import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import './styles.css';
//
import { isArray } from '@mescius/wijmo';
import { Palettes } from '@mescius/wijmo.chart';

import '@angular/compiler';
import { Component, Inject, enableProdMode, ɵresolveComponentResources } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';
import { WjChartModule } from '@mescius/wijmo.angular2.chart';
import * as wjChart from '@mescius/wijmo.chart';
import { WjChartAnalyticsModule } from '@mescius/wijmo.angular2.chart.analytics';
import { WjChartAnimationModule } from '@mescius/wijmo.angular2.chart.animation';
import { DataService } from './app.data';

(wjChart as any).Axis.prototype._addMinMaxLabels = function (t: any, e: any) {
    if (this.labelMin) {
        var i = this.actualMin;
        if (isFinite(i) && t.indexOf(i) == -1) {
            e.splice(0, 0, this._formatValue(i));
            t.splice(0, 0, i);
        }
    }
    if (this.labelMax) {
        var r = this.actualMax;
        if (isFinite(r) && t.indexOf(r) == -1) {
            e.splice(0, 0, this._formatValue(r));
            t.splice(0, 0, r);
        }
    }
};
//
@Component({
    standalone: true,
    providers: [DataService],
    imports: [WjChartModule, WjChartAnalyticsModule, WjChartAnimationModule, BrowserModule],
    selector: 'app-component',
    templateUrl: 'src/app.component.html'
})
export class AppComponent {
    data: any;
    palette: string[];
    //
    constructor(@Inject(DataService) private dataService: DataService) {
        this.data = dataService.getData();
        this.palette = this._getRandomPalette();
    }
    //
    private _getRandomPalette() {
        let palettes = Object.keys(Palettes).filter(prop => isArray(Palettes[prop]));
        let rand = Math.floor(Math.random() * palettes.length);
        //
        return Palettes[palettes[rand]];
    }
}
//


//
enableProdMode();

// Resolve resources (templateUrl, styleUrls etc), After resolution all URLs have been converted into `template` strings.
ɵresolveComponentResources(fetch).then(() => {
    // Bootstrap application 
    bootstrapApplication(AppComponent).catch(err => console.error(err));
});