import React, { useRef, useState } from "react";
import useEvent from "react-use-event-hook";
import * as wjInput from "@mescius/wijmo.react.input";
import * as wjFlexGrid from "@mescius/wijmo.react.grid";
import * as wjGroupPanel from "@mescius/wijmo.react.grid.grouppanel";
import * as wjGridFilter from "@mescius/wijmo.react.grid.filter";
import * as wjcGridImmutable from "@mescius/wijmo.grid.immutable";
import { ImmutabilityProvider } from "@mescius/wijmo.react.grid.immutable";
import "@mescius/wijmo.touch"; // add touch support on mobile devices
// Presentation component with an editable Redux grid
export function GridView(props) {
  const [showStoreData, setShowStoreData] = useState(true);
  const groupPanelRef = useRef(null);
  const refFlex = useRef(null);
  const onCountChanged = useEvent((s) => {
    props.changeCountAction(s.selectedValue);
  });
  const onGridInitialized = useEvent((s) => {
    // Attach group panel
    if (groupPanelRef.current) {
      groupPanelRef.current.control.grid = s;
    }
  });
  // Dispatches data change actions to the Redux Store in response to
  // user edits made via the grid.
  const onGridDataChanged = useEvent((s, e) => {
    switch (e.action) {
      case wjcGridImmutable.DataChangeAction.Add:
        props.addItemAction(e.newItem);
        break;
      case wjcGridImmutable.DataChangeAction.Remove:
        props.removeItemAction(e.newItem, e.itemIndex);
        break;
      case wjcGridImmutable.DataChangeAction.Change:
        props.changeItemAction(e.newItem, e.itemIndex);
        break;
      default:
        throw "Unknown data action";
    }
  });

  const cellEditEnded = (s, e) => {
    console.log("edit ended ");
    let item = s.selectedItems[0];
    console.log(e.getRow().dataItem);
    console.log(item);
  };

  const itemValidator = (row, col, parsing) => {
    if (refFlex.current) {
      const grid = refFlex.current.control;

      let item = grid.rows[row].dataItem,
        prop = grid.columns[col].binding;

      // parsing failed, show message
      if (parsing) {
        if (prop == "date") {
          return 'Please enter a valid date in the format "MM/dd/yyyy"';
        } else if (prop == "id") {
          return "Please enter a positive number";
        }
      }

      // check that stored (parsed) data is valid
      if (prop == "date" && item.date < minDate) {
        return "Please enter a date after " + Globalize.formatDate(minDate, "d");
      } else if (prop == "id" && item.id < 0) {
        return "Please enter a positive number";
      }
    }
  };

  return (
    <main className="container-fluid">
      <div>
        <wjInput.Menu header="Item Count" value={props.itemCount} itemClicked={onCountChanged}>
          <wjInput.MenuItem value={5}>5</wjInput.MenuItem>
          <wjInput.MenuItem value={50}>50</wjInput.MenuItem>
          <wjInput.MenuItem value={100}>100</wjInput.MenuItem>
          <wjInput.MenuItem value={500}>500</wjInput.MenuItem>
          <wjInput.MenuItem value={5000}>5,000</wjInput.MenuItem>
          <wjInput.MenuItem value={10000}>10,000</wjInput.MenuItem>
          <wjInput.MenuItem value={50000}>50,000</wjInput.MenuItem>
          <wjInput.MenuItem value={100000}>100,000</wjInput.MenuItem>
        </wjInput.Menu>
      </div>
      {/* <wjGroupPanel.GroupPanel ref={groupPanelRef} placeholder="Drag columns here to create groups." /> */}
      <div>
        {/* <wjFlexGrid.FlexGrid allowAddNew allowDelete initialized={onGridInitialized}>
          <ImmutabilityProvider itemsSource={props.items} dataChanged={onGridDataChanged} />
          <wjGridFilter.FlexGridFilter />
          <wjFlexGrid.FlexGridColumn binding="id" header="ID" width={80} isReadOnly={true} />
          <wjFlexGrid.FlexGridColumn binding="start" header="Date" format="d" />
          <wjFlexGrid.FlexGridColumn binding="end" header="Time" format="t" />
          <wjFlexGrid.FlexGridColumn binding="country" header="Country" />
          <wjFlexGrid.FlexGridColumn binding="product" header="Product" />
          <wjFlexGrid.FlexGridColumn binding="sales" header="Sales" format="n2" />
          <wjFlexGrid.FlexGridColumn binding="downloads" header="Downloads" format="n0" />
          <wjFlexGrid.FlexGridColumn binding="active" header="Active" width={80} />
        </wjFlexGrid.FlexGrid> */}
      </div>

      <wjFlexGrid.FlexGrid
        ref={refFlex}
        className="wj-flexgrid-list"
        alternatingRowStep={1}
        showMarquee={true}
        allowSorting={false}
        headersVisibility="Column"
        allowResizing="ColumnsAllCells"
        selectionMode="Cell"
        autoGenerateColumns={false}
        isReadOnly={false}
        cellEditEnded={cellEditEnded}
        itemValidator={itemValidator}
        validateEdits={false}
      >
        <ImmutabilityProvider itemsSource={props.items} />
        <wjFlexGrid.FlexGridColumn binding="id" header="ID" width={80} isReadOnly={true} />
        <wjFlexGrid.FlexGridColumn binding="start" header="Date" format="d" />
        <wjFlexGrid.FlexGridColumn binding="end" header="Time" format="t" />
        <wjFlexGrid.FlexGridColumn binding="country" header="Country" />
        <wjFlexGrid.FlexGridColumn binding="product" header="Product" />
        <wjFlexGrid.FlexGridColumn binding="sales" header="Sales" format="n2" />
        <wjFlexGrid.FlexGridColumn binding="downloads" header="Downloads" format="n0" />
        <wjFlexGrid.FlexGridColumn binding="active" header="Active" width={80} />
      </wjFlexGrid.FlexGrid>
    </main>
  );
}
