import "bootstrap.css";
import "@grapecity/wijmo.styles/wijmo.css";
import "./styles.css";
import { FlexGrid, DataMap } from "@grapecity/wijmo.grid";
import { ComboBox, AutoComplete } from "@grapecity/wijmo.input";
import { getData, getCountries, getProducts, getNames } from "./data";
import * as wjGrid from "@grapecity/wijmo.grid";
import * as wjCore from "@grapecity/wijmo";

document.readyState === "complete" ? init() : (window.onload = init);
function init() {
  wjGrid._CustomEditor.prototype._cellEditEnding = function (e, t) {
    if (!t.cancel && t.getColumn(!0) == this._col) {
      var i = this.grid,
        o = this._ctl,
        n = this._prop;
      if (this._isAutoComplete) {
        var r = o.selectedIndex;
        if (wjCore.isNumber(r) && r < 0) {
          var l = o.collectionView;
          l && 1 == l.items.length && this._col.isRequired ? (o.selectedIndex = 0) : this._col.isRequired && (t.cancel = !0);
        }
      }
      !t.cancel && n && i._edtHdl._setCustomEditorValue(o[n]);
    }
  };

  // create a grid with custom editors
  new FlexGrid("#theGrid", {
    showMarquee: true,
    selectionMode: "MultiRange",
    alternatingRowStep: 0,
    autoGenerateColumns: false,
    columns: [
      { header: "ID", binding: "id", width: 80, isReadOnly: true },
      {
        header: "Country",
        binding: "country",
        editor: new ComboBox(document.createElement("div"), {
          itemsSource: getCountries(),
        }),
      },
      {
        header: "Product",
        binding: "productId",
        width: 220,
        isRequired: false,
        dataMap: new DataMap(getProducts(), "id", "name"),
        editor: new AutoComplete(document.createElement("div"), {
          itemsSource: getProducts().slice(0, 1),
          isRequired: false,
          selectedValuePath: "id",
          displayMemberPath: "name",
        }),
      },
    ],
    itemsSource: getData(),
  });
}
