﻿using C1.Chart.Printing;
using C1.Win.Chart;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Printing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static C1.Util.Win.Win32;

namespace AxisXNameInsteadOfNumber
{
    public partial class Form1 : Form
    {
        private DataTable dt;

        public Form1()
        {
            InitializeComponent();
            CreateTable();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            FlexChart1.DataSource = dt;
            FlexChart1.BeginUpdate();
            FlexChart1.ChartType = C1.Chart.ChartType.Column;
            FlexChart1.Series.Clear();
            FlexChart1.Series.Add(new Series { Name = "Stunden", Binding = "Hours_per_cost_center", BindingX = "Hours" });
            FlexChart1.Series.Add(new Series { Name = "Ser2", Binding = "New_Series", BindingX = "Hours" });

            // AxisX
            FlexChart1.AxisX.DataSource = ConvertDataTableToList(dt);
            FlexChart1.AxisX.Binding = "Ob_Hours,Ob_Code";

            FlexChart1.AxisX.Labels = true;
            FlexChart1.AxisX.LabelAngle = -40;

            // Daten für die AxisX Säule
            FlexChart1.DataLabel.Content = "{STStunden}";
            FlexChart1.DataLabel.Position = C1.Chart.LabelPosition.Top;

            // AxisY
            FlexChart1.AxisY.MajorUnit = 50;
            FlexChart1.AxisY.Min = 0;
            FlexChart1.AxisY.Max = 900;

            // Specify titles for FlexChart header and axes
            FlexChart1.Header.Content = "Stunden pro Kostenstellen";
            FlexChart1.EndUpdate();
        }


        public void CreateTable()
        {
            dt = new DataTable();
            dt.Columns.Add("Hours", typeof(int));
            dt.Columns.Add("Hours_per_cost_center", typeof(double));
            dt.Columns.Add("New_Series", typeof(double));
            dt.Columns.Add("TACodeKST", typeof(int));

            Random random = new Random();
            int start = 2001;
            for (int hours = 0; hours <= 30; hours++)
            {
                double hoursPerCostCenter = random.NextDouble() * 900;
                double newData = random.NextDouble() * 450;
                dt.Rows.Add(hours, hoursPerCostCenter, newData, start++);
            }
        }

        public List<MyObject> ConvertDataTableToList(DataTable dataTable)
        {
            List<MyObject> myList = new List<MyObject>();

            foreach (DataRow row in dataTable.Rows)
            {
                MyObject obj = new MyObject();

                // Assuming the column names in the DataTable match the property names in the MyObject class
                obj.Ob_Hours = Convert.ToInt32(row["Hours"]);
                obj.Ob_HPCC = Convert.ToDouble(row["Hours_per_cost_center"]);
                obj.Ob_New = Convert.ToDouble(row["New_Series"]);
                obj.Ob_Code = row["TACodeKST"].ToString(); // string type property need to be bound as custom label to the axis

                myList.Add(obj);
            }

            return myList;
        }

        private void exportBtn_Click(object sender, EventArgs e)
        {
            //create Printer FlexChart
            ChartPrinter chartPrinter = new ChartPrinter(FlexChart1, true);

            PageSettings PageSettngs = new PageSettings() { Landscape = true };

            //replace default page settings with custom page settings
            chartPrinter.PageSettingsProp = PageSettngs;



            //set whether or not to resize FlexChart according to the print rectangle
            ChartPrinter.PrintScale pscale =
                (ChartPrinter.PrintScale)Enum.Parse(typeof(ChartPrinter.PrintScale), "None");

            //set whether to print in GrayScale or not
            chartPrinter.UseGrayScale = false;

            bool usePrintPreview = true;
            bool printAsBitmap = true;

            //chartPrinter.PrintCtrl()
            //print FlexChart with specific printer and page settings
            chartPrinter.PrintCtrl(pscale, new Rectangle(50, 50, 400, 400), PageSettngs, printAsBitmap, usePrintPreview);
        }
    }

    public class MyObject
    {
        public int Ob_Hours { get; set; }

        public double Ob_HPCC { get; set; }

        public double Ob_New { get; set; }

        public string Ob_Code { get; set; }
    }

    public class DataPointAxisX
    {
        public int Value { get; set; }

        public string Code { get; set; }
    }
}
