import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';

import '@angular/compiler';
import { Component, OnDestroy } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';

import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { WjGridTransposedModule, WjTransposedGrid } from '@mescius/wijmo.angular2.grid.transposed';
import { ObservableArray } from '@mescius/wijmo';
import { getData, getDataColumns } from '../data';

// Workaround
// WjTransposedGrid.prototype.ngOnDestroy = function () {};

@Component({
    standalone: true,
    imports: [WjGridModule, WjGridTransposedModule, BrowserModule],
    selector: 'transposedgrid-component',
    templateUrl: 'src/transposedGrid/transposedGrid.component.html',
})
export class TransposedGridComponent implements OnDestroy {
    data = new ObservableArray(getData());
    columns = getDataColumns();
    grid;

    initGrid(grid) {
        this.grid = grid;
    }

    // customize transposed product grid row/column sizes
    loadedRows(s: any) {
        s.columns.defaultSize = 200;
        setTimeout(() => {
            s.autoSizeColumn(0, true, 10); // auto-size row headers
            s.autoSizeRows(); // auto-size data rows
            s.rows[0].height = 180; // make product images large
        });
    }

    // customize cells to show product images and star rating
    formatItem(s: any, e: any) {
        if (e.panel == s.cells) {
            // get binding from row if possible, then from column
            let binding = s.rows[e.row].binding || s.columns[e.col].binding;
            switch (binding) {
                // product image
                case 'img':
                    e.cell.innerHTML = '<img src="{img}" draggable="false"/>'.replace('{img}', e.cell.textContent);
                    break;

                // stars for rating
                case 'rating':
                    let rating = s.getCellData(e.row, e.col, false),
                        html = new Array(Math.floor(rating) + 1).join('&#x2605;');
                    if (rating > Math.floor(rating)) {
                        html += '&#9734;'; // white star (half star doesn't work...)
                    }
                    e.cell.innerHTML = '<span class="rating">' + html + '</span>';
                    break;
            }
        }
    }

    ngOnDestroy(): void {
        // dispose like this if necessary, after applying workaround above
        setTimeout(() => {
            this.grid.dispose();
        }, 500);
    }
}

