﻿import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import './styles.css';
//
import * as wjChart from '@mescius/wijmo.chart';
import * as wjRadar from '@mescius/wijmo.chart.radar';
import * as animation from '@mescius/wijmo.chart.animation';
import '@angular/compiler';
import { Component, Inject, enableProdMode, ViewChild, AfterViewInit, ɵresolveComponentResources } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';
import { WjChartModule } from '@mescius/wijmo.angular2.chart';
import { WjInputModule } from '@mescius/wijmo.angular2.input';
import { WjChartRadarModule } from '@mescius/wijmo.angular2.chart.radar';
import { DataService } from './app.data';
import { WjChartInteractionModule } from '@mescius/wijmo.angular2.chart.interaction';
import { ChartGestures } from '@mescius/wijmo.chart.interaction';

//
@Component({
  standalone: true,
  providers: [DataService],
  imports: [WjChartModule, WjChartRadarModule, BrowserModule, WjChartInteractionModule, WjInputModule],
  selector: 'app-component',
  templateUrl: 'src/app.component.html',
})
export class AppComponent implements AfterViewInit {
  @ViewChild('chart', { static: true }) chart: wjRadar.FlexRadar;
  @ViewChild('chartGestures', { static: true }) gestures: ChartGestures;
  data: any;
  palette: any;
  // DataSvc will be passed by derived classes
  constructor(@Inject(DataService) private dataService: DataService) {
    this.data = dataService.getData();
    this.palette = wjChart.Palettes.cocoa;
  }
  //
  ngAfterViewInit() {

    window['ch'] = this.chart;

    
    let ani = new animation.ChartAnimation(this.chart, {
      animationMode: animation.AnimationMode.Series,
      easing: animation.Easing.Linear,
      duration: 500,
    });
    let app = this;
    setTimeout(function () {
      app.chart.itemsSource = app.data;
    }, 200);
  }
  
  initGestures() {
    setTimeout(() => {
      this.chart.axisY.min = 0;
      this.chart.axisY.max = 1000;
      }, 500)
    }
}
//\\

//
enableProdMode();

// Resolve resources (templateUrl, styleUrls etc), After resolution all URLs have been converted into `template` strings.
ɵresolveComponentResources(fetch).then(() => {
  // Bootstrap application
  bootstrapApplication(AppComponent).catch((err) => console.error(err));
});
