import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import './styles.css';

import '@angular/compiler';
import { Component, enableProdMode, ɵresolveComponentResources } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';

import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { WjGridTransposedModule } from '@mescius/wijmo.angular2.grid.transposed';
import { CollectionView, SortDescription } from '@mescius/wijmo';
import { ObservableArray } from '@mescius/wijmo';
import { getData, getDataColumns } from './data';
import { GridComponent } from './grid/grid.component';
import { TransposedGridComponent } from './transposedGrid/transposedGrid.component';

@Component({
  standalone: true,
  imports: [WjGridModule, WjGridTransposedModule, BrowserModule, TransposedGridComponent, GridComponent],
  selector: 'app-component',
  templateUrl: 'src/app.component.html',
})
export class AppComponent {
  showTransposedGrid = true; 
  data = (getData());
  sortDescriptions = [];
  // data2 = new CollectionView(getData());

  constructor() {
    var sd = new SortDescription('name', true);
    // this.data.sortDescriptions.push(sd);
  }

  updateSortDesc(newDesc){
    console.log('got', newDesc)
    this.sortDescriptions = newDesc;
  }
  
  toggleGrid() {
    this.showTransposedGrid = !this.showTransposedGrid;
  }
}

enableProdMode();

// Resolve resources (templateUrl, styleUrls etc), After resolution all URLs have been converted into `template` strings.
ɵresolveComponentResources(fetch).then(() => {
  // Bootstrap application
  bootstrapApplication(AppComponent).catch((err) => console.error(err));
});
