import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';

import '@angular/compiler';
import { Component, EventEmitter, Input, Output, output } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';

import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { WjGridTransposedModule } from '@mescius/wijmo.angular2.grid.transposed';
import { ObservableArray, SortDescription } from '@mescius/wijmo';
import { FlexGridFilter } from '@mescius/wijmo.grid.filter';
import { getData, getDataColumns } from '../data';

@Component({
    standalone: true,
    imports: [WjGridModule, WjGridTransposedModule, BrowserModule],
    selector: 'grid-component',
    templateUrl: 'src/grid/grid.component.html',
})
export class GridComponent {
    @Input() data;
    columns = getDataColumns();
    grid;
    @Input() sortDescriptions = [];
    @Output() sortDescriptionsChange = new EventEmitter();

    initGrid(grid) {
        this.grid = grid;
        new FlexGridFilter(grid);

        if (this.sortDescriptions) {
            let sds = this.sortDescriptions;
            sds.forEach(desc => {
                var sd = new SortDescription(desc.prop, desc.asc);
                grid.collectionView.sortDescriptions.push(sd);
            })
        }

        this.sortDescriptionsChange.emit(this.sortDescriptions);
        grid.collectionView.sortDescriptions.collectionChanged.addHandler((s, e) => {
            this.sortDescriptions = [];
            s.forEach(desc => {
                this.sortDescriptions.push({ asc: desc.ascending, prop: desc.property })
            })

            this.sortDescriptionsChange.emit(this.sortDescriptions);
        })
    }

    // customize transposed product grid row/column sizes
    loadedRows(s: any) {
        s.columns.defaultSize = 200;
        setTimeout(() => {
            s.autoSizeColumn(0, true, 10); // auto-size row headers
            s.autoSizeRows(); // auto-size data rows
            s.rows[0].height = 180; // make product images large
        });
    }

    // customize cells to show product images and star rating
    formatItem(s: any, e: any) {
        if (e.panel == s.cells) {
            // get binding from row if possible, then from column
            let binding = s.rows[e.row].binding || s.columns[e.col].binding;
            switch (binding) {
                // product image
                case 'img':
                    e.cell.innerHTML = '<img src="{img}" draggable="false"/>'.replace('{img}', e.cell.textContent);
                    break;

                // stars for rating
                case 'rating':
                    let rating = s.getCellData(e.row, e.col, false),
                        html = new Array(Math.floor(rating) + 1).join('&#x2605;');
                    if (rating > Math.floor(rating)) {
                        html += '&#9734;'; // white star (half star doesn't work...)
                    }
                    e.cell.innerHTML = '<span class="rating">' + html + '</span>';
                    break;
            }
        }
    }
}

