import path from 'path';
import {
  fileURLToPath
} from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

export default {
  entry: './src/client.js',
  output: {
    path: path.resolve(__dirname, '../server/public'),
    filename: 'client.bundle.js',
  },
  mode: 'production',
  module: {
    rules: [
      {
        test: /\.css$/i,
        use: ['style-loader', 'css-loader'
        ],
      },
    ],
  },
};
