import sqlite3 from 'sqlite3';

const db = new sqlite3.Database('./docs.db');

async function initSqliteDataTables(db) {
    const run = (sql) => {
        return new Promise((resolve, reject) => {
            db.run(sql, (e) => (e ? reject(e) : resolve()));
        });
    };

    try {
        await run(
            `CREATE TABLE IF NOT EXISTS documents (
                id TEXT PRIMARY KEY,
                type TEXT NOT NULL,
                version INTEGER NOT NULL DEFAULT 0,
                snapshot_version INTEGER NOT NULL DEFAULT 0,
                snapshot TEXT
            )`
        );

        await run(
            `CREATE TABLE IF NOT EXISTS operations (
                doc_id TEXT NOT NULL,
                version INTEGER NOT NULL,
                operation TEXT NOT NULL,
                PRIMARY KEY (doc_id, version),
                FOREIGN KEY (doc_id) REFERENCES documents (id) ON DELETE CASCADE
            )`
        );

        await run(
            `CREATE TABLE IF NOT EXISTS snapshot_fragments (
                doc_id TEXT NOT NULL,
                fragment_id TEXT NOT NULL,
                data TEXT NOT NULL,
                PRIMARY KEY (doc_id, fragment_id),
                FOREIGN KEY (doc_id) REFERENCES documents (id) ON DELETE CASCADE
            )`
        );

        console.log('Database tables created successfully');
        console.log('Tables: documents, operations, snapshot_fragments');

    } catch (error) {
        console.error('Database initialization failed:', error);
        process.exit(1);
    } finally {
        db.close();
    }
}

initSqliteDataTables(db);
