import http from 'http';
import express from 'express';
import sqlite3 from 'sqlite3';
import { Server } from '@mescius/js-collaboration';
import * as OT from '@mescius/js-collaboration-ot';
import { presenceFeature } from '@mescius/js-collaboration-presence';
import { type } from '@mescius/spread-sheets-collaboration';
import { SqliteDb } from '@mescius/js-collaboration-ot-sqlite';

OT.TypesManager.register(type);

const app = express();
const httpServer = http.createServer(app);
const server = new Server({ httpServer });

const db = new sqlite3.Database('./docs.db');
const sqliteDbAdapter = new SqliteDb(db);
const documentServices = new OT.DocumentServices({ db: sqliteDbAdapter });

server.useFeature(OT.documentFeature(documentServices));
server.useFeature(presenceFeature());

app.use(express.static('public'));

app.use((req, res, next) => {
    res.header('Access-Control-Allow-Origin', '*');
    res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS');
    res.header('Access-Control-Allow-Headers', 'Content-Type');
    next();
});

const PORT = 8080;

httpServer.listen(PORT, () => {
    console.log('SpreadJS Collaboration Server Started');
    console.log('Server: http://localhost:' + PORT);
    console.log('WebSocket: ws://localhost:' + PORT);
    console.log('Client: http://localhost:' + PORT + '/index.html');
    console.log('Features: OT, Presence, SQLite');
});
