using FarPoint.Win.Chart;
using FarPoint.Win.Spread;
using GrapeCity.Spreadsheet.Drawing;
using System.Drawing.Printing;

namespace WinFormsApp
{
    public partial class Form1 : Form
    {
        private int _printPageCount = 0;
        private int _printingPage = 0;

        private readonly PrintDocument _printDocument = new()
        {
            PrintController = new StandardPrintController(),
            PrinterSettings = new()
            {
                // Please change to the appropriate printer name.
                PrinterName = "Microsoft Print to PDF",
            },
        };

        public Form1()
        {
            InitializeComponent();
            ribbonBar1.Attach(fpSpread1);
            fpSpread1.SpreadScaleMode = ScaleMode.ZoomDpiSupport;
            fpSpread1.Features.EnhancedShapeEngine = true;
            fpSpread1.Features.ExcelCompatiblePrinting = true;

            var worksheet = fpSpread1.ActiveSheet.AsWorksheet();
            worksheet.DisplayPageBreaks = true;
            worksheet.Rows.RowHeight = 24;
            worksheet.Cells[0, 0, 40, 0].Formula = "ROW()";
            worksheet.PageSetup.PaperSize = GrapeCity.Spreadsheet.Printing.PaperSize.PaperA4;
            worksheet.PageSetup.Orientation = GrapeCity.Spreadsheet.Printing.PageOrientation.Portrait;
            

            fpSpread1.ActiveSheet.PrintInfo.Margin.Left = 50;
            fpSpread1.ActiveSheet.PrintInfo.Margin.Top = 50;
            fpSpread1.ActiveSheet.PrintInfo.Margin.Right = 50;
            fpSpread1.ActiveSheet.PrintInfo.Margin.Bottom = 50;
            fpSpread1.ActiveSheet.PrintInfo.ZoomFactor = 0.63f;
            fpSpread1.ActiveSheet.PrintInfo.Preview = true;


            _printDocument.PrintPage += OnPrintPage;
        }

        private void OnPrintPage(object sender, PrintPageEventArgs e)
        {
            fpSpread1.OwnerPrintDraw(e.Graphics, e.MarginBounds, 0, ++_printingPage);
            e.HasMorePages = _printingPage < _printPageCount;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            _printingPage = 0;
            _printPageCount = fpSpread1.GetPrintPageCount(0);
            _printDocument.DefaultPageSettings.Margins = new(0, 0, 0, 0);
            _printDocument.DocumentName = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory), "test.pdf");
            using (var previewDialog = new PrintPreviewDialog())
            {
                previewDialog.Document = _printDocument;
                previewDialog.Width = 1200;
                previewDialog.Height = 800;

                previewDialog.ShowDialog();
            }
        }
    }
}