import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import ReactDOM from 'react-dom/client';
import React from 'react';
import useEvent from 'react-use-event-hook';
import * as wjcGrid from '@mescius/wijmo.react.grid';
import * as wjGrid from '@mescius/wijmo.grid';
import './app.css';
function App() {
    const onInitialized = useEvent((grid) => {
        // create extra header row
        var extraRow = new wjGrid.Row();
        extraRow.allowMerging = true;
        //
        // add extra header row to the grid
        var panel = grid.columnHeaders;
        panel.rows.splice(0, 0, extraRow);
        //
        // populate the extra header row
        for (let colIndex = 1; colIndex <= 30; colIndex++) {
            panel.setCellData(0, colIndex, 'Amounts');
        }
        //
        // merge "Country" and "Active" headers vertically
        ['country', 'active'].forEach(function (binding) {
            let col = grid.getColumn(binding);
            col.allowMerging = true;
            panel.setCellData(0, col.index, col.header);
        });
        //
        // center-align merged header cells
        grid.formatItem.addHandler(function (s, e) {
            if (e.panel == s.columnHeaders && e.range.rowSpan > 1) {
                var html = e.cell.innerHTML;
                e.cell.innerHTML = '<div class="v-center">' + html + '</div>';
            }
        });
        grid.autoGenerateColumns = false;
        grid.itemsSource = getData();
    });
    const getData = () => {
        var countries = 'US,Germany,UK,Japan'.split(',');
        var data = [];
        for (var i = 0; i < 20; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                active: i % 5 != 0,
                downloads: Math.round(Math.random() * 200000),
                sales: Math.random() * 100000,
                expenses: Math.random() * 50000
            });
        }
        return data;
    };
    return (<main className="container-fluid">
      <wjcGrid.FlexGrid allowMerging="ColumnHeaders" alternatingRowStep={0} initialized={onInitialized}>
        <wjcGrid.FlexGridColumn binding="country" header="Country" allowMerging={true}/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="sales" header="Sales" format="n2"/>
        <wjcGrid.FlexGridColumn binding="expenses" header="Expenses" format="n2"/>
        <wjcGrid.FlexGridColumn binding="active" header="Active" allowMerging={true}/>
      </wjcGrid.FlexGrid>
    </main>);
}
const container = document.getElementById('app');
if (container) {
    const root = ReactDOM.createRoot(container);
    root.render(<App />);
}
