﻿using C1.Maui.Core;
using C1.Maui.Grid;
using System.ComponentModel.DataAnnotations.Schema;

namespace AddDeleteConfirmation
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            flexGrid.ItemsSource = Customer.GetCustomerList(8);
            flexGrid.CellFactory = new MyCellFactory();

            flexGrid.RowEditEnding += FlexGrid_RowEditEnding;
        }

        private void FlexGrid_RowEditEnding(object? sender, GridCellEditEventArgs e)
        {
            //check if the event is fired for new row,
            //and the user has not pressed the Escape key to cancel the edit
            if (flexGrid.Rows[e.CellRange.Row] is GridNewRow newRow && !e.CancelEdits)
            {
                /*here, you can check for data validity of the new row*/
                //for example, we check if first name column has a value
                var firstNameData = flexGrid[newRow.Index, flexGrid.Columns["FirstName"].Index];
                var dataValid = !string.IsNullOrEmpty(firstNameData?.ToString());

                //if data is invalid
                if (!dataValid)
                {
                    //show an alert
                    DisplayAlert("Data Invalid", "Either enter a value for the FirstName or press Esc key to cancel add row", "Ok");

                    //and set the selection back to new row
                    flexGrid.SetCursor(newRow.Index, 0);
                    flexGrid.Select(newRow.Index, 0);
                }

                //cancel the edit according to data validity
                e.Cancel = !dataValid;
            }
        }
    }

    class MyCellFactory : GridCellFactory
    {
        protected override bool OnKeyDown(KeyEventArgs e)
        {
            //if delete key is pressed
            if (e.Key == C1KeyboardHelper.Delete)
            {
                //handle the delete operation manually
                HandleDeleteRow();

                //cancel default delete operation by returning true
                return true;
            }

            return base.OnKeyDown(e);
        }

        private async void HandleDeleteRow()
        {
            if (Grid.CursorRange is not null && Grid.Rows[Grid.CursorRange.Row] is not GridNewRow)
            {
                //show alert and get confirmation from user
                var confirmed = await Application.Current?.MainPage?.DisplayAlert("Confirm Delete", "Do you want to delete this row?", "Yes", "No");
                if (confirmed)
                {
                    //save the current row and column
                    var row = Grid.CursorRange.Row;
                    var col = Grid.CursorRange.Column;

                    //delete the row
                    Grid.Rows.RemoveAt(row);

                    //select the current row and column back to select the next row
                    Grid.Select(row, col);
                    Grid.SetCursor(row, col);
                }
            }
        }
    }
}
