﻿window.onload = function () {
    const viewer = new DsImageViewer("#root", {
        undo: { skipCommands: ["Open", "Zoom"] }
    });

    const paintToolsPlugin = new PaintToolsPlugin({
        toolbarLayout: {
            paintTools: false,
            effectsTools: false
        }
    });

    viewer.addPlugin(paintToolsPlugin);

    viewer.open("./yachts.jpg").then(() => {
        viewer.toggleSidebar(true);
    });

    // Hide object properties panel when objects are drawn
    viewer.tempOnPanelChange.register((panelKey) => {
        if (panelKey && paintToolsPlugin._propertiesPanelHandle &&
            panelKey === paintToolsPlugin._propertiesPanelHandle.id) {
            paintToolsPlugin.closeObjectProperties();
        }
    });
};
