﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using GrapeCity.Documents.Excel;
using SpreadExcelExport.Models;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Drawing;

namespace SpreadExcelExport.Controllers
{
    public class MyAddFunctionX : CustomFunction
    {
        public MyAddFunctionX()
            : base("MyAdd", FunctionValueType.Number, new Parameter[] { new Parameter(FunctionValueType.Number), new Parameter(FunctionValueType.Number) })
        {

        }

        public override object Evaluate(object[] arguments, ICalcContext context)
        {
            return (double)arguments[0] + (double)arguments[1];
        }
    }

    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }
        /// <summary>
        /// Return JSON string to load in SpreadSheet 
        /// </summary>
        /// <param name="file">File to process using GCExcel</param>
        /// <returns>SpreadJSON to load in Spread</returns>
        [HttpGet]
        public string GetSpreadJson(string file)
        {
            try
            {
                var workbook = new Workbook();
                var _filePath = new string[] { "BlankXlsx" };
                if (file != null)
                {
                    _filePath = file.Split('.');
                    if (_filePath[_filePath.Length - 1].ToLower() == "json" || _filePath[_filePath.Length - 1].ToLower() == "ssjson")
                    {
                        Common.LoadJsonToWb(workbook, Server.MapPath("~/Files/" + file));
                    }
                    else
                    {
                        workbook.Open(Server.MapPath("~/Files/" + file));
                    }
                }
                

                
                workbook.Open(Server.MapPath("~/Files/" + file));
                Common.SaveFileToDrive(Server.MapPath("~/Files/" + "test.ssjson"), workbook.ToJson());
                
                return workbook.ToJson();
                
            }
            catch (Exception e)
            {
                return (e.Message);
            }
        }
        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }
        [HttpGet]
        public async Task<ActionResult> SaveAsExcel()
        {
            var wb = new Workbook();
            wb.ActiveSheet.Range[0, 0].Value = "Hello";
            var workbook=  Common.UpdateContent(wb);
            workbook = Common.CalculateWorkbook(workbook);
            var time = DateTime.Now.ToString();
            var fileName = time.Replace("/", "").Replace(":", "");
            workbook.Save(Server.MapPath("~/Files/GC-" + fileName + ".xlsx"));
            return Content("Saved as Excel");
        }
        public ActionResult GenerateExcel(string spreadJson)
        {
            try
            {
                var workbook = new Workbook();
                //workbook.Open(Server.MapPath("~/Files/"+file));
                //this.LoadJsonToWb(workbook, Server.MapPath("~/Files/" + file));
                workbook.FromJson(spreadJson);
                workbook.Save(Server.MapPath("~/Files/CustomIconGCXL.xlsx"), SaveFileFormat.Xlsx);
                //String jsonString = workbook.ToJson();
                return Content("CustomIconGCXL.xlsx");
            }
            catch (Exception e)
            {
                return Content(e.Message);
            }
        }
    }
}