﻿using GrapeCity.Documents.Excel;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace SpreadExcelExport.Models
{
	public class Common
	{
        /// <summary>
        /// Load the JSON file to GCExcel Workbook 
        /// </summary>
        /// <param name="wb">GCExcel workbook instance</param>
        /// <param name="filePath">File path of the SpreadJSON</param>
        public static void LoadJsonToWb(Workbook wb, string filePath)
        {
            //try
            //{
                string text = System.IO.File.ReadAllText(filePath);
                wb.FromJson(text);
            //}
            //catch (Exception e)
            //{
                
            //}
        }
        /// <summary>
        /// Save the Files to Specified location
        /// </summary>
        /// <param name="Path">Location to save the file</param>
        /// <param name="Content">Content to be saved in file</param>
        public static void SaveFileToDrive(string Path, string Content)
        {
            System.IO.File.WriteAllText(Path, Content);
        }
		/// <summary>
        /// Add Dummy Data to Sheets and Add a sheet with Formulas
        /// </summary>
        /// <param name="wb">Workbook instance</param>
        /// <returns>GCExcel workbook</returns>
        public static IWorkbook UpdateContent(IWorkbook wb)
        {
            var activeSheet = wb.Worksheets["Sheet1"];
            wb = Common.AddSheet(wb,"Formulas");
            Random _rnd = new Random();
            for (int i = 1; i < 15; i++)
            {
                activeSheet.Range[i, 0].Value = _rnd.Next(10, 100);
                activeSheet.Range[i, 1].Value = _rnd.Next(10, 100);
                activeSheet.Range[i, 2].Value = _rnd.Next(10, 100);
                activeSheet.Range[i, 3].Value = _rnd.Next(10, 100);
            }
            wb.Worksheets["Formulas"].Activate();
            wb.ActiveSheet.Range[0, 0].Value = "Sum Col A";
            wb.ActiveSheet.Range[0, 1].Value = "Sum Col B";
            wb.ActiveSheet.Range[0, 2].Value = "Sum Col C";
            wb.ActiveSheet.Range[0, 3].Value = "Sum Col D";
            wb.ActiveSheet.Range[1, 0].Formula = "Sum(Sheet1!A2:A14)";
            wb.ActiveSheet.Range[1, 1].Formula = "Sum(Sheet1!B2:B14)";
            wb.ActiveSheet.Range[1, 2].Formula = "Sum(Sheet1!C2:C14)";
            wb.ActiveSheet.Range[1, 3].Formula = "Sum(Sheet1!D2:D14)";
            return wb;
        }
		/// <summary>
        /// Apply Calculation on existing GCExcel file
        /// </summary>
        /// <param name="wb">GCExcel workbook instance</param>
        /// <returns>GCExcel Workbook</returns>
        public static IWorkbook CalculateWorkbook(IWorkbook wb)
        {
            wb.EnableCalculation = true;
            wb.Dirty();
            wb.Calculate();
            return wb;
        }
		/// <summary>
        /// Add Sheet to GCExcel Workbook
        /// </summary>
        /// <param name="wb">GCExcel Workbook Instance</param>
        /// <param name="sheetName">SheetName for newly added Sheet</param>
        /// <returns>GCExcel workbook</returns>
        public static IWorkbook AddSheet(IWorkbook wb,string sheetName)
        {
            IWorksheet sheet = wb.Worksheets.Add();
            sheet.Name = sheetName;
            return wb;
        }
    }
}