var spreadNS = GC.Spread.Sheets;

function CustomTimeFormatter() { }

CustomTimeFormatter.prototype = new GC.Spread.Formatter.FormatterBase();

// Convert seconds → HH:MM:SS
CustomTimeFormatter.prototype.format = function (obj, formattedData) {
	let seconds = Number(obj);
	if (isNaN(seconds) || seconds < 0) {
		return obj != null ? obj.toString() : "";
	}

	let hrs = Math.floor(seconds / 3600);
	let mins = Math.floor((seconds % 3600) / 60);
	let secs = Math.floor(seconds % 60);

	if (formattedData) {
		formattedData.conditionalForeColor = "blue";
	}

	return (
		hrs.toString().padStart(2, "0") +
		":" +
		mins.toString().padStart(2, "0") +
		":" +
		secs.toString().padStart(2, "0")
	);
};

// Convert HH:MM:SS → seconds (optional)
CustomTimeFormatter.prototype.parse = function (str) {
	return new GC.Spread.Formatter.GeneralFormatter().parse(str);
};

window.onload = function () {
	// host the workbook control in a DIV element with id "ss"
	var spread = new GC.Spread.Sheets.Workbook(document.getElementById('ss'), {
		sheetCount: 1
	});

	/*
	* retrieve the spread workbook object from the host element using findControl static method.
	* var spread = GC.Spread.Sheets.findControl(document.getElementById('ss'));
	*/

	initSpread(spread);
};

function initSpread(spread) {

	var sheet = spread.getSheet(0);
	sheet.name("Time Formatter (DataSource)");

	spread.suspendPaint();

	// ✅ Sample database-style data
	var data = [
		{ id: 1, task: "Process A", timeInSeconds: 3661 },
		{ id: 2, task: "Process B", timeInSeconds: 145 },
		{ id: 3, task: "Process C", timeInSeconds: 86399 },
		{ id: 4, task: "Process D", timeInSeconds: 59 },
		{ id: 5, task: "Process E", timeInSeconds: 7325 },
	];

	// ✅ Bind the data source
	sheet.setDataSource(data);

	// ✅ Create binding path columns (similar to table headers)
	sheet.autoGenerateColumns = false;
	sheet.bindColumns([
		{ name: "id", displayName: "ID" },
		{ name: "task", displayName: "Task" },
		{
			name: "timeInSeconds",
			displayName: "Duration (HH:MM:SS)",
			formatter: new CustomTimeFormatter(),
		},
	]);

	sheet.setColumnWidth(0, 60);
	sheet.setColumnWidth(1, 150);
	sheet.setColumnWidth(2, 160);

	spread.resumePaint();
}
