﻿using C1.Win.C1InputPanel;
using System.Data;
using System.Windows.Forms;

namespace InputPanelBinding
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //BindingSource containing sample data
            BindingSource bs = new BindingSource(GetDataTable(), string.Empty);

            //Set the Binding for the InputPanel components
            SetInputComponentBinding(inputTextBox1, bs, "Id");
            SetInputComponentBinding(inputTextBox2, bs, "Name");
            SetInputComponentBinding(inputTextBox3, bs, "Department");
            SetInputComponentBinding(inputTextBox4, bs, "Sex");
            SetInputComponentBinding(inputTextBox5, bs, "Salary");
            SetInputComponentBinding(inputDataNavigator1, bs, string.Empty);
        }

        private void SetInputComponentBinding(InputComponent inputTextBox, object dataSource, string dataField)
        {
            //Set DataSource and DataField properties for the InputPanel components
            inputTextBox.DataSource = dataSource;
            inputTextBox.DataField = dataField;
        }

        /// <summary>
        /// Sample data
        /// </summary>
        private DataTable GetDataTable()
        {
            DataTable dt = new DataTable("Employees");
            dt.Columns.Add("Id", typeof(int));
            dt.Columns.Add("Name", typeof(string));
            dt.Columns.Add("Department", typeof(string));
            dt.Columns.Add("Sex", typeof(string));
            dt.Columns.Add("Salary", typeof(decimal));

            dt.Rows.Add(1, "Peter", "Mgmt", "M", 5000);
            dt.Rows.Add(2, "George", "ACC", "M", 4000);
            dt.Rows.Add(3, "Frank", "IT", "M", 4500);
            dt.Rows.Add(4, "Linda", "IT", "F", 4000);
            dt.Rows.Add(5, "Fink", "ACC", "M", 3000);
            dt.Rows.Add(6, "Lucy", "ACC", "F", 5000);

            return dt;
        }
    }
}
