﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="WebApplication1.Default" %>
<%@ Register Assembly="C1.Web.Wijmo.Controls.48" Namespace="C1.Web.Wijmo.Controls.C1GridView" TagPrefix="wijmo" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>C1GridView 2025v2 Grouping Test</title>
    <style>
        /*text-alignment*/
        #C1GridView1 .align-left {
            text-align: left;
        }
        /*group-headers*/
        #C1GridView1 .wijmo-wijgrid-groupheaderrow {
            background-color: gray !important; /* Gray */
            background-image: none !important;
            color: white !important;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="grid-container">
            <h2>ComponentOne GridView 2025v2 Migration</h2>
            
            <wijmo:C1GridView ID="C1GridView1" runat="server"
                AutoGenerateColumns="False"
                AllowColSizing="True"
                ShowFooter="True"
                GroupAreaVisible="True"
                Width="800px">

                <Columns>
                    <%-- Grouping Column --%>
                    <wijmo:C1BoundField DataField="Department" HeaderText="Department" Width="150px">
                        <ItemStyle CssClass="align-left" />
                    </wijmo:C1BoundField>

                    <%-- Data Columns with Aggregates --%>
                    <wijmo:C1BoundField DataField="Number of requests" HeaderText="Requests"
                        Width="130px" Aggregate="Sum" FooterText="Total: {0}">
                        <ItemStyle HorizontalAlign="Left" CssClass="align-left"/>
                        <FooterStyle CssClass="align-left"/>
                    </wijmo:C1BoundField>

                    <wijmo:C1BoundField DataField="Counted to the end" HeaderText="Completions"
                        Width="130px" Aggregate="Sum" FooterText="Total: {0}">
                        <ItemStyle HorizontalAlign="Left" CssClass="align-left"/>
                        <FooterStyle CssClass="align-left"/>
                    </wijmo:C1BoundField>

                    <%-- Template Field for Percentage --%>
                    <wijmo:C1TemplateField HeaderText="Success Rate (%)" Width="250px">
                        <ItemStyle HorizontalAlign="Left" CssClass="align-left"/>
                        <ItemTemplate>
                            <%# String.Format("{0:F2}%", Eval("Completion rate")) %>
                        </ItemTemplate>
                        <FooterTemplate>
                            <div style="font-weight: bold;" class="align-left">
                                <asp:Label ID="lblPercentageFooter" runat="server" Text="0.00%"></asp:Label>
                            </div>
                        </FooterTemplate>
                    </wijmo:C1TemplateField>
                </Columns>
            </wijmo:C1GridView>
        </div>
    </form>
</body>
</html>