import React from 'react';
import { editCell } from './reducers';
import useEvent from 'react-use-event-hook';
import * as wjInput from '@mescius/wijmo.react.input';
import * as wjcGrid from '@mescius/wijmo.react.grid';
import { CollectionView } from '@mescius/wijmo';
import * as wjGroupPanel from '@mescius/wijmo.react.grid.grouppanel';
import * as wjGridFilter from '@mescius/wijmo.react.grid.filter';
import * as wjcGridImmutable from '@mescius/wijmo.grid.immutable';
import { ImmutabilityProvider } from '@mescius/wijmo.react.grid.immutable';
import { useSelector, useDispatch } from 'react-redux';
import '@mescius/wijmo.touch';

export function GridView() {
  const dispatch = useDispatch();
  const viewComponent = useSelector(state => state.viewComponents[0]);
  const onGridDataChanged = useEvent((s, e) => {
    switch (e.action) {
      case wjcGridImmutable.DataChangeAction.Change: {
        dispatch(editCell({ newItem: e.newItem || {}, oldItem: e.oldItem, row: e.itemIndex, id: viewComponent.id }));
        break;
      }
      default:
        throw 'Unknown data action';
    }
  })
  const columnsProps = [];
  Object.keys(viewComponent.table.data.dataSource[0]).forEach((value) => {
    columnsProps.push({
      dataType: "String"
    })
  })

  return (
    <div className="container-fluid">
      <wjcGrid.FlexGrid
        allowMerging="AllHeaders"
      >
        <ImmutabilityProvider itemsSource={viewComponent.table.data.dataSource} dataChanged={onGridDataChanged} />
        {viewComponent.table.data.dataSource.length > 0 &&
          Object.keys(viewComponent.table.data.dataSource[0])
            .filter(key => key.startsWith('col_'))
            .map((col, index) => {
              const colProps = columnsProps[index];
              const dataType = colProps.dataType;
              return (
                <wjcGrid.FlexGridColumn
                  key={index}
                  binding={`${col}.value`}
                  header={''}
                  allowMerging={true}
                  dataType={dataType}
                />
              );
            })}
      </wjcGrid.FlexGrid>
    </div>)
}
