const countries = ['US', 'Germany', 'UK', 'Japan', 'Italy', 'Greece'];
const products = ['Widget', 'Gadget', 'Doohickey'];
export function getData(count = 5) {
    const data = [];
    const dt = new Date();
    for (let i = 0; i < count; i++) {
        // constants used to create data items
        let date = new Date(dt.getFullYear(), i % 12, 25, i % 24, i % 60, i % 60), countryId = Math.floor(Math.random() * countries.length), productId = Math.floor(Math.random() * products.length);
        // create the item
        let item = {
            col_id: { value: i },
            col_start: { value: date },
            col_end: { value: date },
            col_country: { value: countries[countryId] },
            col_product: { value: products[productId] },
            col_sales: { value: Math.random() * 10000 },
            col_downloads: { value: Math.round(Math.random() * 10000) },
            col_active: { value: i % 4 === 0 }
        }
        Object.freeze(item);
        data.push(item);
    }
    // return the data
    return data;
}
