import { getData } from './data';
import { copyObject } from '@mescius/wijmo.grid.immutable';

const initialState = {
    viewComponents: [{
        id: 1,
        table: {
            data: {
                dataSource: getData(50)
            }
        }
    }]
};

const EDIT_CELL = 'editCell';

// Action creator for editing a cell
export const editCell = ({ newItem, oldItem, row, id }) => ({
    type: EDIT_CELL,
    payload: { newItem, oldItem, row, id },
});

export const appReducer = (state = initialState, action) => {
    switch (action.type) {
        case EDIT_CELL: {
            const { newItem, row, id } = action.payload;

            const viewComponent = state.viewComponents.find(vc => vc.id === id);
            if (viewComponent) {
                // && isTableViewComponent(viewComponent)) {
                const items = viewComponent.table.data.dataSource;
                const index = row;
                const oldItem = items[index];

                const clonedItem = Object.freeze(copyObject({}, oldItem, newItem));

                const newDataSource = [
                    ...items.slice(0, index),
                    clonedItem,
                    ...items.slice(index + 1),
                ];

                const updatedViewComponent =
                    copyObject({}, viewComponent, {
                        table: copyObject({}, viewComponent.table, {
                            data: copyObject({}, viewComponent.table.data, {
                                dataSource: copyObject([], newDataSource)
                            })
                        })
                    });

                return {
                    ...state,
                    viewComponents: state.viewComponents.map(vc =>
                        vc.id === id ? updatedViewComponent : vc
                    )
                };
            }

            return state;
        }
        default:
            return state;
    }
};
