import { Component, ViewChild } from '@angular/core';
import { RouterOutlet } from '@angular/router';
import * as wjcCore from '@mescius/wijmo';
import * as wjcGrid from '@mescius/wijmo.grid';
import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { WjInputModule } from '@mescius/wijmo.angular2.input';

@Component({
  selector: 'app-root',
  standalone: true,
  imports: [RouterOutlet, WjGridModule, WjInputModule],
  templateUrl: './app.component.html',
  styleUrl: './app.component.css'
})
export class AppComponent {
  title = 'angular18_flexgrid_app';
  data: any[];
  selectedItem?: string;
  strings: any[];

  // references FlexGrid named 'flex' in the view
  @ViewChild('flex', { static: true }) flex?: wjcGrid.FlexGrid;

  constructor() {
    this.data = this._getData();
    this.strings = this.getCountries();
  }

  flexInitialized(flexgrid: any) {
    flexgrid.collectionView.currentChanged.addHandler(this._updateCurrentInfo.bind(this));
    this._updateCurrentInfo();
  }

  getCountries() {
    return ['China', 'Germany', 'Greece', 'Italy', 'Japan', 'Portugal', 'Russia', 'Spain', 'UK', 'US'];
  }

  private _getData() {
    // create some random data
    let countries = 'US,Germany,UK,Japan,Italy,Greece'.split(','),
      data = [];
    for (let i = 0; i < countries.length; i++) {
      data.push({
        id: i,
        country: countries[i],
        sales: Math.random() * 10000,
        expenses: Math.random() * 5000
      });
    }

    return data;
  }

  private _updateCurrentInfo() {
    this.selectedItem = wjcCore.format(
      'Country: <b>{country}</b>, Sales: <b>{sales:c0}</b> Expenses: <b>{expenses:c0}</b>',
      this.flex?.collectionView.currentItem);
  }
}
