import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import './styles.css';
//
import * as wjGrid from '@mescius/wijmo.grid';

import '@angular/compiler';
import { Component, Inject, enableProdMode, input, ɵresolveComponentResources } from '@angular/core';

import { BrowserModule, bootstrapApplication } from '@angular/platform-browser';
import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { DataService } from './app.data';

//
@Component({
  standalone: true,
  providers: [DataService],
  imports: [WjGridModule, BrowserModule],
  selector: 'app-component',
  templateUrl: 'src/app.component.html',
})
export class AppComponent {
  workers: any;
  // DataSvc will be passed by derived classes
  constructor(@Inject(DataService) private dataService: DataService) {
    this.workers = dataService.getWorkers();
  }

  initGrid(grid: wjGrid.FlexGrid) {
    // handle formatItem event to insert custom input elements in cells
    grid.formatItem.addHandler((s, e) => {
      if (e.panel == s.cells) {
        // get column and row details
        let col = e.getColumn();
        let row = e.getRow() as wjGrid.GroupRow;

        // insert custom input element only in Custom Content column, and in child rows only
        if (col.binding == 'someBinding' && !row.hasChildren) {
          // you can create any element you want and handle any events on them if needed
          let inputElement = document.createElement('input');
          inputElement.type = 'text';
          inputElement.value = 'some value';

          // you can also set direct html content
          const html1 = '<input type="text" value="abc"/> <input type="text" />';
          let item = row.dataItem;

          // insert input element in cells
          if (item.type == 1) {
            e.cell.innerHTML = html1;
          } else {
            e.cell.innerHTML = '';
            e.cell.appendChild(inputElement);
          }
        }
      }
    });
  }
  //
  onLoadedRows(flexGird: wjGrid.FlexGrid, e: wjGrid.FormatItemEventArgs) {
    flexGird.rows.forEach(function (row: wjGrid.Row) {
      row.isReadOnly = false;
    });
  }
  //
  onBeginningEdit(flexGird: wjGrid.FlexGrid, e: wjGrid.CellEditEndingEventArgs) {
    var item = flexGird.rows[e.row].dataItem,
      binding = flexGird.columns[e.col].binding;
    if (!(binding in item)) {
      // property not on this item?
      e.cancel = true; // can't edit!
    }
  }
}
//\\

//
enableProdMode();

// Resolve resources (templateUrl, styleUrls etc), After resolution all URLs have been converted into `template` strings.
ɵresolveComponentResources(fetch).then(() => {
  // Bootstrap application
  bootstrapApplication(AppComponent).catch((err) => console.error(err));
});
