import { fakeAsync, flush, TestBed } from '@angular/core/testing';
import { AppComponent } from './app.component';
import { WjCoreModule } from '@mescius/wijmo.angular2.core';
import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { TestModule } from './test.module';

describe('AppComponent', () => {
  beforeEach(async () => {
    await TestBed.configureTestingModule({
      imports: [AppComponent, WjGridModule],
    }).compileComponents().catch(error => console.error(error));
  });

  it('should create the app', () => {
    const fixture = TestBed.createComponent(AppComponent);
    const app = fixture.componentInstance;
    expect(app).toBeTruthy();
  });

  it(`should have the 'angular19_flexgrid_app' title`, () => {
    const fixture = TestBed.createComponent(AppComponent);
    const app = fixture.componentInstance;
    expect(app.title).toEqual('angular19_flexgrid_app');
  });

  it('check columns count', fakeAsync(async () => {
    const fixture = TestBed.createComponent(AppComponent);
    const app = fixture.componentInstance;
    fixture.detectChanges();
    flush();
    await fixture.whenStable().then(() => {
      let colCount = app.flex.columns.length;
      expect(colCount).toEqual(3);
    })
  }), 10000);
});
