import { AfterViewInit, Component, Inject, ViewChild } from '@angular/core';
import { RouterOutlet } from '@angular/router';
import * as wjcCore from '@mescius/wijmo';
import * as wjcGrid from '@mescius/wijmo.grid';
import { FormsModule } from '@angular/forms';
import { WjInputModule } from '@mescius/wijmo.angular2.input';
import { WjGridModule } from '@mescius/wijmo.angular2.grid';
import { DataService } from './app.data';
import { CommonModule } from '@angular/common';


@Component({
  selector: 'app-root',
  providers: [DataService],
  imports: [RouterOutlet, WjGridModule, WjInputModule, FormsModule, CommonModule],
  templateUrl: './app.component.html',
  styleUrl: './app.component.css'
})
export class AppComponent implements AfterViewInit{
  title = 'angular19_flexgrid_app';
  countries: string[];
  data: wjcCore.CollectionView;
  customTopLeft = true;
  customRowHeader = true;
  customRowHeaderEdit = true;
  customCell = true;
  customCellEdit = true;
  customColumnHeader = true;
  customGroupHeader = true;
  customGroup = true;
  customColumnFooter = true;
  customBottomLeft = true;
  highlightDownloads = true;
  //
  @ViewChild('grid', { static: true }) grid?: wjcGrid.FlexGrid;
  //
  constructor(@Inject(DataService) dataSvc: DataService) {
    this.countries = dataSvc.getCountries();
    this.data = dataSvc.getCv(dataSvc.getData());
  }
  //
  ngAfterViewInit() {
    if (this.grid) {
      this.grid.columnFooters.rows.push(new wjcGrid.GroupRow());
    }
  }
}
