package com.dsexcel;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import com.grapecity.documents.excel.IComment;
import com.grapecity.documents.excel.IRange;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.Workbook;
import com.grapecity.documents.excel.drawing.ImageType;

public class Main {

    public static void main(String[] args) throws IOException {
        Workbook workbook = new Workbook();
        IWorksheet sheet = workbook.getActiveSheet();
        IRange cell = sheet.getRange("A1");
        cell.setValue("Image in comment");

        // Load image from resources
        try (FileInputStream imgStream = new FileInputStream("logo.png")) {
            addImageToCellComment(cell, imgStream);
        }

        String filePath = "CommentWithImage.xlsx";
        workbook.save(filePath);
        openFile(filePath);
    }

    private static void addImageToCellComment(IRange cell, FileInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            return;
        }
        IComment comment = cell.addComment("Picture");
        comment.getShape().getFill().userPicture(imageInputStream, ImageType.PNG);
        comment.getShape().setWidth(200);
        comment.getShape().setHeight(200);
        imageInputStream.close();
    }

    private static void openFile(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                System.err.println("File does not exist: " + filePath);
                return;
            }

            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(file);
            } else {
                System.err.println("Desktop is not supported. Cannot open file.");
            }
        } catch (IOException e) {
            System.err.println("Failed to open file: " + e.getMessage());
        }
    }
}
