﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using C1.WPF.Excel;
using C1.WPF.FlexGrid;

namespace ExportFlexgridToExcel
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            flexgrid.ItemsSource = Customer.GetCustomerList(15);
        }

        public void OnSaveClick(object sender, RoutedEventArgs routedEventArgs)
        {
            var dlg = new Microsoft.Win32.SaveFileDialog();
            dlg.DefaultExt = "xlsx";
            dlg.Filter = "Excel Workbook (*.xlsx)|*.xlsx";
            if (dlg.ShowDialog() == true)
            {
                 Save(dlg.FileName, flexgrid);
            }
        }
        public void Save(string filename, C1FlexGrid flexgrid)
        {
            // create the book to save
            var book = new C1XLBook();
            book.Sheets.Clear();
            var xlSheet = book.Sheets.Add("Sheet1");
            ExcelExport.ExcelFilter.Save(flexgrid, xlSheet);


            // save the book
            book.Save(filename, C1.WPF.Excel.FileFormat.OpenXml);
        }
    }
    
}
