﻿using C1.Win.CoditionalFormatting;
using C1.Win.RulesManager;
using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace RulesManager_Sample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            c1FlexGrid1.DataSource = new System.Data.DataTable()
            {
                Columns =
                {
                    {"ID", typeof(int) },
                    "Name",
                    {"Val", typeof(int) }
                },
                Rows =
                {
                    {1, "name-1", 0},
                    {2, "name-2", 50},
                    {3, "", 50},
                    {4, null, -100}
                }
            };

            c1FlexGrid1.Footers.Descriptions.Add(new C1.Win.C1FlexGrid.FooterDescription() 
            { 
                Caption = "Total",
                Aggregates =
                {
                    new C1.Win.C1FlexGrid.AggregateDefinition()
                    {
                        Column = 3,
                        Aggregate = C1.Win.C1FlexGrid.AggregateEnum.Sum
                    }
                }
            });

            c1RulesManager1.SetC1RulesManager(c1FlexGrid1, c1RulesManager1);

            ((IFormattableView)c1FlexGrid1).ItemFormatting += Form1_ItemFormatting;
        }

        private void Form1_ItemFormatting(object sender, ItemFormattingEventArgs e)
        {
            if(e.Item == c1FlexGrid1.Rows.Count - 1)
            {
                e.Cancel = true;
            }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            if (c1RulesManager1.Rules.Cast<Rule>().Where(r => r.Name == "Zero Check").FirstOrDefault() == null)
                c1RulesManager1.Rules.Add(new Rule()
                {
                    Name = "Zero Check",
                    Expression = "[Val] = 0",
                    Style = new ItemStyle { BackColor = Color.IndianRed }
                });
        }
    }
}
