(function (global) {
    SystemJS.config({
        transpiler: 'plugin-babel',
        babelOptions: {
            es2015: true
        },
        paths: {
            // paths serve as alias
            'npm:': 'node_modules/'
        },
        packageConfigPaths: [
            './node_modules/*/package.json',
            "./node_modules/@grapecity/*/package.json",
            "./node_modules/@babel/*/package.json",
            "./node_modules/@vue/*/package.json"
        ],
        map: {
            'vue': "npm:vue/dist/vue.esm-browser.js",
            'tiny-emitter': 'npm:tiny-emitter/index.js',
            'plugin-babel': 'npm:systemjs-plugin-babel/plugin-babel.js',
            "systemjs-babel-build": "npm:systemjs-plugin-babel/systemjs-babel-browser.js",
            '@grapecity/spread-sheets': 'npm:@grapecity/spread-sheets/index.js',
            '@grapecity/spread-sheets-print': 'npm:@grapecity/spread-sheets-print/index.js',
            '@grapecity/spread-sheets-pdf': 'npm:@grapecity/spread-sheets-pdf/index.js',
            '@grapecity/spread-sheets-vue': 'npm:@grapecity/spread-sheets-vue/index.js'

        },
        meta: {
            '*.css': { loader: 'systemjs-plugin-css' },
            '*.vue': { loader: "../plugin-vue/index.js" }
        }
    });
})(this);


