using C1.Win.C1FlexGrid;
using System;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Xml;

namespace TreeNode
{
    // to handle node dragging
    internal struct DRAGINFO
    {
        public bool dragging;   // currently dragging
        public bool checkDrag;  // currently checking mouse to start dragging
        public int row;     // index of row being dragged
        public Point mouseDown; // mouse down position
    }

    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        private C1.Win.C1FlexGrid.C1FlexGrid flex;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        private DRAGINFO m_DragInfo;
        private const int DRAGTOL = 5;  // mouse movement before dragging starts

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this.flex = new C1.Win.C1FlexGrid.C1FlexGrid();
            ((System.ComponentModel.ISupportInitialize)(this.flex)).BeginInit();
            this.SuspendLayout();
            // 
            // flex
            // 
            this.flex.ColumnInfo = "10,1,0,0,0,75,Columns:";
            this.flex.Dock = System.Windows.Forms.DockStyle.Fill;
            this.flex.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F);
            this.flex.Location = new System.Drawing.Point(0, 0);
            this.flex.Name = "flex";
            this.flex.Rows.DefaultSize = 17;
            this.flex.Size = new System.Drawing.Size(672, 357);
            this.flex.StyleInfo = resources.GetString("flex.StyleInfo");
            this.flex.TabIndex = 1;
            this.flex.Tree.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(128)))), ((int)(((byte)(128)))), ((int)(((byte)(128)))));
            this.flex.Tree.NodeImageCollapsed = ((System.Drawing.Image)(resources.GetObject("flex.Tree.NodeImageCollapsed")));
            this.flex.Tree.NodeImageExpanded = ((System.Drawing.Image)(resources.GetObject("flex.Tree.NodeImageExpanded")));
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(672, 357);
            this.Controls.Add(this.flex);
            this.Name = "Form1";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "C1FlexGrid: Tree Handling with the Node Object";
            this.Load += new System.EventHandler(this.Form1_Load);
            ((System.ComponentModel.ISupportInitialize)(this.flex)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.Run(new Form1());
        }

        private void Form1_Load(object sender, System.EventArgs e)
        {
            // initialize grid

            // layout
            flex.Rows.Count = 1;
            flex.Cols.Count = 2;
            flex.Cols.Fixed = 0;
            flex.ExtendLastCol = true;
            flex[0, 0] = "Tag";
            flex[0, 1] = "Value";

            // styles
            CellStyle cs = flex.Styles.Normal;
            cs.Border.Direction = BorderDirEnum.Vertical;
            cs.TextAlign = TextAlignEnum.LeftCenter;
            cs.WordWrap = false;
            cs = flex.Styles.Add("Data");
            cs.BackColor = SystemColors.Info;
            cs.ForeColor = SystemColors.InfoText;
            cs = flex.Styles.Add("SourceNode");
            cs.BackColor = Color.Yellow;
            cs.Font = new Font(flex.Font, FontStyle.Bold);

            // outline tree
            flex.Tree.Column = 0;
            flex.AllowMerging = AllowMergingEnum.Nodes;

            // other
            flex.AllowResizing = AllowResizingEnum.Columns;
            flex.SelectionMode = SelectionModeEnum.Cell;

            // read XML document into the grid
            PopulateGrid();
            flex.AutoSizeCols();

            flex.Tree.Style = TreeStyleFlags.ButtonBar | TreeStyleFlags.CompleteLeaf;
        }
        private void PopulateGrid()
        {
            // build filename
            string path = Path.GetDirectoryName(Application.ExecutablePath);
            int i = path.LastIndexOf(@"\bin\");
            if (i > -1) path = path.Substring(0, i);
            string fileName = path + @"\test.xml";

            // load xml document
            XmlDocument xdoc = new XmlDocument();
            xdoc.Load(fileName);

            // copy document to grid
            flex.Rows.Count = 1;
            GetXMLData(xdoc.ChildNodes[1], 0);
        }
        private void GetXMLData(XmlNode node, int level)
        {
            // skip comment nodes
            if (node.NodeType == XmlNodeType.Comment)
                return;

            // add new row for this node
            int row = flex.Rows.Count;
            flex.Rows.Add();
            flex[row, 0] = node.Name;
            if (node.ChildNodes.Count == 1)
            {
                flex[row, 1] = node.InnerText;
                flex.SetCellStyle(row, 1, flex.Styles["Data"]);
            }

            // make new row a node
            flex.Rows[row].IsNode = true;
            flex.Rows[row].Node.Level = level;

            // if this node has children, get them as well
            if (node.ChildNodes.Count > 1)
            {
                // recurse to get children
                foreach (XmlNode child in node.ChildNodes)
                    GetXMLData(child, level + 1);
            }
        
        }
    }
}
