﻿using GrapeCity.ActiveReports;
using GrapeCity.ActiveReports.Document.Section;
using System.Diagnostics;
using System.Xml;

namespace MergeReportsAR
{
    internal class Program
    {
        static void Main(string[] args)
        {
            //main report
            var mainReport = new SectionReport();
            using (var reader = XmlReader.Create("MainReport.rpx"))
            {
                mainReport.LoadLayout(reader);
            }
            mainReport.Run();

            //sub report
            var subReport = new SectionReport();
            using (var reader = XmlReader.Create("SubReport.rpx"))
            {
                subReport.LoadLayout(reader);
            }
            subReport.Run();

            //merge reports
            var mergedReport = new SectionReport();
            foreach (Page page in mainReport.Document.Pages)
            {
                mergedReport.Document.Pages.Add(page);
            }
            foreach (Page page in subReport.Document.Pages)
            {
                mergedReport.Document.Pages.Add(page);
            }

            //add page count manually
            var totalPageCount = mainReport.Document.Pages.Count + subReport.Document.Pages.Count;
            AddPageCount(mergedReport, totalPageCount);

            //pdf export
            ExportReportToPdf(mainReport, "MainReport.pdf");
            ExportReportToPdf(subReport, "SubReport.pdf");
            ExportReportToPdf(mergedReport, "MergedReport.pdf");
            Process.Start(new ProcessStartInfo("MergedReport.pdf") { UseShellExecute = true });
        }

        private static void AddPageCount(SectionReport mergedReport, int totalPageCount)
        {
            for (int i = 0; i < totalPageCount; i++)
            {
                var page = mergedReport.Document.Pages[i];
                page.DrawText($"Page {i + 1} of {totalPageCount}", new System.Drawing.RectangleF(page.Width - 1.5f, page.Height - 0.5f, 1, 1));
            }
        }

        private static void ExportReportToPdf(SectionReport report, string filename)
        {
            var pdfExport = new GrapeCity.ActiveReports.Export.Pdf.Section.PdfExport();
            pdfExport.Export(report.Document, filename);  
        }
    }
}
