﻿using C1.WPF.Core;
using C1.WPF.Docking;
using C1.WPF.Input;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading.Tasks.Sources;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CustomizeDockTabIcon
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            dockControl.ViewChanged += DockControl_ViewChanged;
        }

        private void DockControl_ViewChanged(object? sender, EventArgs e)
        {
            var dockControl = sender as C1DockControl; 
            if (dockControl != null)
            {
                List<C1DockTabControl> tabControls = GetAllC1DockTabControls(dockControl.Items);
                foreach (var tabControl in tabControls)
                {
                    var dropDownButton = (tabControl.Template.FindName("9_T", tabControl) as C1DropDownButton);
                    dropDownButton.Background = Brushes.Yellow;

                    var pinButton = (tabControl.Template.FindName("SlidingButton", tabControl) as Button);
                    pinButton.Background = Brushes.Yellow;

                    var closeButton = (tabControl.Template.FindName("HiddenButton", tabControl) as Button);
                    closeButton.Background = Brushes.Yellow;
                    
                }
            }
        }

        public static List<C1DockTabControl> GetAllC1DockTabControls(ItemCollection items)
        {
            List<C1DockTabControl> tabControls = new List<C1DockTabControl>();

            foreach (var item in items)
            {
                if (item is C1DockTabControl tabControl)
                {
                    tabControls.Add(tabControl);
                }
                else if (item is C1DockGroup dockGroup)
                {
                    // Recursively call the function for C1DockGroup's items
                    tabControls.AddRange(GetAllC1DockTabControls(dockGroup.Items));
                }
            }

            return tabControls;
        }

    }
}
