import 'bootstrap.css';
import '@mescius/wijmo.styles/wijmo.css';
import './styles.css';
//
import { isArray } from '@mescius/wijmo';
import { FlexChart, Palettes } from '@mescius/wijmo.chart';
import { BoxWhisker, _BoxPlot } from '@mescius/wijmo.chart.analytics';
import { getData } from './data';

function customerParserFunction(sourceData, quartileCalculation, showOutliers) {

    return sourceData[2];

    //  Custom parser function logic
    // you can use your custom logic here to process the data if needed

    // this method should return an object with the following properties:
    return {
        min,              // Minimum value [number]
        max,              // Maximum value [number]
        mean,             // Mean (average) value [number]
        firstQuartile,    // First quartile [number]
        thirdQuartile,    // Third quartile [number]
        median,           // Median [number] [number]
        outlierPoints,    // Outlier points (values outside typical range) [number[]]
        innerPoints,      // Inner points (values within the interquartile range) [number[]]
        iqr,              // Interquartile range [number]
    }
}
_BoxPlot.prototype._parse = function () {
    const sourceData = this._data;
    const quartileCalculation = this._quartileCalculation;
    const showOutliers = this._showOutliers; 
    let parsedData = customerParserFunction(sourceData, quartileCalculation, showOutliers);
    const {
        min,
        max,
        mean,
        firstQuartile,
        thirdQuartile,
        median,
        outlierPoints,
        innerPoints,
        iqr
    } = parsedData;
    this._min = min;
    this._max = max;
    this._mean = mean;
    this._firstQuartile = firstQuartile;
    this._thirdQuartile = thirdQuartile;
    this._median = median;
    this._outlierPoints = outlierPoints;
    this._innerPoints = innerPoints;
    this._iqr = iqr;
}
//
document.readyState === 'complete' ? init() : window.onload = init;
//
function init() {
    
    const data = getData();
    // create the chart
    let theChart = new FlexChart('#theChart', {
        itemsSource: data,
        bindingX: 'country',
        tooltip: { content: '{seriesName}: <b>{x}</b>' },
        palette: getRandomPalette()
    });
    //
    // create BoxWhisker series for 'sales' and add it to the chart
    theChart.series.push(new BoxWhisker({
        name: 'Sales',
        binding: 'processedSales',
        groupWidth: 0.7,
        gapWidth: 0.2
    }));
    //
    // create BoxWhisker series for 'expenses' and add it to the chart
    theChart.series.push(new BoxWhisker({
        name: 'Expenses',
        binding: 'processedExpenses',
        groupWidth: 0.7,
        gapWidth: 0.2
    }));
    //
    // customize the BoxWhisker series
    document.querySelector('#innerPoints').addEventListener('click', e => {
        theChart.series.forEach((series) => {
            series.showInnerPoints = e.target.checked;
        });
    });
    document.querySelector('#outliers').addEventListener('click', e => {
        theChart.series.forEach((series) => {
            series.showOutliers = e.target.checked;
        });
    });
    document.querySelector('#meanline').addEventListener('click', e => {
        theChart.series.forEach((series) => {
            series.showMeanLine = e.target.checked;
        });
    });
    document.querySelector('#meanmarker').addEventListener('click', e => {
        theChart.series.forEach((series) => {
            series.showMeanMarker = e.target.checked;
        });
    });
    document.querySelector('#rotated').addEventListener('click', e => {
        theChart.rotated = e.target.checked;
    });
    //
    // randomize the data
    document.querySelector('#btnRandomize').addEventListener('click', () => {
        theChart.itemsSource = getData();
    });
}
//
function getRandomPalette() {
    let palettes = Object.keys(Palettes).filter(prop => isArray(Palettes[prop]));
    let rand = Math.floor(Math.random() * palettes.length);
    //
    return Palettes[palettes[rand]];
}
