// create some random data
// the data items contain arrays of values rather than single values
export function getData() {
  let countries = ["US", "Canada", "Mexico", "Germany", "UK", "France", "Japan", "Korea", "China"],
    data = [];

  for (let i = 0; i < countries.length; i++) {
    const sales = getRandomArray(20, 10000);
    const expenses = getRandomArray(20, 5000);
    data.push({
      country: countries[i],
      sales,
      expenses,
      processedSales: finalData(sales),
      processedExpenses: finalData(expenses),
    });
  }

  return data;
}

// function to format the processed data for being accepted by the chart
function finalData(arr) {
    let processedData = processData(arr);
    return [processedData.min, processedData.max, processedData];
}

function getRandomArray(count, max) {
  let arr = [];
  for (let i = 0; i < count; i++) {
    arr.push((Math.random() * max) / 3 + (Math.random() * max) / 3 + (Math.random() * max) / 3);
  }
  return arr;
}

// function to process the data
function processData(arr) {
  const sorted = [...arr].sort((a, b) => a - b);
  const min = sorted[0];
  const max = sorted[sorted.length - 1];
  const mean = sorted.reduce((sum, val) => sum + val, 0) / sorted.length;

  const firstQuartile = quantile(sorted, 0.25);
  const median = quantile(sorted, 0.5);
  const thirdQuartile = quantile(sorted, 0.75);
  const iqr = thirdQuartile - firstQuartile;

  const lowerFence = firstQuartile - 1.5 * iqr;
  const upperFence = thirdQuartile + 1.5 * iqr;

  const innerPoints = sorted.filter((v) => v >= lowerFence && v <= upperFence);
  const outlierPoints = sorted.filter((v) => v < lowerFence || v > upperFence);

  return {
    min,
    max,
    mean,
    firstQuartile,
    thirdQuartile,
    median,
    outlierPoints,
    innerPoints,
    iqr,
  };
}

function quantile(sortedArr, q) {
  const pos = (sortedArr.length - 1) * q;
  const base = Math.floor(pos);
  const rest = pos - base;
  if (sortedArr[base + 1] !== undefined) {
    return sortedArr[base] + rest * (sortedArr[base + 1] - sortedArr[base]);
  } else {
    return sortedArr[base];
  }
}
