﻿Imports C1.Win.C1FlexGrid

Public Class Form1
    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        SetupGrid()

    End Sub

    Private Sub SetupGrid()

#Region "Sample Data"

        C1FlexGrid1.Cols.Count = 4
        C1FlexGrid1.Rows.Count = 1

        Dim col = C1FlexGrid1.Cols(1)
        col.Name = "ID"
        col.Caption = "ID"

        col = C1FlexGrid1.Cols(2)
        col.Name = "Name"
        col.Caption = "Name"

        col = C1FlexGrid1.Cols(3)
        col.Name = "Department"
        col.Caption = "Department"

        C1FlexGrid1.AddItem(New Object() {"", 1, "Peter", "Management"})
        C1FlexGrid1.AddItem(New Object() {"", 2, "George", "Management"})
        C1FlexGrid1.AddItem(New Object() {"", 3, "Athena", "HR"})
        C1FlexGrid1.AddItem(New Object() {"", 4, "Emily", "HR"})
        C1FlexGrid1.AddItem(New Object() {"", 5, "Christian", "Development"})
        C1FlexGrid1.AddItem(New Object() {"", 6, "Billy", "Finance"})
        C1FlexGrid1.AddItem(New Object() {"", 7, "Hunter", "Finance"})

#End Region

#Region "Custom Merging"

        C1FlexGrid1.AllowMerging = AllowMergingEnum.Custom

        Dim cellRange = C1FlexGrid1.GetCellRange(1, 3, 2, 3)
        C1FlexGrid1.MergedRanges.Add(cellRange)
        cellRange = C1FlexGrid1.GetCellRange(3, 3, 4, 3)
        C1FlexGrid1.MergedRanges.Add(cellRange)
        cellRange = C1FlexGrid1.GetCellRange(6, 3, 7, 3)
        C1FlexGrid1.MergedRanges.Add(cellRange)

#End Region

    End Sub

    Private Sub AddItemToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles AddItemToolStripMenuItem.Click

        Dim index = C1FlexGrid1.MergedRanges.IndexOf(C1FlexGrid1.Row, 3)

        'When adding item between a merged range, add the item
        'then update the current and all the below ranges
        If index <> -1 Then
            Dim mergedRange = C1FlexGrid1.MergedRanges(index)
            C1FlexGrid1.AddItem($" {vbTab}00{vbTab}NewRow{vbTab}NewRow", C1FlexGrid1.Row)
            If C1FlexGrid1.Row - 1 = mergedRange.r1 Then
                mergedRange.r1 += 1
                mergedRange.r2 += 1
            Else
                mergedRange.r2 += 1
            End If
            C1FlexGrid1.MergedRanges.RemoveAt(index)
            C1FlexGrid1.MergedRanges.Insert(index, mergedRange)

            For i = index + 1 To C1FlexGrid1.MergedRanges.Count - 1
                Dim range = C1FlexGrid1.MergedRanges(i)
                range.r1 += 1
                range.r2 += 1
                C1FlexGrid1.MergedRanges.RemoveAt(i)
                C1FlexGrid1.MergedRanges.Insert(i, range)
            Next

            'When adding item over a normal row (not merged) , add the item
            'then update all the below ranges
        Else
            C1FlexGrid1.AddItem($" {vbTab}00{vbTab}NewRow{vbTab}NewRow", C1FlexGrid1.Row)

            For i = C1FlexGrid1.Row To C1FlexGrid1.Rows.Count - 1
                Dim mergedIndex = C1FlexGrid1.MergedRanges.IndexOf(i, 3)
                If mergedIndex <> -1 Then
                    Dim range = C1FlexGrid1.MergedRanges(mergedIndex)
                    range.r1 += 1
                    range.r2 += 1
                    C1FlexGrid1.MergedRanges.RemoveAt(mergedIndex)
                    C1FlexGrid1.MergedRanges.Insert(mergedIndex, range)

                    If mergedIndex = C1FlexGrid1.MergedRanges.Count - 1 Then Exit For

                End If
            Next

        End If

    End Sub
End Class
