﻿using C1.WPF.Input;
using C1.WPF.Ribbon;
using C1.WPF.Viewer;
using DocumentFormat.OpenXml.Drawing;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace FlexviewerStyle
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            
        }

        private void fv_Loaded(object sender, RoutedEventArgs e)
        {
            var flexViewer = sender as FlexViewer;
            var mainToolBar = flexViewer.Template.FindName("mainToolbar", flexViewer) as MainToolbar;
            var toolStrip = mainToolBar.Template.FindName("toolBarStack", mainToolBar) as C1ToolStrip;
            mainToolBar.Foreground = Brushes.White; 
            toolStrip.Background = Brushes.DarkBlue;
            (mainToolBar.Template.FindName("menuLayout", mainToolBar) as C1MenuTool).Background = Brushes.DarkBlue;
            (mainToolBar.Template.FindName("pageNumberTextBox", mainToolBar) as C1TextBox).Foreground = Brushes.DarkBlue;
            (mainToolBar.Template.FindName("pageNumberTextBox", mainToolBar) as C1TextBox).CaretBrush = Brushes.DarkBlue;
        }

    }
}
