/// <reference types="cypress" />

// Welcome to Cypress!
describe('SpreadJS Testing', () => {

    // set up app state
    beforeEach(() => {
        cy.visit('http://localhost:1234/')
    })

    it('checking cell content', () => {
        cy.window().then((appWindow) => {
            let spreadHostElement = appWindow.document.querySelector('[gcuielement="gcSpread"]');
            let spread = appWindow.GC.Spread.Sheets.findControl(spreadHostElement);
            let value = spread.getSheet(0).getValue(0, 0);

            expect(value).to.eq('Test application');
        });
    })

    it('hiding sheet from sheet context menu', () => {
        cy.window().then((appWindow) => {
            let spreadHostElement = appWindow.document.querySelector('[gcuielement="gcSpread"]');
            let spread = appWindow.GC.Spread.Sheets.findControl(spreadHostElement);
            let sheet = spread.getActiveSheet();

            let actSheetTabRect = getActiveSheetTabRect(spread);
            cy.get(spread.getHost()).rightclick(actSheetTabRect.x + actSheetTabRect.width / 2, actSheetTabRect.y + actSheetTabRect.height / 2);

            cy.get('.gc-ui-contextmenu-container .gc-ui-contextmenu-menuitem').contains('Hide').click();
            
            cy.wait(1000).then(() => {
                let value = sheet.visible();
    
                expect(value).to.eq(appWindow.GC.Spread.Sheets.SheetTabVisible.hidden);
            });
        });
    })

    it('deleting sheet from sheet context menu', () => {
        cy.window().then((appWindow) => {
            let spreadHostElement = appWindow.document.querySelector('[gcuielement="gcSpread"]');
            let spread = appWindow.GC.Spread.Sheets.findControl(spreadHostElement);
            let sheet = spread.getActiveSheet();
            let sheetName = sheet.name();

            let actSheetTabRect = getActiveSheetTabRect(spread);
            cy.get(spread.getHost()).rightclick(actSheetTabRect.x + actSheetTabRect.width / 2, actSheetTabRect.y + actSheetTabRect.height / 2);

            cy.get('.gc-ui-contextmenu-container .gc-ui-contextmenu-menuitem').contains('Delete').click();
            
            cy.wait(1000).then(() => {
                let isSheetPresent = true;
                if (!spread.getSheetFromName(sheetName)) {
                    isSheetPresent = false;
                }
    
                expect(isSheetPresent).to.eq(false);
            });
        });
    })

    it('inserting new sheet from sheet context menu', () => {
        cy.window().then((appWindow) => {
            let spreadHostElement = appWindow.document.querySelector('[gcuielement="gcSpread"]');
            let spread = appWindow.GC.Spread.Sheets.findControl(spreadHostElement);
            let namesMap = new Map();

            spread.sheets.forEach((sheet) => {
                namesMap.set(sheet.name(), true);
            });

            let actSheetTabRect = getActiveSheetTabRect(spread);
            cy.get(spread.getHost()).rightclick(actSheetTabRect.x + actSheetTabRect.width / 2, actSheetTabRect.y + actSheetTabRect.height / 2);

            cy.get('.gc-ui-contextmenu-container .gc-ui-contextmenu-menuitem').contains('Insert').click();
            
            cy.wait(1000).then(() => {
                let activeSheet = spread.getActiveSheet();
                let newSheetAdded = false;

                if (!namesMap.has(activeSheet.name())) {
                    newSheetAdded = true;
                }
    
                expect(newSheetAdded).to.eq(true);
            });
        });
    })
})

function getActiveSheetTabRect(spread) {
    var hostID = spread.getHost().id;
    var tabStripHost = spread.getHost().querySelector(`#${hostID}_tabStrip`);
    var offset = getOffset(tabStripHost), width = tabStripHost.clientWidth, height = tabStripHost.clientHeight;
    var startX, acTabWidth, flag = false, activeSheetIndex = spread.getActiveSheetIndex();
    for (var x = 0; x < width; x++) {
        var hitInfo = spread.hitTest(x + offset.left, height / 2 + offset.top);
        var tabStripHitInfo = hitInfo && hitInfo.tabStripHitInfo;
        if (tabStripHitInfo && tabStripHitInfo.sheetTab && tabStripHitInfo.sheetTab.sheetIndex !== void 0) {
            if (tabStripHitInfo.sheetTab.sheetIndex === activeSheetIndex) {
                if (startX === void 0) {
                    startX = x;
                }
                flag = true;
            } else if (flag) {
                acTabWidth = x - startX;
                break;
            }
        } else if (flag) {
            acTabWidth = x - startX;
            break;
        }
    }
    return { x: startX + offset.left + 5, y: offset.top, width: acTabWidth, height: height - 5 };
}

function getOffset(elem) {
    var docElem, win, box = { top: 0, left: 0 }, ownerDocument = elem && elem.ownerDocument;
    if (!ownerDocument) {
        return;
    }
    docElem = ownerDocument.documentElement;
    if (elem.getBoundingClientRect) {
        try {
            box = elem.getBoundingClientRect();
        }
        catch (e) {
        }
    }
    win = ownerDocument.defaultView;
    return {
        top: box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
        left: box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0)
    };
} 