// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"node_modules/@grapecity/spread-sheets/dist/gc.spread.sheets.all.min.js":[function(require,module,exports) {
var global = arguments[3];
var define;
/*!
 * 
 * SpreadJS Library 16.2.5
 *
 * Copyright(c) GrapeCity, Inc.  All rights reserved.
 *
 * Licensed under the SpreadJS Commercial License.
 * us.sales@grapecity.com
 * http://www.grapecity.com/en/licensing/grapecity/
 *
 *
 */
var GC;!function(){var e,i,t;function r(t){var n,n,n=i[t];return void 0!==n||(n=i[t]={exports:{}},e[t].call(n.exports,n,n.exports,r)),n.exports}e={"./all.entry.js":function(t,n,e){(GC=GC||{}).Spread=GC.Spread||{},GC.Spread=e("./node_modules_local/@grapecity/js-sheets-common/index.js"),GC.Spread.CalcEngine=e("./node_modules_local/@grapecity/js-calc/index.js"),GC.Spread.CalcEngine.BasicFunctions=e("./node_modules_local/@grapecity/js-calc-basicfunctions/index.js"),GC.Spread.CalcEngine.AdvancedFunctions=e("./node_modules_local/@grapecity/js-calc-advancedfunctions/index.js"),GC.Data=e("./node_modules_local/@grapecity/js-data-manager/index.js"),GC.Spread.Sheets=e("./dist/core/core.entry.js"),GC.Spread.Sheets.Bindings=e("./dist/plugins/data/data.entry.js"),GC.Spread.Sheets.Outlines=e("./dist/plugins/group/group.entry.js"),GC.Spread.Sheets.CalcEngine=e("./dist/plugins/sheetsCalc/sheetsCalc.entry.js"),GC.Spread.Sheets.ConditionalFormatting=e("./dist/plugins/conditional/conditional.entry.js"),GC.Spread.Sheets.DataValidation=e("./dist/plugins/validation/datavalidation.entry.js"),GC.Spread.Sheets.Search=e("./dist/plugins/search/search.entry.js"),GC.Spread.Sheets.Touch=e("./dist/plugins/touch/touch.entry.js"),GC.Spread.Sheets.FloatingObjects=e("./dist/plugins/floatingObject/floatingobject.entry.js"),GC.Spread.Sheets.Sparklines=e("./dist/plugins/sparkline/sparkline-wrapper.entry.js"),GC.Spread.Sheets.Comments=e("./dist/plugins/comment/comment.entry.js"),GC.Spread.Sheets.CellState=e("./dist/plugins/cellState/cellstate.entry.js"),GC.Spread.Sheets.CellTypes=e("./dist/plugins/celltype/celltypes.entry.js"),GC.Spread.Sheets.Filter=e("./dist/plugins/filter/filter.entry.js"),GC.Spread.Sheets.Tables=e("./dist/plugins/table/table.entry.js"),GC.Spread.Sheets.Fill=e("./dist/plugins/fill/fill.entry.js"),GC.Spread.Sheets.ContextMenu=e("./dist/plugins/contextMenu/context-menu.entry.js"),GC.Spread.Sheets.FormulaTextBox=e("./dist/plugins/formulaTextbox/formulaTextBox.entry.js"),GC.Spread.Sheets.OutlineColumn=e("./dist/plugins/outlineColumn/outlineColumn.entry.js"),GC.Spread.Sheets.DragMerge=e("./dist/plugins/dragMerge/dragMerge.entry.js"),GC.Spread.Sheets.StatusBar=e("./dist/plugins/statusBar/statusBar.entry.js"),GC.Spread.Sheets.AutoMerge=e("./dist/plugins/autoMerge/autoMerge.js"),GC.Spread.Sheets.Hyperlink=e("./dist/plugins/hyperlink/hyperlink.js"),GC.Spread.Sheets.NameBox=e("./dist/plugins/namebox/namebox.entry.js"),GC.Spread.Sheets.InputMask=e("./dist/plugins/inputMask/inputMask.entry.js"),t.exports=GC.Spread},"./dist/core/celltype/basecelltype.js":function(n,u,t){"use strict";var c,v,lt,ht,m,z,i,l,h,d,M,t,Y,o,Z,yt,W,dt,C,S,Q,B,T,g,F,x,y,J,K,X,D,L,b,_,A,vt,N,mt,gt,Mt,r,pt,a,s,j,bt,E,O,k,R,P,I,G,e,U;function q(t){var n=t.isPrinting,t=t.printZoomFactor;return n&&typeof t===b&&1!==t}function H(t){var n;return!(t instanceof CanvasRenderingContext2D)&&!g(t._ae)}function V(t,n){var e,i,r,e=0,i=t.font+n,r=!H(t);return r&&O[i]?e=O[i]:(e=Q(t,t.font,n),r&&(O[i]=e)),e}function w(){}function $(t,n){var e;return n/2-t/2+(8<t?vt((t-8)/5+2):1)-1}function tt(t){var n=G[t.charCodeAt(0)];return n?String.fromCharCode(n):t}function nt(t,n,e){return Y(t.x)||(t.x+=n.width),t.width=t.width-n.width-e.width,t}function et(t,n,e,i,r){var o,a,o=e+" - "+n+" - "+t;return u.wordWrapInfoCache||(u.wordWrapInfoCache={}),a=2e3,g(u.clearCacheTimer)&&(u.clearCacheTimer=setTimeout(function(){u.wordWrapInfoCache=null,u.clearCacheTimer=null},a)),u.wordWrapInfoCache[o]||(u.wordWrapInfoCache[o]=lt.q.un(t,n,e,!1,r)),u.wordWrapInfoCache[o]}function it(t,n){return ht.W.gfe(t,z.IconPosition.left)&&(n+=1),ht.W.gfe(t,z.IconPosition.right)&&(n+=2),n}function rt(t,n){return ht.W.gfe(t,z.IconPosition.left)&&--n,ht.W.gfe(t,z.IconPosition.right)&&(n-=2),n}function f(){this.allowOverflow=!1,this.typeName="0"}function ot(t,n,e,i){var r,o,r=t.conditionalFormats;return r&&(o=t.getValue(n,e,i),r.O(n,e,i))&&r.U(t,n,e,o,i).iconSet}function at(t,n,e){for(var i,r,o,i=0,r=0;r<t.length;r++)o=void 0,o=t[r].style&&t[r].style.font?t[r].style.font:n,i=Math.max(Z(o,A,W(t[r].text))/e,i),(t[r].style&&1===t[r].style.vertAlign||2===t[r].style.vertAlign)&&(i=Math.max(Z(o,A,W(t[r].text))/e+2*ht.W.V(o,E).fontSize*.218,i));return i}function ut(t,n,e,i,r){var o,a,u,s,c,f,o=lt.q.J();if(!o)return 0;for(u=a=0;u<t.length;u++)s=void 0,s=t[u].style&&t[u].style.font?t[u].style.font:n,t[u].style&&t[u].style.vertAlign&&(s=ht.W.V(s,E).font),dt(o,s),c="",c=u===t.length-1&&r?lt.q.tt(t[u].text):t[u].text,f=0,i?f=Z(s)*c.length/e:Y(t[u].text)||(f=Q(o,s,t[u].text)/e),a+=f;return a}function st(t,n,e,i,r){var o,a,u,o;if(!lt.q.J())return 0;for(u=a=0;u<t.length;u++)a+=ut(t[u],n,e,i,r);return a}function ct(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,p,b,s,a,m,g,w,y,M,C,S,T,p,b,c=a.backColor,f=a.backgroundImage,l=a.textOrientation,h=a.isVerticalText,d=a.textIndent&&0!==a.textIndent,v=a.backgroundImageLayout,m=s.row,g=s.col,p=s.sheet,b=p.Jt,s=s.sheet&&s.sheet.getSpan(m,g,s.sheetArea),a=a&&(a.borderLeft||a.borderTop||a.borderRight||a.borderBottom),w=0,y=n;t.save(),g+1<p.getColumnCount()&&(S=b.qt(m,g+1)),0<=g-1&&(T=b.qt(m,g-1)),p=function(t){return t!==A&&t&&-90<=t&&t<=90},b=function(){t.fillRect(n,e,i,r)},l&&0!==l&&a&&u&&!s&&!h&&!d&&(m=pt(l*Math.PI/180),g=Mt(m),w=vt(r/g),-90<l&&l<0&&(S&&!p(S.textOrientation)&&(C=S.backColor),y=n-w),0<l&&l<90&&(T&&!p(T.textOrientation)&&(C=T.backColor),y=n+w),M=function(){t.beginPath(),t.moveTo(y,e),t.lineTo(y+i,e),t.lineTo(n+i,e+r),t.lineTo(n,e+r),t.fill()}),(c||f)&&(C&&ht.W.setFillStyle(t,C,n,e,i,r,b),M?ht.W.setFillStyle(t,c,Math.min(y,n),e,i+w,r,M):c&&ht.W.setFillStyle(t,c,n,e,i,r,b),I.nt(t,n,e,i,r,f,v,o)),t.restore()}function ft(t,n,e,i,r,o,a){var t;(0===t||a)&&ot(n,e,i,r)&&(t=Ct(n),o.x+=t,o.width-=t)}function Ct(t){return parseInt(D*t.zoom(),10)}function wt(t,n,e,i){var r=t.cellPadding,o=0,t=t.labelOptions;return(r=e?t?t.margin:"0":r)&&(o=typeof(o=parseInt(kt(r)[n],10))===b&&0<o?o:0),i===A?o:o*i}function St(t){var n={context:t,value:0};return e.et(t.sheet,"getOutlineColumnOffset",n),n.value}function Tt(t,n){var n={context:t,value:0,cellStyle:n};return e.et(t.sheet,"getCellButtonAutoWidth",n),n.value}function At(t,n){var n={context:t,value:0,cellStyle:n};return cn(n),e.et(t.sheet,"getSpecialIconsAutoWidth",n),n.value}function It(t,n){var n={context:t,value:0,cellStyle:n};return e.et(t.sheet,"getCellButtonAutoHeight",n),n.value}function xt(t,n){var n={context:t,value:0,cellStyle:n};return fn(n),e.et(t.sheet,"getSpecialIconsAutoHeight",n),n.value}function Nt(t,n,e,i){var r,i,r,n,o,r=i&&i.sheet;r&&e&&(i=i.canvasOffset||r.rt.it(),r=r.ot(),(n=(n=n.backColor||"white").stops?(o=n.stops)[0]&&o[0].color:n).backgroundColor&&(n=n.backgroundColor),(0,v.GC$)(t).width(e.width).height(e.height).css({top:i.top+r.y+e.y-2,left:i.left+r.x+e.x-2,"background-color":n}))}function kt(t){var n,t,e,i,r,n=["0","0","0","0"];return typeof t===L&&(r=i=void 0,1===(e=(t=t.split(" ",4)).length)?n=[i=t[0],i,i,i]:2===e?n=[i=t[0],r=t[1],i,r]:3===e?(r=t[1],n=[t[0],r,t[2],r]):4===e&&(n=[t[0],t[1],t[2],t[3]])),n}function _t(t,n){var e,i,r,o,a,e=wt(t,0),i=wt(t,2),r=wt(t,0,!0),o=wt(t,2,!0);if(!(wt(t,3,!0)+wt(t,1,!0)>=n.width))if(0===(a=(a=t.labelOptions.alignment)===A?t.labelOptions.alignment=0:a)||1===a||2===a){if(0<e&&r+o<e)return 1}else if((3===a||4===a||5===a)&&e<n.height&&0<i&&r+o<i)return 1}function Dt(t,n){var e,i,r,o,a,e=wt(n,0),i=wt(n,3,!0),r=wt(n,2,!0),o=t.clone(),a=n.labelOptions.alignment;return 0===a||1===a||2===a?e<t.height&&(o.height=e-r+1):3!==a&&4!==a&&5!==a||(o.height=t.height-r),o.x+=i,o.width-=i+wt(n,1,!0),o}function jt(t){var n="left";return 1===t||4===t?n="center":2!==t&&5!==t||(n="right"),n}function Et(t,n,e,i){var r,e,o,a,u,s,c,t,f,l,h,i,d,v,r=new lt.Point(t.x,t.y),e=parseInt(e.fontSize,10),o=wt(n,0),a=wt(n,2),u=wt(n,3,!0),s=wt(n,1,!0),c=t.width,t=t.height,f,l,h=8<e?1:2,i=i-(i/2-e/2+(8<e?Math.floor((e-8)/5+2):1)-1)+wt(n,0,!0),d=i+1,v=t<o+a?o+i:t-a+i-1;switch(n.labelOptions.alignment){case 0:r.x+=u+h+1,r.y+=d;break;case 1:r.x+=u+(c-u-s)/2,r.y+=d;break;case 2:r.x+=c-s-2,r.y+=d;break;case 3:r.x+=u+h+1,r.y+=v;break;case 4:r.x+=u+(c-u-s)/2,r.y+=v;break;case 5:r.x+=c-s-2,r.y+=v}return r}function Ot(t,n){var e,i,r,o,a,u,e=wt(n,3,!0),i=wt(n,1,!0),r=wt(n,0,!0),o=wt(n,2,!0),a=t.clone(),u=n.labelOptions.alignment;return a.x=e+1,a.width-=e+i,0===u||1===u||2===u?(a.y=r,a.height=wt(n,0)-r-o):3!==u&&4!==u&&5!==u||(a.y=t.height-wt(n,2)+r,a.height=wt(n,2)-r-o),2!==u&&5!==u||(a.width-=2),a}function Rt(t,n,e){var i,r;if(o(n,L))return V(t,n);if(e&&n&&n[0]&&n[0].value)return n[0].value.length*Z(t.font);for(r=i=0;r<n.length;r++)"fillingChar"!==n[r].type&&(i+=V(t,n[r].value));return i}function Lt(t){for(var n,e,i,r,o,n=t[0].type,e=0,i=[t[0]],r=1;r<t.length;r++)o=t[r],n===j&&o.type===j?i[e].value+=o.value:(i.push(o),n=o.type,e++);return i}function Bt(t,n,e,i,r){var i,i=i?Math.floor(n/r):Math.floor(n/Q(t,t.font,e));return new Array(i+1).join(e)}function Ft(t){var t=t.clone();return t.width--,t.height--,t}function Pt(t,n,e,i){for(var r,o,a,r=0;r<t.length;r++)o=void 0,t[r].style=t[r].style||{},(a=t[r].style).font?(o=ht.W.V(a.font,e).font,Y(i)||(o=ht.W.V(o,i).font)):o="object"==typeof n?n.font:n,a.font=o}function Gt(t,n,e,i,r){var o=e*gt(-i)+r*mt(-i),e=e*gt(-i)+r*mt(-i),a,u;return new lt.Rect(t-o/2,n-e/2,o,e)}function Ut(t){return"string"==typeof t.src&&0<t.src.length&&-1===t.src.indexOf("<script")}function Ht(t,n,e,i){g(e.decoration)||(e.decoration.cornerFold&&Vt(t,n,e.decoration.cornerFold,i),e.decoration.icons&&0<e.decoration.icons.length&&zt(t,n,e.decoration.icons.filter(Ut),e.vAlign,i))}function Vt(t,n,e,i){var r,o,e,a,u,s,n,c,r,i,e,f,l,h,d,r=e.size,o=e.position,e=e.color;g(r)&&(r=6),g(o)&&(o=m.CornerPosition.leftTop),a=n.x,u=n.y,s=n.height,n=n.width,r=r*(c=i.sheet).zoom(),t&&0<n&&0<s&&(t.save(),t.rect(a,u,n,s),t.clip(),t.fillStyle=e||"#FF3D00",t.beginPath(),t.fillStyle=e,d=h=l=f=e=i=void 0,o&m.CornerPosition.leftTop&&(f=i=a,l=(e=u)+r,h=i+r,d=e,t.moveTo(i,e),t.lineTo(f,l),t.lineTo(h,d),t.fill()),o&m.CornerPosition.rightBottom&&(l=(e=u+s)-r,h=(f=i=a+n)-r,d=e,t.moveTo(i,e),t.lineTo(f,l),t.lineTo(h,d),t.fill()),o&m.CornerPosition.leftBottom&&(f=i=a,l=(e=u+s)-r,h=i+r,d=e,t.moveTo(i,e),t.lineTo(f,l),t.lineTo(h,d),t.fill()),o&m.CornerPosition.rightTop&&(l=(e=u)+r,h=(f=i=a+n)-r,d=e,t.moveTo(i,e),t.lineTo(f,l),t.lineTo(h,d),t.fill()),t.closePath(),t.restore())}function zt(t,n,e,i,r){var o,e,a,a,u,s,c;!r.cellOverflowLayout&&0<e.length&&(o=e.filter(function(t){return g(t.position)||t.position===z.IconPosition.left}),e=e.filter(function(t){return t.position===z.IconPosition.right}),0<(a=o.concat(e)).length)&&(un(a,r),t)&&(a=sn(n.clone(),r),t.save(),t.rect(a.x,a.y,a.width,a.height),t.clip(),t.beginPath(),s=u=a.x,c=a.x+a.width,0<o.length&&(s=u=Kt(t,o,a,i,r)),0<e.length&&(c=u=Qt(t,e,a,i,r)),t.restore(),n.width=n.x+n.width-(a.x+a.width-c)-s,n.x=s)}function Yt(t,n,e,i,r){var o,e,a,u;t&&0<e.length&&(o=e.filter(function(t){return t.position===z.IconPosition.outsideLeft&&Ut(t)}),e=e.filter(function(t){return t.position===z.IconPosition.outsideRight&&Ut(t)}),a=3,u=n.x,0<o.length||0<e.length)&&(un(o,r),un(e,r),2===r.columnHeaderFitMode&&r.cornerX&&((n=n.clone()).height=n.height-(r.cornerY-n.y)-1,n.y=r.cornerY-1),0<o.length&&(n.x=u-3,Zt(t,o,n,i,r)),0<e.length)&&(n.x=u+3,Wt(t,e,n,i,r))}function Zt(t,n,e,i,r){Jt(t,n,e.x,e,i,r)}function Wt(t,n,e,i,r){Xt(t,n,e.x+e.width,e,i,r)}function Qt(t,n,e,i,r){return Jt(t,n,e.x+e.width,e,i,r)}function Jt(t,n,e,i,r,o){var a,u,s,c,a,u;for(e-=on(o),s=n.length-1;0<=s;s--)e-=c=p(o,n[s],"width"),$t(t,n[s],e,i.y,c,i.height,o,i,r);return e}function Kt(t,n,e,i,r){return Xt(t,n,e.x,e,i,r)}function Xt(t,n,e,i,r,o){var a,u,s,c,a,u;for(e+=on(o),s=0;s<n.length;s++)c=p(o,n[s],"width"),$t(t,n[s],e,i.y,c,i.height,o,i,r),e+=c;return e}function qt(t,n){var e,i,r,o,n,a,t,u,u,n,e=n.ctx,i=n.style,r=n.context,o=n.textRect,n=n.availRect;!g(i.decoration)&&e&&(a="beforeFillTextArea"===t?z.IconPosition.leftOfText:z.IconPosition.rightOfText,t=i.decoration.icons&&i.decoration.icons.filter(function(t){return t.position===a&&Ut(t)}))&&0<t.length&&(un(t,r),2===r.columnHeaderFitMode&&r.cornerX&&(u=r.cellRect.x+r.cellRect.width-(n.x+n.width),(n=n.clone()).width=r.cornerX-n.x-u,n.height=n.height-(r.cornerY-n.y)-1,n.y=r.cornerY-1),u=void 0,n=en(n,o,a),e.save(),e.rect(n.x,n.y,n.width,n.height),e.clip(),e.beginPath(),a===z.IconPosition.leftOfText?(u=Qt(e,t,n,i.vAlign,r),o.x=u):(u=Kt(e,t,n,i.vAlign,r),o.width=u-o.x),e.restore())}function $t(t,n,e,i,r,o,a,u,s){var c,f,l,e,i,r,h,o,n,e,s,a,d;t.save(),t.beginPath(),t.rect(e,i,r,o),t.clip(),c=0,f=an(a),l=n.src,f.jt(l)?f.qh(l)&&(e=new lt.Rect(e,i,r,o),i=p(a,n,"width"),r=p(a,n,"height"),o=rn(e,h=new lt.Rect(0,0,i,r),s,on(a)),e=(n=f.Ot(l)).width,s=n.height,lt.mt.Tt.msie&&(R[l]||(n.style.position="absolute",n.style.left="-10000px",n.style.top="-100000px",document.body.appendChild(n),R[l]={width:n.width,height:n.height},document.body.removeChild(n)),e=R[l].width,s=R[l].height),u&&lt.mt.Tt.msie&&o.x+o.width>u.x+u.width?0<(a=c=u.x+u.width-o.x)&&t.drawImage(n,0,0,a*(d=e/i),s,o.x,o.y,a,r):t.drawImage(n,0,0,e,s,o.x,o.y,c=i,r)):f.Rt(l,"anonymous"),t.restore()}function tn(t){var n=t.context,e=t.style,t=t.externals;!n.cellOverflowLayout&&ht.W.Xue(e)&&(t.left=t.left.concat(nn(n,e,z.IconPosition.leftOfText)),t.right=t.right.concat(nn(n,e,z.IconPosition.rightOfText)))}function nn(n,t,e){return t.decoration.icons.filter(function(t){return t.position===e}).map(function(t){return{width:p(n,t,"width"),height:p(n,t,"height")}})}function en(t,n,e){switch(e){case z.IconPosition.leftOfText:return new lt.Rect(t.x,t.y,n.x-t.x,t.height);case z.IconPosition.rightOfText:return new lt.Rect(n.x+n.width,t.y,t.x+t.width-n.x-n.width,t.height)}}function rn(t,n,e,i){var r,o=2*i;switch(e){case z.VerticalAlign.top:r=0+o;break;case z.VerticalAlign.bottom:r=Math.max(0,t.height-n.height)-o;break;default:r=Math.max(0,(t.height-n.height)/2)}return new lt.Rect(t.x,t.y+r,Math.min(n.width,t.width),Math.min(n.height,t.height))}function on(t){return q(t)?t.printZoomFactor:t.sheet.zoom()}function p(t,n,e){var n=n[e],e=on(t);return(n=g(n)||isNaN(n)||n<=0?12:n)*e}function an(t){var n=t.sheet,e;return n.MC||t.imageLoader||n.BO()}function un(t,n){for(var e,i,r,e=an(n),i=0;i<t.length;i++)(r=t[i].src)&&e.Rt(r,"anonymous")}function sn(t,n){return 2===n.columnHeaderFitMode&&n.cornerX&&(t.width=n.cornerX-t.x,t.height=t.height-(n.cornerY-t.y)-1,t.y=n.cornerY-1),t}function cn(t){ln(t,"width")}function fn(t){ln(t,"height")}function ln(t,n){var e,i,r,o,a,e=t.cellStyle;if(e.decoration&&e.decoration.icons&&0!==e.decoration.icons.length){for(i=e.decoration.icons,o=r=0;o<i.length;o++)a=i[o],ht.W.Kue(a)&&(r+=p(t.context,a,n));t.value=r}}Object.defineProperty(u,"__esModule",{value:!0}),u.Context=u.Base=u.paintStyleDecorationOutSideIcons=u.paintDecoration=u.clearCacheTimer=u.wordWrapInfoCache=void 0,c=t("Common"),v=t("./dist/core/util/domUtil.js"),lt=t("./dist/core/util/common.js"),ht=t("./dist/core/worksheet/stylehelper.js"),m=t("./dist/core/core.interface.js"),z=t("./dist/core/core.enum.js"),i=t("./dist/core/celltype/celltype.ns.js"),l=t("CalcEngine"),h=c.Common.CultureManager,d=c.Common.st,M=c.Common.ct,t=c.Common.lt,Y=t.ht,o=t.dt,Z=lt.mt.vt,yt=lt.mt.gt,W=lt.mt.pt,dt=lt.mt.bt,C=lt.mt.yt,S=lt.mt.wt,Q=lt.mt.Mt,B=lt.mt.Ct,T=lt.mt.St,g=c.Common.lt.ht,F=v.GC$.extend,x=lt.mt.Tt,y="left",J="right",K="center",X="alphabetic",D=16,L="string",b="number",_=null,A=void 0,vt=Math.floor,N=Math.ceil,mt=Math.sin,gt=Math.cos,Mt=Math.tan,r=Math.PI,pt=Math.abs,a="none",s="General",j="text",bt=Math.max,E=.7,O={},k="...",R={},U=P={top:0,0:"top",right:1,1:"right",bottom:2,2:"bottom",left:3,3:"left"},w.At=function(t){var t,n,e,t=t.split("e")[1];if(t&&0<t.length&&("+"===t[0]?n=!0:"-"===t[0]&&(n=!1),e=t.slice(1)),void 0!==n)return{isAdd:n,length:e}},w.It=function(t,n,e){var i,r,i=w.xt,r=i[n+e];return r||(r=Q(t,n,e),i[n+e]=r),r},w.Nt=function(t,n,e,i,r){var o,r,a,a,r,a,u,s,s,c,u,f,a,l,h,o,d,v,m,g,p,o=i.font;if(e=e-1-rt(i,3)*r,r=i.textIndent&&0!==i.textIndent,a=i.isVerticalText,typeof n!==b||!0===i.shrinkToFit||a||r)return i._autoFormatter;if(a=n<0,n=pt(n),r=a?w.It(t,o,"-"):0,a=n.toString(),(u=w.At(a))&&!1===u.isAdd&&(s=lt.mt.toPlainString(n)).split(".")[1].length<10&&(a=s,u=A),s=void 0,c=w.Dt(i._autoFormatter,n),u)return s=u.length.toString().length,s=bt(s,2),w._t(t,e,i,s,r,u.isAdd,c);if(u=r,f=w.It(t,o,"0"),a=a.split("."),u+=h=f*(l=Math.round(n).toString().length),o=w.It(t,o,"."),d=void 0,h<=e){if(!a[1]||0===a[1].length)return i._autoFormatter;if((u=u+a[1].length*f+o)<=e)return i._autoFormatter;if(n<.001)return s=a[1].length.toString().length,s=bt(s,2),w._t(t,e,i,s,r,!1,c);for(m=Math.floor((v=e-r-h-o)/f),d="0",0<(m=Math.min(m,a[1].length))&&(d+="."),g=0;g<m;g++)d+="0";return d}return s=(p=Math.round(n)).toString().length.toString().length,s=bt(s,2),w._t(t,e,i,s,r,!0,c)},w._t=function(t,n,e,i,r,o,a){var e,u,s,c,f,l,h,n,r,d,v,m,e=e.font,u=w.It(t,e,"0"),s=w.It(t,e,"E"),c=w.It(t,e,"+"),f=w.It(t,e,"-"),l,h,n=n-r-i*u-s-(o?c:f)-u,r=n-w.It(t,e,".");if(r<=u)return o?"0E+00":0<n?"0E-00":"0";for(d=Math.floor(r/u),d=Math.min(d,a),v="0",m=0;m<d;m++)0===m&&(v+="."),v+="0";return v+=o?"E+00":"E-00"},w.Et=function(t,n,e,i,r){var o,r,a,u,s,r,c,f,l,o=i.font;if(e=e-1-rt(i,3)*r,r=i.textIndent||0,u=e,(u=1!==(a=i.hAlign)&&0<r?e-8*r:e)<(s=Q(t,i.font,n))){for(r=w.It(t,o,"#"),c=Math.floor(e/r),f="",l=0;l<c;l++)f+="#";return f}return n},w.nt=function(t,n,e,i,r,o,a,u){var s,c,f,l,h,d,v,m,g,p,b,w;if(o&&"none"!==o&&u)try{u.jt(o)?(s=u.Ot(o),c=void 0,x.msie&&((c=document.createElement("div")).appendChild(s),document.body.appendChild(c)),f=s.width,l=s.height,x.msie&&(c.removeChild(s),document.body.removeChild(c)),d=h=0,v=f,m=l,g=i,p=r,b=n,w=e,1===a?(v=f<=i?f:i,m=l<=r?l:r,b=f<i&&0<f?N(n+i/2-f/2):n,w=l<r&&0<l?N(e+r/2-l/2):e,g=v,p=m):2===a?0<r&&0<l&&f/l<i/r?b=n+i/2-(g=f/l*r)/2:0<i&&0<f&&l/f<r/i&&(w=e+r/2-(p=l/f*i)/2):3===a&&(g=v=f<=i?f:i,p=m=l<=r?l:r),t.drawImage(s,0,0,v,m,b,w,g,p)):u.Rt(o)}catch(t){}},w.Bt=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,b,y,M,C,S,C,T,A,I,S,t,C,x,N,k,t,o=0,a=r&&r.sheet,u=r.sheetArea,s=r.row,c=r.col,f=e.textIndent,l=e.hAlign,h=e.isVerticalText,d,v=1===u&&1===a.Lt(c)?-90:e.textOrientation,m=e.borderTop||e.borderBottom||e.borderLeft||e.borderRight,w=e.font;if(v&&-90<=v&&v<=90&&(b=pt(v*Math.PI/180),p=mt(b),b=gt(b)),a&&typeof n===L&&n)if(y=[],M=void 0,t&&t.richText)if(C=e.formatter||e._autoFormatter,C=(S=a.getCellType(s,c,u)).Ft(C,t.text),Pt(M=F(!0,[],S.Pt(t,n,C,w,e.foreColor)),w,i),h)if(e.wordWrap){if(T=a.Gt(s,u),(A=a.Ut.findSpan(s,c,u))&&A.row>=s&&A.col>=c&&1<A.rowCount)for(I=s+1;I<s+A.rowCount;I++)T+=a.Gt(I,u);for((S=0)<f&&(S=8*f*i),0<(t=wt(e,0))&&(T-=t),0<(C=wt(e,2))&&(T-=C),y=lt.q.Ht(n,++T-rt(e,3)-S,w,M,h),g=0;g<y.length;g++)o+=at(y[g].textInfos,w,i)}else o=at(M,w,i);else{if(e.wordWrap){for(x=n.split(/\r\n|\r|\n/),g=0;g<x.length;g++)y.push((0,lt.zt)(x[g]));for(y=lt.q.Vt(y,lt.q.Yt(M)),g=0;g<y.length;g++)o=Math.max(o,st(y[g],w,i,h,!0))}else o=ut(M,w,i);0<f&&4!==l&&(o+=1===l?8*f*2:8*f),ot(a,s,c,r.sheetArea)&&(o+=Ct(a))}else if(y=n.split(/\r\n|\r|\n/),N=e.font,k=Z(N)/i,h)if(e.wordWrap)for(g=0;g<y.length;g++)o+=k;else o=k;else{if(e.wordWrap){if(v)return t=a.Gt(s,u),lt.q.Zt(s,c,p,b,n,N,t);for(g=0;g<y.length;g++)o=Math.max(o,lt.q.Wt(y[g],N,!0)/i)}else o=v?m?(4+k)/p:b*(a.Qt(n,N)/i)+k*p:4===e.hAlign?a.Jt.Kt(c,u):a.Qt(n,N)/i;0<f&&4!==l&&(o+=1===l?8*f*2:8*f),ot(a,s,c,r.sheetArea)&&(o+=D)}return o},w.Xt=function(t,n,e,i){for(var r,o,a,u,r=t.Jt.Kt(e,i),o=e+1;o<t.getColumnCount(i)&&(a=t.Jt.qt(n,o,i),u=t.Jt.$t(n,o,i,1,a),g(u))&&!a.watermark&&!(a.cellType&&"1"!==a.cellType.typeName||a.cellButtons&&0<a.cellButtons.length||ht.W.Jue(a))&&4===a.hAlign;o++)r+=t.Jt.Kt(o,i);return r},w.tn=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,N,k,I,A,_,A,D,_,j,E,l,O,R,o=0,u=r&&r.sheet,s=e.font,c=e.isVerticalText,f=e.textIndent,l=e.vAlign,h=e.textOrientation,d=r.row,v=r.col,m=r.sheetArea;if(h&&-90<=h&&h<=90&&(N=pt(h*Math.PI/180),x=mt(N),N=gt(N)),u&&typeof n===L&&n)if(k=[],I=void 0,t&&t.richText)if(A=e.formatter||e._autoFormatter,A=(_=u.getCellType(d,v,m)).Ft(A,t.text),Pt(I=F(!0,[],_.Pt(t,n,A,s,e.foreColor)),s,i),c){if(e.wordWrap){for(D=n.split(/\r\n|\r|\n/),a=0;a<D.length;a++)k.push((0,lt.zt)(D[a]));for(k=lt.q.Vt(k,lt.q.Yt(I)),a=0;a<k.length;a++)o=Math.max(o,st(k[a],s,i,c,!0))}else o=ut(I,s,i,c);0<f&&(o+=1===l?8*f*2:8*f)}else if(e.wordWrap){if(g=u.nn(v,m),(w=u.Ut.findSpan(d,v,m))&&w.row>=d&&w.col>=v&&1<w.colCount)for(y=v+1;y<v+w.colCount;y++)g+=u.nn(y,m);for((C=0)<f&&(C=8*f*i),S=wt(e,1),0<(T=wt(e,3))&&(g-=T),0<S&&(g-=S),k=lt.q.Ht(n,++g-rt(e,3)-C,s,I),a=0;a<k.length;a++)o+=at(k[a].textInfos,s,i)}else o=at(I,s,i);else if(_=e.font,j=Z(_)/i,c){if(e.wordWrap)for(k=n.split(/\r\n|\r|\n/),a=0;a<k.length;a++)E=k[a].length*j,o=Math.max(o,E);else o=n.length*j;0<f&&(o+=1===l?8*f*2:8*f)}else if(e.wordWrap){if(m=r.sheetArea,g=4===e.hAlign?this.Xt(r.sheet,d,v,m):u.nn(v,m),p=u.Gt(d,m),(w=u.Ut.findSpan(d,v,m))&&w.row>=d&&w.col>=v&&1<w.colCount){for(y=v+1;y<v+w.colCount;y++)g+=u.nn(y,m);for(M=d+1;M<d+w.colCount;M++)p+=u.Gt(M,m)}if((C=0)<f&&(C=8*f*i),S=wt(e,1),0<(T=wt(e,3))&&(g-=T),0<S&&(g-=S),0<(A=wt(e,0))&&(p-=A),0<(I=wt(e,2))&&(p-=I),e.cellButtons&&0<e.cellButtons.length&&(g-=Tt(r,e)),ht.W.Jue(e)&&(g-=At(r,e)),e.cellType&&e.cellType.Tfe&&(g-=e.cellType.Tfe(i)),1===m&&(O=!!((l=u.rowFilter&&u.rowFilter())&&l.rn(d,v,m)&&l.filterButtonVisible(v)))&&(g-=u.an(new lt.Rect(0,0,g,p),m).width),h)return k=lt.q.un(n,R=(p-j*N)/x,_),o=x*(b=u.Qt(k[0],_)/i)+j*N;o=(k=B(t)?[n]:lt.q.un(n,g-rt(e,3)-C,_)).length*j}else o=h?x*(b=u.Qt(n,_)/i)+j*N:j;return o},w.cn=function(t,n,e,i,r,o,a,u,s,c,f){var l;1===s?(t.beginPath(),(l=t.createLinearGradient(n,e+1,n,e+r-2)).addColorStop(0,u.borderLeftColor),l.addColorStop(1,u.borderRightColor),t.strokeStyle!==l&&(t.strokeStyle=l),o.borderLeft||(t.moveTo(n+.5,e),t.lineTo(n+.5,e+r)),o.borderRight||(t.moveTo(n+i-.5,e),t.lineTo(n+i-.5,e+r)),c&&!o.borderTop&&(t.moveTo(n,e+.5),t.lineTo(n+i,e+.5)),t.stroke(),u.borderBottomWidth&&!o.borderBottom&&(t.beginPath(),t.strokeStyle!==u.borderBottomColor&&(t.strokeStyle=u.borderBottomColor),t.moveTo(n+1,e+r-.5),t.lineTo(n+i,e+r-.5),t.stroke())):(t.beginPath(),(l=t.createLinearGradient(n,e,n+i-2,e)).addColorStop(0,u.borderTopColor),l.addColorStop(1,u.borderBottomColor),t.strokeStyle!==l&&(t.strokeStyle=l),o.borderTop||(t.moveTo(n,e+.5),t.lineTo(n+i,e+.5)),o.borderBottom||(t.moveTo(n,e+r-.5),t.lineTo(n+i,e+r-.5)),f&&!o.borderLeft&&(t.moveTo(n+.5,e),t.lineTo(n+.5,e+r)),t.stroke(),u.borderRightWidth&&!o.borderRight&&(t.beginPath(),t.strokeStyle!==u.borderRightColor&&(t.strokeStyle=u.borderRightColor),t.moveTo(n+i-.5,e+1),t.lineTo(n+i-.5,e+r),t.stroke()))},w.hn=function(t,n){var n,n=2===n?"active":4===n?"inactive":0===n?"disabled":"auto";(0,v.GC$)(t).css("ime-mode",n)},w.dn=function(t,n,e,i,r,o,a){var u,s,s,c,f;return!!(n&&"SparklineExValue"===n.typeName&&(s=(u=a.sheet)&&u.parent)&&(s=s.getSparklineEx(n.name)))&&(f={zoomFactor:c=q(a)?a.printZoomFactor:u.zoom(),sheet:u,rowIndex:a.row,columnIndex:a.col},2===a.columnHeaderFitMode&&(r=u.getColumnWidth(a.col,a.sheetArea)+1),s.paint(t,n.value,e,i,r,o,f),!0)},w.xt={},w.Dt=function(t,n){var e,t,n,n,t,t;return t&&t.vn&&(t=(e=t.vn(n)).format(n))&&t[1]&&"decimalSeparator"===t[1].type?(n=t[2])&&n.type===b?(n=n.value,t=(t=t[3])&&"exponent"===t.type&&t.value&&-1<t.value.indexOf("E"),!Y(n)&&t?n.length:5):0:5},w.gn=wt,I=w,u.Context=I,G={9001:65087,9002:65088,10216:65087,10217:65088,10092:65087,10093:65088,10096:65087,10097:65088,12296:65087,12297:65088,9121:65089,9126:65090,12300:65089,12301:65090,65378:65089,65379:65090,40:9180,41:9181,91:9140,93:9141,65339:9140,65341:9141,123:9182,125:9183,10100:9182,10101:9183,65115:9182,65116:9183,65371:9182,65373:9183,12310:65047,12311:65048,10098:65081,10099:65082,12308:65081,12309:65082,65117:65081,65118:65082,12304:65083,12305:65084,10218:65085,10219:65086,12298:65085,12299:65086,12302:65091,12303:65092},f.prototype.pn=function(t,n,e,i){var t={ctx:t,options:{rect:n,context:e,value:i}};return f.et(e.sheet,"paintCellPadding",t),t.options.rect},f.prototype.bn=function(t,n,e){var n={context:t,options:{dom:n,cellRect:e,contentRect:e.clone(),leftExternalRect:new lt.Rect(0,0,0,0),rightExternalRect:new lt.Rect(0,0,0,0)}};return f.et(t.sheet,"onCreateCellEditor",n),n.options.dom},f.prototype.yn=function(t,n,e){var n={ctx:null,options:{rect:n.clone(),context:t,value:null,style:e}};return f.et(t.sheet,"getCellButtonRect",n),n.options.rect},f.prototype.wn=function(t,n,e,i){var n={context:t,options:{dom:n,cellRect:e,cellStyle:i,contentRect:e.clone(),leftExternalRect:new lt.Rect(0,0,0,0),rightExternalRect:new lt.Rect(0,0,0,0)}};return f.et(t.sheet,"onActivateCellEditor",n),n},f.prototype.Mn=function(t,n,e,i){var n={context:t,contentContainer:n,editorBounds:e,cellStyle:i,contentRect:e.clone(),leftExternalRect:new lt.Rect(0,0,0,0),rightExternalRect:new lt.Rect(0,0,0,0)};return f.et(t.sheet,"onUpdateContainer",n),n},f.prototype.Cn=function(t,n,e){var n={context:t,options:{dom:n,cellRect:e,contentRect:e.clone(),leftExternalRect:new lt.Rect(0,0,0,0),rightExternalRect:new lt.Rect(0,0,0,0)}};return f.et(t.sheet,"onDeactivateCellEditor",n),n.options.dom},f.prototype.Sn=function(t,n,e){var i=this;i.deactivateEditor(t,n),i.Cn(n,t,e)},f.prototype.Tn=function(t,n,e,i){var r,o,a,u,i,u,o,i,o,u,s,r=e.labelOptions;r&&(o=i.sheet,a=e.watermark)&&(u=r.visibility,i=o.getText(i.row,i.col,i.sheetArea),1!==u)&&(2!==u&&u!==A||""!==i)&&(u=o.zoom(),i=void 0,i=(o=r.font)?ht.W.V(o,u):ht.W.V(e.font,1),o=Z(i.font),u=Dt(n,e),s=void 0,s=_t(e,n)?Et(n,e,i,o):s)&&(t.save(),t.textAlign=jt(r.alignment),t.textBaseline="alphabetic",dt(t,i.font),t.fillStyle=r.foreColor||e.foreColor||"grey",t.rect(u.x,u.y,u.width,u.height),t.clip(),t.beginPath(),t.fillText(a,s.x,s.y),t.restore())},f.prototype.An=function(t,n,e){var i,r,o,a,n,i=t.clone(),r=wt(n,0,!1,e),o=wt(n,1,!1,e),a=wt(n,2,!1,e),n=wt(n,3,!1,e);return 0<r&&(i.y+=r,i.height-=r),0<a&&(i.height-=a),0<n&&(i.x+=n,i.width-=n),0<o&&(i.width-=o),o+n>=t.width&&(i.width=0),r+a>=t.height&&(i.height=0),i},f.prototype.In=function(t,n,e,i){var r,o,r,r=this,o=q(i)?i.printZoomFactor:i.sheet.zoom();return n=r.An(n,e,o),f.et(i.sheet,"getCellPaddingRect",r={ctx:t,options:{rect:n,context:i}}),r.options.rect},f.prototype.xn=function(t,n,e,i){var r,o,i,a,u,s,c,o,f,l,a,n,h,d,r=e.labelOptions;r&&(i=(o=i.sheet).getText(i.row,i.col,i.sheetArea),a=e.watermark,1!==(u=r.visibility))&&a&&(s=r.font||e.font||o.Dn.Nn(),1!==(c=o.zoom())&&(s=o.Dn._n(s)),o=Z(s),f=_t(e,n)?Ot(n,e):f)&&((l=(0,v.GC$)(lt.mt.En("span"))).text(a),n=f.height-o,h=f.y+((a=(2===u||u===A)&&""===i)&&0<n?n:0),l.css({display:"block",position:"absolute",left:f.x,top:h,width:f.width,height:f.height,font:C(s),color:r.foreColor||e.foreColor||"grey",textAlign:jt(r.alignment),overflow:"hidden",whiteSpace:"nowrap"}).attr("gcUIElement","gcEditorLabel"),(0,v.GC$)(t).append(l),a)&&(d=setInterval(function(){h--,l.css("top",h),h<=f.y&&clearInterval(d)},20))},f.prototype.jn=function(t){var n,e,i,r,i,n=this,e=lt.mt.En("div");return e.style.cssText="position: absolute; margin: 0;padding: 0 ;overflow: hidden; box-sizing: content-box;resize: none;outline: none;border: 2px #5292f7 solid;box-shadow: 1px 2px 5px rgba(0,0,0,0.4);background-color: white",(i=lt.mt.En("div")).style.cssText="position: absolute; outline: none; border: none",(0,v.GC$)(e).append((0,v.GC$)(i)),(r=n.createEditorElement(t,e))&&(0,v.GC$)(i).append((0,v.GC$)(r)),i=t.sheetArea,n.bn(t,e,t.sheet.getCellRect(t.row,t.col,1===i?-1:A,2===i?-1:A)),e},f.prototype.On=function(t,n,e,i){var r,e,e,o,a,u,e,s,o,c;t&&t.firstChild&&(r=this,Nt(t,n,e=Ft(e),i),o=(e=r.wn(i,t,e,n)).options.contentRect,a=e.options.cellRect,u=e.options.leftExternalRect,e=e.options.rightExternalRect,r.xn&&r.xn(t,o,n,i),s=i.sheet.zoom(),o=nt(o=r.An?r.An(o,n,s):o,u,e),c=t.firstChild,(0,v.GC$)(c).css({left:(+(0,v.GC$)(c).css("left").replace("px","")||0)+wt(n,3,!1,s),top:(+(0,v.GC$)(c).css("top").replace("px","")||0)+wt(n,0,!1,s)}),r.activateEditor(t.firstChild.firstChild,n,o,i,a,u,e))},f.prototype.updateEditorContainer=function(t,n,e,i,r,o,a){var n,t,n,u,s,t;t&&n&&(t=(n=t.parentNode)?n.parentNode:A)&&r&&(n=(0,v.GC$)(t),u=r.width,s=r.height,0<u&&(n.width(u),t=t.lastChild,e)&&"gcEditorLabel"===t.getAttribute("gcUIElement")&&(0,v.GC$)(t).width(u-wt(e,3,!0)-wt(e,1,!0)-2),0<s&&n.height(s),Y(r.x)||n.css("left",r.x+"px"),Y(r.y)||n.css("top",r.y+"px"))},f.prototype.Rn=function(t,n,e,i){var r,o,e,t,e,a,u,t,o,a,a,u,t,s,c,e,r=this,o=t.firstChild,e=Ft(e);Nt(t,n,e,i),e=(t=r.Mn(i,o,e,n)).editorBounds,a=t.contentRect,u=t.leftExternalRect,t=t.rightExternalRect,o=o.firstChild,a=nt(a=r.An?r.An(a,n,i.sheet.zoom()):a,u,t),a=r.updateEditor(o,n,a,i,e,u,t),u={width:u.width,height:u.height},t={width:t.width,height:t.height},c=!isNaN(a&&a.width)&&a.width+u.width+t.width>e.width?a.width+u.width+t.width:e.width,e=!isNaN(a&&a.height)&&a.height+u.height+t.height>e.height?a.height+u.height+t.height:e.height,r.updateEditorContainer(o,a,n,i,s={width:c,height:e},u,t)},f.prototype.Bn=function(t,n,e,i,r){return this.getCellAndPaddingHitInfo(t,n,e,i,r)},f.prototype.Ln=function(t,n,e,i,r){var o,t,o=Tt(r,e)+St(r)+At(r,e),t=this.getAutoFitWidth(t,n,e,i,r);return 0<t&&(o+=t+wt(e,3,!1)+wt(e,1,!1)),o},f.prototype.Fn=function(t,n,e,i,r){var o,t,o=0,t=this.getAutoFitHeight(t,n,e,i,r);return 0<t&&(o+=t+wt(e,0,!1)+wt(e,2,!1)),o=Math.max(xt(r,e),o),Math.max(It(r,e),o)},f.prototype.paintValue=function(t,n,e,i,r,o,a,u){var s,c,f,l,l,s=this,c={};u.quotePrefix=a.quotePrefix,(f=this.format(S(n),a.formatter||a._autoFormatter,c,u))&&(l=new lt.Rect(e,i,r,o),this.adjustRectForIconSet(a.hAlign,u.sheet,u.row,u.col,u.sheetArea,l,c.content&&this.hasInfilling(c.content)),e=l.x,r=l.width,l=s.Pn(t,f,a,u,e,i,r,o),this.paintText(t,n,e,i,r,o,a,u,f,c,A,l.externals))},f.prototype.Gn=function(t,n,e,i){var t=0<t?8*t*i:0;return t=n&&n.Un(e)?0:t},f.prototype.Ft=function(t,n){return!!(!t||o(t,L)&&t===s||t&&t.formatString&&t.formatString()===s)||!(n&&(!isNaN(n)||"TRUE"===n.toUpperCase()||"FALSE"===n.toUpperCase())&&"@"!==t)},f.prototype.Hn=function(t){for(var n,e,n=0,e=0;e<t.length;e++)n+=t[e].width;return n},f.prototype.zn=function(t){for(var n,e,n=0,e=0;e<t.length;e++)n+=t[e].height;return n},f.prototype.Vn=function(t,n,e,i,r){var o;f.et(n.sheet,"beforePaintLabel",{ctx:t,options:{rect:e,context:n,value:i,style:r}})},f.prototype.Pn=function(t,n,e,i,r,o,a,u){var t={ctx:t,text:n,rect:new lt.Rect(r,o,a,u),style:e,context:i,externals:{left:[],right:[]}};return f.et(i.sheet,"beforePaintText",t),tn(t),t},f.prototype.Yn=function(t,n,e,i,r,o,a,u,s){var t={ctx:t,style:n,context:e,textRect:new lt.Rect(i,r,o,a),availRect:u};return f.et(e.sheet,s,t),qt(s,t),t},f.prototype.Zn=function(t,n,e,i,r,o,a,u){return this.Yn(t,n,e,i,r,o,a,u,"beforeFillTextArea")},f.prototype.Wn=function(t,n,e,i,r,o,a,u){return this.Yn(t,n,e,i,r,o,a,u,"afterFillTextArea")},f.prototype.paintText=function(t,n,e,i,r,o,a,u,s,c,f,l){var h,d,v,m,g,h=this;t.save(),t.beginPath(),d=a.textOrientation,v=a.textIndent&&0!==a.textIndent,m=a.hAlign,g=a.isVerticalText&&4!==m,4===m&&(d=0,v=!1),n&&n.richText&&0<n.richText.length||g?h.Qn(t,n,e,i,r,o,a,u,s,c,f,l):0!==d&&!Y(d)&&-90<=d&&d<=90&&!v&&!g?h.Kn(t,n,e,i,r,o,a,u,s,c,f,l):h.Jn(t,n,e,i,r,o,a,u,s,c,f,l),t.restore()},f.prototype.Xn=function(t,n,e,i,r,o,a,u,s,c){for(var f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,f=n.sheet,l=n.row,h=n.col,d=r.vAlign,v=n.sheetArea,m=0;m<e.length;m++)if(g=e[m].text,p=i[m].lineHeight,b=1===d?0:u,w=this.qn(t,"0"),y="",(M=o)-1-2-b<g.length*p){if(M<3*w)c.push(0),y=k;else if(C=vt((M-1-2-3*w-(1===d?0:u))/p),(S=0)===d){for(T=0;T<C;T++)y+=g[T];A=y.length,3*w+((y+=k).length-3)*p+u>M-1-2?(y=y.substring(0,y.length-4)+k,c.push(y.split(k)[0].length)):c.push(A)}else if(1===d){for(I=0;I<N(C/2);I++)y+=x=g.charAt(I),S=I;for(A=y.length,y+=k,I=N(g.length-C/2);I<g.length;I++)y+=x=g.charAt(I);3*w+(y.length-3)*p+u>M-1-2?(y=y.replace(g[S],""),c.push(y.split(k)[0].length)):c.push(A),s[m].y=a+(o-(3*w+(y.length-3)*p))/2}else{for(c.push(0),T=g.length-1;T>=g.length-C;T--)y=g[T]+y;3*w+((y=k+y).length-3)*p+u>M-1-2&&(y=y.replace(g[g.length-C],"")),s[m].y=a+o-u-(3*w+(y.length-3)*p)-2}e[m].textInfos[0].text=y,f.Ut.$n(l,h,g,v)}else f.Ut.$n(l,h,null,v)},f.prototype.Qn=function(t,n,e,i,r,o,a,u,s,c,f,l){var h,d,v,m,g,p,b,w,y,M,C,w,S,v,m,l,v,T,A,m,p,I,x,N,C,l,k,h=this,d=new lt.Rect(e,i,r,o),v=u.sheet?u.sheet.zoom():1,m=u.printZoomFactor;if(m=q(u)?m:_,g=h.Gn(a.textIndent,u.sheet.outlineColumn,u.col,m?m*v:v),p=u.cellOverflowLayout&&u.cellOverflowLayout.expandedWidth,b=a.hAlign,w=a.formatter||a._autoFormatter,3===b&&(b=yt(b,n,w)),M=!!(y=a.isVerticalText&&4!==b)&&W(s),C=a.font,w=h.Ft(w,n.text),S=F(!0,[],h.Pt(n,s,w,C,a.foreColor)),(0,lt.resetFillStyle)(t,u.sheet,a,f),n&&n.richText&&0<n.richText.length&&h.te(S,C,v,m),m=v=0,l&&(v=h.Hn(l.left),m=h.Hn(l.right)),l=v+m,v={left:v,right:m},!a.wordWrap&&a.shrinkToFit&&(4===a.hAlign?h.ne(S,p-l,o,a,C,1,y):h.ne(S,r-l,o,a,C,1,y)),T=h.ee(t,s,a.font,y?o:r-l,g,y?a.vAlign:a.hAlign,a.wordWrap,y,S),A=h.re(T,a,b,f),m=h.oe(t,a,e,i,r,o,a.wordWrap,u.cellOverflowLayout,b,g,y,T[0].textLength,A[0].lineHeight),p=!1,a.showEllipsis&&y&&!n.richText&&(p=!0),I=[],I=4===b?h.ae(e,i,u.cellOverflowLayout.expandedWidth,o,b,a.vAlign,g,y,M,T,A,v,p,a):h.ae(e,i,r,o,b,a.vAlign,g,y,M,T,A,v,p,a),x=T.length,N=[],p&&c&&(c.content&&1===c.content.length&&"text"===c.content[0].type||!c.content&&1===T.length&&T[0].text)&&this.Xn(t,u,T,A,a,o,i,g,I,N),1===x&&c&&!w)h.ue(t,u.sheet,s,c,I[0].x,I[0].y,r,o,b,a,m.width,m.height,g,y,T[0].textLength,u,v,d);else{for(C=h.se(T),l=I[0].x,t.textAlign===K?l-=C/2:t.textAlign===J&&(l-=C),h.Zn(t,a,u,l,I[0].y,C,0,d),k=0;k<x;k++)h.ce(t,u.sheet,I[k].x,I[k].y,A[k],b,T[k],N[k]);h.Zn(t,a,u,l,I[0].x,C,0,d)}},f.prototype.se=function(t){for(var n,e,n=t[0].textLength,e=0;e<t.length;e++)n=bt(n,t[e].textLength);return n},f.prototype.qn=V,f.prototype.fe=function(t,n,e,i,r,o,a){var u,s,e,c,f,t,l,h,r,d,v,m,g,p,b,w,y,M,C,S,C,s=t.sheetArea,u=e,e=this.qn(i,u),c=t.sheet,f=t.row,t=t.col,l=r,h=0,r=this.qn(i,"0"),d;if(h=this.qn(i,k),l-1-2-(v=1===o?0:a)<e){if(m="",2===o)for(g=u.length-1;0<=g;g--){if(l-1-2-a<h){p=m.length,m=k+m.substring(1,p);break}m=(b=u.charAt(g))+m,h+=w=this.qn(i,b)}else if(1===o){for(y=N((l-h)/r),g=0;g<y/2;g++)m+=b=u.charAt(g);for(m+=k,g=vt(u.length-y/2);g<u.length;g++)m+=b=u.charAt(g);for(M=this.qn(i,m);l-1-2<M&&m!==k;)S=(C=m.split(k))[0],C=C[1],m=S.length>C.length?S.substring(0,S.length-1)+k+C:S+k+C.substring(1,C.length),M=this.qn(i,m)}else for(g=0;g<u.length;g++){if(l-1-2-a<h){p=m.length,m=m.substring(0,p-1)+k;break}m+=b=u.charAt(g),h+=w=this.qn(i,b)}n.content=[{value:m,type:"text"}],c.Ut.$n(f,t,u,s)}},f.prototype.Jn=function(t,n,e,i,r,o,a,u,s,c,f,l){var h,d,v,m,g,p,b,w,y,M,C,S,L,B,T,A,F,P,I,x,N,f,v,f,k,_,l,D,G,j,E,O,A,n,b,U,A,f,k,y,b,p,A,v,o,R,k,y,m,k,n,I,H,V,h=this,d=0,v=a.textIndent,m=a.wordWrap,g=a.hAlign,p=a.vAlign,b=a.shrinkToFit,w=a.textDecoration,y="left",M=2,C=2,S=a.font,L=0,B=[],T=0,A=u.sheet,F=new lt.Rect(e,i,r,o),P=u.cellOverflowLayout&&u.cellOverflowLayout.expandedWidth,I=u.offsetX;if(I=I||0,4===g&&(v=0),Y(u.fontInfo)&&(u.fontInfo=ht.W.V(a.font,A.zoom()),q(u))&&(u.fontInfo=ht.W.V(u.fontInfo.font,u.printZoomFactor)),x=parseInt(u.fontInfo.fontSize,10),Y(u.lineHeight)&&(u.lineHeight=Z(ht.W.V(a.font,A.zoom()).font,!1,W(s))),N=u.lineHeight,(0,lt.resetFillStyle)(t,A,a,f),f=A.zoom()||1,q(u)&&(f*=u.printZoomFactor),0<v&&(d=8*v*f),A.outlineColumn&&A.outlineColumn.Un(u.col)&&(d=0),3===g&&(g=yt(g,n,a.formatter||a._autoFormatter)),v=1,dt(t,S),k=f=0,l&&(f=h.Hn(l.left),k=h.Hn(l.right)),_=f+k,l={left:f,right:k},!m&&b){for(G={value:!1},j=void(D=0),E=0;E<3&&!1===G.value&&(O=t.measureText(s).width,D=bt(0,r-4-(1===g?0:d)-_),(D=4===g?bt(0,P-4-d-_):D)<O);E++)S=(j=ht.W.V(S,D/O,G,!0)).font,dt(t,S);j&&(v=x/j.fontSize,x=j.fontSize)}if(A=(A=A.parent&&A.parent.options.numbersFitMode===z.NumbersFitMode.overflow||!1)||(c&&c.content?!(!c.content||1!==c.content.length||"text"!==c.content[0].type):"string"==typeof n&&n===s),!m&&!b&&a.showEllipsis&&A&&this.fe(u,c,s,t,r,g,d),M+=d+f,1===g||4===g?(M=(r+f-k)/2,y=K):2===g&&(M=r-k-1-2,y=J,M=it(a,M-=d)),t.textAlign!==y&&(t.textAlign=y),n=0,m&&(n=r-_-(b=rt(a,3))-(1===g?2*d:d),4===g&&(n=P-_-b-d),--n,1<(T=(B=u.isPrinting?lt.q.un(s,n,S,!1,t):et(s,n,S,!1,t)).length))&&0!==p&&(L=(T-1)*N),C=(C+(N-(A=N/2-x/2+(U=8<x?vt((x-8)/5+2):1)-1)))/v,1===p?C=(o-L)/2+N/2-A:2===p&&(C=o-(L+2+A)/v),t.textBaseline!==X&&(t.textBaseline=X),y={x:(k=(f=u.cellOverflowLayout)&&f.layout)?k.x:e+1,y:k?k.y:i+1,width:k?k.width:r-2,height:k?k.height:o-2},f&&4===g&&(M+=(f.expandedWidth-r)/2),M+=I,b=k&&k.width>r||4===g,p=y.x,A=y.y,v=y.width,o=y.height,m)if(t.rect(p,A,v,o),t.clip(),t.beginPath(),R=i+C,1<T){for(k=e+M,t.textAlign===K?k-=n/2:t.textAlign===J&&(k-=n),h.Zn(t,a,u,k,R,n,N*T,F),E=0;E<T;E++)t.fillText(B[E],e+M,R),w&&(O=t.measureText(B[E]).width,h.le(t,w,e+M,R,O,x,U)),R+=N;h.Zn(t,a,u,k,R,n,N*T,F)}else h.he(t,s,c,e+M,i+C,g,v,d,w,U,x,u,a,l,F,b);else m=v-(e+1-p)<(y=Q(t,t.font,s)+_)||o<N||0!==I,4===g&&(m=!0),k=wt(a,0),n=wt(a,1),I=wt(a,2),H=wt(a,3),m||(1===g||4===g?f&&((V=y/2)>f.backgroundLeftWidth||V>f.backgroundRightWidth)&&(m=!0):(v<y+d+k+I||o<L+H+n)&&(m=!0)),m&&(t.rect(p,A,v,o),t.clip(),t.beginPath()),h.he(t,s,c,e+M,i+C,g,v,d,w,U,x,u,a,l,F,b)},f.prototype.Kn=function(t,L,B,n,e,i,r,o,a,u,F,s){var c,f,l,P,G,U,h,d,v,H,m,g,p,V,b,w,y,z,M,M,C,S,Y,T,Z,A,I,x,W,M,Q,J,K,M,N,k,X,q,_,D,j,$,tt,E,nt,et,it,rt,ot,O,R,at,ut,st,ct,ft,u,F,L,s,G,Z,P,f,c=this,f=r.wordWrap,l=r.hAlign,P=r.vAlign,G=r.shrinkToFit,U=r.textDecoration,h=2,d=2,v=r.font,H=[],m=0,b=parseInt(o.fontInfo.fontSize,10),w=o.sheet,z=new lt.Rect(B,n,e,i),M=o.cellOverflowLayout,M=M&&M.layout,C=r&&(r.borderLeft||r.borderTop||r.borderRight||r.borderBottom)&&!w.getSpan(o.row,o.col,o.sheetArea),S=r.textOrientation,Y=S*Math.PI/180,T=pt(Y),Z=gt(T),A=mt(T),I=Mt(T),x=o.lineHeight,W=90===S||-90===S;if(C&&(-90<S&&S<0&&(y=!1),0<S)&&S<90&&(y=!0),Q=(M={x:M?M.x:B+1,y:M?M.y:n+1,width:M?M.width:e-2,height:M?M.height:i-2}).x,J=M.y,K=M.width,M=M.height,N=x/2*mt(T),k=x/2*gt(T),q=x/2-b/2+(X=8<b?vt((b-8)/5+2):1)-1,u&&u.content&&0<u.content.length&&!G&&(a=c.de(t,u.content,i-4,v)),_=w.Qt(a,v),(0,lt.resetFillStyle)(t,w,r,F),3===l&&(l=yt(l,L,r.formatter||r._autoFormatter,S)),dt(t,v),j=D=0,s&&(D=c.Hn(s.left),j=c.Hn(s.right)),!f&&G)for(tt={value:!1},E=$=0;E<3&&!1===tt.value&&($=bt(0,(i-4-2*k)/A))<_;E++)v=ht.W.V(v,$/_,tt,!0).font,dt(t,v),b=parseInt(o.fontInfo.fontSize,10),_=w.Qt(a,v),N=(x=lt.mt.vt(v))/2*mt(T),k=x/2*gt(T);if(et=nt=0,f)for(m=(H=lt.q.un(a,et=(i-4-2*k)/A,v,!1,t)).length,_=w.Qt(H[0],v),it=0;it<m;it++)nt<(rt=w.Qt(H[it],v))&&(nt=rt);switch(g=_/2*Z,p=(f?nt:_)/2*A,ot=""+l+(P=i<=(V=(f?nt:_)*A+2*k)?2:P)){case"00":h+=g+N+D,d+=p,W||(d+=k),C&&(h=(i-d)/I*(y?1:-1)+(x/2+2)/A+D);break;case"01":h+=g+N+D,d=i/2,C&&(h=(i-d)/I*(y?1:-1)+(x/2+2)/A+D);break;case"02":h+=g+N+D,d+=p,W||(d+=k),C&&(h=d/I*(y?1:-1)+(x/2+2)/A+D),d=i-d;break;case"10":h=(e+D-j)/2,d+=p,W||(d+=k),C&&(h+=(y?1:-1)*(i-d)/I);break;case"11":h=(e+D-j)/2,d=i/2,C&&(h+=(y?1:-1)*(i-d)/I);break;case"12":h=(e+D-j)/2,d+=p,W||(d+=k),C&&(h+=(y?1:-1)*d/I),d=i-d;break;case"20":h=e-2-g-N-j,d+=p,W||(d+=k),C&&(h=e+(i-d)/I*(y?1:-1)-(x/2+2)/A-j);break;case"21":h=e-2-g-N-j,d=i/2,C&&(h=e+(i-d)/I*(y?1:-1)-(x/2+2)/A-j);break;case"22":h=e-2-g-N-j,d+=p,W||(d+=k),C&&(h=e+d/I*(y?1:-1)-(x/2+2)/A-j),d=i-d}if(f)if(O=B+h,R=x/A,at=void 0,90===Math.abs(S)&&(ct=K<_*m+(ut=wt(r,1))+(st=wt(r,3)))&&(t.rect(Q,J,K,M),t.clip()),1<m){for(1===l&&(O-=(ft=m%2!=0)?R*(m-1)/2:m/2*R-.5*R),F=(u=Gt(O,n+d,_,Y,x)).width+R*(m-1),L=u.height,s=2===l?u.x-R*(m-1):u.x+R*(m-1),G=u.y,c.Zn(t,r,o,s,G,F,L,z),E=0;E<m;E++)at=E,(0<r.textOrientation&&2===l||r.textOrientation<0&&(0===l||1===l))&&(at=m-E-1),c.ve(t,Y,H[at],O,n+d,U,b,X,q),O=2===l?O-R:O+R;c.Zn(t,r,o,s,G,F,L,z)}else c.me(t,a,B,n,h,d,o,r,_,Y,U,b,X,x,q,z);else Z=_*A+b*A+2,P=wt(r,0),f=wt(r,2),(ct=M-(n+1-J)<Z||M<x||M<Z+P+f)&&(t.rect(Q,J,K,M),t.clip()),c.me(t,a,B,n,h,d,o,r,_,Y,U,b,X,x,q,z)},f.prototype.me=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m){var g,p,b,w,y,p,M,g=this,p=Gt(e,i,s,c,d),b=p.width,w=p.height,y=p.x,p=p.y;(ht.W.gfe(u,z.IconPosition.leftOfText)||ht.W.gfe(u,z.IconPosition.rightOfText))&&(M=pt(c),y=e+r-(b=s*gt(M)+d*mt(M))/2,p=i+o-(w=s*mt(M)+d*gt(M))/2),g.Zn(t,u,a,y,p,b,w,m),g.ve(t,c,n,e+r,i+o,f,l,h,v),g.Wn(t,u,a,y,p,b,w,m)},f.prototype.te=function(t,n,e,i){Pt(t,n,e,i)},f.prototype.ne=function(t,n,e,i,r,o,a){for(var u,s,c,f,l,u=0,s={value:!1},c=0;c<3&&!1===s.value&&(f=ut(t,r,o,a),u=bt(0,(a?e:n)-4),(u=(a?i.vAlign:1!==i.hAlign&&i.textIndent)?bt(0,u-8*i.textIndent*o):u)<f);c++)for(l=0;l<t.length;l++)t[l].style.font=ht.W.V(t[l].style.font,u/f,s,!0).font},f.prototype.Pt=function(t,n,e,i,r){var t=t.richText;return t=!Y(t)&&e?t:[{style:{font:i,foreColor:r},text:n}]},f.prototype.oe=function(t,n,e,i,r,o,a,u,s,c,f,l,h){var d,r,d,o,v,m,g,d=u&&u.layout,r={x:d?d.x:e+1,y:d?d.y:i+1,width:d?d.width:r-2,height:d?d.height:o-2},d=r.x,o=r.y,v=r.width,m=r.height;return(a||(g=this.ge(n,s,n.vAlign,e,i,m,v,d,o,l,h,c,f,u)))&&(t.rect(d,o,v,m),t.clip(),t.beginPath()),r},f.prototype.ge=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d){var v,m,g,p,t,h,m=wt(t,0),g=wt(t,1),p=wt(t,2),t=wt(t,3);return h?(!(v=o-(r+1-s)<c||a<f)&&1!==e&&o<c+l+m+p||a<f+t+g)&&(v=!0):(v=a-(i+1-u)<c||o<f)||(1===n?d&&((h=c/2)>d.backgroundLeftWidth||h>d.backgroundRightWidth)&&(v=!0):(a<c+l+t+g||o<f+m+p)&&(v=!0)),v},f.prototype.ee=function(t,n,e,i,r,o,a,u,s){var c,f,l,h,h;if(1!==o?i=i-3-r:i-=3,a)return lt.q.Ht(n,i,e,s,u,t);for(f=c=0;f<s.length;f++)l=s[f].text,u?c+=Z(s[f].style.font)*(l?l.length:0):(h=ht.W.V(s[f].style.font,1),h=s[f].style.vertAlign?h.fontSize*E+"px "+h.fontFamily:s[f].style.font,c+=Q(t,h,l));return[{textLength:c,text:n,textInfos:s}]},f.prototype.ue=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p){var b,b,w,y,b=c.font,b=ht.W.V(b,1).fontSize,w=8<b?vt((b-8)/5+2):1;this.pe(t,n,c),d?this.be(t,e,i,c,r,o,l,h,l,m,g,p):this.he(t,e,i,r,o,s,f,h,c.textDecoration,w,b,m,c,g,p,y=a<f,v)},f.prototype.be=function(t,n,e,i,r,o,a,u,s,c,f,l){var h,d,v,e,m,g,p,b,h=this,d=e.content,e=o;if(h.Zn(t,i,c,r,e,s,s*n.length,l),d&&0<d.length)for(g=0<(g=a-u-(m=Rt(t,d,!0))-2)?g:0,p=void 0,v=0;v<d.length;v++)"fillingChar"===d[v].type?(b=Bt(t,g,d[v].value,!0),this.ye(t,b,r,o),o+=g):"placeholder"===d[v].type?o+=d[v].value?d[v].value.length*s:0:"numberPlaceholder"===d[v].type?o+=s:(this.ye(t,d[v].value,r,o),o+=p=d[v].value?d[v].value.length*s:0);else if(n)for(v=0;v<n.length;v++)o=this.ye(t,n[v],r,o,s).y;h.Wn(t,i,c,r,e,s,o-e,l)},f.prototype.we=function(t){var n=y;return 1===t?n=K:2===t&&(n=J),n},f.prototype.ce=function(t,n,e,i,r,o,a,u){for(var s,c,f,l,s=[],c=a.textInfos,f=0;f<c.length;f++)s.push(F(!0,{},r,c[f].style));for(f=0;f<c.length;f++)e=(l=this.Me(t,n,e,i,s[f],c[f].text,u)).x,i=l.y},f.prototype.re=function(t,n,e,i){for(var r,o,a,u,r=[],o=t.length,a=0;a<o;a++)u=this.Ce(n,e,i,t[a].textInfos),r.push(u);return r},f.prototype.Ce=function(t,n,e,i){var r,o,a,u,s,c,f,r=this,o=0,a=0;if(i)for(u=0;u<i.length;u++)s=void 0,s=(i[u].style&&i[u].style.font&&i[u].text?i[u].style:t).font,o=Math.max(Z(s,A,W(i[u].text)),o),a=Math.max(ht.W.V(s,1).fontSize,a),(i[u].style&&1===i[u].style.vertAlign||2===i[u].style.vertAlign)&&(o=Math.max(Z(s,A,W(i[u].text))+2*ht.W.V(s,E).fontSize*.218,o));return{lineHeight:o,fontSize:a,baselineOffset:c=8<a?vt((a-8)/5+2):1,lineOffset:f=o/2-a/2+c-1,font:t.font,foreColor:t.foreColor,textDecoration:t.textDecoration,isVerticalText:t.isVerticalText,textAlign:r.we(n),textBaseline:X,opacity:e}},f.prototype.Se=function(t,n,e){for(var i=0,r=0,o,o=0;o<t.length;o++)r+=n[o].lineHeight,i=Math.max(t[o].textLength,i);return{width:e?r:i,height:e?i:r}},f.prototype.ae=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d){var v,m,g,p,b,v=this.Se(c,f,u),m=v.height,g=v.width,p=[];if(u)for(b=0;b<c.length;b++)p.push(this.Te(t,n,e,i,r,o,a,g,c[b].textLength,f[b].lineHeight,f[b].lineOffset,s,l,c[b],h,d)),s?t-=f[b].lineHeight:t+=f[b].lineHeight;else for(b=0;b<c.length;b++)p.push(this.Ae(t,n,e,i,r,o,a,c[b].textLength,m,f[b].lineHeight,f[b].lineOffset,l,d)),n+=f[b].lineHeight;return p},f.prototype.Ae=function(t,n,e,i,r,o,a,u,s,c,f,l,h){var d,v,m,l,d=0,v=0,m=l.left,l=l.right;return v=1===o?(i-s)/2+c-f:2===o?i-s-2+c-f:2+c-f,1===r||4===r?d=(e-u+m-l)/2:2===r?(d=it(h,d=e-1-2-u-l),d-=a):d=2+a+m,{x:t+d,y:n+v}},f.prototype.Te=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m){var g,p,b,w,h,g=0,p=0,w=h.left,h=h.right;return l?0===r?g=2+u+h-c/2:1===r?g=(e-w+h+u)/2-c/2:2===r&&(g=it(m,g=e-w-1-2-c/2)):1===r?g=(e-u+w-h)/2+c/2:2===r?g=it(m,g=e-1-2-h-u+c/2):0===r&&(g=2+w+c/2),{x:t+g,y:n+(p=1===o?(i-s)/2:2===o?i-a-s-2:2+a)}},f.prototype.Me=function(t,n,e,i,r,o,a){var n,a;return t.save(),this.pe(t,n,r),n=r.vertAlign,a=r.isVerticalText?this.ye(t,o,e,i,r.textDecoration,r.baselineOffset,a):this.Ie(t,e,i,r,o,n),t.restore(),a},f.prototype.pe=function(t,n,e){(0,lt.resetFillStyle)(t,n,e);var n=e.vertAlign?this.xe(e.font):e.font;Y(e.textBaseline)||t.textBaseline===e.textBaseline?Y(t.textBaseline)&&t.textBaseline!==X&&(t.textBaseline=X):t.textBaseline=e.textBaseline,e.isVerticalText?t.textAlign!==K&&(t.textAlign=K):t.textAlign!==y&&(t.textAlign=y),dt(t,n)},f.prototype.xe=function(t){var t,n,t=ht.W.Ne(t),n=parseFloat(t.fontSize)*E;return t.fontSize=n+"px",this.ke(t)},f.prototype.ke=function(t){var n,e,i,r,o,a,t,n="",e="normal",i,r=t.fontStyle,o=t.fontSize,a=t.fontWeight,t=t.fontFamily;return n=void 0!==r?r:e,n=(n=(n+=void 0!==a?(n?" ":"")+a:(n?" ":"")+e)+((n?" ":"")+o))+(void 0!==t?(n?" ":"")+t:(n?" ":"")+"Calibri")},f.prototype.ye=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,v;if(n&&0<n.length)for(u=t.font,s=Z(u,A,W(n)),c=$(ht.W.V(u,1).fontSize,s),l=(f=this.qn(t,"0"))/2,h=0;h<n.length;h++)d=tt(n[h]),v=void 0!==a&&a<=h&&h<=a+2&&(a+3===n.length||0===a&&a+3<n.length||0!==a&&a+3<n.length),t.fillText(d,e,i=i+(m=v?f:s)-(v=v?l:c)),this.De(t,r,e,i,Q(t,t.font,d),ht.W.V(t.font,1).fontSize,o),i+=v;return{x:e,y:i}},f.prototype.De=function(t,n,e,i,r,o,a){var u,s,c,f,s;t.strokeStyle!==t.fillStyle&&(t.strokeStyle=t.fillStyle),s=u=0,c=.5,s=vt(((f=o<=12?12:o)-12)/21+1),t.lineWidth!==s&&(t.lineWidth=s),0==(1&s)&&(c=0),(s=t.textAlign)===K?e-=r/2:s===J&&(e-=r),t.beginPath(),2==(2&n)&&(u=N(i+a-o/2)-c,t.moveTo(e,u),t.lineTo(e+r,u)),t.stroke()},f.prototype.Ie=function(t,n,e,i,r,o){var a,u,s,o,r;return Y(r)?{x:n,y:e}:(u=8<(a=ht.W.V(t.font,1).fontSize)?vt((a-8)/5+2):1,s=0,o?t.fillText(r,n,e-(s=1===o?.74*a:.28*-a)):t.fillText(r,n,e),o=Q(t,t.font,r),r=i.textDecoration,this.le(t,r,n,e,o,a,u-s),{x:n+o,y:e})},f.prototype._e=function(t,n,e,i,r,o,a,u){var s={row:u.row,col:u.col,sheet:u.sheet,sheetArea:u.sheetArea,style:a,underline:a.textDecoration,foreColor:a.foreColor};f.et(u.sheet,"applyHyperlinkStyle",s),this.paint(t,n,e,i,r,o,a,u)},f.prototype.paint=function(t,n,e,i,r,o,a,u){var s,s,c,f,c,f,c;t&&(s=a.backColor,u.parentBackColor!==s&&ct(t,e,i,r,o,u.imageLoader,a,n,u),2!==(s=u.sheetArea)&&1!==s||(c=u.visualState||0,f="columnHeader",c=this.getThemeStyle(u.visualState,"gc-"+(f=2===s?"rowHeader":f)+"-"+lt.I.Ee(c)),I.cn(t,e,i,r,o,a,f,c,s)),f=this,c=new lt.Rect(e,i,r,o),u.cellRect=c.clone(),f.Vn(t,u,c,n,a),Ht(t,c,a,u),f.Tn&&(f.Tn(t,c,a,u),c=f.An(c,a,q(u)?u.printZoomFactor:u.sheet.zoom())),u.cellOverflowLayout||f.pn(t,c,u,S(n)),0<c.width)&&0<c.height&&(a&&a.showEllipsis&&u.sheet.Ut.$n(u.row,u.col,null,u.sheetArea),f.paintContent(t,n,c.x,c.y,c.width,c.height,a,u))},f.prototype.paintContent=function(t,n,e,i,r,o,a,u){var s,c,c,c,s,c=u.conditionalFormats;c&&(s=c._e(t,S(n),e,i,r,o,a,u)),u.showBarIconOnly=s,(c=u.sparkline)&&c.paintSparkline(t,e,i,r,o),c=I.dn(t,S(n),e,i,r,o,u),u.cellOverflowLayout||s||c||(s=new lt.Rect(e,i,r,o),this.paintValue(t,n,s.x,s.y,s.width,s.height,a,u))},f.prototype.adjustRectForIconSet=function(t,n,e,i,r,o,a){ft(t,n,e,i,r,o,a)},f.prototype.hasInfilling=function(t){for(var n=0;n<t.length;n++)if("fillingChar"===t[n].type)return!0;return!1},f.prototype.createEditorElement=function(t,n){return _},f.prototype.getEditorValue=function(t,n){return _},f.prototype.je=function(t,n,e,i){return e},f.prototype.setEditorValue=function(t,n,e){},f.prototype.getEditingElement=function(){return _},f.prototype.parse=function(t,n,e){var i,r,o,a,i=Y(n),r=Y(t);try{if(o=c.Formatter&&c.Formatter.GeneralFormatter,!i&&!r&&o)return(a=typeof n===L?new o(n):n).parse(t)}catch(t){}return r?"":t.toString()},f.prototype.format=function(n,t,e,i){var r,o,a,a,i,u,s,r=T(t);if(i&&r&&(a=(o=i.sheet).Oe(i.row,i.col,i.sheetArea,t),Y(a)||(n=a)),Y(n)||""===n)return"";if(i&&i.quotePrefix&&typeof n===L)return n.toString();if(!r&&typeof t===L&&"object"!=typeof n)return lt.Be.Re(n,t,e);if(!t||"General"===t||r)return"boolean"==typeof n||n instanceof Boolean?(n=l?n?l.getBoolean().boolean_true:l.getBoolean().boolean_false:n).toString().toUpperCase():n instanceof Date?(i=(a=h.Fe(h.culture()).DateTimeFormat).shortDatePattern,0===n.getHours()&&0===n.getMinutes()&&0===n.getSeconds()&&0===n.getMilliseconds()||(i=a.defaultDatePattern),M.Pe(n,i)):(n=typeof n===b?d.Ge(n.toString()):n).toString();try{return(u=c.Formatter&&c.Formatter.GeneralFormatter)?(s=void 0,(s=typeof t===L?lt.Be.Ue(t):t).format(n,e)):n.toString()}catch(t){return n.toString()}},f.prototype.focus=function(t,n){t&&t.focus&&t.focus()},f.prototype.getThemeStyle=function(t,n){return lt.I.He(t,n)},f.prototype.activateEditor=function(t,n,e,i,r,o,a){},f.prototype.deactivateEditor=function(t,n){},f.prototype.selectAll=function(t,n){t&&t.select&&t.select()},f.prototype.updateEditor=function(t,n,e,i,r,o,a){},f.prototype.setImeMode=function(t,n,e){this.isImeAware(e)?this.updateImeMode(t,n,e):t&&I.hn(t,0)},f.prototype.updateImeMode=function(t,n,e){t&&I.hn(t,n)},f.prototype.getHitInfo=function(t,n,e,i,r){return _},f.prototype.getCellAndPaddingHitInfo=function(t,n,e,i,r){var o,a,u,o=this;if(r){if(a={x:t,y:n,context:r,cellStyle:e,cellRect:i,paddingHitInfo:null},f.et(r.sheet,"getCellButtonHitInfo",a,function(){return null!==a.paddingHitInfo&&void 0!==a.paddingHitInfo}),u=a.paddingHitInfo,a.paddingHitInfo&&!Y(a.paddingHitInfo.cellButtonHitInfo)&&!Y(a.paddingHitInfo.cellButtonHitInfo.buttonConfig))return a.paddingHitInfo;if(a.cellRect=o.An?o.An(a.cellRect,e,r.sheet.zoom()):a.cellRect,f.et(r.sheet,"getCellTextHitInfo",a,function(){return!Y(a.paddingHitInfo)&&a.paddingHitInfo.isReservedLocation}),a.paddingHitInfo&&a.paddingHitInfo.isReservedLocation)return a.paddingHitInfo;if(3===r.sheetArea)return f.et(r.sheet,"getCellPaddingHitInfo",a,function(){return!Y(a.paddingHitInfo)&&a.paddingHitInfo.isReservedLocation}),a.paddingHitInfo||u||this.getHitInfo(t,n,e,i,r)}return this.getHitInfo(t,n,e,i,r)},f.prototype.processCellAndPaddingMouseDown=function(t){return f.et(t.sheet,"processMouseDownOnCellPadding",t),this.processMouseDown(t)},f.prototype.processMouseDown=function(t){return!1},f.prototype.ze=function(t){return f.et(t.sheet,"processMouseMoveOnCellPadding",t),this.processMouseMove(t)},f.prototype.processMouseMove=function(t){return!1},f.prototype.Ve=function(t){return f.et(t.sheet,"processMouseUpOnCellPadding",t),this.processMouseUp(t)},f.prototype.processMouseUp=function(t){return!1},f.prototype.processMouseEnter=function(t){return!1},f.prototype.Ye=function(t){return f.et(t.sheet,"processMouseLeaveOnCellPadding",t),this.processMouseLeave(t)},f.prototype.processMouseLeave=function(t){return!1},f.prototype.isReservedKey=function(t,n){return!1},f.prototype.isEditingValueChanged=function(t,n,e){var i,r,o,e,i,i=e.sheet,r=e.row,o=e.col,e=e.sheetArea||z.SheetArea.viewport,i=i&&i.getValue(r,o,e,z.ValueType.richText);return(t=(t=i&&i.richText?t.replace(/\r\n?/g,"\n"):t)===_?A:t)!==(n=n===_?A:n)},f.prototype.processCompositionStart=function(t,n){return!1},f.prototype.processKeyDown=function(t,n){return!1},f.prototype.processKeyUp=function(t,n){return!1},f.prototype.getAutoFitWidth=function(t,n,e,i,r){return I.Bt(t,n,e,i,r)},f.prototype.getAutoFitHeight=function(t,n,e,i,r){return I.tn(t,n,e,i,r)},f.prototype.he=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p){var b,p,b=this;e&&e.content&&0<e.content.length&&(p||!m||4===o)?this.Ze(t,e.content,i,r,o,a,u,s,c,f,l,h,d,v,g):(g=g||Q(t,t.font,n),p=i,t.textAlign===K?p-=g/2:t.textAlign===J&&(p-=g),b.Zn(t,h,l,p,r,g,l.lineHeight,v),t.fillText(n,i,r),s&&this.le(t,s,i,r,g,f,c),b.Wn(t,h,l,p,r,g,l.lineHeight,v))},f.prototype.ve=function(t,n,e,i,r,o,a,u,s){var i;t.save(),t.textAlign="center",t.textBaseline="middle",t.translate(i,r),t.rotate(-n),t.fillText(e,0,0),o&&(i=t.measureText(e).width,this.le(t,o,0,s,i,a,u)),t.restore()},f.prototype.de=function(t,n,e,i){var r,o,a,u;for(t.font||dt(t,i),o=0<(o=e-(r=Rt(t,n)))?o:0,a=[],u=0;u<n.length;u++)"fillingChar"===n[u].type?a.push(Bt(t,o,n[u].value)):"placeholder"!==n[u].type&&"numberPlaceholder"!==n[u].type&&a.push(n[u].value);return a.join("")},f.prototype.Ze=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v){var m,g,p,h,b,w,o;t.save(),t.textAlign!==y&&(t.textAlign=y),m=this,w=0<(w=o-a-(g=Rt(t,n=Lt(JSON.parse(JSON.stringify(n)))))-(b=(p=h?h.left:0)+(h=h?h.right:0))-2)?w:0,Y(v)?this.hasInfilling(n)?1===r||4===r?e=e-(o+p-h)/2+(a+p):2===r&&(e=e-o+h+2,e+=a+p):Y(g)||(1===r||4===r?e-=g/2:2===r&&(e-=g)):this.hasInfilling(n)?1===r?(e=e+(v||g)/2-(o+p-h)/2,e+=a+p):2===r&&(e=e+(v||g)-o+h+2,e+=a+p):Y(g)||(1===r?e=e+v/2-g/2:2===r&&(e=e+v-g)),m.Zn(t,l,f,e,i,g,f.lineHeight,d),o=this.We(t,n,e,i,w,u,s,c),m.Wn(t,l,f,e,i,o-e,f.lineHeight,d),t.restore()},f.prototype.We=function(t,n,e,i,r,o,a,u,s){for(var c,f,l,l,c=this.qn(t,"0"),f=0;f<n.length;f++)"fillingChar"===n[f].type?(t.fillText(Bt(t,r,n[f].value),e,i),o&&this.le(t,o,e,i,r,u,a),e+=r):"placeholder"===n[f].type?e+=Q(t,t.font,n[f].value):"numberPlaceholder"===n[f].type?e+=c:((l=n[f].value)!==_&&t.fillText(l,e,i),l=Q(t,t.font,l),o&&this.le(t,o,e,i,l,u,a),e+=l);return e},f.prototype.le=function(t,n,e,i,r,o,a){var u,s,c,f,l;t.strokeStyle!==t.fillStyle&&(t.strokeStyle=t.fillStyle),u=t.textAlign,c=s=0,f=.5,c=vt(((l=o<=12?12:o)-12)/21+1),t.lineWidth!==c&&(t.lineWidth=c),0==(1&c)&&(f=0),u===K?e-=r/2:u===J&&(e-=r),t.beginPath(),4==(4&n)&&(s=N(i+a-o-1)-f,t.moveTo(e,s),t.lineTo(e+r,s)),2==(2&n)&&(s=N(i+a-o/2)-f,t.moveTo(e,s),t.lineTo(e+r,s)),1==(1&n)&&(s=N(i+a-1)-f,t.moveTo(e,s),t.lineTo(e+r,s)),8==(8&n)&&(s=N(i+a-1)-f,t.moveTo(e,s-c),t.lineTo(e+r,s-c),t.moveTo(e,s+c),t.lineTo(e+r,s+c)),t.stroke()},f.prototype.Qe=function(t,n){var e=4==(4&n)?"overline":"";2==(2&n)&&(e+=" line-through"),1==(1&n)&&(e+=" underline"),t.css("text-decoration",e)},f.prototype.Ke=function(){return _},f.prototype.isImeAware=function(t){return!1},f.prototype.isEditing=function(){return!1},f.prototype.Je=function(t){},f.prototype.Xe=function(t,n,e,i,r){},f.prototype.qe=function(t,n,e,i,r){},f.prototype.lfe=function(t,n){return t},f.prototype.toJSON=function(){var t,n,e,t={},n=this;for(e in n)n.hasOwnProperty(e)&&(t[e]=n[e]);return t},f.prototype.fromJSON=function(t){if(t)for(var n in t)Y(t[n])||(this[n]=t[n])},e=f,u.Base=e,(0,lt.$e)(e),i.ti[0]=e,u.paintDecoration=Ht,u.paintStyleDecorationOutSideIcons=Yt},"./dist/core/celltype/cellType.entry.js":function(t,n,e){"use strict";var i,r,o,a,i=this&&this.__createBinding||(Object.create?function(t,n,e,i){void 0===i&&(i=e);var r=Object.getOwnPropertyDescriptor(n,e);r&&("get"in r?n.__esModule:!r.writable&&!r.configurable)||(r={enumerable:!0,get:function(){return n[e]}}),Object.defineProperty(t,i,r)}:function(t,n,e,i){t[i=void 0===i?e:i]=n[e]}),r=this&&this.__exportStar||function(t,n){for(var e in t)"default"===e||Object.prototype.hasOwnProperty.call(n,e)||i(n,t,e)};Object.defineProperty(n,"__esModule",{value:!0}),o=e("./dist/core/celltype/headercelltype.js"),a=e("./dist/core/celltype/textcelltype.js"),Object.defineProperty(n,"Corner",{set:function(t){t!==o.Corner&&(o.Corner=t)},get:function(){return o.Corner}}),Object.defineProperty(n,"ColumnHeader",{set:function(t){t!==o.ColumnHeader&&(o.ColumnHeader=t)},get:function(){return o.ColumnHeader}}),Object.defineProperty(n,"RowHeader",{set:function(t){t!==o.RowHeader&&(o.RowHeader=t)},get:function(){return o.RowHeader}}),Object.defineProperty(n,"Text",{set:function(t){t!==a.Text&&(a.Text=t)},get:function(){return a.Text}}),r(e("./dist/core/celltype/celltype.ns.js"),n),r(e("./dist/core/celltype/basecelltype.js"),n),r(e("./dist/core/celltype/textcelltype.js"),n),r(e("./dist/core/celltype/headercelltype.js"),n)},"./dist/core/celltype/celltype.ns.js":function(t,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.ti=void 0,n.ti={}},"./dist/core/celltype/headercelltype.js":function(p,t,n){"use strict";var e,i,r,b,B,o,S,F,w,P,T,_,G,U,D,j,A,E,H,V,n,i,r,a,u,s,c;function d(t,n){return w.He(t=t||0,"gc-"+n+"-"+w.Ee(t))}function I(t,n,e,i,r,o){var a,o,a=new Image,o=o;o=(o=o.replace('url("',"")).replace('")',""),a.src=o,t.drawImage(a,n,e,i,r)}function v(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,p,b,w,y,M;function C(){t.fillRect(n+1,e+1,i-1,r-1)}if(!U(u)){if(t.save(),t.beginPath(),c=o.backColor,0===u&&c)B.W.setFillStyle(t,c,n,e,i,r,C);else try{if(c=s&&s.backgroundColor,f=s&&s.backgroundImage,l=a.sheet,h=a.row,d=a.col,v=a.sheetArea,m=void 0,g=!1,l.cellStates&&u===F.VisualState.hover&&(m=l.cellStates.getStyle(h,d,v))&&m.backColor&&(c=m.backColor,g=!0),!g&&f&&-1!==f.indexOf("linear-gradient")){for(p=T(f),b={degree:90,stops:[]},w=0,y=p.length;w<y;w++)M=p[w],b.stops.push({position:M.point,color:M.color});B.W.setFillStyleGradient(t,b,n,e,i,r,C)}else c?(t.fillStyle=c,C()):f&&f!==A&&I(t,n+1,e+1,i-1,r-1,f)}catch(t){}2===a.columnHeaderFitMode&&(i=a.sheet.getColumnWidth(a.col)+1),S.Context.nt(t,n,e,i,r,o.backgroundImage,o.backgroundImageLayout,a.imageLoader),t.restore()}}function f(t,n,e,i,r,o,a,u,s,c,f,l){var h,h,c,h,f;n&&(v(n,i,r,o,a,u,s,h=s.visualState||0,h=d(h,c)),S.Context.cn(n,i,r,o,a,u,c,h,f,s.needTopGridline,s.needLeftGridline),c=new b.Rect(i,r,o,a),s.cellRect=c.clone(),t.Vn(n,s,c,e,u),(0,S.paintDecoration)(n,c,u,s),t.Tn&&(t.Tn(n,c,u,s),h=s.printZoomFactor,f=s.isPrinting&&"number"==typeof h&&1!==h?h:s.sheet.zoom(),c=t.An(c,u,f)),0<c.width)&&0<c.height&&t.paintContent(n,e,c.x,c.y,c.width,c.height,u,s,l)}function z(t,n,e,i,r,o){var n,e,o,n={font:n,fillStyle:e},e=i.sheet;return 0!==i.visualState&&2007<parseInt(o.zIndex,10)&&e.ni(i.row,i.col,r)&&(o=void 0,o=e.ei(i.row,i.col,r)?t(i.visualState,"gc-columnHeader-selected"):t(i.visualState,"gc-columnHeader-highlight"),n.fillStyle=o.color,n.font=B.W.ii(n.font,"bold")),n}function l(t,n,e,i,r,o,a,u,s,c,f,l){var h,d,v,v,m,g,p,m,l,m,l,m,d,h={},d=s.sheet,v={sheet:d,row:s.row,col:s.col,sheetArea:c,quotePrefix:u.quotePrefix},v=t.format(D(e),u.formatter,h,v);v&&(n.save(),n.beginPath(),m=d.rowFilter&&d.rowFilter(),g=s.columnHeaderFitMode,!(p=!!(m&&m.rn(s.row,s.col,c)&&m.filterButtonVisible(s.col)))&&!l||g!==F.ColumnHeaderFitMode.normal&&g!==F.ColumnHeaderFitMode.vertical||(U(s.cornerX)||(o=s.cornerX-i),o-=d.an(new b.Rect(i,r,o,a),c).width),(m=(m=u.foreColor)||f.color)&&n.fillStyle!==m&&(n.fillStyle=m),l=u.textOrientation,m=u.isVerticalText,l=0===g&&d.NMi&&0!==l&&!U(l)&&-90<=l&&l<=90&&!m,e&&e.richText&&0<e.richText.length||m?y(t,d,n,e,i,r,o,a,u,v,h,s,c,f):1===g||l?(m=z(t.getThemeStyle,u.font||n.font,n.fillStyle,s,c,f),u.foreColor=m.fillStyle,u.font=b.util.yt(m.font),1===g&&(u.textOrientation=-90),d=t.Pn(n,v,u,s,i,r,o,a),t.Kn(n,e,i,r,o,a,u,s,v,h,E,d.externals)):M(t,n,e,i,r,o,a,u,v,h,s,c,f),n.restore())}function y(t,n,e,i,r,o,a,u,s,c,f,l,h,d){var v,h,d,m,g,p,b,w,y,w,y,w,M,y,C,S,w,h,T,A,I,x,N,k,v=new V(r,o,a,u),h=z(t.getThemeStyle,s.font||e.font,e.fillStyle,l,h,d),d=s.isVerticalText,m=s.hAlign,g=R(s),p=t.Ft(s.formatter||s._autoFormatter,i.text),b=j(!0,[],t.Pt(i,c,p,h.font,h.fillStyle));if(i&&i.richText&&0<i.richText.length&&(w=l.sheet?l.sheet.zoom():1,y=l.printZoomFactor,y=l.isPrinting&&"number"==typeof y&&1!==y?y:E,t.te(b,h,w,y)),w=t.Pn(e,D(i),s,l,r,o,a,u),M=(y=t.Hn(w.externals.left))+(w=t.Hn(w.externals.right)),y={left:y,right:w},!s.wordWrap&&s.shrinkToFit&&t.ne(b,a-M,u,s,h,1,d),C=t.ee(e,c,s.font,d?u:a-M,g,d?s.vAlign:s.hAlign,s.wordWrap,d,b),S=t.re(C,s,m),O(e,s,r,o,a,u,g,C[0].textLength,S[0].lineHeight),w=d?_(c):E,h=!1,s.wordWrap||s.shrinkToFit||!s.showEllipsis||!d||i.richText||(h=!0),T=t.ae(v.x,v.y,v.width,v.height,m,s.vAlign,g,d,w,C,S,y,h),A=[],h&&f&&(f.content&&1===f.content.length&&"text"===f.content[0].type||!f.content&&1===C.length&&C[0].text)&&t.Xn(e,l,C,S,s,u,o,g,T,A),1===(I=C.length)&&f.content&&!p)t.ue(e,n,c,f,T[0].x,T[0].y,a,u,m,s,v.width,v.height,g,d,C[0].textLength,l,y,v);else for(x=0;x<I;x++)N=t.se(C),k=T[0].x,"center"===e.textAlign?k-=N/2:"right"===e.textAlign&&(k-=N),t.Zn(e,s,l,k,T[0].y,N,0,v),t.ce(e,n,T[x].x,T[x].y,S[x],m,C[x],A[x]),t.Zn(e,s,l,k,T[0].x,N,0,v)}function M(t,n,L,e,i,r,o,a,u,s,c,f,l){var h,d,f,v,l,m,g,l,p,b,w,y,w,M,C,d,S,d,y,w,p,T,A,I,x,N,k,_,D,p,j,M,E,f,w,l,o,O,R,h=new V(e,i,r,o),d=c.columnHeaderFitMode,f=z(t.getThemeStyle,a.font||n.font,n.fillStyle,c,f,l);if(G(n,f.font),n.fillStyle=f.fillStyle,(v=0)<(l=a.textIndent)&&(v=8*l),m=parseInt(c.fontInfo.fontSize,10),g=a.hAlign,l=a.vAlign,p="left",b=2,w=t.Pn(n,u,a,c,e,i,r,o),M=(y=t.Hn(w.externals.left))+(w=t.Hn(w.externals.right)),C={left:y,right:w},b+=v+y,1===(g=d!==F.ColumnHeaderFitMode.stack||U(c.cornerX)||(o=c.cornerY-i,(d=c.colStyle)&&!U(d.hAlign))?g:0)?(b=(r+y-w)/2,p="center"):2===g&&(b=r-w-1,b-=v,p="right"),n.textAlign!==p&&(n.textAlign=p),d="alphabetic",y=2,w=a.wordWrap,p=a.shrinkToFit,T=a.font,A=c.lineHeight,I=[],x=S=0,!w&&p)for(k={value:!1},_=N=0;_<3&&!1===k.value&&(D=n.measureText(u).width,(N=Math.max(0,r-4-(1===g?0:v)))<D);_++)T=B.W.V(T,N/D,k,!0).font,G(n,T);if(p=0,w&&(p=r-M-3-v,1<(x=(I=P.un(u,--p,f.font)).length))&&0!==l&&(S=(x-1)*A),M=A/2-m/2+(j=8<m?H((m-8)/5+2):1)-1,!w&&a.showEllipsis&&t.fe(c,s,u,n,r,g,v),y+=A-M,1===l?y=(o-S)/2+A/2-M:2===l&&(y=o-S-2-M),n.textBaseline!==d&&(n.textBaseline=d),E=a.textDecoration,f=h.x,w=h.y,l=h.width,o=h.height,a.wordWrap)if(n.rect(f,w,l,o),n.clip(),n.beginPath(),O=i+y,1<x){for(t.Zn(n,a,c,e+b,O,p,A*x,h),_=0;_<x;_++)n.fillText(I[_],e+b,O),E&&(D=n.measureText(I[_]).width,t.le(n,E,e+b,O,D,m,j)),O+=A;t.Zn(n,a,c,e+b,O,p,A*x,h)}else t.he(n,u,s,e+b,i+y,g,l,v,E,j,m,c,a,C,h);else(l<(R=n.measureText(u).width)||o<A)&&(n.rect(f,w,l,o),n.clip(),n.beginPath()),t.he(n,u,s,e+b,i+y,g,l,v,E,j,m,c,a,C,h,void 0,void 0,a.showEllipsis)}function O(t,n,e,i,r,o,a,u,s){var c=!1,c;(c=!!n.wordWrap||(n.isVerticalText?o<u+a||r<s:r<u+a||o<s))&&(t.rect(e,i,r,o),t.clip(),t.beginPath())}function R(t){var n=0,t=t.textIndent;return n=0<t?8*t:n}function h(){var t=u.call(this)||this;return t.typeName="2",t}function m(){var t=s.call(this)||this;return t.typeName="3",t}function g(){var t=c.call(this)||this;return t.typeName="4",t}e=this&&this.__extends||(a=function(t,n){return(a=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}a(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(t,"__esModule",{value:!0}),t.RowHeader=t.ColumnHeader=t.Corner=void 0,i=n("Common"),r=n("./dist/core/util/domUtil.js"),b=n("./dist/core/util/common.js"),B=n("./dist/core/worksheet/stylehelper.js"),o=n("./dist/core/celltype/celltype.ns.js"),S=n("./dist/core/celltype/basecelltype.js"),F=n("./dist/core/core.enum.js"),w=b.I,P=b.q,T=b.mt.ri,_=b.mt.pt,G=b.mt.bt,U=i.Common.lt.ht,D=b.mt.wt,j=r.GC$.extend,A="none",E=void 0,H=Math.floor,V=b.Rect,u=S.Base,e(h,u),h.prototype.paint=function(t,n,e,i,r,o,a,u,s){f(this,t,n,e,i,r,o,a,u,"columnHeader",1,s)},h.prototype.paintContent=function(t,n,e,i,r,o,a,u,s){var c,f,c;S.Context.dn(t,D(n),e,i,r,o,u)||l(this,t,n,e,i,r,o,a,u,1,f=d(u.visualState,"columnHeader"),s)},t.ColumnHeader=n=h,o.ti[2]=n,s=S.Base,e(m,s),m.prototype.paint=function(t,n,e,i,r,o,a,u){f(this,t,n,e,i,r,o,a,u,"rowHeader",2)},m.prototype.paintContent=function(t,n,e,i,r,o,a,u){var s,c,s;S.Context.dn(t,D(n),e,i,r,o,u)||l(this,t,n,e,i,r,o,a,u,2,c=d(u.visualState,"rowHeader"))},t.RowHeader=i=m,o.ti[3]=i,c=S.Base,e(g,c),g.prototype.paint=function(t,n,e,i,r,o,a,u){var s,c,f,l,h,f,l,h,d,v,m,g,p,s,c,b,l;if(t){t.save(),t.rect(e,i,r,o),t.clip(),t.beginPath(),s=this,c=u.visualState||0;try{l=(f=s.getThemeStyle(u.visualState,"gc-corner-"+w.Ee(c)))&&f.backgroundColor,h=f&&f.backgroundImage,l?(t.fillStyle=l,t.fillRect(e,i,r,o)):h&&h!==A&&I(t,e,i,r,o,h)}catch(t){}if(l=(f=s.getThemeStyle(4,"gc-corner-triangle-"+w.Ee(c)))&&f.backgroundImage,h=f&&f.backgroundColor,d=t.createLinearGradient(e+r/2,i,e+r/2,i+o),l&&-1!==l.indexOf("linear-gradient")){for(m=0,g=(v=T(l)).length;m<g;m++)p=v[m],d.addColorStop(p.point,p.color);t.fillStyle=d}else h&&(d.addColorStop(.125,"#f6fafb"),d.addColorStop(1,h),t.fillStyle=d);(s=t.createLinearGradient(e+r,i+1,e+r,i+o-2)).addColorStop(0,f.borderLeftColor),s.addColorStop(1,f.borderRightColor),t.beginPath(),t.strokeStyle=s,t.moveTo(e+r-.5,i),t.lineTo(e+r-.5,i+o),t.stroke(),u.needLeftGridline&&(t.beginPath(),t.strokeStyle=f.borderLeftColor,t.moveTo(e+.5,i),t.lineTo(e+.5,i+o),t.stroke()),(c=t.createLinearGradient(e,i,e+r-2,i)).addColorStop(0,f.borderTopColor),c.addColorStop(1,f.borderBottomColor),t.beginPath(),t.strokeStyle=c,t.moveTo(e,i+o-.5),t.lineTo(e+r,i+o-.5),t.stroke(),u.needTopGridline&&(t.beginPath(),t.strokeStyle=f.borderTopColor,t.moveTo(e,i+.5),t.lineTo(e+r,i+.5),t.stroke()),t.beginPath(),t.moveTo(e+r-(l=r<(l=o)?r:o)+(b=3),i+o-3),t.lineTo(e+r-3,i+o-3),t.lineTo(e+r-3,i+o-l+3),t.fill(),t.restore()}},t.Corner=r=g,o.ti[4]=r},"./dist/core/celltype/textcelltype.js":function(o,t,n){"use strict";var a,u,d,E,e,v,O,A,R,n,k,L,J,_,g,i,s,D,p,c,B,j,K,y,X,b,w,f,q,$,tt,nt,et,it,rt,F,ot,at,ut,M,P,C,S,G,U,st,H,V,z,ct,Y,ft,lt,ht,dt,vt,T,I,mt,gt,pt,x,N,bt,wt,yt,Mt,Ct,St,Z,Tt,h,At,It,xt,Nt,kt,u,_t,n,l;function Dt(t){return pt||0===t}function jt(t){return Dt(t)?(0,E.GC$)(p("textarea")):(0,E.GC$)(p("div"))}function W(t){return t&&"DIV"===t.tagName&&"true"===t.contentEditable}function Q(t){return W(t)?B&&parseFloat(c.version)<10?i.oi(t):t.innerText:t.value}function Et(t,n){W(t)?t.innerText=L(n)?"":n:t.value=n}function Ot(t){var n;W(t)?((n=T.getSelection()).selectAllChildren(t),0<n.rangeCount&&n.collapseToEnd()):t.selectionStart=t.selectionEnd=t.value.length}function Rt(t){var n,e;return W(t)?0<(n=T.getSelection()).rangeCount?(e=n.getRangeAt(0)).startOffset:0:t.selectionStart}function Lt(t){var n,e;return W(t)?0<(n=T.getSelection()).rangeCount?(e=n.getRangeAt(0)).endOffset:0:t.selectionEnd}function Bt(t){var n,t,e,i,r,o,n=t.keyCode,t=t.shiftKey,e={106:42,107:43,109:45,110:46,111:47,173:45},i={186:59,187:61,188:44,189:45,190:46,191:47,192:96,219:91,220:92,221:93,222:39},r={186:58,187:43,188:60,189:95,190:62,191:63,192:126,219:123,220:124,221:125,222:34},o=n;return 96<=n&&n<=105?o=n-48:e[n]?o=e[n]:t&&r[n]?o=r[n]:!t&&i[n]?o=i[n]:!t&&65<=n&&n<=90&&(o=n+32),o}function Ft(t){return t&&"BR"===t.tagName}function Pt(t){return t&&"SPAN"===t.tagName}function Gt(t){return t&&"DIV"===t.tagName}function m(t){return t instanceof Text}function Ut(t){return t===h}function Ht(t,n,e,i){var r,o,r,o;return t.substr(0,n)+i+t.substr(e,t.length-e)}function Vt(t,n,e,i,r,o){for(var a,u,s,c,f,l,h,d,a="",u=t.childNodes,s=u.length,c=0;c<s;c++)Pt(f=u[c])?a+=Vt(f,n,e,i,r,o):m(f)?(l=n&&n.startContainer,h=n&&n.endContainer,d=f.textContent,f===l||f===h?l!==h?o=f===l?(a+=Ht(d,e,d.length,r),!0):(a+=Ht(d,0,i,""),!1):a+=Ht(d,e,i,r):o||(a+=d)):Ft(f)&&!o&&(a+="\n");return a}function zt(t,n,e,i,r){var r,o,a,r=String.fromCharCode(Bt(r));return W(t)?0<(o=T.getSelection()).rangeCount&&m((a=o.getRangeAt(0)).startContainer)?Vt(t,a,e,i,r):a&&a.startOffset===a.endOffset?n+r:r:Ht(n,e,i,r)}function Yt(t){var t=Jt(t);return t=t&&0<=t.indexOf(" ")?nt(t," ",Tt):t}function Zt(t,n,e,i,r,o){var a,u,s,e,c,f,l,f,c,l,e,f,a=t.srcElement||t.target;a&&a.getAttribute(M)===S&&13===t.keyCode&&(t.ctrlKey||t.altKey)&&((u=g.ai())instanceof d.Worksheet&&(s=u.getCellType(u.ui,u.ci))&&(W(a)?(e&&(a.blur(),a.focus()),0<(e=T.getSelection()).rangeCount&&(c=e.getRangeAt(0),f=I.createElement("br"),l=I.createTextNode(h),c.insertNode(l),c.insertNode(f),Wt(c),(f=I.createRange()).setStartAfter(l),f.setEndAfter(l),f.collapse(!1),e.removeAllRanges(),e.addRange(f))):(c=a.selectionStart,e=(l=a.value).substr(0,c),f=l.substr(c,l.length-c),a.value=e+"\n"+f,a.selectionStart=c+1,a.selectionEnd=c+1),s.fi(u.li,x,x,t,n,!0)),y(t))}function Wt(t){var t,n,e,t=t.endContainer,n=t.lastChild;m(n)&&0===n.textContent.length&&t.removeChild(n),e=(n=t.lastChild).previousSibling,Ut(n.textContent)&&!Ft(e)&&0===e.textContent.length&&t.removeChild(e)}function Qt(t){var n,t,n=t;return n&&(n.indexOf(h)<0&&n.indexOf("\n")<0?n:((t=t.split("\n")).forEach(function(t,n,e){Ut(t[0])&&(e[n]=t.substr(1))}),t.join("\n")))}function Jt(t){var t,n,t=t;return t=t&&0<(n=t.length)?t.replace(/\n/g,"\n"+h):t}function Kt(t){var n,e,i,r,o,n,a,u,s,n,c,f,l,h,d,n=T.getSelection(),e=!1,i=0,r=0,o="";if(0<n.rangeCount){if(n=n.getRangeAt(0),a=Rt(t),u=Lt(t),s=n.startContainer,n=n.endContainer,Gt(s))e=!0,i=a;else if(l=void 0,0<(f=(c=s.childNodes).length))for(l=0;l<f;l++){if(!(h=c[l]).tagName||"br"!==h.tagName.toLocaleLowerCase()){s=h;break}o+="\n"}return o+(d=Xt(t,a,u,s,n,e,i,r=Gt(n)?u:r)).content}}function Xt(t,n,e,i,r,o,a,u){var s,c,f,l,h,d,v;if(i===r&&!o)return{content:Qt(i.textContent.slice(n,e))};for(s="",c=a,h=t.childNodes,d=u||h.length;c<d;c++)if(Pt(v=h[c])){if(s+=(f=Xt(v,n,e,i,r,o,0,0)).content,f.startFlag&&(o=!0),f.endFlag){l=!0;break}}else if(m(v)&&v===i)s+=v.textContent.slice(n,v.textContent.length),o=!0;else{if(m(v)&&v===r){s+=v.textContent.slice(0,e),l=!0;break}o&&(Ft(v)?s+="\n":s+=v.innerText||v.textContent)}return{content:Qt(s),startFlag:o,endFlag:l}}function qt(t,n){for(var e,i,r,e=t.length,i=[],r=0;r<e;r++)i.push($(t[r],n));return i}function $t(t){for(var n,e,i,n=t.length,e=0,i=0;i<n;i++)e+=t[i];return e}function tn(t,n,e,i){for(var r,o,a,u,r=0,o=e,a=0;a<t.length;a++)K&&(o=i[a]),t[a]>n?r+=o*(u=bt(t[a]/n)):r+=o;return r}function nn(t,n,e){var t=Q(t);return t&&"="===t[0]||""===t&&"="===n[0]||0===e&&"="===n[0]}function en(t){var t=t&&t.tagName;return"TEXTAREA"===t||"INPUT"===t}function rn(t){return(t.ctrlKey||t.metaKey)&&t.keyCode===(t.shiftKey?It:At)}function on(t){return(t.ctrlKey||t.metaKey)&&t.keyCode===(t.shiftKey?At:It)}function r(t){var n=l.call(this)||this;return n.allowOverflow=!0,n.typeName="1",n.editorType=L(t)?1:t,n}function an(t){var n,t,e,i,r,n=["0","0","0","0"];return typeof t===xt&&(r=i=void 0,1===(e=(t=t.split(" ",4)).length)?n=[i=t[0],i,i,i]:2===e?n=[i=t[0],r=t[1],i,r]:3===e?(r=t[1],n=[t[0],r,t[2],r]):4===e&&(n=[t[0],t[1],t[2],t[3]])),n}a=this&&this.__extends||(_t=function(t,n){return(_t=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}_t(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(t,"__esModule",{value:!0}),t.Text=t.EditorType=void 0,u=n("Common"),d=n("./dist/core/worksheet/worksheet.js"),E=n("./dist/core/util/domUtil.js"),e=n("./dist/core/util/common.js"),v=n("./dist/core/celltype/celltype.ns.js"),O=n("./dist/core/celltype/basecelltype.js"),A=n("./dist/core/core.enum.js"),R=n("./dist/core/util/common.js"),n=n("CalcEngine"),k=!!n,L=u.Common.lt.ht,J=e.q,_=e.Events.EditChange,g=e.hi,i=e.mt,s=e.di,D=i.St,p=i.En,c=i.Tt,B=c.msie,j=c.edge,K=c.chrome,y=i.vi,X=i.gt,b=i.mi,w=i.gi,f=i.pi(),q=i.vt,$=i.bi,tt=i.Mt,nt=i.yi,et=i.yt,it=i.wt,rt=i.Ct,F="left",ot="right",at="center",ut="top",M="gcUIElement",P="none",C=".gcEditingInput",S="gcEditingInput",G="width",U="height",st="text-align",H="hidden",V="word-wrap",z="overflow",ct="vertical-align",Y="normal",ft="break-word",lt="overflow-y",ht="scroll",dt="word-break",vt="float",T=window,I=document,mt=.337,gt=f.ipad,pt=f.iphone||gt||f.android,x=null,N=void 0,bt=Math.ceil,wt=Math.min,yt=Math.sin,Mt=Math.cos,Ct=Math.abs,St=Math.max,Z=parseInt,Tt="\xa0",h="\u200b",At=90,It=89,xt="string",Nt="number",(n=kt=t.EditorType||(t.EditorType={}))[n.textarea=0]="textarea",n[n.editableDiv=1]="editableDiv",l=O.Base,a(r,l),r.prototype.getText=function(t,n){return t},r.prototype.paintValue=function(t,n,e,i,r,o,a,u){var s,c,f,l,h,d,v,m,g,p,b,w,p,g,y,p,M,C,M,S,C,T,p,v,M,s=this,c=u.sheet,f=c.zoom?c.zoom():1;if(n=s.getText(n,u),l={},u.quotePrefix=a.quotePrefix,v=(d=a.formatter)&&"General"!==d,m=D(d),"string"==typeof d&&(v=v&&!m),g=a.textOrientation,p=a.textIndent&&0!==a.textIndent,b=a.isVerticalText,w=r,g&&-90<=g&&g<=90&&!p&&!b&&(p=Ct(g*Math.PI/180),w=(o-u.lineHeight*Mt(p))/yt(p)),g=(y=s.Pn(t,h,a,u,e,i,r,o)).externals,p=s.Hn(g.left),M=s.Hn(g.right),2===(C=3===(C=a.hAlign)?X(C,n,a.formatter||a._autoFormatter):C)?w-=M:0===C&&(w-=p),M=a._autoFormatter&&a._autoFormatter.formatCached&&"General"!==a._autoFormatter.formatCached,v?S=a.formatter:M?S=a._autoFormatter:c.parent&&c.parent.options.numbersFitMode===A.NumbersFitMode.mask?S=O.Context.Nt(t,n,w,a,f):c.parent&&c.parent.options.numbersFitMode===A.NumbersFitMode.overflow&&(S=a._autoFormatter),h=m&&(n instanceof Date||"boolean"==typeof n||n instanceof Boolean||"number"==typeof n)?s.format(n,d,{}):s.format(it(n),S,l,u),C=new R.Rect(e,i,r,o),this.adjustRectForIconSet(a.hAlign,u.sheet,u.row,u.col,u.sheetArea,C,l.content&&this.hasInfilling(l.content)),e=C.x,r=C.width,!0!==a.shrinkToFit&&!b)if(rt(n)){if(c.parent){switch(T=h,c.parent.options.numbersFitMode){case A.NumbersFitMode.mask:T=this.wi(t,h,w,a,f,u,l,c);break;case A.NumbersFitMode.overflow:T=this.Mi(t,u,n,a,c,h,l)}h=T}}else void 0===c.Ut.Ci(u.row,u.col,u.sheetArea)||a.showEllipsis||c.Ut.$n(u.row,u.col,void 0,u.sheetArea);p=a.labelOptions,v=a.watermark,M=!p||0!==p.visibility,v&&!h&&M?s.paintText(t,v,e,i,r,o,a,u,v,l,mt):(h||l.content&&l.content.length)&&s.paintText(t,n,e,i,r,o,a,u,h,l,N,g)},r.prototype.wi=function(t,n,e,i,r,o,a,u){var s,t,e,s,s=o.cellOverflowLayout&&o.cellOverflowLayout.expandedWidth,t=O.Context.Et(t,n,L(s)?e:s,i,r),e=o.row,s=o.col;return n!==t?(delete a.content,i.textIndent=0,u.Ut.$n(e,s,u.getText(e,s,o.sheetArea),o.sheetArea)):u.Ut.$n(e,s,void 0,o.sheetArea),t},r.prototype.Mi=function(t,n,e,i,r,o,a){var u,s,t,c,f,l,h,u=n.row,s=n.col;if(i.wordWrap&&(i.wordWrap=!1),t=tt(t,i.font,o),c=r.Jt.Kt(s),l=void 0,!(f=n.cellOverflowLayout)&&c<t)l=r.getText(u,s,n.sheetArea);else if(f&&c<t&&this.Si(f.backgroundWidth)&&this.Si(f.valueWidth)){if(!this.Si(i.hAlign))return;h=void 0,l=(h=1!==i.hAlign?f.valueWidth>f.backgroundWidth:f.valueWidth/2>f.backgroundLeftWidth||f.valueWidth/2>f.backgroundRightWidth)?r.getText(u,s,n.sheetArea):void 0}return r.Ut.$n(u,s,l,n.sheetArea),o},r.prototype.Si=function(t){return null!=t},r.prototype.createEditorElement=function(t,n){var t,t,n,e,t=t&&t.sheet&&t.sheet.parent&&t.sheet.parent.Ti,t=w(t)+1e3;return(0,E.GC$)(n).css("z-index",t),n=jt(this.editorType),(0,E.GC$)(n).css({font:"normal 11pt calibri",outline:P,resize:P,border:P,"vertical-align":"top","min-height":"0px","box-sizing":"content-box",background:"transparent"}).css(V,Y).attr({tabindex:-1,autocomplete:"off",contenteditable:!0}).css(z,H).attr(M,S),c.safari&&(0,E.GC$)(n).css("-webkit-user-select","auto"),(e=W((0,E.GC$)(n)[0]))&&((0,E.GC$)(n).css("display","table-cell"),(0,E.GC$)(n).css(dt,Y)),(0,E.GC$)(n)[0]},r.prototype.getEditorValue=function(t,n){var e,i,n,t;return t&&(e=Q(t),i=!L(e)&&0<e.length,O.Base.et(n&&n.sheet,"getEditorValue",n={editor:t,ns:C,editorValue:e}),i)?(t=(t=Qt(e=n.editorValue)).replace(/\r\n?/g,"\n")).indexOf(Tt)<0?t:nt(t,Tt," "):x},r.prototype.setEditorValue=function(t,n,e,i,r){var o,a,n,a,r;t&&(a=o=void 0,e&&e.sheet&&(o=e.sheet.Ai,a=e.sheet.getValue(e.row,e.col)),n=Yt(n),O.Base.et(e&&e.sheet,"setEditorValue",a={editor:t,ns:C,editorValue:n,originValue:a,startEditByKeydown:o,addPercent:i||r,cancel:!1}),!0===a.cancel?(Et(t,a.editorValue),this.qmt(t,a.caret),e&&e.sheet&&(r=e.sheet).ki(R.Events.FormulaTextBoxTextChanged,{sheet:r,sheetName:r.name(),text:a.editorValue})):B?o&&e.isImeInput||Et(t,n=L(n)?i?"%":"":n):Et(t,n=o?i?"%":"":n))},r.prototype.selectAll=function(t,n){var e;t&&t.select?t.select():T.getSelection().selectAllChildren(t)},r.prototype.focus=function(t,n){var e,i,t,n,e=this;e.isImeAware()&&t?Ot(i=t):i=t.parentNode.parentNode,i.focus(),t=e.Xmt(i),O.Base.et(n&&n.sheet,"afterSetEditorFocus",n={editor:i,caret:t,cancel:!1}),!0===n.cancel&&n.caret&&e.qmt(i,n.caret)},r.prototype.je=function(t,n,e,i){var r,o,n,r=t&&i&&i.sheet,o={},n=b(n,e,r,i,o);return t.Ii=o.formatter||N,n},r.prototype.Xmt=function(t){var n,e,i,r,o,r;return t&&(n=I.activeElement===t)?(i=e=-1,o=r=void 0,en(t)?(e=t.selectionStart,i=t.selectionEnd):W(t)&&0<(r=T.getSelection()).rangeCount&&((r=(o=r.getRangeAt(0)).cloneRange()).selectNodeContents(t),r.setEnd(o.endContainer,o.endOffset),i=r.toString().length,(r=o.cloneRange()).selectNodeContents(t),r.setEnd(o.startContainer,o.startOffset),e=r.toString().length,r.detach()),{start:e,end:i,length:i-e}):null},r.prototype.qmt=function(t,n){var e,i,r,o,a,u,e=n.start,i=n.end,r=document.createRange(),o=window.getSelection();if(t.childNodes[0]){if((a=t.childNodes[0].textContent.length)<e){for(u=0;t.childNodes[u]&&0<=e;)e-=t.childNodes[u].textContent.length,u++;r.setStart(t.childNodes[u-1],e+t.childNodes[u-1].textContent.length)}else r.setStart(t.childNodes[0],e);if(a<(i=i>n.start?i-1:i)){for(u=0;t.childNodes[u]&&0<=i;)i-=t.childNodes[u].textContent.length,u++;r.setEnd(t.childNodes[u-1],i+t.childNodes[u-1].textContent.length)}else r.setEnd(t.childNodes[0],i);r.collapse(!0),o.removeAllRanges(),o.addRange(r)}},r.prototype.activateEditor=function(n,l,h,d,v,m,g){var p,b,w,n,o,n,t,e,i,r,a,u,e,p=d&&d.sheet;if(p&&(b=this,w=n)){if(n=(0,E.GC$)(w),o=W(w),b._editingElement=w,n.attr(M)||n.attr(M,S),f.android&&n.bind("input"+C,function(t){try{b.fi(w,l,h,t,d,!1,v,m,g)}catch(t){}}),n.bind("keydown"+C,function(t){var n,e,i;try{n=t.keyCode,o&&(e={event:t,editor:w,value:w.innerText,caret:b.Xmt(w),cancel:!1},8===n?(O.Base.et(p,"editorBackspace",e),!0===e.cancel?(y(t),w.innerText=e.value,b.qmt(w,e.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:e.value})):s.processBackspaceAndLeftArrowKeyEvent(t,!0)):46===n?(O.Base.et(p,"editorDelete",e),!0===e.cancel?(y(t),w.innerText=e.value,b.qmt(w,e.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:e.value})):s.processDeleteAndRightArrowKeyEvent(t,!0)):37===n?s.processBackspaceAndLeftArrowKeyEvent(t,!1):39===n&&s.processDeleteAndRightArrowKeyEvent(t,!1),rn(t)?(O.Base.et(p,"editorUndo",e),!0===e.cancel&&(y(t),w.innerText=e.value,b.qmt(w,e.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:e.value}))):on(t)&&(O.Base.et(p,"editorRedo",e),!0===e.cancel)&&(y(t),w.innerText=e.value,b.qmt(w,e.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:e.value}))),((i=229===n||0===n)||b.Ni)&&!f.android||b.fi(w,l,h,t,d,!0,v,m,g),Zt(t,d,b.Ni,v,m,g)}catch(t){}}),n.bind("keyup"+C,function(t){var n,e,i,r,n=t.keyCode,e=t.ctrlKey,i=t.altKey,r;(!(229===n||0===n)&&!b.Ni||f.android)&&(46!==n&&8!==n&&(90!==n&&89!==n||!e||i)||(o&&"\n"===w.innerText&&(0,E.GC$)(w).empty(),b.fi(w,l,h,t,d,!1,v,m,g)),13!==n&&9!==n&&27!==n&&16!==n||e||i)&&p.ki(_,{sheet:p,sheetName:p.name(),row:p.ui,col:p.ci,editingText:b.getEditorValue(w,d)})}),n.bind("mousedown"+C,function(){1===p.Di&&(p.Di=2,p._i(1,2))}),n.bind("textInput"+C,function(t){var n,n,e,e;if(c.safari){if(t.metaKey||t.altKey||t.ctrlKey||"Enter"===t.key)return;n=t.key||t.data,n={editor:w,value:n,caret:b.Xmt(w),cancel:!1},O.Base.et(p,"editorInput",n),!0===n.cancel&&(y(t),w.innerText=n.value,e=p.getCellType(d.row,d.col),w.parentNode&&w.parentNode.parentNode&&e&&e.Rn(w.parentNode.parentNode,l,p.getCellRect(d.row,d.col),d),b.qmt(w,n.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:n.value}))}t.data&&(b.probabilityAddPercentSpec||b.probabilityAddPercent)&&/^[0-9]+.?[0-9]*/.test(t.data)&&((e=document.createElement("span")).innerText="%",e.id="updateEditorImpAddPercent",("#text"===w.firstChild.nodeName?w:w.firstChild).appendChild(e),delete b.probabilityAddPercentSpec,delete b.probabilityAddPercent)}),n.bind("compositionstart"+C,function(){b.Ni=!0,b.Ei=Q(w)}),n.bind("compositionupdate"+C,function(t){b.fi(w,l,h,t||x,d,!0,v,m,g)}),n.bind("compositionend"+C,function(t){var n,n,e,e,n,t,i,n=t.data,n={editor:w,value:n,caret:b.Xmt(w),isImeInputting:!0,cancel:!1};O.Base.et(p,"editorInput",n),!0===n.cancel&&(y(t),w.innerText=n.value,e=p.getCellType(d.row,d.col),w.parentNode&&w.parentNode.parentNode&&e&&e.Rn(w.parentNode.parentNode,l,p.getCellRect(d.row,d.col),d),b.qmt(w,n.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:n.value})),b.fi(w,l,h,t||x,d,!1,v,m,g),b.Ni=!1,e=t.keyCode,n=t.ctrlKey,t=t.altKey,i=b.getEditorValue(w,d)||"",b.Ei!==i&&(e===N||13!==e&&9!==e||n||t)&&p.ki(_,{sheet:p,sheetName:p.name(),row:p.ui,col:p.ci,editingText:i})}),o&&(n.bind("copy"+C,function(t){var n=T.clipboardData,e=t.clipboardData,i=Kt(t.currentTarget);L(i)||(n&&n.setData?(n.setData("text",i),y(t)):e&&e.setData&&(e.setData("text/plain",i),y(t)))}),n.bind("cut"+C,function(t){var n,n,e,i,r,r,n=Kt(t.currentTarget),e="editorCut";!L(n)&&w.Rse&&(T.clipboardData&&T.clipboardData.setData?(i="text",r=T.clipboardData):t.clipboardData&&t.clipboardData.setData&&(i="text/plain",r=t.clipboardData),n={editor:w,clipboardData:r,dataName:i,caret:b.Xmt(w)},O.Base.et(p,e,n),y(t),w.innerText=n.value,r=p.getCellType(d.row,d.col),w.parentNode&&w.parentNode.parentNode&&r&&r.Rn(w.parentNode.parentNode,l,p.getCellRect(d.row,d.col),d),b.qmt(w,n.caret))}),n.bind("paste"+C,function(t){var n,e,i,r,o,a,u,s,c,f,n=!1;try{e=void 0,B&&!j&&T.clipboardData&&T.clipboardData.getData?e=T.clipboardData.getData("text"):t.clipboardData&&t.clipboardData.getData&&(e=t.clipboardData.getData("text/plain")),e=Yt(e=e.replace(/\r\n?/g,"\n")),i={editor:w,pasteValue:e,caret:b.Xmt(w),cancel:!1},O.Base.et(p,"editorPaste",i),!0===i.cancel?(n=!0,w.innerText=i.pasteValue,b.qmt(w,i.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:i.pasteValue})):0<(r=T.getSelection()).rangeCount&&((a=(o=r.getRangeAt(0)).startOffset)!==(u=o.endOffset)&&o.deleteContents(),nn(w,e,a)||(s=I.createElement("span"),"\n"===(e=e.replace(/\u200B/g,""))[(c=e.length)-1]&&(e="\r"===e[c-2]?e.substr(0,c-2):e.substr(0,c-1)),s.innerText=e,o.insertNode(s),(f=document.createRange()).setStartAfter(s),f.setEndAfter(s),f.collapse(!1),r.removeAllRanges(),r.addRange(f),n=!0))}catch(t){}if(b.ji=T.setTimeout(function(){b.fi(w,l,h,t,d,!1,v,m,g),p.parent&&p.parent.ki(R.Events.FormulaTextBoxUpdatePosition,void 0),b.ji&&(clearTimeout(b.ji),delete b.ji)},10),n)return!1}),n.bind("keypress"+C,function(t){var n,n,t;t.metaKey||t.altKey||t.ctrlKey||"Enter"===t.key||(n=t.key||t.data,n={editor:w,value:n,caret:b.Xmt(w),cancel:!1},O.Base.et(p,"editorInput",n),!0===n.cancel&&(y(t),w.innerText=n.value,t=p.getCellType(d.row,d.col),w.parentNode&&w.parentNode.parentNode&&t&&t.Rn(w.parentNode.parentNode,l,p.getCellRect(d.row,d.col),d),b.qmt(w,n.caret),p.ki(R.Events.FormulaTextBoxTextChanged,{sheet:p,sheetName:p.name(),text:n.value})))})),t=n=void 0,(n=!d||(t=k&&p.getFormula(d.row,d.col))?n:l.mask)&&n.pattern&&"="===n.pattern[0]){e=p.Lp,i=p.Uw(3),r=0<=d.row?d.row:0,a=0<=d.col?d.col:0;try{u=e.evaluate(i,n.pattern,r,a),n.pattern="object"==typeof u?"":""+u}catch(t){n.pattern=""}}e={editor:w,ns:C,mask:n,text:Q(w)},O.Base.et(p,"activateEditor",e)}},r.prototype.deactivateEditor=function(t,n){var e,i,r,o,a,u,s,c,f,l,e=this;if(O.Base.et(n&&n.sheet,"deactivateEditor",{editor:t}),t&&n&&n.sheet){if(i=n.sheet,e.Ni&&gt&&i.Oi)try{(0,E.GC$)(t).trigger("compositionend"+C)}catch(t){}if(r=i.getActualStyle(n.row,n.col,n.sheetArea).cellPadding)for(o=[F,ut],a=[3,0],u=0;u<o.length;u++)s=parseInt(an(r)[a[u]],10),e.shiftPadding(t,o[u],s=typeof s==Nt&&0<s?s:0);(0,E.GC$)(t).unbind(C),c=i.getActiveRowIndex(),f=i.getActiveColumnIndex(),l=i.getActualStyle(c,f),i.Ri(e,t,c,f,l,N,N,N,N,n.sheetArea)}e._editingElement=x},r.prototype.shiftPadding=function(t,n,e){var t=(0,E.GC$)(t).parent();t&&(n===F?t.css({left:(+(0,E.GC$)(t).css(F).replace("px","")||0)-e}):n===ut&&t.css({top:(+(0,E.GC$)(t).css(ut).replace("px","")||0)-e}))},r.prototype.getEditingElement=function(){return this._editingElement},r.prototype.Bi=function(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,r,m,g,p,b,w,y,M,C,S,T,A,y,A,t,b,a,b,l,t,e,I,v,e,x,N,k,_,v,I,D,j,e,a,b,m,f,i,c=r&&r.sheet,f=this,l=c.options.sheetAreaOffset,h=t;if(h&&c&&(d=(0,E.GC$)(h),v=c.Dn,r=r.preventOverflow,m=Q(h),c.isEditing())){if(g=W(h),b=F,w=p=void 0,y=O.Context.gn,T=S=C=M=0,n&&(M=y(n,0,!1,A=c.zoom()),C=y(n,1,!1,A),S=y(n,2,!1,A),T=y(n,3,!1,A),1===(p=X(n.hAlign,t.Li))?b=at:2===p&&(b=ot),d.css(st,b),n.foreColor&&d.css("color",n.foreColor),(w=n.font||v.Nn())&&(1<c.zoom()&&(w=v._n(w)),d.css("font",et(w))),n.textDecoration)&&f.Qe(d,n.textDecoration),y=(Z(d.css("padding-left"),10)||0)+(Z(d.css("padding-right"),10)||0),A=(Z(d.css("padding-top"),10)||0)+(Z(d.css("padding-bottom"),10)||0),e||(y+=2*Number(d.parent().css("left").replace("px","")),A+=2*Number(d.parent().css("top").replace("px",""))),(a=L(a)?e:a)&&(t=c.Fi(),b=e.width,a.x+a.width-l.left>t.width&&(b=e.width=t.width-e.x,a.width=t.width-a.x),d.css(G,b-y).css(U,e.height-A),h.maxWidth=l.left+t.width-e.x-y-C,d.css("max-width",h.maxWidth+"px"),h.maxHeight=l.top+t.height-e.y-A-S,h.minWidth=Z(h.style.width,10),h.minHeight=Z(h.style.height,10)),a=Rt(h),b=Lt(h),l=(o=(o=o&&i&&i.keyCode&&c.rt.Pi(i)&&0===a&&b===m.length)||c.Ai)&&!n.mask?"":m,w=(w=h.style.font)||v._n(v.Nn()),t=q(w),i&&f.probabilityAddPercent&&(e=i.key)&&-1!==R.NUMBER_ARRAY.indexOf(e)&&(c.parent.options.enableFormulaTextbox?(v=h.innerText,/[a-z]/i.test(v)?f.probabilityAddPercent=!1:((I=document.createElement("span")).innerText="%",I.id="updateEditorImpAddPercent",h.appendChild(I),delete f.probabilityAddPercent)):((I=document.createElement("span")).innerText="%",I.id="updateEditorImpAddPercent",h.firstChild.appendChild(I),delete f.probabilityAddPercent)),!o&&i&&(e=c.parent,c.rt.Pi(i)&&8!==i.keyCode&&L(e.contextMenu.menuView.getHost())&&(l=zt(h,l,a,b,i)),f.Ni)&&(l=B?m:f.Ei+i.data),x=[],k=N=void 0,_=(x=n&&n.wordWrap?J.un(l,Z(h.style.width)-y,w):l.split(/\r\n|\r|\n/)).length,h.minWidth=wt(h.minWidth,h.maxWidth),h.minHeight=wt(h.minHeight,h.maxHeight),n&&n.wordWrap||0<_){if(I=v=void 0,v=K?$t(I=qt(x,w)):_*t,n&&n.wordWrap)d.css(V,ft).css(z,H).css("max-width",h.style.width);else{for(j=[],N=D=0;N<_;N++)k=bt(c.Gi(x[N],w)),j.push(k),D=St(D,k);e=d.css(V),a=Z(h.style.width),n||e!==ft?D<=h.minWidth?(d.css(G,h.minWidth).css(V,Y).css(z,H),g&&d.css(dt,Y)):D>h.minWidth&&D<=h.maxWidth&&!r?(d.css(G,D).css(V,Y).css(z,H),g&&d.css(dt,Y)):D>h.maxWidth&&!r&&(d.css(G,h.maxWidth-2).css(V,ft).css(z,H),v=tn(j,h.maxWidth,t,I)):a<D&&!r&&(v=tn(j,a,t,I))}v<=h.minHeight?d.css(U,h.minHeight).css(vt,P):v>h.minHeight&&v<=h.maxHeight?d.css(U,v).css(vt,P):v>h.maxHeight&&d.css(U,h.maxHeight-1).css(lt,ht).css(vt,F)}return p=d.css(st),b=d.width()-h.minWidth,L(p)||p===F||(p===at?d.css(F,h.originalLeft-b/2):p===ot&&d.css(F,h.originalLeft-b)),n&&g&&(1===(m=n.vAlign)?d.css(ct,"middle"):2===m&&d.css(ct,"bottom")),f=Z(h.style.height)+A+M+S,i=y+T+C,d.css(lt)===ht?{width:h.offsetWidth+i,height:o?0:f}:{width:Z(h.style.width)+i,height:f}}},r.prototype.updateEditor=function(t,n,e,i,r,o,a){var n,i,u;return e=this.Bi(t,n,e,x,i,!1,r,o,a),B&&t&&(i=(n=(0,E.GC$)(t))[0].style.width,n.width(i+1).width(i)),u=!L(e)&&t?new R.Rect(t.style.left?parseFloat(t.style.left):0,t.style.top?parseFloat(t.style.top):0,e.width,e.height):u},r.prototype.fi=function(t,n,e,i,r,o,a,u,s){var i,o;e=this.Bi(t,n,e,i,r,o,a,u,s),B&&t&&(o=(i=(0,E.GC$)(t))[0].style.width,i.width(o+1).width(o)),!L(e)&&t&&(L(a)?a=e:(a.x=N,a.y=N),this.updateEditorContainer(t,e,n,r,a,u,s))},r.prototype.updateEditorContainer=function(t,n,e,i,r,o,a){var u,u,s;i&&i.preventOverflow?(l.prototype.updateEditorContainer.call(this,t,n,e,i,r,o,a),(u=t.parentNode)&&n&&(u=(0,E.GC$)(u),0<(s=n.width))&&u.width(s)):(n&&n.width&&r&&r.width&&(r.width=n.width),n&&n.height&&r&&r.height&&(r.height=n.height),l.prototype.updateEditorContainer.call(this,t,n,e,i,r,o,a))},r.prototype.updateImeMode=function(t,n,e){this.isImeAware()&&t&&O.Context.hn(t,n)},r.prototype.isReservedKey=function(t,n){var e=t.srcElement||t.target,i=t.keyCode,r=t.ctrlKey,o=t.altKey,a=t.metaKey;return!!(e&&n&&n.isEditing&&e.getAttribute(M)===S)&&(13===i&&(r&&!t.shiftKey||o)||90===i&&r&&!o||89===i&&r&&!o||67===i&&(r||a)&&!o||88===i&&(r||a)&&!o)},r.prototype.isImeAware=function(t){return!0},r.prototype.toJSON=function(){var t,n,e,t={},n=this;for(e in n)n.hasOwnProperty(e)&&"_editingElement"!==e&&(t[e]=n[e]);return t},r.prototype.lfe=function(t,n){var n={eventName:n,eventArg:t};return O.Base.et(t.sheet,"onCreateEventArg",n),n.eventArg},t.Text=u=r,v.ti[1]=u},"./dist/core/core.definition.js":function(){},"./dist/core/core.entry.js":function(t,n,e){"use strict";var i,r,o,a,u,s,s,r,e;function c(t,n){return a.n1e(t,n)}i=this&&this.__createBinding||(Object.create?function(t,n,e,i){void 0===i&&(i=e);var r=Object.getOwnPropertyDescriptor(n,e);r&&("get"in r?n.__esModule:!r.writable&&!r.configurable)||(r={enumerable:!0,get:function(){return n[e]}}),Object.defineProperty(t,i,r)}:function(t,n,e,i){t[i=void 0===i?e:i]=n[e]}),r=this&&this.__exportStar||function(t,n){for(var e in t)"default"===e||Object.prototype.hasOwnProperty.call(n,e)||i(n,t,e)},Object.defineProperty(n,"__esModule",{value:!0}),n.Aoe=n.n1e=n.CellTypes=void 0,e("./dist/core/core.res.en.js"),o=e("./dist/core/util/common.js"),Object.defineProperty(n,"getTypeFromString",{set:function(t){o.getTypeFromString=t},get:function(){return o.getTypeFromString}}),r(e("./dist/core/core.ns.js"),n),r(e("./dist/core/core.interface.js"),n),r(e("./dist/core/core.enum.js"),n),r(e("./dist/core/util/common.js"),n),r(e("./dist/core/excel-io-util/common.js"),n),r(e("./dist/core/excel-io-util/excel-types.js"),n),r(e("./dist/core/excel-io-util/range-parser.js"),n),r(e("./dist/core/excel-io-util/excel-helper.js"),n),r(e("./dist/core/excel-io-util/excel-style.js"),n),r(e("./dist/core/util/domUtil.js"),n),e("./dist/core/core.definition.js"),s=-1,1===(u=(a=e("./dist/core/lc/releaseLc.js"))._pt)&&(s=Math.floor(5*Math.random()),n["G".concat("C","$")]["s".concat("d")]=s),r(e("./dist/core/util/theme.js"),n),r(e("./dist/core/util/basedialog.js"),n),r(e("./dist/core/util/imageLoader.js"),n),r(e("./dist/core/util/tasks.js"),n),r(e("./dist/core/util/crypto.js"),n),0===s&&e("./dist/core/lc/lcRegister.js"),r(e("./dist/core/worksheet/stylehelper.js"),n),1===s&&e("./dist/core/lc/lcRegister.js"),r(e("./dist/core/worksheet/style.js"),n),2===s&&e("./dist/core/lc/lcRegister.js"),r(e("./dist/core/worksheet/clipboardhelper.js"),n),3===s&&e("./dist/core/lc/lcRegister.js"),r(e("./dist/core/worksheet/worksheet-model.js"),n),4===s&&e("./dist/core/lc/lcRegister.js"),r(e("./dist/core/worksheet/worksheet.js"),n),r(e("./dist/core/worksheet/worksheet-formatter.js"),n),r(e("./dist/core/worksheet/worksheet-actions.js"),n),r(e("./dist/core/worksheet/worksheet-border.js"),n),e("./dist/core/worksheet/worksheet-edit.js"),r(e("./dist/core/worksheet/worksheet-event.js"),n),e("./dist/core/worksheet/worksheet-json.js"),r(e("./dist/core/worksheet/worksheet-render.js"),n),e("./dist/core/worksheet/worksheet-selection.js"),e("./dist/core/worksheet/worksheet-sort.js"),r(e("./dist/core/worksheet/worksheet-ui.js"),n),r(e("./dist/core/worksheet/worksheet-static.js"),n),r(e("./dist/core/workbook/workbook.js"),n),r(e("./dist/core/workbook/workbook-json.js"),n),r(e("./dist/core/workbook/sheettabbase.js"),n),r(e("./dist/core/workbook/sheettab.js"),n),r(e("./dist/core/workbook/sheettab2007.js"),n),r(e("./dist/core/workbook/workbookpanelex.js"),n),r(e("./dist/core/util/styleManager.js"),n),s=e("./dist/core/celltype/cellType.entry.js"),n.CellTypes=s,r=e("./dist/core/celltype/headercelltype.js"),e=e("./dist/core/celltype/textcelltype.js"),s.Hi=r,s.zi=e,1!==u&&2!==u||a.Vi(n),n.n1e=c,n.Aoe=a.Aoe},"./dist/core/core.enum.js":function(L,t){"use strict";var n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,E,B,F,P,G,U,H,V,z,Y,O,Z,W,Q,J,K,X,q,$,tt,nt,et,it,rt,ot,at,ut,st,ct,ft,lt,ht,dt,vt,mt,gt,pt,bt,wt,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,R,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O,R,O;Object.defineProperty(t,"__esModule",{value:!0}),t.CalendarPage=t.LayoutDisplayAs=t.LayoutDirection=t.CaptionAlignment=t.IconPosition=t.ButtonPosition=t.DropDownType=t.ButtonImageType=t.ButtonVisibility=t.RowColumnStates=t.CellStatesType=t.SortState=t.SheetArea=t.VerticalPosition=t.HorizontalPosition=t.Yi=t.ImageLayout=t.ValueType=t.RangeChangedAction=t.HeaderAutoText=t.StorageType=t.SelectionUnit=t.SelectionPolicy=t.ImeMode=t.EditorStatus=t.VisualState=t.Zi=t.VertAlign=t.VerticalAlign=t.HorizontalAlign=t.TextDecorationType=t.LabelVisibility=t.LabelAlignment=t.CopyToOptions=t.ClipboardPasteOptions=t.AutoFitType=t.InvalidOperationType=t.ResizeZeroIndicator=t.HeaderOptions=t.CalculationType=t.CalculationMode=t.CopyPasteHeaderOptions=t.ResizeMode=t.InsertShiftCell=t.ShowScrollTip=t.ScrollbarAppearance=t.ShowResizeTip=t.ScrollbarState=t.AxisInfoChangeType=t.ScrollType=void 0,t.DefaultChangeValueType=t.ClipboardActionType=t.OpenMode=t.OpenSaveFileType=t.FileType=t.TableStyleElement=t.SortBy=t.UsedRangeType=t.ColumnHeaderFitMode=t.AllSheetsListVisibility=t.SheetTabVisible=t.SheetType=t.HyperlinkTargetType=t.TabStripPosition=t.NumbersFitMode=t.PatternType=t.DropDownAlignment=t.DropDownDirection=t.DropdownListValue=t.GroupSort=t.CalendarStartDay=void 0,(O=n=t.ScrollType||(t.ScrollType={}))[O.pixels=0]="pixels",O[O.continuous=1]="continuous",(O=e=t.AxisInfoChangeType||(t.AxisInfoChangeType={}))[O.setRowCount=0]="setRowCount",O[O.setColumnCount=1]="setColumnCount",O[O.addRows=2]="addRows",O[O.deleteRows=3]="deleteRows",O[O.addColumns=4]="addColumns",O[O.deleteColumns=5]="deleteColumns",O[O.setRowHeight=6]="setRowHeight",O[O.setColumnWidth=7]="setColumnWidth",O[O.setRowVisible=8]="setRowVisible",O[O.setColumnVisible=9]="setColumnVisible",O[O.filterRows=10]="filterRows",O[O.outlineExpandRows=11]="outlineExpandRows",O[O.outlineExpandColumns=12]="outlineExpandColumns",(O=i=t.ScrollbarState||(t.ScrollbarState={}))[O.hide=0]="hide",O[O.show=1]="show",O[O.active=2]="active",O[O.inactive=3]="inactive",(O=r=t.ShowResizeTip||(t.ShowResizeTip={}))[O.none=0]="none",O[O.column=1]="column",O[O.row=2]="row",O[O.both=3]="both",(O=o=t.ScrollbarAppearance||(t.ScrollbarAppearance={}))[O.skin=0]="skin",O[O.mobile=1]="mobile",(O=a=t.ShowScrollTip||(t.ShowScrollTip={}))[O.none=0]="none",O[O.horizontal=1]="horizontal",O[O.vertical=2]="vertical",O[O.both=3]="both",(O=u=t.InsertShiftCell||(t.InsertShiftCell={}))[O.right=0]="right",O[O.down=1]="down",(O=s=t.ResizeMode||(t.ResizeMode={}))[O.normal=0]="normal",O[O.split=1]="split",(O=c=t.CopyPasteHeaderOptions||(t.CopyPasteHeaderOptions={}))[O.noHeaders=0]="noHeaders",O[O.rowHeaders=1]="rowHeaders",O[O.columnHeaders=2]="columnHeaders",O[O.allHeaders=3]="allHeaders",(O=f=t.CalculationMode||(t.CalculationMode={}))[O.auto=0]="auto",O[O.manual=1]="manual",(O=l=t.CalculationType||(t.CalculationType={}))[O.all=0]="all",O[O.rebuild=1]="rebuild",O[O.minimal=2]="minimal",O[O.regular=3]="regular",(O=h=t.HeaderOptions||(t.HeaderOptions={}))[O.noHeaders=0]="noHeaders",O[O.rowHeaders=1]="rowHeaders",O[O.columnHeaders=2]="columnHeaders",O[O.allHeaders=3]="allHeaders",(O=d=t.ResizeZeroIndicator||(t.ResizeZeroIndicator={}))[O.default=0]="default",O[O.enhanced=1]="enhanced",(O=v=t.InvalidOperationType||(t.InvalidOperationType={}))[O.setFormula=0]="setFormula",O[O.copyPaste=1]="copyPaste",O[O.dragFill=2]="dragFill",O[O.dragDrop=3]="dragDrop",O[O.changePartOfArrayFormula=4]="changePartOfArrayFormula",O[O.changeSheetName=5]="changeSheetName",O[O.table=6]="table",O[O.filter=7]="filter",O[O.hideSheet=8]="hideSheet",O[O.sort=9]="sort",O[O.pivotTable=10]="pivotTable",O[O.ptOverlapValue=11]="ptOverlapValue",O[O.groupProtected=12]="groupProtected",O[O.editProtected=13]="editProtected",O[O.cutProtected=14]="cutProtected",O[O.customName=15]="customName",O[O.dataObjectCellTypeInsertData=16]="dataObjectCellTypeInsertData",(O=m=t.AutoFitType||(t.AutoFitType={}))[O.cell=0]="cell",O[O.cellWithHeader=1]="cellWithHeader",(O=g=t.ClipboardPasteOptions||(t.ClipboardPasteOptions={}))[O.all=0]="all",O[O.values=1]="values",O[O.formatting=2]="formatting",O[O.formulas=3]="formulas",O[O.valuesAndFormatting=4]="valuesAndFormatting",O[O.formulasAndFormatting=5]="formulasAndFormatting",(O=p=t.CopyToOptions||(t.CopyToOptions={}))[O.value=1]="value",O[O.formula=2]="formula",O[O.comment=4]="comment",O[O.outline=8]="outline",O[O.sparkline=16]="sparkline",O[O.span=32]="span",O[O.style=64]="style",O[O.tag=128]="tag",O[O.bindingPath=256]="bindingPath",O[O.conditionalFormat=512]="conditionalFormat",O[O.hyperlink=1024]="hyperlink",O[O.defaultValue=2048]="defaultValue",O[O.altText=4096]="altText",O[O.all=8191]="all",(O=b=t.LabelAlignment||(t.LabelAlignment={}))[O.topLeft=0]="topLeft",O[O.topCenter=1]="topCenter",O[O.topRight=2]="topRight",O[O.bottomLeft=3]="bottomLeft",O[O.bottomCenter=4]="bottomCenter",O[O.bottomRight=5]="bottomRight",(O=w=t.LabelVisibility||(t.LabelVisibility={}))[O.visible=0]="visible",O[O.hidden=1]="hidden",O[O.auto=2]="auto",(O=y=t.TextDecorationType||(t.TextDecorationType={}))[O.underline=1]="underline",O[O.lineThrough=2]="lineThrough",O[O.overline=4]="overline",O[O.doubleUnderline=8]="doubleUnderline",O[O.none=0]="none",(O=M=t.HorizontalAlign||(t.HorizontalAlign={}))[O.left=0]="left",O[O.center=1]="center",O[O.right=2]="right",O[O.general=3]="general",O[O.centerContinuous=4]="centerContinuous",(O=C=t.VerticalAlign||(t.VerticalAlign={}))[O.top=0]="top",O[O.center=1]="center",O[O.bottom=2]="bottom",(O=S=t.VertAlign||(t.VertAlign={}))[O.normal=0]="normal",O[O.superscript=1]="superscript",O[O.subscript=2]="subscript",(O=T=t.Zi||(t.Zi={}))[O.smallDecrement=0]="smallDecrement",O[O.smallIncrement=1]="smallIncrement",O[O.largeDecrement=2]="largeDecrement",O[O.largeIncrement=3]="largeIncrement",O[O.thumbPosition=4]="thumbPosition",O[O.thumbTrack=5]="thumbTrack",O[O.endScroll=6]="endScroll",(O=A=t.VisualState||(t.VisualState={}))[O.normal=0]="normal",O[O.highlight=1]="highlight",O[O.selected=2]="selected",O[O.active=3]="active",O[O.hover=4]="hover",O[O.activeNotSelected=5]="activeNotSelected",(O=I=t.EditorStatus||(t.EditorStatus={}))[O.ready=0]="ready",O[O.enter=1]="enter",O[O.edit=2]="edit",(O=x=t.ImeMode||(t.ImeMode={}))[O.auto=1]="auto",O[O.active=2]="active",O[O.inactive=4]="inactive",O[O.disabled=0]="disabled",(O=N=t.SelectionPolicy||(t.SelectionPolicy={}))[O.single=0]="single",O[O.range=1]="range",O[O.multiRange=2]="multiRange",(O=k=t.SelectionUnit||(t.SelectionUnit={}))[O.cell=0]="cell",O[O.row=1]="row",O[O.column=2]="column",(O=_=t.StorageType||(t.StorageType={}))[O.data=1]="data",O[O.style=2]="style",O[O.comment=4]="comment",O[O.tag=8]="tag",O[O.sparkline=16]="sparkline",O[O.axis=32]="axis",O[O.bindingPath=64]="bindingPath",O[O.hyperlink=256]="hyperlink",O[O.altText=512]="altText",(O=D=t.HeaderAutoText||(t.HeaderAutoText={}))[O.blank=0]="blank",O[O.numbers=1]="numbers",O[O.letters=2]="letters",(O=j=t.RangeChangedAction||(t.RangeChangedAction={}))[O.dragDrop=0]="dragDrop",O[O.dragFill=1]="dragFill",O[O.clear=2]="clear",O[O.paste=3]="paste",O[O.sort=4]="sort",O[O.setArrayFormula=5]="setArrayFormula",O[O.evaluateFormula=6]="evaluateFormula",(O=E=t.ValueType||(t.ValueType={}))[O.normal=0]="normal",O[O.richText=1]="richText",(O=B=t.ImageLayout||(t.ImageLayout={}))[O.stretch=0]="stretch",O[O.center=1]="center",O[O.zoom=2]="zoom",O[O.none=3]="none",(O=F=t.Yi||(t.Yi={})).ThumbButton="thumbButton",O.TrackButton="trackButton",O.LeftButton="leftButton",O.RightButton="rightButton",O.UpButton="upButton",O.DownButton="downButton",(O=P=t.HorizontalPosition||(t.HorizontalPosition={}))[O.left=0]="left",O[O.center=1]="center",O[O.right=2]="right",O[O.nearest=3]="nearest",(O=G=t.VerticalPosition||(t.VerticalPosition={}))[O.top=0]="top",O[O.center=1]="center",O[O.bottom=2]="bottom",O[O.nearest=3]="nearest",(O=U=t.SheetArea||(t.SheetArea={}))[O.corner=0]="corner",O[O.colHeader=1]="colHeader",O[O.rowHeader=2]="rowHeader",O[O.viewport=3]="viewport",(O=H=t.SortState||(t.SortState={}))[O.none=0]="none",O[O.ascending=1]="ascending",O[O.descending=2]="descending",(O=V=t.CellStatesType||(t.CellStatesType={}))[O.hover=1]="hover",O[O.invalid=2]="invalid",O[O.readonly=4]="readonly",O[O.edit=8]="edit",O[O.active=16]="active",O[O.selected=32]="selected",O[O.dirty=64]="dirty",O[O.invalidFormula=128]="invalidFormula",(O=z=t.RowColumnStates||(t.RowColumnStates={}))[O.hover=1]="hover",O[O.invalid=2]="invalid",O[O.edit=8]="edit",O[O.active=16]="active",O[O.selected=32]="selected",O[O.dirty=64]="dirty",O[O.inserted=128]="inserted",O[O.invalidFormula=512]="invalidFormula",(O=Y=t.ButtonVisibility||(t.ButtonVisibility={}))[O.always=0]="always",O[O.onSelected=1]="onSelected",O[O.onEditing=2]="onEditing",(R=O=t.ButtonImageType||(t.ButtonImageType={}))[R.none=0]="none",R[R.custom=1]="custom",R[R.clear=2]="clear",R[R.cancel=3]="cancel",R[R.ok=4]="ok",R[R.dropdown=5]="dropdown",R[R.ellipsis=6]="ellipsis",R[R.left=7]="left",R[R.right=8]="right",R[R.plus=9]="plus",R[R.minus=10]="minus",R[R.undo=11]="undo",R[R.redo=12]="redo",R[R.search=13]="search",R[R.separator=14]="separator",R[R.spinLeft=15]="spinLeft",R[R.spinRight=16]="spinRight",R[R.collapse=17]="collapse",R[R.expand=18]="expand",O.calcel=O.cancel,(R=Z=t.DropDownType||(t.DropDownType={}))[R.colorPicker=0]="colorPicker",R[R.dateTimePicker=1]="dateTimePicker",R[R.timePicker=2]="timePicker",R[R.monthPicker=3]="monthPicker",R[R.list=4]="list",R[R.slider=5]="slider",R[R.calculator=6]="calculator",R[R.workflowList=7]="workflowList",R[R.multiColumn=8]="multiColumn",(O=W=t.ButtonPosition||(t.ButtonPosition={}))[O.left=0]="left",O[O.right=1]="right",O[O.leftOfText=2]="leftOfText",O[O.rightOfText=3]="rightOfText",(R=Q=t.IconPosition||(t.IconPosition={}))[R.left=0]="left",R[R.right=1]="right",R[R.leftOfText=2]="leftOfText",R[R.rightOfText=3]="rightOfText",R[R.outsideLeft=4]="outsideLeft",R[R.outsideRight=5]="outsideRight",(O=J=t.CaptionAlignment||(t.CaptionAlignment={}))[O.left=0]="left",O[O.right=1]="right",(R=K=t.LayoutDirection||(t.LayoutDirection={}))[R.horizontal=0]="horizontal",R[R.vertical=1]="vertical",(O=X=t.LayoutDisplayAs||(t.LayoutDisplayAs={}))[O.inline=0]="inline",O[O.popup=1]="popup",O[O.tree=2]="tree",(R=q=t.CalendarPage||(t.CalendarPage={}))[R.year=1]="year",R[R.month=2]="month",R[R.day=3]="day",(O=$=t.CalendarStartDay||(t.CalendarStartDay={}))[O.monday=1]="monday",O[O.tuesday=2]="tuesday",O[O.wednesday=3]="wednesday",O[O.thursday=4]="thursday",O[O.friday=5]="friday",O[O.saturday=6]="saturday",O[O.sunday=7]="sunday",(R=tt=t.GroupSort||(t.GroupSort={}))[R.none=0]="none",R[R.group=1]="group",R[R.child=2]="child",R[R.full=3]="full",(O=nt=t.DropdownListValue||(t.DropdownListValue={}))[O.string=0]="string",O[O.array=1]="array",(R=et=t.DropDownDirection||(t.DropDownDirection={}))[R.Down=0]="Down",R[R.Up=1]="Up",R[R.Left=2]="Left",R[R.Right=3]="Right",(O=it=t.DropDownAlignment||(t.DropDownAlignment={}))[O.Near=0]="Near",O[O.Center=1]="Center",O[O.Far=2]="Far",(R=rt=t.PatternType||(t.PatternType={}))[R.solid=1]="solid",R[R.darkGray=2]="darkGray",R[R.mediumGray=3]="mediumGray",R[R.lightGray=4]="lightGray",R[R.gray125=5]="gray125",R[R.gray0625=6]="gray0625",R[R.darkHorizontal=7]="darkHorizontal",R[R.darkVertical=8]="darkVertical",R[R.darkDown=9]="darkDown",R[R.darkUp=10]="darkUp",R[R.darkGrid=11]="darkGrid",R[R.darkTrellis=12]="darkTrellis",R[R.lightHorizontal=13]="lightHorizontal",R[R.lightVertical=14]="lightVertical",R[R.lightDown=15]="lightDown",R[R.lightUp=16]="lightUp",R[R.lightGrid=17]="lightGrid",R[R.lightTrellis=18]="lightTrellis",(O=ot=t.NumbersFitMode||(t.NumbersFitMode={}))[O.mask=0]="mask",O[O.overflow=1]="overflow",(R=at=t.TabStripPosition||(t.TabStripPosition={}))[R.bottom=0]="bottom",R[R.top=1]="top",R[R.left=2]="left",R[R.right=3]="right",(O=ut=t.HyperlinkTargetType||(t.HyperlinkTargetType={}))[O.blank=0]="blank",O[O.self=1]="self",O[O.parent=2]="parent",O[O.top=3]="top",(R=st=t.SheetType||(t.SheetType={}))[R.tableSheet=0]="tableSheet",R[R.ganttSheet=1]="ganttSheet",R[R.customSheetTab=2]="customSheetTab",(O=ct=t.SheetTabVisible||(t.SheetTabVisible={}))[O.hidden=0]="hidden",O[O.visible=1]="visible",O[O.veryHidden=2]="veryHidden",(R=ft=t.AllSheetsListVisibility||(t.AllSheetsListVisibility={}))[R.hide=0]="hide",R[R.show=1]="show",R[R.auto=2]="auto",(O=lt=t.ColumnHeaderFitMode||(t.ColumnHeaderFitMode={}))[O.normal=0]="normal",O[O.vertical=1]="vertical",O[O.stack=2]="stack",(R=ht=t.UsedRangeType||(t.UsedRangeType={}))[R.all=262143]="all",R[R.axis=1]="axis",R[R.style=2]="style",R[R.rowStyle=4]="rowStyle",R[R.colStyle=8]="colStyle",R[R.data=16]="data",R[R.formula=32]="formula",R[R.span=64]="span",R[R.shape=128]="shape",R[R.table=256]="table",R[R.sparkLine=512]="sparkLine",R[R.comment=1024]="comment",R[R.slicer=2048]="slicer",R[R.pivottable=4096]="pivottable",R[R.filter=8192]="filter",R[R.dataValidation=16384]="dataValidation",R[R.conditionFormat=32768]="conditionFormat",R[R.chart=65536]="chart",R[R.picture=131072]="picture",(O=dt=t.SortBy||(t.SortBy={})).cellColor="cellColor",O.fontColor="fontColor",O.icon="icon",O.value="value",(R=vt=t.TableStyleElement||(t.TableStyleElement={})).wholeTable="wholeTable",R.firstColumnStripe="firstColumnStripe",R.secondColumnStripe="secondColumnStripe",R.firstRowStripe="firstRowStripe",R.secondRowStripe="secondRowStripe",R.lastColumn="lastColumn",R.firstColumn="firstColumn",R.headerRow="headerRow",R.totalRow="totalRow",R.firstHeaderCell="firstHeaderCell",R.lastHeaderCell="lastHeaderCell",R.firstTotalCell="firstTotalCell",R.lastTotalCell="lastTotalCell",(O=mt=t.FileType||(t.FileType={}))[O.excel=0]="excel",O[O.ssjson=1]="ssjson",O[O.csv=2]="csv",(R=gt=t.OpenSaveFileType||(t.OpenSaveFileType={}))[R.excel=0]="excel",R[R.sjs=1]="sjs",(O=pt=t.OpenMode||(t.OpenMode={}))[O.normal=0]="normal",O[O.lazy=1]="lazy",O[O.incremental=2]="incremental",(R=bt=t.ClipboardActionType||(t.ClipboardActionType={}))[R.copy=1]="copy",R[R.cut=2]="cut",R[R.reset=3]="reset",(O=wt=t.DefaultChangeValueType||(t.DefaultChangeValueType={})).Expression="expr",O.Value="value"},"./dist/core/core.interface.js":function(t,n){"use strict";var e,n;Object.defineProperty(n,"__esModule",{value:!0}),n.CornerPosition=void 0,(n=e=n.CornerPosition||(n.CornerPosition={}))[n.leftTop=1]="leftTop",n[n.rightTop=2]="rightTop",n[n.leftBottom=4]="leftBottom",n[n.rightBottom=8]="rightBottom"},"./dist/core/core.ns.js":function(t,n,e){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.SR=void 0;var e=e("./dist/core/core.res.en.js");n.SR={en:e}},"./dist/core/core.res.en.js":function(t,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.ARIA_HasValue=n.ARIA_Cell=n.ARIA_Scrollbar_TRACK_Button=n.ARIA_Scrollbar_Bottom_Button=n.ARIA_Scrollbar_Right_Button=n.ARIA_Scrollbar_Thumb_Button=n.ARIA_Scrollbar_Top_Button=n.ARIA_Scrollbar_Left_Button=n.ARIA_Blank=n.ARIA_NewSheet=n.ARIA_SheetTab=n.ARIA_NextButton=n.ARIA_PreviousButton=n.ARIA_Last=n.ARIA_NextArrow=n.ARIA_PreviousArrow=n.ARIA_First=n.ARIA_Resize=n.NeedCanvasSupport=n.Exp_OverlappingSpans=n.Exp_SheetIsNull=n.Exp_DestSheetIsNull=n.Exp_ArrayFormulaSpan=n.Exp_SheetNameConflict=n.Exp_SheetNameInvalid=n.Exp_EmptyNamedStyle=n.NewTab=n.Tip_Width=n.Tip_Height=n.Tip_Column_Offset=n.Tip_Column=n.Tip_Row=n.Exp_PasteChangeMergeCell=n.Exp_PasteDestinationCellsLocked=n.Exp_InvalidCopyPasteSize=n.Exp_PasteSourceCellsLocked=n.Exp_ArgumentOutOfRange=n.Exp_NotAFunction=n.Exp_InvalidRange=n.Exp_IndexOutOfRange=n.Exp_InvalidCustomName=n.Exp_InvalidCustomFunction=n.Exp_DestIsNull=n.Exp_SrcIsNull=n.Exp_InvalidAndSpace=n.Exp_ChangePartOfArray=n.Exp_MultipleSelections=n.Exp_InvalidPastedArea=n.Exp_PasteExtentIsNull=n.Exp_NotSupported=void 0,n.STEP=n.EXP_UNSUPPORT_CRYPTO_ALGORITHM=n.GENERAL=n.NORMAL=n.EXP_INVALID_PASSWORD=n.EXP_NO_PASSWORD=n.EXP_FILE_FORMAT=n.EXP_IO=n.Exp_InvalidOperationInProtect=n.Exp_InvalidSortPartTableOrMultiTableInRange=n.Exp_InvalidSortSpanInRange=n.Exp_InvalidSortArrayFormulaInRange=n.Exp_InsertCopiedCutCellsAffectTable=n.Exp_InsertCopiedCutCellsOverlap=n.Exp_InsertCopiedCutCellsNoRange=n.Exp_InsertCopiedCutCellsOnSpanTable=n.Exp_InsertCopiedCutCells=n.ls10=n.ls9=n.ls8=n.ls7=n.ls6=n.ls5=n.ls4=n.ls3=n.ls2=n.ls1=n.lsde=n.lsru=n.SHEET_NAME=n.ARIA_ColumnHeader=n.ARIA_RowHeader=n.ARIA_HasComment=n.ARIA_HasHyperlink=n.ARIA_HasButton=n.ARIA_HasCheckbox=n.ARIA_HasFormula=void 0,n.Exp_NotSupported="Not supported exception",n.Exp_PasteExtentIsNull="pasteExtent is null",n.Exp_InvalidPastedArea="The pasted area should have the same size as the copy or cut area.",n.Exp_MultipleSelections="This action won't work on multiple selections.",n.Exp_ChangePartOfArray="Cannot change part of an array.",n.Exp_InvalidAndSpace="Invalid {0}: {1} (must be between {2} and {3}).",n.Exp_SrcIsNull="The argument 'src' is null",n.Exp_DestIsNull="The argument 'dest' is null",n.Exp_InvalidCustomFunction="invalid custom function",n.Exp_InvalidCustomName="invalid custom name",n.Exp_IndexOutOfRange="Index is out of range!",n.Exp_InvalidRange="Invalid range",n.Exp_NotAFunction="Not A Function",n.Exp_ArgumentOutOfRange="ArgumentOutOfRange",n.Exp_PasteSourceCellsLocked="Source sheet's cells are locked.",n.Exp_InvalidCopyPasteSize="The copy and paste areas are not the same size.",n.Exp_PasteDestinationCellsLocked="The cell you are trying to change is protected and therefore read-only.",n.Exp_PasteChangeMergeCell="Cannot change part of a merged cell.",n.Tip_Row="Row: ",n.Tip_Column="Column: ",n.Tip_Column_Offset="Offset: ",n.Tip_Height="Height: {0} pixels",n.Tip_Width="Width: {0} pixels",n.NewTab="New...",n.Exp_EmptyNamedStyle="The name of named style cannot be empty or null",n.Exp_SheetNameInvalid="The sheet name can not be blank or contains these characters : *, :, [, ], ?, \\, /",n.Exp_SheetNameConflict="That name is already taken. Try a different one.",n.Exp_ArrayFormulaSpan="Array formulas are not valid in merged cells.",n.Exp_DestSheetIsNull="destSheet is null",n.Exp_SheetIsNull="sheet is null.",n.Exp_OverlappingSpans="This operation will cause overlapping spans.",n.NeedCanvasSupport="You need a browser which full supports HTML5 Canvas to run SpreadJS",n.ARIA_Resize="resize",n.ARIA_First="first",n.ARIA_PreviousArrow="previous arrow",n.ARIA_NextArrow="next arrow",n.ARIA_Last="last",n.ARIA_PreviousButton="previous button",n.ARIA_NextButton="next button",n.ARIA_SheetTab="sheet tab",n.ARIA_NewSheet="new sheet",n.ARIA_Blank="blank",n.ARIA_Scrollbar_Left_Button="scrollbar left button",n.ARIA_Scrollbar_Top_Button="scrollbar top button",n.ARIA_Scrollbar_Thumb_Button="scrollbar thumb button",n.ARIA_Scrollbar_Right_Button="scrollbar right button",n.ARIA_Scrollbar_Bottom_Button="scrollbar bottom button",n.ARIA_Scrollbar_TRACK_Button="scrollbar track button",n.ARIA_Cell="cell",n.ARIA_HasValue="has value {0}",n.ARIA_HasFormula="has formula {0}",n.ARIA_HasCheckbox="has checkbox {0}",n.ARIA_HasButton="has button {0}",n.ARIA_HasHyperlink="has hyperlink {0}",n.ARIA_HasComment="has comment {0}",n.ARIA_RowHeader="row header",n.ARIA_ColumnHeader="column header",n.SHEET_NAME="Sheet",n.lsru=["","6465706c6f796d656e74"],n.lsde=["","64657369676e6572"],n.ls1=["","506f776572656420627920477261706543697479205370726561644a532e0d0a596f752063616e206f6e6c79206465706c6f792074686973204556414c554154494f4e2076657273696f6e206c6f63616c6c792e0d0a54656d706f72617279207b317d206b6579732061726520617661696c61626c6520666f722074657374696e672e0d0a456d61696c2075732e73616c6573406772617065636974792e636f6d2e"],n.ls2=["","506f776572656420627920477261706543697479205370726561644a532e0d0a596f75722074656d706f72617279207b317d206b6579206578706972657320696e207b307d206461792873292e"],n.ls3=["","4c6963656e7365204e6f7420466f756e640d0a596f75206e65656420612076616c6964206c6963656e7365206b657920746f2072756e205370726561644a532e0d0a54656d706f72617279206b6579732061726520617661696c61626c6520666f72206576616c756174696f6e2e0d0a496620796f75207075726368617365642061206c6963656e73652c20796f7572206b657920697320696e20796f757220707572636861736520636f6e6669726d6174696f6e20656d61696c2e0d0a456d61696c2075732e73616c6573406772617065636974792e636f6d20696620796f75206e65656420617373697374616e63652e"],n.ls4=["","496e76616c6964206c6963656e7365206b65792e20456d61696c2075732e73616c6573406772617065636974792e636f6d20696620796f75206e6565642068656c702e"],n.ls5=["","506f776572656420627920477261706543697479205370726561644a532e0d0a596f75722074656d706f72617279207b317d206b65792068617320657870697265642e0d0a456d61696c2075732e73616c6573406772617065636974792e636f6d20666f722068656c702e"],n.ls6=["","506f776572656420627920477261706543697479205370726561644a53204576616c756174696f6e2056657273696f6e0d0a4e6f74204c6963656e73656420666f7220446973747269627574696f6e"],n.ls7=["","457863656c20494f204c6963656e7365204e6f7420466f756e640d0a596f75206e65656420612076616c6964206c6963656e7365206b657920746f2072756e205370726561644a5320457863656c20494f2e2054656d706f72617279206b6579732061726520617661696c61626c6520666f72206576616c756174696f6e2e20496620796f75207075726368617365642061206c6963656e73652c20796f7572206b657920697320696e20796f757220707572636861736520636f6e6669726d6174696f6e20656d61696c2e20456d61696c2075732e73616c6573406772617065636974792e636f6d20696620796f75206e65656420617373697374616e63652e"],n.ls8=["","496e76616c696420457863656c20494f206c6963656e7365206b65792e200d0a456d61696c2075732e73616c6573406772617065636974792e636f6d20696620796f75206e65656420617373697374616e63652e"],n.ls9=["","4164642d6f6e7320456e61626c65643a207b307d"],n.ls10=["","4164642d6f6e73204e6f7420456e61626c65643a207b307d"],n.Exp_InsertCopiedCutCells="This selection is not valid. The copy/paste area must be the same size",n.Exp_InsertCopiedCutCellsOnSpanTable="This won\u2019t work because it would move cells in a table on your worksheet or will cause some merged cells to unmerge.",n.Exp_InsertCopiedCutCellsNoRange="New cells can not be inserted as there are non-empty cells that would extend beyond the worksheet.",n.Exp_InsertCopiedCutCellsOverlap="This selection isn't valid. Make sure the copy and paste areas don't overlap unless they are the same size and shape.",n.Exp_InsertCopiedCutCellsAffectTable="You can't rearrange cells within a table this way, because it might affect other table cells in an unexpected way.",n.Exp_InvalidSortArrayFormulaInRange="Can't sort current range as array formula exist.",n.Exp_InvalidSortSpanInRange="Can't sort current range as span exist.",n.Exp_InvalidSortPartTableOrMultiTableInRange="Can't sort current range as part table or more than one table exist.",n.Exp_InvalidOperationInProtect="The cell or chart you're trying to change is on a protected sheet. To make a change, unprotect the sheet.",n.EXP_IO="File read and write exception.",n.EXP_FILE_FORMAT="Incorrect file format.",n.EXP_NO_PASSWORD="The Excel file cannot be opened because the workbook/worksheet is password protected.",n.EXP_INVALID_PASSWORD="The specified password is incorrect.",n.NORMAL="Normal",n.GENERAL="General",n.EXP_UNSUPPORT_CRYPTO_ALGORITHM="Unsupported cryptographic algorithms",n.STEP={start:"start load {0}",loadFileData:"load {0}'s data to spread",loadSheetData:"load {0}'s data",startCalc:"start reCalc",loadSheetFormula:"load {0}'s formula",parseFile:"parse {0} content"}},"./dist/core/excel-io-util/common.js":function(t,n,e){"use strict";var i,r,u,v,m,c,s,f,l,o,a,h,d,g,p,e,b,w,y,M,C;function S(){}function T(){}function A(){}function I(t,n){var n,n,e,n=n.toUpperCase(),n=b[n];return n?(e=p,(e=n.reg?n.prefix:p)+t):t}function x(n,t,e){var i,r,e,t,i,r=function(t){return n.getColumnWidth(t)},e=N(e,function(t){return n.getRowHeight(t)},n.getRowCount(),n.defaults.rowHeight),t=N(t,r,n.getColumnCount(),n.defaults.colWidth);return{rowIndex:e.index,rowOffset:e.offset,colIndex:t.index,colOffset:t.offset}}function N(t,n,e,i){for(var r,o,a,u,s,c,r=-1,o=-1,a=0,u=0;u<e;u++)if(t<(a+=s=n(u))){r=u,o=t-(a-s);break}return-1===r&&a<t&&(r=e+(c=Math.floor((t-a)/i)),o=t-(a+c*i)),{index:r,offset:o}}function k(t,n){for(var e=n;e<t.length;e++)if("'"===t[e]||'"'===t[e])return e;return e}function _(t,n){var e,i,r;if(t&&"string"==typeof t){for(e=[],i=0;i<t.length&&(r=k(t,i),e.push(n(t.substring(i,r))),r<t.length);i++){if(-1===(i=t.indexOf(t[r],r+1))){e.push(t.substring(r));break}e.push(t.substring(r,i+1))}return e.join("")}return t}function D(){}Object.defineProperty(n,"__esModule",{value:!0}),n.excelSupportProtectionOptions=n.protectionOptionsMap=n.SJSStylePropsToStyleProps=n.Util=n.NodeHelper=n.IndexHelper=n.StringEx=n.STEP_RATE=void 0,i=e("Common"),r=e("./dist/core/core.enum.js"),u=e("./dist/core/util/domUtil.js"),v=e("./dist/core/util/common.js"),m=e("./dist/core/excel-io-util/excel-types.js"),c=e("./dist/core/excel-io-util/excel-helper.js"),s=/_x00[0-1][0-9A-Fa-f]_/,f=i.Common.lt.ht,l=null,o=void 0,a=m.XFileConstants.Wi,h=m.XFileConstants.Qi,d=m.XFileConstants.Ki,g=/([A-Z][A-Z.]+)\(/gi,p="_xlfn.",b={AVERAGEIF:/\bAVERAGEIF\b\(/gi,AVERAGEIFS:/\bAVERAGEIFS\b\(/gi,CUBEKPIMEMBER:/\bCUBEKPIMEMBER\b\(/gi,CUBEMEMBER:/\bCUBEMEMBER\b\(/gi,CUBEMEMBERPROPERTY:/\bCUBEMEMBERPROPERTY\b\(/gi,CUBERANKEDMEMBER:/\bCUBERANKEDMEMBER\b\(/gi,CUBESET:/\bCUBESET\b\(/gi,CUBESETCOUNT:/\bCUBESETCOUNT\b\(/gi,CUBEVALUE:/\bCUBEVALUE\b\(/gi,COUNTIFS:/\bCOUNTIFS\b\(/gi,IFERROR:/\bIFERROR\b\(/gi,SUMIFS:/\bSUMIFS\b\(/gi,ACOT:/\bACOT\b\(/gi,ACOTH:/\bACOTH\b\(/gi,AGGREGATE:/\bAGGREGATE\b\(/gi,ARABIC:/\bARABIC\b\(/gi,BASE:/\bBASE\b\(/gi,"BETA.DIST":/\bBETA\.DIST\b\(/gi,"BETA.INV":/\bBETA\.INV\b\(/gi,"BINOM.DIST":/\bBINOM\.DIST\b\(/gi,"BINOM.DIST.RANGE":/\bBINOM\.DIST\.RANGE\b\(/gi,"BINOM.INV":/\bBINOM\.INV\b\(/gi,BITAND:/\bBITAND\b\(/gi,BITLSHIFT:/\bBITLSHIFT\b\(/gi,BITOR:/\bBITOR\b\(/gi,BITRSHIFT:/\bBITRSHIFT\b\(/gi,BITXOR:/\bBITXOR\b\(/gi,"CEILING.MATH":/\bCEILING\.MATH\b\(/gi,"CEILING.PRECISE":/\bCEILING\.PRECISE\b\(/gi,"CHISQ.DIST":/\bCHISQ\.DIST\b\(/gi,"CHISQ.DIST.RT":/\bCHISQ\.DIST\.RT\b\(/gi,"CHISQ.INV":/\bCHISQ\.INV\b\(/gi,"CHISQ.INV.RT":/\bCHISQ\.INV\.RT\b\(/gi,"CHISQ.TEST":/\bCHISQ\.TEST\b\(/gi,COMBINA:/\bCOMBINA\b\(/gi,CONCAT:/\bCONCAT\b\(/gi,"CONFIDENCE.T":/\bCONFIDENCE\.T\b\(/gi,"CONFIDENCE.NORM":/\bCONFIDENCE\.NORM\b\(/gi,COT:/\bCOT\b\(/gi,"COVARIANCE.P":/\bCOVARIANCE\.P\b\(/gi,"COVARIANCE.S":/\bCOVARIANCE\.S\b\(/gi,CSC:/\bCSC\b\(/gi,CSCH:/\bCSCH\b\(/gi,DAYS:/\bDAYS\b\(/gi,DECIMAL:/\bDECIMAL\b\(/gi,ENCODEURL:/\bENCODEURL\b\(/gi,"ERF.PRECISE":/\bERF\.PRECISE\b\(/gi,"ERFC.PRECISE":/\bERFC\.PRECISE\b\(/gi,"EXPON.DIST":/\bEXPON\.DIST\b\(/gi,"F.DIST":/\bF\.DIST\b\(/gi,"F.DIST.RT":/\bF\.DIST\.RT\b\(/gi,"F.INV":/\bF\.INV\b\(/gi,"F.INV.RT":/\bF\.INV\.RT\b\(/gi,FILTERXML:/\bFILTERXML\b\(/gi,"FLOOR.MATH":/\bFLOOR\.MATH\b\(/gi,"FLOOR.PRECISE":/\bFLOOR\.PRECISE\b\(/gi,FORMULATEXT:/\bFORMULATEXT\b\(/gi,GAMMA:/\bGAMMA\b\(/gi,"GAMMA.DIST":/\bGAMMA\.DIST\b\(/gi,"GAMMA.INV":/\bGAMMA\.INV\b\(/gi,"GAMMALN.PRECISE":/\bGAMMALN\.PRECISE\b\(/gi,"HYPGEOM.DIST":/\bHYPGEOM\.DIST\b\(/gi,IFNA:/\bIFNA\b\(/gi,IFS:/\bIFS\b\(/gi,IMCOSH:/\bIMCOSH\b\(/gi,IMCOT:/\bIMCOT\b\(/gi,IMCSCH:/\bIMCSCH\b\(/gi,IMSEC:/\bIMSEC\b\(/gi,IMSECH:/\bIMSECH\b\(/gi,IMSINH:/\bIMSINH\b\(/gi,IMTAN:/\bIMTAN\b\(/gi,ISFORMULA:/\bISFORMULA\b\(/gi,ISOWEEKNUM:/\bISOWEEKNUM\b\(/gi,"LOGNORM.DIST":/\bLOGNORM\.DIST\b\(/gi,"LOGNORM.INV":/\bLOGNORM\.INV\b\(/gi,MAXIFS:/\bMAXIFS\b\(/gi,MINIFS:/\bMINIFS\b\(/gi,"MODE.MULT":/\bMODE\.MULT\b\(/gi,"MODE.SNGL":/\bMODE\.SNGL\b\(/gi,MUNIT:/\bMUNIT\b\(/gi,"NEGBINOM.DIST":/\bNEGBINOM\.DIST\b\(/gi,"NORM.DIST":/\bNORM\.DIST\b\(/gi,"NORM.INV":/\bNORM\.INV\b\(/gi,"NORM.S.DIST":/\bNORM\.S\.DIST\b\(/gi,"NORM.S.INV":/\bNORM\.S\.INV\b\(/gi,NUMBERVALUE:/\bNUMBERVALUE\b\(/gi,PDURATION:/\bPDURATION\b\(/gi,"PERCENTILE.EXC":/\bPERCENTILE\.EXC\b\(/gi,"PERCENTILE.INC":/\bPERCENTILE\.INC\b\(/gi,"PERCENTRANK.EXC":/\bPERCENTRANK\.EXC\b\(/gi,"PERCENTRANK.INC":/\bPERCENTRANK\.INC\b\(/gi,PERMUTATIONA:/\bPERMUTATIONA\b\(/gi,PHI:/\bPHI\b\(/gi,"POISSON.DIST":/\bPOISSON\.DIST\b\(/gi,"QUARTILE.EXC":/\bQUARTILE\.EXC\b\(/gi,"QUARTILE.INC":/\bQUARTILE\.INC\b\(/gi,"RANK.AVG":/\bRANK\.AVG\b\(/gi,"RANK.EQ":/\bRANK\.EQ\b\(/gi,RRI:/\bRRI\b\(/gi,SECH:/\bSECH\b\(/gi,SHEET:/\bSHEET\b\(/gi,SHEETS:/\bSHEETS\b\(/gi,"STDEV.P":/\bSTDEV\.P\b\(/gi,"STDEV.S":/\bSTDEV\.S\b\(/gi,SWITCH:/\bSWITCH\b\(/gi,"T.DIST":/\bT\.DIST\b\(/gi,"T.DIST.2T":/\bT\.DIST\.2T\b\(/gi,"T.DIST.RT":/\bT\.DIST\.RT\b\(/gi,"T.INV":/\bT\.INV\b\(/gi,"T.INV.2T":/\bT\.INV\.2T\b\(/gi,TEXTJOIN:/\bTEXTJOIN\b\(/gi,UNICHAR:/\bUNICHAR\b\(/gi,UNICODE:/\bUNICODE\b\(/gi,"VAR.P":/\bVAR\.P\b\(/gi,"VAR.S":/\bVAR\.S\b\(/gi,WEBSERVICE:/\bWEBSERVICE\b\(/gi,"WEIBULL.DIST":/\bWEIBULL\.DIST\b\(/gi,XOR:/\bXOR\b\(/gi,"Z.TEST":/\bZ\.TEST\b\(/gi,XMATCH:/\bXLOOKUP\b\(/gi,XLOOKUP:/\bXLOOKUP\b\(/gi,RANDARRAY:/RANDARRAY\(/gi,SEQUENCE:/SEQUENCE\(/gi,SORTBY:/SORTBY\(/gi,UNIQUE:/UNIQUE\(/gi,ANCHORARRAY:/ANCHORARRAY\(/gi,SINGLE:/SINGLE\(/gi,LET:/\bLET\b\(/gi,LAMBDA:/\bLAMBDA\b\(/gi,MAP:/\bMAP\b\(/gi,REDUCE:/\bREDUCE\b\(/gi,SCAN:/\bSCAN\b\(/gi,MAKEARRAY:/\bMAKEARRAY\b\(/gi,BYCOL:/\bBYCOL\b\(/gi,BYROW:/\bBYROW\b\(/gi,ISOMITTED:/\bISOMITTED\b\(/gi,FILTER:{reg:/FILTER\(/gi,prefix:e="_xlfn._xlws."},SORT:{reg:/SORT\(/gi,prefix:e},TEXTBEFORE:/\bTEXTBEFORE\b\(/gi,TEXTAFTER:/\bTEXTAFTER\b\(/gi,TEXTSPLIT:/\bTEXTSPLIT\b\(/gi,VSTACK:/\bVSTACK\b\(/gi,HSTACK:/\bHSTACK\b\(/gi,TOROW:/\bTOROW\b\(/gi,TOCOL:/\bTOCOL\b\(/gi,WRAPROWS:/\bWRAPROWS\b\(/gi,WRAPCOLS:/\bWRAPCOLS\b\(/gi,TAKE:/\bTAKE\b\(/gi,DROP:/\bDROP\b\(/gi,EXPAND:/\bEXPAND\b\(/gi,CHOOSEROWS:/\bCHOOSEROWS\b\(/gi,CHOOSECOLS:/\bCHOOSECOLS\b\(/gi},n.STEP_RATE={start:0,loadFileData:.1,loadSheetData:.4,loadSheetDataWithCalc:.3,startCalc:.2,loadSheetFormula:.4,loadSheetFormulaWithCalc:.3,parseFile:.1,end:1},S.Ji=function(t){return!t||""===t},S.Xi=function(t){return!t||" "===t},w=S,n.StringEx=w,T.qi=function(t){if(w.Ji(t))return 0;for(var n=0,e=0;e<t.length&&isNaN(parseInt(t[e],10));)e++;return(n=e<t.length?parseInt(t.substring(e),10):n)-1},T.$i=function(t){for(var n,e,i,r,o,a,n=0,e=t.length,i=0;i<e&&!(25<(a=(o=(r=t[i]).charCodeAt())-97))&&!((a=a<0?o-65:a)<0);i++)n=26*n+a+1;return--n},T.nr=function(t){var n,e,i,r,o,a;if(t<0)return"";if(!(n=T.er[t])){for(e=t,r=(i="").length,t+=1;0<t;t=Math.floor((t-1)/26))o=i.substring(0,r),a=i.substring(r),i=o+String.fromCharCode(65+(t-1)%26)+a;n=i.toString(),T.er[e]=n}return n},T.ir=function(t){var n,e,i,n=function(t){for(var n,e,i,n=!0,e=0;e<t.length;e++){if(i=t[e],T.rr[i])return!1;n&&/\D/.test(i)&&(n=!1)}return!n},e;return"'"===t[0]&&"'"===t.substr(-1)||(i=n(t))?t:"'"+t+"'"},T.er=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"],T.rr={" ":!0,"'":!0,"[":!0,"]":!0,"?":!0,"\\":!0,"%":!0,'"':!0,"(":!0,")":!0,"|":!0,"{":!0,"}":!0,"#":!0,"@":!0,"!":!0,$:!0,"^":!0,"\uff08":!0,"\uff09":!0,";":!0,":":!0,",":!0,"+":!0,"-":!0,"*":!0,"/":!0,"&":!0,"=":!0,"<":!0,">":!0,"\u3000":!0},y=T,n.IndexHelper=y,A.ar=function(t,n){if(!f(t)){var t=parseFloat(t);if(!isNaN(t))return t}return n},A.ur=function(t,n){return"1"===t||"true"===t||"0"!==t&&"false"!==t&&n},A.sr=function(t,n){if(!isNaN(t)){var t=parseInt(t,10);if(!isNaN(t))return t}return n},A.cr=function(t){return t=Array.isArray(t)?t:t?[t]:[]},A.lr=function(t,n){var e,i,r;if(t){for(e=n.split("."),i=t;e.length;){if(r=e.shift(),f(i[r]))return;i=i[r]}return i}},A.dr=function(t,n){return f(t)?n:t?"1":"0"},n.NodeHelper=A,D.vr=function(t){return t.split("/").pop().slice(0,-4)},D.mr=function(t){return _(t,function(t){return 0<=t.toLowerCase().indexOf("_xlfn.")?t.replace(/_xlfn\.|_xlws\./gi,""):t})},D.gr=function(t,n,e){return t.split(n).join(e)},D.pr=function(t,n){var e,i,r,o,a,u;if(f(t)||""===t)return t;for(t.match(s)!==l&&(t=t.replace(e=/(_x00[0-1][0-9A-Fa-f]_)/g,function(t){return"_x005F"+t})),i=["_x0000_","_x0001_","_x0002_","_x0003_","_x0004_","_x0005_","_x0006_","_x0007_","_x0008_","_x0009_","_x000A_","_x000B_","_x000C_","_x000D_","_x000E_","_x000F_","_x0010_","_x0011_","_x0012_","_x0013_","_x0014_","_x0015_","_x0016_","_x0017_","_x0018_","_x0019_","_x001A_","_x001B_","_x001C_","_x001D_","_x001E_","_x001F_"],r=[],o=0;o<t.length;o++)a=t.charCodeAt(o),u=t[o],r.push(31<a||(10===a||13===a)&&n?u:i[a]);return r.join("")},D.addXLFNPrefix=function(t){return _(t,function(t){return t.replace(g,I)})},D.wr=function(t){return t.c_||(t.c_=[]),t.c_.length+1},D.Mr=function(t){return t+"."+m.XFileConstants.Cr},D.Sr=function(t,n){for(var e,i,r,e=0,i=t;e<i.length;e++)if((r=i[e]).Id===n)return r},D.Tr=function(t,n,e){var t,n,t,t=t&&D.Sr(t.c_,n);if(t)return n=D.vr(t.Target),(t=e.drawings)&&t[n]},D.Ir=function(t,n){var e=v.util.xr(t,a);if(e)return D.Tr(t.rels,e[d],n)},D.Nr=function(t){t.rels||(t.rels={n_:m.XFileConstants.Dr,xmlns:m.RelationshipConstants._r,c_:[]})},D.Er=function(t,n){var e,n,e,n,e=v.util.xr(n,a),n=e&&D.Sr(n.rels.c_,e[d]),e=n&&D.vr(n.Target);if(e)return t.drawings||(t.drawings={}),(n=t.drawings)[e]||(n[e]={n_:"wsDr",r_:[5,4],c_:[],rels:{n_:m.XFileConstants.Dr,xmlns:m.RelationshipConstants._r,c_:[]}}),n[e]},D.jr=function(t,n){var e,i,i,n,e=t.rels;v.util.xr(t,a)||(n.drawing++,i=D.wr(e),i=m.XFileConstants.Rr+i,n=m.XFileConstants.Wi+n.drawing,e.c_.push({n_:m.XFileConstants.Lr,Id:i,Type:m.RelationshipConstants.Fr,Target:"../drawings/"+n+"."+m.XFileConstants.Cr}),t.c_||(t.c_=[]),t.c_.push({n_:a,"r:id":i}),v.util.Pr(t,m.WorkSheetNodeOrder))},D.Gr=function(t,n,e){return D.Tr(t,n,e)},D.Ur=function(t,n,e){var e,n,e,n,i,e=v.util.xr(n,e||h),n=e&&D.Sr(n.rels.c_,e[d]),e=n&&D.vr(n.Target);if(e)return t.drawings||(t.drawings={}),(n=t.drawings)[e]||(n[e]={n_:"xml",r_:[10,11,12],c_:[i={n_:"shapelayout","v:ext":"edit",c_:[{n_:"idmap","v:ext":"edit",data:"1"}]}]}),n[e]},D.Hr=function(t,n,e){var i,n,r,r,n,i=t.rels;v.util.xr(t,e=e||h)||(n.vmlDrawing++,n=n.vmlDrawing,r=D.wr(i),r=m.XFileConstants.Rr+r,n=m.XFileConstants.zr+n,i.c_.push({n_:m.XFileConstants.Lr,Id:r,Type:m.RelationshipConstants.Vr,Target:"../drawings/"+n+"."+m.XFileConstants.Yr}),t.c_||(t.c_=[]),t.c_.push({n_:e,"r:id":r}))},D.Zr=function(t,n,e){var n,t,i,n,n,n=D.Sr(n.c_,t),t=n&&n.Target;if(t)return-1!==(n=(t=-1!==(n=t.lastIndexOf("/"))?t.substring(n+1):t).lastIndexOf("."))&&(i=t.substring(n+1)),{blob:n=(n=e.media[t])&&i?D.Wr(n,i):n,type:i}},D.Wr=function(t,n){var n=n;return"data:image/".concat(n="svg"===n?"svg+xml":n,";base64,").concat(t)},D.Qr=function(t){var n,e,i,n=t.indexOf(";base64,");if(-1!==n)return e=t.substring(n+8),{type:i=t.substring(11,n),base64Content:e}},D.Kr=function(t,n,e){var i,t,r,o,a,u,t,i=D.Qr(t);if(i){for(e.media||(e.media={}),"svg+xml"===(t=i.type)?t="svg":"x-icon"===t&&(t="png"),r="",o=Object.keys(e.media),a=0;a<o.length;a++)u=o[a],e.media[u]===i.base64Content&&(r=u);return r||(r=m.XFileConstants.Jr+Object.keys(e.media).length+"."+t,e.media[r]=i.base64Content),t=m.XFileConstants.Rr+D.wr(n),n.c_.push({n_:m.XFileConstants.Lr,Id:t,Type:m.RelationshipConstants.Xr,Target:"../media/"+r}),t}},D.qr=function(t,n){var t=1024*(t+1)+1;return n&&(t+=n.c_.filter(function(t){return t.n_===m.XFileConstants.$r}).length),t},D.StringToByteArray=function(t){var n,e,i,n=[];if(t&&!(t instanceof Array))for(e=t.length,i=0;i<e;i+=2)n[i/2]=parseInt(t.substr(i,2),16);return n},D.no=function(){return"{xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx}".replace(/[xy]/g,function(t){var n=16*Math.random()|0,e;return("x"===t?n:3&n|8).toString(16)})},D.eo=function(t,n){var e,i,r,e=t.split("/"),i=n.split("/");for(e.pop();0<i.length;)if(".."===(r=i[0]))i.shift(),e.pop();else{if("."!==r)break;i.shift()}return e.concat(i).join("/")},D.io=function(t){var n;return f(t)||t.match(s)===l?t:t.replace(/(_x005[fF])?_x00([0-1][0-9A-Fa-f])_/g,function(t,n,e){var i=0;return e&&(i=parseInt(e,16)),n?"_x00"+e+"_":String.fromCharCode(i)}).replace(/(\r)+\n/g,"\r\n")},D.ro=function(){var t,n,e,i;try{n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol?"symbol":typeof t},e="object"===("undefined"==typeof global?"undefined":n(global))&&global&&global.Object===Object&&global,i="object"===("undefined"==typeof self?"undefined":n(self))&&self&&self.Object===Object&&self,t=e||i||Function("return this")()}catch(t){}return t},D.oo=function(){var t=D.ro();return t&&t.gcCultureInfo},D.ao=function(){var t=D.ro();return t&&t.gcCultureObj},D.uo=function(t){var n,e,e,n=!0,e=D.ro(),e=e&&e.GC&&e.GC.Spread&&e.GC.Spread.Formatter&&e.GC.Spread.Formatter.GeneralFormatter;if(t&&"="!==t[0]&&!f(e))try{new e(t)}catch(t){n=!1}return n},D.so=function(t,o){var a;return u.GC$.each(t,function(t,n){var e,i,r,e=n.rels&&n.rels.c_;if(e&&e.length)for(i=0;i<e.length;i++)if((r=D.vr(e[i].Target))===o)return a=t,!1}),a},D.co=function(t,n){var e,i,r,o,a,u,s,c;if(n&&n.rels&&n.c_&&n.c_.length){for(e=n.rels.c_,i={},r=0;r<e.length;r++)(o=e[r]).Type===m.RelationshipConstants.fo&&(i[o.Id]=D.vr(o.Target));for(r=0;r<n.c_.length;r++)if("sheets"===(a=n.c_[r]).n_)for(u=a.c_,s=0;s<u.length;s++)if(i[(c=u[s])[m.XFileConstants.Ki]]===t)return c.name}},D.ho=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d;for(n=v.util.vo(n),i=t.workbook,o=-1,u=0,s=r=v.util.xr(i,m.XFileConstants.mo).c_;u<s.length;u++)if(n===(c=s[u]).name){o=c[m.XFileConstants.Ki];break}if(-1!==o){for(l=0,h=f=v.util.go(i.rels,m.XFileConstants.Lr);l<h.length;l++)if(o===(d=h[l]).Id){a=D.vr(d.Target);break}a&&(e=t.sheets[a])}return e},D.po=function(t,n){var t=D.ho(t,n);return t&&v.util.xr(t,m.XFileConstants.bo)},D.yo=function(t,n,e,i,r){var o,a;f(i)||t&&((a=(a=(o=(o=t[n])||(t[n]={}))[e])||(o[e]={})).v=r.getTextIndex(i))},D.wo=function(t,n){return t&&t.openMode&r.OpenMode.lazy&&!f(n)},D.Mo=function(t){return t&&t.openMode&r.OpenMode.incremental},D.Co=function(t){return t&&t.fileType===r.OpenSaveFileType.excel},D.So=function(t,n,e,i){var r,o,a,u,r=t.getRowCount(),o=t.getColumnCount(),u=i&&i.dataEffectByInflate&&i.dataEffectByInflate[t.name()];r<n&&(a=new v.Range(r,-1,n-r,-1),t.setRowCount(n),u)&&Object.keys(u).forEach(function(t){u[t](a)}),o<e&&(a=new v.Range(-1,o,-1,e-o),t.setColumnCount(e),u)&&Object.keys(u).forEach(function(t){u[t](a)})},D.ume=function(a,t){var t=t.sheetColumnInfos,n=a.name(),t=t&&t[n],n=a.Ut,u=a.getColumnCount(),s=n.Q_(!1,3);t&&t.forEach(function(t){for(var n,e,i,r,o,n=t.columnSize,e=t.hidden,i=t.colStyle,r=Math.min(t.maxCol,u),o=t.minCol;o<=r;o++)D.cme(a,s,o-1,n,e,i)})},D.cme=function(t,n,e,i,r,o){i!==l&&n.setSize(e,i),r&&t.setColumnVisible(e,!1),o!==l&&t.setStyle(-1,e,o)},D.To=function(t,n,e,i){var r,o,a,u,n,s,a,s,a,o,u;void 0===e&&(e=2),o=n.from,a=n.to,u=n.pos,n=n.ext,a?(s=+a.row.v_,a=+a.col.v_,D.So(t,s+e,a+e,i)):n&&(o||u)&&(s={x:0,y:0},o?s=D.Gce(t,o):(s.x=c.ExcelHelper.emuToPixles(parseInt(u.x,10)),s.y=c.ExcelHelper.emuToPixles(parseInt(u.y,10))),s.x+=c.ExcelHelper.emuToPixles(parseInt(n.cx,10)),s.y+=c.ExcelHelper.emuToPixles(parseInt(n.cy,10)),o=(a=x(t,s.x,s.y)).rowIndex,u=a.colIndex,D.So(t,o+e,u+e,i))},D.Ao=function(e,t,i,r){t&&t.forEach(function(t){var n,t,n=t.row+(0<t.rowCount?t.rowCount:1),t=t.col+(0<t.colCount?t.colCount:1);i&&(n>=m.XmlConstants.Io||t>=m.XmlConstants.xo)||D.So(e,n,t,r)})},D.Uce=function(t){var n,e,i,r;function o(t,n){var t=parseInt(t.v_||0,10);return n?c.ExcelHelper.emuToPixles(t):t}return{row:n=o(t.row),col:e=o(t.col),rowOff:i=o(t.rowOff,!0),colOff:r=o(t.colOff,!0)}},D.Gce=function(t,n){var n,e,i,n=D.Uce(n),e,i;return{x:v.util.w0(t,0,n.col,!1)+n.colOff,y:v.util.w0(t,0,n.row,!0)+n.rowOff}},D.No=function(t){return t=Math.min(t,m.XmlConstants.xo-1),y.nr(t)},D.ko=function(t){return!t||f(t.fileType)||t.fileType===r.OpenSaveFileType.sjs},n.Util=D,n.SJSStylePropsToStyleProps={wholeSlicerStyle:"wholeTable",headerStyle:"headerRow",wholeTableStyle:"wholeTable",headerRowStyle:"headerRow",footerRowStyle:"totalRow",highlightFirstColumnStyle:"firstColumn",highlightLastColumnStyle:"lastColumn",firstRowStripStyle:"firstRowStripe",secondRowStripStyle:"secondRowStripe",firstColumnStripStyle:"firstColumnStripe",secondColumnStripStyle:"secondColumnStripe",firstHeaderCellStyle:"firstHeaderCell",lastHeaderCellStyle:"lastHeaderCell",firstFooterCellStyle:"firstTotalCell",lastFooterCellStyle:"lastTotalCell",reportFilterLabelsStyle:"pageFieldLabels",reportFilterValuesStyle:"pageFieldValues",firstRowStripeStyle:"firstRowStripe",secondRowStripeStyle:"secondRowStripe",firstColumnStripeStyle:"firstColumnStripe",secondColumnStripeStyle:"secondColumnStripe",subtotalColumn1Style:"firstSubtotalColumn",subtotalColumn2Style:"secondSubtotalColumn",subtotalColumn3Style:"thirdSubtotalColumn",subtotalRow1Style:"firstSubtotalRow",subtotalRow2Style:"secondSubtotalRow",subtotalRow3Style:"thirdSubtotalRow",columnSubheading1Style:"firstColumnSubheading",columnSubheading2Style:"secondColumnSubheading",columnSubheading3Style:"thirdColumnSubheading",rowSubheading1Style:"firstRowSubheading",rowSubheading2Style:"secondRowSubheading",rowSubheading3Style:"thirdRowSubheading",blankRowStyle:"blankRow",grandTotalColumnStyle:"lastColumn",grandTotalRowStyle:"totalRow",firstHeaderCellStyleL:"firstHeaderCell",firstColumnStyle:"firstColumn"},n.protectionOptionsMap={allowSelectLockedCells:"selectLockedCells",allowSelectUnlockedCells:"selectUnlockedCells",allowFilter:"autoFilter",allowSort:"sort",allowInsertColumns:"insertColumns",allowInsertRows:"insertRows",allowDeleteColumns:"deleteColumns",allowDeleteRows:"deleteRows",allowEditObjects:"objects"},n.excelSupportProtectionOptions={formatCells:!0,formatColumns:!0,formatRows:!0,insertColumns:!0,insertRows:!0,insertHyperlinks:!0,deleteColumns:!0,deleteRows:!0,sort:!0,autoFilter:!0,pivotTables:!0}},"./dist/core/excel-io-util/excel-helper.js":function(t,n){"use strict";function e(t,n){var n=Math.pow(10,n);return Math.round(t*n)/n}var i;function r(){}Object.defineProperty(n,"__esModule",{value:!0}),n.ExcelHelper=void 0,r.pointToPixel=function(t){return e(96*t/72,2)},r.pixelToPoint=function(t){return 72*t/96},r.emuToPixles=function(t,n){return e(96*t/914400,n||2)},r.pixelToEMU=function(t){return Math.round(914400*t/96)},r.getActualColumnWidth=function(t,n,e){for(var i,r,i=0,r=n;r<e;r++)t.getColumnVisible(r)&&(i+=t.Do(r,3));return i},r.getActualRowHeight=function(t,n,e){for(var i,r,i=0,r=n;r<e;r++)t.getRowVisible(r)&&(i+=t._o(r,3));return i},r.getImageContent=function(t,n){var e,i,i,e="png",i=t.lastIndexOf(".");return"svg"===(e=-1!==i?t.substr(i+1):e)&&(e="svg+xml"),(i=n(t,!0))?"data:image/"+e+";base64,"+i:null},n.ExcelHelper=r},"./dist/core/excel-io-util/excel-style.js":function(t,n){"use strict";var e,n;Object.defineProperty(n,"__esModule",{value:!0}),n.ExcelBorderStyle=void 0,(n=e=n.ExcelBorderStyle||(n.ExcelBorderStyle={}))[n.none=0]="none",n[n.thin=1]="thin",n[n.medium=2]="medium",n[n.dashed=3]="dashed",n[n.dotted=4]="dotted",n[n.thick=5]="thick",n[n.double=6]="double",n[n.hair=7]="hair",n[n.mediumDashed=8]="mediumDashed",n[n.dashDot=9]="dashDot",n[n.mediumDashDot=10]="mediumDashDot",n[n.dashDotDot=11]="dashDotDot",n[n.mediumDashDotDot=12]="mediumDashDotDot",n[n.slantDashDot=13]="slantDashDot"},"./dist/core/excel-io-util/excel-types.js":function(t,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.WorkSheetNodeOrder=n.WorkbookNodeOrder=n.RelationshipConstants=n.XFileConstants=n.XmlConstants=void 0,n.XmlConstants={xo:16384,Io:1048576},n.XFileConstants={Eo:"_rels",jo:"/xl",Oo:"[Content_Types].xml",Rr:"rId",Ki:"r:id",Dr:"Relationships",Lr:"Relationship",Qi:"legacyDrawing",Ro:"legacyDrawingHF",Bo:"AlternateContent",Lo:"Choice",Fo:"controls",Po:"control",$r:"shape",Go:"bin",Uo:"application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings",Ho:"rels",zo:"application/vnd.openxmlformats-package.relationships+xml",Vo:"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",Yo:"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",Zo:"application/vnd.openxmlformats-officedocument.theme+xml",Wo:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",Qo:"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",Ko:"application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml",Jo:"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml",Xo:"application/vnd.openxmlformats-officedocument.drawing+xml",qo:"application/vnd.openxmlformats-officedocument.drawingml.chart+xml",$o:"application/vnd.ms-office.chartex+xml",ta:"application/vnd.ms-office.chartstyle+xml",na:"application/vnd.ms-office.chartcolorstyle+xml",ia:"application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml",ra:"application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml",oa:"application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml",aa:"application/vnd.ms-office.drawingml.diagramDrawing+xml",ua:"application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml",sa:"application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml",ca:"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml",fa:"application/vnd.ms-excel.threadedcomments+xml",la:"application/vnd.ms-excel.person+xml",ha:"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml",da:"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml",va:"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml",ma:"application/vnd.ms-excel.slicer+xml",ga:"application/vnd.ms-excel.slicerCache+xml",pa:"application/vnd.ms-excel.timeline+xml",ba:"application/vnd.ms-excel.timelineCache+xml",ya:"application/vnd.ms-office.vbaProject",wa:"application/vnd.openxmlformats-officedocument.vmlDrawing",Ma:"application/vnd.ms-excel.controlproperties+xml",Cr:"xml",Yr:"vml",Ca:"application/xml",Sa:"jpg",Ta:"image/jpg",Aa:"tiff",Ia:"image/tiff",xa:"jpeg",Na:"image/jpeg",ka:"svg",Da:"image/svg+xml",_a:"png",Ea:"image/png",ja:"bmp",Oa:"image/bmp",Ra:"gif",Ba:"image/gif",La:"emf",Fa:"image/x-emf",Pa:"wmf",Ga:"image/x-wmf",Ua:"drawings",zr:"vmlDrawing",Ha:"/xl/charts",za:"/xl/drawings",Va:"/xl/persons",Ya:"/xl/media",Za:"/xl/threadedComments",Wa:"/xl/worksheets",Qa:"/xl/tables",Ka:"/xl/slicers",Ja:"/xl/slicerCaches",Xa:"/xl/timelines",qa:"/xl/timelineCaches",$a:"/xl/ctrlProps",tu:"externalLink",nu:"/xl/externalLinks",eu:"/xl/pivotCache",iu:"/xl/pivotTables",mo:"sheets",ru:"sheet",ou:"comments",au:"chart",uu:"chartEx",su:"style",cu:"person",fu:"colors",Wi:"drawing",lu:"ctrlProp",hu:"threadedComment",Jr:"image",du:"table",vu:"slicer",mu:"slicerCache",gu:"timeline",pu:"timelineCache",bu:"pivotCacheDefinition",yu:"pivotCache",wu:"pivotCacheRecords",Mu:"pivotTable",Cu:"External",Su:"sheetPr",Tu:"dimension",Au:"extLst",Iu:"mergeCells",xu:"mergeCell",Nu:"hyperlinks",ku:"hyperlink",Du:"sheetViews",_u:"sheetFormatPr",Eu:"cols",bo:"sheetData",ju:"conditionalFormatting",Ou:"dataValidations",Ru:"dataValidation",Bu:"tableParts",Lu:"/xl/sharedStrings.xml",Fu:"/xl/theme/theme1.xml",Pu:"/xl/worksheets",Gu:"/xl/workbook.xml",Uu:"/docProps/core.xml",Hu:"/docProps/app.xml",zu:"/docProps/custom.xml",Vu:"/xl/styles.xml",Yu:"/xl/theme/theme1.xml",Zu:"metadata.xml",Wu:"/xl/_rels/workbook.xml.rels",Qu:"http://schemas.openxmlformats.org/spreadsheetml/2006/main",Ku:"http://schemas.openxmlformats.org/markup-compatibility/2006",Ju:"http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing",Xu:"http://schemas.openxmlformats.org/drawingml/2006/main",qu:"http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac",$u:"x14ac",ts:"x14ac xr xr2 xr3",ns:"xr",os:"http://schemas.microsoft.com/office/spreadsheetml/2014/revision",as:"http://schemas.microsoft.com/office/spreadsheetml/2015/revision2",us:"http://schemas.microsoft.com/office/spreadsheetml/2016/revision3",ss:"http://schemas.openxmlformats.org/officeDocument/2006/relationships",fs:"http://schemas.openxmlformats.org/package/2006/content-types",_r:"http://schemas.openxmlformats.org/package/2006/relationships",ls:"http://schemas.openxmlformats.org/drawingml/2006/main",hs:"http://schemas.microsoft.com/office/drawing/2010/main",vs:"http://schemas.microsoft.com/office/drawing/2016/SVG/main",ms:"http://schemas.microsoft.com/office/spreadsheetml/2009/9/main",ps:"http://schemas.microsoft.com/office/excel/2006/main",bs:"http://schemas.openxmlformats.org/markup-compatibility/2006",ys:"http://schemas.microsoft.com/office/spreadsheetml/2009/9/main",ws:"http://schemas.openxmlformats.org/spreadsheetml/2006/main",Ms:"http://schemas.microsoft.com/office/spreadsheetml/2010/11/main",Cs:"http://schemas.microsoft.com/office/spreadsheetml/2018/calcfeatures",Ss:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml",Ts:"http://schemas.microsoft.com/office/spreadsheetml/2017/dynamicarray",As:"http://schemas.microsoft.com/office/spreadsheetml/2017/richdata",Is:"http://schemas.microsoft.com/office/spreadsheetml/2018/threadedcomments",xs:"http://schemas.microsoft.com/office/spreadsheetml/2018/threadedcomments",Ns:"http://schemas.microsoft.com/office/spreadsheetml/2014/revision",ks:"http://schemas.openxmlformats.org/package/2006/metadata/core-properties",Ds:"http://purl.org/dc/elements/1.1/",_s:"http://purl.org/dc/terms/",Es:"http://purl.org/dc/dcmitype/",js:"http://www.w3.org/2001/XMLSchema-instance",Os:"application/vnd.openxmlformats-package.core-properties+xml",Ls:"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties",Fs:"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes",Ps:"application/vnd.openxmlformats-officedocument.extended-properties+xml",Gs:"http://schemas.openxmlformats.org/officeDocument/2006/custom-properties",Us:"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes",Hs:"application/vnd.openxmlformats-officedocument.custom-properties+xml"},n.RelationshipConstants={zs:"rId",_r:"http://schemas.openxmlformats.org/package/2006/relationships",Vs:"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties",Ys:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties",Zs:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties",Ws:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",Qs:"http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument",Ks:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles",Js:"http://purl.oclc.org/ooxml/officeDocument/relationships/styles",fo:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet",Xs:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings",qs:"http://purl.oclc.org/ooxml/officeDocument/relationships/sharedStrings",$s:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme",tc:"http://purl.oclc.org/ooxml/officeDocument/relationships/theme",ec:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/pivotCacheDefinition",ic:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/pivotCacheRecords",oc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/pivotTable",uc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLink",fc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLinkPath",lc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/table",hc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments",Vr:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing",dc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/ctrlProp",vc:"http://purl.oclc.org/ooxml/officeDocument/relationships/extendedProperties",Fr:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing",gc:"http://purl.oclc.org/ooxml/officeDocument/relationships/drawing",pc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink",Xr:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",bc:"http://purl.oclc.org/ooxml/officeDocument/relationships/image",yc:"http://schemas.microsoft.com/office/2007/relationships/slicer",wc:"http://schemas.microsoft.com/office/2007/relationships/slicerCache",Mc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart",Cc:"http://schemas.microsoft.com/office/2014/relationships/chartEx",Sc:"http://purl.oclc.org/ooxml/officeDocument/relationships/chart",Tc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/chartUserShapes",Ac:"http://schemas.microsoft.com/office/2011/relationships/chartColorStyle",Ic:"http://schemas.microsoft.com/office/2011/relationships/chartStyle",xc:"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sheetMetadata",Nc:"http://schemas.microsoft.com/office/2011/relationships/timeline",kc:"http://schemas.microsoft.com/office/2011/relationships/timelineCache"},n.WorkbookNodeOrder=["bookViews",n.XFileConstants.mo,"externalReferences","definedNames","calcPr","pivotCaches","extLst"],n.WorkSheetNodeOrder=[n.XFileConstants.Su,n.XFileConstants.Tu,n.XFileConstants.Du,n.XFileConstants._u,n.XFileConstants.Eu,n.XFileConstants.bo,"sheetProtection","autoFilter",n.XFileConstants.Iu,n.XFileConstants.ju,n.XFileConstants.Ou,n.XFileConstants.Nu,"printOptions","pageMargins","pageSetup","headerFooter","rowBreaks","colBreaks","picture","drawing",n.XFileConstants.Qi,n.XFileConstants.Ro,n.XFileConstants.Po,n.XFileConstants.Bo,n.XFileConstants.Bu,n.XFileConstants.Au]},"./dist/core/excel-io-util/range-parser.js":function(t,n,e){"use strict";var i,c,u,f,l,r;function h(t){return-1===t.col||-1===t.colCount}function d(t){return-1===t.row||-1===t.rowCount}function a(){}Object.defineProperty(n,"__esModule",{value:!0}),n.range_parser=void 0,i=e("./dist/core/excel-io-util/excel-types.js"),c=e("./dist/core/excel-io-util/common.js"),u=e("./dist/core/util/common.js"),f=i.XmlConstants.Io,l=i.XmlConstants.xo,a.Dc=function(t,n){var e,i,e=[];return null!==t&&(i=t.replace(/('.+')/g,"").split(" ")).forEach(function(t){var t=a._c(t,n);!t||t.row>f||t.col>l||t.rowCount>f||t.col>l||e.push(t)}),e},a._c=function(t,n){var e,i,i,r,o,i,a,a,t,e=(0,u.Ec)(0,0,0,0),i=t.indexOf("!");if(1===(i=(i=(t=-1<i?t.substr(i+1):t).split("$").join("")).split(":")).length){if(a=i[0],r=c.IndexHelper.qi(a),o=c.IndexHelper.$i(a),-1===r&&-1===o)return null;e.row=r,e.col=o,e.rowCount=1,e.colCount=1}else 2===i.length&&(a=i[0],t=i[1],r=c.IndexHelper.qi(a),o=c.IndexHelper.$i(a),i=c.IndexHelper.qi(t),a=c.IndexHelper.$i(t),e.row=r,e.col=o,e.rowCount=i-r+1,e.colCount=a-o+1,n||0!==r||e.rowCount!==f||(e.row=-1,e.rowCount=-1),n||0!==o||e.colCount!==l||(e.col=-1,e.colCount=-1));return e},a.jc=function(t,n){var n,e,i,r,t,o;if(t)return n=n?"$":"",e=t.row,i=t.col,r=t.rowCount,t=t.colCount,o=c.IndexHelper.nr(i),1===r&&1===t?n+o+n+(e+1):-1===e||-1===r?n+o+n+"1:"+n+c.IndexHelper.nr(i+t-1)+n+f:-1===i||-1===t?n+"A"+n+(e+1)+":"+n+c.IndexHelper.nr(l)+n+(e+r):0===r&&0===t?n+o+n+(e+1):n+o+n+(e+1)+":"+n+c.IndexHelper.nr(i+t-1)+n+(e+r)},a.Oc=function(t,n){var e,i,r,o;if(t){for(e=[],i=0,r=t;i<r.length;i++)o=r[i],e.push(a.jc(o,n));return e.join(" ")}},a.getRangeString=function(t){for(var n,e,i,r,o,a,u,s,u,n=[],e=0,i=t;e<i.length;e++)h(r=i[e])&&(r.col=0,r.colCount=l),d(r)&&(r.row=0,r.rowCount=f),o=r.row,a=r.row+r.rowCount-1,u=r.col,s=r.col+r.colCount-1,u=c.IndexHelper.nr(u)+(o+1),(1<r.rowCount||1<r.colCount)&&(u+=":"+c.IndexHelper.nr(s)+(1+a)),n.push(u);return n.join(" ")},n.range_parser=a},"./dist/core/lc/common.js":function(L,t,n){"use strict";var e,i,o,r,l,r,p,r,u,a,n,r,s,c,f,v,m,g,b,w,y,M,C,S,T,A,I,x,N,h,d,k;function B(){return k}function _(t,n){for(var e,i,r,o,a,u,i="",a=0,e=0;e<t.length;e++)a=Math.max(a,t[e].length);for(e=0;e<a;e++){for(n&&(r=""),u=0;u<t.length;u++)n?e>=t[u].length?r+="00":r+=t[u].charAt(e)+t[u].charAt(e+1):e<t[u].length&&(i+=t[u].charAt(e));n&&(o=parseInt(r,16),i+=String.fromCharCode(o),e++)}return i}function D(n,e,i){var t,r,o,a,t=_(["Lcnee","iesKy"]),r=k[t],o="ZCTW";return u(r,{pK:"l6/zrbWoSbcLFwEetFh38rH3ErBZE9H+Cqix3R+wTlfA1wD5B+lUcCQn+EJ60I4RGrm0x1sFjkiLWwB0jAn6BWZv0W4WbqAKriOdeoivxDp1Wmjs3qkEDhvbsjPtfvwx2BHil6o+/tDrdMJQSGs18WZm2PoQLQuL+9VhZ4FNRHUQU3Jtioke/OZEGHJOdYVwvCGalzBad6QFOiVbDBQPePpS3++GJzOxN8SN/7lyS5/IdKiy3WJRaVGkB370+HbN6hKraDfUgReLX26yxRaKC/5aWnGAJ2NnWLoGyAGRcwT9dVjo4bcAZNrrA0U9JVKQxaSskhdv2p49XzJkltXx5w==",aC:"B1"},function(t){(a=F(t,o)).hl=!!r,a.m=r?a.m:-1,e.call(n,a),G(a,n,r,i)},function(){(a=F()).hl=!!r,a.m=r?a.m:-1,e.call(n,a),G(a,n,r,i)}),a}function F(u,s){var t,c,f,l,h,d,n,t={isVd:function(t){var n=this;return t=1===k.Workbook.lm||t,n.s&&!n.e&&(!n.adr||!!n.adr.dsr==!!t)}},d=W(),n=function(){var t,n,e,i,r,o,a;if(!u)return!1;if(!(t=u[C])||!t.length)return!1;for(i=0,r=t.length;i<r;i++)if(e=(n=t[i])&&n[T]===s){c=n[S];break}if(!e)return!1;if(u[N]&&(h=u[N]),u[x]){if(o=new Date,a=P(u[x]),l=Math.ceil((a-o)/864e5),f=l<=0)return!1}else l=void 0;return!!(d||!u[A]&&!u[I]||Y(u[A],u[I])||Z(u[A],u[I]))};return t[g]=d,t.s=n(),t[v]=u?u[M]?-1:1:0,t[m]=c,(t[w]=f)||(t[b]=l),t[y]=h,t}function P(t){return new Date(j(t.substr(0,4))||0,j(t.substr(4,2))-1||0,j(t.substr(6,2))||0)}function j(t){return parseInt(t,10)}function G(t,n,e,i){var r,r,o,a,u,s,c,f,l,h,d,v;if(E(t)){if(t&&t.adr&&!0!==t.adr.dsr&&(r=t.adr.flg||[],o=t.m,a=t.d,k.Workbook.et(n,"adlc",{flg:r,checkRs:r={},m:o,d:a,fn:U}),void 0!==r.nwm)){if(t.wm=r.wm,t.nwm=r.nwm,r.dis){for(u=t.disL||[],s=0,c=r.dis;s<c.length;s++)f=c[s],u.push(_(["",f],!0));t.disL=u}if(r.state)for(l=0,h=r.state;l<h.length;l++)t[(d=h[l])[0]]=d[1]}e||(r={},o=t.m,a=t.d,(v=1)!==k.Workbook.lm&&k.Workbook.et(n,"adlc",{flg:[],checkRs:r,m:o,d:a,nl:1}),void 0!==r.nwm&&(t.wm=r.wm,t.nwm=r.nwm)),i||n.repaint&&!n.xT&&n.repaint()}else tt(n,t)}function U(n,t,e){var i=["rs"];n&&t.forEach(function(t){var t=_(["",t],!0);n[t]&&n[t][e+i]&&n[t][e+i]()})}function H(t,n){var t,e,i,r,o;if(t&&0===t.indexOf("//")&&!((t=t.slice(2).split("/")).length<1))for(e=t[0],i=0,r=n.length;i<r;i++)if((o=n[i])===e)return 1}function V(t,n){for(var e,i,r,o,o,e=0,i=n.length;e<i;e++){if(o=!1,(r=(o=(r=n[e])&&0===r.lastIndexOf("*.",0)?!0:o)?r.slice(2):r)===t)return 1;if(o&&0<(o=t.indexOf("."+r))&&o===t.length-r.length-1)return 1}}function z(t,n){var e,i,r,o;if(t&&4===t.split(".").length)for(e=0,i=n.length;e<i;e++)if((r=n[e])&&0<(o=r.length-2)&&(r===t||".*"===r.substr(o)&&t.substr(0,o)===r.substr(0,o)&&f.test(t)))return 1}function Y(t,n){var e,i,e,i;return!!(X()&&(e=a(h),i=a("1agFGc#UHbw5"),e=s[e]&&s[e][i])&&(e=e.toLowerCase(),i=t.split(","),t)&&H(e,i))}function Z(t,n){var e,i,e,i,e=a(h),i=a("Zdg3Ga#UHbw5"),e=s[e]&&s[e][i];return!e||(e=e.toLowerCase(),i=t.split(","),t&&V(e,i))||!(!t||!z(e,i))}function W(){var t=a(h);return Q(s[t])}function Q(t){var n,e,n=a("VdgJHc#wJb59"),e=a("Zdg3Ga#UHbw5");return t&&(J(t[n])||K(t[n])||q(t[e]))}function J(t){var n=a("MlSZto#Z");return t&&t===n}function K(t){var n=a("yXbog&w");return t&&t===n}function X(){var t,n,e,t,t=a(h),n=a("VdgJHc#wJb59"),e=a("Udg36Y#oUddV"),t=s[t];return t&&t[n]===e}function q(t){var n,e,i,r,r,n=a("4LJITMx8UMcA"),e=a("jOxo"),i=a("JYw3Gb4NOb6x"),r=a("g1Jbww#Y"),r=new RegExp("^[\\w\\-]+\\."+r+"$","i");return t&&(t===n||t===e||t===i||c.test(t)||r.test(t))}function E(t){return t&&(t.isVd(!1)||t.b&&!t.hl)}function $(e,t){var i,n,r,n,o,n,a,n,u,s,n=(k=t).Workbook.prototype,r=n.Hc;n.Hc=function(){var n=this;if(D(n,function(t){n.ls=t,i=t,n.ul=function(){D(n,function(t){n.ls=t,i=t})}}),!i||E(i))return r.apply(n,arguments)},n.nslc=function(){this.xU=!0},t.PivotTableManager&&(n=t.PivotTableManager.prototype,o=n._Qt,n._Qt=function(){o.apply(this,arguments),i||this.parent||D(this,function(t){i=t})}),n=t.Worksheet.prototype,a=n.Hc,n.Hc=function(){if(i||this.parent||D(this,function(t){i=t}),!i||E(i))return a.apply(this,arguments)},n=t.g7.prototype,u=n.jy,n.jy=function(t,n){u.apply(this,arguments),i&&(-1===i.m||!i.hl&&i.b||i.m&&i.nwm&&(1===i.m||1===i.m&&void 0===i.d))&&e(this.Mf,t,n,i)},s=n.cet,n.cet=function(t,n){s.apply(this,arguments),i&&(-1===i.m||!i.hl&&i.b)&&e(this.Mf,t,n,i)}}function tt(t,n){var e,i;function r(){i.width=(0,o.GC$)(e).width(),i.height=(0,o.GC$)(e).height(),ot(i.getContext("2d"),i.width,i.height,n)}t.yoe||(t.yoe=!0,e=t.Ti,t.sheets=[],t.mp=[],t.dse=[],t.L0(),e&&(i=document.createElement("canvas"),e.appendChild(i),r(),(0,o.GC$)(window).bind("resize",function(){setTimeout(r,100)})))}function O(t){var n;return new e.Common.ResourceManager(i.SR).getResource()[t]}function nt(t){return 1===t.m&&!0===t.s}function et(t,n,e){e&&!nt(e)&&R(t,n,e,!0)}function R(t,n,e,i){var t,r,o,a,u,s,c,t,f,l,h,d,v,m,v,g,n,r,t=O(_([t,"s"])),r=1===k.Workbook.lm?O(_(["ld","se"])):O(_(["lr","su"])),o=rt(t,n);for(r=rt(r,n),o=(o=o.replace("{0}",e.d)).replace("{1}",r).replace("{1}",r),a=[],s=u=0;s<o.length;s++)"\r"!==o[s]&&"\n"!==o[s]||(a.push(o.substring(u,s)),"\r"===o[s]&&s<o.length-1&&"\n"===o[s+1]&&s++,u=s+1);if(u<o.length&&a.push(o.substring(u,o.length)),!0===i)return a;for(t=[],f=[],l=[],h=0,d=(c=e.wm||[]).length;h<d;h++)m=(v=c[h])[0],v=v[1],g=void 0,""!==(g=m instanceof Array?_(m,!0):_(["",m],!0))&&(0===v?l.push(g):1===v&&f.push(g));return(0<f.length||0<l.length)&&(t.push(""),0<f.length&&(n=(n=p().ls9)instanceof Array?_(n,!0):_(["",n],!0),t.push(n.replace(/\{0\}/,f.join(", ")))),0<l.length)&&(r=(r=p().ls10)instanceof Array?_(r,!0):_(["",r],!0),t.push(r.replace(/\{0\}/,l.join(", ")))),1===e.m&&e.nwm?[].concat(t):e.wm&&0<e.wm.length?a.concat(t):a}function it(t){return O(_([t,"sa"]))}function rt(t,n){var e,i,r,o,a,e=!0,i="";if(t)if("string"==typeof t)(t=t.trim())&&(r=[t]);else if(Array.isArray(t)){for(o=!0,r=[],a=0;a<t.length;a++)i=t[a].trim(),r.push(i),o&&i&&(o=!1);o&&(r=null)}return r||(e=!1,r=n),_(r,e)}function ot(t,n,e,i){var r,o,a,u,s,c,f,r="16pt calibri";if(!i||!i.isVd(!1))for(a=R(o=i.hl?(!i.adr||!i.adr.dsr)&&i.e?"l5":"l4":"l3",d,i),l(t,r),t.fillStyle="black",t.fillRect(0,0,n,e),t.fillStyle="white",u=20,s=30,c=0;c<a.length;c++)f=a[c],t.fillText(f,20,s),s+=25}Object.defineProperty(t,"__esModule",{value:!0}),t.Moe=t.Toe=t.eG=t.Vi=t.Aoe=t.decode=void 0,e=n("Common"),i=n("./dist/core/core.ns.js"),o=n("./dist/core/util/domUtil.js"),r=n("./dist/core/util/common.js"),l=r.mt.bt,r=new e.Common.ResourceManager(i.SR),p=r.getResource.bind(r),r=n("./dist/core/lc/lcValidator.js"),u=r.Aoe,a=r.Ioe,n="object"==typeof global&&global&&global.Object===Object&&global,r="object"==typeof self&&self&&self.Object===Object&&self,s=n||r||Function("return this")(),c=/^[\w\-]+$/i,f=/^[0-9.]+$/,v="m",m="n",g="b",b="d",w="e",y="adr",M=a("XRsZ"),C=a("HUkJ"),S=a("T&g"),T=a("Q&w"),A=a("GRz1"),I=a("XSzB"),x=a("XRwh"),N=a("WQs5"),h="JYx3Gb#8Pb5R",d=["Ivldlcneky mi pedslsgaeiycmi o edassac.","nai ies e.Ealsra.ae@rpct.o fyune sitne"],t.decode=_,t.Aoe=D,t.Vi=$,t.eG=tt,t.Toe=R,t.Moe=it},"./dist/core/lc/lcRegister.js":function(t,n,e){"use strict";var v,n,m,e,i,r;function o(h){if(r=null,i[0])try{var d=i[0].jS;d&&d.Ti&&v.Aoe(d,function(t){var n,e,i,r,o,a,u,s,c,f,l,n=d.getActiveSheetOrSheetTab();if(n&&(e=n._gi)!==m.SheetType.customSheetTab&&((o=(r=(i="number"==typeof e)?n.Mf:n).l)&&(t=o),h||o||t.b||-1!==t.m||!t.d||(t.s=!1,v.eG(d,t)),t.nwm))for(u=0,s=a=t.disL||[];u<s.length;u++)(f=r[c=s[u]])&&(l=f.adrs)&&l.apply(f),i&&e===m.SheetType[c]&&(l=n.adrs)&&l.apply(n)},!0)}finally{i=[]}}Object.defineProperty(n,"__esModule",{value:!0}),v=e("./dist/core/lc/releaseLc.js"),n=e("./dist/core/util/domUtil.js"),m=e("./dist/core/core.enum.js"),e=n.GC$.sd,i=[],n.GC$[e]=function(t,n){i.push(t),n?o(n):r=r||setTimeout(o,5e3*Math.random()+3e3)}},"./dist/core/lc/lcValidator.js":function(t){var n=(e=[function(t,_){!function(t){"use strict";var i,h,d,o,v,t,n,m,e,r;function a(t){var n,e;if("number"==typeof t)for(n=new Array(t),e=0;e<t;++e)n[e]=0;else n=t.slice(0);return(n.buffer=n).byteLength=n.length,"object"===(void 0===t?"undefined":i(t))&&t.buffer&&(n.buffer=t.buffer),n}function u(t,n,e,i){1!=t.length&&t.splice(e,1,i(t.splice(n,1,i(t[e]))[0]))}function s(t,n){var n,e,n=1<arguments.length&&void 0!==n?n:1,e=t.charCodeAt(0);return 65<=e&&e<=90?t.toLowerCase():97<=e&&e<=122?t.toUpperCase():48<=e&&e<=57?d(48+(e-48+10+n)%10):t}function c(t){for(var n,e,i,n=t.split(""),e=function t(n){return s(n,-1)},i=n.length-5;0<=i;i--)u(n,i+1,i+3,e),u(n,i,i+2,e);return n.join("")}function f(t){return t.split("").reverse().join("")}function l(t){var n,e,i,r,o,a,u,s,c,f,l,h,t,d,c=[],f="",d=v,h=t,l=h.length%3;if(0<l)for(;l++<3;)f+="=",h+="\0";for(l=0;l<h.length;l+=3)a=(r=(n=h.charCodeAt(l))<<16|(e=h.charCodeAt(l+1))<<8|(i=h.charCodeAt(l+2)))>>12&63,u=r>>6&63,s=63&r,c[l/3]=d.charAt(o=r>>18&63)+d.charAt(a)+d.charAt(u)+d.charAt(s);return t=(t=c.join("")).slice(0,t.length-f.length)+f}function g(t){for(var n,e,i,r,n,o,a,r,u,s,c,f,l,u=[],f=v,c=t,l=0;l<c.length;l+=4)r=f.indexOf(c.charAt(l)),n=f.indexOf(c.charAt(l+1)),o=f.indexOf(c.charAt(l+2)),a=f.indexOf(c.charAt(l+3)),u[l/4]=d(n=(r=r<<18|n<<12|o<<6|a)>>>16&255,e=r>>>8&255,i=255&r),64==a&&(u[l/4]=d(n,e)),64==o&&(u[l/4]=d(n));return s=u.join("")}function p(t){return(h&&window.atob||g)(t)}function b(t){return(h&&window.btoa||l)(t)}function w(t){return decodeURIComponent(Array.prototype.map.call(p(t),function(t){return"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2)}).join(""))}function y(t){return b(encodeURIComponent(t).replace(/%([0-9A-F]{2})/g,function(t,n){return d(parseInt(n,16))}))}function M(t){var t,n;return t?(t=f(t=c(t)),n=Math.ceil(t.length/2),w(t=(t=(t=t.substr(n)+t.substr(0,n)).replace("#","=")).replace("&","=="))):""}function C(t){for(var n,e,i,r,n=p(t),e=n.length,i=new o(e),r=0;r<e;r++)i[r]=n.charCodeAt(r);return i.buffer}function S(t){for(var n,e,i,r,n=new ArrayBuffer(t.length),e=new o(n),i=0,r=t.length;i<r;i++)e[i]=t.charCodeAt(i);return n}function T(t){return d.apply(null,new o(t))}function A(t){return t.replace(/\+/g,"-").replace(/\//g,"_").replace(/\=+$/,"")}function I(t){for(var n,e,i,r,o,a,n=0,e=5381,i=0,r=t.length-1;0<=r;r--)n=(o=t.charCodeAt(r))+(n<<6)+(n<<16)-n,e=o+((e<<5)+e),i=o+((i<<5)-i),i&=i;return(a=(a=n^e^i)<0?~a:a).toString(16).toUpperCase()}function x(t){t&&JSON.parse(t)}function N(t,n){try{n="#"+n;var e=t.indexOf(n);if(-1<e)return{prefix:t.substring(0,e),licData:JSON.parse(M(t.substr(e+n.length)))}}catch(t){}return!1}function k(e){return"oncomplete"in e&&(e.then=function(t,n){e.resolve=t,e.reject=n},e.oncomplete=function(t){e.resolve(e.result)},e.onerror=function(){e.reject()}),e}Object.defineProperty(_,"__esModule",{value:!0}),i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},h="undefined"!=typeof window,d=String.fromCharCode,o=h&&window.Uint8Array||a,v="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",t="object"==(void 0===t?"undefined":i(t))&&t&&t.Object===Object&&t,n="object"==("undefined"==typeof self?"undefined":i(self))&&self&&self.Object===Object&&self,m=t||n,e=_.iDe=M,_.attorn=function t(n,e,i,r){var o,n,a,u,s,n,c,n,f,o=h?window.msCrypto||window.crypto:void 0,n=N(n,e.aC);return n?(a=n.licData,u=n.prefix+"#"+e.aC,s=T(C(y(u+JSON.stringify(a.D)))),n=M("JYx3Gb#8Pb5R"),c=M("VdgJHc#wJb59"),(!m[n]||!m[n][c]||location.protocol.match(/^https/i))&&o&&o.subtle?(n={alg:"PS256",e:"AQAB",kty:"RSA",n:A(e.pK)},n=window.msCrypto?S(JSON.stringify(n)):n,void k(o.subtle.importKey("jwk",n,f={name:"RSA-PSS",saltLength:32,hash:{name:"SHA-256"}},!1,["verify"])).then(function(t){k(o.subtle.verify(f,t,C(a.S),S(s))).then(function(t){return t?i(a.D):r()})},l)):l()):r();function l(){return I(u+JSON.stringify(a.D))===a.H?i(a.D):r()}}}.call(_,function(){return this}())}],i={},r.m=e,r.c=i,r.p="dist",r(0)),e,i;function r(t){var n;return(i[t]||(n=i[t]={exports:{},id:t,loaded:!1},e[t].call(n.exports,n,n.exports,r),n.loaded=!0,n)).exports}t.exports={Aoe:n.attorn,Ioe:n.iDe}},"./dist/core/lc/releaseLc.js":function(t,n,e){"use strict";var M,e,C,S,T;function i(n,t,e,i){var r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,r=n.Fi(),o=203,a=n.parent,u="11pt calibri",s=i.hl&&i.isVd(!1)&&i.d,c=a&&a.xU,f="";for(s?l="l2":i.e?l="l5":i.hl&&!i.d?l="l6":h=M.Moe(l="l1"),r=r||n.Fi(),d=M.Toe(l,S,i),v=0,h&&d.forEach(function(t){v=T(v,n.Qt(t,u))}),n.l=d[0]?i:void 0,m=0;m<d.length&&(203<r.width||203<r.height)&&!c;m++)f=d[m],g=v||n.Qt(f,u),w=r.width-g-(p=10),y=r.height-10-(b=20)*(d.length-m),!t||e&&!e.intersect(w,y,g,20)||(t.save(),t.fillStyle="rgba(0, 0, 0, 0.5)",C(t,u),e&&(t.rect(e.x,e.y,e.width,e.height),t.clip(),t.beginPath()),t.fillText(f,w,20+y),f&&(n.l=i),t.restore())}function r(t){M.Vi(i,t)}function o(t,n){return M.decode(t,n)}Object.defineProperty(n,"__esModule",{value:!0}),n.eG=n.Aoe=n._pt=n.n1e=n.Vi=void 0,M=e("./dist/core/lc/common.js"),e=e("./dist/core/util/common.js"),C=e.mt.bt,S=["LcneNtFud\no edavldlcnekyt u pedSet.\neprr esaeaalbefreauto.\nfyuprhsdalcne orkyi nyu ucaecnimto mi.\nmi sslsgaeiycmi o edassac.","ies o on\rYune  ai ies e ornSra.hes\rTmoayky r vial o vlain\rI o ucae  ies,yu e si orprhs ofraineal\rEalu.ae@rpct.o fyune sitne"],T=Math.max,n.Vi=r,n.n1e=o,n._pt=1,n.Aoe=M.Aoe,n.eG=M.eG},"./dist/core/util/basedialog.js":function(t,n,e){"use strict";var i,r,e,l,a,u,s,h,c,o,f,d,v,e,m,g,p;function b(t,n,e){this.Bc="gc-popup",this.Lc="gc-overlay",this.Fc=null;var i=this;i.Ti=t,i.Pc=e,i.Gc={position:"fixed",width:"100%",height:"100%",margin:0,padding:0,top:0,left:0,border:"none",zIndex:n=n||0,backgroundColor:"rgba(0,0,0,0)"},i.Uc={position:"absolute",padding:0,margin:0,height:"auto",zIndex:n+1,outline:"none"},i.Hc()}function w(t,n,e){var o=p.call(this,t,n,e)||this;return o.Mse=!1,o.Cse={mouseOriginalX:0,mouseOriginalY:0,domOriginalX:0,domOriginalY:0,domWidth:0,domHeight:0,parentRect:null,screenWidth:0,screenHeight:0},o.Sse=function(t){var n,e,t,e,i,t,r,i,t,n=o;n.Mse&&n.mouseInScreen(t.pageX-window.scrollX,t.pageY-window.scrollY)&&(e=t.pageX,t=t.pageY,i=e-(e=n.Cse).mouseOriginalX,t=t-e.mouseOriginalY,e.parentRect)&&(r=n.Wc[0],i=Math.max(0,e.domOriginalX+Math.min(i,e.screenWidth-e.domOriginalX-e.domWidth+(n.Pc?0:window.scrollX))),t=Math.max(0,e.domOriginalY+Math.min(t,e.screenHeight-e.domOriginalY-e.domHeight+(n.Pc?0:window.scrollY))),r.style.left="".concat(i,"px"),r.style.top="".concat(t,"px"))},o.Ise=function(){window.removeEventListener("mousemove",o.Sse),o.Mse=!1},o}i=this&&this.__extends||(g=function(t,n){return(g=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}g(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(n,"__esModule",{value:!0}),n.Ase=n.zc=void 0,r=e("./dist/core/util/common.js"),e=e("./dist/core/util/domUtil.js"),l=e.GC$,a=r.util.En,u=r.util.Tt,s=r.util.vi,h=document,c=window,o=c.Vc,f="touchstart",d="MSPointerDown",v="pointerdown",b.prototype.Hc=function(){var t=this;t.Yc(t.Zc)?t.Wc=l("#"+t.Zc):(t.Zc=t.Qc(),t.Kc=t.Lc+"-"+t.Zc,t.Jc=t.Bc+"-"+t.Zc,t.Wc=l(a("div")).addClass(t.Jc+" ui-widget").attr({id:t.Zc,tabIndex:-1}).css(t.Uc))},b.prototype.Qc=function(){for(var t,n,t=0,n="gc-dialog";this.Yc(n+t.toString());)t++;return n+t.toString()},b.prototype.Xc=function(){if(this.Wc)return this.Wc},b.prototype.qc=function(){return this.Ti||h.body},b.prototype.$c=function(t){var n=this,e=n.Wc;n.tf()||n.nf(),o.ef(),n.Yc(n.Zc)||(l(n.qc()).append(e),n.if(),e.css("display","none")),e.show(t)},b.prototype.rf=function(){return"block"===this.Wc.css("display")},b.prototype.close=function(){var t=this;t.af(),t.Yc(t.Zc)&&t.Wc.remove(),l("."+t.Jc).isVisible()||t.uf(),o.cf()},b.prototype.uf=function(){l("."+this.Kc).remove(),this.Fc=null},b.prototype.af=function(){var n=this.Zc;[f,d,v].forEach(function(t){l(h).unbind(t+"."+n)})},b.prototype.if=function(){var t,n,n,e,i,r,o,a,u,s,c,s,f,t=this.Wc,n=this.qc();0===t.length||(n=l(n).offset(),e=parseInt(t.css("left"),10)+n.left,i=parseInt(t.css("top"),10)+n.top,r=t.width(),o=t.height(),isNaN(e))||isNaN(i)||isNaN(r)||isNaN(o)||(c=(s=h.documentElement).clientWidth,s=s.clientHeight,(f=t[u=a=0].getBoundingClientRect()).left+r>c&&(u=f.left+r-c),f.top+o>s&&(a=f.top+o-s),(e<0||i<0||0<a||0<u)&&t.css({left:(e=(e-=u)<0?0:e)-n.left+"px",top:(i=(i-=a)<0?0:i)-n.top+"px"}))},b.prototype.Yc=function(t){return 0<l("#"+t).length},b.prototype.nf=function(){var e,n,t,i,r,o,e=this,n=e.Zc,t=l(a("div")).addClass(e.Kc),i=e.Wc;(e.Fc=t).css(e.Gc),l(e.qc()).append(t),(r=u&&u.mozilla)&&(o=(new Date).valueOf()),t.bind("mousedown",function(t){if(!e.Pc){var n;if(r)if((new Date).valueOf()-o<100)return;e.close(),r&&e.ff&&clearTimeout(e.ff)}s(t)}),t.bind("contextmenu",function(t){e.Pc&&s(t)}),i.bind("contextmenu",function(t){s(t)}),[f,d,v].forEach(function(t){l(h).bind(t+"."+n,function(t){var n=t.target;e.Fc&&!e.lf(n)&&(e.Pc||(r?e.ff=c.setTimeout(function(){e.close()},100):e.close()),s(t))})})},b.prototype.hf=function(t,n){for(var e=t;n&&n!==document.body;){if(n===e)return!0;n=n.parentNode}return!1},b.prototype.lf=function(t){return!!this.Wc&&this.hf(this.Wc.get(0),t)},b.prototype.tf=function(){return 0<l("."+this.Kc).length},n.zc=e=b,i(w,p=e),w.prototype.bindMoveEvent=function(t){var i=this;t.addEventListener("mousedown",function(t){var n,e,t,t,n=i.Wc[0],e=i.Cse;e.mouseOriginalX=t.pageX,e.mouseOriginalY=t.pageY,t=n.getBoundingClientRect(),e.domOriginalX=t.left+(i.Pc?0:window.scrollX),e.domOriginalY=t.top+(i.Pc?0:window.scrollY),e.domWidth=t.width,e.domHeight=t.height,(t=n.offsetParent)?e.parentRect=t.getBoundingClientRect():"fixed"===n.style.position&&(e.parentRect=n.getBoundingClientRect()),e.screenWidth=window.innerWidth,e.screenHeight=window.innerHeight,i.Mse=!0,window.addEventListener("mousemove",i.Sse)}),document.addEventListener("mouseup",i.Ise)},w.prototype.mouseInScreen=function(t,n){return 0<=t&&t<=this.Cse.screenWidth&&0<=n&&n<=this.Cse.screenHeight},n.Ase=w},"./dist/core/util/common.js":function(a,f,s){"use strict";var F,h,t,P,T,G,U,H,C,V,z,Y,Z,d,W,A,Q,J,K,t,X,q,l,v,$,tt,nt,et,m,I,it,x,N,g,rt,ot,at,ut,st,ct,S,ft,p,lt,ht,dt,vt,mt,gt,pt,bt,wt,yt,Mt,Ct,St,Tt,At,It,xt,Nt,b,w,kt,_t,u,Dt,jt,Et,Ot,Rt,Lt,Bt,Ft,P,Pt,Gt,Ut,Ht,Vt,zt,Yt,Zt,Wt,Qt,Jt,Kt,Xt,qt,P,t,n,$t,tn;function nn(t){return t!==m}function en(t){return v.createElement(t)}function rn(t){v.body&&v.body.insertBefore(t,I)}function on(t,e,i){Object.defineProperty(t,e,{get:function(){return this._ps[e]},set:function(t){var n=this._ps[e];n!==t&&(this._ps[e]=t,i)&&i(e,t,n)},enumerable:!0})}function an(t,n){var t;return t.style&&t.style.vertAlign?(t=H.W.V(n,1)).fontSize*st+"px "+t.fontFamily:n}function un(t){return t.preventDefault?(t.preventDefault(),t.stopPropagation()):(t.cancelBubble=!1,t.returnValue=!1),!1}function sn(t){var n,e,i,n=!1;if(t)for(e=0;e<t.length;e++)if(11904<=(i=t.charCodeAt(e))&&i<12032||12288<=i&&i<40960||43360<=i&&i<43392||63744<=i&&i<64256){n=!0;break}return n}function cn(t){return Math.random().toString(16).slice(-t)}function fn(e){return function(t,n){return String.fromCharCode(parseInt(n,e))}}function ln(t){if(!t||"string"!=typeof t)return!1;var n;switch((t=t.toLowerCase())[0]){case"b":return 0===t.indexOf("background ");case"t":return 0===t.indexOf("text ");case"a":return 0===t.indexOf("accent ");case"h":return 0===t.indexOf("hyperlink");case"f":return 0===t.indexOf("followedhyperlink");default:return!1}}function hn(t,n,e){var i,r,o,a,i=0,o=t.split(" ");if(3<=o.length&&(i=parseFloat(o[2]),isNaN(i)||(i/=100)),"Background 1"===t.substring(0,12)&&(r=n?243:0),"Text 1"===t.substring(0,6)&&(r=n?241:1),"Background 2"===t.substring(0,12)&&(r=n?244:2),"Text 2"===t.substring(0,6)&&(r=n?242:3),"Accent 1"===t.substring(0,8)&&(r=4),"Accent 2"===t.substring(0,8)&&(r=5),"Accent 3"===t.substring(0,8)&&(r=6),"Accent 4"===t.substring(0,8)&&(r=7),"Accent 5"===t.substring(0,8)&&(r=8),"Accent 6"===t.substring(0,8)&&(r=9),"hyperlink"===t.substring(0,8)&&(r=10),(r="followedHyperlink"===t.substring(0,8)?11:r)!==m)return{n_:a=e||"color",theme:r,tint:i}}function dn(t,n){var e=t.tint?Math.round(100*t.tint):0,t=+t.theme;return 0==t||243==t?"Background 1 "+e:1==t||241==t?"Text 1 "+e:2==t||244==t?"Background 2 "+e:3==t||242==t?"Text 2 "+e:4==t?"Accent 1 "+e:5==t?"Accent 2 "+e:6==t?"Accent 3 "+e:7==t?"Accent 4 "+e:8==t?"Accent 5 "+e:9==t?"Accent 6 "+e:10==t?"hyperlink":11==t?"followedHyperlink":void 0}function c(){}function vn(t){return Mt.getIndexedColor(+t.indexed)}function mn(t,n){var t,e,t=Mt.convertColorToHex(t);if(t)return{n_:e=n||"color",rgb:t}}function gn(t,n){var e,i,r,o,a,o,e=0,i,r=document.createElement("canvas").getContext("2d");return r||(o=s("canvas"))&&o.createCanvas&&(r=(a=o.createCanvas(2,2)).getContext("2d")),r&&(r.font=t,e=(o=r.measureText(n)).emHeightAscent+o.emHeightDescent),e}function k(){}function pn(t){t=t.toLowerCase();var t=/(chrome)[ \/]([\w.]+)/.exec(t)||/(webkit)[ \/]([\w.]+)/.exec(t)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(t)||/(msie) ([\w.]+)/.exec(t)||t.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(t)||[];return{browser:t[1]||"",version:t[2]||"0"}}function bn(){var n,e,n=I,e=!1;try{new ActiveXObject("")}catch(t){n=t.name}try{e=!!new ActiveXObject("htmlfile")}catch(t){e=!1}return!(e="ReferenceError"===n||!1!==e)}function wn(){}function yn(t,n){var e=en("span");return e.className=t,n&&(e.id=n),e.style.display="none",rn(e),e}function Mn(t,n,e,i){t.addEventListener(n,e,i)}function Cn(t){var n,e,n=t.currentStyle,e=v.defaultView;return n=e&&e.getComputedStyle?e.getComputedStyle(t,""):n}function Sn(t){var n,n,e,i,e,n,r,o,n=l.Vc;0<n.vf||(16!==t.keyCode&&(n.mf=!0),(e=(n=kt.ai())&&n.gf)&&(i=C(e)).isVisible())||n&&n.rt&&n.rt.pf&&(n.rt.pf(t),n.isEditing()||(e=t.keyCode,n=t.ctrlKey,r=t.altKey,o=t.shiftKey,90!==e&&89!==e||!n||r?86!==e||!n||r||o||t.stopPropagation&&t.stopPropagation():un(t)))}function Tn(t){var n,n,n=l.Vc;0<n.vf||(n.mf=!1,(n=kt.ai())&&n.rt&&n.rt.bf&&n.rt.bf(t))}function An(t){var n,e,n;0<l.Vc.vf||(e=kt.ai())&&e.rt&&e.rt.yf&&e.rt.yf(t)}function In(t){var n,n,n=l.Vc;0<n.vf||!0!==n.mf&&(n=kt.ai())&&n.rt&&n.rt.yf&&n.rt.yf(t)}function xn(t){return v.all===m&&kt.ai()&&un(t),!1}function e(){this.vf=0,this.wf=[],this.mf=!1,this.Hc()}function r(){}function Nn(t,n){this.x=t,this.y=n}function y(t,n,e,i){var r=this;r.x=t,r.y=n,r.width=e,r.height=i}function M(t,n,e,i){var r=this;r.row=t,r.rowCount=e,r.col=n,r.colCount=i}function kn(t,n,e,i){return new Ot(t,n,e,i)}function _n(t,n){var e,i,r,t;if(t&&n){if(e=N(t.row,n.row),i=N(t.col,n.col),r=g(t.row+t.rowCount-1,n.row+n.rowCount-1),t=g(t.col+t.colCount-1,n.col+n.colCount-1),0<=e&&0<=i)return new Ot(e,i,r-e+1,t-i+1);if(0<=e)return new Ot(e,-1,r-e+1,-1);if(0<=i)return new Ot(-1,i,-1,t-i+1)}return new Ot(-1,-1,-1,-1)}function Dn(){}function i(){}function o(t){this.Mf=t}function _(){}function jn(t){var n=t.Cf||{scaleX:1,scaleY:1,translateX:0,translateY:0,skewX:0,skewY:0,orgTranslateX:0,orgTranslateY:0};return t.Cf=n}function En(){}function On(t,n){t&&(t.Sf=n)}function Rn(t,n){t&&(t.Tf=n)}function Ln(t,n){t.Af=n}function Bn(t,n){t.If=n}function D(){}function j(){var t,t;return Ut.xf||(Ut.xf=en("canvas").getContext("2d")),Ut.xf||(t=s("canvas"))&&t.createCanvas&&(t=t.createCanvas(2,2),Ut.xf=t.getContext("2d")),Ut.xf}function Fn(t){return h.Common.CultureManager.Fe().hse(t)}function E(t){for(var n=t.length-1;" "===t.charAt(n);)n--;return t=n!==t.length-1?t.substring(0,n+1):t}function Pn(t){var n,e,n=t instanceof Array?[]:{};for(e in t)t.hasOwnProperty(e)&&(n[e]="object"==typeof t[e]&&t[e]!==I?Pn(t[e]):t[e]);return n}function Gn(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,h,o=[],a=r||j();if(a){for(s=e?(c=t.length*i,x(n/i)):(u=(c=w(a,a.font,t))/t.length,x(n/u));n<c&&t;)for(f=!1,l=s;;){if(t.length<l){o.push(t),t="";break}if(h=t.substring(0,l),d=e?l*i:w(a,a.font,h),(d="-"===h.charAt(h.length-1)?e?l*i:w(a,a.font,h)-w(a,a.font,"-"):d)===n||f&&d<n){o.push(h),t=t.substring(l),c-=d;break}if(n<d){if(1===h.length){(v=t.substring(h.length)).trim()?(o.push(h),t=t.substring(l),c-=d):(o.push(t),t="");break}--l,f=!0}else l+=h=1<=(h=e?(n-d)/i:(n-d)/u)?h:1}t&&-1===t.search(/^[ ]*$/)&&o.push(t)}return o}function Un(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,a=o||j();if(!a)return[t];for(u=[],c=n,f=[],l=s=0;l<t.length;l++)if(h=t[l].style&&t[l].style.font||r,d=b.vt(h),h=an(t[l],h),t[l].text&&0<t[l].text.length?s+=i?d*t[l].text.length:w(a,h,t[l].text):s=0,s<c)f.push(t[l]);else for(s-=i?d*t[l].text.length:w(a,h,t[l].text),v=0,m=t[l].text.length;v<m;v++){if(e<(g=i?d:w(a,h,t[l].text.charAt(v)))&&0===v){0<f.length&&(u.push(f),f=[]),f.push({style:t[l].style,text:t[l].text.substring(0,1)}),u.push(f),f=[],(p=t[l].text.substring(1,t[l].text.length)).length&&t.splice(l+1,0,{style:t[l].style,text:p}),s=0,c=e;break}if(c<(s+=g)){f.push({style:t[l].style,text:t[l].text.substring(0,v)}),u.push(f),f=[],(p=t[l].text.substring(v,t[l].text.length)).length&&t.splice(l+1,0,{style:t[l].style,text:p}),s=0,c=e;break}v===m-1&&(f.push({style:t[l].style,text:t[l].text}),u.push(f),f=[],s=0,c=e)}return 0<f.length&&u.push(f),u}function Hn(t,n,e,i,r){var o,a,u,r,r,s,c,f,l,h,d,v,m,m,g,p,b,o=[],a=Fn(t),u=r||j();if(u){for(r=w(u,u.font,t),r=e?i:r/t.length,s=ot(n/r+"",10),h=l=f=c=0,v=!(d=[]);h<a.length;){if(!1===v){if(m=a[h],d.push(m),(f+=m.length)<s&&h<a.length-1){h++;continue}l=f,f=0}if(n<(m=e?d.join("").length*i:Ut.Wt(d.join(""),u.font,!0,u)))if(g=d.pop(),0===d.length){for(p=Gn(g,n,e,i,u),b=0;b<p.length-1;b++)o[c]=p[b],c++;1===p.length&&(o[c]=p[0],c++),2<=p.length?a[h]=p[p.length-1]:h++,v=!1}else v=!0,h--;else m<n&&!0===v||m===n?(v=!1,o[c]=E(d.join("")),c++,d=[],h++):m<n&&(h++,f=l)}0!==d.length&&(o[c]=E(d.join("")))}return o}function Vn(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p,o=[],a=r||j();if(a)if(0===t.length)o.push({textLength:0,text:"",textInfos:[{style:{font:e},text:""}]});else{for(s=[],c=u=0;c<t.length;c++){for(f=t[c],d=h=l=0;d<f.length;d++)v=void 0,v=f[d].style&&f[d].style.font?f[d].style.font:e,i?l+=(h=b.vt(v))*f[d].text.length:A(f[d].text)||(v=an(f[d],v),l+=w(a,v,f[d].text));if(n<l){for(0<s.length&&(o.push({textLength:u,text:E(Yn(s)),textInfos:Pn(s)}),s=[],u=0),m=Un(f,n-u,n,i,e,a),s=s.concat(m[0]),A(m[0])||o.push({textLength:u+zn(m[0],e,i,a),text:E(Yn(s)),textInfos:Pn(s)}),s=[],u=0,g=1;g<m.length-1;g++)A(m[g])||o.push({textLength:zn(m[g],e,i,a),text:E(Yn(m[g])),textInfos:Pn(m[g])});1<m.length&&(p=m[m.length-1],s=s.concat(p),A(p)||(u+=zn(p,e,i,a)))}else n<u+l?(o.push({textLength:u,text:E(Yn(s)),textInfos:Pn(s)}),s=(s=[]).concat(f),u=l):(s=s.concat(f),u+=l)}0<s.length&&o.push({textLength:u,text:E(Yn(s)),textInfos:Pn(s)})}return o}function zn(t,n,e,i){for(var r,o,a,u,s,r=0,o=i||j(),a=0;a<t.length;a++)u=t[a].style&&t[a].style.font||n,s=an(t[a],u),r+=e?b.vt(u)*t[a].text.length:w(o,s,t[a].text);return r}function Yn(t){for(var n,e,n="",e=0;e<t.length;e++)n+=t[e].text;return n}function Zn(t,n,e,i){for(var r,o,a,u,s,c,c,r=-1,o=!0,a=0;a<n.length;a++)if(!A(n[a].text))for(u=0;u<n[a].text.length;u++)s=n[a].text.charAt(u),c=n[a].style?n[a].style.font:e,b.bt(t,c),c=b.vt(c),s===S||o?s!==S&&o&&(r=i?c:w(t,e,s),o=!1):r=N(r,i?c:w(t,e,s));return r}function O(){}function Wn(){this.Nf={}}function Qn(){}function Jn(t){var n,e,n,i,e,n,e,e,n=t.getRangeAt(0),e=n.startContainer,n=n.startOffset,i;Xn(e)&&(e=oe(e,n))&&e.zeroWidthCharNode&&(n=e.zeroWidthCharNode,(e=t.getRangeAt(0)).setStart(n,1),e.deleteContents(),(e=v.createRange()).setStart(n,1),e.setEnd(n,1),t.removeAllRanges(),t.addRange(e),un(event))}function Kn(t){return t.textContent&&1===t.textContent.length&&t.textContent.split("")[0]===gt}function Xn(t){return t.textContent&&t.textContent.split("")[0]===gt}function qn(t,n,e){if(1===n&&R(e.firstChild)&&R(e.firstChild.firstChild)){var n=e.firstChild.firstChild.lastChild,i=void 0;if(t===e)return 1===(i=n.textContent).length&&i[0]!==gt&&$n(n.previousSibling);if(n===t||$n(n)&&t===n.previousSibling)return 1===(i=t.textContent).length&&i[0]!==gt&&$n(t.previousSibling)}}function R(t){return t&&"SPAN"===t.tagName}function $n(t){return t&&"BR"===t.tagName}function te(t){return t&&"DIV"===t.tagName}function ne(t){return t instanceof Text}function ee(t){var n;return!!t&&(n=t.childNodes,R(t))&&2===n.length&&$n(n[0])&&re(n[1])}function ie(t,n){var e;if(t)return e=t.childNodes,R(t)&&$n(e[n-2])&&re(e[n-1])}function re(t){if(t&&ne(t)){var t=t.textContent;if(1===t.length&&ce(t[0]))return!0}return!1}function oe(t,n){var e,i,r,o,i,e,n,e=t.childNodes.length,o;if(!ce((t.innerText||t.textContent)[0])||0!==n&&1!==n)if(0===n)i=(i=fe(r=(r=t)===t.parentNode.firstChild?t.parentNode:r,ee))&&i.lastChild;else{if(te(t))return 1===e&&1===n?i=t.firstChild.firstChild.lastChild:1<e&&n===e&&(i=t.lastChild),re(i)?{zeroWidthCharNode:i,previousTextNode:i.previousSibling.previousSibling}:ee(i)?{zeroWidthCharNode:i,previousTextNode:fe(r,ne)}:I;!R(t)||n!==e&&n!==e-1||(ee(t)?i=t:ee(t.lastChild)?i=t.lastChild:ie(t,n)&&(i=t.childNodes[n-1]))}else i=t;return i?(R(i)?r=i:ne(i)&&(r=(e=i.previousSibling)===(n=i.parentNode).firstChild?n:e),{zeroWidthCharNode:i,previousTextNode:fe(r,ne)}):I}function ae(t){var n,t,e,i,r,t,n=t.anchorNode,t=t.anchorOffset,e=n.textContent,i;if(t!==e.length)return 0===t&&ce(e[0])?{node:n,offset:0}:I;if(t=void 0,!(r=le(n)))return I;if(R(r)&&ce(r.textContent[0])){for(;R(r.firstChild);)r=r.firstChild;t=r.childNodes[1]}else $n(r)&&ce(r.nextSibling.textContent[0])&&(t=r.nextSibling);return{node:t,offset:1}}function ue(t,n,e,i,r,o){for(var a,u,s,c,f,l,h,d,a="",u=t.childNodes,s=u.length,c=0;c<s;c++)R(f=u[c])?a+=ue(f,n,e,i,r,o):ne(f)?(l=n&&n.startContainer,h=n&&n.endContainer,d=f.textContent,f===l||f===h?l!==h?o=f===l?(a+=se(d,e,d.length,r),!0):(a+=se(d,0,i,""),!1):a+=se(d,e,i,r):o||(a+=d)):$n(f)&&!o&&(a+="\n");return a}function se(t,n,e,i){var r,o,r,o;return t.substr(0,n)+i+t.substr(e,t.length-e)}function ce(t){return t===gt}function fe(t,n){for(var e=t&&t.previousSibling;e;){if(n(e))return e;e=e.lastChild}return I}function le(t){for(var n,e,n=t;n;){if(n!==(e=n.parentNode).lastChild)return n.nextSibling;n=e}return I}function he(t){var n,t;return n=t&&!(n=t.getActiveSheet())&&(t=t.getActiveSheetTab())?t.Mf:n}function de(t,n){var e,i;t&&((e=t._f(n))?t.setActiveSheet(n):(i=t.Ofe(n))&&t.setActiveSheetTab(n))}function ve(t,n){var e,t,e=t._f(n);return e||(t=t.Ofe(n))&&(e=t.Mf),e}function me(t){return"="===t||"+"===t||"-"===t}function ge(t){var n=0;return"+"!==t[n]&&"-"!==t[n]||(n+=1),t.length>n&&"%"===t[n]?t.length>n+1&&("-"===t[n+1]||"+"===t[n+1])?NaN:Number(t.slice(n+1)):0<t.length&&"%"===t[t.length-1]?Number(t.slice(0,t.length-1)):Number(t)}function pe(t){return t&&0<t.length&&me(t[0])&&isNaN(ge(t))&&!me(t)}function be(){}function we(){var t=this;t.rowInfo=[],t.colInfo=[],t.wholeCols={},t.wholeRows={}}function ye(){this.reset()}function Me(t,n){var n=Math.pow(10,n);return Math.round(t*n)/n}function L(){}function B(){}function Ce(){var t,n,e,i,r,t=this;try{e="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol?"symbol":typeof t},i="object"===("undefined"==typeof global?"undefined":e(global))&&global&&global.Object===Object&&global,r="object"===("undefined"==typeof self?"undefined":e(self))&&self&&self.Object===Object&&self,n=i||r||t}catch(t){}return n}function Se(t,n){this.numberFormatId=t,this.numberFormatCode=n}function Te(t){return!1===t}function Ae(t){var n,e,i,r,o,a;t&&(n=t.applyFont,e=t.applyFill,i=t.applyBorder,r=t.applyAlignment,o=t.applyNumberFormat,a=t.applyProtection,!1===n&&(delete t.foreColor,delete t.textDecoration,delete t.themeFont,delete t.font),!1===e&&delete t.backColor,!1===i&&(delete t.borderLeft,delete t.borderTop,delete t.borderRight,delete t.borderBottom,delete t.diagonalDown,delete t.diagonalUp),!1===r&&(delete t.textIndent,delete t.wordWrap,delete t.hAlign,delete t.vAlign,delete t.isVerticalText,delete t.shrinkToFit,delete t.textOrientation),!1===o&&delete t.formatter,!1===a)&&delete t.locked}function Ie(t,n,e,i){var r,n;e&&(r=e.foreColor,r=Dt.m(n,r),i=A(e.opacity)?i:e.opacity,A(i)||((n=z._(r)).a=i,r=z.j(n)),t.fillStyle!==r)&&(t.fillStyle=r||"#000000")}F=this&&this.__spreadArray||function(t,n,e){if(e||2===arguments.length)for(var i=0,r=n.length,o;i<r;i++)!o&&i in n||((o=o||Array.prototype.slice.call(n,0,i))[i]=n[i]);return t.concat(o||Array.prototype.slice.call(n))},Object.defineProperty(f,"__esModule",{value:!0}),f.resetFillStyle=f.AL=f.ExcelNumerFormat=f.ExtendedNumberFormatHelper=f.SJSColumnWidthHelper=f.unknownFontMaxDigitWidthMap=f.SharedStrings=f.NUMBER_ARRAY=f.BaseUsedRange=f.UsedRangeUtil=f.kf=f.Df=f._f=f.Ef=f.jf=f.Of=f.di=f.Rf=f.$e=f.q=f.zt=f.Bf=f.Lf=f.Be=f.Ff=f.Events=f.Pf=f.getUnionRange=f.Ec=f.Range=f.Rect=f.Point=f.I=f.hi=f.mt=f.util=f.ColorHelper=f.isThemeColor=f.findControl=f.getTypeFromString=f.CursorResource=f.productInfo=f.isDefined=f.FormulaPrefix=f.FallbackFontFamily=void 0,h=s("Common"),t=s("./dist/core/util/domUtil.js"),P=s("./dist/core/core.ns.js"),T=s("./dist/core/core.enum.js"),G=s("./dist/core/excel-io-util/common.js"),U=s("CalcEngine"),H=s("./dist/core/worksheet/stylehelper.js"),C=t.GC$,V=C.extend,z=h.Common.ft,Y=h.Common.st,Z=h.Common.Uf.Gf,d=h.Formatter&&h.Formatter.GeneralFormatter,W=h.Formatter&&h.Formatter.Hf,A=h.Common.lt.ht,Q=G.StringEx.Xi,J=h.Common.zf,K=!!U,t=new h.Common.ResourceManager(P.SR),X=t.getResource.bind(t),f.FallbackFontFamily='"Helvetica Neue", Arial, sans-serif',q=G.Util.addXLFNPrefix,l=window,v=document,$="boolean",tt="date",nt="undefined",et="function",m=void 0,I=null,it=Math.floor,x=Math.ceil,N=Math.min,g=Math.max,rt=Math.round,ot=parseInt,at=parseFloat,ut=isNaN,st=.7,ct="px",S=" ",ft=".",p="string",lt="number",ht="touch",dt="MSPOINTER_TYPE_TOUCH",vt=new RegExp("^/Date\\((-?\\d+)([-+]{1}\\d+)?\\)/\\s*$"),mt=new RegExp("^/OADate\\(([-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)\\)/\\s*$"),gt="\u200b",f.FormulaPrefix=["=","+","-"],f.isDefined=nn,f.productInfo={productVersion:"16.2.5"},f.CursorResource={ResizeCol:"col-Resize",ResizeRow:"row-resize",ResizeHiddenCol:"w-resize",ResizeHiddenRow:"n-resize"},f.getTypeFromString=pt=function(t){var n,e,i,r,o,n=!1,e=l;if(typeof t===p){for(r=0,o=(i=t.split(ft)).length;r<o&&e;r++)e=e[i[r]];e&&r===o&&0<o&&(n=!0)}return n?e:m},f.findControl=bt=function(t){return typeof t===p&&(t=v.getElementById(t)),C(t).data("workbook")},f.isThemeColor=ln,wt=[4278190080,4294967295,4294901760,4278255360,4278190335,4294967040,4294902015,4278255615,4278190080,4294967295,4294901760,4278255360,4278190335,4294967040,4294902015,4278255615,4286578688,4278222848,4278190208,4286611456,4286578816,4278222976,4290822336,4286611584,4288256511,4288230246,4294967244,4291624959,4284874854,4294934656,4278216396,4291611903,4278190208,4294902015,4294967040,4278255615,4286578816,4286578688,4278222976,4278190335,4278242559,4291624959,4291624908,4294967193,4288269567,4294941132,4291598847,4294954137,4281558783,4281584844,4288269312,4294953984,4294940928,4294927872,4284901017,4288059030,4278203238,4281571686,4278203136,4281545472,4288230144,4288230246,4281545625,4281545523,4278190080,4294967295],yt={aliceblue:4293982463,antiquewhite:4294634455,aqua:4278255615,aquamarine:4286578644,azure:4293984255,beige:4294309340,bisque:4294960324,black:4278190080,blanchedalmond:4294962125,blue:4278190335,blueviolet:4287245282,brown:4289014314,burlywood:4292786311,cadetblue:4284456608,chartreuse:4286578432,chocolate:4291979550,coral:4294934352,cornflowerblue:4284782061,cornsilk:4294965468,crimson:4292613180,cyan:4278255615,darkblue:4278190219,darkcyan:4278225803,darkgoldenrod:4290283019,darkgray:4289309097,darkgreen:4278215680,darkkhaki:4290623339,darkmagenta:4287299723,darkolivegreen:4283788079,darkorange:4294937600,darkorchid:4288230092,darkred:4287299584,darksalmon:4293498490,darkseagreen:4287609999,darkslateblue:4282924427,darkslategray:4281290575,darkturquoise:4278243025,darkviolet:4287889619,deeppink:4294907027,deepskyblue:4278239231,dimgray:4285098345,dodgerblue:4280193279,feldspar:4291924597,firebrick:4289864226,floralwhite:4294966e3,forestgreen:4280453922,fuchsia:4294902015,gainsboro:4292664540,ghostwhite:4294506751,gold:4294956800,goldenrod:4292519200,gray:4286611584,green:4278222848,greenyellow:4289593135,honeydew:4293984240,hotpink:4294928820,"indianred ":4291648604,"indigo ":4283105410,ivory:4294967280,khaki:4293977740,lavender:4293322490,lavenderblush:4294963445,lawngreen:4286381056,lemonchiffon:4294965965,lightblue:4289583334,lightcoral:4293951616,lightcyan:4292935679,lightgoldenrodyellow:4294638290,lightgrey:4292072403,lightgreen:4287688336,lightpink:4294948545,lightsalmon:4294942842,lightseagreen:4280332970,lightskyblue:4287090426,lightslateblue:4286869759,lightslategray:4286023833,lightsteelblue:4289774814,lightyellow:4294967264,lime:4278255360,limegreen:4281519410,linen:4294635750,magenta:4294902015,maroon:4286578688,mediumaquamarine:4284927402,mediumblue:4278190285,mediumorchid:4290401747,mediumpurple:4287852760,mediumseagreen:4282168177,mediumslateblue:4286277870,mediumspringgreen:4278254234,mediumturquoise:4282962380,mediumvioletred:4291237253,midnightblue:4279834992,mintcream:4294311930,mistyrose:4294960353,moccasin:4294960309,navajowhite:4294958765,navy:4278190208,oldlace:4294833638,olive:4286611456,olivedrab:4285238819,orange:4294944e3,orangered:4294919424,orchid:4292505814,palegoldenrod:4293847210,palegreen:4288215960,paleturquoise:4289720046,palevioletred:4292374675,papayawhip:4294963157,peachpuff:4294957753,peru:4291659071,pink:4294951115,plum:4292714717,powderblue:4289781990,purple:4286578816,red:4294901760,rosybrown:4290547599,royalblue:4282477025,saddlebrown:4287317267,salmon:4294606962,sandybrown:4294222944,seagreen:4281240407,seashell:4294964718,sienna:4288696877,silver:4290822336,skyblue:4287090411,slateblue:4285160141,slategray:4285563024,snow:4294966010,springgreen:4278255487,steelblue:4282811060,tan:4291998860,teal:4278222976,thistle:4292394968,tomato:4294927175,turquoise:4282441936,violet:4293821166,violetred:4291829904,wheat:4294303411,white:4294967295,whitesmoke:4294309365,yellow:4294967040,yellowgreen:4288335154,transparent:16777215},c.hexToARGB=function(t){return{r:(t="string"==typeof t?parseInt(t,16):t)>>16&255,g:t>>8&255,b:255&t,a:t>>24&255}},c.getClosestColorIndex=function(t,n){var e,i,r,o,a,u,s,o;for(n===m&&(n=64),e=-1,i=Number.MAX_VALUE,r=Math.min(c.palette.length-1,n);0<=r;r--)u=(65280&(o=c.palette[r]))>>8,s=255&o,(o=Math.abs(.3*((a=(16711680&o)>>16)-t.r))+Math.abs(.59*(u-t.g))+Math.abs(.11*(s-t.b)))<i&&(i=o,e=r);return e},c.getHexNumString=function(t){var n,n,n=+t;return isNaN(n)?t+"":(n=(t=n).toString(16),t<16?"0"+n:n)},c.convertColorToHex=function(t){var t,n,e,i,r,o;if(t)return"string"!=typeof t?t:("#"===(t=t.toLowerCase()).substring(0,1)?7===t.length?n="FF"+t.substring(1).toUpperCase():4===t.length&&(n="FF"+(e=t[1]+t[1]+t[2]+t[2]+t[3]+t[3]).toUpperCase()):"rgb("===t.substring(0,4)?(r=t.indexOf("("),o=t.indexOf(")"),i=t.substring(r+1,o).split(","),n="FF"+(e=c.getHexNumString(i[0])+c.getHexNumString(i[1])+c.getHexNumString(i[2])).toUpperCase()):"rgba("===t.substring(0,5)?(r=t.indexOf("("),o=t.indexOf(")"),i=t.substring(r+1,o).split(","),n=(e=c.getHexNumString(i[3])+c.getHexNumString(i[0])+c.getHexNumString(i[1])+c.getHexNumString(i[2])).toUpperCase()):yt[t]&&(n=yt[t].toString(16).toUpperCase()),n)},c.convertHexColorToArgb=function(t){return c.hexToARGB(c.convertColorToHex(t))},c.getIndexedColor=function(t){var t,n,e,i;return 32767===t||t<0||wt.length<=t?"#000000":wt[t]!==m?"rgb("+(n=(t=wt[t])>>16&255)+","+(e=t>>8&255)+","+(i=255&t)+")":void 0},c.palette=[4278190080,4294967295,4294901760,4278255360,4278190335,4294967040,4294902015,4278255615,4278190080,4294967295,4294901760,4278255360,4278190335,4294967040,4294902015,4278255615,4286578688,4278222848,4278190208,4286611456,4286578816,4278222976,4290822336,4286611584,4288256511,4288230246,4294967244,4291624959,4284874854,4294934656,4278216396,4291611903,4278190208,4294902015,4294967040,4278255615,4286578816,4286578688,4278222976,4278190335,4278242559,4291624959,4291624908,4294967193,4288269567,4294941132,4291598847,4294954137,4281558783,4281584844,4288269312,4294953984,4294940928,4294927872,4284901017,4288059030,4278203238,4281571686,4278203136,4281545472,4288230144,4288230246,4281545625,4281545523,4278190080],Mt=c,f.ColorHelper=Mt,Ct=/&#(\d+);/g,St=/&#x([0-9A-F]+);/gi,Tt=/&amp;/g,At=/&gt;/g,It=/&lt;/g,xt=/&quot;/g,Nt=/&apos;/g,k.Vf=function(t){for(var n,e,n="";0<t;t=parseInt((t-1)/26+"",10))n=String.fromCharCode(65+(e=(t-1)%26))+n;return n},k.gt=function(t,n,e,i){var r;return 3===t&&(r=C.getType(n),t=!e||"@"!==e&&"@"!==e.formatCached?r===$?1:r===lt||r===tt||r===p&&k.Yf(n)?2:0:0,i)&&0!==i&&(0<i?t=0:i<0&&(t=2),-90===i?t=0:90===i&&(t=2)),t},k.Yf=function(t){return k.Zf.test(t)},k.j=function(t){var n,n,n=C.getType(t);return t=t===I||t===m?"":n===$?t.toString().toUpperCase():n===tt?(n=0===t.getHours()&&0===t.getMinutes()&&0===t.getSeconds()&&0===t.getMilliseconds(),h.Common.ct.Pe(t,n?"M/d/yyyy":"M/d/yyyy h:mm:ss")):t.richText?k.wt(t):t.toString()},k.Wf=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,u=C(t),s=n,c=e,f="background-position",l="background-size",h="auto",d="0%",v="50%",m="100%";switch(o){case 0:a?u.css(f,a.position).css(l,a.size):u.css(f,d+S+d).css(l,m+S+m);break;case 1:p=g=v,u.css(f,(g=s<i?d:v)+S+(p=c<r?d:v)).css(l,h+S+h);break;case 2:y=s,(w=b=0)<(M=c)&&0<r&&i/r<s/c?b=b+s/2-(y=i/r*c)/2:0<s&&0<i&&r/i<c/s&&(w=w+c/2-(M=r/i*s)/2),u.css(f,b+ct+S+w+ct).css(l,y+ct+S+M+ct);break;case 3:u.css(f,d+S+d).css(l,h+S+h)}},k.device=function(){var t,n,e,i,r,o,t=navigator.userAgent,n=t.match(/iPad/i);if(n)(e=n[0])&&(i="ipad"===e.toLowerCase());else if((n=t.match(/Macintosh/i))&&(e=n[0]))try{document.createEvent("TouchEvent"),i="macintosh"===e.toLowerCase()}catch(t){}return{ipad:i,iphone:r=(n=t.match(/iPhone/i))&&(e=n[0])?"iphone"===e.toLowerCase():r,android:o=(n=t.match(/android/i))&&(e=n[0])?"android"===e.toLowerCase():o}},k.Qf=function(){var t=navigator.platform;return t&&-1<t.indexOf("Mac")},k.Kf=function(t){var t,t;return t!==m&&t!==I&&(t=t.toString(),t=Y.Jf(t),!ut(Number(""===t.trim()?NaN:t))||/^[1-9]\d{0,2}(?:(,\d{3})*|\d*)(?:\.\d*)?$/.test(t))},k.Xf=function(t,n,e,i,r){var o,a,u,u,s,t,o,a,o=I,a=!1;if(t&&((u=t.formatter)?(r?o=r:k.St(u)||(o=u,a=!0),typeof o===p&&d&&(o=new d(o))):o=t._autoFormatter),o&&!o.isAuto){u=I;try{if(u=o.parse(n),typeof(u=a&&u instanceof Date&&(s=(new d).getPreferredDisplayFormatter(n,r))?s.parse(n):u)==lt)return u}catch(t){}return u===m||u===I?n:u}if(e){if(t=void 0,t={},o=void 0,a=I,d)try{a=(new d).getPreferredDisplayFormatter(n,t)}catch(t){}return typeof(o=t.value)==lt?n=o:k.Kf(n)&&(o=t.value=n),i&&(i.value=a),o!==m&&o!==I?o:n}return n},k.gi=function(t){for(var n,e,t,i,n=v.body,e=t;e&&e.parentElement&&e.parentElement!==n;)e=e.parentElement;return t=1e3,e&&e.parentElement===n&&(i=ot(C(e).css("z-index")),ut(i)||(t+=i)),t},k.ri=function(t){var n,e,i,r,o,a,u,s,c,f,l,h,d,v,d;if(!t)return[];if(n=t.indexOf("("),e=t.lastIndexOf(")"),!(i=t.substring(n+1,e)))return[];for(r=[],a="",s=u=o=0;s<i.length;)u=i.indexOf("rgb",o),-1===(s=i.indexOf("rgb",o+1))&&(s=i.length),a=i.substring(u,s),r.push(a),o=s;for(c=[],f=0,l=r.length;f<l;f++)d=(h=r[f]).indexOf(")"),v=h.substring(0,d+1),d=at(h.substring(d+1,h.length)),ut(d)&&(f===l-1?d=100:f<=1&&(d=0)),!v&&0===f||c.push({color:v,point:d/=100});return c},k.qf=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,d,m,g,g,g,p,p,b,w,y,M,C,w,S,o=n.Dn,a=0,u=[e],s=n.zoom();for(i===T.AutoFitType.cellWithHeader&&(e===T.SheetArea.viewport?u.push(1):e===T.SheetArea.rowHeader&&u.push(0)),c=0;c<u.length;c++)for(f=0,l=u[c],h=r||n.getRowCount(l);0<=f&&f<h;)(d=n.Ut.findSpan(f,t,l))&&(d.col<t||1<d.colCount||d.row<f)?f=d.row+d.rowCount:(d=0,(m=(v=n.getActualStyle(f,t,l)).cellType||n.$f(l))&&(g=v.font||o.Nn(),v.font=o._n(g),(g=!(!(g=n.rowFilter&&n.rowFilter())||!g.rn(f,t,l)))||3!==l||(p=n.tables?n.tables.find(f,t):I)&&p.showHeader()&&p.headerIndex()===f&&p.rowFilter()&&p.filterButtonVisible(t-p.range().col)&&(g=!0),p=v.formatter||v._autoFormatter,b={sheet:n,row:f,col:t,sheetArea:l,quotePrefix:v.quotePrefix},w={},y=n.getValue(f,t,l,T.ValueType.richText),M=n.t0(f,t,e),C="",C=y&&y.richText?n.getText(f,t,l):A(M)?m.format(y,p,w,b):M,d=m.Ln(y,C,v,s,b),g)&&(w=N(s,1),d+=S=ot((n.defaults.rowHeight*w).toString(),10)),a<d&&(a=d),l===T.SheetArea.viewport?f=k.n0(f,t,n,l):f++);return 0===a?a=n.defaults.colWidth:a+=x(3),x(a)},k.n0=function(t,n,e,i){for(var r,o,a,u,s,r=-1,o=e.getRowCount(i),a=t+1;a<o;a++){if(u=e.getText(a,n,i)){r=a;break}if((s=e.getActualStyle(a,n,i))&&(s.cellType||s.cellButtons&&0<s.cellButtons.length||H.W.Jue(s))){r=a;break}}return r},k.e0=function(t,n,e,i){var r,o,a,u,s,c,f,l,h,d,v,v,m,m,s,g,p,b,r=n.Dn,o=0,a=[e],u=n.zoom();for(1===i&&(3===e?a.push(2):1===e&&a.push(0)),f=!1,l=c=0;l<a.length;l++)for(h=0,d=n.getColumnCount(e=a[l]);0<=h&&h<d;)(v=n.Ut.findSpan(t,h,e))&&(v.row<t||1<v.rowCount||v.col<h)?h=v.col+v.colCount:(0<n.getColumnWidth(h,e)&&(m=(v=n.getActualStyle(t,h,e)).font||r.Nn(),v.font=r._n(m),m=0,(s=n.getCellType(t,h,e))&&(g=n.getText(t,h,e),p=n.getValue(t,h,e,1),m=s.Fn(p,g,v,u,b={sheet:n,row:t,col:h,sheetArea:e})),2===(s=n.Lt(h))?c=c+m+x(3):(c&&(m+=c,c=0),1===s&&(f=!0)),o<(m=c?c:m))&&(o=m),3===e?h=k.i0(t,h,n,e):h++);return 0===(o=f&&o<60?60:o)?o=n.defaults.rowHeight:o+=x(3),x(o)},k.i0=function(t,n,e,i){for(var r,o,a,u,s,r=-1,o=e.getColumnCount(i),a=n+1;a<o;a++){if(u=e.getText(t,a,i)){r=a;break}if((s=e.getActualStyle(t,a,i))&&s.cellType){r=a;break}}return r},k.Eve=function(t){var n,e,i,r;if(t instanceof Date)return t;if("string"!=typeof t)return"number"==typeof t&&!isNaN(t)&&(n=h.Common.ct.Y0(t))||I;if(!(n=h.Common.ct.yU(t)))if(isNaN(t)){if(h.Common.ct.u6t(t))return I;if(n=new Date(t),isNaN(n.valueOf()))return I;try{if(e=/^[-+=\s]*(\d+)\W+(\d+)\W+(\d+)$/,i=J.s6t(J.cJ(t.replace(/[ \n]/g,"")," ")," "),(r=e.exec(i))&&4===r.length&&(-1===r.indexOf(n.getFullYear().toString())||-1===r.indexOf(n.getMonth().toString())||-1===r.indexOf(n.getDate().toString())))return I}catch(t){return I}}else if(!(n=h.Common.ct.Y0(parseFloat(t))))return I;return n},k.mi=function(t,n,e,i,r){var o,a,i,t,r,u,s,c,f,l;if(e&&(o=i.row,a=i.col,i=i.sheetArea,t=t.formatter||t._autoFormatter,r=r||{},d)&&n!==I&&n!==m)if(u=void 0,t&&t.isAuto)u=typeof n==lt,s=k.Kf(n),!u&&s&&(n=Y.Jf(n)),n=t.getPreferredEditingFormatter?t.getPreferredEditingFormatter(n).format(n):n;else if(t=typeof t!==p||k.St(t)?t:new d(t))try{n instanceof Date?((c=U&&U.Convert.r0(n))&&(n=c),f=h.Common.CultureManager.Fe().DateTimeFormat,l=h.Common.ct.o0(n),t=!W.a0(t.formatString(),["d","y"])&&0<=l&&l<1?new d(f.longTimePattern):0===n.getHours()&&0===n.getMinutes()&&0===n.getSeconds()&&0===n.getMilliseconds()?new d(f.shortDatePattern):new d(f.shortDatePattern+S+f.longTimePattern),e.u0=!0,n=t.format(n),r.formatter=t):typeof n==lt&&(n=t.getPreferredEditingFormatter?t.getPreferredEditingFormatter(n).format(n):Y.Ge(n.toString()))}catch(t){n=e.getText(o,a,i)}else n=0===n?"0":e.getText(o,a,i);return n=n!==I&&n!==m?k.j(n):n},k.s0=function(t,n,e,i){var e,i,r,o,a,u;if(e&&(e=i||{},d)&&n!==I&&n!==m)if(i=void 0,t&&t.isAuto)i=typeof n==lt,r=k.Kf(n),!i&&r&&(n=Y.Jf(n)),n=t.getPreferredEditingFormatter?t.getPreferredEditingFormatter(n).format(n):n;else if(t)try{n instanceof Date?(typeof t!==p||k.St(t)||(t=new d(t)),(o=U&&U.Convert.r0(n))&&(n=o),a=h.Common.CultureManager.Fe().DateTimeFormat,u=h.Common.ct.o0(n),n=(t=!W.a0(t.formatString(),["d","y"])&&0<=u&&u<1?new d(a.longTimePattern):0===n.getHours()&&0===n.getMinutes()&&0===n.getSeconds()&&0===n.getMilliseconds()?new d(a.shortDatePattern):new d(a.shortDatePattern+S+a.longTimePattern)).format(n),e.formatter=t):typeof n==lt&&(n=Y.Ge(n.toString()))}catch(t){}return n=n!==I&&n!==m?k.j(n):n},k.c0=function(t,n,e,i){return!A(t)&&"string"==typeof t&&!!(n||-1===f.FormulaPrefix.indexOf(t)&&0<t.length&&-1!==f.FormulaPrefix.indexOf(t[0])&&e&&!i)},k.f0=function(t,n,e){var i,r,r,i="";if(t)if((r=t.getFormulaInformation(n,e,3))&&r.hasFormula){if(i="="+r.formulaWithCulture,r.isDynamicArray)return""}else{if(r=t.getValue(n,e),A(r))return r;i=k.s0(t.getFormatter(n,e)||t.l0(n,e,"_autoFormatter"),r,t)||""}return i},k.h0=function(t,n){var e,n,i,r,e=t,n=h.Common.CultureManager.Fe(n).NumberFormat,i;return!!(n&&n.percentSymbol&&t)&&"object"!=typeof(e="object"==typeof t&&t.formatCached?t.formatCached:e)&&"string"==typeof e&&0<(r=Y.v0(e)).d0},k.m0=function(t){var n,e,t,n=k.Tt.msie||k.Tt.edge,e=n&&l.MSPointerEvent&&1<(navigator.msMaxTouchPoints||0);return t?e:(t=n&&l.PointerEvent&&1<(navigator.maxTouchPoints||0),e||t)},k.wt=function(t){return t&&t.richText&&0<t.richText.length?(t=t.text?t:k.g0(t)).text:t},k.g0=function(t){var n,e,i;if(t&&(n=t.richText)&&0<n.length){for(e=[],i=0;i<n.length;i++)e.push(n[i].text||"");t.text=e.join("")}return t},k.St=function(t){return"string"==typeof t&&("="===t.charAt(0)||0<=t.indexOf("{{")&&0<=t.indexOf("}}"))},k.p0=function(t,n,o,a){var u,s,t,u=t,s=n,t=function(t,n){var e,i,r,e=this;return e.hasOwnProperty("_ps")||(e._ps={}),i=e._ps,0===arguments.length?i[u]!==m?i[u]:s:(!1!==n&&a&&!a.call(e,t)||(r=i[u]!==m?i[u]:s)!==t&&(i[u]=t,!1!==n)&&o&&o.call(e,t,r),e)};return t.isDefault=function(t){return t===s},t},k.b0=function(t,n){var e={_ps:{}};return h.Common.lt.y0(t,function(t){on(e,t,n)}),e},k.w0=function(t,n,e,i,r,o,a){for(var u,s,c,f,u=N(n,e),s=g(n,e),c=0,f=u;f<s&&(c+=i?o?t.getRowHeight(f,3):t.Gt(f,3,a):o?t.getColumnWidth(f,3):t.nn(f,3,a),!(r&&r<c));f++);return c},k.M0=function(t,n,e,i,r){for(var o,a,u,s,c,o=N(n,e),a=g(n,e),u=0,s=o;s<a&&(i?(c=t.C0(s),t.getViewportTopRow(c)<=s&&t.getViewportBottomRow(c)>=s&&(u+=t.Gt(s,3))):(c=t.S0(s),t.getViewportLeftColumn(c)<=s&&t.getViewportRightColumn(c)>=s&&(u+=t.nn(s,3))),!(r&&r<u));s++);return u},k.T0=function(t,n){var e,i,t,n,e=0,i=0;return t!==n&&(t=C(t).offset(),n=C(n).offset(),e=t.left-n.left,i=t.top-n.top),{A0:i,I0:e}},k.x0=function(t,n,e,i){var r,o,a,u,s,r=i||{};if(!t||"string"!=typeof t)return r.message=X().Exp_SheetNameInvalid,!1;for(a=0;a<t.length;a++)if("*"===(o=t.charAt(a))||":"===o||"["===o||"]"===o||"?"===o||"\\"===o||"/"===o)return r.message=X().Exp_SheetNameInvalid,!1;if("'"===t.charAt(0)||"'"===t.charAt(t.length-1))return r.message=X().Exp_SheetNameInvalid,!1;if(n)for(u=n.length,a=0;a<u;a++)if(e!==(s=n[a])&&t.toUpperCase()===s.name().toUpperCase())return r.message=X().Exp_SheetNameConflict,!1;return!0},k.yi=function(t,n,e){var i,r,o;if(!t)return t;for(i=0,r=t.length,o=[];i<r;)t[i]===n?o[i]=e:o[i]=t[i],i++;return o.join("")},k.N0=function(){var t,n,e,i,t=k;return t.k0||(i="-10000px",(e=(n=en("span")).style).visibility="hidden",e.top=i,e.left=i,e.position="absolute",n.setAttribute("gcUIElement","gcStringWidthSpan"),v.body.insertBefore(n,I),t.k0=n),t.k0},k.vt=function(t,n,e){var i,r,o,o,i,i=k,r=i.D0;if(!n)if(r){if(o=(r=e?r.CJKFontCache:r)[t])return o}else r=i.D0={CJKFontCache:{}},e&&(r=r.CJKFontCache);return(o=i.N0()).style.font=k.yt(t),k.Tt&&k.Tt.safari&&(o.style.lineHeight="normal"),o.innerHTML=e?String.fromCharCode(20013):"H",i=(i=o.offsetHeight)||gn(t,o.innerHTML),n||(r[t]=i),i},k._0=function(t){var n,e,i,n,n=k,e=n.E0;if(e){if(e[t])return e[t]}else e=n.E0={};return(n=n.N0()).style.font=t,n.innerHTML="H",(i={}).fontFamily=n.style.fontFamily,i.fontSize=n.style.fontSize,i.fontStyle=n.style.fontStyle,i.fontWeight=n.style.fontWeight,e[t]=i},k.bi=function(t,n){var e,i,e=k.N0();return e.style.font=k.yt(n),k.Tt&&k.Tt.safari&&(e.style.lineHeight="normal"),e.innerHTML=J.j0(t||"H"),i=(i=e.offsetHeight)||gn(n,e.innerHTML)},k.O0=function(t){var n,e,n,n=k;return 0<=t.indexOf(f.FallbackFontFamily)?t:(t=t.replace("("+String.fromCharCode(27491)+String.fromCharCode(25991)+")","").replace("(Body)","").replace("("+String.fromCharCode(26631)+String.fromCharCode(39064)+")",""),(n=(e=n.N0()).style).font=t,n.fontFamily=[].concat(n.fontFamily.split(","),f.FallbackFontFamily.split(",")).join(","),n.font)},k.yt=function(t){var n,e,i,n=k;return t&&n.R0?(i=(e=(e=n.B0)||(n.B0={}))[t])||(e[t]=n.O0(t)):t},k.bt=function(t,n){n&&(n=k.yt(n),t.font!==n)&&(t.font=n)},k.Mt=function(t,n,e){return!n||A(e)?0:(k.bt(t,n),t.measureText(e).width)},k.L0=function(){var t,n,t=k,n=t.k0;n&&(C(n).remove(),t.k0=m),t.D0=m,t.E0=m,k.F0&&(k.F0=m),t.B0=m},k.oi=function(t){var n,t,n=k.F0;return n=n||(k.F0=en("div")),t=t.innerHTML,n.innerHTML=t,n.innerText},k.P0=function(t){return t&&/^[A-Za-z_\\\u0080-\uFFFF][A-Za-z0-9_\.\\\?\u0080-\uFFFF]*$/.test(t)&&!(-1!==["C","c","R","r"].indexOf(t)||/^[A-Za-z]{1,3}(\$)?\d+$/.test(t)||/^[Rr]\d*[Cc]\d*$/.test(t)||255<=t.length)},k.G0=function(t){t&&(t.U0(!0),t.initExpression(),t.H0())},k.z0=function(t){var n,e,i,r,o,n=0,e=0,i=t.length;for(0<i&&(n=t[0].row,e=t[0].col),r=1;r<i;r++)n>(o=t[r]).row&&(n=o.row),e>o.col&&(e=o.col);return{r:n=n<0?0:n,c:e=e<0?0:e}},k.V0=function(t){var n,n,n=typeof t===p&&"/"===t.charAt(0)?(n=void 0,mt.test(t)?(n=t.match(mt),h.Common.ct.Y0(at(n[1]))):vt.test(t)?(n=t.match(vt),new Date(at(n[1]))):t):t;return n},k.Z0=function(t){var t,t=!A(t)&&h.Common.ct.W0(t)?h.Common.ct.Q0(t):t;return t},k.K0=function(t,n){for(var e,i,r,o,e=t.getImageData(n.x,n.y,n.width,n.height),i=e.data,r=0;r<i.length-4;r+=4)o=it((30*i[r]+59*i[r+1]+11*i[r+2]+50)/100),i[r]=o,i[r+1]=o,i[r+2]=o;t.putImageData(e,n.x,n.y)},k.J0=function(t,n,e){t.rowCount>n&&(t.rowCount=n),t.colCount>e&&(t.colCount=e)},k.X0=function(t,n,e,i){for(var r=e;r<e+i;r++)if(!A(t.getValue(n,r)))return!0;return!1},k.q0=function(t,n,e,i){for(var r=n;r<n+i;r++)if(!A(t.getValue(r,e)))return!0},k.$0=function(t){return!t||""===t},k.qi=function(t){if(k.$0(t))return 0;for(var n=0,e=0;e<t.length&&isNaN(parseInt(t[e],10));)e++;return(n=e<t.length?parseInt(t.substring(e),10):n)-1},k.$i=function(t){for(var n,e,i,r,o,n=0,e=t.length,i=0;i<e&&!(25<(o=(r=t[i].charCodeAt())-97))&&!((o=o<0?r-65:o)<0);i++)n=26*n+o+1;return--n},k.t1=function(t){var t=""+t;return"="===t.charAt(0)?t.substr(1):t},k.getFormulaString=function(t){return"string"==typeof t?(t="="===t[0]?t.substr(1):t,q(t)):t},k.vo=function(t,n){return!A(t)&&(n=n||/(&)|(<)|(>)|(")|(')/g).test(t)?typeof t===p?t.replace(n,function(t){switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&apos;"}}):""+t:t},k.Nfe=function(t,n){return(n=void 0!==n&&n)?t&&t.replace(/\%/g,"%25").replace(/\ /g,"%20").replace(/\#/g,"%23").replace(/\[/g,"%5b").replace(/\]/g,"%5d").replace(/\^/g,"%5e").replace(/\`/g,"%60").replace(/\{/g,"%7b").replace(/\}/g,"%7d").replace(/\&/g,"&amp;").replace(/\"/g,"&quot;"):t&&t.replace(/\&/g,"&amp;").replace(/\"/g,"&quot;").replace(/\>/g,"&gt;").replace(/\</g,"&lt;")},k.kfe=function(t,n){return(n=void 0!==n&&n)?t&&t.replace(/&amp;/g,"&").replace(/&quot;/g,'"').replace(/%20/g," ").replace(/%23/g,"#").replace(/%5[bB]/g,"[").replace(/%5[cC]/g,"\\").replace(/%5[dD]/g,"]").replace(/%5[eE]/g,"^").replace(/%60/g,"`").replace(/%7[bB]/g,"{").replace(/%7[dD]/g,"}").replace(/%25/g,"%"):t&&t.replace(/&amp;/g,"&").replace(/&quot;/g,'"').replace(/&gt;/g,">").replace(/&lt;/g,"<")},k.n1=function(t){var n,e;return A(t)?t:!(n=typeof t===p)||-1===t.indexOf("&")?""+t:(e=/(&amp;)|(&gt;)|(&lt;)|(&quot;)|(&apos;)/g,(t=-1!==t.indexOf("&#")?t.replace(Ct,fn(10)).replace(St,fn(16)):t).replace(e,function(t){switch(t){case"&amp;":return"&";case"&gt;":return">";case"&lt;":return"<";case"&quot;":return'"';case"&apos;":return"'"}}))},k.e1=function(t,n,e){var i,r;if(t&&typeof t===p)for(i=0;i<e.length;i++)if((r=e[i])!==n&&(-1<t.indexOf(r+"!")||-1<t.indexOf("'"+r+"'!")))return!0;return!1},k.i1=function(t){var n,e,n;return"string"==typeof t&&(n=t.indexOf("/OADate(")+1,e=t.indexOf(")"),0!==n)&&n<e&&(n=parseFloat(t.substring(n+7,e)),isNaN(n)||(t=""+n)),t},k.r1=function(t){var n,e,i;if(!t)return null;if(n=-1!==(n=t).indexOf(e=",")?n.split(",")[0]:n){for(i=n.length-1;0<=i&&"/"!==n[i];)i--;'"'===(n=(n=0<=i?n.substring(i):n)&&"/#"===n.substring(0,2)?n.substring(2):n)[0]&&'"'===n[n.length-1]&&(n=n.substring(1,n.length-1))}return n},k.o1=function(t,n){for(var e,i,r,o,a,o,e=n.split("&"),i=0,r=e.length;i<r;i++){if(a=(o=e[i].split("."))[0],o=o[1],!t)return;t=k.xr(t,a,o)}return t},k.Hue=function(t,n){var e,i,r;if(t&&t.c_){for(i=t.c_,r=0;r<i.length&&!(e=k.xr(i[r],n));r++);return e}},k.xr=function(t,n,e){var i,r,o,a;if(!t||!t.c_)return m;for(e=e?+e:0,r=0,o=(i=t.c_).length;r<o;r++)if((a=i[r])&&a.n_===n){if(0===e)return a;e--}},k.u1=function(t,n){var e,i;if(t)for(e=t.c_||[],i=0;i<e.length;i++)if(e[i][n])return e[i][n]},k.s1=function(t,n){var e,i,r,o,o;if(!t||!t.c_)return m;for(i=0,r=(e=t.c_).length;i<r;i++){if((o=e[i])&&o.n_===n)return o;if(o=k.s1(o,n),!A(o))return o}},k.c1=function(t){return t&&t.c_?t.c_[0]:m},k.go=function(t,n){var e,i,r,o,a;if(!t||!t.c_)return m;for(i=[],r=0,o=(e=t.c_).length;r<o;r++)(a=e[r])&&a.n_===n&&i.push(a);return i},k.Pr=function(t,n){var e,i,r,o,o;if(t&&t.c_){for(e=[],i=0,r=n.length;i<r;i++)o=n[i],(o=k.go(t,o))&&0<o.length&&(e=e.concat(o));t.c_=e}},k.f1=function(t,n,e){var i,r,o;if(t&&n)for(e=e||n.name,i=0,r=t.length;i<r;i++)(o=t[i])&&o.n_===e&&(t[i]=n)},k.l1=function(){var t;return("{"+cn(8)+"-"+cn(4)+"-"+cn(4)+"-"+cn(4)+"-"+cn(12)+"}").toUpperCase()},k.h1=function(t,n,e){if(t)return ln(t)?hn(t,n,e):mn(t,e)},k.d1=function(t,n){var n;if(t)return"1"===t.auto?"#000000":t.theme!==m?dn(t,n):t.rgb?"#"+(n="number"==typeof(n=t.rgb)?n.toString(16):n).substring(2,n.length):t.indexed!==m?vn(t):void 0},k.hueToRGB=function(t,n,e){return e<0&&(e+=255),255<e&&(e-=255),e<42?t+((n-t)*e+21)/42:e<127?n:e<170?t+((n-t)*(170-e)+21)/42:t},k.v1=function(t,n,e){var i,r,o,a,n,i=0,r=0,o=0;return o=0===e?r=i=255*n/255|0:(a=void 0,n=2*n-(a=n<=127?(n*(255+e)+127)/255:n+e-(n*e+127)/255),i=parseInt(((255*k.hueToRGB(n,a,t+85)+127)/255).toString(),10),r=parseInt(((255*k.hueToRGB(n,a,t)+127)/255).toString(),10),parseInt(((255*k.hueToRGB(n,a,t-85)+127)/255).toString(),10)),{r:i=(i=0<i?i:0)<255?i:255,g:r=(r=0<r?r:0)<255?r:255,b:o=255<(o=0<o?o:0)?o:255,a:0}},k.m1=function(t){var t=yt[t];if(t!==m)return Mt.hexToARGB(t)},k.g1=function(t){if(!Q(t))return"="===t[0]?t:"="+t},k.p1=function(t){return Q(t)||t.length<=2?t:t.substr(1,t.length-2)},k.b1=function(t){if(!A(t))return"="===t[0]?t.substring(1,t.length):t},k.w1=function(t,n){if(t&&n)for(var e in n)n.hasOwnProperty(e)&&(t[e]=n[e]);return t},k.C1=function(t){var n,e,i,r;if("string"==typeof t){if(n=/\[[^\]]+\]|@/,(e=t.split(/\'|\"/g))&&0<e.length)for(i=0;i<e.length;i++)if(r=e[i],i%2==0&&r.match(n))return!0;return!1}},k.S1=function(t,n){var e,i,r,n,o,t,e=n.row,i=n.col,r=n.rowCount,n=n.colCount,o=t.getRowCount(),t=t.getColumnCount();return-1===e&&(e=0,r=o),-1===i&&(i=0,n=t),kn(e,i,r=o<e+r?o-e:r,n=t<i+n?t-i:n)},k.isInfinityNumberString=function(t){return"string"==typeof t&&(parseFloat(t)===Number.POSITIVE_INFINITY||parseFloat(t)===Number.NEGATIVE_INFINITY)},k.repeatString=function(t,n){var e="";if(!(!t||n<1||n>Number.POSITIVE_INFINITY))for(;n%2&&(e+=t),(n=Math.floor(n/2))&&(t+=t),n;);return e},k.toPlainString=function(t){var n,e;return(""+t).replace(/(-?)(\d*)\.?(\d*)e([+-]\d+)/,function(t,n,e,i,r){return+r<0?n+"0."+k.repeatString("0",1-+r-e.length-1)+e+i:n+e+i+k.repeatString("0",+r-i.length)})},k.jse=function(t){var n=document.createElement("div");return n.innerHTML=t.trim(),n.firstChild},k.rfe=function(t,n){var e,i,r,o;if(t===I||n===I||"object"!=typeof t||"object"!=typeof n)return t===n;if(e=Object.keys(t),i=Object.keys(n),e.length!==i.length)return!1;for(r=0;r<e.length;r++)if(o=e[r],!k.rfe(t[o],n[o]))return!1;return!0},k.bme=function(t,n){for(var e,i,r,o,a,u,e=n.row,i=n.col,r=n.rowCount,o=n.colCount,a=e;a<e+r;a++)for(u=i;u<i+o;u++)if(t.getCell(a,u).locked())return!0;return!1},k.wme=function(t){for(var n,e,i,r,o,a,i,u,n=t.getSelections(),e=0;e<n.length;e++)if(r=-1===(i=n[e]).col?0:i.col,o=-1===i.row?0:i.row,a=-1===i.col?t.getColumnCount():i.colCount,i=-1===i.row?t.getRowCount():i.rowCount,u=k.bme(t,{col:r,row:o,colCount:a,rowCount:i}))return!0;return!1},k.ige=function(t){return 4<t?t=4:t<.25&&(t=.25),this.mge(t)},k.mge=function(t,n){return void 0===n&&(n=12),+parseFloat(t.toPrecision(n))},k.Zf=/[\u0600-\u06FF\u0750-\u077F]/,k.vi=un,k.pi=k.device,k.Tt=(t=pn(P=navigator.userAgent),n={version:m,chrome:m,webkit:m,safari:m,mozilla:m,msie:m,metroMode:m,edge:m},t.browser&&(n[t.browser]=!0,n.version=t.version),n.chrome?n.webkit=!0:n.webkit&&(n.safari=!0),($t=0<=P.indexOf("PhantomJS"))&&(n.safari=!1,n.chrome=!0),(tn=(t=P.toLowerCase()).indexOf("compatible")<0&&/(trident)(?:.*? rv ([\w.]+)|)/.exec(t)!==I)&&(n.mozilla=m,n.msie=!0),(t=/Edge\/\d+/.exec(P))!==I&&0<t.length&&(n.webkit=m,n.chrome=m,n.msie=!0,n.edge=!0,n.version=t[0].substr(t[0].indexOf("/")+1)),n.msie&&bn()&&(n.metroMode=!0),n),k.browser=k.Tt,k.En=en,k.T1=nn,k.pt=sn,k.R0=k.Qf(),k.Ct=function(t){return!A(t)&&(typeof t==lt||typeof t==$||t instanceof Date||U&&t instanceof U.CalcError)},b=k,f.util=b,f.mt=b,w=b.Mt,wn.A1=function(t){return!(wn.ai()!==t||!t.rt||!t.rt.I1)},wn.ai=function(){return l&&l.Vc&&l.Vc.activeElement},wn.N1=function(i){var r,o,a,t,n,t,e,u,s,c,f;function l(t){for(var n,e,n=0;n<=2;n++)(e=t.call(r,n))&&0!==e.width&&0!==e.height&&(i.k1=!0,o.D1(a,e))}if(i&&!wn.A1(i)&&i.parent&&i.parent.options.hideSelection)if(r=i.Fi(),o=i.Dn,a=o.J(),n=(t=i._1)&&t.isEnable(T.RowColumnStates.selected,!0),t=t&&t.isEnable(T.RowColumnStates.selected,!1),e=i.getSelections(),s=u=void 0,n||t){for(c=void 0,u=0;u<e.length;u++)f=e[u],c=c?c.union(f):f;c&&o.E1(c)}else{for(u=0;u<e.length;u++)f=e[u],0<=(s=i.j1(f)).width&&0<=s.height&&(s.x-=9,s.y-=9,s.width+=18,s.height+=30,o.O1(s));s=r.R1(),i.k1=!0,o.D1(a,s),l(r.B1),l(r.L1)}},wn.F1=function(t,n){var e=wn.ai();(l.Vc.activeElement=t)===e||n||(e&&(e.endEdit(),wn.N1(e),e.G1)&&e.G1(),t&&t.Dn.E1())},kt=wn,f.hi=kt,e.prototype.U1=function(){var t="gc-theme-version ui-widget-header ui-state-default wijmoThemeHelper btn-default",n="span."+t.split(S).join(ft);return u.H1?C(v).find(n).length<=0&&rn(u.H1):u.H1=yn(t),u.H1},e.prototype.z1=function(){var t="gc-theme-version ui-widget-content wijmoThemeHelper btn-default",n="span."+t.split(S).join(ft);return u.V1?C(v).find(n).length<=0&&rn(u.V1):u.V1=yn(t),u.V1},e.prototype.Y1=function(){var t="gc-theme-version ui-state-hover wijmoThemeHelper btn-primary",n="span."+t.split(S).join(ft);return u.Z1?C(v).find(n).length<=0&&rn(u.Z1):u.Z1=yn(t),u.Z1},e.prototype.W1=function(){var t="gc-theme-version ui-state-highlight wijmoThemeHelper btn-warning",n="span."+t.split(S).join(ft);return u.K1?C(v).find(n).length<=0&&rn(u.K1):u.K1=yn(t),u.K1},e.prototype.J1=function(){var t="gc-theme-version",n="gcDummyElement";return u.X1?C(v).find("#"+n).length<=0&&rn(u.X1):u.X1=yn(t,n),u.X1},e.prototype.nl=function(){u.U1(),u.z1(),u.Y1(),u.W1()},e.prototype.Hc=function(){var r,t,o;function a(t,n){for(var e,i,e=!1,i=t;i;){if("gcSpread"===C(i).attr("gcUIElement")){e=n.qc()!==i;break}i=i.parentElement}return e}function e(t){var n,e,i,i,n=kt.ai();if(n&&(e=u.el(t.target),i=n.il&&n.il.rl,r.wf.forEach(function(t){t&&t(n,e)}),!e||a(e,n)))if(n.ol(m,m,i))o&&(i=n.rt)&&i.al&&i.al(),kt.F1(I);else if(t.cancelable)return!1}function n(t){var n=t.pointerType;n!==t[dt]&&n!==ht||e(t)}(r=this).vf=0,Mn(l,"keydown",Sn,!0),Mn(l,"keyup",Tn,!0),Mn(l,"compositionstart",An,!0),Mn(l,"selectstart",xn,!0),t=b.pi(),o=t.ipad||t.iphone,b.browser.safari&&!o&&Mn(l,"textInput",In,!0),b.m0()?(C(v).bind("MSPointerDown",n),C(v).bind("pointerdown",n)):C(v).bind("touchstart",e),Mn(v,"mousedown",function(t){var n;!1===e(t)&&un(t)},!0),C(v).bind("DOMContentLoaded",function(){u.nl()})},e.prototype.el=function(t){for(var n,e,n=t;n&&"BODY"!==n.tagName&&typeof n.getAttribute==et;){if(e=(e=n.getAttribute("gcUIElement"))||n.gcUIElement)return n;n=n.parentNode}return I},e.prototype.ul=function(t,n){var e,t,i,r,o,a,t,e=u.U1();return t===T.VisualState.highlight||t===T.VisualState.selected?e=u.W1():t===T.VisualState.hover&&(e=u.Y1()),t=e.className,C(e).removeClass(t).addClass(n),o=(i=Cn(e)).backgroundColor,a=i.backgroundImage,C(e).addClass(t),(t={backgroundColor:(i=Cn(e)).backgroundColor,backgroundImage:i.backgroundImage,color:i.color,zIndex:i.zIndex}).borderLeftColor=i.borderLeftColor,t.borderRightColor=i.borderRightColor,t.borderBottomColor=i.borderBottomColor,t.borderBottomWidth=i.borderBottomWidth,t.borderTopColor=i.borderTopColor,t.borderRightWidth=i.borderRightWidth,t.backgroundImage===a&&t.backgroundColor!==o&&(t.backgroundImage=m),C(e).removeClass(n),t},e.prototype.sl=function(t){var n,t,n=u.J1();return C(n).removeClass(n.className).addClass("gc-theme-version "+t),t=Cn(n),V({},t)},e.prototype.cl=function(t){var n,t,n=u.z1();return C(n).removeClass(n.className).addClass("gc-theme-version ui-widget-content wijmoThemeHelper btn-default "+t),t=Cn(n),V({},t)},e.prototype.ef=function(){var t;l.Vc.vf++},e.prototype.cf=function(){var t=l.Vc;t.vf--,t.vf<0&&(t.vf=0)},u=e.prototype,l.Vc||(l.Vc=new e),r.Ee=function(t){var n;return{0:"normal",1:"highlight",2:"selected",3:"active",4:"hover",5:"activeNotSelected"}[t]||""},r.He=function(t,n){var e=r.Ee(t)+n,i=r.styleCache;return i[e]||(i[e]=u.ul(t,n)),i[e]},r.fl=function(t){var n=t,e=r.styleCache;return e[n]||(e[n]=u.sl(t)),e[n]},r.ll=function(t){var n="content"+t,e=r.styleCache;return e[n]||(e[n]=u.cl(t)),e[n]},r.m=function(t,n){var t=t.hl;return n=t&&t.getColor?t.getColor(n):n},r.dl=function(){r.styleCache={}},r.styleCache={},Dt=r,f.I=Dt,Nn.prototype.clone=function(){return new Nn(this.x,this.y)},f.Point=Nn,y.prototype.intersect=function(t,n,e,i){var r=this;return t<r.x+r.width&&r.x<t+e&&n<r.y+r.height&&r.y<n+i},y.prototype.intersectRect=function(t){return this.intersect(t.x,t.y,t.width,t.height)},y.prototype.contains=function(t,n,e){var i=this;return e?i.x<=t&&t<=i.x+i.width&&i.y<=n&&n<=i.y+i.height:i.x<t&&t<i.x+i.width&&i.y<n&&n<i.y+i.height},y.prototype.containsRect=function(t,n){return this.contains(t.x,t.y,n)&&this.contains(t.x+t.width,t.y+t.height,n)},y.prototype.getIntersectRect=function(t){return this.getIntersect(t.x,t.y,t.width,t.height)},y.prototype.getIntersect=function(t,n,e,i){var r=this,o=r.x,a=r.y,u=r.x+r.width,r=r.y+r.height,s,c=n,e=t+e,n=n+i,i=g(o,t),o=g(a,c),f,l,h,d,t=N(u,e)-i,a=N(r,n)-o;return 0<t&&0<a?new y(i,o,t,a):I},y.prototype.round=function(){var t=this;t.x=it(t.x),t.y=it(t.y),t.width=x(t.width),t.height=x(t.height)},y.prototype.clone=function(){var t=this;return new y(t.x,t.y,t.width,t.height)},f.Rect=y,M.prototype.intersect=function(t,n,e,i){var r=this;return(-1===t||-1===r.row||r.row<t+e&&t<r.row+r.rowCount)&&(-1===n||-1===r.col||r.col<n+i&&n<r.col+r.colCount)},M.prototype.getIntersect=function(t,n,e){var i,r,e,o,n,a,r,e,i,u,s,i=this;return t&&i.intersect(t.row,t.col,t.rowCount,t.colCount)?(r=-1===i.col?e-1:i.col+i.colCount-1,e=-1===t.col?e-1:t.col+t.colCount-1,o=-1===i.row?n-1:i.row+i.rowCount-1,n=-1===t.row?n-1:t.row+t.rowCount-1,a=g(i.col,t.col),r=N(r,e),e=g(i.row,t.row),i=N(o,n),new M(e,a,u=-1===e?-1:i-e+1,s=-1===a?-1:r-a+1)):I},M.prototype.contains=function(t,n,e,i){var r=this,o=arguments.length,a=!1;return 2!==o&&4!==o||(2===o&&(i=e=1),a=(-1===r.row||r.row<=t&&t+e<=r.row+r.rowCount)&&(-1===r.col||r.col<=n&&n+i<=r.col+r.colCount)),a},M.prototype.containsRange=function(t){return this.contains(t.row,t.col,t.rowCount,t.colCount)},M.prototype.offset=function(t,n){var e,i,r,e=this,i=e.col,r=e.row;return-1!==i&&(i+=t),-1!==r&&(r+=n),new M(r,i,e.rowCount,e.colCount)},M.prototype.union=function(t){return _n(this,t)},M.prototype.equals=function(t){var n=this;return t instanceof M&&n.row===t.row&&n.col===t.col&&n.rowCount===t.rowCount&&n.colCount===t.colCount},M.prototype.toJSON=function(){var t=this;return{row:t.row,col:t.col,rowCount:t.rowCount,colCount:t.colCount}},M.prototype.fromJSON=function(t){var n=this;t&&(n.row=t.row,n.col=t.col,n.rowCount=t.rowCount,n.colCount=t.colCount)},Ot=M,f.Range=Ot,f.Ec=kn,f.getUnionRange=_n,Dn.vl=function(t,n){if(t&&n){var t=t.currentTheme();if(t)return t.getColor(n)}return n},Dn.ml=function(t,n){var t;return t&&n?(t=t.currentTheme())?t.getFont(n):n:I},f.Pf=Dn,i.ValidationError="ValidationError",i.CellClick="CellClick",i.CellDoubleClick="CellDoubleClick",i.ColumnChanging="ColumnChanging",i.RowChanging="RowChanging",i.EnterCell="EnterCell",i.LeaveCell="LeaveCell",i.ValueChanged="ValueChanged",i.TopRowChanged="TopRowChanged",i.SheetChanging="SheetChanging",i.SheetChanged="SheetChanged",i.PivotTableChanged="PivotTableChanged",i.LeftColumnChanged="LeftColumnChanged",i.InvalidOperation="InvalidOperation",i.RangeFiltering="RangeFiltering",i.RangeFiltered="RangeFiltered",i.RangeFilterClearing="RangeFilterClearing",i.TableFilterClearing="TableFilterClearing",i.RangeFilterCleared="RangeFilterCleared",i.TableFilterCleared="TableFilterCleared",i.TableFiltering="TableFiltering",i.TableFiltered="TableFiltered",i.RangeSorting="RangeSorting",i.RangeSorted="RangeSorted",i.ClipboardChanging="ClipboardChanging",i.ClipboardChanged="ClipboardChanged",i.ClipboardPasting="ClipboardPasting",i.ClipboardPasted="ClipboardPasted",i.ColumnWidthChanging="ColumnWidthChanging",i.ColumnWidthChanged="ColumnWidthChanged",i.RowHeightChanging="RowHeightChanging",i.RowHeightChanged="RowHeightChanged",i.DragDropBlock="DragDropBlock",i.DragDropBlockCompleted="DragDropBlockCompleted",i.DragFillBlock="DragFillBlock",i.DragFillBlockCompleted="DragFillBlockCompleted",i.EditStarting="EditStarting",i.EditStarted="EditStarted",i.EditChange="EditChange",i.EditEnding="EditEnding",i.EditEnd="EditEnd",i.EditEnded="EditEnded",i.RangeGroupStateChanging="RangeGroupStateChanging",i.RangeGroupStateChanged="RangeGroupStateChanged",i.InternalSelectionChanging="InternalSelectionChanging",i.SelectionChanging="SelectionChanging",i.SelectionChanged="SelectionChanged",i.SheetTabClick="SheetTabClick",i.SheetTabDoubleClick="SheetTabDoubleClick",i.SheetNameChanging="SheetNameChanging",i.SheetNameChanged="SheetNameChanged",i.ViewZooming="ViewZooming",i.ViewZoomed="ViewZoomed",i.UserZooming="UserZooming",i.UserFormulaEntered="UserFormulaEntered",i.CellChanged="CellChanged",i.ColumnChanged="ColumnChanged",i.RowChanged="RowChanged",i.ActiveSheetChanging="ActiveSheetChanging",i.ActiveSheetChanged="ActiveSheetChanged",i.SparklineChanged="SparklineChanged",i.OutlineColumnCheckStatusChanged="OutlineColumnCheckStatusChanged",i.RangeChanged="RangeChanged",i.ButtonClicked="ButtonClicked",i.EditorStatusChanged="EditorStatusChanged",i.FloatingObjectChanged="FloatingObjectChanged",i.DrawingElementZIndexChanged="DrawingElementZIndexChanged",i.ProgressChanged="ProgressChanged",i.FloatingObjectSelectionChanged="FloatingObjectSelectionChanged",i.ShapeChanged="ShapeChanged",i.ShapeSelectionChanged="ShapeSelectionChanged",i.FormControlButtonClicked="FormControlButtonClicked",i.FormControlValueChanged="FormControlValueChanged",i.PictureChanged="PictureChanged",i.FloatingObjectRemoving="FloatingObjectRemoving",i.ShapeRemoving="ShapeRemoving",i.FloatingObjectRemoved="FloatingObjectRemoved",i.ShapeRemoved="ShapeRemoved",i.PictureSelectionChanged="PictureSelectionChanged",i.FloatingObjectLoaded="FloatingObjectLoaded",i.TouchToolStripOpening="TouchToolStripOpening",i.CommentChanged="CommentChanged",i.CommentRemoving="CommentRemoving",i.CommentRemoved="CommentRemoved",i.SlicerChanged="SlicerChanged",i.BeforeDragDrop="BeforeDragDrop",i.ActiveSheetChangingInternal="ActiveSheetChangingInternal",i.ActiveSheetChangedInternal="ActiveSheetChangedInternal",i.EnterCellInternal="EnterCellInternal",i.SheetOptionsChangedInternal="SheetOptionsChangedInternal",i.WorkbookOptionsChangedInternal="WorkbookOptionsChangedInternal",i.RangeChangedInternal="RangeChangedInternal",i.CustomNameChangedInternal="CustomNameChangedInternal",i.FormulaTextboxEditStarted="FormulaTextboxEditStarted",i.FormulaTextboxEditEnded="FormulaTextboxEditEnded",i.SheetMoving="SheetMoving",i.SheetMoved="SheetMoved",i.DragMerging="DragMerging",i.DragMerged="DragMerged",i.ChartClicked="ChartClicked",i.FloatingElementSelected="FloatingElementSelected",i.BeforePrint="BeforePrint",i.TableResizing="TableResizing",i.TableResized="TableResized",i.TableRowsChanged="TableRowsChanged",i.TableColumnsChanged="TableColumnsChanged",i.DropdownSpreadMouseClick="DropdownSpreadMouseClick",i.DropdownSpreadKeyboardEnter="DropdownSpreadKeyboardEnter",i.PasteEnd="PasteEnd",i.WorkbookUndo="WorkbookUndo",i.WorkbookRedo="WorkbookRedo",i.SheetTabAllSheetsListContextMenuOpening="SheetTabAllSheetsListContextMenuOpening",i.SheetTabAllSheetsListContextMenuOpened="SheetTabAllSheetsListContextMenuOpened",i.WorksheetDataChanged="WorksheetDataChanged",f.Events=i,o.prototype.L0=function(){this.Mf=I},o.prototype.gl=function(t,n,e){var i,t,n,i=this.pl,t=t<<4+n;return i?((n=i[t])||(n=e(),i[t]=n),n):e()},o.prototype.yl=function(t,n){var e,e,e=this.wl;return e&&(e=e[t])?e[n]:I},o.prototype.Ml=function(t,n,e,i){var r,o,r=this.wl;r&&(r[t]||(r[t]={}),(o=r[t])[n]={d:e,i:i})},o.prototype.$t=function(t,n,e,i,r){var o,a,u,o=this,a=o.Mf;return e===m&&(e=3),u=a.t0(t,n,e),A(u)?!A(r)&&b.St(r.formatter)?Ft.Cl(a,r,o.Sl(t,n,e,0),{},{row:t,col:n,sheet:a}):o.Sl(t,n,e,i):u},o.prototype.Sl=function(t,n,e,i){var r,o,r,a,r,a,r=this,o=r.Mf,r=r.Tl;return e===m&&(e=3),r?((a=r[e])||(r[e]=a={}),(r=a[t])||(a[t]=r={}),(a=r[n])===m&&(a=o.getValue(t,n,e,i),r[n]=a),a):o.getValue(t,n,e,i)},o.prototype.qt=function(t,n,e){var i,r,i,o,i,o,i=this,r=i.Mf,i=i.Al;return e===m&&(e=3),i?((o=i[e])||(i[e]=o={}),(i=o[t])||(o[t]=i={}),(o=i[n])||(o=r.Il(t,n,e,!1,!0),i[n]=o),o.clone(!0)):r.Il(t,n,e,!1,!1)},o.prototype.Gt=function(t,n){var e,i,e,r,e;return void 0===n&&(n=T.SheetArea.viewport),i=(e=this).Mf,(e=e.xl)?(e=(r=(r=e[n])===m?e[n]={}:r)[t])===m?r[t]=i.Gt(t,n):e:i.Gt(t,n)},o.prototype.Kt=function(t,n){var e,i,e,r,e;return void 0===n&&(n=T.SheetArea.viewport),i=(e=this).Mf,(e=e.Nl)?(e=(r=(r=e[n])===m?e[n]={}:r)[t])===m?r[t]=i.nn(t,n):e:i.nn(t,n)},o.prototype.kl=function(t){var n=this;return n.Tl?(n.Dl||(n.Dl=t()),n.Dl):t()},o.prototype._l=function(t){var n=this;return n.Tl?(n.El||(n.El=t()),n.El):t()},o.prototype.jl=function(){var t=this;t.Ol=!0,t.pl={},t.wl={},t.Tl={},t.Al={},t.xl={},t.Nl={}},o.prototype.Rl=function(){this.Ol=!1},o.prototype.Bl=function(){var t=this;t.Ol=!1,t.pl=I,t.wl=I,t.Tl=I,t.Al=I,t.Nl=I,t.xl=I,t.Dl=I,t.El=I},f.Ff=o,_.Ll=function(t,n,e,i,r){var o,a,u,s;if(_.Fl=!0,(o=t.tables)&&o.Pl(n,e,i-n+1,r-e+1))for(a=-1,u=_.Gl=[],s=0;s<=i;s++)t.getRowVisible(s)?u[s]=++a:u[s]=-1},_.dl=function(){_.Gl=I,_.Fl=!1},_.Ue=function(t){var n=_.Ul;return n[t]||(n[t]=d?new d(t):I),n[t]},_.Re=function(t,n,e){var i,r,i,o,o,a,o,n,i,i=_.Hl,r=t+"_"+typeof t;return d?(i[n]||(i[n]={}),(o=(i=i[n])[r])?(e&&(e.conditionalForeColor=e.value=o.color,e.content=Z(o.content)),o.text):((o=_.Ul)[n]||(o[n]=new d(n)),n=(a=o[n]).format(t,o={}),(i=i[r]={}).text=n,i.color=o.conditionalForeColor,i.content=o.content,e&&(e.conditionalForeColor=e.value=o.conditionalForeColor,e.content=Z(o.content)),n)):t.toString()},_.Cl=function(t,n,e,i,r){var t,n;return e&&"SparklineExValue"===e.typeName?"":(t=n.cellType||t.$f(),n=n.formatter||n._autoFormatter,t.format(e,n,i,r))},_.zl=function(){_.Ul={},_.Hl={}},_.Fl=!1,_.Ul={},_.Hl={},_.Gl=[],Ft=_,f.Be=Ft,En.Vl=function(t,n,e){var i=jn(t);i.scaleX=n,i.scaleY=e,i.translateX=i.orgTranslateX*n,i.translateY=i.orgTranslateY*e,t.setTransform(i.scaleX,i.skewX,i.skewY,i.scaleY,i.translateX,i.translateY)},En.Yl=function(t,n,e){var i=jn(t);i.orgTranslateX+=n,i.orgTranslateY+=e,i.translateX=i.orgTranslateX*i.scaleX,i.translateY=i.orgTranslateY*i.scaleY,t.setTransform(i.scaleX,i.skewX,i.skewY,i.scaleY,i.translateX,i.translateY)},f.Lf=P=En,Pt=P,D.Zl=function(){var t,n,n,t,e,t=l.screen,n=t.deviceXDPI,n=l.devicePixelRatio||(n?n/t.logicalXDPI:1),t=20*n,e=rt(t);return.82<e-t?e/20:rt(100*n)/100},D.Wl=function(t,n,e){var i,r,o,a,u,s,c,f,l,i=D;if(On(t,1),Rn(t,1),(1!==(r=D.Zl())||1!==i.dpr)&&(i.dpr=r,o=n||e&&e.parent)){for(a=i.Ql,u=void 0,s=0;s<a.length;s++)if(o===a[s].workbook){u=a[s];break}if(u||a.push(u={workbook:o,sheets:[],canvases:[]}),n)u.canvases.push(t);else{for(c=void 0,f=u.sheets,l=0;l<f.length;l++)if(f[l].sheet===e){c=f[l];break}c||f.push(c={sheet:e,canvases:[]}),c.canvases.push(t)}}},D.Kl=function(t){return t&&t.Sf||1},D.Jl=function(t){return t&&t.Tf||1},D.Xl=function(t){return t.Af},D.ql=function(t){return t.If},D.$l=function(t,n,e){var i,r,o,i,a,r,n,i=D,r=i.dpr,o=i.Kl(t),i=i.Jl(t);Ln(t,n),Bn(t,e),1===r&&1===o&&1===i?(t.width=n,t.height=e):(a=t.getContext("2d"),Pt.Vl(a,1,1),b.Tt.mozilla?(t.width=x(n*r),t.height=x(e*r)):(t.width=rt(n*r),t.height=rt(e*r)),t.style.width=n+ct,t.style.height=e+ct,r=t.width/n,n=t.height/e,r===o&&n===i||(On(t,r),Rn(t,n)),Pt.Vl(a,r,n))},D.th=function(t,n){for(var e,i,r,o,a,u,s,e=D.Ql,i=t.parent,a=0;a<e.length;a++)if(!i||e[a].workbook===i)for(r=e[a].sheets,u=0;u<r.length;u++)if(r[u].sheet===t){for(o=r[u].canvases,s=0;s<o.length;s++)if(o[s]===n){o.splice(s,1);break}break}},D.nh=function(t,n){for(var e,i,r,o,e=D.Ql,r=0;r<e.length;r++)if(e[r].workbook===t)for(i=e[r].canvases,o=0;o<i.length;o++)if(i[o]===n){i.splice(o,1);break}},D.eh=function(t){for(var n,e,i,r,o,n=D.Ql,e=t.parent,r=0;r<n.length;r++)if(!e||n[r].workbook===e){for(i=n[r].sheets,o=0;o<i.length;o++)i[o].sheet===t&&i.splice(o,1);return}},D.ih=function(t){for(var n,e,n=D.Ql,e=0;e<n.length;e++)if(n[e].workbook===t)return void n.splice(e,1)},D.rh=function(){var t,n,e,i,r,o,a,u,s,c,t=D,n=t.Zl();if(t.dpr!==n)for(e=t.Ql,a=o=r=i=void 0,t.dpr=n,u=0;u<e.length;u++){for(o=(r=e[u]).canvases,i=r.sheets,s=0;s<i.length;s++)o=o.concat(i[s].canvases);for(c=0;c<o.length;c++)a=o[c],t.$l(a,t.Xl(a),t.ql(a))}},D.dpr=1,D.Ql=[],f.Bf=D,f.zt=Fn,O.un=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,o=[];if(t&&0!==t.length&&!isNaN(n)&&(a=r||j())){if(b.bt(a,e),u=b.vt(e),n<=0){for(s=-1,c=!0,f=0;f<t.length;f++)(l=t.charAt(f))===S||c?l!==S&&c&&(s=i?u:w(a,a.font,l),c=!1):s=N(s,i?u:w(a,a.font,l));if((n=s)<=0)return[t]}for(h=t.split(/\r\n|\r|\n/),d=0;d<h.length;d++)if(v=Hn(h[d],n,i,u,a))if(0===v.length)o.push("");else for(m=0;m<v.length;m++)o.push(v[m])}return o},O.oh=function(t,n,e,i,r){var o,a,u,s,c,o=[];if(0!==n.length)if(i)o=O.un(n,r,e,!0);else for(a=n.split(/\r\n|\r|\n/),u=0;u<a.length;u++){for(s=[],c=0;c<a[u].length;c++)s.push(a[u][c]);o.push(s)}return o},O.Ht=function(t,n,e,i,r,o){var a,u,s,c,o,f,l,h,a=[];if(0!==t.length&&(u=o||j())){if(n<=0&&(n=Zn(u,i,e,r))<=0){for(c=[],s=0;s<i.length;s++)A(i[s].text)||c.push({textLength:O.ah([i[s]],e,1,r,!1,u),text:i[s].text,textInfos:[i[s]]});return c}for(o=O.uh(t),f=O.Vt(o,O.Yt(i)),s=0;s<f.length;s++)if(l=Vn(f[s],n,e,r,u))if(0===l.length)a.push("");else for(h=0;h<l.length;h++)a.push(l[h])}return a},O.uh=function(t){for(var n,e,i,n=[],e=t.split(/\r\n|\r|\n/),i=0;i<e.length;i++)n.push(Fn(e[i]));return n},O.Vt=function(t,n){for(var e,i,r,o,a,u,s,c,f,e=[],i=0,r=0,o=0;o<t.length;o++){for(a=[],u=0;u<t[o].length&&i<n.length;u++)if((s=t[o][u]).length<=n[i].text.length-r)a.push([{style:n[i].style,text:s}]),r+=s.length;else{for((c=[]).push({style:n[i].style,text:n[i].text.substring(r)}),f=s.length-(n[i].text.length-r),i++;i<n.length;i++){if(f<n[i].text.length){c.push({style:n[i].style,text:s.substring(s.length-f)}),r=f;break}if(f===n[i].text.length){c.push({style:n[i].style,text:s.substring(s.length-f)}),i++,r=0;break}c.push({style:n[i].style,text:n[i].text}),f-=n[i].text.length}a.push(c)}e.push(a)}return e},O.Wt=function(t,n,e,i){var i,n,i=i||j();return i?(n&&b.bt(i,n),n=e?E(t):t,w(i,i.font,n)):0},O.Yt=function(t){for(var n,e,n=[],e=0;e<t.length;e++)n.push({style:t[e].style,text:t[e].text&&t[e].text.replace(/\r\n|\r|\n/g,"")});return n},O.ah=function(t,n,e,i,r,o){var a,u,s,c,f,l,a=o||j();if(!a)return 0;for(s=u=0;s<t.length;s++)c=void 0,c=t[s].style&&t[s].style.font?t[s].style.font:n,b.bt(a,c),f="",f=s===t.length-1&&r?E(t[s].text):t[s].text,l=0,i?l=b.vt(c)*f.length/e:A(t[s].text)||(l=w(a,a.font,t[s].text)/e),t[s].style&&t[s].style.vertAlign&&(l*=st),u+=l;return u},O.Zt=function(t,n,e,i,r,o,a,u){var s,c,f,r,a,l,h,s=0,c=b.vt(o),f,r=O.un(r,(a-4-c*i)/e,o),a=r.length,l,h=c*e;return s=(a-1)*(c/e),s=(s+=O.Wt(r[0],o)/2*i+h)+(O.Wt(r[a-1],o)/2*i+h)},O.tt=E,O.J=j,Ut=O,f.q=Ut,f.$e=Ht=function(s){s.ch=function(t,n){var e,i;for(s.fh||(s.fh=[]),s.lh={},e=s.fh,n.name=t,n.priority=n.priority||5e3,i=0;;i++)if(i>=e.length||n.priority>e[i].priority){e.splice(i,0,n);break}},s.et=function(t,n,e,i){var r,o,a,u,r=s.fh;if(r){if(!(o=s.lh[n]))for(o=s.lh[n]=[],a=0;a<r.length;a++)(u=r[a][n])&&o.push(u);for(a=0;a<o.length&&(o[a].call(t,e),!i||!i());a++);}}},Wn.prototype.get=function(t,n){var t=this.Nf[t];return t?t[n]:m},Wn.prototype.set=function(t,n,e){var i,i;(i=(i=this.Nf[t])||(this.Nf[t]={}))[n]=e},f.Rf=Wn,Qn.processBackspaceAndLeftArrowKeyEvent=function(t,n){var e,i,r,o,a,u,u,o,s,c,u,f,o,s,c,u,i,e=l.getSelection();if(!(e.rangeCount<=0))if(i=e.anchorNode,r=e.anchorOffset,o=t.target,b.browser.msie&&!b.browser.edge&&n&&qn(i,r,o))u=(a=parseFloat(b.browser.version)<10?ue(o):o.innerText).slice(0,-1),o.innerHTML=u.replace(/\r/g,"").replace(/\n/g,"<br>\u200b"),e.selectAllChildren(o),0<e.rangeCount&&e.collapseToEnd(),un(t);else if(o=(u=e.getRangeAt(0)).startContainer,s=u.endContainer,c=u.startOffset,u=u.endOffset,f=o===s&&c===u){if((o=oe(i,r))&&o.zeroWidthCharNode){if(s=o.zeroWidthCharNode,c=o.previousTextNode,n)if(R(s))s.parentNode.removeChild(s);else{if(s.parentNode.removeChild(s.previousSibling),$n(c))return void un(t);(u=e.getRangeAt(0)).setStart(s,0),u.setEnd(s,1),u.deleteContents()}i=v.createRange(),Kn(c)?(i.setStart(c,1),i.setEnd(c,1)):(i.setStartAfter(c),i.setEndAfter(c)),i.collapse(!1),e.removeAllRanges(),e.addRange(i),un(t)}}else n&&Jn(e)},Qn.processDeleteAndRightArrowKeyEvent=function(t,n){var e,i,r,o,a,i,u,r,o,a,i,r,i,s,e=l.getSelection();e.rangeCount<=0||(r=(i=e.getRangeAt(0)).startContainer,o=i.endContainer,a=i.startOffset,i=i.endOffset,(u=r===o&&a===i)?(r=ae(e))&&r.node&&(i=oe(o=r.node,a=r.offset),n?(r=e.getRangeAt(0),1===a?(r.setStart(o,0),r.setEnd(o,1),o.parentNode.removeChild(o.previousSibling),r.deleteContents(),i&&i.previousTextNode&&(i=i.previousTextNode,s=v.createRange(),Kn(i)?(s.setStart(i,1),s.setEnd(i,1)):(s.setStartAfter(i),s.setEndAfter(i)),s.collapse(!1),e.removeAllRanges(),e.addRange(s))):0===a&&(r.setStart(o,1),r.setEnd(o,2),r.deleteContents())):((s=v.createRange()).setStart(o,a),s.setEnd(o,a),s.collapse(!1),e.removeAllRanges(),e.addRange(s)),un(t)):n&&Jn(e))},f.di=Qn,f.Of={touch:!1},f.jf=he,f.Ef=de,f._f=ve,f.Df=me,f.kf=pe,be.hh=function(t){var n,e,i;if(!A(t))return e=t.row+t.rowCount-1,i=t.col+t.colCount-1,(n={}).minRow=t.row,n.minCol=t.col,n.maxRow=e,n.maxCol=i,n},be.vh=function(t,n){if(A(n)||A(n.minRow))return t;t.minRow=A(t.minRow)?n.minRow:N(t.minRow,n.minRow),t.minCol=A(t.minCol)?n.minCol:N(t.minCol,n.minCol),t.maxRow=A(t.maxRow)?n.maxRow:g(t.maxRow,n.maxRow),t.maxCol=A(t.maxCol)?n.maxCol:g(t.maxCol,n.maxCol)},be.updateUsedRangeByData=function(t,n,e,i,r){i===r||!A(i)&&!A(r)||A(t)||(!A(i)&&A(r)&&t.removeRowAndColInfo(n,e),A(i)&&!A(r)&&t.addRowAndColInfo(n,e))},f.UsedRangeUtil=be,we.prototype.getRowUsedRange=function(){var t,n,n,e,i,r,o,t,n=this.wholeRows,n=Object.keys(n);return 0<n.length&&(e=+n[0],i=-1,r=+n[n.length-1],o=0),{minRow:e,minCol:i,maxRow:r,maxCol:o}},we.prototype.getColUsedRange=function(){var t,n,n,e,i,r,o,t,n=this.wholeCols,n=Object.keys(n);return 0<n.length&&(i=+n[0],e=-1,o=+n[n.length-1],r=0),{minRow:e,minCol:i,maxRow:r,maxCol:o}},we.prototype.getUsedRange=function(){for(var t,n,e,i,r,o,a,u,s,c,f,l,h,t=this,n=t.rowInfo,e=t.colInfo,u=n.length-1,s=e.length-1,c=0;c<=u;c++)if(n[c]){i=c;break}for(f=u;0<=f;f--)if(n[f]){o=f;break}for(l=0;l<=s;l++)if(e[l]){r=l;break}for(h=s;0<=h;h--)if(e[h]){a=h;break}return{minRow:i,minCol:r,maxRow:o,maxCol:a}},we.prototype.addRowAndColInfo=function(t,n){var e=this,i=e.rowInfo,r=e.colInfo;A(t)||A(n)||-1===t&&-1===n||(-1===t?e.wholeCols[n]=!0:-1===n?e.wholeRows[t]=!0:(A(i[t])?i[t]=1:i[t]++,A(r[n])?r[n]=1:r[n]++))},we.prototype.removeRowAndColInfo=function(t,n){var e=this,i=e.rowInfo,r=e.colInfo;-1===t&&-1===n||(-1===t?delete e.wholeCols[n]:-1===n?delete e.wholeRows[t]:i[t]&&r[n]&&(i[t]--,r[n]--))},we.prototype.addHeadInfo=function(t,n,e){var i,e,i,i=this,e=e?i.rowInfo:i.colInfo,i=[];i.length=n,e.splice.apply(e,F([t,null],i,!1))},we.prototype.removeHeadInfo=function(t,n,e){var i=this,r;(e?i.rowInfo:i.colInfo).splice(t,n)},we.prototype.dispose=function(){var t=this;t.rowInfo=m,t.colInfo=m,t.wholeCols=m,t.wholeRows=m},f.BaseUsedRange=we,f.NUMBER_ARRAY=["0","1","2","3","4","5","6","7","8","9"],ye.prototype.getTextIndex=function(t){var n,e,i,r,o,a,n=this;if(t.richText)if((i=t.text)===m&&(i=t.text=b.g0(t).text),(e=n.mh[i])===m||n.gh[i]===m)e=n.ph.push(t)-1,n.mh[i]=e,n.gh[i]=[],n.gh[i].push({i:e,v:t});else{for(r=void 0,o=0,a=n.gh[i].length;o<a;o++)if(n.gh[i][o]&&n.gh[i][o].v===t){r=o;break}0<=r?e=n.gh[i][r].i:(e=n.ph.push(t)-1,n.gh[i].push({i:e,v:t}))}else(e=n.mh[t])!==m&&!n.gh[t]||(e=n.ph.push(t)-1,n.mh[t]=e);return e},ye.prototype.getText=function(t){var n=this.ph[t];return A(n)?t:n},ye.prototype.getCount=function(){return this.bh},ye.prototype.reset=function(){var t=this;t.ph=[],t.mh={},t.gh={},t.bh=0},ye.prototype.rebuildSSTDict=function(){var i=this;i.ph.forEach(function(t,n){var e;t.richText?((e=t.text)===m&&(e=t.text=b.g0(t).text),i.mh[e]=n):i.mh[t]=n})},ye.prototype.yh=function(t){var n;t&&0<t.length&&((n=this).reset(),n.ph=t)},ye.prototype.wh=function(){return this.ph},f.SharedStrings=ye,Qt={8:{"Gill Sans MT":6,Abadi:7,"Abadi Extra Light":6,"Agency FB":5,Aharoni:5,Aldhabi:4,Algerian:7,"Ami R":5,"Angsana New":4,AngsanaUPC:4,Aparajita:4,"Arabic Typesetting":4,Arial:6,"Arial Black":7,"Arial Narrow":5,"Arial Nova":6,"Arial Nova Cond":6,"Arial Nova Cond Light":5,"Arial Nova Light":6,"Arial Rounded MT Bold":7,"Baskerville Old Face":5,Batang:6,BatangChe:6,"Bauhaus 93":6,"Bell MT":6,Bembo:5,"Berlin Sans FB":7,"Berlin Sans FB Demi":7,"Bernard MT Condensed":5,"Blackadder ITC":4,"Bodoni MT":5,"Bodoni MT Black":7,"Bodoni MT Condensed":4,"Bodoni MT Poster Compressed":4,"Book Antiqua":6,"Bookman Old Style":7,"Bookshelf Symbol 7":8,"Bradley Hand ITC":7,"Britannic Bold":7,Broadway:7,"Browallia New":4,BrowalliaUPC:4,"Brush Script MT":6,Calibri:6,"Calibri Light":6,"Californian FB":5,"Calisto MT":6,Cambria:6,"Cambria Math":6,Candara:6,Castellar:8,Centaur:5,Century:6,"Century Gothic":6,"Century Schoolbook":6,Chiller:5,"Colonna MT":6,"Comic Sans MS":7,Consolas:6,Constantia:6,"Cooper Black":7,"Copperplate Gothic Bold":8,"Copperplate Gothic Light":8,Corbel:6,"Cordia New":4,CordiaUPC:4,"Courier New":7,"Curlz MT":6,Dante:5,DaunPenh:4,David:5,DilleniaUPC:3,DokChampa:6,Dotum:6,DotumChe:6,Dubai:6,"Dubai Light":6,"Dubai Medium":6,Ebrima:6,"Edwardian Script ITC":5,Elephant:8,"Engravers MT":7,"Eras Bold ITC":7,"Eras Demi ITC":7,"Eras Light ITC":6,"Eras Medium ITC":6,EucrosiaUPC:4,Euphemia:6,"Expo M":10,FangSong:6,"Felix Titling":6,"Footlight MT Light":6,Forte:6,"Franklin Gothic Book":6,"Franklin Gothic Demi":6,"Franklin Gothic Demi Cond":6,"Franklin Gothic Heavy":6,"Franklin Gothic Medium":6,"Franklin Gothic Medium Cond":6,FrankRuehl:5,FreesiaUPC:5,"Freestyle Script":4,"French Script MT":4,Gabriola:4,Gadugi:6,Garamond:5,Gautami:7,Georgia:8,"Georgia Pro":6,"Georgia Pro Black":8,"Georgia Pro Cond":6,"Georgia Pro Cond Black":7,"Georgia Pro Cond Light":6,"Georgia Pro Cond Semibold":6,"Georgia Pro Light":6,"Georgia Pro Semibold":7,Gigi:5,"Gill Sans MT Condensed":4,"Gill Sans MT Ext Condensed Bold":4,"Gill Sans Nova":6,"Gill Sans Nova Cond":4,"Gill Sans Nova Cond Lt":3,"Gill Sans Nova Cond Ultra Bold":6,"Gill Sans Nova Cond XBd":6,"Gill Sans Nova Light":6,"Gill Sans Nova Ultra Bold":9,"Gill Sans Ultra Bold":9,"Gill Sans Ultra Bold Condensed":6,Gisha:6,"Gloucester MT Extra Condensed":4,"Goudy Old Style":6,"Goudy Stout":9,Grotesque:5,"Grotesque Light":5,Gulim:6,GulimChe:6,Gungsuh:6,GungsuhChe:6,"Hadassah Friedlaender":6,Haettenschweiler:5,"Harlow Solid Italic":5,Harrington:6,"Headline R":8,HGGothicE:6,HGGothicM:6,HGGyoshotai:6,HGKyokashotai:6,HGMaruGothicMPRO:8,HGMinchoB:7,HGMinchoE:7,HGPGothicE:7,HGPGothicM:7,HGPGyoshotai:6,HGPKyokashotai:6,HGPMinchoB:6,HGPMinchoE:7,HGPSoeiKakugothicUB:8,HGPSoeiKakupoptai:8,HGPSoeiPresenceEB:7,HGSeikaishotaiPRO:7,HGSGothicE:6,HGSGothicM:6,HGSGyoshotai:5,HGSKyokashotai:5,HGSMinchoB:6,HGSMinchoE:7,HGSoeiKakugothicUB:7,HGSoeiKakupoptai:7,HGSoeiPresenceEB:7,HGSSoeiKakugothicUB:7,HGSSoeiKakupoptai:7,HGSSoeiPresenceEB:6,"High Tower Text":5,"HYGothic-Extra":7,"HYGothic-Medium":6,"HYGraphic-Medium":6,"HYGungSo-Bold":6,"HYHeadLine-Medium":6,"HYMyeongJo-Extra":7,"HYPMokGak-Bold":8,"HYPost-Light":7,"HYPost-Medium":8,"HYShortSamul-Medium":4,"HYSinMyeongJo-Medium":7,Impact:6,"Imprint MT Shadow":6,"Informal Roman":6,"Ink Free":6,IrisUPC:6,"Iskoola Pota":6,JasmineUPC:6,"Javanese Text":6,Jokerman:8,"Juice ITC":4,KaiTi:6,Kalinga:6,Kartika:6,"Khmer UI":6,KodchiangUPC:6,Kokila:6,"Kristen ITC":7,"Kunstler Script":4,"Lao UI":6,Latha:6,Leelawadee:6,"Leelawadee UI":6,"Leelawadee UI Semilight":6,"Levenim MT":6,LilyUPC:6,"Lucida Bright":7,"Lucida Calligraphy":7,"Lucida Console":8,"Lucida Fax":7,"Lucida Handwriting":8,"Lucida Sans":7,"Lucida Sans Typewriter":7,"Lucida Sans Unicode":8,"Magic R":7,Magneto:8,"Maiandra GD":7,"Malgun Gothic":6,"Malgun Gothic Semilight":7,Mangal:7,Marlett:12,"Matura MT Script Capitals":8,Meiryo:7,"Meiryo UI":7,"Microsoft GothicNeo":7,"Microsoft Himalaya":5,"Microsoft JhengHei":7,"Microsoft JhengHei Light":7,"Microsoft JhengHei UI":7,"Microsoft JhengHei UI Light":7,"Microsoft New Tai Lue":6,"Microsoft PhagsPa":6,"Microsoft Sans Serif":7,"Microsoft Tai Le":6,"Microsoft Uighur":4,"Microsoft YaHei Light":7,"Microsoft YaHei UI":7,"Microsoft YaHei UI Light":7,"Microsoft Yi Baiti":7,MingLiU:7,MingLiU_HKSCS:7,"MingLiU_HKSCS-ExtB":7,"MingLiU-ExtB":7,Miriam:7,"Miriam Fixed":7,Mistral:6,"Modern No. 20":6,"MoeumT R":7,"Mongolian Baiti":7,"Monotype Corsiva":6,MoolBoran:7,"MS Gothic":7,"MS Mincho":7,"MS Outlook":7,"MS PGothic":7,"MS PMincho":7,"MS Reference Sans Serif":8,"MS Reference Specialty":14,"MS UI Gothic":7,"MT Extra":12,"MV Boli":9,"Myanmar Text":6,Narkisim:7,"Neue Haas Grotesk Text Pro":7,"New Gulim":7,"News Gothic MT":7,"Niagara Engraved":5,"Niagara Solid":5,"Nirmala UI":6,"Nirmala UI Semilight":7,Nyala:7,"OCR A Extended":8,OCRB:8,"Old English Text MT":7,Onyx:5,"Palace Script MT":4,"Palatino Linotype":6,Papyrus:7,Parchment:3,Perpetua:5,"Perpetua Titling MT":7,"Plantagenet Cherokee":7,Playbill:5,PMingLiU:6,"PMingLiU-ExtB":6,"Poor Richard":7,Pristina:6,"Pyunji R":6,Raavi:7,"Rage Italic":7,Ravie:11,Rockwell:6,"Rockwell Condensed":5,"Rockwell Extra Bold":8,"Rockwell Light":7,"Rockwell Nova":7,"Rockwell Nova Cond":7,"Rockwell Nova Cond Light":7,"Rockwell Nova Extra Bold":7,"Rockwell Nova Light":7,Rod:7,"Sakkal Majalla":7,"Sanskrit Text":7,"Script MT Bold":6,"Segoe MDL2 Assets":4,"Segoe Print":8,"Segoe Script":8,"Segoe UI":6,"Segoe UI Black":7,"Segoe UI Emoji":6,"Segoe UI Historic":6,"Segoe UI Light":6,"Segoe UI Semibold":6,"Segoe UI Semilight":6,"Segoe UI Symbol":6,Selawik:6,"Selawik Light":6,"Selawik Semibold":6,"Shonar Bangla":6,"Showcard Gothic":6,Shruti:6,"Simplified Arabic":6,"Simplified Arabic Fixed":6,"SimSun-ExtB":6,"Sitka Banner":6,"Sitka Display":6,"Sitka Heading":6,"Sitka Small":8,"Sitka Subheading":6,"Sitka Text":7,"Snap ITC":10,"Source Sans Pro":6,"Source Sans Pro Black":6,"Source Sans Pro ExtraLight":6,"Source Sans Pro Light":6,"Source Sans Pro SemiBold":6,Stencil:6,Sylfaen:6,Symbol:6,Tahoma:6,"Tempus Sans ITC":7,"TH SarabunPSK":6,"Times New Roman":6,"Traditional Arabic":6,"Trebuchet MS":6,Tunga:6,"Tw Cen MT":6,"Tw Cen MT Condensed":4,"Tw Cen MT Condensed Extra Bold":5,"UD Digi Kyokasho N-B":6,"UD Digi Kyokasho NK-B":6,"UD Digi Kyokasho NK-R":6,"UD Digi Kyokasho NP-B":6,"UD Digi Kyokasho NP-R":6,"UD Digi Kyokasho N-R":6,Univers:6,"Univers Condensed":6,"Univers Condensed Light":6,"Univers Light":6,"Urdu Typesetting":6,Utsaah:6,Vani:6,Verdana:7,"Verdana Pro":6,"Verdana Pro Black":6,"Verdana Pro Cond":6,"Verdana Pro Cond Black":6,"Verdana Pro Cond Light":6,"Verdana Pro Cond SemiBold":6,"Verdana Pro Light":6,"Verdana Pro SemiBold":6,Vijaya:6,"Viner Hand ITC":7,Vivaldi:5,"Vladimir Script":5,Vrinda:6,Webdings:11,"Wide Latin":14,Wingdings:15,"Wingdings 2":12,"Wingdings 3":10,"Yet R":6,"Yu Gothic":6,"Yu Gothic Light":6,"Yu Gothic Medium":6,"Yu Gothic UI":6,"Yu Gothic UI Light":6,"Yu Gothic UI Semibold":6,"Yu Gothic UI Semilight":6,"Yu Mincho":6,"Yu Mincho Demibold":6,"Yu Mincho Light":6,"\u4eff\u5b8b":6,"\u534e\u6587\u4e2d\u5b8b":7,"\u534e\u6587\u4eff\u5b8b":5,"\u534e\u6587\u5b8b\u4f53":5,"\u534e\u6587\u5f69\u4e91":6,"\u534e\u6587\u65b0\u9b4f":6,"\u534e\u6587\u6977\u4f53":5,"\u534e\u6587\u7425\u73c0":6,"\u534e\u6587\u7ec6\u9ed1":6,"\u534e\u6587\u884c\u6977":6,"\u534e\u6587\u96b6\u4e66":5,"\u5b8b\u4f53":6,"\u5e7c\u5706":6,"\u5fae\u8f6f\u96c5\u9ed1":6,"\u5fae\u8f6f\u96c5\u9ed1 Light":6,"\u65b0\u5b8b\u4f53":6,"\u65b9\u6b63\u59da\u4f53":6,"\u65b9\u6b63\u8212\u4f53":6,"\u6977\u4f53":6,"\u7b49\u7ebf":6,"\u7b49\u7ebf Light":6,"\u96b6\u4e66":6,"\u9ed1\u4f53":6,"\u6e38\u30b4\u30b7\u30c3\u30af":6,"\uff2d\uff33 \uff30\u660e\u671d":6,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':6,"\u30e1\u30a4\u30ea\u30aa":7,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":6,"HG\u660e\u671dB":6,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":6},9:{"Gill Sans MT":6,Abadi:7,"Abadi Extra Light":7,"Agency FB":5,Aharoni:5,Aldhabi:4,Algerian:7,"Ami R":5,"Angsana New":4,AngsanaUPC:4,Aparajita:5,"Arabic Typesetting":4,Arial:7,"Arial Black":8,"Arial Narrow":5,"Arial Nova":7,"Arial Nova Cond":6,"Arial Nova Cond Light":5,"Arial Nova Light":7,"Arial Rounded MT Bold":7,"Baskerville Old Face":6,Batang:6,BatangChe:6,"Bauhaus 93":7,"Bell MT":6,Bembo:6,"Berlin Sans FB":7,"Berlin Sans FB Demi":8,"Bernard MT Condensed":6,"Blackadder ITC":5,"Bodoni MT":6,"Bodoni MT Black":8,"Bodoni MT Condensed":4,"Bodoni MT Poster Compressed":4,"Book Antiqua":6,"Bookman Old Style":7,"Bookshelf Symbol 7":9,"Bradley Hand ITC":8,"Britannic Bold":7,Broadway:8,"Browallia New":4,BrowalliaUPC:4,"Brush Script MT":6,Calibri:6,"Calibri Light":6,"Californian FB":7,"Calisto MT":6,Cambria:7,"Cambria Math":7,Candara:7,Castellar:9,Centaur:6,Century:7,"Century Gothic":7,"Century Schoolbook":7,Chiller:6,"Colonna MT":6,"Comic Sans MS":7,Consolas:7,Constantia:7,"Cooper Black":7,"Copperplate Gothic Bold":9,"Copperplate Gothic Light":9,Corbel:6,"Cordia New":4,CordiaUPC:4,"Courier New":7,"Curlz MT":6,Dante:5,DaunPenh:4,David:5,DilleniaUPC:4,DokChampa:7,Dotum:6,DotumChe:6,Dubai:6,"Dubai Light":6,"Dubai Medium":6,Ebrima:6,"Edwardian Script ITC":6,Elephant:9,"Engravers MT":8,"Eras Bold ITC":8,"Eras Demi ITC":7,"Eras Light ITC":6,"Eras Medium ITC":7,EucrosiaUPC:5,Euphemia:7,"Expo M":10,FangSong:6,"Felix Titling":7,"Footlight MT Light":7,Forte:6,"Franklin Gothic Book":7,"Franklin Gothic Demi":7,"Franklin Gothic Demi Cond":6,"Franklin Gothic Heavy":7,"Franklin Gothic Medium":7,"Franklin Gothic Medium Cond":6,FrankRuehl:5,FreesiaUPC:5,"Freestyle Script":5,"French Script MT":4,Gabriola:5,Gadugi:6,Garamond:6,Gautami:7,Georgia:8,"Georgia Pro":7,"Georgia Pro Black":9,"Georgia Pro Cond":6,"Georgia Pro Cond Black":8,"Georgia Pro Cond Light":6,"Georgia Pro Cond Semibold":7,"Georgia Pro Light":7,"Georgia Pro Semibold":7,Gigi:7,"Gill Sans MT Condensed":4,"Gill Sans MT Ext Condensed Bold":4,"Gill Sans Nova":6,"Gill Sans Nova Cond":4,"Gill Sans Nova Cond Lt":4,"Gill Sans Nova Cond Ultra Bold":7,"Gill Sans Nova Cond XBd":6,"Gill Sans Nova Light":6,"Gill Sans Nova Ultra Bold":10,"Gill Sans Ultra Bold":10,"Gill Sans Ultra Bold Condensed":7,Gisha:6,"Gloucester MT Extra Condensed":5,"Goudy Old Style":6,"Goudy Stout":10,Grotesque:6,"Grotesque Light":6,Gulim:6,GulimChe:6,Gungsuh:6,GungsuhChe:6,"Hadassah Friedlaender":7,Haettenschweiler:5,"Harlow Solid Italic":6,Harrington:7,"Headline R":9,HGGothicE:6,HGGothicM:6,HGGyoshotai:6,HGKyokashotai:6,HGMaruGothicMPRO:9,HGMinchoB:7,HGMinchoE:7,HGPGothicE:8,HGPGothicM:8,HGPGyoshotai:7,HGPKyokashotai:7,HGPMinchoB:7,HGPMinchoE:7,HGPSoeiKakugothicUB:9,HGPSoeiKakupoptai:9,HGPSoeiPresenceEB:8,HGSeikaishotaiPRO:7,HGSGothicE:7,HGSGothicM:7,HGSGyoshotai:6,HGSKyokashotai:6,HGSMinchoB:7,HGSMinchoE:7,HGSoeiKakugothicUB:7,HGSoeiKakupoptai:7,HGSoeiPresenceEB:7,HGSSoeiKakugothicUB:8,HGSSoeiKakupoptai:8,HGSSoeiPresenceEB:7,"High Tower Text":6,"HYGothic-Extra":8,"HYGothic-Medium":7,"HYGraphic-Medium":7,"HYGungSo-Bold":7,"HYHeadLine-Medium":7,"HYMyeongJo-Extra":8,"HYPMokGak-Bold":9,"HYPost-Light":8,"HYPost-Medium":9,"HYShortSamul-Medium":5,"HYSinMyeongJo-Medium":8,Impact:7,"Imprint MT Shadow":6,"Informal Roman":7,"Ink Free":6,IrisUPC:6,"Iskoola Pota":6,JasmineUPC:6,"Javanese Text":7,Jokerman:9,"Juice ITC":4,KaiTi:6,Kalinga:6,Kartika:6,"Khmer UI":6,KodchiangUPC:6,Kokila:6,"Kristen ITC":7,"Kunstler Script":4,"Lao UI":6,Latha:6,Leelawadee:6,"Leelawadee UI":6,"Leelawadee UI Semilight":7,"Levenim MT":6,LilyUPC:6,"Lucida Bright":7,"Lucida Calligraphy":9,"Lucida Console":8,"Lucida Fax":8,"Lucida Handwriting":9,"Lucida Sans":8,"Lucida Sans Typewriter":7,"Lucida Sans Unicode":9,"Magic R":8,Magneto:9,"Maiandra GD":8,"Malgun Gothic":7,"Malgun Gothic Semilight":8,Mangal:7,Marlett:13,"Matura MT Script Capitals":9,Meiryo:8,"Meiryo UI":8,"Microsoft GothicNeo":7,"Microsoft Himalaya":5,"Microsoft JhengHei":7,"Microsoft JhengHei Light":8,"Microsoft JhengHei UI":7,"Microsoft JhengHei UI Light":8,"Microsoft New Tai Lue":7,"Microsoft PhagsPa":7,"Microsoft Sans Serif":8,"Microsoft Tai Le":7,"Microsoft Uighur":5,"Microsoft YaHei Light":8,"Microsoft YaHei UI":7,"Microsoft YaHei UI Light":8,"Microsoft Yi Baiti":7,MingLiU:7,MingLiU_HKSCS:7,"MingLiU_HKSCS-ExtB":7,"MingLiU-ExtB":7,Miriam:7,"Miriam Fixed":7,Mistral:6,"Modern No. 20":6,"MoeumT R":8,"Mongolian Baiti":7,"Monotype Corsiva":6,MoolBoran:7,"MS Gothic":7,"MS Mincho":7,"MS Outlook":7,"MS PGothic":7,"MS PMincho":7,"MS Reference Sans Serif":9,"MS Reference Specialty":15,"MS UI Gothic":7,"MT Extra":13,"MV Boli":9,"Myanmar Text":7,Narkisim:7,"Neue Haas Grotesk Text Pro":7,"New Gulim":8,"News Gothic MT":7,"Niagara Engraved":5,"Niagara Solid":5,"Nirmala UI":7,"Nirmala UI Semilight":8,Nyala:7,"OCR A Extended":8,OCRB:8,"Old English Text MT":7,Onyx:5,"Palace Script MT":5,"Palatino Linotype":6,Papyrus:8,Parchment:4,Perpetua:6,"Perpetua Titling MT":8,"Plantagenet Cherokee":7,Playbill:5,PMingLiU:7,"PMingLiU-ExtB":7,"Poor Richard":8,Pristina:6,"Pyunji R":7,Raavi:7,"Rage Italic":7,Ravie:12,Rockwell:7,"Rockwell Condensed":5,"Rockwell Extra Bold":8,"Rockwell Light":7,"Rockwell Nova":7,"Rockwell Nova Cond":7,"Rockwell Nova Cond Light":7,"Rockwell Nova Extra Bold":7,"Rockwell Nova Light":7,Rod:7,"Sakkal Majalla":7,"Sanskrit Text":7,"Script MT Bold":6,"Segoe MDL2 Assets":5,"Segoe Print":9,"Segoe Script":9,"Segoe UI":6,"Segoe UI Black":7,"Segoe UI Emoji":6,"Segoe UI Historic":6,"Segoe UI Light":6,"Segoe UI Semibold":7,"Segoe UI Semilight":7,"Segoe UI Symbol":6,Selawik:6,"Selawik Light":6,"Selawik Semibold":6,"Shonar Bangla":6,"Showcard Gothic":8,Shruti:6,"Simplified Arabic":6,"Simplified Arabic Fixed":6,"SimSun-ExtB":6,"Sitka Banner":6,"Sitka Display":6,"Sitka Heading":7,"Sitka Small":8,"Sitka Subheading":7,"Sitka Text":8,"Snap ITC":10,"Source Sans Pro":6,"Source Sans Pro Black":6,"Source Sans Pro ExtraLight":6,"Source Sans Pro Light":6,"Source Sans Pro SemiBold":6,Stencil:7,Sylfaen:6,Symbol:6,Tahoma:7,"Tempus Sans ITC":8,"TH SarabunPSK":6,"Times New Roman":6,"Traditional Arabic":6,"Trebuchet MS":6,Tunga:6,"Tw Cen MT":7,"Tw Cen MT Condensed":4,"Tw Cen MT Condensed Extra Bold":6,"UD Digi Kyokasho N-B":6,"UD Digi Kyokasho NK-B":6,"UD Digi Kyokasho NK-R":6,"UD Digi Kyokasho NP-B":6,"UD Digi Kyokasho NP-R":6,"UD Digi Kyokasho N-R":6,Univers:6,"Univers Condensed":6,"Univers Condensed Light":6,"Univers Light":6,"Urdu Typesetting":6,Utsaah:6,Vani:6,Verdana:8,"Verdana Pro":6,"Verdana Pro Black":6,"Verdana Pro Cond":6,"Verdana Pro Cond Black":6,"Verdana Pro Cond Light":6,"Verdana Pro Cond SemiBold":6,"Verdana Pro Light":6,"Verdana Pro SemiBold":6,Vijaya:6,"Viner Hand ITC":8,Vivaldi:5,"Vladimir Script":6,Vrinda:6,Webdings:12,"Wide Latin":15,Wingdings:16,"Wingdings 2":14,"Wingdings 3":11,"Yet R":6,"Yu Gothic":7,"Yu Gothic Light":6,"Yu Gothic Medium":7,"Yu Gothic UI":6,"Yu Gothic UI Light":6,"Yu Gothic UI Semibold":7,"Yu Gothic UI Semilight":7,"Yu Mincho":7,"Yu Mincho Demibold":6,"Yu Mincho Light":6,"\u4eff\u5b8b":6,"\u534e\u6587\u4e2d\u5b8b":7,"\u534e\u6587\u4eff\u5b8b":6,"\u534e\u6587\u5b8b\u4f53":6,"\u534e\u6587\u5f69\u4e91":7,"\u534e\u6587\u65b0\u9b4f":7,"\u534e\u6587\u6977\u4f53":6,"\u534e\u6587\u7425\u73c0":7,"\u534e\u6587\u7ec6\u9ed1":7,"\u534e\u6587\u884c\u6977":6,"\u534e\u6587\u96b6\u4e66":5,"\u5b8b\u4f53":6,"\u5e7c\u5706":6,"\u5fae\u8f6f\u96c5\u9ed1":7,"\u5fae\u8f6f\u96c5\u9ed1 Light":7,"\u65b0\u5b8b\u4f53":6,"\u65b9\u6b63\u59da\u4f53":6,"\u65b9\u6b63\u8212\u4f53":7,"\u6977\u4f53":6,"\u7b49\u7ebf":6,"\u7b49\u7ebf Light":6,"\u96b6\u4e66":6,"\u9ed1\u4f53":6,"\u6e38\u30b4\u30b7\u30c3\u30af":7,"\uff2d\uff33 \uff30\u660e\u671d":6,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':6,"\u30e1\u30a4\u30ea\u30aa":7,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":6,"HG\u660e\u671dB":6,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":6},10:{"Gill Sans MT":7,Abadi:8,"Abadi Extra Light":7,"Agency FB":5,Aharoni:5,Aldhabi:4,Algerian:8,"Ami R":5,"Angsana New":4,AngsanaUPC:4,Aparajita:5,"Arabic Typesetting":4,Arial:7,"Arial Black":9,"Arial Narrow":6,"Arial Nova":7,"Arial Nova Cond":7,"Arial Nova Cond Light":6,"Arial Nova Light":7,"Arial Rounded MT Bold":8,"Baskerville Old Face":6,Batang:7,BatangChe:7,"Bauhaus 93":7,"Bell MT":7,Bembo:6,"Berlin Sans FB":8,"Berlin Sans FB Demi":8,"Bernard MT Condensed":6,"Blackadder ITC":5,"Bodoni MT":6,"Bodoni MT Black":9,"Bodoni MT Condensed":4,"Bodoni MT Poster Compressed":5,"Book Antiqua":7,"Bookman Old Style":8,"Bookshelf Symbol 7":10,"Bradley Hand ITC":8,"Britannic Bold":8,Broadway:8,"Browallia New":5,BrowalliaUPC:5,"Brush Script MT":7,Calibri:7,"Calibri Light":7,"Californian FB":7,"Calisto MT":7,Cambria:7,"Cambria Math":7,Candara:7,Castellar:9,Centaur:6,Century:7,"Century Gothic":7,"Century Schoolbook":7,Chiller:6,"Colonna MT":7,"Comic Sans MS":8,Consolas:7,Constantia:7,"Cooper Black":8,"Copperplate Gothic Bold":9,"Copperplate Gothic Light":9,Corbel:7,"Cordia New":5,CordiaUPC:5,"Courier New":8,"Curlz MT":7,Dante:6,DaunPenh:4,David:6,DilleniaUPC:4,DokChampa:7,Dotum:6,DotumChe:7,Dubai:7,"Dubai Light":7,"Dubai Medium":7,Ebrima:7,"Edwardian Script ITC":6,Elephant:10,"Engravers MT":8,"Eras Bold ITC":8,"Eras Demi ITC":8,"Eras Light ITC":7,"Eras Medium ITC":7,EucrosiaUPC:5,Euphemia:8,"Expo M":11,FangSong:7,"Felix Titling":8,"Footlight MT Light":7,Forte:7,"Franklin Gothic Book":8,"Franklin Gothic Demi":8,"Franklin Gothic Demi Cond":7,"Franklin Gothic Heavy":8,"Franklin Gothic Medium":8,"Franklin Gothic Medium Cond":7,FrankRuehl:5,FreesiaUPC:6,"Freestyle Script":5,"French Script MT":5,Gabriola:5,Gadugi:7,Garamond:6,Gautami:8,Georgia:9,"Georgia Pro":7,"Georgia Pro Black":9,"Georgia Pro Cond":7,"Georgia Pro Cond Black":8,"Georgia Pro Cond Light":7,"Georgia Pro Cond Semibold":7,"Georgia Pro Light":7,"Georgia Pro Semibold":8,Gigi:7,"Gill Sans MT Condensed":5,"Gill Sans MT Ext Condensed Bold":4,"Gill Sans Nova":7,"Gill Sans Nova Cond":4,"Gill Sans Nova Cond Lt":4,"Gill Sans Nova Cond Ultra Bold":8,"Gill Sans Nova Cond XBd":7,"Gill Sans Nova Light":7,"Gill Sans Nova Ultra Bold":11,"Gill Sans Ultra Bold":11,"Gill Sans Ultra Bold Condensed":8,Gisha:7,"Gloucester MT Extra Condensed":5,"Goudy Old Style":7,"Goudy Stout":11,Grotesque:6,"Grotesque Light":6,Gulim:7,GulimChe:7,Gungsuh:6,GungsuhChe:7,"Hadassah Friedlaender":7,Haettenschweiler:6,"Harlow Solid Italic":6,Harrington:7,"Headline R":9,HGGothicE:7,HGGothicM:7,HGGyoshotai:7,HGKyokashotai:7,HGMaruGothicMPRO:10,HGMinchoB:8,HGMinchoE:8,HGPGothicE:8,HGPGothicM:9,HGPGyoshotai:7,HGPKyokashotai:7,HGPMinchoB:7,HGPMinchoE:8,HGPSoeiKakugothicUB:9,HGPSoeiKakupoptai:9,HGPSoeiPresenceEB:8,HGSeikaishotaiPRO:8,HGSGothicE:7,HGSGothicM:8,HGSGyoshotai:6,HGSKyokashotai:6,HGSMinchoB:7,HGSMinchoE:8,HGSoeiKakugothicUB:8,HGSoeiKakupoptai:8,HGSoeiPresenceEB:8,HGSSoeiKakugothicUB:8,HGSSoeiKakupoptai:8,HGSSoeiPresenceEB:7,"High Tower Text":6,"HYGothic-Extra":8,"HYGothic-Medium":8,"HYGraphic-Medium":8,"HYGungSo-Bold":8,"HYHeadLine-Medium":8,"HYMyeongJo-Extra":9,"HYPMokGak-Bold":9,"HYPost-Light":9,"HYPost-Medium":9,"HYShortSamul-Medium":5,"HYSinMyeongJo-Medium":8,Impact:7,"Imprint MT Shadow":7,"Informal Roman":7,"Ink Free":7,IrisUPC:7,"Iskoola Pota":7,JasmineUPC:7,"Javanese Text":8,Jokerman:9,"Juice ITC":5,KaiTi:7,Kalinga:7,Kartika:7,"Khmer UI":7,KodchiangUPC:4,Kokila:7,"Kristen ITC":8,"Kunstler Script":5,"Lao UI":7,Latha:7,Leelawadee:7,"Leelawadee UI":7,"Leelawadee UI Semilight":7,"Levenim MT":7,LilyUPC:7,"Lucida Bright":8,"Lucida Calligraphy":10,"Lucida Console":9,"Lucida Fax":9,"Lucida Handwriting":10,"Lucida Sans":9,"Lucida Sans Typewriter":8,"Lucida Sans Unicode":9,"Magic R":8,Magneto:10,"Maiandra GD":9,"Malgun Gothic":8,"Malgun Gothic Semilight":8,Mangal:8,Marlett:14,"Matura MT Script Capitals":10,Meiryo:9,"Meiryo UI":9,"Microsoft GothicNeo":8,"Microsoft Himalaya":5,"Microsoft JhengHei":8,"Microsoft JhengHei Light":8,"Microsoft JhengHei UI":8,"Microsoft JhengHei UI Light":8,"Microsoft New Tai Lue":7,"Microsoft PhagsPa":7,"Microsoft Sans Serif":8,"Microsoft Tai Le":7,"Microsoft Uighur":5,"Microsoft YaHei Light":8,"Microsoft YaHei UI":8,"Microsoft YaHei UI Light":8,"Microsoft Yi Baiti":8,MingLiU:8,MingLiU_HKSCS:8,"MingLiU_HKSCS-ExtB":8,"MingLiU-ExtB":8,Miriam:8,"Miriam Fixed":8,Mistral:7,"Modern No. 20":7,"MoeumT R":8,"Mongolian Baiti":8,"Monotype Corsiva":7,MoolBoran:8,"MS Gothic":8,"MS Mincho":8,"MS Outlook":8,"MS PGothic":8,"MS PMincho":8,"MS Reference Sans Serif":9,"MS Reference Specialty":17,"MS UI Gothic":8,"MT Extra":14,"MV Boli":10,"Myanmar Text":7,Narkisim:8,"Neue Haas Grotesk Text Pro":8,"New Gulim":8,"News Gothic MT":8,"Niagara Engraved":5,"Niagara Solid":5,"Nirmala UI":7,"Nirmala UI Semilight":8,Nyala:8,"OCR A Extended":9,OCRB:9,"Old English Text MT":8,Onyx:6,"Palace Script MT":5,"Palatino Linotype":7,Papyrus:9,Parchment:4,Perpetua:6,"Perpetua Titling MT":9,"Plantagenet Cherokee":8,Playbill:6,PMingLiU:7,"PMingLiU-ExtB":7,"Poor Richard":8,Pristina:8,"Pyunji R":7,Raavi:8,"Rage Italic":8,Ravie:13,Rockwell:7,"Rockwell Condensed":6,"Rockwell Extra Bold":9,"Rockwell Light":8,"Rockwell Nova":8,"Rockwell Nova Cond":8,"Rockwell Nova Cond Light":8,"Rockwell Nova Extra Bold":8,"Rockwell Nova Light":8,Rod:8,"Sakkal Majalla":8,"Sanskrit Text":8,"Script MT Bold":7,"Segoe MDL2 Assets":5,"Segoe Print":10,"Segoe Script":10,"Segoe UI":7,"Segoe UI Black":8,"Segoe UI Emoji":7,"Segoe UI Historic":7,"Segoe UI Light":7,"Segoe UI Semibold":7,"Segoe UI Semilight":7,"Segoe UI Symbol":7,Selawik:7,"Selawik Light":7,"Selawik Semibold":7,"Shonar Bangla":7,"Showcard Gothic":8,Shruti:7,"Simplified Arabic":7,"Simplified Arabic Fixed":7,"SimSun-ExtB":7,"Sitka Banner":7,"Sitka Display":7,"Sitka Heading":7,"Sitka Small":9,"Sitka Subheading":8,"Sitka Text":8,"Snap ITC":11,"Source Sans Pro":7,"Source Sans Pro Black":7,"Source Sans Pro ExtraLight":7,"Source Sans Pro Light":7,"Source Sans Pro SemiBold":7,Stencil:7,Sylfaen:7,Symbol:7,Tahoma:7,"Tempus Sans ITC":9,"TH SarabunPSK":7,"Times New Roman":6,"Traditional Arabic":7,"Trebuchet MS":7,Tunga:7,"Tw Cen MT":7,"Tw Cen MT Condensed":5,"Tw Cen MT Condensed Extra Bold":6,"UD Digi Kyokasho N-B":7,"UD Digi Kyokasho NK-B":7,"UD Digi Kyokasho NK-R":7,"UD Digi Kyokasho NP-B":7,"UD Digi Kyokasho NP-R":7,"UD Digi Kyokasho N-R":7,Univers:7,"Univers Condensed":7,"Univers Condensed Light":7,"Univers Light":7,"Urdu Typesetting":7,Utsaah:7,Vani:7,Verdana:8,"Verdana Pro":8,"Verdana Pro Black":7,"Verdana Pro Cond":7,"Verdana Pro Cond Black":7,"Verdana Pro Cond Light":7,"Verdana Pro Cond SemiBold":7,"Verdana Pro Light":7,"Verdana Pro SemiBold":7,Vijaya:7,"Viner Hand ITC":9,Vivaldi:6,"Vladimir Script":6,Vrinda:7,Webdings:13,"Wide Latin":16,Wingdings:17,"Wingdings 2":15,"Wingdings 3":12,"Yet R":7,"Yu Gothic":7,"Yu Gothic Light":7,"Yu Gothic Medium":7,"Yu Gothic UI":7,"Yu Gothic UI Light":7,"Yu Gothic UI Semibold":7,"Yu Gothic UI Semilight":7,"Yu Mincho":7,"Yu Mincho Demibold":7,"Yu Mincho Light":7,"\u4eff\u5b8b":7,"\u534e\u6587\u4e2d\u5b8b":8,"\u534e\u6587\u4eff\u5b8b":6,"\u534e\u6587\u5b8b\u4f53":6,"\u534e\u6587\u5f69\u4e91":7,"\u534e\u6587\u65b0\u9b4f":8,"\u534e\u6587\u6977\u4f53":6,"\u534e\u6587\u7425\u73c0":7,"\u534e\u6587\u7ec6\u9ed1":7,"\u534e\u6587\u884c\u6977":7,"\u534e\u6587\u96b6\u4e66":6,"\u5b8b\u4f53":7,"\u5e7c\u5706":7,"\u5fae\u8f6f\u96c5\u9ed1":8,"\u5fae\u8f6f\u96c5\u9ed1 Light":7,"\u65b0\u5b8b\u4f53":7,"\u65b9\u6b63\u59da\u4f53":7,"\u65b9\u6b63\u8212\u4f53":7,"\u6977\u4f53":7,"\u7b49\u7ebf":7,"\u7b49\u7ebf Light":7,"\u96b6\u4e66":7,"\u9ed1\u4f53":7,"\u6e38\u30b4\u30b7\u30c3\u30af":7,"\uff2d\uff33 \uff30\u660e\u671d":7,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':7,"\u30e1\u30a4\u30ea\u30aa":8,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":7,"HG\u660e\u671dB":7,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":7},11:{"Gill Sans MT":8,Abadi:9,"Abadi Extra Light":8,"Agency FB":6,Aharoni:6,Aldhabi:5,Algerian:9,"Ami R":6,"Angsana New":5,AngsanaUPC:5,Aparajita:6,"Arabic Typesetting":5,Arial:8,"Arial Black":10,"Arial Narrow":7,"Arial Nova":8,"Arial Nova Cond":8,"Arial Nova Cond Light":7,"Arial Nova Light":8,"Arial Rounded MT Bold":9,"Baskerville Old Face":7,Batang:8,BatangChe:8,"Bauhaus 93":9,"Bell MT":8,Bembo:7,"Berlin Sans FB":9,"Berlin Sans FB Demi":9,"Bernard MT Condensed":7,"Blackadder ITC":6,"Bodoni MT":7,"Bodoni MT Black":10,"Bodoni MT Condensed":5,"Bodoni MT Poster Compressed":5,"Book Antiqua":8,"Bookman Old Style":9,"Bookshelf Symbol 7":11,"Bradley Hand ITC":10,"Britannic Bold":9,Broadway:10,"Browallia New":5,BrowalliaUPC:5,"Brush Script MT":8,Calibri:7,"Calibri Light":8,"Californian FB":9,"Calisto MT":8,Cambria:8,"Cambria Math":8,Candara:8,Castellar:11,Centaur:7,Century:8,"Century Gothic":8,"Century Schoolbook":8,Chiller:7,"Colonna MT":8,"Comic Sans MS":9,Consolas:8,Constantia:8,"Cooper Black":9,"Copperplate Gothic Bold":11,"Copperplate Gothic Light":11,Corbel:8,"Cordia New":5,CordiaUPC:5,"Courier New":9,"Curlz MT":8,Dante:7,DaunPenh:5,David:7,DilleniaUPC:5,DokChampa:8,Dotum:9,DotumChe:8,Dubai:8,"Dubai Light":8,"Dubai Medium":8,Ebrima:8,"Edwardian Script ITC":7,Elephant:11,"Engravers MT":10,"Eras Bold ITC":10,"Eras Demi ITC":9,"Eras Light ITC":8,"Eras Medium ITC":9,EucrosiaUPC:6,Euphemia:9,"Expo M":13,FangSong:8,"Felix Titling":9,"Footlight MT Light":8,Forte:8,"Franklin Gothic Book":9,"Franklin Gothic Demi":9,"Franklin Gothic Demi Cond":8,"Franklin Gothic Heavy":9,"Franklin Gothic Medium":9,"Franklin Gothic Medium Cond":8,FrankRuehl:6,FreesiaUPC:7,"Freestyle Script":6,"French Script MT":5,Gabriola:6,Gadugi:8,Garamond:7,Gautami:9,Georgia:9,"Georgia Pro":8,"Georgia Pro Black":11,"Georgia Pro Cond":8,"Georgia Pro Cond Black":10,"Georgia Pro Cond Light":8,"Georgia Pro Cond Semibold":8,"Georgia Pro Light":8,"Georgia Pro Semibold":9,Gigi:7,"Gill Sans MT Condensed":5,"Gill Sans MT Ext Condensed Bold":5,"Gill Sans Nova":8,"Gill Sans Nova Cond":5,"Gill Sans Nova Cond Lt":5,"Gill Sans Nova Cond Ultra Bold":9,"Gill Sans Nova Cond XBd":8,"Gill Sans Nova Light":8,"Gill Sans Nova Ultra Bold":13,"Gill Sans Ultra Bold":13,"Gill Sans Ultra Bold Condensed":9,Gisha:8,"Gloucester MT Extra Condensed":6,"Goudy Old Style":8,"Goudy Stout":12,Grotesque:7,"Grotesque Light":7,Gulim:8,GulimChe:8,Gungsuh:7,GungsuhChe:8,"Hadassah Friedlaender":9,Haettenschweiler:7,"Harlow Solid Italic":7,Harrington:8,"Headline R":11,HGGothicE:8,HGGothicM:8,HGGyoshotai:8,HGKyokashotai:8,HGMaruGothicMPRO:11,HGMinchoB:9,HGMinchoE:9,HGPGothicE:9,HGPGothicM:10,HGPGyoshotai:8,HGPKyokashotai:8,HGPMinchoB:8,HGPMinchoE:9,HGPSoeiKakugothicUB:10,HGPSoeiKakupoptai:11,HGPSoeiPresenceEB:9,HGSeikaishotaiPRO:9,HGSGothicE:8,HGSGothicM:9,HGSGyoshotai:7,HGSKyokashotai:7,HGSMinchoB:8,HGSMinchoE:9,HGSoeiKakugothicUB:9,HGSoeiKakupoptai:9,HGSoeiPresenceEB:9,HGSSoeiKakugothicUB:9,HGSSoeiKakupoptai:10,HGSSoeiPresenceEB:8,"High Tower Text":7,"HYGothic-Extra":9,"HYGothic-Medium":9,"HYGraphic-Medium":9,"HYGungSo-Bold":9,"HYHeadLine-Medium":9,"HYMyeongJo-Extra":10,"HYPMokGak-Bold":11,"HYPost-Light":10,"HYPost-Medium":11,"HYShortSamul-Medium":6,"HYSinMyeongJo-Medium":9,Impact:8,"Imprint MT Shadow":8,"Informal Roman":8,"Ink Free":8,IrisUPC:8,"Iskoola Pota":8,JasmineUPC:8,"Javanese Text":9,Jokerman:11,"Juice ITC":6,KaiTi:8,Kalinga:8,Kartika:8,"Khmer UI":8,KodchiangUPC:5,Kokila:8,"Kristen ITC":9,"Kunstler Script":5,"Lao UI":8,Latha:8,Leelawadee:8,"Leelawadee UI":8,"Leelawadee UI Semilight":8,"Levenim MT":9,LilyUPC:8,"Lucida Bright":9,"Lucida Calligraphy":11,"Lucida Console":10,"Lucida Fax":10,"Lucida Handwriting":11,"Lucida Sans":10,"Lucida Sans Typewriter":9,"Lucida Sans Unicode":10,"Magic R":9,Magneto:12,"Maiandra GD":10,"Malgun Gothic":9,"Malgun Gothic Semilight":9,Mangal:9,Marlett:16,"Matura MT Script Capitals":11,Meiryo:9,"Meiryo UI":10,"Microsoft GothicNeo":9,"Microsoft Himalaya":6,"Microsoft JhengHei":9,"Microsoft JhengHei Light":10,"Microsoft JhengHei UI":9,"Microsoft JhengHei UI Light":10,"Microsoft New Tai Lue":9,"Microsoft PhagsPa":9,"Microsoft Sans Serif":9,"Microsoft Tai Le":9,"Microsoft Uighur":6,"Microsoft YaHei Light":10,"Microsoft YaHei UI":9,"Microsoft YaHei UI Light":10,"Microsoft Yi Baiti":9,MingLiU:9,MingLiU_HKSCS:9,"MingLiU_HKSCS-ExtB":9,"MingLiU-ExtB":9,Miriam:9,"Miriam Fixed":10,Mistral:8,"Modern No. 20":8,"MoeumT R":9,"Mongolian Baiti":9,"Monotype Corsiva":8,MoolBoran:9,"MS Gothic":9,"MS Mincho":9,"MS Outlook":9,"MS PGothic":9,"MS PMincho":9,"MS Reference Sans Serif":11,"MS Reference Specialty":19,"MS UI Gothic":9,"MT Extra":16,"MV Boli":12,"Myanmar Text":9,Narkisim:7,"Neue Haas Grotesk Text Pro":9,"New Gulim":10,"News Gothic MT":9,"Niagara Engraved":5,"Niagara Solid":6,"Nirmala UI":9,"Nirmala UI Semilight":9,Nyala:9,"OCR A Extended":10,OCRB:10,"Old English Text MT":9,Onyx:6,"Palace Script MT":6,"Palatino Linotype":8,Papyrus:10,Parchment:4,Perpetua:7,"Perpetua Titling MT":10,"Plantagenet Cherokee":9,Playbill:6,PMingLiU:8,"PMingLiU-ExtB":8,"Poor Richard":9,Pristina:9,"Pyunji R":8,Raavi:9,"Rage Italic":9,Ravie:15,Rockwell:8,"Rockwell Condensed":6,"Rockwell Extra Bold":10,"Rockwell Light":9,"Rockwell Nova":9,"Rockwell Nova Cond":9,"Rockwell Nova Cond Light":9,"Rockwell Nova Extra Bold":9,"Rockwell Nova Light":9,Rod:9,"Sakkal Majalla":9,"Sanskrit Text":9,"Script MT Bold":8,"Segoe MDL2 Assets":6,"Segoe Print":11,"Segoe Script":11,"Segoe UI":8,"Segoe UI Black":9,"Segoe UI Emoji":8,"Segoe UI Historic":8,"Segoe UI Light":8,"Segoe UI Semibold":9,"Segoe UI Semilight":8,"Segoe UI Symbol":8,Selawik:8,"Selawik Light":8,"Selawik Semibold":8,"Shonar Bangla":8,"Showcard Gothic":9,Shruti:8,"Simplified Arabic":8,"Simplified Arabic Fixed":8,"SimSun-ExtB":8,"Sitka Banner":8,"Sitka Display":8,"Sitka Heading":8,"Sitka Small":10,"Sitka Subheading":9,"Sitka Text":9,"Snap ITC":13,"Source Sans Pro":8,"Source Sans Pro Black":8,"Source Sans Pro ExtraLight":8,"Source Sans Pro Light":8,"Source Sans Pro SemiBold":8,Stencil:9,Sylfaen:8,Symbol:8,Tahoma:8,"Tempus Sans ITC":10,"TH SarabunPSK":8,"Times New Roman":7,"Traditional Arabic":8,"Trebuchet MS":8,Tunga:8,"Tw Cen MT":8,"Tw Cen MT Condensed":5,"Tw Cen MT Condensed Extra Bold":7,"UD Digi Kyokasho N-B":8,"UD Digi Kyokasho NK-B":8,"UD Digi Kyokasho NK-R":8,"UD Digi Kyokasho NP-B":8,"UD Digi Kyokasho NP-R":8,"UD Digi Kyokasho N-R":8,Univers:8,"Univers Condensed":8,"Univers Condensed Light":8,"Univers Light":8,"Urdu Typesetting":8,Utsaah:8,Vani:8,Verdana:10,"Verdana Pro":10,"Verdana Pro Black":8,"Verdana Pro Cond":8,"Verdana Pro Cond Black":8,"Verdana Pro Cond Light":8,"Verdana Pro Cond SemiBold":8,"Verdana Pro Light":8,"Verdana Pro SemiBold":8,Vijaya:8,"Viner Hand ITC":10,Vivaldi:6,"Vladimir Script":7,Vrinda:9,Webdings:15,"Wide Latin":19,Wingdings:20,"Wingdings 2":17,"Wingdings 3":13,"Yet R":8,"Yu Gothic":8,"Yu Gothic Light":8,"Yu Gothic Medium":8,"Yu Gothic UI":8,"Yu Gothic UI Light":8,"Yu Gothic UI Semibold":9,"Yu Gothic UI Semilight":8,"Yu Mincho":8,"Yu Mincho Demibold":8,"Yu Mincho Light":8,"\u4eff\u5b8b":8,"\u534e\u6587\u4e2d\u5b8b":9,"\u534e\u6587\u4eff\u5b8b":7,"\u534e\u6587\u5b8b\u4f53":7,"\u534e\u6587\u5f69\u4e91":9,"\u534e\u6587\u65b0\u9b4f":9,"\u534e\u6587\u6977\u4f53":7,"\u534e\u6587\u7425\u73c0":9,"\u534e\u6587\u7ec6\u9ed1":8,"\u534e\u6587\u884c\u6977":8,"\u534e\u6587\u96b6\u4e66":7,"\u5b8b\u4f53":8,"\u5e7c\u5706":8,"\u5fae\u8f6f\u96c5\u9ed1":9,"\u5fae\u8f6f\u96c5\u9ed1 Light":9,"\u65b0\u5b8b\u4f53":8,"\u65b9\u6b63\u59da\u4f53":8,"\u65b9\u6b63\u8212\u4f53":8,"\u6977\u4f53":8,"\u7b49\u7ebf":8,"\u7b49\u7ebf Light":8,"\u96b6\u4e66":8,"\u9ed1\u4f53":8,"\u6e38\u30b4\u30b7\u30c3\u30af":8,"\uff2d\uff33 \uff30\u660e\u671d":8,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':8,"\u30e1\u30a4\u30ea\u30aa":9,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":8,"HG\u660e\u671dB":8,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":8},12:{"Gill Sans MT":8,Abadi:10,"Abadi Extra Light":9,"Agency FB":6,Aharoni:7,Aldhabi:5,Algerian:10,"Ami R":7,"Angsana New":5,AngsanaUPC:5,Aparajita:6,"Arabic Typesetting":5,Arial:9,"Arial Black":11,"Arial Narrow":7,"Arial Nova":9,"Arial Nova Cond":8,"Arial Nova Cond Light":7,"Arial Nova Light":9,"Arial Rounded MT Bold":10,"Baskerville Old Face":8,Batang:9,BatangChe:8,"Bauhaus 93":9,"Bell MT":8,Bembo:8,"Berlin Sans FB":10,"Berlin Sans FB Demi":10,"Bernard MT Condensed":8,"Blackadder ITC":6,"Bodoni MT":8,"Bodoni MT Black":11,"Bodoni MT Condensed":5,"Bodoni MT Poster Compressed":6,"Book Antiqua":8,"Bookman Old Style":10,"Bookshelf Symbol 7":12,"Bradley Hand ITC":10,"Britannic Bold":10,Broadway:10,"Browallia New":6,BrowalliaUPC:6,"Brush Script MT":8,Calibri:8,"Calibri Light":8,"Californian FB":9,"Calisto MT":8,Cambria:9,"Cambria Math":9,Candara:9,Castellar:12,Centaur:8,Century:9,"Century Gothic":9,"Century Schoolbook":9,Chiller:8,"Colonna MT":8,"Comic Sans MS":10,Consolas:9,Constantia:9,"Cooper Black":10,"Copperplate Gothic Bold":11,"Copperplate Gothic Light":12,Corbel:8,"Cordia New":6,CordiaUPC:6,"Courier New":10,"Curlz MT":9,Dante:7,DaunPenh:5,David:7,DilleniaUPC:5,DokChampa:9,Dotum:8,DotumChe:8,Dubai:9,"Dubai Light":9,"Dubai Medium":9,Ebrima:9,"Edwardian Script ITC":8,Elephant:12,"Engravers MT":10,"Eras Bold ITC":10,"Eras Demi ITC":10,"Eras Light ITC":9,"Eras Medium ITC":9,EucrosiaUPC:6,Euphemia:9,"Expo M":14,FangSong:8,"Felix Titling":9,"Footlight MT Light":9,Forte:8,"Franklin Gothic Book":9,"Franklin Gothic Demi":9,"Franklin Gothic Demi Cond":8,"Franklin Gothic Heavy":9,"Franklin Gothic Medium":9,"Franklin Gothic Medium Cond":8,FrankRuehl:7,FreesiaUPC:7,"Freestyle Script":6,"French Script MT":6,Gabriola:6,Gadugi:9,Garamond:8,Gautami:10,Georgia:10,"Georgia Pro":9,"Georgia Pro Black":11,"Georgia Pro Cond":8,"Georgia Pro Cond Black":10,"Georgia Pro Cond Light":8,"Georgia Pro Cond Semibold":9,"Georgia Pro Light":9,"Georgia Pro Semibold":10,Gigi:7,"Gill Sans MT Condensed":6,"Gill Sans MT Ext Condensed Bold":6,"Gill Sans Nova":8,"Gill Sans Nova Cond":5,"Gill Sans Nova Cond Lt":5,"Gill Sans Nova Cond Ultra Bold":9,"Gill Sans Nova Cond XBd":8,"Gill Sans Nova Light":8,"Gill Sans Nova Ultra Bold":14,"Gill Sans Ultra Bold":14,"Gill Sans Ultra Bold Condensed":9,Gisha:9,"Gloucester MT Extra Condensed":6,"Goudy Old Style":8,"Goudy Stout":13,Grotesque:8,"Grotesque Light":8,Gulim:9,GulimChe:8,Gungsuh:9,GungsuhChe:8,"Hadassah Friedlaender":9,Haettenschweiler:7,"Harlow Solid Italic":7,Harrington:9,"Headline R":11,HGGothicE:8,HGGothicM:8,HGGyoshotai:8,HGKyokashotai:8,HGMaruGothicMPRO:12,HGMinchoB:9,HGMinchoE:9,HGPGothicE:10,HGPGothicM:10,HGPGyoshotai:9,HGPKyokashotai:8,HGPMinchoB:9,HGPMinchoE:9,HGPSoeiKakugothicUB:11,HGPSoeiKakupoptai:11,HGPSoeiPresenceEB:10,HGSeikaishotaiPRO:10,HGSGothicE:9,HGSGothicM:9,HGSGyoshotai:8,HGSKyokashotai:7,HGSMinchoB:9,HGSMinchoE:9,HGSoeiKakugothicUB:9,HGSoeiKakupoptai:9,HGSoeiPresenceEB:9,HGSSoeiKakugothicUB:10,HGSSoeiKakupoptai:10,HGSSoeiPresenceEB:9,"High Tower Text":8,"HYGothic-Extra":10,"HYGothic-Medium":9,"HYGraphic-Medium":9,"HYGungSo-Bold":9,"HYHeadLine-Medium":9,"HYMyeongJo-Extra":11,"HYPMokGak-Bold":11,"HYPost-Light":11,"HYPost-Medium":11,"HYShortSamul-Medium":6,"HYSinMyeongJo-Medium":10,Impact:9,"Imprint MT Shadow":8,"Informal Roman":9,"Ink Free":8,IrisUPC:8,"Iskoola Pota":8,JasmineUPC:8,"Javanese Text":9,Jokerman:11,"Juice ITC":6,KaiTi:8,Kalinga:9,Kartika:8,"Khmer UI":8,KodchiangUPC:5,Kokila:8,"Kristen ITC":10,"Kunstler Script":6,"Lao UI":8,Latha:8,Leelawadee:9,"Leelawadee UI":9,"Leelawadee UI Semilight":9,"Levenim MT":9,LilyUPC:7,"Lucida Bright":10,"Lucida Calligraphy":12,"Lucida Console":11,"Lucida Fax":11,"Lucida Handwriting":12,"Lucida Sans":11,"Lucida Sans Typewriter":10,"Lucida Sans Unicode":11,"Magic R":10,Magneto:12,"Maiandra GD":10,"Malgun Gothic":9,"Malgun Gothic Semilight":10,Mangal:9,Marlett:17,"Matura MT Script Capitals":12,Meiryo:11,"Meiryo UI":11,"Microsoft GothicNeo":9,"Microsoft Himalaya":6,"Microsoft JhengHei":10,"Microsoft JhengHei Light":10,"Microsoft JhengHei UI":10,"Microsoft JhengHei UI Light":10,"Microsoft New Tai Lue":9,"Microsoft PhagsPa":9,"Microsoft Sans Serif":10,"Microsoft Tai Le":9,"Microsoft Uighur":6,"Microsoft YaHei Light":10,"Microsoft YaHei UI":10,"Microsoft YaHei UI Light":10,"Microsoft Yi Baiti":9,MingLiU:9,MingLiU_HKSCS:9,"MingLiU_HKSCS-ExtB":9,"MingLiU-ExtB":9,Miriam:9,"Miriam Fixed":11,Mistral:8,"Modern No. 20":8,"MoeumT R":10,"Mongolian Baiti":9,"Monotype Corsiva":8,MoolBoran:7,"MS Gothic":9,"MS Mincho":9,"MS Outlook":9,"MS PGothic":9,"MS PMincho":9,"MS Reference Sans Serif":11,"MS Reference Specialty":20,"MS UI Gothic":9,"MT Extra":17,"MV Boli":12,"Myanmar Text":9,Narkisim:8,"Neue Haas Grotesk Text Pro":9,"New Gulim":10,"News Gothic MT":9,"Niagara Engraved":6,"Niagara Solid":6,"Nirmala UI":9,"Nirmala UI Semilight":10,Nyala:9,"OCR A Extended":11,OCRB:11,"Old English Text MT":9,Onyx:7,"Palace Script MT":6,"Palatino Linotype":8,Papyrus:10,Parchment:4,Perpetua:7,"Perpetua Titling MT":11,"Plantagenet Cherokee":9,Playbill:7,PMingLiU:9,"PMingLiU-ExtB":9,"Poor Richard":10,Pristina:9,"Pyunji R":9,Raavi:8,"Rage Italic":9,Ravie:16,Rockwell:9,"Rockwell Condensed":7,"Rockwell Extra Bold":11,"Rockwell Light":10,"Rockwell Nova":9,"Rockwell Nova Cond":9,"Rockwell Nova Cond Light":9,"Rockwell Nova Extra Bold":9,"Rockwell Nova Light":9,Rod:9,"Sakkal Majalla":9,"Sanskrit Text":9,"Script MT Bold":8,"Segoe MDL2 Assets":7,"Segoe Print":12,"Segoe Script":12,"Segoe UI":9,"Segoe UI Black":10,"Segoe UI Emoji":9,"Segoe UI Historic":9,"Segoe UI Light":8,"Segoe UI Semibold":9,"Segoe UI Semilight":9,"Segoe UI Symbol":9,Selawik:8,"Selawik Light":8,"Selawik Semibold":8,"Shonar Bangla":8,"Showcard Gothic":9,Shruti:8,"Simplified Arabic":8,"Simplified Arabic Fixed":8,"SimSun-ExtB":8,"Sitka Banner":8,"Sitka Display":8,"Sitka Heading":9,"Sitka Small":11,"Sitka Subheading":9,"Sitka Text":10,"Snap ITC":14,"Source Sans Pro":8,"Source Sans Pro Black":8,"Source Sans Pro ExtraLight":8,"Source Sans Pro Light":8,"Source Sans Pro SemiBold":8,Stencil:9,Sylfaen:8,Symbol:8,Tahoma:9,"Tempus Sans ITC":11,"TH SarabunPSK":8,"Times New Roman":8,"Traditional Arabic":8,"Trebuchet MS":8,Tunga:8,"Tw Cen MT":9,"Tw Cen MT Condensed":6,"Tw Cen MT Condensed Extra Bold":8,"UD Digi Kyokasho N-B":8,"UD Digi Kyokasho NK-B":8,"UD Digi Kyokasho NK-R":8,"UD Digi Kyokasho NP-B":8,"UD Digi Kyokasho NP-R":8,"UD Digi Kyokasho N-R":8,Univers:8,"Univers Condensed":8,"Univers Condensed Light":8,"Univers Light":8,"Urdu Typesetting":8,Utsaah:6,Vani:8,Verdana:10,"Verdana Pro":10,"Verdana Pro Black":8,"Verdana Pro Cond":8,"Verdana Pro Cond Black":8,"Verdana Pro Cond Light":8,"Verdana Pro Cond SemiBold":8,"Verdana Pro Light":8,"Verdana Pro SemiBold":8,Vijaya:8,"Viner Hand ITC":11,Vivaldi:7,"Vladimir Script":7,Vrinda:9,Webdings:16,"Wide Latin":20,Wingdings:22,"Wingdings 2":18,"Wingdings 3":14,"Yet R":9,"Yu Gothic":9,"Yu Gothic Light":9,"Yu Gothic Medium":9,"Yu Gothic UI":9,"Yu Gothic UI Light":9,"Yu Gothic UI Semibold":9,"Yu Gothic UI Semilight":9,"Yu Mincho":9,"Yu Mincho Demibold":8,"Yu Mincho Light":8,"\u4eff\u5b8b":8,"\u534e\u6587\u4e2d\u5b8b":10,"\u534e\u6587\u4eff\u5b8b":8,"\u534e\u6587\u5b8b\u4f53":8,"\u534e\u6587\u5f69\u4e91":9,"\u534e\u6587\u65b0\u9b4f":9,"\u534e\u6587\u6977\u4f53":8,"\u534e\u6587\u7425\u73c0":9,"\u534e\u6587\u7ec6\u9ed1":9,"\u534e\u6587\u884c\u6977":8,"\u534e\u6587\u96b6\u4e66":7,"\u5b8b\u4f53":8,"\u5e7c\u5706":8,"\u5fae\u8f6f\u96c5\u9ed1":9,"\u5fae\u8f6f\u96c5\u9ed1 Light":9,"\u65b0\u5b8b\u4f53":8,"\u65b9\u6b63\u59da\u4f53":8,"\u65b9\u6b63\u8212\u4f53":9,"\u6977\u4f53":8,"\u7b49\u7ebf":8,"\u7b49\u7ebf Light":8,"\u96b6\u4e66":8,"\u9ed1\u4f53":8,"\u6e38\u30b4\u30b7\u30c3\u30af":9,"\uff2d\uff33 \uff30\u660e\u671d":8,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':8,"\u30e1\u30a4\u30ea\u30aa":10,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":8,"HG\u660e\u671dB":8,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":8},14:{"Gill Sans MT":10,Abadi:11,"Abadi Extra Light":11,"Agency FB":8,Aharoni:8,Aldhabi:6,Algerian:11,"Ami R":8,"Angsana New":6,AngsanaUPC:6,Aparajita:8,"Arabic Typesetting":6,Arial:11,"Arial Black":13,"Arial Narrow":9,"Arial Nova":11,"Arial Nova Cond":10,"Arial Nova Cond Light":9,"Arial Nova Light":11,"Arial Rounded MT Bold":11,"Baskerville Old Face":9,Batang:10,BatangChe:10,"Bauhaus 93":11,"Bell MT":10,Bembo:9,"Berlin Sans FB":11,"Berlin Sans FB Demi":12,"Bernard MT Condensed":9,"Blackadder ITC":8,"Bodoni MT":9,"Bodoni MT Black":12,"Bodoni MT Condensed":6,"Bodoni MT Poster Compressed":6,"Book Antiqua":10,"Bookman Old Style":12,"Bookshelf Symbol 7":14,"Bradley Hand ITC":12,"Britannic Bold":12,Broadway:12,"Browallia New":7,BrowalliaUPC:7,"Brush Script MT":10,Calibri:10,"Calibri Light":10,"Californian FB":11,"Calisto MT":10,Cambria:11,"Cambria Math":11,Candara:10,Castellar:14,Centaur:9,Century:11,"Century Gothic":11,"Century Schoolbook":11,Chiller:9,"Colonna MT":10,"Comic Sans MS":12,Consolas:10,Constantia:10,"Cooper Black":11,"Copperplate Gothic Bold":14,"Copperplate Gothic Light":14,Corbel:10,"Cordia New":7,CordiaUPC:7,"Courier New":11,"Curlz MT":10,Dante:9,DaunPenh:6,David:8,DilleniaUPC:6,DokChampa:11,Dotum:10,DotumChe:10,Dubai:10,"Dubai Light":10,"Dubai Medium":10,Ebrima:10,"Edwardian Script ITC":9,Elephant:14,"Engravers MT":12,"Eras Bold ITC":12,"Eras Demi ITC":12,"Eras Light ITC":10,"Eras Medium ITC":11,EucrosiaUPC:8,Euphemia:11,"Expo M":16,FangSong:10,"Felix Titling":11,"Footlight MT Light":11,Forte:10,"Franklin Gothic Book":11,"Franklin Gothic Demi":11,"Franklin Gothic Demi Cond":10,"Franklin Gothic Heavy":11,"Franklin Gothic Medium":11,"Franklin Gothic Medium Cond":10,FrankRuehl:8,FreesiaUPC:8,"Freestyle Script":7,"French Script MT":7,Gabriola:8,Gadugi:10,Garamond:9,Gautami:11,Georgia:12,"Georgia Pro":11,"Georgia Pro Black":13,"Georgia Pro Cond":10,"Georgia Pro Cond Black":12,"Georgia Pro Cond Light":10,"Georgia Pro Cond Semibold":11,"Georgia Pro Light":10,"Georgia Pro Semibold":12,Gigi:10,"Gill Sans MT Condensed":7,"Gill Sans MT Ext Condensed Bold":7,"Gill Sans Nova":10,"Gill Sans Nova Cond":6,"Gill Sans Nova Cond Lt":6,"Gill Sans Nova Cond Ultra Bold":11,"Gill Sans Nova Cond XBd":10,"Gill Sans Nova Light":10,"Gill Sans Nova Ultra Bold":16,"Gill Sans Ultra Bold":16,"Gill Sans Ultra Bold Condensed":11,Gisha:10,"Gloucester MT Extra Condensed":7,"Goudy Old Style":10,"Goudy Stout":16,Grotesque:9,"Grotesque Light":9,Gulim:10,GulimChe:10,Gungsuh:10,GungsuhChe:10,"Hadassah Friedlaender":11,Haettenschweiler:8,"Harlow Solid Italic":9,Harrington:11,"Headline R":14,HGGothicE:10,HGGothicM:10,HGGyoshotai:10,HGKyokashotai:10,HGMaruGothicMPRO:14,HGMinchoB:11,HGMinchoE:11,HGPGothicE:11,HGPGothicM:12,HGPGyoshotai:10,HGPKyokashotai:10,HGPMinchoB:10,HGPMinchoE:11,HGPSoeiKakugothicUB:13,HGPSoeiKakupoptai:13,HGPSoeiPresenceEB:12,HGSeikaishotaiPRO:11,HGSGothicE:10,HGSGothicM:11,HGSGyoshotai:9,HGSKyokashotai:9,HGSMinchoB:10,HGSMinchoE:11,HGSoeiKakugothicUB:11,HGSoeiKakupoptai:11,HGSoeiPresenceEB:11,HGSSoeiKakugothicUB:12,HGSSoeiKakupoptai:12,HGSSoeiPresenceEB:11,"High Tower Text":9,"HYGothic-Extra":12,"HYGothic-Medium":11,"HYGraphic-Medium":11,"HYGungSo-Bold":11,"HYHeadLine-Medium":11,"HYMyeongJo-Extra":13,"HYPMokGak-Bold":13,"HYPost-Light":13,"HYPost-Medium":13,"HYShortSamul-Medium":7,"HYSinMyeongJo-Medium":12,Impact:10,"Imprint MT Shadow":10,"Informal Roman":10,"Ink Free":10,IrisUPC:10,"Iskoola Pota":10,JasmineUPC:10,"Javanese Text":11,Jokerman:14,"Juice ITC":7,KaiTi:10,Kalinga:11,Kartika:11,"Khmer UI":10,KodchiangUPC:7,Kokila:10,"Kristen ITC":11,"Kunstler Script":7,"Lao UI":10,Latha:10,Leelawadee:10,"Leelawadee UI":10,"Leelawadee UI Semilight":10,"Levenim MT":11,LilyUPC:8,"Lucida Bright":12,"Lucida Calligraphy":14,"Lucida Console":12,"Lucida Fax":13,"Lucida Handwriting":14,"Lucida Sans":13,"Lucida Sans Typewriter":11,"Lucida Sans Unicode":13,"Magic R":12,Magneto:15,"Maiandra GD":12,"Malgun Gothic":11,"Malgun Gothic Semilight":12,Mangal:11,Marlett:20,"Matura MT Script Capitals":13,Meiryo:13,"Meiryo UI":13,"Microsoft GothicNeo":11,"Microsoft Himalaya":7,"Microsoft JhengHei":11,"Microsoft JhengHei Light":12,"Microsoft JhengHei UI":11,"Microsoft JhengHei UI Light":12,"Microsoft New Tai Lue":11,"Microsoft PhagsPa":11,"Microsoft Sans Serif":11,"Microsoft Tai Le":11,"Microsoft Uighur":7,"Microsoft YaHei Light":12,"Microsoft YaHei UI":12,"Microsoft YaHei UI Light":12,"Microsoft Yi Baiti":11,MingLiU:11,MingLiU_HKSCS:11,"MingLiU_HKSCS-ExtB":11,"MingLiU-ExtB":11,Miriam:10,"Miriam Fixed":12,Mistral:10,"Modern No. 20":10,"MoeumT R":11,"Mongolian Baiti":11,"Monotype Corsiva":9,MoolBoran:8,"MS Gothic":11,"MS Mincho":11,"MS Outlook":11,"MS PGothic":11,"MS PMincho":11,"MS Reference Sans Serif":13,"MS Reference Specialty":24,"MS UI Gothic":11,"MT Extra":20,"MV Boli":14,"Myanmar Text":11,Narkisim:9,"Neue Haas Grotesk Text Pro":11,"New Gulim":12,"News Gothic MT":12,"Niagara Engraved":7,"Niagara Solid":7,"Nirmala UI":11,"Nirmala UI Semilight":11,Nyala:11,"OCR A Extended":12,OCRB:12,"Old English Text MT":11,Onyx:7,"Palace Script MT":7,"Palatino Linotype":10,Papyrus:12,Parchment:5,Perpetua:9,"Perpetua Titling MT":13,"Plantagenet Cherokee":11,Playbill:8,PMingLiU:10,"PMingLiU-ExtB":10,"Poor Richard":11,Pristina:10,"Pyunji R":10,Raavi:10,"Rage Italic":11,Ravie:19,Rockwell:10,"Rockwell Condensed":8,"Rockwell Extra Bold":13,"Rockwell Light":11,"Rockwell Nova":11,"Rockwell Nova Cond":11,"Rockwell Nova Cond Light":11,"Rockwell Nova Extra Bold":11,"Rockwell Nova Light":11,Rod:11,"Sakkal Majalla":11,"Sanskrit Text":12,"Script MT Bold":10,"Segoe MDL2 Assets":8,"Segoe Print":14,"Segoe Script":14,"Segoe UI":10,"Segoe UI Black":12,"Segoe UI Emoji":10,"Segoe UI Historic":10,"Segoe UI Light":10,"Segoe UI Semibold":11,"Segoe UI Semilight":10,"Segoe UI Symbol":10,Selawik:10,"Selawik Light":10,"Selawik Semibold":10,"Shonar Bangla":10,"Showcard Gothic":11,Shruti:11,"Simplified Arabic":10,"Simplified Arabic Fixed":11,"SimSun-ExtB":10,"Sitka Banner":10,"Sitka Display":10,"Sitka Heading":11,"Sitka Small":13,"Sitka Subheading":11,"Sitka Text":12,"Snap ITC":16,"Source Sans Pro":9,"Source Sans Pro Black":10,"Source Sans Pro ExtraLight":9,"Source Sans Pro Light":10,"Source Sans Pro SemiBold":10,Stencil:11,Sylfaen:10,Symbol:10,Tahoma:10,"Tempus Sans ITC":13,"TH SarabunPSK":7,"Times New Roman":10,"Traditional Arabic":10,"Trebuchet MS":10,Tunga:10,"Tw Cen MT":10,"Tw Cen MT Condensed":7,"Tw Cen MT Condensed Extra Bold":9,"UD Digi Kyokasho N-B":10,"UD Digi Kyokasho NK-B":10,"UD Digi Kyokasho NK-R":10,"UD Digi Kyokasho NP-B":10,"UD Digi Kyokasho NP-R":10,"UD Digi Kyokasho N-R":10,Univers:10,"Univers Condensed":10,"Univers Condensed Light":8,"Univers Light":10,"Urdu Typesetting":10,Utsaah:8,Vani:11,Verdana:12,"Verdana Pro":12,"Verdana Pro Black":10,"Verdana Pro Cond":10,"Verdana Pro Cond Black":10,"Verdana Pro Cond Light":10,"Verdana Pro Cond SemiBold":10,"Verdana Pro Light":10,"Verdana Pro SemiBold":10,Vijaya:10,"Viner Hand ITC":13,Vivaldi:8,"Vladimir Script":9,Vrinda:11,Webdings:19,"Wide Latin":24,Wingdings:26,"Wingdings 2":22,"Wingdings 3":17,"Yet R":10,"Yu Gothic":11,"Yu Gothic Light":10,"Yu Gothic Medium":11,"Yu Gothic UI":10,"Yu Gothic UI Light":10,"Yu Gothic UI Semibold":11,"Yu Gothic UI Semilight":10,"Yu Mincho":10,"Yu Mincho Demibold":10,"Yu Mincho Light":10,"\u4eff\u5b8b":10,"\u534e\u6587\u4e2d\u5b8b":12,"\u534e\u6587\u4eff\u5b8b":9,"\u534e\u6587\u5b8b\u4f53":9,"\u534e\u6587\u5f69\u4e91":11,"\u534e\u6587\u65b0\u9b4f":11,"\u534e\u6587\u6977\u4f53":9,"\u534e\u6587\u7425\u73c0":11,"\u534e\u6587\u7ec6\u9ed1":11,"\u534e\u6587\u884c\u6977":10,"\u534e\u6587\u96b6\u4e66":8,"\u5b8b\u4f53":10,"\u5e7c\u5706":10,"\u5fae\u8f6f\u96c5\u9ed1":11,"\u5fae\u8f6f\u96c5\u9ed1 Light":11,"\u65b0\u5b8b\u4f53":10,"\u65b9\u6b63\u59da\u4f53":10,"\u65b9\u6b63\u8212\u4f53":10,"\u6977\u4f53":10,"\u7b49\u7ebf":10,"\u7b49\u7ebf Light":10,"\u96b6\u4e66":10,"\u9ed1\u4f53":10,"\u6e38\u30b4\u30b7\u30c3\u30af":11,"\uff2d\uff33 \uff30\u660e\u671d":10,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':10,"\u30e1\u30a4\u30ea\u30aa":12,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":10,"HG\u660e\u671dB":10,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":10},16:{"Gill Sans MT":11,Abadi:13,"Abadi Extra Light":12,"Agency FB":9,Aharoni:9,Aldhabi:7,Algerian:13,"Ami R":9,"Angsana New":7,AngsanaUPC:7,Aparajita:8,"Arabic Typesetting":7,Arial:12,"Arial Black":14,"Arial Narrow":10,"Arial Nova":12,"Arial Nova Cond":11,"Arial Nova Cond Light":9,"Arial Nova Light":12,"Arial Rounded MT Bold":12,"Baskerville Old Face":10,Batang:10,BatangChe:11,"Bauhaus 93":12,"Bell MT":11,Bembo:10,"Berlin Sans FB":13,"Berlin Sans FB Demi":13,"Bernard MT Condensed":10,"Blackadder ITC":8,"Bodoni MT":10,"Bodoni MT Black":14,"Bodoni MT Condensed":7,"Bodoni MT Poster Compressed":7,"Book Antiqua":11,"Bookman Old Style":13,"Bookshelf Symbol 7":16,"Bradley Hand ITC":14,"Britannic Bold":13,Broadway:14,"Browallia New":8,BrowalliaUPC:8,"Brush Script MT":11,Calibri:11,"Calibri Light":11,"Californian FB":12,"Calisto MT":11,Cambria:12,"Cambria Math":12,Candara:12,Castellar:15,Centaur:10,Century:12,"Century Gothic":12,"Century Schoolbook":12,Chiller:10,"Colonna MT":11,"Comic Sans MS":13,Consolas:12,Constantia:11,"Cooper Black":13,"Copperplate Gothic Bold":15,"Copperplate Gothic Light":15,Corbel:11,"Cordia New":8,CordiaUPC:8,"Courier New":13,"Curlz MT":11,Dante:9,DaunPenh:7,David:9,DilleniaUPC:7,DokChampa:12,Dotum:11,DotumChe:11,Dubai:11,"Dubai Light":11,"Dubai Medium":11,Ebrima:11,"Edwardian Script ITC":10,Elephant:16,"Engravers MT":14,"Eras Bold ITC":14,"Eras Demi ITC":13,"Eras Light ITC":11,"Eras Medium ITC":12,EucrosiaUPC:9,Euphemia:12,"Expo M":18,FangSong:11,"Felix Titling":12,"Footlight MT Light":12,Forte:11,"Franklin Gothic Book":12,"Franklin Gothic Demi":12,"Franklin Gothic Demi Cond":11,"Franklin Gothic Heavy":12,"Franklin Gothic Medium":12,"Franklin Gothic Medium Cond":11,FrankRuehl:9,FreesiaUPC:9,"Freestyle Script":8,"French Script MT":8,Gabriola:8,Gadugi:11,Garamond:10,Gautami:13,Georgia:13,"Georgia Pro":12,"Georgia Pro Black":15,"Georgia Pro Cond":11,"Georgia Pro Cond Black":13,"Georgia Pro Cond Light":11,"Georgia Pro Cond Semibold":12,"Georgia Pro Light":12,"Georgia Pro Semibold":13,Gigi:12,"Gill Sans MT Condensed":8,"Gill Sans MT Ext Condensed Bold":7,"Gill Sans Nova":11,"Gill Sans Nova Cond":7,"Gill Sans Nova Cond Lt":6,"Gill Sans Nova Cond Ultra Bold":12,"Gill Sans Nova Cond XBd":11,"Gill Sans Nova Light":11,"Gill Sans Nova Ultra Bold":18,"Gill Sans Ultra Bold":18,"Gill Sans Ultra Bold Condensed":12,Gisha:11,"Gloucester MT Extra Condensed":8,"Goudy Old Style":11,"Goudy Stout":17,Grotesque:10,"Grotesque Light":10,Gulim:11,GulimChe:11,Gungsuh:11,GungsuhChe:11,"Hadassah Friedlaender":12,Haettenschweiler:9,"Harlow Solid Italic":10,Harrington:12,"Headline R":15,HGGothicE:11,HGGothicM:11,HGGyoshotai:11,HGKyokashotai:11,HGMaruGothicMPRO:16,HGMinchoB:12,HGMinchoE:12,HGPGothicE:12,HGPGothicM:13,HGPGyoshotai:11,HGPKyokashotai:11,HGPMinchoB:11,HGPMinchoE:12,HGPSoeiKakugothicUB:14,HGPSoeiKakupoptai:15,HGPSoeiPresenceEB:13,HGSeikaishotaiPRO:12,HGSGothicE:11,HGSGothicM:12,HGSGyoshotai:10,HGSKyokashotai:10,HGSMinchoB:11,HGSMinchoE:12,HGSoeiKakugothicUB:12,HGSoeiKakupoptai:12,HGSoeiPresenceEB:12,HGSSoeiKakugothicUB:13,HGSSoeiKakupoptai:14,HGSSoeiPresenceEB:12,"High Tower Text":10,"HYGothic-Extra":13,"HYGothic-Medium":12,"HYGraphic-Medium":12,"HYGungSo-Bold":12,"HYHeadLine-Medium":12,"HYMyeongJo-Extra":14,"HYPMokGak-Bold":15,"HYPost-Light":14,"HYPost-Medium":15,"HYShortSamul-Medium":8,"HYSinMyeongJo-Medium":13,Impact:11,"Imprint MT Shadow":11,"Informal Roman":11,"Ink Free":11,IrisUPC:11,"Iskoola Pota":11,JasmineUPC:10,"Javanese Text":12,Jokerman:15,"Juice ITC":8,KaiTi:11,Kalinga:12,Kartika:12,"Khmer UI":11,KodchiangUPC:7,Kokila:8,"Kristen ITC":13,"Kunstler Script":7,"Lao UI":11,Latha:11,Leelawadee:11,"Leelawadee UI":11,"Leelawadee UI Semilight":12,"Levenim MT":12,LilyUPC:9,"Lucida Bright":13,"Lucida Calligraphy":15,"Lucida Console":14,"Lucida Fax":14,"Lucida Handwriting":15,"Lucida Sans":14,"Lucida Sans Typewriter":13,"Lucida Sans Unicode":14,"Magic R":13,Magneto:16,"Maiandra GD":13,"Malgun Gothic":12,"Malgun Gothic Semilight":13,Mangal:12,Marlett:22,"Matura MT Script Capitals":15,Meiryo:14,"Meiryo UI":14,"Microsoft GothicNeo":12,"Microsoft Himalaya":8,"Microsoft JhengHei":13,"Microsoft JhengHei Light":13,"Microsoft JhengHei UI":13,"Microsoft JhengHei UI Light":13,"Microsoft New Tai Lue":12,"Microsoft PhagsPa":12,"Microsoft Sans Serif":13,"Microsoft Tai Le":12,"Microsoft Uighur":8,"Microsoft YaHei Light":13,"Microsoft YaHei UI":13,"Microsoft YaHei UI Light":13,"Microsoft Yi Baiti":12,MingLiU:12,MingLiU_HKSCS:12,"MingLiU_HKSCS-ExtB":12,"MingLiU-ExtB":12,Miriam:11,"Miriam Fixed":14,Mistral:10,"Modern No. 20":11,"MoeumT R":13,"Mongolian Baiti":12,"Monotype Corsiva":10,MoolBoran:8,"MS Gothic":12,"MS Mincho":12,"MS Outlook":12,"MS PGothic":12,"MS PMincho":12,"MS Reference Sans Serif":14,"MS Reference Specialty":26,"MS UI Gothic":12,"MT Extra":22,"MV Boli":16,"Myanmar Text":12,Narkisim:10,"Neue Haas Grotesk Text Pro":12,"New Gulim":13,"News Gothic MT":14,"Niagara Engraved":8,"Niagara Solid":8,"Nirmala UI":12,"Nirmala UI Semilight":13,Nyala:12,"OCR A Extended":14,OCRB:14,"Old English Text MT":12,Onyx:8,"Palace Script MT":8,"Palatino Linotype":11,Papyrus:14,Parchment:5,Perpetua:10,"Perpetua Titling MT":14,"Plantagenet Cherokee":12,Playbill:8,PMingLiU:11,"PMingLiU-ExtB":11,"Poor Richard":13,Pristina:11,"Pyunji R":11,Raavi:11,"Rage Italic":12,Ravie:21,Rockwell:11,"Rockwell Condensed":9,"Rockwell Extra Bold":14,"Rockwell Light":12,"Rockwell Nova":12,"Rockwell Nova Cond":12,"Rockwell Nova Cond Light":12,"Rockwell Nova Extra Bold":12,"Rockwell Nova Light":12,Rod:12,"Sakkal Majalla":12,"Sanskrit Text":13,"Script MT Bold":11,"Segoe MDL2 Assets":8,"Segoe Print":15,"Segoe Script":15,"Segoe UI":11,"Segoe UI Black":13,"Segoe UI Emoji":11,"Segoe UI Historic":11,"Segoe UI Light":11,"Segoe UI Semibold":12,"Segoe UI Semilight":11,"Segoe UI Symbol":11,Selawik:11,"Selawik Light":11,"Selawik Semibold":12,"Shonar Bangla":11,"Showcard Gothic":12,Shruti:13,"Simplified Arabic":11,"Simplified Arabic Fixed":13,"SimSun-ExtB":11,"Sitka Banner":11,"Sitka Display":11,"Sitka Heading":12,"Sitka Small":14,"Sitka Subheading":12,"Sitka Text":13,"Snap ITC":18,"Source Sans Pro":10,"Source Sans Pro Black":11,"Source Sans Pro ExtraLight":10,"Source Sans Pro Light":11,"Source Sans Pro SemiBold":11,Stencil:12,Sylfaen:11,Symbol:11,Tahoma:11,"Tempus Sans ITC":14,"TH SarabunPSK":8,"Times New Roman":11,"Traditional Arabic":10,"Trebuchet MS":11,Tunga:11,"Tw Cen MT":12,"Tw Cen MT Condensed":8,"Tw Cen MT Condensed Extra Bold":10,"UD Digi Kyokasho N-B":11,"UD Digi Kyokasho NK-B":11,"UD Digi Kyokasho NK-R":11,"UD Digi Kyokasho NP-B":11,"UD Digi Kyokasho NP-R":11,"UD Digi Kyokasho N-R":11,Univers:11,"Univers Condensed":11,"Univers Condensed Light":9,"Univers Light":11,"Urdu Typesetting":11,Utsaah:8,Vani:13,Verdana:13,"Verdana Pro":13,"Verdana Pro Black":11,"Verdana Pro Cond":11,"Verdana Pro Cond Black":11,"Verdana Pro Cond Light":11,"Verdana Pro Cond SemiBold":11,"Verdana Pro Light":11,"Verdana Pro SemiBold":11,Vijaya:11,"Viner Hand ITC":14,Vivaldi:9,"Vladimir Script":10,Vrinda:12,Webdings:21,"Wide Latin":26,Wingdings:28,"Wingdings 2":24,"Wingdings 3":19,"Yet R":11,"Yu Gothic":12,"Yu Gothic Light":11,"Yu Gothic Medium":12,"Yu Gothic UI":11,"Yu Gothic UI Light":11,"Yu Gothic UI Semibold":12,"Yu Gothic UI Semilight":12,"Yu Mincho":11,"Yu Mincho Demibold":11,"Yu Mincho Light":11,"\u4eff\u5b8b":11,"\u534e\u6587\u4e2d\u5b8b":13,"\u534e\u6587\u4eff\u5b8b":10,"\u534e\u6587\u5b8b\u4f53":10,"\u534e\u6587\u5f69\u4e91":12,"\u534e\u6587\u65b0\u9b4f":12,"\u534e\u6587\u6977\u4f53":10,"\u534e\u6587\u7425\u73c0":12,"\u534e\u6587\u7ec6\u9ed1":12,"\u534e\u6587\u884c\u6977":11,"\u534e\u6587\u96b6\u4e66":9,"\u5b8b\u4f53":11,"\u5e7c\u5706":11,"\u5fae\u8f6f\u96c5\u9ed1":12,"\u5fae\u8f6f\u96c5\u9ed1 Light":12,"\u65b0\u5b8b\u4f53":11,"\u65b9\u6b63\u59da\u4f53":11,"\u65b9\u6b63\u8212\u4f53":11,"\u6977\u4f53":11,"\u7b49\u7ebf":11,"\u7b49\u7ebf Light":11,"\u96b6\u4e66":11,"\u9ed1\u4f53":11,"\u6e38\u30b4\u30b7\u30c3\u30af":12,"\uff2d\uff33 \uff30\u660e\u671d":11,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':11,"\u30e1\u30a4\u30ea\u30aa":13,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":11,"HG\u660e\u671dB":11,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":11},18:{"Gill Sans MT":12,Abadi:15,"Abadi Extra Light":13,"Agency FB":10,Aharoni:10,Aldhabi:8,Algerian:14,"Ami R":10,"Angsana New":8,AngsanaUPC:8,Aparajita:10,"Arabic Typesetting":8,Arial:13,"Arial Black":16,"Arial Narrow":11,"Arial Nova":13,"Arial Nova Cond":12,"Arial Nova Cond Light":11,"Arial Nova Light":13,"Arial Rounded MT Bold":14,"Baskerville Old Face":12,Batang:12,BatangChe:12,"Bauhaus 93":14,"Bell MT":12,Bembo:12,"Berlin Sans FB":14,"Berlin Sans FB Demi":15,"Bernard MT Condensed":12,"Blackadder ITC":9,"Bodoni MT":12,"Bodoni MT Black":16,"Bodoni MT Condensed":8,"Bodoni MT Poster Compressed":8,"Book Antiqua":12,"Bookman Old Style":15,"Bookshelf Symbol 7":18,"Bradley Hand ITC":15,"Britannic Bold":15,Broadway:16,"Browallia New":9,BrowalliaUPC:9,"Brush Script MT":12,Calibri:12,"Calibri Light":12,"Californian FB":13,"Calisto MT":12,Cambria:13,"Cambria Math":13,Candara:13,Castellar:17,Centaur:12,Century:13,"Century Gothic":13,"Century Schoolbook":13,Chiller:11,"Colonna MT":12,"Comic Sans MS":15,Consolas:13,Constantia:13,"Cooper Black":14,"Copperplate Gothic Bold":17,"Copperplate Gothic Light":17,Corbel:13,"Cordia New":9,CordiaUPC:9,"Courier New":14,"Curlz MT":13,Dante:11,DaunPenh:8,David:11,DilleniaUPC:7,DokChampa:13,Dotum:13,DotumChe:12,Dubai:13,"Dubai Light":13,"Dubai Medium":13,Ebrima:13,"Edwardian Script ITC":11,Elephant:18,"Engravers MT":16,"Eras Bold ITC":16,"Eras Demi ITC":15,"Eras Light ITC":13,"Eras Medium ITC":14,EucrosiaUPC:10,Euphemia:14,"Expo M":21,FangSong:12,"Felix Titling":14,"Footlight MT Light":13,Forte:13,"Franklin Gothic Book":14,"Franklin Gothic Demi":14,"Franklin Gothic Demi Cond":12,"Franklin Gothic Heavy":14,"Franklin Gothic Medium":14,"Franklin Gothic Medium Cond":12,FrankRuehl:10,FreesiaUPC:11,"Freestyle Script":9,"French Script MT":9,Gabriola:10,Gadugi:13,Garamond:11,Gautami:14,Georgia:15,"Georgia Pro":14,"Georgia Pro Black":17,"Georgia Pro Cond":13,"Georgia Pro Cond Black":15,"Georgia Pro Cond Light":12,"Georgia Pro Cond Semibold":13,"Georgia Pro Light":13,"Georgia Pro Semibold":15,Gigi:12,"Gill Sans MT Condensed":9,"Gill Sans MT Ext Condensed Bold":8,"Gill Sans Nova":12,"Gill Sans Nova Cond":8,"Gill Sans Nova Cond Lt":7,"Gill Sans Nova Cond Ultra Bold":14,"Gill Sans Nova Cond XBd":13,"Gill Sans Nova Light":12,"Gill Sans Nova Ultra Bold":20,"Gill Sans Ultra Bold":21,"Gill Sans Ultra Bold Condensed":14,Gisha:13,"Gloucester MT Extra Condensed":9,"Goudy Old Style":12,"Goudy Stout":20,Grotesque:12,"Grotesque Light":12,Gulim:13,GulimChe:12,Gungsuh:13,GungsuhChe:12,"Hadassah Friedlaender":14,Haettenschweiler:11,"Harlow Solid Italic":11,Harrington:13,"Headline R":17,HGGothicE:12,HGGothicM:12,HGGyoshotai:12,HGKyokashotai:12,HGMaruGothicMPRO:18,HGMinchoB:13,HGMinchoE:13,HGPGothicE:14,HGPGothicM:15,HGPGyoshotai:12,HGPKyokashotai:12,HGPMinchoB:12,HGPMinchoE:13,HGPSoeiKakugothicUB:16,HGPSoeiKakupoptai:17,HGPSoeiPresenceEB:14,HGSeikaishotaiPRO:14,HGSGothicE:13,HGSGothicM:14,HGSGyoshotai:11,HGSKyokashotai:11,HGSMinchoB:12,HGSMinchoE:13,HGSoeiKakugothicUB:13,HGSoeiKakupoptai:13,HGSoeiPresenceEB:13,HGSSoeiKakugothicUB:15,HGSSoeiKakupoptai:16,HGSSoeiPresenceEB:13,"High Tower Text":12,"HYGothic-Extra":15,"HYGothic-Medium":14,"HYGraphic-Medium":14,"HYGungSo-Bold":14,"HYHeadLine-Medium":14,"HYMyeongJo-Extra":16,"HYPMokGak-Bold":17,"HYPost-Light":16,"HYPost-Medium":17,"HYShortSamul-Medium":9,"HYSinMyeongJo-Medium":15,Impact:13,"Imprint MT Shadow":12,"Informal Roman":13,"Ink Free":12,IrisUPC:12,"Iskoola Pota":12,JasmineUPC:11,"Javanese Text":14,Jokerman:17,"Juice ITC":8,KaiTi:12,Kalinga:13,Kartika:14,"Khmer UI":13,KodchiangUPC:8,Kokila:9,"Kristen ITC":14,"Kunstler Script":8,"Lao UI":13,Latha:12,Leelawadee:13,"Leelawadee UI":13,"Leelawadee UI Semilight":13,"Levenim MT":14,LilyUPC:11,"Lucida Bright":15,"Lucida Calligraphy":17,"Lucida Console":15,"Lucida Fax":16,"Lucida Handwriting":17,"Lucida Sans":16,"Lucida Sans Typewriter":14,"Lucida Sans Unicode":16,"Magic R":14,Magneto:19,"Maiandra GD":15,"Malgun Gothic":14,"Malgun Gothic Semilight":14,Mangal:14,Marlett:25,"Matura MT Script Capitals":17,Meiryo:16,"Meiryo UI":16,"Microsoft GothicNeo":13,"Microsoft Himalaya":9,"Microsoft JhengHei":14,"Microsoft JhengHei Light":15,"Microsoft JhengHei UI":14,"Microsoft JhengHei UI Light":15,"Microsoft New Tai Lue":14,"Microsoft PhagsPa":14,"Microsoft Sans Serif":14,"Microsoft Tai Le":14,"Microsoft Uighur":9,"Microsoft YaHei Light":15,"Microsoft YaHei UI":15,"Microsoft YaHei UI Light":15,"Microsoft Yi Baiti":13,MingLiU:13,MingLiU_HKSCS:13,"MingLiU_HKSCS-ExtB":13,"MingLiU-ExtB":13,Miriam:12,"Miriam Fixed":15,Mistral:12,"Modern No. 20":12,"MoeumT R":14,"Mongolian Baiti":13,"Monotype Corsiva":12,MoolBoran:9,"MS Gothic":13,"MS Mincho":13,"MS Outlook":13,"MS PGothic":13,"MS PMincho":13,"MS Reference Sans Serif":16,"MS Reference Specialty":30,"MS UI Gothic":13,"MT Extra":25,"MV Boli":18,"Myanmar Text":14,Narkisim:11,"Neue Haas Grotesk Text Pro":13,"New Gulim":15,"News Gothic MT":16,"Niagara Engraved":9,"Niagara Solid":9,"Nirmala UI":14,"Nirmala UI Semilight":14,Nyala:13,"OCR A Extended":15,OCRB:15,"Old English Text MT":13,Onyx:9,"Palace Script MT":9,"Palatino Linotype":12,Papyrus:15,Parchment:6,Perpetua:11,"Perpetua Titling MT":16,"Plantagenet Cherokee":13,Playbill:10,PMingLiU:12,"PMingLiU-ExtB":12,"Poor Richard":14,Pristina:13,"Pyunji R":13,Raavi:12,"Rage Italic":13,Ravie:24,Rockwell:13,"Rockwell Condensed":10,"Rockwell Extra Bold":17,"Rockwell Light":14,"Rockwell Nova":13,"Rockwell Nova Cond":13,"Rockwell Nova Cond Light":13,"Rockwell Nova Extra Bold":13,"Rockwell Nova Light":13,Rod:15,"Sakkal Majalla":10,"Sanskrit Text":15,"Script MT Bold":13,"Segoe MDL2 Assets":10,"Segoe Print":18,"Segoe Script":18,"Segoe UI":13,"Segoe UI Black":15,"Segoe UI Emoji":13,"Segoe UI Historic":13,"Segoe UI Light":12,"Segoe UI Semibold":14,"Segoe UI Semilight":13,"Segoe UI Symbol":13,Selawik:12,"Selawik Light":13,"Selawik Semibold":14,"Shonar Bangla":12,"Showcard Gothic":14,Shruti:14,"Simplified Arabic":13,"Simplified Arabic Fixed":14,"SimSun-ExtB":12,"Sitka Banner":12,"Sitka Display":13,"Sitka Heading":13,"Sitka Small":16,"Sitka Subheading":14,"Sitka Text":15,"Snap ITC":21,"Source Sans Pro":12,"Source Sans Pro Black":12,"Source Sans Pro ExtraLight":11,"Source Sans Pro Light":12,"Source Sans Pro SemiBold":12,Stencil:14,Sylfaen:12,Symbol:12,Tahoma:13,"Tempus Sans ITC":16,"TH SarabunPSK":9,"Times New Roman":12,"Traditional Arabic":12,"Trebuchet MS":13,Tunga:13,"Tw Cen MT":13,"Tw Cen MT Condensed":9,"Tw Cen MT Condensed Extra Bold":12,"UD Digi Kyokasho N-B":12,"UD Digi Kyokasho NK-B":12,"UD Digi Kyokasho NK-R":12,"UD Digi Kyokasho NP-B":17,"UD Digi Kyokasho NP-R":12,"UD Digi Kyokasho N-R":12,Univers:12,"Univers Condensed":12,"Univers Condensed Light":11,"Univers Light":12,"Urdu Typesetting":12,Utsaah:10,Vani:15,Verdana:15,"Verdana Pro":15,"Verdana Pro Black":12,"Verdana Pro Cond":12,"Verdana Pro Cond Black":12,"Verdana Pro Cond Light":12,"Verdana Pro Cond SemiBold":12,"Verdana Pro Light":12,"Verdana Pro SemiBold":12,Vijaya:12,"Viner Hand ITC":16,Vivaldi:10,"Vladimir Script":11,Vrinda:14,Webdings:24,"Wide Latin":30,Wingdings:32,"Wingdings 2":27,"Wingdings 3":21,"Yet R":13,"Yu Gothic":13,"Yu Gothic Light":13,"Yu Gothic Medium":13,"Yu Gothic UI":13,"Yu Gothic UI Light":13,"Yu Gothic UI Semibold":14,"Yu Gothic UI Semilight":13,"Yu Mincho":13,"Yu Mincho Demibold":13,"Yu Mincho Light":12,"\u4eff\u5b8b":12,"\u534e\u6587\u4e2d\u5b8b":15,"\u534e\u6587\u4eff\u5b8b":11,"\u534e\u6587\u5b8b\u4f53":11,"\u534e\u6587\u5f69\u4e91":14,"\u534e\u6587\u65b0\u9b4f":14,"\u534e\u6587\u6977\u4f53":11,"\u534e\u6587\u7425\u73c0":14,"\u534e\u6587\u7ec6\u9ed1":13,"\u534e\u6587\u884c\u6977":12,"\u534e\u6587\u96b6\u4e66":11,"\u5b8b\u4f53":12,"\u5e7c\u5706":12,"\u5fae\u8f6f\u96c5\u9ed1":14,"\u5fae\u8f6f\u96c5\u9ed1 Light":14,"\u65b0\u5b8b\u4f53":12,"\u65b9\u6b63\u59da\u4f53":12,"\u65b9\u6b63\u8212\u4f53":13,"\u6977\u4f53":12,"\u7b49\u7ebf":13,"\u7b49\u7ebf Light":12,"\u96b6\u4e66":12,"\u9ed1\u4f53":12,"\u6e38\u30b4\u30b7\u30c3\u30af":13,"\uff2d\uff33 \uff30\u660e\u671d":12,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':12,"\u30e1\u30a4\u30ea\u30aa":15,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":12,"HG\u660e\u671dB":12,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":12},20:{"Gill Sans MT":14,Abadi:16,"Abadi Extra Light":15,"Agency FB":11,Aharoni:11,Aldhabi:9,Algerian:16,"Ami R":11,"Angsana New":9,AngsanaUPC:9,Aparajita:11,"Arabic Typesetting":9,Arial:15,"Arial Black":18,"Arial Narrow":12,"Arial Nova":15,"Arial Nova Cond":14,"Arial Nova Cond Light":12,"Arial Nova Light":15,"Arial Rounded MT Bold":16,"Baskerville Old Face":13,Batang:16,BatangChe:14,"Bauhaus 93":15,"Bell MT":14,Bembo:13,"Berlin Sans FB":16,"Berlin Sans FB Demi":17,"Bernard MT Condensed":13,"Blackadder ITC":11,"Bodoni MT":13,"Bodoni MT Black":18,"Bodoni MT Condensed":9,"Bodoni MT Poster Compressed":8,"Book Antiqua":14,"Bookman Old Style":17,"Bookshelf Symbol 7":20,"Bradley Hand ITC":17,"Britannic Bold":17,Broadway:17,"Browallia New":10,BrowalliaUPC:10,"Brush Script MT":14,Calibri:14,"Calibri Light":14,"Californian FB":14,"Calisto MT":14,Cambria:15,"Cambria Math":15,Candara:15,Castellar:19,Centaur:13,Century:15,"Century Gothic":15,"Century Schoolbook":15,Chiller:13,"Colonna MT":14,"Comic Sans MS":16,Consolas:15,Constantia:15,"Cooper Black":16,"Copperplate Gothic Bold":19,"Copperplate Gothic Light":19,Corbel:14,"Cordia New":10,CordiaUPC:10,"Courier New":16,"Curlz MT":15,Dante:12,DaunPenh:9,David:12,DilleniaUPC:8,DokChampa:15,Dotum:16,DotumChe:14,Dubai:15,"Dubai Light":15,"Dubai Medium":15,Ebrima:15,"Edwardian Script ITC":13,Elephant:20,"Engravers MT":17,"Eras Bold ITC":18,"Eras Demi ITC":16,"Eras Light ITC":14,"Eras Medium ITC":15,EucrosiaUPC:11,Euphemia:16,"Expo M":23,FangSong:14,"Felix Titling":16,"Footlight MT Light":15,Forte:14,"Franklin Gothic Book":16,"Franklin Gothic Demi":16,"Franklin Gothic Demi Cond":14,"Franklin Gothic Heavy":16,"Franklin Gothic Medium":16,"Franklin Gothic Medium Cond":14,FrankRuehl:11,FreesiaUPC:12,"Freestyle Script":10,"French Script MT":10,Gabriola:11,Gadugi:15,Garamond:13,Gautami:16,Georgia:17,"Georgia Pro":15,"Georgia Pro Black":19,"Georgia Pro Cond":14,"Georgia Pro Cond Black":17,"Georgia Pro Cond Light":14,"Georgia Pro Cond Semibold":15,"Georgia Pro Light":15,"Georgia Pro Semibold":17,Gigi:14,"Gill Sans MT Condensed":10,"Gill Sans MT Ext Condensed Bold":9,"Gill Sans Nova":14,"Gill Sans Nova Cond":9,"Gill Sans Nova Cond Lt":8,"Gill Sans Nova Cond Ultra Bold":16,"Gill Sans Nova Cond XBd":14,"Gill Sans Nova Light":14,"Gill Sans Nova Ultra Bold":23,"Gill Sans Ultra Bold":23,"Gill Sans Ultra Bold Condensed":16,Gisha:15,"Gloucester MT Extra Condensed":10,"Goudy Old Style":14,"Goudy Stout":22,Grotesque:13,"Grotesque Light":13,Gulim:16,GulimChe:14,Gungsuh:16,GungsuhChe:14,"Hadassah Friedlaender":15,Haettenschweiler:12,"Harlow Solid Italic":13,Harrington:15,"Headline R":19,HGGothicE:14,HGGothicM:14,HGGyoshotai:14,HGKyokashotai:14,HGMaruGothicMPRO:20,HGMinchoB:15,HGMinchoE:15,HGPGothicE:16,HGPGothicM:17,HGPGyoshotai:14,HGPKyokashotai:14,HGPMinchoB:14,HGPMinchoE:15,HGPSoeiKakugothicUB:18,HGPSoeiKakupoptai:19,HGPSoeiPresenceEB:16,HGSeikaishotaiPRO:16,HGSGothicE:15,HGSGothicM:16,HGSGyoshotai:13,HGSKyokashotai:13,HGSMinchoB:14,HGSMinchoE:15,HGSoeiKakugothicUB:15,HGSoeiKakupoptai:15,HGSoeiPresenceEB:15,HGSSoeiKakugothicUB:17,HGSSoeiKakupoptai:18,HGSSoeiPresenceEB:15,"High Tower Text":13,"HYGothic-Extra":17,"HYGothic-Medium":16,"HYGraphic-Medium":16,"HYGungSo-Bold":16,"HYHeadLine-Medium":16,"HYMyeongJo-Extra":18,"HYPMokGak-Bold":19,"HYPost-Light":18,"HYPost-Medium":19,"HYShortSamul-Medium":10,"HYSinMyeongJo-Medium":17,Impact:15,"Imprint MT Shadow":14,"Informal Roman":15,"Ink Free":14,IrisUPC:14,"Iskoola Pota":14,JasmineUPC:12,"Javanese Text":16,Jokerman:19,"Juice ITC":10,KaiTi:14,Kalinga:15,Kartika:16,"Khmer UI":15,KodchiangUPC:9,Kokila:10,"Kristen ITC":16,"Kunstler Script":10,"Lao UI":15,Latha:14,Leelawadee:15,"Leelawadee UI":15,"Leelawadee UI Semilight":15,"Levenim MT":15,LilyUPC:12,"Lucida Bright":16,"Lucida Calligraphy":19,"Lucida Console":17,"Lucida Fax":18,"Lucida Handwriting":19,"Lucida Sans":18,"Lucida Sans Typewriter":16,"Lucida Sans Unicode":18,"Magic R":16,Magneto:21,"Maiandra GD":17,"Malgun Gothic":16,"Malgun Gothic Semilight":16,Mangal:16,Marlett:28,"Matura MT Script Capitals":19,Meiryo:18,"Meiryo UI":18,"Microsoft GothicNeo":15,"Microsoft Himalaya":10,"Microsoft JhengHei":16,"Microsoft JhengHei Light":17,"Microsoft JhengHei UI":16,"Microsoft JhengHei UI Light":17,"Microsoft New Tai Lue":16,"Microsoft PhagsPa":16,"Microsoft Sans Serif":16,"Microsoft Tai Le":16,"Microsoft Uighur":10,"Microsoft YaHei Light":16,"Microsoft YaHei UI":17,"Microsoft YaHei UI Light":16,"Microsoft Yi Baiti":15,MingLiU:15,MingLiU_HKSCS:15,"MingLiU_HKSCS-ExtB":15,"MingLiU-ExtB":15,Miriam:14,"Miriam Fixed":17,Mistral:13,"Modern No. 20":13,"MoeumT R":16,"Mongolian Baiti":15,"Monotype Corsiva":13,MoolBoran:10,"MS Gothic":15,"MS Mincho":15,"MS Outlook":15,"MS PGothic":15,"MS PMincho":15,"MS Reference Sans Serif":18,"MS Reference Specialty":33,"MS UI Gothic":15,"MT Extra":29,"MV Boli":20,"Myanmar Text":16,Narkisim:12,"Neue Haas Grotesk Text Pro":15,"New Gulim":17,"News Gothic MT":18,"Niagara Engraved":9,"Niagara Solid":9,"Nirmala UI":16,"Nirmala UI Semilight":16,Nyala:15,"OCR A Extended":17,OCRB:17,"Old English Text MT":15,Onyx:9,"Palace Script MT":9,"Palatino Linotype":14,Papyrus:16,Parchment:7,Perpetua:12,"Perpetua Titling MT":18,"Plantagenet Cherokee":15,Playbill:11,PMingLiU:14,"PMingLiU-ExtB":14,"Poor Richard":16,Pristina:14,"Pyunji R":14,Raavi:14,"Rage Italic":15,Ravie:27,Rockwell:15,"Rockwell Condensed":12,"Rockwell Extra Bold":19,"Rockwell Light":15,"Rockwell Nova":15,"Rockwell Nova Cond":15,"Rockwell Nova Cond Light":15,"Rockwell Nova Extra Bold":15,"Rockwell Nova Light":15,Rod:17,"Sakkal Majalla":11,"Sanskrit Text":17,"Script MT Bold":14,"Segoe MDL2 Assets":11,"Segoe Print":20,"Segoe Script":20,"Segoe UI":15,"Segoe UI Black":17,"Segoe UI Emoji":15,"Segoe UI Historic":15,"Segoe UI Light":14,"Segoe UI Semibold":15,"Segoe UI Semilight":15,"Segoe UI Symbol":15,Selawik:14,"Selawik Light":14,"Selawik Semibold":15,"Shonar Bangla":14,"Showcard Gothic":16,Shruti:16,"Simplified Arabic":14,"Simplified Arabic Fixed":16,"SimSun-ExtB":14,"Sitka Banner":14,"Sitka Display":14,"Sitka Heading":15,"Sitka Small":18,"Sitka Subheading":16,"Sitka Text":17,"Snap ITC":23,"Source Sans Pro":13,"Source Sans Pro Black":14,"Source Sans Pro ExtraLight":12,"Source Sans Pro Light":12,"Source Sans Pro SemiBold":14,Stencil:16,Sylfaen:14,Symbol:14,Tahoma:15,"Tempus Sans ITC":18,"TH SarabunPSK":10,"Times New Roman":14,"Traditional Arabic":13,"Trebuchet MS":14,Tunga:14,"Tw Cen MT":15,"Tw Cen MT Condensed":10,"Tw Cen MT Condensed Extra Bold":13,"UD Digi Kyokasho N-B":14,"UD Digi Kyokasho NK-B":14,"UD Digi Kyokasho NK-R":14,"UD Digi Kyokasho NP-B":19,"UD Digi Kyokasho NP-R":14,"UD Digi Kyokasho N-R":14,Univers:14,"Univers Condensed":14,"Univers Condensed Light":12,"Univers Light":14,"Urdu Typesetting":14,Utsaah:11,Vani:17,Verdana:17,"Verdana Pro":17,"Verdana Pro Black":14,"Verdana Pro Cond":14,"Verdana Pro Cond Black":14,"Verdana Pro Cond Light":14,"Verdana Pro Cond SemiBold":14,"Verdana Pro Light":14,"Verdana Pro SemiBold":14,Vijaya:14,"Viner Hand ITC":18,Vivaldi:12,"Vladimir Script":13,Vrinda:16,Webdings:27,"Wide Latin":33,Wingdings:36,"Wingdings 2":31,"Wingdings 3":24,"Yet R":14,"Yu Gothic":15,"Yu Gothic Light":14,"Yu Gothic Medium":15,"Yu Gothic UI":15,"Yu Gothic UI Light":14,"Yu Gothic UI Semibold":16,"Yu Gothic UI Semilight":15,"Yu Mincho":15,"Yu Mincho Demibold":14,"Yu Mincho Light":14,"\u4eff\u5b8b":14,"\u534e\u6587\u4e2d\u5b8b":17,"\u534e\u6587\u4eff\u5b8b":13,"\u534e\u6587\u5b8b\u4f53":13,"\u534e\u6587\u5f69\u4e91":15,"\u534e\u6587\u65b0\u9b4f":16,"\u534e\u6587\u6977\u4f53":13,"\u534e\u6587\u7425\u73c0":15,"\u534e\u6587\u7ec6\u9ed1":15,"\u534e\u6587\u884c\u6977":14,"\u534e\u6587\u96b6\u4e66":12,"\u5b8b\u4f53":14,"\u5e7c\u5706":14,"\u5fae\u8f6f\u96c5\u9ed1":16,"\u5fae\u8f6f\u96c5\u9ed1 Light":15,"\u65b0\u5b8b\u4f53":14,"\u65b9\u6b63\u59da\u4f53":14,"\u65b9\u6b63\u8212\u4f53":15,"\u6977\u4f53":14,"\u7b49\u7ebf":14,"\u7b49\u7ebf Light":14,"\u96b6\u4e66":14,"\u9ed1\u4f53":14,"\u6e38\u30b4\u30b7\u30c3\u30af":15,"\uff2d\uff33 \uff30\u660e\u671d":14,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':14,"\u30e1\u30a4\u30ea\u30aa":17,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":14,"HG\u660e\u671dB":14,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":14},22:{"Gill Sans MT":15,Abadi:18,"Abadi Extra Light":16,"Agency FB":11,Aharoni:12,Aldhabi:9,Algerian:17,"Ami R":12,"Angsana New":10,AngsanaUPC:10,Aparajita:12,"Arabic Typesetting":10,Arial:16,"Arial Black":19,"Arial Narrow":13,"Arial Nova":16,"Arial Nova Cond":15,"Arial Nova Cond Light":13,"Arial Nova Light":16,"Arial Rounded MT Bold":17,"Baskerville Old Face":14,Batang:17,BatangChe:15,"Bauhaus 93":16,"Bell MT":15,Bembo:14,"Berlin Sans FB":17,"Berlin Sans FB Demi":18,"Bernard MT Condensed":14,"Blackadder ITC":11,"Bodoni MT":14,"Bodoni MT Black":19,"Bodoni MT Condensed":10,"Bodoni MT Poster Compressed":9,"Book Antiqua":15,"Bookman Old Style":18,"Bookshelf Symbol 7":21,"Bradley Hand ITC":19,"Britannic Bold":18,Broadway:19,"Browallia New":11,BrowalliaUPC:11,"Brush Script MT":15,Calibri:15,"Calibri Light":15,"Californian FB":15,"Calisto MT":15,Cambria:16,"Cambria Math":16,Candara:16,Castellar:21,Centaur:14,Century:16,"Century Gothic":16,"Century Schoolbook":16,Chiller:14,"Colonna MT":15,"Comic Sans MS":18,Consolas:16,Constantia:16,"Cooper Black":17,"Copperplate Gothic Bold":21,"Copperplate Gothic Light":21,Corbel:15,"Cordia New":11,CordiaUPC:11,"Courier New":17,"Curlz MT":16,Dante:13,DaunPenh:10,David:13,DilleniaUPC:9,DokChampa:16,Dotum:17,DotumChe:15,Dubai:16,"Dubai Light":16,"Dubai Medium":16,Ebrima:16,"Edwardian Script ITC":14,Elephant:22,"Engravers MT":19,"Eras Bold ITC":19,"Eras Demi ITC":18,"Eras Light ITC":16,"Eras Medium ITC":17,EucrosiaUPC:12,Euphemia:17,"Expo M":25,FangSong:15,"Felix Titling":17,"Footlight MT Light":16,Forte:15,"Franklin Gothic Book":17,"Franklin Gothic Demi":17,"Franklin Gothic Demi Cond":15,"Franklin Gothic Heavy":17,"Franklin Gothic Medium":17,"Franklin Gothic Medium Cond":15,FrankRuehl:12,FreesiaUPC:13,"Freestyle Script":10,"French Script MT":11,Gabriola:12,Gadugi:16,Garamond:14,Gautami:17,Georgia:18,"Georgia Pro":16,"Georgia Pro Black":21,"Georgia Pro Cond":15,"Georgia Pro Cond Black":18,"Georgia Pro Cond Light":15,"Georgia Pro Cond Semibold":16,"Georgia Pro Light":16,"Georgia Pro Semibold":18,Gigi:14,"Gill Sans MT Condensed":11,"Gill Sans MT Ext Condensed Bold":10,"Gill Sans Nova":15,"Gill Sans Nova Cond":10,"Gill Sans Nova Cond Lt":9,"Gill Sans Nova Cond Ultra Bold":17,"Gill Sans Nova Cond XBd":15,"Gill Sans Nova Light":15,"Gill Sans Nova Ultra Bold":25,"Gill Sans Ultra Bold":25,"Gill Sans Ultra Bold Condensed":17,Gisha:16,"Gloucester MT Extra Condensed":11,"Goudy Old Style":15,"Goudy Stout":24,Grotesque:14,"Grotesque Light":14,Gulim:17,GulimChe:15,Gungsuh:17,GungsuhChe:15,"Hadassah Friedlaender":17,Haettenschweiler:13,"Harlow Solid Italic":14,Harrington:16,"Headline R":21,HGGothicE:15,HGGothicM:15,HGGyoshotai:15,HGKyokashotai:15,HGMaruGothicMPRO:22,HGMinchoB:16,HGMinchoE:16,HGPGothicE:17,HGPGothicM:18,HGPGyoshotai:15,HGPKyokashotai:14,HGPMinchoB:15,HGPMinchoE:16,HGPSoeiKakugothicUB:19,HGPSoeiKakupoptai:20,HGPSoeiPresenceEB:17,HGSeikaishotaiPRO:17,HGSGothicE:16,HGSGothicM:17,HGSGyoshotai:14,HGSKyokashotai:13,HGSMinchoB:15,HGSMinchoE:16,HGSoeiKakugothicUB:16,HGSoeiKakupoptai:16,HGSoeiPresenceEB:16,HGSSoeiKakugothicUB:18,HGSSoeiKakupoptai:19,HGSSoeiPresenceEB:16,"High Tower Text":14,"HYGothic-Extra":18,"HYGothic-Medium":17,"HYGraphic-Medium":17,"HYGungSo-Bold":17,"HYHeadLine-Medium":17,"HYMyeongJo-Extra":19,"HYPMokGak-Bold":21,"HYPost-Light":19,"HYPost-Medium":21,"HYShortSamul-Medium":11,"HYSinMyeongJo-Medium":18,Impact:16,"Imprint MT Shadow":15,"Informal Roman":16,"Ink Free":15,IrisUPC:15,"Iskoola Pota":15,JasmineUPC:13,"Javanese Text":17,Jokerman:21,"Juice ITC":11,KaiTi:15,Kalinga:16,Kartika:17,"Khmer UI":16,KodchiangUPC:10,Kokila:11,"Kristen ITC":17,"Kunstler Script":10,"Lao UI":16,Latha:15,Leelawadee:16,"Leelawadee UI":16,"Leelawadee UI Semilight":16,"Levenim MT":17,LilyUPC:13,"Lucida Bright":18,"Lucida Calligraphy":20,"Lucida Console":18,"Lucida Fax":19,"Lucida Handwriting":21,"Lucida Sans":19,"Lucida Sans Typewriter":17,"Lucida Sans Unicode":19,"Magic R":17,Magneto:22,"Maiandra GD":18,"Malgun Gothic":17,"Malgun Gothic Semilight":17,Mangal:17,Marlett:30,"Matura MT Script Capitals":20,Meiryo:20,"Meiryo UI":20,"Microsoft GothicNeo":16,"Microsoft Himalaya":11,"Microsoft JhengHei":17,"Microsoft JhengHei Light":18,"Microsoft JhengHei UI":17,"Microsoft JhengHei UI Light":18,"Microsoft New Tai Lue":17,"Microsoft PhagsPa":17,"Microsoft Sans Serif":17,"Microsoft Tai Le":17,"Microsoft Uighur":11,"Microsoft YaHei Light":18,"Microsoft YaHei UI":18,"Microsoft YaHei UI Light":18,"Microsoft Yi Baiti":16,MingLiU:16,MingLiU_HKSCS:16,"MingLiU_HKSCS-ExtB":16,"MingLiU-ExtB":16,Miriam:15,"Miriam Fixed":18,Mistral:14,"Modern No. 20":14,"MoeumT R":17,"Mongolian Baiti":16,"Monotype Corsiva":14,MoolBoran:11,"MS Gothic":16,"MS Mincho":16,"MS Outlook":16,"MS PGothic":16,"MS PMincho":16,"MS Reference Sans Serif":19,"MS Reference Specialty":36,"MS UI Gothic":16,"MT Extra":31,"MV Boli":21,"Myanmar Text":17,Narkisim:13,"Neue Haas Grotesk Text Pro":16,"New Gulim":18,"News Gothic MT":19,"Niagara Engraved":10,"Niagara Solid":10,"Nirmala UI":17,"Nirmala UI Semilight":17,Nyala:16,"OCR A Extended":19,OCRB:18,"Old English Text MT":16,Onyx:10,"Palace Script MT":10,"Palatino Linotype":15,Papyrus:18,Parchment:7,Perpetua:13,"Perpetua Titling MT":20,"Plantagenet Cherokee":16,Playbill:11,PMingLiU:15,"PMingLiU-ExtB":15,"Poor Richard":17,Pristina:15,"Pyunji R":15,Raavi:15,"Rage Italic":16,Ravie:29,Rockwell:16,"Rockwell Condensed":12,"Rockwell Extra Bold":20,"Rockwell Light":16,"Rockwell Nova":16,"Rockwell Nova Cond":16,"Rockwell Nova Cond Light":16,"Rockwell Nova Extra Bold":16,"Rockwell Nova Light":16,Rod:18,"Sakkal Majalla":12,"Sanskrit Text":18,"Script MT Bold":15,"Segoe MDL2 Assets":12,"Segoe Print":21,"Segoe Script":21,"Segoe UI":16,"Segoe UI Black":18,"Segoe UI Emoji":16,"Segoe UI Historic":16,"Segoe UI Light":15,"Segoe UI Semibold":17,"Segoe UI Semilight":16,"Segoe UI Symbol":16,Selawik:15,"Selawik Light":15,"Selawik Semibold":16,"Shonar Bangla":15,"Showcard Gothic":17,Shruti:17,"Simplified Arabic":15,"Simplified Arabic Fixed":17,"SimSun-ExtB":15,"Sitka Banner":15,"Sitka Display":15,"Sitka Heading":16,"Sitka Small":20,"Sitka Subheading":17,"Sitka Text":18,"Snap ITC":25,"Source Sans Pro":14,"Source Sans Pro Black":15,"Source Sans Pro ExtraLight":13,"Source Sans Pro Light":13,"Source Sans Pro SemiBold":14,Stencil:17,Sylfaen:15,Symbol:15,Tahoma:16,"Tempus Sans ITC":19,"TH SarabunPSK":11,"Times New Roman":15,"Traditional Arabic":14,"Trebuchet MS":15,Tunga:15,"Tw Cen MT":16,"Tw Cen MT Condensed":11,"Tw Cen MT Condensed Extra Bold":14,"UD Digi Kyokasho N-B":15,"UD Digi Kyokasho NK-B":15,"UD Digi Kyokasho NK-R":15,"UD Digi Kyokasho NP-B":21,"UD Digi Kyokasho NP-R":15,"UD Digi Kyokasho N-R":15,Univers:15,"Univers Condensed":15,"Univers Condensed Light":13,"Univers Light":15,"Urdu Typesetting":15,Utsaah:12,Vani:18,Verdana:18,"Verdana Pro":18,"Verdana Pro Black":15,"Verdana Pro Cond":15,"Verdana Pro Cond Black":15,"Verdana Pro Cond Light":15,"Verdana Pro Cond SemiBold":15,"Verdana Pro Light":15,"Verdana Pro SemiBold":15,Vijaya:12,"Viner Hand ITC":20,Vivaldi:12,"Vladimir Script":13,Vrinda:17,Webdings:29,"Wide Latin":36,Wingdings:39,"Wingdings 2":33,"Wingdings 3":26,"Yet R":16,"Yu Gothic":16,"Yu Gothic Light":16,"Yu Gothic Medium":16,"Yu Gothic UI":16,"Yu Gothic UI Light":15,"Yu Gothic UI Semibold":17,"Yu Gothic UI Semilight":16,"Yu Mincho":16,"Yu Mincho Demibold":15,"Yu Mincho Light":15,"\u4eff\u5b8b":15,"\u534e\u6587\u4e2d\u5b8b":18,"\u534e\u6587\u4eff\u5b8b":14,"\u534e\u6587\u5b8b\u4f53":14,"\u534e\u6587\u5f69\u4e91":16,"\u534e\u6587\u65b0\u9b4f":17,"\u534e\u6587\u6977\u4f53":14,"\u534e\u6587\u7425\u73c0":16,"\u534e\u6587\u7ec6\u9ed1":16,"\u534e\u6587\u884c\u6977":15,"\u534e\u6587\u96b6\u4e66":13,"\u5b8b\u4f53":15,"\u5e7c\u5706":15,"\u5fae\u8f6f\u96c5\u9ed1":17,"\u5fae\u8f6f\u96c5\u9ed1 Light":17,"\u65b0\u5b8b\u4f53":15,"\u65b9\u6b63\u59da\u4f53":15,"\u65b9\u6b63\u8212\u4f53":16,"\u6977\u4f53":15,"\u7b49\u7ebf":15,"\u7b49\u7ebf Light":15,"\u96b6\u4e66":15,"\u9ed1\u4f53":15,"\u6e38\u30b4\u30b7\u30c3\u30af":16,"\uff2d\uff33 \uff30\u660e\u671d":15,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':15,"\u30e1\u30a4\u30ea\u30aa":18,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":15,"HG\u660e\u671dB":15,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":15},24:{"Gill Sans MT":16,Abadi:19,"Abadi Extra Light":18,"Agency FB":14,Aharoni:13,Aldhabi:10,Algerian:19,"Ami R":13,"Angsana New":11,AngsanaUPC:11,Aparajita:13,"Arabic Typesetting":11,Arial:18,"Arial Black":21,"Arial Narrow":15,"Arial Nova":18,"Arial Nova Cond":16,"Arial Nova Cond Light":14,"Arial Nova Light":18,"Arial Rounded MT Bold":19,"Baskerville Old Face":16,Batang:19,BatangChe:16,"Bauhaus 93":18,"Bell MT":16,Bembo:16,"Berlin Sans FB":19,"Berlin Sans FB Demi":20,"Bernard MT Condensed":16,"Blackadder ITC":13,"Bodoni MT":16,"Bodoni MT Black":21,"Bodoni MT Condensed":11,"Bodoni MT Poster Compressed":9,"Book Antiqua":16,"Bookman Old Style":20,"Bookshelf Symbol 7":24,"Bradley Hand ITC":21,"Britannic Bold":20,Broadway:21,"Browallia New":12,BrowalliaUPC:12,"Brush Script MT":16,Calibri:16,"Calibri Light":16,"Californian FB":17,"Calisto MT":16,Cambria:18,"Cambria Math":18,Candara:18,Castellar:23,Centaur:16,Century:18,"Century Gothic":18,"Century Schoolbook":18,Chiller:15,"Colonna MT":16,"Comic Sans MS":20,Consolas:18,Constantia:17,"Cooper Black":19,"Copperplate Gothic Bold":23,"Copperplate Gothic Light":23,Corbel:17,"Cordia New":12,CordiaUPC:12,"Courier New":19,"Curlz MT":17,Dante:14,DaunPenh:11,David:14,DilleniaUPC:10,DokChampa:18,Dotum:19,DotumChe:16,Dubai:17,"Dubai Light":17,"Dubai Medium":17,Ebrima:17,"Edwardian Script ITC":15,Elephant:24,"Engravers MT":21,"Eras Bold ITC":21,"Eras Demi ITC":20,"Eras Light ITC":17,"Eras Medium ITC":18,EucrosiaUPC:13,Euphemia:19,"Expo M":28,FangSong:16,"Felix Titling":19,"Footlight MT Light":18,Forte:17,"Franklin Gothic Book":19,"Franklin Gothic Demi":19,"Franklin Gothic Demi Cond":16,"Franklin Gothic Heavy":19,"Franklin Gothic Medium":19,"Franklin Gothic Medium Cond":16,FrankRuehl:13,FreesiaUPC:14,"Freestyle Script":12,"French Script MT":12,Gabriola:13,Gadugi:17,Garamond:15,Gautami:19,Georgia:20,"Georgia Pro":18,"Georgia Pro Black":23,"Georgia Pro Cond":17,"Georgia Pro Cond Black":20,"Georgia Pro Cond Light":16,"Georgia Pro Cond Semibold":18,"Georgia Pro Light":18,"Georgia Pro Semibold":20,Gigi:17,"Gill Sans MT Condensed":12,"Gill Sans MT Ext Condensed Bold":11,"Gill Sans Nova":16,"Gill Sans Nova Cond":11,"Gill Sans Nova Cond Lt":10,"Gill Sans Nova Cond Ultra Bold":19,"Gill Sans Nova Cond XBd":17,"Gill Sans Nova Light":16,"Gill Sans Nova Ultra Bold":27,"Gill Sans Ultra Bold":27,"Gill Sans Ultra Bold Condensed":19,Gisha:17,"Gloucester MT Extra Condensed":12,"Goudy Old Style":16,"Goudy Stout":26,Grotesque:15,"Grotesque Light":15,Gulim:18,GulimChe:16,Gungsuh:19,GungsuhChe:16,"Hadassah Friedlaender":18,Haettenschweiler:14,"Harlow Solid Italic":15,Harrington:18,"Headline R":23,HGGothicE:16,HGGothicM:16,HGGyoshotai:16,HGKyokashotai:16,HGMaruGothicMPRO:24,HGMinchoB:17,HGMinchoE:17,HGPGothicE:18,HGPGothicM:20,HGPGyoshotai:16,HGPKyokashotai:16,HGPMinchoB:16,HGPMinchoE:18,HGPSoeiKakugothicUB:21,HGPSoeiKakupoptai:22,HGPSoeiPresenceEB:19,HGSeikaishotaiPRO:19,HGSGothicE:17,HGSGothicM:19,HGSGyoshotai:15,HGSKyokashotai:15,HGSMinchoB:16,HGSMinchoE:18,HGSoeiKakugothicUB:17,HGSoeiKakupoptai:17,HGSoeiPresenceEB:17,HGSSoeiKakugothicUB:20,HGSSoeiKakupoptai:21,HGSSoeiPresenceEB:18,"High Tower Text":15,"HYGothic-Extra":20,"HYGothic-Medium":19,"HYGraphic-Medium":19,"HYGungSo-Bold":19,"HYHeadLine-Medium":19,"HYMyeongJo-Extra":21,"HYPMokGak-Bold":23,"HYPost-Light":21,"HYPost-Medium":23,"HYShortSamul-Medium":12,"HYSinMyeongJo-Medium":20,Impact:17,"Imprint MT Shadow":16,"Informal Roman":17,"Ink Free":16,IrisUPC:16,"Iskoola Pota":16,JasmineUPC:15,"Javanese Text":19,Jokerman:23,"Juice ITC":11,KaiTi:16,Kalinga:18,Kartika:18,"Khmer UI":17,KodchiangUPC:11,Kokila:12,"Kristen ITC":19,"Kunstler Script":11,"Lao UI":17,Latha:16,Leelawadee:17,"Leelawadee UI":17,"Leelawadee UI Semilight":18,"Levenim MT":18,LilyUPC:14,"Lucida Bright":19,"Lucida Calligraphy":22,"Lucida Console":20,"Lucida Fax":21,"Lucida Handwriting":23,"Lucida Sans":21,"Lucida Sans Typewriter":19,"Lucida Sans Unicode":21,"Magic R":19,Magneto:25,"Maiandra GD":20,"Malgun Gothic":19,"Malgun Gothic Semilight":19,Mangal:18,Marlett:33,"Matura MT Script Capitals":22,Meiryo:22,"Meiryo UI":22,"Microsoft GothicNeo":17,"Microsoft Himalaya":12,"Microsoft JhengHei":19,"Microsoft JhengHei Light":19,"Microsoft JhengHei UI":19,"Microsoft JhengHei UI Light":19,"Microsoft New Tai Lue":18,"Microsoft PhagsPa":18,"Microsoft Sans Serif":19,"Microsoft Tai Le":18,"Microsoft Uighur":12,"Microsoft YaHei Light":19,"Microsoft YaHei UI":20,"Microsoft YaHei UI Light":19,"Microsoft Yi Baiti":17,MingLiU:17,MingLiU_HKSCS:17,"MingLiU_HKSCS-ExtB":17,"MingLiU-ExtB":17,Miriam:16,"Miriam Fixed":20,Mistral:15,"Modern No. 20":16,"MoeumT R":19,"Mongolian Baiti":17,"Monotype Corsiva":15,MoolBoran:12,"MS Gothic":17,"MS Mincho":17,"MS Outlook":17,"MS PGothic":17,"MS PMincho":17,"MS Reference Sans Serif":21,"MS Reference Specialty":39,"MS UI Gothic":17,"MT Extra":34,"MV Boli":23,"Myanmar Text":18,Narkisim:14,"Neue Haas Grotesk Text Pro":17,"New Gulim":19,"News Gothic MT":21,"Niagara Engraved":11,"Niagara Solid":11,"Nirmala UI":18,"Nirmala UI Semilight":19,Nyala:17,"OCR A Extended":20,OCRB:20,"Old English Text MT":17,Onyx:10,"Palace Script MT":11,"Palatino Linotype":16,Papyrus:20,Parchment:8,Perpetua:15,"Perpetua Titling MT":22,"Plantagenet Cherokee":18,Playbill:12,PMingLiU:16,"PMingLiU-ExtB":16,"Poor Richard":19,Pristina:16,"Pyunji R":17,Raavi:16,"Rage Italic":18,Ravie:31,Rockwell:17,"Rockwell Condensed":14,"Rockwell Extra Bold":22,"Rockwell Light":18,"Rockwell Nova":17,"Rockwell Nova Cond":17,"Rockwell Nova Cond Light":17,"Rockwell Nova Extra Bold":17,"Rockwell Nova Light":17,Rod:20,"Sakkal Majalla":13,"Sanskrit Text":19,"Script MT Bold":17,"Segoe MDL2 Assets":13,"Segoe Print":23,"Segoe Script":23,"Segoe UI":17,"Segoe UI Black":20,"Segoe UI Emoji":17,"Segoe UI Historic":17,"Segoe UI Light":16,"Segoe UI Semibold":18,"Segoe UI Semilight":17,"Segoe UI Symbol":17,Selawik:17,"Selawik Light":17,"Selawik Semibold":18,"Shonar Bangla":13,"Showcard Gothic":19,Shruti:19,"Simplified Arabic":17,"Simplified Arabic Fixed":19,"SimSun-ExtB":16,"Sitka Banner":16,"Sitka Display":17,"Sitka Heading":18,"Sitka Small":22,"Sitka Subheading":19,"Sitka Text":20,"Snap ITC":28,"Source Sans Pro":15,"Source Sans Pro Black":17,"Source Sans Pro ExtraLight":15,"Source Sans Pro Light":15,"Source Sans Pro SemiBold":16,Stencil:18,Sylfaen:16,Symbol:16,Tahoma:17,"Tempus Sans ITC":21,"TH SarabunPSK":12,"Times New Roman":16,"Traditional Arabic":16,"Trebuchet MS":17,Tunga:17,"Tw Cen MT":18,"Tw Cen MT Condensed":12,"Tw Cen MT Condensed Extra Bold":16,"UD Digi Kyokasho N-B":16,"UD Digi Kyokasho NK-B":16,"UD Digi Kyokasho NK-R":16,"UD Digi Kyokasho NP-B":23,"UD Digi Kyokasho NP-R":16,"UD Digi Kyokasho N-R":16,Univers:16,"Univers Condensed":16,"Univers Condensed Light":14,"Univers Light":16,"Urdu Typesetting":16,Utsaah:13,Vani:20,Verdana:20,"Verdana Pro":20,"Verdana Pro Black":16,"Verdana Pro Cond":16,"Verdana Pro Cond Black":16,"Verdana Pro Cond Light":16,"Verdana Pro Cond SemiBold":16,"Verdana Pro Light":16,"Verdana Pro SemiBold":16,Vijaya:13,"Viner Hand ITC":22,Vivaldi:14,"Vladimir Script":15,Vrinda:18,Webdings:32,"Wide Latin":40,Wingdings:43,"Wingdings 2":36,"Wingdings 3":29,"Yet R":17,"Yu Gothic":18,"Yu Gothic Light":17,"Yu Gothic Medium":18,"Yu Gothic UI":17,"Yu Gothic UI Light":17,"Yu Gothic UI Semibold":18,"Yu Gothic UI Semilight":18,"Yu Mincho":17,"Yu Mincho Demibold":17,"Yu Mincho Light":16,"\u4eff\u5b8b":16,"\u534e\u6587\u4e2d\u5b8b":20,"\u534e\u6587\u4eff\u5b8b":15,"\u534e\u6587\u5b8b\u4f53":15,"\u534e\u6587\u5f69\u4e91":18,"\u534e\u6587\u65b0\u9b4f":19,"\u534e\u6587\u6977\u4f53":15,"\u534e\u6587\u7425\u73c0":18,"\u534e\u6587\u7ec6\u9ed1":18,"\u534e\u6587\u884c\u6977":16,"\u534e\u6587\u96b6\u4e66":14,"\u5b8b\u4f53":16,"\u5e7c\u5706":16,"\u5fae\u8f6f\u96c5\u9ed1":19,"\u5fae\u8f6f\u96c5\u9ed1 Light":18,"\u65b0\u5b8b\u4f53":16,"\u65b9\u6b63\u59da\u4f53":16,"\u65b9\u6b63\u8212\u4f53":18,"\u6977\u4f53":16,"\u7b49\u7ebf":17,"\u7b49\u7ebf Light":16,"\u96b6\u4e66":16,"\u9ed1\u4f53":16,"\u6e38\u30b4\u30b7\u30c3\u30af":18,"\uff2d\uff33 \uff30\u660e\u671d":16,'"\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af"':16,"\u30e1\u30a4\u30ea\u30aa":20,"HG\uff7a\uff9e\uff7c\uff6f\uff78E":16,"HG\u660e\u671dB":16,"HG\uff7a\uff9e\uff7c\uff6f\uff78M":16}},f.unknownFontMaxDigitWidthMap={},L.pixelToPoint=function(t){return 72*t/96},L.pointToPixel=function(t,n){return Me(96*t/72,n=void 0===n?2:n)},L.setMaxDigitWidth=function(t){var n,e,i,r,o,a,u,s,c,n=0;try{if((e=en("span")).style.font=t,i=e.style.fontSize,r=void 0,-1!==i.indexOf("px")?r=Math.round(L.pixelToPoint(parseFloat(i))):-1!==i.indexOf("pt")&&(r=Math.round(parseFloat(i))),!isNaN(r)&&r||(r=Math.round(L.pixelToPoint(parseFloat(t.match(/(\d|\.)+/)+"")))),(o=e.style.fontFamily)||t.split(" ").forEach(function(t){"normal"!==t&&"italic"!==t&&"bold"!==t&&-1===t.indexOf("px")&&-1===t.indexOf("pt")&&isNaN(+t)&&(o=t)}),o&&'"'===o[0]&&(o=o.slice(1,o.length-1)),f.unknownFontMaxDigitWidthMap[r]&&f.unknownFontMaxDigitWidthMap[r][o]?n=f.unknownFontMaxDigitWidthMap[r][o]:Qt[r]&&Qt[r][o]&&(n=Qt[r][o]),0<n)return void(L.maxDigitWidth=n)}catch(t){}for(a="0123456789",u=0,(s=j()).font=t,c=0;c<a.length;c++)n<(u=s.measureText(a.charAt(c)).width)&&(n=u);return L.maxDigitWidth=0<n?n:L.maxDigitWidth},L.defaultColumnWidthToPixel=function(t){var n,t,n=2*Math.ceil(L.maxDigitWidth/4)+1,t=L.columnWidthToPixel(t)+n;return 8*Math.ceil(t/8)},L.columnWidthToPixel=function(t){return 0===t?0:Math.floor(Math.floor(256*t)/256*L.maxDigitWidth+.5)},L.pixelToColumnWidth=function(t){var n,t;return 0===t?0:(n=L.maxDigitWidth,t=Math.floor((t-5)/n*100+.5)/100,Math.floor((t*n+5)/n*256)/256)},L.maxDigitWidth=7,f.SJSColumnWidthHelper=L,B.builtInNumberFomrat=function(){return 0===(B.Mh=B.Mh?B.Mh:{count:0}).count&&B.initBuintNumberFormat(),B.Mh},B.languageIndepedentNumberFormat=function(){return 0===(B.Ch=B.Ch?B.Ch:{count:0}).count&&B.initLanguageIndepedentNumberFormat(),B.Ch},B.formatCodeTable=function(){return B.Sh=B.Sh?B.Sh:[]},B.customNumberFormat=function(){return B.Th=B.Th?B.Th:{count:0}},B.getCultureInfo=function(){var t,n,t=Ce(),n;return t&&t.GC&&t.GC.Spread&&t.GC.Spread.Common&&Ce().GC.Spread.Common.CultureManager.getCultureInfo()||Xt()},B.initBuintNumberFormat=function(){var t,n,n,e,i,r,o,a,t=B.Mh;if(t[0]="General",t[1]="0",t[2]="0.00",t[3]="#,##0",t[4]="#,##0.00",t[9]="0%",t[10]="0.00%",t[11]="0.00E+00",t[12]="# ?/?",t[13]="# ??/??",t[14]="m/d/yyyy",t[15]="d-mmm-yy",t[16]="d-mmm",t[17]="mmm-yy",t[18]="h:mm AM/PM",t[19]="h:mm:ss AM/PM",t[20]="h:mm",t[21]="h:mm:ss",t[22]="m/d/yyyy h:mm",t[37]="#,##0 ;(#,##0)",t[38]="#,##0 ;[Red](#,##0)",t[39]="#,##0.00;(#,##0.00)",t[40]="#,##0.00;[Red](#,##0.00)",t[45]="mm:ss",t[46]="[h]:mm:ss",t[47]="mm:ss.0",t[48]="##0.0E+0",t[49]="@",t.count=49,Xt())if("zh-cn"===(n=Xt()))t[14]="yyyy/m/d",t[17]="mmm-yy",t[22]="yyyy/m/d h:mm",t[27]='yyyy"\u5e74"m"\u6708"',t[28]='m"\u6708"d"\u65e5"',t[29]='m"\u6708"d"\u65e5"',t[30]="m-d-yy",t[31]='yyyy"\u5e74"m"\u6708"d"\u65e5"',t[32]='h"\u65f6"mm"\u5206"',t[33]='h"\u65f6"mm"\u5206"ss"\u79d2"',t[34]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"',t[35]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"ss"\u79d2"',t[36]='yyyy"\u5e74"m"\u6708"',t[39]="#,##0.00;-#,##0.00",t[40]="#,##0.00;[Red]-#,##0.00",t[50]='yyyy"\u5e74"m"\u6708"',t[51]='m"\u6708"d"\u65e5"',t[52]='yyyy"\u5e74"m"\u6708"',t[53]='m"\u6708"d"\u65e5"',t[54]='m"\u6708"d"\u65e5"',t[55]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"',t[56]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"ss"\u79d2"',t[57]='yyyy"\u5e74"m"\u6708"',t[58]='m"\u6708"d"\u65e5"',t.count=58;else if("ja-jp"===n)t[14]="yyyy/m/d",t[15]="dd-mmm-yy",t[16]="dd-mmm",t[17]="mmm-yy",t[22]="yyyy/mm/dd h:mm",t[27]="[$-411]ge.m.d",t[28]='[$-411]ggge"\u5e74"m"\u6708"d"',t[29]='[$-411]ggge"\u5e74"m"\u6708"d"',t[30]="m/d/yy",t[31]='yyyy"\u5e74"m"\u6708"d"\u65e5"',t[32]='h"\u6642"mm"\u5206"',t[33]='h"\u6642"mm"\u5206"ss"\u79d2"',t[34]='yyyy"\u5e74"m"\u6708"',t[35]='m"\u6708"d"\u65e5"',t[36]="[$-411]ge.m.d",t[38]="#,##0;[Red]-#,##0",t[39]="#,##0.00;-#,##0.00",t[40]="#,##0.00;[Red]-#,##0.00",t[50]="[$-411]ge.m.d",t[51]='[$-411]ggge"\u5e74"m"\u6708"d"\u65e5"',t[52]='yyyy"\u5e74"m"\u6708"',t[53]='m"\u6708"d"\u65e5"',t[54]='[$-411]ggge"\u5e74"m"\u6708"d"\u65e5"',t[55]='yyyy"\u5e74"m"\u6708"',t[56]='m"\u6708"d"\u65e5"',t[57]="[$-411]ge.m.d",t[58]='[$-411]ggge"\u5e74"m"\u6708"d"\u65e5"',t.count=58;else if(e=(n=B.getCultureInfo())&&n.LocalNumberFormat,!A(e)&&!Array.isArray(e)&&"object"==typeof e){for(i in e)isNaN(Number(i))||(r=e[i],G.Util.uo(r)&&(t[i]=e[i]));for(i in o=0,t)isNaN(Number(i))||o<(a=Number(i))&&(o=a);t.count=o}},B.initLanguageIndepedentNumberFormat=function(){var t=B.Ch;t[27]="m/d/yyyy",t[28]="m/d/yyyy",t[29]="m/d/yyyy",t[30]="m/d/yyyy",t[31]="m/d/yyyy",t[32]="h:mm:ss",t[33]="h:mm:ss",t[34]="m/d/yyyy",t[35]="m/d/yyyy",t[36]="m/d/yyyy",t[50]="m/d/yyyy",t[51]="m/d/yyyy",t[52]="m/d/yyyy",t[53]="m/d/yyyy",t[54]="m/d/yyyy",t[55]="m/d/yyyy",t[56]="m/d/yyyy",t[57]="m/d/yyyy",t[58]="m/d/yyyy"},B.getFormatCode=function(t){var n,e,i,r,t,o,t,n=B.builtInNumberFomrat(),e=B.customNumberFormat(),i=B.languageIndepedentNumberFormat(),r=t.numberFormatIndex;return t.numberFormat?(o=(t=t.numberFormat).numberFormatId,t=t.numberFormatCode,n[o]&&n[o]!==t?n[o]=t:(e[t]||(e[t]=o,e.count++),t)):n[r]||i[r]||"General"},B.getFormatId=function(t){var n,e,i,r,o,a,u,s,n=B.Ah();if(n[t])return n[t];if(i=B.builtInNumberFomrat())for(r in i)if(i[r]===t)return e={isBuiltIn:!0,id:parseInt(r,10)},n[t]=e;if((o=B.customNumberFormat())&&o[t])return e={isBuiltIn:!1,id:o[t]},n[t]=e;if((a=0)<o.count){for(s in u=0,o)o[s]>u&&(u=o[s]);a=u}return a=Math.max(B.Ih,a)+1,B.Ih++,e={isBuiltIn:!1,id:o[t]=a}},B.Ah=function(){return B.xh=B.xh?B.xh:{}},B.Sh=null,B.xh=null,B.Mh={count:0},B.Ch={count:0},B.Th={count:0},B.Ih=170,f.ExtendedNumberFormatHelper=B,Xt=function(){var t=Ce();return t&&t.gcCultureObj},Se.prototype.equals=function(t){var n=this;return n===t||!!t&&n.numberFormatId===t.numberFormatId&&n.numberFormatCode===t.numberFormatCode},Se.prototype.compose=function(t){var n=this;n.numberFormatId===m&&(n.numberFormatId=t.numberFormatId),n.numberFormatCode===m&&(n.numberFormatCode=t.numberFormatCode)},Se.prototype.clone=function(){var t=this;return new Se(t.numberFormatId,t.numberFormatCode)},f.ExcelNumerFormat=Se,f.AL=Ae,f.resetFillStyle=Ie},"./dist/core/util/crypto.js":function(t,n){"use strict";var e,s,c,p,i,f,r,nt,l,o,a,h,u,d,v,m;function g(t,n){this.bits=t,this.init(n)}function b(t,n,e){var i,r,o,a,u,i=this;for(128<t.length&&(t=new l(n,!0).update(t).digest()),r=[],o=[],a=0;a<128;++a)u=t[a]||0,r[a]=92^u,o[a]=54^u;return(i=m.call(this,n,e)||this).update(o),i.oKeyPad=r,i.inner=!0,i.sharedMemory=e,i}for(e=this&&this.__extends||(v=function(t,n){return(v=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}v(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(n,"__esModule",{value:!0}),n.e1e=n.i1e=n.Qoe=void 0,s="input is invalid type",c="finalize already called",p="0123456789abcdef".split(""),i=[],f=[24,16,8,0],r=[-2147483648,8388608,32768,128],nt=[1116352408,3609767458,1899447441,602891725,3049323471,3964484399,3921009573,2173295548,961987163,4081628472,1508970993,3053834265,2453635748,2937671579,2870763221,3664609560,3624381080,2734883394,310598401,1164996542,607225278,1323610764,1426881987,3590304994,1925078388,4068182383,2162078206,991336113,2614888103,633803317,3248222580,3479774868,3835390401,2666613458,4022224774,944711139,264347078,2341262773,604807628,2007800933,770255983,1495990901,1249150122,1856431235,1555081692,3175218132,1996064986,2198950837,2554220882,3999719339,2821834349,766784016,2952996808,2566594879,3210313671,3203337956,3336571891,1034457026,3584528711,2466948901,113926993,3758326383,338241895,168717936,666307205,1188179964,773529912,1546045734,1294757372,1522805485,1396182291,2643833823,1695183700,2343527390,1986661051,1014477480,2177026350,1206759142,2456956037,344077627,2730485921,1290863460,2820302411,3158454273,3259730800,3505952657,3345764771,106217008,3516065817,3606008344,3600352804,1432725776,4094571909,1467031594,275423344,851169720,430227734,3100823752,506948616,1363258195,659060556,3750685593,883997877,3785050280,958139571,3318307427,1322822218,3812723403,1537002063,2003034995,1747873779,3602036899,1955562222,1575990012,2024104815,1125592928,2227730452,2716904306,2361852424,442776044,2428436474,593698344,2756734187,3733110249,3204031479,2999351573,3329325298,3815920427,3391569614,3928383900,3515267271,566280711,3940187606,3454069534,4118630271,4000239992,116418474,1914138554,174292421,2731055270,289380356,3203993006,460393269,320620315,685471733,587496836,852142971,1086792851,1017036298,365543100,1126000580,2618297676,1288033470,3409855158,1501505948,4234509866,1607167915,987167468,1816402316,1246189591],g.prototype.init=function(t){t?(i[0]=i[1]=i[2]=i[3]=i[4]=i[5]=i[6]=i[7]=i[8]=i[9]=i[10]=i[11]=i[12]=i[13]=i[14]=i[15]=i[16]=i[17]=i[18]=i[19]=i[20]=i[21]=i[22]=i[23]=i[24]=i[25]=i[26]=i[27]=i[28]=i[29]=i[30]=i[31]=i[32]=0,this.blocks=i):this.blocks=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var t=this.bits;384===t?(this.h0h=3418070365,this.h0l=3238371032,this.h1h=1654270250,this.h1l=914150663,this.h2h=2438529370,this.h2l=812702999,this.h3h=355462360,this.h3l=4144912697,this.h4h=1731405415,this.h4l=4290775857,this.h5h=2394180231,this.h5l=1750603025,this.h6h=3675008525,this.h6l=1694076839,this.h7h=1203062813,this.h7l=3204075428):256===t?(this.h0h=573645204,this.h0l=4230739756,this.h1h=2673172387,this.h1l=3360449730,this.h2h=596883563,this.h2l=1867755857,this.h3h=2520282905,this.h3l=1497426621,this.h4h=2519219938,this.h4l=2827943907,this.h5h=3193839141,this.h5l=1401305490,this.h6h=721525244,this.h6l=746961066,this.h7h=246885852,this.h7l=2177182882):224===t?(this.h0h=2352822216,this.h0l=424955298,this.h1h=1944164710,this.h1l=2312950998,this.h2h=502970286,this.h2l=855612546,this.h3h=1738396948,this.h3l=1479516111,this.h4h=258812777,this.h4l=2077511080,this.h5h=2011393907,this.h5l=79989058,this.h6h=1067287976,this.h6l=1780299464,this.h7h=286451373,this.h7l=2446758561):(this.h0h=1779033703,this.h0l=4089235720,this.h1h=3144134277,this.h1l=2227873595,this.h2h=1013904242,this.h2l=4271175723,this.h3h=2773480762,this.h3l=1595750129,this.h4h=1359893119,this.h4l=2917565137,this.h5h=2600822924,this.h5l=725511199,this.h6h=528734635,this.h6l=4215389547,this.h7h=1541459225,this.h7l=327033209),this.block=this.start=this.bytes=this.hBytes=0,this.finalized=this.hashed=!1},g.prototype.update=function(t){var n,e,i,r,o,a,u;if(this.finalized)throw new Error(c);if("string"!=(e=typeof t)){if("object"!=e)throw new Error(s);if(null===t)throw new Error(s);if(!Array.isArray(t)&&!ArrayBuffer.isView(t))throw new Error(s);n=!0}for(r=0,a=t.length,u=this.blocks;r<a;){if(this.hashed&&(this.hashed=!1,u[0]=this.block,u[1]=u[2]=u[3]=u[4]=u[5]=u[6]=u[7]=u[8]=u[9]=u[10]=u[11]=u[12]=u[13]=u[14]=u[15]=u[16]=u[17]=u[18]=u[19]=u[20]=u[21]=u[22]=u[23]=u[24]=u[25]=u[26]=u[27]=u[28]=u[29]=u[30]=u[31]=u[32]=0),n)for(o=this.start;r<a&&o<128;++r)u[o>>2]|=t[r]<<f[3&o++];else for(o=this.start;r<a&&o<128;++r)(i=t.charCodeAt(r))<128?u[o>>2]|=i<<f[3&o++]:(i<2048?u[o>>2]|=(192|i>>6)<<f[3&o++]:(i<55296||57344<=i?u[o>>2]|=(224|i>>12)<<f[3&o++]:(i=65536+((1023&i)<<10|1023&t.charCodeAt(++r)),u[o>>2]|=(240|i>>18)<<f[3&o++],u[o>>2]|=(128|i>>12&63)<<f[3&o++]),u[o>>2]|=(128|i>>6&63)<<f[3&o++]),u[o>>2]|=(128|63&i)<<f[3&o++]);this.lastByteIndex=o,this.bytes+=o-this.start,128<=o?(this.block=u[32],this.start=o-128,this.hash(),this.hashed=!0):this.start=o}return 4294967295<this.bytes&&(this.hBytes+=this.bytes/4294967296<<0,this.bytes=this.bytes%4294967296),this},g.prototype.finalize=function(){var t,n;this.finalized||(this.finalized=!0,t=this.blocks,n=this.lastByteIndex,t[32]=this.block,t[n>>2]|=r[3&n],this.block=t[32],112<=n&&(this.hashed||this.hash(),t[0]=this.block,t[1]=t[2]=t[3]=t[4]=t[5]=t[6]=t[7]=t[8]=t[9]=t[10]=t[11]=t[12]=t[13]=t[14]=t[15]=t[16]=t[17]=t[18]=t[19]=t[20]=t[21]=t[22]=t[23]=t[24]=t[25]=t[26]=t[27]=t[28]=t[29]=t[30]=t[31]=t[32]=0),t[30]=this.hBytes<<3|this.bytes>>>29,t[31]=this.bytes<<3,this.hash())},g.prototype.hash=function(){for(var L,B,F,P,G,U,H,V,z,Y,Z,W,Q,J,K,X,t,n,e,i,r,o,a,u,s,c,f,l,q,f,l,q,$,tt,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,E,O,R,L=this.h0h,B=this.h0l,F=this.h1h,P=this.h1l,G=this.h2h,U=this.h2l,H=this.h3h,V=this.h3l,z=this.h4h,Y=this.h4l,Z=this.h5h,W=this.h5l,Q=this.h6h,J=this.h6l,K=this.h7h,X=this.h7l,t=this.blocks,n=32;n<160;n+=2)e=((v=t[n-30])>>>1|(m=t[n-29])<<31)^(v>>>8|m<<24)^v>>>7,i=(m>>>1|v<<31)^(m>>>8|v<<24)^(m>>>7|v<<25),r=((v=t[n-4])>>>19|(m=t[n-3])<<13)^(m>>>29|v<<3)^v>>>6,o=(m>>>19|v<<13)^(v>>>29|m<<3)^(m>>>6|v<<26),v=t[n-32],m=t[n-31],g=t[n-14],p=t[n-13],t[n]=(c=(g>>>16)+(v>>>16)+(e>>>16)+(r>>>16)+((s=(65535&g)+(65535&v)+(65535&e)+(65535&r)+((u=(p>>>16)+(m>>>16)+(i>>>16)+(o>>>16)+((a=(65535&p)+(65535&m)+(65535&i)+(65535&o))>>>16))>>>16))>>>16))<<16|65535&s,t[n+1]=u<<16|65535&a;for(y=L,M=B,I=H,x=V,N=z,k=Y,_=Z,D=W,j=Q,E=J,O=K,R=X,$=(C=F)&(T=G),tt=(S=P)&(A=U),n=0;n<160;n+=8)v=t[n],m=t[n+1],v=(c=((g=nt[n])>>>16)+(v>>>16)+((b=N&_^~N&j)>>>16)+((r=(N>>>14|k<<18)^(N>>>18|k<<14)^(k>>>9|N<<23))>>>16)+(O>>>16)+((s=(65535&g)+(65535&v)+(65535&b)+(65535&r)+(65535&O)+((u=((p=nt[n+1])>>>16)+(m>>>16)+((w=k&D^~k&E)>>>16)+((o=(k>>>14|N<<18)^(k>>>18|N<<14)^(N>>>9|k<<23))>>>16)+(R>>>16)+((a=(65535&p)+(65535&m)+(65535&w)+(65535&o)+(65535&R))>>>16))>>>16))>>>16))<<16|65535&s,m=u<<16|65535&a,g=(c=((h=(f=y&C)^y&T^$)>>>16)+((e=(y>>>28|M<<4)^(M>>>2|y<<30)^(M>>>7|y<<25))>>>16)+((s=(65535&h)+(65535&e)+((u=((d=(l=M&S)^M&A^tt)>>>16)+((i=(M>>>28|y<<4)^(y>>>2|M<<30)^(y>>>7|M<<25))>>>16)+((a=(65535&d)+(65535&i))>>>16))>>>16))>>>16))<<16|65535&s,p=u<<16|65535&a,O=(c=(I>>>16)+(v>>>16)+((s=(65535&I)+(65535&v)+((u=(x>>>16)+(m>>>16)+((a=(65535&x)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,R=u<<16|65535&a,I=(c=(g>>>16)+(v>>>16)+((s=(65535&g)+(65535&v)+((u=(p>>>16)+(m>>>16)+((a=(65535&p)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,x=u<<16|65535&a,v=t[n+2],m=t[n+3],v=(c=((g=nt[n+2])>>>16)+(v>>>16)+((b=O&N^~O&_)>>>16)+((r=(O>>>14|R<<18)^(O>>>18|R<<14)^(R>>>9|O<<23))>>>16)+(j>>>16)+((s=(65535&g)+(65535&v)+(65535&b)+(65535&r)+(65535&j)+((u=((p=nt[n+3])>>>16)+(m>>>16)+((w=R&k^~R&D)>>>16)+((o=(R>>>14|O<<18)^(R>>>18|O<<14)^(O>>>9|R<<23))>>>16)+(E>>>16)+((a=(65535&p)+(65535&m)+(65535&w)+(65535&o)+(65535&E))>>>16))>>>16))>>>16))<<16|65535&s,m=u<<16|65535&a,g=(c=((h=(q=I&y)^I&C^f)>>>16)+((e=(I>>>28|x<<4)^(x>>>2|I<<30)^(x>>>7|I<<25))>>>16)+((s=(65535&h)+(65535&e)+((u=((d=(f=x&M)^x&S^l)>>>16)+((i=(x>>>28|I<<4)^(I>>>2|x<<30)^(I>>>7|x<<25))>>>16)+((a=(65535&d)+(65535&i))>>>16))>>>16))>>>16))<<16|65535&s,p=u<<16|65535&a,j=(c=(T>>>16)+(v>>>16)+((s=(65535&T)+(65535&v)+((u=(A>>>16)+(m>>>16)+((a=(65535&A)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,E=u<<16|65535&a,T=(c=(g>>>16)+(v>>>16)+((s=(65535&g)+(65535&v)+((u=(p>>>16)+(m>>>16)+((a=(65535&p)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,A=u<<16|65535&a,v=t[n+4],m=t[n+5],v=(c=((g=nt[n+4])>>>16)+(v>>>16)+((b=j&O^~j&N)>>>16)+((r=(j>>>14|E<<18)^(j>>>18|E<<14)^(E>>>9|j<<23))>>>16)+(_>>>16)+((s=(65535&g)+(65535&v)+(65535&b)+(65535&r)+(65535&_)+((u=((p=nt[n+5])>>>16)+(m>>>16)+((w=E&R^~E&k)>>>16)+((o=(E>>>14|j<<18)^(E>>>18|j<<14)^(j>>>9|E<<23))>>>16)+(D>>>16)+((a=(65535&p)+(65535&m)+(65535&w)+(65535&o)+(65535&D))>>>16))>>>16))>>>16))<<16|65535&s,m=u<<16|65535&a,g=(c=((h=(l=T&I)^T&y^q)>>>16)+((e=(T>>>28|A<<4)^(A>>>2|T<<30)^(A>>>7|T<<25))>>>16)+((s=(65535&h)+(65535&e)+((u=((d=(q=A&x)^A&M^f)>>>16)+((i=(A>>>28|T<<4)^(T>>>2|A<<30)^(T>>>7|A<<25))>>>16)+((a=(65535&d)+(65535&i))>>>16))>>>16))>>>16))<<16|65535&s,p=u<<16|65535&a,_=(c=(C>>>16)+(v>>>16)+((s=(65535&C)+(65535&v)+((u=(S>>>16)+(m>>>16)+((a=(65535&S)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,D=u<<16|65535&a,C=(c=(g>>>16)+(v>>>16)+((s=(65535&g)+(65535&v)+((u=(p>>>16)+(m>>>16)+((a=(65535&p)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,S=u<<16|65535&a,v=t[n+6],m=t[n+7],v=(c=((g=nt[n+6])>>>16)+(v>>>16)+((b=_&j^~_&O)>>>16)+((r=(_>>>14|D<<18)^(_>>>18|D<<14)^(D>>>9|_<<23))>>>16)+(N>>>16)+((s=(65535&g)+(65535&v)+(65535&b)+(65535&r)+(65535&N)+((u=((p=nt[n+7])>>>16)+(m>>>16)+((w=D&E^~D&R)>>>16)+((o=(D>>>14|_<<18)^(D>>>18|_<<14)^(_>>>9|D<<23))>>>16)+(k>>>16)+((a=(65535&p)+(65535&m)+(65535&w)+(65535&o)+(65535&k))>>>16))>>>16))>>>16))<<16|65535&s,m=u<<16|65535&a,g=(c=((h=($=C&T)^C&I^l)>>>16)+((e=(C>>>28|S<<4)^(S>>>2|C<<30)^(S>>>7|C<<25))>>>16)+((s=(65535&h)+(65535&e)+((u=((d=(tt=S&A)^S&x^q)>>>16)+((i=(S>>>28|C<<4)^(C>>>2|S<<30)^(C>>>7|S<<25))>>>16)+((a=(65535&d)+(65535&i))>>>16))>>>16))>>>16))<<16|65535&s,p=u<<16|65535&a,N=(c=(y>>>16)+(v>>>16)+((s=(65535&y)+(65535&v)+((u=(M>>>16)+(m>>>16)+((a=(65535&M)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,k=u<<16|65535&a,y=(c=(g>>>16)+(v>>>16)+((s=(65535&g)+(65535&v)+((u=(p>>>16)+(m>>>16)+((a=(65535&p)+(65535&m))>>>16))>>>16))>>>16))<<16|65535&s,M=u<<16|65535&a;this.h0h=(c=(L>>>16)+(y>>>16)+((s=(65535&L)+(65535&y)+((u=(B>>>16)+(M>>>16)+((a=(65535&B)+(65535&M))>>>16))>>>16))>>>16))<<16|65535&s,this.h0l=u<<16|65535&a,this.h1h=(c=(F>>>16)+(C>>>16)+((s=(65535&F)+(65535&C)+((u=(P>>>16)+(S>>>16)+((a=(65535&P)+(65535&S))>>>16))>>>16))>>>16))<<16|65535&s,this.h1l=u<<16|65535&a,this.h2h=(c=(G>>>16)+(T>>>16)+((s=(65535&G)+(65535&T)+((u=(U>>>16)+(A>>>16)+((a=(65535&U)+(65535&A))>>>16))>>>16))>>>16))<<16|65535&s,this.h2l=u<<16|65535&a,this.h3h=(c=(H>>>16)+(I>>>16)+((s=(65535&H)+(65535&I)+((u=(V>>>16)+(x>>>16)+((a=(65535&V)+(65535&x))>>>16))>>>16))>>>16))<<16|65535&s,this.h3l=u<<16|65535&a,this.h4h=(c=(z>>>16)+(N>>>16)+((s=(65535&z)+(65535&N)+((u=(Y>>>16)+(k>>>16)+((a=(65535&Y)+(65535&k))>>>16))>>>16))>>>16))<<16|65535&s,this.h4l=u<<16|65535&a,this.h5h=(c=(Z>>>16)+(_>>>16)+((s=(65535&Z)+(65535&_)+((u=(W>>>16)+(D>>>16)+((a=(65535&W)+(65535&D))>>>16))>>>16))>>>16))<<16|65535&s,this.h5l=u<<16|65535&a,this.h6h=(c=(Q>>>16)+(j>>>16)+((s=(65535&Q)+(65535&j)+((u=(J>>>16)+(E>>>16)+((a=(65535&J)+(65535&E))>>>16))>>>16))>>>16))<<16|65535&s,this.h6l=u<<16|65535&a,this.h7h=(c=(K>>>16)+(O>>>16)+((s=(65535&K)+(65535&O)+((u=(X>>>16)+(R>>>16)+((a=(65535&X)+(65535&R))>>>16))>>>16))>>>16))<<16|65535&s,this.h7l=u<<16|65535&a},g.prototype.hex=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,t;return this.finalize(),t=this.h0h,n=this.h0l,e=this.h1h,i=this.h1l,r=this.h2h,o=this.h2l,a=this.h3h,u=this.h3l,s=this.h4h,c=this.h4l,f=this.h5h,l=this.h5l,h=this.h6h,d=this.h6l,v=this.h7h,m=this.h7l,g=this.bits,t=p[t>>28&15]+p[t>>24&15]+p[t>>20&15]+p[t>>16&15]+p[t>>12&15]+p[t>>8&15]+p[t>>4&15]+p[15&t]+p[n>>28&15]+p[n>>24&15]+p[n>>20&15]+p[n>>16&15]+p[n>>12&15]+p[n>>8&15]+p[n>>4&15]+p[15&n]+p[e>>28&15]+p[e>>24&15]+p[e>>20&15]+p[e>>16&15]+p[e>>12&15]+p[e>>8&15]+p[e>>4&15]+p[15&e]+p[i>>28&15]+p[i>>24&15]+p[i>>20&15]+p[i>>16&15]+p[i>>12&15]+p[i>>8&15]+p[i>>4&15]+p[15&i]+p[r>>28&15]+p[r>>24&15]+p[r>>20&15]+p[r>>16&15]+p[r>>12&15]+p[r>>8&15]+p[r>>4&15]+p[15&r]+p[o>>28&15]+p[o>>24&15]+p[o>>20&15]+p[o>>16&15]+p[o>>12&15]+p[o>>8&15]+p[o>>4&15]+p[15&o]+p[a>>28&15]+p[a>>24&15]+p[a>>20&15]+p[a>>16&15]+p[a>>12&15]+p[a>>8&15]+p[a>>4&15]+p[15&a],256<=g&&(t+=p[u>>28&15]+p[u>>24&15]+p[u>>20&15]+p[u>>16&15]+p[u>>12&15]+p[u>>8&15]+p[u>>4&15]+p[15&u]),384<=g&&(t+=p[s>>28&15]+p[s>>24&15]+p[s>>20&15]+p[s>>16&15]+p[s>>12&15]+p[s>>8&15]+p[s>>4&15]+p[15&s]+p[c>>28&15]+p[c>>24&15]+p[c>>20&15]+p[c>>16&15]+p[c>>12&15]+p[c>>8&15]+p[c>>4&15]+p[15&c]+p[f>>28&15]+p[f>>24&15]+p[f>>20&15]+p[f>>16&15]+p[f>>12&15]+p[f>>8&15]+p[f>>4&15]+p[15&f]+p[l>>28&15]+p[l>>24&15]+p[l>>20&15]+p[l>>16&15]+p[l>>12&15]+p[l>>8&15]+p[l>>4&15]+p[15&l]),512===g&&(t+=p[h>>28&15]+p[h>>24&15]+p[h>>20&15]+p[h>>16&15]+p[h>>12&15]+p[h>>8&15]+p[h>>4&15]+p[15&h]+p[d>>28&15]+p[d>>24&15]+p[d>>20&15]+p[d>>16&15]+p[d>>12&15]+p[d>>8&15]+p[d>>4&15]+p[15&d]+p[v>>28&15]+p[v>>24&15]+p[v>>20&15]+p[v>>16&15]+p[v>>12&15]+p[v>>8&15]+p[v>>4&15]+p[15&v]+p[m>>28&15]+p[m>>24&15]+p[m>>20&15]+p[m>>16&15]+p[m>>12&15]+p[m>>8&15]+p[m>>4&15]+p[15&m]),t},g.prototype.digest=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,n,t;return this.finalize(),t=this.h0h,n=this.h0l,e=this.h1h,i=this.h1l,r=this.h2h,o=this.h2l,a=this.h3h,u=this.h3l,s=this.h4h,c=this.h4l,f=this.h5h,l=this.h5l,h=this.h6h,d=this.h6l,v=this.h7h,m=this.h7l,t=[t>>24&255,t>>16&255,t>>8&255,255&t,n>>24&255,n>>16&255,n>>8&255,255&n,e>>24&255,e>>16&255,e>>8&255,255&e,i>>24&255,i>>16&255,i>>8&255,255&i,r>>24&255,r>>16&255,r>>8&255,255&r,o>>24&255,o>>16&255,o>>8&255,255&o,a>>24&255,a>>16&255,a>>8&255,255&a],256<=(n=this.bits)&&t.push(u>>24&255,u>>16&255,u>>8&255,255&u),384<=n&&t.push(s>>24&255,s>>16&255,s>>8&255,255&s,c>>24&255,c>>16&255,c>>8&255,255&c,f>>24&255,f>>16&255,f>>8&255,255&f,l>>24&255,l>>16&255,l>>8&255,255&l),512===n&&t.push(h>>24&255,h>>16&255,h>>8&255,255&h,d>>24&255,d>>16&255,d>>8&255,255&d,v>>24&255,v>>16&255,v>>8&255,255&v,m>>24&255,m>>16&255,m>>8&255,255&m),t},g.prototype.arrayBuffer=function(){var t,n,e;return this.finalize(),t=this.bits,n=new ArrayBuffer(t/8),(e=new DataView(n)).setUint32(0,this.h0h),e.setUint32(4,this.h0l),e.setUint32(8,this.h1h),e.setUint32(12,this.h1l),e.setUint32(16,this.h2h),e.setUint32(20,this.h2l),e.setUint32(24,this.h3h),256<=t&&e.setUint32(28,this.h3l),384<=t&&(e.setUint32(32,this.h4h),e.setUint32(36,this.h4l),e.setUint32(40,this.h5h),e.setUint32(44,this.h5l)),512===t&&(e.setUint32(48,this.h6h),e.setUint32(52,this.h6l),e.setUint32(56,this.h7h),e.setUint32(60,this.h7l)),n},g.prototype.clone=function(){var t=new g(this.bits,!1);return this.copyTo(t),t},g.prototype.copyTo=function(t){for(var n,e=["h0h","h0l","h1h","h1l","h2h","h2l","h3h","h3l","h4h","h4l","h5h","h5l","h6h","h6l","h7h","h7l","start","bytes","hBytes","finalized","hashed","lastByteIndex"],n=0;n<e.length;++n)t[e[n]]=this[e[n]];for(n=0;n<this.blocks.length;++n)t.blocks[n]=this.blocks[n]},l=g,n.i1e=l,e(b,m=l),b.prototype.finalize=function(){var t;m.prototype.finalize.call(this),this.inner&&(this.inner=!1,t=this.digest(),this.init(this.sharedMemory),this.update(this.oKeyPad),this.update(t),m.prototype.finalize.call(this))},n.e1e=b,a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",h=new Uint8Array(255),u=0;u<a.length;u++)h[a.charCodeAt(u)]=u;function w(){}w.r1e=function(t){var n=new Uint8Array(4);return n[0]=255&t,n[1]=(65280&t)>>8,n[2]=(16711680&t)>>16,n[3]=(4278190080&t)>>24,n},w.Joe=function(t){var n,e,i,r,o,a,u,s,n,c,n=.75*t.length,e=t.length,r=0;for("="===t[t.length-1]&&(n--,"="===t[t.length-2])&&n--,n=new ArrayBuffer(n),c=new Uint8Array(n),i=0;i<e;i+=4)o=h[t.charCodeAt(i)],a=h[t.charCodeAt(i+1)],u=h[t.charCodeAt(i+2)],s=h[t.charCodeAt(i+3)],c[r++]=o<<2|a>>4,c[r++]=(15&a)<<4|u>>2,c[r++]=(3&u)<<6|63&s;return new Uint8Array(n)},w.Xoe=function(t){for(var n,e=t.length,i="",n=0;n<e;n+=3)i=(i=(i=(i+=a[t[n]>>2])+a[(3&t[n])<<4|t[n+1]>>4])+a[(15&t[n+1])<<2|t[n+2]>>6])+a[63&t[n+2]];return e%3==2?i=i.substring(0,i.length-1)+"=":e%3==1&&(i=i.substring(0,i.length-2)+"=="),i},w.qoe=function(t){for(var n,e,n=new DataView(new ArrayBuffer(2*t.length)),e=0;e<t.length;e++)n.setUint16(2*e,t.charCodeAt(e),!0);return new Uint8Array(n.buffer)},w.$oe=function(t,n){var e,i,e=t.length,i=new Uint8Array(e+n.length);return i.set(t,0),i.set(n,e),i},w.tue=function(t,n,e,i){for(var r,o,a,r,o=i(w.$oe(w.Joe(n),w.qoe(t))),a=0;a<e;a++)o=i(w.$oe(new Uint8Array(o),w.r1e(a)));return o},w.nue=function(t,n,e,i){return w.Xoe(new Uint8Array(w.tue(t,n,e,i)))},w.eue=function(t){var n;return new l(512,!0).update(t).arrayBuffer()},w.o1e=function(t){for(var n,e,n=new Uint8Array(256),e=0;e<=255;e++)n[e]=Date.now()*Math.random()+Date.now()&255;return new Uint8Array(w.eue(n)).slice(0,t)},w.iue=function(){for(var t,n,t=new Uint8Array(256),n=0;n<=255;n++)t[n]=Date.now()*Math.random()+Date.now()&255;return w.Xoe(w.o1e(16))},w.rue=function(t,n,e,i,r){var o;return w.nue(t,e,i,r)===n},w.a1e=function(t,n,e){for(var i,r,i=0,r=e;r<n+e;r++)i+=t[r]*(1<<8*(r-e));return i},n.Qoe=w},"./dist/core/util/domUtil.js":function(r,t,n){"use strict";var e,B,n,m,h,g,s,f,a,d,c,u,l,v,p,b,w,y,M,C,i,S,T,A,I,F,o,x,N,P,G,k,e,U,_,H;function V(t,n){var e,i;for(Array.call(this),"string"==typeof t?e=(n||f).querySelectorAll(t):t&&(e=k.isArray(t)||t instanceof HTMLCollection?t:[t]),i=0;e&&i<e.length;i++)this.push(e[i])}function z(t){for(var n,e,n=Y(t);t.parentElement;)n<(e=Y(t=t.parentElement))&&(n=e);return n}function Y(t){var t=getComputedStyle(t).zIndex;return"auto"===t||""===t?0:Number(t)}function Z(t){return k.isWindow(t)?t:9===t.nodeType&&(t.defaultView||t.parentWindow)}function W(t,n){var t=t.nodeName;return t&&t.toLowerCase()===n.toLowerCase()}function Q(t,n){return 0<="top left right bottom width height border-radius border-width border-left-width border-right-width border-top-width border-bottom-width line-height padding padding-left padding-right padding-top padding-bottom margin margin-left margin-right margin-top margin-bottom".split(" ").indexOf(t)&&isFinite(n)?(n=0<="width height".split(" ").indexOf(t)&&n<0?0:n)+"px":n}function J(t,n,e){var i,r,o,a=t.nodeType;if(t&&3!==a&&8!==a&&2!==a)return(o=1!==a)&&(r=F[n=I[n]||n]),R(e)?r&&c in r&&(i=r.get(t,n))!==g?i:t[n]:r&&u in r&&!R(i=r.set(t,e,n))?i:t[n]=e}function K(t){var n,e,n,n,n=t.nodeType;return!(n&&1!==n&&9!==n||(n=(n=t.nodeName)&&(e={embed:!0,object:"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",applet:!0})[n.toLowerCase()])&&(!0===n||t.getAttribute("classid")!==n))}function D(t){return t.replace(/^-ms-/,"ms-").replace(/-([\da-z])/gi,function(t,n){return n.toUpperCase()})}function j(t,n,e,i){if(K(t)){var t,r,o=N,a=E(n),u=t.nodeType,s=u?x:t,c=u?t[o]:t[o]&&o;if(c&&s[c]&&(i||s[c].data)||!a||!R(e))return c||(u?(t[o]=c=P,P++):c=o),s[c]||(s[c]={},u)||(s[c].toJSON=function(){}),!O(n)&&"function"!=typeof n||(i?s[c]=k.extend(s[c],n):s[c].data=k.extend(s[c].data,n)),t=s[c],i||(t.data||(t.data={}),t=t.data),R(e)||(t[D(n)]=e),a?(r=t[n])!==g&&r!==h||(r=t[D(n)]):r=t,r}}function X(t){var n;for(n in t)if(("data"!==n||!k.isEmptyObject(t[n]))&&"toJSON"!==n)return;return 1}function q(t,n,e){if(K(t)){var i,r,o,a=t.nodeType,u=a?x:t,s=a?t[N]:N;if(u[s]){if(n&&(o=e?u[s]:u[s].data)){r=(n=k.isArray(n)?n.concat(k.map(n,D)):n in o||(n=D(n))in o?[n]:n.split(" ")).length;for(i=0;i<r;i++)delete o[n[i]];if(!(e?X:k.isEmptyObject)(o))return}(e||(delete u[s].data,X(u[s])))&&(a?$([t],!0):u!==u.window?delete u[s]:u[s]=g)}}}function $(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,d,v,o=0,a=N,u=x,e=t[o];e!==g&&void 0!==e;){if((n||K(e))&&(r=(i=e[a])&&u[i])){if(s=r.events)for(c in s)if(m(s,c)&&(f=s[c]))for(l in f)if(m(f,l)&&(h=f[l]))for(d=0,v=h.length;d<v;d++)L(e,c,h[d]);u[i]&&(delete u[i],delete e[a])}e=t[++o]}}function E(t){return"string"==typeof t}function O(t){return"object"==typeof t}function R(t){return typeof t==typeof h}function tt(t){var u=t;return function(t){var n,e,i,r,o,a,n=this,e="border-box"===n.css("box-sizing"),r=u?l:v,o=u?p:w,a=u?b:y;return 0===arguments.length?(i=Math.round(s(n.css(r)))||0,e&&(i-=s(n.css("padding-"+o))+s(n.css("padding-"+a))+s(n.css("border-"+o+"-"+l))+s(n.css("border-"+a+"-"+l))),i):(n.css(r,t),n)}}function nt(t){var i=t;return function(){var t,n,e,t=this,n=i?p:w,e=i?b:y;return i?t.width():t.height()+s(t.css("padding-"+n))+s(t.css("padding-"+e))}}function et(t){var o=t;return function(t){var n,e,i,r,n=o?p:w,e=o?b:y,i=this,r=o?i.innerWidth():i.innerHeight();return r+=s(i.css("border-"+n+"-"+l))+s(i.css("border-"+e+"-"+l)),t&&(r+=s(i.css("margin-"+n))+s(i.css("margin-"+e))),r}}function it(t){var e=t;return function(n){return this.forEach(function(t){t.style[A]=e?C:i,n&&n.apply(t)}),this}}function rt(t){var s=t;return function(t){var n,e,i,r,o,a,u,n="scrollLeft",e="scrollTop",i=s?n:e,r=s?"pageXOffset":"pageYOffset",o=this,a=o[0],u=Z(a);return R(t)?u?r in u?u[r]:f.documentElement[i]:a[i]:(u?u.scrollTo(s?t:k(u)[n](),s?k(u)[e]():t):a[i]=t,o)}}function L(t,n,e){t.removeEventListener(n,e)}function ot(i,r,t){var o,a,u,s,c,f,l,n,h,e,l=0,n=!1,h=!1,e=!0;if("function"!=typeof i)throw new TypeError("Expected a function");function d(t){var n,e,n=o,e=a;return o=a=void 0,l=t,s=i.apply(e,n)}function v(t,n){return setTimeout(t,n)}function m(t){clearTimeout(t)}function g(t){return l=t,c=v(w,r),n?d(t):s}function p(t){var n,e,t,n,e=t-l,t=r-(t-f);return h?Math.min(t,u-e):t}function b(t){var n,e,n=t-f,e;return void 0===f||r<=n||n<0||h&&u<=t-l}function w(){var t=Date.now();if(b(t))return y(t);c=v(w,p(t))}function y(t){return c=void 0,e&&o?d(t):(o=a=void 0,s)}function M(){void 0!==c&&m(c),o=f=a=c=void(l=0)}function C(){return void 0===c?s:y(Date.now())}function S(){return void 0!==c}function T(){for(var t,n,e,i,t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];if(i=b(e=Date.now()),o=t,a=this,f=e,i){if(void 0===c)return g(f);if(h)return c=v(w,r),d(f)}return void 0===c&&(c=v(w,r)),s}return r=+r||0,O(t)&&(n=!!t.leading,h="maxWait"in t,u=h?Math.max(+t.maxWait||0,r):u,e="trailing"in t?!!t.trailing:e),T.cancel=M,T.flush=C,T.pending=S,T}function at(t,n,e){var i,r,i=!0,r=!0;if("function"!=typeof t)throw new TypeError("Expected a function");return O(e)&&(i="leading"in e?!!e.leading:i,r="trailing"in e?!!e.trailing:r),ot(t,n,{leading:i,trailing:r,maxWait:n})}function ut(t,n,e){var i,r,o;if(t){if(i=t,!n||0===n.length)return i=!(i=t[a])&&e?t[a]={}:i;for(r=n.length-1;0<=r;r--){if(!i[o=n[r]]){if(!e)return;i[o]={}}i=i[o]}return i}}function st(t,n){var e,i,r,o;for(e in t)if(m(t,e)&&(i=t[e]))if(k.isArray(i))for(r=i.length,o=0;o<r;o++)L(n,e,i[o]);else st(i,n)}function ct(t,n,e,i,r){var o,a,u,s,c;if(!(!t||2<r||t instanceof Function))for(o in r+=1,t)if(m(t,o)&&(a=t[o])){if((u=a[e])&&k.isArray(u))for(s=0,c=u.length;s<c;s++)u[s].apply(n,[{type:e},i]);ct(a,n,e,i,r)}}function ft(t,n,e){this.zue=t.clientHeight,this.Vue=t.clientWidth,this.sse=B.mt.Tt.safari,this.cse(t,n,e)}Object.defineProperty(t,"__esModule",{value:!0}),t.Ose=t.GC$=t.getHostMaxZIndex=void 0,e=n("Common"),B=n("./dist/core/util/common.js"),n=e.Common.lt,m=e.Common.kh,h=void 0,g=null,s=parseFloat,f=document,a="_nonamespace",d="events",c="get",u="set",l="width",v="height",p="left",b="right",w="top",y="bottom",M="hidden",C="block",i="none",S="position",T="visibility",A="display",I={tabindex:"tabIndex",readonly:"readOnly",for:"htmlFor",class:"className",maxlength:"maxLength",cellspacing:"cellSpacing",cellpadding:"cellPadding",rowspan:"rowSpan",colspan:"colSpan",usemap:"useMap",frameborder:"frameBorder",contenteditable:"contentEditable"},F={tabIndex:{get:function(t){var n,e,i,r,n=t.getAttributeNode("tabindex"),e=/^(?:input|select|textarea|button|object)$/i,i=/^(?:a|area)$/i,r=t.nodeName;return n&&n.specified?parseInt(n.value,10):e.test(r)||i.test(r)&&t.href?0:h}}},o={option:{get:function(t){var n=t.attributes.value;return!n||n.specified?t.value:t.text}},select:{get:function(t){var n,n,e=t.options,i=t.selectedIndex,r="select-one"===t.type||i<0,o=r?g:[],a=r?i+1:e.length,u=r?i:0;for(i<0&&(u=a);u<a;u++)if(((n=e[u]).selected||u===i)&&!n.disabled&&(!n.parentNode.disabled||!W(n.parentNode,"optgroup"))){if(n=k(n).val(),r)return n;o.push(n)}return o},set:function(t,n){var e,i,e=k.makeArray(n),i;return k(t).find("option").getAll().forEach(function(t){t.selected=0<=k.inArray(k(t).val(),e)}),e.length||(t.selectedIndex=-1),e}}},x={},N="$"+(""+Math.random()).replace(/\D/g,""),P=1,G={},[v,l].forEach(function(c){G[c]={get:function(t){var n,e,i,r,o,a,n,u,s,n=getComputedStyle(t),e=t.style,i=e[S],r=e[T],o=e[A],a=0===t.offsetWidth&&/^(none|table(?!-c[ea]).+)/.test(n[A]);if(a&&(e[S]="absolute",e[T]=M,e[A]=C),n=n&&n[c],a&&(e[S]=i,e[T]=r,e[A]=o),""===n){for(u=t.parentElement,s=f.body;u&&u!==s;)u=u.parentElement;u!==s&&(n=e[c])}return n}}}),k=function(t,n){return t instanceof V?t:new V(t,n)},t.GC$=k,e={get:function(t){return this[t]},getAll:function(){return this},bind:function(a,u,s){var t=this;return R(s)&&(s=u,u=h),t.forEach(function(e){var t,n,i,r,t,n,o,t=j(e,d,h,!0);t||j(e,d,t={},!0),i=(n=a.split("."))[0],t=ut(t,r=n.slice(1),!0),(n=function(t){R(u)||(t.data=u);var n=s.apply(e,arguments);!1===(t.result=n)&&(t.preventDefault?(t.preventDefault(),t.stopPropagation()):(t.cancelBubble=!1,t.returnValue=!1))}).original=s,(o=(o=t[i])||(t[i]=[])).push(n),e.addEventListener(i,n)}),t},unbind:function(f,l){var t=this;return t.forEach(function(t){var n,e,i,r,o,a,u,e,s,c,n=j(t,d,h,!0),e=f.split("."),i=e[0],r=e.slice(1),e=ut(n,r);if(e)if(l){if(i&&(o=e[i])&&k.isArray(o))for(u=o.length,a=0;a<u;a++)if(o[a].original===l){L(t,i,o[a]),o.splice(a,1);break}}else if(i){if((o=e[i])&&k.isArray(o))for(u=o.length,a=0;a<u;a++)L(t,i,o[a]);e[i]=h}else{for(st(e,t),s=n,c=r.length-1;0<c&&(s=s[r[c]]);c--);s&&(s[r[0]]=h)}}),t},trigger:function(t,n){var e,i,r,o,a,u,s,e=this;if(t)for(i=0,r=e.length;i<r;i++)(a=j(o=e[i],d,h,!0))&&ct(a,o,s=(u=t.split("."))[0],n,0);return e},css:function(e,i){var t,r,n,o,a,a;function u(n,e){r.forEach(function(t){t.style[n]=Q(n,e)})}if(r=t=this,1===(n=arguments.length)){if(!O(e))return o=t[0],(a=G[e])&&c in a?a.get(o):(a=getComputedStyle(o))&&a[e];r.forEach(function(t){for(var n in e)m(e,n)&&(t.style[n]=Q(n,e[n]))})}else 2===n&&(k.isArray(e)&&k.isArray(i)&&e.length===i.length?e.forEach(function(t,n){u(t,i[n])}):u(e,i));return t},width:tt(!0),height:tt(),innerWidth:nt(!0),innerHeight:nt(),outerWidth:et(!0),outerHeight:et(),append:function(t){var n,t,e,n=[t];return t instanceof k&&(n=t.getAll()),e=(t=this)[0],n.forEach(function(t){t&&e.appendChild(t)}),t},appendTo:function(t){var n,t,n=t;return t instanceof k&&(n=t[0]),(t=this).forEach(function(t){n.appendChild(t)}),t},prepend:function(t){var n=this,e=n[0];return e.insertBefore(t,e.firstChild),n},insertBefore:function(n){var t=this,e=n.parentElement;return t.forEach(function(t){e.insertBefore(t,n)}),t},addClass:function(t){for(var n,e,i,r,o,a=0,u=this,s=u.length,c,f=/[\t\r\n]/g,n=(t||"").match(/\S+/g)||[];a<s;a++)if(i=1===(e=u[a]).nodeType&&(e.className?(" "+e.className+" ").replace(f," "):" ")){for(r=n[o=0];r;)i.indexOf(" "+r+" ")<0&&(i+=r+" "),r=n[++o];e.className=k.trim(i)}return this},removeClass:function(t){for(var n,e,i,r,o,a=0,u=this,s=u.length,c,f=/[\t\r\n]/g,n=(t||"").match(/\S+/g)||[];a<s;a++)if(i=1===(e=u[a]).nodeType&&(e.className?(" "+e.className+" ").replace(f," "):"")){for(r=n[o=0];r;){for(;0<=i.indexOf(" "+r+" ");)i=i.replace(" "+r+" "," ");r=n[++o]}e.className=t?k.trim(i):""}return this},hasClass:function(t){var n,e,i,r,o,n=0,e=this,i=e.length,r=/[\t\r\n]/g;for(t=" "+t+" ";n<i;n++)if(1===(o=e[n]).nodeType&&0<=(" "+o.className+" ").replace(r," ").indexOf(t))return!0;return!1},toggle:function(){var t,n,t=this,n;return t[0].style[A]===i?t.show():t.hide(),t},show:it(!0),hide:it(),attr:function(e,n){var t=this,i=t,r=arguments.length;if(1===r){if(!O(e))return t[0].getAttribute(e);i.forEach(function(t){for(var n in e)m(e,n)&&t.setAttribute(n,e[n])})}else 2===r&&i.forEach(function(t){t.setAttribute(e,n)});return t},removeAttr:function(n){return this.forEach(function(t){t.removeAttribute(n)}),this},prop:function(e,n){var t=this,i=t,r=arguments.length;if(1===r){if(!O(e))return J(t[0],e);i.forEach(function(t){for(var n in e)m(e,n)&&J(t,n,e[n])})}else 2===r&&i.forEach(function(t){J(t,e,n)});return t},removeProp:function(n){n=I[n]||n;var t=this,e;return t.forEach(function(t){try{t[n]=h,delete t[n]}catch(t){}}),t},text:function(n){var t=this,e=t;return 0===arguments.length?t[0].textContent:(e.forEach(function(t){t.textContent=n}),t)},val:function(e){var t,i,t,n,r,t=this;return arguments.length?(r=k.isFunction(e),t.forEach(function(t,n){var n;1!==t.nodeType||((n=r?e.call(t,n,k(t).val()):e)===g||n===h?n="":"number"==typeof n?n+="":k.isArray(n)&&(n=k.map(n,function(t){return t===g||t===h?"":t+""})),(i=o[t.type]||o[t.nodeName.toLowerCase()])&&u in i&&!R(i.set(t,n,"value")))||(t.value=n)}),t):(n=void 0,(t=t[0])?(i=o[t.type]||o[t.nodeName.toLowerCase()])&&c in i&&!R(n=i.get(t,"value"))?n:E(n=t.value)?n.replace(/\r/g,""):n===g||n===h?"":n:void 0)},position:function(){var t,n,e,i,r,t=this[0];if(t){if(n={top:0,left:0},e={top:0,left:0},"fixed"===k(t).css(S))try{n=t.getBoundingClientRect()}catch(t){}else i=this.offsetParent(),n=this.offset(),W(r=i[0],"html")||((e=i.offset()).left-=r.scrollLeft,e.top-=r.scrollTop),e.top+=s(k(r).css("borderTopWidth")),e.left+=s(k(r).css("borderLeftWidth"));return{top:n.top-e.top-s(k(t).css("marginTop")),left:n.left-e.left-s(k(t).css("marginLeft"))}}},offsetParent:function(){var t=k.map(this,function(t){for(var n,e,n=f.documentElement,e=t.offsetParent||n;e&&!W(e,"html")&&"static"===k(e).css(S);)e=e.offsetParent;return e||n});return k(t)},offset:function(){var t,n,e={top:0,left:0},n=this[0],i=n&&n.ownerDocument;if(i){if(t=i.documentElement,!R(n.getBoundingClientRect))try{e=n.getBoundingClientRect()}catch(t){}return n=Z(i),{top:e.top+(n.pageYOffset||t.scrollTop)-(t.clientTop||0),left:e.left+(n.pageXOffset||t.scrollLeft)-(t.clientLeft||0)}}},scrollLeft:rt(!0),scrollTop:rt(),html:function(n){var t=this,e=t;return 0===arguments.length?t[0].innerHTML:(e.forEach(function(t){t.innerHTML=n}),t)},remove:function(){var t;this.forEach(function(t){var n=t.parentElement;n&&(n.removeChild(t),$([t]))})},empty:function(){return this.forEach(function(t){k(t.children).remove()}),this},find:function(n){var e=[];return E(n)&&this.forEach(function(t){var t=t.querySelectorAll(n);k.merge(e,t)}),k(e)},parent:function(){var n=[];return this.forEach(function(t){var t=t.parentElement;t&&n.push(t)}),k(n)},index:function(t){var n=this[0];return t?E(t)?k.inArray(n,k(t).getAll()):k.inArray(t,this):n&&n.parentElement?k.inArray(n,n.parentElement.children):-1},focus:function(){var t=this,n=t[0];return n!==f.activeElement&&n.focus&&n.focus(),t},isVisible:function(){var n=0;return this.forEach(function(t){var t=getComputedStyle(t);t[T]!==M&&t[A]!==i&&n++}),0<n},data:function(e,i){var r,o,r=this,o=R(i);return o&&(r=void 0),k.each(this,function(t,n){var n=j(n,e,i);if(o)return r=n,!1}),r},removeData:function(e){return k.each(this,function(t,n){q(n,e)}),this}},U=V.prototype=[],n.Dh(U,e),k.prototype=U,k.each=n.y0,k.isEmptyObject=n._h,k.isFunction=n.Eh,k.isArray=n.Nh,k.isNumeric=n.jh,k.getType=n.Oh,k.inArray=n.Rh,k.merge=n.Bh,k.map=n.Lh,k.extend=n.Dh,k.inherit=n.Fh,k.isPlainObject=n.Ph,k.isArraylike=n.Gh,k.isWindow=n.Uh,k.makeArray=n.Hh,k.trim=function(t){var n;return t.trim?t.trim():t===g||t===h?"":(t+"").replace(/(^[\s\uFEFF\xA0]+)|([\s\uFEFF\xA0]+$)/g,"")},k.En=function(t,n,e,i,r){var t=k(f.createElement(t));return n&&e&&t.css(n,e),i&&t.addClass(i),r&&(r instanceof k?r:k(r)).append(t),t},t.getHostMaxZIndex=z,_="px",ft.prototype.cse=function(r,o,t){var a=this;this.sse?this.fse=setInterval(function(){var t;r.style.width===a.Vue+_&&r.style.height===a.zue+_||o()},100):(this.Yue=new MutationObserver(at(function(t){for(var n,e,i,n=0;n<t.length;n++)if("attributes"===(e=t[n]).type&&(i=r.style.width!==a.Vue+_||r.style.height!==a.zue+_))return void o()},t)),this.Yue.observe(r,{attributes:!0}))},ft.prototype.disconnect=function(){this.sse?clearInterval(this.fse):(this.Yue.disconnect(),this.Yue=null)},t.Ose=ft},"./dist/core/util/imageLoader.js":function(t,n,e){"use strict";var e,s,c,i;function r(t){var n;this.zh=0,this.Vh=0,this.Yh={},this.Zh=t}Object.defineProperty(n,"__esModule",{value:!0}),n.Wh=void 0,e=e("./dist/core/util/domUtil.js"),s=e.GC$,c=".gcSheet",r.prototype.Rt=function(t,n){var e,i,r,o;function a(){e.Qh(t,!0)}function u(){e.Qh(t,!1)}(r=(i=(e=this).Yh)[t])||(o=s(document.createElement("img")),n&&o.attr("crossOrigin",n),o.bind("load"+c,a),o.bind("error"+c,u),o.bind("abort"+c,u),e.zh++,i[t]={Kh:!1,Jh:o[0],Xh:!1},o[0].src=t)},r.prototype.jt=function(t){var t=this.Yh[t];return!!t&&t.Kh},r.prototype.qh=function(t){var t=this.Yh[t];return!!t&&t.Xh},r.prototype.Ot=function(t){var t=this.Yh[t];return t?t.Jh:null},r.prototype.Qh=function(t,n){var e=this;e.Vh++,e.Yh[t].Kh=!0,e.Yh[t].Xh=n,e.$h()&&e.Zh&&e.Zh()},r.prototype.$h=function(){return this.Vh>=this.zh},r.prototype.L0=function(){var t,n,e,t=this.Yh;if(t)for(n in t)t[n]&&(e=s(t[n].Jh)).unbind(c);this.Zh=null},n.Wh=r},"./dist/core/util/styleManager.js":function(L,t,n){"use strict";var B,F,d,v,s,u,P,a,c,m,g,f,p,r,o,l,e,G,h,b,U,w,y,M,C,H,V,i,n;function S(t,n){var e=this;this.td=[],this.Lh={},t&&(n?t.forEach(function(t,n){e.Lh[t]=""+n,e.td[n]=t}):t.forEach(function(t,n){e.getTextIndex(t)}))}function T(){this.td=[]}function A(t){return t?1:0}function I(t,n){var e,i;return t?(e="{",m(t.style)||"object"!=typeof(i="string"==typeof(i=t.style)?'"'+P.ExcelBorderStyle[i]+'"':i)&&(e+='"s":'+i+","),m(t.color)||(e+='"c":'+n.getTextIndex(t.color)+","),e.substring(0,e.length-1)+"}"):""}function z(t,n,e){var i,t;if(t)return i=new v.LineBorder,t=JSON.parse(t),e||0!==t.s?(m(t.s)||(i.style=+t.s),m(t.c)||(i.color=n.getText(+t.c)),i):f}function Y(){var t,n,t=e(),n;return t&&t.GC&&t.GC.Spread&&t.GC.Spread.Common&&e().GC.Spread.Common.CultureManager.getCultureInfo()||G()}function x(t,n){var e=this;e.nd=[],e.ed=new b(n),e.rd=t}function N(t,n){var e=this;e.od=[],e.ad=new b,e.ud=new b,e.rd=t,e.cd=n}function k(t){var n=this;n.fd=[],n.ld=[],n.hd=new b,n.dd=new b,n.rd=t,n.hd.getTextIndex('{"s":0}'),n.dd.getTextIndex("l:0,r:0,t:0,b:0")}function _(t,n){var e=this;e.Ih=170,e.vd=[],e.md=new b,e.pd=new b,e.bd={},e.cd=t,e.yd=n,e.wd={},_.initBuiltNumberFormat(),Object.keys(_.Md).forEach(function(t){"count"!==t&&(_.Cd[_.Md[t]]=t)}),_.initLanguageIndependentNumberFormat(),Object.keys(_.Sd).forEach(function(t){"count"!==t&&(_.Cd[_.Sd[t]]=t)})}function D(){var t=this;t.Td=[],t.Ad=new b}function j(){var t=this;t.xd=[],t.Nd=new b}function E(t,n){if(t&&n)for(var e in n)n.hasOwnProperty(e)&&(t[e]=n[e])}function O(t,n,e){var i=this;i.kd=new b,i.Dd=new C(n,e),i._d=new y(t,n),i.Lfe=new y(t,n),i.Ed=new w(t),i.jd=new M(t),i.Vve=new H,i.Yve=new V}function R(){var t=this;t.Od=new b,t.cd=new b,t.yd=new U,t.Dd=new C(t.cd,t.yd),t._d=new y(t.Od,t.cd),t.Ed=new w(t.Od,['{"t":0}','{"t":5}']),t.jd=new M(t.Od),t.Rd=new b,t.Bd=new b,t.Ld=new b,t.kd=new i(t.Od,t.cd,t.yd),t.Fd={},t.Pd={},t.Gd={},t.Ud={},t.Hd={},t.zd=[],t.Vd={},t.Yd={},t.Zd={},t.originCellXfs=new b,t.originNamedStylesXfs=new b,t.Wd={},t.Qd={},t.Kd={},t.Jd="__builtInStyle",t.Xd="__builtInTableStyle",t.qd=/^(__builtInTableStyle\d+)?__builtInStyle\d+$/,t.$d=0}Object.defineProperty(t,"__esModule",{value:!0}),t.StyleManager=t.SharedDxfs=t.SimpleSharedStrings=void 0,B=n("./dist/core/util/common.js"),F=n("./dist/core/celltype/celltype.ns.js"),d=n("./dist/core/util/common.js"),v=n("./dist/core/worksheet/style.js"),s=n("./dist/core/util/common.js"),u=n("./dist/core/excel-io-util/common.js"),P=n("./dist/core/excel-io-util/excel-style.js"),a=n("Common"),c=n("./dist/core/util/domUtil.js"),m=a.Common.lt.ht,g=void 0,f=null,p=u.NodeHelper.ur,r=c.GC$.each,o=a.Common.lt.tv,l=u.Util.oo,e=u.Util.ro,G=u.Util.ao,h=B.mt.St,S.prototype.dispose=function(){this.td=g,this.Lh=g},S.prototype.getTextIndex=function(t){var n;return this.Lh[t]===g&&(n=this.td.push(t)-1,this.Lh[t]=n),this.Lh[t]},S.prototype.getText=function(t){return this.td[t]},S.prototype.setTextIndex=function(t,n){this.td[n]=t,this.Lh[t]=n},S.prototype.replaceText=function(t,n){this.td[t]=n},S.prototype.getCount=function(){return this.td.length},S.prototype.yh=function(t){var n,e,i,r,n=this,e=n.Lh;if(t)for(i=0,r=(n.td=t).length;i<r;i++)e[t[i]]=""+i},S.prototype.wh=function(){return this.td},b=S,t.SimpleSharedStrings=b,T.prototype.dispose=function(){this.td=g},T.prototype.getObjectIndex=function(t){var n,e=this.td,i=0,r=e.length,o;if(t.toJSON?o=t.toJSON():!m(t)&&t instanceof Object&&(o=JSON.stringify(t)),o){for(;i<r;i++)if(e[i]===o)return i;return e[i]=o,i}},T.prototype.getObject=function(t){return this.td[t]},T.prototype.yh=function(t){this.td=t},T.prototype.wh=function(){return this.td},U=T,x.prototype.dispose=function(){var t=this;t.ed&&(t.ed.dispose(),t.ed=g),t.nd=g,t.rd=g},x.prototype.nv=function(t){var n,e,i,t,r,o,a,u,n=this,e=n.rd;return t.backColor===f?n.ed.getTextIndex('{"t":0}'):t.backColor!==g?("object"==typeof(a=o=r=t=t.backColor)?(i="{",o.stops?(i+='"s":[',(u=o.stops).forEach(function(t){i+='{"p":'+t.position+',"c":'+e.getTextIndex(t.color)+"},"}),i=i.substring(0,i.length-1),i+="],","path"===a.type?(i+='"t":"p"',(0,s.isDefined)(a.left)&&(i+=',"l":'+a.left),(0,s.isDefined)(a.right)&&(i+=',"r":'+a.right),(0,s.isDefined)(a.top)&&(i+=',"a":'+a.top),(0,s.isDefined)(a.bottom)&&(i+=',"c":'+a.bottom)):i+='"d":'+(o.degree||0)):r.type!==g&&(i+='"t":'+r.type,(0,s.isDefined)(r.patternColor)&&""!==r.patternColor&&(i+=',"p":'+e.getTextIndex(r.patternColor)),(0,s.isDefined)(r.backgroundColor))&&""!==r.backgroundColor&&(i+=',"b":'+e.getTextIndex(r.backgroundColor)),i+="}"):i=""===t?'{"t":0}':e.getTextIndex(t),n.ed.getTextIndex(i)):void 0},x.prototype.ev=function(t,n){var e,i,r,o,e,a,u,s,u,e=this,i=e.rd,r=e.nd;return r[t]||("string"==typeof(e=e.ed.getText(+t))&&"{"===e[0]?(u=(a=JSON.parse(e)).s,o={},0===a.t?f:(u&&0<u.length?(s=o.stops=[],u.forEach(function(t){var n={};m(t.p)||(n.position=t.p),m(t.c)||(n.color=i.getText(t.c)),s.push(n)}),"p"===a.t?(o.type="path",m(a.l)||(o.left=a.l),m(a.r)||(o.right=a.r),m(a.a)||(o.top=a.a),m(a.c)||(o.bottom=a.c)):m(a.d)||(o.degree=a.d)):m(a.t)?m(a.b)||(o=i.getText(a.b)):1===(u=a.t)?n||m(a.p)?m(a.b)||(o=i.getText(a.b)):o=i.getText(a.p):(o.type=u,m(a.p)||(o.patternColor=i.getText(a.p)),m(a.b)||(o.backgroundColor=i.getText(a.b))),o=c.GC$.isEmptyObject(o)?g:o,r[t]=o)):(o=i.getText(e),o=c.GC$.isEmptyObject(o)?g:o,r[t]=o))},x.prototype.iv=function(t){t.fills=this.ed.wh()},x.prototype.rv=function(t){this.ed.yh(t.fills)},w=x,N.prototype.dispose=function(){var t=this;t.ad&&(t.ad.dispose(),t.ad=g),t.ud&&(t.ud.dispose(),t.ud=g),t.od=g,t.rd=g,t.cd=g},N.prototype.nv=function(t){var n,e,n=this;if(!(m(t.font)&&m(t.vertAlign)&&m(t.textDecoration)&&t.foreColor===g&&m(t.themeFont)))return e="",m(t.font)||(e+="f:"+n.ud.getTextIndex(t.font)+","),m(t.vertAlign)||(e+="v:"+t.vertAlign+","),m(t.textDecoration)||(e+="d:"+t.textDecoration+","),t.foreColor!==g&&(e+="c:"+n.rd.getTextIndex(t.foreColor)+","),m(t.themeFont)||(e+="t:"+n.cd.getTextIndex(t.themeFont)+","),n.ad.getTextIndex(e.substring(0,e.length-1))},N.prototype.ev=function(t){var i,r,n,e,o,i=this,r=i.rd,n=i.od;return n[t]||((e=i.ad.getText(+t))?(o={},e.split(",").forEach(function(t){var t=t.split(":"),n=t[0],e=t[1];switch(n){case"f":o.font=i.ud.getText(+e);break;case"v":o.vertAlign=+e;break;case"d":o.textDecoration=+e;break;case"c":o.foreColor=r.getText(+e);break;case"t":o.themeFont=i.cd.getText(+e)}}),n[t]=o):void 0)},N.prototype.iv=function(t,n){var e=this;n?(t.partFonts=e.ad.wh(),t.partHtmlFonts=e.ud.wh()):(t.fonts=e.ad.wh(),t.htmlFonts=e.ud.wh())},N.prototype.rv=function(t,n){var e=this;n?(e.ad.yh(t.partFonts),e.ud.yh(t.partHtmlFonts)):(e.ad.yh(t.fonts),e.ud.yh(t.htmlFonts))},y=N,k.prototype.dispose=function(){var t=this;t.hd&&(t.hd.dispose(),t.hd=g),t.dd&&(t.dd.dispose(),t.dd=g),t.fd=g,t.ld=g,t.rd=g},k.prototype.nv=function(t){var n,e,i,n=this,e=n.rd;if(!(m(t.borderLeft)&&m(t.borderTop)&&m(t.borderRight)&&m(t.borderBottom)&&m(t.borderVertical)&&m(t.borderHorizontal)&&m(t.diagonalDown)&&m(t.diagonalUp)))return i="",m(t.borderLeft)||(i+="l:"+n.hd.getTextIndex(I(t.borderLeft,e))+","),m(t.borderRight)||(i+="r:"+n.hd.getTextIndex(I(t.borderRight,e))+","),m(t.borderTop)||(i+="t:"+n.hd.getTextIndex(I(t.borderTop,e))+","),m(t.borderBottom)||(i+="b:"+n.hd.getTextIndex(I(t.borderBottom,e))+","),m(t.borderVertical)||(i+="v:"+n.hd.getTextIndex(I(t.borderVertical,e))+","),m(t.borderHorizontal)||(i+="h:"+n.hd.getTextIndex(I(t.borderHorizontal,e))+","),m(t.diagonalUp)||(i+="u:"+n.hd.getTextIndex(I(t.diagonalUp,e))+","),m(t.diagonalDown)||(i+="d:"+n.hd.getTextIndex(I(t.diagonalDown,e))+","),n.dd.getTextIndex(i.substring(0,i.length-1))},k.prototype.ov=function(t,n){var e,i,r,e,o,r,e=this,i=e.ld;return i[t]||(r=e.hd,e=e.rd,r=z(o=r.getText(+t),e,n),i[t]=r)},k.prototype.ev=function(t,i){var r,n,e,o,r=this,n=r.fd;return n[t]||(e=r.dd.getText(t),o={},e?(e.split(",").forEach(function(t){var t=t.split(":"),n=t[0],e=t[1];switch(n){case"l":o.borderLeft=r.ov(e,i);break;case"r":o.borderRight=r.ov(e,i);break;case"t":o.borderTop=r.ov(e,i);break;case"b":o.borderBottom=r.ov(e,i);break;case"v":o.borderVertical=r.ov(e,i);break;case"h":o.borderHorizontal=r.ov(e,i);break;case"u":o.diagonalUp=r.ov(e,i);break;case"d":o.diagonalDown=r.ov(e,i)}}),n[t]=o):void 0)},k.prototype.iv=function(t){var n=this;t.borderItems=n.hd.wh(),t.borders=n.dd.wh()},k.prototype.rv=function(t){var n=this;n.dd.yh(t.borders),n.hd.yh(t.borderItems)},M=k,_.prototype.dispose=function(){var t=this;t.md&&(t.md.dispose(),t.md=g),t.pd&&(t.pd.dispose(),t.pd=g),t.vd=g,t.bd=g},_.prototype.nv=function(t){var n,e,i,t,r,o,a,n=this,e="",i=t._autoFormatter,t=t.formatter;if(!m(i)){if(r=(o=n.av(i))&&"a"+o.c,!o)return;n.bd[r]!==g?e+="a:"+n.bd[r]+",":(a=n.pd.getTextIndex(JSON.stringify(o)),e+="a:"+(n.bd[r]=a)+",")}if(!m(t)&&!h(t)){if(r=(o=n.av(t))&&"f"+o.c,!o)return;n.bd[r]!==g?e+="f:"+n.bd[r]+",":(a=n.pd.getTextIndex(JSON.stringify(o)),e+="f:"+(n.bd[r]=a)+",")}if(e)return n.md.getTextIndex(e.substring(0,e.length-1))},_.prototype.ev=function(t){var r,n,e,o,r=this,n=r.vd;return n[t]||(e=r.md.getText(t),o={},e.split(",").forEach(function(t){var t,n,t,e,i,i,t=t.split(":"),n=t[0],t=t[1];"a"===n?(e=r.fromSJSFormatString(r.pd.getText(+t)),(i=(i=a.Formatter)&&i.GeneralFormatter)&&(o._autoFormatter=new i(e.formatCached,e.customerCultureName),o._autoFormatter.isAuto=!0)):"f"===n&&(o.formatter=r.fromSJSFormatString(r.pd.getText(+t)))}),n[t]=o)},_.prototype.uv=function(t){var n=this,e=n.wd;return e[t]||n.sv(t)},_.prototype.sv=function(t){if(t!==g)return _.Md[t]!==g?_.Md[t]:_.Sd[t]!==g?_.Sd[t]:void 0},_.prototype.fromSJSFormatString=function(t){var n,e,t,i,r,t,t,n=this,e=n.wd,t=JSON.parse(t),i=t.n,r=t.c;return"string"==typeof(r=m(t.json)?r:JSON.parse(n.yd.getObject(t.json)))?e[i]=r:r&&!m(r.typeName)&&(t=d.getTypeFromString(r.typeName))?((t=new t).fromJSON(r),e[i]=t):(m(i)||r&&r.formatCached||(r=n.sv(i)),e[i]=r)},_.prototype.av=function(t){var n,t,e,i,n=this,t=t;if("object"==typeof t&&(t.toJSON&&(e=t.toJSON()),t.formatCached?t=t.formatCached:e&&(t=JSON.stringify(e))),t)return(i=_.Cd[t])===g&&this.bd[t]===g&&(i=this.Ih,this.Ih++),{n:i,c:t,json:e&&n.yd.getObjectIndex(e)}},_.prototype.iv=function(t){var n=this;t.numFmts=n.md.wh(),t.formatStrings=n.pd.wh()},_.prototype.rv=function(t){var n,e,i,n=this;if(n.md.yh(t.numFmts),n.pd.yh(t.formatStrings),t.numFmts&&0<t.numFmts.length)for(e=0,i=t.numFmts.length;e<i;e++)n.ev(e)},_.initBuiltNumberFormat=function(){var t,n,n,e,i,r,o,a,t=_.Md;if(t[0]="General",t[1]="0",t[2]="0.00",t[3]="#,##0",t[4]="#,##0.00",t[9]="0%",t[10]="0.00%",t[11]="0.00E+00",t[12]="# ?/?",t[13]="# ??/??",t[14]="m/d/yyyy",t[15]="d-mmm-yy",t[16]="d-mmm",t[17]="mmm-yy",t[18]="h:mm AM/PM",t[19]="h:mm:ss AM/PM",t[20]="h:mm",t[21]="h:mm:ss",t[22]="m/d/yyyy h:mm",t[37]="#,##0 ;(#,##0)",t[38]="#,##0 ;[Red](#,##0)",t[39]="#,##0.00;(#,##0.00)",t[40]="#,##0.00;[Red](#,##0.00)",t[45]="mm:ss",t[46]="[h]:mm:ss",t[47]="mm:ss.0",t[48]="##0.0E+0",t[49]="@",t.count=49,l())if("zh-cn"===(n=l()))t[14]="yyyy/m/d",t[17]="mmm-yy",t[22]="yyyy/m/d h:mm",t[27]='yyyy"\u5e74"m"\u6708"',t[28]='m"\u6708"d"\u65e5"',t[29]='m"\u6708"d"\u65e5"',t[30]="m-d-yy",t[31]='yyyy"\u5e74"m"\u6708"d"\u65e5"',t[32]='h"\u65f6"mm"\u5206"',t[33]='h"\u65f6"mm"\u5206"ss"\u79d2"',t[34]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"',t[35]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"ss"\u79d2"',t[36]='yyyy"\u5e74"m"\u6708"',t[39]="#,##0.00;-#,##0.00",t[40]="#,##0.00;[Red]-#,##0.00",t[50]='yyyy"\u5e74"m"\u6708"',t[51]='m"\u6708"d"\u65e5"',t[52]='yyyy"\u5e74"m"\u6708"',t[53]='m"\u6708"d"\u65e5"',t[54]='m"\u6708"d"\u65e5"',t[55]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"',t[56]='\u4e0a\u5348/\u4e0b\u5348h"\u65f6"mm"\u5206"ss"\u79d2"',t[57]='yyyy"\u5e74"m"\u6708"',t[58]='m"\u6708"d"\u65e5"',t.count=58;else if("ja-jp"===n)t[14]="yyyy/m/d",t[15]="dd-mmm-yy",t[16]="dd-mmm",t[17]="mmm-yy",t[22]="yyyy/mm/dd h:mm",t[27]="[$-411]ge.m.d",t[28]='[$-411]ggge"\u5e74"m"\u6708"d"',t[29]='[$-411]ggge"\u5e74"m"\u6708"d"',t[30]="m/d/yy",t[31]='yyyy"\u5e74"m"\u6708"d"\u65e5"',t[32]='h"\u6642"mm"\u5206"',t[33]='h"\u6642"mm"\u5206"ss"\u79d2"',t[34]='yyyy"\u5e74"m"\u6708"',t[35]='m"\u6708"d"\u65e5"',t[36]="[$-411]ge.m.d",t[38]="#,##0;[Red]-#,##0",t[39]="#,##0.00;-#,##0.00",t[40]="#,##0.00;[Red]-#,##0.00",t[50]="[$-411]ge.m.d",t[51]='[$-411]ggge"\u5e74"m"\u6708"d"\u65e5"',t[52]='yyyy"\u5e74"m"\u6708"',t[53]='m"\u6708"d"\u65e5"',t[54]='[$-411]ggge"\u5e74"m"\u6708"d"\u65e5"',t[55]='yyyy"\u5e74"m"\u6708"',t[56]='m"\u6708"d"\u65e5"',t[57]="[$-411]ge.m.d",t[58]='[$-411]ggge"\u5e74"m"\u6708"d"\u65e5"',t.count=58;else if(e=(n=Y())&&n.LocalNumberFormat,!m(e)&&!Array.isArray(e)&&"object"==typeof e){for(i in e)isNaN(Number(i))||(r=e[i],u.Util.uo(r)&&(t[i]=e[i]));for(i in o=0,t)isNaN(Number(i))||o<(a=Number(i))&&(o=a);t.count=o}},_.initLanguageIndependentNumberFormat=function(){var t=_.Sd;t[27]="m/d/yyyy",t[28]="m/d/yyyy",t[29]="m/d/yyyy",t[30]="m/d/yyyy",t[31]="m/d/yyyy",t[32]="h:mm:ss",t[33]="h:mm:ss",t[34]="m/d/yyyy",t[35]="m/d/yyyy",t[36]="m/d/yyyy",t[50]="m/d/yyyy",t[51]="m/d/yyyy",t[52]="m/d/yyyy",t[53]="m/d/yyyy",t[54]="m/d/yyyy",t[55]="m/d/yyyy",t[56]="m/d/yyyy",t[57]="m/d/yyyy",t[58]="m/d/yyyy"},_.Md={count:0},_.Sd={count:0},_.Cd={},C=_,D.prototype.dispose=function(){var t=this;t.Ad&&(t.Ad.dispose(),t.Ad=g),t.Td=g},D.prototype.nv=function(t,n){var e,i,r,i,e="",i=t.hAlign;if(m(i)||(3===n||!n)&&3===i||2===n&&1===i||1===n&&1===i||(e+="h:"+(r=[1,2,3,0,6])[i]+","),i=t.vAlign,m(i)||(3===n||!n)&&2===i||2===n&&1===i||1===n&&1===i||(e+="v:"+i+","),m(t.textOrientation)||(e+="x:"+t.textOrientation+","),m(t.textIndent)||(e+="i:"+t.textIndent+","),m(t.shrinkToFit)||(e+="s:"+A(t.shrinkToFit)+","),m(t.wordWrap)||(e+="w:"+A(t.wordWrap)+","),e)return this.Ad.getTextIndex(e.substring(0,e.length-1))},D.prototype.ev=function(t){var n,e,e,i,n=this,e=n.Td;return e[t]||(e=n.Ad.getText(t),i=new v.Style,e.split(",").forEach(function(t){var t=t.split(":"),n=t[0],e=t[1];switch(n){case"h":i.hAlign=+e;break;case"v":i.vAlign=+e;break;case"x":i.textOrientation=+e;break;case"i":i.textIndent=+e;break;case"s":i.shrinkToFit=p(e);break;case"w":i.wordWrap=p(e)}}),i)},D.prototype.iv=function(t){t.alignments=this.Ad.wh()},D.prototype.rv=function(t){this.Ad.yh(t.alignments)},H=D,j.prototype.dispose=function(){var t=this;t.Nd&&(t.Nd.dispose(),t.Nd=g),t.xd=g},j.prototype.nv=function(t){var n;if(!m(t.locked))return n="",n+="l:"+A(t.locked)+",",this.Nd.getTextIndex(n.substring(0,n.length-1))},j.prototype.ev=function(t){var n,e,e,i,n=this,e=n.xd;return e[t]||(e=n.Nd.getText(t),i=new v.Style,e.split(",").forEach(function(t){var t=t.split(":"),n=t[0],t=t[1];"l"===n&&(i.locked=p(t))}),i)},j.prototype.iv=function(t){t.protections=this.Nd.wh()},j.prototype.rv=function(t){this.Nd.yh(t.protections)},V=j,O.prototype.dispose=function(){var t=this;t.kd&&(t.kd.dispose(),t.kd=g),t.Dd&&(t.Dd.dispose(),t.Dd=g),t._d&&(t._d.dispose(),t._d=g),t.Ed&&(t.Ed.dispose(),t.Ed=g),t.jd&&(t.jd.dispose(),t.jd=g),t.Vve&&(t.Vve.dispose(),t.Vve=g),t.Yve&&(t.Yve.dispose(),t.Yve=g)},O.prototype.cv=function(t,n,e){var i,r,o,o,o,n,o,n,i=this,r="";if(t&&((o=i.Vve.nv(t))!==g&&e&&(r+="a:"+o+","),(o=i.Ed.nv(t))!==g&&(r+="c:"+o+","),(o=(n?i.Lfe:i._d).nv(t))!==g&&(r+=(n?"pf:":"f:")+o+","),(n=i.jd.nv(t))!==g&&(r+="b:"+n+","),(o=i.Dd.nv(t))!==g&&(r+="j:"+o+","),(n=i.Yve.nv(t))!==g&&e&&(r+="pr:"+n+","),""!==(r=r.substring(0,r.length-1))))return i.kd.getTextIndex(r)},O.prototype.fv=function(t,o,a,u){var s=this,t=s.kd.getText(t);if(t)return o=o||new v.Style,t.split(",").forEach(function(t){var t,n,e,i,i,r,i,r,i,t=t.split(":"),n=t[0],e=t[1];switch(n){case"a":u&&(i=s.Vve.ev(+e),E(o,i));break;case"c":i=s.Ed.ev(+e,a),o.backColor=i;break;case"f":r=s._d.ev(+e),E(o,r);break;case"pf":r=s.Lfe.ev(+e),E(o,r);break;case"b":i=s.jd.ev(+e),E(o,i);break;case"j":r=s.Dd.ev(+e),E(o,r);break;case"pr":u&&(i=s.Yve.ev(+e),E(o,i))}}),o},O.prototype.iv=function(){var t=this,n={};return n.cellXfs=t.kd.wh(),t.Dd.iv(n),t._d.iv(n),t.Lfe.iv(n,!0),t.Ed.iv(n),t.jd.iv(n),t.Vve.iv(n),t.Yve.iv(n),n},O.prototype.rv=function(t){var n;t&&(n=this,t)&&(n.kd.yh(t.cellXfs),n.Dd.rv(t),n._d.rv(t),n.Lfe.rv(t,!0),n.Ed.rv(t),n.jd.rv(t),n.Vve.rv(t),n.Yve.rv(t))},i=O,t.SharedDxfs=i,R.prototype.dispose=function(){var t=this;t.Od&&(t.Od.dispose(),t.Od=g),t.cd&&(t.cd.dispose(),t.cd=g),t.yd&&(t.yd.dispose(),t.yd=g),t.Dd&&(t.Dd.dispose(),t.Dd=g),t._d&&(t._d.dispose(),t._d=g),t.Ed&&(t.Ed.dispose(),t.Ed=g),t.jd&&(t.jd.dispose(),t.jd=g),t.Rd&&(t.Rd.dispose(),t.Rd=g),t.Bd&&(t.Bd.dispose(),t.Bd=g),t.Ld&&(t.Ld.dispose(),t.Ld=g),t.kd&&(t.kd.dispose(),t.kd=g),t.Fd={},t.Pd={},t.Gd={},t.Ud={},t.Hd={},t.Vd={},t.zd.length=0,t.Yd={},t.Zd={},t.originCellXfs&&(t.originCellXfs.dispose(),t.originCellXfs=g),t.originNamedStylesXfs&&(t.originNamedStylesXfs.dispose(),t.originNamedStylesXfs=g),t.Wd={},t.Qd={},t.Kd={}},R.prototype.lv=function(t,n,e,i){var r,o,a,u,e,e,e,e,n,i,e,n,i,e,n,s,i,r=this,o=r.cd,a=r.yd,u="";return e!==g&&(u+="t:"+e+","),(e=r.Ed.nv(t))!==g&&(u+="c:"+e+","),(e=r._d.nv(t))!==g&&(u+="f:"+e+","),e=t.hAlign,m(e)||!i&&((3===n||!n)&&3===e||2===n&&1===e||1===n&&1===e)||(u+="h:"+e+","),e=t.vAlign,2===n&&1===e||1===n&&1===e||(m(e)?i||(u+="v:0,"):u+="v:"+e+","),(n=r.jd.nv(t))!==g&&(u+="b:"+n+","),m(t.locked)||(u+="l:"+A(t.locked)+","),m(t.wordWrap)||(u+="w:"+A(t.wordWrap)+","),m(t.showEllipsis)||(u+="se:"+A(t.showEllipsis)+","),m(t.hv)||(u+="st:"+A(t.hv)+","),m(t.shrinkToFit)||(u+="s:"+A(t.shrinkToFit)+","),m(t.tabStop)||(u+="ts:"+A(t.tabStop)+","),m(t.quotePrefix)||(u+="q:"+A(t.quotePrefix)+","),m(t.isVerticalText)||(u+="va:"+A(t.isVerticalText)+","),m(t.applyFont)||(u+="y:"+A(t.applyFont)+","),m(t.applyFill)||(u+="z:"+A(t.applyFill)+","),m(t.applyAlignment)||(u+="r:"+A(t.applyAlignment)+","),m(t.applyBorder)||(u+="e:"+A(t.applyBorder)+","),m(t.applyProtection)||(u+="u:"+A(t.applyProtection)+","),m(t.applyNumberFormat)||(u+="g:"+A(t.applyNumberFormat)+","),m(t.textIndent)||(u+="i:"+t.textIndent+","),i=t.imeMode,m(i)||1===i||(u+="im:"+i+","),m(t.opacity)||(u+="o:"+t.opacity+","),m(t.backgroundImageLayout)||(u+="bl:"+t.backgroundImageLayout+","),m(t.textOrientation)||(u+="x:"+t.textOrientation+","),m(t.backgroundImage)||(u+="bi:"+o.getTextIndex(t.backgroundImage)+","),m(t.watermark)||(u+="k:"+o.getTextIndex(t.watermark)+","),m(t.cellPadding)||(u+="p:"+o.getTextIndex(t.cellPadding)+","),m(t.textBaseline)||(u+="tb:"+o.getTextIndex(t.textBaseline)+","),m(t.labelOptions)||(u+="lo:"+o.getTextIndex(JSON.stringify(t.labelOptions))+","),m(t.cellType)||(e=a.getObjectIndex(t.cellType),m(e))||(u+="ct:"+e+","),m(t.cellButtons)||(n=a.getObjectIndex(t.cellButtons),m(n))||(u+="cb:"+n+","),m(t.dropDowns)||(i=a.getObjectIndex(t.dropDowns),m(i))||(u+="dd:"+i+","),m(t.decoration)||(e=a.getObjectIndex(t.decoration),m(e))||(u+="dc:"+e+","),m(t.mask)||(n=a.getObjectIndex(t.mask),m(n))||(u+="ma:"+n+","),!m(t.formatter)&&h(t.formatter)&&(u+="fs:"+(s=o.getTextIndex(t.formatter))+","),(i=r.Dd.nv(t))!==g&&(u+="j:"+i+","),u.substring(0,u.length-1)},R.prototype.vv=function(t,u){var s,c,f,l,h;if(t)return s=new v.Style,f=(c=this).cd,l=c.yd,h=c.Hd,t.split(",").forEach(function(t){var t,n,e,i,i,i,i,r,o,a,i,o,t=t.split(":"),n=t[0],e=t[1];switch(n){case"t":s.sheetId=+e;break;case"c":i=c.Ed.ev(+e),s.backColor=i;break;case"f":i=c._d.ev(+e),E(s,i);break;case"h":s.hAlign=+e;break;case"v":s.vAlign=+e;break;case"b":i=c.jd.ev(+e,u),E(s,i);break;case"l":s.locked=p(e);break;case"w":s.wordWrap=p(e);break;case"se":s.showEllipsis=p(e);break;case"st":s.hv=p(e);break;case"s":s.shrinkToFit=p(e);break;case"ts":s.tabStop=p(e);break;case"q":s.quotePrefix=p(e);break;case"va":s.isVerticalText=p(e);break;case"y":s.applyFont=p(e);break;case"z":s.applyFill=p(e);break;case"r":s.applyAlignment=p(e);break;case"e":s.applyBorder=p(e);break;case"u":s.applyProtection=p(e);break;case"g":s.applyNumberFormat=p(e);break;case"i":s.textIndent=+e;break;case"im":s.imeMode=+e;break;case"o":s.opacity=+e;break;case"bl":s.backgroundImageLayout=+e;break;case"x":s.textOrientation=+e;break;case"bi":s.backgroundImage=f.getText(+e);break;case"n":s.parentName=m(e)||!u&&0==+e?g:h[e];break;case"k":s.watermark=f.getText(+e);break;case"p":s.cellPadding=f.getText(+e);break;case"tb":s.textBaseline=f.getText(+e);break;case"lo":s.labelOptions=JSON.parse(f.getText(+e));break;case"ct":i=F.ti,(r=l.getObject(+e))&&(o=r.typeName,a=void 0,(i=i[r.type]||i[o]||d.getTypeFromString(o))&&(a=new i).fromJSON(r,!0),s.cellType=a);break;case"cb":s.cellButtons=JSON.parse(l.getObject(+e));break;case"dd":s.dropDowns=JSON.parse(l.getObject(+e));break;case"dc":s.decoration=JSON.parse(l.getObject(+e));break;case"ma":s.mask=JSON.parse(l.getObject(+e));break;case"fs":s.formatter=f.getText(+e);break;case"j":o=c.Dd.ev(+e),E(s,o)}}),s},R.prototype.mv=function(t,n){var e=this;if(!m(t))return t=n&&e.gv&&e.gv[t]&&e.gv[t][n]?e.gv[t][n]:t},R.prototype.getNamedStyle=function(t,n,e){var i,r,o,o,i=this,r,o=i.Rd.getText(t);if(o!==g)return(o=o?i.vv(o,e):new v.Style).name=n,i.Hd[t]=n,o},R.prototype.getNamedStyleIndex=function(t,n,e,i,r){var o,a,u,s,c,f,l,e;if(t)return a=(o=this).Rd,u=o.Pd,s=o.qd,f=o.Kd,l=t.name,l=o.mv(l,e),e=o.lv(t,n,i,!0),r&&(!l||s.test(l))||(c=a.getTextIndex(e),f[u[l]=c]={parentName:t.parentName,name:l}),c},R.prototype.updateNamedStylesParentName=function(){var t=this,i=t.Rd,r=t.Pd,o=t.Kd;Object.keys(o).forEach(function(t){var n,e,n,t,t,n=o[t],e=n.parentName,n=n.name;m(e)||m(r[e])||(t=i.getText(+t),t=i.getTextIndex(t+(0<t.length?",n:":"n")+r[e]),r[n]=+t)})},R.prototype.getStyle=function(t){var n,e,i,i,r,o,o,n=this,e,i=n.Yd[t];return i!==g?i:(r=(i=n.Ud)[t])!==g?r:(o=(o=n.Bd)&&o.getText(t))!==g?(r=n.vv(o,!1),i[t]=r):void 0},R.prototype.getStyleIndex=function(t,n,e){var i,r,o,a,u,s,c,f,a,f,l;if(t)return o=(i=this).Pd,a=i.Rd,u=i.Bd,s=i.qd,"string"==typeof t?(f=o[t=i.mv(t,e)],(c=a.getText(f)).length&&","!==c[c.length-1]&&(c+=","),+u.getTextIndex(c+="d:"+f)):(a=t._id,f=i.Fd,a!==g&&(r=f[a])!==g||((l=t.name)!==g&&!s.test(l)||(l=t.parentName),l=i.mv(l,e),(c=i.lv(t,n)).length&&","!==c[c.length-1]&&(c+=","),l!==g&&o[l]!==g?c+="n:"+o[l]:c+="n:0",r=u.getTextIndex(c),f[a]=r),r)},R.prototype.getOriginNamedStyleIndex=function(t){var n,e;return+this.originNamedStylesXfs.getTextIndex(t)},R.prototype.getOriginStyleIndex=function(t,n){var e,i,r,i,o,o,i,e=this,i=e.Wd,r=e.originCellXfs;return t?(o=t._id)!==g&&(i=i[o])!==g?i:(o=e.Pd,i=e.lv(t,n,void 0,!0),t.name&&!m(o[t.name])&&(i.length&&","!==i[i.length-1]&&(i+=","),i+="d:"+o[t.name]),t.parentName&&!m(o[t.parentName])&&(i.length&&","!==i[i.length-1]&&(i+=","),i+="n:"+o[t.parentName]),+r.getTextIndex(i)):+r.getTextIndex(f)},R.prototype.getOriginStyle=function(t){var n,e,i,e,n,n=this,e=n.originCellXfs,i=n.Qd;return i[t]!==g?i[t]:(e=e.getText(t))?(n=n.vv(e,!0),i[t]=n):f},R.prototype.getOriginNamedStyle=function(t){var n,e;return this.originNamedStylesXfs.getText(t)},R.prototype.getDxf=function(t,n,e,i){var r,o;return this.kd.fv(t,n,e,i)},R.prototype.getDxfIndex=function(t,n,e){var i,r=this.kd;return t?r.cv(t,n,e):g},R.prototype.addTableStyle=function(n){0<this.zd.filter(function(t){return t.name===n.name}).length||this.zd.push(n)},R.prototype.addDefaultStyleName=function(t,n){this.Vd[t]=n},R.prototype.getDefaultStyleName=function(t){return this.Vd[t]},R.prototype.getFormatCodeByNumFmtId=function(t){return this.Dd.uv(t)},R.prototype.buildDummyNamedStyles=function(t){var n,e,i,r,o,a,u,s,n=this,e=n.Bd,i=n.Jd,r=e.td.length,o=n.Yd;if(0<r)for(a=0;a<r;a++)(u=n.getStyle(a)).name=s=i+a,t.addNamedStyle(u),o[a]=s},R.prototype.yh=function(e,t){var i=this;e&&(e.sharedColors&&i.Od.yh(e.sharedColors),e.commonSharedStrings&&i.cd.yh(e.commonSharedStrings),e.cellXfs&&i.Bd.yh(e.cellXfs),e.cellStyleXfs&&i.Rd.yh(e.cellStyleXfs),e.sharedObjects&&i.yd.yh(e.sharedObjects),e.originCellXfs&&i.originCellXfs.yh(e.originCellXfs),e.originNamedStylesXfs&&i.originNamedStylesXfs.yh(e.originNamedStylesXfs),i.Ed.rv(e),i.Dd.rv(e),i._d.rv(e),i.jd.rv(e),i.kd.rv(e.dxfs),i.Vd=o(e.defaultStyleNames)||{},R.fh)&&r(R.fh,function(t,n){n.yh&&n.yh.call(i,e)})},R.prototype.wh=function(t){var e=this,i={sharedColors:e.Od.wh(),commonSharedStrings:e.cd.wh(),cellXfs:e.Bd.wh(),cellStyleXfs:e.Rd.wh(),sharedObjects:e.yd.wh(),namedStylesMap:e.Pd,defaultStyleNames:o(e.Vd),originCellXfs:e.originCellXfs.wh(),originNamedStylesXfs:e.originNamedStylesXfs.wh()};return e.Dd.iv(i),e._d.iv(i),e.Ed.iv(i),e.jd.iv(i),i.dxfs=e.kd.iv(),0<e.zd.length&&(i.tableStyles={n_:"tableStyles",c_:[].concat(e.zd),defaultPivotStyle:e.getDefaultStyleName("defaultPivotStyle")||"PivotStyleLight16",defaultTableStyle:e.getDefaultStyleName("defaultTableStyle")||"TableStyleMedium2",count:e.zd.length}),R.fh&&r(R.fh,function(t,n){n.wh&&n.wh.call(e,i)}),i},R.prototype.bv=function(t,n){for(var e in n)n.hasOwnProperty(e)&&(t[e]=n[e]);return t},t.StyleManager=n=R,(0,s.$e)(n)},"./dist/core/util/tasks.js":function(t,n){"use strict";var e,i,r,o,a,u,s,c,f,l;function h(t,n){this.fn=t,this.args=n}function d(t,n){var e=this;e.tasks=[],e.nextTaskFunc=t.bind(e),e.isBusyFunc=n.bind(e)}function v(t,n,e,i,r){var t=f.call(this,t,n)||this;return t.description=e,t.progress=i,t.sheetName=r,t}function m(t,n,e){void 0===e&&(e=function(t){});var t=l.call(this,t,n)||this;return t.progress=e,t}e=this&&this.__extends||(c=function(t,n){return(c=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}c(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(n,"__esModule",{value:!0}),n.LoadTasks=n.LoadTask=n.Tasks=n.Task=void 0,i=100,r=10,h.prototype.dispose=function(){this.fn=void 0,this.args=void 0},h.prototype.run=function(){this.fn.apply(null,this.args)},o=h,n.Task=o,d.prototype.addTask=function(t,n,e){this.tasks.splice(0,0,new o(t,n))},d.prototype.pushTask=function(t,n,e){this.tasks.push(new o(t,n))},d.prototype.runNextTask=function(){var t,n,e,t=this,n=t.tasks;t.isTerminated||(n.length<1?t.endingCallback&&t.endingCallback():t.isBusyFunc()?setTimeout(function(){t.runNextTask()},100):((e=t.nextTaskFunc()).run(),setTimeout(function(){t.runNextTask()},10)))},d.prototype.start=function(){var t;this.runNextTask()},d.prototype.terminate=function(){var t=this;t.tasks&&(t.tasks.forEach(function(t){t.dispose()}),t.tasks=[]),t.endingCallback=void 0,t.isTerminated=!0},n.Tasks=a=d,e(v,f=o),v.prototype.dispose=function(){this.description=void 0,this.progress=void 0,this.sheetName=void 0,f.prototype.dispose.call(this)},u=v,n.LoadTask=u,e(m,l=a),m.prototype.runNextTask=function(){var t,n,e,n,t=this,n=t.tasks,e=t.progress;t.isTerminated||(n.length<1?t.endingCallback&&t.endingCallback():t.isBusyFunc()?setTimeout(function(){t.runNextTask()},100):((n=t.nextTaskFunc()).description&&e({progress:n.progress&&n.progress(),step:n.description,sheetName:n.sheetName}),n.run(),n.dispose(),setTimeout(function(){t.runNextTask()},0)))},m.prototype.addTask=function(t,n,e,i,r){this.tasks.splice(0,0,new u(t,n,e,i,r))},m.prototype.pushTask=function(t,n,e,i,r){this.tasks.push(new u(t,n,e,i,r))},m.prototype.terminate=function(){this.progress=void 0,l.prototype.terminate.call(this)},n.LoadTasks=m},"./dist/core/util/theme.js":function(L,t,n){"use strict";var e,i,a,p,o,v,u,s,r,c,n,e,i,f,l,h,d,m,B,F,P,G,U,H,V,g,b,w,y,M,C,S,S,C,T,M;function A(n){var e=n;return function(t){return 0===arguments.length?this.yv[e]:(this.yv[n]=v(t),this)}}function I(t){return t<=0?0:t<=.0031308?255*t*12.92+.5:t<1?255*(1.055*Math.pow(t,.4166666666666667)-.055)+.5:255}function z(t){var n,e,i,i,r,i,r,o,i,r,o,n=t.n_.split(":").pop(),e=t.val;return"sysClr"===n?void 0!==(i=g[e.toUpperCase()])?a.ColorHelper.hexToARGB(i):(i=t.lastClr)?(r=4278190080+(16777215&parseInt(i,16)),a.ColorHelper.hexToARGB(r)):void 0:"srgbClr"===n&&e?(r=4278190080+(16777215&parseInt(e,16)),a.ColorHelper.hexToARGB(r)):"scrgbClr"===n?(i=parseFloat(t._r),r=parseFloat(t.g),o=parseFloat(t.b),{a:255,r:I(i),g:I(r),b:I(o)}):"hslClr"===n?(i=parseFloat(t.wv),r=parseFloat(t.sat),o=parseFloat(t.lum),a.util.v1(i,o,r)):"prstClr"===n&&e?a.util.m1(e):void 0}function x(t){var t=t.toString(16).toUpperCase();return t=1===t.length?"0"+t:t}function N(t,n){return{n_:t,c_:[{n_:"srgbClr",val:x(n.r)+x(n.g)+x(n.b)}]}}function k(t,n,e,i,r,o,a,u,s,c,f,l,h){this.background1=A(0),this.background2=A(1),this.textColor1=A(2),this.textColor2=A(3),this.accent1=A(4),this.accent2=A(5),this.accent3=A(6),this.accent4=A(7),this.accent5=A(8),this.accent6=A(9),this.hyperlink=A(10),this.followedHyperlink=A(11),this.Zc=t,this.yv=[];for(var d=1;d<13;d++)this.yv.push(v(arguments[d]))}function _(t){return t=t&&"'"===t[0]?t.slice(1,t.length-1):t}function D(t,n,e){this.Zc=t,this.Ide=n,this.See=e}function j(t,n,e,i){var r,o,r=this;this.name=s("name"),this.colors=s("colors"),this.fmtTheme=s("fmtTheme",void 0,function(){r.Mv={}}),(o=this).name(t),o.colors(n||new w(t)),"string"!=typeof e&&e instanceof y?this.font(e):this._font=new y(void 0,e,i)}function E(){}function O(){}function R(){}Object.defineProperty(t,"__esModule",{value:!0}),t.Themes=t.ThemeFonts=t.ThemeColors=t.Theme=t.ThemeFont=t.ColorScheme=void 0,e=n("Common"),i=n("./dist/core/util/common.js"),a=n("./dist/core/util/common.js"),p=e.Common.lt.ht,o=e.Common.ft,v=o._,u=parseInt,s=i.util.p0,r=a.util.xr,c=a.util.o1,n="Gill Sans MT",e="Franklin Gothic Book",i="Trebuchet MS",l=1,h=2,d=3,m=4,B=5,F=6,P=7,G=8,U=9,H=10,V=11,g={"3DDKSHADOW":4288716960,"3DLIGHT":4293125091,ACTIVEBORDER:4290032820,ACTIVECAPTION:4288263377,APPWORKSPACE:4289440683,BACKGROUND:1044480,BTNFACE:4293980400,BTNHIGHLIGHT:4294967295,BTNSHADOW:4288716960,BTNTEXT:1044480,CAPTIONTEXT:1044480,GRAYTEXT:4285361517,HIGHLIGHT:4281571839,HIGHLIGHTTEXT:4294967295,INACTIVEBORDER:4294244348,INACTIVECAPTION:4290760155,INACTIVECAPTIONTEXT:4282601044,INFOBK:4294967265,INFOTEXT:1044480,MENU:4293980400,GRADIENTACTIVECAPTION:4290367978,HOTLIGHT:267413196,GRADIENTINACTIVECAPTION:4292338930,MENUBAR:4293980400,MENUHIGHLIGHT:4281571839,MENUTEXT:1044480,SCROLLBAR:4291348680,WINDOW:4294967295,WINDOWFRAME:4284769380,WINDOWTEXT:4278190080},(M=b=b||{})[M.lt1=f=0]="lt1",M[M.lt2=1]="lt2",M[M.dk1=2]="dk1",M[M.dk2=3]="dk2",M[M.accent1=4]="accent1",M[M.accent2=5]="accent2",M[M.accent3=6]="accent3",M[M.accent4=7]="accent4",M[M.accent5=8]="accent5",M[M.accent6=9]="accent6",M[M.hlink=10]="hlink",M[M.folHlink=11]="folHlink",k.prototype.name=function(t){return 0===arguments.length?this.Zc:(this.Zc=t,this)},k.prototype.getColor=function(t){var n,e,i,r,e;if(t&&"string"==typeof t&&(e=void 0,n=t.split(" "))){if(i=-1,1<(r=n.length)){if(!n[0])return t;"background"===(e=n[0].toLowerCase())?i=u(n[1],10)-1:"text"===e?i=u(n[1],10)+1:"accent"===e&&(i=u(n[1],10)+3)}else 1===r&&("hyperlink"===(e=n[0].toLowerCase())?i=10:"followedhyperlink"===e&&(i=11));if(0<=i&&i<=11)return 2<r?(e=u(n[2],10)/100,o.j(o.Cv(this.yv[i],e))):o.j(this.yv[i])}return t},k.prototype.toJSON=function(){var t=this,n=t.yv;return{name:t.Zc,background1:n[0],background2:n[1],text1:n[2],text2:n[3],accent1:n[4],accent2:n[5],accent3:n[6],accent4:n[7],accent5:n[8],accent6:n[9],hyperlink:n[10],followedHyperlink:n[11]}},k.prototype.fromJSON=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,i,n,n;function g(t,n){p(n)||(e.yv[t]={a:n.a,r:n.r,g:n.g,b:n.b})}t&&(e=this,i="_colorList",i=n?(n=t.name||t[r="_name"],p(n)||(e.Zc=n),o=(n=t.colorList||t[i])[0],a=n[1],u=n[2],s=n[3],c=n[4],f=n[5],l=n[6],h=n[7],d=n[8],v=n[9],m=n[10],n[11]):(p(t.name)||(e.Zc=t.name),o=t.background1,a=t.background2,u=t.text1,s=t.text2,c=t.accent1,f=t.accent2,l=t.accent3,h=t.accent4,d=t.accent5,v=t.accent6,m=t.hyperlink,t.followedHyperlink),g(0,o),g(1,a),g(2,u),g(3,s),g(4,c),g(5,f),g(6,l),g(7,h),g(8,d),g(9,v),g(10,m),g(11,i))},k.prototype.yh=function(t){var n,e,i,r,o,a,o;if(t)for(e=t.c_,(n=this).Zc=t.name,i=0,r=e.length;i<r;i++)(o=e[i])&&(a=o.n_.split(":").pop(),o=o.c_[0],n.yv[b[a]]=z(o))},k.prototype.wh=function(){for(var t,n,e,i,r,o,a,t=this,n={n_:"clrScheme",name:t.name()},e=[],i=t.yv,r=0,o=i.length;r<o;r++)a=i[r],2===r?e[0]=a.r+a.g+a.b===0?{n_:"dk1",c_:[{n_:"sysClr",val:"windowText",lastClr:x(a.r)+x(a.g)+x(a.b)}]}:N("dk1",a):0===r?e[1]=a.r+a.g+a.b===765?{n_:"lt1",c_:[{n_:"sysClr",val:"window",lastClr:x(a.r)+x(a.g)+x(a.b)}]}:N("lt1",a):3===r?e[2]=N("dk2",a):1===r?e[3]=N("lt2",a):e.push(N(""+b[r],a));return n.c_=e,n},k.prototype.Sv=function(t){var n,e,i,r;if(this.name()!==t.name())return!1;for(e=0,i=(n=["textColor1","textColor2","background1","background2","accent1","accent2","accent3","accent4","accent5","accent6","hyperlink","followedHyperlink"]).length;e<i;e++)if(!o.Tv(this[r=n[e]](),t[r]()))return!1;return!0},w=k,t.ColorScheme=w,Object.defineProperty(D.prototype,"name",{get:function(){return this.Zc},set:function(t){this.Zc=t},enumerable:!1,configurable:!0}),Object.defineProperty(D.prototype,"headerFont",{get:function(){return this.Ide},set:function(t){this.Ide=t},enumerable:!1,configurable:!0}),Object.defineProperty(D.prototype,"bodyFont",{get:function(){return this.See},set:function(t){this.See=t},enumerable:!1,configurable:!0}),D.prototype.toJSON=function(){return{name:this.Zc,headerFont:this.Ide,bodyFont:this.See}},D.prototype.fromJSON=function(t){this.Zc=t.name,this.Ide=t.headerFont,this.See=t.bodyFont},y=D,t.ThemeFont=y,j.prototype.headerFont=function(t){if(0===arguments.length)return this._font.headerFont;this._font.headerFont=t},j.prototype.bodyFont=function(t){if(0===arguments.length)return this._font.bodyFont;this._font.bodyFont=t},j.prototype.font=function(t){if(0===arguments.length)return this._font;this._font=new y,this._font.fromJSON(t.toJSON())},j.prototype.getColor=function(t){return this.colors().getColor(t)},j.prototype.getFont=function(t){return"Body"===t?this.bodyFont():"Headings"===t?this.headerFont():t},j.prototype.toJSON=function(){var t=this,n=t.name();return j.Av(t)?n:{name:n,themeColor:t.colors()?t.colors().toJSON():void 0,headingFont:t.headerFont(),bodyFont:t.bodyFont(),font:t._font.toJSON()}},j.prototype.fromJSON=function(t){var n;"string"==typeof t?(n=T[t],this.name(n.name()),this.colors(n.colors()),this.headerFont(n.headerFont()),this.bodyFont(n.bodyFont()),this.font(n.font())):(this.name(t.name),this.bodyFont(t.bodyFont),this.headerFont(t.headingFont),this.colors().fromJSON(t.themeColor),t.font&&this._font.fromJSON(t.font))},j.prototype.wh=function(t){var n,e,i,r,t,n=this,e=n.name();return!1!==t&&j.Av(n)?e:(t={n_:"themeElements",c_:[]},(r=(i=n.colors())?i.wh():r)&&t.c_.push(r),t.c_.push({n_:"fontScheme",c_:[{n_:"majorFont",c_:[{n_:"latin",typeface:_(n.headerFont())}]},{n_:"minorFont",c_:[{n_:"latin",typeface:_(n.bodyFont())}]}],name:n._font.name}),{n_:"theme",name:e,c_:[t]})},j.prototype.yh=function(t){var n,t,e,i,e,i,n=this;"string"==typeof t?n.Iv(t):(n.Iv(t.name),t=r(t,"themeElements"),e=r(t,"clrScheme"),(i=new w("")).yh(e),n.colors(i),(e=r(t,"fontScheme"))&&(n.headerFont(c(e,"majorFont&latin").typeface),n.bodyFont(c(e,"minorFont&latin").typeface),e.name)&&(n._font.name=e.name),(i=r(t,"fmtScheme"))&&n.fmtTheme(i))},j.prototype.Iv=function(t){var n,t,n=this;t&&"OFFICE"===t.toUpperCase().substring(0,6)&&(t="Office"),n.name(t),(t=T[t])&&(n.colors(t.colors()),n.font(t.font()))},j.Av=function(t){var n,n,n=t.name();return!!T[n]&&(n=T[n],t.bodyFont()===n.bodyFont())&&t.headerFont()===n.headerFont()&&t.font().name===n.font().name&&t.colors().Sv(n.colors())},M=j,t.Theme=M,E.Default=new w("Default",S="#FFFFFF","#EEECE1",C="#000000","#1F497D","#4F81BD","#C0504D","#9BBB59","#8064A2","#4BACC6","#F79646","#0000FF","#800080"),E.Office2007=new w("Office2007",S,"#EEECE1",C,"#1F497D","#4F81BD","#C0504D","#9BBB59","#8064A2","#4BACC6","#F79646","#0000FF","#800080"),E.Office=new w("Office",S,"#E7E6E6",C,"#44546A","#5B9BD5","#ED7D31","#A5A5A5","#FFC000","#4472C4","#70AD47","#0563C1","#954F72"),E.Apex=new w("Apex",S,"#C9C2D1",C,"#69676D","#CEB966","#9CB084","#6BB1C9","#6585CF","#7E6BC9","#A379BB","#410082","#932968"),E.Aspect=new w("Aspect",S,"#E3DED1",C,"#323232","#F07F09","#9F2936","#1B587C","#4E8542","#604878","#C19859","#6B9F25","#B26B02"),E.Concourse=new w("Concourse",S,"#DEF5FA",C,"#464646","#2DA2BF","#DA1F28","#EB641B","#39639D","#474B78","#7D3C4A","#FF8119","#44B9E8"),E.Civic=new w("Civic",S,"#C5D1D7",C,"#646B86","#D16349","#CCB400","#8CADAE","#8C7B70","#8FB08C","#D19049","#00A3D6","#694F07"),E.Oriel=new w("Oriel",S,"#FFF39D",C,"#575F6D","#FE8637","#7598D9","#B32C16","#F5CD2D","#AEBAD5","#777C84","#D2611C","#3B435B"),E.Origin=new w("Origin",S,"#DDE9EC",C,"#464653","#727CA3","#9FB8CD","#D2DA7A","#FADA7A","#B88472","#8E736A","#B292CA","#6B5680"),E.Paper=new w("Paper",S,"#FEFAC9",C,"#444D26","#A5B592","#F3A447","#E7BC29","#D092A7","#9C85C0","#809EC2","#8E58B6","#7F6F6F"),E.Solstice=new w("Solstice",S,"#E7DEC9",C,"#4F271C","#3891A7","#FEB80A","#C32D2E","#84AA33","#964305","#475A8D","#8DC765","#AA8A14"),E.Technic=new w("Technic",S,"#D4D2D0",C,"#3B3B3B","#6EA0B0","#CCAF0A","#8D89A4","#748560","#9E9273","#7E848D","#00C8C3","#A116E0"),E.Trek=new w("Trek",S,"#FBEEC9",C,"#4E3B30","#F0A22E","#A5644E","#B58B80","#C3986D","#A19574","#C17529","#AD1F1F","#FFC42F"),E.Urban=new w("Urban",S,"#DEDEDE",C,"#424456","#53548A","#438086","#A04DA3","#C4652D","#8B5D3D","#5C92B5","#67AFBD","#C2A874"),E.Verve=new w("Verve",S,"#D2D2D2",C,"#666666","#FF388C","#E40059","#9C007F","#68007F","#005BD3","#00349E","#17BBFD","#FF79C2"),E.Equity=new w("Equity",S,"#E9E5DC",C,"#696464","#D34817","#9B2D1F","#A28E6A","#956251","#918485","#855D5D","#CC9900","#96A9A9"),E.Flow=new w("Flow",S,"#DBF5F9",C,"#04617B","#0F6FC6","#009DD9","#0BD0D9","#10CF9B","#7CCA62","#A5C249","#E2D700","#85DFD0"),E.Foundry=new w("Foundry",S,"#EAEBDE",C,"#676A55","#72A376","#B0CCB0","#A8CDD7","#C0BEAF","#CEC597","#E8B7B7","#DB5353","#903638"),E.Median=new w("Median",S,"#EBDDC3",C,"#775F55","#94B6D2","#DD8047","#A5AB81","#D8B25C","#7BA79D","#968C8C","#F7B615","#704404"),E.Metro=new w("Metro",S,"#D6ECFF",C,"#4E5B6F","#7FD13B","#EA157A","#FEB80A","#00ADDC","#738AC8","#1AB39F","#EB8803","#5F7791"),E.Module=new w("Module",S,"#D4D4D6",C,"#5A6378","#F0AD00","#60B5CC","#E66C7D","#6BB76D","#E88651","#C64847","#168BBA","#680000"),E.Opulent=new w("Opulent",S,"#F4E7ED",C,"#B13F9A","#B83D68","#AC66BB","#DE6C36","#F9B639","#CF6DA4","#FA8D3D","#FFDE66","#D490C5"),t.ThemeColors=S=E,O.Office=new y("Office","Calibri Light","Calibri"),O.Office2007=new y("Office2007","Cambria","Calibri"),O.LucidaBook=new y("LucidaBook","Lucida Sans","Book Antiqua"),O.Verdana=new y("Verdana","Verdana","Verdana"),O.LucidaSansUnicode=new y("LucidaSansUnicode","Lucida Sans Unicode","Lucida Sans Unicode"),O.Georgia=new y("Georgia","Georgia","Georgia"),O.CenturySchoolbook=new y("CenturySchoolbook","Century Schoolbook","Century Schoolbook"),O.BookmanGillSansMT=new y("BookmanGillSansMT","Bookman Old Style",n),O.Constantia=new y("Constantia","Constantia","Constantia"),O.GillSansMT=new y("GillSansMT",n,n),O.FranklinGothicArial=new y("FranklinGothicArial",e,"Arial"),O.FranklinGothic=new y("FranklinGothic","Franklin Gothic Medium",e),O.TrebuchetGeorgia=new y("TrebuchetGeorgia",i,"Georgia"),O.CenturyGothic=new y("CenturyGothic","Century Gothic","Century Gothic"),O.FranklinGothicPerpetua=new y("FranklinGothicPerpetua",e,"Perpetua"),O.CalibriConstantia=new y("CalibriConstantia","Calibri","Constantia"),O.Rockwell=new y("Rockwell","Rockwell","Rockwell"),O.TwCenMT=new y("TwCenMT","Tw Cen MT","Tw Cen MT"),O.ConsolasCorbel=new y("ConsolasCorbel","Consolas","Corbel"),O.Corbel=new y("Corbel","Corbel","Corbel"),O.TrebuchetMS=new y("TrebuchetMS",i,i),t.ThemeFonts=C=O,R.Default=new M("Default",S.Default,"Cambria","Calibri"),R.Office=new M("Office",S.Office,C.Office),R.Office2007=new M("Office2007",S.Office2007,C.Office2007),R.Apex=new M("Apex",S.Apex,C.LucidaBook),R.Aspect=new M("Aspect",S.Aspect,C.Verdana),R.Concourse=new M("Concourse",S.Concourse,C.LucidaSansUnicode),R.Civic=new M("Civic",S.Civic,C.Georgia),R.Oriel=new M("Oriel",S.Oriel,C.CenturySchoolbook),R.Origin=new M("Origin",S.Origin,C.BookmanGillSansMT),R.Paper=new M("Paper",S.Paper,C.Constantia),R.Solstice=new M("Solstice",S.Solstice,C.GillSansMT),R.Technic=new M("Technic",S.Technic,C.FranklinGothicArial),R.Trek=new M("Trek",S.Trek,C.FranklinGothic),R.Urban=new M("Urban",S.Urban,C.TrebuchetGeorgia),R.Verve=new M("Verve",S.Verve,C.CenturyGothic),R.Equity=new M("Equity",S.Equity,C.FranklinGothicPerpetua),R.Flow=new M("Flow",S.Flow,C.CalibriConstantia),R.Foundry=new M("Foundry",S.Foundry,C.Rockwell),R.Median=new M("Median",S.Median,C.TwCenMT),R.Metro=new M("Metro",S.Metro,C.ConsolasCorbel),R.Module=new M("Module",S.Module,C.Corbel),R.Opulent=new M("Opulent",S.Opulent,C.TrebuchetMS),T=R,t.Themes=T},"./dist/core/workbook/sheettab.js":function(t,n,e){"use strict";var i,r,m,w,g,y,M,o,a,f,u,s,c,l,h;function d(t){var t,n,t=h.call(this,t)||this;return t.xv=4,t.Nv="white",(n=t).kv=13,n.Dv=12,n._v=0,n.Ev=30,n.jv=28,n.Ov=28,n.Rv=g.NEW_TAB_SIZE_ASIDE,n.Bv=15,n.Lv=28,n.Fv=0,n._font="10pt Segoe UI",t}i=this&&this.__extends||(l=function(t,n){return(l=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}l(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(n,"__esModule",{value:!0}),n.Gv=void 0,r=e("Common"),m=e("./dist/core/util/common.js"),w=e("./dist/core/worksheet/stylehelper.js"),g=e("./dist/core/workbook/sheettabbase.js"),y=e("./dist/core/core.enum.js"),M=r.Common.ft,o=M.Uv,a=M._,f=null,u="blank",s="nextButton",h=g.Hv,i(d,h),d.prototype.zv=function(){var t=this.Vv,t=t&&t.options;return t&&t.tabNavigationVisible?this.jv*(t.useTouchLayout?1.5:1):0},d.prototype.Yv=function(){var t=this.Vv;return t&&t.options.tabNavigationVisible?t.Zv():0},d.prototype.Wv=function(){return this.Ov},d.prototype.Qv=function(){return this.Kv?0:this.Ov},d.prototype.Jv=function(){var t,n,t,n;return!this.Vv.options.newTabVisible||this.Kv?0:this.Rv},d.prototype.Xv=function(){var t,n,e,i,r,o,a,u,s,t=this,n=t.Vv.qv(),e=t.$v,i=t.tm();for(t.nm()&&(i-=t.em()),r=t.im(),o=t.ot(),a=r?o.x+o.width-t.rm()-t.Jv()-t.Qv():o.y+o.height-t.Yv(),u=t.om,s=n.length;u<s;u++)if(n[u].visible()===y.SheetTabVisible.visible&&(i+=r?e[u]:t.am),a<i){i=a;break}return i},d.prototype.tm=function(){var t,n,e,n,e,n,t=this,n=t.Vv.options,e=t.im(),n=n.tabNavigationVisible;return e?(e=2*t.em(),n&&(e-=t.em()),2*t.zv()+t.Wv()+t.um()+e):(n=t.cm(),t.nm()&&(n=0),Math.max(t.Jv(),n))},d.prototype.um=function(){var t=this,n=t.Vv;return n&&n.options.tabNavigationVisible?t.rm()/2:0},d.prototype.getResizeBarBounds=function(){var t,n,t=this,n=t.ot();return{x:n.x+n.width-t.rm(),y:f,width:t.rm(),height:f}},d.prototype.getNavButtonBounds=function(){var t,n,e,i,r,o,a,u,o,s,t,t=this,n,o=t.im()?(e=t.rm()/2,i=f,r=t.zv(),f):(o=t.ot(),s=t.Yv(),t=t.zv(),e=o.width/2-t,i=o.height-s,r=t,s),a=1,u=3;return{x:e,y:i,width:r,height:o,startIndex:1,endIndex:3}},d.prototype.getSheetTabBounds=function(){var t,n,e,i,t=this,n=t.ot(),e=t.Qv(),i=t.tm();return t.nm()&&(i-=t.em()),{x:i,y:f,height:f,secondMoreTabWidth:t.Qv(),moreTabPos:n.x+n.width-t.rm()-t.Jv()-e}},d.prototype.getPreMoreTabBounds=function(){var t,n,t=this,n=t.tm();return t.nm()&&(n-=t.em()),{x:n-t.Wv(),width:t.Wv()}},d.prototype.getAllSheetsBounds=function(){var t,n,e,i,r,o,a,u,s,c,f,r,n,n,a,i,t=this,n=t.im(),e=t.Vv.options.newTabVisible,i=t.Vv.options.tabNavigationVisible,r=t.Vv.options.useTouchLayout,o=t.ot(),a=t.getNavButtonBounds(),u=t.em(),s=t.cm(),n=(r=n?(c=a.x+2*a.width,c+=t.em()-t.rm()/2,0===t.rm()&&i&&(c-=t.em()),f=o.y,u):r?(n=o.x,a=o.width,e&&(n=o.x+o.width/2,a=o.width/2),c=n,f=o.y,a):(i=e?0:t.Bv/-2,c=(o.x+o.width)/2+i,f=5,u+4),s);return{x:c,y:f,width:r,height:n}},d.prototype.fm=function(){var t,n,t=this,n;return t.im()?t.lm+t.$v[t.hm]>t.dm():t.lm+2*t.am>t.dm()},d.prototype.dm=function(){var t,n,t=this,n;return t.im()?t.ot().width-t.rm()-t.Jv()-t.Qv():t.ot().height-t.Yv()},d.prototype.vm=function(){return 6},d.prototype.mm=function(){return[u,s]},d.prototype.gm=function(){return this.tm()},d.prototype.pm=function(t,n){var e,i,e=this;t.save(),t.beginPath(),i=m.I.He(0,"gc-tabStripBackground").backgroundColor,e.bm=a(i),t.fillStyle=i,t.fillRect(n.x,n.y,n.width,n.height),t.restore()},d.prototype.ym=function(t,n){var e,i,i,r,o,a,u,s,e,i=this.Vv,i=i&&i.options.tabStripPosition,r=m.I.He(0,"gc-tabStripBackground").borderTopColor;t.save(),t.beginPath(),t.strokeStyle=r,i===y.TabStripPosition.bottom?(o=n.x,a=n.y,u=n.x+n.width,s=n.y+.5):i===y.TabStripPosition.top?(o=n.x,a=n.height-.5,u=n.x+n.width,s=n.y+n.height-.5):i===y.TabStripPosition.left?(o=n.x+n.width-.5,a=n.y,u=n.x+n.width-.5,s=n.y+n.height):i===y.TabStripPosition.right&&(o=n.x+.5,a=n.y,u=n.x+.5,s=n.y+n.height),t.moveTo(o,a),t.lineTo(u,s),t.stroke(),t.restore()},d.prototype.wm=function(t,n){var e=this;e.pm(t,n),e.ym(t,n)},d.prototype.Mm=function(t,n,e){var i,r,o,a,u,s,e,c,f,l,a,l,l,s,i=this,r,o=i.Vv.options.newTabVisible,a=i.im(),u=i.tm(),s=i.jv,e=e,c=0,f=s;a?(i.nm()&&(u-=i.em()),e+=a=i.Qv(),(l=n.x+n.width-i.rm()-i.Jv())<e&&((l=(e=l)-a)<u&&(e=(l=u)+s),i.Cm(t,l,0,a,n.height)),l=n.height):(s=i.em(),i.nm()&&(s=0),e=(n.width-u)/2-s,f=l=u),o&&i.Sm(t,e,0,f,l,-2===i.Tm)},d.prototype.Am=function(t,n,e,i){var r=this.Wv();this.Cm(t,i-r,0,r,n.height)},d.prototype.Im=function(t,n){var e,i,r,o,a,u,s,c,e=this,i=e.im(),r=e.xm,o=e.zv(),a=e.Yv(),u=e.Nm;i?(s=e.rm()/2+o/2,e.km(t,s,c=a/2,s+r,c+r,s+r,c-r,g.NavButtonDirection.left,f,1===u),e.km(t,s+=o,c,s-r,c+r,s-r,c-r,g.NavButtonDirection.right,f,2===u)):(s=(n.width-o)/2,c=n.height-a/2,e.km(t,s,c,s+r,c+r,s-r,c+r,g.NavButtonDirection.top,f,1===u),e.km(t,s+=o,c,s-r,c+r,s-r,c-r,g.NavButtonDirection.bottom,f,2===u))},d.prototype.Dm=function(t,n){var e,i,r,o,i,a,u,s,c,a,e=this,i=e.Vv.options,r=i.allSheetsListVisible,o=i.newTabVisible,i=i.tabNavigationVisible,a=e.im(),u=e.tm();e.nm()&&(u-=e.em()),s=0,c=10,a?(s=2*e.zv()+e.em(),0===e.rm()&&i&&(s-=e.em())):(a=o?e.em():e.em()/2,s=(n.width-u)/2+a),r!==y.AllSheetsListVisibility.hide&&e._m(t,s,10,-3===e.Tm)},d.prototype.Em=function(t,n){var e,e,i,i,r,e=this,i=e.rm(),r=m.I.He(0,"gc-tabStripResizeBarInner");e.Vv.options.showHorizontalScrollbar&&(t.beginPath(),t.rect(n.x+n.width-i,0,i,n.height),t.clip(),e=n.x+n.width-i/2,i=n.y+n.height/2,t.fillStyle=r.color,t.fillRect(e,i,2,2),t.fillRect(e,i-4,2,2),t.fillRect(e,i+4,2,2))},d.prototype.jm=function(t,n,e,i,r,o,a,u){var s,c,f,l,h,d,v,s,s=this,c,f=s.Vv.options.tabStripPosition,l=s.Om,h=s.Nv,d=s.xv,v=s.Rm,s=s.im();t.save(),u&&a&&(t.fillStyle=h,f===y.TabStripPosition.bottom?t.fillRect(n,e,i,r-d):f===y.TabStripPosition.top?t.fillRect(n,e+d,i,r):f===y.TabStripPosition.left?t.fillRect(n+l,e,i-l,r):t.fillRect(n,e,i-l,r)),a?(t.fillStyle=h,f===y.TabStripPosition.bottom?t.fillRect(n,e+1,i,r-d):f===y.TabStripPosition.top?t.fillRect(n,e+d-1,i,r):u?f===y.TabStripPosition.left?t.fillRect(n+l,e,i-l,r+1):t.fillRect(n,e,i-l,r+1):t.fillRect(n+l,e,i-2*l,r+1)):u&&(t.fillStyle=h,f===y.TabStripPosition.bottom?t.fillRect(n,e,i,1):f===y.TabStripPosition.top?t.fillRect(n,e+r,i,1):f===y.TabStripPosition.left?t.fillRect(n+l,e,i-l,r+1):t.fillRect(n,e,i-l,r+1)),t.fillStyle=o,s?t.fillRect(n+v,e+v,i-2*v+1,r-2*v):u?f===y.TabStripPosition.left?t.fillRect(n+l,e,i-l,r+1):t.fillRect(n,e,i-l,r+1):t.fillRect(n+l,e,i-2*l,r+1),t.restore()},d.prototype.Bm=function(t,n,e,i,r,o,a){var u,s,c,f,l,u,u=this,s,c=u.Vv.options.tabStripPosition,f=u.xv,l=u.Om,u=u.im();t.save(),u?(t.beginPath(),t.lineWidth=1,t.strokeStyle=o&&o.borderLeftColor,a?c===y.TabStripPosition.bottom?(t.moveTo(n+.5,e),t.lineTo(n+.5,e+r-f),t.moveTo(n+i+.5,e),t.lineTo(n+i+.5,e+r-f)):c===y.TabStripPosition.top&&(t.moveTo(n+.5,e+f),t.lineTo(n+.5,e+r),t.moveTo(n+i+.5,e+f),t.lineTo(n+i+.5,e+r)):(t.moveTo(n+.5,e+f),t.lineTo(n+.5,e+r-f),t.moveTo(n+i+.5,e+f),t.lineTo(n+i+.5,e+r-f))):(t.beginPath(),t.lineWidth=1,t.strokeStyle=o&&o.borderLeftColor,a?c===y.TabStripPosition.left?(t.moveTo(n+l,e+.5),t.lineTo(n+l+i,e+.5),t.moveTo(n+l,e+r+.5),t.lineTo(n+l+i,e+r+.5)):(t.moveTo(n,e+.5),t.lineTo(n+i-l,e+.5),t.moveTo(n,e+r+.5),t.lineTo(n+i-l,e+r+.5)):(t.moveTo(n+l,e+.5),t.lineTo(n-l+i,e+.5),t.moveTo(n+l,e+r+.5),t.lineTo(n-l+i,e+r+.5))),t.stroke(),t.restore()},d.prototype.Lm=function(t,n,e,i,r,o,a){var u,s,c,f,u,u=this,s,c=u.Vv.options.tabStripPosition,f=u.xv,u=u.Om;a&&(t.save(),t.beginPath(),t.strokeStyle=o&&o.borderBottomColor,t.lineWidth=2,c===y.TabStripPosition.bottom?(t.moveTo(n,e+r-f),t.lineTo(n+i+1,e+r-f)):c===y.TabStripPosition.top?(t.moveTo(n,e+f),t.lineTo(n+i+1,e+f)):c===y.TabStripPosition.left?(t.moveTo(n+u,e),t.lineTo(n+u,e+r+1)):(t.moveTo(i-u,e),t.lineTo(i-u,e+r+1)),t.stroke(),t.restore())},d.prototype.Fm=function(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,v,m,g,g,g,p,a,p,f,h,b,p,l=this,h=l.Vv.options.tabStripPosition,d=l.Om,v=l.Rm,m=l.Pm,g=l.Vv.Gm(o),g=g&&g.options,g=g&&g.sheetTabColor;t.save(),t.textBaseline="top",a=l.Um(a,p="string"==typeof u?u:p),t.fillStyle=a,(f||c||s)&&(t.font=w.W.ii(t.font,"bold")),p=l.kv,t.textBaseline="middle",h===y.TabStripPosition.bottom?t.fillText(o,n+p,e+r/2-1):h===y.TabStripPosition.top?t.fillText(o,n+p,e+r/2+1):(t.beginPath(),t.rect(n+d,e+.5,(f=n+i-2*d-2*v-2-1)+v,r+.5),t.clip(),t.fillText(o,n+d+v,e+r/2+2),h=t.measureText(m).width,f<(b=t.measureText(o).width)-h&&(t.beginPath(),p=void 0,p=g?u:c||s?l.Nv:M.j(l.bm),t.fillStyle=p,t.fillRect(n+d+v+f-h,e+1.5,f,r-1.5),t.fillStyle=a,t.fillText(m,n+d+v+f-h,e+r/2+2))),t.restore()},d.prototype.Hm=function(t,n,e,i,r,o,a,u,s,c){var f,l,l,h,d,f=this,l=y.VisualState.normal;u&&(l=y.VisualState.hover),c&&(l=y.VisualState.selected),a&&(l=y.VisualState.active),a&&!c&&(l=y.VisualState.activeNotSelected),l=m.I.He(l,"gc-tab-"+m.I.Ee(l)),h=m.I.He(0,"gc-tab-"+m.I.Ee(0)),d=f.zm(t,a,s,h,e),f.jm(t,n,e,i,r,d,c,a),f.Bm(t,n,e,i,r,h,a),f.Lm(t,n,e,i,r,l,c),f.Fm(t,n,e,i,r,s,l,d,c,a,u)},d.prototype.km=function(t,n,e,i,r,o,a,u,s,c){var f,l,h,d,v,c,f;t.save(),f=this,l=u===g.NavButtonDirection.left||u===g.NavButtonDirection.top,h=y.VisualState.highlight,c&&(h=y.VisualState.hover),l?(u===g.NavButtonDirection.left?n-=2:e-=2,-1===(d=f.Vm(f.om))&&(h=y.VisualState.normal)):(u===g.NavButtonDirection.right?n+=2:e+=2,-1===(v=f.Ym(f.Zm()))&&(h=y.VisualState.normal)),c=m.I.He(h,"gc-navButton-"+m.I.Ee(h)),t.strokeStyle=this.Wm(c.borderTopColor),t.beginPath(),f=l?1:-1,u===g.NavButtonDirection.left||u===g.NavButtonDirection.right?(t.moveTo(n-.5,e),t.lineTo(n-.5,e+1),t.moveTo(n+f-.5,e-1),t.lineTo(n+f-.5,e+2),t.moveTo(n+2*f-.5,e-2),t.lineTo(n+2*f-.5,e+3),t.moveTo(n+3*f-.5,e-3),t.lineTo(n+3*f-.5,e+4)):u!==g.NavButtonDirection.top&&u!==g.NavButtonDirection.bottom||(t.moveTo(n,e-.5),t.lineTo(n+1,e-.5),t.moveTo(n-1,e+f-.5),t.lineTo(n+2,e+f-.5),t.moveTo(n-2,e+2*f-.5),t.lineTo(n+3,e+2*f-.5),t.moveTo(n-3,e+3*f-.5),t.lineTo(n+4,e+3*f-.5)),t.stroke(),t.restore()},d.prototype.Sm=function(t,n,e,i,r,o){var a,u,s,o,a=this;t.save(),t.beginPath(),u=(r-2*a.Qm)/2,s=y.VisualState.highlight,o&&(s=y.VisualState.hover),o=m.I.He(s,"gc-tabStripNewTab-"+m.I.Ee(s)),t.lineWidth=1.5,t.strokeStyle=a.Wm(o.borderTopColor),t.arc(n+i/2,e+r/2,u,0,2*Math.PI),t.stroke(),t.beginPath(),t.lineWidth=2,t.moveTo(n+i/2-4,e+r/2),t.lineTo(n+i/2+4,e+r/2),t.moveTo(n+i/2,e+r/2-4),t.lineTo(n+i/2,e+r/2+4),t.stroke(),t.restore()},d.prototype._m=function(t,n,e,i){var r,o,a,u,i,r=this,o=15,a=5;r.nm()&&(o=0),t.save(),t.beginPath(),u=y.VisualState.highlight,i&&(u=y.VisualState.hover),i=m.I.He(u,"gc-tab-strip-all-sheets-"+m.I.Ee(u)),t.strokeStyle=r.Wm(i.borderTopColor),t.lineWidth=2,t.moveTo(n,e),t.lineTo(n+o,e),t.moveTo(n,e+5),t.lineTo(n+o,e+5),t.moveTo(n,e+10),t.lineTo(n+o,e+10),t.stroke(),t.restore()},d.prototype.Cm=function(t,n,e,i,r){var o,a,a;t.save(),t.beginPath(),o=y.VisualState.highlight,5!==(a=this.Nm)&&6!==a||(o=y.VisualState.hover),a=m.I.He(o,"gc-navMoreButton-"+m.I.Ee(o)),t.fillStyle=this.Wm(a.borderTopColor),t.fillRect(n+i/2,e+r/2,2,2),t.fillRect(n+i/2-4,e+r/2,2,2),t.fillRect(n+i/2+4,e+r/2,2,2),t.restore()},d.prototype.Wm=function(t){var n=a(t),e=this.bm;return n.a<=.01?o(e):M.Km(e,n)?o(n):t},n.Gv=d},"./dist/core/workbook/sheettab2007.js":function(t,n,e){"use strict";var i,r,o,S,T,M,C,A,I,x,N,k,a,_,e,h,u,s,c;function f(t){var t,n,t=c.call(this,t)||this,n=t;return n.kv=12,n.Dv=8,n._v=3,n.Ev=12,n.Rv=48,n.Bv=15,n.Lv=28,n.Fv=5,n._font="10pt Arial",t}i=this&&this.__extends||(s=function(t,n){return(s=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}s(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(n,"__esModule",{value:!0}),n.Jm=void 0,r=e("./dist/core/core.ns.js"),o=e("Common"),S=e("./dist/core/util/common.js"),T=e("./dist/core/workbook/sheettabbase.js"),M=e("./dist/core/worksheet/stylehelper.js"),C=e("./dist/core/core.enum.js"),A=S.mt.ri,I=null,x=Math.min,N=Math.max,k="#92A5C7",a="newSheet",_="linear-gradient",e=new o.Common.ResourceManager(r.SR,"Sheets"),h=e.getResource.bind(e),c=T.Hv,i(f,c),f.prototype.zv=function(){var t,n,e,t=this.Vv,n=t&&t.options,e=0;return e=n&&n.tabNavigationVisible?t.Xm()*(n.useTouchLayout?2:1):e},f.prototype.Yv=function(){var t=this.Vv;return t&&t.options.tabNavigationVisible?t.Xm():0},f.prototype.tm=function(){var t,n,e,t=this,n;return t.im()?4*t.zv()+t.qm()+t.em():(e=t.cm(),t.nm()&&(e=0),Math.max(t.Jv(),e))},f.prototype.qm=function(){var t,n=this.Vv;return n&&n.options.tabNavigationVisible?2:0},f.prototype.getResizeBarBounds=function(){var t,n,t=this,n=t.ot();return{x:n.x+n.width-t.rm(),y:I,width:t.rm(),height:I}},f.prototype.getNavButtonBounds=function(){var t,n,e,i,r,o,a,u,o,s,t,t=this,n,o=t.im()?(e=0,i=I,r=t.zv(),I):(o=t.ot(),s=t.Yv(),t=t.zv(),e=o.width/2-2*t,i=o.height-s,r=t,s),a=0,u=4;return{x:e,y:i,width:r,height:o,startIndex:0,endIndex:4}},f.prototype.getSheetTabBounds=function(){var t,n,t=this,n=t.tm();return t.nm()&&(n-=t.em()),{x:n,y:I,height:I,secondMoreTabWidth:0,moreTabPos:0}},f.prototype.getPreMoreTabBounds=function(){var t,n,t=this,n=t.tm();return t.nm()&&(n-=t.em()),{x:n,width:t._v+t.Fv}},f.prototype.getAllSheetsBounds=function(){var t,n,e,i,r,o,a,u,s,c,f,r,n,n,a,i,t=this,n=t.im(),e=t.Vv.options.newTabVisible,i=t.Vv.options.tabNavigationVisible,r=t.Vv.options.useTouchLayout,o=t.ot(),a=t.getNavButtonBounds(),u=t.em(),s=t.cm(),n=(r=n?(c=a.x+4*a.width,c+=t.em()/2-t.rm()/2,0===t.rm()&&i&&(c-=t.em()/2),f=o.y,u):r?(n=o.x,a=o.width,e&&(n=o.x+o.width/2,a=o.width/2),c=n,f=o.y,a):(i=e?0:t.Bv/-2,c=(o.x+o.width)/2+i,f=5,u+4),s);return{x:c,y:f,width:r,height:n}},f.prototype.fm=function(){var t,n,t=this,n;return t.im()?t.lm+t.$v[t.hm]+t.Jv()>t.dm():t.lm+2*t.am>t.dm()},f.prototype.dm=function(){var t,n,t=this,n;return t.im()?t.ot().width-t.rm():t.ot().height-t.Yv()},f.prototype.vm=function(){var t;return this.im()?1:4},f.prototype.mm=function(){return[a]},f.prototype.gm=function(){var t,n,e,t=this,n=t.im(),e=t.tm();return e=n&&(e+=t.ot().height,t.Vv.options.newTabVisible)?(e+=t.Jv())+t._v:e},f.prototype.wm=function(t,n){var e,i,r,i,o,a,u,s;if(t.save(),t.beginPath(),e=t.createLinearGradient(n.x,n.y,n.width,n.height),r=(i=S.I.He(0,"gc-tabStripBackground"))&&i.backgroundImage,i=i&&i.backgroundColor,r&&-1!==r.indexOf(_))for(a=0,u=(o=A(r)).length;a<u;a++)s=o[a],e.addColorStop(s.point,s.color);else i&&(e.addColorStop(0,"#DDDDDD"),e.addColorStop(1,i));t.fillStyle=e,t.fillRect(n.x,n.y,n.width,n.height),t.restore()},f.prototype.Mm=function(t,n,e){var i,r,o,a,u,r,s,c,f,l,a,e,i=this,r=i.Vv,o=h().NewTab,a=i.im(),u;r.options.newTabVisible&&(r=void 0,f=c=void(s=0),l=-2===i.Tm,a?(i.Rv=t.measureText(o).width+i.kv,r=e,c=i.Jv(),f=n.height,i.Hm(t,r,0,c,f,void 0,!1,l,o,!1)):(a=i.em(),i.nm()&&(a=0),e=T.NEW_TAB_SIZE_ASIDE,i.Rv=e,r=(n.width-e)/2-a,i.$m(t,r,0,c=e,f=e,l)))},f.prototype.$m=function(t,n,e,i,r,o){var a,a,u,u,o,s,c,f,l,h,a=this;if(t.save(),t.beginPath(),a=(r-2*a.Qm)/2,u=C.VisualState.normal,o&&(u=C.VisualState.hover),u=S.I.He(u,"gc-tab-"+S.I.Ee(u)),(o=o?u.backgroundColor:u.backgroundImage)&&-1!==o.indexOf(_))for(s=t.createLinearGradient(n+.7*r,e+0,.7*r,r),f=0,l=(c=A(o)).length;f<l;f++)h=c[f],s.addColorStop(h.point,h.color);else s=o;t.lineWidth=1.5,t.strokeStyle=s,t.arc(n+i/2,e+r/2,a,0,2*Math.PI),t.stroke(),t.beginPath(),t.lineWidth=2,t.moveTo(n+i/2-4,e+r/2),t.lineTo(n+i/2+4,e+r/2),t.moveTo(n+i/2,e+r/2-4),t.lineTo(n+i/2,e+r/2+4),t.stroke(),t.restore()},f.prototype.Am=function(t,n,e,i){var r=this,e=e-1;r.Hm(t,i,0,r.Fv,n.height,e,r.hm===e,r.Tm===e,"",!1)},f.prototype.Im=function(t,n){var e,i,r,o,a,u,s,c,f,e=this,i=e.im(),r=e.tm(),o=e.xm,a=e.zv(),u=e.Yv(),s=e.Nm;t.fillStyle=k,i?t.fillRect(n.x,n.y,r-e.em()-2,n.height):t.fillRect(n.x,n.height-u,n.width,u),i?(e.km(t,c=a/2,f=u/2,c+o,f+o,c+o,f-o,T.NavButtonDirection.left,c-o,0===s),e.km(t,c+=a,f,c+o,f+o,c+o,f-o,T.NavButtonDirection.left,I,1===s),e.km(t,c+=a,f,c-o,f+o,c-o,f-o,T.NavButtonDirection.right,I,2===s),e.km(t,c+=a,f,c-o,f+o,c-o,f-o,T.NavButtonDirection.right,c+4,3===s)):(c=n.width/2-1.5*a,f=n.height-u/2,e.km(t,c,f,c+o,f+o,c-o,f+o,T.NavButtonDirection.top,f-o,0===s),e.km(t,c+=a,f,c+o,f+o,c-o,f+o,T.NavButtonDirection.top,I,1===s),e.km(t,c+=a,f,c+o,f-o,c-o,f-o,T.NavButtonDirection.bottom,I,2===s),e.km(t,c+=a,f,c+o,f-o,c-o,f-o,T.NavButtonDirection.bottom,f+o,3===s))},f.prototype.Dm=function(t,n){var e,i,r,i,o,a,u,s,o,e=this,i=e.Vv.options,r=i.allSheetsListVisible,i=i.newTabVisible,o=e.im(),a=e.tm();e.nm()&&(a-=e.em()),s=u=0,s=o?(u=4*e.zv()+1,5):(o=i?e.em():e.em()/2,u=(n.width-a)/2+o,10),r!==C.AllSheetsListVisibility.hide&&e._m(t,u,s,-3===e.Tm)},f.prototype._m=function(t,n,e,i){var r,o,a,u,s,c,s,f,l,h,d,v,m,g,l,f,u,a,p,b,w,c;if(t.save(),t.beginPath(),o=(r=this).im(),a=r.ot(),u=r.em(),c=(s=S.I.He)(4,"gc-all-sheets-button-hover"),f=(s=s(0,"gc-all-sheets-button-normal"))&&s.backgroundColor,(l=s&&s.backgroundImage)&&-1!==l.indexOf(_))for(h=t.createLinearGradient(a.x+.7*a.height,a.y+0,.7*a.height,a.height),v=0,m=(d=A(l)).length;v<m;v++)g=d[v],h.addColorStop(g.point,g.color);if(o&&(i?(t.fillStyle=c.backgroundColor,t.fillRect(n+2,a.y+2,u-4,a.height-4)):(h?t.fillStyle=h:f&&(t.fillStyle=f),t.fillRect(n-u/2,a.y+1,r.cm(),a.height-2))),o)t.strokeStyle=(i?c:s).color;else{if(l=C.VisualState.normal,i&&(l=C.VisualState.hover),g=void 0,f=S.I.He(l,"gc-all-sheets-button-"+S.I.Ee(l)),(u=i?f.backgroundColor:f.backgroundImage)&&-1!==u.indexOf(_))for(a=r.em(),g=t.createLinearGradient(n+.7*a,e+0,.7*a,a),v=0,m=(d=A(u)).length;v<m;v++)p=d[v],g.addColorStop(p.point,p.color);else g=u;t.strokeStyle=g}c=o?(b=3,w=12,4):(b=0,w=15,5),r.nm()&&(b=c=w=0),t.stroke(),t.lineWidth=1,t.moveTo(n+b,e),t.lineTo(n+w,e),t.moveTo(n+b,e+c),t.lineTo(n+w,e+c),t.moveTo(n+b,e+2*c),t.lineTo(n+w,e+2*c),t.stroke(),t.fill(),t.restore()},f.prototype.Em=function(t,n){var e,i,i,e,r,o,r,e=this,i=e.Vv,e=e.rm(),r=S.I.He,o=r(4,"gc-tabStripResizeBarInner"),r=r(0,"gc-tabStripResizeBarOuter");i.options.showHorizontalScrollbar&&(i=n.x+n.width-e,t.fillStyle=r.backgroundColor,t.fillRect(i,n.y,e,n.height),t.fillStyle=o.backgroundColor,t.fillRect(1+i,n.y+1,e-2,n.height-2),t.fillStyle=o.color,t.fillRect(i+e/2-1,n.y+4,2,n.height-8))},f.prototype.Hm=function(t,n,e,i,r,o,a,u,s,c){var f,l,h,h,f=this,l=f.im(),h=C.VisualState.normal;(u||c)&&(h=C.VisualState.hover),h=S.I.He(h,"gc-tab-"+S.I.Ee(h)),l?f.tg(t,n,e,i,r,s,h,c,a,u):f.ng(t,n,e,i,r,o,s,h,c,a,u)},f.prototype.tg=function(t,n,e,i,r,o,a,u,s,c){var f,l,h,l,d,h,f=this,l=f.Vv.options.tabStripPosition,h=f.eg;t.save(),t.beginPath(),l===C.TabStripPosition.bottom?(t.moveTo(n,e),t.lineTo(n,e+r-h),t.arcTo(n,e+r,n+i,e+r,h),t.lineTo(n+i,e+r),t.lineTo(n+i+r,e),s||t.lineTo(n,e)):(t.moveTo(n,e+r),t.lineTo(n,e-h),t.arcTo(n,e,n+i,e,h),t.lineTo(n+i,e),t.lineTo(n+i+r,e+r),s||t.lineTo(n,e+r)),l=f.zm(t,u||c,o,a),t.fillStyle=l,t.fill(),t.strokeStyle=k,t.stroke(),t.textBaseline="top",t.fillStyle=f.Um(a,d="string"==typeof l?l:d),s&&(t.font=M.W.ii(t.font,"bold")),h=f.kv,t.textBaseline="middle",t.fillText(o,n+h,e+r/2),t.restore()},f.prototype.ng=function(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,o,v,m,g,p,b,h,w,v,o,g,y,l=this,h=l.Vv.options.tabStripPosition,d,o=o===l.Vv.sheets.length-1,v=l.eg,m=l.Om,g=l.xm,p=l.Rm,b=l.Pm;t.save(),t.beginPath(),h===C.TabStripPosition.left?(t.moveTo((n+=m)+(i-=m),e),t.lineTo(n+v,e),t.arcTo(n,e,n,e+v,v),t.lineTo(n,e+r-v),t.arcTo(n,e+r,n+v,e+r,v),o?t.lineTo(n+i,e+r):(t.lineTo(n+i-g,e+r),t.lineTo(n+i,e+r+g)),c||t.lineTo(n+i,e)):(i-=m,t.moveTo(n,e),t.lineTo(n+i-v,e),t.arcTo(n+i,e,n+i,e+v,v),t.lineTo(n+i,e+r-v),t.arcTo(n+i,e+r,n+i-v,e+r,v),o?t.lineTo(n,e+r):(t.lineTo(n+g,e+r),t.lineTo(n,e+r+g)),c||t.lineTo(n,e)),h=l.zm(t,s||f,a,u,e),t.fillStyle=h,t.fill(),t.strokeStyle=k,t.stroke(),t.textBaseline="top",v=l.Um(u,w="string"==typeof h?h:w),t.fillStyle=v,c&&(t.font=M.W.ii(t.font,"bold")),t.textBaseline="middle",t.beginPath(),t.rect(n,e,o=i-2*m,r),t.clip(),t.fillText(a,n+m+p,e+r/2+2),g=t.measureText(b).width,o<(y=t.measureText(a).width)-g&&(t.beginPath(),t.fillStyle=h,t.fillRect(n+o-g,e+1.5,o,r-2.5),t.fillStyle=v,t.fillText(b,n+o-g,e+r/2+2)),t.restore()},f.prototype.km=function(t,n,e,i,r,o,a,u,s,c){var f,l,h,d,f,v,m,v,g,p,b,w,y,M,C;if(t.save(),l=(f=this).im(),h=u===T.NavButtonDirection.left||u===T.NavButtonDirection.top,d=f.ot(),f=f.zv(),m=(v=S.I.He)(4,"gc-navButton-hover"),g=(v=v(0,"gc-navButton-normal"))&&v.backgroundColor,(p=v&&v.backgroundImage)&&-1!==p.indexOf(_))for(b=t.createLinearGradient(d.x+.7*d.height,d.y+0,.7*d.height,d.height),y=0,M=(w=A(p)).length;y<M;y++)C=w[y],b.addColorStop(C.point,C.color);l&&(c?(t.fillStyle=m.backgroundColor,t.fillRect(n-f/2+2,d.y+2,f-4,d.height-4)):(b?t.fillStyle=b:g&&(t.fillStyle=g),t.fillRect(n-f/2,d.y+1,f,d.height-2))),t.fillStyle=l?(c?m:v).color:!c&&b||g,void 0!==s&&s!==I&&(u===T.NavButtonDirection.left||u===T.NavButtonDirection.right?t.fillRect(s,x(r,a),1,N(r,a)-x(r,a)):t.fillRect(x(i,o),s,N(i,o)-x(i,o),1)),h?u===T.NavButtonDirection.left?(n-=2,i-=2,o-=2):(e-=2,r-=2,a-=2):u===T.NavButtonDirection.right?(n+=2,i+=2,o+=2):(e+=2,r+=2,a+=2),t.beginPath(),t.moveTo(n,e),t.lineTo(i,r),t.lineTo(o,a),t.lineTo(n,e),t.fill(),t.restore()},n.Jm=f},"./dist/core/workbook/sheettabbase.js":function(v,t,n){"use strict";var e,i,g,p,B,w,r,m,F,b,y,P,G,U,M,a,C,S,T,f,H,A,I,n,o,u,s,c,l,h,n,V,z,n,Y,Z,W,Q,x,N,k,_,D,j,E,J,O,K,X,R,L,n,q,$,e,i;function tt(t,n,e){t.ki(p.Events.SheetTabClick,{sheet:n,sheetName:n?n.name():C,sheetTabIndex:b(e)?-1:e})}function d(t){this.Zc=t,this.Kv=!1,this.Fv=0,this._v=0,this.Om=6,this.ig=3,this.eg=5,this.xm=5,this.Rm=3,this.Qm=7,this.Pm="...",this.buffer=null;var t=this;t.Vv=C,t.hm=0,t.om=0,t.lm=70,t.Nm=-1,t.Tm=-1,t._font="",t.$v=[],t.am=0,t.rg=-1,t.og=-1,t.ag=C,t.ug=C,t.sg=0,t.cg(new p.Rect(0,0,200,28))}Object.defineProperty(t,"__esModule",{value:!0}),t.Hv=t.NavButtonDirection=t.NEW_TAB_SIZE_ASIDE=void 0,e=n("./dist/core/core.ns.js"),i=n("Common"),g=n("./dist/core/util/domUtil.js"),p=n("./dist/core/util/common.js"),B=n("./dist/core/worksheet/stylehelper.js"),w=n("./dist/core/core.enum.js"),r=i.Common.ft,m=p.mt.ri,F=p.mt.x0,b=i.Common.lt.ht,y=p.mt.En,P=p.mt.vt,G=p.mt.bt,U=parseInt,M=window,a=document,C=null,S=Math.max,T=Math.min,f=Math.pow,H=Math.round,A="px",I="none",o="mousedown"+(n=".gcTab"),u="mousemove"+n,s="mouseup"+n,c="mouseout"+n,l="dblclick"+n,h="mousewheel"+n,V="mousemove"+(n=".spliter"),z="mouseup"+n,Y="keydown"+(n=".tabNameEditor"),Z="focus"+n,W="blur"+n,Q="canvas",x="2d",N="resize",_="tab",D="newSheet",j="blank",E="allSheets",J="black",O="white",K=7,X=10,R=k="navButton",L="sheetTab",t.NEW_TAB_SIZE_ASIDE=28,n=new i.Common.ResourceManager(e.SR,"Sheets"),q=n.getResource.bind(n),(i=$=t.NavButtonDirection||(t.NavButtonDirection={}))[i.left=0]="left",i[i.right=1]="right",i[i.top=2]="top",i[i.bottom=3]="bottom",d.prototype.getNewTabBounds=function(){var t,n,e,i,r,o,a,u,t,n,n,t=this,n=t.Vv.options.useTouchLayout,e=t.ot(),i=t.Jv(),r=(i-2*t.Qm)/2,t=n?(n=e.width,t.nm()||(n/=2),o=e.x,a=e.y,u=n,i):(n=(e.x+e.width-2*r)/2,t.nm()||(n-=t.em()),o=n,a=(e.y+i-2*r)/2,u=2*r);return{x:o,y:a,width:u,height:t}},d.prototype.getCanvas=function(){return this.fg},d.prototype.im=function(){var t,n,t,n=this.Vv.options.tabStripPosition;return n===w.TabStripPosition.bottom||n===w.TabStripPosition.top},d.prototype.hg=function(t){var n,e,i;t&&((e=(n=this).fg)&&n.L0(!0),i=y(Q),p.Bf.Wl(i,n.Vv),i.setAttribute("id",n.Zc),n.dg=n.vg(),n.mg(),t.appendChild(n.dg[0]),t.appendChild(i),n.fg=i,(0,g.GC$)(i).bind(o,function(t){return n.gg(t)}).bind(u,function(t){return n.pg(t)}).bind(s,function(t){return n.bg(t)}).bind(c,function(t){return n.yg(t)}).bind(l,function(t){return n.wg(t)}).bind(h,function(t){return n.Mg(t)}),n.Cg(),d.et(n,"setHost"))},d.prototype.Sg=function(t){var n,t,n=this;(n.Vv=t)&&((t=t.options.font)&&0<t.length&&(n._font=t),n.mg())},d.prototype.Tg=function(t){var n=this.Vv;n.suspendPaint(),this.Ag(t),n.resumePaint()},d.prototype.Ag=function(t){var n,e,i,r,n=this,e=-1,i=n.Zm();if(!(i.length<=0))for(;;){if(e===(r=n.Ig().tabsInfo)[0].index)return;if(e=r[0].index,r[0].index>t)n.xg(i);else{if(!(r[r.length-1].index<t||r[r.length-1].index===t&&1<r.length))return;n.Ng(i)}}},d.prototype.ot=function(){var t=this.kg;return new p.Rect(t.x,t.y,t.width,t.height)},d.prototype.cg=function(t){var n=this.kg=new p.Rect(0,0,0,0);n.x=t.x,n.y=t.y,n.width=t.width,n.height=t.height},d.prototype.Jv=function(){var t,n,t,n;return this.Vv.options.newTabVisible?this.Rv:0},d.prototype.em=function(){var t,n,e,t,n,e;return this.Vv.options.allSheetsListVisible!==w.AllSheetsListVisibility.hide?this.Bv:0},d.prototype.cm=function(){var t,n,e,t,n,e;return this.Vv.options.allSheetsListVisible!==w.AllSheetsListVisibility.hide?this.Lv:0},d.prototype.Xv=function(){var t,n,e,t=this,n=t.ot(),e;return t.im()?n.x+n.width-t.rm():n.y+n.height-t.Yv()},d.prototype.tm=function(){return 0},d.prototype.rm=function(){var t,n,e,t=this,n=w.TabStripPosition.bottom,e=t.Vv;return(n=e?e.options.tabStripPosition:n)===w.TabStripPosition.bottom?t.Ev:0},d.prototype.Cg=function(){var t,n,e,i,e,r,t=this,n=t.Dg();n&&n.parentNode&&0!==(e=(0,g.GC$)(n.parentNode)).width()&&0!==e.height()&&(i=S(e.width(),0),e=S(e.height(),0),n.style.display=I,n.width=i,n.height=e,n.style.display="",n.style.width=i+A,n.style.height=e+A,i=n.clientWidth||n.width,e=n.clientHeight||n.height,r=t.ot(),t.cg(new p.Rect(r.x,r.y,i,e)),p.Bf.$l(n,i,e),t.repaint())},d.prototype.fm=function(){return!1},d.prototype.Yv=function(){return 0},d.prototype.dm=function(){return 0},d.prototype.vm=function(){return 0},d.prototype.mm=function(){return[]},d.prototype.gm=function(){return 0},d.prototype.vg=function(){return this.dg||(0,g.GC$)(y("div"))},d.prototype.mg=function(){var t,n,t,t,e,t=this,n=t.dg;n&&(e=void 0,(t=(t=t.Vv)?t.options.tabStripPosition:w.TabStripPosition.bottom)===w.TabStripPosition.bottom?e="gc-tab-indicator-bottom":t===w.TabStripPosition.top?e="gc-tab-indicator-top":t===w.TabStripPosition.left?e="gc-tab-indicator-left":t===w.TabStripPosition.right&&(e="gc-tab-indicator-right"),n.removeClass(),n.addClass(e))},d.prototype.L0=function(t){var n,e,i,n=this,e=n.fg;e&&(i=e.parentNode,(0,g.GC$)(e).unbind(o).unbind(u).unbind(s).unbind(l).unbind(c).unbind(h),i)&&i.removeChild(e),(0,g.GC$)(n.dg).remove(),d.et(n,"dispose"),t||(n.Vv=C)},d.prototype._g=function(t,n){var e,i,r,o,a,o,u,s,r,c,f,l,h,o,a,r,a,o,d,v,m,g,p,b,e=this,i=e.Vv,r=i.options.scrollbarAppearance===w.ScrollbarAppearance.mobile,o=i.options.showHorizontalScrollbar,a=e.ot();if(o&&!r&&(o=e.getResizeBarBounds(),i.options.showHorizontalScrollbar)&&t>o.x&&t<a.x+a.width)return{type:"resize",element:N};for(s=-1,r=(u=e.getNavButtonBounds()).startIndex,c=u.x,f=u.endIndex,l=["first","prevArrow","nextArrow","last","","prevButton","nextButton"],h=r;h<f;h++){if(c<t&&t<c+u.width){k=l[s=h];break}c+=u.width}if(-1!==s)return{type:R,element:k,index:h};if(c=(o=e.getAllSheetsBounds()).x,a=i.options.allSheetsListVisible,r=!0,e.nm()&&(r=!1),a!==w.AllSheetsListVisibility.hide&&c<=t&&t<c+o.width&&r)return{type:L,element:E,position:c,index:-1};if(c=(a=e.getPreMoreTabBounds()).x,o=0,-1!==(d=e.Vm(e.om))){if(c<=t&&t<c+a.width)return{type:R,element:k=l[5],index:5,position:c};o=e.Fv}if(v=e.getSheetTabBounds(),m=i.qv(),g=e.$v,p=e._v,b=0,c=v.x+o,-1<e.om)for(h=e.om;h<m.length&&h<g.length;h++)if(m[h].visible()===w.SheetTabVisible.visible){if(b=g[h],c<t&&t<c+b+p&&(0<v.moreTabPos&&t<v.moreTabPos||0===v.moreTabPos))return{type:L,element:_,index:h,position:c};c+=b+p}if(c>v.moreTabPos&&0<v.moreTabPos&&(c=v.moreTabPos),-1!==e.Ym(e.Zm())){if(c<t&&t<c+v.secondMoreTabWidth)return{type:R,element:k=l[6],index:6,position:c}}else if(c<t&&t<c+v.secondMoreTabWidth)return{element:j,position:c};return c+=v.secondMoreTabWidth,i.options.newTabVisible&&c<t&&t<c+e.Jv()?{type:L,element:D,position:c,index:-1}:{element:j}},d.prototype.Eg=function(t,n){for(var e,i,r,o,a,u,s,c,f,l,c,h,d,v,m,g,p,c,d,e=this,i=e.Vv,o=e.getNavButtonBounds(),a=-1,u=o.x,s=o.y,c=o.startIndex,f=o.endIndex,l=["first","prevArrow","nextArrow","last","","prevButton","nextButton"],r=c;r<f;r++){if(u<t&&t<u+o.width&&s<n&&n<s+o.height){k=l[a=r];break}u+=o.width}if(-1!==a)return{type:R,element:k,index:r};if(c=e.Jv(),h=i.options.allSheetsListVisible,d=e.cm(),v=!0,e.nm()&&(d=0,v=!1),s=S(c,d),m=i.qv(),g=e.$v,p=e.am,-1<e.om)for(r=e.om;r<m.length&&r<g.length;r++)if(m[r].visible()===w.SheetTabVisible.visible){if(s<n&&n<s+p)return{type:L,element:_,index:r,position:s};s+=p}return c=e.getNewTabBounds(),i.options.newTabVisible&&c.x<t&&t<c.x+c.width&&c.y<n&&n<c.y+c.height?{type:L,element:D,position:s,index:-1}:(d=e.getAllSheetsBounds(),h!==w.AllSheetsListVisibility.hide&&d.x<t&&t<d.x+d.width&&d.y<n&&n<d.y+d.height&&v?{type:L,element:E,position:s,index:-1}:s<n&&n<s+o.y?-1!==e.Ym(e.Zm())?{type:R,element:k=l[6],index:6,position:s}:{element:j,position:s}:{element:j})},d.prototype.hitTest=function(t,n){var e,i,e,e=this,i,e=e.im()?e._g(t,n):e.Eg(t,n);return e},d.prototype.gg=function(t){var n,e,e,i,r,i,o,o,r,n=this,e={e:t,r:C};return d.et(n,"preProcessMouseDown",e),b(e=e.r)?(i=(0,g.GC$)(n.Dg()).offset(),r=t.pageX-i.left,i=t.pageY-i.top,o=n.Vv.jg(),n.Og&&n.Rg(o,!1),r=(o=n.hitTest(r,i)).element,0===t.button&&(r===N?(n.Bg=!0,n.Lg=t.pageX,n.Fg()):r===k?n.Pg(o.index):r===_?(n.Gg(o.index,o.position,t),n.Ug(t,o)):r===D?n.Hg(o.position):r===E&&n.zg(t),n.Vg()),!(n.Yg=!0)):e},d.prototype.Vg=function(){var t,n,t,n=this.Vv.jg();n&&!n.isEditing()&&n.Zg()},d.prototype.zg=function(t){var n,e,n,e;return this.Vv.commandManager().execute({cmd:"showAllSheetsDialog",mouseEvent:t})},d.prototype.pg=function(t){var n,e,i,r,r,r,o,a,u,s,i,i,s,c,s,i,e,t,s,i,n=this,e=n.Vv,i=(0,p.jf)(e),r={e:t,r:C};if(d.et(n,"preProcessMouseMove",r),!b(r=r.r))return r;if(r=n.fg.style,o="default",a="w-resize",n.Wg&&!n.Qg&&10<(u=Math.sqrt(f(n.Wg.x-t.pageX,2)+f(n.Wg.y-t.pageY,2)))&&(n.Qg=!0),n.Bg)r.cursor=a,s=t.pageX-n.Lg,i=i.getHDockScrollbarWidth(),i=n.Vv.Kg.clientWidth-i,e.options.tabStripRatio=e.Jg()+s/i,s=n.rm()/i,c=1,e.Jg()<s?(e.options.tabStripRatio=s,n.Lg=n.rm()):1<=e.Jg()?(e.options.tabStripRatio=1,n.Lg=i):n.Lg=t.pageX,e.Xg();else if(n.Qg)n.qg(t.pageX,t.pageY),n.$g(t);else{if(n.Nm=-1,n.Tm=-1,s=(0,g.GC$)(n.Dg()).offset(),i=t.pageX-s.left,e=t.pageY-s.top,s=(t=n.hitTest(i,e)).element,n.Vv&&n.Vv.options.enableAccessibility&&(i=n.t2(t),n.Vv.n2(i)),""===s)return r.cursor=o,n.repaint(),!1;s===N?r.cursor=a:(r.cursor=o,s===k?n.Nm=t.index:s===_?n.Tm=t.index:s===D?n.Tm=-2:s===E&&(n.Tm=-3)),n.repaint()}return!1},d.prototype.t2=function(t){var n,e,i,r,t,n=q(),e="",i=t.element;return i===N?e=n.ARIA_Resize:i===k?e=(r={first:n.ARIA_First,prevArrow:n.ARIA_PreviousArrow,nextArrow:n.ARIA_NextArrow,last:n.ARIA_Last,prevButton:n.ARIA_PreviousButton,nextButton:n.ARIA_NextButton})[k]||"":i===_?(t=this.Vv.e2(t.index).name(),e=n.ARIA_SheetTab+" "+t.replace(/([0-9]+)/," $1 ")):i===D?e=n.ARIA_NewSheet:i===j&&(e=n.ARIA_Blank),e},d.prototype.bg=function(t){var n,t,t,n=this,t={e:t,r:C};return d.et(n,"preProcessMouseUp",t),b(t=t.r)?(n.Bg&&(n.Bg=!1,n.Vv.Xg()),n.i2(),n.Qg&&(n.Qg=!1,n.r2.remove(),n.o2(),n.dg.hide()),n.Wg=C,n.a2(),n.u2(),!n.Yg||(n.Yg=!1)):t},d.prototype.yg=function(t){var n,t,t,e,i,n=this,t={e:t,r:C};return d.et(n,"preProcessMouseOut",t),b(t=t.r)?(n.a2(),e=n.Nm,n.Nm=-1,i=n.Tm,n.Tm=-1,n.Nm===e&&n.Tm===i||n.repaint(),!1):t},d.prototype.Fg=function(){var n=this;n.s2||((0,g.GC$)(a).bind(V,function(t){n.pg(t)}).bind(z,function(t){n.bg(t)}),n.c2(!0),n.s2=!0)},d.prototype.c2=function(t){var n,e,n,e=this.Vv.getActiveSheet();e&&(e.f2=t)},d.prototype.u2=function(){var t;this.s2&&((this.s2=!1,g.GC$)(a).unbind(V).unbind(z),t=this.Vv.getActiveSheet())&&delete t.f2},d.prototype.Pg=function(t,n){var e,i,r,e=this;e.a2(),(i=e.Zm()).length<=0||(r=200,0===(t%=4)?e.l2(i):1===t?(n||(e.h2=M.setTimeout(function(){e.Pg(1)},200)),e.xg(i)):2===t?(n||(e.h2=M.setTimeout(function(){e.Pg(2)},200)),e.Ng(i)):3===t&&e.d2(i))},d.prototype.Gg=function(t,n,e){var i,r,o,r,o,i=this,r=i.Vv,o=r.v2,r=r.e2(t),o=o&&o.sheetsState;o&&0===o[r.name()]?(i.ug!==C&&clearTimeout(i.ug),i.ug=setTimeout(function(){i.m2(t,n,e),i.c2(!0),i.ug=C,i.Vg()})):i.m2(t,n,e)},d.prototype.m2=function(t,n,e){var i,r,n,o,n,i=this,r=i.Vv;i.hm=t,i.lm=n,r.suspendPaint(),n=r.getActiveSheet(),(o=r.e2(t))&&o.isEditing()&&o!==n&&(n=n&&n.il&&n.il.rl,!o.ol(void 0,void 0,n))||(tt(r,o,t),i.g2(t,e),r.resumePaint(),i.repaint())},d.prototype.p2=function(t,n,e,i,r,o){var e={oldValue:e,newValue:i,sheetName:r,propertyName:"isSelected",cancel:!1,sheetIndex:o,sheetPosition:t.getSheetPosition(r)};t.ki(p.Events.SheetChanging,e),e.cancel||(n.b2(i),t&&t.w2&&t.w2.repaint(),delete e.cancel,t.ki(p.Events.SheetChanged,e))},d.prototype.Hg=function(t){var n,e,i,r,r,o,a,r,u,n=this,e=n.Vv,i=n.im(),r=e.getActiveSheet();if((!n.C2||n.C2(r))&&(tt(e,C,C),r=e.qv(),o=e.getSheetCount(),a=e.S2(e.T2(o)),r.forEach(function(t){t.b2(!1,!0)}),u={sheetName:r=a.name(),propertyName:"insertSheet",cancel:!1,sheetIndex:o,sheetPosition:e.getSheetPosition(r)},n.p2(e,a,!1,!0,r,o),e.ki(p.Events.SheetChanging,u),!u.cancel)){for(e.A2(o,1,a),e.ki(p.Events.SheetChanged,{sheetName:a.name(),propertyName:"insertSheet",sheetIndex:o,sheetPosition:e.getSheetPosition(a.name())}),n.hm=o,n.lm=t,e.I2(e.qv().length-1,1,!1,!0);n.hm>n.om&&(n.fm()||n.om<n.N2(-1));)n.k2(n.om)&&(n.lm-=i?n.$v[n.om]:n.am),n.om++;n.repaint()}},d.prototype.g2=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,n,c,d,a,n,c,e=this,i=e.Vv,r=i.qv(),o=e.im(),a=i.getActiveSheet();e.D2&&!e.D2(a)||(u=!1,a&&a.il&&a.il.rl&&(u=!0),(s=!!n)&&(c=(l=p.mt.Qf())?n.metaKey:n.ctrlKey,f=n.shiftKey),t!==i.ep()?(c?(h=r[t]).b2()?h.b2(!1,!0):(h.b2(!0,!0),a&&!a.b2()&&a.b2(!0,!0)):f?(c=(n=i.jg())?i.getSheetPosition(n.name()):-1,d=r.slice(T(c,t),S(c,t)+1),r.forEach(function(t){t.visible()===w.SheetTabVisible.visible&&(-1!==d.indexOf(t)?t.b2()||t.b2(!0,!0):t.b2()&&t.b2(!1,!0))})):(a=r.every(function(t){return t.visible()!==w.SheetTabVisible.visible||t.b2()}),r[t].b2()&&!a||r.forEach(function(t){t.b2(!1,!0)}),(h=r[t]).b2()||h.b2(!0,!0),i.I2(t,1,u,!0)),n=e.N2(e.om),c=!1,c=o?e.lm+e.$v[e.hm]>e.dm():e.lm+e.am>=e.dm(),e.hm>e.om&&c&&-1!==n&&(e.om=n)):f&&r.forEach(function(t){var n,e,n=t.name(),e;i.getSheetPosition(n)!==i.ep()&&t.b2()&&t.visible()===w.SheetTabVisible.visible&&t.b2(!1,!0)}),e.hm<e.om&&(e.om=e.Vm(e.om)))},d.prototype.E2=function(t,n){var e,i,r,o,a,t,n,u,t,t,i,s,c,f,l,h,d,v,m,n,r,e=this,i=e.Vv,r=e.im(),o=i.options.tabStripPosition,a=U(p.I.fl("").zIndex),t=e.hitTest(t,n);if(t.element===_){if(n=e.hm,u=i.e2(n),t.index!==n)return;if(i.ki(p.Events.SheetTabDoubleClick,{sheet:u,sheetName:u.name(),sheetTabIndex:n}),!i.options.tabEditable)return!1;if((t=p.hi.ai())&&t.endEdit&&!t.endEdit())return;p.hi.F1(C),t=(0,g.GC$)(e.Dg()).offset(),i=i.j2(),s=(0,g.GC$)(i).offset(),c=(0,g.GC$)(i).width(),l=(f=y("input")).style,f.type="text",f.value=u.name(),f.setAttribute("contentEditable","true"),f.setAttribute("autocomplete","off"),l.position="absolute",l.margin="0px",l.padding="0px",m=v=d=h=void 0,n=e.$v[n],r?(m=n-e.kv-e.Dv+2,v=t.top-s.top+e.vm(),h=t.left-s.left+e.lm+e.kv):(r=e.ot(),m=n-e.kv-e.Dv+2,v=t.top-s.top+e.lm+e.vm(),h=t.left-s.left+r.x+e.Om+e.Rm,o===w.TabStripPosition.left&&2007===a&&(h+=e.Om),o===w.TabStripPosition.right&&c<h+m&&(d=t.left+r.width-c+e.Om+e.Rm)),d?l.right=d+A:h&&(l.left=h+A),l.top=v+A,l.width=m+A,l.backgroundColor=O,l.borderWidth="0px",l.outline=I,l.zIndex="1",(0,g.GC$)(f).appendTo(i),e.Og=f,(0,g.GC$)(f).addClass("gc-sheetTabEditor").bind(Y,function(t){return 13===t.keyCode?(e.Rg(u,!1),!1):27===t.keyCode?(e.Rg(u,!0),!1):void 0}).bind(Z,function(){f.selectionStart=0,f.selectionEnd=f.value.length}).bind(W,function(){e.Rg(u,!1)}),f.focus()}return!1},d.prototype.wg=function(t){var n,e,e,i,r,t,n=this,e={e:t,r:C};return d.et(n,"preProcessMouseDbClick",e),b(e=e.r)?(i=(0,g.GC$)(n.Dg()).offset(),r=t.pageX-i.left,t=t.pageY-i.top,n.E2(r,t)):e},d.prototype.Mg=function(t){var n,e,i,e,i,n=this,e=n.im(),i=!b(n.Og);return e||i||(b(t.wheelDelta)&&b(t.detail)&&(t.wheelDelta=t.originalEvent.wheelDelta,t.detail=t.originalEvent.detail),e=t.detail||t.wheelDelta,i=n.Zm(),0<e?n.xg(i):n.Ng(i)),!1},d.prototype.Rg=function(t,n){var e,i,r,n,o,e=this,i=e.Og;i&&((0,g.GC$)(i).unbind(Y).unbind(Z).unbind(W),r=i.value,!1===n&&r!==(n=t.name())&&(o={message:""},F(r,e.Vv.qv(),t,o)&&!b(r)&&""!==r?t.getParent().commandManager().execute({cmd:"renameSheet",sheetName:n,name:r}):t.ki(p.Events.InvalidOperation,{sheet:t,sheetName:t.name(),invalidType:5,message:o.message})),i.parentNode.removeChild(i),delete e.Og)},d.prototype.O2=function(){return this.Vv.options.allowSheetReorder},d.prototype.Ug=function(t,n){var e=this;e.O2()?(e.og=n.index,e.r2=e.R2(e.og),e.Wg=new p.Point(t.pageX,t.pageY),e.Fg()):e.Qg=!1},d.prototype.R2=function(t){var n,e,e,n,n=this.Vv.qv(),e=n.length;if(!(e<=t||t<0))return e=(e=n[t].name())||"sheet",(n=(0,g.GC$)(y("span")).text(e).css({position:"absolute",cursor:"default","border-radius":"5px",opacity:".7"})).addClass("ui-widget-header gc-tab-tip-span btn-primary"),n},d.prototype.a2=function(){var t=this.h2;t&&(clearTimeout(t),this.h2=C)},d.prototype.qg=function(t,n){var e,i,r,o,e,i=this.r2;i&&0===(0,g.GC$)(".gc-tab-tip-span").length&&(i.appendTo(a.body),i.hide()),r=i.width(),o=i.height(),i.css({left:t-r/2,top:n-o/2}),i.show()},d.prototype.$g=function(t){var n,e,i,r,i,o,t,i,a,u,s,c,f,l,e,h,d,o,t,v,m,e,t,o,n=this,e=n.Vv,i=(0,g.GC$)(n.Dg()),r=i.position(),i=i.offset(),o=t.pageX-i.left,t=t.pageY-i.top,i=n.hitTest(o,t),a=i.element,u=n.ot(),s=n.tm(),c=n.Vv.qv().length,f=100,l=e.options.tabStripPosition,e=n.im(),h=n.Jv(),d=n.dg,o=e?o:t,t=e?u.x+n.dm():u.y+n.dm()+h;t<o?n.ag===C&&n.rg<c&&(n.ag=M.setInterval(function(){n.Ng(n.Zm()),n.rg===c?(n.i2(),l===w.TabStripPosition.bottom?(v=r.left+n.B2()-3.5,m=r.top-3.5):l===w.TabStripPosition.top?(v=r.left+n.B2()-3.5,m=r.top+u.height):l===w.TabStripPosition.left?(v=r.left+u.width,m=r.top+n.B2()-3.5):l===w.TabStripPosition.right&&(v=r.left-3.5,m=r.top+n.B2()-3.5),d.show()):(n.rg++,d.hide()),d.css({left:v,top:m})},100)):o<s?n.ag===C&&0<n.rg&&(n.ag=M.setInterval(function(){n.xg(n.Zm()),0===n.rg?(n.i2(),l===w.TabStripPosition.bottom?(v=r.left+s-3.5,m=r.top-3.5):l===w.TabStripPosition.top?(v=r.left+s-3.5,m=r.top+u.height):l===w.TabStripPosition.left?(v=r.left+u.width,m=r.top+h-3.5):l===w.TabStripPosition.right&&(v=r.left-7,m=r.top+h-3.5),d.show()):(n.rg--,d.hide()),d.css({left:v,top:m})},100)):(n.i2(),a!==_&&-1===n.mm().indexOf(a)||(e=i.index,a===j&&(e=n.rg),t=e=a===_&&!b(e)?e:c,o=i.position,n.rg=t,l===w.TabStripPosition.bottom?(v=r.left+o-3.5,m=r.top-7):l===w.TabStripPosition.top?(v=r.left+o-3.5,m=r.top+u.height):l===w.TabStripPosition.left?(v=r.left+u.width,m=r.top+o-3.5):l===w.TabStripPosition.right&&(v=r.left-7,m=r.top+o-3.5),d.css({left:v,top:m}),d.show()))},d.prototype.B2=function(){for(var t,n,e,i,r,o,a,u,s,c,t=this,n=t.im(),e=t.$v,i=t.Zm(),r=t.L2(t.om,i),o=0,a=t.tm(),u=t.am,s=n?a+t.Fv:a,c=r;c<i.length;c++)o=i[c],n?s=(s+=e[o])+t._v:s+=u;return s},d.prototype.i2=function(){var t=this.ag;t&&(clearInterval(t),this.ag=C)},d.prototype.o2=function(){var t,n,e,i,r,o,a,u,t=this,n=t.Vv,e=t.rg,i=t.og,r=n.qv();if(n.suspendPaint(),this.F2(r)){for(o=[],a=0;a<r.length;a++)r[a].b2()&&(r[a].b2(!1),o.push(r[a]));for(a=o.length-1;0<=a&&!(n.getSheetPosition(o[a].name())<=e);a--)n.commandManager().execute({cmd:"moveSheet",sheetName:o[a].name(),targetIndex:e});for(e-=1,a=0;a<o.length&&!(n.getSheetPosition(o[a].name())>e);a++)n.commandManager().execute({cmd:"moveSheet",sheetName:o[a].name(),targetIndex:e})}else u=n.e2(i),-1!==e&&-1!==i&&i!==e&&i!==e-1&&t.dg.isVisible()&&(i<e-1&&(e-=1),n.commandManager().execute({cmd:"moveSheet",sheetName:u.name(),targetIndex:e}));n.resumePaint()},d.prototype.F2=function(t){for(var n,e,n=[],e=0;e<t.length;e++)if(t[e].b2()&&(n.push(t[e]),1<n.length))return!0;return!1},d.prototype.G2=function(t,n){var e,i,r,o,e=this,i=e.Vv,r=e.Zm();n===i.getSheetCount()?(e.d2(r),e.Cg()):0===n?(e.l2(r),e.Cg()):(o=e.U2(t,n))&&(t<n&&n++,e.Tg(n))},d.prototype.U2=function(t,n){for(var e,i,r,o,a,e=this,i=e.Ig().tabsInfo,r=!1,o=!1,a=0;a<i.length-2;a++)if(t===i[a].index&&(r=!0),n===i[a].index&&(o=!0),r&&o)return e.Cg(),!1;return!0},d.prototype.Zm=function(){for(var t,n,e,t=[],e=this.Vv.qv(),n=0;n<e.length;n++)this.k2(n)&&t.push(n);return t},d.prototype.l2=function(t){0<t.length&&this.om!==t[0]&&this.Vv.startSheetIndex(t[0])},d.prototype.xg=function(t){var n,t;0<t.length&&(n=this).om>t[0]&&-1!==(t=n.Vm(n.om))&&n.Vv.startSheetIndex(t)},d.prototype.Ng=function(t){var n,e;0<t.length&&(n=this).om<t[t.length-1]&&-1!==(e=n.Ym(t))&&n.Vv.startSheetIndex(n.N2(n.om))},d.prototype.d2=function(t){var t;0<t.length&&this.om<t[t.length-1]&&-1!==(t=this.Ym(t))&&this.Vv.startSheetIndex(t)},d.prototype.Ym=function(t){var n,e,i,r,o,a,u,s,c,f,l,h,h;if(0<t.length)for(e=(n=this).im(),i=n.am,r=n.dm(),a=n.$v,s=u=void(o=0),c=n.gm(),-1===(f=n.L2(n.om,t))&&(f=0),u=t.length-1;f<=u;u--)if(s=t[u],o+=l=e?a[s]:i,u!==t.length-1&&(o+=e?n._v:0),h=c+o,0!==u&&(h+=e?n.Fv:i),r<h)return h=void 0,h=u+1<t.length?t[u+1]:t[t.length-1],n.om<h?h:-1;return-1},d.prototype.Vm=function(t){for(var n,n=t-1;0<=n;n--)if(this.k2(n))return n;return-1},d.prototype.N2=function(t){for(var n,e,n=this.Vv.qv().length,e=t+1;e<n;e++)if(this.k2(e))return e;return-1},d.prototype.L2=function(t,n){for(var e,e=0;e<=n.length-1;e++)if(t===n[e])return e;return-1},d.prototype.k2=function(t){var t=this.Vv.e2(t);return!(!t||t.visible()!==w.SheetTabVisible.visible)},d.prototype.H2=function(){var t,n,e,i,r,o,a,t=this,n=t.Vm(t.om),e=t.Zm().length*t.am,i=t.Lv,r=t.Yv()/2,o,a;return t.ot().height<e+i+r||-1!==n},d.prototype.z2=function(){var t,n,t,t=this,n=t.Vm(t.om),t=t.Ym(t.Zm());return-1!==n||-1!==t},d.prototype.nm=function(){var t,n,e,i,t=this,n,e=t.Vv.options.allSheetsListVisible,i;if(t.im()){if(!t.z2()&&e===w.AllSheetsListVisibility.auto)return!0}else if(!t.H2()&&e===w.AllSheetsListVisibility.auto)return!0},d.prototype.V2=function(){this.sg++},d.prototype.Y2=function(){var t=this;t.sg--,t.sg<=0&&(t.sg=0,t.repaint())},d.prototype.repaint=function(t){var n=this.Dg();n&&n.getContext&&this._e(n.getContext(x),t)},d.prototype._e=function(t,n){var e,i,r,o,o,a,u,s,c,f,l,h,d,v,e=this;if(!(0<e.sg)){if(i=e.ot(),r=e.fg,n){if(n.x>=i.x+i.width)return;if(n.y>=i.y+i.height)return;if(n.x+n.width>i.width&&(n.width=i.width-n.x,n.width<=0))return;if(n.y+n.height>i.height&&(n.height=i.height-n.y,n.height<=0))return;if(n.width<=0||n.height<=0)return}if((o=e.buffer)&&o.width===r.width&&o.height===r.height&&(o||o.width===i.width&&o.height===i.height)||(o&&p.Bf.nh(e.Vv,o),e.buffer=o=y(Q),p.Bf.Wl(o,e.Vv),p.Bf.$l(o,i.width,i.height)),!(i.width<=0||i.height<=0||n&&(n.width<=0||n.height<=0))){(o=e.buffer.getContext(x)).clearRect(0,0,i.width,i.height),p.Lf.Yl(o,-i.x,-i.y),e.Z2(o,n),p.Lf.Yl(o,i.x,i.y),s=a=0<=i.x?0:-i.x,c=u=0<=i.y?0:-i.y,n&&(s=i.x+n.x,c=i.y+n.y,i=new p.Rect(s,c,n.width,n.height)),a=0<=i.x?i.x:0,u=0<=i.y?i.y:0,h=C,d=p.Bf.Kl(r),v=p.Bf.Jl(r),r&&1!==d&&(s*=d,c*=v,i.x*=d,i.y*=v,i.width*=d,i.height*=v);try{l=r?n?(f=S(i.width-s,0),S(i.height-c,0)):(f=T(i.width-s,S(r.width-i.x,3)),T(i.height-c,S(r.height-i.y,3))):(s=n.x,c=n.y,f=n.width,n.height),r?(p.Lf.Vl(t,1,1),t.clearRect(a,u,f,l),t.drawImage(e.buffer,s,c,f,l,a,u,f,l),p.Lf.Vl(t,d,v)):h=(o=e.buffer.getContext(x)).getImageData(s,c,f,l)}catch(t){return}!r&&h&&0<i.width&&0<i.height&&t.putImageData(h,a,u)}}},d.prototype.W2=function(t,n){var e,i,e,i=this.ot();n?t.rect(n.x,n.y,n.width,n.height):t.rect(i.x,i.y,i.width,i.height),t.clip()},d.prototype.K2=function(t){var n,e,i,r,o,a,n=this,e=n.Vv,i=n.im();for(t.save(),t.font=B.W.ii(t.font,"bold"),n.$v=[],a=e.qv(),o=0;o<a.length;o++)r=Math.round(t.measureText(a[o].name()).width)+n.Dv+n.kv,n.$v.push(r);i||(n.am=P(t.font)+2*n.ig),t.restore()},d.prototype.Ig=function(){var t,n,e,i,r,o,a,u,s,a,c,f,t=this,n,e=t.Vv.qv(),i=t.im(),r=t.ot(),o=[],a=t.tm();for(t.nm()&&i&&(a-=t.em()),u=a,a=t.om,i&&0<a&&0<=t.Vm(a)&&(u+=t.Fv),a<0&&(t.om=0),c=t.om;c<e.length;c++){if(f=e[c].visible(),s=t.$v[c],i){if(u>r.x+r.width)break}else if(u>r.y+r.height)break;o.push({index:c,position:u,width:s,text:e[c].name(),visible:f}),f===w.SheetTabVisible.visible&&(u+=i?s+t._v:t.am)}return{tabsInfo:o,newTabStartPosition:u}},d.prototype.Z2=function(t,n){var e,i,r,o,a,i,n,e=this,i=e.Vv,r=i.options.scrollbarAppearance===w.ScrollbarAppearance.mobile,o=i.options.tabStripPosition,a=i.options.showHorizontalScrollbar;t&&i&&(i=e.ot(),t.save(),G(t,e._font),e.W2(t,n),t.beginPath(),e.K2(t),n=e.Ig(),e.wm(t,i),e.Mm(t,i,n.newTabStartPosition),e.Dm(t,i),n=e.Ig(),e.J2(t,i,n.tabsInfo),e.Vv&&e.Vv.options.tabNavigationVisible&&e.Im(t,i),a&&!r&&o===w.TabStripPosition.bottom&&e.Em(t,i),t.beginPath(),t.restore())},d.prototype.wm=function(t,n){},d.prototype.Mm=function(t,n,e){},d.prototype.X2=function(t,n){var e,i,r,i,i,e=this,i=e.im(),r=e.tm();e.nm()&&(r-=e.em()),i?(i=n.x+e.dm(),t.rect(r,0,i-r,n.height)):(i=e.Yv(),t.rect(0,r,n.width,n.height-r-i)),t.clip()},d.prototype.q2=function(t,n,e){for(var i,r,o,a,u,s,c,f,i=this,r=i.Vv,o=i.im(),a=i.hm,u=i.Tm,s=e.length-1;0<=s;s--)(c=e[s]).index!==a&&c.visible===w.SheetTabVisible.visible&&(f=r.Gm(c.text).b2(),o?i.Hm(t,c.position,0,c.width,n.height,c.index,!1,c.index===u,c.text,f):i.Hm(t,0,c.position,n.width,i.am,c.index,!1,c.index===u,c.text,f))},d.prototype.tp=function(t,n,e){var i,r,o,a,u,s,e,s,o,i=this,r=i.Vv,o=r.qv(),a=i.im(),u=i.hm,s=i.om,e=e[u-s];s<=u&&u<o.length&&e&&e.visible&&(s=r.jg())&&(o=s.b2(),a?i.Hm(t,e.position,0,e.width,n.height,u,!0,!1,e.text,o):i.Hm(t,0,e.position,n.width,i.am,u,!0,!1,e.text,o))},d.prototype.np=function(t,n){var e,i,r,o,e=this,i=e.om,r=e.im(),o=e.tm();0<i&&0<=e.Vm(i)&&r&&e.Am(t,n,i,o)},d.prototype.J2=function(t,n,e){var i,r,o,i=this,r=i.Vv,o=r.qv();i.hm=r.ep(),0<o.length&&(t.save(),t.beginPath(),i.X2(t,n),i.q2(t,n,e),i.tp(t,n,e),t.restore(),t.save(),t.beginPath(),i.np(t,n),t.restore())},d.prototype.Am=function(t,n,e,i){},d.prototype.Im=function(t,n){},d.prototype.Dm=function(t,n){},d.prototype.Em=function(t,n){},d.prototype.km=function(t,n,e,i,r,o,a,u,s,c){},d.prototype.Hm=function(t,n,e,i,r,o,a,u,s,c){},d.prototype.Dg=function(){return this.fg},d.prototype.ip=function(t,n){var e,t,n,t,i,r,o,a,e=t.createLinearGradient(n.x,n.y,n.width,n.height),t=p.I.He(w.VisualState.normal,"gc-tabStripBackground"),n=t&&t.backgroundImage,t=t&&t.backgroundColor;if(n&&-1!==n.indexOf("linear-gradient"))for(r=0,o=(i=m(n)).length;r<o;r++)a=i[r],e.addColorStop(a.point,a.color);else t&&(e.addColorStop(0,"#DDDDDD"),e.addColorStop(1,t));return e},d.prototype.zm=function(t,n,e,i,r){var o,a,u,s,a,c,r,u,a,f,c,e,o,u,l,h,d,v,o=this,a=o.im(),u=o.ot(),s=a?t.createLinearGradient(u.x+.7*u.height,u.y+0,.7*u.height,u.height):(a=u.y,(c=0)<=r&&(a=r,c=o.am),t.createLinearGradient(u.x+.7*c,a,.7*c,a+c)),r=o.Vv.Gm(e);if(a=(u=(r=""===e&&0<o.om?o.Vv.e2(o.om-1):r)&&r.options)&&u.sheetTabColor)t.fillStyle=f="rgba(0, 0, 0, 0)",c=t.fillStyle,t.fillStyle=p.Pf.vl(r,a),(e=t.fillStyle)!==c&&(n?(s.addColorStop(0,O),s.addColorStop(.45,"#F1F6FD"),s.addColorStop(.9,e),s.addColorStop(1,O)):s=e);else if(i)if(o=i.backgroundImage,u=i.backgroundColor,o&&-1!==o.indexOf("linear-gradient"))for(h=0,d=(l=m(o)).length;h<d;h++)v=l[h],s.addColorStop(v.point,v.color);else u&&s.addColorStop(0,u);return s},d.prototype.Um=function(t,n){var e=J;return t&&(e=t.color),e=n&&r.rp(r._(n))<127.5?O:e},t.Hv=e=d,(0,p.$e)(e)},"./dist/core/workbook/workbook-json.js":function(i,t,n){"use strict";var o,Q,O,J,V,K,X,e,q,$,tt,gt,nt,r,a,et,B,R,z,it,u,Y,pt,h,d,Z,bt,s,wt,yt,rt,Mt,c,f,ot,at,ut,v,W,Ct,st,ct,n,ft,l,lt,ht,m;function L(t,n){return t.hasOwnProperty(n)}function F(t){var t,n,e,n;if(t&&"string"==typeof t){if(3<(n=(t=t.split(".")).length))return 3;if(e=m(t[0]),n<=2)return isNaN(e)?1:e;if(n=m(t[1]),10<=e)return e;if(3<=e){if(20143<=n)return 3;if(20142<=n)return 2}}return 1}function St(t){var n,e,i,t,r,o,a,u,s,n=this,e=t&&t.frozenColumnsAsRowHeaders,i=t&&t.frozenRowsAsColumnHeaders;if(e||i)for(et&&(t=n.op()).isAdjustSuspended()&&t.resumeAdjust(),o=(r=n.sheets).length,a=0;a<o;a++)s=(u=r[a]).Ut,i&&ht(s.ap)&&(u.cp=!0,u.deleteRows(0,s.ap)),e&&ht(s.fp)&&u.deleteColumns(0,s.fp)}function P(t,n){var e,i,r,o,a,u,s,c,a,e=this,i=n&&n.frozenColumnsAsRowHeaders,r=n&&n.frozenRowsAsColumnHeaders,o=0,u=t.sheets;if(r||i)for(s in u)"string"==typeof s&&(c=u[s],a=ht(c.index)?c.index:c.lp,a=e.sheets[ht(a)?a:o],r&&ht(c.frozenRowCount)&&(a.cp=!0,a.deleteRows(0,c.frozenRowCount)),i&&ht(c.frozenColCount)&&a.deleteColumns(0,c.frozenColCount),o++)}function G(t,n){t.hp(n,0)}function g(p,b,w){return function(){for(var g,t,n,e,i,g=b.dataManager(),t=function(t){var n,d,v,m;if(!t[0].getParent())return"continue";n=t[1].dataView,(d=g.tables[n&&n.tableName])&&(v=d.views[n.name])&&((m=v).dp=function(){w(t),delete m.dp},v.vp=function(){for(var t,n,e,i,r,o,a,u,s,c,f,l,h,h,t=function(t){if(!t[0].getParent())return"continue";var n=t[1].dataView;(d=g.tables[n&&n.tableName])&&(v=d.views[n.name])&&m!==v&&v.fetch().then(function(){w(t)})},n=0,e=p;n<e.length;n++)t(i=e[n]);for(o in r=g.tables)if(r.hasOwnProperty(o))for(s in u=(a=r[o]).views)u.hasOwnProperty(s)&&delete(c=u[s]).vp;for(f=0,l=p;f<l.length;f++)if((i=l[f])[0].getParent()&&(h=i[1].dataView,d=g.tables[h&&h.tableName])&&(v=d.views[h.name],m===v)){h=i[0],b.suspendPaint(),h.Mf.recalcAll(!0),b.resumePaint();break}})},n=0,e=p;n<e.length;n++)t(i=e[n])}}function Tt(o,a,u,i){var s,t,n,c,f,l;if(0<o.length){for(s=a.dataManager(),t=void 0,n=0;n<o.length&&!(t=o[n][1].dataView);n++);(c=s.tables[t&&t.tableName])&&(f=c.views[t.name])&&(l=function(t){var n=t[0],e=t[1],t=t[2];n.getParent()&&(n.ANi(e,i),t)&&b(a,t,n)},f.fetch().then(function(){var e,t,n,i,r;if(o[0][0].getParent()){for(l(o[0]),e=[],t=function(t){var n=t[1].dataView;(c=s.tables[n&&n.tableName])&&(f=c.views[n.name])&&e.push(f.fetch().then(function(){l(t)}))},n=0,i=o.slice(1);n<i.length;n++)t(r=i[n]);Promise.all(e).then(function(){a.suspendPaint(),u&&a.calculate(1),a.resumePaint()})}}).catch(g(o,a,l)))}}function p(t,n,e){var i,e,e,i=n.dataView;return i&&(e=e.tables[i&&i.tableName])&&(e=e.views[i.name])?e.fetch().then(function(){t.ANi(n,!0)}):void 0}function U(t,n,e,i){for(var r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,r=0,o=n.sheetTabs,a=[],u=i&&i.gp,s=t.mp,c=[],f=n.sheetCount,l=0,h=Object.keys(o);l<h.length;l++)(v=o[d=h[l]])&&(m=v.index-f,c.splice(m,0,v));if(s&&s.length&&c){for(g=0,p=c;g<p.length;g++)if("string"==typeof(b=(v=p[g]).name)&&(w=t.mp[r])){if(w.fromJSON(v,!1,e,i,!0),st(v.order)||(w.E0i=v.order),!u){for(y=n.formatStringNames,M=[],C=0;y&&C<y.length;C++)(S=y[C]).sheetTabName===w.name()&&M.push(S);a[r]=[w,v.addition,M]}r++}Tt(a,t,!(i&&i.doNotRecalculateAfterLoad),!1)}}function b(t,n,e){var i,r;if(n)for(i=0;i<n.length;i++)r=n[i],t.pp(t.bp,r.name,r.formula,r.row,r.col,!0,r.comment,e)}function H(t,n){var n,t,n=n.activeSheetTabIndex;ht(n)&&(t.yp(n,0),t=t.mp[n])&&t.b2(!0,!1)}function At(t,n,e,i,r){var o;return e===ct&&i===ct&&t===ct&&n===ct?ct:(o="",e!==ct&&(o+="$"+u(e)),t!==ct&&(o+="$"+(t+1)),o+=":",i!==ct&&(o+="$"+u(i)),n!==ct&&(o+="$"+(n+1)),r?s(r)+"!"+o:o)}function It(e,i,r){Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){var n=n[i];n&&n.call.apply(n,o([e],r,!1))})}function xt(t,n){for(var e,i,r,o,a,u,s,c,f,l,l,l,l,f,e=dt(t),i=[],r=0,o=0,a=0,u=0,s=0,c=0;c<e;c++)(f=vt(t,c))&&(f.wp=c+1,(l=f.tables)&&0<l.all().length&&l.all().forEach(function(t){++r,t._id=r+""}),(l=f.charts)&&0<l.all().length&&l.all().forEach(function(t){++o,t.wp=o}),(l=f.pictures)&&0<l.all().length&&l.all().forEach(function(t){++a,t.wp=a}),(l=f.pivotTables)&&0<l.all().length&&l.all().forEach(function(t){++s,t.Mp=s}),f=h(n),i.push(f),n.c_.push({n_:v,Id:ut+f,Type:X.RelationshipConstants.fo,Target:d("worksheets/"+ot+f)}));return w(n),t.Cp={slicer:0,timeline:0,drawing:0,vmlDrawing:0},i}function w(t){var n=ut+h(t);t.c_.push({n_:v,Id:n,Type:X.RelationshipConstants.Xs,Target:d("sharedStrings")}),n=ut+h(t),t.c_.push({n_:v,Id:n,Type:X.RelationshipConstants.Ks,Target:d("styles")}),n=ut+h(t),t.c_.push({n_:v,Id:n,Type:X.RelationshipConstants.$s,Target:d("theme/theme1")})}function dt(t){return t.getSheetCount()+t.getSheetTabCount()}function vt(t,n){var t=t.e2(n);return t instanceof a.Worksheet?t:t&&t.Mf}function Nt(t){return t.substring(0,19)===f}function kt(t){return t.substring(0,23)===c}function _t(t,n){var e=t;return 255<e.length?e=e.slice(-240):250<(e=n+" "+e).length&&(e=t+" "+Math.random().toString(36).slice(-6)),e}function y(t){for(var n,e,i,n=dt(t),e=0;e<n;e++)if(i=vt(t,e).hl)return i}function Dt(t,n,e,i){var r,o,a,u,e,a=t.themeFont;return"Body"===a?o=e||(u=y(n))&&u.bodyFont():"Headings"===a&&(o=i||(u=y(n))&&u.headerFont()),r=o&&t.font?(e=q.util._0(t.font)).fontWeight+" "+e.fontStyle+" "+e.fontSize+" "+o:t.font||l}function jt(){return{fileVer:"1.0",proName:"sjs",proVer:q.productInfo.productVersion}}function Et(){var t=new O.Style;return t.font="14.67px Calibri",t.foreColor="Text 1",t.borderLeft=new O.LineBorder,t.borderRight=new O.LineBorder,t.borderTop=new O.LineBorder,t.borderBottom=new O.LineBorder,t.name="Normal",t.backColor={type:0},t}function M(t,n){var n=n.state;"hidden"===n?t.visible(nt.SheetTabVisible.hidden):"veryHidden"===n&&t.visible(nt.SheetTabVisible.veryHidden)}function Ot(t,n,e,i,r,o,a){var t,u,n,i,i,t=vt(t,i),u=o.loadStatus,n=n[i];t.loading=!0,i=(i=Y(e,"sheetData"))&&i.rowCount||200,u.total+=i,t.NMi?(t.NMi.yh(e,r,o),st(e.order)||(t.NMi.E0i=e.order)):(t.yh(e,r,o,a),st(e.order)||(t.E0i=e.order)),M(t,n)}function mt(t){var n,t,n=t.getActiveSheet();return n||(t=t.getActiveSheetTab())&&(n=t.Mf),n}function Rt(t){for(var n=0,e=dt(t);n<e;n++)delete vt(t,n).loading}function Lt(t,n,e,i){var t=t;z.culture(n),t.Bp=!1,e&&i&&i.Zg(),t.resumeEvent(),t.Cg(),t.resumePaint()}o=this&&this.__spreadArray||function(t,n,e){if(e||2===arguments.length)for(var i=0,r=n.length,o;i<r;i++)!o&&i in n||((o=o||Array.prototype.slice.call(n,0,i))[i]=n[i]);return t.concat(o||Array.prototype.slice.call(n))},Object.defineProperty(t,"__esModule",{value:!0}),t.Sp=t.Tp=t.Ap=t.Ip=void 0,Q=n("./dist/core/workbook/workbook.js"),O=n("./dist/core/worksheet/style.js"),J=n("./dist/core/util/domUtil.js"),V=n("./dist/core/util/tasks.js"),K=n("./dist/core/excel-io-util/common.js"),X=n("./dist/core/excel-io-util/excel-types.js"),e=n("Common"),q=n("./dist/core/util/common.js"),$=n("CalcEngine"),tt=n("./dist/core/util/styleManager.js"),gt=n("./dist/core/util/theme.js"),nt=n("./dist/core/core.enum.js"),r=n("./dist/core/core.ns.js"),a=n("./dist/core/worksheet/worksheet.js"),et=!!$,B=O.Style.xp,R=e.Commands.UndoManager,z=e.Common.CultureManager,it=e.Common.lt.tv,u=K.IndexHelper.nr,Y=q.util.xr,pt=q.util.o1,h=K.Util.wr,d=K.Util.Mr,Z=K.Util.Sr,bt=K.Util.addXLFNPrefix,s=K.IndexHelper.ir,wt=q.util.Pr,yt=q.mt.n1,rt=q.mt.vo,Mt=K.Util.io,c="__builtInValidatorStyle",f="__builtInTableStyle",ot=X.XFileConstants.ru,at=X.XFileConstants.mo,ut=X.XFileConstants.Rr,v=X.XFileConstants.Lr,W=X.XFileConstants.Ki,Ct=X.XFileConstants.ou,st=e.Common.lt.ht,ct=void 0,n=new e.Common.ResourceManager(r.SR,"Sheets"),ft=n.getResource.bind(n),l="normal normal normal 11pt/normal Calibri",lt=J.GC$.each,ht=q.mt.T1,m=parseFloat,t.Ip=p,Q.Workbook.prototype.toJSON=function(t){return this.Np(t)},Q.Workbook.prototype.Np=function(e,t){var i,r,n,o,a,u,s,c,f,l,h,d,v,m,g,p,l,f,l,b,w,y,y,M,C,S,T,A,I,x,N,k,_,D,i=this,r={version:q.productInfo.productVersion,name:i.name},a=e&&e.rowHeadersAsFrozenColumns,u=e&&e.columnHeadersAsFrozenRows,s=a||u;if(s&&(e.kp=!0),i.Dp&&(r.docProps=it(i.Dp)),et&&(n=$.Functions.setLanguagepackage)&&(o=n(),n("en")),this._p&&this._p.Ep(this),c=i.getSheetCount(),r.sheetCount=c,s)for(f=new Q.Workbook,l=e&&e.includeAutoMergedCells,f.fromJSON(i.toJSON({includeBindingSource:!0,includeAutoMergedCells:l}),{gp:!0}),i=f,h=0;h<c;h++)v=(d=i.getSheet(h)).getRowCount(1),m=d.getColumnCount(2),p=u&&0<v,(g=a&&0<m)&&d.addColumns(0,m),p&&d.ffe(0,v,3,p),g&&d.jp(m,p?v:0),p&&d.Op(v,g?m:0);for(i.Bp=!0,i.suspendPaint(),i.suspendEvent(),et&&((l=i.Lp).calcOnDemand&&(l.calcOnDemand=!1,i.Fp(),l.suspend(!0),l.resume(!0),l.calcOnDemand=!0),l.forceR1C1Formula=e&&e.forceR1C1Formula,l.suspend(!0)),(f=i.startSheetIndex())&&(r.startSheetIndex=f),lt(i.options,function(t,n){"_ps"!==t&&Q.Workbook.Pp[t]!==n&&(r[t]=n)}),(l=i.getActiveSheetIndex())!==Q.Workbook.Gp&&(r.activeSheetIndex=l),b={},w=0;w<c;w++)d=i.getSheet(w),y=e,st(t)||w===t||(y={}),(y=d.toJSON(y)).index=w,y.order=d.E0i,b[d.name()]=y;for(J.GC$.isEmptyObject(b)||(r.sheets=b),M={},C=i.getSheetTabCount(),S=i.getActiveSheetTabIndex(),I=A=T=0;I<C;I++)(N=(x=i.Ofe(I)).toJSON(e))?(N.sheetType=x._gi,N.index=c+I-T,N.order=x.E0i,M[x.name()]=N,A++):(T++,I<=S&&S--);if(r.sheetTabCount=A,-1!==S&&(r.activeSheetTabIndex=S),J.GC$.isEmptyObject(M)||(r.sheetTabs=M),k=[],_=i.Hp){for(D in _)L(_,D)&&k.push(_[D]);0<k.length&&(r.namedStyles=k)}return Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){n.toJson&&n.toJson.call(i,r,e)}),et&&n&&n(o),i.Bp=!1,et&&(delete i.Lp.forceR1C1Formula,i.Lp.resume(!1)),i.resumeEvent(),i.resumePaint(),s&&delete e.kp,r},Q.Workbook.prototype.fromJSON=function(e,i){var r,t,o,n,t,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,E,r=this;if(r.zp(),e){if(r.Vp&&r.Vp.terminate(),i&&i.incrementalLoading)return!0===i.incrementalLoading&&(i.incrementalLoading={}),r.Yp(e,i);t=F(e.version),n={noSchema:o=t<3,version:t},t=q.hi.ai(),r.Bp=!0,r.suspendPaint(),r.suspendEvent(),a=z.culture(),z.culture("");try{for(h in r.Zp(),r.Wp=new R(r,-1,r.options.allowUndo),et&&(r.Qp(!0),r.Lp.suspendAdjust(),r.Lp.forceR1C1Formula=i&&i.forceR1C1Formula),r.Kp=-1,r.clearSheets(),r.clearSheetTabs(),u=e.name,ht(u)&&(r.name=u),s=r.options,c=e.canUserEditFormula,ht(c)&&(s.allowUserEditFormula=c),f=e.allowDragDrop,ht(f)&&(s.allowUserDragDrop=f),l=e.allowDragFill,ht(l)&&(s.allowUserDragFill=l),s)L(s,h)&&(d=e[h],ht(d))&&(s[h]=d);if(r.Dp=it(e.docProps),It(r,"preFromJson",[e,o,i]),v=e.sheetCount,ht(v)||(v=Q.Workbook.Jp),r.Xp(v,0),r.Hp={},r.qp={},m=e.namedStyles)for(g=0,p=m;g<p.length;g++)b=p[g],w=new O.Style,B(b,r),w.fromJSON(b,o,r),r.$p(w);if(M=void(y=0),C=e.sheets,T=S=void 0,I=!(A=!1),C)for(x in C)"string"==typeof x&&(N=C[x],k=ht(N.index)?N.index:N.lp,M=r.sheets[ht(k)?k:y])&&(N.isApplyRefilter=i&&i.isApplyRefilter,M.fromJSON(N,!1,n,i,!0),st(N.order)||(M.E0i=N.order),y++,T=N.allowUndo,A?I=I&&T===S:(S=T,A=!0));ht(S)&&I&&(s.allowUndo=S),G(r,e),0<r.mp.length?(U(r,e,n,i),H(r,e)):0<=e.activeSheetTabIndex&&(e.activeSheetIndex=0),_=e.activeSheetIndex,ht(_)||(_=Q.Workbook.Gp),r.tb(_,0,ct,ct,!0),(D=r.sheets[_])&&D.b2(!0,!1),r.dse=r.vse(r.sheets,r.mp),j=e.startSheetIndex,ht(j)&&r.startSheetIndex(j),E=e.backgroundImage,ht(E)&&r.nb(),Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){var n=n.fromJson;n&&n.call(r,e,o,i)}),et&&r.Lp.resumeAdjust(),P.call(r,e,i),Q.Workbook.et(r,"initCustomName")}finally{et&&(r.Lp.resumeAdjust(),delete r.Lp.forceR1C1Formula),z.culture(a),r.Bp=!1,D=r.getActiveSheet(),t&&D&&D.Zg(),r.resumeEvent(),r.Cg(),r.resumePaint(),D&&r.ki(q.Events.ActiveSheetChangedInternal,{oldSheet:void 0,newSheet:D}),et&&r.Lp.processDynamicRef()}}},Q.Workbook.prototype.Yp=function(e,i){var o,t,n,r,t,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,o=this;o.Vp=new V.Tasks(function(){var t,n,e,e,t=o.getActiveSheet();if(t&&!t.loaded)for(n=this.tasks.length-1;0<=n;n--)if((e=this.tasks[n].args[0])&&e.Ut&&e.name&&e.name()===t.name())return e=this.tasks[n],this.tasks.splice(n,1),e;return this.tasks.pop()},function(){var t=o.getActiveSheet();return t&&(o.ib.eb||t.isEditing()||t.rt.rb||t.rt.ob||t.rt.ab)}),t=F(e.version),r={noSchema:n=t<3,version:t},t=q.hi.ai(),o.Bp=!0,o.suspendPaint(),o.suspendEvent(),a=z.culture(),z.culture("");try{for(h in o.Zp(),o.Wp=new R(o,-1,o.options.allowUndo),et&&(o.Qp(!0),o.Lp.suspendAdjust()),o.Kp=-1,o.clearSheets(),o.clearSheetTabs(),u=e.name,ht(u)&&(o.name=u),s=o.options,c=e.canUserEditFormula,ht(c)&&(s.allowUserEditFormula=c),f=e.allowDragDrop,ht(f)&&(s.allowUserDragDrop=f),l=e.allowDragFill,ht(l)&&(s.allowUserDragFill=l),s)L(s,h)&&(d=e[h],ht(d))&&(s[h]=d);if(o.Dp=it(e.docProps),It(o,"preFromJson",[e,n,i]),v=e.sheetCount,ht(v)||(v=Q.Workbook.Jp),o.Xp(v,0),o.Hp={},m=e.namedStyles)for(g=0;g<m.length;g++)p=m[g],b=new O.Style,B(p,o),b.fromJSON(p,n,o),o.$p(b);if(w=0,M=e.sheets,S=C=void 0,A=!(T=!1),M)for(x in I={total:0,valuesLoad:0,formulaLoad:0},i.incrementLoadTask=o.Vp,i.incrementalLoading.loadStatus=I,M)"string"==typeof x&&(N=M[x],k=ht(N.index)?N.index:N.lp,(y=o.sheets[ht(k)?k:w]).loading=!0,y.ub(N.name+"",!0),y.b2(N.isSelected),y.setRowCount(N.rowCount),y.setColumnCount(N.columnCount),ht(N.visible)&&y.visible(N.visible),I.total+=y.getRowCount(),o.Vp.addTask(function(t,n){n.isApplyRefilter=i&&i.isApplyRefilter,t.Yp(n,!1,r,i,!0),st(n.order)||(t.E0i=n.order)},[y,N]),w++,S=N.allowUndo,T?A=A&&S===C:(C=S,T=!0));ht(C)&&A&&(s.allowUndo=C),G(o,e),0<o.mp.length?(U(o,e,r,i),H(o,e)):0<=e.activeSheetTabIndex&&(e.activeSheetIndex=0),_=e.activeSheetIndex,ht(_)||(_=Q.Workbook.Gp),o.tb(_,0,ct,ct,!0),(D=o.sheets[_])&&D.b2(!0,!1),j=e.startSheetIndex,ht(j)&&o.startSheetIndex(j),o.Vp.endingCallback=function(){Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,r){r.Yp?o.Vp.addTask(function(t,n,e,i){r.Yp.call(t,n,e,i)},[o,e,n,i]):r.fromJson&&r.fromJson.call(o,e,n,i)}),o.Vp.endingCallback=function(){var t,n,n;for(o.dse=o.vse(o.sheets,o.mp),et&&o.Lp.resumeAdjust(),P.call(o,e,i),Q.Workbook.et(o,"initCustomName"),et&&o.Lp.processDynamicRef(),t=0;t<o.sheets.length;t++)delete o.sheets[t].loading;(y=o.getActiveSheet())&&o.ki(q.Events.ActiveSheetChangedInternal,{oldSheet:void 0,newSheet:y}),i&&i.incrementalLoading&&(n=i.incrementalLoading,o.ki(q.Events.ProgressChanged,{loadStatus:n.loadStatus,progress:1,sheet:y}),n.loading)&&n.loading(1,{sheet:y}),(n=i&&i.incrementalLoading&&i.incrementalLoading.loaded)&&n(),y&&y.repaint(),o.w2.repaint(),o.Vp.endingCallback=void 0},o.Vp.start()},o.Vp.start()}finally{z.culture(a),o.Bp=!1,D=o.getActiveSheet(),t&&D&&D.Zg(),o.resumeEvent(),o.Cg(),o.resumePaint()}},Q.Workbook.prototype.getSheetRelsName=function(t){var t,n,t=t.split("/").pop(),n=t.lastIndexOf(".xml");return t.substring(0,n)},Q.Workbook.prototype.getSheetRelsDir=function(t){var t,t,t=t.split("/"),t=t[t.length-2];return"worksheets"!==t?t:"sheets"},t.Ap=dt,t.Tp=vt,Q.Workbook.prototype.wh=function(e){var i,t,n,r,o,L,n,r,t,a,B,r,n,u,s,c,F,u,f,P,l,G,h,d,u,v,m,g,p,b,U,H,w,y,M,V,r,z,Y,n,Z,W,C,S,T,A,T,I,x,N,k,_,D,j,k,_,D,j,E,O,R,D,k,_,j,E,R,O,D,r,i=this;if(i._p&&i._p.Ep(i),t=0<i.mp.length&&(e&&e.fileType)===nt.OpenSaveFileType.excel,n=e&&e.rowHeadersAsFrozenColumns,r=e&&e.columnHeadersAsFrozenRows,o=!e||!1!==e.includeStyles,(L=n||r||t)&&(n=new Q.Workbook,r=e&&e.includeAutoMergedCells,n.fromJSON(i.toJSON({includeBindingSource:!0,includeAutoMergedCells:r}),{sb:!0,cb:e&&e.fileType}),i=n),t=i.options,(B=(a={}).workbook={n_:"workbook",c_:[],lossless:{version:jt(),renamedStylesMap:{},customData:e&&e.customData},rels:{}}).c_.push(r={n_:"bookViews",c_:[]}),!(n={n_:"workbookView"})===t.showHorizontalScrollbar&&(n.showHorizontalScroll="0"),!1===t.showVerticalScrollbar&&(n.showVerticalScroll="0"),!1===t.tabStripVisible&&(n.showSheetTabs="0"),(u=i.startSheetIndex())&&(n.firstSheet=u),-1!==(s=i.ep()))for(c=s;0<=c;c--)2===(F=i.e2(c))._gi&&s--;for(s!==Q.Workbook.Gp&&(n.activeTab=s),"number"==typeof(u=t.tabStripRatio)&&.6!==u&&(n.tabRatio=1e3*u),r.c_.push(n),i.Dp&&(a.docProps=it(i.Dp)),lt(i.options,function(t,n){"_ps"!==t&&Q.Workbook.Pp[t]!==n&&(B.lossless[t]=n)}),et&&(f=$.Functions.setLanguagepackage)&&(P=f(),f("en")),l={},G=dt(i),h=i.getNamedStyles(),d=new tt.StyleManager,u=new q.SharedStrings,m=!(v={styleManager:d,sharedStrings:u}),g=[{style:null}],p={},b={},U=B.lossless.renamedStylesMap,Object.keys(h).forEach(function(t){var n=h[t].name;n!==ft().NORMAL?g.push({style:h[t]}):(g[0].style=h[t],m=!0),p[n]=1}),H=function(r){var o,a,o=vt(i,r);if(!o)return"continue";a=o.getNamedStyles(),Object.keys(a).forEach(function(t){var n,e,i,n=a[t].name;if(!kt(n)&&!Nt(n)){for(e=n,i=it(a[t]);p[e]||255<e.length;)e=_t(e,o.name());i.name=e,m||i.name!==ft().NORMAL?g.push({sheetId:r,style:i}):(g[0]={sheetId:r,style:a[t]},m=!0),p[e]=1,n!==e&&(b[n]=b[n]||{},b[n][o.name()]=e,U[e]=n)}})},c=0;c<G;c++)H(c);for(d.gv=b,(w=K.Util.ko(e))||o&&g[0]&&g[0].style?!w||g[0]&&g[0].style||g.shift():(M=vt(i,0),y=o&&M&&!M.NMi?M.getDefaultStyle():{},V=Et(),Object.keys(y).forEach(function(t){"_id"!==t&&"name"!==t&&(V[t]=y[t])}),g[0]={style:V},m=!0),g.forEach(function(t){d.getNamedStyleIndex(t.style,3,ct,t.sheetId,!w)}),w||(r=g[0].style.clone(!0),(0,q.AL)(r),d.getStyleIndex(r)),d.updateNamedStylesParentName(),y=m?g[0]&&g[0].style:(M=vt(i,0),o&&M&&!M.NMi?M.getDefaultStyle():Et()),v.defaultStyle=y,q.SJSColumnWidthHelper.setMaxDigitWidth(Dt(y,i)),Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){n.preToSJSFormat&&n.preToSJSFormat.call(i,a,v,e)}),Y={n_:at,c_:[]},n={n_:X.XFileConstants.Dr,xmlns:X.RelationshipConstants._r},Z=xt(i,n),W=0,a.workbook.rels=n,C=0;C<G;C++)if(M=vt(i,C)){if(S=Z[W],W++,T=ot+S,(A=(M.NMi||M).wh(a,v,e)).order=(M.NMi||M).E0i,l[T]=A,T=M.name(),o&&M.hl&&!z&&(a.theme=z=A&&A.lossless&&A.lossless.theme),(I=A.lossless.definedNames||[])&&I.length)for(c=0;c<I.length;c++)x=I[c],I[c]={n_:"definedName",name:x.name,localSheetId:C,e:x.e,comment:x.comment,isReadOnly:x.isReadOnly,c_:[x.formula]};(N=A.printInfo)&&(k=N.rowStart,_=N.rowEnd,D=N.columnStart,j=N.columnEnd,-1===k&&-1===_&&-1===D&&-1===j||(k=M.getCalcService(),_=M.Uw(),k&&_&&(D=M.getCustomName("Print_Area"))&&(j=D.getExpression(),E=D.getRow(),O=D.getColumn(),R=D.getComment(),D=D.isReadOnly(),k=k.unparse(_,j,E,O,!1,!0,!0),I.push({n_:"definedName",name:"_xlnm.Print_Area",localSheetId:C,comment:R,isReadOnly:D,c_:[rt(bt(k))]}))),_=At(N.repeatRowStart,N.repeatRowEnd,ct,ct,T),j=At(ct,ct,N.repeatColumnStart,N.repeatColumnEnd,T),E=void 0,_&&j?E=j+","+_:_?E=_:j&&(E=j),E&&I.push({n_:"definedName",name:"_xlnm.Print_Titles",localSheetId:C,c_:[rt(bt(E))]}),delete A.printInfo),A.lossless.definedNames=I,O=void 0,(R=M.visible())===nt.SheetTabVisible.hidden?O="hidden":R===nt.SheetTabVisible.veryHidden&&(O="veryHidden"),D={n_:ot,"r:id":ut+S,name:rt(T),sheetId:S,state:O,lossless:{tabSelected:M.b2()?"1":ct}},Y.c_.push(D)}return a.workbook.c_.push(Y),J.GC$.isEmptyObject(l)||(a.sheets=l),a.styles={},Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){n.wh&&n.wh.call(i,a,v,e)}),a.styles=d.bv(a.styles,d.wh(e)),a.sharedStrings=u.wh(),d.dispose(),1!==t.referenceStyle&&st(t.iterativeCalculation)&&st(t.iterativeCalculationMaximumIterations)&&st(t.iterativeCalculationMaximumChange)||(r={n_:"calcPr",calcId:0},1===t.referenceStyle&&(r.refMode="R1C1"),t.calculationMode===nt.CalculationMode.manual&&(r.calcMode="manual"),!0===t.iterativeCalculation&&(r.iterate=1),st(t.iterativeCalculationMaximumIterations)||(r.iterateCount=t.iterativeCalculationMaximumIterations),st(t.iterativeCalculationMaximumChange)||(r.iterateDelta=t.iterativeCalculationMaximumChange),a.workbook.c_.push(r)),wt(a.workbook,X.WorkbookNodeOrder),et&&f&&f(P),a},Q.Workbook.prototype.fb=function(t,n){var e,t,e=this;z.culture(""),e.Zp(),n&&n.calcOnDemand&&(e.options.calcOnDemand=!0),n&&!1===n.dynamicReferences&&(e.options.dynamicReferences=!1),!0===t&&(e.options.allowDynamicArray=!0),e.Wp=new R(e,-1,e.options.allowUndo),et&&(e.Qp(!0),(t=e.Lp).suspendAdjust(),t.suspend(),t.lb=n&&!n.fullRecalc),e.Kp=-1,e.clearSheets(),e.clearSheetTabs()},Q.Workbook.prototype.hb=function(t){var n,e,i,r,r,r,o,a,r,r,n,e=this.options,i=t.workbook.lossless;if(i)for(o in r=i.canUserEditFormula,ht(r)&&(e.allowUserEditFormula=r),r=i.allowDragDrop,ht(r)&&(e.allowUserDragDrop=r),r=i.allowDragFill,ht(r)&&(e.allowUserDragFill=r),e)L(e,o)&&(a=i[o],ht(a))&&(e[o]=a);(r=Y(t.workbook,"extLst"))&&r.c_&&r.c_[0]&&r.c_[0]["xmlns:xcalcf"]===X.XFileConstants.Cs&&(e.allowDynamicArray=!0),(r=Y(t.workbook,"calcPr"))&&("R1C1"===r.refMode&&(e.referenceStyle=1),"manual"===r.calcMode&&(e.calculationMode=nt.CalculationMode.manual),e.iterativeCalculation=1===parseInt(r.iterate,10),e.iterativeCalculationMaximumIterations=st(r.iterateCount)?100:parseInt(r.iterateCount,10),e.iterativeCalculationMaximumChange=st(r.iterateDelta)?.001:parseFloat(r.iterateDelta))},Q.Workbook.prototype.db=function(t){var n,e,i,i,r,o,a,u,s,c,f,f,f,l,l,l,n=this,e=n.options,i=Y(t.workbook,"bookViews"),i=Y(i,"workbookView");if(i){if(i.showHorizontalScroll&&(e.showHorizontalScrollbar="0"!==i.showHorizontalScroll),i.showVerticalScroll&&(e.showVerticalScrollbar="0"!==i.showVerticalScroll),i.showSheetTabs&&(e.tabStripVisible="0"!==i.showSheetTabs),e.tabStripRatio=st(i.tabRatio)?.6:i.tabRatio/1e3,i.firstSheet&&n.startSheetIndex(+i.firstSheet),r=0,i.activeTab!==ct)r=+i.activeTab;else if(t.sheets&&(o=Y(t.workbook,at).c_,a=t.workbook.rels&&t.workbook.rels.c_,o)&&a){for(u=[],s=0;s<o.length;s++)f=(c=o[s])[W],(f=(f=Z(a,f))&&f.Target)&&u.push(n.getSheetRelsName(f));for(s=0;s<u.length;s++)if((l=t.sheets[u[s]])&&(l=Y(l,"sheetViews"))&&(l=Y(l,"sheetView"))&&"1"===l.tabSelected){r=s;break}}n.I2(r,2)}},Q.Workbook.prototype.mb=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,b,w,p,b,p,y,b,p,p,u=this,s=r.sheetNamedStyles;for(d in o=o||{},c=!(u.Hp={})!==a.includeUnusedStyles,f=n.styles&&n.styles.namedStylesMap,l=K.Util.ko(a),h=!0,f)f.hasOwnProperty(d)&&(v=h&&(d===ft().NORMAL||!l&&0===f[d]),!c&&!v&&st(t.originNamedStylesXfs.Lh[d])||(m=t.getNamedStyle(f[d],d,l),st(m)&&(m={foreColor:"Text 1 0",themeFont:"Body",font:"normal normal 14.7px Calibri",locked:!0,textIndent:0,wordWrap:!1,vAlign:2,hAlign:3}),l||m.formatter!==ft().GENERAL||delete m.formatter,v&&(h=!1,m.name="Normal",m.font=Dt(m,u,i,e),q.SJSColumnWidthHelper.setMaxDigitWidth(m.font),delete(g=m.clone()).name,r.defaultStyle=g),m.name=o[m.name]||m.name,m.sheetId!==ct?(s[m.sheetId]||(s[m.sheetId]=[]),s[m.sheetId].push(m)):u.$p(m)));!1!==h&&(p=Y(n.workbook,at).c_,b=n.workbook.rels&&n.workbook.rels.c_,p=(w=p[0])[W],g=y=void 0,g=(g=(y=(p=(b=Z(b,p))&&b.Target)?(b=u.getSheetRelsName(p),n[p=u.getSheetRelsDir(p)]&&n[p][b]):n.sheets.sheet1)?y.lossless&&y.lossless.defaultStyle:g)||{hAlign:3,imeMode:1,themeFont:"Body",vAlign:0},(p=new O.Style).fromJSON(g,ct,ct),p.font=Dt(p,u,i,e),q.SJSColumnWidthHelper.setMaxDigitWidth(p.font),r.defaultStyle=p),a&&a.fileType===nt.OpenSaveFileType.excel&&t.buildDummyNamedStyles(u)},t.Sp=mt,Q.Workbook.prototype.yh=function(r,o,e){var t,n,a,u,i,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,L,B,F,N,P,G,k,_,D,U,j,E,O,H,R,a=this;if(a.zp(),r){e=e||function(){},u=K.Util.Mo(o),(o=o||{}).progress||(o.progress=function(t){}),o.loadStatus={total:0,valuesLoad:0,formulaLoad:0},i=function(t){a.pb(q.Events.ProgressChanged,{loadStatus:o.loadStatus,progress:t.progress,sheetName:t.sheetName}),o.progress({step:t.step,sheetName:t.sheetName,progress:t.progress})},a.Vp&&a.Vp.terminate(),a.Vp=new V.LoadTasks(function(){var t,n,e,e,t=mt(a);if(t&&!t.loaded)for(n=this.tasks.length-1;0<=n;n--)if((e=this.tasks[n].args[0])&&e.Ut&&e.name&&e.name()===t.name())return e=this.tasks[n],this.tasks.splice(n,1),e;return this.tasks.pop()},function(){var t=mt(a);return u&&t&&(a.ib.eb||t.isEditing()||t.rt.rb||t.rt.ob||t.rt.ab)},i),a.suspendPaint(),a.suspendEvent(),s=q.hi.ai(),a.Bp=!0,c=z.culture(),f=!1;try{if(a.fb(r.workbook.lossless&&r.workbook.lossless.allowDynamicArray,o),a.hb(r),a.Dp=it(r.docProps),(l=new tt.StyleManager).yh(r.styles),(h=new q.SharedStrings).yh(r.sharedStrings),d={},Object.keys(r).forEach(function(t){-1<t.indexOf(Ct)&&(d[t]=r[t])}),v=void 0,v=(r.sheets&&r.sheets.sheet1&&r.sheets.sheet1.lossless&&r.sheets.sheet1.lossless.theme?r.sheets.sheet1.lossless:r).theme,g=m=void 0,v&&"string"!=typeof v?v&&(b=Y(v,"themeElements"),w=Y(b,"fontScheme"),m=pt(w,"majorFont&latin").typeface,g=pt(w,"minorFont&latin").typeface):((p=new gt.Theme(ct)).yh("string"==typeof v?v:"Office"),m=p.headerFont(),g=p.bodyFont()),y={drawings:r.drawings,tables:r.tables,charts:r.charts,media:r.media,ctrlProps:r.ctrlProps,comments:d,pivotTables:r.pivotTables,slicers:r.slicers,slicerCaches:r.slicerCaches,timelineCaches:r.timelineCaches,timelines:r.timelines,styleManager:l,sharedStrings:h,theme:r.theme,sheetNamedStyles:{},dataEffectByInflate:{}},a.mb(l,r,m,g,y,r.workbook.lossless&&r.workbook.lossless.renamedStylesMap,o),M=Y(r.workbook,at).c_.length,ht(M)||(M=Q.Workbook.Jp),Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){var n=n.preFromSJSFormat;n&&n.call(a,r,y,o)}),C=Y(r.workbook,"definedNames"),y.workbookNames=C&&C.c_,S=Y(r.workbook,at).c_,T=r.workbook.rels&&r.workbook.rels.c_,o&&(o.incrementLoadTask=a.Vp),S&&T){for(A=[],I=[],x=0;x<M;x++)B=(L=S[x])[W],(N=(F=Z(T,B))&&F.Target)&&(P=a.getSheetRelsName(N),G=a.getSheetRelsDir(N),k=r[G][P],_=Mt(yt(L.name)),D=!0,k.lossless&&(j=(U=k.lossless).sheetType,E=U.addition,st(j)&&(j=nt.SheetType.tableSheet),E?(O=a.bb(_,j))?(a.yb(x-a.sheets.length,0,O),A.push([O,E])):D=!1:(H=a.S2(_),a.A2(x,0,H))),D)&&(I[x]=k);for(x=0;x<M;x++)(k=I[x])&&Ot(a,S,k,x,y,o,!K.Util.wo(o,a.v2));Tt(A,a,o&&o.fullRecalc,!0)}a.db(r),R={},null!=(n=null==(t=r.workbook)?void 0:t.lossless)&&n.customData&&(R.customData=r.workbook.lossless.customData),a.Vp.endingCallback=function(){a.wb(),Q.Workbook.fh&&lt(Q.Workbook.fh,function(t,n){var i=u&&n.Mb||n.yh;i&&a.Vp.addTask(function(t,n,e){i.call(a,r,y,o)},[a,r,o])}),a.Vp.endingCallback=function(){var t,n,n;l.dispose(),K.Util.wo(o,a.v2)||St.call(a,o),t=!1,et&&((n=a.Lp).resumeAdjust(),o.fullRecalc?(Rt(a),n.resume(!(t=!0),!1,!n.calcOnDemand)):(n.resumeWithoutCalc(),delete n.lb,a.Lp.processDynamicRef())),Q.Workbook.et(a,"initCustomName"),t||Rt(a),a.options.backgroundImage&&a.nb(),n=mt(a),i({progress:1,step:"whole workbook loaded.",sheetName:n&&n.name()}),u?n&&n.repaint():Lt(a,c,s,n),n&&a.ki(q.Events.ActiveSheetChangedInternal,{oldSheet:void 0,newSheet:n}),e(R)},a.Vp.start()},a.Vp.start()}catch(t){throw f=!0,t}finally{(u||f)&&Lt(a,c,s,mt(a))}}}},"./dist/core/workbook/workbook.js":function(_,B,t){"use strict";var u,n,o,y,D,F,P,G,U,H,V,v,z,Y,M,Z,W,Q,J,K,X,w,j,c,t,q,$,tt,nt,C,E,f,O,et,R,it,L,rt,ot,at,ut,a,s,st,ct,ft,m,lt,e,ht,l,dt,d,vt,h,g,p,mt,gt,pt,bt,wt,yt,b,Mt,Ct,St,S,T,A,Tt,I,x,At,It,xt,Nt,kt,_t,n,N,Dt,jt,Et,r,Ot,n;function Rt(t){t.getActiveSheet()}function Lt(t,n){return D.Bf.Zl()%1!=0||t.zoom()%1!=0||t.parent&&t.parent.options.scrollByPixel&&n&&t.Cb&&t.Cb.Sb((0,D.Ec)(t.Tb,t.Ab,1,1))}function Bt(n,e){return E.setTimeout(function(){n.invalidateLayout(),n.repaint(),e.Ib=O;var t=n.ot();e.xb(n,t.x,t.width),e.Nb(n,t.y,t.height)},200)}function Ft(t,n,e){t.ki(D.Events.ActiveSheetChanged,{oldSheet:n,newSheet:e})}function Pt(t,n){t.ki(D.Events.ActiveSheetChanging,n)}function Gt(t,n){t.ki(D.Events.ActiveSheetChangingInternal,n)}function Ut(t,n,e){t.ki(D.Events.ActiveSheetChangedInternal,{oldSheet:n,newSheet:e})}function i(t){this.kb=t}function Ht(t,n){n?(0,y.GC$)(t).removeClass(S):(0,y.GC$)(t).addClass(S)}function Vt(t,n,e){var i,r,n,o,n,i=D.I.fl("gc-vertical-scrollbar"+yt),o=2007<C(i.zIndex)?1:0,n=n-e,n=n%2==0?(r=n/2)-o:r=(n-o)/2;(0,y.GC$)(t).css({"box-sizing":bt,border:p,"border-color":p,"border-left-style":wt,"border-left-width":o+d,"border-left-color":i.borderLeftColor,"background-color":i.backgroundColor,width:e,padding:"0px "+r+"px 0px "+n+d,margin:0})}function zt(t,n,e){var i,r,n,o,n,i=D.I.fl("gc-horizontal-scrollbar"+yt),o=2007<C(i.zIndex)?1:0,n=n-e,n=n%2==0?(r=n/2)-o:r=(n-o)/2;(0,y.GC$)(t).css({"box-sizing":bt,border:p,"border-color":p,"border-top-style":wt,"border-top-width":o+d,"border-top-color":i.borderTopColor,"background-color":i.backgroundColor,height:e,padding:n+"px 0px "+r+"px 0px",margin:0})}function Yt(t){var n=D.I.fl("gc-footer-corner"+yt);(0,y.GC$)(t).css({border:p,padding:0,margin:0,"background-color":n.backgroundColor})}function Zt(t,n,e,i,r){var o,a,n,o=t._b(),a=n.left-e.left,n=n.top-e.top;if(a<i&&i<o.width+a&&n<r&&r<o.height+n)return{horizontalScrollBarHitInfo:{element:t.hitTest(i-a,r-n).element},x:i,y:r}}function Wt(t,n,e,i,r){var o,a,n,o=t._b(),a=n.left-e.left,n=n.top-e.top;if(a<i&&i<o.width+a&&n<r&&r<o.height+n)return{verticalScrollBarHitInfo:{element:t.hitTest(i-a,r-n).element},x:i,y:r}}function Qt(t){var t=(0,y.GC$)(t);return{top:Jt(t,"borderTopWidth"),right:Jt(t,"borderRightWidth"),bottom:Jt(t,"borderBottomWidth"),left:Jt(t,"borderLeftWidth")}}function Jt(t,n){var e=t.css(n);switch(e){case"thin":return 1;case"medium":return 3;case"thick":return 5;default:return parseFloat(e)}}function Kt(t){var t=(0,y.GC$)(t);return{top:parseFloat(t.css("paddingTop")),right:parseFloat(t.css("paddingRight")),bottom:parseFloat(t.css("paddingBottom")),left:parseFloat(t.css("paddingLeft"))}}function Xt(t){var n,e,i,e,t,r,o,n=t.getBoundingClientRect().width,e=Qt(t),i=e.left,e=e.right,t=Kt(t),r,o;return n-i-e-t.left-t.right}function qt(t){return M.SheetType[t]}function $t(t){var n,e,i,r,o,n=t.getSheetCount(),e=t.getSheetTabCount();if(0!==n&&0!==e)for(i=t.qv(),r=0;r<i.length;r++)if(o=i[r],r<n&&o.NMi||n<=r&&!o.NMi)return;return 1}function tn(t){var n={calcSources:[]};return v.Worksheet.et(t,"getRelatedCalcSources",n),n.calcSources}function k(t,n){var i,e,n,i=this;i.name="",i.Eb=!1,i.Kp=-1,i._2=0,i.jb=-1,i.Bp=!1,i.options=q(Ot,function(t,n,e){i.Ob(t,n,e)}),i.Zp(n),n&&"white"===n.backColor?i.Rb=!0:i.Rb=!1,e=1,n&&typeof(n=n.sheetCount)==rt&&(e=n),"string"==typeof t&&(t=f.getElementById(t)),i.Ti=t,i.Hc(e,t)}Object.defineProperty(B,"__esModule",{value:!0}),B.Workbook=void 0,u=t("./dist/core/workbook/workbookpanelex.js"),n=t("./dist/core/core.ns.js"),o=t("Common"),y=t("./dist/core/util/domUtil.js"),D=t("./dist/core/util/common.js"),F=t("./dist/core/util/imageLoader.js"),P=t("./dist/core/worksheet/worksheet-actions.js"),G=t("./dist/core/workbook/sheettab.js"),U=t("./dist/core/workbook/sheettab2007.js"),H=t("./dist/core/worksheet/stylehelper.js"),V=t("./dist/core/worksheet/clipboardhelper.js"),v=t("./dist/core/worksheet/worksheet.js"),z=t("CalcEngine"),Y=!!z,M=t("./dist/core/core.enum.js"),Z=t("DataManager"),W=o.Common.zf,Q=o.Commands.UndoManager,J=o.Commands.CommandManager,K=y.GC$.each,X=y.GC$.extend,w=Y,j=o.Common.lt.ht,c=D.mt.En,t=D.mt.p0,q=D.mt.b0,$=D.mt.yt,tt=D.mt.T1,nt=o.Common.CultureManager,C=parseInt,E=window,f=document,O=null,et=Math.round,R=Math.min,it=Math.floor,L=Math.abs,rt="number",ot="mousedown",at="mousemove",ut="mouseup",a="mouseenter",s="mouseleave",st="scroll",ct="resize",ft="focus",m=".gcSpread",lt=".gcSpreadInternal",e=".gcScrollbar",ht="span",l="div",dt="table",d="px",vt="100%",h="gc-scroll-handle",g="gc-scroll-bar",p="none",mt="display",gt="block",pt="absolute",bt="content-box",wt="solid",yt=" ui-widget-header ui-state-default btn btn-default",b="gc-scroll-mobile-container",Mt="gc-scroll-mobile-container-horizontal",Ct="gc-scroll-mobile-container-vertical",St="gc-scroll-mobile-spread-hovering",S="gc-scroll-mobile-state-hide",T="gc-scroll-mobile-state-hover",A=E.jQuery,Tt="cultureChanged",I="workbook",x="gcUIElement",At="gc-no-user-select",It="visible",xt="overflow",Nt="en-US",kt=80,_t=1,n=new o.Common.ResourceManager(n.SR,"Sheets"),N=n.getResource.bind(n),Dt=100,jt=30,Et=40,i.Bb=function(t,n){var t,e,e,t=t.data,e=t.ib;e.Lb&&(E.clearTimeout(e.Lb),e.Lb=O),(e=t.jg())&&n&&e.Fb(t,n)},i.Pb=function(t){var t,n,t=t.data,n=t.jg();n&&n.Gb(t)},i.Ub=function(t,n){var e,i,r,r,i,r,i,e=t.data;e&&((i=e.getActiveSheet())?((r=e.zb.Hb)&&r.Vb&&(i.Oi=!0),i.Zg()):(r=e.getActiveSheetTab())&&r.Zg(),1===(i=e.options.showScrollTip)||3===i)&&(i=(r=(0,y.GC$)(t.srcElement||t.target)).parent(),r&&(r.hasClass(h)||r.hasClass(g))||i&&(i.hasClass(h)||i.hasClass(g)))&&e.ib.Yb(!1,t,n)},i.Zb=function(t,n){var t,e,e,t=t.data,e=t.ib;e.Lb&&(E.clearTimeout(e.Lb),e.Lb=O),(e=t.jg())&&n&&e.Wb(t,n)},i.Qb=function(t){var t,n,t=t.data,n=t.jg();n&&n.Kb(t)},i.Jb=function(t){var n,e,i,i,e,i,e,n=t.data;n&&((e=n.getActiveSheet())?((i=n.Xb.Hb)&&i.Vb&&(e.Oi=!0),e.Zg()):(i=n.getActiveSheetTab())&&i.Zg(),2!==(e=n.options.showScrollTip)&&3!==e||(i=(0,y.GC$)(t.srcElement||t.target))&&(e=i.parent(),i.hasClass(h)||e&&e.hasClass(h)||i.hasClass(g)||e&&e.hasClass(g))&&n.ib.Yb(!0,t))},i.qb=function(t,n){var t,e,e,e,n,t=t.data,e=t.ib;e.Lb&&(E.clearTimeout(e.Lb),e.Lb=O),(e=t.jg())&&n&&(e.onHorizontalDockScroll(t,n),1!==(e=t.options.showScrollTip)&&3!==e||(n=t.ib.$b(!1,!0),t.ny(n)))},i.ey=function(t){var t=t.data;t&&t.iy()},i.ry=function(t){var n,e,i,r,i,o,t,n=N(),e=t.data,i=t.scrollbar;e.options.enableAccessibility&&(r=(0,y.GC$)(i.oy()).offset(),i=i.hitTest(t.x-r.left,t.y-r.top),t=(o={thumbButton:n.ARIA_Scrollbar_Thumb_Button,trackButton:n.ARIA_Scrollbar_TRACK_Button,leftButton:n.ARIA_Scrollbar_Left_Button,rightButton:n.ARIA_Scrollbar_Right_Button,upButton:n.ARIA_Scrollbar_Top_Button,downButton:n.ARIA_Scrollbar_Bottom_Button})[i.element],e.n2(t))},i.prototype.L0=function(){this.kb=O},i.prototype.ay=function(t,n,e,i){var r=this;t&&(r.eb=!0,r.uy=i?t.Tb:n,r.fy=i?t.ly:e,r.hy=i?n:t.Ab,r.vy=i?e:t.my,E.setTimeout(function(){r.gy(t)},0))},i.prototype.gy=function(t){var n=this;t&&n.eb&&(n.eb=!1,n.py(t))},i.prototype.py=function(t){var n,e,i,r,o,a,u,n=this;n.by||(n.by=!0,e=n.kb,t&&(i=e.options.showScrollTip,r=n.uy,o=n.fy,a=n.hy,u=n.vy,r!==t.Tb||o!==t.ly?(n.yy(t,r,o),2!==i&&3!==i||e.ny(n.$b(!0))):a===t.Ab&&u===t.my||(n.wy(t,a,u),1!==i&&3!==i)||e.ny(n.$b(!1))),n.by=!1)},i.prototype.yy=function(t,n,e,i){var r,o,a,u,u,i,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,T,A,I,x,T,N,k,c,i,T,e,_,l,f,r=this;if(r.Ib&&(E.clearTimeout(r.Ib),r.Ib=O),t&&(o=t.Tb,a=t.ly,(u=!j(i))||n!==o||e!==a))if(u&&(o=i),t.Tb=n,t.ly=e,0<t.My)o!==n&&t.ki(D.Events.TopRowChanged,{sheet:t,sheetName:t.name(),oldTopRow:o,newTopRow:n});else{if(u=!1,c=(s=(i=t.options).sheetAreaOffset.top)+2,f=t.kg,h=(l=t.Fi()).Cy,d=t.Sy(l),v=l.Ty,m=l.Ay,g=l.Iy,p=l.width+i.sheetAreaOffset.left,y=w=b=void 0,C=(M=t.Dn).J(),S=t.Ny,t.tables&&0===t.frozenRowCount()&&(T=t.tables.Dy())&&(T.x=T.x-2,T.width=T.width+4,T.y=s,T.height=h,t.k1=!0,M.D1(C,T)),o<n||n===o&&L(e)>L(a)){if(A=T=void 0,T=(I=t._y(1))&&0<I.length?I.findRow(n):T){for(A=I[x=I.length-1];A&&A.y+A.height>h+d;)A=I[x-=1];A&&A.row>n&&(u=!0,w=(f||l).x,y=T.y+L(e),b=A.y+A.height-y-c,M.Ey(w,y,p,b,w,h),i.colHeaderVisible||(t.invalidateLayout(),M.D1(C,new D.Rect(w,0,p,s+1))),t.invalidateLayout(),M.D1(C,new D.Rect(w,h+b,p,(T=S?d:d+g+v)-b)),M.jy(C,new D.Rect(w,h-2,p,2+(T-=S?0:v))),this.xb(t,w,p))}}else{for(N=0,k=n;k<o&&N<d;k++)N+=t.Gt(k);(N+=L(a)-L(e))<d&&(u=!0,w=(f||l).x,y=h,b=d-N,0<t.frozenTrailingRowCount()&&--b,c=0,!S&&0<v&&(i=R(f.height-(c=g)-1,m-1+N),M.Ey(w,m-1,p,c+1,w,i)),T=S?0:R(N,v)-1,M.Ey(w,y,p,b+T,w,y+N),t.invalidateLayout(),e=t.rowOutlines&&!t.rowOutlines.Oy()?t.rowOutlines.Ry()+s+1:0,M.D1(C,new D.Rect(w,y-s,p,N+s+e+5)),M.jy(C,new D.Rect(w,y-2,p,_=d+T+c+2)),this.xb(t,w,p))}u||(t.invalidateLayout(),t.repaint()),o!==n&&t.ki(D.Events.TopRowChanged,{sheet:t,sheetName:t.name(),oldTopRow:o,newTopRow:n}),(l=t.rt)&&l.By(),f=o===t.Tb&&a!==t.ly,u&&Lt(t,f)&&(r.Ib=Bt(t,r))}},i.prototype.xb=function(t,n,e){var i=t.Dn,r=i.J();this.Ly(t).concat(this.Fy(t)).forEach(function(t){var t=t.layout,t=new D.Rect(n,t.y,e,t.height);i.O1(t),i.jy(r,t)})},i.prototype.Ly=function(t){var n,e,n,i,r,o,e,a,e,n=this,e=t.getSelections();return!(1===e.length&&0<t.frozenRowCount())||(n=n.kb.options.scrollByPixel,i=t.Tb,r=t.ly,o=e[0].row,e=e[0].row+e[0].rowCount-1,n&&e==i-1)?[]:(a=[],(o===i+1||o<i&&i<=e||e==i-1||n&&o===i&&0!==r)&&(e=t._y(0))&&0<e.length&&a.push({layout:e[e.length-1]}),a)},i.prototype.Fy=function(t){var n,e,n,i,r,e,o,a,u,a,t,s,t,s,n=this,e=t.getSelections();return 1===e.length&&0<t.frozenTrailingRowCount()?(n=n.kb.options.scrollByPixel,i=t.getViewportBottomRow(1),r=e[0].row,e=e[0].row+e[0].rowCount-1,o=[],a=(u=(a=t._y(2))&&0<a.length)?a[0]:O,t=(s=(t=t._y(1))&&0<t.length)?t.findRow(i):O,s=u&&s&&a.y!==t.y+t.height,(e==i-1||r<=i&&i<e||r===i+1||n&&e===i&&s)&&u&&o.push({layout:a}),o):[]},i.prototype.wy=function(t,n,e,i){var r,o,a,u,u,i,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,T,N,k,c,i,T,e,_,l,f,r=this;if(r.Ib&&(E.clearTimeout(r.Ib),r.Ib=O),t&&(o=t.Ab,a=t.my,(u=!j(i))||n!==o||e!==a))if(u&&(o=i),t.Ab=n,t.my=e,0<t.My)o!==n&&t.ki(D.Events.LeftColumnChanged,{sheet:t,sheetName:t.name(),oldLeftCol:o,newLeftCol:n});else{if(u=!1,c=(s=(i=t.options).sheetAreaOffset.left)+2,f=t.kg,h=(l=t.Fi()).Py,d=t.Gy(l),v=l.Uy,m=l.Hy,g=l.zy,p=l.height+i.sheetAreaOffset.top,y=w=b=void 0,C=(M=t.Dn).J(),S=t.Vy,o<n||n===o&&L(e)>L(a)){if(A=T=void 0,T=(I=t.Yy(1))&&0<I.length?I.findCol(n):T){for(A=I[x=I.length-1];A&&A.x+A.width>h+d;)A=I[x-=1];A&&A.col>n&&(u=!0,b=T.x+L(e),w=(f||l).y,y=A.x+A.width-b-c,M.Ey(b,w,y,p,h,w),i.rowHeaderVisible||(t.invalidateLayout(),M.D1(C,new D.Rect(0,w,s+1,p))),t.invalidateLayout(),M.D1(C,new D.Rect(h+y,w,(T=S?d:d+g+v)-y,p)),M.jy(C,new D.Rect(h-2,w,2+(T-=S?0:v),p)),this.Nb(t,w,p))}}else{for(N=0,k=n;k<o&&N<d;k++)N+=t.nn(k);(N+=L(a)-L(e))<d&&(u=!0,b=h,w=(f||l).y,y=d-N,0<t.frozenTrailingColumnCount()&&--y,c=0,!S&&0<v&&(i=R(f.width-(c=g)-1,m-1+N),M.Ey(m-1,w,c+1,p,i,w)),T=S?0:R(N,v)-1,M.Ey(b,w,y+T,p,b+N,w),t.invalidateLayout(),e=t.columnOutlines&&!t.columnOutlines.Oy()?t.columnOutlines.Ry()+s+1:0,M.D1(C,new D.Rect(b-s,w,N+s+e+5,p)),M.jy(C,new D.Rect(h-2,w,_=d+T+c+2,p)),this.Nb(t,w,p))}u||(t.invalidateLayout(),t.repaint()),o!==n&&t.ki(D.Events.LeftColumnChanged,{sheet:t,sheetName:t.name(),oldLeftCol:o,newLeftCol:n}),(l=t.rt)&&l.By(),f=o===t.Ab&&a!==t.my,u&&Lt(t,f)&&(r.Ib=Bt(t,r))}},i.prototype.Nb=function(t,n,e){var i=t.Dn,r=i.J();this.Zy(t).concat(this.Wy(t)).forEach(function(t){var t=t.layout,t=new D.Rect(t.x,n,t.width,e);i.O1(t),i.jy(r,t)})},i.prototype.Zy=function(t){var n,e,n,i,r,o,e,a,e,n=this,e=t.getSelections();return!(1===e.length&&0<t.frozenColumnCount())||(n=n.kb.options.scrollByPixel,i=t.Ab,r=t.my,o=e[0].col,e=e[0].col+e[0].colCount-1,n&&e==i-1)?[]:(a=[],(o===i+1||o<i&&i<=e||e==i-1||n&&o===i&&0!==r)&&(e=t.Yy(0))&&0<e.length&&a.push({layout:e[e.length-1]}),a)},i.prototype.Wy=function(t){var n,e,n,i,r,e,o,a,u,a,t,s,t,s,n=this,e=t.getSelections();return 1===e.length&&0<t.frozenTrailingColumnCount()?(n=n.kb.options.scrollByPixel,i=t.getViewportRightColumn(1),r=e[0].col,e=e[0].col+e[0].colCount-1,o=[],a=(u=(a=t.Yy(2))&&0<a.length)?a[0]:O,t=(s=(t=t.Yy(1))&&0<t.length)?t.findCol(i):O,s=u&&s&&a.x!==t.x+t.width,(e==i-1||r<=i&&i<e||r===i+1||n&&e===i&&s)&&u&&o.push({layout:a}),o):[]},i.prototype.Mg=function(t,n,e,i){var r,o,a,u,s,c,f,l,h,o,d,v,h,h,o,d,v,e,d,h,o,s,v,e,o,d,h,l,r=this,o=r.kb,a=!1,u=!1,s=o.Xb,c=o.zb,f=o.options.scrollbarShowMax,l=o.options.scrollbarAppearance===M.ScrollbarAppearance.mobile;if(t){if(h=t.name(),n.ctrlKey){if(!o.options.allowUserZoom)return!0;if(o=t.zoom(),d=D.mt.ige(o-.05*e),t.isEditing()&&!t.endEdit())return;if(v={sheet:t,sheetName:t.name(),oldZoomFactor:o,newZoomFactor:d,cancel:!1},t.ki(D.Events.ViewZooming,v),v&&!0===v.cancel)return!1;h={cmd:"zoom",sheetName:h,oldZoomFactor:o,zoomFactor:v.newZoomFactor},t.Qy().execute(h),o!==(d=t.zoom())&&(delete v.cancel,t.ki(D.Events.ViewZoomed,v),t.ki(D.Events.UserZooming,v))}else i=i||0,h=t.Tb,o=t.ly,v=(d=r.Jy(t,e)).Ky,e=d.Xy,h!==v||o!==e?(l&&(s.qy(M.ScrollbarState.show),r.$y(!0)),r.yy(t,v,e),t.tw(),f||t.ew()):a=!0,d=t.Ab,h=t.my,s=(o=r.rw(t,i)).iw,v=o.Xy,d===s&&h===v||(l&&(c.qy(M.ScrollbarState.show),r.$y(!1)),r.wy(t,s,v),t.ow(),f)||t.aw();e=t.uw(),o=t.hitTest(n.pageX-e.left,n.pageY-e.top),(h=(d=t.sw)&&d.cellTypeHitInfo)&&(h.cellRect=t.getCellRect(d.row,d.col)),(l=t.rt).cw(o),l.fw(o)}return a&&0===i},i.prototype.hw=function(t,n){var e,i,r,o,a,u,s,c,n,o,o,n,r,f,n,r,e=t.Tb,i=t.ly,r=t.parent,o=t.zoom(),a=et(n*r.options.scrollPixel*o),u=0,n=t.Fi().Cy,o=t.dw(1).findRow(e);if(o)if(a<0){for(s=t.vw(-1),u=-(n-o.y);s<e&&a<=u;)u-=t.Gt(--e);i=u-a,e===s&&0<i&&(i=0)}else if(0<a){for(c=t.mw(),u=o.y+o.height-n;e<c&&u<=a;)u+=t.Gt(++e);i=u-a-(o=t.Gt(e)),r.options.scrollbarMaxAlign?(n=t.Fi(),r=t.frozenRowCount(),f=t.getRowCount()-t.frozenTrailingRowCount()-1,c=(n=t.gw(t.Sy(n),r,f)).Ky,r=n.Xy,c<e?(e=c,i=r):e===c&&L(i)>L(r)&&(i=r)):e<c&&u-a==0?(e++,i=0):e===c&&u-a<0&&(i=-o)}return{Ky:e,Xy:i}},i.prototype.Jy=function(t,n){var e,i,r,r,o,o,n,e=t.Tb,i=t.ly,r=t.parent;return r&&r.options.scrollByPixel?r.ib.hw(t,n):(0<(r=t.frozenRowCount())&&(0===e&&0<n?e=r:n<0&&e===r-n&&(e=0)),-1!==(o=t.vw(e+n,n<0))?e=o:e+=n,o=t.pw(),n=t.mw(),t.getRowCount()-r-t.frozenTrailingRowCount()<=0||o===O?e=t.Tb:(e<o?e=o:n<e&&(e=n),e===O&&(e=-1)),{Ky:e,Xy:i})},i.prototype.bw=function(t,n){var e,i,r,o,a,u,s,c,n,o,o,n,r,f,n,r,e=t.Ab,i=t.my,r=t.parent,o=t.zoom(),a=et(n*r.options.scrollPixel*o),u=0,n=t.Fi().Py,o=t.yw(1).findCol(e);if(o)if(a<0){for(s=t.ww(-1),u=-(n-o.x);s<e&&a<=u;)u-=t.nn(--e);i=u-a,e===s&&0<i&&(i=0)}else if(0<a){for(c=t.Mw(),u=o.x+o.width-n;e<c&&u<=a;)u+=t.nn(++e);i=u-a-(o=t.nn(e)),r.options.scrollbarMaxAlign?(n=t.Fi(),r=t.frozenColumnCount(),f=t.getColumnCount()-t.frozenTrailingColumnCount()-1,c=(n=t.Cw(t.Gy(n),r,f)).iw,r=n.Xy,c<e?(e=c,i=r):e===c&&L(i)>L(r)&&(i=r)):e<c&&u-a==0?(e++,i=0):e===c&&u-a<0&&(i=-o)}return{iw:e,Xy:i}},i.prototype.rw=function(t,n){var e,i,r,r,o,o,n,e=t.Ab,i=t.my,r=t.parent;return r&&r.options.scrollByPixel?r.ib.bw(t,n):(0<(r=t.frozenColumnCount())&&(0===e&&0<n?e=r:n<0&&e===r-n&&(e=0)),-1!==(o=t.ww(e+n,n<0))?e=o:e+=n,o=t.Sw(),n=t.Mw(),t.getColumnCount()-r-t.frozenTrailingColumnCount()<=0||o===O?e=t.Ab:(e<o?e=o:n<e&&(e=n),e===O&&(e=-1)),{iw:e,Xy:i})},i.prototype.Yb=function(t,n,e){var i,r,o,e,a,i,i=this,r=i.kb,a;(0,D.jf)(r)&&(i=i.$b(t,e),e=t?(o=n.pageY,n.pageX-100):(o=n.pageY-40,n.pageX-30),r.Tw(W.j0(i),e,o,!0))},i.prototype.$b=function(t,n){var e,i,e=(0,D.jf)(this.kb);return i=e?e.getScrollTooltipContent(t,n):i},i.prototype.Aw=function(t){(0,y.GC$)(t).addClass(S)},i.prototype.Iw=function(t){(0,y.GC$)(t).removeClass(S)},i.prototype.xw=function(t){(0,y.GC$)(t).addClass(T)},i.prototype.Nw=function(t){(0,y.GC$)(t).removeClass(T)},i.prototype.$y=function(t,n){var e,i,r,o,a;void 0===n&&(n=1e3),i=(e=this).kb,r=t?i.kw:i.Dw,a=function(){e.Nw(r),e.Aw(r)},(o=i.options.scrollbarAppearance=M.ScrollbarAppearance.mobile)&&(e._w(t),t?e.Ew=setTimeout(a,n):e.jw=setTimeout(a,n))},i.prototype._w=function(t){var n=this;t&&n.Ew?(clearTimeout(n.Ew),n.Ew=null):!t&&n.jw&&(clearTimeout(n.jw),n.jw=null)},r=i,Ot={allowUserDragDrop:!0,allowUserDragFill:!0,allowUserZoom:!0,allowUserResize:!0,allowUndo:!0,allowSheetReorder:!0,allowContextMenu:!0,allowUserDeselect:!0,defaultDragFillType:5,showDragFillSmartTag:!0,showHorizontalScrollbar:!0,showVerticalScrollbar:!0,scrollbarShowMax:!0,scrollbarMaxAlign:!1,tabStripVisible:!0,tabStripRatio:.5,tabStripPosition:M.TabStripPosition.bottom,tabStripWidth:80,tabEditable:!0,newTabVisible:!0,allSheetsListVisible:M.AllSheetsListVisibility.auto,cutCopyIndicatorVisible:!0,cutCopyIndicatorBorderColor:"#217346",tabNavigationVisible:!0,backColor:"white",backgroundImage:O,backgroundImageLayout:0,showResizeTip:M.ShowResizeTip.none,showDragDropTip:!0,showDragFillTip:!0,scrollIgnoreHidden:!1,highlightInvalidData:!1,showScrollTip:M.ShowScrollTip.none,grayAreaBackColor:O,useTouchLayout:!1,hideSelection:!1,resizeZeroIndicator:M.ResizeZeroIndicator.enhanced,allowUserEditFormula:!0,pivotAreaReference:1,enableFormulaTextbox:!0,referenceStyle:0,allowDynamicArray:!1,iterativeCalculation:!0,iterativeCalculationMaximumIterations:1e3,iterativeCalculationMaximumChange:.01,calcOnDemand:!1,dynamicReferences:!0,autoFitType:M.AutoFitType.cell,allowCopyPasteExcelStyle:!0,allowExtendPasteRange:!1,copyPasteHeaderOptions:M.CopyPasteHeaderOptions.allHeaders,calculationMode:M.CalculationMode.auto,allowUserDragMerge:!1,rowResizeMode:M.ResizeMode.normal,columnResizeMode:M.ResizeMode.normal,scrollByPixel:!1,scrollPixel:5,enableAccessibility:!1,allowAutoCreateHyperlink:!0,scrollbarAppearance:M.ScrollbarAppearance.skin,font:O,customList:[],numbersFitMode:M.NumbersFitMode.mask,pasteSkipInvisibleRange:!1,allowAutoExtendFilterRange:!1,allowInvalidFormula:!1,formulaFormatHint:!0},k.prototype.commandManager=function(){return this.Qy},k.prototype.undoManager=function(){return this.Wp},k.prototype.Ow=function(){var t=this.Rw(),n=this.Bw;return n instanceof Array?n.concat(t):t},k.prototype.Rw=function(){var t=nt.culture(),n=[],e=[],i=nt.Fe(Nt).DateTimeFormat,r=nt.Fe(t).DateTimeFormat,n=this.Lw(i);return t!==Nt&&(e=this.Lw(r)),n.concat(e)},k.prototype.Lw=function(n){var e=[],i,r;return this.Fw=["abbreviatedDayNames","dayNames","abbreviatedMonthNames","monthNames"],this.Fw.forEach(function(t){(i=n[t])instanceof Array&&0<i.length&&(r=-1<t.indexOf("month")||-1<t.indexOf("Month"),i=r?i.slice(0,12):i,e.push(i))}),e},k.prototype.Fp=function(){var t,n,t,n=w&&this.op();n&&n.clearDirties(),this.sheets.forEach(function(t){var n;t.Uw().Gw()})},k.prototype.Ob=function(t,n,e){var i,r,o,a,i=this,r=(0,D.jf)(i),o=w&&i.op();switch(t){case"allowUndo":i.Wp&&(i.Wp.Hw=n);break;case"backColor":i.Rb=!0,r&&r.zw();break;case"cutCopyIndicatorBorderColor":case"cutCopyIndicatorVisible":case"grayAreaBackColor":case"hideSelection":case"highlightInvalidData":case"resizeZeroIndicator":case"allowUserDragFill":case"allowUserDragMerge":case"numbersFitMode":case"pasteSkipInvisibleRange":r&&r.zw();break;case"backgroundImage":case"backgroundImageLayout":i.nb(),r&&r.zw();break;case"newTabVisible":case"allSheetsListVisible":case"tabNavigationVisible":(a=i.w2)&&a.repaint();break;case"tabStripPosition":n!==e&&i.Vw(n);break;case"tabStripWidth":n!==e&&i.Yw(n);break;case"showHorizontalScrollbar":case"showVerticalScrollbar":case"useTouchLayout":case"tabStripVisible":i.Cg();break;case"tabStripRatio":i.Xg();break;case"scrollIgnoreHidden":case"scrollbarMaxAlign":case"scrollbarShowMax":r&&(r.Zw=!0,r.Ww=!0,r.zw());break;case"scrollByPixel":r&&(r.Zw=!0,r.Ww=!0,r.ly=0,r.my=0,r.zw());break;case"scrollPixel":n<=0&&(i.options.scrollPixel=e);break;case"scrollbarAppearance":i.ib&&n!==e&&i.Qw(n);break;case"calcOnDemand":o&&(!n&&o.calcOnDemand&&i.Fp(),o.calcOnDemand=n);break;case"dynamicReferences":o&&(o.dynamicReferences=n);break;case"customList":i.Bw=n;break;case"referenceStyle":case"allowDynamicArray":case"calculationMode":case"iterativeCalculation":case"iterativeCalculationMaximumIterations":case"iterativeCalculationMaximumChange":i.Kw(t,n),r&&r.zw()}i.ki(D.Events.WorkbookOptionsChangedInternal,{propertyName:t,value:n})},k.prototype.Qw=function(t){var n,e,e=(t=j(t)?M.ScrollbarAppearance.skin:t)===M.ScrollbarAppearance.mobile;(n=this).Xb.Jw(t),n.zb.Jw(t),n.Xw.Jw(t),n.qw(),e?n.$w():n.tM(),n.refresh()},k.prototype.Vw=function(t){var n=this;j(t)&&(t=M.TabStripPosition.bottom,n.options.tabStripPosition=t),n.nM&&(n.eM(),n.iM(),n.Cg())},k.prototype.Yw=function(t){var n=this;j(t)?n.options.tabStripWidth=t=80:t<80&&(n.options.tabStripWidth=80),n.nM&&(n.iM(),n.Cg())},k.prototype.Kw=function(t,n){var e,i,e,i=w&&this.op();if(i)switch(t){case"referenceStyle":i.useR1C1=1===n;break;case"allowDynamicArray":case"calculationMode":case"iterativeCalculation":case"iterativeCalculationMaximumIterations":case"iterativeCalculationMaximumChange":i[t]=n}},k.prototype.Hc=function(t,n){var r,e,i,o,e,r=this;for(w&&r.Qp(),r.rM=[],r.oM=c("input"),r.vf=0,r.sg=0,r.aM={fromSheet:O,isCutting:!1},r.uM={fromSheet:O,isCutting:!1},r.sM=O,r.sheets=[],r.mp=[],r.dse=[],r.Hp={},r.Bw=r.options.customList,r.Wp=new Q(r,-1,r.options.allowUndo),(e=r.Qy=new J(r)).cM("beforeWorkbookExecute",function(t){r.fM(t)}),e.addListener("workbookUndo",function(t){var n,e,i,i,n=t.command,e=P.Commands.lM(n),i=r.Qy[n.cmd];i&&i.canUndo()&&!e&&!n.hM&&((i=r.getSheetFromName(n.sheetName))&&(n.sheetId=i._id),r.undoManager().dM(n,t.vM)),1!==t.vM&&2!==t.vM||r.mM(t)}),P.Commands.gM(e),k.et(r,"init"),i=0;i<t;i++)o=r.S2(r.T2(i)),r.sheets.push(o),r.dse.push(o),o.E0i=i,o.pM(r);(e=r.sheets[r._2])&&e.isSelected(!0),r.suspendPaint(),n&&r.hg(n),r.bM=new V.yM(r),r.resumePaint()},k.prototype.hitTest=function(t,n,e){var i,r,o,a,u,s,c,s,f,l,c,h,c,c,d,v,c,d,r,v,c,m,g,p,e,b,w,d,r,o,v,c,e,d,r,a,o,v,c,e,i=this,r=i.jg(),o=i.w2,a=i.zb,u=i.Xb,s=(0,y.GC$)(i.getHost()).width(),c=(0,y.GC$)(i.getHost()).height();if(t<0||s<t||n<0||c<n)return O;if(s=i.wM(),f=i.options.scrollbarAppearance===M.ScrollbarAppearance.mobile){if(c=Zt(a,l=(0,y.GC$)(i.Dw).offset(),s,t,n))return c;if(c=Wt(u,h=(0,y.GC$)(i.kw).offset(),s,t,n))return c}if(r&&(c=r.uw(),d=r.ot(),v=c.left-s.left,c=c.top-s.top,v<t)&&t<d.width+v&&c<n&&n<d.height+c)return{worksheetHitInfo:r.hitTest(t-v,n-c,!1,e),x:t,y:n};if(d=(0,y.GC$)(o.Dg()).offset(),r=o.ot(),v=d.left-s.left,c=d.top-s.top,v<t&&t<r.width+v&&c<n&&n<r.height+c){switch(g={},p=(m=o.hitTest(t-v,n-c)).index,b=(e=i.e2(p))&&e.name(),w=O,e&&qt(e._gi)&&(w=e._gi),m.type){case"navButton":g={navButton:m.element};break;case"sheetTab":g={sheetTab:{sheetName:b||m.element,sheetIndex:p}},w!==O&&(g.sheetTab.sheetType=w);break;case"resize":g={resize:!0};break;default:g={blank:!0}}return{tabStripHitInfo:g,x:t,y:n}}return d=(0,y.GC$)(a.oy()).offset(),r=a._b(),o=d.left-s.left,v=d.top-s.top,o<t&&t<r.width+o&&v<n&&n<r.height+v?{horizontalScrollBarHitInfo:{element:a.hitTest(t-o,n-v).element},x:t,y:n}:(c=(0,y.GC$)(u.oy()).offset(),e=u._b(),d=c.left-s.left,r=c.top-s.top,d<t&&t<e.width+d&&r<n&&n<e.height+r?{verticalScrollBarHitInfo:{element:u.hitTest(t-d,n-r).element},x:t,y:n}:(a=(0,y.GC$)(i.MM).offset(),o=parseInt(i.MM.style.width.substr(0,i.MM.style.width.indexOf("px")),10),v=parseInt(i.MM.style.height.substr(0,i.MM.style.height.indexOf("px")),10),c=a.left-s.left,e=a.top-s.top,c<t&&t<o+c&&e<n&&n<v+e?{footerCornerHitInfo:{element:"footerCorner"},x:t,y:n}:void 0))},k.prototype.wM=function(){var t=this,t,t=(A||y.GC$)(t.Ti).offset();return t?(t.top+=f.body.clientTop||0,t.left+=f.body.clientLeft||0):t={top:0,left:0},t},k.prototype.Zp=function(t){var e,t,e=this.options,t=t||{};t=X(!0,{},Ot,t),K(t,function(t,n){e.hasOwnProperty(t)&&(e[t]=n)})},k.prototype.j2=function(){var t=this;return!t.sM&&t.Ti&&(t.sM=c(l),(0,y.GC$)(t.sM).css({position:"relative",left:0,top:0,height:0}).attr(x,"gcLayerContainer"),(0,y.GC$)(t.Ti).prepend(t.sM)),t.sM},k.prototype.T2=function(t){var n,e,i,r,o,a,u,s,n=this,e=n.getSheetCount();n.Kp<e?n.Kp=e:n.Kp++,(j(t)||t<n.Kp)&&(t=n.Kp),i=!1,o=n.qv();do{for(r=(N().SHEET_NAME||"Sheet")+(t+1),a=o.length,u=0;u<a;u++)if(s=o[u]){if(s.name().toUpperCase()===r.toUpperCase()){t++,i=!0;break}i=i&&!1}}while(i);return r},k.prototype.S2=function(t){return new v.Worksheet(t)},k.prototype.setHost=function(t){this.hg(t)},k.prototype.hg=function(t){var n=this;t&&(n.Ti=t,n.CM(),n.nl(),n.SM(),n.TM(),n.AM(),n.IM(),n.xM(),n.NM(),n.kM(),n.DM(),n._M(),n.$w(),n.EM(),n.jM(),n.OM(),n.BM(),n.iM(),n.Cg(),n.LM(t),k.et(n,"setHost",t))},k.prototype.CM=function(){var t,n,t=this,n=t.Ti;A&&A(n).data(I,t),(0,y.GC$)(n).data(I,t).attr(x,"gcSpread").addClass(At).css(xt,It)},k.prototype.nl=function(){E.Vc.nl()},k.prototype.SM=function(){var t=this;t.cultureChangedHandler=function(){t.FM()},f.addEventListener(Tt,t.cultureChangedHandler)},k.prototype.TM=function(){var t=this;t.PM(),t.GM(),t.HM()},k.prototype.GM=function(){var t,n,e,i,r,o,a,u,s,t=this,n=t.Ti,e=c(dt),i=e.style;for(e.cellSpacing="0px",e.cellPadding="0px",e.border="0",i.width=vt,i.height=vt,i.border="0",i.margin="0",i.borderCollapse="collapse",i.float="left",r=0;r<3;r++){for(o=c("tr"),a=0;a<2;a++)(s=(u=c("td")).style).padding="0",s.border="0",o.appendChild(u);e.appendChild(o)}n.appendChild(e),t.nM=e},k.prototype.PM=function(){var t,n,e,i,t=this,n=t.Ti,e=c(l),i=e.style;i.width="0",i.height="0",i.float="left",n.appendChild(e),t.zM=e},k.prototype.HM=function(){var t,n,e,i,t=this,n=t.Ti,e=c(l),i=e.style;i.width="0",i.height="0",i.float="left",n.appendChild(e),t.VM=e},k.prototype.AM=function(){var t,n,e,i,r,t=this,n=t.Ti,e,i=t.nM.rows[1].cells[0],r=c(l);r.id=n.id+"vp",(0,y.GC$)(i).append(r),t.Kg=r},k.prototype.IM=function(){var t,n,e,i,r,i,r,r,i,o,t=this,n,e=t.nM.rows[1].cells[1],i=t.options,r=i.scrollByPixel,i=i.scrollbarAppearance,r=r?M.ScrollType.pixels:M.ScrollType.continuous,r=new u.YM(!1,O,O,O,O,O,r,i,function(){t.ZM(!0)}),i=c(l),o=r.oy();(0,y.GC$)(i).append(o),t.Xb=r,t.kw=i,t.WM=e},k.prototype.QM=function(){var i,t,i=this,t=i.Xb.oy();(0,y.GC$)(t).bind(st+e,function(t,n){var e=n.scrollEventType;t.data=i,n.scrollOrientation===u.ScrollOrientation.verticalScroll&&(e===M.Zi.smallDecrement||e===M.Zi.smallIncrement||e===M.Zi.largeDecrement||e===M.Zi.largeIncrement||e===M.Zi.thumbTrack?r.Zb(t,n):e===M.Zi.thumbPosition&&r.Qb(t))}).bind(ot+e,function(t){t.data=i,r.Jb(t)}).bind(ut+e,function(t){t.data=i,r.ey(t)}).bind(at+e,function(t){t.data=i,t.scrollbar=i.Xb,r.ry(t)})},k.prototype.xM=function(){var t,n,e,i,r,o,a,u,s,t=this,n,e=t.nM.rows[2].cells[0],i=c(dt),r=i.style;for(i.cellSpacing="0",i.cellPadding="0",i.border="0",r.border="0",r.margin="0",(0,y.GC$)(i).css("user-select",p),o=c("tr"),a=0;a<2;a++)(s=(u=c("td")).style).padding="0",s.border="0",o.appendChild(u);i.appendChild(o),(0,y.GC$)(e).append(i),t.JM=i},k.prototype.NM=function(){var t,n,e,i,t=this,n=t.Ti,e=c(l),i=e.style;i.width=t.Jg()*(0,y.GC$)(n).width()+d,i.height=t.Zv()+d,i.fontSize="10pt",i.fontFamily="Arial",t.XM=e},k.prototype.kM=function(){var t,n,e,i,r,i,r,r,o,a,o,r,t=this,n,e=t.JM.rows[0].cells[1],i=t.options,r=i.scrollByPixel,i=i.scrollbarAppearance,r=r?M.ScrollType.pixels:M.ScrollType.continuous,r=new u.YM(!0,O,O,O,O,O,r,i,function(){t.ZM(!1)}),o=r.oy(),a=c(l);(0,y.GC$)(a).append(o),t.zb=r,r=(o=new u.YM(!0,O,O,O,O,O,M.ScrollType.pixels,i,function(){t.ZM(!1)})).oy(),(0,y.GC$)(a).append(r),t.Xw=o,t.Dw=a,t.qM=e},k.prototype.$M=function(){var i,t,i=this,t=i.zb.oy();(0,y.GC$)(t).bind(st+e,function(t,n){var e=n.scrollEventType;t.data=i,n.scrollOrientation===u.ScrollOrientation.horizontalScroll&&(e===M.Zi.smallDecrement||e===M.Zi.smallIncrement||e===M.Zi.largeDecrement||e===M.Zi.largeIncrement||e===M.Zi.thumbTrack?r.Bb(t,n):e===M.Zi.thumbPosition&&i.iy())}).bind(ot+e,function(t){t.data=i,r.Ub(t)}).bind(ut+e,function(t){t.data=i,r.ey(t)}).bind(at+e,function(t){t.data=i,t.scrollbar=i.zb,r.ry(t)})},k.prototype.tC=function(){var i,t,i=this,t=i.Xw.oy();(0,y.GC$)(t).bind(st+e,function(t,n){var e=n.scrollEventType;t.data=i,n.scrollOrientation===u.ScrollOrientation.horizontalScroll&&(e===M.Zi.smallDecrement||e===M.Zi.smallIncrement||e===M.Zi.largeDecrement||e===M.Zi.largeIncrement||e===M.Zi.thumbTrack?r.qb(t,n):e===M.Zi.thumbPosition&&r.Pb(t))}).bind(ot+e,function(t){t.data=i,r.Ub(t,!0)}).bind(ut+e,function(t){t.data=i,r.ey(t)}).bind(at+e,function(t){t.data=i,t.scrollbar=i.Xw,r.ry(t)})},k.prototype.DM=function(){var t=this;t.nC(),t.eC()},k.prototype.nC=function(){var t,n,e,i,t=this,n,e=t.nM.rows[0].cells[1],i=c(l);(0,y.GC$)(e).append(i),t.iC=i},k.prototype.eC=function(){var t,n,e,i,t=this,n,e=t.nM.rows[2].cells[1],i=c(l);(0,y.GC$)(e).append(i),t.MM=i},k.prototype.EM=function(){var t=this;t.ib=new r(t)},k.prototype._M=function(){var t=this;t.QM(),t.$M(),t.tC()},k.prototype.$w=function(){var t,n,e,i,r,o,t=this,n,e;t.options.scrollbarAppearance===M.ScrollbarAppearance.mobile&&(i=t.Ti,r=t.kw,o=t.Dw,(0,y.GC$)(r).bind(a,function(){t.Xb.qy(M.ScrollbarState.active)}).bind(s,function(){t.Xb.qy(M.ScrollbarState.inactive)}),(0,y.GC$)(o).bind(a,function(){t.zb.qy(M.ScrollbarState.active),t.Xw.qy(M.ScrollbarState.active)}).bind(s,function(){t.zb.qy(M.ScrollbarState.inactive),t.Xw.qy(M.ScrollbarState.inactive)}),(0,y.GC$)(i).bind(a,t.oC).bind(s,t.aC))},k.prototype.tM=function(){var t,n,e,t=this,n=t.kw,e=t.Dw;n&&((0,y.GC$)(n).unbind(a).unbind(s),t.ib._w(!0)),e&&((0,y.GC$)(e).unbind(a).unbind(s),t.ib._w(!1)),(0,y.GC$)(t.Ti).unbind(a,t.oC).bind(s,t.aC)},k.prototype.oC=function(){(0,y.GC$)(this).find("."+b).addClass(St)},k.prototype.aC=function(){(0,y.GC$)(this).find("."+b).removeClass(St)},k.prototype.jM=function(){var t=this;t.eM(),t.qw()},k.prototype.uC=function(){var t,n,e,t,i,r,t,t=this,n=t.w2,e=t.options.tabStripPosition,t=t.options.tabStripVisible,i=0,r=0;return n&&t&&(t=n.ot(),e===M.TabStripPosition.top?r=t.height:e===M.TabStripPosition.left&&(i=t.width)),{left:i,top:r}},k.prototype.sC=function(){var t,n,t,t=this,n=t.j2(),t=t.uC();(0,y.GC$)(n).css({left:t.left,top:t.top})},k.prototype.qw=function(){var t,n,e,i,r,o,a,e,t=this,n=t.Ti;t.ib&&(e=t.options.scrollbarAppearance===M.ScrollbarAppearance.mobile,i=t.WM,r=t.qM,o=t.kw,a=t.Dw,(0,y.GC$)(o).removeAttr("style"),(0,y.GC$)(a).removeAttr("style"),(0,y.GC$)(a).addClass("gc-clear-float"),e?(e=t.j2(),o.style.position="absolute",o.style.top="0px",o.style.left="0px",(0,y.GC$)(o).addClass(b+" "+Ct),(0,y.GC$)(e).append(o),a.style.position="absolute",a.style.top="0px",a.style.left="0px",(0,y.GC$)(a).addClass(b+" "+Mt),(0,y.GC$)(e).append(a)):((0,y.GC$)(i).append(o),(0,y.GC$)(r).append(a),(0,y.GC$)(o).removeClass(b+" "+S+" "+Ct+" "+T),(0,y.GC$)(a).removeClass(b+" "+S+" "+Mt+" "+T),(0,y.GC$)(n).css("position","auto")))},k.prototype.eM=function(){var t,n,e,i,r,o,a,t,u,t=this,n=t.nM,e=t.zM,i=t.VM,r=t.JM,o=t.XM,a=t.options.tabStripPosition,t=t.options.tabStripVisible;a===M.TabStripPosition.bottom?u=r.rows[0].cells[0]:a===M.TabStripPosition.top?u=n.rows[0].cells[0]:a===M.TabStripPosition.left?u=e:a===M.TabStripPosition.right&&(u=i),a!==M.TabStripPosition.bottom&&a!==M.TabStripPosition.top&&t?n.style.tableLayout="fixed":n.style.tableLayout="",(0,y.GC$)(u).append(o)},k.prototype.LM=function(t){var n,e,i,r,n=this,e="tabindex",i=C((0,y.GC$)(t).attr(e),10)||0,r=c(l);(0,y.GC$)(r).css({position:pt,overflow:"hidden"}).attr(x,"gcSheetFocusElementForTab").attr(e,i).bind(ft,function(){n.fC||(0,D.jf)(n).Zg(),n.fC=!1}),t.insertBefore(r,O),n.lC=r},k.prototype.OM=function(){var t,n,t=this,n=function(){t.hC()};(0,y.GC$)(E).bind(ct+m,n),t.dC=n},k.prototype.BM=function(){var t,n,t=this,n=(0,D.jf)(t);n&&n.hg(t.Kg)},k.prototype.vC=function(){var t=this,n=t.lC;n&&(t.fC=!0,n.focus())},k.prototype.mC=function(){var t,n,e,i,r,o,t=this.getActiveSheet();if(t)if(D.hi.A1(t)){if(e=this.Ti)for(i=document.activeElement,r=document.body,o=i;o;){if(o===e){n=i;break}if(o===r)break;o=o.parentElement}}else t.fg&&(n=t.fg);return n},k.prototype.n2=function(e){var i=this;i.Q1e(),i.gC=E.setTimeout(function(){var t,n,t=i.mC();t&&("gcWorksheetCanvas"!==(n=t.getAttribute(x))&&"gcSheetClipboard"!==n&&t.setAttribute("aria-label",e),D.mt.Qf())&&(t.textContent="",i.vC(),setTimeout(function(){t.focus()},50)),E.clearTimeout(i.gC),i.gC=O},50)},k.prototype.Q1e=function(){var t=this;t.gC&&(E.clearTimeout(t.gC),t.gC=O)},k.prototype.L0=function(){var t,n,e,i,r,o,a,u,n,n,s,e,i,t=this,n=t.zb,e=t.Xb,i=t.Xw,o=t.sheets,a=t.options.scrollbarAppearance===M.ScrollbarAppearance.mobile;for(t.zp(),D.Bf.ih(t),D.mt.L0(),t.dC&&(0,y.GC$)(E).unbind(ct+m,t.dC),t.dC=O,t.pC&&clearTimeout(t.pC),n&&n.dispose(),e&&e.dispose(),i&&i.dispose(),t.bC(),t.iy(),D.hi.ai()===t.getActiveSheet()&&D.hi.F1(O),r=0;r<o.length;r++)o[r].L0(!0);for(o.splice(0,o.length),u=t.mp,r=0;r<u.length;r++)u[r].L0(!0);u.splice(0,u.length),t.dse.splice(0,t.dse.length),(n=t.bM)&&(n.L0(),t.bM=O),e="class",i="unselectable",(n=t.Ti)&&(s=(0,y.GC$)(n),f.removeEventListener(Tt,t.cultureChangedHandler),s.html("").removeAttr(x).removeClass(At),s.attr(e)||s.removeAttr(e),s.attr(i)||s.removeAttr(i),s.data(I)&&s.data(I,O),A)&&A(n).data(I)&&A(n).data(I,O),a&&t.tM(),t.Dw=O,t.kw=O,t.Wp&&(t.Wp.L0(),t.Wp=O),t.w2&&(t.w2.L0(),t.w2=O),k.et(t,"dispose"),t.lC&&((0,y.GC$)(t.lC).unbind(ft),t.lC=O),t.Lp&&(t.Lp.dispose(),t.Lp=O,t.yC=O,t.wC=O),t.MC&&(t.MC.L0(),t.MC=O),H.W.L0(),t.Qy&&(t.Qy.L0(),t.Qy=O),t.ib&&(t.ib.L0(),t.ib=O),t.v2&&(t.v2.dispose(),t.v2=O)},k.prototype.bC=function(){var t,n,e,i,r,o,a,u,t=this,n=t.sheets;for((0,y.GC$)(t.oM).unbind(m),e=0;e<n.length;e++)(i=n[e]).bC();for(o=0,a=r=t.mp;o<a.length;o++)(u=a[o]).bC();t.rM&&(t.rM.length=0)},k.prototype.zp=function(){var t,n,e,i,r,t=this,n=t.CC;if(n)for(e=0,i=n;e<i.length;e++)(r=i[e]).close&&r.close();t.CC=[]},k.prototype.iM=function(){var t,n,e,t=this,n=C(D.I.fl("").zIndex),e=n!==t.SC;e&&t.TC(n),t.AC(e),t.IC(),t.xC()},k.prototype.TC=function(t){this.SC=t},k.prototype.AC=function(t){var n,e,i,e,r,n=this,e=n.Ti,i=n.SC,e=e.getAttribute("id")+"_tabStrip",r=n.w2;r&&!t?(r.mg(),r.repaint()):(r&&r.L0(),r=new(2007<i?G.Gv:U.Jm)(e),(n.w2=r).Sg(n),r.hg(n.XM))},k.prototype.IC=function(){var t,n,e,i,r,t=this,n=t.options.scrollbarAppearance===M.ScrollbarAppearance.mobile,e=t.Zv(),i=t.Xm(),r=t.NC();n?t.kC():(Vt(t.kw,r,i),zt(t.Dw,e,i))},k.prototype.xC=function(){var t=this;Yt(t.MM),Yt(t.iC)},k.prototype.hC=function(){var t=this,n=t.pC;n&&clearTimeout(n),t.pC=E.setTimeout(function(){D.Bf.rh(),t.Cg(),t.pC=O},100)},k.prototype.Cg=function(){var t=this;t.Eb||(t.Eb=!0,t.DC(),t.Eb=!1)},k.prototype.DC=function(){var t,n,t=this,n;t.Ti&&(t._C(),t.EC(),t.jC(),t.OC(),t.RC(),t.BC(),t.LC(),t.PC(),t.GC(),t.UC(),t.HC(),t.sC(),t.zC())},k.prototype._C=function(){var t,n,n,e,i,r,i,e,t,o,e,t=this,n=t.zM;n&&(n=n.style,i=(e=t.options).tabStripVisible,r=e.tabStripPosition,i=i?e.tabStripWidth:0,e=t.Ti,t=(0,y.GC$)(e).height(),e=r===M.TabStripPosition.left?(o=i,t):o=0,n.width=o+d,n.height=e+d)},k.prototype.EC=function(){var t,n,n,e,i,r,e,o,i,a,t=this,n=t.nM;n&&(n=n.style,i=(e=t.options).tabStripVisible,r=e.tabStripPosition,e=e.tabStripWidth,o=(0,y.GC$)(t.Ti).width(),i=!i||r!==M.TabStripPosition.left&&r!==M.TabStripPosition.right?o+d:(a=it(Xt(t.Ti)))-e+d,n.width=i)},k.prototype.OC=function(){var t,n,n,e,i,r,i,e,t,o,e,t=this,n=t.VM;n&&(n=n.style,i=(e=t.options).tabStripVisible,r=e.tabStripPosition,i=i?e.tabStripWidth:0,e=t.Ti,t=(0,y.GC$)(e).height(),e=r===M.TabStripPosition.right?(o=i,t):o=0,n.width=o+d,n.height=e+d)},k.prototype.jC=function(){var t,n,e,i,i,r,e,o,a,t,u,s,c,f,l,t,c,h,n,r,t=this,n=t.Ti,e=(0,y.GC$)(n),i=t.Kg;i&&(i=i.style,r=e.width(),e=e.height(),o=t.NC(),a=t.Zv(),u=(t=t.options).showVerticalScrollbar,s=t.showHorizontalScrollbar,c=t.scrollbarAppearance,f=t.tabStripVisible,l=t.tabStripPosition,t=f?t.tabStripWidth:0,c=c===M.ScrollbarAppearance.mobile,n=(h=l===M.TabStripPosition.left||l===M.TabStripPosition.right)?it(Xt(n)):r,u&&!c&&(n-=o),h&&(n-=t),r=e,l===M.TabStripPosition.top?(s&&!c&&(r-=a),f&&(r-=a)):(s&&!c||f&&l===M.TabStripPosition.bottom)&&(r-=a),r<2&&(r=2),i.width=n+d,i.height=r+d)},k.prototype.RC=function(t){var n,e,e,i,e,i,r,o,a,u,s,c,f,l,a,c,h,d,v,m,m,g,n,e,o,n=this,e=n.Ti,e=(0,y.GC$)(e),i=n.Kg;i&&(j(t)&&(t=e.width()),e=(0,y.GC$)(i).height(),i=n.zb,r=n.Xw,o=n.Xb,u=(a=n.options).showVerticalScrollbar,s=a.showHorizontalScrollbar,c=a.scrollbarAppearance,f=a.tabStripVisible,l=a.tabStripPosition,a=f?a.tabStripWidth:0,c=c===M.ScrollbarAppearance.mobile,h=n.Xm(),d=n.NC(),v=n.VC(),m=(m=(0,D.jf)(n))?m.getHDockScrollbarWidth():0,u?((0,y.GC$)(n.kw).show(),(0,y.GC$)(o.oy()).show()):((0,y.GC$)(n.kw).hide(),(0,y.GC$)(o.oy()).hide()),s?((0,y.GC$)(n.Dw).show(),(0,y.GC$)(i.oy()).show(),(0,y.GC$)(r.oy()).show()):((0,y.GC$)(n.Dw).hide(),(0,y.GC$)(i.oy()).hide(),(0,y.GC$)(r.oy()).hide()),0===m?(0,y.GC$)(r.oy()).hide():(0,y.GC$)(r.oy()).show(),n=e,o.YC(h),o.ZC(n),e=t-m,l!==M.TabStripPosition.left&&l!==M.TabStripPosition.right||(e-=a),f&&!c&&l===M.TabStripPosition.bottom&&(e-=v),u&&!c&&(e-=d),o=h,s||f||l!==M.TabStripPosition.bottom||(o=0),i.YC(e=e<=0?1:e),i.ZC(o),r.YC(m),r.ZC(o))},k.prototype.VC=function(){var t,n,e,i,r,e,o,n,a,u,t=this,n=t.Kg,e=t.options,i=e.tabStripPosition,r=e.tabStripWidth,e=e.scrollbarAppearance,o=(0,D.jf)(t),n=(0,y.GC$)(n).width();return i===M.TabStripPosition.bottom||i===M.TabStripPosition.top?(o&&i===M.TabStripPosition.bottom&&e===M.ScrollbarAppearance.skin&&(n-=u=o.getHDockScrollbarWidth()),a=et(t.Jg()*n),i===M.TabStripPosition.bottom&&a===n&&(a=n-1)):a=r,a},k.prototype.BC=function(){var t,n,n,e,e,i,r,i,o,t,i,t=this,n=t.Ti,n=(0,y.GC$)(n).height(),e=t.XM;e&&(e=e.style,r=(i=t.options).tabStripVisible,i=i.tabStripPosition,o=t.Zv(),t=t.VC(),i=i===M.TabStripPosition.bottom||i===M.TabStripPosition.top?o:n,r||(i=0),e.width=t+d,e.height=i+d)},k.prototype.LC=function(){var t,n,e,i,r,o,a,u,i,s,t,c,f,c,l,t=this,n=t.iC,e=t.MM,i=t.options,r=i.showVerticalScrollbar,o=i.showHorizontalScrollbar,a=i.tabStripVisible,u=i.tabStripPosition,i=i.scrollbarAppearance===M.ScrollbarAppearance.mobile,s=t.NC(),t=t.Zv(),f=u===M.TabStripPosition.top?(c=r&&!i?s:0,a?t:0):c=0;(0,y.GC$)(n).css("width",c+d),(0,y.GC$)(n).css("height",f+d),c=r&&!i?s:0,(o||a&&u===M.TabStripPosition.bottom)&&(l=t,!i||a&&u===M.TabStripPosition.bottom)||(l=0),(0,y.GC$)(e).css("width",c+d),(0,y.GC$)(e).css("height",l+d)},k.prototype.PC=function(){var t,n,e,i,e,t,t=this;t.Kg&&(n=t.nM,i=(e=t.options).scrollbarAppearance===M.ScrollbarAppearance.mobile,e=e.showVerticalScrollbar,t=[(0,y.GC$)(t.Kg).width(),t.NC()],!i&&e||(t[1]=0),n.rows[0].cells[0].style.width=t[0]+d,n.rows[0].cells[1].style.width=t[1]+d)},k.prototype.UC=function(){var t,n,e,t=this,n,e=t.options.scrollbarAppearance===M.ScrollbarAppearance.mobile;e&&t.kC(),t.WC(),t.QC(),e&&(t.Xb.qy(M.ScrollbarState.hide),t.zb.qy(M.ScrollbarState.hide))},k.prototype.HC=function(){var t,n,e,t=this,n,e;t.options.tabStripVisible?(0,y.GC$)(t.XM).show():(0,y.GC$)(t.XM).hide(),t.w2&&t.w2.Cg()},k.prototype.GC=function(t){var n,e,t;void 0===t&&(t=!0),(e=(0,D.jf)(n=this))?(0===e.Tb&&(e.Tb=e.pw()),0===e.Ab&&(e.Ab=e.Sw()),t&&e.Cg()):(t=n.getActiveSheetTab())&&t.Cg()},k.prototype.zC=function(){var t,n,e,t=this,n=(0,D.jf)(t);n&&(n.invalidateLayout(),n.repaint()),(e=t.KC())&&!t.JC&&(t.JC=!0,setTimeout(function(){delete t.JC,t.DC()},1))},k.prototype.KC=function(){var t,n,e,i,n,e,r,o,a,u,o,a,u,u,o,a,n,s,c,t=this,n=(0,y.GC$)(t.Ti),e=n.width(),i=2,n=n.width(),e=e!==n&&2<L(e-n),r=!1,o=t.zM,a=t.VM,u=t.nM;return o&&a&&u&&(o=(0,y.GC$)(o).width(),a=(0,y.GC$)(a).width(),u=(0,y.GC$)(u).width(),r=2<L(o+u+a-n)),o=t.Xw,a=(u=!1,D.jf)(t),o&&a&&(n=a.getDockScrollbarAttachedIndex(),j(n)||(s=o.YC())!==(c=a.getHDockScrollbarWidth())&&(u=!0)),e||r||u},k.prototype.kC=function(){var t,n,e,i,r,o,a,n,u,s,c,f,l,s,c,e,h,o,f,n,c,o,d,v,m,a,l,s,h,g,p,b,t=this;!j(t.Ti)&&(n=(0,y.GC$)(t.Ti),e=(0,D.jf)(t))&&(i=(0,y.GC$)(t.kw),r=(0,y.GC$)(t.Dw),o=e.Fi(),a=n.width(),n=n.height(),u=2,c=(s=t.options).tabStripVisible,f=s.showVerticalScrollbar,l=s.tabStripPosition,s=c?s.tabStripWidth:0,c=c?t.Zv():0,e=e.getHDockScrollbarWidth(),h=o.x+o.XC,o=o.y+o.qC,f=f?i.width():0,n=n-o,l!==M.TabStripPosition.bottom&&l!==M.TabStripPosition.top||(n-=c),c=0,l!==M.TabStripPosition.right&&l!==M.TabStripPosition.left||(c+=s),o=o,m=n-(d=C(i.css("padding-top")))-(v=C(i.css("padding-bottom"))),a=a-h,0===e&&(a-=f),l!==M.TabStripPosition.left&&l!==M.TabStripPosition.right||(a-=s),l=r.height(),s=-(n+o),h=h,b=a-(g=C(r.css("padding-left")))-(p=C(r.css("padding-right")))-e,0===e?b-=2:e-=f+p+2,t.Xb.YC(f),t.Xb.ZC(m),t.zb.YC(b),t.zb.ZC(l),t.Xw.YC(e),t.Xw.ZC(l),i.css(["height","left","right","top"],[n,"auto",c,o]),r.css(["width","top","bottom","left"],[a,"auto",s,h]))},k.prototype.WC=function(){var t=this,n=t.jg(),e=t.options;n?(n.WC(e.scrollbarMaxAlign,e.scrollbarShowMax,t.zb),n.$C(t.Xw)):t.zb&&t.zb.w4()},k.prototype.QC=function(){var t=this,n=t.jg(),e=t.options;n&&n.QC(e.scrollbarMaxAlign,e.scrollbarShowMax,t.Xb)},k.prototype.Xg=function(){var t,n,e,t=this,n;t.Ti&&(e=t.t3(),t.BC(),t.RC(e),t.GC(!1),t.UC(),t.HC())},k.prototype.t3=function(){var t,n,e,i,t=this.Ti,n=t.parentNode;return e=n&&"flex"===(i=n.style.display||getComputedStyle(n).display)?(0,y.GC$)(t).width():e},k.prototype.suspendPaint=function(){var t,n,e,i,r,o,a,u,s,c,t=this,n=t.w2,e=t.sheets,i=t.mp;for(t.sg++,r=0,o=e;r<o.length;r++)(a=o[r]).suspendPaint();for(u=0,s=i;u<s.length;u++)(c=s[u]).suspendPaint();n&&n.V2()},k.prototype.resumePaint=function(){var t,n,e,i,r,o,a,u,s,c,t=this,n=t.w2,e=t.sheets,i=t.mp;for(t.sg-=0<t.sg?1:0,r=0,o=e;r<o.length;r++)(a=o[r]).resumePaint();for(u=0,s=i;u<s.length;u++)(c=s[u]).resumePaint();n&&n.Y2()},k.prototype.wb=function(){var t,n,e,i,t=this,n=t.getActiveSheet();try{n&&(e=n.My,n.My=0,n.n3(),n.repaint(),n.My=e),t.w2&&(i=t.w2.sg,t.w2.sg=0,t.w2.repaint(),t.w2.sg=i)}catch(t){}},k.prototype.isPaintSuspended=function(){return 0<this.sg},k.prototype.nb=function(){var t,n,e,i,r,o,a,u,s,c,t=this,n=t.options.backgroundImage,e=t.options.backgroundImageLayout,i=(0,D.jf)(t);if(i&&n&&((r=(o=void 0,y.GC$)(i.Dg())).css({"background-image":"url('"+n+"')","background-repeat":"no-repeat"}),!j(e))){o=(o=t.MC)||(t.MC=new F.Wh(function(){t.MC&&t.nb()}));try{o.jt(n)?(a=o.Ot(n),s=(u=i.ot()).width,c=u.height,D.mt.Wf(i.Dg(),s,c,a.width,a.height,e)):o.Rt(n)}catch(t){}}},k.prototype.e3=function(t){var n,t,t,n=this,t=t.name(),t=n.getSheetPosition(t);n.w2.g2(t)},k.prototype.startSheetIndex=function(t){var n=this,e=n.w2;return 0===arguments.length?e?e.om:0:(e&&(e.k2(t)||-1===(t=e.N2(t))&&(t=e.Vm(t)),e.om=t),n.Xg(),n)},k.prototype.Jg=function(){var t,n,e,i,e,i,n,t,n,t=this,n=t.options,e=t.options.scrollbarAppearance===M.ScrollbarAppearance.mobile,i=n.tabStripPosition;return n.showHorizontalScrollbar&&!e&&i===M.TabStripPosition.bottom?(e=n.tabStripRatio,isNaN(e)?.5:(i=0,n=t.Kg,t=t.w2,n&&t&&(n=(0,y.GC$)(n).width(),i=t.rm()/n),e<i?e=i:1<e&&(e=1),e)):1},k.prototype.destroy=function(){this.dC&&(0,y.GC$)(E).unbind(ct+m,this.dC),this.L0()},k.prototype.repaint=function(){var t,n,n,t=this,n=t.w2;n&&n.repaint(),(n=(0,D.jf)(t))&&n.repaint()},k.prototype.refresh=function(){var t=this;t.Ti&&(D.I.dl(),t.r3(),t.iM(),t.Cg(),t.repaint())},k.prototype.getHost=function(){return this.Ti},k.prototype.invalidateLayout=function(){var t=(0,D.jf)(this);t&&t.invalidateLayout()},k.prototype.addNamedStyle=function(t){this.$p(t);var t=(0,D.jf)(this);t&&t.zw()},k.prototype.$p=function(t){if(t){if(!t.name)throw new Error(N().Exp_EmptyNamedStyle);var n=t.name.toUpperCase();this.Hp[n]=t,this.r3()}},k.prototype.getNamedStyle=function(t){return this.i3(t,!0)},k.prototype.i3=function(t,n){var e,e,e=this.Hp;return e&&t?((e=e[t=t.toUpperCase()])&&n&&this.r3(),e):O},k.prototype.r3=function(){for(var t,n,e,i,t,n=0,e=this.sheets;n<e.length;n++)(i=e[n]).r3()},k.prototype.removeNamedStyle=function(t){var n,e,e,n=this.Hp;n&&t&&(t=t.toUpperCase(),n.hasOwnProperty(t))&&((e=n[t].formatter)&&"string"==typeof e&&this.bp[e]&&this.o3(e),delete n[t],this.r3(),e=(0,D.jf)(this))&&e.zw()},k.prototype.getNamedStyles=function(){var e=[],t=this.Hp;return t&&K(t,function(t,n){e.push(n)}),e},k.prototype.getActiveSheet=function(){return this.sheets&&0<this.sheets.length?this.sheets[this._2]:O},k.prototype.getActiveSheetTab=function(){return this.mp&&0<this.mp.length?this.mp[this.jb]:O},k.prototype.setActiveSheet=function(t){var n,e,n=this.getActiveSheet(),e=this.getActiveSheetTab();this.vb(t,2),this.a3(n),this.u3(e)},k.prototype.setActiveSheetTab=function(t){var n,e,n=this.getActiveSheet(),e=this.getActiveSheetTab();"number"==typeof t?this.yp(t,2):"string"==typeof t&&this.s3(t,2),this.a3(n),this.u3(e)},k.prototype.vb=function(t,n,e,i){for(var r,o,r=this.sheets,o=0;o<r.length;o++)if(r[o].name()===t){this.tb(o,n,e,i);break}},k.prototype.s3=function(t,n,e,i){for(var r,o,r=this.mp,o=0;o<r.length;o++)if(r[o].name()===t){this.yp(o,n,e,i);break}},k.prototype.getActiveSheetIndex=function(){return this._2},k.prototype.getActiveSheetTabIndex=function(){return this.jb},k.prototype.setActiveSheetIndex=function(t){var n,e,e,i,n=this,e=n.getSheetCount();(t=e<=t?e-1:t)<0&&(t=0),e=n.getActiveSheet(),i=n.getActiveSheetTab(),n.tb(t,2),n.a3(e),n.u3(i)},k.prototype.tb=function(t,n,e,i,r){var o,a,r,u,u,s,c,c,f,c;typeof t==rt&&t!==(o=this)._2&&((a=o.sheets[t])&&a.visible()===M.SheetTabVisible.visible||r)&&!(((r=D.mt.pi()).ipad||r.iphone)&&(u=o.c3)&&(new Date).valueOf()-u<300)&&(s=(s=u=o.getActiveSheet())||(c=o.getActiveSheetTab())&&c.Mf,Gt(o,c={oldSheet:s,newSheet:a,needTriggerSheetChange:!0}),f={oldSheet:s,newSheet:a,cancel:!1},(c=c.needTriggerSheetChange&&i)&&Pt(o,f),!1===f.cancel&&(o._2=t,o.f3(),a!==u&&(u&&(u.L0(!1),u.charts)&&u.charts.all().forEach(function(t){t.clearflexDVs()}),a)&&o.l3(a,n,!1,c,e),o.Cg(),Ut(o,s,a),c)&&Ft(o,s,a),r.ipad||r.iphone)&&(o.c3=(new Date).valueOf())},k.prototype.yp=function(t,n,e,i){var r,o,a,u,s,s,c,f,l,f;typeof t==rt&&t!==(r=this).jb&&(o=r.mp[t])&&o.visible()===M.SheetTabVisible.visible&&(a=o.Mf,((u=D.mt.pi()).ipad||u.iphone)&&(s=r.c3)&&(new Date).valueOf()-s<300||(c=(s=r.getActiveSheetTab())?s.Mf:r.getActiveSheet(),Gt(r,f={oldSheet:c,newSheet:a,needTriggerSheetChange:!0}),l={oldSheet:c,newSheet:a,cancel:!1},(f=f.needTriggerSheetChange&&i)&&Pt(r,l),!1===l.cancel&&(r.jb=t,r.h3(),o!==s&&(s&&s.L0(!1),r.d3(o,n,!1,f,e)),r.Cg(),Ut(r,c,a),f)&&Ft(r,c,a),(u.ipad||u.iphone)&&(r.c3=(new Date).valueOf())))},k.prototype.l3=function(t,n,e,i,r){var e,e,e;e||t.hg(this.Kg),e=(e=D.hi.ai())&&e.parent===this,e=2===n?e:1===n,D.hi.F1(O),!this.Bp&&e&&t.Zg(r),t.aw(),t.tw()},k.prototype.d3=function(t,n,e,i,r){var e,e,e;e||t.hg(this.Kg),e=(e=D.hi.ai())&&e.parent===this,e=2===n?e:1===n,D.hi.F1(O),!this.Bp&&e&&t.Zg(r),t.aw(),t.tw()},k.prototype.a3=function(t){var n=this.getActiveSheet();t&&t.b2(!1,!1),n&&n.b2(!0,!1)},k.prototype.u3=function(t){var n=this.getActiveSheetTab();t&&t.b2(!1,!1),n&&n.b2(!0,!1)},k.prototype.addSheet=function(t,n){var e,i,e=this.getActiveSheet(),i=this.getActiveSheetTab();this.A2(t,2,n),this.a3(e),this.u3(i)},k.prototype.addSheetTab=function(t,n,e){var i,r,n,i=this.getActiveSheet(),r=this.getActiveSheetTab(),n=this.bb(n,e);if(n)return this.suspendPaint(),this.yb(t,2,n),this.a3(i),this.u3(r),this.resumePaint(),n},k.prototype.gse=function(t,n,e){for(var i,r,o,i=t.length,r=[],o=0;o<e&&0<i;o++)r.push(t.pop());for(t.push(n);0<r.length;)t.push(r.pop())},k.prototype.pse=function(t,n,e){for(var i,r,o,a,u,s,i=t.length,r=[],o=0,a=n instanceof v.Worksheet;o<e&&0<i;)u=t[t.length-1]instanceof v.Worksheet,(a&&u||!a&&!u)&&o++,r.push(t.pop());for(t.push(n),n.E0i=t.length-1;0<r.length;)s=r.pop(),t.push(s),s.E0i=t.length-1},k.prototype.bse=function(t,n){for(var e,i,r,e=0;e<t.length;e++)if(t[e].name()===n){for(i=e;i<t.length-1;i++)(r=t[i+1]).E0i--,t[i]=r;t.length=t.length-1;break}},k.prototype.A2=function(t,n,e){var i,r,o,a,u,s,c,t,i=this;if(e=e||i.S2(i.T2(t)),a=(o=i.sheets).length,e.name()){for(u=i.qv(),r=0;r<u.length;r++)if(u[r].name()===e.name())throw N().Exp_NotSupported}else e.ub(i.T2(t));i.v3(e),s=i.getActiveSheet(),c=i._2,i.gse(o,e,a-t),e.pM(i),i.pse(i.dse,e,a-t),i.f3(),1===(a=o.length)?(i.Kg&&e.hg(i.Kg),i._2=0):(c<0&&i.w2&&(c=i.w2.N2(c)),i._2=c),(t=i.getActiveSheet())!==s&&(s&&s.L0(!1),t&&i.l3(t,n,1===a,!0),i.Cg()),i.w2&&(i.w2.om<0&&(i.w2.om=i._2),i.w2.repaint())},k.prototype.yb=function(t,n,e){var i,r,o,a,u,s,c,t;if(e){for(a=(o=(i=this).mp).length,u=i.qv(),r=0;r<u.length;r++)if(u[r].name()===e.name())throw N().Exp_NotSupported;i.v3(e),s=i.getActiveSheetTab(),c=i.jb,i.gse(o,e,a-t),e.pM(i),i.pse(i.dse,e,a-t),1===(a=o.length)?(i.Kg&&e.hg(i.Kg),i.jb=0):(c<0&&i.w2&&(c=i.w2.N2(c)),i.jb=c),i.h3(),(t=i.getActiveSheetTab())!==s&&(s&&s.L0(!1),t&&i.d3(t,n,1===a,!0),i.Cg()),i.w2&&(i.w2.om<0&&(i.w2.om=i.jb),i.w2.repaint())}},k.prototype.removeSheet=function(t){this.m3(t,2)},k.prototype.removeSheetTab=function(t){"string"==typeof t&&(t=this.getSheetTabIndex(t)),this.g3(t,2)},k.prototype.m3=function(t,n){var e,i,r,o,a,u,s,c,f,l,s,u,h,d,v,m,g,p,b,n,c,s,t,e=this,i=e.sheets,r=e.Lp,o=e.w2,a=i.length;if(isNaN(t)||t<0||a<=t)throw new Error(N().Exp_IndexOutOfRange);if(u=e._2,s=t<=e._2||t===a-1,c=e.getActiveSheet(),t<e._2&&e._2--,(f=i[t]).bC(),i.splice(t,1),e.bse(e.dse,f.name()),0===(a=i.length))e._2=-1;else if(e._2>=a&&o)e._2=o.Vm(a);else{for(l=void 0,l=Math.max(0,e._2);l<a;l++)if(i[l].visible()===M.SheetTabVisible.visible){e._2=l;break}a<=l&&o&&(e._2=o.Vm(a))}if(e.f3(),(s||u!==e._2)&&c!==(s=i[e._2])&&(c&&c.L0(!1),s)&&(Gt(e,c),e.l3(s,n,!1,!0),Ut(e,c,s)),r){if(r.suspend(),f.b3().p3(),h=(u=tn(f)).map(function(t){return t.id}),d={},v=r.y3)for(g in m=f.b3().getSource().id,v)if(v.hasOwnProperty(g))for(d[g]=[],p=v[g];p;)m!==(b=p.w3&&p.w3.getSource().id)&&-1===h.indexOf(b)&&d[g].push(p),p=p.C3;for(g in(n=f.Uw()).S3=t,r.removeSource(n),c=f.T3,r.removeSource(c),s=f.A3,r.removeSource(s),u.forEach(function(t){r.removeSource(t)}),d)if(d.hasOwnProperty(g))for(p=d[g],l=0;l<p.length;l++)r.I3(p[l],parseInt(g,10));r.resume(!1)}f.L0(!0,-1!==e._2),w&&!r.x3&&e.sheets&&0<e.sheets.length&&(t=e.sheets[0],r.initParserContext(t.Uw())),o&&(o.om>=a?e.startSheetIndex(o.Vm(a)):o.om<0?e.startSheetIndex(o.N2(-1)):e.Cg())},k.prototype.g3=function(t,n){var e,i,r,o,a,u,s,c,f,l,s,u,s,n,c,t,e=this,i=e.mp,r=e.Lp,o=e.w2,a=i.length;if(isNaN(t)||t<0||a<=t)throw new Error(N().Exp_IndexOutOfRange);if(u=e.jb,s=t<=e.jb||t===a-1,c=e.getActiveSheetTab(),t<e.jb&&e.jb--,(f=i[t]).bC(),i.splice(t,1),e.bse(e.dse,f.name()),0===(a=i.length))e.jb=-1;else if(e.jb>=a)e.jb=o.Vm(a);else{for(l=void 0,l=Math.max(0,e.jb);l<a;l++)if(i[l].visible()===M.SheetTabVisible.visible){e.jb=l;break}a<=l&&(e.jb=o.Vm(a))}e.h3(),!s&&u===e.jb||c===(s=i[e.jb])||(c&&c.L0(!1),s&&e.d3(s,n,!1,!0),e.u3(c)),r&&(r.suspend(),(s=(u=f.Mf).Uw()).S3=t,r.removeSource(s),n=u.T3,r.removeSource(n),c=u.A3,r.removeSource(c),t=u.Dnn,j(t)||r.removeSource(t),r.resume(!1)),f.L0(!0,-1!==e.jb),o&&(o.om>=a?e.startSheetIndex(o.Vm(a)):o.om<0?e.startSheetIndex(o.N2(-1)):e.Cg())},k.prototype.clearSheets=function(){for(var t,n,e,i,r,o,a,t=this,n=t.sheets,e=t.Lp,i=t.w2,r=0,o=n;r<o.length;r++)(a=o[r]).bC(),a.L0(!0);n.splice(0,n.length),t.dse=t.yse(t.mp),e&&e.clearSource(),t._2=-1,i&&(i.om=-1,i.repaint())},k.prototype.clearSheetTabs=function(){for(var t,n,e,i,r,o,t=this,n=t.mp,e=t.w2,i=0,r=n;i<r.length;i++)(o=r[i]).bC(),o.L0(!0);n.splice(0,n.length),t.dse=t.yse(t.sheets),t.jb=-1,e&&(e.om=-1,e.repaint())},k.prototype.getSheet=function(t){var n=this.sheets;return 0<=t&&t<n.length?n[t]:O},k.prototype.getSheetTab=function(t){return this.Ofe(t)},k.prototype.Ofe=function(t){var n,e,i,r,n=this.mp;if("number"==typeof t)return 0<=t&&t<n.length?n[t]:O;if("string"==typeof t)for(e=0,i=n;e<i.length;e++)if((r=i[e]).name()===t)return r;return O},k.prototype.getSheetFromName=function(t){return this._f(t)},k.prototype._f=function(t){for(var n,e,i,r,n,e=0,i=this.sheets;e<i.length;e++)if((r=i[e]).name()===t)return r;return O},k.prototype.getSheetIndex=function(t){for(var n,e,n=this.sheets,e=0;e<n.length;e++)if(n[e].name()===t)return e;return O},k.prototype.getSheetTabIndex=function(t){for(var n,e,n=this.mp,e=0;e<n.length;e++)if(n[e].name()===t)return e;return O},k.prototype.getSheetPosition=function(t){for(var n,e,n=this.dse,e=0;e<n.length;e++)if(n[e].name()===t)return e;return-1},k.prototype.getSheetCount=function(){return this.sheets.length},k.prototype.getSheetTabCount=function(){return this.mp.length},k.prototype.setSheetCount=function(t){var n,e,i,n=this,e=n.getActiveSheet(),i=n.getActiveSheetTab();n.Xp(t,2),n.a3(e),n.u3(i)},k.prototype.Xp=function(t,n){var e,i,r,e=this;if(t<0)throw N().Exp_ArgumentOutOfRange;if(0===t&&e.clearSheets(),t<(i=e.sheets.length))for(r=i-1;t<=r;r--)e.m3(r,n);else if(i<t)for(r=i;r<t;r++)e.A2(r,n)},k.prototype.hp=function(t,n){var e,i,r,o,t,a,u,s,c,f,l,h,d,v,m,g,e=this,i=t.sheetTabCount;if(tt(i)){if(i<0)throw N().Exp_ArgumentOutOfRange;if(0===i)e.clearSheetTabs();else{for(r=t.sheetTabs,o=t.sheetCount,t=e.mp.length,a=[],u=0,s=Object.keys(r);u<s.length;u++)(f=r[c=s[u]])&&(l=f.index-o,a.splice(l,0,f));if(i<t)for(h=t-1;i<=h;h--)e.g3(h,n);for(h=0;h<a.length;h++)d=e.mp[h],v="number"==typeof(f=a[h]).sheetType?f.sheetType:M.SheetType.tableSheet,m=o+h,d?(g=d._gi)!==v&&(e.g3(m,n),d=e.bb(O,v),e.yb(m,n,d)):(d=e.bb(O,v),e.yb(m,n,d))}}},k.prototype.bb=function(t,n){var e={name:t,type:n,sheetTab:O};return k.et(this,"createSheetTab",e,function(){return e.sheetTab!==O}),e.sheetTab},k.prototype.dataManager=function(){var t=this,n=t.N3;return n=!n&&Z.DataManager?t.N3=new Z.DataManager(t.Lp):n},k.prototype.bind=function(t,n,e){var i,r,o,a,u,s,c,f,l,i=this,r=i.sheets;for(i.rM&&i.rM.push({type:t,data:n,fn:e}),(0,y.GC$)(i.oM).bind(t+m,n,e),o=0,a=r;o<a.length;o++)(u=a[o]).bind(t,n,e);for(c=0,f=s=i.mp;c<f.length;c++)(l=f[c]).bind(t,n,e)},k.prototype.unbind=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,e=this,i=e.sheets,r=e.rM;if(r)for(o=r.length-1;0<=o;o--)(a=r[o]).type!==t&&!e.k3(a.type,t)||r.splice(o,1);for((0,y.GC$)(e.oM).unbind(t+m,n),u=0,s=i;u<s.length;u++)(c=s[u]).unbind(t,n);for(l=0,h=f=e.mp;l<h.length;l++)(d=h[l]).unbind(t,n)},k.prototype.k3=function(t,n){return 0===n.indexOf(".")&&t.substring(t.length-n.length)===n},k.prototype.unbindAll=function(){var t,n,e,i,r,o,a,u,s,t=this,n=t.sheets;for((t.rM.length=0,y.GC$)(t.oM).unbind(m),e=0,i=n;e<i.length;e++)(r=i[e]).unbindAll();for(a=0,u=o=t.mp;a<u.length;a++)(s=u[a]).unbindAll()},k.prototype.D3=function(t,n,e){var i,r,o,a,u,s,c,f,l,i=this,r=i.sheets;for(i.rM.push({type:t,data:n,fn:e}),(0,y.GC$)(i.oM).bind(t+lt,n,e),o=0,a=r;o<a.length;o++)(u=a[o]).D3(t,n,e);for(c=0,f=s=i.mp;c<f.length;c++)(l=f[c]).D3(t,n,e)},k.prototype._3=function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,d,e=this,i=e.sheets,r=e.rM,o=0;o<r.length;o++)(a=r[o]).type!==t&&!e.k3(a.type,t)||r.splice(o,1);for((0,y.GC$)(e.oM).unbind(t+lt,n),u=0,s=i;u<s.length;u++)(c=s[u])._3(t,n);for(l=0,h=f=e.mp;l<h.length;l++)(d=h[l])._3(t,n)},k.prototype.E3=function(){var t,n,e,i,r,o,a,u,s,t=this,n=t.sheets;for((t.rM.length=0,y.GC$)(t.oM).unbind(lt),e=0,i=n;e<i.length;e++)(r=i[e]).E3();for(a=0,u=o=t.mp;a<u.length;a++)(s=u[a]).E3()},k.prototype.ki=function(t,n){0===this.vf&&(0,y.GC$)(this.oM).trigger(t,n)},k.prototype.pb=function(t,n){(0,y.GC$)(this.oM).trigger(t,n)},k.prototype.j3=function(t,n,e,i){this.ki(D.Events.ButtonClicked,{sheet:t,sheetName:t.name(),row:n,col:e,sheetArea:i})},k.prototype.v3=function(t){for(var n,e,i,r,n,e=0,i=this.rM;e<i.length;e++)r=i[e],t.bind(r.type,r.data,r.fn)},k.prototype.suspendEvent=function(){var t,n,e,i,r,o,a,u,s,t=this,n=t.sheets;for(t.vf++,e=0,i=n;e<i.length;e++)(r=i[e]).suspendEvent();for(a=0,u=o=t.mp;a<u.length;a++)(s=u[a]).suspendEvent()},k.prototype.resumeEvent=function(){var t,n,e,i,r,o,a,u,s,t=this,n=t.sheets;for(t.vf--,t.vf<0&&(t.vf=0),e=0,i=n;e<i.length;e++)(r=i[e]).resumeEvent();for(a=0,u=o=t.mp;a<u.length;a++)(s=u[a]).resumeEvent()},k.prototype.focus=function(t){var t,t;!1===t?D.hi.F1(O):(t=this.getActiveSheet())?t.Zg():(t=this.getActiveSheetTab())&&t.Zg()},k.prototype.Xm=function(){return 2007<this.SC?15:18},k.prototype.NC=function(){return 2007<this.SC?22:this.Xm()},k.prototype.ZM=function(t){var n,e,i,r,o,a,n=this,e=t?n.kw:n.Dw,i=t?n.Xb:n.zb,r=n.options.scrollbarAppearance===M.ScrollbarAppearance.mobile;if(e&&i&&r)switch(o=n.ib,a=i.O3){case M.ScrollbarState.hide:o.$y(t);break;case M.ScrollbarState.show:o.Iw(e),o._w(t);break;case M.ScrollbarState.active:o.Iw(e),o._w(t),o.xw(e);break;case M.ScrollbarState.inactive:o.Nw(e),o.$y(t)}},k.prototype.Zv=function(){return 2007<this.SC?28:this.Xm()},k.prototype.Tw=function(t,n,e,i,r){var o,a,u,s,o="auto",a=this;a.R3||(u=(0,y.getHostMaxZIndex)(a.Ti)+1,s=c(l),r?(0,y.GC$)(s).addClass("gc-spread-pivot-toolTip"):(0,y.GC$)(s).addClass("gc-spread-toolTip"),(0,y.GC$)(s).addClass("ui-state-default ui-widget-content btn-default").css({position:pt,padding:"0px 3px 0px 3px",font:$("normal normal normal 11pt calibri"),"box-shadow":"1px 2px 5px rgba(0,0,0,0.4)","white-space":"pre-wrap","z-index":u}).width(o).height(o).appendTo(f.body),a.R3=s),a.ny(t,n,e,i)},k.prototype.ny=function(t,n,e,i){var r,o,r,r,t,i,o,i,r=this,o=r.jg();o&&(r=r.R3)&&(r=(0,y.GC$)(r),t?(r.html(t),r.show()):r.hide(),t=o.uw(),i&&(e-=t.top,n-=t.left),o=(i=o.ot()).x+i.width-r.outerWidth(),i=i.y+i.height-r.outerHeight(),o<0?n=0:i<0?e=0:(e=R(e,i),n=R(n,o)),j(e)||r.css("top",e+t.top),j(n)||r.css("left",n+t.left))},k.prototype.iy=function(){var t=this,n=t.R3;n&&((0,y.GC$)(n).remove(),t.R3=O)},k.prototype.FM=function(){var t,n,e,i,r,t=this,n=t.qv();for(D.Be.zl(),t.invalidateLayout(),e=0,i=n.length;e<i;e++)(r=n[e]).FM();N(),o.Common.B3(),Y&&z.sR(),t.repaint(),k.et(t,"onCultureChanged")},k.prototype.getTab=function(){return this.w2},k.prototype.changeSheetIndex=function(t,n){var e,i,r,o,o,t,e=this,i=e.getSheetPosition(t),r=e.getTab(),o=e.getSheetCount()+e.getSheetTabCount();return!("number"!=typeof n||-1===i||i===n||n<0||o<=n||n%1!=0||e.L3(t)||((o=e.jg().name())!==t?(e.suspendPaint(),e.setActiveSheetOrSheetTabIndex(i,2),e.o2(i,n),t=e.getSheetPosition(o),e.setActiveSheetOrSheetTabIndex(t,2),e.resumePaint()):(e.o2(i,n),r.G2(i,n)),0))},k.prototype.changeSheetPosition=function(t,n){var e,i,r,o,o,t,e=this,i=e.getSheetPosition(t),r=e.getTab(),o=e.getSheetCount()+e.getSheetTabCount();return!("number"!=typeof n||-1===i||i===n||n<0||o<=n||n%1!=0||e.L3(t)||((o=e.jg().name())!==t?(e.suspendPaint(),e.setActiveSheetOrSheetTabIndex(i,2),e._se(i,n),t=e.getSheetPosition(o),e.setActiveSheetOrSheetTabIndex(t,2),e.resumePaint()):(e._se(i,n),r.G2(i,n)),0))},k.prototype.L3=function(t){for(var n,e,i,r,o,a,u,s,c,n=this,e,i=0,r=n.sheets;i<r.length;i++)if((o=r[i]).name()===t)return!1;for(u=0,s=a=n.mp;u<s.length;u++)if((c=s[u]).name()===t)return!1;return!0},k.prototype.o2=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,e=this,i=-1,r=e.qv(),a=r[t],u=e.sheets.length;if($t(e)){if(n<t)if(u<=t&&n<u)r.splice(t,1),r.splice(u,0,a),i=u;else{for(o=t;n<o;o--)r[o]=r[o-1];r[n]=a,i=n}else if(t<n)if(t<u&&u<=n)r.splice(u,0,a),r.splice(t,1),i=u-1;else{for(o=t;o<n;o++)r[o]=r[o+1];r[n]=a,i=n}}else if(s=e.getSheetTabCount(),l=void(f=c=0),h=j(a._gi),0<=t&&t<u&&0<=n&&n<u||u<=t&&t<u+s&&u<=n&&n<u+s){for(o=0;o<r.length;o++)if(d=r[o],j(d._gi)?c++:f++,h&&c-1===n||!h&&f-1===n){l=o;break}if(l<t){for(o=t;l<o;o--)r[o]=r[o-1];r[l]=a,i=l}else if(t<l){for(o=t;o<l;o++)r[o]=r[o+1];r[l]=a,i=l}}e.P3(r),e.setActiveSheetOrSheetTabIndex(i,2)},k.prototype._se=function(t,n){var e,i,r,o,a,e=this,i=-1,r=e.qv(),a=r[t];if(n<t){for(o=t;n<o;o--)r[o]=r[o-1];r[n]=a,i=n}else if(t<n){for(o=t;o<n;o++)r[o]=r[o+1];r[n]=a,i=n}e.P3(r),e.setActiveSheetOrSheetTabIndex(i,2)},k.prototype.F3=function(t,n){t?this.setActiveSheetTab(n):this.setActiveSheet(n)},k.prototype.setActiveSheetOrSheetTab=function(t){var n=this.getSheetIndex(t),e=!1;j(n)&&(n=this.getSheetTabIndex(t),e=!0),j(n)||this.F3(e,t)},k.prototype.isFocus=function(){var t=D.hi.ai();return t&&t.getParent&&t.getParent()===this},k.prototype.clone=function(t,n,e,i){var r,t,o,a,u,s,c,f,l,h,d,r=this,t=r.Gm(t);if(j(i)&&(i=!0),!(j(t)||j(e)||r.Gm(e))&&(o=t instanceof v.Worksheet,r.suspendPaint(),r.suspendCalcService(),t.canClone)){if(a=JSON.stringify(t.toJSON({newWorkSheetName:e})),n<0&&(n=0),o?((u=r.S2(e)).Uw().G3=!0,r.addSheet(n,u)):((u=r.bb(e,t._gi)).Mf&&(u.Mf.Uw().G3=!0),r.yb(n,2,u)),r.getSheetPosition(e)!==n&&r.changeSheetPosition(e,n),u.fromJSON(JSON.parse(a)),r.setActiveSheetOrSheetTab(u.name()),o){for(c=t.tables.U3,f=u.tables.U3,l=void 0,h=0;h<c.length;h++)c[h].H3&&i&&(s=c[h].z3(),f[h].V3(s)),l=f[h].range(),u.Q1i&&u.Q1i(l.row,l.col,l.rowCount,l.colCount,M.SheetArea.viewport);(s=t.H3._dataSource)&&i&&(d=u.H3).bind(s)}else(s=t.Mf&&t.Mf.H3._dataSource)&&i&&(d=u.Mf.H3).bind(s);return r.resumeCalcService(!1),r.resumePaint(),u}},k.prototype.fM=function(t){var n,e,t,n,i,t,n=this,e=t.command;0!==t.vM&&e.hM||(t=e.sheetName?(0,D._f)(n,e.sheetName):(0,D.jf)(n))&&(n=t.getActiveRowIndex(),i=t.getActiveColumnIndex(),t=t.getSelections(),e.Z3={W3:t,K3:{row:n,col:i}})},k.prototype.mM=function(t){var n,t,e,i,r,t,o,a,e,u,s,c,f,l,h,n=this,t=t.command,e=t.Z3,i=(0,D.jf)(n),r;if((i&&i.name())!==t.sheetName&&((0,D.Ef)(n,t.sheetName),i=(0,D.jf)(n)),!j(e)&&i){if(i.suspendPaint(),t=e.K3,o=e.W3,a=e.J3,e=e.X3,j(t)||i.t4(t.row,t.col),!j(o))if(1===(u=o.length))i.setSelection(o[0].row,o[0].col,o[0].rowCount,o[0].colCount);else for(s=0;s<u;s++)c=o[s].row,f=o[s].col,l=o[s].rowCount,h=o[s].colCount,i.n4(c,f,l,h);if(k.et(n,"onCommandExecuting",i),!j(a)){for(s=0;s<a.length;s++)a[s].isSelected&&a[s].isSelected(!0);e||i.e4()}i.showCell(t.row,t.col,3,3),i.resumePaint()}},k.prototype.changeSelectionInCommandExecuting=function(t,n,e,i,r){var t,o;t&&t.Z3&&(o=(t=t.Z3).K3,j(o)||(j(n)||(o.row=n),j(e))||(o.col=e),j(i)||(t.W3=i),j(r)||(t.J3=r))},k.prototype.h3=function(){var t=this.getActiveSheet();t&&(t.L0(!1),t.b2(!1,!1)),this._2=-1},k.prototype.f3=function(){var t=this.getActiveSheetTab();t&&(t.L0(!1),t.b2(!1,!1)),this.jb=-1},k.prototype.yse=function(t){for(var n,e,i,n=[],e=0;e<t.length;e++)n[(i=t[e]).E0i=e]=i;return n},k.prototype.vse=function(t,n){for(var e,i,e=[],i=0;i<t.length;i++)e.push(t[i]);for(i=0;i<n.length;i++)e.push(n[i]);for(e.sort(function(t,n){return t.E0i-n.E0i}),i=0;i<e.length;i++)e[i].E0i=i;return e},k.prototype.qv=function(){var t=this;return t.sheets.length+t.mp.length!==t.dse.length&&(t.dse=[].concat(t.sheets).concat(t.mp)),t.dse},k.prototype.P3=function(t){var n,e,i,r,o,a,u,s,c,n=this,r=n.getActiveSheet(),o=n.getActiveSheetTab();for(r?e=r.name():o&&(i=o.name()),n.sheets.length=0,n.mp.length=0,a=n.sheets,u=n.mp,s=0;s<t.length;s++)(c=t[s]).E0i=s,(c instanceof v.Worksheet?a:u).push(c);e?n._2=n.getSheetIndex(e):i&&(n.jb=n.getSheetTabIndex(i)),n.dse=t},k.prototype.Gm=function(t){return this._f(t)||this.Ofe(t)},k.prototype.e2=function(t){return this.qv()[t]},k.prototype.getActiveSheetOrSheetTab=function(){return this.jg()},k.prototype.jg=function(){return this.getActiveSheet()||this.getActiveSheetTab()},k.prototype.I2=function(t,n,e,i){var t=this.e2(t);t&&(t instanceof v.Worksheet?this.vb(t.name(),n,e,i):this.s3(t.name(),n,e,i))},k.prototype.setActiveSheetOrSheetTabIndex=function(t,n,e,i){var r,o,r=this.getActiveSheet(),o=this.getActiveSheetTab();this.I2(t,j(n)?2:n,e,i),this.a3(r),this.u3(o)},k.prototype.getActiveSheetOrSheetTabIndex=function(){return this.ep()},k.prototype.ep=function(){var t=this.jg();return t?t.E0i:-1},k.prototype.i4=function(){var n=[].concat(this.sheets);return this.mp.forEach(function(t){t.Mf&&n.push(t.Mf)}),n},k.prototype.r4=function(){for(var t,n,e,i,r,o,t,n=this.sheets,e=n.length,i=[],r=0;r<e;r++)(o=n[r])&&i.push(o.name());return i},k.prototype.Ese=function(t){var n=this.getSheetIndex(t);return n=j(n)?this.getSheetTabIndex(t):n},k.Pp=Ot,k.Jp=1,k.Gp=0,B.Workbook=n=k,(0,D.$e)(n),n.prototype.nextControl=t("nextControl",O),n.prototype.previousControl=t("previousControl",O)},"./dist/core/workbook/workbookpanelex.js":function(g,t,n){"use strict";var E,e,i,O,n,f,p,w,y,X,i,a,M,R,C,q,$,tt,nt,et,it,rt,ot,at,ut,st,S,ct,ft,lt,L,B,s,ht,F,dt,P,vt,mt,G,U,H,V,gt,z,pt,Y,bt,Z,W,Q,wt,r,T,o,A,I,x,u,J,K,c,b,N,l,k,h,_,e,h;function d(t){t.preventDefault?t.preventDefault():t.returnValue=!1}function v(t,n,e,i,r,o,a,u,s){this.updateStateFn=s;var s=this;s.o4=u,s.a4=!1,s.u4=!1,s.s4=p,s.c4=p,s.f4=300,s.l4=70,s.h4=t,s.qy(O.ScrollbarState.show),s.YC("number"==typeof n?n:0),s.ZC("number"==typeof e?e:0),s.d4("number"==typeof i?i:0),s.v4("number"==typeof r?r:0),s.m4("number"==typeof o?o:0),s.g4="number"==typeof a?a:1,s.p4=!1,s.b4=0,s.y4=s.m4(),s.w4()}function yt(t,n){var t=t.get(0);t&&(t.style[n]="")}function m(t,n){var e=this;e.C4=!0,e.S4=!0,e.T4=18,e.A4=t&&(0,E.GC$)(t),e.I4=n&&(0,E.GC$)(n),e.w4(!0)}Object.defineProperty(t,"__esModule",{value:!0}),t.x4=t.YM=t.ScrollOrientation=void 0,E=n("./dist/core/util/domUtil.js"),e=n("./dist/core/util/common.js"),i=n("Common"),O=n("./dist/core/core.enum.js"),n=n("./dist/core/workbook/sheettabbase.js"),f=i.Common.lt.ht,p=null,w=e.mt.Tt,y=e.mt.vi,X=e.mt.En,i=e.mt.p0,a=document,M=window,R=Math.round,C=Math.ceil,q="gc-scroll-container",$="gc-scroll-corner-all",tt="gc-scroll-arrow",nt="gc-scrollbar-wrapper",et="gc-scroll-bar",it="gc-scroll-arrowUp",rt="gc-scroll-arrowDown",ot="gc-scroll-arrowLeft",at="gc-scroll-arrowRight",ut="gc-scroll-mobile-track",st="gc-scroll-mobile-thumb",S="gc-scroll-mobile-state-active",ct="gc-scrollbar-vertical",ft="gc-scrollbar-horizontal",lt="gc-no-user-select",L="width",B="height",s="gc-scrollbar-stateActive ui-state-active",ht="float",F="left",dt="right",P="top",vt="bottom",mt="margin-left",G="position",U="border",H="padding",V="margin",gt="overflow",z="display",pt="outline",Y="100%",bt="borderWidth",Z="boxSizing",W="absolute",Q="relative",wt="margin-top",T="mousedown"+(r=".gcScrollbar"),o="mouseup"+r,A="mousemove"+r,I="mouseover"+r,x="mouseout"+r,u="mousewheel",J="inline-block",K="content-box",c="DOMMouseScroll",b="scroll"+r,N="scrollbar",(h=l=t.ScrollOrientation||(t.ScrollOrientation={}))[h.horizontalScroll=0]="horizontalScroll",h[h.verticalScroll=1]="verticalScroll",v.prototype.oy=function(){return this.N4},v.prototype.qy=function(t){t===O.ScrollbarState.inactive&&this.a4||(this.O3=t,this.updateStateFn&&this.updateStateFn())},v.prototype.value=function(t){var n,t,n=this;return 0===arguments.length?n.y4:("number"==typeof t&&t<=n.v4()&&t>=n.m4()&&(t=((n.y4=t)-n.m4())*n.k4,n.scrollTo(t,!0)),n)},v.prototype.w4=function(){var n,t,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x;function N(){n.N4=X("div"),n.D4=(0,E.GC$)(n.N4),n.D4.css([G,F,P,gt,pt,H,V],[Q,0,0,"hidden","none",0,0]).addClass(q+" "+$+" "+u+" "),n.h4&&n.D4.css(ht,F)}function k(t){n._4=E.GC$.En("div",[G,z,bt,H,V,Z],[W,J,"1px",0,0,K],tt+" "+w,t),n.E4=E.GC$.En("span",[z,U,H,V],["block","none",0,0],m+" "+y,n._4)}function _(t){n.j4=E.GC$.En("div",[G,z,Z,U,H,V],[W,J,K,"none",0,0],nt+" "+nt,t)}function D(t){n.O4=E.GC$.En("div",[],[],lt+" "+M+" "+et,t),n.R4=E.GC$.En("span",[z,U,H,V],["block","none",0,0],p+" "+C,n.O4)}function j(t){n.B4=E.GC$.En("div",[G,z,bt,H,V,Z],[W,J,"1px",0,0,K],tt+" "+S,t),n.L4=E.GC$.En("span",[z,U,H,V],["block","none",0,0],g+" "+T,n.B4)}e=t=0,i=!1,a=(o=(r=(n=this).o4)===O.ScrollbarAppearance.mobile)?0:2,u="ui-widget ui-corner-all",s=n.ZC(),c=n.YC(),h=f=o?0:s,d=F,v=dt,m=ot,g=at,p=ft,b=mt,w="ui-button ui-state-default ui-corner-bl btn btn-default",y="ui-icon ui-icon-triangle-1-w",M="gc-scroll-handle ui-button ui-state-default ui-corner-all ui-draggable btn btn-default",C="ui-icon ui-icon-grip-solid-vertical",S="ui-button ui-state-default ui-corner-br btn btn-default",T="ui-icon ui-icon-triangle-1-e",n.F4=l=c-2*f,n.h4||(l=f=o?0:c,d=P,v=vt,m=it,g=rt,p=ct,b=wt,w="ui-button ui-state-default ui-corner-tr btn btn-default",y="ui-icon ui-icon-triangle-1-n",M="gc-scroll-handle ui-button ui-state-default ui-corner-all ui-draggable btn btn-default",C="ui-icon ui-icon-grip-solid-horizontal",S="ui-button ui-state-default ui-corner-br btn btn-default",T="ui-icon ui-icon-triangle-1-s",n.F4=h=s-2*f),A=n.F4,I=n.v4()-n.m4(),n.P4=n.d4()*A/(I+n.d4()),n.P4>A&&(n.P4=A),n.P4<10&&(n.P4=10),x=n.P4,n.k4=0==I?1:(A-x)/I,e=n.h4?(t=x,f):(t=f,x),n.D4||(i=!0,N()),o?n.D4.addClass(ut):n.D4.removeClass(ut),n._4||k(n.D4),n.j4||_(n.D4),n.O4?n.O4.removeAttr("style"):D(n.j4),o?n.O4.css(G,W).addClass(st):n.O4.css([G,bt,H,V,Z],[W,"1px",0,0,K]).removeClass(st),n.B4||j(n.D4),o?(yt(n.D4,U),yt(n.D4,V),n.h4?(n.D4.css([L,B],[c,Y]),n.j4.css([d,L,B],[f,Y,Y]),n.O4.css([d,L,B],[n.b4,R(t-a),Y])):(n.D4.css([L,B,V],[Y,Y,0]),n.j4.css([d,L,B],[f,Y,Y]),n.O4.css([d,L,B],[n.b4,Y,R(e-a)])),n.R4.remove(),n._4.remove(),n.B4.remove()):(n.D4.css([L,B,U],[c,s,"none"]),n.j4.css([d,L,B],[f,l,h]),n.O4.css([d,L,B],[n.b4,R(t-a),R(e-a)]),n._4.css([d,L,B],[0,f-a,f-a]),n.E4.css([L,B],[Y,Y]),n.B4.css([v,L,B],[0,f-a,f-a]),n.L4.css([L,B],[Y,Y]),n.R4.css([L,B,b],[f-a,f-a,Math.floor((n.P4-f)/2)]),n.O4.append(n.R4),n.D4.append(n._4),n.D4.append(n.B4)),i&&n.G4()},v.prototype.G4=function(){var r=this;function t(t,n){t.bind(T,function(t){r.U4(t,n)}).bind(o,function(t){r.H4(t,n)}).bind(I,function(t){r.z4(t,n)}).bind(x,function(t){r.V4(t,n)})}t(r._4,!0),t(r.B4,!1),r.O4.bind(T,function(t){r.Y4(t)}).bind(A,function(t){r.Z4(t)}).bind(o,function(t){r.W4(t)}).bind(I,function(t){r.K4(t)}).bind(x,function(t){r.J4(t)}),r.j4.bind(T,function(t){var n,e,i,n;w&&w.mozilla&&(e=(new Date).valueOf(),i=r.X4,r.X4=e,i)&&e-i<100||r.q4(t)}).bind(o,function(t){r.tS(t)}),r.nS=function(t){r.eS(t)},r.D4.bind(u,r.nS),r.D4.bind(c,r.nS),v.et(r,"initEvents",r.N4)},v.prototype.Jw=function(t){this.o4=t},v.prototype.dispose=function(){var t=this;function n(t){t&&t.unbind(r)}n(t.B4),n(t.O4),n(t._4),n(t.j4),t.D4&&(t.nS&&(t.D4.unbind(u,t.nS),t.D4.unbind(c,t.nS)),v.et(t,"dispose",t.N4),t.D4.unbind(r).remove())},v.prototype.Fg=function(){var n=this;n.p4||((0,E.GC$)(a).bind(A,function(t){n.Z4(t)}).bind(o,function(t){n.W4(t)}),n.p4=!0)},v.prototype.u2=function(){this.p4&&(this.p4=!1,E.GC$)(a).unbind(A).unbind(o)},v.prototype.U4=function(t,n){var e,i,r,o,e=0,i=this,r=!0;i.u4=!0,null===i.s4&&(n?(i._4.addClass(s),e=0-i.iS(),i.rS=O.Zi.smallDecrement):(i.B4.addClass(s),e=i.iS(),i.rS=1),(o=function(){i.scrollTo(i.b4+e*i.k4,!1),i.s4=M.setTimeout(o,r?i.f4:i.l4),r=!1})(),d(t))},v.prototype.H4=function(t,n){var e,i,e=this,i;(n?e._4:e.B4).removeClass(s),e.oS(),d(t)},v.prototype.z4=function(t,n){var e,i,e=this,i;(n?e._4:e.B4).addClass("gc-scroll-arrow-hover ui-state-hover"),d(t)},v.prototype.V4=function(t,n){var e,i,e=this,i;(n?e._4:e.B4).removeClass("gc-scroll-arrow-hover ui-state-hover "+s),e.oS(),d(t)},v.prototype.Y4=function(t){var n,e,i,r,o,a,u,n=this;0===t.button&&(n.a4=!0,n.Z3={x:t.pageX,y:t.pageY},n.qy(O.ScrollbarState.show),n.Fg(),n.D4.addClass(S),n.O4.addClass(s),e=n.O4.offset(),i=n.O4.outerWidth(!0),r=n.O4.outerHeight(!0),o=n.j4.offset(),a=n.j4.outerWidth(!0),u=n.j4.outerHeight(!0),n.aS={isBeyondEdge:!1,startEdgePosition:{x:o.left+t.pageX-e.left,y:o.top+t.pageY-e.top},endEdgePosition:{x:o.left+a-(i-t.pageX+e.left),y:o.top+u-(r-t.pageY+e.top)}}),d(t)},v.prototype.Z4=function(t){var n=this;n.a4&&(n.qy(O.ScrollbarState.active),n.uS={x:t.pageX,y:t.pageY},n.sS(),n.Z3=n.uS,(0,E.GC$)(a.body).attr("unselectable","on").addClass(lt)),d(t)},v.prototype.W4=function(t){var n,e,i,r,o,o,n=this;n.a4=!1,n.rS=O.Zi.thumbPosition,n.aS=null,n.D4.trigger(b,{newValue:n.y4,oldValue:n.y4,scrollOrientation:n.h4?l.horizontalScroll:l.verticalScroll,scrollEventType:n.rS}),i=((e=n.y4)-n.m4())*n.k4,r="left",o=(o=t.target.classList)&&o.contains(st),n.h4||(r="top"),o?n.qy(O.ScrollbarState.hide):n.qy(O.ScrollbarState.inactive),n.b4=i,n.O4.css(r,R(i)),n.u2(),(0,E.GC$)(a.body).removeClass(lt),(0,E.GC$)(a.body).attr("unselectable")&&(0,E.GC$)(a.body).removeAttr("unselectable"),n.O4.removeClass(s),n.D4.removeClass(S),n.rS=6,n.D4.trigger(b,{newValue:n.y4,oldValue:n.y4,scrollOrientation:n.h4?l.horizontalScroll:l.verticalScroll,scrollEventType:n.rS}),d(t)},v.prototype.K4=function(t){this.O4.addClass("gc-scrollbar-stateHover ui-state-hover"),d(t)},v.prototype.J4=function(t){this.O4.removeClass("gc-scrollbar-stateHover ui-state-hover"),d(t)},v.prototype.eS=function(t){var n,e,i,i,n=this;f(t.wheelDelta)&&f(t.detail)&&(t.wheelDelta=t.originalEvent.wheelDelta,t.detail=t.originalEvent.detail),i=(e=t.detail||t.wheelDelta/-40)/3*n.iS()*n.k4,n.rS=0<=i?1:0,n.scrollTo(n.b4+i,!1),n.rS=6,i={newValue:n.y4,oldValue:n.y4,scrollOrientation:n.h4?l.horizontalScroll:l.verticalScroll,scrollEventType:n.rS},n.D4.trigger(b,i),d(t)},v.prototype.q4=function(t){var e,i,r,o,a,u,s,c,e=this,i=!0,r=t.pageX,o=t.pageY,a=0,u=e.j4.offset(),s=e.cS();null===e.c4&&(a=e.h4?r-u.left-e.b4:o-u.top-e.b4,(c=function(){var t=0,n=e.b4,t;if((t=e.h4?r-u.left-n:o-u.top-n)*a<0||0<=t&&t<e.P4)e.fS();else{if(a<0)e.rS=O.Zi.largeDecrement,e.scrollTo(n-s*e.k4,!1);else{if(!(0<a))return void e.fS();e.rS=O.Zi.largeIncrement,e.scrollTo(n+s*e.k4,!1)}e.c4=M.setTimeout(c,i?e.f4:e.l4),i=!1}})(),d(t))},v.prototype.tS=function(t){this.fS(),d(t)},v.prototype.fS=function(){var t,n,t=this;t.c4&&clearTimeout(t.c4),t.c4=p,t.rS=O.Zi.endScroll,n={newValue:t.y4,oldValue:t.y4,scrollOrientation:t.h4?l.horizontalScroll:l.verticalScroll,scrollEventType:t.rS},t.D4.trigger(b,n)},v.prototype.oS=function(){var t,n,t=this;t.u4&&(t.u4=!1,t.s4&&clearTimeout(t.s4),t.s4=p,t.rS=6,n={newValue:t.y4,oldValue:t.y4,scrollOrientation:t.h4?l.horizontalScroll:l.verticalScroll,scrollEventType:t.rS},t.D4.trigger(b,n))},v.prototype.sS=function(){var e,t,n,i,r,o,n,a,u,i,s,u;function c(t){return e.h4?t.x:t.y}function f(t,n){e.h4?t.x=n:t.y=n}if(t=(e=this).b4,n=e.uS,i=e.aS,n=c(n),a=c(e.Z3),i&&i.isBeyondEdge){if(u=c(i.startEdgePosition),i=c(i.endEdgePosition),(r=n<u)||(o=i<n))return;a<u&&f(e.Z3,u),i<a&&f(e.Z3,i)}(u=t+(s=n-a))!==t&&(e.rS=5,e.scrollTo(u,!1))},v.prototype.scrollTo=function(t,n){var e,i,r,o,a,u,r,u,s,c,n,e=this,i=P,r=e.F4-e.P4;e.h4&&(i=F),u=a=o=!1,r<t&&(t=r,a=u=!0),t<0&&(o=u=!(t=0)),e.aS&&(e.aS.isBeyondEdge=u),r=e.g4===O.ScrollType.continuous?R(t/e.k4)+e.m4():t/e.k4+e.m4(),u=e.y4,s=!1,n||(n={newValue:r,oldValue:u,scrollOrientation:e.h4?l.horizontalScroll:l.verticalScroll,scrollEventType:e.rS,isBeyondMaxEdge:a,isBeyondMinEdge:o},e.D4.trigger(b,n),s=n.ignoreUpdatePosition,n.newValue>e.v4()&&(n.newValue=e.v4()),r=n.newValue,c=n.newValueWithOffset),f(c)&&(c=r),e.y4=r,5!==e.rS&&(t=(c-e.m4())*e.k4),e.b4=t,s||e.O4.css(i,R(t))},v.prototype.hitTest=function(t,n){var e,i,r,o,a,u,s,c,f,u,o,f,a,e=this,i=0,r=0,o=e.O4.outerWidth(),a=e._4.outerWidth(),u=e.j4.outerWidth(),s=e.O4.offset(),c=(0,E.GC$)(e.oy()).offset(),f=s.left-c.left-18;return e.h4?t<0+u+a&&0+a<t?t<f+o+a&&f<t?{element:O.Yi.ThumbButton,x:t,y:n}:{element:O.Yi.TrackButton}:t<=0+a&&0<t?{element:O.Yi.LeftButton,x:t,y:n}:{element:O.Yi.RightButton,x:t,y:n}:(u=e.O4.outerHeight(),o=e._4.outerHeight(),f=e.j4.outerHeight(),a=s.top-c.top-18,n<0+f+o&&0+o<n?n<a+u+o&&a<n?{element:O.Yi.ThumbButton,x:t,y:n}:{element:O.Yi.TrackButton}:n<=0+o&&0<n?{element:O.Yi.UpButton,x:t,y:n}:{element:O.Yi.DownButton,x:t,y:n})},v.prototype._b=function(){var t=this;return{x:0,y:0,width:t.YC(),height:t.ZC()}},v.prototype.show=function(){this.j4.show()},v.prototype.hide=function(){this.j4.hide()},v.prototype.lS=function(t){var n,n,n=this,n=n.D4.parent()&&n.D4.parent().parent();return n?t?n.height():n.width():p},k=v,t.YM=k,(0,e.$e)(k),(h=k.prototype).iS=i("smallChange",1),h.cS=i("largeChange",10),h.d4=i("pageValue",10,function(t){t<=0&&this.d4(1)}),h.v4=i("maximum",100,function(t){t<=0&&this.v4(0)}),h.m4=i("minimum",0,function(t){t<=0&&this.m4(0)}),h.YC=i("width",0),h.ZC=i("height",0),m.prototype.w4=function(t){var a,n,e,i,r,o,u,s,c,t,r,o,f,l;function h(t){return t===W?E.GC$.En("div",[G,F,P,U,H,V],[W,0,0,"none",0,0]):t===Q?E.GC$.En("div",[G,F,P,U,H,V],[Q,0,0,"none",0,0]):p}function d(t,n){var e,e,i,n,e=n?a.hS:a.dS;return e||(e=new k(n),i=E.GC$.En("div"),n?(a.vS=i,a.hS=e,i.css([G,F,vt,U,H,V],[W,0,0,"none",0,0])):(a.mS=i,a.dS=e,i.css([G,dt,P,U,H,V],[W,0,0,"none",0,0])),n=(n?a.hS:a.dS).oy(),i.append(n),t.append(i),e)}function v(t,n,e,i,r,o){o?(a.vS.css([L,B],[n,i]),t.YC(n),t.ZC(i)):(a.mS.css([L,B],[i,n]),t.YC(i),t.ZC(n)),t.m4(0),t.v4(r-n),t.d4(n),t.iS(o?a.gS():a.pS()),t.cS(n),t.w4(),(0,E.GC$)(t.oy()).bind(b,function(t,n){e.css(o?F:P,0-n.newValue)}),(o?a.vS:a.mS).show()}function m(t){a.bS||(a.bS=h(Q),a.bS.css([gt,z,L],["hidden",J,Y]),t.append(a.bS))}function g(t){a.yS||(a.yS=E.GC$.En("div",G,Q,p,t))}(a=this).A4&&a.I4&&(n=a.T4,e=a.I4.width(),i=a.I4.height(),u=(r=a.A4.width())-n,s=(o=a.A4.height())-n,c=!1,a.wS||(a.wS=h(Q),a.wS.css([G,gt],[Q,"hidden"]),c=!0),a.wS.css(B,o),m(a.wS),g(a.bS),t&&a.yS.append(a.I4).css([P,F],[0,0]),w.chrome&&(e=R(e),i=R(i),r=C(r),o=C(o)),r=(t=a.CS(e,i,r,o)).MS,(o=t.SS)?(r||(u+=n),v(f=d(a.wS,!0),u,a.yS,n,e,!0)):a.vS&&a.vS.hide(),r?(o||(s+=n),v(l=d(a.wS,!1),s,a.yS,n,i,!1)):a.mS&&a.mS.hide(),o||r||(u+=n,s+=n),a.C4=o,a.S4=r,a.TS=u,a.AS=s,a.bS.css(B,s),c)&&(a.A4.append(a.wS),a.IS())},m.prototype.xS=function(t){var n,t,e,t,n=this,t=n.NS(t),e=t.I0,t=t.A0;!f(e)&&n.hS&&n.wy(e),!f(t)&&n.dS&&n.yy(t)},m.prototype.wy=function(t){var n,e,i,n=this;n.hS.value(t),e=n.TS,i=n.I4.width(),0<=t&&t<=i-e&&n.yS.css(F,0-t)},m.prototype.yy=function(t){var n,e,i,n=this;n.dS.value(t),e=n.AS,i=n.I4.height(),0<=t&&t<=i-e&&n.yS.css(P,0-t)},m.prototype.CS=function(t,n,e,i){var r,o=e,a=i-this.T4,u={SS:!1,MS:!1};return e<t&&(u.SS=!0,u.MS=a<n),i<n&&(u.MS=!0,u.SS=o<t),u},m.prototype.NS=function(t){var n=(0,E.GC$)(t),e=this.bS,i=this.yS,t,i,r,n,o,n,o,a={I0:p,A0:p};return t&&(t=n.offset(),i=i.offset(),r=e.offset(),t.leftWidth=t.left+n.outerWidth(),t.topHeight=t.top+n.outerHeight(),r.leftWidth=r.left+e.outerWidth(),r.topHeight=r.top+e.outerHeight(),n=t.left-i.left,t.left<r.left?a.I0=n:t.leftWidth>r.leftWidth&&(o=t.leftWidth-i.left-e.innerWidth(),a.I0=n<o?n:o),n=t.top-i.top,t.top<r.top?a.A0=n:t.topHeight>r.topHeight&&(o=t.topHeight-i.top-e.innerHeight(),a.A0=n<o?n:o)),a},m.prototype.IS=function(){var n=this;this.yS&&(n.nS=function(t){n.kS(t)},n.yS.bind(u,n.nS),n.yS.bind(c,n.nS))},m.prototype.kS=function(t){var n,e,i,r,o,a,u,i,n=this;f(t.wheelDelta)&&f(t.detail)&&(t.wheelDelta=t.originalEvent.wheelDelta,t.detail=t.originalEvent.detail),i=e=t.detail||t.wheelDelta/-40,r=n.dS,o=parseInt(n.yS.css(P),10),a=n.AS,(u=n.I4.height())<a&&(u=a),(i=(i=0<=(i=(o=isNaN(o)?0:o)-i*n.pS())?0:i)<0&&u-a<0-i?0-(u-a):i)!==o&&(n.yS.css(P,i),n.S4)&&r.value(0-i),y(t)},m.prototype.dispose=function(){var t=this;t.wS&&(t.hS&&t.hS.dispose(),t.dS&&t.dS.dispose(),t.yS&&t.nS&&(t.yS.unbind(u,t.nS),t.yS.unbind(c,t.nS)),(0,E.GC$)(t.wS).remove())},(e=(t.x4=_=m).prototype).gS=i("horizontalSmallChange",10),e.pS=i("verticalSmallChange",10),n.Hv.ch(N,{preProcessMouseMove:function(t){var n=this.Vv,e;(n.Xb.a4||n.zb.a4)&&(t.r=!0)}})},"./dist/core/worksheet/clipboardhelper.js":function(t,n,e){"use strict";var F,i,f,l,I,P,h,G,d,U,H,r,x,o;function a(t){return t&&t.options.allowCopyPasteExcelStyle}function v(t,n){var e,i;if(G.msie){for(e=[],i=0;i<t.length;i++)n&&""===t[i].trim()||e.push(t[i]);return e.join("")}return t.join("")}function u(t){for(var n,e,i,n="picture",e=1,i=n+e.toString();t.get(i);)i=n+(++e).toString();return i}function N(t,n,e,i){for(var r,o,a,r=[],o=0,a=e;o<a;o++)r[n+o]=t.getRowHeight(n+o,i);return r}function k(t,n,e,i){for(var r,o,a,r=[],o=0,a=e;o<a;o++)r[n+o]=t.getColumnWidth(n+o,i);return r}function b(t,n,e){var i,r;if(n=n||"\x3c!--",e=e||"--\x3e",t)for(;;){if((i=t.indexOf(n))<0)break;if((r=t.indexOf(e))<0)break;t=t.substring(0,i)+t.substring(r+e.length)}return t}function c(t,n,e){var i,r,i=-1;if(e)for(r=i=0;r<n;r++)i+=e[t+r]||0;return i}function m(t,n,e){var i,r,i=-1;if(e)for(r=i=0;r<n;r++)i+=e[t+r]||0;return i}function s(t){this.Nf=[],this.Zc=t}function g(t){this.Nf={},this.Doe=t,this.joe=t.map(function(t){return new r(t)}),this.Lre=1}function V(t){var n=this;n.DS=H,n._S=H,n.ES=!1,n.jS=t,n.En()}Object.defineProperty(n,"__esModule",{value:!0}),n.yM=n.Ooe=n.Boe=void 0,F=e("./dist/core/util/common.js"),i=e("Common"),f=e("./dist/core/worksheet/stylehelper.js"),l=e("./dist/core/worksheet/style.js"),I=e("./dist/core/core.enum.js"),P=i.Common.zf,h=/<img[^>]+>/g,G=F.mt.Tt,d=i.Common.lt.ht,U=i.Common.Uf.OS,H=null,s.prototype.add=function(t){var n=this.Nf,e=n.indexOf(t);return-1===e&&(n.push(t),e=n.length-1),e},s.prototype.toString=function(t){var t=this.Nf[t];return d(t)?"":this.Zc+":"+t},r=s,n.Boe=r,g.prototype.Loe=function(e){var i=this.joe;return this.Doe.map(function(t,n){return i[n].add(e[t])}).join("_")},g.prototype.add=function(t){var n=this.Nf,t=this.Loe(t);return n[t]||(n[t]="sjs"+this.Lre,this.Lre++),n[t]},g.prototype.toString=function(){var t,n,e,i,r,o,a,u,s,t=this.joe,n=[],e=this.Nf;for(i in e)if(e.hasOwnProperty(i)){for(r=i.split("_"),o=[],a=0;a<this.Doe.length;a++)(u=t[a].toString(+r[a]))&&o.push(u);s="."+e[i]+"{\r\n"+o.join(";\r\n")+"\r\n}\r\n",n.push(s)}return n.join("")},x=g,n.Ooe=x,V.prototype.En=function(){var c,t,n,e,i,c=this,t=document.createElement("div");t.style.position="fixed",t.style.top="0px",t.style.left="0px",t.style.width="0px",t.style.height="0px",t.style.overflow="hidden",(n=document.createElement("div")).setAttribute("contenteditable","true"),n.setAttribute("gcUIElement","gcSheetClipboard"),n.setAttribute("tabindex","-1"),n.style.position="absolute",n.style.overflow="hidden",n.style.background="white",n.style.webkitUserSelect="text",t.appendChild(n),c.RS=n,(e=document.createElement("textarea")).setAttribute("gcUIElement","gcSheetClipboard"),c.jS&&c.jS.options.enableAccessibility&&(e.setAttribute("aria-hidden","true"),e.setAttribute("role","none"),e.setAttribute("title","")),e.setAttribute("tabindex","-1"),e.style.position="absolute",e.style.overflow="hidden",e.style.background="white",e.style.webkitUserSelect="text",t.appendChild(e),c.BS=e,(i=c.jS.getHost())&&i.appendChild(t),G.msie||G.edge||(c.qfe=function(t){var n,e,i,i,n=t.clipboardData;n&&(i=(e=c.DS).bT(c._S),n.setData("text/plain",i),i=e.MT(c._S),n.setData("text/html",i),t.preventDefault())},c.FS=function(t){var e,n,i,r,o,a,u,s,r,e=(0,F.jf)(c.jS),n=t.clipboardData;if(n)if(i=(i=n.getData("text/html")).replace(h,""),(r=c.PS()).innerHTML=i,o=i?c.GS(r,!0):V.formatClipboardData(n.getData("text/plain")),r.innerHTML="",o||i&&0<=i.indexOf("<table"))e.US(o,i);else{for(a=void 0,u=n.items,s=0;s<u.length&&(0!==u[s].type.indexOf("image")||!(a=u[s].getAsFile()));s++);a&&((r=new FileReader).onload=function(t){var n=new Image;n.src=t.target.result,n.onload=function(){e.US(o,i,n.src)}},r.readAsDataURL(a))}t.preventDefault()},n.addEventListener("cut",c.qfe),n.addEventListener("copy",c.qfe),n.addEventListener("paste",c.FS),c.HS=function(t){var n,e,i,e,r,n=(0,F.jf)(c.jS),e=t.clipboardData;e&&((i=V.formatClipboardData(e.getData("text/plain")))||(e=e.getData("text/html"))&&((r=c.PS()).innerHTML=e,i=c.GS(r,!1),r.innerHTML=""),n.US(i,"")),t.preventDefault()},e.addEventListener("paste",c.HS))},V.prototype.L0=function(){var t,n,n,e,e,n,n,e,t=this,n=t.RS;n&&(G.msie||G.edge||(n.removeEventListener("cut",t.qfe),n.removeEventListener("copy",t.qfe),n.removeEventListener("paste",t.FS),t.BS.removeEventListener("paste",t.HS)),(n=n.parentElement)&&(e=n.parentElement)&&e.removeChild(n),t.RS=H,t.BS=H),(e=t.zS)&&((n=e.parentElement)&&n.removeChild(e),t.zS=H),(n=t.VS)&&((e=n.parentElement)&&e.removeChild(n),t.VS=H),t.jS=H},V.prototype.YS=function(t){a(this.jS)?this.RS.innerHTML=t:this.BS.value=t},V.prototype.ZS=function(){(a(this.jS)?this.RS:this.BS).focus()},V.prototype.WS=function(){a(this.jS)?document.execCommand("selectAll"):this.BS.select()},V.prototype.QS=function(){var t,n,e,i,r,r,t="",n="",e="";return n=a(this.jS)?((i=this.RS)&&(0<(r=i.getElementsByTagName("table")).length?t=r[0].outerHTML:0<(r=i.getElementsByTagName("img")).length&&(e=r[0].src)),this.GS(this.RS,!0)):V.formatClipboardData(this.BS.value),{html:t,text:n,image:e}},V.KS=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d){var v,m,g,p,b,n,f,w,y,M,C,C,S,T,A,n,b,b;return d||!G.chrome&&!G.edge||(V.Foe=new x(["background-color","color","font","white-space","vertical-align","text-align","border-left","border-right","border-top","border-bottom"])),v=t.JS((0,F.Ec)(e,r,i,o),a),m=new RegExp(String.fromCharCode(32),"g"),b=p=!(g="&nbsp;"),a===I.SheetArea.viewport&&(e<0&&2==(2&n)&&(p=!0),r<0)&&1==(1&n)&&(b=!0),e=v.row,r=v.col,i=v.rowCount,o=v.colCount,n=f?t.options.gridline:H,f=f?{color:"#d4d4d4",showHorizontalGridline:!0,showVerticalGridline:!0}:H,w=h?N(t,e,i,a):H,y=h?k(t,r,o,a):H,M=!d&&4e3<i*o&&(G.safari||G.mozilla||F.mt.Qf()&&G.chrome),a===I.SheetArea.viewport?(S=C=void 0,A=T=H,n=V.XS(t,e,i,r,o,3,s,c,u,v,m,g,n,l,w,y,d),b&&(C=h?k(t,r,o,2):H,b=t.getColumnCount(2),T=V.XS(t,e,i,0,b,2,s,[],u,v,m,g,f,l,w,C,d)),p&&(S=h?N(t,e,i,1):H,b=t.getRowCount(1),A=V.XS(t,0,b,r,o,1,[],c,u,v,m,g,f,l,S,y,d)),C=V.qS(n,T,A,d,M)):a===I.SheetArea.rowHeader?(T=V.XS(t,e,i,r,o,2,s,c,u,v,m,g,f,l,w,y,d),C=V.qS(T,H,H,d,M)):a===I.SheetArea.colHeader&&(A=V.XS(t,e,i,r,o,1,s,c,u,v,m,g,f,l,w,y,d),C=V.qS(A,H,H,d,M)),V.Foe&&(V.Foe=H),C},V.qS=function(t,n,e,i,r){var o,a,u,n,s,o=t,a=0,u=function(t,n){for(var e,i,r,e=[],i=t.length,r=0;r<i;r++)e.push(t[r].concat(n[r]));return e};return n&&(a=n[0].length,o=u(n,t)),e&&(n=e.length,o=(e=a?u(s=V.XS(H,0,n,0,a,H,[],[],!1,H,H,H,H,!1,[],[],i),e):e).concat(o)),r&&V.$S(o),V.t5(o,i)},V.$S=function(t){for(var n,e,n=t.length,e=t.length-1;0<=e&&-1===t[e].join("").search(/>\S+</);e--)n=e;t.length=n},V.t5=function(t,n){var e,i,r,o,a,e="",i=!!V.Foe;for(i&&(e=(e+="<html>\r\n<head>\r\n<style>\r\n")+V.Foe.toString()+"</style>\r\n</head>\r\n<body>\r\n"),r=t.length,e+=n?'<table style="border-collapse: collapse">':'<table gc-sjs-clipboard="true" style="min-width:1px;min-height:1px;">',o=0;o<r;o++){for(e+="<tr>",a=0;a<t[o].length;a++)e+=t[o][a];e+="</tr>"}return e+="</table>",i&&(e+="\r\n</body>\r\n</html>"),e},V.n5=function(t){return t&&0<=t.indexOf('gc-sjs-clipboard="true"')},V.vI=function(t,n,e,i,r,o,a){var u,s,c,i,r,f,l,l,l,o,l,u,o,s,a,n,l,u,l,u,l,u=V.convertVAlign,s=V.convertHAlign,c=V.convertLineBorder,i=i,r=r,f={},l=t.backColor;return l&&(f["background-color"]=l,r=i=!1),(l=t.foreColor)&&(f.color=l),(l=t.font)&&(o&&(l=l+", "+F.FallbackFontFamily),f.font=l.replace(/"/g,"'").replace(/([\.\d]+px)/,function(t){return(3*parseFloat(t.substring(0,t.length-2))/4).toFixed(2)+"pt"})),f["white-space"]=t.wordWrap?a?"pre":"normal":"nowrap",o=t.vAlign,d(o)||(f["vertical-align"]=u(o)),l=t.hAlign,d(l)||(u=s(l=a?F.mt.gt(l,n):l))&&(f["text-align"]=u),o="border-left",s="border-right",a="border-top",n="border-bottom",(l=t.borderLeft)&&(f[o]=c(l),r=!1),(u=t.borderRight)&&(f[s]=c(u),r=!1),(l=t.borderTop)&&(f[a]=c(l),i=!1),(u=t.borderBottom)&&(f[n]=c(u),i=!1),l="1px solid "+e,i&&(f[a]=l,f[n]=l),r&&(f[o]=l,f[s]=l),f},V.dge=function(t,n,e,i,r){var o,a,u,s,c,o=t.row===n&&t.col===e;if(i&&r){for(u=t.row;u<t.row+t.rowCount;u++)if(0<i[u]){a=u;break}for(s=void 0,c=t.col;c<t.col+t.colCount;c++)if(0<r[c]){s=c;break}o=a===n&&s===e}return o},V.hge=function(t,n,e){var i,r,i=n;if(e)for(r=t;r<t+n;r++)e[r]<=0&&i--;return i},V.XS=function(t,n,e,i,r,o,a,u,s,c,f,l,h,L,d,v,m){var g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,j,E,O,B,R,N,I,k,_,D;for(h&&(g=h.color,p=h.showHorizontalGridline,b=h.showVerticalGridline),w=[],y=0;y<e;y++)if(!(U(a,M=n+y)||m&&d&&d[M]<=0)){for(C=[],S=0;S<r;S++)if(!(U(u,T=i+S)||m&&v&&v[T]<=0)){if(A="",x=I=void 0,D=_=k=N=1,s&&t&&(I=(I=t.getSpan(M,T,o))&&V.isPartSpan(I,c,a,u)?H:I)){if(I.row!==M||I.col!==T){if(!V.dge(I,M,T,d,v))continue;M=I.row,T=I.col}x=t.getActualStyle(M,T,o),j=t.getActualStyle(I.row+I.rowCount-1,I.col+I.colCount-1,o),!x.borderRight&&j.borderRight&&(x.borderRight=j.borderRight),!x.borderBottom&&j.borderBottom&&(x.borderBottom=j.borderBottom)}if(A+="<td",j=t&&t.getValue(M,T,o),s&&t){if(I&&(N=V.hge(I.row,I.rowCount,d),_=I.rowCount,1<N&&(A+=" rowSpan="+N),k=V.hge(I.col,I.colCount,v),D=I.colCount,1<k)&&(A+=" colSpan="+k),x=x||t.getActualStyle(M,T,o),E=m?"padding: 0; ":"",O=V.vI(x,j,g,p,b,L,m),V.Foe)A+=' class="'+(B=V.Foe.add(O))+'"';else for(R in O)O.hasOwnProperty(R)&&(E+=R+": "+O[R]+"; ");N=O.font?F.mt.vt(O.font):0,(E+=V.e5(M,T,_,D,d,v,N))&&(A+=' style="'+E+'"')}A+=">",k=I=void 0,s&&t&&((I=2==(2&(_=x.textDecoration)))&&(A+="<s>"),k=(k=1==(1&_))||8==(8&_))&&(A+="<u>"),(D=t?t.getText(M,T,o):"")?(" "!==D[0]&&" "!==D[D.length-1]||"number"!=typeof j||(D=D.trim()),"number"!=typeof j&&(D=P.j0(D).replace(f,l))):G.chrome?D="":G.safari&&(D="&nbsp;"),A+=D=m?D:D.replace(/\n/g," "),s&&(k&&(A+="</u>"),I)&&(A+="</s>"),C.push(A+="</td>")}w.push(C)}return w},V.e5=function(t,n,e,i,r,o,a){var u,t,e,s,u="",t=c(t,e,r);return 0<t&&(t-=1),0<(e=m(n,i,o))&&(e-=1),u=0<=t&&0<=e?"overflow: hidden;height: "+t+"px;line-height: "+(s=Math.min(a,t))+"px; width: "+e+"px;max-width: "+e+"px;min-width: "+e+"px;":u},V.prototype.PS=function(){var t,n,e,t=this;return t.zS||((n=document.createElement("div")).style.display="none",(e=t.jS.getHost())&&e.appendChild(n),t.zS=n),t.zS},V.prototype.i5=function(){var t,n,e,t=this;return t.VS||((n=document.createElement("div")).style.display="none",(e=t.jS.getHost())&&e.appendChild(n),t.VS=n),t.VS},V.prototype.r5=function(t,n,e,i){var r,t,o,a,u,s,c,f,l,h,d,h,v,r=this.PS();if(r.innerHTML=t,t=r.getElementsByTagName("table"),o=n.o5(),0<t.length)for(a=this.a5(t[0],!0),s=e+(u=0);u<a.length;u++,s++){if(c=a[u],o)for(;0===n.getRowHeight(s);)s++;for(l=i+(f=0);f<c.length;f++,l++)if(h=c[f]){if(o)for(;0===n.getColumnWidth(l);)l++;n.u5(s,l,h.style),d=h.rowSpan,h=h.colSpan,(1<d||1<h)&&((v=n.getSpan(s,l))?(v.row=s,v.col=l,v.rowCount=d,v.colCount=h):n.addSpan(s,l,d,h))}}r.innerHTML=""},V.prototype.s5=function(t,n,e,i){var r,r,n,r;n.shapes?((r=n.shapes.addPictureShape("",t,0,0)).startRow(e),r.startColumn(i)):n.pictures&&(n=u(r=n.pictures),(r=r.add(n,t,0,0)).startRow(e),r.startColumn(i))},V.prototype.a5=function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,d,v,d,m,g,p,e=this.i5(),i=[],r=/ +/g,o=0;o<t.rows.length;o++)for(a=t.rows[o],i[o]||(i[o]=[]),u=i[o],c=s=0;s<a.cells.length;s++){for(f=a.cells[s];u[c];)c++;for(l=u[c]={},h=void 0,n&&(h=V.getStyleFromDOM(f),l.style=h),d=b(d=f.innerHTML,"\x3c!--[if","[endif]--\x3e"),e.innerHTML=d.replace(r," "),v=e.innerText,0<=d.indexOf("<table")&&(v=v.trim()),l.text=v,l.rowSpan=f.rowSpan,(d=f.getAttribute("style"))&&0<=d.search(/mso-ignore:\s*colspan/)?l.colSpan=1:l.colSpan=f.colSpan,m=0;m<f.rowSpan;m++)for(g=0;g<f.colSpan;g++)0===m&&0===g||(i[o+m]||(i[o+m]=[]),(p=i[o+m])[c+g]={style:h,text:"",rowSpan:1,colSpan:1});c+=f.colSpan}return e.innerHTML="",i},V.prototype.GS=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,e=[];if(t)if(0<(i=t.getElementsByTagName("table")).length)for(r=this.a5(i[0],!1),o=new RegExp(String.fromCharCode(160),"g"),a=String.fromCharCode(32),u=0,s=r.length;u<s;u++){for(f=0,l=(c=r[u]).length;f<l;f++)0<=(h=c[f]?c[f].text:"").indexOf("\n")&&(h=n?(0<=h.indexOf("\r\n")&&(h=v(h.split("\r\n"),!0)),v(h.split("\n"),!0)):'"'+h+'"'),e.push(h.replace(o,a)),f<l-1&&e.push("\t");u<s-1&&e.push("\r\n")}else e.push(b(t.innerText||t.innerHTML).trim());return e.join("")},V.prototype.c5=function(t){var n,e,n=this,e=n.QS();n.DS&&n.DS.ki(F.Events.ClipboardChanging,{sheet:n.DS,sheetName:n.DS.name(),copyData:{text:e.text,html:e.html},ranges:n._S,cancel:!1,action:I.ClipboardActionType.reset},!0),n.DS=H,n._S=H,n.ES=!1,n.TT=!1,n.jS.ki("ClipboardStatusChanged",{isReset:!0,isSystemPasted:!!t})},V.isPartSpan=function(t,n,e,i){var r,o,a,u,s,c;if(!n.containsRange(t))return!0;for(r=0,o=e;r<o.length;r++)if(a=o[r],t.row<=a&&a<t.row+t.rowCount)return!0;for(u=0,s=i;u<s.length;u++)if(c=s[u],t.col<=c&&c<t.col+t.colCount)return!0;return!1},V.formatClipboardData=function(t){var n,e,i,r,o,a,n=[];if(t){for(i=!(e='"'),r=0;r<t.length;r++)o=0<r?t[r-1]:"",'"'===(a=t[r])?(i=!i,n.push('"')):n.push(i||"\n"!==a||"\r"===o?a:"\r\n");return n.join("")}return""},V.convertHAlign=function(t){var n;return{0:"left",1:"center",2:"right"}[t]},V.convertVAlign=function(t){var n;return{0:"top",1:"middle",2:"bottom"}[t]},V.convertLineBorder=function(t){var n,e,n,e;return{9:.5,1:.5,3:.5,4:.5,7:.5,11:.5,2:1,10:1,12:1,8:1,13:1,5:1.5,6:1.5}[t.style]+"pt "+{0:"none",1:"solid",2:"solid",3:"dashed",4:"dotted",5:"solid",6:"double",7:"dotted",8:"dashed",9:"dashed",10:"dashed",11:"dashed",12:"dashed",13:"dashed"}[t.style]+" "+t.color},V.convertToHAlign=function(t){var n;return{left:0,center:1,right:2}[t]},V.convertToVAlign=function(t){var n;return{top:0,middle:1,bottom:2}[t]},V.convertToLineBorder=function(t,n,e){var i={none:0,solid:1,dashed:3,dotted:4,double:6};return(G.msie||G.edge)&&"2px"===e?i.solid=5:(e=Math.round(10*parseFloat(e)*3/4)/10)<=.8?i.solid=1:e<=1?(i.solid=2,i.dashed=8):e<=1.5&&(i.solid=5),new l.LineBorder(t,i[n])},V.convertToTextDecoration=function(t){var n;return{underline:1,"line-through":2,"underline line-through":3,none:0}[t]},V.isTransparent=function(t){return 0===i.Common.ft._(t).a},V.isBlack=function(t){var t=i.Common.ft._(t);return 0!==t.a&&0===t.r&&0===t.g&&0===t.b},V.getStyleFromDOM=function(t){var n,e,i,r,o,o,o,a,n,u,o,s,c,n,i,n,o,i,n,o,n=t.getElementsByTagName("font")[0],e=getComputedStyle(t),i=t.style,r=new l.Style,o=e.backgroundColor;return o&&!V.isTransparent(o)&&(r.backColor=o),o=e.color,(o=n?n.color:o)&&!V.isBlack(o)&&(r.foreColor=o),n?r.font=f.W.f5(getComputedStyle(n)):(o=f.W.f5(e))&&(o=o.replace(/\/.+?\s/gi," "),r.font=o),"normal"===(a=e.whiteSpace)&&(r.wordWrap=!0),n=e.verticalAlign,o=V.convertToHAlign,s=V.convertToLineBorder,c=V.convertToTextDecoration,n&&(r.vAlign=(u=V.convertToVAlign)(n)),n=i.textAlign,i=e.textAlign,G.msie||G.edge?r.hAlign=o(""!==n?n:"general"):i&&(r.hAlign=o(i)),"none"!==(n=e.borderLeftStyle)&&(r.borderLeft=s(e.borderLeftColor,n,e.borderLeftWidth)),"none"!==(o=e.borderRightStyle)&&(r.borderRight=s(e.borderRightColor,o,e.borderRightWidth)),"none"!==(i=e.borderTopStyle)&&(r.borderTop=s(e.borderTopColor,i,e.borderTopWidth)),"none"!==(n=e.borderBottomStyle)&&(r.borderBottom=s(e.borderBottomColor,n,e.borderBottomWidth)),o=c(e.textDecorationLine||e.textDecoration),0<t.getElementsByTagName("u").length&&(o|=c("underline")),0<t.getElementsByTagName("s").length&&(o|=c("line-through")),0!==o&&(r.textDecoration=o),r},n.yM=V},"./dist/core/worksheet/style.js":function(L,t,n){"use strict";var a,o,u,s,g,c,r,i,n,f,p,l,b,h,d,n,v,m,w,y,M,C,S,e,T,A,B,F,P,G,U,H,I,x,N,k,k,k;function V(t){var n,e,n={};return t&&t.option&&t.option.dataSource?(e=t.option.dataSource,t.option.dataSource=b,(n=p(t)).option.dataSource=e,t.option.dataSource=e):n=p(t),n}function _(t,n,e){this.color=t||"black",this.style=n||0,this.level=e}function z(t){return!(!t||"object"!=typeof t||t.patternColor||t.stops)}function Y(t){return(!t||!t.stops)&&t&&t.type?{type:O(r.PatternType,t.type,b),patternColor:t.patternColor,backgroundColor:t.backgroundColor}:t}function D(t){return t?new I(t.color,O(U,t.style,b)):b}function Z(t){var n,e,e,e;if(t){if(!(e=(n={checkbox:"5",combobox:"7",hyperlink:"8",radioButtonList:"11",checkboxList:"12"})[t.type]))return it(t,!0,void 0);if(e=c.ti[e])return(e=new e).Je(t),e}return t}function W(t){return t?{alignment:O(r.LabelAlignment,t.alignment,b),visibility:O(r.LabelVisibility,t.visibility,b),font:t.font,foreColor:t.foreColor,margin:t.margin}:b}function Q(t){return t?{cornerFold:t.cornerFold,icons:t.icons&&0<t.icons.length?t.icons.map(function(t){return{src:t.src,width:t.width,height:t.height,position:O(r.IconPosition,t.position,b)}}):b}:b}function J(t){return t?t.map(function(t){return{position:O(r.ButtonPosition,t.position,b),useButtonStyle:t.useButtonStyle,enabled:t.enabled,width:t.width,caption:t.caption,imageSrc:t.imageSrc,imageSize:t.imageSize,captionAlign:O(r.CaptionAlignment,t.captionAlign,b),command:t.command,imageType:O(r.ButtonImageType,t.imageType,b),visibility:O(r.ButtonVisibility,t.visibility,b),hoverBackColor:t.hoverBackColor,buttonBackColor:t.buttonBackColor}}):b}function K(t){var n,e,e,e,i,i,e,i;if(t)return n=u.GC$.extend(!0,{},t),e=t.calendarPage,l(e)||(n.calendarPage=O(r.CalendarPage,e)),e=t.startDay,l(e)||(n.startDay=r.CalendarStartDay[e]),(e=t.layout)&&(i=e.direction,l(i)||(n.layout.direction=r.LayoutDirection[i]),i=e.displayAs,l(i)||(n.layout.displayAs=r.LayoutDisplayAs[i])),e=t.valueType,l(e)||(n.valueType=r.DropdownListValue[e]),i=t.direction,l(i)||(n.direction=r.LayoutDirection[i]),n}function X(t){return t?t.map(function(t){return{type:O(r.DropDownType,t.type,b),option:K(t.option),submitCommand:t.submitCommand}}):b}function q(t){var t,t="lineThroughUnderline"===t?r.TextDecorationType.lineThrough|r.TextDecorationType.underline:"lineThroughDoubleUnderline"===t?r.TextDecorationType.lineThrough|r.TextDecorationType.doubleUnderline:O(r.TextDecorationType,t,r.TextDecorationType.none);return t}function $(t){var n,e,i,r,n=p(t.decoration);if(!l(n)&&!l(n.icons))for(n.icons=[],e=t.decoration.icons,i=0;i<e.length;i++)r=e[i],n.icons.push(p(r));return n}function tt(t,n){var e,i,r,o;for(l(t.decoration)&&(t.decoration={}),l(t.decoration.icons)&&(t.decoration.icons=[]),e=t.decoration.icons,i=n.decoration.icons,r=0;r<i.length;r++)o=i[r],e.push(p(o))}function j(e){var i;return e&&e instanceof Object?(i={},Object.keys(e).forEach(function(t){var n=e[t];l(n)||(n instanceof Array?i[t]=JSON.parse(JSON.stringify(n)):n instanceof Object?i[t]=j(n):i[t]=n)}),i):e}function E(){for(var t,n,e,i,r,t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];if((e=this)._id=E.l5,E.l5++,0!==t.length)if(i=t[0],1===t.length&&z(i))e.Je(i);else for(r=0;r<x.length;r++)e[x[r]]=t[r]}function nt(t,n){l(t.applyFill)||(n.applyFill=t.applyFill),l(t.applyFont)||(n.applyFont=t.applyFont),l(t.applyAlignment)||(n.applyAlignment=t.applyAlignment),l(t.applyBorder)||(n.applyBorder=t.applyBorder),l(t.applyProtection)||(n.applyProtection=t.applyProtection),l(t.applyNumberFormat)||(n.applyNumberFormat=t.applyNumberFormat)}function O(t,n,e){var i;if(e=e||b,!l(n)){if(!isNaN(n))return parseInt(n,10);i=t[n]}return l(i)?e:i}function et(t,n,e,i){var n=it(n,e,i);t.cellType=n}function it(t,n,e){var i,r,n,o,n,i=t;if(n&&t){if(r=t.Ke&&t.Ke())return i;t.toJSON&&(t=t.toJSON()),n=c.ti,o=t.typeName,(n=n[t.type]||n[o]||s.getTypeFromString(o))?(i=new n).fromJSON(t,e):i=b}return i}function rt(t,n,e,i){var r,o;if(n===h&&(t.cellButtons=n),n){if(r=n,e)for(r=[],o=0;o<n.length;o++)r.push(p(n[o]));t.cellButtons=r}}function ot(t,n,e,i){var r;n===h&&(t.decoration=n),n&&(r=n,e&&(r=p(n),n.icons)&&0<n.icons.length&&(r.icons=n.icons.map(function(t){return p(t)})),t.decoration=r)}function at(t,n,e,i){var r,o;if(n===h&&(t.dropDowns=n),n){if(r=a([],n,!0),e)for(r=[],o=0;o<n.length;o++)r.push(p(n[o]));t.dropDowns=r}}function ut(t,n,e){var i,e,e,r,r,i=n;e&&n&&"object"==typeof n&&(n.toJSON&&(n=n.toJSON()),e=(e=o.Formatter)&&e.GeneralFormatter)&&((r=n.typeName)?(r=s.getTypeFromString(r))&&(i=new r).fromJSON(n):i=new e(n.formatCached,n.customerCultureName)),t.formatter=i}function st(t,n,e){var i,e,e,i=n;e&&n&&(n.toJSON&&(n=n.toJSON()),e=(e=o.Formatter)&&e.GeneralFormatter)&&((i=new e(n.formatCached,n.customerCultureName)).isAuto=!0),t._autoFormatter=i}function R(t,n,e){(n=n&&t.getColor(n))&&e(n)}function ct(t,n,e){return t===m?2===e||1===e?1===n:3===n:t===w?2===e||1===e?1===n:0===n:t===y?1===n:t===d&&n===b}a=this&&this.__spreadArray||function(t,n,e){if(e||2===arguments.length)for(var i=0,r=n.length,o;i<r;i++)!o&&i in n||((o=o||Array.prototype.slice.call(n,0,i))[i]=n[i]);return t.concat(o||Array.prototype.slice.call(n))},Object.defineProperty(t,"__esModule",{value:!0}),t.Style=t.LineBorder=t.LineBorderComposeLevel=t.LineStyle=void 0,o=n("Common"),u=n("./dist/core/util/domUtil.js"),s=n("./dist/core/util/common.js"),g=n("./dist/core/worksheet/stylehelper.js"),c=n("./dist/core/celltype/celltype.ns.js"),r=n("./dist/core/core.enum.js"),i=u.GC$.each,n=s.mt,f=n.T1,p=o.Common.lt.tv,l=o.Common.lt.ht,d="autoFormatter",n="formatter",v="cellType",m="hAlign",w="vAlign",y="imeMode",M="labelOptions",C="cellButtons",S="dropDowns",e="applyFont",T="applyFill",A="applyAlignment",B="applyBorder",F="applyNumberFormat",P="applyProtection",G={borderLeft:!(h=null),borderRight:!(b=void 0),borderTop:!0,borderBottom:!0,diagonalDown:!0,diagonalUp:!0},(k=U=t.LineStyle||(t.LineStyle={}))[k.empty=0]="empty",k[k.thin=1]="thin",k[k.medium=2]="medium",k[k.dashed=3]="dashed",k[k.dotted=4]="dotted",k[k.thick=5]="thick",k[k.double=6]="double",k[k.hair=7]="hair",k[k.mediumDashed=8]="mediumDashed",k[k.dashDot=9]="dashDot",k[k.mediumDashDot=10]="mediumDashDot",k[k.dashDotDot=11]="dashDotDot",k[k.mediumDashDotDot=12]="mediumDashDotDot",k[k.slantedDashDot=13]="slantedDashDot",(k=H=t.LineBorderComposeLevel||(t.LineBorderComposeLevel={}))[k.conditionalFormat=1]="conditionalFormat",k[k.cell=10]="cell",k[k.table=20]="table",k[k.row=30]="row",k[k.column=40]="column",k[k.sheet=50]="sheet",_.prototype.Gf=function(){return new _(this.color,this.style,this.level)},_.prototype.toJSON=function(){var t,n,e,n,t={},n=this,e=n.color,n=n.style;return"black"!==e&&(t.color=e),t.style=n,t},_.prototype.fromJSON=function(t,n){var e,i,t;t&&(e=this,i=t.color,t=t.style,f(i)&&(e.color=i),f(t))&&(e.style=t)},_.YC=function(t){var n,e,n,e;return{9:1,1:1,3:1,4:1,7:1,11:1,2:2,10:2,12:2,8:2,13:2,5:3,6:3}[t&&t.style]||0},I=_,t.LineBorder=I,x=["backColor","foreColor",m,w,"font","themeFont",n,"borderLeft","borderTop","borderRight","borderBottom","locked","textIndent","wordWrap","showEllipsis","_showTip","shrinkToFit","backgroundImage",v,"backgroundImageLayout","tabStop","textDecoration",y,"name","parentName","watermark","cellPadding",M,"quotePrefix","diagonalDown","diagonalUp","isVerticalText",C,S,"textOrientation","decoration","mask"],N=[e,T,A,B,F,P],E.xp=function(t,n){var e=t.parentName;e&&!n.getNamedStyle(e)&&delete t.parentName},E.prototype.compose=function(t,n,e,i,r){this.h5(t,n,e,i,r)},E.prototype.h5=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,n,o=this,h=t.labelOptions,d=t.cellButtons;if(t.cellButtons&&0<t.cellButtons.length)for(d=[],v=0;v<t.cellButtons.length;v++)d.push(p(t.cellButtons[v]));if(m=t.dropDowns,t.dropDowns&&0<t.dropDowns.length)for(m=[],v=0;v<t.dropDowns.length;v++)m.push(V(t.dropDowns[v]));n?(o._autoFormatter=t._autoFormatter,o.backgroundImage=t.backgroundImage,o.backgroundImageLayout=t.backgroundImageLayout,o.backColor=j(t.backColor),o.foreColor=t.foreColor,o.hAlign=t.hAlign,o.vAlign=t.vAlign,o.font=t.font,o.themeFont=t.themeFont,o.formatter=t.formatter,o.mask=j(t.mask),o.showEllipsis=t.showEllipsis,o.hv=t.hv,a=t.borderLeft,o.borderLeft=a&&a.Gf&&a.Gf()||a,o.borderLeft&&e&&(o.borderLeft.level=e),u=t.borderTop,o.borderTop=u&&u.Gf&&u.Gf()||u,o.borderTop&&e&&(o.borderTop.level=e),s=t.borderRight,o.borderRight=s&&s.Gf&&s.Gf()||s,o.borderRight&&e&&(o.borderRight.level=e),c=t.borderBottom,o.borderBottom=c&&c.Gf&&c.Gf()||c,o.borderBottom&&e&&(o.borderBottom.level=e),f=t.diagonalDown,o.diagonalDown=f&&f.Gf&&f.Gf()||f,o.diagonalDown&&e&&(o.diagonalDown.level=e),l=t.diagonalUp,o.diagonalUp=l&&l.Gf&&l.Gf()||l,o.diagonalUp&&e&&(o.diagonalUp.level=e),o.locked=t.locked,o.textIndent=t.textIndent,o.wordWrap=t.wordWrap,o.shrinkToFit=t.shrinkToFit,o.cellType=t.cellType,o.name=t.name,o.parentName=t.parentName,o.tabStop=t.tabStop,o.textDecoration=t.textDecoration,o.imeMode=t.imeMode,o.watermark=t.watermark,o.cellPadding=t.cellPadding,o.isVerticalText=t.isVerticalText,o.textOrientation=t.textOrientation,h&&(o.labelOptions={alignment:h.alignment,font:h.font,foreColor:h.foreColor,visibility:h.visibility,margin:h.margin}),o.quotePrefix=t.quotePrefix,o.cellButtons=d,o.dropDowns=m,o.decoration=$(t)):(o.backgroundImage===b&&(o.backgroundImage=t.backgroundImage),o.backgroundImageLayout===b&&(o.backgroundImageLayout=t.backgroundImageLayout),o.backColor===b&&(o.backColor=j(t.backColor)),o.foreColor===b&&(o.foreColor=t.foreColor),o.hAlign===b&&(o.hAlign=t.hAlign),o.vAlign===b&&(o.vAlign=t.vAlign),o.themeFont===b&&o.font===b?(o.themeFont=t.themeFont,o.font=t.font):o.themeFont!==b&&o.font===b&&(o.font=t.font),o.formatter===b&&(o.formatter=t.formatter),o.showEllipsis===b&&(o.showEllipsis=t.showEllipsis),o.hv===b&&(o.hv=t.hv),o._autoFormatter===b&&(o._autoFormatter=t._autoFormatter),o.mask===b&&(o.mask=j(t.mask)),o.borderLeft===b&&(a=t.borderLeft,o.borderLeft=a&&a.Gf&&a.Gf()||a,o.borderLeft)&&e&&(o.borderLeft.level=e),o.borderTop===b&&(u=t.borderTop,o.borderTop=u&&u.Gf&&u.Gf()||u,o.borderTop)&&e&&(o.borderTop.level=e),o.borderRight===b&&(s=t.borderRight,o.borderRight=s&&s.Gf&&s.Gf()||s,o.borderRight)&&e&&(o.borderRight.level=e),o.borderBottom===b&&(c=t.borderBottom,o.borderBottom=c&&c.Gf&&c.Gf()||c,o.borderBottom)&&e&&(o.borderBottom.level=e),o.diagonalDown===b&&(f=t.diagonalDown,o.diagonalDown=f&&f.Gf&&f.Gf()||f,o.diagonalDown)&&e&&(o.diagonalDown.level=e),o.diagonalUp===b&&(l=t.diagonalUp,o.diagonalUp=l&&l.Gf&&l.Gf()||l,o.diagonalUp)&&e&&(o.diagonalUp.level=e),o.locked===b&&(o.locked=t.locked),o.textIndent===b&&(o.textIndent=t.textIndent),o.wordWrap===b&&(o.wordWrap=t.wordWrap),o.shrinkToFit===b&&(o.shrinkToFit=t.shrinkToFit),o.cellType===b&&(o.cellType=t.cellType),o.tabStop===b&&(o.tabStop=t.tabStop),o.textDecoration===b&&(o.textDecoration=t.textDecoration),o.imeMode===b&&(o.imeMode=t.imeMode),o.name===b&&(o.name=t.name),o.parentName===b&&(o.parentName=t.parentName),o.watermark===b&&(o.watermark=t.watermark),o.cellPadding===b&&(o.cellPadding=t.cellPadding),!o.labelOptions&&h&&(o.labelOptions={}),(n=o.labelOptions)&&h&&(n.alignment===b&&(n.alignment=h.alignment),n.font===b&&(n.font=h.font),n.foreColor===b&&(n.foreColor=h.foreColor),n.visibility===b&&(n.visibility=h.visibility),n.margin===b)&&(n.margin=h.margin),i||o.quotePrefix!==b||(o.quotePrefix=t.quotePrefix),o.isVerticalText===b&&(o.isVerticalText=t.isVerticalText),o.textOrientation===b&&(o.textOrientation=t.textOrientation),o.cellButtons===b&&(o.cellButtons=d),o.dropDowns===b&&(o.dropDowns=m),o.decoration===b?o.decoration=$(t):r&&g.W.Xue(t)&&tt(o,t))},E.prototype.d5=function(t){var e=this;0===arguments.length?(i(x,function(t,n){e[n]=b}),i(N,function(t,n){f(e[n])&&(e[n]=b)})):e[t]=b},E.prototype.clone=function(t){var n,e,i,r,o,a,u,s,n=this,e=n.borderLeft,i=n.borderTop,r=n.borderRight,o=n.borderBottom,a=n.diagonalDown,u=n.diagonalUp,s=new E;return s.backColor=j(n.backColor),s.foreColor=n.foreColor,s.hAlign=n.hAlign,s.vAlign=n.vAlign,s.font=n.font,s.themeFont=n.themeFont,s.formatter=b,s.mask=j(n.mask),s.borderLeft=e&&!t&&e.Gf()||e,s.borderTop=i&&!t&&i.Gf()||i,s.borderRight=r&&!t&&r.Gf()||r,s.borderBottom=o&&!t&&o.Gf()||o,s.locked=n.locked,s.textIndent=n.textIndent,s.wordWrap=n.wordWrap,s.shrinkToFit=n.shrinkToFit,s.backgroundImage=n.backgroundImage,s.cellType=b,s.backgroundImageLayout=n.backgroundImageLayout,s.tabStop=n.tabStop,s.textDecoration=n.textDecoration,s.imeMode=n.imeMode,s.name=n.name,s.parentName=n.parentName,s.watermark=n.watermark,s.cellPadding=n.cellPadding,s.labelOptions=n.labelOptions,s.quotePrefix=n.quotePrefix,s.diagonalDown=a&&!t&&a.Gf()||a,s.diagonalUp=u&&!t&&u.Gf()||u,s.isVerticalText=n.isVerticalText,s.showEllipsis=n.showEllipsis,s.hv=n.hv,s.textOrientation=n.textOrientation,ot(s,n.decoration,!t,!0),nt(n,s),ut(s,n.formatter,!t),st(s,n._autoFormatter,!t),et(s,n.cellType,!t,!0),rt(s,n.cellButtons,!t,!0),at(s,n.dropDowns,!t,!0),s},E.prototype.v5=function(i){var n,e,t,r,o,a,u,s,c,n=this;if(i&&i.getColor){if(R(i,n.foreColor,function(t){n.foreColor=t}),"string"==typeof(e=n.backColor))R(i,e,function(t){n.backColor=t});else if(e&&(e.backgroundColor&&R(i,e.backgroundColor,function(t){e.backgroundColor=t}),e.patternColor&&R(i,e.patternColor,function(t){e.patternColor=t}),e.stops))for(t=function(n){R(i,e.stops[n].color,function(t){e.stops[n].color=t})},r=0;r<e.stops.length;r++)t(r);for(a=function(t,n){var e=o[t];e&&e.color&&R(i,e.color,function(t){e.color=t})},r=0,u=(o=[n.borderLeft,n.borderTop,n.borderRight,n.borderBottom,n.diagonalDown,n.diagonalUp]).length;r<u;r++)a(r,u)}return s=n.themeFont,c=n.font,i&&i.getFont&&(s?n.font=g.W.m5(c,i.getFont(s)):c||(n.font=g.W.m5(c,i.bodyFont()))),n},E.prototype.g5=function(t){var n,e,e,n=this,e=n._autoFormatter;e&&t!==h&&((e=e.getPreferredEditingFormatter(t)).isAuto=!0,n._autoFormatter=e)},E.prototype.toJSON=function(t,n){var e,i,r,o,a,e=this,i={},r=e._autoFormatter;for(!f(r)||n&&ct(d,r,t)||(r.toJSON&&(r=r.toJSON()),u.GC$.isEmptyObject(r))||(i[d]=r),o=0;o<x.length;o++)r=e[a=x[o]],a!==M||u.GC$.isEmptyObject(r)?a!==S&&a!==C||u.GC$.isEmptyObject(r)?!f(r)||n&&ct(a,r,t)||(i[a]=r&&r.toJSON?r.toJSON():r):i[a]=r:i[M]=r;for(o=0;o<N.length;o++)r=e[a=N[o]],f(r)&&(i[a]=r);return u.GC$.isEmptyObject(i)?b:i},E.prototype.fromJSON=function(t,n,e){var i,r,o,a,a;if(t)for(r in i=this,t)t.hasOwnProperty(r)&&(o=t[r],f(o))&&((a={p:r,v:o,r:!1}).noSchema=n,a.context=e,E.et(i,"fromJson",a),a.r||("formatter"===r?ut(i,o,!0):"autoFormatter"===r?st(i,o,!0):r===v?et(i,o,!0,n):G[r]?o===h?i[r]=null:((a=new I).fromJSON(o,n),i[r]=a):i[r]=o))},E.prototype.Je=function(t){var n=this;n.backColor=Y(t.backColor),n.foreColor=t.foreColor,n.hAlign=O(r.HorizontalAlign,t.hAlign,b),n.vAlign=O(r.VerticalAlign,t.vAlign,b),n.font=t.font,n.themeFont=t.themeFont,n.formatter=t.formatter,n.borderLeft=D(t.borderLeft),n.borderTop=D(t.borderTop),n.borderRight=D(t.borderRight),n.borderBottom=D(t.borderBottom),n.diagonalDown=D(t.diagonalDown),n.diagonalUp=D(t.diagonalUp),n.locked=t.locked,n.textIndent=t.textIndent,n.wordWrap=t.wordWrap,n.shrinkToFit=t.shrinkToFit,n.backgroundImage=t.backgroundImage,n.cellType=Z(t.cellType),n.backgroundImageLayout=O(r.ImageLayout,t.backgroundImageLayout,b),n.tabStop=t.tabStop,n.textDecoration=q(t.textDecoration),n.imeMode=O(r.ImeMode,t.imeMode,b),n.name=t.name,n.parentName=t.parentName,n.watermark=t.watermark,n.cellPadding=t.cellPadding,n.labelOptions=W(t.labelOptions),n.isVerticalText=t.isVerticalText,n.textOrientation=t.textOrientation,n.showEllipsis=t.showEllipsis,n.cellButtons=J(t.cellButtons),n.dropDowns=X(t.dropDowns),n.decoration=Q(t.decoration),nt(t,n)},k=E,t.Style=k,s.$e(k),k.l5=0},"./dist/core/worksheet/stylehelper.js":function(t,o,n){"use strict";var a,h,i,d,v,e,r,u,m,g,p,b,w,y,M,C,S,s;function c(t){return t=v(t=t||0,0),t=e(t,1)}function T(){}Object.defineProperty(o,"__esModule",{value:!0}),o.W=o.p5=void 0,a=n("./dist/core/util/domUtil.js"),h=n("./dist/core/util/common.js"),i=n("./dist/core/core.enum.js"),d=document,v=Math.max,e=Math.min,r=void 0,u=null,m="#FFFFFF",g="#000000",p=Math.abs,b=Math.PI,w=Math.cos,y=Math.sin,M=Math.atan,C=Math.tan,o.p5="11pt",S={1:[[1]],2:[[1,0,1,1],[1,1,1,0]],3:[[0,1],[1,0]],4:[[0,0,1,0],[1,0,0,0]],5:[[0,0,0,0],[0,0,1,0],[0,0,0,0],[1,0,0,0]],6:[[0,0,0,0,0,0,0,0],[1,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0],[0,0,0,0,1,0,0,0]],7:[[0],[1],[1],[0]],8:[[1,1,0,0]],9:[[0,1,1,0],[0,0,1,1],[1,0,0,1],[1,1,0,0]],10:[[0,1,1,0],[1,1,0,0],[1,0,0,1],[0,0,1,1]],11:[[0,0,1,1],[0,0,1,1],[1,1,0,0],[1,1,0,0]],12:[[0,1,1,0],[1,1,1,1],[1,0,0,1],[1,1,1,1]],13:[[0],[1],[0],[0]],14:[[1,0,0,0]],15:[[0,1,0,0],[0,0,1,0],[0,0,0,1],[1,0,0,0]],16:[[0,0,1,0],[0,1,0,0],[1,0,0,0],[0,0,0,1]],17:[[0,0,1,0],[1,1,1,1],[0,0,1,0],[0,0,1,0]],18:[[1,0,1,0],[0,0,0,1],[1,0,1,0],[0,1,0,0]]},T.m5=function(t,n){return n?T.b5(t,n):t},T.Ne=function(t){var n,t;return t?((n=T.y5()).style.font=t,{fontFamily:(t=n.style).fontFamily,fontSize:t.fontSize,fontStyle:t.fontStyle,fontWeight:t.fontWeight}):{}},T.f5=function(t){var n,e,i,r,o,a,u,s,c,f,l;return h.mt.Tt.safari?t.font:(n="",e="normal",a=t.fontStyle,u=t.fontVariant,s=t.fontWeight,c=t.lineHeight,a&&a!==e&&(n=a),u&&u!==e&&(n+=(n?" ":"")+u),s&&s!==e&&s!==(i="400")&&(n+=(n?" ":"")+s),n+=(n?" ":"")+(f=(f=t.fontSize)||(r="11pt")),c&&c!==e&&(n+="/"+c),n+(" "+(l=(l=t.fontFamily)||(o="Calibri"))))},T.b5=function(t,n){var e,i,r,t,n;if(!t&&!n)return t;if(t){if(r=T.w5[i=n?t+"+"+n:t])return r;e=T.y5(),(0,a.GC$)(e).css("font",t)}else{if(r=T.w5[i=n])return r;e=T.y5(),(0,a.GC$)(e).css("fontSize",o.p5)}return n&&(0,a.GC$)(e).css("fontFamily",n),t=e.currentStyle,(n=d.defaultView)&&n.getComputedStyle&&(t=n.getComputedStyle(e,"")),r=T.f5(t),T.w5[i]=r,T.w5[r]=r},T.V=function(t,n,e,i){var r,o,a,u,s,s,c,f,e,l,r=T.C5[n];if(!i)if(r){if(o=r[t])return o}else r=T.C5[n]={};return(a=T.y5()).style.font=t,u=a.currentStyle,-1!==(s=(u=(s=d.defaultView)&&s.getComputedStyle?s.getComputedStyle(a,""):u).fontSize).indexOf(c="px")&&(f=v(1,parseFloat(s.replace(c,""))*n),e&&1===f&&(e.value=!0),s=f+c),-1!==(e=u.lineHeight).indexOf(c)&&(e=(l=v(1,parseFloat(e.replace(c,""))*n))+c),o=1===n?{font:t,fontFamily:a.style.fontFamily,fontSize:f}:(a.style.fontSize=s,a.style.lineHeight=e,{font:a.style.font,fontFamily:a.style.fontFamily,fontSize:f}),i||(r[t]=o),o},T.y5=function(){var t,n,e;return T.S5?T.S5.style.cssText=T.T5:(t="-10000px",(e=(n=h.mt.En("span")).style).visibility="hidden",e.top=t,e.left=t,e.lineHeight="normal",e.position="absolute",e.fontWeight="normal",e.fontStretch="normal",e.fontVariant="normal",e.fontStyle="normal",d.body.insertBefore(n,null),T.S5=n,T.T5=e.cssText),T.S5},T.L0=function(){var t=T.S5;t&&((0,a.GC$)(t).remove(),T.S5=r,T.T5=r)},T.stringFontCatch={},T.ii=function(t,n){var e,i,r,o,e=t+","+n,i=T.stringFontCatch,r=i[e];return r||((o=T.y5()).style.font=t,n&&(o.style.fontWeight=n),r=i[e]=o.style.font),r},T.w5={},T.C5={},T.A5=function(t){var n;return t<=0?"none":(n="",(1|t)===t&&(n+="underline "),(2|t)===t&&(n+="line-through "),(4|t)===t&&(n+="overline "),n.trim())},T.setFillStyle=function(t,n,e,i,r,o,a){"string"==typeof n?(t.fillStyle!==n&&(t.fillStyle=n),a()):"path"===n.type?T.setFillStylePath(t,n,e,i,r,o,a):n.stops?T.setFillStyleGradient(t,n,e,i,r,o,a):n.type&&T.setFillStylepatternFill(t,n,e,i,r,o,a)},T.setFillStylepatternFill=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,n,u=S[n.type],s=u.length,c=u[0].length,f=document.createElement("canvas");for(f.width=c,f.height=s,(l=f.getContext("2d")).fillStyle=n.backgroundColor||m,l.fillRect(0,0,c,s),l.fillStyle=n.patternColor||g,h=0;h<s;h++)for(d=0;d<c;d++)(v=u[h][d])&&l.fillRect(d,h,1,1);t.createPattern(f,"repeat"),n=t.createPattern(f,"repeat"),t.fillStyle=n,a()},T.processStops=function(t){var n,e;if(t.stops||"path"===t.type){if(n=t.stops)if(0===n.length)n=[{position:0,color:g},{position:1,color:g}];else{for((n=n.filter(function(t,n,e){return t.position<=1&&0<=t.position})).sort(function(t,n){return t.position-n.position}),e=0;e<n.length;e++)n[e].color=n[e].color||g;0!==n[0].position&&n.splice(0,0,{position:0,color:g}),1!==n[n.length-1].position&&n.push({position:1,color:g})}else n=[{position:0,color:m},{position:1,color:m}];t.stops=n}"path"===t.type?(t.left=c(t.left),t.right=c(t.right),t.top=c(t.top),t.bottom=c(t.bottom)):t.stops&&(delete t.type,t.degree=t.degree||0)},T.setFillStyleGradient=function(t,n,e,i,r,o,a){var u,s,c,f,u,l,h,d,u=n.degree||0;for(u%90==0?(c=u/180*b,f=p(u%180/180*b)-M(o/r)):(c=M(r/o*C(u/180*b)),f=p(c)-M(o/r),c=Math.round(u/180)*b+c),u=Math.sqrt(r*r+o*o)/2,s=t.createLinearGradient(e+r/2-u*w(f)*w(c),i+o/2-u*w(f)*y(c),e+r/2+u*w(f)*w(c),i+o/2+u*w(f)*y(c)),h=0,d=(l=n.stops).length;h<d;h++)s.addColorStop(l[h].position,l[h].color||m);t.fillStyle=s,a()},T.setFillStylePath=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,u=n.left||0,s=n.right||0,c=n.top||0,f=n.bottom||0,l=n.stops;if(s<u&&(s=u),f<c&&(f=c),0<u){for(t.save(),t.beginPath(),h=t.createLinearGradient(e+r*u,0,e,0),d=0,v=l.length;d<v;d++)h.addColorStop(l[d].position,l[d].color||m);t.fillStyle=h,t.moveTo(e,i-1),t.lineTo(e+r*u+1,i+o*c),t.lineTo(e+r*u+1,i+o*f),t.lineTo(e,i+o+1),t.clip(),a(),t.restore()}if(s<1){for(t.save(),t.beginPath(),h=t.createLinearGradient(e+r*s,0,e+r,0),d=0,v=l.length;d<v;d++)h.addColorStop(l[d].position,l[d].color||m);t.fillStyle=h,t.moveTo(e+r,i-1),t.lineTo(e+r,i+o+1),t.lineTo(e+r*s-1,i+o*f),t.lineTo(e+r*s-1,i+o*c),t.clip(),a(),t.restore()}if(0<c){for(t.save(),t.beginPath(),h=t.createLinearGradient(0,i+o*c,0,i),d=0,v=l.length;d<v;d++)h.addColorStop(l[d].position,l[d].color||m);t.fillStyle=h,t.moveTo(e,i),t.lineTo(e+r,i),t.lineTo(e+r*s,i+o*c+1),t.lineTo(e+r*u,i+o*c+1),t.clip(),a(),t.restore()}if(f<1){for(t.save(),t.beginPath(),h=t.createLinearGradient(0,i+o*f,0,i+o),d=0,v=l.length;d<v;d++)h.addColorStop(l[d].position,l[d].color||m);t.fillStyle=h,t.moveTo(e+r,i+o),t.lineTo(e,i+o),t.lineTo(e+r*u,i+o*f-1),t.lineTo(e+r*s,i+o*f-1),t.clip(),a(),t.restore()}u<s&&c<f&&(t.save(),t.beginPath(),t.fillStyle=l[0].color,t.rect(e+r*u,i+o*c,r*(s-u),o*(f-c)),t.clip(),a(),t.restore())},T.Xue=function(t){return t&&t.decoration&&t.decoration.icons&&0<t.decoration.icons.length},T.gfe=function(t,n){var e=n===i.IconPosition.left;return T.Xue(t)&&t.decoration.icons.some(function(t){return e?t.position===i.IconPosition.left||t.position===u||t.position===r:t.position===n})},T.Jue=function(t){return T.Xue(t)&&t.decoration.icons.some(function(t){return T.Kue(t)})},T.Kue=function(t){return t.position===u||t.position===r||t.position===i.IconPosition.left||t.position===i.IconPosition.leftOfText||t.position===i.IconPosition.right||t.position===i.IconPosition.rightOfText},o.W=T},"./dist/core/worksheet/worksheet-actions.js":function(l,h,t){"use strict";var n,e,L,y,T,tt,H,d,nt,b,B,A,v,I,F,et,V,m,x,g,w,N,k,_,S,p,d,it,rt,ot,P,D,z,j,E,O,Y,Z,R,W,t,at,ut,Q,J,K,X,q,$,mt,gt,pt,bt,wt,yt,Mt,Ct,St,Tt,At,It,xt,Nt,kt,_t,Dt,jt,Et,Ot,Rt,Lt,Bt,Ft,Pt,Gt,Ut,Ht,Vt,zt,Yt,Zt,Wt,Qt,Jt,Kt,Xt,qt,$t,tn,nn,en,rn,on,an,un,sn,cn,fn,ln,hn,dn,vn,mn,u,gn,pn,e,bn,wn,yn,Mn,Cn,Sn,Tn,An,In,xn,Nn,kn,_n,Dn,jn,En,On,Rn,Ln,Bn,Fn,Pn,Gn,Un,Hn,Vn,zn;function st(t,n){return t.getRowCount(n)}function ct(t,n){return t.getColumnCount(n)}function ft(t){return t.rowCount}function lt(t){return t.colCount}function Yn(t){var t=t.parent;return t&&t.options.allowExtendPasteRange}function G(t){var t=t.parent;return t&&t.options.allowCopyPasteExcelStyle}function U(t){var t=t.parent;return t&&t.options.copyPasteHeaderOptions}function Zn(t){return(t&nt.CopyToOptions.style)<=0}function Wn(t,n){return n===nt.ClipboardPasteOptions.formatting&&t.options.protectionOptions.formatCells}function Qn(t,n,e,i){throw new Error(m.I5(at().Exp_InvalidAndSpace,[t,n,e,i]))}function Jn(t){t.suspendPaint()}function ht(t){t.resumePaint()}function Kn(t){t.suspendEvent()}function dt(t){t.resumeEvent()}function Xn(t,n){t&&F&&t.suspendCalcService(n)}function qn(t,n){t&&F&&t.resumeCalcService(n)}function $n(t,n,e,i,r){var i=t.getSpan(n,e,i);return!(!(i&&r&&t.getRowVisible(i.row)&&t.getColumnVisible(i.col))||i.row===n&&i.col===e)}function te(t){var n=this;n.x5=1==(1&t),n.N5=2==(2&t),n.k5=8==(8&t),n.D5=F&&16==(16&t),n._5=!0,n.E5=!0}function ne(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,r,r;if(et(t)||""===t)return rt;for(!et(n)&&""!==n||(n="\r\n"),a="\n",!et(e)&&""!==e||(e="\t"),!et(i)&&""!==i||(i='"'),x(t,n)||(t+=n),u=!r,s=[],f="",h=!(c=[]),d=i.length,v=n.length,m=a.length,g=e.length,p=t.length,b=0;b<p;b++)l=(f+=t[b]).length,u&&(l===d&&i===f||d<l&&i===f.substr(l-d,d))?h&&b+1+d<=p&&i===t.substr(b+1,d)?b+=d:h?(f=f.substr(0,l-d),h=!1):0===f.indexOf(i)&&(f=f.substr(0,l-d),h=!0):!h&&(l===g&&e===f||g<l&&e===f.substr(l-g,g))?(f=f.substr(0,l-g),c.push(f),f=""):!h&&(l===v&&n===f||v<l&&n===f.substr(l-v,v))?(f=f.substr(0,l-v),c.push(f),s.push(c),c=[],f=""):!h&&(l===m&&a===f||m<l&&a===f.substr(l-m,m))?(f=f.substr(0,l-m),c.push(f),s.push(c),c=[],f=""):h&&b+1+g<=p&&e===t.substr(b+1,g)&&","!==e&&(b+=d);if(h){if(0<c.length){for(y=void 0,y=0;y<s.length&&s[y]!==c;y++);s.length<=y&&s.push(c)}(r=f.toString())&&(r=r.replace(new RegExp(e,"g"),""),x(r,n)&&(r=r.substr(0,r.length-v)),0===s.length)&&s.push([r])}return 0===s.length&&(x(r=t,n)&&(r=r.substr(0,r.length-v)),s.push([r])),o&&ee(s)&&/^(\s)*$/.test(t)&&t.substr(t.length-m,m)===a&&s.push([""]),s}function ee(t){var n,e;if(t){for(n=0;n<t.length&&((e=t[n])&&1===e.length);n++);if(n===t.length)return 1}}function ie(t,n,e,i,r){var o,a,u,s,c,r,f,l,h,d,v,o=i.length,a=ae(i);if(0!==o&&0!==a)for(u=new te(r),t&&(ct(t,2)<=0&&(u.x5=!1),st(t,1)<=0)&&(u.N5=!1),(a-=s=u.x5?ct(t,2):0)<=(r=0)&&(a=0),(o=(o-=c=u.N5?st(t,1):0)-(r=o<=0?0:r))<=0&&(o=0),u._5&&n+o>st(t)&&t.setRowCount(n+o),u.E5&&e+a>ct(t)&&t.setColumnCount(e+a),f={},h=l=0;l<i.length;l++,h++)d=i[l],v=t.o5(),d.length<=0||(0<c&&l<c?re(t,d,h,e,a,1,u,f):0<o&&h<st(t)&&(re(t,d,h=l===c?n:h,0,s,2,u,f),d.splice(0,s),v&&(h=t.j5(h-1,3)),re(t,d,h,e,a,3,u,f,v)))}function re(t,n,e,i,r,o,a,u,s){for(var c,f,l,c=ct(t,o),f=0,l=i;f<n.length;f++,l++)0<r&&l<c&&(s&&(l=t.O5(l-1,3)),oe(t,o,e,l,n[f],a,u))}function oe(n,e,i,r,o,t,a){var u,s,c,f,l,l,a,f,t,h,c,u=o,s=rt;if(!1===t.k5&&(c={value:rt},l=a[f=o.toString()],!et(o)&&l?(u=l.setValue,s=l.formatter):(u=tt.mt.Xf(rt,o,!t.k5,c),s=c.value,et(o)||(a[f]={setValue:u,formatter:s}))),et(u))n.setValue(i,r,u,e);else if(""!==o)if(t.D5&&"="===o[0]&&1<o.length)try{n.setFormula(i,r,o.substr(1))}catch(t){n.setText(i,r,o,e)}else l=n.l0(i,r,"formatter",e),!1===t.k5&&s?l?(c=(l="string"==typeof l&&L.Formatter?new L.Formatter.GeneralFormatter(l):l).parse&&l.parse(o),u=et(c)?u:c):(s.isAuto=!0,n.getCell(i,r,e).R5("_autoFormatter",s),a=void 0,f=n.getCellType(i,r,e),t=s.formatString(),f&&"7"===f.typeName&&(a=f.parse(o,t,h={sheet:n,row:i,col:r,sheetArea:e}),u=et(a)?o:a)):l&&n.getCell(i,r,e).formatter(rt),n.setValue(i,r,u,e);else n.setValue(i,r,rt,e)}function ae(t){for(var n,e,i,n=0,e=0;e<(t&&t.length);e++)i=t[e],n=P(i.length,n);return n}function ue(t,n,e,i,r,o,a,u,s,c){if(!t)throw new Error(at().Exp_SheetIsNull);var i;(n<-1||n>=st(t))&&Qn("row",n,"-1",st(t)-1),(e<-1||e>=ct(t))&&Qn("column",e,"-1",ct(t)-1),et(i)||""===i||(-1===n&&(n=0),-1===e&&(e=0),(i=ne(i,r,o,a,s,c))&&0<i.length&&ie(t,n,e,i,u))}function se(t,n,e,i,r,o,a,u,s,c,f,l,h,d){var v,m,v,m,g,p,b,w,y,M,p,n,C;if(t)return v=st(t),m=ct(t),(n<-1||v<=n)&&Qn("row",n,"-1",v-1),(e<-1||v<n+e)&&Qn("rowCount",e,"-1",v-n),(i<-1||m<=i)&&Qn("column",i,"-1",m-1),(r<-1||m<i+r)&&Qn("columnCount",r,"-1",m-i),p=g=!(m=v=-1),m=-1===n&&-1===i&&-1===e&&-1===r?(i=n=0,v=(e=st(t))-1,(r=ct(t))-1):(-1===n&&(n=0,2==(2&U(t)))&&(g=!0),-1===i&&(i=0,1==(1&U(t)))&&(p=!0),v=n+(e=-1===e?st(t)-n:e)-1,i+(r=-1===r?ct(t)-i:r)-1),y=w=null,M=he(t,n,v,i,m,3,c,f,o=!et(o)&&""!==o?o:"\r\n",a=!et(a)&&""!==a?a:"\t",u=!et(u)&&""!==u?u:'"',b=new RegExp(u,"g"),s,l,h,d),p&&(p=t.getColumnCount(2),w=he(t,n,v,0,p-1,2,c,f,o,a,u,b,s,l,h,d)),g&&(n=t.getRowCount(1),y=he(t,0,n-1,i,m,1,c,f,o,a,u,b,s,l,h,d)),ce(M,w,y,o,a,C=l&&4e3<e*r&&(S.safari||S.mozilla||tt.mt.Qf()&&S.chrome));throw new Error(at().Exp_SheetIsNull)}function ce(t,n,e,i,r,o){var a,u,s,n,c,a=t,u=0,s=function(t,n){for(var e,i,r,e=[],i=t.length,r=0;r<i;r++)e.push(t[r].concat(n[r]));return e};return n&&(u=n[0].length,a=s(n,t)),e&&(n=e.length,c=null,a=(e=u?s(c=he(null,0,n-1,0,u-1,null,[],[],i,r,null,null,null,!1,!1),e):e).concat(a)),o&&fe(a),le(a,i,r)}function fe(t){for(var n,e,n=t.length,e=t.length-1;0<=e&&-1===t[e].join("").search(/\S+/);e--)n=e;t.length=n}function le(t,n,e){for(var i,r,o,a,o="",a=t.length,i=0;i<a;i++){for(r=0;r<t[i].length;r++)0!==r&&(o+=e),o+=t[i][r];o+=n}return o}function he(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m){for(var g,p,b,w,y,M,g=[],w=t&&G(t),p=n;p<=e;p++)if(!a||!V(a,p)){for(y=[],b=i;b<=r;b++)u&&V(u,b)||(M="",M=de(M=t&&!$n(t,p,b,o,d)&&(M=t.getText(p,b,o),m)&&w?M&&(" "!==M[0]&&" "!==M[M.length-1]||"number"!=typeof t.getValue(p,b,o)?M.replace(/[\r\n]+/g,"\n"):M.trim()):M,d,w,l,f,v,h,c,s),y.push(M));g.push(y)}return g}function de(t,n,e,i,r,o,a,u,s){var c="";return et(t)||(c=t,n&&e)||(c=c.replace(i,r+r)),o&&!c&&(c=" "),n&&e?c=c.replace(/\n/g," "):!a&&-1===c.indexOf(r)&&-1===c.indexOf(u)&&-1===c.indexOf(s)&&-1===c.indexOf("\n")||(c=r+c+r),c}function ve(t,n,e,i,r,o){var a,u,s,c,f,l,h,a=rt,u=ne(t,n,e,i,r,o);if(u){for(s=u.length,c=ae(u),f=[],l=0;l<s;l++)for(f[l]=[],h=0;h<c;h++)h<u[l].length?f[l][h]=u[l][h]:f[l][h]=rt;a=f}return a}function me(n,t){var e=[];return t.forEach(function(t){var t=ge(n,t);t&&e.push(t)}),e}function ge(t,n){var e,i,r,t,o,a,u,n,s,e,o,i,a,e=t.row,i=t.col,r=t.row+t.rowCount,t=t.col+t.colCount,o=n.row,a=n.col,u=n.row+n.rowCount,n=n.col+n.colCount,s;return P(e,o)<=D(r,u)&&P(i,a)<=D(t,n)&&(e=P(e,o),o=P(i,a),i=D(r,u)-e,a=D(t,n)-o,new tt.Range(e,o,i,a))}function s(t,n){if(t.sheets){var n=(0,tt._f)(t,n.sheetName);if(n)return n}return t}function o(t,n,e,i){var t,n,t=s(t,e),n=new n(t,e,i);return i?n.undo(t):n.execute(t)}function pe(t){var e=t;return function(t,n){var t=s(t,n);return ut.B5(t,e)}}function i(t,n){var e,i,e=t,i=n;return function(t,n){var t=s(t,n);return ut.L5(t,e,i)}}function be(t,n){var t,e,i,r,n,t=t.parent;t&&(e=t.getSheetCount(),r=i=void 0,i=r=t.getActiveSheetIndex(),n?r<e-1&&r++:0<r&&r--,i!==r)&&(n=t.getActiveSheet(),t.tb(r,1),t.a3(n),t.repaint())}function we(t,n,e,i){t.F5=!0,ye(t)?t.P5(n):t.G5(n,e,void 0,void 0,i),t.F5=!1}function ye(t){var n,e,n=t.Ut.getSelections().length;return 1<n||!(!((e=t.U5())&&0<n)||t.ui===e.row&&t.ci===e.col&&t.H5>=ft(e)&&t.z5>=lt(e))}function Me(t,n){var e,e,t,n;return!!t.endEdit()&&((e=t.rt).V5(),e.Y5(),tt.hi.F1(rt),e=!1,(t=t.parent)&&((n=n.call(t))&&n.focus?(n.focus(),e=!0):t.vC()),{ignoreCancelDefault:!e})}function r(t,n,e){var i=this;i.Mf=t,i.Z5=n,i.W5=e,i.Q5=[],i.K5=[],i.J5()}function Ce(n,t){var e,i,e=[];return"string"==typeof t?(i=(0,tt._f)(n,t))&&e.push(i):Array.isArray(t)&&t.forEach(function(t){var t=(0,tt._f)(n,t);t&&e.push(t)}),e}function Se(t){return t instanceof T.Worksheet?t:t.Mf instanceof T.Worksheet?t.Mf:void 0}function M(t,n){Jn(t),n||Kn(t)}function C(t,n){n||dt(t),ht(t)}function Te(t,n){this.X5=M,this.q5=C;var e=this;e.Mf=t,e.tT=n}function Ae(t,n){et(t.Tb)&&(t.Tb=n.Tb,t.Ab=n.Ab)}function Ie(t,n){var e=jn.call(this,t,n)||this;return Ae(n,t),e}function xe(t,n){var e=En.call(this,t,n)||this;return Ae(n,t),e}function Ne(t,n){var e,i,e=On.call(this)||this,i=e;return i.Mf=t,i.tT=n,e}function ke(t,n){var e,i,e=Rn.call(this)||this,i=e;return i.Mf=t,i.tT=n,e}function a(t,n){var e,i,t,e=Ln.call(this,t,n)||this,i=e,t=t.parent;return i.nT=n.rowHeader?2:3,p(n.autoFitType)||(n.autoFitType=t?t.options.autoFitType:0),e}function c(t,n){var e,i,t,e=Bn.call(this,t,n)||this,i=e,t=t.parent;return i.nT=n.columnHeader?1:3,p(n.autoFitType)||(n.autoFitType=t?t.options.autoFitType:0),e}function _e(t,n){"value"===n.propertyName&&t.eT(n.row,n.col,n.oldValue,n.newValue)}function f(t,n){var e,i,t,e=Fn.call(this,t,n)||this;return F&&n.ranges&&1===n.endEditType&&(i=t.JS(n.ranges[0]),1===ft(n.ranges[0]=i))&&1===lt(i)&&(t=t.iT(i.row,i.col,1,1))&&t.ranges&&0<t.ranges.length&&(n.ranges=[t.ranges[0]]),e}function De(t){var t=t.parent,t=t&&t.w2;t&&t.repaint()}function je(t,i){t&&t.forEach(function(t){var n,e,n=t.w3.getFormula(t.row,t.column),e=t.w3.sT(t.row,t.column);t.w3.rT.setFormula(t.row,t.column,n,e,i)})}function Ee(t,n){return Pn.call(this,t,n)||this}function Oe(t,n){return Gn.call(this,t,n)||this}function Re(t,n){return!(!0===t.isEditing()&&!t.endEdit()||(t.suspendPaint(),t.zoom(n),t.resumePaint(),0))}function Le(t,n){return t.tables&&t.tables.Uue(n)}function Be(t,n){for(var e,i,e=n.row;e<n.row+n.rowCount;e++)for(i=n.col;i<n.col+n.colCount;i++)if(!et(t.getValue(e,i)))return;return 1}function Fe(t,n){return-1!==t.col&&-1!==t.colCount&&t.colCount!==n}function Pe(t,n){return-1===t.row||-1===t.rowCount||t.rowCount===n}function Ge(t,n,e,i,r){if(!(t<=r.row&&n<=r.col&&t+e>=r.row+r.rowCount&&n+i>=r.col+r.colCount||r.col>n+i||r.col+r.colCount-1<n||r.col>n+i-1||r.col+r.colCount-1<n||r.row+r.rowCount-1<t||n===r.col&&i===r.colCount&&t>r.row))return!0}function Ue(t,n){return t.tables&&t.tables.Uue(n)}function He(t,n,e,i,r){return t.tables&&t.tables.oSt(n,e,i,r)}function Ve(t,n,e,i){return(-1===t.row||-1===t.col)&&t.intersect(e,i,n.rowCount,n.colCount)&&!t.equals(n)}function ze(t,n){return Un.call(this,t,n)||this}function Ye(t,n,e){var i,r,o,i=Hn.call(this,t,n)||this;if(!e&&(n.cachedActions=[],r=n.ranges)&&0<r.length)for(o=0;o<r.length;o++)n.cachedActions[o]=new xn(t,{clearRange:r[o]});return i}function vt(t,n){return Vn.call(this,t,n)||this}function Ze(t,n,e){var i,r,o,e,a,u,s,c,f,l,h,d,v,e,m,g,p,b,w,y,M,C,S,M,T,A,i=zn.call(this,t,n)||this;if(!e){if(o=n.fromSheet,!(r=t))throw new Error(at().Exp_DestSheetIsNull);if(a=(e=n).pastedRanges,u=r.o5(),a&&0<a.length)if(n.cachedActions=[],c=(s=e.fromRanges||[e.fromRange]).length,f=e.isCutting,l=e.clipboardText,h=e.clipboardHtml,d=e.clipboardImage,v=e.pasteOption,e={},m=a[0],!f&&o&&o.cT(s,e)&&m.equals(o.fT(s,m))){for(p=e.inSameCol,(g=e.inSameRow)?s.sort(function(t,n){return t.col-n.col}):p&&s.sort(function(t,n){return t.row-n.row}),b=m.row,w=m.col,y=0;y<c;y++)C=(M=s[y]).rowCount,S=M.colCount,u&&(C+=t.lT(b,C,!0),S+=t.lT(w,S)),M={sourceRange:M,targetRange:(0,tt.Ec)(b,w,C,S),isCutting:f,clipboardText:l,clipboardHtml:h,clipboardImage:d,includeFilteredOutRow:!0},n.cachedActions[y]=new kn(t,{fromSheet:o,toSheet:r,pasteExtent:M,pasteOption:v}),g?w+=S:p&&(b+=C);n.hT=!0}else for(T=0;T<a.length;T++)A={sourceRange:s[0],targetRange:a[T],isCutting:f,clipboardText:l,clipboardHtml:h,clipboardImage:d},n.cachedActions[T]=new kn(t,{fromSheet:o,toSheet:r,pasteExtent:A,pasteOption:v})}return i}n=this&&this.__extends||(Dn=function(t,n){return(Dn=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}Dn(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(h,"__esModule",{value:!0}),h.ClipboardPasteRangeUndoAction=h.Commands=void 0,e=t("./dist/core/core.ns.js"),L=t("Common"),y=t("./dist/core/worksheet/style.js"),T=t("./dist/core/worksheet/worksheet.js"),tt=t("./dist/core/util/common.js"),H=t("./dist/core/worksheet/clipboardhelper.js"),d=t("./dist/core/util/domUtil.js"),nt=t("./dist/core/core.enum.js"),b=d.GC$,B=t("./dist/core/worksheet/worksheet-static.js"),A=t("CalcEngine"),v=t("./dist/core/util/crypto.js"),I=t("./dist/core/worksheet/worksheet-formatter.js"),F=!!A,et=L.Common.lt.ht,V=L.Common.Uf.OS,m=L.Common.zf,x=m.dT,g=tt.Events.CellChanged,w=tt.Events.ColumnWidthChanging,N=tt.Events.ColumnWidthChanged,k=tt.Events.RowHeightChanging,_=tt.Events.RowHeightChanged,S=tt.mt.Tt,p=tt.mt.T1,d=b.extend,it=nt.CopyToOptions.all,rt=null,ot=void 0,P=Math.max,D=Math.min,z=Math.floor,j=Math.ceil,E=Number.MAX_VALUE,O=isNaN,Y="^(((ht|f)tp(s?)):\\/\\/(?:www.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|www\\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|((ht|f)tp(s?)):\\/\\/(?:www\\.|(?!www))[a-zA-Z0-9]+\\.[^\\s]{2,}|www\\.[a-zA-Z0-9]+\\.[^\\s]{2,})$",Z="^(mailto:\\/\\/)?([A-Za-z0-9_\\-\\.\\!\\#$%&'*\\+/=?^`{|}~])+\\@([A-Za-z0-9\\-])+\\.([A-Za-z0-9\\-]){2,63}(\\?subject=.+)?$",R=1e5,W="SHA-512",t=new L.Common.ResourceManager(e.SR,"Sheets"),at=t.getResource.bind(t),d(T.Worksheet.prototype,{autoFitColumn:function(t){0<=t&&t<ct(this)&&this.Qy().execute({cmd:"autoFitColumn",sheetName:this.name(),columns:[{col:t}],rowHeader:!1})},autoFitRow:function(t){0<=t&&t<st(this)&&this.Qy().execute({cmd:"autoFitRow",sheetName:this.name(),rows:[{row:t}],columnHeader:!1})},setCsv:function(t,n,e,i,r,o,a,u){var s=this;Jn(s),Kn(s),Xn(s),ue(s,t,n,e,i,r,'"',o,a,u),qn(s,!1),dt(s),ht(s)},setDataToCell:function(t,n,e,i){ie(t,n,e,i,0)},getCsv:function(t,n,e,i,r,o){return se(this,t,e,n,i,r,o,'"',!0)},getRangeTextHasIgnore:function(t,n,e,i,r,o){return se(this,t,e,n,i,"\r\n","\t",'"',!0,r,o)},copyTo:function(t,n,e,i,r,o,a){this.vT(t,n,e,i,r,o,a)},vT:function(t,n,e,i,r,o,a,u,s){var c=this;Jn(c),Kn(c),B.staticMembers.copyTo(c,t,n,c,e,i,r,o,a,u,0,s),dt(c),ht(c)},moveTo:function(t,n,e,i,r,o,a,u){var s=this;if(!(F&&a&nt.CopyToOptions.formula)||s.mT(t,n,r,o,!0)&&s.mT(e,i,r,o,!0))try{Jn(s),Kn(s),B.staticMembers.moveTo(s,t,n,s,e,i,r,o,a,u)}finally{dt(s),ht(s)}},findSpecialNonNullCellInRange:function(t,n){for(var e,t,i,r,o,a,u,s,e=this.Ut.sheetModels[3],t=tt.mt.S1(this,t),i=t.row,r=t.row+t.rowCount,o=t.col,a=t.col+t.colCount,u=e.gT(i-1);-1!==u&&u<=r;){for(s=e.pT(u,o-1);-1!==s&&s<=a;){if(n(this,u,s))return{row:u,col:s};s=e.pT(u,s)}u=e.gT(u)}return ot},bT:function(t){var n,e,i,r,o,t,n=this,e=n.yT(t);if(e)return i="\t",r="\r\n",o='"',t=n.wT(t),se(n,e.row,ft(e),e.col,lt(e),r,i,'"',!1,t.rows,t.cols,!0)},MT:function(t){var n,e,t,i,n=this,e=n.yT(t);if(e)return t=n.wT(t),i=U(n),H.yM.KS(n,i,e.row,ft(e),e.col,lt(e),nt.SheetArea.viewport,G(n),t.rows,t.cols,!1,!1,!1,!1)},CT:function(t,n,e){var i,r,o,a,u,s,c,i=this,r=i.rt,o=i.bT(t);if(o){(a=i.ST()).DS=i,a._S=t,n&&i.NMi&&1===t.length&&-1===t[0].row&&-1===t[0].col&&(n=!1),a.ES=n,(u=i.ST()).TT=!0,s=i.MT(t),i.AT&&i.AT(),i.ieV&&i.ieV();try{if(c={sheet:i,sheetName:i.name(),copyData:{text:o,html:s},ranges:t,isCutting:n,cancel:!1,action:n?nt.ClipboardActionType.cut:nt.ClipboardActionType.copy},i.ki(tt.Events.ClipboardChanging,c),!1===c.cancel)return r&&!e&&r.IT(G(i)?s:o),i.ki(tt.Events.ClipboardChanged,{sheet:i,sheetName:i.name(),copyData:{text:o,html:s}}),setTimeout(function(){!r||e||i.xT||r.NT()},100),{copyText:o,copyHtml:s};a.c5()}catch(t){}}},kT:function(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,v,m,m,c,l=at().Exp_PasteSourceCellsLocked;if(a.pastedInternal=!1,a.pastedRange=rt,h=!o&&!s,!t&&h)return!1;if(m=(v=d=this).wT(n),d._T(t,d.yT(n),v,o,m.rows,m.cols,c)||h){if(a.pastedInternal=!0,r&&t.options.isProtected&&t.ET(n)&&!Wn(t,i))return d.jT(1,l),!1;a.pastedRange=d.OT(t,n,v,e,i,r,u)}else m=d.RT(v,e,o,H.yM.n5(s)),c=d.BT(v,e,s),a.pastedRange=m.union(c);return d.LT(t,n,e,i,r,a,u,f)},LT:function(t,n,e,i,r,o,a,u){var s,c,f,l,h,d,v,m,g,p,f,h,b,w,y,M,C,S,T,A,I,x,N,s=this,c=at().Exp_InvalidCopyPasteSize,f=s.FT(),l=at().Exp_PasteChangeMergeCell,h=at().Exp_ChangePartOfArray,d=s,v=o.pastedRange,m=d.o5();if(!v)return s.jT(1,c),!1;if(!Wn(d,i)&&!d.PT(v.row,v.col,ft(v),lt(v),f,h,ot,a,ot,nt.SheetArea.viewport))return!1;if(o.pastedInternal){if(1===(g=n.length)){if(p=n[0],r&&!t.PT(p.row,p.col,ft(p),lt(p),f,h,ot,ot,ot,nt.SheetArea.viewport))return!1;if(t.GT(p.row,p.col,ft(p),lt(p)))return s.jT(1,l),!1;if(f=v.row<0?st(d):ft(v),h=v.col<0?ct(d):lt(v),b=p.row<0?st(t):ft(p),w=p.col<0?ct(t):lt(p),m&&(f=(f-=d.lT(e.row,P(f,b),!0))<1?1:f,h=(h-=d.lT(e.col,P(h,w)))<1?1:h),(b<f||w<h)&&!(y=2===i)){if(M=e.row,C=e.col,e.row<0&&b<st(d)&&(M=0),e.col<0&&w<ct(d)&&(C=0),f%b==0&&1===h?(h=w,m||(v=o.pastedRange=new tt.Range(M,C,f,h))):1===f&&h%w==0?(f=b,m||(v=o.pastedRange=new tt.Range(M,C,f,h))):f%b==0&&h%w==0||(v=o.pastedRange=new tt.Range(M,C,f=b,h=w)),S=z(f/b),T=z(h/w),a===ot||r&&(!u||!Le(d,new tt.Range(M,C,f,h))))for(A=0;A<S;A++)for(I=0;I<T;I++)if(!s.UT(p,v)&&d.GT(M<0?-1:M+A*b,C<0?-1:C+I*w,M<0?-1:b,C<0?-1:w))return s.jT(1,l),!1}else if(a===ot&&!s.UT(p,v)&&d.GT(v.row,v.col,ft(v),lt(v)))return s.jT(1,l),!1}else if(1<g){for(x=0;x<g;x++)if(N=n[x],t.GT(N.row,N.col,ft(N),lt(N)))return s.jT(1,l),!1;if(d.GT(v.row,v.col,ft(v),lt(v)))return s.jT(1,l),!1}}else{if(d.GT(v.row,v.col,ft(v),lt(v)))return s.jT(1,l),!1;if(!d.HT(v.row,v.col,ft(v),lt(v)))return s.jT(1,c),!1}return!0},UT:function(t,n){if(t&&1===ft(t)&&1===lt(t)){var t=this.getSpan(n.row,n.col);if(t&&t.equals(n))return!0}return!1},_T:function(t,n,e,i,r,o,a){var u,s,c,f;if(t&&n&&e)try{return(s=(s=(u=se(t,n.row,ft(n),n.col,lt(n),"\r\n","\t",'"',!1,r,o,!0,S.safari,!0))===i)||((s=!(s=u===i+"\r\n")&&S.chrome?u===i+"\t\r\n":s)||!(S.safari||S.mozilla||a)&&G(e)?s:u.replace(/\s/g,"")===i.replace(/\s/g,"")))||(c=new RegExp(String.fromCharCode(160),"g"),f=String.fromCharCode(32),s=(u=u.replace(c,f)).replace(/\s+$/,"")===i.replace(/\s+$/,"")),s}catch(t){}return!1},OT:function(t,n,e,i,r,o,a){var u,s,c,s,n,f,l,s,h,d,v,m,g,p,r,r,u=this,s=n.length,c=e.o5();if(1!==s)return 1<s?u.fT(n,i):rt;if(n=(s=n[0]).row<0?0:s.row,f=s.col<0?0:s.col,l=s.row<0?st(t):ft(s),s=s.col<0?ct(t):lt(s),h=i.row<0?0:i.row,d=i.col<0?0:i.col,v=i.row<0?st(e):ft(i),m=i.col<0?ct(e):lt(i),p=g=void 0,c&&(v=(v-=g=e.lT(h,P(v,l),!0))<1?1:v,m=(m-=p=e.lT(d,P(m,s)))<1?1:m),r=2===r,o||1===v&&1===m)v=l,m=s;else if(!r&&(v%l==0&&1===m?m=s:1===v&&m%s==0?v=l:v%l==0&&m%s==0||(v=l,m=s),!u.zT(n,f,l,s,st(t),ct(t))))return rt;if(!o&&t.name()===e.name()&&et(a))if((r=new tt.Range(h,d,v,m)).contains(n,f,l,s)){if((n-h)%l!=0||(f-d)%s!=0)return rt}else if(r.intersect(n,f,l,s)&&(l<v||s<m))return rt;return c&&(v+=g,m+=p),e.HT(h,d,v,m)?(-1===i.row&&(v=h=-1),-1===i.col&&(m=d=-1),new tt.Range(h,d,v,m)):rt},fT:function(t,n){var e,i,r,o,a,u,s,a,c,a,e=this,i=e.o5();if(1<t.length){if(r=t[0],o=t[1],a=r.rowCount,u=r.colCount,r.row===o.row&&a===o.rowCount)return s=0,a=a,t.forEach(function(t){s+=t.colCount}),i&&(a+=e.lT(n.row,a,!0),s+=e.lT(n.col,s)),(0,tt.Ec)(n.row,n.col,a,s);if(r.col===o.col&&u===o.colCount)return c=0,a=u,t.forEach(function(t){c+=t.rowCount}),i&&(c+=e.lT(n.row,c,!0),a+=e.lT(n.col,a)),(0,tt.Ec)(n.row,n.col,c,a)}return rt},RT:function(t,n,e,i){var r,n,o,e,i,e,r=n.row<0?0:n.row,n=n.col<0?0:n.col,o=new tt.Range(r,n,1,1),e=ve(e,"\r\n","\t",'"',G(t),i);return e&&(i=e.length,e=ae(e),0<i)&&0<e&&(t.o5()&&(i+=t.lT(r,i,!0),e+=t.lT(n,e)),o=new tt.Range(r,n,i,e)),o},BT:function(t,n,e){var i,n,r,o,a,a,e,a,e,a,i=n.row<0?0:n.row,n=n.col<0?0:n.col,r=1,o=1,a=t.ST();return a&&((a=a.i5()).innerHTML=e,a=(e=a.getElementsByTagName("table"))&&e[0])&&((e=a.rows)&&(r=e.length,a=e[0]&&e[0].cells)&&(o=a.length),0<r)&&0<o&&t.o5()&&(r+=t.lT(i,r,!0),o+=t.lT(n,o)),new tt.Range(i,n,r,o)},YT:function(){var t=this.ST();t&&t.c5()},ZT:function(t,e,i,n,r,o,a,u,s,c){var f,l,h,d,v,s,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,f=kn.WT(s),s=n.row<0?st(i):ft(n),m=n.col<0?ct(i):lt(n),d=e.row<0?st(t):ft(e),v=e.col<0?ct(t):lt(e),l=n.row,h=n.col;for(n.row<0&&d<st(i)&&(l=0),n.col<0&&v<ct(i)&&(h=0),g=z(s/d),p=z(m/v),b=0;b<g&&g&&p;b++)for(w=0;w<p;w++)B.staticMembers.copyTo(t,e.row,e.col,i,l+d*b,h+v*w,d,v,f,c,U(t),ot,Zn(f));for(x=-33&f,C=l+d*g,S=h,T=s-d*g,A=v,I=me(new tt.Range(e.row,e.col,T,A),t.getSpans(e)),N=function(n){I.forEach(function(t){i.addSpan(C+t.row-e.row,S+v*n+t.col-e.col,t.rowCount,t.colCount)}),B.staticMembers.copyTo(t,e.row<0?0:e.row,e.col<0?0:e.col,i,C,S+v*n,T,A,x,c,U(t),ot,Zn(x))},w=0;w<p&&T&&A;w++)N(w);for(C=l,S=h+v*p,T=d,A=m-v*p,I=me(new tt.Range(e.row,e.col,T,A),t.getSpans(e)),k=function(n){I.forEach(function(t){i.addSpan(C+d*n+t.row-e.row,S+t.col-e.col,t.rowCount,t.colCount)}),B.staticMembers.copyTo(t,e.row<0?0:e.row,e.col<0?0:e.col,i,C+d*n,S,T,A,x,c,U(t),ot,Zn(x))},b=0;b<g&&T&&A;b++)k(b);C=l+d*g,S=h+v*p,T=s-d*g,A=m-v*p,I=me(new tt.Range(e.row,e.col,T,A),t.getSpans(e)),T&&A&&(I.forEach(function(t){i.addSpan(C+t.row-e.row,S+t.col-e.col,t.rowCount,t.colCount)}),B.staticMembers.copyTo(t,e.row<0?0:e.row,e.col<0?0:e.col,i,C,S,T,A,x,c,U(t),ot,Zn(x)))},QT:function(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,E,O,R;if(t&&e.name()===t.name()&&e.parent&&!t.NMi&&!V(e.parent.sheets,t)&&e.parent!==t.parent)t.YT();else{l=e.o5(),b=kn.WT(s),Xn(t),Xn(e);try{if(t&&n){if(0!=(2&b)&&r&&F&&(t.KT(n.row,n.col,ft(n),lt(n))||e.KT(i.row,i.col,ft(i),lt(i))))throw at().Exp_ChangePartOfArray;if(w=2===s,r)B.staticMembers.moveTo(t,n.row,n.col,e,i.row,i.col,ft(n),lt(n),b,t.JT,f),t.YT();else if(w)this.ZT(t,n,e,i,r,o,a,u,s,c);else if(y=i.row<0?st(e):ft(i),M=i.col<0?ct(e):lt(i),v=n.row<0?st(t):ft(n),m=n.col<0?ct(t):lt(n),l&&(y-=e.lT(i.row,P(y,v),!0),M-=e.lT(i.col,P(M,m)),y=y<1?1:y,M=M<1?1:M),v<y||m<M)for(h=i.row,d=i.col,i.row<0&&v<st(e)&&(h=0),i.col<0&&m<ct(e)&&(d=0),y%v==0&&1===M?M=m:1===y&&M%m==0?y=v:y%v==0&&M%m==0||(y=v,M=m),C=z(y/v),S=z(M/m),T=v,A=m,k=N=x=I=void 0,g=0;g<C;g++){for(I=et(N)?h<0?-1:h+g*v:N,p=0;p<S;p++)x=et(k)?d<0?-1:d+p*m:k,v=h<0?-1:T,m=d<0?-1:A,l&&(v=h<0?-1:v+e.lT(I,T,!0),m=d<0?-1:m+e.lT(x,A)),B.staticMembers.copyTo(t,n.row,n.col,e,I,x,T,A,b,c,U(t),f,Zn(b)),k=x+(m<0?0:m);N=I+(v<0?0:v),k=null}else B.staticMembers.copyTo(t,n.row,n.col,e,i.row,i.col,ft(n),lt(n),b,c,U(t),f,Zn(b))}else{if(h=i.row,d=i.col,v=ft(i),m=lt(i),_=0===s||2===s||4===s||5===s,o&&_)for(E=(j=(D=e.Ut).getSpans((0,tt.Ec)(h,d,v,m))).length-1;0<=E;E--)D.do("removeSpan",j[E]);if(F&&0<(1&b)&&e.clearFormula(h,d,v,m,function(t,n){return!t.XT||!t.XT(n)}),O=e.ST(),o&&""!==o)e.parent&&e.parent.options.allowAutoCreateHyperlink&&1===v&&1===m&&(L.Common.$T.qT(Y).test(o)||L.Common.$T.qT(Z).test(o))&&e.setHyperlink&&e.setHyperlink(h,d,{url:o,tooltip:o}),R=e.parent&&e.parent.options.allowUserEditFormula?16:0,e.setCsv(h,d,o,"\r\n","\t",R,G(e),H.yM.n5(a));else if(O&&_&&u)O.s5(u,e,h,d);else for(g=0;g<v;g++)for(p=0;p<m;p++)e.setValue(h+g,d+p,rt);O&&_&&a&&O.r5(a,e,h,d)}}finally{qn(t,!1),qn(e,!1)}}},tA:function(t){if(!this.isEditing()){var n=this.getSelections();if(n&&1===n.length)return this.options.isProtected&&this.ET(n)?(this.jT(14,this.FT()),rt):this.CT(n,!0,t)}return rt},nA:function(t){var n,e,i,r,o,a,u,s,n=this,e=t.length,i;if(n.options.isProtected)for(r=0;r<e;r++)for(a=(o=t[r]).row;a<o.row+o.rowCount;a++)for(u=o.col;u<o.col+o.colCount;u++)if(!1!==(s=n.getActualStyle(a,u)).locked)return!0;return!1},cT:function(t,n){var e,i,r,o,a,u,s;if(t&&1<(e=t.length)){for(i=void 0,i=0;i<e;i++)for(r=t[i],o=i+1;o<e;o++)if(a=t[o],r.intersect(a.row,a.col,a.rowCount,a.colCount))return!1;for(u=t[0],s=void 0,i=1;i<e&&(s=t[i],u.row===s.row&&u.rowCount===s.rowCount);i++);if(e<=i)return n&&(n.inSameRow=!0),!0;for(i=1;i<e&&(s=t[i],u.col===s.col&&u.colCount===s.colCount);i++);if(e<=i)return n&&(n.inSameCol=!0),!0}return!1},yT:function(t){var n,e,i,r,o;if(t){if(1===(n=t.length))return t[0];if(1<n){if(e=t[0],i=t[n-1],o=r=void 0,e.row===i.row&&e.rowCount===i.rowCount){for(r=0;r<n;r++)(o=t[r]).col<e.col&&(e=o),o.col>i.col&&(i=o);return(0,tt.Ec)(e.row,e.col,e.rowCount,i.col+i.colCount-e.col)}if(e.col===i.col&&e.colCount===i.colCount){for(r=0;r<n;r++)(o=t[r]).row<e.row&&(e=o),o.row>i.row&&(i=o);return(0,tt.Ec)(e.row,e.col,i.row+i.rowCount-e.row,e.colCount)}}}return rt},wT:function(t){var n,e,i,r,o,a,r,u,s,c,s,f,l,h,n=[],e=[];if(t&&1<(i=t.length)&&(r=t[0],o=t[i-1],a=r.row===o.row&&r.rowCount===o.rowCount,r=r.col===o.col&&r.colCount===o.colCount,a||r))for(t.sort(a?function(t,n){return t.col-n.col}:function(t,n){return t.row-n.row}),u=1;u<i;u++)for(s=t[u-1],c=t[u],s=a?s.col+s.colCount:s.row+s.rowCount,f=a?c.col:c.row,l=a?e:n,h=s;h<f;h++)l.push(h);return{rows:n,cols:e}},eA:function(t){var n,e,i,r,o,a,u,s,n=this;if(!n.isEditing()){if((e=n.getSelections())&&1===e.length){if((i=n.ST()).TT=!0,-1!==(r=e[0]).row&&n.iA&&n.iA()){for(o=[],a=-1,u=0;u<r.rowCount;u++)s=r.row+u,n.XT(s)?-1!==a&&(o.push((0,tt.Ec)(a,r.col,s-a,r.colCount)),a=-1):-1===a&&(a=s);-1!==a&&o.push((0,tt.Ec)(a,r.col,r.row+r.rowCount-a,r.colCount)),e=o}return n.CT(e,!1,t)}if(n.cT(e))return n.CT(e,!1,t);n.jT(1,at().Exp_MultipleSelections)}return rt},rA:function(t,s){var c,f,l,h,d,v,m,g,p,b,c=this,f=c.rt;c.isEditing()||(t&&(l=t.pasteText,h=t.pasteHtml,d=void 0===t.pasteOption?c.options.clipBoardOptions:t.pasteOption,v=t.shiftCells,p=t.isHeaderPaste,g=t.isFromDesigner,m=c.getSelections()[0]),f&&!l&&s&&f.IT(""),(b=c.ST())&&(b.oA=!1),setTimeout(function(){var t,n,e,i,i,r,o,a,u;if(!c.xT){if(t=l||"",n=h||"",f&&!l){if(b&&(i=b.QS(),r=b.DS,t=i.text,n=i.html,i=i.image,e=b._S,r)&&e)for(o=0,a=e;o<a.length;o++)u=a[o],tt.mt.J0(u,r.getRowCount(),r.getColumnCount());s&&f.NT()}(S.msie||S.edge||l||!t&&!n&&!b.oA)&&c.US(t,n,i,d,v,m,e,g,p),c.rt.aA(),c.ki(tt.Events.PasteEnd)}},100))},US:function(t,n,e,i,r,o,a,u,s){var c,f,f,c=this,f=c.ST();if(f&&(f.oA=!0),!(f=c.uA(t,i,r,n,u,s))){if(!e)return;f={pasteOption:void 0===i?c.options.clipBoardOptions:i,pastedRanges:[(0,tt.Ec)(c.getActiveRowIndex(),c.getActiveColumnIndex(),1,1)],clipboardText:""}}r!==ot&&(f.sA=r),et(s)||(f.kse=s),o&&(f.cA=o),a&&(f.fA=a),f.cmd="clipboardPaste",f.sheetName=c.name(),G(c)&&(f.clipboardHtml=n,f.clipboardImage=e),c.Qy().execute(f)},uA:function(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,s,e,b,w,a=this,u=at().Exp_InvalidPastedArea,s=a.ST(),c=s.DS,f=s._S,l=s.ES;if(l&&c&&f&&c.options.isProtected&&c.ET(f)&&(l=!1),h={pastedRange:rt,pastedInternal:!1},d=[],1<(v=a.getSelections()).length)for(g=2===n,p=0;p<v.length;p++){if(m=v[p],!a.kT(c,f,m,n,l,t,h,ot,i,r,o))return;if(m.containsRange(h.pastedRange)&&!m.equals(h.pastedRange)&&!g)return void a.jT(1,u);d.push(h.pastedRange)}else{if(m=0<v.length?v[0]:a.Ut.getSpan(a.ui,a.ci),!a.kT(c,f,m,n,l,t,h,e,i,r,o))return;d.push(h.pastedRange)}if((s=a.lA)&&s._T(h.pastedInternal),h.pastedInternal||(f=c=rt,l=!1),e=void 0===n?a.options.clipBoardOptions:n,l&&(e=a.hA),f&&1===f.length)for(b=0;b<d.length;b++)a.UT(f[0],w=d[b])&&(w.rowCount=1,w.colCount=1);if(!((!f||1<f.length)&&1<d.length))return{fromSheet:c,fromRanges:f,isCutting:l,pasteOption:e,pastedRanges:d,clipboardText:t};a.jT(1,at().Exp_MultipleSelections)},HT:function(t,n,e,i,r){var o,a,u,o=this,a=st(o),u=ct(o);return Yn(o)?-1<=t&&(r||t<a)&&-1<=n&&(r||n<u):o.zT(t,n,e,i,a,u)},ET:function(t){for(var n=0;n<t.length;n++)if(this.dA(t[n],ot,nt.SheetArea.viewport))return!0;return!1},G5:function(t,n,e,i,r){var o,a,a,a,u,o=this,a=o.vA&&1===o.vA.sheetArea;o.endEdit&&!o.endEdit()||a||(a={sheet:o,sheetName:o.name(),row:o.ui,col:o.ci,cancel:!1},o.ki(tt.Events.LeaveCell,a),!0!==a.cancel&&(a=o.ui,u=o.ci,et(e)&&(e=o.ui),et(i)&&(i=o.ci),3===t?o.mA(e,i,n):4===t?o.gA(e,i,n):1===t?o.pA(e,i,n,r):2===t?o.bA(e,i,n):5===t?o.yA():6===t&&o.wA(),o.MA(t,a,u,!1)))},P5:function(t){var n,e,e,i,n=this;n.endEdit()&&(e={sheet:n,sheetName:n.name(),row:n.ui,col:n.ci,cancel:!1},n.ki(tt.Events.LeaveCell,e),!0!==e.cancel)&&(e=n.ui,i=n.ci,3===t?n.CA(n.ui,n.ci):4===t?n.SA(n.ui,n.ci):1===t?n.TA(n.ui,n.ci):2===t&&n.AA(n.ui,n.ci),n.MA(t,e,i,!0))},MA:function(t,n,e,i){var r,o,a,u,s,s,c,f,f,l,h,l,h,f,l,h,u,d,v,d,h,u,m,g,l,v,d,h,u,r=this,o=r.rt,a=r.Ut.getSelections(),u=!1;if(i||(s=r.JS(r.U5()),!(u=1<a.length||1<ft(s)||1<lt(s)?!0:u)&&r.Cb&&r.Cb.Sb(s)&&(u=!0),r.IA()),s=r.ui,c=r.ci,f=r.Ut.getSpan(s,c),r.H5=ft(f),r.z5=lt(f),i||(f=r.xA(s,c),l=r.selectionPolicy(),h=r.selectionUnit(),0!==l&&1!==l||r.Ut.do("clearSelection"),1===h?(f.col=-1,f.colCount=-1):2===h&&(f.row=-1,f.rowCount=-1),r.kA(f.row,f.col,ft(f),lt(f),!1),l=r.Ut.getSelections(),o._A(a,l)&&(r.EA(a,l),r.jA(a))),r.OA(s,c),n!==s&&(h=r.H3)&&h.RA(),f=r.Dn,u){if(h=(l=r.Fi()).BA,u=l.LA,d=l.width-h,v=l.height-u,f.FA(h,u,d,v),f.repaint(new tt.Rect(h,u,d,l.qC)),f.repaint(new tt.Rect(h,u,l.XC,v)),h=(d=r._1)&&d.isEnable(nt.RowColumnStates.selected,!0),u=d&&d.isEnable(nt.RowColumnStates.selected,!1),h||u){for(m=a[0],g=1;g<a.length;g++)m=m.union(a[g]);m&&(l=new tt.Range(s,c,r.H5,r.z5),f.E1(l.union(m),null,null,null,null,i))}f.jy(f.J())}else d=ft(v=r.Ut.getSpan(n,e)),h=lt(v),f.E1(new tt.Range(s,c,r.H5,r.z5).union(new tt.Range(n,e,d,h)),null,null,null,null,i);u={sheet:r,sheetName:r.name(),row:s,col:c},r.ki(tt.Events.EnterCell,u),r.ki(tt.Events.EnterCellInternal,u),o.PA&&o.PA(s,c)},GA:function(t,n){var e,i,t,e=this,i=e.getDataValidator&&e.getDataValidator(t,n),t={sheet:e,sheetName:e.name(),row:t,col:n,validator:i,validationResult:0};return e.ki(tt.Events.ValidationError,t),t.validationResult},protect:function(t){this.aue(t)},aue:function(t){var n,e,e,i,t,n=this,e="string"==typeof t;!0!==n.options.isProtected&&(et(t)||e&&0===t.length?n.options.isProtected=!0:e&&(e=v.Qoe.iue(),t=v.Qoe.nue(t,e,i=1e5,v.Qoe.eue),n.oue={algorithmName:W,hashValue:t,saltValue:e,spinCount:1e5},n.options.isProtected=!0))},unprotect:function(t){return this.uue(t)},uue:function(t){var n,e,e,i,r,o,a,u,n=this,e=n.sue();if(n.options.isProtected){if(!e)return!(n.options.isProtected=!1);if(et(t)||"string"!=typeof t||0===t.length)return!1;if(i=(e=n.oue).hashValue,r=e.saltValue,o=e.spinCount,(a=e.algorithmName)!==W)throw new Error(at().EXP_UNSUPPORT_CRYPTO_ALGORITHM);if(!(u=v.Qoe.rue(t,i,r,o,v.Qoe.eue)))return!1;n.options.isProtected=!1,n.oue=ot}return!0},hasPassword:function(){return this.sue()},sue:function(){return!et(this.oue)}}),ut={},(h.Commands=ut).B5=function(t,n){return!!t&&2!==t.Di&&(t.G5(n,!1),!0)},ut.UA=function(t,n,e,i){return!!t&&2!==t.Di&&(t.G5(n,!1,e,i),!0)},ut.L5=function(t,n,e){return!!t&&2!==t.Di&&!(t.endEdit&&!t.endEdit()||(t.HA(n,e),0))},Q="navigationLeft",J="navigationRight",K="navigationUp",X="navigationDown",q="navigationHome2",$="navigationEnd2",mt="navigationTop",gt="navigationBottom",pt="navigationHome",bt="navigationFirst",wt="navigationEnd",yt="navigationLast",Mt="moveToNextCell",Ct="moveToPreviousCell",St="navigationPageUp",Tt="navigationPageDown",At="navigationPreviousSheet",It="navigationNextSheet",xt="clear",Nt="clearAndEditing",kt="commitInputNavigationDown",_t="commitInputNavigationUp",Dt="cancelInput",jt="commitArrayFormula",Et="selectionLeft",Ot="selectionRight",Rt="selectionUp",Lt="selectionDown",Bt="selectionHome",Ft="selectionEnd",Pt="selectionPageUp",Gt="selectionPageDown",Ut="selectionTop",Ht="selectionBottom",Vt="selectionFirst",zt="selectionLast",Yt="copy",Zt="cut",Wt="paste",Qt="undo",Jt="redo",Kt="resizeColumn",Xt="resizeRow",qt="splitResizeRow",$t="splitResizeColumn",tn="autoFitColumn",nn="autoFitRow",en="editCell",rn="renameSheet",on="zoom",an="clearValues",un="clipboardPaste",sn="selectNextControl",cn="selectPreviousControl",fn="moveToNextCellThenControl",ln="moveToPreviousCellThenControl",hn="changeFormulaReference",dn="moveSheet",vn="copySheet",mn="showAllSheetsDialog",ut.Tp=s,ut.zA=o,ut.gM=function(t){var n=tt.mt.Qf(),e=!n,i=n;t.register(Q,ut[Q],37,!1,!1,!1,!1),t.register(J,ut[J],39,!1,!1,!1,!1),t.register(K,ut[K],38,!1,!1,!1,!1),t.register(X,ut[X],40,!1,!1,!1,!1),t.register(q,ut[q],37,e,!1,!1,i),t.register($,ut[$],39,e,!1,!1,i),t.register(mt,ut[mt],38,e,!1,!1,i),t.register(gt,ut[gt],40,e,!1,!1,i),t.register(pt,ut[pt],36,!1,!1,!1,!1),t.register(bt,ut[bt],36,!0,!1,!1,!1),t.register(wt,ut[wt],35,!1,!1,!1,!1),t.register(yt,ut[yt],35,!0,!1,!1,!1),t.register(Mt,ut[Mt],9,!1,!1,!1,!1),t.register(Ct,ut[Ct],9,!1,!0,!1,!1),t.register(St,ut[St],33,!1,!1,!1,!1),t.register(Tt,ut[Tt],34,!1,!1,!1,!1),t.register(At,ut[At],33,e,!1,!1,i),t.register(It,ut[It],34,e,!1,!1,i),t.register(xt,ut[xt],46,!1,!1,!1,!1),t.register(Nt,ut[Nt],8,!1,!1,!1,!1),t.register(kt,ut[kt],13,!1,!1,!1,!1),t.register(_t,ut[_t],13,!1,!0,!1,!1),t.register(Dt,ut[Dt],27,!1,!1,!1,!1),t.register(jt,ut[jt],13,!0,!0,!1,!1),t.register(Et,ut[Et],37,!1,!0,!1,!1),t.register(Ot,ut[Ot],39,!1,!0,!1,!1),t.register(Rt,ut[Rt],38,!1,!0,!1,!1),t.register(Lt,ut[Lt],40,!1,!0,!1,!1),t.register(Bt,ut[Bt],36,!1,!0,!1,!1),t.register(Ft,ut[Ft],35,!1,!0,!1,!1),t.register(Pt,ut[Pt],33,!1,!0,!1,!1),t.register(Gt,ut[Gt],34,!1,!0,!1,!1),t.register(Bt,ut[Bt],37,e,!0,!1,i),t.register(Ft,ut[Ft],39,e,!0,!1,i),t.register(Ut,ut[Ut],38,e,!0,!1,i),t.register(Ht,ut[Ht],40,e,!0,!1,i),t.register(Vt,ut[Vt],36,!0,!0,!1,!1),t.register(zt,ut[zt],35,!0,!0,!1,!1),t.register(Yt,ut.copy,67,e,!1,!1,i),t.register(Zt,ut.cut,88,e,!1,!1,i),t.register(Wt,ut[Wt],86,e,!1,!1,i),t.register(Qt,ut.undo,90,e,!1,!1,i),t.register(Jt,ut.redo,89,e,!1,!1,i),n&&t.register(Jt,ut.redo,90,e,!0,!1,i),t.register(sn,ut[sn]),t.register(cn,ut[cn]),t.register(fn,ut[fn]),t.register(ln,ut[ln]),t.register(hn,ut[hn]),t.register(Kt,ut[Kt]),t.register(Xt,ut[Xt]),t.register($t,ut[$t]),t.register(qt,ut[qt]),t.register(tn,ut[tn]),t.register(nn,ut[nn]),t.register(en,ut[en]),t.register(rn,ut[rn]),t.register(on,ut.zoom),t.register(an,ut[an]),t.register(un,ut[un]),t.register(dn,ut[dn]),t.register(vn,ut[vn]),t.register(mn,ut[mn])},u={256:"bindingPath",4:"comment",2:"formula",16:"sparkline",64:"style",128:"tag",1024:"hyperlink",2048:"defaultValue",4096:"altText",1:"value"},ut[Q]={canUndo:!(gn=".cellEditAction"),execute:pe(3)},ut[J]={canUndo:!1,execute:pe(4)},ut[K]={canUndo:!1,execute:pe(1)},ut[X]={canUndo:!1,execute:pe(2)},ut[jt]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n),n=ut.VA;return(t=n?n.YA(t):t).YA&&t.YA(),!0}},ut[kt]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n),n=ut.VA;return we(t=n?n.ZA(t):t,2,!1),!0}},ut[_t]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n),n=ut.VA;return we(t=n?n.WA(t):t,1,!1,!0),!0}},ut[pt]={canUndo:!1,execute:function(t,n){var t=s(t,n);return ut.UA(t,4,rt,t.frozenColumnCount()-1)}},ut[q]={canUndo:!1,execute:function(t,n){var t,e,t=s(t,n);return!!(t&&0<(e=t.getSelections()).length)&&ut.UA(t,4,rt,-1)}},ut[wt]={canUndo:!1,execute:function(t,n){var t=s(t,n);return ut.UA(t,3,rt,ct(t)-t.frozenTrailingColumnCount())}},ut[$]={canUndo:!1,execute:function(t,n){var t,e,t=s(t,n);return!!(t&&0<(e=t.getSelections()).length)&&ut.UA(t,3,rt,ct(t))}},ut[mt]={canUndo:!1,execute:function(t,n){var t=s(t,n);return ut.UA(t,2,-1,rt)}},ut[gt]={canUndo:!1,execute:function(t,n){var t=s(t,n);return ut.UA(t,1,st(t),rt)}},ut[St]={canUndo:!1,execute:function(t,n){var t,n,e,e,i,i,t=s(t,n);if(!t||2===t.Di)return!1;if((n=t.QA())!==rt&&n!==t.Tb){if(e=t._y(1,3),(e=t.j5(t.ui-e.length))<n&&(e=n),i=ut.VA){if((i=i.KA(t,e,n)).r)return!0;t=i.sheet}if(!t.endEdit())return!1;t.JA(e,t.getActiveColumnIndex())&&(t.XA(e,rt),t.qA=e,t.G5()),t.$A(n,0)}return!0}},ut[Tt]={canUndo:!1,execute:function(t,n){var t,n,e,e,i,i,t=s(t,n);if(!t||2===t.Di)return!1;if((n=t.tI())!==rt&&n!==t.Tb){if(e=t._y(1,3),(e=t.nI(t.ui+e.length))<n&&(e=n),i=ut.VA){if((i=i.eI(t,e,n)).r)return!0;t=i.sheet}if(!t.endEdit())return!1;t.JA(e,t.getActiveColumnIndex())&&(t.XA(e,rt),t.qA=e,t.G5()),t.$A(n,0)}return!0}},ut[It]={canUndo:!1,execute:function(t,n){var e;be(s(t,n),!0)}},ut[At]={canUndo:!1,execute:function(t,n){var e;be(s(t,n),!1)}},ut[bt]={canUndo:!1,execute:function(t,n){var t,n,n,t=s(t,n);if(!t||2===t.Di)return!1;if(n=ut.VA){if((n=n.iI(t)).r)return!0;t=n.sheet}return t.G5(5,!1,t.ui,t.ci),!0}},ut[yt]={canUndo:!1,execute:function(t,n){var t,n,n,t=s(t,n);if(!t||2===t.Di)return!1;if(n=ut.VA){if((n=n.rI(t)).r)return!0;t=n.sheet}return t.G5(6,!1,t.ui,t.ci),!0}},ut[sn]={canUndo:!1,execute:function(t,n){var t=s(t,n);return!!t.parent&&Me(t,t.parent.nextControl)}},ut[cn]={canUndo:!1,execute:function(t,n){var t=s(t,n);return!!t.parent&&Me(t,t.parent.previousControl)}},ut[Mt]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n),n=ut.VA;return we(t=n?n.oI(t):t,4,!0),!0}},ut[Ct]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n),n=ut.VA;return we(t=n?n.aI(t):t,3,!0),!0}},ut[fn]={canUndo:!1,execute:function(t,n){var e,i,r,o,a,e=s(t,n),i=e.qA,r=e.getActiveColumnIndex();return e.F5=!0,o=e.uI(e.getActiveRowIndex(),r,!0,i),e.F5=!1,((a=!o||o.leadingCellRow<i||o.leadingCellRow===i&&r>o.col)?ut[sn]:ut[Mt]).execute(t,n)}},ut[ln]={canUndo:!1,execute:function(t,n){var e,i,r,o,a,e=s(t,n),i=e.qA,r=e.getActiveColumnIndex();return e.F5=!0,o=e.sI(e.getActiveRowIndex(),r,!0,i),e.F5=!1,((a=!o||o.leadingCellRow>i||o.leadingCellRow===i&&r<o.col)?ut[cn]:ut[Ct]).execute(t,n)}},ut[Dt]={canUndo:!1,execute:function(t,n){var t,n,e,n,t=s(t,n),n=ut.VA;return n&&(e=n.cI(t)),t.isEditing()?!!t.endEdit(!0):et(e)?(ut.fI(t.parent),t.bM=rt,t.parent.bM.c5(),(n=t).AT&&n.AT(),void(n.ieV&&n.ieV())):e}},ut.fI=function(t){var n,t,e,i,r,o;if(t&&(n=t.sheets,t=t.mp.map(function(t){return t.Mf}),e=n.concat(t)))for(i=0,r=e.length;i<r;i++)(o=e[i])&&o.lA&&o.lA.lI()},ut[xt]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n);return!t.isEditing()&&(n=t.getSelections(),t.Qy().execute({cmd:an,sheetName:t.name(),ranges:n}))}},ut[Nt]={canUndo:!1,execute:function(t,n){var e=s(t,n);return!e.isEditing()&&(tt.mt.Qf()?ut[xt].execute(t,n):(e.Ai=!0,e.startEdit(!0,""),e.Ai=!1),!0)}},ut.copy={canUndo:!1,execute:function(t,n){var e,t,e,t,t=s(t,n),e=!n.vge&&(null==(e=n.ignoreClipboard)||e),t=n.copyData=t.eA(e);return n.callback&&n.callback(),!t||ot}},ut.cut={canUndo:!1,execute:function(t,n){var e,t,e,t,t=s(t,n),e=!n.vge&&(null==(e=n.ignoreClipboard)||e),t=n.cutData=t.tA(e);return n.callback&&n.callback(),!t||ot}},ut[Wt]={canUndo:!1,execute:function(t,n){var e,e,i,e=null!=(e=n.vge)&&e,i;s(t,n).rA(n,e)}},ut[Et]={canUndo:!1,execute:i(37)},ut[Ot]={canUndo:!1,execute:i(39)},ut[Rt]={canUndo:!1,execute:i(38)},ut[Lt]={canUndo:!1,execute:i(40)},ut[Bt]={canUndo:!1,execute:i(37,!0)},ut[Ft]={canUndo:!1,execute:i(39,!0)},ut[Pt]={canUndo:!1,execute:i(33)},ut[Gt]={canUndo:!1,execute:i(34)},ut[Ut]={canUndo:!1,execute:i(38,!0)},ut[Ht]={canUndo:!1,execute:i(40,!0)},ut[Vt]={canUndo:!1,execute:i(36,!0)},ut[zt]={canUndo:!1,execute:i(35,!0)},ut[hn]={canUndo:!1,execute:function(t,n){var t,n,t=s(t,n),n=t&&t.rt;if(n){Jn(t);try{n.hI&&n.hI()}finally{ht(t)}}}},ut.undo={canUndo:!1,execute:function(t){var t,n,t=t;return t&&(n=t.undoManager())&&n.canUndo()&&(n.undo(),t.ki(tt.Events.WorkbookUndo,{spread:t})),!0}},ut.redo={canUndo:!1,execute:function(t){var t,n,t=t;return t&&(n=t.undoManager())&&n.canRedo()&&(n.redo(),t.ki(tt.Events.WorkbookRedo,{spread:t})),!0}},ut[Kt]={canUndo:!0,execute:function(t,n,e){return o(t,bn,n,e)}},ut[Xt]={canUndo:!0,execute:function(t,n,e){return o(t,wn,n,e)}},ut[$t]={canUndo:!0,execute:function(t,n,e){return o(t,yn,n,e)}},ut[qt]={canUndo:!0,execute:function(t,n,e){return o(t,Mn,n,e)}},ut[tn]={canUndo:!0,execute:function(t,n,e){return o(t,Cn,n,e)}},ut[nn]={canUndo:!0,execute:function(t,n,e){return o(t,Sn,n,e)}},ut[en]={canUndo:!0,execute:function(t,n,e){return o(t,Tn,n,e)}},ut[rn]={canUndo:!0,execute:function(t,n,e){return o(t,An,n,e)}},ut.zoom={canUndo:!0,execute:function(t,n,e){return o(t,In,n,e)}},ut[an]={canUndo:!0,execute:function(t,n,e){var i,r,i=s(t,n),r=i.getSelections();return i.options.isProtected&&i.ET(r)?(i.jT(13,i.FT()),!1):o(t,Nn,n,e)}},ut[un]={canUndo:!0,execute:function(t,n,e){return o(t,_n,n,e)}},ut[dn]={canUndo:!1,execute:function(t,n){var e,n,i,r,i,o,a,a,e=n.sheetName,n=n.targetIndex,i=t.getSheetPosition(e),r=t.jg(),i=i,o=n,a={sheet:r,sheetName:r.name(),oldIndex:i,newIndex:o,cancel:!1};return t.ki(tt.Events.SheetMoving,a),!a.cancel&&(a=t.changeSheetPosition(e,n),t.ki(tt.Events.SheetMoved,{sheet:r,sheetName:r?r.name():rt,oldIndex:i,newIndex:o}),a)}},ut[vn]={canUndo:!1,execute:function(t,n){var e,i,r,n,o,a,e=n.sheetName,i=n.targetIndex,r=n.newName,n=n.includeBindingSource,o=t.Gm(e);return t.ki(tt.Events.SheetChanging,{sheetName:r,propertyName:"insertSheet",cancel:!1,sheetIndex:i,sheetPosition:t.getSheetPosition(r)}),t.ki(tt.Events.ActiveSheetChanging,{oldSheet:o,newSheet:a,cancel:!1}),a=t.clone(e,i,r,n),!et(a)&&(t.ki(tt.Events.SheetChanged,{sheetName:a.name(),propertyName:"insertSheet",sheetIndex:i,sheetPosition:t.getSheetPosition(a.name())}),t.ki(tt.Events.ActiveSheetChanged,{oldSheet:o,newSheet:a}),!0)}},ut[mn]={canUndo:!1,execute:function(t,n){for(var t,e,i,r,o,a,u,s,c,c,f,l,h,t=t,e="gc.spread.",i="gc.spread.contextMenu.allSheets",r="sheetTab",o=[],a=t.qv(),s=0;s<a.length;s++)a[s].visible()===nt.SheetTabVisible.visible&&(c=21<a[s].name().length?a[s].name().substr(0,18)+"...":a[s].name(),c={text:c=m.dI(c),name:e+a[s].name(),command:i,workArea:r,itemClass:"",title:a[s].name()},a[s].b2()&&(u=s,c.itemClass="gc-ui-contextmenu-menuitem-all-sheets-select-sheets-background-color"),o.push(c));return f=(0,tt.jf)(t),t.ki(tt.Events.ActiveSheetChangingInternal,l={oldSheet:f,newSheet:f,needTriggerSheetChange:!0}),h={items:o,mouseEvent:n.mouseEvent,cancel:!1},t.ki(tt.Events.SheetTabAllSheetsListContextMenuOpening,h),!h.cancel&&(t.contextMenu.openAllSheetsListContextMenu(o,t,n.mouseEvent,u),t.ki(tt.Events.SheetTabAllSheetsListContextMenuOpened,h),t.ki(tt.Events.ActiveSheetChangedInternal,{oldSheet:void 0,newSheet:f}),!0)}},r.prototype.toJSON=function(){var t=this;return{sheetName:t.Mf.name(),range:t.Z5,dataType:t.W5,cellsData:t.Q5}},r.prototype.fromJSON=function(t,n){var e,i,e=t.sheetName,i=n;"Workbook"===n.constructor.name&&(i=n.getSheetFromName(e)),this.Mf=i,this.Z5=t.range,this.W5=t.dataType,this.Q5=t.cellsData},r.prototype.J5=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,h,T,T,A,A,t=this,n=t.Z5,e=t.Mf;if(e&&n){if(i=t.W5,r=n.row,o=n.col,a=ft(n),u=lt(n),s=t.Q5,c=!1,-1===r&&(c=!0,r=0,a=st(e)),-1===o&&(c=!0,o=0,u=ct(e)),l=[],0<(64&i))for(d=0;d<u;d++)l[d]=e.vI(-1,d)||rt;for(v=0;v<a;v++)for(m=r+v,0<(64&i)&&(f=e.vI(m,-1)||rt),g=0;g<u;g++){if(p=void 0,b=o+g,F&&0<(2&i)&&e.getFormulaInformation&&(p=e.getFormulaInformation(m,b,3)).hasFormula)if(p.isArrayFormula){if((w=p.baseRange).row===m&&w.col===b)for(y=w.row,M=w.row+ft(w);y<M;y++)for(C=w.col,S=w.col+lt(w);C<S;C++)t.mI(s,y-r,C-o,p,2)}else t.mI(s,v,g,p.formula,2);!(0<(1&i))||p&&p.hasFormula||t.mI(s,v,g,e.getValue(m,b,3),1),0<(16&i)&&e.getSparkline&&(h=e.getSparkline(m,b),T=rt,h&&(et(h.data())&&h.data(h.gI),T=h.data()),h)&&T&&t.mI(s,v,g,h,16),0<(64&i)&&(T=void 0,T=c?e.getActualStyle(m,b,3):(h=e.vI(m,b)||rt,e.getCompositeStyle(m,b,3,h,f,l[g])),A=ot,T&&T.toJSON&&(A=JSON.stringify(T.toJSON(3,!0))),t.mI(s,v,g,A,64)),A=e.Ut.pI,0<(4&i)&&A&&t.mI(s,v,g,A.get(m,b),4),0<(128&i)&&t.mI(s,v,g,e.getTag(m,b,3),128),0<(256&i)&&t.mI(s,v,g,e.getBindingPath&&e.getBindingPath(m,b,3),256),0<(1024&i)&&t.mI(s,v,g,e.getHyperlink&&e.getHyperlink(v,g,3),1024),0<(2048&i)&&t.mI(s,v,g,e.getDefaultValue(m,b,3),2048),0<(4096&i)&&t.mI(s,v,g,e.getAltText(v,g,3),4096)}}},r.prototype.bI=function(){return this.Q5},r.prototype.mI=function(t,n,e,i,r){!et(i)&&t&&(t[n]===ot&&(t[n]=[]),t[n][e]===ot&&(t[n][e]={}),t[n][e][u[r]]=i)},r.prototype.yI=function(t){var n,e,i,r,o,a,u,s,c;if(t)for(e=(n=this).Q5,i=0,r=t.length;i<r;i++)if(o=t[i])for(a=0,u=o.length;a<u;a++)(s=o[a])&&(e[i]||(e[i]=[]),(c=e[i][a])?n.wI(s,c)&&(e[i][a]=ot):e[i][a]=s)},r.prototype.wI=function(t,n){var e,i,r,o,a,e=this.W5,i=[];for(256&e&&i.push(u[256]),4&e&&i.push(u[4]),2&e&&i.push(u[2]),16&e&&i.push(u[16]),64&e&&i.push(u[64]),128&e&&i.push(u[128]),1024&e&&i.push(u[1024]),2048&e&&i.push(u[2048]),4096&e&&i.push(u[4096]),1&e&&i.push(u[1]),r=0,o=i.length;r<o;r++)if(t[a=i[r]]!==n[a])return!1;return!0},r.prototype.MI=function(){var t,n,e,i,r,o,a,u,s,c,t=this,n=t.Z5.row,e=t.Z5.col,i=t.Q5,r=t.K5;if(!(r&&0<r.length)){for(r=[],n=-1===n?0:n,e=-1===e?0:e,o=0,a=i.length;o<a;o++)if(u=i[o])for(s=0,c=u.length;s<c;s++)u[s]&&r.push({row:o+n,col:s+e});t.K5=r}return r},pn=r,ut.CI=pn,ut.SI=function(t,n,e,i,r,o,a,u,s,c){t&&(n<0&&(n=0,i=st(t)),e<0&&(e=0,r=ct(t)),t.SI(n,e,i,r,o,a,ot,ot,u,s,c))},ut.TI=function(t){return"changes"+t},ut.AI=function(t){return t&&(0!==t.length||!b.isEmptyObject(t))},ut.lM=function(n){var t,e,e=n.sheetName;return"string"==typeof e?t=[e]:Array.isArray(e)&&(t=e),!!t&&t.every(function(t){var t,t,t=ut.TI(t),t=n[t];return t&&0===t.length&&b.isEmptyObject(t)})},ut.startTransaction=function(t,n){Ce(t,n.sheetName).forEach(function(t){t.Ut.startTransaction()})},ut.endTransaction=function(t,e){Ce(t,e.sheetName).forEach(function(t){var n=ut.TI(t.name());e[n]=t.Ut.endTransaction()})},ut.undoTransaction=function(t,e){Ce(t,e.sheetName).forEach(function(t){var n=ut.TI(t.name());t.Ut.undo(e[n]),t.zw()})},ut.II=function(t){t.forEach(function(t){var t=Se(t);t&&t.Ut.startTransaction()})},ut.startTransactionAll=function(t){ut.II(t)},ut.xI=function(t,i){var r=[];t.forEach(function(t){var t,n,e,t,t=Se(t);t&&(n=t.name(),e=ut.TI(n),t=t.Ut.endTransaction())&&(i[e]=t,r.push(n))}),i.sheetNames=r},ut.endTransactionAll=function(t,n){ut.xI(t,n)},ut.NI=function(t,e){t.forEach(function(t){var t,n,t=Se(t);t&&(n=ut.TI(t.name()),t.Ut.undo(e[n]))})},Te.prototype.execute=function(){},Te.prototype.canExecute=function(){return!0},Te.prototype.canUndo=function(){return!0},Te.prototype.undo=function(){return!0},ut.ActionBase=e=Te,n(Ie,jn=e),Ie.prototype.execute=function(){var t,n,e,i,r,o,a,t,u,s,c,f,l,h,d,v,m,g,p,t=this,n=!1;if(t.canExecute()&&(e=t.tT,i=t.Mf,r=e.columns,o=e.rowHeader,a=r&&r.length,i)&&0<a){if(t=t.kI(r),u={sheet:i,sheetName:i.name(),colList:t,header:o,cancel:!1},i.ki(w,u),!0===u.cancel)return n;e.DI=!0,i.Ut.startTransaction(),M(i);try{for(s=2,c=3,f=ct(i,o?2:3),i.Ab=e.Ab,l=e.size,h=0;h<a;h++)for(v=(d=r[h]).firstCol,m=d.lastCol,g=v;g<=m;g++)0<=g&&g<f&&(o&&i.getColumnResizable(g,2)&&l!==i.Do(g,2)?(i.setColumnWidth(g,l,2),n=!0):!o&&i.getColumnResizable(g,3)&&l!==i.Do(g,3)&&(i.setColumnWidth(g,l,3),n=!0))}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(N,{sheet:i,sheetName:i.name(),colList:t,header:e.rowHeader}),ht(i),e[p=ut.TI(i.name())]=i.Ut.endTransaction()}i.ow()}return n},Ie.prototype.undo=function(){var t,n,e,i,r,o,a,a,t,u,t=this,n=!1;if(t.canUndo()&&(e=t.tT,i=t.Mf,r=e.columns,o=e.rowHeader,a=r&&r.length,i)&&0<a){if(a=t.kI(r),t={sheet:i,sheetName:i.name(),colList:a,header:o,cancel:!1},i.ki(w,t),!0===t.cancel)return n;M(i);try{u=ut.TI(i.name()),i.Ut.undo(e[u]),i.Zw=!0,i.showCell(i.getActiveRowIndex(),i.getActiveColumnIndex(),1,1),n=!0}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(N,{sheet:i,sheetName:i.name(),colList:a,header:e.rowHeader}),ht(i)}}return n},Ie.prototype.kI=function(t){for(var n,e,i,r,o,a,u,n=[],e=0,i=t.length;e<i;e++)for(o=(r=t[e]).firstCol,a=r.lastCol,u=o;u<=a;u++)n.push(u);return n},Ie.prototype.canUndo=function(){return this.tT.DI},bn=Ie,n(xe,En=e),xe.prototype.execute=function(){var t,n,e,i,r,o,t,a,u,s,c,f,l,h,d,v,m,g,p,t=this,n=!1;if(t.canExecute()&&(e=t.Mf,o=(r=(i=t.tT).rows)&&r.length,e)&&0<o){if(t=t._I(r),a={sheet:e,sheetName:e.name(),rowList:t,header:i.columnHeader,cancel:!1},e.ki(k,a),!0===a.cancel)return n;i.DI=!0,e.Ut.startTransaction(),M(e);try{for(u=3,s=1,f=st(e,(c=i.columnHeader)?1:3),e.Tb=i.Tb,l=i.size,h=0;h<o;h++)for(v=(d=r[h]).firstRow,m=d.lastRow,g=v;g<=m;g++)0<=g&&g<f&&(c&&e.getRowResizable(g,1)&&l!==e._o(g,1)?(e.setRowHeight(g,l,1),n=!0):!c&&e.getRowResizable(g,3)&&l!==e._o(g,3)&&(e.setRowHeight(g,l,3),n=!0))}finally{dt(e),b[b.sd]({jS:e.parent}),e.ki(_,{sheet:e,sheetName:e.name(),rowList:t,header:i.columnHeader}),ht(e),i[p=ut.TI(e.name())]=e.Ut.endTransaction()}e.tw()}return n},xe.prototype.undo=function(){var t,n,e,i,r,o,o,t,a,t=this,n=!1;if(t.canUndo()&&(e=t.Mf,o=(r=(i=t.tT).rows)&&r.length,e)&&0<o){if(o=t._I(r),t={sheet:e,sheetName:e.name(),rowList:o,header:i.columnHeader,cancel:!1},e.ki(k,t),!0===t.cancel)return n;M(e);try{a=ut.TI(e.name()),e.Ut.undo(i[a]),e.Ww=!0,e.showCell(e.getActiveRowIndex(),e.getActiveColumnIndex(),1,1),n=!0}finally{dt(e),b[b.sd]({jS:e.parent}),e.ki(_,{sheet:e,sheetName:e.name(),rowList:o,header:i.columnHeader}),ht(e)}}return n},xe.prototype._I=function(t){for(var n,e,i,r,o,a,u,n=[],e=0,i=t.length;e<i;e++)for(o=(r=t[e]).firstRow,a=r.lastRow,u=o;u<=a;u++)n.push(u);return n},xe.prototype.canUndo=function(){return this.tT.DI},wn=xe,n(Ne,On=e),Ne.prototype.execute=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,t=this,n=!1,e=t.tT,i=t.Mf,r=e.columns,o=e.rowHeader,a=t.kI(r);if(i&&r&&0<r.length){if(u={sheet:i,sheetName:i.Zc,colList:a,header:o,cancel:!1},i.ki(w,u),!0===u.cancel)return n;i.Ut.startTransaction(),t.X5(i);try{s=j(e.size),c=o?2:3,f=r[0].firstCol,d=h=l=void 0,s!==(l=i.Do(f,c))&&(h=s-l,d=i.O5(f,c),i.setColumnWidth(f,s,c),i.setColumnWidth(d,i.Do(d,c)-h,c)),n=!0}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(N,{sheet:i,sheetName:i.Zc,colList:a,header:e.rowHeader}),ht(i),e[v=ut.TI(i.name())]=i.Ut.endTransaction()}}return n},Ne.prototype.undo=function(){var t,n,e,i,r,n,r,o,t=this.Mf,n=this.tT.columns,e=!1,i=this.tT,r=this.tT.rowHeader,n=this.kI(n),r={sheet:t,sheetName:t.Zc,colList:n,header:r,cancel:!1};if(t.ki(w,r),!0!==r.cancel){M(t);try{o=ut.TI(t.name()),t.Ut.undo(i[o]),e=!0}finally{dt(t),b[b.sd]({jS:t.parent}),t.ki(N,{sheet:t,sheetName:t.Zc,colList:n,header:i.rowHeader}),ht(t)}}return e},Ne.prototype.kI=function(t){for(var n,e,i,r,o,a,u,n=[],e=0,i=t.length;e<i;e++)for(o=(r=t[e]).firstCol,a=r.lastCol,u=o;u<=a;u++)n.push(u);return n},yn=Ne,n(ke,Rn=e),ke.prototype.execute=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,t=this,n=!1,e=t.tT,i=t.Mf,r=e.rows,o=e.columnHeader,a=t._I(r);if(i&&r&&0<r.length){if(u={sheet:i,sheetName:i.Zc,rowList:a,header:o,cancel:!1},i.ki(k,u),!0===u.cancel)return n;i.Ut.startTransaction(),t.X5(i);try{s=j(e.size),c=o?1:3,f=r[0].firstRow,d=h=l=void 0,s!==(l=i._o(f,c))&&(h=s-l,d=i.j5(f,c),i.setRowHeight(f,s,c),i.setRowHeight(d,i._o(d,c)-h,c)),n=!0}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(_,{sheet:i,sheetName:i.Zc,rowList:a,header:e.columnHeader}),ht(i),e[v=ut.TI(i.name())]=i.Ut.endTransaction()}}return n},ke.prototype.undo=function(){var t,n,e,i,r,n,r,o,t=this.Mf,n=this.tT.rows,e=!1,i=this.tT,r=this.tT.columnHeader,n=this._I(n),r={sheet:t,sheetName:t.Zc,rowList:n,header:r,cancel:!1};if(t.ki(k,r),!0!==r.cancel){M(t);try{o=ut.TI(t.name()),t.Ut.undo(i[o]),e=!0}finally{dt(t),b[b.sd]({jS:t.parent}),t.ki(_,{sheet:t,sheetName:t.Zc,rowList:n,header:i.columnHeader}),ht(t)}}return e},ke.prototype._I=function(t){for(var n,e,i,r,o,a,u,n=[],e=0,i=t.length;e<i;e++)for(o=(r=t[e]).firstRow,a=r.lastRow,u=o;u<=a;u++)n.push(u);return n},Mn=ke,n(a,Ln=e),a.prototype.canExecute=function(){var t=this.tT;return this.Mf&&t.columns&&0<t.columns.length},a.prototype.execute=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,t=this,n=!1;if(t.canExecute()){if(e=t.tT,i=t.Mf,r=t.nT,o=t.kI(e.columns),a=2===r,u={sheet:i,sheetName:i.name(),colList:o,header:a,cancel:!1},i.ki(w,u),!0===u.cancel)return n;for(e.DI=!0,c=(s=ct(i,r))-1,l=void(f=0),h=0,d=e.columns.length;h<d;h++)c=(l=e.columns[h].col)<c?l:c,f=f<l?l:f;tt.Be.Ll(i,0,c,st(i)-1,f),i.Ut.startTransaction(),M(i);try{for(v=void 0,h=0,d=e.columns.length;h<d;h++)0<=(m=e.columns[h].col)&&m<s&&i.getColumnResizable(m,r)&&((v=t.qf(m))===i.getColumnWidth(m,r)&&et(i.getColumnWidth(m,r,!0))||(i.setColumnWidth(m,v,r),n=!0))}finally{tt.Be.dl(),dt(i),b[b.sd]({jS:i.parent}),i.ki(N,{sheet:i,sheetName:i.name(),colList:o,header:a}),ht(i),e[g=ut.TI(i.name())]=i.Ut.endTransaction()}}return n},a.prototype.undo=function(){var t,n,e,i,r,t,r,o,a,t=this,n=!1;if(t.canUndo()){if(e=t.tT,i=t.Mf,r=t.nT,t=t.kI(e.columns),r=2===r,o={sheet:i,sheetName:i.name(),colList:t,header:r,cancel:!1},i.ki(w,o),!0===o.cancel)return n;M(i);try{a=ut.TI(i.name()),i.Ut.undo(e[a]),n=!0}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(N,{sheet:i,sheetName:i.name(),colList:t,header:r}),ht(i)}}return n},a.prototype.kI=function(t){for(var n,e,i,n=[],e=0;e<t.length;e++)i=t[e],n.push(i.col);return n},a.prototype.qf=function(t){return tt.mt.qf(t,this.Mf,this.nT,this.tT.autoFitType)},a.prototype.canUndo=function(){return this.tT.DI},Cn=a,n(c,Bn=e),c.prototype.canExecute=function(){var t=this.tT;return this.Mf&&t.rows&&0<t.rows.length},c.prototype.execute=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,t=this,n=!1;if(t.canExecute()){if(e=t.tT,i=t.Mf,r=t._I(e.rows),o=t.nT,a=1===t.nT,u={sheet:i,sheetName:i.name(),rowList:r,header:a,cancel:!1},i.ki(k,u),!0===u.cancel)return n;e.DI=!0,i.Ut.startTransaction(),M(i);try{for(s=st(i,o),c=void 0,f=0,l=e.rows.length;f<l;f++)0<=(h=e.rows[f].row)&&h<s&&i.getRowResizable(h,o)&&((c=t.e0(h))===i.getRowHeight(h,o)&&et(i.getRowHeight(h,o,!0))||(i.setRowHeight(h,c,o),n=!0))}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(_,{sheet:i,sheetName:i.name(),rowList:r,header:a}),ht(i),e[d=ut.TI(i.name())]=i.Ut.endTransaction()}}return n},c.prototype.undo=function(){var t,n,e,i,r,t,o,a,t=this,n=!1;if(t.canUndo()){if(e=t.tT,i=t.Mf,r=t._I(e.rows),t=1===t.nT,o={sheet:i,sheetName:i.name(),rowList:r,header:t,cancel:!1},i.ki(k,o),!0===o.cancel)return n;M(i);try{a=ut.TI(i.name()),i.Ut.undo(e[a]),n=!0}finally{dt(i),b[b.sd]({jS:i.parent}),i.ki(_,{sheet:i,sheetName:i.name(),rowList:r,header:t}),ht(i)}}return n},c.prototype._I=function(t){for(var n,e,i,r,n=[],e=0,i=t.length;e<i;e++)r=t[e],n.push(r.row);return n},c.prototype.e0=function(t){return tt.mt.e0(t,this.Mf,this.nT,this.tT.autoFitType)},c.prototype.canUndo=function(){return this.tT.DI},Sn=c,n(f,Fn=e),f.prototype.canExecute=function(){var t,n,e,i,t,r,o,a,t=this,n=t.Mf,e=t.tT,i=e.ranges,t=e.row,r=e.col;if(i){for(o=0;o<i.length;o++)if(a=i[o],!n.PT(a.row,a.col,ft(a),lt(a),ot,ot,ot,ot,ot,e.sheetArea))return!1}else if(!n.PT(t,r,1,1,ot,ot,ot,ot,ot,e.sheetArea))return!1;return!0},f.prototype.EI=function(t){var n,e,i,r,o,a,u,n,e=this.tT,i=e.ranges;if(i)for(r=0;r<i.length;r++)for(a=(o=i[r]).row;a<o.row+ft(o);a++)for(u=o.col;u<o.col+lt(o);u++)t(a,u);else t(e.row,e.col)},f.prototype.undo=function(){var t,e,t,n,t=this;if(t.canUndo()){e=t.Mf,t=t.tT,M(e,!0);try{e.D3(g+gn,function(t,n){_e(e,n)}),n=ut.TI(e.name()),e.Ut.undo(t[n])}catch(t){return!1}finally{e._3(g+gn),C(e,!0)}return!0}return!1},f.prototype.execute=function(){var t,n,e,i,t=this,n=!1;if(t.canExecute()){i=(e=t.Mf).parent.i4(),ut.II(i),M(e,!0);try{e.D3(g+gn,function(t,n){_e(e,n)}),t.tT.applyResult=t.jI(),n=!0}catch(t){n=!1}finally{e._3(g+gn),ut.xI(i,t.tT),C(e,!0)}}return n},f.prototype.OI=function(t,n){return t+"_"+n},f.prototype.RI=function(t){var n,e,i,r,o,a,u,s,c,r,u,f,r,u,l,n=this,e=0,i=n.Mf,r=n.tT,o=r.row,a=r.col,u=r.sheetArea,s=r.newValue,c=!r.hasOwnProperty("autoFormat")||r.autoFormat;if(F&&!0!==r.ignoreFormula&&(0,tt.kf)(s)){if(i.getDataValidator&&i.getDataValidator(o,a,u)&&""!==(r="="===s[0]?s.substring(1):s)&&r!==i.getFormula(o,a,u)&&(u=i.op())){f=void 0;try{f=u.parse(i.Uw(),r,0<=o?o:0,0<=a?a:0,!0)}catch(t){e=i.GA(o,a)}f&&(r=u.BI(i.Uw(),f,{row:o,col:a}),i.isValid)&&!i.isValid(o,a,r,!1)&&(e=i.GA(o,a))}}else u=n.LI(o,a,s,c,t),(l=!i.isValid||i.isValid(o,a,u,!1))||(e=i.GA(o,a),i.rt.FI=!0);return e},f.prototype.jI=function(){var t,i,n,r,o,e,a,u,s,e,c,f,l,h,d,v,m,g,l,p,b,w,w,l,b,n,d,t=this,i=t.Mf,n=t.tT,r=n.sheetArea,o=n.newValue,e=n.ignoreValidate,a={GI:!1,UI:!1,_autoFormatter:ot,quotePrefix:ot},u=0;if(!0===e||1!==(u=t.RI(a))&&2!==u){if(e=!n.hasOwnProperty("autoFormat")||n.autoFormat,c=0<=(c=n.row)?c:0,f=0<=(f=n.col)?f:0,l=F&&A&&A.Parser,m=i.parent,!(g=i.NMi&&3===r)&&l)if(v=i.op(),l=m&&m.options.allowUserEditFormula,b=!1,"@"!==(p=i.getFormatter(c,f,r))&&l&&v&&!0!==n.ignoreFormula&&(0,tt.kf)(o)){"="===o[0]&&(o=o.substring(1),b=!0);try{if(w={row:c,col:f,sheetArea:r,text:o,isAllow:!0},T.Worksheet.et(i,"applyEditingSetFormula",w),w.isAllow){if(n.ranges&&1===n.endEditType)return d=n.ranges[0],i.setArrayFormula(d.row,d.col,ft(d),lt(d),o,r),u;h=v.parse(i.Uw(),o,c,f,!0)}}catch(t){if(!m||!m.options.allowInvalidFormula)throw i.jT(0,"string"==typeof t?t:t.message),t;o=b?"="+o:o}}else n.ranges&&1===n.endEditType&&(d=n.ranges[0],i.getRange(d.row,d.col,ft(d),lt(d),r).clear(1));h||(o&&"'"===o[0]?t.HI(c,f,!0,a):t.HI(c,f,ot,a),s=t.LI(c,f,o,e,a)),t.EI(function(n,e){if(h)try{var t=v.unparse(i.Uw(r),h,n,e);i.zI(n,e,t,h,ot,r),i.ki(tt.Events.UserFormulaEntered,{sheet:i,sheetName:i.name(),row:n,col:e,isCircularReference:i.VI(n,e),formula:t}),m&&m.options.formulaFormatHint&&(0,I.Fue)(i,m,h,c,f)}catch(t){throw i.jT(0,"string"==typeof t?t:t.message),t}else{try{i.hasFormula&&i.hasFormula(n,e,r)&&i.setFormula(n,e,rt,r)}catch(t){throw i.jT(0,"string"==typeof t?t:t.message),t}try{i.YI(n,e,s,r),"string"!=typeof s&&null!==s||T.Worksheet.et(i,"setHyperlinkWhenEditing",{url:s,row:n,col:e,sheetArea:r})}catch(t){i.setValue(n,e,o,r)}}}),l=a.UI,((w=a.GI)||l)&&(n="string"==typeof(b=i.vI(c,f,r)),b&&!n||(d=new y.Style,n&&(d.parentName=b),b=d),w&&(b._autoFormatter=a._autoFormatter),l&&(b.quotePrefix=a.quotePrefix),i.setStyle(c,f,b,r))}return u},f.prototype.canUndo=function(){return 0===this.tT.applyResult},f.prototype.LI=function(t,n,e,i,r){var o,a,o,u,a,t,n,u,e,o=this,a=o.Mf,o=o.tT,u=o.ignoreFormatting,a=a.getActualStyle(t,n),t={},n="string"!=typeof e||u?e:e&&"'"===e[0]?e.substring(1):tt.mt.Xf(a,e,i,t,o.editingFormatter);return r.quotePrefix?(r._autoFormatter=ot,r.GI=!0):(u=t.value,i&&u&&((n===(e=rt)||"General"===u.formatString())&&a._autoFormatter||(u.isAuto=!0,e=u),e)&&(r.GI=!0,r._autoFormatter=e)),n},f.prototype.HI=function(t,n,e,i){var r,o,t,n,a,r,o,t=this.Mf.vI(t,n),n="string"==typeof t;t&&!n||(a=new y.Style,n&&(a.parentName=t),t=a),t.quotePrefix!==e&&(i.UI=!0,i.quotePrefix=e)},Tn=f,n(Ee,Pn=e),Ee.prototype.canUndo=function(){return!!this.tT.oldName},Ee.prototype.canExecute=function(){var t,n,t=this,n=t.tT;return t.Mf&&n.name&&n.name!==n.oldName},Ee.prototype.execute=function(){var t,n,e,i,r,t,o,a,a,u,s,t=this,n=t.Mf,e=t.tT,i=e.name,r=!1;return t.canExecute()&&(t=n.name(),n.ki(tt.Events.SheetNameChanging,a={sheet:n,oldValue:t,newValue:o=i,cancel:!1}),!1===a.cancel)&&(a=n.parent.sheets,ut.II(a),u=null,n.parent.options&&n.parent.options.saveChangesForSheet&&je(u=n.getCrossSheetReferences(),!0),e.oldName=t,M(n,!0),Xn(n),n.ub(i),De(n),u&&je(u,!1),ut.xI(a,e),r=!0,e.sheetName=i,qn(n,!1),C(n,!0),n.ki(tt.Events.SheetNameChanged,s={sheet:n,oldValue:t,newValue:o})),r},Ee.prototype.undo=function(){var t,n,t,e,i,r,r,o,t=this;return!(!t.canUndo()||(n=t.Mf,e=(t=t.tT).name,i=t.oldName,n.ki(tt.Events.SheetNameChanging,r={sheet:n,oldValue:e,newValue:i,cancel:!1}),!1!==r.cancel)||(M(n,!0),Xn(n),r=ut.TI(n.name()),n.Ut.undo(t[r]),De(n),t.sheetName=t.oldName,qn(n,!1),C(n,!0),n.ki(tt.Events.SheetNameChanged,o={sheet:n,oldValue:e,newValue:i}),0))},An=Ee,n(Oe,Gn=e),Oe.prototype.canExecute=function(){var t,n,t=this,n=tt.mt.ige(t.tT.zoomFactor);return t.Mf&&t.Mf.parent.options.allowUserZoom&&t.Mf.zoom()!==n},Oe.prototype.execute=function(){var t,n,e,t,i,r,o,t=this,n=t.tT,e=!1;return t.canExecute()&&(i=(t=t.Mf).Ut,r=n.zoomFactor,i.startTransaction(),e=Re(t,r),i.ZI(["zoomChanged",r,n.oldZoomFactor]),n[o=ut.TI(t.name())]=t.Ut.endTransaction()),e},Oe.prototype.undo=function(){var t,n,t=this.Mf;if(this.canUndo())return!(!0===t.isEditing()&&!t.endEdit()||(t.suspendPaint(),n=ut.TI(t.name()),t.Ut.undo(this.tT[n]),t.resumePaint(),0))},In=Oe,n(ze,Un=e),ze.prototype.execute=function(){var t,n,e,i,e,r,o,a,e,u,u,t=this,n=t.Mf;t.canExecute()&&n&&(e=t.tT.clearRange,i=n.tables&&n.tables.WI&&n.tables.WI(e.row,e.col,e.rowCount,e.colCount),n.isDirtySuspended()||(t.tT.K5=new pn(n,n.JS(e),3)),i&&0<i.length&&(t.tT.tableNames=i),r=(e=n.JS(e)).row,o=e.col,a=ft(e),0<(e=lt(e)))&&0<a&&(n.Ut.startTransaction(),M(n),n.QI=!0,n.KI(r,o,a,e,3,257,!0),C(n),n.QI=!1,u=ut.TI(n.name()),t.tT[u]=n.Ut.endTransaction(),u=t.tT.K5,ut.SI(n,r,o,a,e,u?u.MI():[],2,i))},ze.prototype.canExecute=function(){var t=this.tT.clearRange;return this.Mf&&this.Mf.PT(t.row,t.col,ft(t),lt(t),ot,ot,ot,ot,ot,nt.SheetArea.viewport)},ze.prototype.canUndo=function(){var t,t;if(this.Mf)return t=ut.TI(this.Mf.name()),t=this.tT[t],ut.AI(t)},ze.prototype.undo=function(){var t,n,e,i,i,t=this,n=t.Mf;if(t.canUndo()&&n&&0<lt(e=n.JS(t.tT.clearRange))&&0<ft(e)){M(n),n.QI=!0;try{i=ut.TI(n.name()),n.Ut.undo(t.tT[i])}finally{C(n),n.QI=!1}return i=t.tT.K5,ut.SI(n,e.row,e.col,ft(e),lt(e),i?i.MI():[],2,t.tT.tableNames,!0),!0}return!1},ze.prototype.toJSON=function(){var t=this;return{sheetName:t.Mf?t.Mf.name():"",command:t.tT}},ze.prototype.fromJSON=function(t){var n,e,i,n=this,e=t.sheetName;n.Mf&&!et(e)&&(i=n.Mf.parent,n.Mf=i.getSheetFromName(e)),n.tT=t.command},xn=ze,ut.ClearRangeValueUndoAction=xn,n(Ye,Hn=e),Ye.prototype.canExecute=function(){var t,n,e,t=this.tT.cachedActions;if(t){for(n=0;n<t.length;n++)if(!(e=t[n]).canExecute())return!1;return!0}return!1},Ye.prototype.execute=function(){var t,n,t,e,i,t=this;if(t.canExecute()&&(n=t.tT.cachedActions,t=t.Mf,n)){for(M(t,!0),e=0;e<n.length;e++)(i=n[e]).execute();return C(t,!0),!0}return!1},Ye.prototype.canUndo=function(){var t,n,e,t=this.tT.cachedActions;if(t){for(n=0;n<t.length;n++)if(!(e=t[n]).canUndo())return!1;return!0}return!1},Ye.prototype.undo=function(){var t,n,e,i,r,r,t=this,n=t.tT.cachedActions;if(t.canUndo()){for(e=t.Mf,i=n.length-1;0<=i;i--)if(r=n[i],M(e,!0),r=r.undo(),C(e,!0),!r)return!1;return!0}return!1},Nn=Ye,ut.JI=Nn,n(vt,Vn=e),vt.WT=function(t){var n=0;return 0!==t&&1!==t||(n|=1),0!==t&&2!==t||(n|=608),0!==t&&3!==t||(n|=2),0!==t&&4!==t||(n|=609),0!==t&&5!==t||(n|=610),0===t&&(n|=8116),n},vt.prototype.canExecute=function(){var t,n,e,i,r,i,e,t=this,n=t.tT,e=n.pasteExtent,i=e.targetRange,r=e.sourceRange,i=n.toSheet.PT(i.row,i.col,i.rowCount,i.colCount,ot,ot,ot,ot,ot,nt.SheetArea.viewport)||Wn(n.toSheet,t.tT.pasteOption),e=!e.isCutting||n.fromSheet.PT(r.row,r.col,r.rowCount,r.colCount,ot,ot,ot,ot,rt,nt.SheetArea.viewport)||Wn(n.fromSheet,t.tT.pasteOption);return i&&e},vt.prototype.XI=function(){var t,n,e,i,r,o,n,a,t,t=this,n=t.tT.pasteExtent,e=t.tT.Kh={},i=n.isCutting,r=vt.WT(t.tT.pasteOption),o=n.sourceRange,n=n.targetRange,a=t.tT.fromSheet,t=t.tT.toSheet;a&&o&&i&&!a.isDirtySuspended()&&(e.qI=new pn(a,o,r)),t.isDirtySuspended()||(e.$I=new pn(t,n,r))},vt.prototype.nx=function(){return this.tT.pasteExtent.targetRange},vt.prototype.ex=function(t,n,e,i,r,o){var L,a,u,s,c,o,B,F,P,G,U,H,f,l,h,d,v,m,g,p,V,z,Y,Z,W,b,w,y,M,C,S,T,A,I,Q,i,x,N,k,_,D,J,K,j,X,E,q,$,O,D,R,M,b,w,O,b,h,v,D,w,M,T,b,L=!1,a=n.row,u=n.col,s=n.rowCount,c=n.colCount,o=r!==o,B=!1,F=!1,P=!1,G=!1,U=Yn(r),H=!1,f=r.o5(),m=r.getRowCount(),g=r.getColumnCount(),p=s,V=c,z=0,Y=0,Z=0,W=0;if(f&&(p-=r.ix(a,p,!0),V-=r.ix(u,V)),b=r.tables&&r.tables.AB(a,u,s,c),y=Fe(e,g),M=Pe(e,m),A=this.bx,I=this.kse,Q=i===nt.InsertShiftCell.right,i=i===nt.InsertShiftCell.down,D=w=!1,-1===(x=e.row)&&(D=!(x=0)),-1===(N=e.col)&&(N=0),-1===(k=e.rowCount)&&(k=m),-1===(_=e.colCount)&&(_=g),-1===u&&(u=0),J=!1,I){if(1<b.length)return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};if(1===b.length){if(C=b[0])if(S=C.Tx,T=C.Sx,Q){if(!o&&(T+C.Ky!==k&&(u!==C.iw||k<C.Ky+T)&&!(k<=C.Ky||!t&&u===C.iw&&p%k==0)||!A&&t&&Le(r,e)))return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};u===C.iw&&p%k==0||(w=!0),-1===a&&(J=!(a=0)),u===C.iw&&(C=ot)}else if(i){if(!o&&y&&a<=x&&_>C.iw&&_<C.iw+C.Tx&&(t||V%_!=0))return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};_===S&&0===C.iw&&a!==C.Ky&&(w=!0),-1===u&&(J=!(u=0)),a===C.Ky&&(C=ot)}}else if(t&&(!y||M)&&r.tables&&r.tables.Uue(e))return r.jT(1,at().Exp_InsertCopiedCutCellsAffectTable),{returnFunc:!0}}if(I&&C&&(K=C.name()),w||t||C&&!y||!(Q&&p%k==0||i&&V%_==0)){if(Q){if(b=void 0,l=a,d=M=k,w=!C||!I||A||!Pe(n,m),O=C&&k<=C.Ky,j=w||O,f&&(M+=b=r.lT(a,M),d+=b),b=!1,!o){if(v=(h=x)+k,j&&a!==h&&(0!==x||-1!==a||!D)&&e.intersect(a,u,M,r.getColumnCount()-u))return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(!C&&I&&Ve(e,n,a,u))return r.jT(1,at().Exp_InsertCopiedCutCellsOverlap),{returnFunc:!0};if(N<u&&u<=N+_-1&&h<a&&a<=v-1)return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(this.rx(r,a,u,M,r.getColumnCount()-u,K)||!j&&C&&u<N&&h>=C.Ky&&h<C.Ky+T&&v>C.Ky+T)return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};if(!A&&t&&N<u&&!Ue(r,e)&&He(r,x,N+_,k,u-N-_+(C?C.Tx-(u-C.iw):0)))return r.jT(1,at().Exp_InsertCopiedCutCellsAffectTable),{returnFunc:!0};if(!w&&C)if(O)q=k;else{if(0!==C.Ky&&u!==C.iw)return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};u===C.iw&&(b=!0),u<N&&h>=C.Ky&&v<=C.Ky+T&&k===C.Sx&&(E=_),q=b?k:C.Sx}}if(o||(a!==x&&-1!==a||!(u<=N)||C&&!b&&!O)&&et(E)||(f?(e.col+=e.colCount,e.col=r.O5(e.col-1),Y=r.lT(e.col,e.colCount),e.colCount+=Y):e.col=e.col+(et(E)?e.colCount:E),B=!0),h=r.getColumnCount()-e.colCount,v=e.colCount,f&&(W=r.lT(u,e.colCount),h=g-(v=(D=e.colCount+W)+r.ox(g-1,D)),B)&&(e.col+=W),(H=this.ax(r,l,h,d,v))&&!U)return r.jT(1,at().Exp_InsertCopiedCutCellsNoRange),{returnFunc:!0}}else if(i){if(M=void 0,h=u,v=w=_,j=!C||!I||A||Fe(n,g)||_<=C.iw,f&&(w+=M=r.lT(u,w),v+=M),!j&&C&&y&&(_<S||_<C.iw+S||(!C.showHeader||C.Ky!==a)&&_!==C.iw+S))return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};if(!o){if(C&&y&&C.iw<w&&C.iw+C.Tx!==w&&e.intersect(a,u,r.getRowCount()-a,w))return r.jT(1,at().Exp_InsertCopiedCutCellsOverlap),{returnFunc:!0};if(!C&&I&&Ve(e,n,a,u))return r.jT(1,at().Exp_InsertCopiedCutCellsOverlap),{returnFunc:!0};if(y&&j&&u!==N&&e.intersect(a,u,r.getRowCount()-a,w))return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(y&&u!==N&&e.intersect(a,u,r.getRowCount()-a,e.colCount))return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(x<a&&a<=x+k-1&&N<u&&u<=N+w-1)return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(this.ux(r,a,u,r.getRowCount()-a,w,K))return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};if(!A&&t&&x<a&&!Ue(r,e)&&He(r,x+k,N,a-x-k+(C?C.Sx-(a-C.Ky):0),w))return r.jT(1,at().Exp_InsertCopiedCutCellsAffectTable),{returnFunc:!0};!j&&C&&(T=k,t&&(!y&&e.intersect(C.Ky,0,C.Sx,C.endColumn()+1)||new tt.Range(C.Ky,0,C.Sx,C.endColumn()+1).containsRange(e))&&(T=x+k-1-C.endRow()),r.getColumnCount()%w==0)&&(0<T?!y&&a<x?X=T:w===S&&($=S):t&&T<0&&(u===N||-1===u)&&a<=x&&(X=k))}if(o||et(X)&&(u!==N&&-1!==u||!(a<=x)||C&&!y)||(f?(e.row=e.row+e.rowCount,e.row=r.j5(e.row-1),z=r.lT(e.row,e.rowCount,!0),e.rowCount+=z):e.row=e.row+(et(X)?e.rowCount:X),F=!0),l=m-e.rowCount,d=e.rowCount,f&&(Z=r.lT(a,e.rowCount,!0),l=m-(d=(b=e.rowCount+Z)+r.ox(m-1,b,!0)),F)&&(e.row+=Z),(H=this.ax(r,l,h,d,v))&&!U)return r.jT(1,at().Exp_InsertCopiedCutCellsNoRange),{returnFunc:!0}}}else if(p%k==(D=O=0)&&V%_!=0?(c=n.colCount=_,f&&(O=r.lT(u,c),n.colCount=c+=O)):p%k!=0&&V%_==0&&(s=n.rowCount=k,f)&&(D=r.lT(a,s,!0),n.rowCount=s+=D),L=!0,Q){if(R=!1,j=!C||!I||A||!Pe(n,m),!o){if((a<=e.row&&a+s>=e.row+e.rowCount||J&&-1===e.row)&&(R=!0),!C&&I&&Ve(e,n,a,u))return r.jT(1,at().Exp_InsertCopiedCutCellsOverlap),{returnFunc:!0};if(N<u&&u<=N+_-1&&x<a&&a<=x+k-1)return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(!R&&e.intersect(a,u,s,g-u))return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(this.rx(r,a,u,s,g-u,K))return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};if(!j&&C&&k===C.Sx){if(0!==C.Ky)return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};u<N&&(E=c),q=C.Sx}(R&&u<=N&&(!C||y)||!et(E))&&(f?(e.col+=c,e.col=r.O5(e.col-1),Y=r.lT(e.col,c),e.colCount+=Y):e.col+=et(E)?c:E,P=!0)}if(l=a,d=s,h=g-c,v=c,f&&(h=g-(v=c+(W=r.ox(g-1,c))+O)),(H=this.ax(r,l,h,d,v))&&!U)return r.jT(1,at().Exp_InsertCopiedCutCellsNoRange),{returnFunc:!0}}else if(i){if(R=!1,j=!C||!I||A||Fe(n,g),!o){if(u<=N&&N+_<=u+c&&(R=!0),!C&&I&&Ve(e,n,a,u))return r.jT(1,at().Exp_InsertCopiedCutCellsOverlap),{returnFunc:!0};if(x<a&&a<=x+k-1&&N<u&&u<=N+_-1)return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(!R&&e.intersect(a,u,r.getRowCount()-a,c))return r.jT(1,at().Exp_InsertCopiedCutCells),{returnFunc:!0};if(this.ux(r,a,u,r.getRowCount()-a,c,K))return r.jT(1,at().Exp_InsertCopiedCutCellsOnSpanTable),{returnFunc:!0};if(x<a&&a<x+k||Fe(n,g)&&C&&_>C.iw&&C.iw+S>_&&e.intersect(a,u,r.getRowCount()-a,c))return r.jT(1,at().Exp_InsertCopiedCutCellsOverlap),{returnFunc:!0};!j&&C&&0<s&&r.getColumnCount()%_==0&&_===S&&0===C.iw&&($=S),(!C||y)&&R&&a<=x&&(f?(e.row+=s,e.row=r.j5(e.row-1),z=r.lT(e.row,s,!0),e.rowCount+=z):e.row+=s,G=!0)}if(l=r.getRowCount()-s,d=s,h=u,v=c,f&&(l=m-(d=s+(Z=r.ox(m-1,s,!0))+D)),(H=this.ax(r,l,h,d,v))&&!U)return r.jT(1,at().Exp_InsertCopiedCutCellsNoRange),{returnFunc:!0}}return{changePasteDataRangeCol:B,changePasteDataRangeRow:F,changePasteDataRangeCols:P,changePasteDataRangeRows:G,moveRangeHaveValue:H,returnFunc:!1,selectRange:L,adjustedTableRowCount:q,adjustedTableColCount:$,changePasteDataRangeRowInvisibleCount:z,changePasteDataRangeColInvisibleCount:Y,invisibleRowCountInAcRange:Z,invisibleColCountInAcRange:W}},vt.prototype.fx=function(L,t,n,B,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,t,p,b,w,y,F,M,C,S,T,A,I,x,N,P,G,k,_,D,j,E,O,U,R,c=!1,f=!1,l=this.kse,h=n.o5(),d=n.getColumnCount(),v=-1!==e.col&&e.colCount!==d,m=!1,g=t===nt.InsertShiftCell.right,t=t===nt.InsertShiftCell.down,p=Le(n,new tt.Range(i,r,t?1:o,g?1:a)),b=0;if(l&&p&&(-1===i&&(i=0),-1===r)&&(r=0),p&&(g&&r===p.iw||t&&i===p.Ky)&&(p=ot),L){if(g)if(n.mT(i,r+a,o,n.getColumnCount()-r-a,!0))if(w=p&&e.rowCount>p.Ky&&p.showHeader(),r+a<n.getColumnCount()){if(y=p&&r===p.iw,h)if(F=o,M=a+n.ox(n.getColumnCount()-1,a),i<0)n.moveTo(i,r,i,r+a,o,n.getColumnCount()-r-a,it,!0);else for(C=i;C<i+F&&C<n.getRowCount();C++)0!==n.getRowHeight(C)&&n.moveTo(C,r,C,r+a,1,n.getColumnCount()-r-M,it,!0);else l&&p&&!y&&(p.showFooter()||w)?(S=p.endRow(),p.showFooter()&&(b=S),e.rowCount>S+1&&n.moveTo(S+1,r,S+1,r+e.colCount,e.rowCount-S-1,n.getColumnCount()-r-e.colCount,it,!0)):n.moveTo(i,r,i,r+a,o,n.getColumnCount()-r-a,it,!0);this.lx(n,i,r,i,r+a),(A=(T=n.rowFilter())&&T.range)&&-1===i&&1<A.colCount&&r>A.col&&r<=A.col+A.colCount-1&&(A.colCount=A.colCount+e.colCount),l&&p&&(y||e.rowCount!==p.Sx&&!Pe(e,n.getRowCount())||(p.showFooter()||w?(p.insertColumns(r-p.iw,e.colCount),m=!0):p.K5t(new tt.Range(p.Ky,p.iw,p.Sx,p.Tx+a))))}else r+a>n.getColumnCount()&&(f=c=!0);else f=c=!0;else if(t)if(n.mT(i+o,r,n.getRowCount()-i-o,a,!0))if(i+o<n.getRowCount()){if(I=0,l&&p&&(N=(x=p.dataRange()).col+x.colCount,(P=i===p.Ky)||(I=o,0<(I=s&&e.row>=p.startRow()&&e.row<=p.endRow()?e.row+e.rowCount-1-p.endRow():I)&&(u=p.footerIndex())),!s&&v&&d%e.colCount==0||!v&&!Be(n,{row:e.row,col:N,rowCount:e.rowCount,colCount:e.colCount-N})||(m=!0)),h)if(G=a,k=o+n.ox(n.getRowCount()-1,o,!0),r<0)n.moveTo(i,r,i+o,r,n.getRowCount()-i-k,e.colCount,it,!0);else for(_=r;_<r+G&&_<n.getColumnCount();_++)0!==n.getColumnWidth(_)&&n.moveTo(i,_,i+o,_,n.getRowCount()-i-k,1,it,!0);else D=0<I,et(u)||-1===u?(D&&p.K5t(new tt.Range(p.Ky,p.iw,p.Sx+I,p.Tx)),n.moveTo(i,r,i+o,r,n.getRowCount()-i-o,a,it,!0)):(n.moveTo(u+1,r,u+1+o,r,n.getRowCount()-u-1-o,a,it,!0),D&&p.K5t(new tt.Range(p.Ky,p.iw,p.Sx+I,p.Tx)),0<(j=u+I-i-o)&&n.moveTo(i,r,i+o,r,j,a,it,!0));this.lx(n,i,r,i+o,r)}else i+o>n.getRowCount()&&(f=c=!0);else f=c=!0}else if(g)if(n.mT(i,r+e.colCount,e.rowCount,n.getColumnCount()-r-e.colCount,!0))if(r+e.colCount<n.getColumnCount()){if(y=p&&r===p.iw,w=p&&e.rowCount>p.Ky&&p.showHeader(),h)if(E=e.rowCount,M=(O=e.colCount+n.lT(r,e.colCount))+n.ox(n.getColumnCount()-1,O),i<0)n.moveTo(i,r,i,r+O,e.rowCount,n.getColumnCount()-r-M,it,!0);else for(C=i;C<i+E&&C<n.getRowCount();C++)0===n.getRowHeight(C)?E++:n.moveTo(C,r,C,r+O,1,n.getColumnCount()-r-M,it,!0);else l&&!s&&p&&!y&&(p.showFooter()||w)?(S=p.endRow(),p.showFooter()&&(b=S),e.rowCount>S+1&&n.moveTo(S+1,r,S+1,r+e.colCount,e.rowCount-S-1,n.getColumnCount()-r-e.colCount,it,!0)):n.moveTo(i,r,i,r+e.colCount,e.rowCount,n.getColumnCount()-r-e.colCount,it,!0);this.lx(n,i,r,i,r+e.colCount),(A=(T=n.rowFilter())&&T.range)&&-1===i&&1<A.colCount&&r>A.col&&r<=A.col+A.colCount-1&&(A.colCount=A.colCount+e.colCount),l&&p&&e.rowCount>p.Ky&&(y||e.rowCount!==p.Sx&&!Pe(e,n.getRowCount())||(s||!p.showFooter()&&!w?p.K5t(new tt.Range(p.Ky,p.iw,p.Sx,p.Tx+e.colCount)):(p.insertColumns(r-p.iw,e.colCount),m=!0)))}else r+e.colCount>n.getColumnCount()&&(f=c=!0);else f=c=!0;else if(t)if(n.mT(i+e.rowCount,r,n.getRowCount()-i-e.rowCount,e.colCount,!0))if(i+e.rowCount<n.getRowCount()){if(I=0,l&&p&&e.colCount>p.iw&&(N=(x=p.dataRange()).col+x.colCount,(P=i===p.Ky)||(I=e.rowCount,0<(I=s&&(!v&&e.intersect(p.Ky,0,p.Sx,p.endColumn()+1)||new tt.Range(p.Ky,0,p.Sx,p.endColumn()+1).containsRange(e))?e.row+e.rowCount-1-p.endRow():I)&&(u=p.footerIndex())),!s&&v&&d%e.colCount==0||!v&&!Be(n,{row:e.row,col:N,rowCount:e.rowCount,colCount:e.colCount-N})||(m=!0)),h)if(U=e.colCount,k=(R=e.rowCount+n.lT(i,e.rowCount,!0))+n.ox(n.getRowCount()-1,R,!0),r<0)n.moveTo(i,r,i+R,r,n.getRowCount()-i-k,e.colCount,it,!0);else for(_=r;_<r+U&&_<n.getColumnCount();_++)0===n.getColumnWidth(_)?U++:n.moveTo(i,_,i+R,_,n.getRowCount()-i-k,1,it,!0);else D=0<I,et(u)||-1===u?(D&&p.K5t(new tt.Range(p.Ky,p.iw,p.Sx+I,p.Tx)),n.moveTo(i,r,i+e.rowCount,r,n.getRowCount()-i-e.rowCount,e.colCount,it,!0)):(n.moveTo(u+1,r,u+1+e.rowCount,r,n.getRowCount()-u-1-e.rowCount,e.colCount,it,!0),D&&p.K5t(new tt.Range(p.Ky,p.iw,p.Sx+I,p.Tx)),0<(j=u+I-i-e.rowCount)&&n.moveTo(i,r,i+e.rowCount,r,j,e.colCount,it,!0));this.lx(n,i,r,i+e.rowCount,r)}else i+e.rowCount>n.getRowCount()&&(f=c=!0);else f=c=!0;return{ignoreTableExpand:m,ignoreTableFooterIndex:b,raiseInvalidOperation:c,returnFunc:f}},vt.prototype.lx=function(t,n,e,i,r){t.ki("shiftCellsDown",{row:i,col:r,changedRowCount:i-n,changedColCount:r-e,srcRow:n,srcColumn:e},!0)},vt.prototype.hx=function(t,n,e,i,r,o,a,u){var s,c,f,l,h,s=u.changePasteDataRangeRowInvisibleCount,c=u.changePasteDataRangeColInvisibleCount,f=u.invisibleRowCountInAcRange,l=u.invisibleColCountInAcRange,h=this.tT.pasteExtent.targetRange;t&&(n.colCount-=c,n.col-=n.colCount,n.col-=l,h.colCount-=c),e&&(n.rowCount-=s,n.row-=n.rowCount,n.row-=f,h.rowCount-=s),i&&(n.colCount-=c,n.col-=o,n.col-=l,h.colCount-=c),r&&(n.rowCount-=s,n.row-=a,n.row-=f,h.rowCount-=s),u.changePasteDataRangeRowInvisibleCount=0,u.changePasteDataRangeColInvisibleCount=0,u.invisibleRowCountInAcRange=0,u.invisibleColCountInAcRange=0},vt.prototype.vx=function(t,n){var e=[].concat(n.parent.sheets);return t&&t.NMi&&e.push(t),n&&n!==t&&n.NMi&&e.push(n),e},vt.prototype.Ufe=function(t,n,e,i){var e,i,r,o,a;n&&e&&i!==ot&&(e=n.Ky,i=n.iw,r=n.Sx,o=n.Tx,a={showHeader:n.showHeader(),showFooter:n.showFooter(),useFooterDropDownList:n.useFooterDropDownList(),showResizeHandle:n.showResizeHandle()},t.tables._Qt(n.name(),e,i,r,o,n.style(),a,!0),n.L0())},vt.prototype.execute=function(){var n,t,e,i,L,r,o,a,u,s,c,f,l,h,d,v,B,F,P,m,G,U,H,V,g,p,z,Y,Z,W,b,b,w,b,w,b,y,M,C,S,T,A,I,x,N,k,_,Q,J,K,D,X,j,E,O,R,q,$,g,C,I,T,A,p,k,x,S,n=this;if(n.canExecute()&&(t=n.tT.fromSheet,e=n.tT.toSheet,i=n.tT.pasteExtent,L=n.tT.pasteOption,r=i.sourceRange,o=i.targetRange,a=i.isCutting,!t||!r||t.zT(r.row,r.col,ft(r),lt(r),st(t),ct(t)))&&e&&o&&e.HT(o.row,o.col,ft(o),lt(o),!0)&&!(e.tables&&e.tables.mx(t,r,e,o,a)||e.pivotTables&&e.pivotTables.KYt(r,o,e))){if(f=c=s=u=void 0,t&&(c=t.ST(),u=n.sA,s=n.fA)&&(f=new tt.Range(s.row,s.col,s.rowCount,s.colCount)),v=d=h=l=void 0,n.cA&&(l=n.cA.row,h=n.cA.col,d=n.cA.rowCount,v=n.cA.colCount),F=n.kse,P=e===t,m=B=void 0,g=Yn(e),p=V=H=U=G=!1,W=Z=Y=z=0,u!==ot&&s){if(P&&a&&u===nt.InsertShiftCell.right&&Pe(s,e.getRowCount())&&(m=Le(e,s))&&(b=Le(e,new tt.Range(l,h,d,v)))&&b.name()===m.name()&&(n.tT.Hfe=m,e.tables.remove(m,1)),(b=this.ex(a,n.cA,s,u,e,t)).returnFunc)return void n.Ufe(e,m,a,u);G=b.changePasteDataRangeCol,U=b.changePasteDataRangeRow,z=b.changePasteDataRangeRowInvisibleCount,Y=b.changePasteDataRangeColInvisibleCount,Z=b.invisibleRowCountInAcRange,W=b.invisibleColCountInAcRange,H=b.changePasteDataRangeCols,V=b.changePasteDataRangeRows,p=b.moveRangeHaveValue,B=b.selectRange,d=n.cA.rowCount,v=n.cA.colCount,o.rowCount+=z,o.colCount+=Y,w=b.adjustedTableRowCount,b=b.adjustedTableColCount,et(w)||(o.row=0,o.rowCount=w),et(b)||(o.col=0,o.colCount=b)}n.XI(),w=n.vx(t,e),ut.II(w),Jn(e),Kn(e),b=!(e.QI=!0),M=y=void 0,t&&(Kn(t),t.QI=!0);try{if(g){if((S=C=-1)!==o.row?C=o.row+ft(o):-1===r.row&&(C=st(t)),A=C-(T=st(e)),I=T<C,x=at().Exp_InvalidCopyPasteSize,I&&n.gx(r,o))u===nt.InsertShiftCell.down&&p?e.addRows(T,T-l+A):e.addRows(T,A);else if(p||l+o.rowCount!==T||u!==nt.InsertShiftCell.down){if(p&&u===nt.InsertShiftCell.down)e.addRows(T,T-l+A);else if(I)return b=!0,y=1,M=x,void n.Ufe(e,m,a,u)}else e.addRows(T,T-l+A-f.rowCount);if(-1!==o.col?S=o.col+lt(o):-1===r.col&&(S=ct(t)),(k=(N=ct(e))<S)&&n.gx(r,o))u===nt.InsertShiftCell.right&&p?e.setColumnCount(S+N-h):e.setColumnCount(S);else if(p||h+o.colCount!==N||u!==nt.InsertShiftCell.right){if(p&&u===nt.InsertShiftCell.right)e.setColumnCount(S+N-h);else if(k)return b=!0,y=1,M=x,void n.Ufe(e,m,a,u)}else e.setColumnCount(S+N-h-f.colCount)}if((b=(_=u!==ot&&this.fx(B,u,e,n.cA,f,l,h,d,v,n.px,a)).raiseInvalidOperation)&&(y=1,M=at().Exp_InsertCopiedCutCellsNoRange),_.returnFunc)n.Ufe(e,m,a,u);else{if(r&&tt.Be.Ll(t,r.row,r.col,r.row+ft(r)-1,r.col+lt(r)-1),!_.ignoreTableExpand)try{Q={shiftCells:n.bx&&u===nt.InsertShiftCell.down,isCopy:!a,isFirst:!1,isHeaderPaste:n.kse},J=et(_.ignoreTableFooterIndex)?0:_.ignoreTableFooterIndex,K=new tt.Range(o.row,o.col,o.rowCount-J,o.colCount),e.tables&&e.tables.yx(t,K,r,rt,rt,rt,{shiftInfo:Q})}catch(t){return b=!0,y=6,M=t.message,void n.Ufe(e,m,a,u)}D=s||r,X=a&&u!==ot&&(u===nt.InsertShiftCell.right&&(-1===D.row||D.row===o.row)||u===nt.InsertShiftCell.down&&(-1===D.col||D.col===o.col)),e.QT(t,s||r,e,o,a,i.clipboardText,i.clipboardHtml,i.clipboardImage,L,!i.includeFilteredOutRow,!0===X),a&&u!==ot&&(j=D.row,E=D.col,O=D.rowCount,R=D.colCount,q=o.row,$=o.col,u!==nt.InsertShiftCell.right||-1!==D.row&&D.row!==o.row||(P&&F&&E<$&&Ue(e,o)&&(o.col-=R),t.moveTo(j,E+R,q,E,O,e.getColumnCount()-E-R,it,!0)),u!==nt.InsertShiftCell.down||-1!==D.col&&D.col!==o.col||(P&&F&&j<q&&Ue(e,o)&&(o.row-=O),t.moveTo(j+O,E,j,$,e.getRowCount()-j-O,R,it,!0)))}}finally{n.Ufe(e,m,a,u),r&&tt.Be.dl(),dt(e),e.QI=!1,t&&(dt(t),t.QI=!1),ht(e),ut.xI(w,n.tT),g=n.tT.Kh,C=vt.WT(L),i.isCutting&&t&&(I=[],t.isDirtySuspended()||((T=new pn(t,r,C)).yI(g.qI.bI()),I=(g.wx=T).MI()),ut.SI(t,r.row,r.col,ft(r),lt(r),I,3,ot,ot,u)),e&&(A=[],e.isDirtySuspended()||((p=new pn(e,o,C)).yI(g.$I.bI()),A=(g.Mx=p).MI()),k=e.tables&&e.tables.WI&&e.tables.WI(o.row,o.col,o.rowCount,o.colCount),x=ft(o),S=lt(o),ut.SI(e,o.row,o.col,x,S,A,3,k,ot,u),n.tableNamesObj={r:o.row,c:o.col,rc:x,cc:S,tableNames:k}),n.Cx={changePasteDataRangeCol:G,changePasteDataRangeRow:U,changePasteDataRangeCols:H,changePasteDataRangeRows:V,acColCount:v,acRowCount:d,changePasteDataRangeRowInvisibleCount:z,changePasteDataRangeColInvisibleCount:Y,invisibleRowCountInAcRange:Z,invisibleColCountInAcRange:W},c&&delete c.TT,b&&e.jT(y,M)}}},vt.prototype.rx=function(t,n,e,i,r,o){for(var a,u,s,c,f,l,h,d,v,d,m,a=t.Ut.getSpans(),u=t.tables&&t.tables.U3,s=t.pivotTables&&t.pivotTables.all(),c=0;c<a.length;c++)if(!(n<=(f=a[c]).row&&e<=f.col&&n+i>=f.row+f.rowCount&&e+r>=f.col+f.colCount||f.row>n+i||f.row+f.rowCount-1<n||f.row>n+i-1||f.row+f.rowCount-1<n||f.col+f.colCount-1<e))return!0;if(u)for(c=0;c<u.length;c++)if(l=u[c],(et(o)||l.name()!==o)&&!(n<=l.Ky&&e<=l.iw&&n+i>=l.Ky+l.Sx&&e+r>=l.iw+l.Tx||l.Ky>n+i||l.Ky+l.Sx-1<n||l.Ky>n+i-1||l.Ky+l.Sx-1<n||l.iw+l.Tx-1<e))return!0;if(s)for(c=0;c<s.length;c++)if(v=(d=(h=s[c]).getRange()).content,d=d.page,m=void 0,m=!(m=v?Ge(n,e,i,r,v):m)&&d?Ge(n,e,i,r,d):m)return!0;return!1},vt.prototype.ux=function(t,n,e,i,r,o){for(var a,u,s,c,f,l,h,d,v,d,m,a=t.Ut.getSpans(),u=t.tables&&t.tables.U3,s=t.pivotTables&&t.pivotTables.all(),c=0;c<a.length;c++)if(!(n<=(f=a[c]).row&&e<=f.col&&n+i>=f.row+f.rowCount&&e+r>=f.col+f.colCount||f.col>e+r||f.col+f.colCount-1<e||f.col>e+r-1||f.col+f.colCount-1<e||f.row+f.rowCount-1<n))return!0;if(u)for(c=0;c<u.length;c++)if(l=u[c],(et(o)||l.name()!==o)&&!(n<=l.Ky&&e<=l.iw&&n+i>=l.Ky+l.Sx&&e+r>=l.iw+l.Tx||l.iw>e+r||l.iw+l.Tx-1<e||l.iw>e+r-1||l.iw+l.Tx-1<e||l.Ky+l.Sx-1<n||e===l.iw&&r===l.Tx&&n>l.Ky))return!0;if(s)for(c=0;c<s.length;c++)if(v=(d=(h=s[c]).getRange()).content,d=d.page,m=void 0,m=!(m=v?Ge(n,e,i,r,v):m)&&d?Ge(n,e,i,r,d):m)return!0;return!1},vt.prototype.ax=function(t,n,e,i,r){for(var o,a,u,s,c,f,l,h,d,o=t.Ut.getSpans(),a=t.tables.U3,u=n;u<n+i;u++)for(s=e;s<e+r;s++){if(c=t.getCell(u,s),!et(c.value())||c.backColor()||c.comment()||c.tag())return!0;for(f=0;f<o.length;f++)if(u>=(l=o[f]).row&&u<=l.row+l.rowCount-1&&s>=l.col&&s<=l.col+l.colCount-1)return!0;for(h=0;h<a.length;h++)if(u>=(d=a[h]).Ky&&u<=d.Ky+d.Sx-1&&s>=d.iw&&s<=d.iw+d.Tx-1)return!0}return!1},vt.prototype.gx=function(t,n){var e,t,i,n,r,o,a;return!t||(e=t.row,t=t.col,i=n.row,n=n.col,-1!==e&&-1!==t)||(r=-1===e&&-1!==t)&&i<=0||(o=-1===t&&-1!==e)&&n<=0||(a=-1===e&&-1===t)&&i<=0&&n<=0},vt.prototype.undo=function(){var t,n,e,i,r,o,a,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,t=this;if(t.canUndo()){if(n=t.tT.fromSheet,e=t.tT.toSheet,r=(i=t.tT.pasteExtent).sourceRange,o=i.targetRange,!e||!o)return!1;if(t.Cx&&(a=t.Cx,this.hx(a.changePasteDataRangeCol,r,a.changePasteDataRangeRow,a.changePasteDataRangeCols,a.changePasteDataRangeRows,a.acColCount,a.acRowCount,a)),!e.zT(o.row,o.col,ft(o),lt(o),st(e),ct(e)))return!1;if(n&&r){if(!n.zT(r.row,r.col,ft(r),lt(r),st(n),ct(n)))return!1;if(n.name()===e.name()&&e.parent&&!n.NMi&&!V(e.parent.sheets,n))return!1}a=t.tT.Kh,Jn(e);try{u=o.row<0?0:o.row,s=o.col<0?0:o.col,c=o.row<0?st(e):ft(o),f=o.col<0?ct(e):lt(o),l=t.vx(n,e),ut.NI(l,t.tT),(d=(h=e.rowFilter())&&h.range)&&-1===o.row&&d.col<o.col&&d.col+d.colCount>=o.col+o.colCount&&(d.colCount=d.colCount-o.colCount),p=g=m=v=0,n&&r&&(v=r.row<0?0:r.row,m=r.col<0?0:r.col,g=r.row<0?st(n):ft(r),p=r.col<0?ct(n):lt(r)),b=[],w=[],(y=t.tableNamesObj)&&(e&&y.r===u&&y.c===s&&y.rc===c&&y.cc===f&&(w=y.tableNames),n)&&y.r===v&&y.c===m&&y.rc===g&&y.cc===p&&(b=y.tableNames),M=t.sA,e&&(C=a.Mx,ut.SI(e,u,s,c,f,C?C.MI():[],3,b,!0,M)),i.isCutting&&n&&(S=a.wx,ut.SI(n,v,m,g,p,S?S.MI():[],3,w,!0,M)),(T=t.tT.Hfe)&&t.Ufe(e,T,i.isCutting,M)}finally{ht(e)}}return!0},vt.prototype.toJSON=function(){var t=this;return{sheetName:t.Mf?t.Mf.name():"",command:t.tT}},kn=vt,h.ClipboardPasteRangeUndoAction=kn,n(Ze,zn=e),Ze.prototype.execute=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,t=this,n=t.tT,e=n.cachedActions,i=!1;if(t.canExecute()&&e){M(o=(r=t.Mf).parent.jg(),!0);try{for(a=!1,u=n.fA&&(Array.isArray(n.fA)?n.fA:[n.fA]),s=0;s<e.length;s++)(c=e[s]).sA=n.sA,c.kse=n.kse,c.cA=n.cA,c.fA=u&&(n.hT?u[s]:u[0]),c.bx=n.bx,c.px=n.px,r?(f=c.tT.pasteExtent,h=(l=t.tT).fromSheet,d=l.fromRanges&&l.fromRanges[s],v=f.clipboardText,(m=f.clipboardHtml)&&(g="<html>\r\n<body>\r\n\x3c!--StartFragment--\x3e",p="\x3c!--EndFragment--\x3e\r\n</body>\r\n</html>",m.substr(0,g.length)===g&&m.substr(m.length-p.length,p.length)===p&&(m=m.substring(g.length,m.length-p.length)),tt.mt.Qf())&&(b="<meta charset='utf-8'>",m.substr(0,b.length)===b)&&(m=m.substring(b.length,m.length)),!v&&h&&d&&(v=h.bT([d])),!m&&h&&d&&G(r)&&(m=h.MT([d])),w={sheet:r,sheetName:r.name(),cellRange:c.nx(),pasteOption:c.tT.pasteOption,pasteData:{text:v,html:m},shiftCells:n.sA,fromSheet:h,fromRange:d,isCutting:!!l.isCutting,cancel:!1,action:l.isCutting?nt.ClipboardActionType.cut:nt.ClipboardActionType.copy},(y=f.clipboardImage)&&(w.pasteData.image=y),r.ki(tt.Events.ClipboardPasting,w),w.cancel||(i=c.execute(),delete w.cancel,a=!0,r.ki(tt.Events.ClipboardPasted,w))):i=c.execute();a&&t.Ax()}finally{C(o,!0)}}return i},Ze.prototype.Ax=function(){var t,n,e,i,t,r,o,a,u,s,c,a,t=this,n=t.tT,e=n.cachedActions,i=t.Mf;if(i&&e){if(t=i.getSelections(),r=[],o=i.parent,i.IA(),n.hT)a=n.pastedRanges[0],i.n4(a.row,a.col,ft(a),lt(a));else if(1<e.length)for(u=0;u<e.length;u++)c=(s=e[u]).nx(),i.n4(c.row,c.col,ft(c),lt(c));else 0<e.length&&(a=e[0].nx(),i.n4(a.row,a.col,ft(a),lt(a)),a.contains(i.ui,i.ci)||i.XA(a.row,a.col));r=i.getSelections(),i.EA(t,r)&&i.jA(t),o&&n.Z3&&o.changeSelectionInCommandExecuting(n,null,null,r)}},Ze.prototype.canExecute=function(){var t,n,e,t=this.tT.cachedActions;if(t){for(n=0;n<t.length;n++)if(!(e=t[n]).canExecute())return!1;return!0}return!1},Ze.prototype.canUndo=function(){var t,n,e,t=this.tT.cachedActions;if(t){for(n=0;n<t.length;n++)if(!(e=t[n]).canUndo())return!1;return!0}return!1},Ze.prototype.undo=function(){var t,n,e,t,i,r,t=this,n=t.tT.cachedActions;if(t.canUndo()&&n){e=!0,M(t=t.Mf.parent.jg(),!0);try{for(i=n.length-1;0<=i;i--)r=n[i],e=e&&r.undo()}finally{C(t,!0)}return e}return!1},_n=Ze},"./dist/core/worksheet/worksheet-border.js":function(d,t,n){"use strict";var e,N,i,H,n,V,E,k,v,_,z,Y,j,Z,R,o,W,L,w,y,M,C,B,m,g,p,b,S,T,A,I,i,f,u,F,l,P,O,G,U,Q,J,K,X,q;function r(){}function $(t,n,e,i,r,o,a){var u,s,c,u=Q.call(this)||this,s;return o%2||(t!==e?(n-=.5,i-=.5):(t-=.5,e-=.5)),(c=u).Ix=t,c.xx=n,c.Nx=e,c.Dx=i,c._x=r,c.Ex=o,c.jx=a,u}function a(t,n,e,i,r,o,a,u){var s,c,f,s=J.call(this)||this,c;return o%2||(t!==e?(n-=.5,i-=.5):(t-=.5,e-=.5)),(f=s).Ix=t,f.xx=n,f.Nx=e,f.Dx=i,f._x=r,f.Ex=o,f.Ox=a,f.jx=u,s}function tt(t,n,e,i,r,o,a,u,s){var c,f,c=K.call(this)||this;return o?(--t,--e):(--n,--i),(f=c).Ix=t,f.xx=n,f.Nx=e,f.Dx=i,f._x=r,f.Rx=o,f.Ex=1,f.Bx=a,f.Lx=u,f.jx=s,c}function s(t,n,e,i,r,o,a){var u,s,u=X.call(this)||this,s=u;return s.Ix=t,s.xx=n,s.Nx=e,s.Dx=i,s._x=r,s.Fx=o,s.jx=a,s.Px=new f(s.Ix,s.xx,s.Nx,s.Dx,r,1,a),s.Gx=null,u}function c(t,n,e,i,r,o){var a,u,s,c,a=q.call(this)||this,u=a,s=0,c=0;return t===e&&(s=1),n===i&&(c=1),t!==e&&n!==i?o?(u.Px=new f(t-(s=2),n,e-s,i,r,1,o),u.Gx=new f(t+s,n,e+s,i,r,1,o)):(c=s=2,e<t?(u.Px=new l(t-s,n,e,i-c,r,!1,o),u.Gx=new l(t,n+c,e+s,i,r,!1,o)):(u.Px=new l(t,n+c,e-s,i,r,!0,o),u.Gx=new l(t+s,n,e,i-c,r,!0,o))):(u.Px=new f(t-s,n-c,e-s,i-c,r,1,o),u.Gx=new f(t+s,n+c,e+s,i+c,r,1,o)),u.jx=o,u._x=r,u.Ex=1,a}function D(t,n,e,i,r,o,a){switch(o=o!==V&&o!==E?o:1){case 1:return new f(t,n,e,i,r,1,a);case 2:return new f(t,n,e,i,r,2,a);case 5:return new f(t,n,e,i,r,3,a);case 3:return new u(t,n,e,i,r,1,[3,1],a);case 9:return new u(t,n,e,i,r,1,[8,2,2,2],a);case 4:return new u(t,n,e,i,r,1,[2,2],a);case 11:return new u(t,n,e,i,r,1,[9,3,3,3,3,3],a);case 13:return new F(t,n,e,i,r,t!==e,[11,1,5,1],[10,2,4,2],a);case 10:return new u(t,n,e,i,r,2,[9,3,3,3],a);case 12:return new u(t,n,e,i,r,2,[9,3,3,3,3,3],a);case 8:return new u(t,n,e,i,r,2,[9,3],a);case 7:return new u(t,n,e,i,r,1,[1],a);case 6:return new P(t,n,e,i,r,a)}return E}function x(){}function h(t,n,e,i){var r=this;r.Ux=!1,r.Hx=!1,r.Mf=t,r.nT=i,r.zx=n,r.Vx=e}e=this&&this.__extends||(U=function(t,n){return(U=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}U(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),Object.defineProperty(t,"__esModule",{value:!0}),t.Yx=t.Zx=void 0,N=n("./dist/core/worksheet/style.js"),i=n("./dist/core/util/domUtil.js"),H=n("./dist/core/core.enum.js"),n=n("Common"),V=void 0,E=null,k=Math.sqrt,v=Math.pow,_=Math.min,z=Math.abs,Y=Math.tan,j=Math.floor,Z=Math.PI,R=i.GC$.inherit,o=i.GC$.isEmptyObject,W=n.Common.lt.ht,m=w=0,g=y=1,p=M=2,b=C=3,S=4,T=5,A=6,I=7,r.prototype.Wx=function(t){var n=this;0===t._orientation?(t.Kx&&(n.Nx+=t.Kx),t.Jx&&(n.Ix+=t.Jx)):(t.Kx&&(n.Dx+=t.Kx),t.Jx&&(n.xx+=t.Jx))},r.prototype._e=function(t){var n=this._x||"#9eb6ce",e=this.Ex,i=t.lineWidth,r=t.strokeStyle;i===e&&r===n||(i!==e&&(t.lineWidth=e),r!==n&&(t.strokeStyle=n)),this.Xx(t)},r.prototype.Xx=function(t){var n,e,i,e,i,n=this,e=n.Ix===n.Nx,i=n.xx===n.Dx;e&&i||(e||i?(t.beginPath(),n.qx(t),t.stroke()):(t.save(),e=Math.min(n.Ix,n.Nx),i=Math.min(n.xx,n.Dx),t.rect(e,i,Math.abs(n.Nx-n.Ix),Math.abs(n.Dx-n.xx)),t.clip(),t.beginPath(),n.qx(t),t.stroke(),t.beginPath(),t.restore()))},r.prototype.qx=function(t){var n=this;t.moveTo(n.Ix,n.xx),t.lineTo(n.Nx,n.Dx)},e($,Q=i=r),f=$,e(a,J=i),a.prototype.qx=function(t){var n=this;a.Dn(t,n.Ix,n.xx,n.Nx,n.Dx,n.Ox)},a.Dn=function(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,a=k(v(i-n,2)+v(r-e,2)),s=(i-n)/a,c=(r-e)/a,f=0,l=0;for(o=o&&o.length?o:[4,4];f<a;)f+=h=_(o[l%o.length],a-f),(d=++l%2)&&t.moveTo(n,e),n+=h*s,e+=h*c,d&&t.lineTo(n,e)},u=a,e(tt,K=i),tt.prototype.qx=function(t){var n,e,i,n=this,e=n.Rx?0:1,i=n.Rx?1:0;u.Dn(t,n.Ix-e,n.xx-i,n.Nx-e,n.Dx-i,n.Bx),u.Dn(t,n.Ix,n.xx,n.Nx,n.Dx,n.Lx)},F=tt,e(s,X=i),s.prototype.Xx=function(t){this.Px&&this.Px.Xx(t),this.Gx&&this.Gx.Xx(t)},s.prototype.Wx=function(t){var n=this;n.Gx?(t.Jx&&n.Px&&n.Px.Wx(t),t.Kx&&n.Gx.Wx(t)):n.Px&&n.Px.Wx(t)},s.prototype.$x=function(t){var n,e,t,i,r,o,a,u,s,n=this;t&&t.severX&&t.severY?(e=t.severX||0,t=t.severY||0,e=n.Fx?e:-e,u=(i=parseInt(n.Ix+(n.Nx-n.Ix)/2,10))+e,s=(r=parseInt(n.xx+(n.Dx-n.xx)/2,10))+t,n.Px=new f(n.Ix,n.xx,o=i-e,a=r-t,n._x,1,n.jx),n.Gx=new f(u,s,n.Nx,n.Dx,n._x,1,n.jx)):(n.Px=new f(n.Ix,n.xx,n.Nx,n.Dx,n._x,1,n.jx),n.Gx=null)},l=s,e(c,q=i),c.prototype.Xx=function(t){this.Px.Xx(t),this.Gx.Xx(t)},c.prototype.Wx=function(t){var n=this;t.tN?1===t.tN?n.Px.Wx(t):2===t.tN&&n.Gx.Wx(t):(n.Px.Wx(t),n.Gx.Wx(t))},c.prototype.$x=function(){var t,n,e,t,t=this,n={severX:1,severY:1},e=t.Px,t=t.Gx;e.$x(n),t.$x(n)},P=c,t.Zx=D,x.nN=function(t,n,e){var i,i;return t?n?0!=(i=(i=x.eN)[t.style]-i[n.style])||e?i:(n.level||0)-(t.level||0):1:n?-1:0},x.iN=function(t){if(t){if(t.isGridLine)return 1;if(t.style)return N.LineBorder.YC(t.style)}return 0},x.rN=function(t){return t&&6===t.style},x.oN=function(t){return t&&13===t.style},x.aN=function(t,n){return t&&(!n||0<=x.nN(t.style,n.style))?t:n},x.uN=function(t,n){t&&t.line?t.line.Wx(n):t.Wx&&t.Wx(n)},x.sN=function(t,n,e){return t===n?0:t?n?t.isGridLine?n.isGridLine?0:-1:n.isGridLine?1:x.nN(t.style,n.style,e):1:-1},x.cN=function(t){return t&&t.style&&6===t.style.style},x.fN=function(t,n,e,i){var t;return!(!t.style||6!==t.style.style)||(t=0,(t=(t=(t+=n&&n.style&&6===n.style.style?1:0)+(e&&e.style&&6===e.style.style?1:0))+(i&&i.style&&6===i.style.style?1:0))<2)},x.lN=function(t,n,e,i,r,o){var o,e,i,o={_orientation:o?1:0,Jx:0,Kx:0},e=this.sN(t,e),i=this.sN(t,i);0<=e&&0<=i?0===e&&0===i?-1!==r&&1===r&&(o.Kx-=r):-1===r?o.Jx-=r:1===r&&(o.Kx-=2*r):0<=i?(o.tN=2,o.Jx+=r):0<=e&&(o.tN=1,o.Jx+=r),this.uN(t,o)},x.hN=function(t,n,e,i,r,o,a,u,s){var c,u,s,f,l,h,d,d,h,v,o,d,h,i,c={_orientation:u?1:0,tN:s?2:1,Jx:0,Kx:0},u={_orientation:u?1:0,tN:s?1:2,Jx:0,Kx:0},s=1===o?i:r,f=1===a?e:n,l;this.cN(f)?0===(h=this.sN(t,s))?0===(d=this.sN(t,f))?1===a&&(u.Kx-=a):0<d&&(-1===a?u.Jx-=2*a:1===a&&(u.Kx-=2*a)):0<h?0===(d=this.sN(t,f))?1===a&&(u.Kx-=a):0<d&&(-1===a?u.Jx-=2*a:1===a&&(u.Kx-=2*a)):0===(h=this.sN(t,f))?-1===a?c.Jx+=2*a:1===a&&(c.Kx+=2*a):0<h&&(-1===a?c.Jx-=3*a:1===a&&(c.Kx-=3*a)):0<=this.sN(t,s)?-1===a?u.Jx-=2*a:1===a&&(u.Kx-=2*a):-1===a?c.Jx+=2*a:1===a&&(c.Kx+=2*a),d=!1,h=0,this.cN(o=1==(v=1===o?2:1)?i:r)&&0<this.sN(o,t)&&(d=!0,i=x.iN(o),0<this.sN(o,s)?0<i&&(h=1===a&&this.cN(e)?2<=i?2:1:-1===a&&this.cN(n)?3<=i?2:1:3===i?3:2):h=3===i?3:2),d||this.cN(f)||!(f&&!f.isGridLine||o&&!o.isGridLine)||(d=!0,h=-1===a?2:1),d&&(-1===a?(c.Jx+=a*h,u.Jx+=a*h):1===a&&(c.Kx+=a*h,u.Kx+=a*h)),(c.Jx||c.Kx)&&this.uN(t,c),(u.Jx||u.Kx)&&this.uN(t,u)},x.dN=function(t,n,e,i,r,o){var e;0<=this.sN(t,e)&&0<=this.sN(t,i)&&(e={_orientation:o?1:0,Jx:0,Kx:0},-1===r?(e.Jx-=2*r,this.cN(t)&&0<this.sN(n,t)&&--e.Jx):1===r&&(e.Kx-=2*r,this.cN(t))&&0<this.sN(n,t)&&(e.Kx+=1),this.uN(t,e))},x.vN=function(t,n,e,i,r,o){var e,i,e;this.cN(t)&&(e=this.aN(e,i))&&!e.isGridLine&&0<(i=x.iN(e))&&(e={_orientation:o?1:0,Jx:0,Kx:0},-1===r?e.Jx+=i*r:e.Kx+=i*r,e.Jx||e.Kx)&&this.uN(t,e)},x.mN=function(t,n,e,i,r,o,a){var u,s,c,f,e,c=x;(n||e||i)&&(f=c.aN(e,i),c.fN(t,n,e,i)?0<(s=c.sN(f,t,!0))?(u=c.iN(f),c.cN(t)&&(c.cN(e)||c.cN(i)||c.cN(n))||3===u&&c.uN(t,{_orientation:0,Jx:1})):f&&s<0?0<(s=c.sN(t,n,!0))?3===(u=c.iN(f))||2===u?c.uN(t,{_orientation:0,Jx:-2}):1===u&&c.uN(t,{_orientation:0,Jx:-1}):0!==s&&0<c.sN(n,f,!0)&&3===(u=c.iN(f))&&c.uN(t,{_orientation:0,Jx:1}):0===s&&(!n||0<c.sN(t,n,!0))&&(3===(u=c.iN(f))||2===u?c.uN(t,{_orientation:0,Jx:-2}):1===u&&c.uN(t,{_orientation:0,Jx:-1})):c.uN(t,{_orientation:0,Jx:1})),(r||o||a)&&(e=c.aN(o,a),c.fN(t,r,o,a)?0<(s=c.sN(e,t,!0))?(u=c.iN(e),c.cN(t)&&(c.cN(o)||c.cN(a)||c.cN(r))||(3===u?c.uN(t,{_orientation:0,Kx:-2}):2!==u&&1!==u||c.uN(t,{_orientation:0,Kx:-1}))):s<=0&&(0<(s=c.sN(t,r,!0))?3===(u=c.iN(e))&&c.uN(t,{_orientation:0,Kx:1}):0!==s&&c.uN(t,{_orientation:0,Kx:-1})):c.uN(t,{_orientation:0,Kx:-2}))},x.gN=function(t,n,e,i,r,o,a){var u,s,c,f,e,c=x;(n||e||i)&&(f=c.aN(e,i),s=c.sN(f,t,!0),c.fN(t,n,e,i)?0<s?(u=c.iN(f),c.cN(t)&&(c.cN(e)||c.cN(i)||c.cN(n))||3===u&&c.uN(t,{_orientation:1,Jx:1})):s<0?0<(s=c.sN(t,n,!0))?3===(u=c.iN(f))||2===u?c.uN(t,{_orientation:1,Jx:-2}):1===u&&c.uN(t,{_orientation:1,Jx:-1}):0!==s&&0<c.sN(n,f,!0)&&3===(u=c.iN(f))&&c.uN(t,{_orientation:1,Jx:1}):0===s&&0<c.sN(t,n,!0)&&(3===(u=c.iN(f))||2===u?c.uN(t,{_orientation:1,Jx:-2}):1===u&&c.uN(t,{_orientation:1,Jx:-1})):c.uN(t,{_orientation:1,Jx:1})),(r||o||a)&&(e=c.aN(o,a),s=c.sN(t,e,!0),c.fN(t,r,o,a)?s<0?(u=c.iN(e),c.cN(t)&&(c.cN(o)||c.cN(a)||c.cN(r))||(3===u||2===u?c.uN(t,{_orientation:1,Kx:-2}):1===u&&c.uN(t,{_orientation:1,Kx:-1}))):e!==E&&0<=s&&(0<(s=c.sN(t,r,!0))?3===(u=c.iN(e))&&c.uN(t,{_orientation:1,Kx:1}):0!==s&&c.uN(t,{_orientation:1,Kx:-1})):c.uN(t,{_orientation:1,Kx:-2}))},x.pN=function(t,n,e,i,r,o,a,u){var s,c,f,l,l,s=x;u?this.gN(t,n,e,i,r,o,a):this.mN(t,n,e,i,r,o,a),c=s.cN(e),f=s.cN(i),l=s.cN(n),c&&f&&l?s.lN(t,n,e,i,-1,u):c&&!f?s.hN(t,n,r,e,i,1,-1,u,!0):!c&&f?s.hN(t,n,r,e,i,2,-1,u,!1):c&&f&&!l?s.dN(t,n,e,i,-1,u):l&&s.vN(t,n,e,i,-1,u),c=s.cN(o),f=s.cN(a),l=s.cN(r),c&&f&&l?s.lN(t,r,o,a,1,u):c&&!f?s.hN(t,n,r,o,a,1,1,u,!0):!c&&f?s.hN(t,n,r,o,a,2,1,u,!1):c&&f&&!l?s.dN(t,r,o,a,1,u):l&&s.vN(t,r,o,a,1,u)},x.eN=[0,101,199,100,100,300,90,100,198,100,198,100,198,198],x.bN=function(t,n){return!(!t||!n||t.color!==n.color||t.level!==n.level||t.style!==n.style)},O=x,h.prototype.yN=function(){var t,n,e,i,r,o,a,u,s,c,f,t=this;if(t.wN=[],t.MN=[],t.CN=[],t.SN=[],t.TN=[],t.AN={},t.IN={},t.xN={},t.NN={},t.kN={},t.DN={},t._N={},n=t.zx,e=t.Vx,n&&0<n.length&&e&&0<e.length){for(i=t.MN,r=n.length,o=void 0,a=0;a<r;a++)0<(o=n[a]).height&&i.push(o.row);for(i.push(i[i.length-1]+1),u=t.CN,s=e.length,c=void 0,f=0;f<s;f++)0<(c=e[f]).width&&u.push(c.col);u.push(u[u.length-1]+1)}t.Ux=!0},h.prototype.EN=function(t,n,e,i,r,o,a,u){var t;e&&(t={Ky:t,iw:n,jN:e.startColumn,ON:e.endColumn,RN:i,_x:r,_y:o,YC:a,ZC:u},this.SN.push(t))},h.prototype.PN=function(t,n,e,i,r,o,a,u,s,c,f){var l,u,h,d,v,m,g,p,b,w,y,l=this;l.Ux||l.yN(),u?l.wN.push(u):(y=w=b=p=g=m=v=d=h=u=void 0,a&&(u=a.borderLeft,h=a.borderTop,d=a.borderRight,v=a.borderBottom,y=a.backColor,f&&2===f.columnHeaderFitMode||(m=a.diagonalDown,g=a.diagonalUp),f&&f.sheetArea!==V&&3!==f.sheetArea||(p=a.textOrientation),b=a.isVerticalText,w=a.textIndent),!y||u||d||h||v||l.TN.push({r:t,c:n,rc:1,cc:1}),l.GN(t,n,e,i,r,o,u,h,d,v,m,g,y,!1,!1,s,c,p,b,w&&0!==w,f))},h.prototype.GN=function(t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,L,B,m,g,p,b){var w,y,M,C,S,F,P,T,A,I,x,g,p,N,k,_,D,j,E,O,R,M,M,I,G,U,w=this,y=w.Mf,M=y.Jt,C=!1,S=!1,F=!1,P=!1,T=function(t){return t!==V&&t&&-90<=t&&t<=90},A=T(m),I=a||u||s||c,_=0,D=0,j=e,E=r;n+1<y.getColumnCount()&&(O=M.qt(t,n+1)),0<=n-1&&(R=M.qt(t,n-1)),M=A&&!g&&!p&&b&&b.data,I&&(M&&(N=z(m*Z/180),k=Y(N),_=Math.floor(o/k),-90<m&&m<0&&(j=e-_),0<m)&&m<90&&(j=e+_),A||(O&&T(O.textOrientation)&&(N=z(O.textOrientation*Z/180),k=Y(N),D=Math.floor(o/k),0<O.textOrientation&&O.textOrientation<90&&(E=r+D),O.textOrientation<0)&&-90<O.textOrientation&&(E=r-D),R&&T(R.textOrientation)&&(N=z(R.textOrientation*Z/180),k=Y(N),D=Math.floor(o/k),-90<R.textOrientation&&R.textOrientation<0&&(E+=D,j=e-D),0<R.textOrientation)&&R.textOrientation<90&&(E-=D,j=e+D))),f&&!A&&w.UN(t,n,e-1,i-1,e+r,i+o,f,w.kN),l&&!A&&w.UN(t,n,e+r,i-1,e-1,i+o,l,w.DN),u&&0<o&&(C=w.UN(t,n,j,i-.5,j+E,i-.5,u,w.xN,A)),a&&0<E&&(S=w.UN(t,n,j-.5,i,e-.5,i+o,a,w.NN,A)),s&&0<E&&(P=b&&b.columnHeaderFitMode===H.ColumnHeaderFitMode.stack&&!W(b.cornerX)?(x=b.cornerX,g=b.cornerY,w.UN(t,n+1,j+E-.5,i,e+r-.5,i+(p=g-i),s,w.NN,A,{isMultiLine:!0,multiLinePart:"topVertical"}),w.UN(t,n+1,x,i+p-.5,e+r-.5,i+p-.5,s,w.xN,A,{isMultiLine:!0,multiLinePart:"horizontal"}),w.UN(t,n+1,x-.5,g,x-.5,i+o,s,w.NN,A,{isMultiLine:!0,multiLinePart:"bottomVertical"})):w.UN(t,n+1,j+E-.5,i,e+r-.5,i+o,s,w.NN,A)),c&&0<o&&(F=b&&b.columnHeaderFitMode===H.ColumnHeaderFitMode.stack&&!W(b.cornerX)?(x=b.cornerX,w.UN(t+1,n,e,i+o-.5,x,i+o-.5,c,w.xN,A)):w.UN(t+1,n,e,i+o-.5,e+r,i+o-.5,c,w.xN,A)),h&&0!==y.Jt.Gt(t)&&0!==y.Jt.Kt(n)||(I=!P&&!v,((M=!F&&!d)||I||(G=!C&&!d)||(U=!S&&!v))&&w.HN(t,n,e,i,r,o,M,I,L,B)),!C&&!h||A||w.zN(t-1,n,w.AN),(S||h)&&w.zN(t,n-1,w.IN),!h||a||s||u||c||(w.VN(t-1,n-1,w.IN,!1),w.VN(t-1,n-1,w.AN,!0))},h.prototype.UN=function(t,n,e,i,r,o,a,u,s,c){var f,l,c,h,h;return!!a&&(l=f=void 0,c&&(f=c.isMultiLine,l=c.multiLinePart),(c=this.YN(t,n,u,!0))?f?((h=D(e,i,r,o,a.color,a.style,s)).multiLinePart=l,c.splitLines||(c.splitLines=[]),"horizontal"===l&&(c.line=h),c.splitLines.push(h)):s||6!==c.style.style&&(6===a.style||0<O.nN(a,c.style))?(c.line=D(e,i,r,o,a.color,a.style,s),c.style=a):c.line&&!c.splitLines&&o-i!=c.line.Dx-c.line.xx&&(c.line.Dx=o,c.line.xx=i):(h=D(e,i,r,o,a.color,a.style,s))&&((c=this.YN(t,n,u)).line=h,c.style=a,f)&&(c.line.multiLinePart=l,c.splitLines=[c.line]),c)&&c.line!==E},h.prototype.HN=function(t,n,e,i,r,o,a,u,s,c){var f,l,h,l,a,a,s,a,f=this,l=3===f.nT,h=f.Mf.options.gridline;l&&h&&(l=h.color,h.showHorizontalGridline&&(a&&((a=f.YN(t,n,f.AN)).isGridLine=!0,a.line=D(e,i+o-.5,e+r,i+o-.5,l)),s)&&((a=f.YN(-1,n,f.AN,!1,!0)).isGridLine=!0,a.line=D(e,i-.5,e+r,i-.5,l)),h.showVerticalGridline)&&(u&&((s=f.YN(t,n,f.IN)).isGridLine=!0,s.line=D(e+r-.5,i,e+r-.5,i+o,l)),c)&&((a=f.YN(t,-1,f.IN,!1,!0)).isGridLine=!0,a.line=D(e-.5,i,e-.5,i+o,l))},h.prototype.VN=function(t,n,e,i){var t,r,t=this.YN(t,n,e,!0);t&&t.line&&t.line.Wx({_orientation:i?0:1,Kx:-1})},h.prototype.zN=function(t,n,e){var e,i;(0<=t&&0<=n||0===t&&-1===n||-1===t&&0===n)&&(e=e[t])&&(i=e[n])&&delete e[n]},h.prototype.YN=function(t,n,e,i,r){var r,e;if(!r&&(-1===t||-1===n))return E;if(!(r=e[t])){if(i)return E;e[t]=r={}}if(!(e=r[n])){if(i)return E;r[n]=e={}}return e},h.prototype.ZN=function(){for(var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,s,p,b,w,h,y,M,y,f,C,S,T,A,I,x,N,k,_,t=this,n=t.SN,e=n.length,i=t.NN,r=t.xN,o=t.IN,a=t.AN,u=0;u<e;u++)if(c=(s=n[u]).Ky,f=s.iw,l=s.jN,h=s.RN,d=s.ON,m=s._x,g=s.YC,s=s.ZC,p=m,b=v=void 0,w=h.textOrientation,h=h.borderTop,!(y=n[u-1])||y.Ky!==c||y.jN!==l||y.ON!==d){for(M=l;M<d;M++)(v=t.YN(c,M+1,i,!0))&&!w?t.zN(c,M+1,i):(v=t.YN(c,M,o,!0))&&t.zN(c,M,o);if(y=t.YN(c,f,r,!0),w&&h&&!y)for(f=void 0,f=s/Math.tan(Math.abs(w*Math.PI/180)),-90<w&&w<0&&(p=m-f),b=(p=0<w&&w<90?m+f:p)+g,C=l;C<d+1;C++)if(T=(S=t.YN(c-1,C,a,!0))&&S.line)for(S.splitLines||(S.splitLines=[],S.splitLines.push(T)),A=0;A<S.splitLines.length;A++)if(x=(I=S.splitLines[A]).Ix,N=I.Nx,k=I.xx,_=I.Dx,x<p&&N<b&&p<N)I.Nx=p;else if(p<x&&N<b)t.zN(c-1,C,t.AN);else if(p<x&&b<N&&x<b)I.Ix=b;else if(x<p&&b<N){S.splitLines.splice(A,1,D(x,k,p,k,I.color),D(b,_,N,_,I.color));break}}},h.prototype.WN=function(){var t,n,e,i,t=this.wN,n=t.length;if(0<n)for(i=0;i<n;i++)e=t[i],this.QN(e)},h.prototype.KN=function(){var t,n,e,i,r,o,a,u;if(this._N={},0<(n=(t=this.wN).length))for(i=0;i<n;i++)for(e=t[i],r=0;r<e.rowCount;r++)for(o=r+e.row,this._N[o]=this._N[o]||{},a=0;a<e.colCount;a++)u=a+e.col,this._N[o][u]=e},h.prototype.QN=function(t){var n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,n=this,e=t.row,i=t.col,r=t.x,o=t.y,a=t.spanSizeInfo,l=a.styleList[0][0],h=l?l.backColor:E,S=r,T=o,A=null,I=!0,x=null,N=!0;if(1===t.rowCount)for(v=e,g=a.rowSizes[0],d=0;d<t.colCount;d++)b=0===d,y=d===t.colCount-1,m=i+d,p=a.colSizes[d],C=a.styleList[0][d],v===t.row&&m===t.col&&(A=(k=C)&&k.diagonalDown,x=k&&k.diagonalUp),C?(u=C.borderLeft,s=C.borderTop,c=C.borderRight,f=C.borderBottom,I=I&&O.bN(A,C.diagonalDown),N=N&&O.bN(x,C.diagonalUp)):u=s=c=f=E,b?n.GN(v,m,S,T,p,g,u,s,E,f,E,E,h,!1,!0):y?n.GN(v,m,S,T,p,g,E,s,c,f,E,E,h,!1,!1):n.GN(v,m,S,T,p,g,E,s,E,f,E,E,h,!1,!0),S+=p;else if(1===t.colCount)for(m=i,p=a.colSizes[0],d=0;d<t.rowCount;d++)w=0===d,M=d===t.rowCount-1,g=a.rowSizes[d],C=a.styleList[d][0],(v=e+d)===t.row&&m===t.col&&(A=(k=C)&&k.diagonalDown,x=k&&k.diagonalUp),C?(u=C.borderLeft,s=C.borderTop,c=C.borderRight,f=C.borderBottom,I=I&&O.bN(A,C.diagonalDown),N=N&&O.bN(x,C.diagonalUp)):u=s=c=f=E,w?n.GN(v,m,S,T,p,g,u,s,c,E,E,E,h,!0,!1):M?n.GN(v,m,S,T,p,g,u,E,c,f,E,E,h,!1,!1):n.GN(v,m,S,T,p,g,u,E,c,E,E,E,h,!0,!1),T+=g;else for(d=0;d<t.rowCount;d++){for(v=e+d,w=0===d,M=d===t.rowCount-1,g=a.rowSizes[d],_=0;_<t.colCount;_++)m=i+_,b=0===_,y=_===t.colCount-1,p=a.colSizes[_],C=a.styleList[d][_],v===t.row&&m===t.col&&(A=(k=C)&&k.diagonalDown,x=k&&k.diagonalUp),C?(u=C.borderLeft,s=C.borderTop,c=C.borderRight,f=C.borderBottom,I=I&&O.bN(A,C.diagonalDown),N=N&&O.bN(x,C.diagonalUp)):u=s=c=f=E,w?b?n.GN(v,m,S,T,p,g,u,s,E,E,E,E,h,!0,!0):y?n.GN(v,m,S,T,p,g,E,s,c,E,E,E,h,!0,!1):n.GN(v,m,S,T,p,g,E,s,E,E,E,E,h,!0,!0):M?b?n.GN(v,m,S,T,p,g,u,E,E,f,E,E,h,!1,!0):y?n.GN(v,m,S,T,p,g,E,E,c,f,E,E,h,!1,!1):n.GN(v,m,S,T,p,g,E,E,E,f,E,E,h,!1,!0):b?n.GN(v,m,S,T,p,g,u,E,E,E,E,E,h,!0,!0):y&&n.GN(v,m,S,T,p,g,E,E,c,E,E,E,h,!0,!1),S+=p;S=r,T+=g}n.GN(t.row,t.col,t.x,t.y,t.width,t.height,E,E,E,E,A=I?A:null,x=N?x:null,E,!0,!0),!h||u||c||s||f||n.TN.push({r:e,c:i,rc:t.rowCount,cc:t.colCount})},h.prototype.Wx=function(){var t,n,e,i,r,t=this,n=!1,e=!1,i=!1,r=!1;o(t.NN)||(n=!0),o(t.xN)||(e=!0),(n||e)&&(t.JN(),t.XN()),o(t.kN)||(i=!0),o(t.DN)||(r=!0),(i||r)&&t.qN(),0<t.TN.length&&t.$N()},h.prototype.t6=function(t,n,e,i,r){var o,a,o=this,a=this._N[t]?this._N[t][n]:null;if(a)switch(r){case m:return o.n6(t,n,e,i);case g:case p:return o.n6(t,n+a.colCount-1,e,i);case b:case S:return o.n6(t+a.rowCount-1,n+a.colCount-1,e,i);case T:case A:return o.n6(t+a.rowCount-1,n,e,i);case I:return o.n6(t,n,e,i)}return o.n6(t,n,e,i)},h.prototype.qN=function(){for(var t,n,e,i,r,o,a,u,s,c,c,c,c,f,l,c,c,c,c,h,d,v,t=this,n=t.MN,e=t.CN,i=n.length,r=e.length,f={},l={},o=0;o<i;o++)for(u=n[o],a=0;a<r;a++)s=e[a],h=t.YN(u,s,t.kN,!1),d=t.YN(u,s,t.DN,!1),(h||d)&&(O.cN(h)&&O.cN(d)&&(h.line.$x(),d.line.$x()),(c=t.t6(u,s,!(v=[]),f,m))&&c.line&&!c.isGridLine&&t.e6(v=[1,1,2],c,h,!0,1),(c=t.t6(u,s,!1,f,g))&&c.line&&!c.isGridLine&&t.e6(v=[1,1,2],c,d,!0,1),(c=t.t6(u,s,!0,l,I))&&c.line&&!c.isGridLine&&t.e6(v=[1,1,2],c,h,!0,0),(c=t.t6(u,s,!0,l,A))&&c.line&&!c.isGridLine&&t.e6(v=[1,1,2],c,d,!1,0),(c=t.t6(u+1,s,!1,f,T))&&c.line&&!c.isGridLine&&t.e6(v=[-1,-2,-2],c,d,!1,1),(c=t.t6(u+1,s,!1,f,S))&&c.line&&!c.isGridLine&&t.e6(v=[-1,-2,-2],c,h,!1,1),(c=t.t6(u,s+1,!0,l,p))&&c.line&&!c.isGridLine&&t.e6(v=[-1,-2,-2],c,d,!0,0),c=t.t6(u,s+1,!0,l,b))&&c.line&&!c.isGridLine&&t.e6(v=[-1,-2,-2],c,h,!1,0)},h.prototype.e6=function(t,n,e,i,r){var o,a,n,o,t,o=O.cN(n),a=O.oN(n),n=n.line.Ex;o&&(n=3),o=t[(n=a?2:n)-1],e&&e.line&&(t={_orientation:r},i?t.Jx=o:t.Kx=o,e.line.Wx(t))},h.prototype.$N=function(){for(var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,t=this,n=t.TN,e=n.length,i=0;i<e;i++){for(s=(u=o=(r=n[i]).r)-1,c=(a=r.c)-1,f=a,1<r.rc&&(u+=r.rc-1),1<r.cc&&(f+=r.cc-1),h=l=!1,d=i+1;d<e&&((v=n[d]).c===f+1&&v.r===o&&(h=!0),!(l=v.r===u+1&&v.c===a?!0:l)||!h)&&!(v.r>o+1&&v.c>a+1);d++);l||t.VN(u,c,t.AN,!0),h||t.VN(s,f,t.IN,!1)}},h.prototype.JN=function(){for(var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,y,t=this,n=t.Mf,e=n.Ut,i=t.MN,r=t.CN,o=i.length,a=r.length,l={},h={},u=0;u<o;u++)for(c=i[u],s=0;s<a;s++){if(f=r[s],A=t.YN(c,f,t.NN,!(T=S=0))){if(A.line&&A.line.jx)continue;S++}else A=t.YN(c,f-1,t.IN,!0);if((I=t.YN(c,f,t.xN,!0))?T++:I=t.YN(c-1,f,t.AN,!0),A||I){if((d=0===u?E:t.n6(i[u-1],f,!0,h))&&d.line&&!d.isGridLine&&(S++,T++),(v=0===s?E:t.n6(c,r[s-1],!1,l))&&v.line&&!v.isGridLine&&(S++,T++),A)for(x=[A],A.splitLines&&0<A.splitLines.length&&(x=A.splitLines),N=0;N<x.length;N++)(k=x[N]).style=A.style,(m=t.n6(c,f,!1,l))&&m.line&&!m.isGridLine&&S++,u!==o-1&&(p=t.n6(i[u+1],f,!0,h))&&p.line&&!p.isGridLine&&S++,0!==s&&u!==o-1&&(b=t.n6(i[u+1],r[s-1],!1,l))&&b.line&&!b.isGridLine&&S++,u!==o-1&&(w=t.n6(i[u+1],f,!1,l))&&w.line&&!w.isGridLine&&S++,0<S&&("topVertical"===k.multiLinePart?(_=e.i6(f,0),D=n.r6(_),2===n.Lt(D)&&(_=n.O5(_)),j=n.O5(f),m=t.n6(c,_,!1,l),p=t.n6(c,j,!0,h),b=k,w=E):"bottomVertical"===k.multiLinePart&&(m=k,p=v=d=E,b=t.n6(i[u+1],r[s-1],!1,l),w=t.n6(i[u+1],r[s],!1,l)),O.rN(A.style)?O.pN(k,d,v,m,p,b,w,!0):O.oN(A.style)||O.gN(k,d,v,m,p,b,w));I&&((g=t.n6(c,f,!0,h))&&g.line&&!g.isGridLine&&T++,s!==a-1&&(y=r[s+1],2===n.Lt(y)&&(y=e.i6(y,0),y=n.O5(y)),y=t.n6(c,y,!1,l))&&y.line&&!y.isGridLine&&T++,0!==u&&s!==a-1&&(M=t.n6(i[u-1],r[s+1],!0,h))&&M.line&&!M.isGridLine&&T++,s!==a-1&&(C=t.n6(c,r[s+1],!0,h))&&C.line&&!C.isGridLine&&T++,0<T)&&(I.line&&"horizontal"===I.line.multiLinePart&&(_=e.i6(f,0),D=n.r6(_),2===n.Lt(D)&&(_=n.O5(_)),y=d=v=E,M=g=I,C=t.n6(c,_,!0,h)),O.rN(I.style)?O.pN(I,v,d,g,y,M,C,!1):O.oN(I.style)||O.mN(I,v,d,g,y,M,C))}}},h.prototype.o6=function(t,n,e,i){var r,o,e,r=this,o=this._N[t]?this._N[t][n]:null,e=e?r.DN:r.kN;return o?t===o.row&&n===o.col&&i===w||t===o.row&&n===o.col+o.colCount-1&&i===y||t===o.row+o.rowCount-1&&n===o.col+o.colCount-1&&i===M||t===o.row+o.rowCount-1&&n===o.col&&i===C?r.YN(o.row,o.col,e,!1):void 0:r.YN(t,n,e,!1)},h.prototype.XN=function(){for(var t,n,e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,b,t=this,n=t.MN,e=t.CN,i=n.length,r=e.length,o=0;o<i;o++)for(u=n[o],a=0;a<r;a++)s=e[a],(b=t.YN(u,s,t.NN,!0))&&b.line&&b.line._noNeedAdjust||(b&&b.line&&O.cN(b)&&(c=t.o6(u,s,!1,w),f=t.o6(u,s,!0,C),l=O.cN(c),h=O.cN(f),d=t.o6(u,s-1,!1,M),v=t.o6(u,s-1,!0,y),m=O.cN(d),g=O.cN(v),c&&l&&b.line.Wx(p={tN:2,_orientation:1,Jx:2}),f&&h&&b.line.Wx(p={tN:2,_orientation:1,Kx:-2}),d&&m&&b.line.Wx(p={tN:1,_orientation:1,Kx:-2}),v)&&g&&b.line.Wx(p={tN:1,_orientation:1,Jx:2}),(b=t.YN(u,s,t.xN,!0))&&b.line&&O.cN(b)&&(c=t.o6(u,s,!1,w),f=t.o6(u,s,!0,y),l=O.cN(c),h=O.cN(f),d=t.o6(u-1,s,!1,M),v=t.o6(u-1,s,!0,C),m=O.cN(d),g=O.cN(v),c&&l&&b.line.Wx(p={tN:2,_orientation:0,Jx:2}),f&&h&&b.line.Wx(p={tN:2,_orientation:0,Kx:-2}),d&&m&&b.line.Wx(p={tN:1,_orientation:0,Kx:-2}),v)&&g&&b.line.Wx(p={tN:1,_orientation:0,Jx:2}))},h.prototype.n6=function(t,n,e,i){var r,i,r=i[t];return i=(i=(r=r||(i[t]={}))[n])===V?r[n]=this.a6(t,n,e):i},h.prototype.a6=function(t,n,e){var i,r,o;if(t===V||t<0||n===V||n<0)return E;if(i=this,r=e?i.NN:i.xN,o=i.YN(t,n,r,!0))return o;if(r=e?i.IN:i.AN,e){if(--n<0)return E}else if(--t<0)return E;return(o=i.YN(t,n,r,!0))||E},h.prototype.paint=function(t){var n=this;n.Ux&&(n.Hx||(n.KN(),n.WN(),n.ZN(),n.Wx(),n.Hx=!0),t.save(),n._e(t),t.restore())},h.prototype._e=function(t){this.u6(t),this.s6(t)},h.prototype.u6=function(t){var n=this;n.c6(t,n.AN),n.c6(t,n.IN)},h.prototype.s6=function(t){var n=this;n.c6(t,n.xN),n.c6(t,n.NN),n.c6(t,n.kN),n.c6(t,n.DN)},h.prototype.c6=function(t,n){var e,i,r,o,a,u;for(e in n)if(n[e])for(i in r=n[e])if(r[i])if(o=r[i].line,(a=r[i].splitLines)&&0<a.length)for(u=0;u<a.length;u++)a[u]&&a[u]._e(t);else o&&o._e(t)},t.Yx=h},"./dist/core/worksheet/worksheet-edit.js":function(t,n,e){"use strict";var n,x,N,i,k,i,_,e,D,j,E,O,r,R,L,C,o,m,e,a,u,s;Object.defineProperty(n,"__esModule",{value:!0}),n=e("./dist/core/core.ns.js"),x=e("./dist/core/worksheet/worksheet.js"),N=e("./dist/core/util/common.js"),i=e("./dist/core/util/domUtil.js"),k=i.GC$,i=e("Common"),_=e("./dist/core/core.enum.js"),e=e("CalcEngine"),D=!!e,j=N.mt.Tt,E=N.mt.pi(),O=i.Common.lt.ht,r=i.Common.zf,R=i.Common.CultureManager,L=null,C=void 0,o="string",m=N.mt.wt,a=(e=new i.Common.ResourceManager(n.SR,"Sheets")).getResource.bind(e),u="=",k.extend(x.Worksheet.prototype,s={startEdit:function(t,n){var e=this;e.f6(e.Dg(),e.ui,e.ci,L,L,t,n)},editorStatus:function(){return this.Di||0},isEditing:function(){var t=this.Di;return 1===t||2===t},endEdit:function(t){return this.ol(t)},ol:function(t,n,e,i){var r,o,a,u,s,r=this;if(!r.isEditing())return!0;r.suspendPaint();try{return o=r.ui,a=r.ci,u=_.SheetArea.viewport,(s=r.vA)&&(o=s.row,a=s.col,u=s.sheetArea,r.vA=C),r.l6(o,a,u,t,n,e,i)}finally{r.resumePaint()}},l6:function(t,n,e,i,r,o,a){var u,s,c,f,t,n,l,h,d,v,m,m,m,g,p,m,b,g,w,p,m,y,M,r,g,p;if(void 0===e&&(e=_.SheetArea.viewport),s=(u=this).rt,c=u.li,f=u.name(),(d=u.getCellType(t=t,n=n,e)).isImeAware(v={sheet:u,row:t,col:n,sheetArea:e})||s.aA(),c&&c.parentNode){if(h=d.getEditorValue(c,v),u.ki(N.Events.EditEnd,m={sheet:u,sheetName:f,row:t,col:n,editor:c,editingText:h,cancel:!1,committed:!i}),m.cancel&&!a)return;if(u.ki(N.Events.EditEnding,m),m.cancel&&!a)return;if(m=(m=u.parent)&&m.h6,document.activeElement===(m&&m.Ti)&&s.aA(),0<=t&&0<=n&&(g=c.d6,p=u.getFormulaInformation&&u.getFormulaInformation(t,n,3),d.isEditingValueChanged(g,h,v)||1===r||p&&p.isArrayFormula&&1!==r))if(i)d.setEditorValue(c,g,v),d.selectAll(c,v);else if(m=d.v6,O(m)&&(m=!0),g={cmd:"editCell",sheetName:f,row:t,col:n,sheetArea:e,newValue:h=(b=u.getActualStyle(t,n)).mask&&p&&!p.hasFormula&&h&&-1<N.FormulaPrefix.indexOf(h[0])?"'"+h:h,autoFormat:m,editingFormatter:c.Ii},1===r&&(g.ranges=[u.U5()],g.endEditType=r),null!==h&&(w=u.tables&&u.tables.find&&(u.tables.find(t-1,n)||u.tables.find(t,n-1)))&&u.tables.yx(L,new N.Range(t,n,1,1),null,h,!0),u.Qy().execute(g),2===(l=g.applyResult)&&(d.focus(c,v),!a))return!1;if(u.k1=!0,p=e===_.SheetArea.colHeader?-1:C,m=e===_.SheetArea.rowHeader?-1:C,d.Sn(c,v,u.getCellRect(t,n,p,m)),d.isImeAware(v))j.msie&&9===parseFloat(j.version)?s.aA():k(c.parentNode.parentNode).css({width:0,height:0,overflow:"hidden",border:"none"});else for(y=u.qc(),M=c;M;)M.parentNode===y?y.removeChild(M):M=M.parentNode}return u.u0=!1,g=k.extend({},r={sheet:u,sheetName:f,row:t,col:n,editingText:h,ignoreValueChange:i,sheetArea:e,committed:!i}),u.ki(N.Events.EditEnded,r),u.ki(N.Events.FormulaTextboxEditEnded,g),!(!0!==o&&g.ignore&&!a)&&(0!==u.Di&&(p=u.Di,u.Di=0,u._i(p,0)),u.Ut.setCellState(t,n,_.CellStatesType.edit,!1,e),x.Worksheet.et(u,"endEdit"),u.li=L,1!==l)},m6:function(t,n,e){var i,r,o,a,u,t,u,r,s,n,i=this,r=i.hitTest(n,e);!r||r.cellTypeHitInfo&&(r.cellTypeHitInfo.outlineColumnHitInfo||r.cellTypeHitInfo.cellButtonHitInfo)||(o=r.row,a=r.col,0<=o&&0<=a&&0<=r.rowViewportIndex&&0<=r.colViewportIndex&&!r.resizeInfo&&!r.dragInfo&&o===i.ui&&a===i.ci&&(u=i.isEditing(),i.f6(t,o,a),!u)&&i.isEditing()&&(t=r.hitTestType,(u=i.getCellType(o,a)).j3)&&(r=i.getCellRect(o,a,1===t?-1:C,2===t?-1:C),s=i.getActualStyle(o,a,t),n=u.Bn(n,e,s,r,{sheet:i,row:o,col:a,sheetArea:t}))&&n.isReservedLocation&&u.j3(i,o,a,3))},inputFormulaAndSelectFormulaRange:function(t,n,e,i){var r,o,a,u,s,c,f,l,h,d,c,r=this,o=r.options,a=r.getCellRect(t,n),u=r.getActualStyle(t,n),s=r.getCellType(t,n),c=r.rt;c.Zg(),f={sheet:r,row:t,col:n,sheetArea:3},(h=(l=c.g6)&&l.firstChild?l.firstChild.firstChild:h)&&(r.li=h,d=r.Fi(),s.isImeAware(f)&&c.p6(),s.On(l,u,a,f),r.Ri(s,h,t,n,u,C,C,C,C,3),s.Rn(l,u,a,f),o.allowCellOverflow&&((c=a.clone()).y-=2,c.height+=4,c.x=d.b6,c.width=r.Gy(d),r.repaint(c)),x.Worksheet.et(r,"startEdit",{element:s.getEditingElement(),row:t,col:n,sheetArea:3}),r.Di=2,r.il.text(i),r.il.caret(i.length-1),e&&r.il.y6(3,4),r.il.w6(),N.hi.F1(r))},f6:function(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,p,p,b,w,y,M,C,S,T,M,T,M,T,T,s,T,M,s,T,M,s,i,A,I,r,p;k[k.sd]({jS:this.parent}),n<0||e<0||(f=(c=this).name(),l=c.options,c.isEditing())||(h=c.C6(i,r),O(h)&&(h=3),(d=c.Ut).setCellState(n,e,_.CellStatesType.edit,!0,h),v=c.getActualStyle(n,e,h),l.isProtected&&!1!==v.locked?(d.setCellState(n,e,_.CellStatesType.edit,!1,h),c.jT(13,c.FT())):(m=c.getCellType(n,e,h))&&(x.Worksheet.et(c,"allowStartEdit",p={row:n,col:e,sheetArea:h,isAllow:g=!0}),p.isAllow)&&((p=c.rt).Zg(),y=(w=m.isImeAware(b={sheet:c,row:n,col:e,sheetArea:h})?p.g6:m.jn(b))&&w.firstChild?w.firstChild.firstChild:y)?(M=v,C=!1,T=R.culture(),(M.formatter&&N.util.h0(M.formatter,T)||M._autoFormatter&&M._autoFormatter.formatCached&&N.util.h0(M._autoFormatter,T))&&(s&&s.key&&(M=s.key,T=s.code,M&&-1!==N.NUMBER_ARRAY.indexOf(M)&&(C=!0),"+"!==M&&"-"!==M||(m.probabilityAddPercent=!0),"process"===M.toLowerCase())&&(!s.shiftKey&&0<T.length-T.replace(/[0-9]/,"").length&&(C=!0),!s.shiftKey&&(0<T.length-T.replace("Minus","").length||0<T.length-T.replace("Subtract","").length||0<T.length-T.replace("Add","").length)&&(m.probabilityAddPercentSpec=!0),s.shiftKey)&&0<T.length-T.replace("Equal","").length&&(m.probabilityAddPercentSpec=!0),M=w.innerText,j.msie&&(M=M.replace("\r\n","")),T=R.Fe(R.culture()).NumberFormat.numberDecimalSeparator,T=new RegExp("^[-]?[0-9]+(\\"+T+"[0-9]+)?$"),!s)&&M&&T.test(M)&&(S=!0),c.li=y,c.ki(N.Events.EditStarting,s={sheet:c,sheetName:f,row:n,col:e,cancel:!1}),s.cancel?(E.ipad&&p.aA(),d.setCellState(n,e,_.CellStatesType.edit,!1,h)):(c.vA={row:n,col:e,sheetArea:h},3===h&&c.showCell(n,e,3,3),c.S6=!0,T=c.getValue(n,e,h),M=D&&c.getFormula(n,e,h),s=c.Di,c.Ai||O(T)&&O(M)?c.Di=1:c.Di=2,c._i(s,c.Di),c.isPaintSuspended()&&c.n3(),T=c.Fi(),!(M=c.getCellRect(n,e,i,r))||O(M.width)||O(M.height)||O(M.x)||O(M.y)||M.width<=0||M.height<=0||(m.isImeAware(b)&&p.p6(),m.On(w,v,M,b),c.Ri(m,y,n,e,v,a,u,C,S,h),s=c.qc(),m.isImeAware(b)||s.insertBefore(w,L),delete c.S6,m.Rn(w,v,M,b),m.isImeAware(b)&&o||m.focus(y,b),l.allowCellOverflow&&((i=M.clone()).y-=2,i.height+=4,c._1&&c._1.isEnable(_.RowColumnStates.edit,!1)&&(i.y=T.T6,i.height=T.A6),i.x=T.b6,i.width=c.Gy(T),c.repaint(i)),x.Worksheet.et(c,"startEdit",{element:m.getEditingElement(),row:n,col:e,sheetArea:h,preventFormulaTextBox:!!v.mask}),C||!o||v.mask||m.selectAll(y,b),C&&(A=window.getSelection(),(I=document.createRange()).setStart(y,0),A.removeAllRanges(),A.addRange(I)),S&&(A=window.getSelection(),(r=document.createElement("span")).innerText="%",I=document.createRange(),c.parent.options.enableFormulaTextbox&&c.parent.options.allowUserEditFormula&&!v.mask?(y.firstChild.appendChild(r),I.setStart(y.firstChild,1),c.il&&c.il.I6()):(y.appendChild(r),I.setStart(y,1)),A.removeAllRanges(),A.addRange(I)),N.hi.F1(c),c.ki(N.Events.EditStarted,p={sheet:c,sheetName:f,row:n,col:e,sheetArea:h}),c.ki(N.Events.FormulaTextboxEditStarted,p)))):d.setCellState(n,e,_.CellStatesType.edit,!1,h))},Ri:function(t,n,e,i,r,o,a,u,s,c){var f,l,h,a,d,v,d,f=this,l=D&&f.getFormula(e,i,c,!0),a={sheet:f,row:e,col:i,sheetArea:c,isImeInput:a,cellStyle:r};(h=l=l&&"="+l)&&0!==l.length||((l=f.getValue(e,i,c,1))&&l.richText&&(l=m(l)),d=f.parent,v=D&&d&&d.options.allowUserEditFormula,d=D&&d&&d.options.allowInvalidFormula,N.util.c0(l,r.quotePrefix,v,d)?h=l="'"+l:(h=l,l=t.je(n,r,l,a))),n.d6=l,O(o)||(l=o),s&&(l=l&&this.x6(l,r)),r.mask&&r.mask.pattern&&"'"!==r.mask.pattern[0]&&l&&"'"===l[0]&&-1<N.FormulaPrefix.indexOf(l[1])&&(l=l.substring(1,l.length)),t.setEditorValue(n,l,a,u,s),f.parent&&f.parent.options.enableAccessibility&&(f.parent.Q1e(),f.K1e(n,l,e,i,c)),n.Li=h},K1e:function(t,n,e,i,r){var o,a,u,a,n,e,o=this,a=n&&"="===n[0],u=o.getText(e,i,r),a=a?n:o.getFormula(e,i,r),n=3===r&&o.comments&&o.comments.get(e,i),e=o.N6(e,i,r,u,a,n&&n.text());t.setAttribute("aria-label",e),o.setAccessibilityPrefixSuffixContent&&o.setAccessibilityPrefixSuffixContent()},k6:function(t){var n="",t=t&&(t.formatter||t._autoFormatter);return n=t?typeof t==o?t:t.formatCached:n},x6:function(t,n){var e,i,e,n,r,o,n,r,n,r,n,n,a,u,e=R.Fe(R.culture()).NumberFormat,i=e.negativeSign,e=e.numberDecimalSeparator,n=this.k6(n),r="%"===n[0],n=n.split(";");if(r?o=n[0].split("%")[1].split(".")[1]:-1<n[0].indexOf("%")&&(o="00"),void 0===o&&(o=""),1<t.split("e").length)return r=t.split("e")[0],n=t.split("e")[1],r+"e+"+(parseInt(n.split("+")[1],10)+2);if(1<t.split(e).length){for(r=!1,t.charAt(0)===i&&(t=t.substr(1,t.length-1),r=!0),n=(t+=o).indexOf(e),a=(n=(t=(t=t.split(e).join("")).substr(0,n+2)+e+t.substr(n+2,t.length-1)).split(e))[0],u=n[1];a&&"0"===a.charAt(0);)a=a.substr(1,a.length-1);for(;u&&"0"===u.charAt(u.length-1);)u=u.substr(0,u.length-1);return(a=r?a&&i+a:a)&&u?a+e+u:!a&&u?(r?i+"0"+e:"0"+e)+u:a&&!u?a:"0"}return"0"===t?t:t+o}})},"./dist/core/worksheet/worksheet-event.js":function(r,o,t){"use strict";var a,p,y,s,v,b,d,t,m,H,c,g,w,V,z,Y,f,Z,M,W,n,Q,J,K,X,q,$,tt,nt,C,S,T,et,A,u,I,x,it,rt,ot,at,ut,st,ct,ft,lt,ht,dt,vt,mt,gt,pt,bt,wt,N,k,_,yt,Mt,Ct,n,St,Tt,At,It;function xt(t,n){var e,n,e=[n,n];return e=t<3*n?2===t?[1,0]:1===t?[0,0]:[n=u(t/3),n]:e}function Nt(t,n){var e=3;return R(n)<0&&(e=1),!(3===(e=L(n)<0?2:e)||!t.ni(n.row,n.col,e,!0))}function kt(t,n,e){var i,r,o,a,u,s,u,s,c,s,c,i=!1,r=t.Fi();return n&&(o=R(n),u=(a=L(n))<0&&n.col>=t.getFreeAreaColumnCount(d.SheetArea.rowHeader),s=o<0&&n.row>=t.getFreeAreaRowCount(d.SheetArea.colHeader),u||s)&&(u=t.getCellRect(n.row,n.col,o,a,!0))&&0<u.width&&0<u.height&&(s=r.x,c=r.y,u.x<r.XC+s||u.y<r.qC+c||u.y>=r.height-r.D6)&&(s=new b.Rect(u.x-2,u.y-2,u.width+4,u.height+4),c=void 0,c=o<0&&a<0?r.R1():o<0?r.L1(a):r.B1(o),s=s.getIntersectRect(c),e._6(s.x,s.y,s.width,s.height),i=Nt(t,n)),i}function D(t){return t.isEditing()}function j(t){return t.endEdit()}function _t(t){return t.frozenRowCount()}function Dt(t){return t.frozenColumnCount()}function E(t,n){return t.getRowCount(n)}function O(t,n){return t.getColumnCount(n)}function R(t){return t.rowViewportIndex}function L(t){return t.colViewportIndex}function B(t){return t.hitTestType}function jt(t){return t.getActiveRowIndex()}function Et(t){return t.getActiveColumnIndex()}function l(t){return t.keyCode}function h(t){return t.ctrlKey}function F(t){return t.shiftKey}function Ot(t){return t.altKey}function Rt(t){return t.metaKey}function P(t){return t.colCount}function Lt(t){return t.rowCount}function G(t,n,e){return{action:t,index:n,sheetArea:e}}function Bt(t,n,e){return C===n.O5(t,e,!0)}function Ft(t,n,e){return C===n.j5(t,e,!0)}function Pt(t,n){return n?t.E6?t.startY-t.movingY:t.movingY-t.startY:t.j6?t.startX-t.movingX:t.movingX-t.startX}function U(t,n,e,i,r,o,a){var n,r,n={sheet:t,sheetName:n,sheetArea:r,row:e,col:i},r=t.getCellType(e,i);return r&&(n=r.lfe(n,a)),o&&(n.cancel=!1),n}function Gt(t,n,e,i,r,o){var a,u,a=t.Mf,u=U(a,a.name(),a.ui,a.ci,S,!0);if(a.ki(b.Events.LeaveCell,u),u&&!0===u.cancel)return!0;a.O6(n,e,i,r,o),a.ki(b.Events.EnterCell,U(a,a.name(),n,e)),a.ki(b.Events.EnterCellInternal,U(a,a.name(),n,e,S,S,b.Events.EnterCellInternal)),t.PA&&t.PA(n,e)}function Ut(t,n,e,i,r,o,a){var u,n,s,u=t.Mf,n=n.call(u,o.sheetArea);return(a&&!u.getRowVisible(o.index,o.sheetArea)||!a&&!u.getColumnVisible(o.index,o.sheetArea))&&(o.index=e.call(t,o.index,o.sheetArea)),s=(s=i.call(n,o.index))||i.call(n,r)}function Ht(t,n,e,i,r){var o,a,u,n,e,o=i?"movingY":"movingX",a=i?"startY":"startX";t[o]=n,(u=t.j6||t.E6?t[o]>t[a]:t[o]<t[a])&&(t[o]=t[a]),n=i?e.y+e.height:e.x+e.width,e=i?t.R6:t.B6,t[o]>n&&!e&&(t[o]=n),r!==C&&t[o]>t[a]+r&&(t[o]=t[a]+r)}function Vt(t,n){var e=t.Fi();return 0<_t(t)&&n<e.T6+e.L6?0:0<t.frozenTrailingRowCount()&&n>e.Ay?2:1}function zt(t,n){var e=t.Fi();return 0<Dt(t)&&n<e.b6+e.F6?0:0<t.frozenTrailingColumnCount()&&n>e.Hy?2:1}function Yt(t,n,e){var t=t._y(n);return t?t.findNearY(e):C}function Zt(t,n){var t=t._y(-1,d.SheetArea.colHeader);return t?t.findNearY(n):C}function Wt(t,n,e){var t=t.Yy(n);return t?t.findNearX(e):C}function Qt(t,n){var t=t.Yy(-1,d.SheetArea.rowHeader);return t?t.findNearX(n):C}function Jt(t){return!t.options.isProtected||t.options.protectionOptions.allowResizeRows}function Kt(t){return!t.options.isProtected||t.options.protectionOptions.allowResizeColumns}function Xt(t,n){var e,i,r,n,o,t,e=n.row,i=n.rowCount,r=n.col,n=n.colCount,o=t.getColumnCount(),t=t.getRowCount();return{row:e,col:r,rowCount:i=t<i+e?t-e:i,colCount:n=o<n+r?o-r:n}}function qt(t,n){var e,i,e=t.getViewportBottomRow(t.C0(n));if(n<(e=-1===e?t.P6():e))for(i=e;n<i;i--)if(0!==t.getRowHeight(i))return;return 1}function $t(r){var t,o,a,t=r.Ut.getSelections();if(0<t.length)return o=0,a=r.getRowCount(),t.every(function(t){var t,n,e,i,t=Xt(r,t),n=!1;return 1===t.rowCount&&(n=(o+=1)<=1),e=t.row<a,(i=-1!==t.col)||n&&e})}function tn(t,n,e){var i,r,i,r=t.parent.options.rowResizeMode;return e&&0===r&&(r=1),n.action!==N&&1===r&&!qt(t,n.index)&&!(!t.getRowResizable(n.index,n.sheetArea)||!t.getRowResizable(n.index+1,n.sheetArea))&&$t(t)}function nn(t,n,e,i){return tn(t,n,i)&&1===e.length&&e[0].firstRow===e[0].lastRow}function en(t,n){var e,i,e=t.getViewportRightColumn(t.S0(n));if(n<(e=-1===e?t.G6():e))for(i=e;n<i;i--)if(0!==t.getColumnWidth(i))return;return 1}function rn(r){var t,o,a,t=r.Ut.getSelections();if(0<t.length)return o=0,a=r.getColumnCount(),t.every(function(t){var t,n,e,i,t=Xt(r,t),n=!1;return 1===t.colCount&&(n=(o+=1)<=1),e=t.col<a,(i=-1!==t.row)||n&&e})}function on(t,n,e){var i,r,i,r=t.parent.options.columnResizeMode;return e&&0===r&&(r=1),n.action!==yt&&1===r&&!en(t,n.index)&&!(!t.getColumnResizable(n.index,n.sheetArea)||!t.getColumnResizable(n.index+1,n.sheetArea))&&rn(t)}function an(t,n,e,i){return on(t,n,i)&&1===e.length&&e[0].firstColumn===e[0].lastColumn}function un(t,n,e,i,r){var o,a,r,u,o=n.index,a=t.Fi();tn(t,n,r)?(r=t.j5(o,e),Ht(n,i,a,!0,u=t.Gt(o,e)+t.Gt(r,e))):Ht(n,i,a,!0)}function sn(t,n,e,i,r){var o,a,r,u,o=n.index,a=t.Fi();on(t,n,r)?(r=t.O5(o,e),Ht(n,i,a,!1,u=t.nn(o,e)+t.nn(r,e))):Ht(n,i,a,!1)}function cn(t,n,e){var i,r,o,a,u,s,c,f,i=e?t.frozenRowCount():t.frozenColumnCount(),r=e?t.Tb:t.Ab,o=!1,u=r-1;if(0<i&&i<r)for(s=r-1;i<=s;){if(a=e?t.getRowVisible(s):t.getColumnVisible(s)){if(c=e?t.getRowHeight(s):t.getColumnWidth(s),s===u&&0===c)break;if(0<c){o=!0;break}}else u--;s--}for(f=o?i:n,f--;0<=f;){if(a=e?t.getRowVisible(f):t.getColumnVisible(f))return f;f--}return-1}function fn(t){var t=t.il;return t&&t.U6}function ln(t){for(;t!==H.body;){var n;if(getComputedStyle(t).transform.match(/matrix\([^\)]+\)/))return 1;if(!t.parentNode)break;t=t.parentNode}}function e(t){var n=this;n.Ti=t,n.H6=C,n.z6=C,n.V6=C,n.Y6=C,n.Z6=!1,n.W6=!1}function i(t){this.Q6=0;var n=this;n.K6=0,n.J6=!1,n.X6=!1,n.q6={},n.Mf=t,n.tk="gcEvent"+t._id}Object.defineProperty(o,"__esModule",{value:!0}),o.nk=void 0,a=t("./dist/core/core.ns.js"),p=t("./dist/core/worksheet/worksheet.js"),y=t("Common"),s=t("./dist/core/worksheet/worksheet-model.js"),v=t("./dist/core/util/domUtil.js"),b=t("./dist/core/util/common.js"),d=t("./dist/core/core.enum.js"),t=t("./dist/core/workbook/sheettabbase.js"),m=window,H=document,c=v.GC$.each,g=b.mt.Tt,w=b.mt.pi(),V=b.mt.vi,z=b.mt.En,Y=y.Common.zf,f=y.Common.zf.I5,Z=b.Ec,M=y.Common.lt.ht,Q="mousedown"+(n=".handler"),J="mouseup"+n,K="mousemove"+n,X="mousewheel"+n,q="DOMMouseScroll"+n,$="wheel"+n,tt="mouseout"+n,nt="dblclick"+n,C=null,S=void 0,T=isNaN,et=parseInt,A=Math.max,u=Math.floor,I=Math.min,x=Math.abs,it=Math.ceil,rt="function",ot="position",at="absolute",ut="border",st="overflow",ct="top",ft="left",lt="width",ht="height",dt="resize",vt="hidden",mt="visible",gt="none",pt="tabindex",bt="gcUIElement",wt="corner",N="sizeHiddenRow",k="sizeRow",_="sizeCol",yt="sizeHiddenCol",Mt="default",Ct=w.iphone||w.ipad||w.android,n=new y.Common.ResourceManager(a.SR,"Sheets"),St=n.getResource.bind(n),Tt=30,e.prototype.ek=function(t){typeof t==rt&&(this.z6=t)},e.prototype.ik=function(t){var n,e,n=this;T(t)||0===t?n.rk():(n.W6=0<t,t=x(t),(e=n.H6)!==(n.H6=t)&&n.ak())},e.prototype.ak=function(){var t=this;t.d5(),T(t.H6)||(t.V6=m.setInterval(function(){t.uk()},t.H6))},e.prototype.uk=function(){var t=this,n=t.z6;t.Z6=!0,typeof n==rt&&(t.Y6=n.call(t.Ti,t.W6))},e.prototype.rk=function(){var t=this;t.d5(),t.H6=C,t.V6=C,t.Y6=C,t.Z6=!1},e.prototype.d5=function(){var t=this.V6;t&&clearInterval(t)},e.prototype.L0=function(){this.rk()},At=e,i.prototype.L0=function(){var t=this;t.sk&&t.sk.L0(),t.ck&&t.ck.L0(),t.fk=C},i.prototype.lk=function(){var t=this;return t.sk||(t.sk=new At(t)),t.sk},i.prototype.hk=function(){var t=this;return t.ck||(t.ck=new At(t)),t.ck},i.prototype.uw=function(){return this.Mf.uw()},i.prototype.it=function(){var t,t;return t=(t=(0,v.GC$)(this.Mf.Dg()).position())||{top:0,left:0}},i.prototype.gg=function(t){var n,e,n,e,n,i,r,o,a,a,i,r,o,n=b.mt.Qf(),e=h(t),n=n&&!0===e&&0===t.button;return!(2!==t.button&&!n&&(n=(e=this).Mf,e.Fg(),g&&g.msie&&t.offsetX!==S&&t.offsetY!==S&&(r=i=0,o=n.fg,t.target!==o&&(i=(a=b.mt.T0(t.target,o)).I0,r=a.A0),o)&&(a=t.pageX-(t.offsetX+i),i=t.pageY-(t.offsetY+r),o.canvasOffset={top:i,left:a}),r=n.uw(),o=e.dk(t,t.pageX-r.left,t.pageY-r.top),D(n)||o||e.Zg(),n.vk=!0))},i.prototype.Fg=function(){var n=this;n.p4||((0,v.GC$)(H).bind("mousemove.gcSheet."+n.tk,function(t){n.pg(t)}).bind("mouseup.gcSheet."+n.tk,function(t){n.bg(t)}),n.p4=!0)},i.prototype.u2=function(){this.p4&&(this.p4=!1,v.GC$)(H).unbind("mousemove.gcSheet."+this.tk).unbind("mouseup.gcSheet."+this.tk)},i.prototype.dk=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,n,e,n,h,s,c,l,d,v,m,g,i=this,r=i.Mf,o=r.hitTest(n,e),a=o.row,u=o.col,s=o.dragInfo,c=o.formulaRangeHitInfo,f=o.cellTypeHitInfo,l=o.resizeTableHitInfo,h={hitInfo:o,e:t,r:C};if(p.Worksheet.et(r,"processMouseDown",h),n>=(n=r.Fi()).x&&e>=n.y&&(r.sw=o,!h.r))if(i.ab=!0,o.tableSelectInfo&&!r.Nde)i.mk(o,r);else if(o.resizeInfo)(fn(r)||j(r))&&i.gk(o);else if(o.dragMergeInfo)j(r)&&i.pk&&i.pk(o);else if(s&&s.side&&s.side!==wt)j(r)&&(i.bk&&i.bk(o),i.yk(t));else if(s&&s.side===wt)j(r)&&i.wk&&i.wk(o);else if(o.filterButtonHitInfo)j(r);else{if(c)return c.inBorder?(i.Mk(o),!0):c.inTopLeft||c.inTopRight||c.inBottomLeft||c.inBottomRight?(i.Ck(o),!0):void 0;if(l)i.Sk&&i.Sk(o);else if(r.JA(R(o)<0?-1:a,L(o)<0?-1:u)){if(e=r.Nde,o.tableSelectInfo&&e?(n=this.Tk(o,r),o.tableSelectInfo.tableSelection=n,e.Ak(n)):e&&e.Hce(),i.Ik&&i.Ik(r,o))return!0;if(h=jt(r),s=Et(r),f){if(c=r.getCellType(f.row,f.col,B(o)),f.sheet||(f.sheet=r),i.xk(c,f)&&(l=f.sheetArea,M(l)||3===l)&&(a!==h||u!==s)){r.suspendPaint();try{if(!j(r))return;if(d=U(r,r.name(),h,s,S,!0),r.ki(b.Events.LeaveCell,d),d&&!0===d.cancel)return;v=r.Ut.getSelections(),m=r.Ut.getSpan(a,u),g=[new b.Range(m.row,m.col,m.rowCount,m.colCount)],r.ki(b.Events.FloatingElementSelected,{type:"worksheet"}),r.EA(v,g),r.t4(a,u,S,S,1),r.ki(b.Events.EnterCell,U(r,r.name(),a,u)),r.ki(b.Events.EnterCellInternal,U(r,r.name(),a,u)),r.jA(v),r.Nk=!0,i.PA&&i.PA(a,u)}finally{r.resumePaint()}}c.processCellAndPaddingMouseDown(f)}if(f&&f.isReservedLocation)return!0;i.yk(t),i.kk(r,o,a,u)}}},i.prototype.kk=function(t,n,e,i){var r,e,i,r=this;try{if(r.Dk=n,D(t)&&!j(t))return}finally{r.Dk=C}M(e)||M(i)||(3===B(n)&&r.PA&&r.PA(e,i),t.ki(b.Events.FloatingElementSelected,{type:"worksheet"}),e=t.Ut.getSelections(),r._k(n,e),i=t.Ut.getSelections(),t.EA(e,i))},i.prototype.xk=function(t,n){return t&&n&&n.isReservedLocation&&(!t.activeOnClick||t.activeOnClick())},i.prototype.Ek=function(t){var n,e,n=this.Mf;return!n||(e=n.Fi(),M(t.x))||M(t.y)||M(t.width)||M(t.height)||t.x+t.width>e.Py+n.Gy(e)+e.zy||t.y+t.height>e.Cy+n.Sy(e)+e.Iy},i.prototype.jk=function(t,n,e,i,r){for(var o,a,u,s,c,f,l,h,h,d,o=this.Mf,u=0,s=t.options,c=s.length;u<c;u++)if((f=s[u]).selected){a=i[u].value;break}l=!1,o.options.isProtected&&(h=o.getActualStyle(n,e))&&(l=h.locked),a===S||l||(h={cmd:"editCell",sheetName:o.name(),row:n,col:e,newValue:a,autoFormat:!0,ignoreFormatting:r,ignoreFormula:!0},o.Qy().execute(h),null!==a&&(d=o.tables&&o.tables.find&&(o.tables.find(n-1,e)||o.tables.find(n,e-1)))&&o.tables.yx(C,new b.Range(n,e,1,1),null,a,!0)),(0,v.GC$)(t).hide()},i.prototype.Ok=function(){var t,n,t=this;t.Rk&&(3!==(n=t.Rk.Bk)&&2!==n||t.hk().ek(t.Lk),3!==n&&1!==n||t.lk().ek(t.Fk))},i.prototype.Pk=function(){var t=this;t.ob&&t.Gk(),t.Uk&&t.Hk&&t.Hk(),t.zk&&t.Vk&&t.Vk(),t.Yk&&t.Zk&&t.Zk(),t.Wk&&t.Qk(),t.Kk&&t.Jk(),t.Xk&&t.qk(),t.$k&&t.t9&&t.t9()},i.prototype.Lk=function(t){var n,e,i,r,i,o,a,u,s,t,a,i,n=this,e;n.n9()||(i=n.Rk,r=n.Mf,i=i.e9,o=r.getViewportTopRow(i),a=r.getViewportBottomRow(i),s=(u=r.pge())===o?o:r.j5(o),t?(a<E(r)-r.frozenTrailingRowCount()-1||(t=r._y(i))&&0<t.length&&(a=r.Fi(),(i=t[t.length-1]).y+i.height>=a.Cy+r.Sy(a)))&&r.$A(s):o>_t(r)&&r.$A(r.nI(o))),n.Pk()},i.prototype.Fk=function(t){var n,e,i,r,o,a,u,s,c,t,u,o,n=this,e;n.i9()||(i=n.Mf,o=(r=n.Rk).r9,a=i.getViewportLeftColumn(o),u=i.getViewportRightColumn(o),c=(s=i.bge())===a?a:i.O5(a),t?(u<O(i)-i.frozenTrailingColumnCount()-1||(t=i.Yy(o))&&0<t.length&&(u=i.Fi(),(o=t[t.length-1]).x+o.width>=u.Py+i.Gy(u)))&&i.o9(c):a>Dt(i)&&i.o9(i.r6(a))),n.Pk()},i.prototype.n9=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,t=this.Mf,n=t.Fi(),e=_t(t),i=t.frozenTrailingRowCount(),r=this.fk,o=this.Rk,a=o.e9;if(0===a){if(r.y>n.Cy)return t.$A(t.pw()),o.e9=1,!0}else if(1===a){if((u=t._y(1))&&0<u.length){if(s=u[0],0<e&&r.y<n.Cy&&s.row<=t.pw())return!(o.e9=0);if(s=u[u.length-1],0<i&&r.y>n.Ay&&s.row>=t.P6()&&s.y+s.height<=n.Ay)return o.e9=2,!0}}else if(2===a&&(u=t._y(1))&&0<u.length&&r.y<n.Ay){if((s=u[u.length-1]).y+s.height>n.Ay){for(c=t.Sy(n),l=0,h=f=E(t)-i-1;e<=h;h--)if(c<(l+=t.Gt(h))){f=I(h+1,f);break}t.$A(t.j5(f-1))}return o.e9=1,!0}return!1},i.prototype.i9=function(){var t,n,e,i,r,o,a,u,s,c,f,l,h,t=this.Mf,n=t.frozenTrailingColumnCount(),e=Dt(t),i=t.Fi(),r=this.fk,o=this.Rk,a=o.r9;if(0===a){if(r.x>i.Py)return t.o9(t.Sw()),o.r9=1,!0}else if(1===a){if((u=t.Yy(1))&&0<u.length){if(s=u[0],0<e&&r.x<i.Py&&s.col<=t.Sw())return!(o.r9=0);if(s=u[u.length-1],0<n&&r.x>i.Hy&&s.col>=t.G6()&&s.x+s.width<=i.Hy)return o.r9=2,!0}}else if(2===a&&(u=t.Yy(1))&&0<u.length&&r.x<i.Hy){if((s=u[u.length-1]).x+s.width>i.Hy){for(c=t.Gy(i),l=0,h=f=O(t)-n-1;e<=h;h--)if(c<(l+=t.nn(h))){f=I(h+1,f);break}t.o9(t.O5(f-1))}return o.r9=1,!0}return!1},i.prototype.a9=function(){var t,n,e,i,r,i,o,a,u,u,r,e,i,n,s,t=this;(t.rb||t.u9||t.s9)&&(e=(n=t.Mf).Fi(),i=t.Rk,M(i)||(r=i.e9,i=i.r9,o=t.fk,a=C,0<=r&&0<=i?(a=e.c9(r,i),0===r&&n.Tb===n.frozenRowCount()&&(u=e.c9(1,i),a.height+=u.height),0===i&&n.Ab===n.frozenColumnCount()&&(u=e.c9(r,1),a.width+=u.width)):0<=r?a=e.B1(r):0<=i&&(a=e.L1(i)),a&&(r=(u=n.parent)&&u.options.scrollbarAppearance===d.ScrollbarAppearance.mobile,i=e=0,s=n=!1,o.x<=a.x?(e=o.x-a.x,r&&(s=!0)):o.x>=a.x+a.width?(0===(e=o.x-(a.x+a.width))&&(e=50),r&&(s=!0)):r&&o.x===a.x+a.width-1&&(e=50,s=!0),o.y<=a.y?(i=o.y-a.y,r&&(n=!0)):o.y>=a.y+a.height&&(i=o.y-(a.y+a.height),r)&&(n=!0),u&&r&&(n&&(u.Xb.qy(d.ScrollbarState.show),u.ib.$y(!0)),s)&&(u.zb.qy(d.ScrollbarState.show),u.ib.$y(!1)),t.lk().ik(t.f9(e)),t.hk().ik(t.f9(i)))))},i.prototype.l9=function(){this.lk().rk(),this.hk().rk()},i.prototype.gk=function(t){var n,e,i,r,o,o,e,o,i,t,n=this,e=s.h9.prototype,i=n.Mf,r=t.resizeInfo;r.action===k||r.action===N?(o=Ut(n,i.d9,n.v9,e.findRow,t.row,r,!0),r.startY=o.y+(r.E6?o.height:0)):(o=Ut(n,i.m9,n.g9,e.findCol,t.col,r,!1),r.startX=o.x+(r.j6?o.width:0)),e=i.parent,o=t.x,i=t.y,!e||(1!==(t=e.options.showResizeTip)||r.action!==_&&r.action!==yt)&&(2!==t||r.action!==k&&r.action!==N)&&3!==t||(i-30<0?i+=15:i-=30,e.Tw(Y.j0(n.p9()),o,i)),n.isResizing=!0,n.rb=!0,n.ctrl&&(n.b9=!0)},i.prototype.y9=function(){var t,n,e,i,r,o,r,a,u,s,e,r,s,t=this,n=t.Mf,e=n.sw,i=e.resizeInfo,r=t.fk,o=r.x,r=r.y,a=n.Fi(),u=n.parent,s=i.sheetArea;i&&t.rb&&t.isResizing&&(e.x===o&&e.y===r||(i.action===k||i.action===N?un(n,i,s,r,t.b9):sn(n,i,s,o,t.b9),r=(e=n.Dn).J(),e.FA(a.x,a.y,a.width,a.height),e.jy(r),!u)||(1!==(s=u.options.showResizeTip)||i.action!==_&&i.action!==yt)&&(2!==s||i.action!==k&&i.action!==N)&&3!==s||u.ny(t.w9(i)))},i.prototype.C9=function(){var t,n,e,i,r,o,a,i,u,s,i,u,i,t=this;t.isResizing=!1,n=!(t.rb=!1),i=(e=t.Mf).sw,(r=i.resizeInfo)&&(t.iy(),r.action===k||r.action===N?M(r.movingY)?n=!1:(o=A(0,Pt(r,!0)/e.zoom()),a=[],i="resizeRow",e.S9(r.index)?v.GC$.each(e.Ut.getSelections(),function(t,n){var n;-1===n.col&&(1===r.sheetArea?a.push({firstRow:r.index,lastRow:r.index}):(n=e.JS(n),a.push({firstRow:n.row,lastRow:n.row+Lt(n)-1})))}):a.push({firstRow:r.index,lastRow:r.index}),nn(e,r,a,t.b9)&&(i="splitResizeRow"),u=1===r.sheetArea,e.Qy().execute({cmd:i,sheetName:e.name(),rows:a,size:o,columnHeader:u})):M(r.movingX)?n=!1:(o=A(0,Pt(r)/e.zoom()),s=[],i="resizeColumn",e.T9(r.index)?v.GC$.each(e.Ut.getSelections(),function(t,n){var n;-1===n.row&&(n=e.JS(n),2===r.sheetArea?s.push({firstCol:r.index,lastCol:r.index}):s.push({firstCol:n.col,lastCol:n.col+P(n)-1}))}):s.push({firstCol:r.index,lastCol:r.index}),an(e,r,s,t.b9)&&(i="splitResizeColumn"),u=2===r.sheetArea,e.Qy().execute({cmd:i,sheetName:e.name(),columns:s,size:o,rowHeader:u})),(i=e.hitTest(t.fk.x,t.fk.y))&&t.cw(i),n||e.repaint(),t.b9=!1)},i.prototype.A9=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,d,c,e=0,i=0,r=0,o=0,a=this,u=a.Mf,s=u.H3,c=_t(u),f=Dt(u),h=B(t),d=1===h&&u.NMi&&u.NMi.options.isDesignMode&&t.row<u.Ut.getFreeAreaRowCount(h);if(a.I9=a.x9=u.Ut.getSelections(h),u.isCtrlPressed(h)||a.shift||(d?u.IA(h):u.IA()),0===h)!a.shift&&(l=Gt(a,v=c?u.N9():u.Tb,p=f?u.k9():u.Ab,1,1,n))||(u.isCtrlPressed(h)||u.IA(),a.wse(u)?(u.IA(),u.D9(0,0,1,1,!0)):u.D9(-1,-1,E(u),O(u),!0));else if(1===h)d?(b=u.Ut.getSpan(t.row,t.col,1),u.Ut._9(b.row,b.col,b.rowCount,b.colCount),u.D9(b.row,b.col,b.rowCount,b.colCount,!0,1),a.E9=!0):!a.shift&&(v=c?u.N9():u.Tb,m=a.j9(v,t.col,!1),l=Gt(a,m.row,m.col,1,L(t),n))||(a.shift||u.O9?(e=I(u.ci,t.col),o=x(u.ci-t.col)+1,u.kA(-1,e,E(u),o,!0)):u.D9(-1,u.ci,E(u),1,!0));else if(2===h){if(!a.shift){if(d=f?u.k9():u.Ab,m=a.j9(t.row,d,!0),g=u.ui!==m.row,l=Gt(a,m.row,m.col,R(t),1,n))return;g&&s&&s.RA()}a.shift||u.O9?(i=I(u.ui,t.row),r=x(u.ui-t.row)+1,u.kA(i,-1,r,O(u),!0)):u.D9(u.ui,-1,1,O(u),!0)}else if(3===h)if(T(t.row)||T(t.col))D(u)&&(c=u.getCellRect(u.ui,u.ci,u.R9,u.B9),u.Dn._6(c.x,c.y,c.width,c.height));else{if(!a.shift&&(u.ui!==t.row||u.ci!==t.col)){if(g=u.ui!==t.row,l=Gt(a,t.row,t.col,R(t),L(t),n))return;g&&s&&s.RA()}a.shift?u.L9(t.row,t.col,!0):(b=u.Ut.getSpan(t.row,t.col),u.O9||u.D9(b.row,b.col,Lt(b),P(b),!0))}},i.prototype.wse=function(t){for(var n,e,i,r,o,a,n,e=0,i=t.getSelections();e<i.length;e++)if(r=i[e],o=E(t),a=O(t),-1===r.row&&-1===r.col&&r.colCount===a&&r.rowCount===o)return!0;return!1},i.prototype.F9=function(t){var n;!t||3===B(t)&&(T(t.row)||T(t.col))||((n=this).rb=!0,n.ob=!0,n.Rk={e9:R(t),r9:L(t),Bk:B(t)},n.Ok())},i.prototype.P9=function(t,n){var e,i,r,o,t,n,a,u,i,s,e,i=this.Mf,o=i.getSpan(t,n),t=t,n=n,a=1,u=1,i=i.selectionUnit(),s=!1;return 1===i?(u=n=-1,t=o?o.row:t,a=o?o.rowCount:a):2===i?(a=t=-1,n=o?o.col:n,u=o?o.colCount:u):s=!0,r=o&&s?o:new b.Range(t,n,a,u)},i.prototype._k=function(t,n){var e=this,i=e.Mf,r=t.row,o=t.col;i.O9=e.G9(r,o,n,B(t))&&i.parent.options.allowUserDeselect,i.O9&&(i.U9=i.ui,i.H9=i.ci,i.z9=e.P9(r,o)),e.A9(t),e.F9(t)},i.prototype.G9=function(t,n,e,i){var r,o,a,r=this,o=r.Mf,a;return r.V9(t,n,e,i)&&2===o.selectionPolicy()},i.prototype.V9=function(t,n,e,i){var r,o,a,u,s,c,r=this.Mf,o=r.getRowCount(),a=r.getColumnCount();if(!r.isCtrlPressed(i))return!1;for(u=!1,s=e.length,c=0;c<s;c++)if(3===i){if(e[c].contains(t,n,1,1)){u=!0;break}}else if(2===i){if(e[c].contains(t,-1,1,a)||e[c].contains(t,0,1,a)){u=!0;break}}else if(1===i&&(e[c].contains(-1,n,o,1)||e[c].contains(0,n,o,1))){u=!0;break}return u},i.prototype.Gk=function(){var t,n,t=this;t.Rk&&t.rb&&!0!==t.FI&&(3===(n=t.Rk.Bk)?t.Y9():2===n?t.Z9():1===n&&t.W9())},i.prototype.Y9=function(){var t,n,e,i,t,r,o,o,t=this,n=t.Mf,e=t.Q9(),i=t.K9();0<=e&&0<=i&&n.JA(e,i)&&(t.a9(),t=n.Ut.getSelections(),r=n.xA(e,i,n.ui,n.ci),1===t.length&&(o=t[0],!n.O9)&&r.equals(o)||(n.L9(e,i,!0),o=n.Ut.getSelections(),n.O9?n.ki(b.Events.InternalSelectionChanging,{sheet:this,sheetName:n.name(),oldSelections:t,newSelections:r}):n.EA(t,o)))},i.prototype.Z9=function(){var t,n,e,i,e,r,o,a,u,s,i,t=this,n=t.Mf,e=t.Q9(!0);if(0<=e&&n.JA(e,-1)){if(i=I(n.ui,e),e=A(n.ui,e)-i+1,r=-1,o=O(n),0===(a=n.selectionPolicy()))return;2===(u=n.selectionUnit())&&(e=i=-1),s=n.Ut.getSelections(),n.kA(i,-1,e,o,!0),i=n.Ut.getSelections(),n.EA(s,i)}t.a9()},i.prototype.W9=function(){var t,n,e,i,r,e,i,e,i,o,r,a,u,s,e,t=this,n=t.Mf,e=t.Rk.Bk,i=t.Q9(!0,e),r=t.K9(!0,e);if(t.E9&&i<n.Ut.getFreeAreaRowCount(e))e=n.Ut.J9(),i=n.xA(i,r,e.row,e.col,S,1),n.D9(i.row,i.col,i.rowCount,i.colCount,!0,1);else if(t.E9=!1,0<=r&&n.JA(-1,r)){if(e=I(n.ci,r),i=A(n.ci,r)-e+1,o=-1,r=E(n),0===(a=n.selectionPolicy()))return;1===(u=n.selectionUnit())&&(i=e=-1),s=n.Ut.getSelections(),n.kA(-1,e,r,i,!0),e=n.Ut.getSelections(),n.EA(s,e)}t.a9()},i.prototype.X9=function(){var t,n,e,e,i,t=this;t.Rk=C,t.l9(),t.FI=C,t.rb=!1,t.ob=!1,t.q9=t.E9,t.E9=!1,0!==(n=t.Mf).Ut.getSelections().length&&(n.O9&&(n.O9=!1,e=n.z9,n.z9=null,n.tD(n.Ut.getSelections(),e),delete n.U9,delete n.H9),n.Nk?delete n.Nk:((e=!t.x9)||(i=n.Ut.getSelections(),e=t._A(t.x9,i)),e&&n.jA(t.I9,t.shift)),t.x9=n.Ut.getSelections())},i.prototype.nD=function(){var t,n,e,i,t=this.Mf,n=Vt(t,this.fk.y),e=this.Rk.e9,i=t._y(1);return n=0===n&&0<e&&0<i.length&&i[0].row>t.pw()||2===n&&e<2&&0<i.length&&i[i.length-1].row<t.P6()?1:n},i.prototype.eD=function(){var t,n,e,i,t=this.Mf,n=zt(t,this.fk.x),e=this.Rk.r9,i=t.Yy(1);return n=0===n&&0<e&&0<i.length&&i[0].col>t.Sw()||2===n&&e<2&&0<i.length&&i[i.length-1].col<t.G6()?1:n},i.prototype.Q9=function(t,n,e){var i,r,o,a,r,n,e,r,a;if(void 0===n&&(n=d.SheetArea.viewport),r=(i=this.Mf).Ut,o=this.fk.y,n===d.SheetArea.colHeader){if(a=Zt(i,o))return r=r.getFreeAreaRowCount(n),e&&0<r&&a.row>=r?r-1:a.row}else if(a=Yt(i,n=this.nD(),o)){if(e=i.Fi(),r=a.row,1===n&&o<e.Cy){if((a=i.pw())<r)return i.j5(r-1)||r;if(r===a&&t)return 0}else if(0===n&&o<e.T6&&t)return 0;return 1===n&&o>e.Ay&&r>i.iD()?i.nI(r)||r:r}return-1},i.prototype.K9=function(t,n,e){var i,r,o,a,r,n,e,r,a;if(void 0===n&&(n=d.SheetArea.viewport),r=(i=this.Mf).Ut,o=this.fk.x,n===d.SheetArea.rowHeader){if(a=Qt(i,o))return r=r.getFreeAreaColumnCount(n),e&&0<r&&a.col>=r?r-1:a.col}else if(a=Wt(i,n=this.eD(),o)){if(e=i.Fi(),r=a.col,1===n&&o<e.Py){if((a=i.Sw())<r)return i.O5(r-1)||r;if(r===a&&t)return 0}else if(0===n&&o<e.b6&&t)return 0;return 1===n&&o>e.Hy&&r>i.rD()?i.r6(r)||r:r}return-1},i.prototype.f9=function(t){var n,e,n=0;return T(t)||0===t||(e=t<0,n=it(500/x(t)),200<(n=A(20,10*n))&&(n=200),e&&(n=-n)),n},i.prototype.v9=function(t,n){var e,n=this.Mf.nI(t,n);return n!==C?n:t},i.prototype.g9=function(t,n){var e,n=this.Mf.r6(t,n);return n!==C?n:t},i.prototype.oD=function(t,n,e){for(var i=this.Mf;n<t;)if(i.getRowVisible(--t,e))return t;return t},i.prototype.aD=function(t,n,e){for(var i=this.Mf;n<t;)if(i.getColumnVisible(--t,e))return t;return t},i.prototype.uD=function(t,n,e){for(var i=this.Mf;t<n;)if(i.getColumnVisible(++t,e))return t;return t},i.prototype.sD=function(t,n,e){for(var i=this.Mf;t<n;)if(i.getRowVisible(++t,e))return t;return t},i.prototype.cD=function(t,n,e,i,r){var o,a,u,s,c,f,u,s,l,h,d,v,d,m,m,g,g,d,m,c,g,p,b,o=C;if(Jt(t)){if(a=this,u=t.options.reversalTrailingResizeOrder,s=t.Ny,c=2===R(n),u=u&&(f=c&&s),s=c&&!s||u,!(l=t._y(R(n),i))||T(n.row)||T(n.col)){if(T(n.row)&&1===R(n))for(p=3,b=0;b<3&&(o=a.fD(t,b,e,i,r))===C;b++);}else t.getRowVisible(n.row,i)||(n.row=this.v9(n.row,i)),(h=l.findRow(n.row))&&(v=(d=xt(h.height,e))[0],d=d[1],m=!(u&&l[l.length-1].row===h.row),h.y+h.height-d<=r&&r<=h.y+h.height+d&&m?(o=G(k,n.row,i),0<=(m=l[l.length-1].row)&&(g=t.P6(i),o.index===g)&&o.index!==m&&h.y+h.height-d/2<=r&&(o=G(a.lD(t,m,i),m,i)),c&&Ft(o.index,t,i)&&(o.R6=!0),u&&(g=a.sD(o.index,l[l.length-1].row,i),(o=G(a.lD(t,g,i),g,i)).E6=u)):h.y-v<=r&&r<h.y+v&&(0<y.Common.Uf.hD(l,h)||s)&&(d=a.oD(n.row,0,i),o=G(a.lD(t,d,i),d,i),u)&&(o=G(k,n.row,i),(o=0<=(m=l[0].row)&&(c=t.j5(m-1,i,!0),o.index===c)&&o.index!==m&&r<h.y+v/2?G(a.lD(t,m,i),m,i):o).E6=u)),!o&&1===R(n)&&0<l.length&&(h=l[0],A(0,h.y-e)<=r)&&r<=h.y+e&&0<=(g=cn(t,n.row,!0))&&(o=G(a.lD(t,g,i),g,i));o&&!t.getRowResizable(o.index,i)&&(o=C)}return o},i.prototype.fD=function(t,n,e,i,r){var o=this,a=C,u=2===n,n=t._y(n,i),n=n[u?0:n.length-1],s,n;return M(n)||0!==n.height||(s=u?n.y:n.y+n.height,n=n.row,A(0,s-e)<=r&&r<=s+e&&(a=G(o.lD(t,n,i),n,i),u)&&(a.E6=!0)),a},i.prototype.lD=function(t,n,e){var i=t.parent;return i&&1===i.options.resizeZeroIndicator&&t.getRowVisible(n)&&0===t._o(n,e)?N:k},i.prototype.dD=function(t,n,e,i,r){var o,a,u,s,c,f,u,s,l,h,d,v,d,m,g,p,g,p,p,m,d,g,c,b,w,o=C;if(Kt(t)){if(a=this,u=t.options.reversalTrailingResizeOrder,s=t.Vy,c=2===L(n),u=u&&(f=c&&s),s=c&&!s||u,!(l=t.Yy(L(n),i))||T(n.col)||T(n.row)){if(T(n.col)&&1===L(n))for(b=3,w=0;w<3&&(o=a.vD(t,w,e,i,r))===C;w++);}else t.getColumnVisible(n.col,i)||(n.col=this.g9(n.col,i)),(h=l.findCol(n.col))&&(v=(d=xt(h.width,e))[0],d=d[1],m=t.getColumnWidth(n.col,i),g=t.zoom(),p=!(u&&l[l.length-1].col===h.col),h.x+(m*=g)-d<=r&&r<=h.x+m+d&&p?(o=G(_,n.col,i),0<=(g=l[l.length-1].col)&&(p=t.G6(i),o.index===p)&&o.index!==g&&h.x+m-d/2<=r&&(o=G(a.mD(t,g,i),g,i)),c&&Bt(o.index,t,i)&&(o.B6=!0),u&&(p=a.uD(o.index,l[l.length-1].col,i),(o=G(a.mD(t,p,i),p,i)).j6=u)):h.x-v<=r&&r<h.x+v&&(0<y.Common.Uf.hD(l,h)||s)&&(m=a.aD(n.col,0,i),o=G(a.mD(t,m,i),m,i),u)&&(o=G(_,n.col,i),(o=0<=(d=l[0].col)&&(g=t.O5(d-1,i,!0),o.index===g)&&o.index!==d&&r<h.x+v/2?G(a.mD(t,d,i),d,i):o).j6=u)),!o&&1===L(n)&&0<l.length&&(h=l[0],A(0,h.x-e)<=r)&&r<=h.x+e&&0<=(c=cn(t,n.col,!1))&&(o=G(a.mD(t,c,i),c,i));(o=o&&t.gD&&t.pD(n,o.index)?C:o)&&!t.getColumnResizable(o.index,i)&&(o=C)}return o},i.prototype.vD=function(t,n,e,i,r){var o=this,a=C,u=2===n,n=t.Yy(n,i),n=n[u?0:n.length-1],s,n;return M(n)||0!==n.width||(s=u?n.x:n.x+n.width,n=n.col,A(0,s-e)<=r&&r<=s+e&&(a=G(o.mD(t,n,i),n,i),u)&&(a.j6=!0)),a},i.prototype.mD=function(t,n,e){var i=t.parent;return i&&1===i.options.resizeZeroIndicator&&t.getColumnVisible(n)&&0===t.Do(n,e)?yt:_},i.prototype.bD=function(t,n,e,i){var r,o,a,u,s,u,c,f,l,a,h,h,h,t,r=this,o=r.Mf,a=o.parent,u=o.options,s=u.colHeaderVisible,u=u.rowHeaderVisible,c=C;return a&&!a.options.allowUserResize||(a=o.Fi(),R(t)<0&&0<=L(t)&&s&&t.row>=o.getFreeAreaRowCount(d.SheetArea.colHeader)?c=(c=r.dD(o,t,i,1,n))||r.cD(o,t,i,1,e):0<=R(t)&&L(t)<0&&u&&t.col>=o.getFreeAreaRowCount(d.SheetArea.rowHeader)?c=(c=r.cD(o,t,i,2,e))||r.dD(o,t,i,2,n):R(t)<0&&L(t)<0?o.P6(2)===C&&x(e-a.qC)<=i?(h=o._y(1))&&0<h.length&&0<=(f=h[h.length-1].row)&&o.getRowResizable(f,2)&&(c=G(r.lD(o,f,2),f,2)):o.G6(1)===C&&x(n-a.XC)<=i&&(h=o.Yy(1))&&0<h.length&&0<=(l=h[h.length-1].col)&&o.getColumnResizable(l,1)&&(c=G(r.mD(o,l,1),l,1)):0<=R(t)&&0<=L(t)&&(f=E(o,1)-1,l=O(o,2)-1,h=o.options.sheetAreaOffset.top,t=o.options.sheetAreaOffset.left,0<=f&&0===a.qC&&h<=e&&e<=i+h&&s?c=G(r.lD(o,f,1),f,1):0<=l&&0===a.XC&&t<=n&&n<=i+t&&u&&(c=G(r.mD(o,l,2),l,2)))),c},i.prototype.yD=function(t,n,e,i){var r,o,a,n,n,n,r,r=this.Mf,o,a=r.Fi().c9(1,1);if(1===n)if((n=r.Yy(n))&&0<n.length){if((n=n[n.length-1]).x+n.width<=e&&e<a.x+a.width)return!0}else if(a.contains(e,i))return!0;if(1===t)if((n=r._y(t))&&0<n.length){if((r=n[n.length-1]).y+r.height<=i&&i<a.y+a.height)return!0}else if(a.contains(e,i))return!0;return!1},i.prototype.pg=function(t){var n=this.uw();this.wD(t,t.pageX-n.left,t.pageY-n.top)},i.prototype.yg=function(){var t,n,e,i,e,e,n,e,t=this.Mf,n=t.sw;n&&(e=n.cellTypeHitInfo)&&(i=t.getCellType(e.row,e.col,B(n))).Ye(e),this.rb||(t.Nk=S,e={x:-1e4,y:-1e4,rowViewportIndex:C,colViewportIndex:C,row:-1,col:-1,resizeInfo:C,hitTestType:C},this.fw(e),n&&(e=n.row,n=n.col,e=t.getActualStyle(e,n),t.MD&&(clearTimeout(t.MD),delete t.MD),t.parent)&&e&&e.showEllipsis&&t.parent.iy())},i.prototype.wD=function(t,n,e){var i,t,n,r,e,o,a,u,s,c,f,l,h,d,v,f,i=this;i.fk={e:t,x:n,y:e},t=i.Mf,i.ab&&!b.hi.A1(t)&&b.hi.F1(t),i.ab&&i.rb?i.isResizing?i.y9():i.Uk?i.Hk&&i.Hk():i.zk?i.Vk&&i.Vk():i.Yk?i.Zk&&i.Zk():i.Wk?i.Qk():i.Kk?i.Jk():i.Xk?i.qk():i.$k?i.t9&&i.t9():i.ob&&i.Gk():(n=t.hitTest(n,e),i.CD(t,n,i),n&&(0===i.Q6&&n.tableSelectInfo&&i.ab&&i.SD(t,i,n),r=t.parent,e=n.row,o=n.col,a=t.C6(n.rowViewportIndex,n.colViewportIndex),c=n.pivotTableInfo,f=!M(c)&&c.options.showToolTip,r?(s=t.getActualStyle(e,o,a),l=t.getCellRect(e,o,n.rowViewportIndex,n.colViewportIndex),!f||t.isEditing&&t.isEditing()?(clearTimeout(t.MD),delete t.MD,(u=t.Ci(e,o,a))&&!1!==s.hv&&a?r.Tw(Y.j0(u),l.x+l.width+5,l.y+l.height+5,!1):(d=r.options.showScrollTip&&(r.Xb.a4||r.zb.a4||r.Xw.a4))||r.iy()):(u=c.sJt(e,o),h="gc-spread-pivot-toolTip",clearTimeout(t.MD),delete t.MD,r.iy(),u&&!1!==s.hv&&(t.MD=setTimeout(function(t,n){r.Tw(u,t,n+15,!1,h)}.bind(void 0,n.x,n.y),700)))):(clearTimeout(t.MD),delete t.MD),i.cw(n),v=i.fw(n))&&r&&r.options.enableAccessibility&&(f=t.t2(n),r.n2(f)))},i.prototype.CD=function(t,n,e){var i,r,o,a,o;1===e.Q6?(i=e.TD.row,r=e.TD.col,o=n.col,a=t.getSelections()[0],t.kA(i,o<r?o:r,a.rowCount,0<r-o?r-o+1:o-r+1,!0)):2===e.Q6&&(i=e.TD.row,r=e.TD.col,o=n.row,a=t.getSelections()[0],t.kA(o<i?o:i,r,0<i-o?i-o+1:o-i+1,a.colCount,!0))},i.prototype.SD=function(t,n,e){var i,t,i,i=t.getActiveRowIndex(),t=t.getActiveColumnIndex();n.TD={row:i,col:t},"tableColSelect"===(i=e.tableSelectInfo.action)?n.Q6=1:"tableRowSelect"===i&&(n.Q6=2)},i.prototype.cw=function(t){var n,e,i,r,o,a,u,r,u,s,c,f,l,h,d,d,r,u,s,n=this,e=n.Mf,i=e.Dg();i&&(a=!(r=e.sw)||t.row!==r.row||t.col!==r.col||B(t)!==B(r)||t.resizeInfo&&!r.resizeInfo||!t.resizeInfo&&r.resizeInfo||t.resizeInfo&&t.resizeInfo.action!==r.resizeInfo.action||t.dragInfo&&!r.dragInfo||!t.dragInfo&&r.dragInfo||t.dragInfo&&t.dragInfo.action!==r.dragInfo.action||t.resizeTableHitInfo&&!r.resizeTableHitInfo||!t.cellTypeHitInfo&&r.cellTypeHitInfo,r&&a&&(u=r.cellTypeHitInfo)&&(o=e.getCellType(u.row,u.col,B(r))).Ye(u),r=t.resizeInfo,u=t.dragMergeInfo,s=t.dragInfo,c=t.formulaRangeHitInfo,f=t.cellTypeHitInfo,l=e.Dn,h=t.resizeTableHitInfo,(d=t.tableSelectInfo)?"tableRowSelect"===d.action?i.style.cursor="url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+CjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiIHdpZHRoPSI4cHgiIGhlaWdodD0iOHB4IiB2aWV3Qm94PSIwIDAgOCA4IiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCA4IDgiIHhtbDpzcGFjZT0icHJlc2VydmUiPiAgPGltYWdlIGlkPSJpbWFnZTAiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHg9IjAiIHk9IjAiCiAgICBocmVmPSJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUFnQUFBQUlDQVFBQUFCdUJuWUFBQUFBQkdkQlRVRUFBTEdQQy94aEJRQUFBQ0JqU0ZKTgpBQUI2SmdBQWdJUUFBUG9BQUFDQTZBQUFkVEFBQU9wZ0FBQTZtQUFBRjNDY3VsRThBQUFBQW1KTFIwUUEvNGVQekw4QUFBQUhkRWxOClJRZm1BeDBHTURRVFpSbFpBQUFBUzBsRVFWUUkxMlhOc1ExQVVBQkYwZU9qVWxFYXdTNFM0Mmh0d0JCS0kyQXVJcUhReUhmcW0vZDQKNVZxbGo5eGlWSkRwSlFnYW5jdVF1RC9kYVE0aXFjTm10YXRWSnYxdlZIejdBRU5GRE9OV3daY3lBQUFBSlhSRldIUmtZWFJsT21OeQpaV0YwWlFBeU1ESXlMVEF6TFRJNVZEQTJPalE0T2pVeUt6QXdPakF3VkVsRUpBQUFBQ1YwUlZoMFpHRjBaVHB0YjJScFpua0FNakF5Ck1pMHdNeTB5T1ZRd05qbzBPRG8xTWlzd01Eb3dNQ1VVL0pnQUFBQUFTVVZPUks1Q1lJST0iIC8+Cjwvc3ZnPgo=) 8 4,auto":"tableColSelect"===d.action?i.style.cursor="url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+CjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiIHdpZHRoPSI4cHgiIGhlaWdodD0iOHB4IiB2aWV3Qm94PSIwIDAgOCA4IiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCA4IDgiIHhtbDpzcGFjZT0icHJlc2VydmUiPiAgPGltYWdlIGlkPSJpbWFnZTAiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHg9IjAiIHk9IjAiCiAgICBocmVmPSJkYXRhOmltYWdlL3BuZztiYXNlNjQsaVZCT1J3MEtHZ29BQUFBTlNVaEVVZ0FBQUFnQUFBQUlDQVFBQUFCdUJuWUFBQUFBQkdkQlRVRUFBTEdQQy94aEJRQUFBQ0JqU0ZKTgpBQUI2SmdBQWdJUUFBUG9BQUFDQTZBQUFkVEFBQU9wZ0FBQTZtQUFBRjNDY3VsRThBQUFBQW1KTFIwUUEvNGVQekw4QUFBQUhkRWxOClJRZm1BeDBHTlRobnBLRTNBQUFBVGtsRVFWUUkxMlhJTVFwQVVBQUEwUGQ5UlprZHdlNFFWanVUZ3pBN25LTllETCtVb3V5ODhRR1QKMjIyQ0hBUVJBVElmdjRocXZVNkxRMm5QSkkwQmpCb0pDb3ZUYVZZUThkaFVOcXVMRjkwZUQzQ2dxdzV5QUFBQUpYUkZXSFJrWVhSbApPbU55WldGMFpRQXlNREl5TFRBekxUSTVWREEyT2pVek9qVTJLekF3T2pBd21XaEVBQUFBQUNWMFJWaDBaR0YwWlRwdGIyUnBabmtBCk1qQXlNaTB3TXkweU9WUXdOam8xTXpvMU5pc3dNRG93TU9nMS9Md0FBQUFBU1VWT1JLNUNZSUk9IiAvPgo8L3N2Zz4K) 8 4,auto":"tableCornerSelect"===d.action?i.style.cursor="url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+CjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiIHdpZHRoPSIxMHB4IiBoZWlnaHQ9IjEwcHgiIHZpZXdCb3g9IjAgMCAxMCAxMCIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMTAgMTAiIHhtbDpzcGFjZT0icHJlc2VydmUiPiAgPGltYWdlIGlkPSJpbWFnZTAiIHdpZHRoPSIxMCIgaGVpZ2h0PSIxMCIgeD0iMCIgeT0iMCIKICAgIGhyZWY9ImRhdGE6aW1hZ2UvcG5nO2Jhc2U2NCxpVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQW9BQUFBS0NBUUFBQUFuT3djMkFBQUFCR2RCVFVFQUFMR1BDL3hoQlFBQUFDQmpTRkpOCkFBQjZKZ0FBZ0lRQUFQb0FBQUNBNkFBQWRUQUFBT3BnQUFBNm1BQUFGM0NjdWxFOEFBQUFBbUpMUjBRQS80ZVB6TDhBQUFBSGRFbE4KUlFmbUF4MEdOd1BrbVNxUkFBQUFZRWxFUVZRSTExM01zUTJETUJRRTBDZTZVRUxDQnBHeUhOUFEyeVVNeFFRWkFjVXhCV0FCZDkzVAovMGVsTitsYzB2djZDNW96anBJc2lZVnJYc0tGbndab3hKMkR0eWh0RHdjdlpvdDhMTGVDbjd5MzVHTytZeXZlTHg4R3FWQmVBYnlQCk1QNG1OSW4zQUFBQUpYUkZXSFJrWVhSbE9tTnlaV0YwWlFBeU1ESXlMVEF6TFRJNVZEQTJPalUxT2pBekt6QXdPakF3anE0VmhBQUEKQUNWMFJWaDBaR0YwWlRwdGIyUnBabmtBTWpBeU1pMHdNeTB5T1ZRd05qbzFOVG93TXlzd01Eb3dNUC96clRnQUFBQUFTVVZPUks1QwpZSUk9IiAvPgo8L3N2Zz4K) 10 5,auto":"tableSelect"===d.action?i.style.cursor="move":"default"===d.action&&(i.style.cursor=""):r?r.action===_?i.style.cursor=b.CursorResource.ResizeCol:r.action===k?i.style.cursor=b.CursorResource.ResizeRow:r.action===yt?i.style.cursor=b.CursorResource.ResizeHiddenCol:r.action===N?i.style.cursor=b.CursorResource.ResizeHiddenRow:i.style.cursor=Mt:u?u.left||u.right?i.style.cursor="w-resize":(u.top||u.bottom)&&(i.style.cursor="n-resize"):s&&"drag"===s.action?s.side===wt?i.style.cursor="crosshair":s.side?i.style.cursor="move":i.style.cursor=Mt:c?(c.inBorder?i.style.cursor="move":c.inTopLeft?i.style.cursor="nw-resize":c.inTopRight?i.style.cursor="ne-resize":c.inBottomLeft?i.style.cursor="sw-resize":c.inBottomRight&&(i.style.cursor="se-resize"),d=n.isFormulaRangeHovering,u=(r=n.AD)&&r.paramRange,s=c.paramRange,n.isFormulaRangeHovering=!0,n.AD={paramRange:s},d&&s.index===u.index||l.kde()):h?i.style.cursor="se-resize":(f&&(o=e.getCellType(f.row,f.col,B(t)),f.sheet=e,a&&o.processMouseEnter(f),o.ze(f)),!a&&f&&f.isReservedLocation||(i.style.cursor=Mt),n.isFormulaRangeHovering&&(n.isFormulaRangeHovering=!1,n.AD=C,l.kde())))},i.prototype.bg=function(t){var n,e,n=this,e=n.Mf;return n.u2(),!e.vk||(e.vk=!1,n.xD(t),!1)},i.prototype.xD=function(t){var n,e,i,i,r,o,n=this,e=n.Mf,i=b.hi.ai();n.ab=!1,n.Q6=0,i&&i!==e&&i.endEdit&&(i.il&&i.il.rl||(i.endEdit(),i.repaint())),b.hi.F1(e),n.isResizing?n.C9():n.Uk?n.ND&&n.ND():n.zk?n.kD&&n.kD(t):n.Yk?n.DD&&n.DD():n.Wk?n._D():n.Kk?n.ED():n.Xk?n.jD():n.$k?n.OD&&n.OD():e.sw&&(r=(i=e.sw).cellTypeHitInfo,!i.filterButtonHitInfo)&&!i.resizeInfo&&0<=i.row&&0<=i.col&&(r&&(o=e.getCellType(r.row,r.col,B(i)),r.sheet||(r.sheet=e),o.Ve(r)),r&&r.isReservedLocation||e.ki(b.Events.CellClick,U(e,e.name(),i.row,i.col,B(i))),n.X9(),e.RD)&&e.BD&&e.BD(),n.LD=!1,n.yk(t)},i.prototype.FD=function(t,n,e){var i,r,i=this.Mf;!i.isEditing||i!==b.hi.ai()||(r=i.Dg(),F(t))||h(t)||i.m6(r,n,e)},i.prototype.pf=function(t){var n,e,i,r,o,a,i,r,o,u,i,s,a,n=this,e=n.Mf;if(e){if(i=jt(e),r=Et(e),o=e.getCellType(i,r),a={isEditing:D(e),sheet:e,row:i,col:r,sheetArea:3},i={sheet:e,row:i,col:r,sheetArea:3},o&&o.isReservedKey(t,a))return void(D(e)||o.processKeyDown(t,i));if(r={e:t,r:C,c:a},p.Worksheet.et(e,"preProcessKeyDown",r),r.r)return}o=!(D(e)||h(t)||Rt(t)||34!==l(t)&&33!==l(t)&&37!==l(t)&&39!==l(t)&&9!==l(t)&&13!==l(t)&&38!==l(t)&&40!==l(t)),e.Oi&&(e.Oi=!1,e.Dn.PD()),a=27===(i=l(t)),e.RD&&e.GD&&((s=13===i)||a)?e.GD(a):u=o?n.UD?n.HD:n.HD=n.zD(t):n.zD(t),o&&u&&b.hi.A1(e)&&(n.VD=new Date,n.UD?(n.YD<25&&n.YD++,V(t)):(n.UD=!0,n.YD=1,n.ZD(t,!0)))},i.prototype.p9=function(){var t,n,e,i,i,t=this.Mf,n,e=t.sw.resizeInfo;return e.action===k||e.action===N?(i=t.getRowHeight(e.index),f(St().Tip_Height,[i])):(i=t.getColumnWidth(e.index),f(St().Tip_Width,[i]))},i.prototype.w9=function(t){var n=this.Mf;return t.action===k||t.action===N?f(St().Tip_Height,[A(0,u((t.movingY-t.startY)/n.zoom()))]):f(St().Tip_Width,[A(0,u((t.movingX-t.startX)/n.zoom()))])},i.prototype.ZD=function(t,n){var e=this;e.UD&&(new Date-e.VD>(1<e.YD?100:600)?e.V5():(n||(e.HD=e.zD(t)),e.UD&&(e.K6=m.setTimeout(function(){e.ZD(t)},n?500:20))))},i.prototype.WD=function(t,n){var e,i,r,o,i,e=this.Mf,i=e.Dg();if(i){e.Ai=!0;try{r=D(e),e.f6&&e.f6(i,e.ui,e.ci,C,C,!0,C,n,t),!r&&D(e)&&(!(o=e.getCellType(e.ui,e.ci)).j3||32!==l(t)||h(t)||F(t)||Ot(t)||o.j3(e,e.ui,e.ci,3),o.QD)&&o.QD(t)}finally{e.Ai=!1,(i=e.ST()).TT&&delete i.TT}}},i.prototype.zD=function(t){var n,e,i,i,r,o,a,u,s,i,r,c,i,f,n=this,e=n.Mf;if(n.yk(t),D(e)||27!==l(t)||Ot(t)||h(t)||F(t)||!e.KD||((0,v.GC$)(e.KD).remove(),e.KD=C),i=e.ST(),D(e)||27!==l(t)||Ot(t)||h(t)||F(t)||!i.TT||delete i.TT,D(e)||34!==l(t)&&33!==l(t)&&35!==l(t)&&36!==l(t)&&38!==l(t)&&40!==l(t)||V(t),D(e)||37!==l(t)&&39!==l(t)||V(t),D(e)&&h(t)&&(89===l(t)||90===l(t)))V(t);else{if(r=(i=e.Qy()).getShortcutKey(l(t),h(t),F(t),Ot(t),Rt(t)),o=i.getCommands(r))for(a=0;a<o.length;a++)if(u={sheetName:e.name(),vge:!0},(s=o[a].execute(e.parent,u))||u.JD)return s.ignoreCancelDefault||V(t),!0;if(i={e:t,r:C},p.Worksheet.et(e,"processKeyDown",i),i.r)return!0;n.Pi(t)&&((r=e.il)&&r.XD&&r.qD(),(c=D(e))||(f=(i=m.Vc.el(t.target))&&"gcAttachedFormulaTextBox"===i.getAttribute(bt))||n.WD(t))}return!1},i.prototype.V5=function(){var t=this;t.UD=!1,t.HD=S,(t.YD=0)<t.K6&&(clearTimeout(t.K6),t.K6=0)},i.prototype.bf=function(t){var n,e,i,r,o,a,i,r,a,n=this;if(n.V5(),e=n.Mf){if(i=jt(e),r=Et(e),o=e.getCellType(i,r),a={isEditing:D(e),sheet:e,row:i,col:r,sheetArea:3},i={sheet:e,row:i,col:r,sheetArea:3},o&&o.isReservedKey(t,a))return void(D(e)||o.processKeyUp(t,i));if((r=e.il)&&r.$D(t))return;if((a=e.parent&&e.parent.h6)&&a.$D(t))return}n.yk(t)},i.prototype.yf=function(t){var n,e,i,n,e=this.Mf,i={e:t,r:C};p.Worksheet.et(e,"processCompositionStart",i),i.r||this.WD(t,!0)},i.prototype.Pi=function(t){return!(h(t)||Ot(t)||Rt(t))&&(65<=l(t)&&l(t)<=90||48<=l(t)&&l(t)<=59||96<=l(t)&&l(t)<=105||186<=l(t)&&l(t)<=192||220<=l(t)&&l(t)<=222||219===l(t)||106<=l(t)&&l(t)<=111||32===l(t)||61===l(t)||173===l(t)||229===l(t)||0===l(t)||8===l(t))},i.prototype.yk=function(t){var n,e,i,r,o,n=this,e=n.Mf,i,r=(b.mt.Qf()?Rt:h)(t);n.ctrl=r&&!F(t),n.shift=F(t)&&!r,n.isPressShiftKey=F(t),!0===n.zk&&(n.t_=r,o=F(t),n.e_&&(o=!F(t)),n.i_=o,e.Dn.o_)&&e.Dn.o_(),n.a_=r},i.prototype.Y5=function(){var t=this;t.shift=!1,t.ctrl=!1,t.zk=!1,t.i_=!1,t.t_=!1,t.a_=!1},i.prototype.By=function(t){var n,e,i,r,o,a,u,t,s,s,c,f,a,u,e,l,c;t&&t.sheet?(n=t.sheet,e=t.editor,i=t.canvasOffset):e=(n=this.Mf).li,D(n)&&(t=d.SheetArea.viewport,(s=n.vA)?(r=s.row,o=s.col,M(s.sheetArea)||(t=s.sheetArea)):(r=n.ui,o=n.ci),t===d.SheetArea.rowHeader?u=-1:t===d.SheetArea.colHeader&&(a=-1),s=n.getCellType(r,o,t),c=n.Fi(),f=n.getActualStyle(r,o,t),a=n.getCellRect(r,o,a,u),e&&e.parentNode&&(u=e.parentNode.parentNode,e=!1,t===d.SheetArea.rowHeader?e=a.x>=c.x&&a.y>=c.y+c.qC&&a.x+a.width<=c.Py&&a.y+a.height<=c.Ay+c.Iy:t===d.SheetArea.colHeader?e=a.x>=c.x+c.XC&&a.y>=c.y&&a.x+a.width<=c.Hy+c.zy&&a.y+a.height<=c.Cy:t===d.SheetArea.viewport&&(e=a.x>=c.b6&&a.y>=c.T6&&a.x+a.width<=c.Hy+c.zy&&a.y+a.height<=c.Ay+c.Iy),a&&0<a.width&&0<a.height&&e?s.Rn(u,f,a,l={sheet:n,row:r,col:o,sheetArea:t,canvasOffset:i}):(0,v.GC$)(u).css({top:-1e4,left:-1e4})),c=n.il)&&c.u_()},i.prototype.s_=function(t,n){var e,i;if(t)for(e=t.firstChild;e;){if(e.id===n||e.name===n)return e;if(i=this.s_(e,n))return i;e=e.nextSibling}return C},i.prototype._A=function(t,n){var e,i,r,o,e=!0;if(t.length===n.length)for(i=0;i<t.length;i++){if(r=t[i],o=n[i],r.row!==o.row||r.col!==o.col||Lt(r)!==Lt(o)||P(r)!==P(o)){e=!0;break}e=!1}return e},i.prototype.f_=function(t,n,e,i){var r,o,a,u,s,c,f,i,i,l,l,t,i,a,r=this,o=r.Mf,a={sheet:o,row:n,col:e,sheetArea:3},u=o.qc(),s=t.isImeAware(a),f=Ct?at:"fixed";return i&&!o.isEditing()&&r.l_(),s&&!r.g6&&(i=(c=t.jn(a)).style,r.h_||(r.h_={overflow:mt,border:gt,position:at}),r.h_.overflow=i.overflow,r.h_.border=i.border,r.h_.position=i.position,(0,v.GC$)(c).css([ot,st,ct,ft,lt,ht,ut],[f,vt,"0px","0px","0px","0px",gt]),o.Ri&&c.firstChild&&(i=c.firstChild.firstChild,o.Ri(t,i,n,e,o.getActualStyle(n,e),S,S,S,S,3),l=t.getEditorValue(i,a),g.safari)&&(""===l||M(l))&&t.setEditorValue(i," ",a),u&&u.insertBefore(c,C),r.g6=c),r.d_||(c=z("div"),(0,v.GC$)(c).css([ot,st,ct,ft,lt,ht],[f,vt,"0px","0px","0px","0px"]),r.d_=c,l=z("textarea"),(0,v.GC$)(l).attr(bt,"gcSheetFocusInput").attr(pt,-1).css([ot,st,ut,dt],[at,vt,gt,gt]),l.value=" ",c.insertBefore(l,C),r.I1=l,t=z("div"),(0,v.GC$)(t).css(ot,at).css(st,vt).attr(bt,"gcSheetFocusInput").attr("aria-hidden","true").attr("title","").attr(pt,-1),c.insertBefore(t,C),r.m_=t,u&&u.insertBefore(c,C)),!s&&o.parent&&o.parent.options.enableAccessibility&&(o.parent.Q1e(),o.K1e(r.I1,"",n,e,3)),i=m.location!==m.parent.location,a=0<m.scrollX||0<m.scrollY,(Ct||(g.mozilla||g.chrome||g.safari)&&i||a)&&(r.g6&&r.g_(o,r.g6),r.g_(o,r.d_)),s?r.g6:r.I1},i.prototype.p6=function(){var t=this;t.g6&&t.h_&&(0,v.GC$)(t.g6).css(st,t.h_.overflow).css(ut,t.h_.border).css(ot,t.h_.position)},i.prototype.l_=function(){var t=this;t.g6&&(t.g6.parentElement&&t.g6.parentElement.removeChild(t.g6),t.g6.comboBox&&(t.g6.comboBox=C),t.g6=C)},i.prototype.Zg=function(t){b.hi.A1(this.Mf)||this.p_(!0,!0,t)},i.prototype.al=function(){var t=this.m_;t&&t.focus()},i.prototype.aA=function(){this.p_(!0,!0)},i.prototype.b_=function(){this.y_&&(clearTimeout(this.y_),this.y_=C)},i.prototype.p_=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,d,t;0===arguments.length&&(t=!0),(i=this).X6||(i.J6=!1,i.b_(),r=i.Mf,o=jt(r),a=Et(r),u=r.getCellType(o,a),i.f_(u,o,a,n),s={sheet:r,row:o,col:a,sheetArea:3},c=u.isImeAware(s)&&i.g6.firstChild?i.g6.firstChild.firstChild:i.I1,f=c,n&&!g.msie&&u.setImeMode(f,r.getActualStyle(o,a).imeMode,s),H.body.focus(),l=function(){var t=function(){try{u.isImeAware(s)?(u.focus(f,s),r.isEditing()||u.selectAll(f,s)):(c.focus(),r.isEditing()||c.select())}catch(t){}};n&&g.msie&&u.setImeMode(f,r.getActualStyle(o,a).imeMode,s),t()},d=g.metroMode||w.ipad||w.iphone||w.android,!r.Oi&&!d||!t&&u.isImeAware(s)?!1===r._enhanceIme||e||i.w_(r)||l():!D(r)&&d?n&&(t=i.g6&&i.g6.firstChild&&i.g6.firstChild.firstChild,u.setImeMode(t,r.getActualStyle(o,a).imeMode,s)):i.y_=m.setTimeout(function(){i.w_(r)||(i.b_(),D(r))||!1===r._enhanceIme||e||l()},200),b.hi.A1(r)||i.w_(r)||b.hi.F1(r),i.M_(r))||i.PA&&i.PA(r.ui,r.ci)},i.prototype.g_=function(t,n){var t,e,e,i,r,o,e,i,r,o,t,i,a,t,u,s,c,u,i,c,s,e=jt(t),i=Et(t),r=t.R9,o=t.B9,e=t.getCellRect(e,i,r,o),i=this,r=t.uw(),o=i.it(),t=i.g6,i=0,a=0;t&&(t=(0,v.GC$)(t),i=parseInt(t.css(ht),10),a=parseInt(t.css(lt),10)),t=e.y+o.top-2,e=e.x+o.left-2,u=m.pageYOffset,s=m.pageXOffset,(c="fixed"===n.style.position&&!ln(n))&&(t-=u,e-=s),u=c?0:u-r.top+o.top,i=m.innerHeight+u-i,c=c?0:s-r.left+o.left,s=m.innerWidth+c-a,(T(t)||t<u||i<t)&&(t=u),(T(e)||e<c||s<e)&&(e=c),(0,v.GC$)(n).css(ct,t).css(ft,e)},i.prototype.C_=function(t){var n,e,i,t,e,n=this;n.b_(),D(n.Mf)||n.J6&&H.activeElement===n.m_||(e=n.Mf,t=t?(i=t.row,t.col):(i=e.ui,e.ci),e=e.getCellType(i,t),n.f_(e,i,t,!1),n.m_.focus(),n.J6=!0)},i.prototype.S_=function(t,n){var e=this;e.J6&&(e.J6=!1,n||e.p_(t))},i.prototype.IT=function(t){var n,e,n,e=this.Mf.ST();e&&(e.YS(t),e.ZS(),this.X6=!0,t)&&e.WS()},i.prototype.NT=function(){var t,n,t=this,n=t.Mf.ST();n&&n.YS(""),t.X6=!1,t.p_(!0,!1)},i.prototype.T_=function(){var t,n,t=this;t.b_(),(n=t.g6)&&((0,v.GC$)(n).remove(),t.g6=S),(n=t.d_)&&((0,v.GC$)(n).remove(),t.I1=S,t.d_=C,t.m_=C)},i.prototype.Tw=function(t,n,e,i){var r=this.Mf.parent;r&&r.Tw(Y.j0(t),n,e,i)},i.prototype.ny=function(t,n,e,i){var r=this.Mf.parent;r&&r.ny(t,n,e,i)},i.prototype.iy=function(){var t=this.Mf.parent;t&&t.iy()},i.prototype.fw=function(t){var n,e,i,r,o,a,u,s,u,c,i,r,i,s;function f(t,n){var e=!1;return t||n?t&&n&&(e=t.action===n.action&&t.index===n.index&&t.sheetArea===n.sheetArea):e=!0,e}return i=(e=(n=this).Mf).A_,r=e.I_,a=(a=(a=(o=e.sw)?!1:!0)||t?a:!0)||t.col!==o.col||t.row!==o.row||L(t)!==L(o)||R(t)!==R(o)||B(t)!==B(o)||!f(t.resizeInfo,o.resizeInfo),e.sw=t,a&&(s=(u=e._1)&&u.isEnable(d.RowColumnStates.hover,!0),u=u&&u.isEnable(d.RowColumnStates.hover,!1),c=t.hitTestType,o&&!M(o.hitTestType)&&(e.A_=null,e.I_=null,e.Ut.setCellState(i,r,d.CellStatesType.hover,!1,o.hitTestType),s&&e.x_(i,o.rowViewportIndex,o.colViewportIndex),u&&e.N_(r,o.rowViewportIndex,o.colViewportIndex),s||u||e.k_&&e.k_(d.CellStatesType.hover,i,r,o.hitTestType,o.rowViewportIndex,o.colViewportIndex)),t&&!M(c)&&(i=void 0!==t.row&&void 0!==t.col&&c===d.SheetArea.viewport,e.A_=t.row,e.I_=t.col,t.resizeInfo||(e.Ut.setCellState(t.row,t.col,d.CellStatesType.hover,!0,c),s&&i&&e.x_(t.row,t.rowViewportIndex,t.colViewportIndex),u&&i&&e.N_(t.col,t.rowViewportIndex,t.colViewportIndex),s)||u||e.k_&&e.k_(d.CellStatesType.hover,t.row,t.col,c,t.rowViewportIndex,t.colViewportIndex)),e.D_=!0,i=kt(e,o,r=e.Dn),s=kt(e,t,r),i=i||s,e.D_=!1,(i||e.gD)&&r.E1(),e.NMi)&&e.NMi.options.isDesignMode&&1===c&&r.E1(S,S,S,S,1),a},i.prototype.j9=function(t,n,e){var t=this.__(t,n,e);return this.E_(t)},i.prototype.__=function(t,n,e){var i,r,o,i=this.Mf.Ut.getSpan(t,n),r=Lt(i),o=P(i);return 1===r&&1===o||e&&1===r||!e&&1===o?i:(e?n++:t++,this.__(t,n,e))},i.prototype.E_=function(t){for(var n,e,i,r,o,a,n=this.Mf,e=t.row,r=E(n),i=e;i<r&&!0!==n.getRowVisible(i);i++);for(i<r&&(e=i),o=t.col,a=O(n),i=o;i<a&&!0!==n.getColumnVisible(i);i++);return Z(e,o=i<a?i:o,Lt(t),P(t))},i.prototype.M_=function(t){var n,e,i,r,n=t.floatingObjects&&t.floatingObjects.all(),e=t.shapes&&t.shapes.all();if(!M(n))for(i=0;i<n.length;i++)if(n[i].isSelected())return!0;if(!M(e))for(r=0;r<e.length;r++)if(e[r].isSelected())return!0},i.prototype.w_=function(t){return"function"==typeof t.isShapeTextEditorOpened&&t.isShapeTextEditorOpened()},i.prototype.j_=function(t){var r,n,e,o,a,e,n,i,u,u,i,r=this.Mf,n=t.resizeInfo;return n?(e=r.Ut.getSelections(),n.action===k||n.action===N?(o=[],r.S9(n.index)?c(e,function(t,n){var e,i;if(-1===n.col)for(e=r.JS(n),i=0;i<Lt(e);i++)o.push({row:e.row+i})}):o.push({row:n.index}),r.Qy().execute({cmd:"autoFitRow",sheetName:r.name(),rows:o,columnHeader:1===n.sheetArea})):(a=[],r.T9(n.index)?c(e,function(t,n){var e,i;if(-1===n.row)for(e=r.JS(n),i=0;i<P(e);i++)a.push({col:e.col+i})}):a.push({col:n.index}),r.Qy().execute({cmd:"autoFitColumn",sheetName:r.name(),columns:a,rowHeader:2===n.sheetArea})),!0):(e=t.row,n=t.col,i=t.hitTestType,(u=r.O_(t.rowViewportIndex,t.colViewportIndex,t.hitTestType,t.row,t.col))&&(e=u.row,n=u.col),u=void 0,i=r.getFormula&&r.getFormula(e,n,i,!0),r.f6(r.fg,e,n,t.rowViewportIndex,t.colViewportIndex,!1,u=i?"="+i:u,!1),!1)},It=i,o.nk=It,p.Worksheet.ch("eventHandler",{beforeSetHost:function(){var t=this;t.rt=new It(t)},dispose:function(t){var n,e,i,r,r,i,n=this,e=n.rt;e&&(e.u2(),i=e.tk,(0,v.GC$)(n.Dg()).unbind(Q+"."+i).unbind(J+"."+i).unbind(K+"."+i).unbind(X+"."+i).unbind(tt+"."+i).unbind(nt+"."+i),g.mozilla&&(r="onwheel"in document?$:q,(0,v.GC$)(n.Dg()).unbind(r+"."+i)),e.L0(),e.T_()),(r=n.li)&&(0,v.GC$)(r).remove(),(i=n.R_)&&(i.close(),n.R_=null),!1!==t.clearCache&&(n.B_=C,n.L_=C,n.F_=C,n.P_=C,n.G_=C,n.U_=C,n.rt=C)},setHost:function(t){var f,i,n,e;function r(t,n){var e,i,e,r,o,e=f.uw(),i=n.pageX-e.left,e=n.pageY-e.top,r=f.hitTest(i,e),o=r.dragInfo;r.tableSelectInfo||(o&&t.H_&&"corner"===o.side?t.H_():t.FD(n,i,e))}t&&(i=(f=this).rt,f.B_=function(t){var n={e:t,r:C};if(p.Worksheet.et(f,"preProcessMouseDown",n),!n.r)return i.gg(t)},f.L_=function(t){var n={e:t,r:C};p.Worksheet.et(f,"preProcessMouseMove",n),n.r||i.p4||i.pg(t)},f.F_=function(t){var n={e:t,r:C};return p.Worksheet.et(f,"preProcessMouseUp",n),n.r||f.f2||i.p4?void 0:i.bg(t)},f.wge=function(t,n,e){var i,r,o,a,i=(new Date).valueOf(),a=!f.z_||200<i-f.z_;return M(t)||(a?(r=(0<=(r=t/e)?1:-1)*u(x(r)),f.V_=0):(f.V_+=r=t/e,r=(0<=r?1:-1)*u(x(f.V_)),f.V_-=r)),M(n)||(a?(o=(0<=(o=n/e)?1:-1)*u(x(o)),f.Y_=0):(f.Y_+=o=n/e,o=(0<=o?1:-1)*u(x(f.Y_)),f.Y_-=o)),f.z_=i,{detailY:r,detailX:o}},f.P_=function(t){var n,n,e,i,r,o,a,u,s,a,c,e,n={e:t=t||m.event,r:C};if(p.Worksheet.et(f,"preProcessMouseWheel",n),!n.r)return e=(n=f.parent)&&n.options.scrollByPixel,i=t.detail||t.wheelDelta/-40,r=0,"wheel"===t.type?(o=17,a=t.wheelDeltaY&&Math.abs(t.wheelDeltaY- -3*t.deltaY)<1,u=g.mozilla&&88<=+g.version&&!a?17:1,i=t.deltaY/u,r=t.deltaX/u,e||(x(i)>=x(r)?r=0:i=0),a&&(i=(s=f.wge(i,r,1)).detailY,r=s.detailX)):(a=t.wheelDeltaY,c=t.wheelDeltaX,e||(x(a)>=x(c)?c=0:a=0),(g.safari||g.chrome)&&(u=g.safari?-4:-40,i=(s=f.wge(a,c,u)).detailY,r=s.detailX)),(0!==i||0!==r)&&(e=f.parent.ib.Mg(f,t,et(i,10)||0,et(r,10)||0),n.iy(),!!e)&&void 0},f.G_=function(t){var n={e:t,r:C};if(p.Worksheet.et(f,"preProcessMouseOut",n),!n.r)return i.yg(t)},f.U_=function(t){var n,n,e,n={e:t,r:C};p.Worksheet.et(f,"preProcessMouseDbClick",n),n.r||(n=f.sw)&&(e=!1,3===B(n)?r(i,t):e=i.j_(n),e||f.ki(b.Events.CellDoubleClick,U(f,f.name(),n.row,n.col,B(n))))},n=i.tk,t.bind(Q+"."+n,function(t){return f.B_(t)}).bind(J+"."+n,function(t){return f.F_(t)}).bind(K+"."+n,function(t){return f.L_(t)}).bind(X+"."+n,function(t){return f.P_(t)}).bind(tt+"."+n,function(t){return f.G_(t)}).bind(nt+"."+n,function(t){return f.U_(t)}),g.mozilla)&&(e="onwheel"in document?$:q,t.bind(e+"."+n,function(t){return f.P_(t)}))}}),t.Hv.ch("worksheet-event",{preProcessMouseMove:function(t){var n,n,n=this.Vv.getActiveSheet();n&&(n=n.rt)&&n.ab&&n.rb&&n.isResizing&&(n.pg(t.e),t.r=!1)}})},"./dist/core/worksheet/worksheet-formatter.js":function(t,n,u){"use strict";var e,i,r,o,a,l,s,h,c,d,v,m;function f(t,n,e,i,r){var o,n,a,o=n.getRange(e,i);if(n.source&&(t=n.source.Mf),n=o.row,a=o.col,r)if(1===o.rowCount)a=i;else{if(1!==o.colCount)return d;n=e}return g(t,n,a)}function g(t,n,e){var i,r,o,r,t,r;return t&&t.getFormatter?(i=t.getFormatter(n,e))&&"General"!==i?y(i,function(t,n){return a.Be.Re(t,n)}):(r=t.getStyle(n,e),(o=r&&r._autoFormatter)?y(o.formatCached,function(t,n){return o.format(t)}):(t=(r=t.pivotTables)&&r.findPivotTable(n,e))&&(i=(r=t.hqt(n,e))&&r.formatter)?y(i,function(t,n){return a.Be.Re(t,n)}):d):d}function p(t,n){var n=s(t,"E")&&n(1,t);return n&&s(n,"E")}function b(t,n){var n=n(123,t);return s(n,"123")&&0<(n=n.replace(/[1230. ]+/g,"")).length}function w(t,n){var n;if(t=t.replace("DBNum",""),e.Common.$T.qT("[mMdDyYhHseg]").test(t))return n=n(123,t),!s(n,"123")}function y(t,n){var e,i,r,o;if("="===t[0])return d;if(e={f:t},w(t,n)){if(i=n(44955,t),r=n(44955.11,t),o=n(45323,t),i!==r)return e.t=i===o?6:8,e;if(i!==o)return e.t=7,e}if(s(t,"%"))e.t=0;else if(s(t,"/"))e.t=4;else if(p(t,n))e.t=3;else if(b(t,n))e.t=5;else if(s(t,"0")||s(t,"DBNum",!0))e.t=2;else if(s(t,"GENERAL",!0))e.t=1;else{if(!s(t,"@"))return d;e.t=9}return e}function M(t,n,e,i,r){var e,t,e=e.value;if(e&&2===e.type)return{f:"0.00%",t:0};if(e&&9===e.type)if(0===e.operatorType||1===e.operatorType){if(e.value&&2===e.value.type)return{f:"0.00%",t:0}}else if(2===e.operatorType)return(t=M(t,n,e,i,r))&&0===t.t&&(t.f=t.f.replace("%","00%")),t;return d}function C(t,n,e,i,r){var o,t,o=A(t,n,e.value,i,r),t=A(t,n,e.value2,i,r);if(7===o.t||8===o.t){if(7===t.t||8===t.t)return d;if(6===t.t)return 8===o.t?o:{f:o.f+" "+t.f,t:8}}else if(6===o.t){if(8===t.t)return t;if(7===t.t)return{f:t.f+" "+o.f,t:8}}return 0===o.t&&0===t.t?{f:(t.f.length>o.f.length?t:o).f,t:0}:1!==o.t?o:t}function S(t,n,e,i,r){var o,t,o=A(t,n,e.value,i,r),t=A(t,n,e.value2,i,r);return 9===o.t?o:9===t.t?t:5<=o.t?5<=t.t?d:o:5<=t.t?t:3===o.t?o:3===t.t?t:4===o.t?o:4===t.t?t:2!==o.t&&1!==o.t&&2!==t.t&&1!==t.t&&0===o.t&&0===t.t?{f:(t.f.length>o.f.length?t:o).f,t:0}:d}function T(t,n,e,i,r){var o,a,u,s,c,f,o=e.functionName&&e.functionName.toUpperCase(),a=m[o];if(l(v[o]))return"number"==typeof a?A(t,n,f=e.arguments[a],i,r):a?a(t,n,e,i,r):d;switch(v[o]){case 6:u="H:mm:ss";break;case 7:u=h.Fe().DateTimeFormat.shortDatePattern||"M/d/yyyy";break;case 8:u=h.Fe().DateTimeFormat.defaultDatePattern||"M/d/yyyy H:mm:ss";break;case 0:u="0.00%";break;case 5:s=h.Fe().NumberFormat.currencySymbol||"$",u=(c=h.Fe().predefinedFormats.Currency)&&c[c.length-1]||"".concat(s,"#,##0.00_);[Red](").concat(s,"#,##0.00)")}return{f:u,t:v[o]}}function A(t,n,e,i,r){if(e)if(9===e.type){if(2===e.operatorType)return M(t,n,e,i,r);if(3===e.operatorType||4===e.operatorType)return C(t,n,e,i,r);if(5===e.operatorType||6===e.operatorType||7===e.operatorType)return S(t,n,e,i,r);if(0===e.operatorType||1===e.operatorType)return A(t,n,e.value,i,r)}else{if(1===e.type||13===e.type||22===e.type)return f(t,e,i,r);if(7===e.type)return T(t,n,e,i,r);if(10===e.type)return A(t,n,e.value,i,r)}return d}function I(t,n,e,i,r){var o=t.getFormatter(i,r);o&&"GENERAL"!==o.toUpperCase()||(e=t.oMt.Fyt(i,r)||e,x(t,i,r,A(t,n,e,i,r)))}function x(t,n,e,i){var r=t.Z_(n,e)||new o.Style;(i="string"==typeof i?y(i,function(t,n){return a.Be.Re(t,n)}):i)&&1!==i.t?r._autoFormatter=new c(i.f):delete r._autoFormatter,delete r.formatter,t.setStyle(n,e,r)}Object.defineProperty(n,"__esModule",{value:!0}),n.Ffe=n.Fue=n.Pue=void 0,e=u("Common"),i=u("./dist/core/util/domUtil.js"),r=u("./dist/core/worksheet/worksheet.js"),o=u("./dist/core/worksheet/style.js"),a=u("./dist/core/util/common.js"),l=e.Common.lt.ht,s=e.Common.zf.OS,h=e.Common.CultureManager,c=e.Formatter&&e.Formatter.GeneralFormatter,d={t:1},i.GC$.extend(r.Worksheet.prototype,{getFormatter:function(t,n,e){return this.l0(t,n,"formatter",e)},setFormatter:function(t,n,e,i){var r=this.Z_(t,n,i),r;(r=r||new o.Style).formatter=e,this.setStyle(t,n,r,i)}}),r.Worksheet.ch("formatter",{settingText:function(t){var n,n,n=a.util.Kf(t.value);c&&n&&(n={},(new c).getPreferredDisplayFormatter(t.value,n),"number"==typeof n.value)&&(t.value=n.value)}}),v={NOW:8,TODAY:7,TIME:6,DATE:7,IRR:0,XIRR:0,MIRR:0,RATE:0,YIELD:0,INTRATE:0,NPV:5,XNPV:5},(m={SUM:0,MAX:0,MIN:0,AVEDEV:0,FLOOR:0,ROUND:0,ROUNDUP:0,ROUNDDOWN:0,INT:0,TRUNC:0}).SINGLE=m["@"]=function(t,n,e,i,r){var e=e.arguments[0];return!e||1!==e.type&&13!==e.type?d:f(t,e,i,r,!0)},m.INDIRECT=m.OFFSET=m.INDEX=function(i,t,n,r,o){var e,a,e=u("SheetsCalc"),a=d;return e&&(n.Gue=function(t,n,e){a=l(n)?f(i,t,r,o):g(e&&e.Mf||i,t,n)},e.evaluateExpression(i,n,r,o)),a},n.Pue=A,n.Fue=I,n.Ffe=x},"./dist/core/worksheet/worksheet-json.js":function(r,t,n){"use strict";var t,z,Y,Z,at,W,e,M,ut,o,st,i,ct,p,n,ft,n,a,x,u,pt,c,Q,J,lt,K,ht,N,X,dt,bt,d,v,l,m,wt,C,k,_,s,f,yt,S,D,vt,g,b,y,j,T,h,Mt,Ct,St,w,E,Tt,At,It,O,et,q,$,mt,A,R,L,B,gt,n;function I(t,n){return dt(t)?n:dt(n)?t:Math.max(t,n)}function F(t,n,e,i){var t,t;t.dataTable&&(n.dataTable||(n.dataTable={}),t=t.dataTable[e])&&(n.dataTable[e]||(n.dataTable[e]={}),t=t[i])&&(n.dataTable[e][i]||(n.dataTable[e][i]={}),t.formula)&&(n.dataTable[e][i].formula=t.formula)}function it(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,o=t.Ut,a=o.W_(),u=o.W_(ut.SheetArea.colHeader),s=o.Q_(!0),c=o.Q_(!0,ut.SheetArea.colHeader),f=o.K_(),l=o.K_(ut.SheetArea.colHeader),h=a.getColumnCount();for(!r&&dt(n.colHeaderData)?n.colHeaderData={}:o.ap=e,u.setRowCount(e),d=0;d<e;d++)for(u.setNode(d,-1,a.J_(d,-1)),c.X_(d,s.q_(d)),v=i;v<h;v++)u.setNode(d,v,a.J_(d,v)),r||F(n.data,n.colHeaderData,d,v);(m=f.getSpans((0,at.Ec)(0,0,e,h))).forEach(function(t){l.add(t)}),t.frozenRowCount(0)}function rt(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,o=t.Ut,a=o.W_(),u=o.W_(ut.SheetArea.rowHeader),s=o.Q_(!1),c=o.Q_(!1,ut.SheetArea.rowHeader),f=o.K_(),l=o.K_(ut.SheetArea.rowHeader),h=a.getRowCount();for(!r&&dt(n.rowHeaderData)?n.rowHeaderData={}:o.fp=e,u.setColumnCount(e),d=0;d<e;d++)for(u.setNode(-1,d,a.J_(-1,d)),c.X_(d,s.q_(d)),v=i;v<h;v++)u.setNode(v,d,a.J_(v,d)),r||F(n.data,n.rowHeaderData,v,d);(m=f.getSpans((0,at.Ec)(0,0,h,e))).forEach(function(t){l.add(t)}),t.frozenColumnCount(0)}function P(t,n){switch(t){case"frozenRowCount":case"frozenColCount":case"frozenTrailingRowCount":case"frozenTrailingColCount":case"activeRow":case"activeCol":case"frozenTopRow":case"frozenLeftCol":return 0===n;case"rowCount":return 200===n;case"columnCount":return 20===n;case"zoomFactor":case"rowHeaderColCount":case"colHeaderRowCount":return 1===n;case"visible":case"frozenTrailingRowStickToEdge":case"frozenTrailingColumnStickToEdge":return!0===n}}function tt(t,n){return K(t)?t:n}function nt(t,n,e,i){K(e)&&n.call(t,e,!!K(i)&&i)}function ot(e,i,r,o,a,u){lt&&ht(lt,function(t,n){var n=n.fromJson;n&&n.call(e,i,r,o,!K(a)||a,u)})}function G(t,i){var t=t.Uw&&t.Uw(3).t8.jme(-1,-1,-1,-1);t&&t.forEach(function(t){var n,e;t.isValid||(n=i[t.minX]&&i[t.minX][t.minY])&&(e={row:t.minX,rowCount:t.maxX-t.minX+1,col:t.minY,colCount:t.maxY-t.minY+1,isDynamicArray:!0},t.isValid||(e.isInvalid=!0),n.arrayInfo=e)})}function U(t,n){var n=k(n,Mt+"&tabColor");n&&(t.sheetTabColor=f(n))}function H(t,n,e){Bt(t,n,e),st.Util.wo(e,t.parent&&t.parent.v2)&&V(t,e)}function V(t,n){Q&&t.Lp.resumeAdjust(),Ut(t,n)}function xt(t,n,e){t.showCell(n,e,ut.VerticalPosition.top,ut.HorizontalPosition.left)}function Nt(t){var t,n,e,t,t=C(t,Ct);return t&&t.ref&&(t=S(t.ref,!0))&&(n=t.row+t.rowCount,e=t.col+t.colCount),{rowCount:n=dt(n)||n<-1?z.Worksheet.n8:n,colCount:e=dt(e)||e<-1?z.Worksheet.e8:e}}function kt(t,n){var t,n,e,t=t.defaults,n=C(n,At);n&&(e=n.defaultColWidth,isNaN(e)?(t.colWidth=at.SJSColumnWidthHelper.defaultColumnWidthToPixel(8),t._isExcelDefaultColumnWidth=!0):t.colWidth=at.SJSColumnWidthHelper.columnWidthToPixel(parseFloat(e)),t.rowHeight=at.SJSColumnWidthHelper.pointToPixel(n.defaultRowHeight))}function _t(r,o,a,t){var n,e,i,u,s,c,f,l,h,d,v,m,g,p,b,w,y,y,M,M,C,y,i,M,d,n=k(o,"sheetViews&sheetView"),e=r.Ut,i=r.options,d=!a||!1!==a.includeStyles,v=st.Util.Co(a),m=r.getRowCount(),g=r.getColumnCount(),p=o.lossless,b=0,w=0;return n&&((y=n.topLeftCell)&&(f=S(y),b=f?f.row:0,w=f?f.col:0),n.zoomScale&&r.zoom(n.zoomScale/100),y=i.gridline,(M=o.lossless&&o.lossless.gridline)?(y.showHorizontalGridline=!!dt(M.showHorizontalGridline)||M.showHorizontalGridline,y.showVerticalGridline=!!dt(M.showVerticalGridline)||M.showVerticalGridline):"0"===n.showGridLines&&(y.showHorizontalGridline=!1,y.showVerticalGridline=!1),M&&!dt(M.color)?y.color=M.color:n.colorId&&64!=+n.colorId&&(y.color=at.ColorHelper.getIndexedColor(n.colorId)),T(n.showRowColHeaders,!0)||(i.rowHeaderVisible=!1,i.colHeaderVisible=!1),T(n.showFormulas)&&(i.showFormulas=!0),i.showZeros=T(n.showZeros,!0),T(n.tabSelected)&&r.b2(!0,!1),M=_(n,"pane"),C=3,d&&M&&0<M.length&&M.forEach(function(t){var n,n,t,e,i,n=t.state;"frozen"!==n&&"frozenSplit"!==n||(t.topLeftCell&&(c=t.topLeftCell),n=t.xSplit,t=t.ySplit,e=b,i=w,t&&m<=(l=+t+e)&&(m=I(m,l)),n&&g<=(h=+n+i)&&(g=I(g,h)),Rt(r,o,a,l,h,b,w),t&&n?(f=S(c),b=f.row||0,w=f.col||0):t&&!n?(f=S(c),b=f.row||0,w=i):!t&&n&&(f=S(c),b=e,w=f.col),m<b&&(m=b+1),g<w&&(g=w+1))}),d&&Lt(r,o),d&&(p&&p.defaultStyle?((y=new Y.Style).fromJSON(p.defaultStyle,mt,r),r.setDefaultStyle(y)):t.defaultStyle&&r.setDefaultStyle(t.defaultStyle)),(i=_(n,"selection"))&&0<i.length&&i.forEach(function(t){var n,n,n,t,n,n=t.activeCell;n&&(n=S(n),u=n.row,s=n.col,m=I(m,n.row+1),g=I(g,n.col+1)),n=t.panel,!(t=t.sqref)||n&&3!==n||(n=D(t),e.selectionModel.selections=n,v&&n&&n.forEach(function(t){var n=t.row+(0<t.rowCount?t.rowCount:1),t=t.col+(0<t.colCount?t.colCount:1);m=I(m,n),g=I(g,t)}))}),v)&&st.Util.So(r,m,g,t),M=p?tt(p.rowHeaderColCount,z.Worksheet.r8):z.Worksheet.r8,d=p?tt(p.colHeaderRowCount,z.Worksheet.o8):z.Worksheet.o8,r.setColumnCount(M,ut.SheetArea.rowHeader),r.setRowCount(d,ut.SheetArea.colHeader),r.O6(u||0,s||0,mt,mt,!0),{showCellRow:b,showCellCol:w}}function Dt(l,t,h,d,n,v){var m,e,g,i,i,p,b,w,e,n,y,M,i,m=!n||!1!==n.includeStyles,e=l.Ut,g=e.Q_(!1,3),i=C(t,It),i=i&&i.c_,p=e.W_(3),b=p.a8,w=j(n);i&&0<i.length&&(e=l.name(),n=(n=v.sheetColumnInfos)||(v.sheetColumnInfos={}),y=[],M=l.getColumnCount(),i.forEach(function(t,n){var e,r,i,o,a,a,u,s,c,e,i,f,e=t.width,r=T(t.hidden,!1),i=t.outlineLevel,a=p.J_(-1,n,!0),a=a&&a.style,u=+t.min,s=+t.max,c=A;for(dt(e)||(c=at.SJSColumnWidthHelper.columnWidthToPixel(parseFloat(e)),r&&0===c&&(c=mt)),r=r&&dt(i)?r:A,w?t.t!==mt?o=h.getOriginNamedStyle(t.t):t.e!==mt&&(o=B(h.getOriginStyle(t.e))):o=h.getStyle(t.style),b&&x(b.style,-1,n,a,o),o=m&&o?o:A,1==u&&s===z.MAX_COLUMN_COUNT&&(v.dataEffectByInflate[l.name()]||(v.dataEffectByInflate[l.name()]={}),v.dataEffectByInflate[l.name()].setColumnInfo=function(t){var n,e,i;if(!(t.col<0||t.colCount<=0))for(n=t.col,e=0,i=t.colCount;e<i;e++)st.Util.cme(l,g,n+e,c,r,o)}),e=s===z.MAX_COLUMN_COUNT,i=+t.max,s=e?I(u,d):i,f=u;f<=s;f++)st.Util.cme(l,g,f-1,c,r,o);M<i&&y.push({minCol:+t.min,maxCol:i,columnSize:c,hidden:r,colStyle:o})}),n[e]=y),(i=t.lossless&&t.lossless.colInfos)&&i.forEach(function(t,n){dt(t)||(dt(t.colTag)||(l.setTag(-1,n,t.colTag),delete t.colTag),g.X_(n,t))})}function jt(t,n){var n,e,i,n=C(n,w);n&&(e=t.spanModels[3],(i=n.c_).forEach(function(t){var t=S(t.ref);e.find(t.row,t.col)||e.add(t)}))}function Et(t,o,a){var n,u;if(0<t.length)return n={n_:E},u=[],t.forEach(function(t){var n,e,e,e,i,r,r,i,r,n={n_:ct.XFileConstants.ku,lossless:{}},e=o[t.row+","+t.col],e=vt(e||(0,at.Ec)(t.row,t.col,1,1));n.ref=e,(i=(e=t.hyperlink).url)&&(i.substring(0,(r="sjs://").length)===r?n.location=s(i.replace(r,"")):(r=ct.XFileConstants.Rr+st.Util.wr(a),a.c_.push({n_:ct.XFileConstants.Lr,Id:r,Target:s(i),Type:ct.RelationshipConstants.pc,TargetMode:ct.XFileConstants.Cu}),n[h]=r),"string"==typeof(i=t.value))&&(n.display=s(i)),e.tooltip&&(n.tooltip=s(e.tooltip)),r=n.lossless,dt(e.visitedLinkColor)||(r.visitedLinkColor=e.visitedLinkColor),dt(e.drawUnderline)||(r.drawUnderline=e.drawUnderline),dt(e.command)||(r.command=e.command),dt(e.target)||(r.target=e.target),dt(e.linkColor)||(r.linkColor=e.linkColor),u.push(n)}),n.c_=u,n}function Ot(s,t){var n,n,c,f,n=C(t,E);n&&(n=n.c_)&&(c=s.Ut.sheetModels[3].dataTable,f=t.rels&&t.rels.c_||[],n.forEach(function(t){var n,e,n,i,r,r,o,a,o,u,u,n=t.ref.split(":"),e=v(n[0]),n=d(n[0]),i=l(t.tooltip);t[h]&&(r=m(f,t[h]),r=l(r&&r.Target)),(o=l(t.location))&&(r=r?r+"#"+o:"sjs://"+(o="#"===o[0]?o.substr(1):o)),o="hyperlink",o="string"==typeof(a=c[e]&&c[e][n]&&c[e][n].style)?(u=s.u8(a))&&u.foreColor:a&&a.foreColor,u=t.lossless||{},s.setHyperlink(e,n,{url:r,tooltip:i,linkColor:u.linkColor||o,visitedLinkColor:u.visitedLinkColor||"followedHyperlink",drawUnderline:!!dt(u.drawUnderline)||u.drawUnderline,command:u.command,target:u.target||0},3)}))}function Rt(t,n,e,i,r,o,a){t.ome(i,o,!0),t.ame(r,a,!0)}function Lt(t,n){var n=n.lossless;n&&(nt(t,t.frozenTrailingRowCount,n.frozenTrailingRowCount),nt(t,t.frozenTrailingColumnCount,n.frozenTrailingColCount),t.Ny=!K(n.frozenTrailingRowStickToEdge)||n.frozenTrailingRowStickToEdge,t.Vy=!K(n.frozenTrailingColumnStickToEdge)||n.frozenTrailingColumnStickToEdge,dt(n.frozenlineColor)||(t.options.frozenlineColor=n.frozenlineColor))}function Bt(t,n,e){var i=e&&e.frozenColumnsAsRowHeaders,e=e&&e.frozenRowsAsColumnHeaders,r=t.frozenRowCount(),o=t.frozenColumnCount();0<r&&e&&it(t,mt,r,o,!0),0<o&&i&&rt(t,mt,o,r,!0)}function Ft(t,n){var e,i,r,o,a,u,e=t.options,i=C(n,"sheetProtection"),r=e.protectionOptions;if(i)for(o in i.algorithmName&&i.hashValue&&i.saltValue&&i.spinCount&&(t.oue={algorithmName:i.algorithmName,hashValue:i.hashValue,saltValue:i.saltValue,spinCount:+i.spinCount}),delete i.algorithmName,delete i.hashValue,delete i.saltValue,delete i.spinCount,i)if(i.hasOwnProperty(o))switch(u="0"===(a=i[o]),o){case ct.XFileConstants.ru:e.isProtected="1"===a;break;case"selectLockedCells":r.allowSelectLockedCells=u;break;case"selectUnlockedCells":r.allowSelectUnlockedCells=u;break;case"autoFilter":r.allowFilter=u;break;case"sort":r.allowSort=u;break;case"insertColumns":r.allowInsertColumns=u;break;case"insertRows":r.allowInsertRows=u;break;case"deleteColumns":r.allowDeleteColumns=u;break;case"deleteRows":r.allowDeleteRows=u;break;case"objects":r.allowEditObjects=u;break;default:"1"===i[o]||"0"===i[o]?r[o]="0"===i[o]:"n_"!==o&&"c_"!==o&&(r[o]=i[o])}e.isProtected&&!0!==r.allowEditObjects&&i.objects===mt&&(r.allowEditObjects=!0)}function Pt(n,e){var i={sheetAreaOffset:function(t){dt(t.left)||(n.sheetAreaOffset.left=t.left),dt(t.top)||(n.sheetAreaOffset.top=t.top)}};e&&e.sheetOptions&&Object.keys(e.sheetOptions).forEach(function(t){dt(e.sheetOptions[t])||(i[t]&&"function"==typeof i[t]?i[t](e.sheetOptions[t]):n[t]=e.sheetOptions[t])})}function Gt(t,n){var e={rowHeaderAutoText:t.rowHeaderAutoText,colHeaderAutoText:t.colHeaderAutoText,rowHeaderAutoTextIndex:t.rowHeaderAutoTextIndex,colHeaderAutoTextIndex:t.colHeaderAutoTextIndex,allowCellOverflow:t.allowCellOverflow,clipBoardOptions:t.clipBoardOptions,selectionBackColor:t.selectionBackColor,selectionBorderColor:t.selectionBorderColor,sheetAreaOffset:{left:t.sheetAreaOffset.left,top:t.sheetAreaOffset.top}};return n&&(e.rowHeaderVisible=t.rowHeaderVisible,e.colHeaderVisible=t.colHeaderVisible),e}function Ut(t,n){var e,n,i,e=n&&n.frozenColumnsAsRowHeaders,n=n&&n.frozenRowsAsColumnHeaders;(e||n)&&(i=t.Ut,n&&K(i.ap)&&(t.cp=!0,t.deleteRows(0,i.ap)),e)&&K(i.fp)&&t.deleteColumns(0,i.fp)}function Ht(t,n,e,i,r,o){var a,u,s,c,f,l;if(t){if(e.col=Math.max(t.getActiveColumnIndex(),0),e.row=Math.max(t.getActiveRowIndex(),0),a=0<r,u=0<o,0===i){if(!a||!u)return}else if(1===i){if(!u)return;a&&(e.col=o,e.row=0)}else if(2===i){if(!a)return;u&&(e.col=0,e.row=r)}if(e.col=Math.min(ct.XmlConstants.xo,e.col),e.row=Math.min(ct.XmlConstants.Io,e.row),n)if(s=void 0,c=t.getSelections())for(f=0;f<c.length;f++)"object"==typeof(l=c[f])&&(s=new at.Range(0<l.row?l.row:0,0<l.col?l.col:0,0<l.rowCount?l.rowCount:ct.XmlConstants.Io,0<l.colCount?l.colCount:ct.XmlConstants.xo),n.push(s));else n.push(new at.Range(e.row,e.col,1,1));return 1}}function Vt(t,n,e){var i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,p,g,b,w,i=t.getSelections();if(i&&0!==i.length)for(r=e?t.frozenRowCount():0,o=e?t.frozenColumnCount():0,a=[],u=new at.Range(0,0,1,1),s=0,f=-(c=1),l=3;0<=l;l--)if(a.length=0,Ht(t,a,u,l,r,o)){for(c=a.length,s=0;s<c;s++)-1!==(h=-1!==(h=a[s]).col&&-1!==h.colCount?h:new at.Range(h.row,0,h.rowCount,ct.XmlConstants.xo)).row&&-1!==h.rowCount||(h=new at.Range(0,h.col,ct.XmlConstants.Io,h.colCount)),u.col>=h.col&&u.col<=h.col+h.colCount-1&&u.row>=h.row&&u.row<=h.row+h.rowCount-1&&(f=s);if(f<0&&0<c&&(u.row=a[0].row,u.col=a[0].col),d=""+y(u.col)+(u.row+1),v="",0<o&&0<r&&(1===l||2===l))v=d;else{for(s=0;s<c;s++)m=a[s],g=Math.min(ct.XmlConstants.Io,m.row+1),p=Math.min(m.col,ct.XmlConstants.xo),v+=""+y(p)+g,(1<m.colCount||1<m.rowCount)&&(p=Math.min(p+m.colCount-1,ct.XmlConstants.xo),g=Math.min(g+m.rowCount-1,ct.XmlConstants.Io),v+=":"+(b=""+y(p)+g)),v+=" ";v=v.trim()}st.StringEx.Xi(v)||3===l&&(0<o||0<r||3!==l)||(w={n_:"selection"},3!==l&&(w.pane=gt[l]),w.activeCell=d,0!==f&&0===l&&(w.activeCellId=f.toString()),w.sqref=v,n.c_.push(w))}}function zt(t,n,e,i){var n,i,n=(n&&n.theme?n:i).theme,i=new W.Theme(void 0);e&&n?n&&i.yh(n):i.yh("Office"),t.currentTheme(i)}function Yt(t,n){t&&(t[n]=2)}function Zt(t,n){var e,i,r,o,a,u,u,e=t.options.protectionOptions,i,r={n_:"sheetProtection"};for(a in t.options.isProtected&&(r.sheet="1"),o=function(t){return t?"0":"1"},e)e.hasOwnProperty(a)&&(u=e[a],["allowSelectLockedCells","allowSelectUnlockedCells","allowEditObjects"].includes(a)&&u||(u=st.protectionOptionsMap[a]||a,(n||st.excelSupportProtectionOptions[u])&&(r[u]=o(e[a]))));if(t.oue&&(at.util.w1(r,t.oue),r.spinCount=!dt(r.spinCount)&&""+r.spinCount),1<Object.keys(r).length)return r}function Wt(t,n){var t,e,e=function(t){var t=t.range();return n.intersect(t.row,t.col,t.rowCount,t.colCount)};return null==(t=t.tables)?void 0:t.all().some(e)}function Qt(t,n,e){for(var i,r,o,a,u,s,c,i=[],r=t.getSpans(),o={},a=0;a<r.length;a++)u=r[a],s=!n&&Wt(t,u),u&&!s&&(i.push({n_:ct.XFileConstants.xu,ref:vt(u)}),o[u.row+","+u.col]=u);return{spanRowColInfos:o,sjsMergeCells:c=e&&0<i.length?{n_:w,c_:i}:c}}Object.defineProperty(t,"__esModule",{value:!0}),t=n("Common"),z=n("./dist/core/worksheet/worksheet.js"),Y=n("./dist/core/worksheet/style.js"),Z=Y.Style.xp,at=n("./dist/core/util/common.js"),W=n("./dist/core/util/theme.js"),e=n("./dist/core/util/domUtil.js"),M=n("./dist/core/worksheet/stylehelper.js"),ut=n("./dist/core/core.enum.js"),o=n("CalcEngine"),st=n("./dist/core/excel-io-util/common.js"),i=n("./dist/core/excel-io-util/range-parser.js"),ct=n("./dist/core/excel-io-util/excel-types.js"),p=n("./dist/core/worksheet/worksheet-model.js"),n=n("./dist/core/core.ns.js"),ft=void 0,n=new t.Common.ResourceManager(n.SR,"Sheets"),a=n.getResource.bind(n),x=at.UsedRangeUtil.updateUsedRangeByData,pt=16384,c=1048576,Q=!!o,J=t.Common.CultureManager,lt=z.Worksheet.fh,K=at.util.T1,ht=e.GC$.each,N=e.GC$.isEmptyObject,X=t.Common.kh,dt=t.Common.lt.ht,bt=st.IndexHelper.nr,d=st.IndexHelper.$i,v=st.IndexHelper.qi,l=at.util.n1,m=st.Util.Sr,wt=at.util.Pr,C=at.util.xr,k=at.util.o1,_=at.util.go,s=at.util.vo,f=at.util.d1,yt=at.util.h1,S=i.range_parser._c,D=i.range_parser.Dc,vt=i.range_parser.jc,g=i.range_parser.Oc,b=t.Common.zf,y=st.Util.No,j=st.Util.ko,T=st.NodeHelper.ur,h=ct.XFileConstants.Ki,Mt=ct.XFileConstants.Su,Ct=ct.XFileConstants.Tu,St=ct.XFileConstants.Au,w=ct.XFileConstants.Iu,E=ct.XFileConstants.Nu,Tt=ct.XFileConstants.Du,At=ct.XFileConstants._u,It=ct.XFileConstants.Eu,O=ct.XFileConstants.bo,et="string",q=parseInt,$=isNaN,mt=void 0,A=null,R="1",L="0",B=t.Common.lt.tv,(n=gt=gt||{})[n.bottomRight=0]="bottomRight",n[n.topRight=1]="topRight",n[n.bottomLeft=2]="bottomLeft",n[n.topLeft=3]="topLeft",e.GC$.extend(z.Worksheet.prototype,{s8:function(t,n,e,i,r,o){var t,n;t[n]||(t[n]={}),(t=t[n])[e]||(t[e]={}),n=t[e],r&&!dt(n.value)||(n.value=i),dt(o)||(n.style=o)},c8:function(t,n,e,i,r,o){var t,a,u,s,c,f,c,t=C(t,O),a=t[n],u=(u=(a=a||(t[n]={}))[e])||(a[e]={});switch(s=typeof i){case"boolean":u.b=i?1:0;break;case"string":f=(c=(0,p.getOADateNumber)(i,r)).OADateNumber,c=c.valueIndex,u.o=f,u.v=c;break;case"object":i&&i.richText?u.v=r.getTextIndex(i):u.v=i;break;default:u.n=i}dt(o)||(u.s=o)},Op:function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,g,e=this,i=e.Ut,r=i.W_(),o=i.W_(ut.SheetArea.colHeader),a=i.Q_(!0),u=i.Q_(!0,ut.SheetArea.colHeader),s=i.K_(),c=i.K_(ut.SheetArea.colHeader),f=e.rowFilter(),l=r.getColumnCount(),h=0;h<t;h++)for(r.setNode(h,-1,o.J_(h,-1)),d=u.q_(h),e.NMi&&(v=e.defaults.colHeaderRowHeight)!==p.DEFAULT_COL_HEADER_ROW_HEIGHT&&(d?dt(d.size)&&(d.size=v):d={size:v}),a.X_(h,d),m=n;m<l;m++)(g=(g=o.J_(h,m))||{}).style=e.getActualStyle(h,m,ut.SheetArea.colHeader),r.setNode(h,m,g),(g=e.getFormula(h,m,ut.SheetArea.colHeader))&&e.setFormula(h,m,g,ut.SheetArea.viewport);c.getSpans().forEach(function(t){s.add(t)}),f&&f.range&&-1===f.range.row&&(f.f8=!0),e.frozenRowCount(t),i.l8(z.Worksheet.o8,l,ut.SheetArea.colHeader),i.h8(!1,ut.SheetArea.colHeader),i.d8(ut.SheetArea.colHeader),e.b3(ut.SheetArea.colHeader).clearAll()},jp:function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,d,d,e=this,i=e.Ut,r=i.W_(),o=i.W_(ut.SheetArea.rowHeader),a=i.Q_(!1),u=i.Q_(!1,ut.SheetArea.rowHeader),s=i.K_(),c=i.K_(ut.SheetArea.rowHeader),f=r.getRowCount(),l=0;l<t;l++)for(r.setNode(-1,l,o.J_(-1,l)),a.X_(l,u.q_(l)),h=n;h<f;h++)(d=(d=o.J_(h,l))||{}).style=e.getActualStyle(h,l,ut.SheetArea.rowHeader),r.setNode(h,l,d),(d=e.getFormula(h,l,ut.SheetArea.rowHeader))&&e.setFormula(h,l,d,ut.SheetArea.viewport);c.getSpans().forEach(function(t){s.add(t)}),e.frozenColumnCount(t),i.l8(f,z.Worksheet.r8,ut.SheetArea.rowHeader),i.h8(!1,ut.SheetArea.rowHeader),i.d8(ut.SheetArea.rowHeader),e.b3(ut.SheetArea.rowHeader).clearAll()},toJSON:function(e){var a,t,n,i,r,o,r,u,u,n,r,i,s,u,c,f,l,h,d,v,m,g,p,b,w,b,a=this,t=e&&e.ignoreStyle;for(l in!e||e.kp||a.NMi||(n=a.getRowCount(ut.SheetArea.colHeader),i=a.getColumnCount(ut.SheetArea.rowHeader),r=e.rowHeadersAsFrozenColumns,u=(o=e.columnHeadersAsFrozenRows)&&0<n,(r=r&&0<i)&&a.addColumns(0,i),u&&a.ffe(0,n,3,u),r&&a.jp(i,u?n:0),u&&a.Op(n,r?i:0)),u=a.getRowCount(),n=a.getColumnCount(),r=a.getRowCount(ut.SheetArea.colHeader),i=a.getColumnCount(ut.SheetArea.rowHeader),s={name:e&&e.newWorkSheetName||a.name(),isSelected:a.b2(),rowCount:u,columnCount:n,activeRow:a.ui,activeCol:a.ci,zoomFactor:a.zoom(),rowHeaderColCount:i,colHeaderRowCount:r,visible:a.visible()},u=a.getDockScrollbarAttachedIndex(),dt(u)||(s.dockScrollbarAttachedIndex=u),t||(s.frozenRowCount=a.frozenRowCount(),s.frozenColCount=a.frozenColumnCount(),s.frozenTopRow=a.bve,s.frozenLeftCol=a.yve,s.frozenTrailingRowCount=a.frozenTrailingRowCount(),s.frozenTrailingColCount=a.frozenTrailingColumnCount(),s.frozenTrailingRowStickToEdge=a.Ny,s.frozenTrailingColumnStickToEdge=a.Vy,s.theme=a.hl.toJSON()),f=(c=a.Ut).toJSON(e))s[l]=f[l];for(d in lt&&ht(lt,function(t,n){n.toJson&&n.toJson.call(a,s,e)}),h={},s)!X(s,d)||dt(v=s[d])||P(d,v)||(h[d]=v);if(G(a,s.data.dataTable),ht(a.options,function(t,n){var e,i,r,o,e=n;"gridline"===t&&(e={},i=n.color,r=n.showHorizontalGridline,o=n.showVerticalGridline,i&&i!==at.I.fl("gc-gridlineColor").borderTopColor&&(e.color=i),!1===r&&(e.showHorizontalGridline=r),!1===o)&&(e.showVerticalGridline=o),"sheetAreaOffset"===t&&(e={},n.left&&(e.left=n.left),n.top)&&(e.top=n.top),"protectionOptions"===t&&a.oue&&at.util.w1(e,a.oue),"_ps"===t||dt(e)||z.Worksheet.Pp[t]===e||"object"==typeof e&&N(e)||(h[t]=e)}),m=[],g=a.Hp){for(p in g)X(g,p)&&(b=g[p])&&(w=b.toJSON(),b=b.font,N(w)||(b&&(w.font=M.W.b5(b)),m.push(w)));0<m.length&&(h.namedStyles=m)}return h},fromJSON:function(t,L,n,e,i){var r,o,a,n,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,B,N,F,k,P,_,G,U,D,H,j,V,E,O,R;if(n&&(r=n.noSchema,o=n.version),t){n=(a=this).Ut,u=e&&e.ignoreStyle,a.Zp(),(s=a.Uw&&a.Uw())&&!s.G3&&(c=s.G3=!0),z.Worksheet.et(a,"preFromJson"),a.suspendPaint(),n.v8(),n.m8(),f=J.culture(),J.culture(""),l=tt(t.rowCount,z.Worksheet.n8),h=tt(t.columnCount,z.Worksheet.e8);try{if(a.ub(t.name+"",!0),a.b2(t.isSelected),a.setRowCount(l),a.setColumnCount(h),a.Hp={},d=t.namedStyles)for(v=0;v<d.length;v++)m=d[v],g=new Y.Style,Z(m,a),g.fromJSON(m,r,a),a.$p(g);for(b in p=a.options)if(X(p,b)&&(w=t[b],"protectionOptions"===b?(w=w||t.protectionOption)&&(w.algorithmName&&w.hashValue&&w.saltValue&&w.spinCount&&(a.oue={algorithmName:w.algorithmName,hashValue:w.hashValue,saltValue:w.saltValue,spinCount:w.spinCount}),delete w.algorithmName,delete w.hashValue,delete w.saltValue,delete w.spinCount):"allowCellOverflow"===b&&(w=K(t[b])?t[b]:!o||11<=o),K(w)))if("object"==typeof w)for(y in w)X(w,y)&&(p[b][y]=w[y]);else"borderWidth"===b?(p.sheetAreaOffset.left=w,p.sheetAreaOffset.top=w):p[b]=w;if(M=tt(t.activeRow,a.ui),C=tt(t.activeCol,a.ci),a.O6(M,C,mt,mt,!0),u||(nt(a,a.frozenRowCount,t.frozenRowCount,t.frozenTopRow||0),nt(a,a.frozenColumnCount,t.frozenColCount,t.frozenLeftCol||0),nt(a,a.frozenTrailingRowCount,t.frozenTrailingRowCount),nt(a,a.frozenTrailingColumnCount,t.frozenTrailingColCount),a.Ny=!K(t.frozenTrailingRowStickToEdge)||t.frozenTrailingRowStickToEdge,a.Vy=!K(t.frozenTrailingColumnStickToEdge)||t.frozenTrailingColumnStickToEdge),!u){if(S=t.colStyles)for(T in S)$(T)||a.setStyle(-1,q(T,10),S[T],ut.SheetArea.viewport);if(A=t.rowStyles)for(I in A)$(I)||a.setStyle(q(I,10),-1,A[I],ut.SheetArea.viewport)}x=tt(t.rowHeaderColCount,z.Worksheet.r8),B=tt(t.colHeaderRowCount,z.Worksheet.o8),a.setColumnCount(x,ut.SheetArea.rowHeader),a.setRowCount(B,ut.SheetArea.colHeader),a.g8(tt(t._zoomFactor||t.zoomFactor,a.zoom())),!1===t.visible?t.visible=ut.SheetTabVisible.hidden:!0===t.visible&&(t.visible=ut.SheetTabVisible.visible),nt(a,a.visible,t.visible),N=a.b8,F={sheet:a,setValidator:function(t,n,e){N&&N.y8(t,n,e)},ignoreStyle:u},t.isApplyRefilter||a.w8(t),n.fromJSON(t,r,F,a.Lp&&a.Lp.allowDynamicArray),a.defaults=n.defaults,N&&N.C8(!0),k=t.dockScrollbarAttachedIndex,dt(k)||a.setDockScrollbarAttachedIndex(k),(P=t.theme)&&!u&&(typeof(_=P)!=et&&K(_)&&(G="_themeColor",U="_name",D=_.themeColor||_[G],(H=new W.ColorScheme(D.name||D[U])).fromJSON(D,r),_=new W.Theme(_.name||_.Zc,H,_.headingFont||_.Aee,_.bodyFont||_.See)),a.currentTheme(_)),ot(a,t,r,e,L,i),j=e&&e.frozenColumnsAsRowHeaders&&!a.NMi,E=(V=e&&e.frozenRowsAsColumnHeaders&&!a.NMi)&&t.frozenRowCount||0,O=j&&t.frozenColCount||0,V&&0<E&&it(a,t,E,O),j&&0<O&&rt(a,t,O,E),Q&&(R=a.Uw(),0<E&&(R.S8=E),0<O)&&(R.T8=O),i||(0<E&&a.deleteRows(0,E),0<O&&a.deleteColumns(0,O)),a.clearPendingChanges()}finally{c&&delete s.G3,J.culture(f),n.A8(),a.resumePaint()}}},Yp:function(a,u,t,s,c){var f,n,l,h,d,v,e,i,r,o,m,g,p,b,t,w,y,M,C,S,t,w,T,t;if(t&&(f=t.noSchema,n=t.version),a){if(h=(l=this).Ut,d=s.ignoreStyle,l.Zp(),z.Worksheet.et(l,"preFromJson"),h.v8(),h.m8(),v=J.culture(),J.culture(""),l.Hp={},e=a.namedStyles)for(i=0;i<e.length;i++)r=e[i],o=new Y.Style,Z(r,l),o.fromJSON(r,f,l),l.$p(o);for(g in m=l.options)if(X(m,g)&&(p=a[g],"protectionOptions"===g?p=p||a.protectionOption:"allowCellOverflow"===g&&(p=K(a[g])?a[g]:!n||11<=n),K(p)))if("object"==typeof p)for(b in p)X(p,b)&&(m[g][b]=p[b]);else"borderWidth"===g?(m.sheetAreaOffset.left=p,m.sheetAreaOffset.top=p):m[g]=p;if(t=tt(a.activeRow,l.ui),w=tt(a.activeCol,l.ci),l.O6(t,w,mt,mt,!0),d||(nt(l,l.frozenRowCount,a.frozenRowCount),nt(l,l.frozenColumnCount,a.frozenColCount),nt(l,l.frozenTrailingRowCount,a.frozenTrailingRowCount),nt(l,l.frozenTrailingColumnCount,a.frozenTrailingColCount),l.Ny=!K(a.frozenTrailingRowStickToEdge)||a.frozenTrailingRowStickToEdge,l.Vy=!K(a.frozenTrailingColumnStickToEdge)||a.frozenTrailingColumnStickToEdge),!d){if(y=a.colStyles)for(M in y)$(M)||l.setStyle(-1,q(M,10),y[M],ut.SheetArea.viewport);if(C=a.rowStyles)for(S in C)$(S)||l.setStyle(q(S,10),-1,C[S],ut.SheetArea.viewport)}t=tt(a.rowHeaderColCount,z.Worksheet.r8),w=tt(a.colHeaderRowCount,z.Worksheet.o8),l.setColumnCount(t,ut.SheetArea.rowHeader),l.setRowCount(w,ut.SheetArea.colHeader),l.g8(tt(a._zoomFactor||a.zoomFactor,l.zoom())),T=l.b8,t={sheet:l,setValidator:function(t,n,e){T&&T.y8(t,n,e)},ignoreStyle:d,incrementalLoading:s.incrementalLoading,incrementLoadTask:s.incrementLoadTask},a.isApplyRefilter||l.w8(a),h.fromJSON(a,f,t,l.Lp&&l.Lp.allowDynamicArray,function(){var t,t,n,e,i,r,i,r,t,o,r;l.defaults=h.defaults,T&&T.C8(!0),(t=a.theme)&&!d&&(typeof(t=t)!=et&&K(t)&&(i=t.themeColor||t[n="_themeColor"],(r=new W.ColorScheme(i.name||i[e="_name"])).fromJSON(i,f),t=new W.Theme(t.name||t.Zc,r,t.headingFont||t.Aee,t.bodyFont||t.See)),l.currentTheme(t)),ot(l,a,f,s,u,c),i=s&&s.frozenColumnsAsRowHeaders&&!l.NMi,t=(r=s&&s.frozenRowsAsColumnHeaders&&!l.NMi)&&a.frozenRowCount||0,o=i&&a.frozenColCount||0,r&&0<t&&it(l,a,t,o),i&&0<o&&rt(l,a,o,t),Q&&(r=l.Uw(),0<t&&(r.S8=t),0<o)&&(r.T8=o),c||(0<t&&l.deleteRows(0,t),0<o&&l.deleteColumns(0,o)),l.clearPendingChanges(),J.culture(v),h.A8(),l.loaded=!0})}},wh:function(L,B,e){var i,t,n,r,F,o,a,u,s,c,u,c,s,c,u,f,l,h,d,v,m,g,p,s,s,g,u,b,w,y,v,M,m,l,d,C,f,h,g,u,y,w,b,v,m,P,S,G,d,T,U,H,h,g,u,y,w,A,b,I,S,o,a,p,c,V,z,v,m,x,Y,Z,N,k,k,_,W,D,Q,J,K,X,q,$,P,T,t,G,d,tt,g,u,y,w,nt,et,j,it,E,rt,O,ot,R,i=this,t=i.options,n=st.Util.ko(e),r=!e||!1!==e.includeStyles;for(t.sheetTabColor&&(F={n_:Mt,c_:[yt(t.sheetTabColor,mt,"tabColor")]}),o=i.getRowCount(ut.SheetArea.colHeader)||1,a=i.getColumnCount(ut.SheetArea.rowHeader)||1,u=i.NMi&&(e&&e.fileType)===ut.OpenSaveFileType.excel,s=e&&e.rowHeadersAsFrozenColumns,c=e&&e.columnHeadersAsFrozenRows,(s||c||u)&&(c=(c||u)&&0<o,(u=s&&0<a)&&i.addColumns(0,a),c&&i.ffe(0,o,3,c),u&&i.jp(a,c?o:0),c)&&i.Op(o,u?a:0),s=t.gridline,c=t.frozenlineColor,u=i.zoom(),f=i.frozenRowCount(),l=i.frozenColumnCount(),h=i.bve||0,d=i.yve||0,v=i.getViewportLeftColumn(1),m=i.getViewportTopRow(1),i.NMi?g="A1":h||d?g=vt((0,at.Ec)(h,d,1,1)):v!==mt&&m!==mt&&(f||l?l&&!f?g="A"+(m+1):!l&&f&&(g=vt((0,at.Ec)(0,v,1,1))):g=vt((0,at.Ec)(m,v,1,1))),s=(s=(p=s?{color:s.color,showVerticalGridline:s.showVerticalGridline,showHorizontalGridline:s.showHorizontalGridline}:p)&&p.color&&p.color!==at.I.fl("gc-gridlineColor").borderTopColor?p&&p.color:mt)&&at.ColorHelper.getClosestColorIndex(at.ColorHelper.convertHexColorToArgb(s)),s={n_:"sheetView",showGridLines:!p||!1!==p.showVerticalGridline&&!1!==p.showHorizontalGridline?mt:"0",showRowColHeaders:!1===t.rowHeaderVisible&&!1===t.colHeaderVisible?"0":mt,defaultGridColor:s?0:mt,colorId:s,showFormulas:t.showFormulas?"1":mt,showZeros:t.showZeros?mt:"0",topLeftCell:g||mt,zoomScale:1===u?mt:Math.round(100*u),workbookViewId:0,tabSelected:i.b2()?"1":mt,c_:[]},u=g=0,b=3,w="1",y="A",r&&(0<l||0<f)&&(0<l&&(g=l,y=bt(v)),0<f&&(u=f,w=m+1+""),0<l&&0===f?b=1:0===l&&0<f?b=2:0<l&&0<f&&(b=0),v={n_:"pane",xSplit:0<l?l-d:mt,ySplit:0<f?f-h:mt,topLeftCell:y+w==="A1"?vt((0,at.Ec)(g,u,1,1)):y+w,activePane:gt[b],state:"frozen"},s.c_.push(v)),Vt(i,s,r),M=B.styleManager,m=B.sharedStrings,C=(d=(l=i.Ut).wh(M,m,e)).sheetData,f=d.hyperlinks,h=d.rowHeaderData,g=d.colHeaderData,u=d.rowHeaderColInfos,y=d.colHeaderRowInfos,w=d.rowHeaderSpan,b=d.colHeaderSpan,v=d.defaults,m=d.selectionPolicy,P=d.selectionUnit,S=d.rowInfos,G=d.defaultData,d=d.tag,T=!i.NMi&&i.getDefaultStyle(),h={rowHeaderData:h,colHeaderData:g,rowHeaderColInfos:u,colHeaderRowInfos:y,rowHeaderSpan:w,colHeaderSpan:b,rowInfos:S,colHeaderRowCount:o,rowHeaderColCount:a,gridline:p,frozenlineColor:c,defaults:v,selectionPolicy:m,selectionUnit:P,defaultStyle:U=r&&T&&T.toJSON(),sheetOptions:H=Gt(t,n),defaultData:G,tag:d},r&&(w=y=u=g=void 0,g=i.frozenTrailingRowCount(),u=i.frozenTrailingColumnCount(),y=i.Ny,w=i.Vy,0!==g&&(h.frozenTrailingRowCount=g),0!==u&&(h.frozenTrailingColCount=u),!0!==y&&(h.frozenTrailingRowStickToEdge=y),!0!==w)&&(h.frozenTrailingColumnStickToEdge=w),r&&(h.theme=i.hl.wh(n)),A=l.Q_(!1,3).wh(e),I=(b=l.defaults).colWidth,S=b.rowHeight,o={n_:At,defaultRowHeight:at.SJSColumnWidthHelper.pixelToPoint(S),defaultColWidth:at.SJSColumnWidthHelper.pixelToColumnWidth(I),customHeight:2<=Math.abs(76-S)?"1":mt},a=e&&!1===e.includeEmptyRegionCells,c=p=0,V=i.getRowCount(),z=i.getColumnCount(),a&&(v=ut.UsedRangeType.all-ut.UsedRangeType.colStyle-ut.UsedRangeType.rowStyle-ut.UsedRangeType.style-ut.UsedRangeType.axis,m=i.getUsedRange(v))&&(p=m.row,c=m.col,V=m.row+m.rowCount,z=m.col+m.colCount),x=[],Y=h.colInfos=[],Z=l.W_(3),N=c;N<z;N++)k=(k=Z.J_(-1,N))&&k.style,_=A[N],W=i.getTag(-1,N),!_&&!k&&dt(W)||(D=_&&_.size,Q=_&&_.visible,X=K=J=void 0,r&&k&&(n?"string"==typeof k?J=M.getOriginNamedStyleIndex(k):k!==mt&&(K=M.getOriginStyleIndex(k)):("string"==typeof k&&0===k.indexOf(M.Jd)&&(q=k,k=(k=i.i3(q,!1))||($=i.parent)&&$.i3(q,!1)),X=M.getStyleIndex(k))),(!dt(D)&&D!==I||!1===Q||k||J!==mt||K!==mt)&&(x[N]={width:dt(D)?at.SJSColumnWidthHelper.pixelToColumnWidth(I):at.SJSColumnWidthHelper.pixelToColumnWidth(D),hidden:!1===Q?"1":mt,customWidth:dt(D)||D===I?mt:1,style:X,t:J,e:K}),dt(W)||(A[N]=A[N]||{},A[N].colTag=W),Y[N]=A[N]);for(T=(P=Qt(i,n,r)).spanRowColInfos,t=P.sjsMergeCells,d=Et(f,T,G={n_:ct.XFileConstants.Dr,xmlns:ct.RelationshipConstants._r,c_:[]}),N=p;N<V;N++)tt=i.getTag(N,-1),!C[N]&&dt(tt)&&!1!==i.getRowVisible(N)||(C[N]||(C[N]={r:N+1}),!1===i.getRowVisible(N)&&(C[N].v="1"),dt(tt))||(C[N].lossless={tag:tt});for(g=Zt(i,n),u=i.getRowCount()||1,y=i.getColumnCount()||1,w={n_:Ct,ref:vt((0,at.Ec)(0,0,u,y))},j={n_:"worksheet",c_:[F,w,nt={n_:Tt,c_:[s]},o,C,g,t,d,et={n_:St,c_:[]}],rels:G,tempCols:x,lossless:h},lt&&ht(lt,function(t,n){n.wh&&n.wh.call(i,j,B,e)}),it=[],N=0;N<x.length;N++)if(E=x[N]){if(pt<=(rt=N))break;for(O=N+1,ot=rt;O<x.length&&(R=x[O])&&O===ot+1&&O<pt&&R.style===E.style&&R.hidden===E.hidden&&R.outlineLevel===E.outlineLevel&&R.collapsed===E.collapsed&&Math.abs(R.width-E.width)<=1e-4&&R.t===E.t&&R.e===E.e;)N=ot=O,O++;_={n_:"col",min:rt+1+"",max:ot+1+""},E.style!==ft&&(_.style=E.style+""),E.t!==ft&&(_.t=E.t+""),E.e!==ft&&(_.e=E.e+""),isNaN(E.width)||E.width===ft||(_.width=E.width+""),_.hidden=E.hidden,E.collapsed&&(_.collapsed="1"),!isNaN(E.width)&&1e-4<Math.abs(E.width-i.defaults.colWidth)&&(_.customWidth="1"),"number"==typeof E.outlineLevel&&0!==E.outlineLevel&&(_.outlineLevel=E.outlineLevel+""),it.push(_)}return 0<it.length&&j.c_.push({n_:It,c_:it}),delete j.tempCols,wt(j,ct.WorkSheetNodeOrder),j},rv:function(e,i,r,o){var a,t,n,u,s,c,s,f,c,l,h,l,d,v,m,c,a=this,t=a.options,n=C(e,O),u=e.lossless;U(t,e),c=(s=Nt(e)).rowCount,s=s.colCount,n&&(r.fileType===ut.OpenSaveFileType.excel?(dt(n.rowCount)||(c=Math.max(n.rowCount,c||0)),dt(n.colCount)||(s=Math.max(n.colCount,s||0))):(dt(n.rowCount)||(c=n.rowCount),dt(n.colCount)||(s=n.colCount))),a.setRowCount(c),a.setColumnCount(s),c=(f=a.parent)&&f.getSheetIndex(a.name()),(l=i.sheetNamedStyles)[c]&&l[c].forEach(function(t){delete t.sheetId,a.addNamedStyle(t)}),kt(h=a.Ut,e),l=_t(a,e,r,i),d=l.showCellRow,v=l.showCellCol,m=!r||!1!==r.includeStyles,zt(a,u,m,i),c=i.styleManager,Dt(a,e,c,s,r,i),Pt(t,u),h.yh(n,i,r,u,function(){m&&jt(h,e),Ot(a,e),Ft(a,e),lt&&ht(lt,function(t,n){n.yh&&n.yh.call(a,e,i,r,o)}),st.Util.ume(a,i);var t=f&&f.v2,t=t&&t.sheetsState;o?(a.Xh=!0,Yt(t,a.name()),H(a,e,r),xt(a,d,v)):r.incrementLoadTask.addTask(function(t,n,e,i){t.Xh=!0,Yt(i,t.name()),H(t,n,e),xt(a,d,v)},[a,e,r,t])},o,a.Lp&&a.Lp.allowDynamicArray)},yh:function(t,n,e,i){var r,o,i,r=this;i?r.rv(t,n,e,i):((e=e||{}).progress||(e.progress=function(t){}),e.loadStatus||(e.loadStatus={total:0,valuesLoad:0,formulaLoad:0}),o=st.Util.wo(e,r.parent&&r.parent.v2),i=e.incrementLoadTask&&e.incrementLoadTask.tasks&&0===e.incrementLoadTask.tasks.length,e.incrementLoadTask.addTask(function(t,n,e){r.rv(t,n,e)},[t,n,e],b.I5(a().STEP.loadSheetData,[r.name()]),function(){var t=e.loadStatus.valuesLoad/e.loadStatus.total;return o?.2:e.fullRecalc?t*st.STEP_RATE.loadSheetDataWithCalc+ +st.STEP_RATE.parseFile+st.STEP_RATE.loadFileData:t*st.STEP_RATE.loadSheetData+st.STEP_RATE.parseFile+st.STEP_RATE.loadFileData},r.name()),i&&e.incrementLoadTask.start())}})},"./dist/core/worksheet/worksheet-model.js":function(u,m,h){"use strict";var c,l,k,_,tt,S,D,B,j,nt,t,et,E,F,st,R,O,it,P,G,rt,ot,U,T,H,g,I,V,z,p,b,Y,s,d,at,Z,W,Q,ct,J,ut,K,X,q,$,v,ft,L,w,y,lt,t,ht,dt,_,vt,mt,gt,pt,bt,wt,yt,f,Mt,Ct,St,Tt,At,It,xt,Nt,kt,_t,Dt;function M(t,n){return at(t)?n:t}function N(t,n){return t.hasOwnProperty(n)}function jt(t){return"number"==typeof t}function C(t){return t.rowCount}function A(t){return t.colCount}function Et(t,e,n,i){var r=n;Object.defineProperty(t,e,{get:function(){return r},set:function(t){var n=r;i(this,r=t,e,n)}})}function Ot(n,t){n.cache={},t&&t.forEach(function(t){Rt(n,t)})}function Rt(t,n){var e,i;if(t.I8=g(t.I8,n.row+C(n)-1),t.x8=g(t.x8,n.col+A(n)-1),!t.suspendUpdatingCache)for(e=0;e<n.rowCount;e++)for(i=0;i<n.colCount;i++)t.cache[n.row+e+"_"+(n.col+i)]=n}function Lt(t,n){var e,i;if(!t.suspendUpdatingCache)for(e=0;e<n.rowCount;e++)for(i=0;i<n.colCount;i++)t.cache[n.row+e+"_"+(n.col+i)]=ot}function Bt(t,n){var e,i,e,e=t.indexOf("/OADate(")+1,i=t.indexOf(")");return 0!==e&&e<i&&(e=parseFloat(t.substring(e+7,i)),!isNaN(e))?{OADateNumber:e,valueIndex:ot}:{OADateNumber:ot,valueIndex:n.getTextIndex(t)}}function n(){Et(this,"spans",[],Ot),this.x8=-1,this.I8=-1,this.cache={},this.suspendUpdatingCache=!1}function Ft(){Array.apply(this,arguments)}function Pt(){var t=_t.call(this)||this;return t.headingOverflowLayouts=rt,t.trailingOverflowLayouts=rt,t}function Gt(t,n,e,i,r,o,a,u,s){var c=this;c.column=t,c.startColumn=n,c.endColumn=e,c.valueWidth=i,c.columnWidth=r,c.backgroundWidth=o,c.backgroundLeftWidth=a,c.backgroundRightWidth=u,c.expandedWidth=s}function Ut(t,n,e){var i,r,o,a,u,i=(0,nt.Ec)(-1,-1,-1,-1);return t&&(r=t.col,o=t.row,u=-1===r,i.row=(a=-1===o)?0:o,i.rowCount=a?n:C(t),i.col=u?0:r,i.colCount=u?e:A(t)),i}function e(){this.selections=[],this.selectionPolicy=2,this.selectionUnit=0}function Ht(t,n,e,i,r,o){for(var a,u,s,c,f,a=t.length,s=!1,c=[],f=0;f<a;f++)if(u=t[f],s=at(n)||at(e)?at(n)?at(e)?at(i)?u.containsY(r):u.containsX(i):u.col===e:u.row===n:u.contains(n,e)){if(!o)return u;c.push(u)}return o&&0<c.length?c:rt}function Vt(t,n,e){var i=rt,r=t.length,o=!at(n);return i=0<r?(i=o?t.findX(n):t.findY(e))||(o&&n<t[0].x||!o&&e<t[0].y?t[0]:t[r-1]):i}function i(){return Dt.call(this)||this}function zt(t,n,e,i,r,o,a,u,s,c){var f=this;f.rowCount=a,f.colCount=u,f.row=t,f.col=n,f.x=e,f.y=i,f.width=r,f.height=o,f.isAutoMerge=s,f.offsetX=c}function Yt(t,n){var t=t.valuesLoad/t.total;return n?.4*t+.1:.3*t+.1}function Zt(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,v,m,g,p,b,w,y,M,C,l,a,l=r&&r.incrementLoadTask;if(l&&!l.isTerminated){for(h=l.isBusyFunc,d=a=a||0,v=!1,m=30,g=new Date;d<e;){if(p=n[d])for(b=0;b<i;b++)(w=p[b])&&nn(w,t.J_(d,b,v=!0),o,d,b,r,s,c,f);if(d++,h&&h())break;if(30<(y=new Date)-g)break}if(v){if(M=r&&r.sheet,0!==a&&M.parent.getActiveSheet()===M)for(C=a;C<d;C++)if(M.N8.viewport[1].findRow(C)){M.repaint();break}(l=r&&r.incrementalLoading)&&(l.loadStatus.valuesLoad+=d-a,a=Yt(l.loadStatus,r.doNotRecalculateAfterLoad),M.parent&&M.parent.ki(nt.Events.ProgressChanged,{loadStatus:l.loadStatus,progress:a,sheet:M}),l.loading)&&l.loading(a,{sheet:M})}d<e?r.incrementLoadTask.pushTask(Zt,[t,n,e,i,r,o,d,u,s]):u&&r.incrementLoadTask.pushTask(u,[])}}function Wt(t,n,e,i,r,o,a,u,s){for(var c,f,l,h,c=0;c<e;c++)if(f=n[c])for(l=0;l<i;l++)(h=f[l])&&nn(h,t.J_(c,l,!0),o,c,l,r,a,u,s)}function Qt(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,k,k,E,I,O,o,o,l=F.Util.Mo(r);if(e){for(h=t.a8,d=r&&!1===r.includeStyles,v=J(r),m=i.styleManager,p=(g=r&&r.incrementLoadTask).isBusyFunc,b=!1,w=30,l&&(y=new Date),M=o=o||0,C=e.rowCount,S=e.colCount;M<C;)if(T=e[M]){for(I=(A=t.J_(M,-1,!0))&&A.style,x=void 0,A&&!d&&(v?T.t!==ot?x=m.getOriginNamedStyle(T.t):T.e!==ot&&(x=ut(m.getOriginStyle(T.e))):x=m.getStyle(T.s),A.style=x),A&&T.lossless&&!at(T.lossless.tag)&&(A.tag=T.lossless.tag),h&&L(h.style,M,-1,I,A&&A.style),N=0;N<S;N++)(k=T[N])!==ot&&(_=t.J_(M,N,b=!0),j=D=void 0,D=(j=k).v!==ot?"number"==typeof(k=j.v)?i.sharedStrings.getText(k):k&&(k._calcError||k._error&&!at(k._code)||k.error&&!at(k.code))?R&&B.CalcError.parse(k._calcError||k._error||k.error):k:j.b!==ot?!!j.b:j.o!==ot?"/OADate("+j.o+")/":j.n,at(j.f)&&h&&L(h.data,M,N,_.value,D),at(D)||(_.value=D),k=_.style,v||(at(j.s)&&(x||f[N])?j.s=0:0!==j.s||x||f[N]||(j.s=ot)),d||(E=void 0,v?j.t!==ot?E=m.getOriginNamedStyle(j.t):j.e!==ot&&(E=ut(m.getOriginStyle(j.e))):E=m.getStyle(j.s),_.style=E),h&&L(h.style,M,N,k,_.style),j.lossless&&(at(j.lossless.bindingPath)||(_.bindingPath=j.lossless.bindingPath),at(j.lossless.tag)||(_.tag=j.lossless.tag),at(j.lossless.altText)||(_.altText=j.lossless.altText)),-1<M)&&dn(_,D,!!j.f||!!j.g||!!j.si,_.style,s,ot,c);if(M++,!u&&p&&p())break;if(l&&(I=new Date,!u)&&30<I-y)break}else M++;if(b){if(0!==o&&n.parent.getActiveSheet()===n)for(O=o;O<M;O++)if(n.N8.viewport[1].findRow(O)){n.repaint();break}r.loadStatus.valuesLoad+=M-o,!u&&l&&(o=r.loadStatus.valuesLoad/r.loadStatus.total,o=+(r.fullRecalc?.3*o+.2:.4*o+.2).toFixed(5),r.incrementLoadTask.progress)&&r.incrementLoadTask.progress({progress:o,sheetName:n.name(),step:Z.I5(ht().STEP.loadSheetData,[n.name()])})}M<C?r.incrementLoadTask.pushTask(Qt,[t,n,e,i,r,M,a,ot,s,c,f]):u?a():a&&r.incrementLoadTask.pushTask(a,[])}else a&&setTimeout(a,0)}function Jt(t,n,e,i,r){var i,o,i,e;0<=t&&0<=n&&(i[t]||(i[t]={}),o=(i=i[t])[n],i=null==(i[n]=e)?void 0:e.value,e=null==e?void 0:e.expr,r)&&(L(r,t,n,o&&o.value,i),L(r,t,n,o&&o.expr,e))}function Kt(t,n,e,i,r,o,a,u,s){var o,c,o;0<=e&&0<=i?(o[e]||(o[e]={}),c=(o=o[e])[i],o=(o[i]=r)&&r.value,s.a8&&(o&&"SparklineExValue"===o.typeName&&(o=rt),L(s.a8.data,e,i,c&&c.value,o),L(s.a8.style,e,i,c&&c.style,r&&r.style))):0<=e&&-1===i&&0<=t&&-1===n?a[e]=r:0<=i&&-1===e&&0<=n&&-1===t&&(u[i]=r)}function Xt(t,n,e,i,r,o,a){var o;0<=e&&0<=i&&(o[e]||(o[e]={}),o[e].rs="e",(o=o[e]).originalItem=a,o[i]=r)}function qt(t,n,e){var i,r,o,a,u,s,i={};for(r in t)t[r]&&(o=H(r),!isNaN(o))&&n<=o&&(a=t[o],u=t[o+e],s=i[o],u&&(i[o+e]=u),s?t[o+e]=s:(delete t[o],t[o+e]=a))}function $t(t,n,e){var i,r,o;for(i in t)t[i]&&(r=Math.floor(i),!isNaN(r))&&n<=r&&(o=t[r],delete t[r],n+e<=r)&&(t[r-e]=o)}function tn(t,n,e,i,r){var o=t.op(),t=t.Uw(),a=n.Uw(),u;o&&t&&a&&r&&(u=o.unparse(a,r,e,i)),n.Ut.setDefaultValue(e,i,u,rt,et.DefaultChangeValueType.Expression,rt,!0)}function r(t,n,e){var i=this;i.Mf=t,i.Sx=n,i.Tx=e,i.defaultCellData={},i.Gve=new nt.BaseUsedRange,i.I8=-1,i.x8=-1}function o(t,n,e,i){var r=this;r.Sx=t,r.Tx=n,at(e)||(r.j8=e),at(i)||(r.O8=i),r.Hc()}function a(){this.infos=[],this.R8=[]}function nn(t,n,e,i,r,o,a,u,s){var c,f,l,l,h,d,v,h,e,a,v,o,d,h;t&&(c=t.value,f=t.formula,c!==ot&&(c!==rt&&(c._calcError||c._error&&!at(c._code))&&(l=R&&B.CalcError.parse(c._calcError||c._error))!==ot&&(c=l=Q(l)),at(f)&&a&&L(a.data,i,r,n.value,c),n.value=c),l=t.style,h=o&&o.sheet,l!==ot&&o&&!o.ignoreStyle&&(d=rt,v=n.style,typeof l===U?(n.style=l,d=h&&(h.i3(l,!1)||h.parent&&h.parent.i3(l,!1))):l&&((d=new tt.Style).fromJSON(l,e),d.name=ot,n.style=d),a&&L(a.style,i,r,v,n.style),d)&&d.validator&&o.setValidator&&o.setValidator(i,r,d.validator),(h=t.visualState)!==ot&&(n.visualState=h),(e=t.bindingPath)!==ot&&(n.bindingPath=e),(a=t.tag)!==ot&&a!==rt&&(typeof(v=a.typeName)===U&&(o=j.getTypeFromString(v))&&(a=new o).fromJSON&&a.fromJSON(t.tag),n.tag=a),(d=t.altText)!==ot&&d!==rt&&(n.altText=d),(h=t.hyperlink)!==ot&&(n.hyperlink=ut(h)),-1<i)&&-1<r&&dn(n,c,!!f,l,u,ot,s)}function en(t,n,e){var i,r,o,a,u,s,c,f,l,h,d,h,v,e,o,r,a,n,e,i=n[0];if("selectionModel"!==i[0]){for(r=i[0],o=n[1],a=null,2<n.length&&(a=n[2]),a=e?a:o,u=t,s=0;s<i.length-1;s++)c=i[s],u=c===V?u.B8:(u[c]||(u[c]={}),u[c]);l=i[(f=i.length)-1],h=t.sheetModels[3],d=t.defaultValueModels[3],h=h.a8,v=u[i[s]],r===w||"colInfos"===r||"rowInfos"===r||r===y?e&&a!==u[i[s]]?u[i[s]]=a:e||(u[i[s]]=o):"spanModels"===r?(u.cache={},u.spans=[],a.forEach(function(t){u.add((0,nt.Ec)(t.row,t.col,t.rowCount,t.colCount))})):(u[i[s]]=n[1],e=void 0,o=i[f-2],r=i[1],"size"===l?e=i[0]===p?et.AxisInfoChangeType.setRowHeight:et.AxisInfoChangeType.setColumnWidth:"visible"===l&&(e=i[0]===p?et.AxisInfoChangeType.setRowVisible:et.AxisInfoChangeType.setColumnVisible),at(e)||t.L8({type:e,index:o,sheetArea:r})),"style"===l?((a=h&&h.style)&&L(a,i[f-3],i[f-2],v,u[i[s]]),u&&(v&&v.quotePrefix||u.style&&u.style.quotePrefix)&&(v&&v.quotePrefix)!==(u.style&&u.style.quotePrefix)&&dn(u,u.value,!!u.formula,u.style,t.F8)):"value"===l?((n=h&&h.data)&&L(n,i[f-3],i[f-2],v,u[i[s]]),u&&v!==u.value&&dn(u,u.value,!!u.formula,u.style,t.F8)):l===lt&&(e=d.Gve)&&L(e,i[f-3],i[f-2],v,u[i[s]])}}function rn(t,n,e){var i=0<t.P8?[["selectionModel"],ot]:ot;t.selectionModel.setProperty(n,e,i),i&&t.G8.push(i)}function on(t,n){[t,n].join(",")}function an(t,n,e){var i;if(t)return(i=t.caches)||(t.caches=i=D.createMap(),t.forEach(function(t){void 0===t[2]&&i.set(t[0]+","+t[1],1)})),i.has(n+","+e)}function un(t,n,e,i){var r=t[n];r&&delete r[e],i&&it(r)&&delete t[n]}function sn(t){return t&&t.filter(function(t){return!t.isAutoMerge})}function x(t,n,e,i,r,o){var a,u,u,u,s,u;function c(t,n,e,i){0<a.P8&&a.G8.push([["defaults",e],i,n]),a.Mf.zw()}(a=this).Mf=t,u=new yt(n,e,n,e),a.sheetModels=[ot,new yt(i,e,0,0),new yt(n,r,0,0),u],u.z8(),(u=a.rowInfos=[])[0]=u[1]=new f,u[2]=u[3]=new f,(u=a.colInfos=[])[0]=u[2]=new f,u[1]=u[3]=new f,a.spanModels=[ot,new dt,new dt,new dt],a.defaultValueModels=[ot,new wt(t,i,e),new wt(t,n,r),new wt(t,n,e)],a.selectionModel=new gt,(s=a.colHeaderSelectionModel=new gt).selectionPolicy=1,a.name=o||"",a.isSelected=!1,a.zoomFactor=1,Et(u=a.defaults={},"rowHeight",20,c),Et(u,"colWidth",62,c),Et(u,"rowHeaderColWidth",40,c),Et(u,"colHeaderRowHeight",m.DEFAULT_COL_HEADER_ROW_HEIGHT,c),Et(u,"_isExcelDefaultColumnWidth",!1,c),a.P8=0,x.et(this,"init"),a.V8(n,e),a.F8={}}function cn(t,n){return!n&&!at(t)&&"string"==typeof t}function fn(t,n,e,i){var n;return(!n||!n.quotePrefix)&&(e&&e[t]||(-1!==It.indexOf(t[0])&&1<t.length&&(At.et(ot,"isInvalidFormula",n={value:t,isInvalid:!1,allowDynamicArray:i}),n.isInvalid)?(e&&(e[t]=!0),1):void 0))}function ln(t){at(t.cellState)||(t.cellState&=~et.CellStatesType.invalidFormula)}function hn(t){at(t.cellState)&&(t.cellState=0),t.cellState|=et.CellStatesType.invalidFormula}function dn(t,n,e,i,r,o,a){at(t)||(cn(n,e)&&fn(n,i=o&&i&&"string"==typeof i?mn(i,o):i,r,a=o&&at(a)?o.options.allowDynamicArray:a)?hn:ln)(t)}function vn(t,n,e){return!(at(t)&&at(n)||("string"==typeof t&&(t=mn(t,e)),"string"==typeof n&&(n=mn(n,e)),(t&&t.quotePrefix)===(n&&n.quotePrefix)))}function mn(t,n){var e,i,r,o,a;if(n){if(e=n.getNamedStyle(t))return e;for(i=0,r=n.sheets;i<r.length;i++)if(a=(o=r[i]).getNamedStyle(t))return a;return rt}}function gn(t,n){var e,i,t;if("string"==typeof t&&"/OADate"===t.substring(0,7)&&!n.formatter){if((n=at(n)?new tt.Style:n)._autoFormatter)return n.formatter=n._autoFormatter.formatCached,n;e=t.indexOf("("),i=t.indexOf(")"),-1!==e&&-1!==i&&((t=parseInt(t.substring(e+1,i),10))<1?n.formatter="h:mm:ss":1<t&&(n.formatter="M/d/yyyy"))}return n}function pn(t,n){return n=t.renamedStyles&&t.renamedStyles[n]?t.renamedStyles[n]:n}function bn(t,n){var e,i,r;return"object"==typeof n?n:"string"==typeof n?(xt.test(e=n)&&(i=n.indexOf(Nt),e=pn(t,n.substring(i))),(r=t.u8(e))||new tt.Style):void 0}function wn(t,n,e){e&&yn(n,e=bn(t,e))}function yn(t,n){t.backColor===ot&&n.backColor!==ot&&!1!==n.applyFill&&(t.backColor=n.backColor),!1!==n.applyFont&&(t.foreColor===ot&&n.foreColor!==ot&&(t.foreColor=n.foreColor),t.themeFont===ot&&t.font===ot?(t.themeFont=n.themeFont,t.font=n.font):t.themeFont!==ot&&t.font===ot&&(t.font=n.font),t.textDecoration===ot)&&n.textDecoration!==ot&&(t.textDecoration=n.textDecoration),!1!==n.applyAlignment&&(t.hAlign===ot&&n.hAlign!==ot&&(t.hAlign=n.hAlign),t.vAlign===ot&&n.vAlign!==ot&&(t.vAlign=n.vAlign),t.textIndent===ot&&n.textIndent!==ot&&(t.textIndent=n.textIndent),t.wordWrap===ot&&n.wordWrap!==ot&&(t.wordWrap=n.wordWrap),t.isVerticalText===ot&&n.isVerticalText!==ot&&(t.isVerticalText=n.isVerticalText),t.shrinkToFit===ot&&n.shrinkToFit!==ot&&(t.shrinkToFit=n.shrinkToFit),t.textOrientation===ot)&&n.textOrientation!==ot&&(t.textOrientation=n.textOrientation),t.formatter===ot&&n.formatter!==ot&&!1!==n.applyNumberFormat&&(t.formatter=n.formatter),!1!==n.applyBorder&&(t.borderLeft===ot&&n.borderLeft!==ot&&(t.borderLeft=Mn(n.borderLeft)),t.borderTop===ot&&n.borderTop!==ot&&(t.borderTop=Mn(n.borderTop)),t.borderRight===ot&&n.borderRight!==ot&&(t.borderRight=Mn(n.borderRight)),t.borderBottom===ot&&n.borderBottom!==ot&&(t.borderBottom=Mn(n.borderBottom)),t.diagonalUp===ot&&n.diagonalUp!==ot&&(t.diagonalUp=Mn(n.diagonalUp)),t.diagonalDown===ot)&&n.diagonalDown!==ot&&(t.diagonalDown=Mn(n.diagonalDown)),t.locked===ot&&!1!==n.applyProtection&&(t.locked=n.locked),t.quotePrefix===ot&&n.quotePrefix!==ot&&(t.quotePrefix=n.quotePrefix)}function Mn(t){var n;return t&&(n={},at(t.color)||(n.color=t.color),at(t.style)||(n.style=t.style),at(t.level)||(n.level=t.level),n)}c=this&&this.__extends||(kt=function(t,n){return(kt=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,n){t.__proto__=n}:function(t,n){for(var e in n)Object.prototype.hasOwnProperty.call(n,e)&&(t[e]=n[e])}))(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}kt(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)}),l=this&&this.__assign||function(){return(l=Object.assign||function(t){for(var n,e,i,r,e=1,i=arguments.length;e<i;e++)for(r in n=arguments[e])Object.prototype.hasOwnProperty.call(n,r)&&(t[r]=n[r]);return t}).apply(this,arguments)},k=this&&this.__rest||function(t,n){var e,i,r,e={};for(i in t)Object.prototype.hasOwnProperty.call(t,i)&&n.indexOf(i)<0&&(e[i]=t[i]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(r=0,i=Object.getOwnPropertySymbols(t);r<i.length;r++)n.indexOf(i[r])<0&&Object.prototype.propertyIsEnumerable.call(t,i[r])&&(e[i[r]]=t[i[r]]);return e},Object.defineProperty(m,"__esModule",{value:!0}),m.Y8=m.DEFAULT_COL_HEADER_ROW_HEIGHT=m.copyDefaultFormula=m.W8=m.h9=m.Q8=m.K8=m.getOADateNumber=void 0,_=h("./dist/core/core.ns.js"),tt=h("./dist/core/worksheet/style.js"),S=h("Common"),D=h("CalcEngine"),B=h("CalcEngine"),j=h("./dist/core/util/common.js"),nt=h("./dist/core/util/common.js"),t=h("./dist/core/util/domUtil.js"),et=h("./dist/core/core.enum.js"),E=h("./dist/core/celltype/celltype.ns.js"),F=h("./dist/core/excel-io-util/common.js"),st=h("./dist/core/excel-io-util/excel-types.js"),R=!!D,O=t.GC$.each,it=t.GC$.isEmptyObject,P=t.GC$.extend,G=new RegExp("^\\d*(\\.\\d+)?\\*$"),rt=null,ot=void 0,U="string",T=Math.min,H=Math.floor,g=Math.max,I=Math.ceil,V="dirtyNodes",z="undo",p="rowInfos",b="colInfos",Y="default_size",s=S.Common.J8,d=S.Common.X8,at=S.Common.lt.ht,Z=S.Common.zf,W=nt.util.wt,Q=nt.util.g0,ct=nt.util.St,J=F.Util.ko,ut=S.Common.lt.tv,K=S.Common.lt.q8,X=200,q=20,$="bindingPath",v=nt.UsedRangeUtil.vh,ft=nt.UsedRangeUtil.hh,L=nt.UsedRangeUtil.updateUsedRangeByData,w="sheetModels",y="defaultValueModels",lt="defaultCellData",t=new S.Common.ResourceManager(_.SR,"Sheets"),ht=t.getResource.bind(t),m.getOADateNumber=Bt,n.prototype.find=function(t,n){return this.cache[t+"_"+n]||rt},n.prototype.get=function(t,n){return this.find(t,n)||(0,nt.Ec)(t,n,1,1)},n.prototype.remove=function(t,n){var t=this.spans.indexOf(t);0<=t?(n&&(n[0].push("spans"),n[1]=[].concat(this.spans)),this.removeSpan(t,1),n&&(n[2]=[].concat(this.spans))):n&&(n.length=0)},n.prototype.removeSpan=function(t,n){for(var e=0;e<n;e++)Lt(this,this.spans[t+e]);this.spans.splice(t,n)},n.prototype.update=function(t,n){var e=this;Lt(e,e.spans[t]),e.spans[t]=n,Rt(e,n)},n.prototype.add=function(t,n){n&&(n[0].push("spans"),n[1]=[].concat(this.spans)),Rt(this,t),this.spans.push(t),n&&(n[2]=[].concat(this.spans))},n.prototype.tE=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,u=this,s=!1;for(a&&(c=[].concat(u.spans)),f=u.spans.length,m=[],v=0;v<f;v++)d=(l=u.spans[v]).col,h=l.row,(-1===t||t<=h&&h<t+r)&&(-1===n||n<=d&&d<n+o)?(m.push((0,nt.Ec)(-1===t?h:e+h-t,-1===n?d:i+d-n,C(l),A(l))),s=!0):(-1===t||e<=h&&h<e+r)&&(-1===n||i<=d&&d<i+o)&&(u.removeSpan(v,1),v--,f--,s=!0);for(v=0;v<m.length;v++){if(!u.nE(u.spans,0,u.spans.length,l=m[v]))throw new Error(ht().Exp_OverlappingSpans);u.add(l)}a&&(s?(a[0].push("spans"),a[1]=c,a[2]=[].concat(u.spans)):a.length=0)},n.prototype.nE=function(t,n,e,i){for(var r=n;r<e&&r<t.length;r++)if(t[r].intersect(i.row,i.col,C(i),A(i)))return!1;return!0},n.prototype.getSpans=function(t){var n,e,i,r,n=this.spans;if(!t)return[].concat(n);for(e=[],i=0;i<n.length;i++)(r=n[i]).intersect(t.row,t.col,C(t),A(t))&&e.push(r);return e},n.prototype.GT=function(t,n,e,i){for(var r,o,a,r=this.spans,o=0;o<r.length;o++)if((a=r[o]).intersect(t,n,e,i)&&(-1!==t&&(a.row<t||a.row+C(a)>t+e)||-1!==n&&(a.col<n||a.col+A(a)>n+i)))return!0;return!1},n.prototype.eE=function(t,n,e,i){for(var r,o,a,u,r=!1,o=this.spans,a=0,u=o.length;a<u;a++){if(0<=t||0<=n)for(;a<u&&!o[a].intersect(t,n,e,i);)a++;if(a<u){r=!0;break}}return r},n.prototype.d5=function(t,n,e,i,r){var o,a,u,s,c,f,c,o=this.spans,a=!1;for(r&&(u=[].concat(o)),s=0;s<o.length;s++)f=(c=o[s]).row,c=c.col,(-1===t||t<=f&&f<t+e)&&(-1===n||n<=c&&c<n+i)&&(this.removeSpan(s,1),s--,a=!0);r&&(a?(r[0].push("spans"),r[1]=u,r[2]=[].concat(this.spans)):r.length=0)},n.prototype.iE=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,u=this,s=!1;for(a&&(c=[].concat(u.spans)),f=[],l=[],h=u.spans.length,g=0;g<h;g++)v=(d=u.spans[g]).row,m=d.col,(-1===t||t<=v&&v<t+r)&&(-1===n||n<=m&&m<n+o)?(p=(0,nt.Ec)(-1===t?v:e+v-t,-1===n?m:i+m-n,C(d),A(d)),l.push(p),s=!0):(-1===t||e<=v&&v<e+r)&&(-1===n||i<=m&&m<i+o)?s=!0:f.push(d);if(s){if(0<l.length)for(g=0;g<l.length;g++){if(!u.nE(f,0,f.length,p=l[g]))throw new Error(ht().Exp_OverlappingSpans);f.push(p)}for(u.spans.length=0,u.cache={},g=0;g<f.length;g++)u.add(f[g]);a&&(a[0].push("spans"),a[1]=c,a[2]=[].concat(u.spans))}else a&&(a.length=0)},n.prototype.rE=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,c,i=this,r=i.spans,o=!(i.suspendUpdatingCache=!0);for(e&&(a=[].concat(r)),u=r.length,s=0;s<u;s++)f=(c=r[s]).row,l=c.col,h=C(c),c=A(c),t<=f?(i.update(s,(0,nt.Ec)(f+n,l,h,c)),o=!0):t<f+h&&(i.update(s,(0,nt.Ec)(f,l,h+n,c)),o=!0);i.suspendUpdatingCache=!1,o&&Ot(i,r),e&&(o?(e[0].push("spans"),e[1]=a,e[2]=[].concat(i.spans)):e.length=0)},n.prototype.oE=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,c,i=this,r=i.spans,o=!(i.suspendUpdatingCache=!0);for(e&&(a=[].concat(r)),u=r.length,s=0;s<u;s++)f=(c=r[s]).row,l=c.col,h=C(c),c=A(c),t<=l?(i.update(s,(0,nt.Ec)(f,l+n,h,c)),o=!0):t<l+c&&(i.update(s,(0,nt.Ec)(f,l,h,c+n)),o=!0);i.suspendUpdatingCache=!1,o&&Ot(i,r),e&&(o?(e[0].push("spans"),e[1]=a,e[2]=[].concat(i.spans)):e.length=0)},n.prototype.aE=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,d,f,h,v,i=this,r=i.spans,o=!(i.suspendUpdatingCache=!0);for(e&&(a=[].concat(r)),u=[],s=r.length,c=0;c<s;c++)l=(f=r[c]).row,h=f.col,d=C(f),f=A(f),t<=l?o=(l<t+n?l+d<=t+n?u.push(c):i.update(c,(0,nt.Ec)(t,h,l+d-(t+n),f)):i.update(c,(0,nt.Ec)(l-n,h,d,f)),!0):t<l+d&&(h=(0,nt.Ec)(l,h,d-T(l+d-t,n),f),i.update(c,h),1===h.rowCount&&1===h.colCount&&u.push(c),o=!0);for(c=u.length-1;0<=c;c--)i.removeSpan(v=u[c],1);i.suspendUpdatingCache=!1,o&&Ot(i,r),e&&(o?(e[0].push("spans"),e[1]=a,e[2]=[].concat(i.spans)):e.length=0)},n.prototype.uE=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,d,f,l,v,i=this,r=i.spans,o=!(i.suspendUpdatingCache=!0);for(e&&(a=[].concat(r)),u=[],s=r.length,c=0;c<s;c++)l=(f=r[c]).row,h=f.col,d=C(f),f=A(f),t<=h?o=(h<t+n?h+f<=t+n?u.push(c):i.update(c,(0,nt.Ec)(l,t,d,h+f-(t+n))):i.update(c,(0,nt.Ec)(l,h-n,d,f)),!0):t<h+f&&(l=(0,nt.Ec)(l,h,d,f-T(h+f-t,n)),i.update(c,l),1===l.rowCount&&1===l.colCount&&u.push(c),o=!0);for(c=u.length-1;0<=c;c--)i.removeSpan(v=u[c],1);i.suspendUpdatingCache=!1,o&&Ot(i,r),e&&(o?(e[0].push("spans"),e[1]=a,e[2]=[].concat(i.spans)):e.length=0)},n.prototype.toJSON=function(){var t=[].concat(this.spans);return 0===t.length?ot:t},n.prototype.fromJSON=function(t,n,e){var i,r,o,a,u,a,u;if(t)for(this.spans=[],i=t,r=0;r<i.length;r++)a=C(o=i[r]),u=A(o),a=at(n)?a:T(a,n),u=at(e)?u:T(u,e),this.add((0,nt.Ec)(o.row,o.col,a,u))},dt=n,Ft.prototype.pop=function(){return rt},Ft.prototype.push=function(t){return 0},Ft.prototype.splice=function(t,n){for(var e,i,e=[],i=2;i<arguments.length;i++)e[i-2]=arguments[i];return rt},Ft.prototype.slice=function(t,n){return null},(_=Ft).prototype=[],c(Pt,_t=_),Pt.prototype.find=function(t){for(var n,e,i,r,o,n=this,e=n.length,r=[],o=0;o<e;o++)(i=n[o]).contains(t)&&r.push(i);return r},m.K8=Pt,Gt.prototype.contains=function(t){return t>=this.startColumn&&t<=this.endColumn},m.Q8=Gt,e.prototype.getProperty=function(t){return this[t]},e.prototype.setProperty=function(t,n,e){e&&(e[0].push(t),e[1]=this[t],e[2]=n),this[t]=n},e.prototype.clear=function(t){t&&(t.push(["selections",this.get()]),t.push(["activeSelectedRangeIndex",this.activeSelectedRangeIndex])),this.selections=[],this.activeSelectedRangeIndex=-1},e.prototype.add=function(t,n,e,i,r,o){r&&(r.push(["selections",this.get()]),r.push(["activeSelectedRangeIndex",this.activeSelectedRangeIndex]));var r=this,a=r.selectionPolicy,u=r.selectionUnit;0===a?(e=T(e,1),i=T(i,1),r.clear()):1===a&&r.clear(),1===u?i=n=-1:2===u&&(e=t=-1),r.selections.push((0,nt.Ec)(t,n,e,i)),!1!==o&&(r.activeSelectedRangeIndex=r.selections.length-1)},e.prototype.get=function(){return[].concat(this.selections)},e.prototype.set=function(t,n){n&&(n.push(["selections",this.get()]),n.push(["activeSelectedRangeIndex",this.activeSelectedRangeIndex])),this.selections=t,this.activeSelectedRangeIndex>=t.length&&(this.activeSelectedRangeIndex=0)},e.prototype.toJSON=function(){var t,n,e,i,r,o,a,t=this,n={},e=t.selectionPolicy,i=t.selectionUnit,r=t.activeSelectedRangeIndex,o=t.selections.length;for(2!==e&&(n.selectionPolicy=e),0!==i&&(n.selectionUnit=i),0!==r&&(n.activeSelectedRangeIndex=r),n.length=o,a=0;a<o;a++)n[a]=t.selections[a];return it(n)?ot:n},e.prototype.fromJSON=function(t,n,e){var i,r,o,a,u,n,e,s,c,f,i=n||200,r=e||20;if(t){for((u=this).clear(),n=t.selectionPolicy,e=t.selectionUnit,s=t.length,at(s)&&(s=1),c=0;c<s;c++)f=t[c],o=T(f?C(f):1,i),a=T(f?A(f):1,r),u.selections.push((0,nt.Ec)(f?f.row:0,f?f.col:0,o,a));u.activeSelectedRangeIndex=t.activeSelectedRangeIndex||0,at(n)||(u.selectionPolicy=n),at(e)||(u.selectionUnit=e)}},e.prototype.T9=function(t){for(var n,e,i,r,n=this.selections,e=0;e<n.length;e++)if(r=-1===(i=n[e]).col?0:i.col,-1===i.row&&r<=t&&t<r+A(i))return!0;return!1},e.prototype.S9=function(t){for(var n,e,i,r,n=this.selections,e=0;e<n.length;e++)if(r=-1===(i=n[e]).row?0:i.row,-1===i.col&&r<=t&&t<r+C(i))return!0;return!1},e.prototype.ni=function(t,n,e,i,r,o){for(var a,u,s,c,f,l,h,d,v,d,v,a=!1,u=this.selections,s=o?1:0,c=0,f=u.length;c<f&&(d=(h=Ut(l=u[c],i,r)).row,v=h.col,d=d-s<=t&&t<d+C(h)+s,v=v-s<=n&&n<v+A(h)+s,3===e||at(e)?a=d&&v:2===e?a=d:1===e?a=v:0===e&&(a=-1===l.row&&-1===l.col),!a);c++);return a},e.prototype.ei=function(t,n,e,i,r){for(var o,a,u,s,c,f,l,s,h,d,c,c,o=this.selections,a=!1,u=0;u<o.length&&(c=(s=o[u]).row,f=s.col,l=C(s),s=A(s),h=-1===f,d=-1===c,at(e)||3===e||(2===e?(c=d?0:c,a=h&&c<=t&&t<c+l):1===e?(c=h?0:f,a=d&&c<=n&&n<c+s):0===e&&(a=d&&h&&l===i&&s===r),!a));u++);return a},gt=e,c(i,Dt=_),i.prototype.findCell=function(t,n){for(var e,i,r,e=this.length,r=0;r<e;r++)if((i=this[r]).contains(t,n))return i;return rt},i.prototype.sE=function(){this.cE={}},i.prototype.fE=function(t,n){this.cE[t]=n},i.prototype.findRow=function(t){var n,e,i,r,n=this.cE;if(n)return n[t];for(e=this.length,r=0;r<e;r++)if((i=this[r]).row===t)return i;return rt},i.prototype.findCol=function(t){for(var n,e,i,n=this.length,i=0;i<n;i++)if((e=this[i]).col===t)return e;return rt},i.prototype.findLargestRow=function(t){var n,e,i,r,o,n=this.length;if(0===n)return rt;for(r=e=0;r<n;r++)(o=this[r]).row===t&&o.height>e&&(e=o.height,i=r);return K(i)&&this[i]},i.prototype.findLargestCol=function(t){var n,e,i,r,o,n=this.length;if(0===n)return rt;for(r=e=0;r<n;r++)(o=this[r]).col===t&&o.width>e&&(e=o.width,i=r);return K(i)&&this[i]},i.prototype.findLargestRange=function(t,n){var e,i,r,o,a,u,s,c,f,l,e=this.length;if(0===e)return rt;for(i=t.row,r=t.col,o=t.rowCount,a=t.colCount,c=s=0;c<e;c++)if(n)for(f=t.row;f<i+o;f++)(l=this[c]).row===f&&l.height>s&&(s=l.height,u=c);else for(f=t.col;f<r+a;f++)(l=this[c]).col===f&&l.width>s&&(s=l.width,u=c);return K(u)&&this[u]},i.prototype.findX=function(t,n){return Ht(this,ot,ot,t,ot,n)},i.prototype.findY=function(t){return Ht(this,ot,ot,ot,t)},i.prototype.findNearX=function(t){return Vt(this,t)},i.prototype.findNearY=function(t){return Vt(this,ot,t)},i.prototype.findXByExactY=function(t,n,e){var i,t,r,o,a,u,i=this.findX(t,!0);if(!Array.isArray(i))return i;for(t=i.length,r=e.y,o=e.height,a=t-1;0<=a;a--)if(n>r+(u=i[a]).y*o)return u},m.h9=i,zt.prototype.contains=function(t,n){var e=this;return t<e.row+C(e)&&e.row<=t&&n<e.col+A(e)&&e.col<=n},zt.prototype.intersect=function(t){var n=this;return(n.x<0||t.x<n.x+n.width&&n.x<t.x+t.width)&&(n.y<0||t.y<n.y+n.height&&n.y<t.y+t.height)},zt.prototype.containsX=function(t){return this.x<=t&&t<this.x+this.width},zt.prototype.containsY=function(t){return this.y<=t&&t<this.y+this.height},m.W8=zt,m.copyDefaultFormula=tn,r.prototype.dispose=function(){this.Mf=rt,this.defaultCellData=rt},r.prototype.getRowCount=function(){return this.Sx},r.prototype.setRowCount=function(t){this.Sx=t},r.prototype.getColumnCount=function(){return this.Tx},r.prototype.setColumnCount=function(t){this.Tx=t},r.prototype.X1e=function(t,n,e,i,r,o){var a;n&&(a=void 0,t&&(a=o===et.DefaultChangeValueType.Expression?t.expr:t.value),n[0].push(lt,e,i,o),n[1]=at(a)?rt:a,n[2]=r)},r.prototype.Uve=function(t,n){var e=this;e.x8<n&&(e.x8=n),e.I8<t&&(e.I8=t)},r.prototype.q1e=function(t,n){var e,t=this.defaultCellData[t],i;return i=at(t)?i:t[n]},r.prototype.getValue=function(t,n){var e=this,i;return t<e.Sx&&n<e.Tx&&(i=0<=t&&0<=n?e.q1e(t,n):i)&&!at(i.value)?i.value:rt},r.prototype.setValue=function(t,n,e,i,r){var o,a,o,u,r,a=this;t<a.Sx&&n<a.Tx&&0<=t&&0<=n&&(u=(o=a.defaultCellData)[t],at(u)&&(u=o[t]={}),e=nt.util.Z0(e),a.X1e(u[n],r,t,n,e,et.DefaultChangeValueType.Value),i?(u[n]||(u[n]={}),u[n].value=e):(r=null==(o=u[n])?void 0:o.value,u[n]&&u[n].expr&&a.$1e(t,n,rt),u[n]={value:e},a.Uve(t,n),a.Gve&&L(a.Gve,t,n,r,e)))},r.prototype.getFormulaFromExpression=function(t,n,e){var t,i,r,o,i,i=this;if(t)return o=void 0,(r=h("SheetsCalc"))&&((i=i.Mf).vle=!0,o=r.expressionToFormula(i,t,n,e,(null==(t=i.parent)?void 0:t.options.referenceStyle)===r.ReferenceStyle.r1c1),delete i.vle),nt.util.g1(o)},r.prototype.getFormula=function(t,n){var e,i,i,e=this;return t<e.Sx&&n<e.Tx&&(i=0<=t&&0<=n?e.q1e(t,n):i)&&i.expr?(i=i.expr,e.getFormulaFromExpression(i,t,n)):rt},r.prototype.getExpression=function(t,n){var e=this,i;return t<e.Sx&&n<e.Tx?(i=0<=t&&0<=n?e.q1e(t,n):i)&&i.expr:rt},r.prototype.$1e=function(t,n,e,i,r,o){var a,u,s,a,c,a=this,u,s=a.defaultCellData[t];if(s&&s[n]&&s[n].expr&&(c=(a=a.Mf).op()))try{a.vle=!0,o&&(s[n].value=rt,i=s[n].expr),a.zI(t,n,e,i,!1,r,!0,!0)}finally{delete a.vle}},r.prototype.setFormula=function(t,n,e,i,r,o){var a,u,s,c,f,s,l,a,s,u=this;t<u.Sx&&n<u.Tx&&0<=t&&0<=n&&(c=(s=u.defaultCellData)[t],f=void 0,(c=at(c)?s[t]={}:c)[n]||(c[n]={}),e&&((s=h("SheetsCalc"))&&(a=(null==(a=(l=u.Mf).parent)?void 0:a.options.referenceStyle)===s.ReferenceStyle.r1c1,f=s.formulaToExpression(l,e,t,n,a,!0),e=s.expressionToFormula(l,f,t,n,a)),e=nt.util.g1(e)),u.X1e(c[n],o,t,n,f,et.DefaultChangeValueType.Expression),s=c[n].expr,c[n].expr=f,u.Uve(t,n),u.Gve&&L(u.Gve,t,n,s,f),R?r||u.$1e(t,n,e,f,i):(u.X1e(c[n],o,t,n,e,et.DefaultChangeValueType.Value),c[n].value=e))},r.prototype.resetFormulaToCalc=function(t,n,e,i,r){var o=this,a=o.Sx,u=o.Tx,s,c;if(0<=t&&0<=n&&(e=T(e,a-t),i=T(i,u-n),0<e)&&0<i)for(c=t;c<t+e;c++)for(s=n;s<n+i;s++)o.$1e(c,s,rt,rt,r,!0)},r.prototype.gle=function(){return this.defaultCellData},r.prototype.ble=function(t){var n,e,i,r;if(t)for(n in t)if(t.hasOwnProperty(n)&&(e=t[n]))for(i in e)e.hasOwnProperty(i)&&(r=e[i])&&r.expr&&(r.oldRow=n,r.oldCol=i)},r.prototype.hE=function(t){var n,e=this.Gve,i={};if(!at(e))return t&et.UsedRangeType.data&&v(i,e.getUsedRange()),i},r.prototype.rE=function(t,n){var e,i,r,e=this,i=e.Sx;0<=t&&t<=i&&0<=n&&(r=e.defaultCellData,e.ble(r),s(r,i,t,n),e.Sx+=n,e.Gve)&&this.Gve.addHeadInfo(t,n,!0)},r.prototype.yE=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,i=this,r=i.Sx;if(0<=t&&t<r&&0<n){if(r<t+n&&(n=r-t),o=i.defaultCellData,e)for(a=0;a<n;a++)e.push([[lt,u=t+a],o[u]]);if(i.Gve){for(c=(s=t)+n,f=i.defaultCellData,l=void 0;s<c;s++)if(f[s])for(h=0;h<i.Tx;h++)!(l=f[s]&&f[s][h])||at(l.value)&&!l.expr||i.Gve.removeRowAndColInfo(s,h);i.Gve.removeHeadInfo(t,n,!0)}i.ble(o),d(o,r,t,n),i.Sx-=n}},r.prototype.oE=function(t,n){var e,i,r,o,a,e=this,i=e.Tx;if(0<=t&&t<=i&&0<=n){for(r=e.defaultCellData,e.ble(r),o=0;o<e.Sx;o++)(a=r[o])&&t<i&&s(a,i,t,n);e.Tx+=n,e.Gve&&e.Gve.addHeadInfo(t,n,!1)}},r.prototype.wE=function(t,n,e){var i,r,o,a,u,s,c,f,i=this,r=i.Tx;if(0<=t&&t<r&&0<n){for(o=i.defaultCellData,a=void 0,i.ble(o),u=0;u<i.Sx;u++)if(s=o[u]){if(e)for(c=0;c<n;c++)a=s[f=t+c],e.push([[lt,u,f],a]),a&&i.Gve&&(at(a.value)&&!a.expr||i.Gve.removeRowAndColInfo(u,f));d(s,r,t,n)}i.Tx-=n=r<t+n?r-t:n,i.Gve&&i.Gve.removeHeadInfo(t,n,!1)}},r.prototype.SE=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,r;r&&(o=[[y,3],ot],a=[[y,3],ot],u=[[y,3],ot],s=[[y,3],ot],r.push(o,a,u,s)),f=(c=this).defaultCellData,l=c.q1e(t,n),h=c.q1e(e,i),r&&(c.X1e(l,o,t,n,h.value,et.DefaultChangeValueType.Value),c.X1e(h,a,e,i,l.value,et.DefaultChangeValueType.Value),c.X1e(l,u,t,n,h.expr,et.DefaultChangeValueType.Expression),c.X1e(h,s,e,i,l.expr,et.DefaultChangeValueType.Expression)),r=c.Gve,l?Jt(e,i,l,f,r):h&&Jt(e,i,rt,f,r),h?Jt(t,n,h,f,r):l&&Jt(t,n,rt,f,r)},r.prototype.fromJSON=function(t){var n,e,i,r,o,a,u,s;if(t)for(e in(n=this).defaultCellData={},t)if(t.hasOwnProperty(e)&&(i=t[e]))for(r in i)if(i.hasOwnProperty(r)&&i[r])try{o=i[r],a=+e,u=+r,o.f&&n.setFormula(a,u,nt.util.n1(o.f),ot,!0),s=o.v,at(s)||(s.error&&!at(s.code)?s=R&&B.CalcError.parse(s.error):"SparklineExValue"===s.typeName&&(s.toString=function(){return""}),n.setValue(a,u,s,!!o.f))}catch(t){}},r.prototype.toJSON=function(t){var n,e,i,r,o,a,u,s,c,s,c,n=this,e=n.defaultCellData,i={};if(e)for(r in e)if(e.hasOwnProperty(r)&&(o=e[r]))for(a in i[r]||(i[r]={}),o)o.hasOwnProperty(a)&&(u=o[a])&&(at(u.value)||(c=s=u.value,t&&(s&&s instanceof Date?c=s.toISOString():at(s._error)&&at(s._code)||(c={error:s._error,code:s._code})),i[r][a]={v:c}),s=u.expr)&&(i[r][a]||(i[r][a]={}),c=n.getFormulaFromExpression(s,+r,+a),i[r][a].f=nt.util.vo(c));return i},r.prototype.yh=function(t){this.fromJSON(t)},r.prototype.wh=function(t){var n;if(J(t))return this.toJSON(!0)},wt=r,o.prototype.Hc=function(){var t=this;t.dataTable={},t.rowDataArray=[],t.columnDataArray=[],t.defaultDataNode=rt,t.B8={},t.lE=0,t.x8=-1,t.I8=-1},o.prototype.z8=function(){var t;this.a8={data:new nt.BaseUsedRange,style:new nt.BaseUsedRange}},o.prototype.hE=function(t){var n,e=this.a8,i={};if(!at(e))return t&et.UsedRangeType.data&&v(i,e.data.getUsedRange()),t&et.UsedRangeType.style&&v(i,e.style.getUsedRange()),t&et.UsedRangeType.rowStyle&&v(i,e.style.getRowUsedRange()),t&et.UsedRangeType.colStyle&&v(i,e.style.getColUsedRange()),i},o.prototype.getRowCount=function(){return this.Sx},o.prototype.getColumnCount=function(){return this.Tx},o.prototype.setRowCount=function(t){this.Sx=t},o.prototype.setColumnCount=function(t){this.Tx=t},o.prototype.getFreeAreaRowCount=function(){return this.j8},o.prototype.getFreeAreaColumnCount=function(){return this.O8},o.prototype.setFreeAreaRowCount=function(t){this.j8=t},o.prototype.setFreeAreaColumnCount=function(t){this.O8=t},o.prototype.dE=function(t,n,e,i,r){var o,a,u,o,u,o,a,t,o=this,a=o.B8;if(!(0<o.lE)){if(o=t+"_"+n,(u=this.B8.vE)&&u[o]){if(u[o].oldCalcValue===e.mE)return;delete u[o]}0<=t&&0<=n&&(i&&(i.type="updateDirty",i.row=t,i.col=n,i.skipUndo=r,a[t]?a[t][n]||(i.isEmptyCol=!0):i.isEmptyRow=!0),a[t]||(a[t]={}),(u=a[t])[n]||(u[n]={}),o=u[n],"n"!==u.rs&&(u.rs="e"),a=e.gE,t=e.d6,at(a)||(i&&(i.originalItem=u.originalItem),u.originalItem=a),at(t)||(i&&(i.oldValue=o.oldValue,r)&&(i.oldCalcValue=t),o.oldValue=t))}},o.prototype.pE=function(t){var n,e,i,n=this.B8,e=t.row,i=t.col;t.skipUndo&&(this.B8.vE=this.B8.vE||{},this.B8.vE[e+"_"+i]=t),t.isEmptyRow&&n?delete n[e]:t.isEmptyCol&&n[e]?delete n[e][i]:(t.hasOwnProperty("originalItem")&&(at(t.originalItem)&&!at(n[e].originalItem)?delete n[e].originalItem:n[e].originalItem=t.originalItem),t.hasOwnProperty("oldValue")&&n[e]&&(at(t.oldValue)&&!at(n[e][i].oldValue)?delete n[e][i].oldValue:n[e][i].oldValue=t.oldValue))},o.prototype.getValue=function(t,n,e){var t=this.J_(t,n);return t&&!at(t.value)?1!==e?W(t.value):at(t.value.richText)?t.value:P(!0,{},t.value):rt},o.prototype.setValue=function(t,n,e,i,r,o){var a,u,a=this.J_(t,n,!0,i?i[0]:ot);!a||at(a.value)&&at(e)||a.value===e?i&&(i.length=0):(u=a.value,a.value=e,this.dE(t,n,{d6:u,mE:e},r,o),i&&(i[0].push("value"),i[1]=u,i[2]=e),this.a8&&(e&&"SparklineExValue"===e.typeName&&(e=rt),L(this.a8.data,t,n,u,e)))},o.prototype.getStyle=function(t,n,e){var t,n,t=this.J_(t,n),n=t&&t.style;return n=n&&e&&n.clone?n.clone(!0):n},o.prototype.setStyle=function(t,n,e,i){var r,o,r=this.J_(t,n,!0,i?i[0]:ot);r&&r.style!==e?(o=r.style,r.style=e,i&&(i[0].push("style"),i[1]=o,i[2]=e),this.a8&&L(this.a8.style,t,n,o,e)):i&&(i.length=0)},o.prototype.getCellState=function(t,n){var t=this.J_(t,n);return t?t.cellState:rt},o.prototype.setCellState=function(t,n,e,i){var i,r,o=this.getCellState(t,n)||0,i=i?o|e:o&~e;0!==i?(r=this.J_(t,n,!0,ot,!0))&&(r.cellState=i):((r=this.J_(t,n))&&delete r.cellState,it(r)&&(un(this.dataTable,t,n),it(this.dataTable[t]))&&delete this.dataTable[t])},o.prototype.getValueForKey=function(t,n,e){var t=this.J_(t,n);return t&&t[e]},o.prototype.setValueForKey=function(t,n,e,i,r){var o,a,o=this.J_(t,n,!0,r?r[0]:ot);o&&o[e]!==i?(a=o[e],o[e]=i,r&&(r[0].push(e),r[1]=a,r[2]=i),this.bE(t,n,e,a,i)):r&&(r.length=0)},o.prototype.bE=function(t,n,e,i,r){var o,a=this.a8;e===$&&a&&L(a.data,t,n,i,r)},o.prototype.rE=function(t,n,e){var i,r,o,a,u,i=this,r=i.Sx,o=i.dataTable,a=i.B8;if(0<=t&&t<=r&&0<=n){if(s(o,r,t,n),s(i.rowDataArray,r,t,n),s(a,r,t,n),i.Sx+=n,!e)for(u=0;u<n;u++)o[t+u]={rs:"n"},a[t+u]={rs:"n"};this.a8&&(this.a8.data.addHeadInfo(t,n,!0),this.a8.style.addHeadInfo(t,n,!0))}},o.prototype.yE=function(t,n,e){var i,r,o,a,i=this,r=i.Sx;if(0<=t&&t<r&&0<n){if(r<t+n&&(n=r-t),e)for(o=0;o<n;o++)e.push([["dataTable",a=t+o],i.dataTable[a]]),e.push([["rowDataArray",a],i.rowDataArray[a]]),e.push([[V,a],i.B8[a]]);d(i.dataTable,r,t,n),d(i.rowDataArray,r,t,n),d(i.B8,r,t,n),i.Sx-=n,this.a8&&(this.a8.data.removeHeadInfo(t,n,!0),this.a8.style.removeHeadInfo(t,n,!0))}},o.prototype.oE=function(t,n){var e,i,r,o,a,a,e=this,i=e.Tx,r=e.B8;if(0<=t&&t<=i&&0<=n){for(o=0;o<e.Sx;o++)(a=e.dataTable[o])&&t<i&&(s(a,i,t,n),a=r[o])&&qt(a,t,n);s(e.columnDataArray,i,t,n),e.Tx+=n,this.a8&&(this.a8.data.addHeadInfo(t,n,!1),this.a8.style.addHeadInfo(t,n,!1))}},o.prototype.wE=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,i=this,r=i.Tx,o=i.B8;if(0<=t&&t<r&&0<n){for(a=0;a<i.Sx;a++)if(u=i.dataTable[a]){if(e)for(s=0;s<n;s++)e.push([["dataTable",a,c=t+s],u[c]]),i.B8[a]&&e.push([[V,a,c],i.B8[a][c]]);d(u,r,t,n),$t(f=o[a],t,n)}if(e)for(l=0;l<n;l++)e.push([["columnDataArray",h=t+l],i.columnDataArray[h]]);d(i.columnDataArray,r,t,n),i.Tx-=n=r<t+n?r-t:n,this.a8&&(this.a8.data.removeHeadInfo(t,n,!1),this.a8.style.removeHeadInfo(t,n,!1))}},o.prototype.ME=function(t,n,e,i){var r=this,o=t[n];return e&&(o=o||(t[n]={}),!i)&&n>r.I8&&(r.I8=n),o},o.prototype.CE=function(t,n,e,i){var r,o;if(t)return r=this,o=t[n],e&&(o=o||(t[n]={}),!i)&&r.x8<n&&(r.x8=n),o},o.prototype.J_=function(t,n,e,i,r){var o,a,u,s,c,a,o=this,a=o.dataTable,u=o.columnDataArray,s=o.rowDataArray,c=rt;return t<o.Sx&&n<o.Tx&&(0<=t&&0<=n?(a=o.ME(a,t,e,r),c=o.CE(a,n,e,r),i&&i.push("dataTable",t,n)):-1===t&&0<=n?(c=u[n],e&&(c=c||(u[n]={}),!r)&&o.x8<n&&(o.x8=n),i&&i.push("columnDataArray",n)):0<=t&&-1===n?(c=s[t],e&&(c=c||(s[t]={}),!r)&&o.I8<t&&(o.I8=t),i&&i.push("rowDataArray",t)):-1===t&&-1===n&&(c=o.defaultDataNode,e&&!c&&(c=o.defaultDataNode={}),i)&&i.push("defaultDataNode")),c},o.prototype.setNode=function(t,n,e){var i,r,o,a,u,i=this,r=i.dataTable,o=i.columnDataArray,a=i.rowDataArray;t<i.Sx&&n<i.Tx&&(0<=t&&0<=n?(u=(u=r[t])||(r[t]={}))[n]=e:-1===t&&0<=n?o[n]=e:-1===n&&0<=t&&(a[t]=e))},o.prototype.SE=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p;r&&(o=[],a=[]),s=(u=this).dataTable,c=u.rowDataArray,f=u.columnDataArray,l=u.B8,h=u.J_(t,n,ot,o),d=l[t]&&l[t][n],v=l[t]&&l[t].originalItem,m=u.J_(e,i,ot,a),g=l[e]&&l[e][i],p=l[e]&&l[e].originalItem,r&&(r.push([o,h]),r.push([a,m])),h?Kt(t,n,e,i,h,s,c,f,u):m&&Kt(t,n,e,i,rt,s,c,f,u),m?Kt(e,i,t,n,m,s,c,f,u):h&&Kt(e,i,t,n,rt,s,c,f,u),d?Xt(t,n,e,i,d,l,v):g&&Xt(t,n,e,i,rt,l,v),g?Xt(e,i,t,n,g,l,p):d&&Xt(e,i,t,n,rt,l,p)},o.prototype.gT=function(t){t++;for(var n=this.Sx,e=this.dataTable;0<=t&&t<n&&!e[t];)t++;return t<n?t:-1},o.prototype.pT=function(t,n){var e,i,r,e=this,i=rt,r=e.Tx;if(i=0<=t&&t<e.Sx?e.dataTable[t]:i){for(n++;0<=n&&n<r&&!i[n];)n++;if(n<r)return n}return-1},o.prototype.U8=function(t){for(var n,e,i,r,o,a,u,s,c,f,l,n=t.row,e=t.col,i=t.rowCount,r=t.colCount,o=this,a=n,u=0;u<i;u++,a++)for(s=e,c=0;c<r;c++,s++)l=void 0,(f=o.J_(a,s))&&(l=f.value,f.value=rt,o.a8)&&L(o.a8.data,a,s,l,rt)},o.prototype.TE=function(t,n,e){var e=e&&e.getFormatter(t,n);return!!ct(e)&&e},o.prototype.clear=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,u=this,s=u.Sx,c=u.Tx,f=[],l=[],m=!!a,g=[];if(0<=t&&0<=n){if(e=T(e,s-t),i=T(i,c-n),0<e&&0<i)for(v=t;v<t+e;v++)if(!o||S.Common.Uf.hD(o,v)<0)for(d=n;d<n+i;d++)m&&(p=[]),(h=u.J_(v,d,ot,p))&&(f.push(h),l.push({r:v,c:d}),m&&g.push(p),0<(1&r))&&!at(h.value)&&(b=m?{}:void 0,u.dE(v,d,{d6:h.value},b),b)&&a.push(b)}else if(0<=t&&-1===n){if(0<(e=T(e,s-t)))for(v=t;v<t+e;v++)m&&(p=[]),(h=u.J_(v,-1,ot,p))&&(f.push(h),l.push({r:v,c:d}),m)&&g.push(p)}else if(-1===t&&0<=n){if(0<(i=T(i,c-n)))for(d=n;d<n+i;d++)m&&(p=[]),(h=u.J_(-1,d,ot,p))&&(f.push(h),l.push({r:v,c:d}),m)&&g.push(p)}else-1===t&&-1===n&&(m&&(p=[]),h=u.J_(-1,-1,ot,p))&&(f.push(h),l.push({r:v,c:d}),m)&&g.push(p);for(u.a8&&(w=u.a8.style,y=u.a8.data),M=function(e){var t;(h=f[e])&&(t=m?[]:ot,0<(8&r)&&(t&&t.push(["tag",h.tag]),h.tag=rt),0<(2&r)&&(t&&t.push(["style",h.style]),w&&L(w,l[e].r,l[e].c,h.style,rt),h.style=rt),0<(1&r)&&(t&&t.push(["value",h.value]),y&&L(y,l[e].r,l[e].c,h.value,rt),h.value=rt),0<(16&r)&&(t&&t.push(["sparkline",h.sparkline]),h.sparkline=rt),0<(64&r)&&(t&&t.push(["bindingPath",h.bindingPath]),y&&L(y,l[e].r,l[e].c,h.bindingPath,rt),h.bindingPath=rt),0<(256&r)&&(t&&t.push(["hyperlink",h.hyperlink]),h.hyperlink=rt),0<(4&r)&&(t&&t.push(["comment",h.comment]),h.comment=rt),0<(512&r)&&(t&&t.push(["altText",h.altText]),h.altText=rt),m)&&t.forEach(function(t){var n=[].concat(g[e]);n.push(t[0]),t[0]=n,a.push(t)})},C=0;C<f.length;C++)M(C)},o.prototype.toJSON=function(t,l,h){var d,n,e,i,r,o,a,u,s,c,f,v,m,g,p,b,w,y,M,C,S,T,A,I,t;function x(t,n,e,i,r,o){var a,u,s,c,o,f,t,n,c,s,o,i;return e&&(u=!(a={}),s=e.value,at(s)||(a.value=s,u=!0),l&&l.saveAsView&&(c=void 0,o?c=o:d&&(c=h&&h.getFormatter(t,n)),c)&&ct(c)&&(o=h.Oe(t,n,i,c,s),at(o)||(a.value=o,u=!0)),(f=l&&l.ignoreStyle)||(t=e.style)&&!it(t)&&("string"==typeof t?(a.style=t,u=!0):(n=t.toJSON(i,r))&&(n.name=ot,n.fontForColumnWidth=t.fontForColumnWidth,a.style=n,u=!0)),c=e.bindingPath,at(c)||(a.bindingPath=c,u=!0),s=e.tag,at(s)||(a.tag=s,u=!0),o=e.altText,at(o)||(a.altText=o,u=!0),i=e.hyperlink,at(i)||(a.hyperlink=ut(i),delete a.hyperlink.isVisited,u=!0),!0===u)?a:rt}if(d=h&&h.parent&&!it(h.parent.bp),e={},i={},r=(n=this).Sx,o=n.Tx,a=n.dataTable,u=n.rowDataArray,s=n.columnDataArray,l&&l.saveAsView)for(v=0,m=3===t&&d;v<r;){if((g=a[v])||m){for(b=!(p={}),w=0;w<o;)y=void 0,g&&g[w]?y=x(v,w,g[w]):m&&(M=this.TE(v,w,h))&&(g=g||n.ME(a,v,!0),y=x(v,w,n.CE(g,w,!0),3,!1,M)),at(y)||(p[w]=y,b=!0),w++;b&&(i[v]=p)}v++}else for(c=n.gT(-1);0<=c;){for(b=!(p={}),f=n.pT(c,-1);0<=f;)(C=n.J_(c,f))&&(y=x(c,f,C),it(y)||(p[f]=y,b=!0)),f=n.pT(c,f);b&&(i[c]=p),c=n.gT(c)}for(it(i)||(e.dataTable=i),S=[],c=0;c<r;c++)N(u,c)&&u[c]&&(T=x(c,-1,u[c]),it(T)||(S[c]=T));for(0<S.length&&(e.rowDataArray=S),A=[],f=0;f<o;f++)N(s,f)&&s[f]&&(I=x(-1,f,s[f]),it(I)||(A[f]=I));return 0<A.length&&(e.columnDataArray=A),t=x(-1,-1,n.defaultDataNode,t,!0),it(t)||(e.defaultDataNode=t),e},o.prototype.fromJSON=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,o,u=e&&e.incrementalLoading;if(t){if((s=this).Hc(),s.lE++,c=t.dataTable,h=s.Sx,d=s.Tx,c?u&&3===o?Zt(s,c,h,d,e,n,ot,a,s.a8,i,r):Wt(s,c,h,d,e,n,s.a8,i,r):u&&a&&setTimeout(a,0),g=t.rowDataArray||t.AE)for(f=0;f<h;f++)N(g,f)&&g[f]&&nn(g[f],s.J_(f,-1,!0),n,f,-1,e,s.a8);if(p=t.columnDataArray||t.IE)for(l=0;l<d;l++)N(p,l)&&p[l]&&nn(p[l],s.J_(-1,l,!0),n,-1,l,e,s.a8);(o=t.defaultDataNode||t.xE)&&nn(o,s.J_(-1,-1,!0),n,-1,-1,e,s.a8),s.lE--}else u&&a&&setTimeout(a,0)},o.prototype.wh=function(t,L,n,B,e,i){var r,F,P,G,U,H,V,o,z,a,Y,u,i,a,s,i,c,Z,f,l,h,d,v,m,g,m,W,p,b,w,y,y,M,C,S,T,A,I,x,N,k,_,D,j,E,O,Q,J,K,X,E,R,q,$,y,r=this,F=0,P=0,G=r.Sx,U=r.Tx,H=r.dataTable,V=[],o=i&&!1===i.includeStyles,z=i&&i.saveAsView,a=i&&!1===i.includeEmptyRegionCells,Y=t&&t.parent&&!it(t.parent.bp),u=i&&i.fileType===et.OpenSaveFileType.excel;for(a&&(i=et.UsedRangeType.all-et.UsedRangeType.colStyle-et.UsedRangeType.rowStyle-et.UsedRangeType.style-et.UsedRangeType.axis,a=t.getUsedRange(i))&&(F=a.row,P=a.col,G=a.row+a.rowCount,U=a.col+a.colCount),i={sheetData:s={n_:st.XFileConstants.bo,rowCount:r.Sx,colCount:r.Tx},hyperlinks:V},c=!t.NMi&&t.getDefaultStyle(3),Object.keys(L).forEach(function(t){var n,e,i,n,t,n=L[t],e=n&&n.size,i=!at(e)&&e!==B,n=n&&!1===n.visible?1:ot;!0!=i&&!n||((t=s[t]={}).h=i&&e!==ot?+nt.SJSColumnWidthHelper.pixelToPoint(e).toFixed(2):ot,t.v=n)}),Z=u?t.Ut.yle().gle():{},f=F;f<G;f++){if(l=s[f]||{r:f+1},h=H[f],d=Z[f],v=void 0,g=(m=r.J_(f,-1))&&m.style,at(g)||o||(u?("string"==typeof g&&0===g.indexOf(n.Jd)&&(m=g,g=(g=t.i3(m,!1))||(W=t.parent)&&W.i3(m,!1)),l.s=n.getStyleIndex(g)):"string"==typeof g?l.t=n.getOriginNamedStyleIndex(g):g!==ot&&(l.e=n.getOriginStyleIndex(g)),v=!0),h||d){for(p=P;p<U;p++){if(w={},!(b=h&&h[p])){if(!d||!d[p])continue;b=d[p]}if(at(b.tag)||(w.tag=b.tag),at(b.altText)||(w.altText=b.altText),y=b.bindingPath,at(y)||(w.bindingPath=y),y=r.getStyle(-1,p,!0),M=rt,k=b.value,_=r.getStyle(f,p,!(N=x=I=A=T=S=C=void 0)),D=b.hyperlink,at(k)&&d&&d[p]&&(k=d[p].value),j=!1,z&&(!(E=r.TE(f,p,t))&&Y&&(E=t.getFormatter(f,p)),ct(E))&&(O=t.Oe(f,p,3,E,k),!at(O))){switch(Q=typeof O){case"boolean":T=O?1:0;break;case"string":N=K=(J=Bt(O,e)).OADateNumber,C=X=J.valueIndex;break;case"object":C=O instanceof Date?(O=nt.util.Z0(O),_.formatter="M/d/yyyy",e.getTextIndex(O)):O;break;default:S=isFinite(O)?O:ot}j=!0}if(!o)if(u){if(E=D||"string"==typeof k&&"/OADate"===k.substring(0,7)||k!==rt&&void 0!==k&&(y||g),_?M=bn(t,_):E&&(M=new tt.Style),M){if(M.parentName)for((R=bn(t,M.parentName))&&wn(t,M,R);R&&R.parentName;)(R=bn(t,R.parentName))&&wn(t,M,R);g&&wn(t,M,g),y&&wn(t,M,y),c&&wn(t,M,c),M=gn(k,M)}}else"string"==typeof _?I=n.getOriginNamedStyleIndex(_):_!==ot&&(x=n.getOriginStyleIndex(_));if(at(k)&&(I===ot&&x===ot&&at(M)||o)&&at(D))it(w)||(l[p]={lossless:w},v=!0);else{if(v=!0,!j&&!at(k))switch(q=typeof k){case"boolean":T=k?1:0;break;case"string":N=K=($=Bt(k,e)).OADateNumber,C=X=$.valueIndex;break;case"object":C=k&&k.richText?e.getTextIndex(k):k&&k instanceof Date?e.getTextIndex(k.toISOString()):at(k._error)&&at(k._code)?k:{error:k._error,code:k._code};break;default:S=isFinite(k)?k:ot}at(D)||(u&&(M?"string"==typeof M&&(M=t.u8(M)):M=new tt.Style,at(D.linkColor)?D.linkColor===ot&&M.foreColor||(M.foreColor="hyperlink"):M.foreColor=D.linkColor,D.drawUnderline&&at(M.textDecoration)?M.textDecoration=1:2!==M.textDecoration&&4!==M.textDecoration||(M.textDecoration+=1)),V.push({row:f,col:p,value:b.value,hyperlink:ut(D)})),y={s:A=M?n.getStyleIndex(M,3,t.name()):A,v:C,n:S,b:T,t:I,e:x,o:N},it(w)||(y.lossless=w),l[p]=y}}}v&&(s[f]=l)}return i},o.prototype.yh=function(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,c=this,f={};if(n)for(l=n.colCount,h=0;h<l;h++)(d=c.J_(-1,h))&&d.style&&(f[h]=1);Qt(this,t,n,e,i,r,o,a,u,s,f)},yt=o,a.prototype.NE=function(t,n){var e,i,e=this.infos,i=e[t];return i=!i&&n?e[t]={}:i},a.prototype.kE=function(t,n){var e=this.infos,i=e.length;0<=t&&t<=i&&0<n&&s(e,i,t,n)},a.prototype.DE=function(t,n,e){var i,r,o,a,i=this.infos,r=i.length;if(0<=t&&t<r&&0<n){if(n=T(n,r-t),e)for(o=0;o<n;o++)e.push([["infos",a=t+o],i[a]]);d(i,r,t,n)}},a.prototype._E=function(){return this.infos.length},a.prototype.EE=function(){return this.infos},a.prototype.q_=function(t){return this.infos[t]},a.prototype.X_=function(t,n,e){var i=this.infos[t];this.infos[t]=n,e&&(e[0].push("infos",t),e[1]=i,e[2]=n)},a.prototype.getSize=function(t){var t=this.infos[t],n=rt;return t&&(!1===t.visible?n=0:jt(t.size)&&(n=H(t.size))),n},a.prototype.getColumnHeaderFitMode=function(t){var t=this.infos[t],n=et.ColumnHeaderFitMode.normal;return n=t?t.columnHeaderFitMode||n:n},a.prototype.setColumnHeaderFitMode=function(t,n,e){var i,r,i=this.NE(t,!0),r=i.columnHeaderFitMode;r!==n&&(i.columnHeaderFitMode=n),e&&(e[0].push("infos",t,"columnHeaderFitMode"),e[1]=r)},a.prototype.getActualSize=function(t){var t=this.infos[t];return t?H(t.size):rt},a.prototype.setSize=function(t,n,e){var i,r,i=this.NE(t,!0),r=i.size;r!==n&&(i.size=n),e&&(e[0].push("infos",t,"size"),e[1]=r,e[2]=n)},a.prototype.getStarSize=function(t){var t=this.infos[t];return t?t.starSize:ot},a.prototype.setStarSize=function(t,n,e){var i,r,i=this.NE(t,!0),r=i.starSize;at(n)&&at(r)||(r!==n&&(at(n)?delete i.starSize:i.starSize=n),e&&(e[0].push("infos",t,"starSize"),e[1]=r,e[2]=n))},a.prototype.getScrollOffsetX=function(t){var t,n,t=this.q_(t),n=0;return n=t&&jt(t.scrollOffsetX)?t.scrollOffsetX:n},a.prototype.setScrollOffsetX=function(t,n,e){var t=this.NE(t,!0);e&&(n+=t.scrollOffsetX||0),t.scrollOffsetX=n},a.prototype.getScrollContentWidth=function(t){var n,t,e,n=this.q_(t),t=this.getSize(t),e=t;return n&&jt(n.scrollContentWidth)&&(e=n.scrollContentWidth),g(e,t)},a.prototype.setScrollContentWidth=function(t,n){var e,t,e=this.NE(t,!0),t=this.getSize(t);e.scrollContentWidth=n=n<t?t:n},a.prototype.getHiddenRows=function(){return this.R8},a.prototype.wh=function(t){return this.infos},a.prototype.yh=function(t,n){var e,i,r,o,a,u,s,e=this,i=t;if(i)for(r=t.rowCount,o=0;o<r;o++)(a=i[o])&&(s=u=void 0,a.h!==ot&&(u=Math.round(nt.SJSColumnWidthHelper.pointToPixel(a.h))),a.v&&(at(a.l)||0===a.l)&&(s=!1,e.R8.push(o)),at(u=!1===s&&0===u?ot:u)||e.setSize(+o,u),at(s)||e.setVisible(+o,s))},a.prototype.toJSON=function(t){var n,e,i,r,o,r,r,a,r,a,n=this.infos,e=[];if(t&&t.ignoreStarSize)for(i=0;i<n.length;i++)at(n[i])||(o=(r=n[i]).cellType,r=k(r,["cellType"]),e[i]=ut(r),o&&(o.toJSON&&(o=o.toJSON()),r=E.ti,a=o.typeName,r=r[o.type]||r[a]||j.getTypeFromString(a))&&((a=new r).fromJSON(o,t),e[i].cellType=a),delete e[i].starSize);else for(i=0;i<n.length;i++)at(n[i])||(e[i]=n[i]);return 0<e.length?e:ot},a.prototype.fromJSON=function(t){t&&(this.infos=t)},Mt=(f=a).prototype,O({visible:!0,resizable:!0,pageBreak:!1},function(o,e){var t=o[0].toUpperCase()+o.substr(1);Mt["get"+t]=function(t){var n,t,n=e,t=this.infos[t];return n=t&&!at(t[o])?t[o]:n},Mt["set"+t]=function(t,n,e){var i,r,i=this.NE(t,!0),r=i[o];r!==n&&(i[o]=n),e&&(e[0].push("infos",t,o),e[1]=r,e[2]=n)}}),St=62,Tt=40,m.DEFAULT_COL_HEADER_ROW_HEIGHT=Ct=20,x.prototype.getUsedRange=function(t){var n=this,e={};return v(e,n.ZE(t)),v(e,n.sheetModels[3].hE(t)),v(e,n.defaultValueModels[3].hE(t)),v(e,n.WE(t)),v(e,n.QE(t)),e},x.prototype.ZE=function(t){var n,e,t,i,r,o,a;if(t&et.UsedRangeType.span&&(t=(e=(n=this).spanModels[et.SheetArea.viewport]).spans,!at(t))&&0<t.length){for(i={},r=0,o=t;r<o.length;r++)a=o[r],v(i,ft(a));return i}},x.prototype.WE=function(t){var n,e,t,i,r,n,t,o,a,u,s,c,f,l,h,n=!(t&et.UsedRangeType.axis);if(t&et.UsedRangeType.data||!n){if(e=n?function(t){return!at(t)&&!at(t.name)}:function(t){return!at(t)},i=(t=this).colInfos[3].infos,n=(r=t.Mf).getRowCount(),t={},0<(a=(o=Object.keys(i)).length)){for(c=0,f=o;c<f.length;c++)if(e(i[l=f[c]])){u=+l;break}for(h=a-1;0<=h;h--)if(e(i[o[h]])){s=+o[h];break}at(u)||at(s)||v(t,{minRow:0,minCol:u,maxRow:n=0<n?n-1:n,maxCol:s})}return t}},x.prototype.QE=function(t){var t,n,e,t,i,r,o,a,u,s,c,f,l;if(t&et.UsedRangeType.axis){if(n=(t=this).rowInfos[3].infos,t=(e=t.Mf).getColumnCount(),i={},0<(u=(a=Object.keys(n)).length)){for(s=0,c=a;s<c.length;s++)if(f=c[s],!at(n[f])){r=+f;break}for(l=u-1;0<=l;l--)if(!at(n[a[l]])){o=+a[l];break}at(r)||at(o)||v(i,{minRow:r,minCol:0,maxRow:o,maxCol:t=0<t?t-1:t})}return i}},x.prototype.KE=function(t,n,e,i,r){var r;3!==e||t<0||n<0||!this.Mf||this.Mf.hasFormula===ot||dn(r=this.W_(3).J_(t,n,!!r),i,this.Mf.hasFormula(t,n,e),r&&r.style,this.F8,this.Mf.parent)},x.prototype.JE=function(t,n,e){var e;3!==e||t<0||n<0||(e=this.W_(3).J_(t,n))&&ln(e)},x.prototype.V8=function(t,n){var e=this;e.L8({type:et.AxisInfoChangeType.setRowCount,count:t}),e.L8({type:et.AxisInfoChangeType.setColumnCount,count:n})},x.prototype.L8=function(t){var n,e,i,r,r,o,a,u,s,c,f,l,h,d,n=this,e=n.Mf,i=t.type,r=t.sheetArea,r=void 0===r?et.SheetArea.viewport:r;if(r===et.SheetArea.viewport)if(at(n.XE)&&(n.XE=[]),at(n.qE)&&(n.qE=[]),n.$E)n.tj(t);else switch(o=n.XE,a=n.qE,i){case et.AxisInfoChangeType.deleteRows:u=t.index,s=t.count,o.splice(u,s);break;case et.AxisInfoChangeType.deleteColumns:u=t.index,s=t.count,a.splice(u,s);break;case et.AxisInfoChangeType.setRowHeight:case et.AxisInfoChangeType.setRowVisible:u=t.index,c=t.value,o[u]=c;break;case et.AxisInfoChangeType.setColumnWidth:case et.AxisInfoChangeType.setColumnVisible:u=t.index,c=t.value,a[u]=c;break;case et.AxisInfoChangeType.filterRows:for(l=0,h=f=t.index;l<h.length;l++)u=h[l],c=e.getRowHeight(u),o[u]=c;break;case et.AxisInfoChangeType.outlineExpandRows:for(f=t.index,d=0;d<f.length;d++)u=f[d],c=e.getRowHeight(u),o[u]=c;break;case et.AxisInfoChangeType.outlineExpandColumns:for(f=t.index,d=0;d<f.length;d++)u=f[d],c=e.getColumnWidth(u),a[u]=c}},x.prototype.nj=function(t){var t;if(this.XE)return t=this.XE[t],at(t)?this.defaults.rowHeight:t},x.prototype.ej=function(t){var t;if(this.qE)return t=this.qE[t],at(t)?this.defaults.colWidth:t},x.prototype.v8=function(){this.$E=[]},x.prototype.A8=function(){var t,n,e,i,r,t=this,n=t.$E;if(t.$E=rt,n)for(e=0,i=n;e<i.length;e++)r=i[e],t.L8(r)},x.prototype.tj=function(t){this.$E&&this.$E.push(t)},x.prototype.m8=function(){var t=this;t.XE=rt,t.qE=rt},x.prototype.ij=function(){this.F8=rt},x.prototype.L0=function(t){var n;!1!==t&&((n=this).Mf=rt,n.sheetModels=rt,n.defaultValueModels&&(n.defaultValueModels.forEach(function(t){null!=t&&t.dispose()}),n.defaultValueModels=rt),n.m8(),n.ij()),x.et(this,"dispose",{clearCache:t})},x.prototype.addRows=function(t,n,e,i,r){var o,a;void 0===r&&(r=et.SheetArea.viewport),0<(o=this).P8&&o.G8.push(a={row:t,rowCount:n,type:"addRows",sheetArea:r}),1===r?(o.W_(1).rE(t,n,i),o.yle(1).rE(t,n),o.K_(1).rE(t,n),o.Q_(!0,1).kE(t,n)):(o.W_(3).rE(t,n,i),o.W_(2).rE(t,n,i),o.yle(3).rE(t,n),o.yle(2).rE(t,n),o.K_(3).rE(t,n),o.K_(2).rE(t,n),o.Q_(!0,3).kE(t,n),!i&&R&&o.Mf.Uw(3).t8.rE(t,n)),e||x.et(o,"addRows",{row:t,rowCount:n,sheetArea:r,changes:o.G8}),o.L8({type:et.AxisInfoChangeType.addRows,index:t,count:n,sheetArea:r})},x.prototype.rj=function(t,n){var e,i,r,t,e=this,i=t.row,r=t.rowCount,t=t.sheetArea;n?e.addRows(i,r,!0,!n,t):e.deleteRows(i,r,!0,t),x.et(e,"undoAddRows",{row:i,rowCount:r,sheetArea:t})},x.prototype.deleteRows=function(t,n,e,i){var r,o,a,u,s,c,f,l,h,d,v,m,o=(i=void 0===i?et.SheetArea.viewport:i)===et.SheetArea.colHeader;if(0<(r=this).P8&&(u=[],s=[],c=o?[]:[["spanModels",3],ot],f=o?[]:[["spanModels",2],ot],l=[],h=[],a={row:t,rowCount:n,type:"deleteRows",sheetArea:i}),o?(r.W_(1).yE(t,n),r.yle(1).yE(t,n),r.K_(1).aE(t,n),r.Q_(!0,1).DE(t,n)):(R&&r.Mf.Uw(3).t8.aE(t,n,!0),r.W_(3).yE(t,n,u),r.W_(2).yE(t,n,s),r.yle(3).yE(t,n,h),r.yle(2).yE(t,n),r.K_(3).aE(t,n,c),r.K_(2).aE(t,n,f),r.Q_(!0,3).DE(t,n,l)),e||x.et(r,"deleteRows",{row:t,rowCount:n,changes:r.G8,sheetArea:i}),a){for(r.G8.push(a),d=a.changes=[],v=[w,3],m=0;m<u.length;m++)u[m][0]=v.concat(u[m][0]),d.push(u[m]);for(v=[w,2],m=0;m<s.length;m++)s[m][0]=v.concat(s[m][0]),d.push(s[m]);for(0<c.length&&d.push(c),0<f.length&&d.push(f),v=[p,3],m=0;m<l.length;m++)l[m][0]=v.concat(l[m][0]),d.push(l[m]);for(v=[y,3],m=0;m<h.length;m++)h[m][0]=v.concat(h[m][0]),d.push(h[m])}r.L8({type:et.AxisInfoChangeType.deleteRows,index:t,count:n,sheetArea:i})},x.prototype.oj=function(t,n){var e,i,r,o,a,u,n,e=this,i=t.row,r=t.rowCount,o=t.sheetArea;if(n)e.deleteRows(i,r,!0,o);else{for(e.addRows(i,r,!0,!0,o),u=(a=t.changes).length-1;0<=u;u--)en(e,a[u]);R&&e.Mf.Uw(3).t8.Eme(i,r)}(n=e.Mf&&e.Mf.aj)&&n.splice(n.length-r,r)},x.prototype.addColumns=function(t,n,e,i,r){var o,a;void 0===i&&(i=et.SheetArea.viewport),0<(o=this).P8&&o.G8.push(a={col:t,colCount:n,type:"addColumns",sheetArea:i}),2===i?(o.W_(2).oE(t,n),o.yle(2).oE(t,n),o.K_(2).oE(t,n),o.Q_(!1,2).kE(t,n)):(o.W_(3).oE(t,n),o.W_(1).oE(t,n),o.yle(3).oE(t,n),o.yle(1).oE(t,n),o.K_(3).oE(t,n),o.K_(1).oE(t,n),o.Q_(!1,3).kE(t,n),!r&&R&&o.Mf.Uw(3).t8.oE(t,n)),e||x.et(o,"addColumns",{col:t,colCount:n,changes:o.G8,sheetArea:i}),o.L8({type:et.AxisInfoChangeType.addColumns,index:t,count:n,sheetArea:i})},x.prototype.uj=function(t,n){var e,i,r,t,e=this,i=t.col,r=t.colCount,t=t.sheetArea;n?e.addColumns(i,r,!0,t):e.deleteColumns(i,r,!0,t)},x.prototype.deleteColumns=function(t,n,e,i){var r,o,a,u,s,c,f,l,h,d,v,m,o=(i=void 0===i?et.SheetArea.viewport:i)===et.SheetArea.rowHeader;if(0<(r=this).P8&&(u=[],s=[],c=o?[]:[["spanModels",3],ot],f=o?[]:[["spanModels",1],ot],l=[],h=[],a={col:t,colCount:n,type:"deleteColumns",sheetArea:i}),o?(r.W_(2).wE(t,n),r.yle(2).wE(t,n),r.K_(2).uE(t,n),r.Q_(!1,2).DE(t,n)):(R&&r.Mf.Uw(3).t8.uE(t,n,!0),r.W_(3).wE(t,n,u),r.W_(1).wE(t,n,s),r.yle(3).wE(t,n,h),r.yle(1).wE(t,n),r.K_(3).uE(t,n,c),r.K_(1).uE(t,n,f),r.Q_(!1,3).DE(t,n,l)),e||x.et(r,"deleteColumns",{col:t,colCount:n,changes:r.G8,sheetArea:i}),a){for(r.G8.push(a),d=a.changes=[],v=[w,3],m=0;m<u.length;m++)u[m][0]=v.concat(u[m][0]),d.push(u[m]);for(v=[w,1],m=0;m<s.length;m++)s[m][0]=v.concat(s[m][0]),d.push(s[m]);for(0<c.length&&d.push(c),0<f.length&&d.push(f),v=[b,3],m=0;m<l.length;m++)l[m][0]=v.concat(l[m][0]),d.push(l[m]);for(v=[y,3],m=0;m<h.length;m++)h[m][0]=v.concat(h[m][0]),d.push(h[m])}r.L8({type:et.AxisInfoChangeType.deleteColumns,index:t,count:n,sheetArea:i})},x.prototype.sj=function(t,n){var e,i,r,o,a,u,e=this,i=t.col,r=t.colCount,o=t.sheetArea;if(n)e.deleteColumns(i,r,!0,o);else{for(e.addColumns(i,r,!0,o,!0),u=(a=t.changes).length-1;0<=u;u--)en(e,a[u]);R&&e.Mf.Uw().t8.Ome(i,r)}},x.prototype.getRowCount=function(t){return this.W_(t).getRowCount()},x.prototype.setRowCount=function(t,n,e){var i,r,i=this,r=i.getRowCount(n);0<i.P8&&i.G8.push({oldRowCount:r,sheetArea:n,type:"setRowCount"}),3===n||2===n?(t<r&&i.deleteRows(t,r-t,e),i.W_(3).setRowCount(t),i.W_(2).setRowCount(t),i.yle(3).setRowCount(t),i.Mf.ki(nt.Events.WorksheetDataChanged,{type:"count"})):1===n&&(t<r&&i.Q_(!0,n).DE(t,r-t),i.W_(n).setRowCount(t)),i.L8({type:et.AxisInfoChangeType.setRowCount,count:t,sheetArea:n})},x.prototype.cj=function(t){var n=this;n.W_(3).setRowCount(t),n.W_(2).setRowCount(t),n.yle(3).setRowCount(t),n.L8({type:et.AxisInfoChangeType.setRowCount,count:t,sheetArea:3})},x.prototype.fj=function(t,n){n?this.setRowCount(t.rowCount,t.sheetArea,!0):this.setRowCount(t.oldRowCount,t.sheetArea,!0)},x.prototype.getColumnCount=function(t){return this.W_(t).getColumnCount()},x.prototype.setColumnCount=function(t,n,e){var i,r,i=this,r=i.getColumnCount(n);0<i.P8&&i.G8.push({oldColCount:r,sheetArea:n,type:"setColumnCount"}),3===n||1===n?(t<r&&i.deleteColumns(t,r-t,e),i.W_(3).setColumnCount(t),i.W_(1).setColumnCount(t),i.yle(3).setColumnCount(t),i.Mf.ki(nt.Events.WorksheetDataChanged,{type:"count"})):2===n&&(t<r&&i.Q_(!1,n).DE(t,r-t),i.W_(n).setColumnCount(t)),i.L8({type:et.AxisInfoChangeType.setColumnCount,count:t,sheetArea:n})},x.prototype.lj=function(t,n){n?this.setColumnCount(t.colCount,t.sheetArea,!0):this.setColumnCount(t.oldColCount,t.sheetArea,!0)},x.prototype.getLastNonNullRow=function(t,n){var n=n?0:this.Q_(!0,t)._E()-1;return g(this.W_(t).I8,this.K_(t).I8,this.yle(t).I8,n)},x.prototype.getLastNonNullCol=function(t,n){var n=n?0:this.Q_(!1,t)._E()-1;return g(this.W_(t).x8,this.K_(t).x8,this.yle(t).x8,n)},x.prototype.getFreeAreaRowCount=function(t){var t=this.W_(t);return t&&t.getFreeAreaRowCount()},x.prototype.getFreeAreaColumnCount=function(t){var t=this.W_(t);return t&&t.getFreeAreaColumnCount()},x.prototype.setFreeAreaRowCount=function(t,n){this.W_(n).setFreeAreaRowCount(t)},x.prototype.setFreeAreaColumnCount=function(t,n){this.W_(n).setFreeAreaColumnCount(t)},x.prototype.hj=function(){var t,u,n,t;function e(t,n){for(var e,i,r,o,a,e=n.length,i=0;i<e;i++)r=n[i][0],o=n[i][1],(a=n[i][2])!==o&&(t?u.dj(r,3,"height",o,a):u.vj(r,3,"width",o,a))}n=0!==(u=(t=this).Mf).ot().height&&t.mj(!0,u.defaults.rowHeight),t=0!==u.ot().width&&t.mj(!1,u.defaults.colWidth),n&&e(!0,n),t&&e(!1,t)},x.prototype.mj=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,f,T,A,A,e=this,i=e.Mf,r=[],o=i.zoom(),a=t?i.getRowCount():i.getColumnCount(),u=e.Q_(t,3),s=0,f=0;if(i.gj&&(f=t?i.gj().height:i.gj().width),t){if(i.options.colHeaderVisible)for(l=0;l<i.getRowCount(1);l++)s+=I(o*i.getRowHeight(l,1));c=i.ot().height-i.options.sheetAreaOffset.top-f-s}else{if(i.options.rowHeaderVisible)for(l=0;l<i.getColumnCount(2);l++)s+=I(o*i.getColumnWidth(l,2));c=i.ot().width-i.options.sheetAreaOffset.left-f-s}for(h=[],d=[],v=[],g=t?i.getRowVisible:i.getColumnVisible,l=m=0;l<a;l++)if(p=g.call(i,l),b=i.Ut.getSize(t,3,l),w=i.Ut.getStarSize(t,3,l),G.test(w))y="*"===w?1:parseFloat(w.replace("*","")),p&&0<y?(m+=y,h.push(l),d.push(y),v.push(b)):r.push([l,0,b]);else if(b=jt(b)?Math.floor(b):n,p&&(c-=I(o*b))<1)return;if(!(m+r.length===0||c<1)){for(M=h.length,l=0;l<M-1;l++)if(b=H((C=c/m/o)*(y=d[l])),S=I(o*b),r.push([h[l],b,v[l]]),c-=S,m-=y,S<1||c<1)return;for(f=I((c-1e-4)/o),r.push([h[M-1],f,v[M-1]]),l=0;l<r.length;l++)T=r[l][0],A=r[l][1],u.setSize(T,A),A=t?et.AxisInfoChangeType.setRowHeight:et.AxisInfoChangeType.setColumnWidth,e.L8({type:A,index:T});return r}},x.prototype.setCellState=function(t,n,e,i,r){var r=this.W_(r);r&&r.setCellState(t,n,e,i)},x.prototype.toJSON=function(t){var n,e,i,r,i,t,o,n=this,e={},i=n.Mf;return e.data=n.W_(3).toJSON(3,t,n.Mf),e.rowHeaderData=n.W_(2).toJSON(2,t),e.colHeaderData=n.W_(1).toJSON(1,t),e.rows=n.Q_(!0,3).toJSON(t),e.columns=n.Q_(!1,3).toJSON(t),e.rowHeaderColInfos=n.Q_(!1,2).toJSON(t),e.colHeaderRowInfos=n.Q_(!0,1).toJSON(t),e.defaultData=n.yle(3).toJSON(),i.filterRowsVisibleInfo&&!i.filterRowsVisibleInfo.empty&&n.updateToJsonRowInfo(i.filterRowsVisibleInfo.rowsVisibleInfo,e,i),e.leftCellIndex=i.getViewportLeftColumn(1),e.topCellIndex=i.getViewportTopRow(1),(r=t&&t.ignoreStyle)||(e.spans=sn(n.K_(3).toJSON()),e.rowHeaderSpan=sn(n.K_(2).toJSON()),e.colHeaderSpan=sn(n.K_(1).toJSON())),e.selections=n.selectionModel.toJSON(),(o=20===(t={colHeaderRowHeight:(i=n.defaults).colHeaderRowHeight,colWidth:i.colWidth,rowHeaderColWidth:i.rowHeaderColWidth,rowHeight:i.rowHeight,_isExcelDefaultColumnWidth:i._isExcelDefaultColumnWidth}).rowHeight&&62===t.colWidth&&40===t.rowHeaderColWidth&&t.colHeaderRowHeight===m.DEFAULT_COL_HEADER_ROW_HEIGHT)||(e.defaults=t),e},x.prototype.updateToJsonRowInfo=function(t,n,e){var i,r,o,a;for(at(n.rows)&&(n.rows=[]),i=n.rows,r=e.getRowCount(),o=0;o<r;o++)(a=!1===t[o])&&(at(i[o])?i[o]={}:i[o]=l({},i[o]),i[o].visible=!1,i[o].isFilter=!0)},x.prototype.fromJSON=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,i,r,o=this,a=o.F8;if(o.W_(3).fromJSON(t.data,n,e,a,i,3,r),o.W_(2).fromJSON(t.rowHeaderData,n,e,a),o.W_(1).fromJSON(t.colHeaderData,n,e,a),o.Mf.showCell(t.topCellIndex||0,t.leftCellIndex||0,et.VerticalPosition.top,et.HorizontalPosition.left),o.Q_(!0,3).fromJSON(t.rows),o.Q_(!1,3).fromJSON(t.columns),o.Q_(!1,2).fromJSON(t.rowHeaderColInfos),o.Q_(!0,1).fromJSON(t.colHeaderRowInfos),o.yle(3).fromJSON(t.defaultData),t&&t.rows)for(s=0,c=u=Object.keys(t.rows);s<c.length;s++)f=c[s],l=t.rows[f],at(l)||o.L8({type:et.AxisInfoChangeType.setRowHeight,index:+f});if(t&&t.columns)for(h=0,d=u=Object.keys(t.columns);h<d.length;h++)f=d[h],l=t.columns[f],at(l)||o.L8({type:et.AxisInfoChangeType.setColumnWidth,index:+f});(v=e&&e.ignoreStyle)||(o.K_(3).fromJSON(t.spans,o.getRowCount(),o.getColumnCount()),o.K_(2).fromJSON(t.rowHeaderSpan),o.K_(1).fromJSON(t.colHeaderSpan)),o.selectionModel.fromJSON(t.selections,t.rowCount,t.columnCount),o.Rue(t.tag),(i=t.defaults)!==ot&&((r=o.defaults).colHeaderRowHeight=M(i.colHeaderRowHeight,m.DEFAULT_COL_HEADER_ROW_HEIGHT),r.colWidth=M(i.colWidth,62),r.rowHeaderColWidth=M(i.rowHeaderColWidth,40),r.rowHeight=M(i.rowHeight,20),r._isExcelDefaultColumnWidth=i._isExcelDefaultColumnWidth)},x.prototype.Rue=function(t){var n,e,e,e;t!==ot&&(n=this,typeof(e=t.typeName)===U&&(e=j.getTypeFromString(e))&&((e=new e).fromJSON&&e.fromJSON(t),t=e),n.do("setValueForKey",-1,-1,"tag",t,3))},x.prototype.wh=function(t,n,e){var i,r,o,t,r,n,t,a,u,s,t,c,f,l,h,e,e,d,o,i,v,i=this,r=i.defaults.rowHeight,o=i.Q_(!0,3).wh(e),t=i.W_(3).wh(i.Mf,o,t,r,n,e),r=t.sheetData,n=t.hyperlinks,t={};return e&&(t.saveAsView=e.saveAsView,t.ignoreStyle=!1===e.includeStyles),a=i.W_(2).toJSON(2,t),u=i.W_(1).toJSON(1,t),s=i.Q_(!1,2).toJSON(t),t=i.Q_(!0,1).toJSON(t),c=i.yle(3).wh(e),f=i.getValueForKey(-1,-1,"tag",3),e&&!1===e.includeStyles||(l=sn(i.K_(2).toJSON()),h=sn(i.K_(1).toJSON())),e={colHeaderRowHeight:(e=i.defaults).colHeaderRowHeight,rowHeaderColWidth:e.rowHeaderColWidth},d=[],o.forEach(function(t,n){t&&t.starSize&&(d[n]={starSize:t.starSize})}),o=i.selectionModel.selectionPolicy,i=i.selectionModel.selectionUnit,v=40===e.rowHeaderColWidth&&e.colHeaderRowHeight===m.DEFAULT_COL_HEADER_ROW_HEIGHT,{sheetData:r,hyperlinks:n,rowHeaderData:a,colHeaderData:u,rowHeaderColInfos:s,colHeaderRowInfos:t,rowHeaderSpan:l,colHeaderSpan:h,rowInfos:d,defaultData:c,tag:f,defaults:v?void 0:e,selectionPolicy:o,selectionUnit:i}},x.prototype.yh=function(t,n,e,i,r,o,a){var u,t,s,c,n,r,o,a,u=this;u.Q_(!0,3).yh(t,e),u.W_(3).yh(u.Mf,t,n,e,ot,r,o,u.F8,a),i&&(t={},e&&(t.ignoreStyle=!1===e.includeStyles,F.Util.Mo(e))&&(t.incrementalLoading=!0),u.W_(2).fromJSON(i.rowHeaderData,ot,t),u.W_(1).fromJSON(i.colHeaderData,ot,t),u.Q_(!1,2).fromJSON(i.rowHeaderColInfos),u.Q_(!0,1).fromJSON(i.colHeaderRowInfos),u.yle(3).yh(i.defaultData),e&&!1===e.includeStyles||(u.K_(2).fromJSON(i.rowHeaderSpan),u.K_(1).fromJSON(i.colHeaderSpan)),s=u.Q_(!0,3),(c=i.rowInfos||[]).forEach(function(t,n){at(t&&t.starSize)||s.setStarSize(n,t.starSize)}),(n=i.defaults)!==ot&&((r=u.defaults).colHeaderRowHeight=M(n.colHeaderRowHeight,m.DEFAULT_COL_HEADER_ROW_HEIGHT),r.rowHeaderColWidth=M(n.rowHeaderColWidth,40)),(o=i.selectionPolicy)!==ot&&(u.selectionModel.selectionPolicy=+o),(a=i.selectionUnit)!==ot&&(u.selectionModel.selectionUnit=+a),u.Rue(i.tag))},x.prototype.startTransaction=function(){var t,n;0===this.P8&&(this.G8=[],this.Mf.isEventSuspended()||(this.G8.events=[]),x.et(this,"startTransaction")),this.P8++},x.prototype.endTransaction=function(){var t,n;return this.P8--,0===this.P8?(x.et(this,"endTransaction"),t=this.G8,this.G8=ot,(n=t.events)&&0===n.length&&delete t.events,t):[]},x.prototype.pj=function(){var t=this.G8;if(t)return t.calc||(t.calc=[]),t.calc},x.prototype.applyChange=function(t,n,e){var i,r,o,a,u,o,s,i=this,r=t.type;!r&&0<t.length?(en(i,t,n),o=t[0][1],a=t[0][3],u=t[0][4],0<o&&0<=a&&0<=u&&(s=(o=i.W_(o)).J_(a,u))&&nn(s,s,!1,a,u,{},o.a8)):"addRows"===r?i.rj(t,n):"addColumns"===r?i.uj(t,n):"deleteRows"===r?i.oj(t,n):"deleteColumns"===r?i.sj(t,n):"setRowCount"===r?i.fj(t,n):"setColumnCount"===r?i.lj(t,n):"setZoomFactor"===r?i.wj(n?t.newValue:t.value):"updateDirty"===r?e.push(t):"setName"===r?n?i.Mj(t.newValue):i.Mj(t.value):"sortRange"===r?i.Cj(t,n):"sheetProperty"===r&&i.Mf[t.pname](n?t.value:t.oldValue)},x.prototype.applyChanges=function(t,n,s){var e,i,r,o,a;function c(t,n,e,i,r){r?t.setArrayFormula(n,e,r.rowCount,r.colCount,i):t.setFormula(n,e,i)}function u(t,n){var e,i,r,o,a,u;if(n)for(e in n)if(!isNaN(e))for(o in i=parseInt(e,10),r=n[e])isNaN(o)||(a=parseInt(o,10),s?c(t,i,a,u=r[o].formula!==r[o].oldFormula?r[o].formula:null,u?r[o].arrayInfo:null):c(t,i,a,r[o].oldFormula,r[o].oldArrayInfo))}if(e=this,i=[],n)if(s)for(r=0;r<n.length;r++)o=n[r],e.applyChange(o,s,i);else for(r=n.length-1;0<=r;r--)o=n[r],e.applyChange(o,s,i);(a=e.Mf).Sj={},a.r3(),u(a,n&&n.formulas),x.et(e,"applyChanges",{command:t,changes:n,isUndo:!s}),0<i.length&&a.Tj()},x.prototype.undo=function(t){var n,e,i,r,o,a,u,s,c,c,c,n=[],e=t&&t.events;if(e&&this.Aj(e,!0),t)for(i=t.length-1;0<=i;i--)(o=(r=t[i]).type)?"addRows"===o?this.rj(r):"addColumns"===o?this.uj(r):"deleteRows"===o?this.oj(r):"deleteColumns"===o?this.sj(r):"setRowCount"===o?this.fj(r):"setColumnCount"===o?this.lj(r):"setZoomFactor"===o?this.wj(r.value):"updateDirty"===o?(this.pE(r),n.push(r)):"setName"===o?this.Mj(r.value):"sortRange"===o&&this.Cj(r):r.skipUndo||en(this,r);(a=this.Mf).Sj={},a.r3(),(u=0<n.length)&&((s=a.Lp)&&s.suspend(),n.forEach(function(t){a.Ij(t.row,t.col,3,!1)})),(c=t&&t.tableChanges)&&0<c.length&&(x.et(this,z,{tableChanges:c}),t.tableChanges.isRestored=!0),(c=t&&t.pivotTableChanges)&&0<c.length&&(x.et(this,z,{pivotTableChanges:c}),t.pivotTableChanges.isRestored=!0),(c=t&&t.calc)&&c.length&&a.xj(c),x.et(this,"undoValue",t),u&&(s&&s.resume(!1),a.Tj()),delete this.W_(3).B8.vE,t&&x.et(this,z,t),e&&this.Aj(e,!1)},x.prototype.do=function(t){for(var n,e,i,t,n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];i=this,t&&(t=i[t])&&t.apply(i,n)},x.prototype.W_=function(t){return at(t)&&(t=3),this.sheetModels[t]},x.prototype.l8=function(t,n,e){var i=0,r=0;at(e)&&(e=3,i=t,r=n),this.sheetModels[e]=new yt(t,n,i,r)},x.prototype.yle=function(t){return at(t)&&(t=3),this.defaultValueModels[t]},x.prototype.ZI=function(t){var n,e=this.G8,e=e&&e.events;e&&e.push(t)},x.prototype.Aj=function(t,n){var e,i,r,o,a,e=this.Mf;for(e.Nj=!0,i=t.length-1;0<=i;i--)a=void 0,"cellChanged"!==(o=(r=t[i])[0])||n?"rowChanged"!==o||n?"columnChanged"!==o||n?"zoomChanged"!==o||n?"rowChanging"===o&&n?a=e.kj:"columnChanging"===o&&n?a=e.Dj:"tableRowsChanged"!==o||n?"tableColumnsChanged"!==o||n?"rangeChanged"!==o||n||(a=e._j):a=e.Ej:a=e.jj:a=e.Oj:a=e.vj:a=e.dj:a=e.Rj,a&&([].splice.call(t,i,1),a.apply(e,[].slice.call(r,1)));e.Nj=!1},x.prototype.Rve=function(t,n,e){var e=this.yle(e);if(e)return e.getValue(t,n)},x.prototype.gge=function(t,n,e,i){var r=this,o=r.Mf;o.hasFormula&&!o.hasFormula(t,n,i,!0)&&r.yle(i).$1e(t,n,rt,rt,i,e)},x.prototype.yge=function(t,n,e,i){var r,o,a,u,s,c,f,l,h,r=this,o=r.Mf;if(o.hasFormula)for(a=r.yle(),u=T(e,a.getRowCount()),s=T(i,a.getColumnCount()),c=0;c<u;c++)for(f=t+c,l=0;l<s;l++)a.getExpression(f,h=n+l)&&!o.hasFormula(f,h,3,!0)&&r.gge(f,h)},x.prototype.getValue=function(t,n,e,i,r){var o,a,r;return at(e)&&(e=3),!i&&(o={row:t,col:n,sheetArea:e,isValueGet:!1,value:ot,valueType:r},x.et(this,"getValue",o,function(){return o.isValueGet}),o.isValueGet)?this.wle||!at(o.value)||(a=this.Rve(t,n,e),at(a))?o.value:a:(r=this.W_(e).getValue(t,n,r),this.wle||i||!at(r)||(a=this.Rve(t,n,e),at(a))?r:a)},x.prototype.setValue=function(t,n,e,i,r,o,a,u,s){var c,f,l,o,s,h,r,s,a,u,r,f;at(i)&&(i=3),l=(f=this).Mf,(o=!o&&!l.isEventSuspended())&&(c=l.getValue(t,n,i,1)),s||f.KE(t,n,i,e,!0),s=!1,r||(h={row:t,col:n,value:e,sheetArea:i,isValueSet:!1,changes:f.G8},x.et(f,"setValue",h,function(){return h.isValueSet}),s=h.isValueSet),s||(s=r=void 0,0<f.P8&&(!a||l.parent&&l.parent.options.saveChangesForSheet)&&(r=[[w,i],ot],s={sheetArea:i}),l.vle?(f.setDefaultValue(t,n,e,i,rt,!0,rt),f.W_(i).setValue(t,n,rt,r,s,u)):(f.gge(t,n,at(e),i),f.W_(i).setValue(t,n,e,r,s,u)),u&&r&&!an(this.pj(),t,n)&&(r.skipUndo=!0),r&&0<r.length&&f.G8.push(r),s&&s.type&&f.G8.push(s),l.Tj()),o?(a=c!==e,u=!1,r=void 0,(a=typeof e===U&&((r=nt.util.V0(e))instanceof Date&&(u=!0),c instanceof Date)?c.valueOf()!==r.valueOf():a)&&l.Rj("value",t,n,i,c,u&&r?r:e),l.ki(nt.Events.WorksheetDataChanged,{type:"value"})):l.Lj(l,[{row:t,col:n}],0),(f=l.getCellType(t,n,i))&&f.Xe(l,t,n,e,i)},x.prototype.Mle=function(t,n,e){at(e)&&(e=3);var e=this.yle(e);if(e)return e.q1e(t,n)},x.prototype.getDefaultValue=function(t,n,e,i){var e=this.yle(e);if(e)return i===et.DefaultChangeValueType.Expression?e.getFormula(t,n):i!==et.DefaultChangeValueType.Value&&e.getFormula(t,n)||e.getValue(t,n)},x.prototype.setDefaultValue=function(t,n,e,i,r,o,a){var u,s,c;at(i)&&(i=3),(s=(u=this).yle(i))&&(c=void 0,0<u.P8&&(c=[[y,i],ot]),at(a)&&(u.wle=!0,a=!at(u.getValue(t,n,i))||u.Mf.hasFormula(t,n,i,!0),delete u.wle),!r&&j.kf(e)||r===et.DefaultChangeValueType.Expression?s.setFormula(t,n,e,i,a,c):s.setValue(t,n,e,o,c),c)&&0<c.length&&u.G8.push(c)},x.prototype.getStyle=function(t,n,e){return this.W_(e).getStyle(t,n,0<this.P8)},x.prototype.setStyle=function(t,n,e,i){var r,o,r;at(i)&&(i=3),e&&e.cellType&&e.cellType.qe(this.Mf,t,n,e,i),r=0<this.P8?[[w,i],ot]:ot,o=this.W_(i).getStyle(t,n,!1),this.W_(i).setStyle(t,n,e,r),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:"style"}),r&&0<r.length&&this.G8.push(r),r=this.Mf.parent,i===et.SheetArea.viewport&&vn(o,e,r)&&this.KE(t,n,i,this.getValue(t,n,i,!0),!1)},x.prototype.getValueForKey=function(t,n,e,i){return this.W_(i).getValueForKey(t,n,e)},x.prototype.setValueForKey=function(t,n,e,i,r){at(r)&&(r=3);var o=0<this.P8?[[w,r],ot]:ot;this.W_(r).setValueForKey(t,n,e,i,o),o&&0<o.length&&this.G8.push(o)},x.prototype.clear=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,b;if(at(a)&&(a=3),u=0<this.P8?[]:ot,c=(s=this).Mf,R&&3===a&&s.Mf.Uw(3).t8.Fgt(t,n,e,i),this.W_(a).clear(t,n,e,i,r,o,u),this.yle(a).resetFormulaToCalc(t,n,e,i,a),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:et.StorageType[r]}),x.et(this,"clear",{row:t,col:n,rowCount:e,colCount:i,type:r,ignoredRowList:o,sheetArea:a,changes:this.G8}),u)for(f=[w,a],l=0,h=u.length;l<h;l++)(d=u[l])[0]=f.concat(d[0]),this.G8.push(d);for(v=0;v<e;v++)for(m=0;m<i;m++)this.KE(g=t+v,p=n+m,a,rt,!1),(b=c.getCellType(g,p,a))&&b.Xe(c,g,p,rt,a)},x.prototype.swapNode=function(t,n,e,i,r){var o,a,u,s,c;if(at(r)&&(r=3),o=0<this.P8?[]:ot,this.W_(r).SE(t,n,e,i,o),this.yle(r).SE(t,n,e,i,o),o)for(a=[w,r],u=0,s=o.length;u<s;u++)(c=o[u])[0]=a.concat(c[0]),this.G8.push(c)},x.prototype.dE=function(t,n,e,i){var r;0<this.P8&&(r={sheetArea:i},at(i))&&(r.sheetArea=3),this.W_(i).dE(t,n,e,r),r&&this.G8.push(r)},x.prototype.pE=function(t){this.W_(t.sheetArea).pE(t)},x.prototype.Fj=function(t){return this.W_(t).B8},x.prototype.Pj=function(t,n,e){var i,e,r,i,e=this.Fj(e)[t];return!(!e||!(r=e[n]))},x.prototype.Gj=function(t,n,e){for(var i,r,o,i=this.W_(e).B8,r=0;r<n;r++)(o=t+r)in i&&delete i[o]},x.prototype.Uj=function(t,n){var e,i,r,o,e,i=this.Mf.aj;if(i)for(r=i.length-1;0<=r;r--)t<=(o=i[r].row)&&o<t+n&&i.splice(r)},x.prototype.Hj=function(t){this.W_(t).B8={}},x.prototype.zj=function(t,n,e,i){var r=this.Fj(),o,a,u;if(r)for(o in r)N(r,o)&&(a=r[o],u=parseInt(o,10),a)&&"n"===a.rs&&(t||n&&e<=u&&u<e+i)&&(r[o]={})},x.prototype.Vj=function(o,t,a,n,u){var e,s,c,f,i,r,l,e,h,d,v,e=this,s=e.Fj(),c=e.Mf,f=c.tables;if(!it(s)){if(i=[],0<=t)for(r=t;r<t+n;r++)i.push(r);else for(l in s)N(s,l)&&i.push(parseInt(l,10));e=[],h=[],f&&(e=f.Yj(t,a,n,u),h=f.Zj(t,a,n,u),0<e.length)&&x.et(this,"clearPendingChanges",{tableList:e}),O(i,function(t,n){var e,i,r;if((d=s[n])&&"e"===d.rs)if(e=h.length,o)if(f&&0!==e&&f.Wj(h,n,-1))for(i=c.getColumnCount(),r=0;r<i;r++)f&&0!==e&&f.Wj(h,n,r)||(v=d[r])&&delete d[r];else s[n]={};else for(r=a;r<a+u;r++)f&&0!==e&&f.Wj(h,n,r)||(v=d[r])&&delete d[r]})}},x.prototype.Qj=function(){var t,n,e,t,n=this.Fj();for(e in n)N(n,e)&&n[e]&&"e"===n[e].rs&&(n[e]={})},x.prototype.Kj=function(t){this.W_(t).lE++},x.prototype.Jj=function(t){var t,n,t=this.W_(t);t.lE--,(n=t.lE)<0&&(t.lE=0)},x.prototype.getName=function(){return this.name||""},x.prototype.setName=function(t){var n,e,n=this,e=n.name;e!==t&&(0<n.P8&&n.G8.push({type:"setName",value:e}),n.name=t)},x.prototype.Xj=function(){return this.isSelected},x.prototype.qj=function(t){this.isSelected=t},x.prototype.Mj=function(t){this.Mf.name(t)},x.prototype.Cj=function(t,n){var e,i,e=t.byRows?t.row:t.column;n||(i=[],t.array.map(function(t,n){i[t-e]=n+e})),this.Mf.sortRange(t.row,t.column,t.rowCount,t.columnCount,t.byRows,t.sortInfo,rt,i)},x.prototype.getZoomFactor=function(){return this.zoomFactor},x.prototype.setZoomFactor=function(t){var n=this;0<n.P8&&n.G8.push({type:"setZoomFactor",value:n.zoomFactor}),n.zoomFactor=t},x.prototype.wj=function(t){this.Mf.zoom(t)},x.prototype.K_=function(t){return at(t)&&(t=3),this.spanModels[t]},x.prototype.d8=function(t){at(t)&&(t=3),this.spanModels[t]=new dt},x.prototype.getSpans=function(t,n,e){var n=this.K_(n).getSpans(t);return n=e?n.filter(function(t){return!t.isAutoMerge}):n},x.prototype.getSpan=function(t,n,e){return this.K_(e).get(t,n)},x.prototype.Ci=function(t,n,e){var e,e;return at(e)&&(e=3),(e=this.W_(e))&&e.J_&&(e=e.J_(t,n))&&e.tipContent?e.tipContent:null},x.prototype.$n=function(t,n,e,i){at(i)&&(i=3);var r=this.W_(i).J_(t,n);!e&&r?delete r.tipContent:e&&r?r.tipContent=e:e&&!r&&((r=this.W_(i).J_(t,n,!0)).tipContent=e)},x.prototype.eE=function(t,n,e,i,r){return this.K_(r).eE(t,n,e,i)},x.prototype.GT=function(t,n,e,i,r){return this.K_(r).GT(t,n,e,i)},x.prototype.findSpan=function(t,n,e){return this.K_(e).find(t,n)},x.prototype.removeSpan=function(t,n){at(n)&&(n=3);var e=0<this.P8?[["spanModels",n],ot]:ot;this.K_(n).remove(t,e),e&&0<e.length&&this.G8.push(e)},x.prototype.addSpan=function(t,n){at(n)&&(n=3);var e=0<this.P8?[["spanModels",n],ot]:ot;this.K_(n).add(t,e),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:"span"}),e&&0<e.length&&this.G8.push(e)},x.prototype.clearSpan=function(t,n,e,i,r){at(r)&&(r=3);var o=0<this.P8?[["spanModels",r],ot]:ot;this.K_(r).d5(t,n,e,i,o),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:"span"}),o&&0<o.length&&this.G8.push(o)},x.prototype.moveSpan=function(t,n,e,i,r,o,a){at(a)&&(a=3);var u=0<this.P8?[["spanModels",a],ot]:ot;this.K_(a).iE(t,n,e,i,r,o,u),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:"span"}),u&&0<u.length&&this.G8.push(u)},x.prototype.copySpan=function(t,n,e,i,r,o,a){at(a)&&(a=3);var u=0<this.P8?[["spanModels",a],ot]:ot;this.K_(a).tE(t,n,e,i,r,o,u),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:"span"}),u&&0<u.length&&this.G8.push(u)},x.prototype._9=function(t,n,e,i){this.colHeaderSelectionModel.$j=new nt.Range(t,n,e,i)},x.prototype.J9=function(){return this.colHeaderSelectionModel.$j},x.prototype.addSelection=function(t,n,e,i,r,o){var a,u,s;if(1===o)this.colHeaderSelectionModel.add(t,n,e,i,ot);else if(a=0<this.P8?[]:ot,this.selectionModel.add(t,n,e,i,a,r),a)for(u=0;u<a.length;u++)(s=a[u])[0]=["selectionModel"].concat(s[0]),this.G8.push(s)},x.prototype.getSelections=function(t){return(1===t?this.colHeaderSelectionModel:this.selectionModel).get()},x.prototype.setSelections=function(t,n){var e,i,r;if(1===n)this.colHeaderSelectionModel.set(t,ot);else if(e=0<this.P8?[]:ot,this.selectionModel.set(t,e),e)for(i=0;i<e.length;i++)(r=e[i])[0]=["selectionModel"].concat(r[0]),this.G8.push(r)},x.prototype.clearSelection=function(t){var n,e,i;if(1===t)this.colHeaderSelectionModel.clear(ot);else if(n=0<this.P8?[]:ot,this.selectionModel.clear(n),n)for(e=0;e<n.length;e++)(i=n[e])[0]=["selectionModel"].concat(i[0]),this.G8.push(i)},x.prototype.getActiveSelectedRangeIndex=function(){return this.selectionModel.getProperty("activeSelectedRangeIndex")},x.prototype.setActiveSelectedRangeIndex=function(t){var n=0<this.P8?[["selectionModel"],ot]:ot;this.selectionModel.setProperty("activeSelectedRangeIndex",t,n),n&&this.G8.push(n)},x.prototype.getSelectionPolicy=function(){return this.selectionModel.getProperty("selectionPolicy")},x.prototype.setSelectionPolicy=function(t){rn(this,"selectionPolicy",t)},x.prototype.getSelectionUnit=function(){return this.selectionModel.getProperty("selectionUnit")},x.prototype.setSelectionUnit=function(t){rn(this,"selectionUnit",t)},x.prototype.T9=function(t){return this.selectionModel.T9(t)},x.prototype.S9=function(t){return this.selectionModel.S9(t)},x.prototype.ni=function(t,n,e,i,r,o){return this.selectionModel.ni(t,n,e,i,r,o)},x.prototype.ei=function(t,n,e,i,r){return this.selectionModel.ei(t,n,e,i,r)},x.prototype.Q_=function(t,n){var e;return at(n)&&(n=3),(t?this.rowInfos:this.colInfos)[n]},x.prototype.h8=function(t,n){var e;at(n)&&(n=3),(t?this.rowInfos:this.colInfos)[n]=new f},x.prototype.getPageBreak=function(t,n,e){var i;return this.Q_(t,n).getPageBreak(e)},x.prototype.setPageBreak=function(t,n,e,i){var r,o;at(n)&&(n=3),r=0<this.P8?[[t?p:b,n],ot]:ot,(o=this.Q_(t,n)).setPageBreak(e,i,r),r&&this.G8.push(r)},x.prototype.getVisible=function(t,n,e){var i;return this.Q_(t,n).getVisible(e)},x.prototype.setVisible=function(t,n,e,i){var r,o,a,i,r=this;at(n)&&(n=3),o=0<r.P8?[[t?p:b,n],ot]:ot,(a=r.Q_(t,n)).setVisible(e,i,o),o&&r.G8.push(o),i=t?et.AxisInfoChangeType.setRowVisible:et.AxisInfoChangeType.setColumnVisible,r.L8({type:i,index:e,sheetArea:n})},x.prototype.getResizable=function(t,n,e){var i;return this.Q_(t,n).getResizable(e)},x.prototype.setResizable=function(t,n,e,i){var r,o;at(n)&&(n=3),r=0<this.P8?[[t?p:b,n],ot]:ot,(o=this.Q_(t,n)).setResizable(e,i,r),r&&this.G8.push(r)},x.prototype.getSize=function(t,n,e){var i;return this.Q_(t,n).getSize(e)},x.prototype.getColumnHeaderFitMode=function(t,n,e){var i;return this.Q_(t,n).getColumnHeaderFitMode(e)},x.prototype.setColumnHeaderFitMode=function(t,n,e,i){var r,o,a,u,s,c,f,t,l,h,d,v,m,r=this,o=60,s=r.Mf,c=s.getRowCount(1);if(at(n)&&(n=3),r.P8&&(a=[[b,n],ot],u=[[p,n],ot]),l=(t=r.Q_(t,n)).getColumnHeaderFitMode(e),t.setColumnHeaderFitMode(e,i,a),d=!1,i===et.ColumnHeaderFitMode.vertical?(h=60,s.gD&&2===l&&s.gD--):i===et.ColumnHeaderFitMode.stack?(r.t7(e,n),s.gD||(s.gD=0),2!==l&&s.gD++):i===et.ColumnHeaderFitMode.normal&&(h=s.defaults.colHeaderRowHeight,s.gD)&&2===l&&s.gD--,h){for(v=r.Q_(!0,n),m=0;m<c;m++)f=s.getRowHeight(m,n),(h=g(h,f))!==f&&(v.setSize(m,Y,u),u)&&(r.G8.push(u),u=[[p,n],ot]);s.defaults.colHeaderRowHeight=h}a&&r.G8.push(a)},x.prototype.t7=function(t,n){var e,i,r,o,a,u,s,c,f,l,e=this,o=e.Mf,a=e.Q_(!0,n);if(e.P8&&(i=[[p,n],ot]),u=e.Mf.defaults.rowHeight||m.DEFAULT_COL_HEADER_ROW_HEIGHT,c=e.getRowCount(et.SheetArea.colHeader),f=e.n7(t),!e.e7(t)){for(l=0;l<c;l++)r=u*f,s=o.getRowHeight(l,n),(r=g(r,s))!==s&&(a.setSize(l,Y,i),i)&&(e.G8.push(i),i=[[p,n],ot]);o.defaults.colHeaderRowHeight=r}},x.prototype.e7=function(t){var n,e,i,e,n,n=this,e=n.Mf,i=e.frozenColumnCount()-1,e=e.frozenTrailingColumnCount(),n=n.getColumnCount()-1;return t===i||t===n||t===n-e},x.prototype.i7=function(t){var n,e,i,e,n,r,o,n=this,e=n.Mf,i=e.frozenColumnCount(),e=e.frozenTrailingColumnCount(),n=n.getColumnCount();return e&&(o=t===n-e),(r=i?t===i:r)||o},x.prototype.n7=function(t,n){for(var e,i,r,t,o,a,u,s,c,f,t,l,h,e=this,o=et.SheetArea.colHeader,a={},u=e.Mf,s=u.getColumnCount(),i=r=t=(n=n||e.Q_(!1,o).infos)[t]&&n[t].columnHeaderFitMode===et.ColumnHeaderFitMode.stack?t:t-1,c=t;0<=c;c--)if(u.getColumnWidth(c,o)){if(!n[c]||n[c].columnHeaderFitMode!==et.ColumnHeaderFitMode.stack||e.eE(-1,c,-1,1,et.SheetArea.colHeader))break;if(e.i7(c)){i=c;break}i=c}else a[i=c]=!0;for(c=t;c<s;c++)if(u.getColumnWidth(c,o)){if(!n[c]||n[c].columnHeaderFitMode!==et.ColumnHeaderFitMode.stack||e.eE(-1,c,-1,1,et.SheetArea.colHeader))break;if(e.e7(c))break;r=c}else if(a[r=c]=!0,e.e7(c))break;return t=r-i-(f=Object.keys(a).length)+1,l=1,!(h=u.O5(r,o,!0))||e.e7(r)||e.eE(-1,h,-1,1,et.SheetArea.colHeader)?t:1+t},x.prototype.r7=function(t,n,e){var i,r,o,a,u,s,c,i=this,r=0,o=i.Mf,a=o.Ut;for(n=n||i.Q_(!1,et.SheetArea.colHeader).infos,u=i.o7(t),s=t-1;u<=s;s--)if(c=o.getColumnWidth(s))if(n[s]&&n[s].columnHeaderFitMode===et.ColumnHeaderFitMode.stack&&!a.eE(-1,s,-1,1,et.SheetArea.colHeader))r++;else if(!e||!n[s]||n[s].columnHeaderFitMode!==et.ColumnHeaderFitMode.vertical||a.eE(-1,s,-1,1,et.SheetArea.colHeader))return r;return r},x.prototype.i6=function(t,n){for(var e,i,r,o,a,e=this,i,r=e.Mf.getColumnCount(),a=t+1;a<r;a++)if((o=e.getColumnHeaderFitMode(!1,1,a))===n)return a;return rt},x.prototype.o7=function(t){var n,e,i,e,n,n=this,e=n.Mf,i=e.frozenColumnCount(),e=e.frozenTrailingColumnCount(),n=n.getColumnCount();return t<i?0:t<n-e?i:n-e},x.prototype.getStarSize=function(t,n,e){var i;return this.Q_(t,n).getStarSize(e)},x.prototype.getActualSize=function(t,n,e){var i;return this.Q_(t,n).getActualSize(e)},x.prototype.setSize=function(t,n,e,i){var r,o,a,o,r=this;at(n)&&(n=3),o=0<r.P8?[[t?p:b,n],ot]:ot,(a=r.Q_(t,n)).setSize(e,i,o),this.Mf.ki(nt.Events.WorksheetDataChanged,{type:"size"}),o&&r.G8.push(o),r.setStarSize(t,n,e,rt),o=t?et.AxisInfoChangeType.setRowHeight:et.AxisInfoChangeType.setColumnWidth,r.L8({type:o,index:e,value:i,sheetArea:n})},x.prototype.setStarSize=function(t,n,e,i){var r,o;at(n)&&(n=3),r=0<this.P8?[[t?p:b,n],ot]:ot,(o=this.Q_(t,n)).setStarSize(e,i,r),r&&!at(r[1])&&this.G8.push(r)},x.prototype._E=function(t,n){var e;return this.Q_(t,n)._E()},x.prototype.EE=function(t,n){var e;return this.Q_(t,n).EE()},x.prototype.q_=function(t,n,e){var i;return this.Q_(t,n).q_(e)},x.prototype.setItem=function(t,n,e,i){var r,o,a,u,r=this;at(n)&&(n=3),o=0<r.P8?[[t?p:b,n],ot]:ot,(a=r.Q_(t,n)).X_(e,i,o),i&&(at(i.size)||(u=t?et.AxisInfoChangeType.setRowHeight:et.AxisInfoChangeType.setColumnWidth,r.L8({type:u,index:e,value:i.size,sheetArea:n})),at(i.visible)||(u=t?et.AxisInfoChangeType.setRowVisible:et.AxisInfoChangeType.setColumnVisible,r.L8({type:u,index:e,sheetArea:n}))),o&&r.G8.push(o)},At=x,m.Y8=At,(0,nt.$e)(At),It=["=","+","-"],xt=/^(__builtInTableStyle\d+)?__builtInStyle\d+$/,Nt="__builtInStyle"},"./dist/core/worksheet/worksheet-render.js":function(o,t,ht){"use strict";var dt,vt,q,n,s,mt,gt,pt,d,bt,wt,At,C,$,tt,It,yt,p,N,c,nt,Mt,T,j,E,w,y,M,f,l,Ct,k,et,a,v,m,h,it,S,g,xt,b,u,A,I,x,D,O,R,L,B,F,P,G;function St(t){return t.height}function Tt(t){return t.width}function U(t,n,e,i,r,o,a){t.beginPath(),t.lineWidth=n,t.strokeStyle=e,t.moveTo(i,r),t.lineTo(o,a),t.stroke()}function H(t,n){var e,t,i,e=0;return"string"==typeof t&&(1===(i=(t=t.split(" ",4)).length)?e=2*k(t[0]):2===i||3===i?e=2*k(t[1]):4===i&&(e=k(t[1])+k(t[3]))),e*n}function _(t,n,e,i,r,o,a,u){var s,c,f,l,h,d,v,m,g,u,t,m,i,p,b,d,v,s=r.zoom(),c=s||1,f=e.font,l=e.textIndent,h=e.textOrientation,d=e.isVerticalText,v=e.textIndent&&0!==e.textIndent,m=0!==h&&!yt(h);return f=f?nt(f,s).font:i,typeof u===it&&1!==u&&(f=nt(f,u).font,c=s*u),i=0,i=t&&t.richText?z(t.richText,f,s):t&&m&&!d&&!v?(u=w(h*Math.PI/180),t=y(u),m=M(u),e.wordWrap?(d=(b=r.Jt).Gt(o),q.q.Zt(o,a,t,m,n,f,d)):(v=$(f),q.q.Wt(n,f)*m+v*t)):q.q.Wt(n,f),g=(i+=Z(r,l,o,a,c)+S)+H(e.cellPadding,s)}function V(t,n,e){var i;if(t&&-90<=t&&t<=90)return l(e/f(w(t*Math.PI/180)))+n+4}function z(t,n,e){var t=s.GC$.extend(!0,[],t);return Y(t,n,e),q.q.ah(t,n,1)}function Y(t,n,e){for(var i,r,o,a,o,i=0,r=t;i<r.length;i++)a=void 0,(o=r[i]).style=o.style||{},a=(o=o.style).font?nt(o.font,e).font:n,o.font=a}function Z(t,n,e,i,r){if(!yt(e)&&!yt(i)&&t.outlineColumn){var t=t.outlineColumn.a7(e,i);if(t)return t}return n?8*n*r:0}function W(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,p,b,w,y,M,C,e,S,S,T,A,I;if(N(r.data)&&t.parent&&t.parent.options.numbersFitMode!==pt.NumbersFitMode.overflow)return Mt;if(c=t.Jt,f=Tt(r),l=Tt(r),d=r.style,m=r.text,g=r.printZoomFactor,p=d.watermark,b=d.wordWrap,w=d.textOrientation,C=t.options.allowCellOverflow,n.findCell(o,a))return Mt;if(d.cellButtons&&0<d.cellButtons.length)return Mt;if(bt.W.Xue(d))return Mt;if(e=d.cellType||e,S=(S=t.parent&&t.parent.options.numbersFitMode)===pt.NumbersFitMode.mask||S===pt.NumbersFitMode.overflow&&!N(r.data),!e.allowOverflow||!m&&!p||!w&&b&&S)return Mt;if(!C&&!w)return Mt;if((y=_(r.data,m=m||p,d,i,t,o,a,g))<=l)return Mt;if(90===Math.abs(w)&&b)return Mt;for(v=(A=T=a)+(s?1:-1);(s?v<=u:u<=v)&&!n.findCell(o,v)&&(M=c.qt(o,v),h=c.$t(o,v,3,1,M),I=M.textOrientation,yt(h)||I&&w)&&!M.watermark&&!(M.cellType&&"1"!==M.cellType.typeName||M.cellButtons&&0<M.cellButtons.length||bt.W.Xue(M))&&(s?A=v:T=v,!(y<=(l+=c.Kt(v))));v+=s?1:-1);return s&&A===a||!s&&T===a?Mt:new mt.Q8(a,T,A,y,f,l,s?-1:l,s?l:-1)}function e(t,n,e){var i=this;i.Mf=t,i.Vx=t.Yy(e),i.u7=t.s7(n,e,pt.SheetArea.viewport,!0),i.c7=nt(t.Dn.Nn(),t.zoom()).font,i.f7=t.$f(),i.l7={}}function Q(t){var n,e,n=t.parent,e={nps:!0};return vt.Worksheet.et(t,"needPaintSelection",e),(q.hi.A1(t)||n&&!n.options.hideSelection)&&e.nps}function rt(t){var t=t.parent;return t&&t.options.backColor||h}function i(t){this.Mf=t}function r(t){var n=this;n.h7=!1,n.d7=!1,n.Mf=t,n.v7()}Object.defineProperty(t,"__esModule",{value:!0}),t.m7=t.g7=t.needPaintSelection=t.p7=void 0,dt=ht("Common"),vt=ht("./dist/core/worksheet/worksheet.js"),q=ht("./dist/core/util/common.js"),n=ht("./dist/core/worksheet/stylehelper.js"),s=ht("./dist/core/util/domUtil.js"),mt=ht("./dist/core/worksheet/worksheet-model.js"),gt=ht("./dist/core/worksheet/worksheet-border.js"),pt=ht("./dist/core/core.enum.js"),d=ht("./dist/core/celltype/basecelltype.js"),bt=ht("./dist/core/worksheet/stylehelper.js"),wt=function(t){return t.getSparkline},At=dt.Common.Uf,C=q.mt.gt,$=q.mt.vt,tt=q.mt.bt,It=q.mt.St,yt=dt.Common.lt.ht,p=dt.Common.lt.q8,N=q.mt.Ct,c=n.p5,nt=n.W.V,Mt=null,T=void 0,j=Math.min,E=Math.max,w=Math.abs,y=Math.sin,M=Math.cos,f=Math.tan,l=Math.floor,Ct=Math.round,k=parseInt,et="black",a="transparent",v="rowHeader",m="columnHeader",h="white",it="number",S=2,g=100,e.prototype.b7=function(t,n,e){var i,r,o,a,u,s,c,i=this,r=i.l7[t];if(r)return r;if(a=(o=i.Vx).length,u=new mt.K8,n=n||q.q.J(),0<a){for(u.headingOverflowLayouts=i.y7(t,n),c=0;c<a;c++)(s=this.w7(t,c,n,e))&&u.push(s);u.trailingOverflowLayouts=i.C7(t,n)}return i.l7[t]=u},e.prototype.w7=function(t,n,e,i){var r,o,a,u,s,c,f,l,u,h,d,v,u,n,a,m,g,p,s,b,n,u,n,u,n,a,w,r=this,o=r.Mf,a=o.Jt,u=r.Vx,s=u.length;if(0!==s&&(p=u[0].col,s=u[s-1].col,e=e||q.q.J(),!(Tt(u=u[n])<=0))&&(h=u.col,d=a.qt(t,h),v=a.$t(t,h,3,1),c=d.textOrientation,f=d.isVerticalText,l=d.textIndent&&0!==d.textIndent,b=d&&(d.borderLeft||d.borderTop||d.borderRight||d.borderBottom),!yt(v)||d.watermark||d.cellType)&&(n=o.parent&&o.parent.options.numbersFitMode,!((d.shrinkToFit||!c&&d.wordWrap&&(n===pt.NumbersFitMode.mask||n===pt.NumbersFitMode.overflow&&!N(v))||f)&&4!==d.hAlign||4!==d.hAlign&&!1===o.options.allowCellOverflow||(u=o.conditionalFormats)&&(u=(n=u.U(o,t,h,v,3))&&n.dataBar,n=n&&n.iconSet,u&&u.showBarOnly||n&&n.showIconOnly))))return u=a.Kt(h),n=a.Gt(t),a=d.cellType||r.f7,m=q.Be.Cl(o,d,v,w={},{row:t,col:h,sheet:o}),w.content&&0<w.content.length&&!d.shrinkToFit&&c&&(m=a.de(e,w.content,n-4,d.font)),3===(a=d.hAlign)&&(a=C(a,v,d.formatter||d._autoFormatter,c)),!b||!c||f&&4!==a||l?0===a?g=r.S7({data:v,style:d,width:u,text:m,printZoomFactor:i},t,h,s):2===a?g=r.T7({data:v,style:d,width:u,text:m,printZoomFactor:i},t,h,p):1===a?g=r.A7({data:v,style:d,width:u,text:m,printZoomFactor:i},t,h,p,s):4===a&&(g=r.I7({data:v,style:d,width:u,text:m,printZoomFactor:i},t,h,0,o.getColumnCount()-1)):c<0&&-90<c?g=r.x7({data:v,style:d,width:u,text:m,printZoomFactor:i},t,h,p):0<c&&c<90&&(g=r.x7({data:v,style:d,width:u,text:m,printZoomFactor:i},t,h,s,!0)),g},e.prototype.N7=function(t){for(var n,e,i,r,o,a,u,s,c,f,n=this,e=n.Vx,i=e.length,r,o=n.Mf.Jt,f=i-1;0<=f;f--)if(c=(a=e[f]).col,u=o.qt(t,c),(s=o.$t(t,c,3,1))||u.watermarks)return this.w7(t,f)},e.prototype.S7=function(t,n,e,i){var r=this;return W(r.Mf,r.u7,r.f7,r.c7,t,n,e,i,!0)},e.prototype.T7=function(t,n,e,i){var r=this;return W(r.Mf,r.u7,r.f7,r.c7,t,n,e,i)},e.prototype.x7=function(t,n,e,i,r){var o,a,u,s,o,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,o=this,a=o.Mf,u=o.u7,s=o.f7,o=o.c7,c=a.Jt,f=Tt(t),l=Tt(t),h=t.style,v=t.text,m=t.printZoomFactor,g=h.watermark,p=h.wordWrap,b=h.textOrientation,M=h&&(h.borderLeft||h.borderTop||h.borderRight||h.borderBottom),C=h.isVerticalText,S=h.textIndent&&0!==h.textIndent,T=a.options.allowCellOverflow;if(u.findCell(n,e))return Mt;if(h.cellButtons&&0<h.cellButtons.length)return Mt;if(bt.W.Xue(h))return Mt;if(!(A=h.cellType||s).allowOverflow||!v&&!g||!b&&p)return Mt;if(v=v||g,!T&&!b)return Mt;if((w=!M||C||S?_(t.data,v,h,o,a,n,e,m):V(b,c.Kt(e),c.Gt(n)))<=l)return Mt;for(d=(x=I=e)+(r?1:-1);(r?d<=i:i<=d)&&!u.findCell(n,d)&&!(y=c.qt(n,d)).watermark&&!(y.cellType&&"1"!==y.cellType.typeName||y.cellButtons&&0<y.cellButtons.length||bt.W.Xue(y))&&(r?x=d:I=d,!(w<=(l+=c.Kt(d))));d+=r?1:-1);return r&&x===e||!r&&I===e?Mt:new mt.Q8(e,I,x,w,f,l,r?-1:l,r?l:-1)},e.prototype.A7=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x;if(N(t.data)&&this.Mf.parent&&this.Mf.parent.options.numbersFitMode!==pt.NumbersFitMode.overflow)return Mt;if(u=(a=(o=this).Mf).Jt,s=o.u7,c=Tt(t),f=Tt(t),h=t.style,v=t.text,m=t.printZoomFactor,g=h.textOrientation,p=h.watermark,b=h.wordWrap,M=a.options.allowCellOverflow,s.findCell(n,e))return Mt;if(h.cellButtons&&0<h.cellButtons.length)return Mt;if(bt.W.Xue(h))return Mt;if(!(C=h.cellType||o.f7).allowOverflow||!v&&!p||!g&&b&&a.parent&&a.parent.options.numbersFitMode!==pt.NumbersFitMode.overflow)return Mt;if(!M&&!g)return Mt;if((w=_(t.data,v=v||p,h,o.c7,a,n,e,m))<=f)return Mt;if(90===Math.abs(g)&&b)return Mt;for(T=f/2,d=(S=e)-1;i<=d&&!s.findCell(n,d)&&(y=u.qt(n,d),l=u.$t(n,d,3,1,y),A=y.textOrientation,yt(l)||A&&g)&&!y.watermark&&!(y.cellType&&"1"!==y.cellType.typeName||y.cellButtons&&0<y.cellButtons.length||bt.W.Xue(y))&&(S=d,!(w/2<=(T+=u.Kt(d))));d--);for(x=f/2,d=(I=e)+1;d<=r&&!s.findCell(n,d)&&(y=u.qt(n,d),l=u.$t(n,d,3,1,y),A=y.textOrientation,yt(l)||A&&g)&&!y.watermark&&!(y.cellType&&"1"!==y.cellType.typeName||y.cellButtons&&0<y.cellButtons.length||bt.W.Xue(y))&&(I=d,!(w/2<=(x+=u.Kt(d))));d++);return S===I?Mt:new mt.Q8(e,S,I,w,c,T+x,T,x)},e.prototype.k7=function(t,n,e){var i,t,i=t.qt(n,e),t=t.$t(n,e,3,1,i);return!(!i.textOrientation&&!yt(t)||i.watermark||i.cellType&&"1"!==i.cellType.typeName||i.cellButtons&&0<i.cellButtons.length||bt.W.Xue(i))},e.prototype.I7=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p,g,b,v,w,y,M,C,S,T,A,I,o=this,a=o.Mf,u=a.Jt,s=o.u7,c=Tt(t),l=t.style,h=l.shrinkToFit,v=t.text,m=t.printZoomFactor,g=l.watermark,p=l.wordWrap;if(s.findCell(n,e))return Mt;if(l.cellButtons&&0<l.cellButtons.length)return Mt;if(bt.W.Xue(l))return Mt;for(g=_(t.data,v=v||g,l,o.c7,a,n,e,m),y=u.Kt(w=v=e),M=v+1;M<=r&&(b=u.qt(n,M),f=u.$t(n,M,3,1,b),yt(f)&&4===b.hAlign&&yt(a.getSpan(n,M)))&&!b.watermark&&!(b.cellType&&"1"!==b.cellType.typeName||b.cellButtons&&0<b.cellButtons.length||bt.W.Xue(b));M++)w=M,y+=u.Kt(M);if(C=(g-y)/2,N(t.data)&&this.Mf.parent&&this.Mf.parent.options.numbersFitMode!==pt.NumbersFitMode.overflow&&(C=0),S=v,A=w,I=T=y/2,!h&&!p&&!1!==a.options.allowCellOverflow){for(d=e-1;i<=d&&0<C&&(this.k7(u,n,d)&&!s.findCell(n,d))&&(S=d,!(C<=(T+=u.Kt(d))-y/2));d--);for(d=w+1;d<=r&&0<C&&(this.k7(u,n,d)&&!s.findCell(n,d))&&(A=d,!(C<=(I+=u.Kt(d))-y/2));d++);}return new mt.Q8(e,S,A,g,c,T+I,T,I,y)},e.prototype.y7=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,f,p,b,w,y,e=this,i=e.Mf,r=i.Jt,o=e.Vx;if(0===o.length)return[];for(a=o[0].col,u=o[o.length-1].col,s=i.Ut,w=[],n=n||q.q.J(),y=1;y<100;y++){if((v=a-y)<0)return w;if(s.findSpan(t,v)||i.Cb&&i.Cb.D7(t,v,pt.SheetArea.viewport))return w;f=r.$t(t,v,3,1),0<(l=r.Kt(v))&&!yt(f)&&(4!==(d=(c=r.qt(t,v)).hAlign)&&!1===i.options.allowCellOverflow||(3===d&&(d=C(d,f,T,c.textOrientation)),h=r.Gt(t),p=c.cellType||e.f7,g=q.Be.Cl(i,c,f,b={},{row:t,col:v,sheet:i}),f={data:f,style:c,width:l,text:g=b.content&&0<b.content.length&&!c.shrinkToFit&&c.textOrientation?p.de(n,b.content,h-4,c.font):g},0<c.textOrientation&&c.textOrientation<90?m=e.x7(f,t,v,u,!0):0===d?m=e.S7(f,t,v,u):1===d?m=e.A7(f,t,v,a,u):4===d&&(m=e.I7(f,t,v,a,u)),m&&m.endColumn>=a&&w.push(m)))}return w},e.prototype.C7=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,f,y,M,e=this,i=e.Mf,r=i.Jt,o=e.Vx;if(0===o.length)return[];for(a=o[0].col,u=o[o.length-1].col,s=i.Ut,g=i.getColumnCount(),y=[],n=n||q.q.J(),M=1;M<100;M++){if(g<=(p=u+M))return y;if(s.findSpan(t,p)||i.Cb&&i.Cb.D7(t,p,pt.SheetArea.viewport))return y;f=r.$t(t,p,3,1),0<(l=r.Kt(p))&&!yt(f)&&(4!==(d=(c=r.qt(t,p)).hAlign)&&!1===i.options.allowCellOverflow||(3===d&&(d=C(d,f,T,c.textOrientation)),h=r.Gt(t),v=c.cellType||e.f7,w=q.Be.Cl(i,c,f,m={},{row:t,col:p,sheet:i}),f={data:f,style:c,width:l,text:w=m.content&&0<m.content.length&&!c.shrinkToFit&&c.textOrientation?v.de(n,m.content,h-4,c.font):w},c.textOrientation<0&&-90<c.textOrientation?b=e.x7(f,t,p,a,!1):2===d?b=e.T7(f,t,p,a):1===d?b=e.A7(f,t,p,a,u):4===d&&(b=e.I7(f,t,p,0,u+100)),b&&b.startColumn<=u&&y.push(b)))}return y},xt=e,t.p7=xt,t.needPaintSelection=Q,i.prototype.J=function(){var t,n,t,t=this.Mf,n=Mt,t=t.Dg();return n=t&&t.getContext?t.getContext("2d"):n},i.prototype._7=function(){var t,n,e,i,r,i,o,r,t=this,n=t.Mf,e=n.ot(),i=n.fg,r=Tt(i),i=St(i),o=t.E7;return o&&Tt(o)===r&&St(o)===i||(o&&q.Bf.th(n,o),t.E7=o=q.mt.En("canvas"),o.getContext&&(t.j7=o.getContext("2d"),q.Bf.Wl(o,Mt,n),q.Bf.$l(o,Tt(e),St(e)))),(r=t.j7)&&(r.beginPath(),tt(r,t._n(t.Nn())),r.name="bufferContext"),r},i.prototype.Nn=function(){return this.c7||(this.c7=c+" "+this.Mf.currentTheme().bodyFont()),this.c7},i.prototype.O7=function(){this.c7=Mt},i.prototype.R7=function(t){var n,e,i,n,r,n=this.Mf,e=n.parent,i=e?e.options.grayAreaBackColor||q.I.ll("gc-grayArea").backgroundColor:"gray",n=q.Pf.vl(n,i);return n=t&&(r=e?e.options.backgroundImage:Mt)?a:n},i.prototype._n=function(t){var n,e=this.Mf.zoom();return 1===e?t:nt(t,e).font},i.prototype.FA=function(t,n,e,i,r){var o,a,u,o,s,r,r,r,o=this,a=o.E7,u=o.J();!(e<=0||i<=0)&&a&&u&&(r=r||o.Mf.ot(),o=q.Bf.Kl(a),s=q.Bf.Jl(a),1!==o&&(t*=o,n*=s,e*=o,i*=s,r=new q.Rect(r.x*o,r.y*s,Tt(r)*o,St(r)*s)),r=r.getIntersect(t,n,e,i))&&(r.round(),t=r.x,n=r.y,e=Tt(r),i=St(r),(r=Tt(a))&&r<t+e&&(t=r-e)<0&&(e+=t,t=0),(r=St(a))&&r<n+i&&(n=r-i)<0&&(i+=n,n=0),q.Lf.Vl(u,1,1),u.clearRect(t,n,e,i),u.drawImage(a,t,n,e,i,t,n,e,i),q.Lf.Vl(u,o,s))},i.prototype.O1=function(t,n){t&&this.FA(t.x,t.y,Tt(t),St(t),n)},i.prototype.Ey=function(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,M;if(0<e&&0<i)try{u=(a=this).Mf,s=a.J(),c=u.Dg(),f=a._7(),l=a.E7,v=r,m=o,g=e,p=i,b=q.Bf.Kl(c),w=q.Bf.Jl(c),t=Ct(t*b),n=Ct(n*w),e=Ct(e*b),i=Ct(i*w),v=Ct(v*b),m=Ct(m*w),g=Ct(g*b),p=Ct(p*w),y=Tt(l),M=St(l),y&&y<t+e&&(t=y-e)<0&&(e+=t,t=0),M&&M<n+i&&(n=M-i)<0&&(i+=n,n=0),y&&y<v+g&&(v=y-g)<0&&(g+=v,v=0),M&&M<m+p&&(m=M-p)<0&&(p+=m,m=0),q.Lf.Vl(s,1,1),q.Lf.Vl(f,1,1),s.clearRect(v,m,g,p),s.drawImage(l,t,n,e,i,v,m,g,p),f.clearRect(v,m,g,p),f.drawImage(c,v,m,g,p,v,m,g,p),q.Lf.Vl(s,b,w),q.Lf.Vl(f,b,w)}catch(t){}},i.prototype.E1=function(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,s,M,C,M,S,T,A,I,I,x,I,T,A,S,S,t,S,x,T,N,k,_,D,A,a=this,u=a.Mf,s=yt(r)||3===r;if(e=e||a.J(),f=(c=!1,q.Ec)(-1,-1,-1,-1),l=u.Ut,t&&(f=u.options.allowCellOverflow||u.gD?(0,q.Ec)(t.row,0,t.rowCount,u.getColumnCount(r)):(0,q.Ec)(t.row,t.col,t.rowCount,t.colCount),s)&&!o){if(0<=f.col){for(d=f.col,v=f.col+f.colCount-1,m=u.getRowCount(1),g=0;g<m;g++)(h=l.findSpan(g,f.col,1))?d=j(h.col,d):u.z9&&(d=j(u.z9.col,d)),(h=l.findSpan(g,f.col+f.colCount-1,1))?v=E(h.col+h.colCount-1,v):u.z9&&(v=E(u.z9.col+u.z9.colCount-1,v));f.col=d,f.colCount=v-d+1}if(0<=f.row){for(p=f.row,b=f.row+f.rowCount-1,w=u.getColumnCount(2),y=0;y<w;y++)(h=l.findSpan(f.row,y,2))?p=j(h.row,p):u.z9&&(p=j(u.z9.row,p)),(h=l.findSpan(f.row+f.rowCount-1,y,2))?b=E(h.row+h.rowCount-1,b):u.z9&&(b=E(u.z9.row+u.z9.rowCount-1,b));f.row=p,f.rowCount=b-p+1}}if(s=u.j1(f,r),u.cellStates&&u.cellStates.hasIntersectInSelectionState(f.row,f.col,f.rowCount,f.colCount)&&u.repaint(s),C=(M=u._1)&&M.isEnable(pt.RowColumnStates.selected,!0),M=M&&M.isEnable(pt.RowColumnStates.selected,!1),t&&(S=void 0,(C||M)&&(S=u.s7(u.C0(t.row),u.S0(t.col),pt.SheetArea.viewport,!1)),C&&(T=t.row,A=t.rowCount,S&&0<S.length&&(I=S.findLargestRange(t,!0))&&(I=(0,q.Ec)(I.row,I.col,I.rowCount,I.colCount),T=(x=t.union(I)).row,A=x.rowCount),I=u.j1((0,q.Ec)(T,-1,A,-1),r),s.x=j(s.x,I.x),s.y=j(s.y,I.y),s.width=E(s.width,I.width),s.height=E(s.height,I.height)),M)&&(T=t.col,A=t.colCount,S&&0<S.length&&(S=S.findLargestRange(t,!1))&&(S=(0,q.Ec)(S.row,S.col,S.rowCount,S.colCount),T=(x=t.union(S)).col,A=x.colCount),I=u.j1((0,q.Ec)(-1,T,-1,A),r),s.x=j(s.x,I.x),s.y=j(s.y,I.y),s.width=E(s.width,I.width),s.height=E(s.height,I.height)),t=Tt(s),S=St(s),x=s.x,T=s.y,0<=t||0<=S){if(_=18,D=30,s.x+=k=N=-9,s.y+=-9,s.width+=18,s.height+=30,n&&!(s=s.getIntersectRect(n)))return;A=u.Fi(),0<S&&!o&&(u.k1=!0,a._e(e,new q.Rect(A.x,E(A.T6,T),A.XC,S),i)),0<t&&!o&&(u.k1=!0,a._e(e,new q.Rect(E(A.b6,x),A.y,t,A.qC),i)),-1!==f.row||-1!==f.col||o||(u.k1=!0,a._e(e,A.R1(),i)),0<t&&0<S&&((C||M)&&(u.k1=!0),a._e(e,s,i)),c=!0}return c},i.prototype._6=function(t,n,e,i,r){var o,a,u,o=this,a=o.Mf;a.My<=0&&(u=o.J())&&(r||(a.k1=!0),o._e(u,new q.Rect(t,n,e,i)))},i.prototype.repaint=function(t){var n,e,i,n=this,e=n.Mf;0<e.My||(i=n.J())&&(e.k1=!0,n._e(i,t))},i.prototype._e=function(t,n,e){var i=this;t&&i.Mf.My<=0&&(e||i.D1(t,n),i.jy(t,n))},i.prototype.D1=function(t,n,e){var i,r,o,t,a,i=this,r=i.Mf;t&&r.My<=0&&(t=(o=i._7())||t,a=r.ot(),(n=n||a)&&n.round(),e&&e.round(),r.k1&&(r.k1=!1,o&&(o.clearRect(n.x,n.y,Tt(n),St(n)),e&&o.clearRect(e.x,e.y,Tt(e),St(e)),q.Lf.Yl(o,-a.x,-a.y)),i.B7(t,n),e&&i.B7(t,e),o)&&q.Lf.Yl(o,a.x,a.y),o)&&(i.O1(n),e)&&i.O1(e)},i.prototype.jy=function(t,n){var e,i,r,o,a,u,s,c,e=this,i=e.Mf,r=i.Oi;if(t&&!(0<i.My)&&(n&&n.round(),o=i.Fi(),vt.Worksheet.et(i,"beforePaintAdornment",{ctx:t,clipRect:n}),!i.D_)){if(r){for(a=o.R1(),e.O1(a),s=0;s<=2;s++)(a=o.B1(s))&&0!==Tt(a)&&0!==St(a)&&e.O1(a);for(c=0;c<=2;c++)(a=o.L1(c))&&0!==Tt(a)&&0!==St(a)&&e.O1(a)}else if(i.NMi&&i.NMi.options.isDesignMode)for(c=0;c<=2;c++)!(a=o.L1(c))||0===Tt(a)||0===St(a)||(u=n)&&!a.intersectRect(u)||e.L7(t,-1,c,u,1);for(s=0;s<=2;s++)for(c=0;c<=2;c++)(a=o.c9(s,c))&&0!==Tt(a)&&0!==St(a)&&(u=n,(r&&(1!==s||1!==c)||i.parent&&i.parent.options.allowUserDragMerge)&&(e.O1(a),u=a),u&&!a.intersectRect(u)||e.L7(t,s,c,u));e.F7(t),vt.Worksheet.et(i,"paintAdornment",{ctx:t,clipRect:n})}},i.prototype.wm=function(t,n){var e,i,i,r,e,o,e=this.Mf,i=e.parent,i=i?i.options:{},r=rt(e),e=q.Pf.vl(e,r),o;i.backgroundImage&&(e=a),t.save(),t.fillStyle=e,t.fillRect(n.x,n.y,Tt(n),St(n)),t.restore()},i.prototype.P7=function(t,n){var e,i,r,e=this.Mf,i=e.Fi(),r=0<e.frozenRowCount()?0:1;return 0===i.qC&&(t===e.getViewportTopRow(r)||n)},i.prototype.G7=function(t,n){var e,i,r,e=this.Mf,i=e.Fi(),r=0<e.frozenColumnCount()?0:1;return 0===i.XC&&(t===e.getViewportLeftColumn(r)||n)},i.prototype.U7=function(t,n,e,i,r){var o,a,u,i,s,c,s,e,o=this,a=o.Mf,u=0===i.width,i=0===i.height,s=a.options,c=s.sheetAreaOffset.top,s=s.sheetAreaOffset.left,e=e.c9(t,n);return e&&(i&&o.P7(a.H7(t),r)&&(e.y=e.y-c,e.height=e.height+c),u)&&o.G7(a.z7(n),r)&&(e.x=e.x-s,e.width=e.width+s),e},i.prototype.V7=function(t,n,e,i){for(var r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,o,r=this,o=r.Mf,a=o.options,u=o.Fi(),s=a.sheetAreaOffset.top,c=a.sheetAreaOffset.left,f=0!==u.qC,l=0!==u.XC,h=o.gj&&o.gj()||{x:a.sheetAreaOffset.left,y:a.sheetAreaOffset.top,width:0,height:0},d=0===h.width,v=0===h.height,g=0;g<=2;g++)(b=u.L1(g))&&(f&&v&&(b.y=b.y-s,b.height=b.height+s,!l)&&d&&(b.x=b.x-c,b.width=b.width+c),p=n?b.getIntersectRect(n):b)&&r.Y7(t,g,p,e,i);for(m=0;m<=2;m++)for((w=u.B1(m))&&(l&&d&&(w.x=w.x-c,w.width=w.width+c,!f)&&v&&(w.y=w.y-s,w.height=w.height+s),p=n?w.getIntersectRect(n):w)&&r.Z7(t,m,p,e,i),g=0;g<=2;g++)(y=r.U7(m,g,u,h,e))&&(p=n?y.getIntersectRect(n):y)&&r.W7(t,m,g,p,e,i);(o=u.R1())&&(p=n?o.getIntersectRect(n):o)&&r.Q7(t,p,e,i)},i.prototype.K7=function(t){var n,e,i,r,o,a,u,s,c,f,l,i,h,n=this,e=n.Mf,i=e.Fi(),r=i.BA,o=i.LA,a=Tt(i),u=i.Ay,s=i.Iy,c=i.J7,f=i.Uy,l=i.X7,i=i.Ty;0<i&&(t.fillStyle=n.R7(!1),t.fillRect(r,l,a,i)),0<f&&(t.fillStyle=n.R7(!1),t.fillRect(c,o,f,l),h=e.Ny)&&t.fillRect(c,u,f,s)},i.prototype.q7=function(t,n){var e,i,r,i,o,i,a,u,s,n,e=this,i=e.Mf,r=e.R7(!1),i=i.options,o=i.sheetAreaOffset.left,i=i.sheetAreaOffset.top,a=n.x,u=n.y,s=Tt(n),n=St(n);t.save(),0<o&&U(t,o,r,a+o/2,0<i?u+i:u,a+o/2,u+E(0,n)),0<i&&U(t,i,r,0<o?a+o:a,u+i/2,a+E(0,s),u+i/2),0<o&&0<i&&(t.fillStyle=e.R7(!1),t.fillRect(a,u,o,i)),t.beginPath(),t.restore()},i.prototype.B7=function(t,n){var e,i,r,e=this,i=e.Mf;!t||0<i.My||(r=i.ot(),t.save(),n?t.rect(n.x,n.y,Tt(n),St(n)):t.rect(r.x,r.y,Tt(r),St(r)),t.clip(),t.beginPath(),e.wm(t,r),vt.Worksheet.et(i,"paint",{ctx:t,clipRect:n}),e.q7(t,r),e.V7(t,n,!1),e.K7(t),e.tO(t),vt.Worksheet.et(i,"paintSheetEnd",{ctx:t,clipRect:n}),t.beginPath(),t.restore())},i.prototype.nO=function(t,n,e){var i,r,r,n,i=this,r=i.Mf;t&&(r=r.ot(),t.save(),n=n||new q.Rect(r.x,r.y,Tt(r),St(r)),t.rect(n.x,n.y,Tt(n),St(n)),t.clip(),t.beginPath(),i.wm(t,r),i.V7(t,n,!0,e),t.beginPath(),t.restore())},i.prototype.F7=function(t){var n,e,i,r,o,a,u,s,c,s,c,u,u=this.Mf,s=u.rt,c=u.sw;if(s&&s.isResizing&&c&&(s=c.resizeInfo)){if(c=u.Fi(),u=et,t.save(),t.strokeStyle!==u&&(t.strokeStyle=u),1!==t.lineWidth&&(t.lineWidth=1),t.beginPath(),"sizeRow"===s.action||"sizeHiddenRow"===s.action)for(e=E(0,s.startY-.5),r=s.movingY-.5,o=c.x+Tt(c),n=c.x;n<o;n+=2)t.moveTo(n,e),t.lineTo(n+1,e),t.moveTo(n,r),t.lineTo(n+1,r);else for(n=E(0,s.startX-.5),i=s.movingX-.5,a=c.y+St(c),e=c.y;e<a;e+=2)t.moveTo(n,e),t.lineTo(n,e+1),t.moveTo(i,e),t.lineTo(i,e+1);t.stroke(),t.beginPath(),t.restore()}},i.prototype.Q7=function(t,n,e,i){var r,o,a,u,s,o,c,c,r=this.Mf;t.beginPath(),a=(o=r.Fi().R1()).x,u=o.y,s=Tt(o),o=St(o),c=r.getActualStyle(-1,-1,0),this.eO(t,[{data:Mt,row:-1,col:-1,x:a,y:u,width:s,height:o,style:c.clone()}],0,e,i),(c=new gt.Yx(r,r._y(0,0),r.Yy(0,0),0)).PN(0,0,a,u,s,o),c.paint(t)},i.prototype.tO=function(t){var n,e,i,r,o,a,u,s,c,f,l,h,d,a,n=this.Mf,e=n.frozenRowCount(),i=n.frozenColumnCount(),r=n.frozenTrailingRowCount(),o=n.frozenTrailingColumnCount();(e||i||r||o)&&(u=(a=n.Fi()).Py,s=a.Cy,c=a.Hy,f=a.Ay,l=a.x,h=a.y,d=Tt(a),a=St(a),t.save(),t.strokeStyle=q.Pf.vl(n,n.options.frozenlineColor),t.lineWidth=1,t.beginPath(),i&&(t.moveTo(u-.5,h),t.lineTo(u-.5,h+a)),e&&(t.moveTo(l,s-.5),t.lineTo(l+d,s-.5)),o&&(t.moveTo(c-.5,h),t.lineTo(c-.5,h+a)),r&&(t.moveTo(l,f-.5),t.lineTo(l+d,f-.5)),t.stroke(),t.restore())},i.prototype.Y7=function(t,n,e,i,r){this.iO(t,-1,n,1,e,i,r)},i.prototype.Z7=function(t,n,e,i,r){this.iO(t,n,-1,2,e,i,r)},i.prototype.W7=function(t,n,e,i,r,o){var a,a,u,s,c,r,a=this.Mf,a=a.getCalcService&&a.getCalcService(),u=a&&a.rO;for(s in u)u[s].getSource().startCalculation();if(this.iO(t,n,e,3,i,r,o),u)for(s in c=!a.calcOnDemand,u)u[s].getSource().endCalculation(c);(r=this.Mf.lA)&&r.oO(t,i,n,e)},i.prototype.aO=function(t,n,e,i,r){var o,a,u,a,n,e,o,a=this.Mf,u=a.getRangeRect(n,e,(0,q.Ec)(r.row,r.col,r.rowCount,r.colCount));(u=u.getIntersectRect(a.Fi().c9(n,e)))&&(u.round(),a=r.isValid,t.save(),t.lineWidth=1,t.strokeStyle="mediumblue",a||t.setLineDash([6,2]),n=u.x+.5,e=u.y+.5,t.strokeRect(n,e,Tt(u),St(u)),t.beginPath(),t.restore())},i.prototype.L7=function(t,n,e,i,r){var o,a,u,s,c,f,l,h,d,v,m,g,p,p,b,w,y,p,M,C,S,T,l,S,l,A,I,x,T,S,l,A,o=yt(r)||3===r,a=this,u=a.Mf;if(Q(u)&&u.addSelection&&(l=u.Ut,h=u.rt,v=(d=l.getSelections(r)).length,i=a.uO(n,e,i))&&(m=q.I.fl("gc-selection"),g=k(m.zIndex),o&&(2007<g&&a.sO(t,n,e,i),p=u.Uw&&u.Uw(3),p=l.cO=p&&p.t8.getAnchorInfo(u.getActiveRowIndex(),u.getActiveColumnIndex()))&&a.aO(t,n,e,i,p),y=void 0,!((w=(b=a.fO(n,e,d,i)).length)<=0))){for(p=o&&a.fO(n,e,[u.z9],i)[0],M=!1,C=void 0,C=0;C<w;C++)if(y=b[C],!i.containsRect(y)){M=!0;break}if(p&&!i.containsRect(p)&&(M=!0),t.save(),M&&(t.rect(i.x,i.y,Tt(i),St(i)),t.clip()),t.beginPath(),0<w)for(f=q.Pf.vl(u,u.getSelectionBackColor()),t.fillStyle!==f&&(t.fillStyle=f),c=s=0,2007<g&&(s=1,c=-3),C=0;C<w;C++)y=b[C],t.fillRect(y.x+s,y.y+s,Tt(y)+c,St(y)+c);u.RD||(S=u.ui,T=u.ci,1===r?(S=(l=l.J9()||d[0]).row,T=l.col):p&&(S=u.U9,T=u.H9),x=I=A=l=void 0,(S=u.getCellRect(S,T,n,e))&&S.intersectRect(i)&&(l=S.x,A=S.y,I=Tt(S),x=St(S),s=1,c=-2,2007<g&&(c=s=0),a.FA(l+s,A+s,I+c,x+c),1<v)&&(t.strokeStyle=q.Pf.vl(u,u.getSelectionBorderColor()),t.lineWidth=1,t.strokeRect(l+1.5,A+1.5,I-4,x-4))),t.restore(),t.save(),t.beginPath(),1===v&&(o&&h&&h.Yk&&h.lO&&h.lO()&&!h.hO&&(T=h.dO&&h.dO(),l=Tt(S=u.getRangeRect(n,e,T)),A=St(S),S)&&0<l&&0<A&&(t.fillStyle=m&&m.color,t.fillRect(S.x,S.y,l,A)),y)&&0<=Tt(y)&&0<=St(y)&&(a.vO(i,u,n,e,g),a.mO(t,n,e,y,i,d[0],r)),p&&(t.save(),M&&(t.rect(i.x,i.y,Tt(i),St(i)),t.clip()),t.beginPath(),t.fillStyle="rgba(255,255,255,0.4)",t.fillRect(p.x+s,p.y+s,Tt(p)+c,St(p)+c),t.fillStyle=f,t.strokeStyle="rgb(124,124,124)",t.lineWidth=1,t.strokeRect(p.x-.5,p.y-.5,Tt(p),St(p)),t.restore()),t.beginPath(),t.restore()}},i.prototype.vO=function(t,n,e,i,r){var o,a,u,s,o,a,c,f,r,l,u,h,d,v,u,r,l,f,c,o=n.frozenTrailingRowCount(),a=n.frozenTrailingColumnCount(),u=n.getSelections(),s=n.Fi(),o=n.getRowCount()-o-1,a=n.getColumnCount()-a-1,c=n.Yy(1,3),f=n._y(1,3);1===u.length&&2007<r&&(r=n.frozenRowCount(),l=n.frozenColumnCount(),h=(u=u[0]).row,d=u.col,v=u.rowCount,u=u.colCount,0<r&&(r<=h&&n.nI(h)<r?(t.y-=2,t.height+=2):h+v<=r&&n.j5(h+v-1)===n.Tb&&(t.height+=2)),0<l&&(l<=d&&n.r6(d)<l?(t.x-=2,t.width+=2):d+u<=l&&n.O5(d+u-1)===n.Ab&&(t.width+=2)),0===h&&0===d&&(t.x-=2,t.y-=2,t.width+=2,t.height+=2),-1===h&&(h=0,v=n.getRowCount()),-1===d&&(d=0,u=n.getColumnCount()),l=r=!1,f=f.findRow(o),c=c.findCol(a),f&&f.y+St(f)<s.Cy+n.Sy(s)&&(r=!0),c&&c.x+Tt(c)<s.Py+n.Gy(s)&&(l=!0),r&&h+v-1==o&&(t.height+=2),l)&&d+u-1==a&&(t.width+=2)},i.prototype.sO=function(t,n,e,i){var r,o,a,u,s,c,f,L,u,a,l,h,d,a,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,E,O,R,r=this,o=r.Mf,a=o.Ut.getSelections(),u=o.Fi(),s=u.b6,c=u.T6,f=a.length,L=0!==u.qC,u=0!==u.XC;if(!(f<=0)){if(l=(a=a[0]).row,h=a.rowCount,d=a.col,a=a.colCount,-1===l&&(l=0),-1===d&&(d=0),-1===h&&(h=o.getRowCount()),-1===a&&(a=o.getColumnCount()),t.save(),t.beginPath(),t.lineWidth=2,t.strokeStyle=o.getSelectionBorderColor(),v=i.x,m=i.y,g=Tt(i),p=St(i),b=o.frozenRowCount(),L&&(1!==f||0!==b||o.Tb<=l||o.Tb>=l+h))for(y=0,M=(w=r.gO(e)).length;y<M;y++)T=S=0,A=(C=w[y]).x,I=C.x+Tt(C),C.x<v+g&&v<C.x+Tt(C)&&(1===f&&(0===b&&o.Tb===l||0<b&&0===l)&&(S=-1,T=1),C.x<v&&(S=0,A=v),C.x+Tt(C)>v+g&&(T=0,I=v+g),t.moveTo(A+S-1,c-1),t.lineTo(I+T,c-1),t.stroke());if(x=o.frozenColumnCount(),u&&(1!==f||0!==x||o.Ab<=d||o.Ab>=d+a))for(k=0,_=(N=r.pO(n)).length;k<_;k++)E=j=0,O=(D=N[k]).y,R=D.y+St(D),D.y<m+p&&m<D.y+St(D)&&(1===f&&(0===x&&o.Ab===d||0<x&&0===d)&&(j=-1,E=1),D.y<m&&(j=0,O=m),D.y+St(D)>m+p&&(E=0,R=m+p),t.moveTo(s-1,O+j-1),t.lineTo(s-1,R+E),t.stroke());t.beginPath(),t.restore()}},i.prototype.gO=function(t){for(var n,e,i,r,o,a,u,s,c,f,l,h,d,u,v,l,h,d,n=this.Mf,e=n.Ut.getSelections(),i=e.length,r=n.Yy(t),o=[],a={},s=0;s<i;s++)(c=e[s])&&(-1===(f=c.col)?(l=n.Yy(0,3),h=n.Yy(1,3),d=n.Yy(2,3),v=u=-1,0<l.length&&(u=l[0].x,v=l[l.length-1].x+l[l.length-1].width-u,o.push(new q.Rect(u,-1,v,-1))),0<h.length&&(u=h[0].x,v=h[h.length-1].x+h[h.length-1].width-u,o.push(new q.Rect(u,-1,v,-1))),0<d.length&&(u=d[0].x,v=d[d.length-1].x+d[d.length-1].width-u,o.push(new q.Rect(u,-1,v,-1)))):r&&(l=r.findCol(f),h=r.findCol(f+c.colCount-1),l||h)&&((d=new q.Rect(-1,-1,-1,-1)).x=(l||r[0]).x,d.width=h?h.x+Tt(h)-d.x:r[r.length-1].x+r[r.length-1].width-d.x,a[u=[d.x,d.width].join("_")]||(a[u]=!0,o.push(d))));return o},i.prototype.pO=function(t){for(var n,e,i,r,o,a,u,s,c,f,l,h,d,u,v,l,h,d,n=this.Mf,e=n.Ut.getSelections(),i=e.length,r=n._y(t),o=[],a={},s=0;s<i;s++)(c=e[s])&&(-1===(f=c.row)?(l=n._y(0,3),h=n._y(1,3),d=n._y(2,3),v=u=-1,0<l.length&&(u=l[0].y,v=l[l.length-1].y+l[l.length-1].height-u,o.push(new q.Rect(-1,u,-1,v))),0<h.length&&(u=h[0].y,v=h[h.length-1].y+h[h.length-1].height-u,o.push(new q.Rect(-1,u,-1,v))),0<d.length&&(u=d[0].y,v=d[d.length-1].y+d[d.length-1].height-u,o.push(new q.Rect(-1,u,-1,v)))):r&&(l=r.findRow(f),h=r.findRow(f+c.rowCount-1),l||h)&&((d=new q.Rect(-1,-1,-1,-1)).y=(l||r[0]).y,d.height=h?h.y+St(h)-d.y:r[r.length-1].y+r[r.length-1].height-d.y,a[u=[d.y,d.height].join("_")]||(a[u]=!0,o.push(d))));return o},i.prototype.mO=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,M,T,u=this,s=u.Mf,c=s.parent,f=s.rt,l=i.x,h=i.y,d=Tt(i),v=St(i),m=s.getViewportTopRow(n),g=s.getViewportLeftColumn(e),p=s.getViewportBottomRow(n),b=s.getViewportRightColumn(e),w=0,y=0,M=s.Fi(),C=0!==M.qC,S;0!==M.XC||o.col!==g&&-1!==o.col||(w=2),C||o.row!==m&&-1!==o.row||(y=2),o.row+o.rowCount===p+1&&(r.height=r.height+1),o.col+o.colCount===b+1&&(r.width=r.width+1),0<=d&&0<=v&&(!r||i.intersect(r.x-1,r.y-1,Tt(r)+2,St(r)+2))&&(t.save(),r&&!r.containsRect(i)&&(t.rect(r.x-w,r.y-y,Tt(r),St(r)),t.clip()),t.beginPath(),t.strokeStyle=q.Pf.vl(s,s.getSelectionBorderColor()),t.lineWidth=2,0<d&&0<v?(f&&f.Yk?2===(M=f.bO)?(t.moveTo(l+.5,h-.5),t.lineTo(l+d-1,h-.5)):3===M?(t.moveTo(l+.5,h+v-.5),t.lineTo(l+d-1,h+v-.5)):0===M?(t.moveTo(l-.5,h+.5),t.lineTo(l-.5,h+v-1)):1===M&&(t.moveTo(l+d-.5,h+.5),t.lineTo(l+d-.5,h+v-1)):2007<(T=c&&c.SC)?t.rect(l-1,h-1,d+1,v+1):t.rect(l-.5,h-.5,d,v),t.stroke(),(yt(a)||3===a)&&c&&c.options.allowUserDragFill&&u.yO&&u.yO(t,n,e,i,r)):0!==d&&0!==v||t.strokeRect(l-1,h-1,d+1,v+1),t.beginPath(),t.restore())},i.prototype.uO=function(t,n,e){var i,r,o,n,n,n,i,i=this.Mf,r=i.Fi();return 0<=t&&0<=n?o=r.c9(t,n):-1===t?o=r.L1(n):-1===n&&(o=r.B1(t)),1===n&&(n=0<(n=i.Yy(n)).length?n[n.length-1]:Mt)&&(o.width=j(Tt(o),n.x+Tt(n)-r.Py)),1===t&&(i=0<(n=i._y(t)).length?n[n.length-1]:Mt)&&(o.height=j(St(o),i.y+St(i)-r.Cy)),e=e?e.getIntersect(o.x,o.y,Tt(o),St(o)):o},i.prototype.fO=function(t,n,e,i){for(var r,o,a,u,s,c,a,f,l,r=this.Mf,o=r.Ut,u=e.length,c=[],f=r.C6(t,n),l=0;l<u;l++)(s=e[l])&&((a=o.findSpan(s.row,s.col,f))&&a.containsRange(s)&&(s=a),a=r.getRangeRect(t,n,s))&&a.x<=i.x+Tt(i)&&a.y<=i.y+St(i)&&i.x<=a.x+Tt(a)&&i.y<=a.y+St(a)&&c.push(a);return c},i.prototype.wO=function(t,n,e){var i,r,o,n,a,u,s,c,f,l,h;if(t.save(),i=n.x,r=n.y,o=Tt(n),n=St(n),a=[6,6],t.setLineDash)t.beginPath(),t.lineWidth=2,t.strokeStyle=e,t.setLineDash(a),t.rect(i,r,o-1,n-1);else{for(t.beginPath(),t.lineWidth=2,t.strokeStyle=e,u=a[0],s=a[1],h=l=f=c=void 0,c=i,f=r,l=o;0<l;)if(u+s<=l)t.moveTo(c,f),t.lineTo(c+u,f),c=c+u+s,l=l-u-s;else{if(u<=l){t.moveTo(c,f),t.lineTo(c+u,f),l=l-u-s;break}if(0<l){t.moveTo(c,f),t.lineTo(c+l,f),l=l-u-s;break}}for(c=i+o-1,f=r+1,h=n-1,l<0&&(s<(l=w(l))&&(t.moveTo(c,f-2),t.lineTo(c,f+(l-s))),f+=l,h-=l);0<h;)u+s<=h?(t.moveTo(c,f),t.lineTo(c,f+u),f=f+u+s,h=h-u-s):u<=h?(t.moveTo(c,f),t.lineTo(c,f+u),h=h-u-s):0<h&&(t.moveTo(c,f),t.lineTo(c,f+h),h=h-u-s);for(c=i+o-2,f=r+n-1,l=o-1,h<0&&(s<(h=w(h))&&(t.moveTo(c+2,f),t.lineTo(c-(h-s),f)),c-=h,l-=h);0<l;)if(u+s<=l)t.moveTo(c,f),t.lineTo(c-u,f),c=c-u-s,l=l-u-s;else{if(u<=l){t.moveTo(c,f),t.lineTo(c-u,f),l=l-u-s;break}if(0<l){t.moveTo(c,f),t.lineTo(c-l,f),l=l-u-s;break}}for(c=i,f=r+n-2,h=n-1,l<0&&(s<(l=w(l))&&(t.moveTo(c,f+2),t.lineTo(c,f-(l-s))),f-=l,h-=l);0<h;)u+s<=h?(t.moveTo(c,f),t.lineTo(c,f-u),f=f-u-s,h=h-u-s):u<=h?(t.moveTo(c,f),f-u===r?t.lineTo(c,f-u-1):t.lineTo(c,f-u),h=h-u-s):0<h&&(r<f&&(t.moveTo(c,f),t.lineTo(c,f-h)),h=h-u-s)}t.stroke(),t.beginPath(),t.restore()},i.prototype.mfe=function(t,n,e,i,r,o){var i,a,u,s,c,f,l,h,d,v,m,g,m;if(!i&&0!==n.length){for(i=e.row,h=l=f=c=s=u=a=void 0,d=n.length-1;0<=d&&(v=n[d]).isOutside;d--)h=d;for(f=(p(h)?(a=(m=n[h]).col,u=m.x,s=m.width,2!==m.columnHeaderFitMode?(c=n[h].y,n[h]):(c=n[h+1].y,n[h+1])):(a=n[n.length-1].col+1,u=n[n.length-1].x+n[n.length-1].width,s=r.Jt.Kt(a,o),c=e.y,e)).height,a<r.getColumnCount(o)&&(l=r.Jt.qt(i,a,o)),bt.W.gfe(l,4)&&0<s&&r.getColumnVisible(a,o)&&t.push({style:l,x:u,y:c,width:s,height:f}),g=void 0,d=0;d<n.length&&(v=n[d]).isOutside;d++)g=d;f=(p(g)?(a=(m=n[g]).col,u=m.x,s=m.width,2!==m.columnHeaderFitMode?(c=n[g].y,n[g]):(c=n[g+1].y,n[g+1])):(a=n[0].col-1,s=r.Jt.Kt(a,o),u=n[0].x-s,c=e.y,e)).height,a<0||(l=r.Jt.qt(i,a,o),bt.W.gfe(l,5)&&0<s&&r.getColumnVisible(a,o)&&t.push({style:l,x:u,y:c,width:s,height:f}))}},i.prototype.MO=function(t,n,e,i,r,o,a){var r,u,s,s,r;r&&0!==n.length&&(r=n[0].col-1,u=n[n.length-1].col+1,s=e.Sl(i.row,r,a,1),0<=r&&o.isValid&&!o.isValid(i.row,r,s)&&t.push({style:o.getDataValidator(i.row,r).highlightStyle(),x:n[0].x-o.getColumnWidth(r),y:i.y,width:o.getColumnWidth(r),height:i.height}),s=e.Sl(i.row,u,a,1),o.isValid)&&!o.isValid(i.row,u,s)&&(r=n[n.length-1],t.push({style:o.getDataValidator(i.row,u).highlightStyle(),x:r.x+r.width,y:i.y,width:o.getColumnWidth(u),height:i.height}))},i.prototype.CO=function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,i=n.Jt,r=t.row,o=t.col,a={},u={},s=[],c=t.rowCount,f=t.colCount,l=0;l<f;l++)u[l]=n.nn(l+o,e);for(h=0;h<c;h++){if(a[h]=n.Gt(h+r,e),d=[],0<a[h])for(v=0;v<f;v++)d.push(0<u[v]?i.qt(r+h,o+v,e):T);s.push(d)}return{rowSizes:a,colSizes:u,styleList:s}},i.prototype.iO=function(t,l,h,d,v,m,s){var g,p,n,P,c,b,e,e,i,w,f,y,r,M,G,U,C,S,T,A,I,x,N,k,_,D,j,E,O,H,R,o,j,V,z,Y,Z,W,Q,J,K,n,X,q,$,tt,nt,n,e,L,et,B,F,it,rt,ot,n,at,ut,a,st,ct,ft,lt,lt,e,u;if(yt(d)&&(d=3),n=(p=(g=this).Mf).parent,P=n&&n.options.resizeZeroIndicator,c=p._y(l,d),b=p.yfe(h,d),e=p.options.sheetAreaOffset,e=p.gj&&p.gj()||{x:e.left,y:e.top,width:0,height:0},i=g.U7(l,h,p.Fi(),e,m),w=!1,f=c.length,y=b.length,!(f<0||y<0)){for(r=new mt.h9,M=0;M<y;M++)b[M].isOutside||r.push(b[M]);for(G=p.s7(l,h,d,!0),U=0<G.length,A=p.Jt,D=_=k=N=0,O=new gt.Yx(p,c,r,d),H=[],R=[],o=[],V=[],z=[],Y=!m&&3===d&&n&&n.options.highlightInvalidData,t.save(),t.beginPath(),Z=[],Q=W=-1,J=p.N9(3),K=p.k9(3),n=p.Fi(),X=0===n.qC&&0===e.height,q=0===n.XC&&0===e.width,$=!!wt(this.Mf),tt=!1,nt=ht("SheetsCalc"),n=p.getActiveRowIndex(),e=p.getActiveColumnIndex(),L=this.SO(d,p,n,e),B={},U&&(et=new dt.Common.rbush,G.forEach(function(t){et.insert({minX:t.row,minY:t.col,maxX:t.row+t.rowCount-1,maxY:t.col+t.colCount-1,item:t})})),M=0;M<f;M++){for(C=c[M],g.MO(V,r,A,C,Y,p,d),F=[],it=function(e){var t,t,t,n,n,i,r,o,a,u,s,c,s,f,a,u,s,a,s,u,a;if(S=b[e],U&&(B.minX=C.row,B.minY=S.col,B.maxX=C.row,B.maxY=S.col,t=et.search(B)[0],T=t&&t.item),T?(I=T.row,x=T.col,N=T.x,k=T.y,_=Tt(T),D=St(T),T.isAutoMerge&&(t=g.TO(T,l,h,d),N=t.x,k=t.y,_=t.width,D=t.height),T.spanSizeInfo||(T.spanSizeInfo=g.CO(T,p,d))):(I=C.row,x=S.col,N=S.x,_=Tt(S),-1===S.y?k=C.y:(k=Ct(S.y*C.height+C.y),w=!0),-1===St(S)?D=St(C):(D=C.height+C.y-k,w=!0)),1===P&&(-1===l&&p.getColumnVisible(x)&&0===p.Do(x)&&((Q<0||Q!==x-1)&&Z.push({x1:N,y1:k,x2:N,y2:k+D,horizontal:!1}),Q=x),-1===h)&&p.getRowVisible(I)&&0===p._o(I)&&((W<0||W!==I-1)&&Z.push({x1:N,y1:k,x2:N+_,y2:k,horizontal:!0}),W=I),v&&(N+_<=v.x||N>=v.x+Tt(v)||k+D<=v.y||k>=v.y+St(v))&&(!w||N>v.x+Tt(v))&&!S.isOutside)return"continue";if(0===_||0===D)return"continue";if(1===d&&e<y-1&&b[e+1].x-N==0)return"continue";if(F.push({col:x,x:N,y:k,width:_,height:D}),t=function(t){var n,n;t.columnHeaderFitMode!==pt.ColumnHeaderFitMode.normal&&e<y-1&&(n=p.O5(S.col,d,!0))&&(n=b.findCol(n))&&-1!==n.y&&(t.cornerX=n.x,t.columnHeaderFitMode===pt.ColumnHeaderFitMode.stack?t.cornerY=Ct(n.y*C.height)+C.y:t.cornerY=C.height+C.y)},S.isOutside)return(n=F[F.length-1]).isOutside=!0,n.columnHeaderFitMode=1===d&&p.Lt(x),t(n),n.columnHeaderFitMode===pt.ColumnHeaderFitMode.stack&&(n.width=A.Kt(x,d)),"continue";if(n=!1,!T||!At.OS(H,T)){if(i=!1,j=A.$t(I,x,d,1),r=p.AO&&p.AO(),o=p.getRowCount(pt.SheetArea.colHeader)-1,a=p.frozenRowCount(),u=p.getViewportTopRow(0),s=p.getViewportTopRow(1),!m&&L&&I===o&&x>=L.iw&&(0===a&&L.Ky+L.Sx>s||0<a&&0<u&&L.Ky+L.Sx>u)&&x<L.iw+L.Tx){if(j=p.getCell(L.Ky,x).text()+"",n=!0,i=L.filterButtonVisible(),r)for(c=0;c<r.length;c++)if(r[c].col===x&&r[c].rowFilter.nM===L){rt.IO(r[c],1,o,!0);break}}else if(r&&0<r.length&&(f=r[s=r.length-1].rowFilter&&r[s].rowFilter.nM))for(c=r.length-1;0<=c;c--)if(r[c].tableColumnHeaderFilter&&r[c].col===x){rt.IO(r[c],3,f.Ky,!1);break}E=A.qt(I,x,d),Y&&(a=A.Sl(I,x,d,1),p.isValid)&&!p.isValid(I,x,a)&&V.push({style:p.getDataValidator(I,x).highlightStyle(),x:N,y:k,width:_,height:D}),3===d&&(u=E.formatter,nt)&&u&&It(u)&&(!m||p.pivotTables&&p.pivotTables.findPivotTable(I,x))&&(s=p.parent&&p.parent.xO(u))&&(a=s.getExpression(),j=p.NO(u,a,I,x)),n&&(E.hAlign=0),t(j={data:j,row:I,col:x,x:N,y:k,width:_,sparkline:$&&p.getSparkline(I,x),height:D,style:E,colStyle:p.Z_(-1,x,d),cellLayout:T,tableFilter:i,columnHeaderFitMode:1===d&&p.Lt(x),offsetX:S.offsetX,sheetArea:d}),R.push(j),bt.W.Xue(E)&&z.push({style:E,x:N,y:k,width:j.columnHeaderFitMode===pt.ColumnHeaderFitMode.stack?p.getColumnWidth(x,d):_,height:D,columnHeaderFitMode:j.columnHeaderFitMode,cornerY:j.cornerY,cornerX:j.cornerX}),T&&H.push(T),j.style&&4===j.style.hAlign&&(tt=!0),s=(I===J||m&&0===M)&&X,u=(x===K||m&&0===e)&&q,a=m||!s&&!u?T:Mt,O.PN(I,x,N,k,_,D,E,a,s,u,j)}},rt=this,ot=0;ot<y;ot++)it(ot);0<F.length&&g.mfe(z,F,C,m,p,d)}if(0<R.length){if(3===d&&(p.options.allowCellOverflow||tt)&&(n=A.gl(l,h,function(){return new xt(p,l,h)}),0<(o=g.kO(t,n,R,O,s)).length)){for(at=v.x,ut=v.x+v.width,M=0;M<o.length;M++)(a=o[M])&&(st=a.row,ct=a.col,(ft=a.cellOverflowLayout&&a.cellOverflowLayout.layout)&&((lt=ft.x)<at&&(at=lt),ut<(lt=lt+ft.width))&&(ut=lt),O.PN(st,ct,a.x,a.y,a.width,a.height,a.style,a.cellLayout,st===J&&X,ct===K&&q,a));R=R.concat(o),m||(v.x=at,v.width=ut-at,i&&(v=v?i.getIntersectRect(v):i))}1===d&&w&&g.DO(R,r,O,v,m,i,J,K,X,q),v&&(e=p.printInfo&&p.printInfo(),m&&e&&(0<e.columnStart()||0<e.rowStart())&&!e.showBorder()?t.rect(v.x-(0<e.columnStart()?2:0),v.y-(0<e.rowStart()?2:0),Tt(v)+(0<e.columnStart()?4:0),St(v)+(0<e.rowStart()?4:0)):t.rect(v.x,v.y,Tt(v),St(v)),t.clip()),g.eO(t,R,d,m,s)}vt.Worksheet.et(p,"paintViewport",{ctx:t,rowViewportIndex:l,colViewportIndex:h,sheetArea:d,clipRect:v,isPrinting:m}),O.paint(t),0<Z.length&&g._O(t,Z,1,3),0<V.length&&(u=i.getIntersectRect(v),t.rect(u.x,u.y,Tt(u),St(u)),t.clip(),g.EO(t,V)),0<z.length&&(u=i?i.getIntersectRect(v):v,t.rect(u.x,u.y,Tt(u),St(u)),t.clip(),g.que(t,z,{isPrinting:m,printZoomFactor:s,sheet:p})),t.restore()}},i.prototype.IO=function(t,n,e,i){t.sheetArea=n,t.row=e,t.tableColumnHeaderFilter=i},i.prototype.SO=function(t,n,e,i){if(n.tables&&1===t){var t=n.tables.find(e,i),e=n.frozenRowCount(),i=n.getViewportTopRow(0),n=n.getViewportTopRow(1);if(t&&t.jO&&(0===e&&t.Ky<n||0<e&&0<i&&t.Ky<i))return t}return null},i.prototype.TO=function(t,n,e,i){var r,o,a,u,s,c,f,l,h,n,d,v,m,n,r,d,v,r=t.row,o=t.col,a=t.x,u=t.y,s=t.width,c=t.height,f=this.Mf,l=f.Fi();return 1!==n||3!==i&&2!==i||(h=l.B1(n),n=f.frozenRowCount(),d=f.getRowCount(i)-f.frozenTrailingRowCount()-1,u<(v=h.y)&&n<=r&&r<=d&&(c-=v-u,u=v),v+(m=h.height)<u+c&&n<=r+t.rowCount-1&&r+t.rowCount-1<=d&&(c-=u+c-(v+m))),1!==e||3!==i&&1!==i||(h=l.L1(e),n=f.frozenColumnCount(),r=f.getColumnCount(i)-f.frozenTrailingColumnCount()-1,a<(d=h.x)&&n<=o&&o<=r&&(s-=d-a,a=d),d+(v=h.width)<a+s&&n<=o+t.colCount-1&&o+t.colCount-1<=r&&(s-=a+s-(d+v))),new q.Rect(a,u,s,c)},i.prototype._O=function(t,n,e,i){var r,o,a,u,s,c,f,a,l,h,d,v,m,g,p,b;if(0!==n.length)for(r=0,o=n.length;r<o;r++)u=(a=n[r]).x1,s=a.y1,c=a.x2,f=a.y2,a=a.horizontal,t.beginPath(),t.save(),t.lineWidth=e,t.strokeStyle=this.OO(t,a,u,s,c,f),t.fillStyle=this.RO(t,a,u,s,c,f),a?(d=-(h=1),v=-2,t.fillRect(u,s+(l=-3),c-u-1,i+2*e),f+=.5,t.moveTo(u+-1,(s+=.5)+-3),t.lineTo(c+-2,f+-3),t.moveTo(u+-1,s+1),t.lineTo(c+-2,f+1)):(b=-(g=1),t.fillRect(u+(m=-3),s+(p=0),i+2*e,f-s-1),c+=.5,t.moveTo((u+=.5)+-3,s+0),t.lineTo(c+-3,f+-1),t.moveTo(u+1,s+0),t.lineTo(c+1,f+-1)),t.stroke(),t.restore()},i.prototype.RO=function(t,n,e,i,r,o){var a,u,s,c,s,f,l,h,d,u,s=q.I.He(0,"gc-"+(n?v:m)+"-normal"),c=s&&s.backgroundColor,s=s&&s.backgroundImage;if(!n&&s&&-1!==s.indexOf("linear-gradient"))for(f=q.mt.ri(s),a=t.createLinearGradient(e,i,r,o),l=0,h=f.length;l<h;l++)d=f[l],a.addColorStop(d.point,d.color);else c&&(a=c);return a},i.prototype.OO=function(t,n,e,i,r,o){var t,a,e,t=t.createLinearGradient(e,i,r,o),a,e=q.I.He(0,"gc-"+(n?v:m)+"-normal");return n?(t.addColorStop(0,e.borderTopColor),t.addColorStop(1,e.borderBottomColor)):(t.addColorStop(0,e.borderLeftColor),t.addColorStop(1,e.borderRightColor)),t},i.prototype.que=function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,o,i=n.length,r=0;r<i;r++)a=(o=n[r]).x,u=o.y,s=o.width,c=o.height,f=o.style,l=o.columnHeaderFitMode,h=o.cornerY,o=o.cornerX,e.columnHeaderFitMode=l,e.cornerY=h,e.cornerX=o,(0,d.paintStyleDecorationOutSideIcons)(t,new q.Rect(a,u,s,c),f.decoration.icons,f.vAlign,e)},i.prototype.EO=function(t,n){var e,i,r,o,a,u,s,c,f,l,u,h,e,i,r=this.Mf.BO();if(n)for(o=n.length,a=0;a<o;a++)s=(u=n[a]).x,c=u.y,f=u.width,l=u.height,0===(h=(u=u.style).type)&&this.LO(t,s,c,f,l,u),1===h&&this.FO(t,s,c,f,l,u),2===h&&this.PO(t,s,c,f,l,u,r)},i.prototype.LO=function(t,n,e,i,r,o){var o,n,e,i,r,a,u,a,s,c,i,r,o=o.color,n=n-4,e=e-4,i=i+8,r=r+8,a=.5522848,u=i/2*a,a=r/2*a,s=n+i,c=e+r,i=n+i/2,r=e+r/2;t.save(),t.lineWidth=2,t.strokeStyle=o,t.beginPath(),t.moveTo(n,r),t.bezierCurveTo(n,r-a,i-u,e,i,e),t.bezierCurveTo(i+u,e,s,r-a,s,r),t.bezierCurveTo(s,r+a,i+u,c,i,c),t.bezierCurveTo(i-u,c,n,r+a,n,r),t.closePath(),t.stroke(),t.restore()},i.prototype.FO=function(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,o;n-=.5,e-=.5,h=Math.min(i/2,r/2),d=o.color,o=o.position,t.save(),t.lineWidth=2,t.strokeStyle=d,t.beginPath(),t.rect(n,e,i,r),t.stroke(),t.restore(),t.save(),t.beginPath(),0===o?(s=a=n,c=(u=e)+h,f=a+h,l=u):2===o?(c=(u=e+r)-h,f=(s=a=n+i)-h,l=u):3===o?(s=a=n,c=(u=e+r)-h,f=a+h,l=u):1===o&&(c=(u=e)+h,f=(s=a=n+i)-h,l=u),t.moveTo(a,u),t.lineTo(s,c),t.lineTo(f,l),t.fillStyle=d,t.fill(),t.closePath(),t.restore()},i.prototype.PO=function(t,n,e,i,r,o,a){var u,s,c,f,l,h,d,v,m,o,g;if(n-=.5,e-=.5,s=(u=this.Mf).zoom(),h=l=15,d=o.image,v=o.position,m=3,o=o.color,t.save(),t.beginPath(),t.lineWidth=2,t.strokeStyle=o,t.rect(n,e,i,r),t.stroke(),d&&"none"!==d&&a){4===v?c=n-18:5===v&&(c=n+i+3);try{a.jt(d)?(g=a.Ot(d),f=e+r/2-7.5,t.drawImage(g,c,f,15,15)):a.Rt(d)}catch(t){}}else 4===v?c=n-18*s:5===v&&(c=n+i+3*s),t.translate(c,f=e+r/2-15*s/2),t.scale(.015*s,.015*s),t.beginPath(),t.moveTo(512,0),t.bezierCurveTo(229.248,0,0,229.184,0,512),t.bezierCurveTo(0,794.816,229.248,1024,512,1024),t.bezierCurveTo(794.752,1024,1024,794.752,1024,512),t.bezierCurveTo(1024,229.24800000000005,794.752,0,512,0),t.closePath(),t.moveTo(783.488,692.992),t.lineTo(692.9920000000001,783.4879999999999),t.lineTo(512,602.496),t.lineTo(331.00800000000004,783.4879999999999),t.lineTo(240.51200000000006,692.992),t.lineTo(421.504,512),t.lineTo(240.512,330.944),t.lineTo(331.008,240.44800000000004),t.lineTo(512,421.44),t.lineTo(692.992,240.384),t.lineTo(783.4879999999999,330.88),t.lineTo(602.496,512),t.lineTo(783.488,692.992),t.closePath(),t.fillStyle=o,t.fill(),t.stroke();t.restore()},i.prototype.eO=function(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,s,L,B,v,F,P,G,o,m,g,p,b,w,y,M,C,S,T,A,I,x,U,N,H,V,z,k,Y,_,D,_,Z,j,W,E,O,R,R,N,Q,J,K,X;for(void 0===a&&(a=0),void 0===u&&(u=0),void 0===s&&(s=1),f=(c=this).Mf,l=3===e,h=(o||f).zoom()*s,d=nt(c.Nn(),h),s=f.getDefaultStyle(e),L=f.$f(e),B=c.Mf.conditionalFormats,v=rt(f),F=f.k9(2),P=f.N9(1),G=(o||f).BO(),t.save(),t.beginPath(),o=et,s&&s.foreColor?(0,q.resetFillStyle)(t,f,s):t.fillStyle=o,tt(t,d.font),t.textAlign=l?"right":"center",p=n.length,j=[],E={sheet:f,row:-1,col:-1,fontInfo:Mt,lineHeight:-1,imageLoader:G,conditionalFormats:B,sheetArea:e,parentBackColor:v},O=[],m=0;m<p;m++)y=(b=n[m]).data,U=b.tableFilter,M=b.row,C=b.col,S=b.x,T=b.y,A=Tt(b),I=St(b),1!==e||O[M]||(O[M]=f.getRowHeight(M,e)),x=b.style,k=b.cellOverflowLayout,N=b.columnHeaderFitMode,H=b.cornerX,V=b.cornerY,Z=b.offsetX,z=b.colStyle,D=x.font?nt(x.font,h):d,i&&typeof r===it&&1!==r&&(D=nt(D.font,r)),x.font=D.font,0<A&&0<I&&(w=x.cellType||L,S--,T--,A++,I++,l?E.sparkline=b.sparkline:(_=i?0:c.GO(M,C,e),E.visualState=_),_=$(D.font),E.lineHeight=_,E.row=M+a,E.col=C+u,E.fontInfo=D,E.cellOverflowLayout=k,R=O.length&&I!==O[M]+1,E.needTopGridline=1===e&&M===P||0===e||R,E.needLeftGridline=2===e&&C===F||0===e||R,E.isPrinting=i,E.printZoomFactor=r,E.columnHeaderFitMode=N,E.cornerX=H,E.cornerY=V,E.offsetX=Z,E.colStyle=z,w._e(t,y,S,T,A,I,x,E,U),k)&&!E.showBarIconOnly&&(R=new q.Rect(S,T,A,I),N=w.In?w.In(t,R,x,E):R,j.push({cellType:w,data:y,x:N.x,y:N.y,width:N.width,height:N.height,style:x,richText:Y,options:{sheet:f,row:M,col:C,fontInfo:D,lineHeight:_,cellOverflowLayout:k,parentBackColor:v,imageLoader:G}}));if(0<(p=j.length))for(Q=f.isEditing(),J=f.ui,K=f.ci,g=0;g<p;g++)y=(W=j[g]).data,E=W.options,Q&&E.row===J&&E.col===K||(X=wt(this.Mf))&&y&&"SparklineExValue"===y.typeName||c.UO(t,W);for(t.restore(),p=n.length,m=0;m<p;m++)b=n[m],vt.Worksheet.et(f,"paintCell",{ctx:t,sheetArea:e,cell:b,isPrinting:i})},i.prototype.UO=function(t,n){var e,i,r,o,a,u,s,n,c,c,c,e=n.cellType,i=n.data,r=n.x,o=n.y,a=Tt(n),u=St(n),s=n.style,n=n.options,c=n.cellOverflowLayout;c&&e.pn&&(c=c.layout,c=new q.Rect(c?c.x:r,c?c.y:o,c?c.width:a,c?c.height:u),e.pn(t,c,n,i)),e.paintValue&&e.paintValue(t,i,r,o,a,u,s,n)},i.prototype.GO=function(t,n,e){var i,r,i=this.Mf,r=0;return Q(i)&&(3===e||yt(e)?!i.isEditing()&&i.HO(t,n)?r=3:i.ni(t,n,e)&&(r=2):(i.ni(t,n,e)&&(r=1,i.ei(t,n,e))&&(r=2),i.zO(t,n,e)&&(r=4))),r},i.prototype.kO=function(g,p,b,w,y){for(var M,C,t,S,T,A,I,x,N,k,_,D,j,E,O,R,L,B,F,P,G,U,n,e,i,M=this.Mf,C=M.Jt,t=b.length,x=[],G={},U=[],n=function(t){var n,e,i,r,o,a,u,s,c,f,l,h,d,v,m;if(S=b[t],I=S.row,N=S.col,k=S.y,D=St(S),L=p.b7(I,g,y),B=L.headingOverflowLayouts,F=L.trailingOverflowLayouts,!G[I]){for(n={},e=0,i=L;e<i.length;e++)r=i[e],n[r.column]=!1;B&&B.forEach(function(t){n[t.column]=!1}),F&&F.forEach(function(t){n[t.column]=!1}),G[I]=n}for(o=G[I],P=L.find(N),a=0;a<P.length;a++)if(u=P[a]){if(s=M.getCellRect(I,u.column,Mt,Mt,!0),!o[u.column]){if(c=u.column,(A=C.qt(I,c)).showEllipsis)continue;T=C.$t(I,c,3,1,A),_=u.columnWidth,j=u.backgroundWidth,E=u.backgroundLeftWidth<0?s.x:u.backgroundRightWidth<0?s.x+Tt(s)-j:4===A.hAlign?s.x+u.expandedWidth/2-u.backgroundLeftWidth:s.x+Tt(s)/2-u.backgroundLeftWidth,R={data:T,row:I,col:c,x:s.x,y:k,width:_,height:D,cellOverflowLayout:u,style:A},x.push(R),u.layout=new q.Rect(E,k,j,D),A=C.qt(I,c),w.EN(I,c,u,A,s.x,k,_,D),o[u.column]=!0}u.column===N&&o[u.column]&&U.push(t)}if(B)for(f=0;f<B.length;f++)(l=B[f])&&!o[l.column]&&l.contains(S.col)&&(N=l.column,(A=C.qt(I,N)).showEllipsis||(T=C.$t(I,N,3,1,A),_=l.columnWidth,j=l.backgroundWidth,h=M.getCellRect(I,l.endColumn,Mt,Mt,!0),E=h.x+Tt(h)-j,R={data:T,row:I,col:N,x:E,y:k,width:_,height:D,style:A,cellOverflowLayout:l},x.push(R),l.layout=new q.Rect(E,k,j,D),o[l.column]=!0,w.EN(I,N,l,A,E,k,_,D)));if(F)for(d=0;d<F.length;d++)(v=F[d])&&!o[v.column]&&v.contains(S.col)&&(N=v.column,(A=C.qt(I,N)).showEllipsis||(T=C.$t(I,N,3,1,A),_=v.columnWidth,j=v.backgroundWidth,m=M.getCellRect(I,v.startColumn,Mt,Mt,!0),E=m.x,O=m.x+j-_,R={data:T,row:I,col:N,x:O,y:k,width:_,height:D,style:A,cellOverflowLayout:v},x.push(R),v.layout=new q.Rect(E,k,j,D),w.EN(I,N,v,A,E,k,_,D),o[v.column]=!0))},e=0;e<t;e++)n(e);if(0<U.length)for(i=U.length-1;0<=i;i--)b.splice(U[i],1);function r(t,n){var e,i,t,n,e=t.row,i=n.row,t=t.col,n=n.col;return e!==i?e-i:t!==n?t-n:void 0}return 0<x.length&&x.sort(r),x},i.prototype.DO=function(t,n,e,i,r,o,a,u,s,c){for(var f,l,h,d,v,m,g,p,b,w,y,M,C,S,S,f=this,l=[],h=f.VO(t[0].col,t[0].x),d=[],v=0;v<h.length;v++)d.push(h[v]);for(v=0;v<n.length;v++)d.push(n[v]);for(e.Vx=d,m=[],g=e.Vx.length,b=0;b<g;b++)0<(p=e.Vx[b]).width&&m.push(p.col);if(m.push(m[m.length-1]+1),e.CN=m,0<(l=f.YO(h,t)).length){for(w=i.x,y=i.x+i.width,v=l.length-1;0<=v;v--)(M=l[v])&&((C=M.overflowLayout)&&((S=C.x)<w&&(w=S),y<(S=S+C.width))&&(y=S),t.unshift(M),e.PN(M.row,M.col,M.x,M.y,M.width,M.height,M.style,T,M.row===a&&s,M.col===u&&c,M));r||(i.width=y-w,o&&i&&o.getIntersectRect(i))}},i.prototype.VO=function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,p,b,w,y,e=new mt.h9,i,r=this.Mf,o=r.Jt,a=r.Ut,u=t,s=[],c=[],f=[],l=[],d=u,m=n,g=r.getColumnCount()-r.frozenTrailingColumnCount(),p=r.frozenColumnCount()-1,b=u-1;p<b;b--)if(s[b]=h=o.Kt(b),h){if(c[b]=a.getColumnHeaderFitMode(!1,pt.SheetArea.colHeader,b),f[b]=a.eE(-1,b,-1,1,pt.SheetArea.colHeader),l[b]=r.ZO(b,m,g,d,s,c,f,l),c[b]===pt.ColumnHeaderFitMode.normal)break;d=b,m-=h}for(w=d;w<u;w++)s[w]||(s[w]=o.Kt(w)),yt(c[w])&&(c[w]=a.getColumnHeaderFitMode(!1,pt.SheetArea.colHeader,w)),v=s[w],y=r.ZO(w,m,g,d,s,c,f,l),e.push(l[w]=y),m+=v;return e},i.prototype.YO=function(r,o){for(var t,a,u,s,e,c,f,l,h,d,v,m,g,p,b,v,n,w,i,y,t,a=this.Mf,u=a.Ut,s=a.Jt,e=a._y(1,1),f=[],n=e.length,w=r.length,i=function(i){var t,n;for(c=e[i],t=function(t){var n,e,n,t,n,n=r[t];if(n){if(l=c.row,h=n.col,p=n.x,b=-1===n.y?c.y:Ct(n.y*c.height+c.y),m=Tt(n),g=-1===St(n)?St(c):c.height+c.y-b,v=s.$t(l,h,1,1,d),d=s.qt(l,h,1),v={data:v,row:l,col:h,x:p,y:b,width:m,height:g,style:d,overflowLayout:n,columnHeaderFitMode:u.getColumnHeaderFitMode(!1,pt.SheetArea.colHeader,h),SheetArea:1},d.showEllipsis&&v.columnHeaderFitMode!==pt.ColumnHeaderFitMode.stack)return"continue";v.columnHeaderFitMode===pt.ColumnHeaderFitMode.stack&&(t===w-1?(e=o[0].col,n=o.filter(function(t){return t.row===i&&t.col===e})[0],v.cornerX=n&&n.x,v.cornerY=n&&n.y):(t=a.O5(h,1,!0))&&(n=r.findCol(t))&&-1!==n.y&&(v.cornerX=n.x,v.cornerY=Ct(n.y*c.height)+c.y)),f.push(v)}},n=0;n<w;n++)t(n)},y=0;y<n;y++)i(y);return f},b=i,t.g7=b,u=".cutCopyIndicator",A=q.Events.CellChanged,I=q.Events.ClipboardChanged,x=q.Events.ValueChanged,D=q.Events.ColumnChanged,O=q.Events.RowChanged,R=q.Events.RangeChanged,L=q.Events.ClipboardPasting,B=q.Events.ClipboardPasted,F=q.Events.DragMerging,P=q.Events.FloatingElementSelected,r.prototype._T=function(t){var n=this;if(0===arguments.length)return n.d7;n.d7=t},r.prototype.WO=function(t,n){var e,i,e=this;if(0===arguments.length)return e.h7;(e.h7!==t||t||n)&&(e.h7=t,i=e.Mf)&&(i.zw(),yt(e.QO)||clearTimeout(e.QO),e.QO=setTimeout(function(){var t;e.h7||(t=i.ST())&&t.c5(n),e.QO=Mt}))},r.prototype.v7=function(){var c,e,f,i,r;function o(){c.h7&&c.WO(!1)}function a(t,n,e){t||n===i||n===e||n===r||o()}e=(c=this).Mf,f=!1,i="resizable",r="isVisible",e.D3(I+u,function(){c.WO(!0)}),e.D3(x+u,o),e.D3(A+u,function(t,n){n.isUndo||"tag"===n.propertyName||n.KO||o()}),e.D3(D+u,function(t,n){a(n.isUndo,n.propertyName,"width")}),e.D3(O+u,function(t,n){a(n.isUndo,n.propertyName,"height")}),e.D3(R+u,function(t,n){n.isUndo||6===n.action||3===n.action||o()}),e.D3(L+u,function(){f=c.WO()}),e.D3(B+u,function(t,n){var e,n,i,r,o,a,u,s,e=n.cellRange,n=n.sheet.ST(),i=n._S,r=f;if(e&&i&&n.DS){if(c._T()){for(a=0,u=i;a<u.length;a++)if((s=u[a]).intersect(e.row,e.col,e.rowCount,e.colCount)&&!s.equals(e)){r=!1;break}}else o=!(r=!1);c.WO(r,o)}}),e.D3(F+u,o),e.D3(P+u,function(t,n){"worksheet"!==n.type&&(e.endEdit(),q.hi.N1(e))})},r.prototype.oO=function(t,n,e,i){var r,r,o,a,a,u,s,c,f,a,c,l,h,d,r=this;if(r.h7&&(o=(r=r.Mf).Dn,a=(a=r.parent)?a.options:{},s=(u=r.ST())._S,c=a.cutCopyIndicatorVisible,yt(c)&&(c=!0),f=q.Pf.vl(r,a.cutCopyIndicatorBorderColor||"blue"),c)&&u.DS===r&&s&&(a=o.uO(e,i,Mt),c=o.fO(e,i,s,n))&&a){for(t.save(),t.rect(a.x,a.y,Tt(a),St(a)),t.clip(),l=0,h=c;l<h.length;l++)d=h[l],o.wO(t,d,f);t.beginPath(),t.restore()}},r.prototype.JO=function(){this.WO(!1)},r.prototype.XO=function(){this.WO(!1)},r.prototype.qO=function(){this.WO(!1)},r.prototype.$O=function(){this.WO(!1)},r.prototype.lI=function(){this.WO(!1)},r.prototype.L0=function(){var t=this.Mf;t._3(A+u),t._3(I+u),t._3(x+u),t._3(D+u),t._3(O+u),t._3(R+u),t._3(L+u),t._3(B+u),t._3(F+u),t._3(P+u)},G=r,t.m7=G,vt.Worksheet.ch("render",{init:function(){var t=this;t.Dn=new b(t),t.lA&&t.lA.L0(),t.lA=new G(t)},dispose:function(t){var n,t,n=this;!1!==t.clearCache&&(n.Dn&&(n.Dn.Mf=Mt,n.Dn=Mt),t=n.lA)&&(t.L0(),n.lA=Mt)},onLayoutChanged:function(t){var n,e,t,n,e=this.lA;e&&("addRows"===(t=t.changeType)?e.JO():"deleteRows"===t?e.XO():"addColumns"===t?e.qO():"deleteColumns"===t&&e.$O())}})},"./dist/core/worksheet/worksheet-selection.js":function(t,n,e){"use strict";var i,y,n,r,o,d,p,M,C,S,a;function T(t,n){return t.getColumnCount(n)}function A(t,n){return t.getRowCount(n)}function I(t){return t.rowCount}function x(t){return t.colCount}function f(t,n,e){for(var i,r,o,a,i=[],r=t.length,a=0;a<r;a++)o=t[a],a===n?i=i.concat(e):i.push(o);return i}function N(t,n,e){for(var i=e-1;0<=i;i--)if(t.getColumnVisible(n+i))return n+i;return n+e-1}function k(t,n,e){for(var i=e-1;0<=i;i--)if(t.getRowVisible(n+i))return n+i;return n+e-1}Object.defineProperty(n,"__esModule",{value:!0}),i=e("./dist/core/worksheet/worksheet.js"),y=e("./dist/core/util/common.js"),n=e("Common"),r=e("./dist/core/util/domUtil.js"),o=e("./dist/core/core.enum.js"),d=n.Common.lt.ht,p=n.Common.Uf.tR,M=null,C=Math.max,S=Math.min,a="gc-selection",r.GC$.extend(i.Worksheet.prototype,{addSelection:function(t,n,e,i){this.n4(t,n,e,i,!1)},n4:function(t,n,e,i,r){var o,a,u,s,c,f,f,o=this,a=t,u=n,s=e,c=i;-1!==a&&-1!==u&&(f=o.Ut.getSpans())&&0<p(f)&&(a=(f=o.nR(f,(0,y.Ec)(t,n,e,i))).row,u=f.col,s=I(f),c=x(f)),o.Ut.do("addSelection",a,u,s,c,r),o.zw()},setSelection:function(t,n,e,i){this.eR(t,n,e,i,2)},eR:function(t,n,e,i,r){var o,a,u,u,a,r,o=this,a=A(o),u=T(o);u<=n&&(n=u-1),u=C(0,t=a<=t?a-1:t),a=C(0,n),o.IA(),r=2===r?y.hi.A1(o):1===r,o.O6(u,a,o.C0(u),o.S0(a),!r),o.n4(t,n,e,i)},getSelections:function(){return this.Ut.getSelections()},clearSelection:function(t){var n,t;void 0===t&&(t=1),(n=this).IA(),t=2===t?y.hi.A1(n):1===t,n.O6(0,0,n.C0(0),n.S0(0),!t),i.Worksheet.et(n,"clearSelection"),n.zw()},IA:function(t){this.Ut.do("clearSelection",t)},JA:function(t,n,e){var i,r,o,a,o,u,r,o,s,c,f,l,h,d,i=this,r=i.options,o=r.protectionOptions,a=!1!==o.allowSelectLockedCells,o=!1!==o.allowSelectUnlockedCells;if(!r.isProtected||a&&o)return!0;if(!a&&!o)return!1;if(r=n<0,o=t<0,a===(u=e?e.locked:i.l0(t,n,"locked"))&&(o||r)){for(f=(t=o?0:t)+(s=o?A(i):1)-1,l=(n=r?0:n)+(c=r?T(i):1)-1,d=h=void 0,h=t;h<=f;h++)for(d=n;d<=l;d++)if((e=i.getCompositeStyle(h,d))&&a!==e.locked)return!1;if(o)for(h=t;h<=f;h++)if((e=i.getCompositeStyle(h,-1))&&a!==e.locked)return!1;if(r)for(d=n;d<=l;d++)if((e=i.getCompositeStyle(-1,d))&&a!==e.locked)return!1}return a===u},iR:function(t,n,e,i){var r,o,a,r=this;for(n=n<0?0:n,o=t=t<0?0:t;o<t+e;o++)for(a=n;a<n+i;a++)if(r.l0(o,a,"locked"))return!0},rR:function(){for(var t,n,t=this.getSelections(),n=0;n<t.length;n++)if(-1!==t[n].col)return!1;return!0},oR:function(){for(var t,n,t=this.getSelections(),n=0;n<t.length;n++)if(-1!==t[n].row)return!1;return!0},selectionPolicy:function(t){var n=this,e=n.Ut;return 0===arguments.length?e.getSelectionPolicy():(e.do("setSelectionPolicy",t),n)},selectionUnit:function(t){var n=this,e=n.Ut;return 0===arguments.length?e.getSelectionUnit():(e.do("setSelectionUnit",t),n)},getSelectionBackColor:function(){return this.options.selectionBackColor||y.I.fl(a).backgroundColor},getSelectionBorderColor:function(){return this.options.selectionBorderColor||y.I.fl(a).borderTopColor},aR:function(t){if(!t)return this.options.aR;this.options.aR=t},e4:function(){var t,n,n,e,t=this,n=t.Ut.getSelections();0<p(n)&&(n={selections:n},0!==(e=t.Ut.getActiveSelectedRangeIndex())&&(n.activeSelectedRangeIndex=e),t.uR=n,t.IA(),t.Dn.E1())},cR:function(){var t=this,n=t.uR,e=n&&n.selections;e&&(t.Ut.do("setSelections",e),t.Ut.do("setActiveSelectedRangeIndex",n.activeSelectedRangeIndex||0))},pA:function(t,n,e,i){var r,o,a,i,a,t,r=this,a=r.tables,o=(e||i)&&(o=a&&a.fR(t,n))||r.lR(t,n,e,r.hR||0);o&&(i=o.row,a=o.col,t=o.leadingCellCol,r.dR(i,a))&&(r.qA=i,r.hR=t,r.XA(i,a))},lR:function(t,n,e,i){var r,o,a,u,s,c,r=this,o=A(r),a=T(r),u=t;return 0===u&&!e||0===o||0===a||(c=r.vR(u,i),e||r.mR(c),u=c.r,s=c.c,u<0&&e&&(i=s=(s=r.r6(s))<0||d(s)?r.r6(a):s,u=(c=r.vR(o,s)).r,(s=c.c)===n)&&u<=t)?M:{row:u,col:s,leadingCellCol:i}},bA:function(t,n,e){var i,e,t,n,e,i=this,e=i.gR(t,n,e,i.hR||0);!e||e.row===t&&e.col===n||(t=e.row,n=e.col,e=e.leadingCellCol,i.dR(t,n)&&(i.qA=t,i.hR=e,i.XA(t,n)))},gR:function(t,n,e,i){var r,o,a,u,s,c,r=this,o=A(r),a=T(r),u=t;if((u!==o-1||e)&&0!==o&&0!==a&&(c=r.pR(u,i),e||r.mR(c),u=c.r,s=c.c,!(u===o&&e&&(i=s=a<=(s=r.O5(s))||d(s)?r.O5(-1):s,u=(c=r.pR(-1,s)).r,(s=c.c)===n)&&t<=u)))return{row:u,col:s,leadingCellCol:i}},wA:function(){var t,n,e,n,t=this,n=t.bR();n&&(e=n.row,n=n.col,t.qA=e,t.hR=n,t.XA(e,n))},bR:function(){var t,n,e,i,r,o,a,o,u,t=this,n=t.P6(),e=t.G6(),i=e;if(n||i){if(a=!1!==(o=(r=t.options).protectionOptions).allowSelectLockedCells,o=!1!==o.allowSelectUnlockedCells,!r.isProtected||a&&o)return{row:n,col:i};if(a||o)for(;n!==M&&0<=n;n=t.nI(n))for(i=e;i!==M&&0<=i;i=t.r6(i))if(a===(u=t.l0(n,i,"locked")))return{row:n,col:i}}return M},yA:function(){var t,n,e,n,t=this,n=t.yR();n&&(e=n.row,n=n.col,t.qA=e,t.hR=n,t.XA(e,n))},yR:function(){var t,n,e,i,r,o,a,u,s,u,c,t=this,n=t.j5(t.frozenRowCount()-1),e=t.O5(t.frozenColumnCount()-1),i=e,r=t.P6(),o=t.G6();if(n!==M&&i!==M){if(s=!1!==(u=(a=t.options).protectionOptions).allowSelectLockedCells,u=!1!==u.allowSelectUnlockedCells,!a.isProtected||s&&u)return{row:n,col:i};if(s||u)for(;n!==M&&n<=r;n=t.j5(n))for(i=e;i!==M&&i<=o;i=t.O5(i))if(s===(c=t.l0(n,i,"locked")))return{row:n,col:i}}return M},mA:function(t,n,e){var i,r,o,o,t,n,i=this,o=i.tables,r=e&&(r=o&&o.wR(t,n))||i.sI(t,n,e,i.qA||0);r&&(o=r.row,t=r.col,n=r.leadingCellRow,i.dR(o,t))&&(i.qA=n,i.hR=t,i.XA(o,t))},sI:function(t,n,e,i){var r,o,a,u,s,c,f,r=this,o=A(r),a=T(r),s=n;if(0===s&&!e||0===o||0===a)return M;for(c=r.MR(i,s),f=i,e||r.mR(c),u=c.r,s=c.c;s<0&&e;){if(i=u=(u=r.nI(u,3,!0))<0||d(u)?r.nI(o,3,!0):u,u=(c=r.MR(i,a)).r,s=c.c,u===t&&s<n)return M;if(u===t&&s===n){if(i===f)return M;u=(c=r.MR(i,s)).r,s=c.c}}return{row:u,col:s,leadingCellRow:i}},mR:function(t){var n,e,e,n=this,e=!1;t.r<0?t.r=n.N9():t.r>=A(n)&&(t.r=n.P6(),e=!0),t.c<0?t.c=n.k9():t.c>=T(n)&&(t.c=n.G6(),e=!0),e&&((e=n.Ut.getSpan(t.r,t.c)).row!==t.r&&(t.r=e.row),e.col!==t.c)&&(t.c=e.col)},CA:function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,h,e=this,i=e.Ut,r=i.getActiveSelectedRangeIndex(),o=-1,a=e.JS(e.U5()),u=a.row,s=a.col,c=a.col+x(a)-1,f=t,l=n;f=(h=e.CR(f,l)).r,!(s<=(l=h.c));){if(o===r&&f===t&&l<=n)return;l=u<=--f?c+1:(h=e.JS(e.U5(3)),o=i.getActiveSelectedRangeIndex(),u=h.row,s=h.col,c=h.col+x(h)-1,f=h.row+I(h)-1,h.col+x(h))}0<=f&&(e.XA(f,l),e.qA=f,e.hR=l)},SA:function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,h,e=this,i=e.Ut,r=i.getActiveSelectedRangeIndex(),o=-1,a=e.JS(e.U5()),u=a.col,s=a.row+I(a)-1,c=a.col+x(a)-1,f=t,l=n;f=(h=e.TR(f,l)).r,!((l=h.c)<=c);){if(o===r&&f===t&&n<=l)return;l=++f<=s?u-1:(h=e.JS(e.U5(4)),o=i.getActiveSelectedRangeIndex(),u=h.col,s=h.row+I(h)-1,c=h.col+x(h)-1,f=h.row,h.col-1)}0<=f&&(e.XA(f,l),e.qA=f,e.hR=l)},TA:function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,h,e=this,i=e.Ut,r=i.getActiveSelectedRangeIndex(),o=-1,a=e.JS(e.U5()),u=a.row,s=a.row+I(a)-1,c=a.col,f=t,l=n;f=(h=e.AR(f,l)).r,l=h.c,!(u<=f);){if(o===r&&l===n&&f<=t)return;c<=--l?f=s+1:(h=e.JS(e.U5(1)),o=i.getActiveSelectedRangeIndex(),u=h.row,s=h.row+I(h)-1,c=h.col,f=h.row+I(h),l=h.col+x(h)-1)}0<=l&&(e.XA(f,l),e.qA=f,e.hR=l)},AA:function(t,n){for(var e,i,r,o,a,u,s,c,f,l,h,h,e=this,i=e.Ut,r=i.getActiveSelectedRangeIndex(),o=-1,a=e.JS(e.U5()),u=a.row,s=a.row+I(a)-1,c=a.col+x(a)-1,f=t,l=n;f=(h=e.IR(f,l)).r,l=h.c,!(f<=s);){if(o===r&&l===n&&t<=f)return;++l<=c?f=u-1:(h=e.JS(e.U5(2)),o=i.getActiveSelectedRangeIndex(),s=h.row+I(h)-1,c=h.col+x(h)-1,f=h.row-1,l=h.col)}0<=l&&(e.XA(f,l),e.qA=f,e.hR=l)},gA:function(t,n,e){var i,r,o,o,e,t,i=this,o=i.tables,r=e&&(r=o&&o.xR(t,n))||i.uI(t,n,e,i.qA||0);!r||r.row===t&&r.col===n||(o=r.row,e=r.col,t=r.leadingCellRow,i.dR(o,e)&&(i.qA=t,i.hR=e,i.XA(o,e)))},uI:function(t,n,e,i){var r,o,a,u,s,c,f,r=this,o=A(r),a=T(r),s=n;if(s===a-1&&!e||0===o||0===a)return M;for(c=r.NR(i,s),f=i,e||r.mR(c),u=c.r,s=c.c;s===a&&e;){if(t===o-1&&t===u&&(!r.getRowVisible(u,3)||r.Gt(u,3)<=0))return M;if(i=u=o<=(u=r.j5(u,3,!0))||d(u)?r.j5(-1,3,!0):u,u=(c=r.NR(i,-1)).r,s=c.c,u===t&&n<s)return M;if(u===t&&s===n){if(i===f)return M;u=(c=r.NR(i,s)).r,s=c.c}}return{row:u,col:s,leadingCellRow:i}},MR:function(t,n){for(var e,i,r,o,o,e=this,r=n;0<=r&&(i=t,!(--r<0));)if(e.getColumnVisible(r)&&((o=e.Ut.getSpans((0,y.Ec)(i,r,1,1)))&&0<p(o)&&r>=(o=o[0]).col&&(r=o.col,i=o.row),e.dR(i,r)))return{r:i,c:r};return{r:i,c:r}},CR:function(t,n){for(var e,i,r,e=this;0<=n&&!(--n<0);){if(i=e.Ut.findSpan(t,n)){if(!((r=e.U5()).row<=i.row&&i.row+I(i)<=r.row+I(r)&&r.col<=i.col&&i.col+x(i)<=r.col+x(r)))continue;if(i.row!==t||i.col!==n)continue;n>=i.col&&(n=i.col,t=i.row)}if(e.dR(t,n))return{r:t,c:n}}return{r:t,c:n}},NR:function(t,n){for(var e,i,r,o,a,a,u,e=this,i=T(e),o=n;o<i&&!(i<=(o=(a=e.Ut.getSpan(r=t,o)).col+x(a)));)if(e.getColumnVisible(o)&&((a=e.Ut.getSpans((0,y.Ec)(r,o,1,1)))&&0<p(a)&&(o>(u=a[0]).col?o=C(o,u.col+x(u)):r=u.row),e.dR(r,o)))return{r:r,c:o};return{r:r,c:o}},TR:function(t,n){for(var e,i,r,o,o,a,e=this,i=e.Ut,r=T(e);n<r&&!(r<=(n=(o=i.getSpan(t,n)).col+x(o)));){if(o=i.findSpan(t,n)){if(!((a=e.U5()).row<=o.row&&o.row+I(o)<=a.row+I(a)&&a.col<=o.col&&o.col+x(o)<=a.col+x(a)))continue;if(o.row!==t||o.col!==n)continue;n>o.col?n=C(n,o.col+x(o)):t=o.row}if(e.dR(t,n))return{r:t,c:n}}return{r:t,c:n}},dR:function(t,n){var e,i,r,o,e=this;return!!e.JA(t,n)&&(i=0<=t&&t<A(e)&&0<=n&&n<T(e)&&e.getRowVisible(t)&&e.getColumnVisible(n)&&0<e.Gt(t)&&0<e.nn(n),r=!!e.F5,!0!==i||!0!=r||!1!==(o=e.l0(t,n,"tabStop")))&&i},vR:function(t,n){for(var e,i,i,e=this;0<=t&&!(--t<0);)if(e.getRowVisible(t)&&((i=e.Ut.getSpans((0,y.Ec)(t,n,1,1)))&&0<p(i)&&t>=(i=i[0]).row&&(t=i.row,n=i.col),e.dR(t,n)))return{r:t,c:n};return{r:t,c:n}},AR:function(t,n){for(var e,i,r,e=this;0<=t&&!(--t<0);){if(i=e.Ut.findSpan(t,n)){if(!((r=e.U5()).row<=i.row&&i.row+I(i)<=r.row+I(r)&&r.col<=i.col&&i.col+x(i)<=r.col+x(r)))continue;if(i.row!==t||i.col!==n)continue;t>=i.row&&(n=i.col,t=i.row)}if(e.dR(t,n))return{r:t,c:n}}return{r:t,c:n}},pR:function(t,n){for(var e,i,r,r,o,e=this,i=A(e);t<i&&!(i<=(t=(r=e.Ut.getSpan(t,n)).row+I(r)));)if(r=e.Ut.getSpans((0,y.Ec)(t,n,1,1)),e.getRowVisible(t)&&(r&&0<p(r)&&(t>(o=r[0]).row?t=C(t,o.row+I(o)):n=o.col),e.dR(t,n)))return{r:t,c:n};return{r:t,c:n}},IR:function(t,n){for(var e,i,r,o,o,a,e=this,i=e.Ut,r=A(e);t<r&&!(r<=(t=(o=i.getSpan(t,n)).row+I(o)));){if(o=i.findSpan(t,n)){if(!((a=e.U5()).row<=o.row&&o.row+I(o)<=a.row+I(a)&&a.col<=o.col&&o.col+x(o)<=a.col+x(a)))continue;if(o.col!==n||o.row!==t)continue;t>o.row?t=C(t,o.row+I(o)):n=o.col}if(e.dR(t,n))return{r:t,c:n}}return{r:t,c:n}},D9:function(t,n,e,i,r,o){var a=this;a.Ut.do("addSelection",t,n,e,i,M,o),r&&a.My<=0&&a.Dn.E1(M,M,M,M,o)},L9:function(t,n,e){var i,t,n,r,o,t,a,u,i=this,t=i.xA(t,n,i.ui,i.ci),n=t.row,r=t.col,o=I(t),t=x(t),a=i.selectionPolicy(),u=i.selectionUnit();0!==a&&(1===a&&i.Ut.do("clearSelection"),1===u?t=r=-1:2===u&&(o=n=-1),i.kA(n,r,o,t,e))},xA:function(t,n,e,i,r,o){var a,u,e,i,u,t,a=this;return d(e)&&(e=a.ui),d(i)&&(i=a.ci),e=(u=a.Ut).getSpan(e,i,o),i=u.getSpan(t,n,o),r&&e.equals(i)?new y.Range(e.row,e.col,1,1):(u=e.union(i),(t=a.Ut.getSpans(M,o))&&0<p(t)?a.kR(t,u):u)},kA:function(t,n,e,i,r){var o,a,u,s,c,f,c,f,a,o=this,a=o.Ut,u=o.U5();0<p(a.getSelections())?(c=(0,y.Ec)(t,n,e,i),o.O9?(s=o.z9,o.z9=c):((f=a.getSelections())[a.getActiveSelectedRangeIndex()]=c,a.do("setSelections",f))):o.O9||a.do("addSelection",t,n,e,i),r&&o.My<=0&&(c=o.U5(),!o.O9&&c.row===u.row&&c.col===u.col&&I(c)===I(u)&&x(c)===x(u)||(f=o.Dn,o.O9&&(a=o.z9,s&&s.containsRange(a)?a=s:s&&(a=s.union(a)),u=(a=a.union((0,y.Ec)(o.getActiveRowIndex(),o.getActiveColumnIndex(),1,1))).union(u),c=a.union(c)),u.containsRange(c)?f.E1(u):c.containsRange(u)?f.E1(c):(f.E1(u),f.E1(c),f.E1(o.z9))))},DR:function(t){var n=[];return n=t?this.Ut.getSpans(t):n},_R:function(t,n){var e=t.row,i=t.col,r=t.rowCount,o=t.colCount,a=n.row,u=n.col,s=n.rowCount,c=n.colCount,r=e+r,o=i+o,f=a+s,l=u+c,h=!1,d=!1,v;return t.intersect(a,u,s,c)&&(d=!(h=v=a<e||u<i||r<f||o<l)),n.ER=n.ER||d,h},jR:function(t,n,e,i){for(var r,o,a,r=[],o=[],a=0;a<t.length;a++)o=this.RR(t[a],n,e,i),r=r.concat(o);return r},RR:function(t,n,e,i){var r,o,a,u,a,s,c,r=[],o=n.length;for(r.push(t),s=o-1;0<=s;s--)for(u=n[s],c=0;c<r.length;)a=r[c],this._R(a,u)?(r=f(r,c,a=this.BR(a,u,e,i)),c+=a.length):c++;return r},LR:function(t,n){var e=n.row,i=n.col,r=n.rowCount,n=n.colCount;return t.intersect(e,i,r,n)},FR:function(t,n){for(var e,i,r,o,e,i=[],o=t.length-1;0<=o;o--)r=t[o],this.LR(r,n)||i.push(r);return i},PR:function(t){var n=!1,e=this.Ut.getSpans(t);return n=1===e.length?t.equals(e[0]):n},GR:function(t,n){for(var e,t,i,r,o,a,u,s,e=t,t=n.length,i=e.length,r=!0,u=t-1;0<=u;u--){for(a=n[u],s=i-1;0<=s;s--)if((o=e[s]).equals(a)){r=!1;break}r&&e.push(a)}return e},UR:function(t){for(var n,e,i,r,o,a,n,e=[],r=t.length-1;0<=r;r--)(i=t[r]).ER&&(delete i.ER,e.push(r));for(o=e.length,a=0;a<o;a++)t.splice(e[a],1)},BR:function(t,n,e,i){var r,n,e,i,o,a,u,s,c,f,o,l,h,n;return n=this.JS(n),r=[],n=t.getIntersect(n,e,i),t&&n?(e=0<=t.row?t.row:0,i=0<=t.col?t.col:0,o=t.rowCount,a=t.colCount,u=n.row,s=n.col,c=n.rowCount,l=i+a,n=s+(f=n.colCount),0<(o=e+o)-(h=u+c)&&r.push((0,y.Ec)(h,i,o-h,a)),0<l-n&&r.push((0,y.Ec)(u,n,c,l-n)),0<s-i&&r.push((0,y.Ec)(u,i,c,s-i)),0<u-e&&r.push((0,y.Ec)(e,i,u-e,a))):r.push(t),r},tD:function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,g,e=[],i=this.getRowCount(3),r=this.getColumnCount(3),o=this.deselectIgnoreSpan();if(t&&0<t.length){for(s=[],c=[],h=l=void 0,a=!(f=[]),d=(u=t.length)-1;0<=d;d--)l=t[d],o||!this.PR(l)||this.LR(l,n)?(s=this.BR(l,n,i,r),o||0<(h=this.DR(l)).length&&(s=this.jR(s,h,i,r),f=this.FR(h,n),c=this.GR(c,f),this.UR(c)),v=p(s),!a&&0<v&&(this.setSelection(s[v-1].row,s[v-1].col,1,1),a=!0),e=s.concat(e)):c=this.GR(c,[l]);o||(e=c.concat(e))}for(this.IA(),m=e.length,this.suspendPaint(),g=0;g<m;g++)this.n4(e[g].row,e[g].col,e[g].rowCount,e[g].colCount);a||this.setActiveCell(this.ui,this.ci),this.resumePaint()},HA:function(t,n){var e,i,r,r,t,n,o,r,a,u,a,e=this,i=e.Ut.getSelections();p(i)<=0||(r=e.U5(),(r=e.HR(r,t,n))&&(t=r.row,n=r.col,o=I(r),r=x(r),a=e.selectionPolicy(),u=e.selectionUnit(),0!==a)&&(1===a&&e.Ut.do("clearSelection"),1===u?r=n=-1:2===u&&(o=t=-1),e.kA(t,n,o,r,!0),a=e.Ut.getSelections(),e.rt._A(i,a))&&(e.EA(i,a),e.jA(i)))},HR:function(t,n,e,i,r){var o,a,u,o=this,a=o.JS(t),u=M;return 37===n?u=e?o.zR(a,!1,i,r):o.VR(a,i,r):39===n?u=e?o.YR(a,!1,i,r):o.ZR(a,i,r):38===n?u=e?o.WR(a,!1,i,r):o.QR(a,i,r):40===n?u=e?o.KR(a,!1,i,r):o.JR(a,i,r):36===n?u=e?o.XR(a,i,r):o.qR(a,i,r):35===n?u=e?o.$R(a,i,r):o.tB(a,i,r):33===n?u=o.nB(a,i,r):34===n&&(u=o.eB(a,i,r)),u&&(t.row<0&&(u.row=-1,u.rowCount=o.getRowCount()),t.col<0)&&(u.col=-1,u.colCount=o.getColumnCount()),u},VR:function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,l,m,g,p,b,w,i=this,r=t.row,o=t.col,a=I(t),u=x(t),s=o+u-1,c=0,f=k(i,r,a);0<s;)if(i.dR(f,--s)&&(l=i.xA(f,s,n,e),h=S(r,l.row),d=S(o,l.col),m=(v=C(r+a-1,l.row+I(l)-1))-h+1,g=(l=S(o+u-1,l.col+x(l)-1))-d+1,h!==r||d!==o||m!==a||g!==u))return p=i.Ab,o<(b=i.ci)?d<=p&&i.o9(d):o===b&&l<=p&&i.o9(l),(w=i.parent&&i.parent.options.scrollByPixel)&&d===p&&0!==i.my&&i.o9(d,0),(0,y.Ec)(h,d,m,g);return M},zR:function(t,n,e,i){var r,o,a,u,s,s,u,n,r,s,e,c,f,r=this,o=t.row,a=t.col,u=r.frozenColumnCount(),s=u?r.O5(u-1):r.k9(),s=n?s:r.k9();if(!d(s))return(u<=0||n)&&r.o9(s),u=r.xA(o,s,e,i),n=S(o,u.row),r=S(a,u.col),s=C(o+I(t)-1,u.row+I(u)-1),e=S(a+x(t)-1,u.col+x(u)-1),(0,y.Ec)(n,r,c=s-n+1,f=e-r+1)},iB:function(t){var n,e,i,r,o,i,a,n=this,e;if(n.parent&&n.parent.options.scrollByPixel){for(o=n.Jt,i=n.S0(t),a=n.getViewportWidth(i);0<=t&&!((a-=o.Kt(t))<0);t--);i=t,r=a}else i=n.rB(t,2).col,r=0;return{iw:i,Xy:r}},ZR:function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,l,m,g,p,b,w,i=this,r=t.row,o=t.col,a=I(t),u=x(t),s=o,c=T(i)-1,f=k(i,r,a);s<c;)if(i.dR(f,++s)&&(l=i.xA(f,s,n,e),h=S(r,l.row),d=C(o,l.col),m=(v=C(r+a-1,l.row+I(l)-1))-h+1,g=(l=C(o+u-1,l.col+x(l)-1))-d+1,h!==r||d!==o||m!==a||g!==u))return p=i.oB(),o<(b=i.ci)?p<=d&&(w=i.iB(d),i.o9(w.iw,w.Xy)):o===b&&p<=l&&(w=i.iB(l),i.o9(w.iw,w.Xy)),(0,y.Ec)(h,d,m,g);return M},YR:function(t,n,e,i){var r,o,a,u,u,n,r,u,e,i,s,c,r=this,o=t.row,a=t.col,u=r.aB();if(!d(u))return r.o9(u),u=r.G6(),n||(u+=r.frozenTrailingColumnCount()),n=r.xA(o,u,e,i),r=S(o,n.row),u=C(a,n.col),e=C(o+I(t)-1,n.row+I(n)-1),i=C(a+x(t)-1,n.col+x(n)-1),(0,y.Ec)(r,u,s=e-r+1,c=i-u+1)},QR:function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,m,g,l,p,b,w,i=this,r=t.row,o=t.col,a=I(t),u=x(t),s=r+a-1,c=0,f=N(i,o,u);0<s;)if(i.dR(--s,f)&&(l=i.xA(s,f,n,e),h=S(r,l.row),d=S(o,l.col),g=(v=S(r+a-1,l.row+I(l)-1))-h+1,l=(m=C(o+u-1,l.col+x(l)-1))-d+1,h!==r||d!==o||g!==a||l!==u))return p=i.Tb,r<(b=i.ui)?h<=p&&i.$A(h):r===b&&v<=p&&i.$A(v),(w=i.parent&&i.parent.options.scrollByPixel)&&h===p&&0!==i.ly&&i.$A(h,0),(0,y.Ec)(h,d,g,l);return M},WR:function(t,n,e,i){var r,o,a,u,s,s,u,n,r,s,e,c,f,r=this,o=t.row,a=t.col,u=r.frozenRowCount(),s=u?r.j5(u-1):r.N9(),s=n?s:r.N9();if(!d(s))return(u<=0||n)&&r.$A(s),u=r.xA(s,a,e,i),n=S(o,u.row),r=S(a,u.col),s=S(o+I(t)-1,u.row+I(u)-1),e=C(a+x(t)-1,u.col+x(u)-1),(0,y.Ec)(n,r,c=s-n+1,f=e-r+1)},uB:function(t){var n,e,i,r,o,i,a,n=this,e;if(n.parent&&n.parent.options.scrollByPixel){for(o=n.Jt,i=n.C0(t),a=n.getViewportHeight(i);0<=t&&!((a-=o.Gt(t))<0);t--);i=t,r=a}else i=n.Jy(t,2),r=0;return{Ky:i,Xy:r}},JR:function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,m,g,l,p,b,w,i=this,r=t.row,o=t.col,a=I(t),u=x(t),s=r,c=A(i)-1,f=N(i,o,u);s<c;)if(i.dR(++s,f)&&(l=i.xA(s,f,n,e),h=C(r,l.row),d=S(o,l.col),g=(v=C(r+a-1,l.row+I(l)-1))-h+1,l=(m=C(o+u-1,l.col+x(l)-1))-d+1,h!==r||d!==o||g!==a||l!==u))return p=i.sB(),r<(b=i.ui)?p<=h&&(w=i.uB(h),i.$A(w.Ky,w.Xy)):r===b&&p<=v&&(w=i.uB(v),i.$A(w.Ky,w.Xy)),(0,y.Ec)(h,d,g,l);return M},KR:function(t,n,e,i){var r,o,a,u,u,n,r,u,e,i,s,c,r=this,o=t.row,a=t.col,u=r.cB();if(!d(u))return r.$A(u),u=r.P6(),n||(u+=r.frozenTrailingRowCount()),n=r.xA(u,a,e,i),r=C(o,n.row),u=S(a,n.col),e=C(o+I(t)-1,n.row+I(n)-1),i=C(a+x(t)-1,n.col+x(n)-1),(0,y.Ec)(r,u,s=e-r+1,c=i-u+1)},qR:function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,m,g,l,i=this,r=t.row,o=t.col,a=I(t),u=x(t),s=i.frozenColumnCount()-1,c=i.ci,f=r+a-1;s<c;)if(i.dR(f,++s)){if(o<=s&&o+u-1===i.ci)break;return l=i.xA(f,s,n,e),h=S(r,l.row),d=S(o,l.col),g=(v=C(r+a-1,l.row+I(l)-1))-h+1,l=(m=S(o+u-1,l.col+x(l)-1))-d+1,i.o9(i.k9()),(0,y.Ec)(h,d,g,l)}return M},XR:function(t,n,e){return t=this.zR(t,!0,n,e),t=this.WR(t,!0,n,e)},tB:function(t,n,e){for(var i,r,o,a,u,s,c,f,l,h,d,v,m,g,l,i=this,r=t.row,o=t.col,a=I(t),u=x(t),s=T(i),c=i.ci,f=r+a-1;c<s;)if(i.dR(f,--s)){if(s<=o+u-1&&o===i.ci)break;return l=i.xA(f,s,n,e),h=S(r,l.row),d=C(o,l.col),g=(v=C(r+a-1,l.row+I(l)-1))-h+1,l=(m=C(o+u-1,l.col+x(l)-1))-d+1,i.o9(i.aB()),(0,y.Ec)(h,d,g,l)}return M},$R:function(t,n,e){return t=this.YR(t,!0,n,e),t=this.KR(t,!0,n,e)},nB:function(t,n,e){var i,r,o,a,u,s,c,f,u,s,i,f,n,l,h,i=this,r=t.row,o=t.col,a=I(t),u=i.QA();return d(u)?M:(s=i._y(1),f=-1,(c=i.$A(u))?f=i.j5(r+a-1-p(s)):i.frozenRowCount()<=0&&(f=i.N9()),f<i.Tb?f=i.Tb:f>=i.sB()&&(f=i.nI(i.sB())),u=i.xA(f,o,n,e),s=S(r,u.row),i=S(o,u.col),f=S(r+a-1,u.row+I(u)-1),n=C(o+x(t)-1,u.col+x(u)-1),(0,y.Ec)(s,i,l=f-s+1,h=n-i+1))},eB:function(t,n,e){var i,r,o,a,u,s,u,s,i,u,n,e,c,f,i=this,r=t.row,o=t.col,a=I(t),u=i.tI();return d(u)?M:(s=i._y(1),i.$A(u),(u=i.nI(r+a-1+p(s)))<i.Tb?u=i.Tb:u>=i.sB()&&(u=i.Tb>=i.cB()?i.sB():i.nI(i.sB())),s=i.xA(u,o,n,e),i=C(r,s.row),u=S(o,s.col),n=C(r+a-1,s.row+I(s)-1),e=C(o+x(t)-1,s.col+x(s)-1),(0,y.Ec)(i,u,c=n-i+1,f=e-u+1))},QA:function(){var t,n,n,e,i,r,o,t=this,n=t._y(1);if(!n||p(n)<=0)return M;for(e=(n=t.frozenRowCount())?t.j5(n-1):t.N9(),i=0,r=t.Tb,o=t.Fi();e<r&&!((i+=t.Gt(--r))>t.Sy(o)););return r},fB:function(){var t,n,n,e,i,r,o,t=this,n=t.Yy(1);if(!n||p(n)<=0)return M;for(e=(n=t.frozenColumnCount())?t.O5(n-1):t.k9(),i=0,r=t.Ab,o=t.Fi();e<r&&!((i+=t.nn(--r))>t.Gy(o)););return r},tI:function(){var t,n,t,t=this._y(1),n=p(t);return t&&0<n?(t=t[n-1].row,this.P6()<=t?this.Tb:t):M},cB:function(){var t,n,e,i,e,i,r,t=this;if(t.P6()===t.sB()&&(n=t.Fi(),e=t._y(1),i=p(e),e)&&1<=i&&(e=e[i-1]).y+e.height<=n.Cy+t.Sy(n))return t.Tb;i=t.Tb;try{return t.Tb=t.P6(),r=t.QA(),r=t.j5(r)}catch(t){}finally{t.Tb=i}},aB:function(){var t,n,e,i,e,r,o,t=this;if(t.G6()===t.oB()&&(n=t.Fi(),e=t.Yy(1),i=p(e),e)&&1<=i&&(e=e[i-1]).x+e.width<=n.Py+n.width)return t.Ab;for(n=t.Fi(),r=0,o=t.G6();0<o&&!((r+=t.nn(o))>t.Gy(n));)o--;return o=0<o?t.O5(o):o},sB:function(){var t=this._y(1),n=p(t);return t&&0<n?t[n-1].row:M},oB:function(){var t=this.Yy(1),n=p(t);return t&&0<n?t[n-1].col:M},iD:function(){var t,n,e,i,e,t=this,n=t._y(1),e=p(n);return n&&0<e?(i=t.Fi(),(n[e=e-1].y+n[e].height<=i.Cy+t.Sy(i)?n[e]:n[C(e-1,0)]).row):M},rD:function(){var t,n,e,i,e,t=this,n=t.Yy(1),e=p(n);return n&&0<e?(i=t.Fi(),(n[e=e-1].x+n[e].width<=i.Py+t.Gy(i)?n[e]:n[C(e-1,0)]).col):M},P6:function(t){var n=A(this,t=d(t)?3:t);return 3!==t&&2!==t||(n-=this.frozenTrailingRowCount()),this.nI(n,t)},G6:function(t){var n=T(this,t=d(t)?3:t);return 3!==t&&1!==t||(n-=this.frozenTrailingColumnCount()),this.r6(n,t)},kR:function(t,n){var e,i,r;if(t)for(e=0,i=p(t);e<i;e++)if(r=t[e],n.intersect(r.row,r.col,I(r),x(r)))return t.splice(e,1),e--,this.kR(t,n.union(r));return n},U5:function(t){var n,e,i,r,o,n,e=this.Ut,i=p(e.getSelections()),r=(0,y.Ec)(-1,-1,0,0);return i<=0||(o=e.getActiveSelectedRangeIndex(),3===t||1===t?e.do("setActiveSelectedRangeIndex",o=--o<0?i-1:o):4!==t&&2!==t||e.do("setActiveSelectedRangeIndex",o=i<=++o?0:o),0<=(o=e.getActiveSelectedRangeIndex())&&(r=e.getSelections()[o])),r}}),i.Worksheet.ch("selection",{init:function(){this.Ut.do("addSelection",0,0,1,1),this.Ut.setCellState(0,0,o.CellStatesType.active,!0,o.SheetArea.viewport)}})},"./dist/core/worksheet/worksheet-sort.js":function(i,t,o){"use strict";var e,t,g,w,n,y,n,p,n,b,u,h,M,s,c,C,f,l,S;function _(t,n,e){for(var i=t[e-n];i<e;)i=t[i-n];return i}function d(t,n){return"object"==typeof t?JSON.stringify(t):(t=n.getColor(t),e.Common.ft.j(e.Common.ft._(t)))}function T(t,n){return t instanceof Date&&n instanceof Date?u(t)===u(n):typeof t==c&&typeof n==c?t.toLowerCase()===n.toLowerCase():t===n}function A(t,n,e,i,r){var o,a,u,t,t=t.currentTheme();return o=(a=(a=M(n)||(a=r?n.backColor:n.foreColor,M(a))?a:d(a,t))||"")===(u=(u=M(e)||(u=r?e.backColor:e.foreColor,M(u))?u:d(u,t))||"")?0:a===i?1:u===i?-1:0}function I(t,n){var e,i,r,o,a;return t instanceof Date&&(t=u(t)),n instanceof Date&&(n=u(n)),r=(e=typeof t)==c,o=(i=typeof n)==c,a=i==C,e==i||e!=C&&!a?e==s&&o||(!r||i!=s)&&(r&&o?t.toLowerCase()>n.toLowerCase():n<t):a}function v(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,h,b,w,b,w,u=r,s=t,c=n;if(u)for(f=0;f<u.length&&(u[f]&&(l=u[f].ascending,0<=(h=u[f].index))&&(v=d=void 0,m=i?s:h,g=i?h:s,p=i?c:h,h=i?h:c,v=o?(d=o[m][g],o[p][h]):(d=e.getValue(m,g),e.getValue(p,h)),u[f].compareFunction?(a=u[f].compareFunction(d,v),l||(a*=-1)):M(u[f].color)?(b=M(d)||""===d||typeof d==C&&isNaN(d),w=M(v)||""===v||typeof v==C&&isNaN(v),b||w?b&&w?a=0:b&&!w?a=1:!b&&w&&(a=-1):a=T(d,v)?0:I(d,v)?l?1:-1:l?-1:1):(b=e.getActualStyle(m,g,3,!1,!1,!(w=b=void 0)),w=e.getActualStyle(p,h,3,!1,!1,!0),a=A(e,b,w,u[f].color,u[f].isBackColor),l||(a*=-1))),0===a);f++);return a}function x(t,n,e,i,r){var o,a,u,s,c,f,l,h,o=t.length;if(o<=1)return t;for(u=t[a=Math.floor(o/2)],s=[],c=[],f=[],l=0;l<o;l++)(a===l?f:(h=v(t[l],u,n,e,i,r))<0?s:0<h?c:f).push(t[l]);return x(s,n,e,i,r).concat(f,x(c,n,e,i,r))}function N(t,n,e){var i,r,o,i=[];if(n)for(r=e.length-1;0<=r;r--)o=e[r],0===t.getRowHeight(o)&&(e.splice(r,1),i.push({lp:r,y4:o}));else for(r=e.length-1;0<=r;r--)o=e[r],0===t.getColumnWidth(o)&&(e.splice(r,1),i.push({lp:r,y4:o}));return i}function k(t,n){for(var e,i,e=t.length-1;0<=e;e--)i=t[e],n.splice(i.lp,0,i.y4)}function D(t,n,e,i,r,o,a,u,s){for(var c,f,l,h,i,d,v,m,c=o?i:r,f=o?n:e,l=[],h=0;h<c;h++)l[h]=f+h;for(i=u.ignoreHidden?N(t,o,l):[],d=l.concat([]),v=!1,l=x(l,t,o,a,s),m=0;m<l.length;m++)if(l[m]!==d[m]){v=!0;break}return k(i,l),{array:l,isChanged:v}}function j(t,n,e,i,r,o,a,u,s){var c,f,i,r,l,h,d,n,e,c=o?i:r,f=o?n:e,i=o?t.rowOutlines:t.columnOutlines,r=i.lB(f,c),l=i.hB(r,u.groupSort);if(!l){for(h=[],d=0;d<c;d++)h.push(f+d);l=[h]}for(d=0;d<l.length;d++)l[d]=x(l[d],t,o,a,s);return e=(n=i.dB(l,r,u.groupSort)).array,n.isChanged&&m(t,o,n,e,r,f,c),{array:e,isChanged:n.isChanged}}function m(t,n,e,i,r,o,a){var u,s,c,f,l,u=n?t.rowOutlines:t.columnOutlines,s=[],c=[];if(n){for(f=o;f<o+a;f++)t.XT(f)||t.rowOutlines&&t.rowOutlines.isCollapsed(f)||(t.getRowVisible(f,3,!0)?0===t.getRowHeight(f)&&(s.push(f),t.setRowHeight(f,t.defaults.rowHeight)):(c.push(f),t.setRowVisible(f,!0)));for(u.vB(e.groupSwap,e.array,r.start),f=0;f<c.length;f++)l=h.hD(i,c[f])+o,t.setRowVisible(l,!1);for(f=0;f<s.length;f++)l=h.hD(i,s[f])+o,t.setRowHeight(l,0)}else{for(f=o;f<o+a;f++)t.columnOutlines&&t.columnOutlines.isCollapsed(f)||(t.getColumnVisible(f,3)?0===t.getColumnWidth(f)&&(s.push(f),t.setColumnWidth(f,t.defaults.colWidth)):(c.push(f),t.setColumnVisible(f,!0)));for(u.vB(e.groupSwap,e.array,r.start),f=0;f<c.length;f++)l=h.hD(i,c[f])+o,t.setColumnVisible(l,!1);for(f=0;f<s.length;f++)l=h.hD(i,s[f])+o,t.setColumnWidth(l,0)}}function E(t,n,e){var t=t.oT(n,e,!1);t&&t.hasListeners()&&t.mB()}function O(t,n,e,i){var r,r,i,r=o("SheetsCalc");r&&(r=r.CalcOperatorAdjustor.gB(t.rT,t.rT,t.pB(n,e),n,e,0,0),t.bB(n,e,r,i),i=t.oT(n,e,!!r))&&(t.Ile(n,e)&&i.isDefault(!0),i.yB())}function R(t,n,e,i,r,o,a,u,s,c,f,l){for(var h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,y=t.Ut,M=y.pI,S=M&&0<M.wB.length,A=o?n:e,I=o?n+i:e+r,N=o?e:n,k=o?e+r:n+i,T=A;T<I;T++)if(T!==(C=_(u,A,T)))for(o?(h=T,v=C):(d=T,m=C),x=N;x<k;x++)o?m=d=x:v=h=x,a&&(g=s[h][d],p=s[v][m]),S&&(b=M.get(h,d),w=M.get(v,m)),f&&l&&(E(f,h,d),E(f,v,m),f.SE(h,d,v,m),O(f,h,d),O(f,v,m)),y.do("swapNode",h,d,v,m),t.b8&&t.MB(h,d,v,m),S&&M.CB(b,h,d,w,v,m),a&&(s[h][d]=p,s[v][m]=g),c.push({row:h,col:d}),c.push({row:v,col:m})}function L(t,n,e,i,r,o,a,u,s,c,f){var l,h,d,n,v,m,g,p,b,l=[],h=t.Ut.P8;if(0<h&&n&&(t.Ut.P8=0,[].push.apply(t.Ut.G8,[{row:e,column:i,rowCount:r,columnCount:o,byRows:a,sortInfo:u,type:"sortRange",array:c.concat([])}])),d=y&&t.b3(),n=y&&t.Uw(),R(t,e,i,r,o,a,s,c,f,l,d,n),s)for(v=e;v<e+r;v++)for(m=i;m<i+o;m++)t.setValue(v,m,f[v][m]);if(d){for(g=e;g<e+r;g++)for(p=i;p<i+o;p++)(b=d.pB(g,p))&&d.SB(g,p,b,S);t.getCalcService().recalcRange(n,e,i,r,o)}return w.Worksheet.et(t,"sortRangeChanged",{column:i,columnCount:o}),0<h&&(t.Ut.P8=h),l}function B(t,n,e,i,r,o,a,u,s,c){var f,l,h,d,v,m;t.suspendPaint(),t.suspendEvent(),y&&t.suspendCalcService();try{if(c)for(l=[],h=n;h<n+i;h++)for(l[h]=[],d=e;d<e+r;d++)l[h][d]=t.getValue(h,d);return m=v=void 0,(v=s||(m=(0===u.groupSort?D:j)(t,n,e,i,r,o,a,u,l)).array)?(f=L(t,m&&m.isChanged,n,e,i,r,o,a,c,v,l),!0):!1}finally{y&&t.resumeCalcService(!1),t.resumeEvent(),t.resumePaint(),t.SI(n,e,i,r,f,4,S,S,S,!!s)}}function F(t,n){for(var e,i,r,o,a,u,s,e=[],i=0,r=n;i<r.length;i++)(o=r[i]).compareFunction?(a=o,e.push({index:a.index,ascending:a.ascending,compareFunction:a.compareFunction})):o.order&&o.hasOwnProperty(f)?(u="top"!==(a=o).order,s=M(a.backColor)?"":d(a.backColor,t.currentTheme()),e.push({index:a.index,ascending:u,color:s,isBackColor:!0})):o.order&&o.hasOwnProperty(l)?(u="top"!==(a=o).order,s=M(a.fontColor)?"":d(a.fontColor,t.currentTheme()),e.push({index:a.index,ascending:u,color:s,isBackColor:!1})):(o.color&&(o.color=d(o.color,t.currentTheme())),e.push(o));return e}Object.defineProperty(t,"__esModule",{value:!0}),e=o("Common"),t=o("./dist/core/util/domUtil.js"),g=o("./dist/core/util/common.js"),w=o("./dist/core/worksheet/worksheet.js"),n=o("CalcEngine"),y=!!n,n=o("./dist/core/core.ns.js"),p=o("./dist/core/core.enum.js"),n=new e.Common.ResourceManager(n.SR,"Sheets"),b=n.getResource.bind(n),u=e.Common.ct.o0,h=e.Common.Uf,M=e.Common.lt.ht,s="boolean",c="string",C="number",f="backColor",l="fontColor",S=void 0,t.GC$.extend(w.Worksheet.prototype,{sortRange:function(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,f,l,f,l,v,m,f,l,f,c=this,f=c.getRowCount(),l=c.getColumnCount();if(-1===e&&(e=f),-1===n&&(n=0),-1===i&&(i=l),(t=-1===t?0:t)<0||f<=t||n<0||l<=n||e<0||f<t+e||i<0||l<n+i||!o)return!1;if(a=c.TB(g.Ec(t,n,e,i),r,a),f=r?c.rowOutlines:c.columnOutlines,!u&&0<a.groupSort){if(!f)return!1;l=f.lB(d=r?t:n,h=r?e:i),r?(e=l.count,t=l.start):(i=l.count,n=l.start)}return y&&!c.mT(t,n,e,i,!1)?(s&&c.jT(7,b().Exp_InvalidSortArrayFormulaInRange),!1):(f=c.Ut.getSpans(g.Ec(t,n,e,i)))&&0<f.length?(s&&c.jT(7,b().Exp_InvalidSortSpanInRange),!1):!(l=c.tables)||(m=1===(v=l.AB(t,n,e,i)).length&&v[0].dataRange().equals(g.Ec(t,n,e,i)),v.length<=0)||m?(f=c.H3,l=(!c.NMi||c.NMi._gi!==p.SheetType.ganttSheet)&&f&&f._dataSource||m&&v[0]&&v[0].z3(),(f=B(c,t,n,e,i,r,F(c,o),a,u,l))&&0!==a.groupSort&&c.IB&&c.IB.reFilter(),f):(s&&c.jT(7,b().Exp_InvalidSortPartTableOrMultiTableInRange),!1)},TB:function(t,n,e){var i,t,r,o,a,n,i=this,t=i.JS(t),r=n?t.rowCount:t.colCount,o=n?t.row:t.col,a=n?i.rowOutlines:i.columnOutlines;return M(e)&&(e={}),i.outlineColumn&&i.outlineColumn.xB()&&n&&(n=i.outlineColumn.NB.columnIndex,t.col<=n&&n<=t.col+t.colCount||(e.groupSort=0)),M(e.groupSort)&&(M(e.ignoreHidden)?e.groupSort=a&&a.kB(o,r)?1:0:e.groupSort=0),0===e.groupSort?e.ignoreHidden=!!M(e.ignoreHidden)||e.ignoreHidden:e.ignoreHidden=!1,e},_B:function(){var t=this.options;return!t.isProtected||t.protectionOptions.allowSort},MB:function(t,n,e,i){var r=this,o=r.getDataValidator(t,n),a=r.getDataValidator(e,i);r.setDataValidator(t,n,a),r.setDataValidator(e,i,o)}})},"./dist/core/worksheet/worksheet-static.js":function(i,t,P){"use strict";var n,G,r,I,e,U,H,p,B,g,V,N,z,Y,e,l;function Z(t,n){return t.getRowCount(n)}function W(t,n){return t.getColumnCount(n)}function k(t,n,e){return t.Do(n,e)}function _(t,n,e){return t._o(n,e)}function D(t,n,e,i){t.setColumnWidth(n,e,i)}function j(t,n,e,i){t.setRowHeight(n,e,i)}function E(t,n,e,i,r){return t.getActualStyle(n,e,i,N,N,N,r)}function o(t,n){return t.getDefaultStyle(n)}function a(t,n,e){t.setDefaultStyle(n,e)}function O(t,n,e,i,r){t.u5(n,e,i,r)}function h(t,n,e,i){throw new Error(r.Common.zf.I5(l().Exp_InvalidAndSpace,[t,n,e,i]))}function Q(t,n,e){return n&&e.XT&&e.XT(t)}function K(t,n,e,i,r,o,a,u,s){var c,t,f,i,e,o,u,t;if(!t)throw new Error(l().Exp_SrcIsNull);if(!i)throw new Error(l().Exp_DestIsNull);c=Z(t),t=W(t),f=Z(i),i=W(i),(n<-1||c<=n)&&h("from row index",n,"-1",c-1),(e<-1||t<=e)&&h("from column index",e,"-1",t-1),(r<-1||f<=r)&&h("to row index",r,"-1",f-1),(o<-1||i<=o)&&h("to column index",o,"-1",i-1),(e=e)<0&&(e=0,u=t),o=o<0?0:o,(u<1||t<e+u||i<o+u)&&h("column count",u,"1",z(t-e,i-o)),(u=n)<0&&(u=0,a=c),t=r<0?0:r,(a<1||c<u+a||f<t+a)&&h("row count",a,"1",z(c-u,f-t))}function F(t){if(!t)return t;if("number"==typeof t||"string"==typeof t||"boolean"==typeof t||B(t))return t;if(t.clone)return t.clone();if(t instanceof Date)return new Date(t.valueOf());var n,e,i,n=t instanceof Object?new t.constructor:new t.constructor(t.valueOf());for(e in t)t.hasOwnProperty(e)&&(i=t[e],t.hasOwnProperty(e))&&n[e]!==i&&(n[e]="object"==typeof i?F(i):i);return n.toString=t.toString,n.valueOf=t.valueOf,n}function m(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,p,b,w,y,y,c=t.getSpans(N,s),f=i.getSpans(N,s),l=[];if(c)for(h=0;h<c.length;h++)v=(d=c[h]).row,m=d.col,g=d.rowCount,p=d.colCount,-1===n?e<=m&&m+p<=e+u&&l.push((0,G.Ec)(v,o+m-e,g,p)):-1===e?n<=v&&v+g<=n+a&&l.push((0,G.Ec)(r+v-n,m,g,p)):n<=v&&v<n+a&&e<=m&&m<e+u&&l.push((0,G.Ec)(r+v-n,o+m-e,g,p));if(f)for(h=0;h<f.length;h++)v=(d=f[h]).row,b=void 0,w=o<=(m=d.col)&&m<o+u,y=r<=v&&v<r+a,(b=-1===n?w:-1===e?y:y&&w)&&(y=i.findSpan(v,m,s))&&y.row===v&&y.col===m&&i.do("removeSpan",y,s);for(h=0;h<l.length;h++)i.do("addSpan",l[h],s)}function X(t,n,e,i,r,o,a,u,s,c){var f,l,i,t,f=t.conditionalFormats,l=i.conditionalFormats,i=v(t,i);f&&l&&!t.EB&&(t=f.jB(n,e,l,r,o,a,u,i,c),s)&&f.OB(n,e,a,u,t,i)}function q(t,n,e,i,r,o,a,u,s,c){var f,l;n<0&&(n=0,a=z(Z(t),Z(i))),r<0&&(r=0),e<0&&(e=0,u=z(W(t),W(i))),o<0&&(o=0),(f=!(t===i&&t.name()===i.name()))?(l=i.RB)&&(s?0<t.RB.count()&&l.BB(t,n,e,r,o,a,u):l.LB(t,n,e,r,o,a,u,N,c)):(l=t.RB)&&(s?0<l.count()&&l.iE(n,e,r,o,a,u):l.tE(n,e,r,o,a,u,N,c))}function $(t,n,e,i,r,o){var a,u,s;n<0&&(n=0,r=z(W(t),W(e))),i<0&&(i=0),a=t.columnOutlines,u=e.columnOutlines,(s=!(t===e&&t.name()===e.name()))?a&&u&&u.FB(a,n,i,r,o):a&&a.PB(n,i,r,o)}function tt(t,n,e,i,r,o){var a,t,e;n<0&&(n=0,r=z(Z(t),Z(e))),i<0&&(i=0),a=!(t===e&&t.name()===e.name()),t=t.rowOutlines,e=e.rowOutlines,a?t&&e&&e.FB(t,n,i,r,o):t&&t.PB(n,i,r,o)}function d(t,n,e,i,r,o,a,u,s,c){var f,t,l,f=!(t===i&&t.name()===i.name()),t=t.Ut,l=t.K_(c);f?(m(t,n,e,i.Ut,r,o,a,u,c),s&&l&&t.do("clearSpan",n,e,a,u,c)):s?t.do("moveSpan",n,e,r,o,a,u,c):t.do("copySpan",n,e,r,o,a,u,c)}function nt(t,n,e,i,r,o,a,u,s){var c=n,f=e;c<0&&(c=0,a=z(Z(t),Z(i))),r<0&&(r=0),f<0&&(f=0,u=z(W(t),W(i))),o<0&&(o=0),n<0&&d(t,-1,f,i,-1,o,-1,u,s,1),e<0&&d(t,c,-1,i,r,-1,a,-1,s,2),d(t,c,f,i,r,o,a,u,s)}function et(t,n,e,i,r,o,a,u,s){var c,f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A;for(n<0&&(n=0,r=z(W(t),W(e))),c=r,i<0&&(i=0),f=!u&&e.o5(),l=1,h=[],v=d=0;d<r&&d<W(e,1);d++)f&&0===e.getColumnWidth(i+d)?r++:(m={},0<(64&o)&&(g=k(t,v+n),B(g)||(m.size=g,a&&D(t,d+n,t.defaults.colWidth)),p=t.getColumnVisible(v+n),B(p)||(m.visible=p,a&&t.setColumnVisible(d+n,!0)),b=E(t,-1,v+n,N,s),m.style=b,a&&O(t,-1,d+n,V),b=E(t,-1,v+n,1,s),m.headerStyle=b,a&&O(t,-1,d+n,V,1),w=t.Lt(v+n),B(w)||(m.columnHeaderFitMode=w,a&&t.GB(d+n,I.ColumnHeaderFitMode.normal))),0<(128&o)&&(y=t.getTag(-1,v+n),B(y)||(m.tag=y,a&&t.setTag(-1,d+n,N))),h[v+n]=m,v++);for(r=c,v=d=0;d<r&&d<W(e,1);d++)f&&0===e.getColumnWidth(i+d)?r++:(m=h[v+n],0<(64&o)&&(g=m.size,B(g)||D(e,d+i,g),p=m.visible,B(p)||e.setColumnVisible(d+i,p),O(e,-1,d+i,(b=m.style)?b.clone():V),O(e,-1,d+i,(b=m.headerStyle)?b.clone():V,1),w=m.columnHeaderFitMode,B(w)||e.GB(d+i,w)),0<(128&o)&&(y=m.tag,B(y)||e.setTag(-1,d+i,y)),v++);for(M=Z(e,1),C=z(Z(t,1),M),T=S=0;S<C&&S<M;S++)f&&0===e.getRowHeight(S,1)?C++:(A=_(t,T,1),B(A)||(a&&j(t,S,t.defaults.colHeaderRowHeight,1),j(e,S,A,1)),T++)}function it(t,n,e,i,r,o,a,u,s,c){var f,l,h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x;for(n<0&&(n=0,r=z(Z(t),Z(e))),f=r,i<0&&(i=0),l=!s&&e.o5(),h=2,d=[],m=v=0;v<r&&i+v<Z(e,2);v++)l&&0===e.getRowHeight(i+v)?r++:(!u&&Q(i+v,a,e)||(g={},0<(64&o)&&(p=_(t,m+n),B(p)||(g.size=p,u&&j(t,v+n,t.defaults.rowHeight)),b=t.getRowVisible(m+n),B(b)||(g.visible=b,u&&t.setRowVisible(v+n,!0)),w=E(t,m+n,-1,N,c),g.style=w,u&&O(t,v+n,-1,V),w=E(t,m+n,-1,2,c),g.headerStyle=w,u)&&O(t,v+n,-1,V,2),0<(128&o)&&(y=t.getTag(m+n,-1),B(y)||(g.tag=y,u&&t.setTag(v+n,-1,N))),d[m+n]=g),m++);for(r=f,M=e.rowFilter&&e.rowFilter()&&e.rowFilter().extendedRange,m=v=0;v<r&&i+v<Z(e,2);v++)C=i+v,l&&0===e.getRowHeight(C)?r++:(!u&&Q(C,a,e)||(g=d[m+n],0<(64&o)&&(p=g.size,B(p)||j(e,C,p),b=g.visible,B(b)||(M&&M.intersect(C,-1,1,0)?e.filterRowsVisibleInfo.rowsVisibleInfo[C]=!!b:e.setRowVisible(C,b)),O(e,C,-1,(w=g.style)?w.clone():V),O(e,C,-1,(w=g.headerStyle)?w.clone():V,2)),0<(128&o)&&(y=g.tag,B(y)||e.setTag(C,-1,y))),m++);for(S=W(e,2),T=z(W(t,2),S),I=A=0;A<T&&A<S;A++)l&&0===e.getColumnWidth(A,2)?T++:(x=k(t,I,2),B(x)||(u&&D(t,A,t.defaults.rowHeaderColWidth,2),D(e,A,x,2)),I++)}function rt(t,n,e,i){var e,e,n;t===n&&t.name()===n.name()||(0<(64&e)&&(e=o(t),a(n,i?e:e.clone()),e=o(t,1),a(n,i?e:e.clone(),1),e=o(t,2),a(n,i?e:e.clone(),2),i)&&(a(t,V),a(t,V,1),a(t,V,2)),e=n.defaults,n=t.defaults,e.colWidth=n.colWidth,e.rowHeight=n.rowHeight,e.rowHeaderColWidth=n.rowHeaderColWidth,e.colHeaderRowHeight=n.colHeaderRowHeight,i&&(n.colWidth=62,n.rowHeight=20,n.rowHeaderColWidth=40,n.colHeaderRowHeight=20))}function T(t,n,e,i,r,o,a,u,s,c,f,l,L){var h,d,v,m,g,p,b,w,y,M,C,S,T,A,I,x,N,k,_,D,j,E,O,R,h=!(t===i&&t.name()===i.name()),d=!L&&i.o5();if(2==(2&c)&&n<0)if(C=e,S=o,v=z(Z(t,1),Z(i,1)),m=u,e<0&&(C=0,m=W(t)),o<0&&(S=0),T=m,h)for(y=g=0;g<v&&g<Z(i,1);g++)if(d&&0===i.getRowHeight(g,1))v++;else{for(M=p=0,m=T;p<m&&p<W(i,1);p++)d&&0===i.getColumnWidth(S+p,1)?m++:(l(i,g,S+p,F(w=f(t,y,C+M,1)),1),M++);y++}else{for(b=new G.Rf,g=0;g<v;g++)for(p=0;p<m;p++)w=f(t,g,C+p,1),B(w)||b.set(g,p,F(w));for(y=g=0;g<v&&g<Z(i,1);g++)if(d&&0===i.getRowHeight(g,1))v++;else{for(M=p=0,m=T;p<m&&p<W(i,1);p++)d&&0===i.getColumnWidth(S+p,1)?m++:(l(i,g,S+p,b.get(y,M),1),M++);y++}}if(1==(1&c)&&e<0)if(A=n,I=r,v=a,m=z(W(t,2),W(i,2)),n<0&&(A=0,v=Z(t)),r<0&&(I=0),T=m,h)for(y=g=0;g<v&&g<Z(i,2);g++)if(d&&0===i.getRowHeight(I+g,2))v++;else{for(M=p=0,m=T;p<m&&p<W(i,2);p++)d&&0===i.getColumnWidth(p,2)?m++:(l(i,I+g,p,F(w=f(t,A+y,M,2)),2),M++);y++}else{for(b=new G.Rf,g=0;g<v;g++)for(p=0;p<m;p++)w=f(t,A+g,p,2),B(w)||b.set(g,p,F(w));for(y=g=0;g<v&&g<Z(i,2);g++)if(d&&0===i.getRowHeight(I+g,2))v++;else{for(M=p=0,m=T;p<m&&p<W(i,2);p++)d&&0===i.getColumnWidth(p,2)?m++:(l(i,I+g,p,b.get(y,M),2),M++);y++}}if(x=n,N=e,k=r,_=o,D=a,j=u,E=Z(i),O=W(i),n<0&&(x=0,D=z(Z(t),E)),e<0&&(N=0,j=z(W(t),O)),r<0&&(k=0),o<0&&(_=0),R=j,h)for(g=y=0;g<D&&k+g<E;g++)if(d&&0===i.getRowHeight(k+g))D++;else{if(!Q(k+g,s,i))for(p=M=0,j=R;p<j&&_+p<O;p++)d&&0===i.getColumnWidth(_+p)?j++:(l(i,k+g,_+p,F(w=f(t,x+y,N+M,3)),3),M++);y++}else{b=new G.Rf;try{for(g=0;g<D;g++)for(p=0;p<j;p++)w=f(t,x+g,N+p,3),B(w)||b.set(g,p,F(w));for(g=y=0;g<D&&k+g<E;g++)if(d&&0===i.getRowHeight(k+g))D++;else{if(!Q(k+g,s,i))for(p=M=0,j=R;p<j&&_+p<O;p++)d&&0===i.getColumnWidth(_+p)?j++:(l(i,k+g,_+p,b.get(y,M),3),M++);y++}}catch(t){}}}function ot(t,n,e,s,i,r,o,a,u,c,f,l,h){var d;f&&U&&(d=b(t,s,n,e,o,a,i,r)),T(t,n,e,s,i,r,o,a,u,c,function(t,n,e,i){var r,o,a,u,a,a,u,r,a=h?0:1,u=t.Ut;return 3===i?o=d&&d[n]&&d[n][e]?N:t.getValueIgnoreDefault(n,e,i,a):(o=u.getValue(n,e,i,!0,a),1===i&&B(o)&&s.UB&&(a=t.H3)&&a._dataSource&&(a=u.q_(!1,3,e),u=t.options.colHeaderAutoTextIndex,a)&&(0<=u&&n===u||-1===u&&n===Z(t,i)-1)&&(o=a.displayName||a.name)),o},function(t,n,e,i,r){B(i)?t.YI(n,e,V,r,!!t.HB,!0):t.YI(n,e,i,r,!!t.HB,!0)},l)}function b(t,n,a,u,s,c,f,l){var h,e,i,d,r,o,v,h={},e=(0,G.Ec)(a,u,s,c),i=t.Uw(3).t8,d=n.Uw(3).t8,r=i&&i.jme(a,u,s,c),o=d&&d.jme(f,l,s,c);t===n&&e.intersect(f,l,s,c)?(v=[],r.forEach(function(t){i.Rme(t),t.minX>=a&&t.minY>=u&&v.push(t)}),o.forEach(function(t){i.Rme(t),t.minX>=f&&t.minY>=l&&d.Lme(t,!0)}),v.forEach(function(t){var t={minX:t.minX+f-a,minY:t.minY+l-u,maxX:t.maxX+f-a,maxY:t.maxY+l-u,isValid:t.isValid};d.Bme(t,!0)})):(o.forEach(function(t){t.minX>=f&&t.minY>=l?i.Rme(t,!0,!0):i.Rme(t)}),r.forEach(function(t){var n,e,i,r,o;if(t.minX>=a&&t.minY>=u)(n={minX:t.minX+f-a,minY:t.minY+l-u,maxX:z(t.maxX+f-a,f+s-1),maxY:z(t.maxY+l-u,l+c-1),isValid:t.isValid}).isValid||(n.maxX=n.minX,n.maxY=n.minY),d.Bme(n,!0);else if(t.isValid)for(e=z(t.maxX,a+s-1),i=z(t.maxY,u+c-1),r=Y(t.minX,a);r<=e;r++)for(h[r]=h[r]||{},o=Y(t.minY,u);o<=i;o++)h[r][o]=1}))}function at(u,s,c,f,o,a,l,h,t,n,e,i,d){var v,m,g,p,b,r,w,v={},m={},g=[];e&&U&&(p=u.Uw(3).t8,b=f.Uw(3).t8,(r=p&&p.jme(s,c,l,h)).forEach(function(t){var n,e,i,r,o,a;if(t.minX>=s&&t.minY>=c)if(!t.isValid||t.maxX<s+l&&t.maxY<c+h)g.push(t);else{for(n=[],e=t.minX;e<=t.maxX;e++)for(n.push(i=[]),r=t.minY;r<=t.maxY;r++)i.push(u.getValueIgnoreDefault(e,r,3));g.push(t),t._v=n,p.Rme(t,!1,!0)}else for(o=z(t.maxX,s+l-1),a=z(t.maxY,c+h-1),e=Y(t.minX,s);e<=o;e++)for(v[e]=v[e]||{},r=Y(t.minY,c);r<=a;r++)v[e][r]=1}),(w=b&&b.jme(o,a,l,h)).forEach(function(t){var n,e,i,r;if(!(0<=g.indexOf(t)))if(t.minX>=o&&t.minY>=a)b.Rme(t,!0,!0,!0);else if(t.isValid)for(n=z(t.maxX,o+l-1),e=z(t.maxY,a+h-1),i=Y(t.minX,o);i<=n;i++)for(m[i]=m[i]||{},r=Y(t.minY,a);r<=e;r++)m[i][r]=t})),T(u,s,c,f,o,a,l,h,t,n,function(t,n,e,i){var r,o,a,u,a,a,s,r=3===i,a=d?0:1,u=t.Ut;return r?o=v&&v[n]&&v[n][e]?N:t.getValueIgnoreDefault(n,e,i,a):(o=u.getValue(n,e,i,!0,a),1===i&&B(o)&&f.UB&&(a=t.H3)&&a._dataSource&&(a=u.q_(!1,3,e),s=t.options.colHeaderAutoTextIndex,a)&&(0<=s&&n===s||-1===s&&n===Z(t,i)-1)&&(o=a.displayName||a.name)),B(o)||(r?t.YI(n,e,V,i,!1,!0):u.do("setValue",n,e,V,i,!0,!0)),o},function(t,n,e,i,r){var o=m&&m[n]&&m[n][e];B(i)?o&&o.isValid||t.YI(n,e,V,r,!!t.HB,!0):(o&&o.isValid&&b.Rme(o,!0,u.Ut.G8),t.YI(n,e,i,r,!!t.HB,!0))},i),(g=g.map(function(t){p.Lme(t,!0);var n={minX:t.minX+o-s,minY:t.minY+a-c,maxX:t.maxX+o-s,maxY:t.maxY+a-c,_v:t._v,isValid:t.isValid};return t._v=null,n})).forEach(function(t){t._v?b.setArray(t.minX,t.minY,t.maxX-t.minX+1,t.maxY-t.minY+1,t._v,!1,!0):b.Bme(t,!0)})}function C(t,n,e){for(var t,i,r,o,a,u,s,c,t=t.JS(n),i=t.row,r=t.col,o=t.rowCount,a=t.colCount,u=0;u<o;u++)for(s=e[i+u]=e[i+u]||{},c=0;c<a;c++)s[r+c]=!0}function ut(t,n,e,i,r,o,a,u,s,c,f,l,h){var d,v,m,g,p,b,w,y,M,d={};if(t===i&&t.tables)for(v=(0,G.Ec)(n,e,a,u),m=(0,G.Ec)(r,o,a,u),p=(g=t.tables).all(),b=void 0,w=0,y=(p=g.zB?p.concat(g.zB):p).length;w<y;w++)(b=(M=p[w]).VB||M.range()).containsRange(v)&&b.containsRange(m)?C(t,v,d):(b.intersect(m.row,m.col,m.rowCount,m.colCount)||f&&v.containsRange(b))&&C(t,b,d);T(t,n,e,i,r,o,a,u,s,c,function(t,n,e,i){var r,r,r=(3===i||B(i))&&d[n]&&d[n][e],r=t.getCompositeStyle(n,e,i,N,N,N,N,r,N,N,l);return f&&r&&O(t,n,e,V,i),r},function(t,n,e,i,r){O(t,n,e,i,r)},h)}function st(r,t,n,o,e,i,a,u,s,c,f){var l,h,d,d,l=r.b8.YB;for(h in l)(d=l[h])&&(d=d.condition())&&d.initExpression();T(r,t,n,o,e,i,a,u,s,0,function(t,n,e){var i=t.getDataValidator(n,e,3);return i&&(c&&t.setDataValidator(n,e,V),v(r,o))&&(i.ZB=!0),i},function(t,n,e,i){t.setDataValidator(n,e,i),v(r,o)&&i&&delete i.ZB},f)}function v(t,n){return t===n&&t.name()===n.name()}function ct(t,n,e,i,r,o,a,u,s,c,f){T(t,n,e,i,r,o,a,u,s,0,function(t,n,e){var t,i,t=t.Ut.pI,i=t&&t.get(n,e);return i&&c&&t.remove(n,e),i},function(t,n,e,i){var t=t.Ut.pI;t&&t.WB(n,e,i)},f)}function ft(t,n,e,o,i,r,a,u,s,c,f,l){T(t,n,e,o,i,r,a,u,s,c,function(t,n,e,i){var i=t.getTag(n,e,i);return!B(i)&&f&&t.setTag(n,e,N),i},function(t,n,e,i,r){o.setTag(n,e,i,r)},l)}function lt(a,u,s,t,n,e,i,r,o,c,f){var l,h,d,v,m,g,p,b,w,y,M,C,S,l=[],h=[],d={},v={},m=!f&&t.o5();if(m){for(g=i,p=r,g+=t.lT(n,g,!0),p+=t.lT(e,p),b=t.getRowCount(),w=t.getColumnCount(),M=y=0;y<g&&y+n<b;y++)0!==t.getRowHeight(n+y)&&(d[M]=y,M++);for(S=C=0;C<p&&C+e<w;C++)0!==t.getColumnWidth(e+C)&&(v[S]=C,S++)}return T(a,u,s,t,n,e,i,r,o,0,function(t,n,e){var i,r,o,i=t.getBindingPath&&t.getBindingPath(n,e);return i&&(r=n-Y(0,u),o=e-Y(0,s),m&&(r=d[r],o=v[o]),l.push({row:r,col:o,value:t.getValue(n,e)}),c)&&a.setBindingPath&&a.setBindingPath(n,e,V),i},function(t,n,e,i){B(i)&&(!t.getBindingPath||B(t.getBindingPath(n,e)))||(t.setBindingPath&&t.setBindingPath(n,e,N),h.push({sheet:t,r:n,c:e,value:i}))},f),{savedValues:l,bindingPathInfos:h}}function J(t){t.forEach(function(t){var n=t.sheet,e=t.r,i=t.c,t=t.value;n.setBindingPath&&n.setBindingPath(e,i,t)})}function ht(s,c,f,l,h,d,t,n,e,i,v,r){var m={},g={};return T(s,c,f,l,h,d,t,n,e,i,function(t,n,e,i){var r,o,a,o,u,s,r,r=t.Ut,o=r.yle(i),a=o.getValue(n,e),o=o.getExpression(n,e),u=n-c,s=e-f;return m[u]||(m[u]={}),v&&!g[u]&&(g[u]={}),v&&(B(a)||r.setDefaultValue(n,e,V,i,I.DefaultChangeValueType.Value,!0),B(o)||r.setDefaultValue(n,e,V,i,I.DefaultChangeValueType.Expression,V,!0)),o?(r=t.getValueIgnoreDefault(n,e,i),B(r)?V:(m[u][s]=1,v&&(g[u][s]={expr:o}),o)):(m[u][s]=0,a)},function(t,n,e,i,r){var t,o,a,u,o,o,t=t.Ut,o=t.yle(r),a=n-h,u=e-d;B(i)&&B(o.getValue(n,e))||(o=m[a][u],U&&1===o?v?(o=g[a][u])&&(o.destRow=n,o.destCol=e):(0,p.copyDefaultFormula)(s,l,n,e,i):t.setDefaultValue(n,e,i,r,I.DefaultChangeValueType.Value))},r),g}function dt(t,n,e,o,i,r,a,u,s,c,f,l){T(t,n,e,o,i,r,a,u,s,c,function(t,n,e,i){var i=t.getHyperlink&&t.getHyperlink(n,e,i);return!B(i)&&f&&t.setHyperlink&&t.setHyperlink(n,e,N),i},function(t,n,e,i,r){o.setHyperlink&&o.setHyperlink(n,e,i,r)},l)}function vt(t,n,e,o,i,r,a,u,s,c,f,l){T(t,n,e,o,i,r,a,u,s,c,function(t,n,e,i){var i=t.getAltText(n,e,i);return!B(i)&&f&&t.setAltText(n,e,N),i},function(t,n,e,i,r){o.setAltText(n,e,i,r)},l)}function mt(t,n,e,i,r,o,a,u){var s=P("SheetsCalc");s&&s.CalcOperatorAdjustor.moveFormula(t,n,e,i,r,o,a,u)}function gt(i,r,o,a,u,s,c,f){var t,l,h,d,v,t,m,t,n,e,t=P("SheetsCalc");if(t)if(l=t.QB,v=i.Ut.pj(),i.parent&&i.parent.sheets)for(m=i.parent.sheets,(t=i.parent.getCustomNames())&&g(t,function(t,n){h=n.getExpression(),(d=l(null,i,r,o,a,u,s,c,f,h))!==h&&n.SB(d,v)}),n=function(e){var t=m[e].getCustomNames();t&&g(t,function(t,n){h=n.getExpression(),(d=l(m[e],i,r,o,a,u,s,c,f,h))!==h&&n.SB(d,v)})},e=0;e<m.length;e++)n(e);else(t=i.getCustomNames())&&g(t,function(t,n){h=n.getExpression(),(d=l(i,i,r,o,a,u,s,c,f,h))!==h&&n.SB(d,v)})}function M(t,n,e,i,r,o,a,u,s){var t;e&&r&&(r=t.adjustFormulaOnMoveSwap(i,o,a,r,u,!0,{crossSheetMoved:s}),t=e.unparse(i,r,o,a),n.setDefaultValue(o,a,t,V,I.DefaultChangeValueType.Expression,V,!0))}function w(t,n,e,i,r,o){var a,u,s,c,f,l,h,d,v,m,g,p,b,w,y;if(t)for(l in a=e!==i,u=e.Ut,s=i.Ut,c=e.Uw(),f=e.op(),t)if(t.hasOwnProperty(l)&&(h=t[l]))for(d in h)h.hasOwnProperty(d)&&(v=h[d])&&v.expr&&(o?M(n,s,f,c,b=v.expr,w=v.destRow,y=v.destCol,r,a):B(e.getValueIgnoreDefault(m=+l,g=+d))||M(n,u,f,c,v.expr,m,g,r,a))}function pt(t,n,e,i,r,o,a,u,s){var c,f,l,h,f,l,n,d,c=P("SheetsCalc");c&&(f=t.op(),l=t.Uw(),h=i.Uw(),f)&&l&&h&&(f=new c.MoveSwapInfo(l,n,e,h,r,o,a,u),w(d=(n=(l=t.Ut)&&l.yle())&&n.gle(),c,t,i,f),w(s,c,t,i,f,!0))}function y(t,n,e,i,r,o,a,u,s,c,f,l,h,d,L){var v,m,g,B,p,b,w,y,M,C,S,T,A,b,b,I,x,N,x,k,_,D,j,E,O,R,F;if(K(t,n,e,i,r,o,a,u,l),0<(1&s)&&0<(2&s)&&(b=t.pivotTables)&&(p=b.KB((0,G.Ec)(Y(0,n),Y(0,e),n<0?z(Z(t),Z(i)):a,e<0?z(W(t),W(i)):u),l)),l&&i.UB&&n<0)for(g=u,(m=e)<0&&(m=0,g=z(W(t),W(i))),(w=o)<0&&(w=0),v=!0,y=0;y<g;y++)M=t.Ut.q_(!1,3,m+y),C=t.Ut.q_(!1,3,w+y),S=M&&M.name,T=C&&C.name,M&&C&&S&&T||(v=!1),(C=H.GC$.extend(!0,{},i.Ut.q_(!1,3,w+y)||{})).displayName=M&&M.displayName,C.name=M&&M.name,i.Ut.do("setItem",!1,3,w+y,C);0<(64&s)&&(ut(t,n,e,i,r,o,a,u,c,f,l,h,d),t.EB||t.b8&&st(t,n,e,i,r,o,a,u,c,l,d)),0<(512&s)&&X(t,n,e,i,r,o,a,u,l,d),0<(1&s)&&0<(2&s)&&(b=t.tables)&&(A=b.KB((0,G.Ec)(Y(0,n),Y(0,e),n<0?z(Z(t),Z(i)):a,e<0?z(W(t),W(i)):u),l)),(b=U)&&(t.suspendCalcService(),i.suspendCalcService()),I=[],x=V,N=[],0<(256&s)&&(I=(x=lt(t,n,e,i,r,o,a,u,c,l,d)).savedValues,N=x.bindingPathInfos),0<(2048&s)&&(x=ht(t,n,e,i,r,o,a,u,c,f,l,d),l)&&x&&pt(t,n,e,i,r,o,a,u,x);try{if(k=i.pivotTables,0<(1&s)&&0<(2&s)&&k&&k.JB(p,t,Y(0,n),Y(0,e),i,Y(0,r),Y(0,o),a,u,l),0<(1&s)&&!v){if((l?at:ot)(t,n,e,i,r,o,a,u,c,f,0<(2&s),d,L),U&&0==(2&s)&&i.clearFormula(r,o,a,u,function(t,n){return!c||!t.XT||!t.XT(n)}),0<(256&s))for(J(N),_=I.length,D=r<0?0:r,j=o<0?0:o,E=0;E<_;E++)O=I[E],!l&&Q(D+O.row,c,i)||i.setValue(D+O.row,j+O.col,O.value)}else 0<(256&s)&&J(N);R=i.tables,0<(1&s)&&0<(2&s)&&R&&R.JB(A,Y(0,n),Y(0,e),Y(0,r),Y(0,o),l),U&&(l?(t.EB||gt(t,n,e,i,r,o,a,u),0<(2&s)&&mt(t,n,e,i,r,o,a,u)):0<(2&s)&&(F=P("SheetsCalc"))&&F.XB(t,n,e,i,r,o,a,u,c,d,!0),0<(1&s))&&0<(2&s)&&R&&R.qB(A),0<(4&s)&&ct(t,n,e,i,r,o,a,u,c,l,d),0<(128&s)&&ft(t,n,e,i,r,o,a,u,c,f,l,d),0<(1024&s)&&dt(t,n,e,i,r,o,a,u,c,f,l,d),0<(4096&s)&&vt(t,n,e,i,r,o,a,u,c,f,l,d)}finally{b&&(t.resumeCalcService(!1),i.resumeCalcService(!1))}if(0<(16&s)&&q(t,n,e,i,r,o,a,u,l,d),0<(8&s)&&(n<0&&$(t,e,i,o,u,l),e<0)&&tt(t,n,i,r,a,l),0<(32&s)&&(!l&&1===a&&1===u||nt(t,n,e,i,r,o,a,u,l)),n<0&&r<=0&&et(t,e,i,o,u,s,l,d,h),e<0&&o<=0&&it(t,n,i,r,a,s,c,l,d,h),n<0&&r<=0&&e<0&&o<=0&&rt(t,i,s,l),l&&t.UB&&n<0)for(g=u,(m=e)<0&&(m=0,g=z(W(t),W(i))),y=0;y<g;y++)t.getDataColumnName&&t.getDataColumnName(m+y)&&t.Ut.do("setItem",!1,3,m+y,V)}Object.defineProperty(t,"__esModule",{value:!0}),t.staticMembers=void 0,n=P("./dist/core/core.ns.js"),G=P("./dist/core/util/common.js"),r=P("Common"),I=P("./dist/core/core.enum.js"),e=P("CalcEngine"),U=!!e,H=P("./dist/core/util/domUtil.js"),p=P("./dist/core/worksheet/worksheet-model.js"),B=r.Common.lt.ht,g=H.GC$.each,V=null,N=void 0,z=Math.min,Y=Math.max,e=new r.Common.ResourceManager(n.SR,"Sheets"),l=e.getResource.bind(e),t.staticMembers={copyTo:function(t,n,e,i,r,o,a,u,s,c,f,l,h){y(t,n,e,i,r,o,a,u,s,c,f,!1,N,l,h)},moveTo:function(t,n,e,i,r,o,a,u,s,c,f,l){var h=3;t===i&&t.NMi&&(h=0),y(t,n,e,i,r,o,a,u,s,N,h,!0,c,f,l)}}},"./dist/core/worksheet/worksheet-ui.js":function(t,n,c){"use strict";var e,s,i,g,r,o,a,u,f,l,h,m,d,a,v;function p(t){return"number"==typeof t}function b(t){return"string"==typeof t}function w(t){return parseInt(t,10)}function y(t){return Math.abs(t)}function M(t,n){var s=t,c=n;return function(t){var n,e,i,r,o,a,u,n=this,e=n.sheet,i=n.row,r=n.col,o=n.sheetArea;if(0===arguments.length)return s.call(e,i,r,o);if(0<=i&&0<=r)for(a=i;a<i+n.rowCount;a++)for(u=r;u<r+n.colCount;u++)C(e,a,u,o)&&c.call(e,a,u,t,o);return n}}function C(t,n,e,i){var r,t,r=t.getRowCount(i),t=t.getColumnCount(i);return e<0&&0<=n&&n<r||n<0&&0<=e&&e<t||0<=n&&n<r&&0<=e&&e<t||-1===n&&-1===e}function S(t,n,e,i,r,o){var a,u;C(t,n,e,o)&&("string"==typeof(a=(a=t.vI(n,e,o))||new s.Style)&&(u=a,(a=new s.Style).parentName=u),"font"===i&&T(t,a,r),a[i]=r,t.setStyle(n,e,a,o))}function T(t,n,e){var i,r,o,o,a;d(n.themeFont)||(r=(i=l()).style,o=n.font,o=(r.font=o)&&r.fontFamily,(a=(r.font=e)&&r.fontFamily)!==o&&(n.themeFont=h))}function A(t,n,e,i,r,o){var a=this;n<0&&(n=i=-1),e<0&&(e=r=-1),a.sheet=t,a.row=n,a.rowCount=d(i)?1:i,a.col=e,a.colCount=d(r)?1:r,a.sheetArea=d(o)?3:o}function I(t){return t=(t=t.replace(/[^\:]+\!/g,"")).replace(/\$/g,"")}function x(t){var t,n,t,e,i,r,r,o,a,u,n,s,e,c,f,l,h,d,v,t=t.split(":"),n=t[0],t=t[1],e=/([A-Z]+)(\d+)?(\D+)?/;if(isNaN(Number(n))){if(o=(r=n.match(e))[3])return m;i=r[1],r=r[2]}else r=n;if(n&&!t){if(i&&r)return[a=N(r),u=k(i),1,1]}else if(n&&t){if(s=n=void 0,isNaN(Number(t))){if(o=(e=t.match(e))[3])return m;n=e[1],s=e[2]}else s=t;if(!i&&r&&!n&&s)return c=N(r),f=N(s),[a=Math.min(c,f),-1,l=y(c-f)+1,-1];if(i&&!r&&n&&!s)return h=k(i),d=k(n),[-1,u=Math.min(h,d),-1,v=y(h-d)+1];if(i&&r&&n&&s)return c=N(r),f=N(s),h=k(i),d=k(n),a=Math.min(c,f),l=y(c-f)+1,[a,u=Math.min(h,d),l,v=y(h-d)+1]}return m}function N(t){return w(t)-1}function k(t){for(var n,e,i,r,o,a,n=64,e=26,i=0,r=t.length,o=0;o<r;o++)a=t[o].charCodeAt(0)-64,i+=Math.pow(26,r-o-1)*a;return i-1}Object.defineProperty(n,"__esModule",{value:!0}),n.$B=n.tL=n.CellRange=void 0,e=c("./dist/core/worksheet/worksheet.js"),s=c("./dist/core/worksheet/style.js"),i=c("./dist/core/util/domUtil.js"),g=c("./dist/core/util/common.js"),r=c("Common"),o=c("./dist/core/core.enum.js"),a=c("CalcEngine"),u=c("./dist/core/worksheet/clipboardhelper.js"),f=!!a,l=g.util.N0,h=void 0,m=null,d=r.Common.lt.ht,a=e.Worksheet.prototype,A.prototype.tag=function(t){var n=this,e=n.sheet,i=n.row,r=n.col,o=n.rowCount,a=n.colCount,u=n.sheetArea,s,c;if(0===arguments.length)return e.getTag(i,r,u);if(0<=i&&0<=r)for(s=i;s<i+o;s++)for(c=r;c<r+a;c++)e.setTag(s,c,t,u);else if(0<=i)for(s=i;s<i+o;s++)e.setTag(s,-1,t,u);else if(0<=r)for(c=r;c<r+a;c++)e.setTag(-1,c,t,u);return n},A.prototype.altText=function(t){var n=this,e=n.sheet,i=n.row,r=n.col,o=n.rowCount,a=n.colCount,u=n.sheetArea,s,c;if(0===arguments.length)return e.getAltText(i,r,u);if(0<=i&&0<=r)for(s=i;s<i+o;s++)for(c=r;c<r+a;c++)e.setAltText(s,c,t,u);return n},A.prototype.width=function(t){var n,e,i,r,o,a,n=this,e=n.sheet,i=n.row,r=n.col,o=n.sheetArea;if(0!==arguments.length){if(i<0)for(a=0;a<n.colCount;a++)e.setColumnWidth(a+r,t,o);return n}if(i<0)return e.getColumnWidth(r,o)},A.prototype.height=function(t){var n,e,i,r,o,a,n=this,e=n.sheet,i=n.row,r=n.col,o=n.sheetArea;if(0!==arguments.length){if(r<0)for(a=0;a<n.rowCount;a++)e.setRowHeight(a+i,t,o);return n}if(r<0)return e.getRowHeight(i,o)},A.prototype.visible=function(t){var n,e,i,r,o,a,u,n=this,e=n.sheet,i=n.row,r=n.col,o=n.sheetArea;if(0===arguments.length)return r<0&&0<=i?e.getRowVisible(i,o):0<=r&&i<0?e.getColumnVisible(r,o):void 0;if(r<0&&0<=i)for(a=0;a<n.rowCount;a++)e.setRowVisible(a+i,t,o);else if(0<=r&&i<0)for(u=0;u<n.colCount;u++)e.setColumnVisible(u+r,t,o);return n},A.prototype.resizable=function(t){var n,e,i,r,o,a,u,n=this,e=n.sheet,i=n.row,r=n.col,o=n.sheetArea;if(0===arguments.length)return r<0&&0<=i?e.getRowResizable(i,o):0<=r&&i<0?e.getColumnResizable(r,o):void 0;if(r<0&&0<=i)for(a=0;a<n.rowCount;a++)e.setRowResizable(a+i,t,o);else if(0<=r&&i<0)for(u=0;u<n.colCount;u++)e.setColumnResizable(u+r,t,o);return n},A.prototype.l0=function(t){var n=this;return n.sheet.l0(n.row,n.col,t,n.sheetArea)},A.prototype.R5=function(e,i){var t=this,r=t.sheet,o=t.sheetArea;return t.nL(function(t,n){S(r,t,n,e,i,o)}),t},A.prototype.nL=function(t){var n,e,i,r,o,a,n=this,e=n.sheet,i=n.row+n.rowCount,r=n.col+n.colCount;if(e.suspendPaint(),0<=n.row&&0<=n.col)for(o=n.row;o<i;o++)for(a=n.col;a<r;a++)t.call(n,o,a);else if(0<=n.row)for(o=n.row;o<i;o++)t.call(n,o,-1);else if(0<=n.col)for(a=n.col;a<r;a++)t.call(n,-1,a);else-1===n.row&&-1===n.col&&-1===n.rowCount&&-1===n.colCount&&t.call(n,-1,-1);e.resumePaint()},A.prototype.setStyleName=function(e){var i=this;i.nL(function(t,n){i.sheet.setStyleName(t,n,e,i.sheetArea)})},A.prototype.setStyle=function(e){var i=this;i.nL(function(t,n){i.sheet.setStyle(t,n,e.clone(),i.sheetArea)})},A.prototype.clear=function(t){var n=this;n.sheet.clear(n.row,n.col,n.rowCount,n.colCount,n.sheetArea,t)},A.prototype.setBorder=function(t,n){var e,i,r,o,a,u,s,c,f,l,h,d,v,m,e=this,i=e.sheet,r=e.sheetArea;i.suspendPaint();try{if(o=new g.Range(e.row,e.col,e.rowCount,e.colCount),u=(a=i.JS(o,r)).row,s=a.col,c=a.rowCount,f=a.colCount,h=l=void 0,d=n.all,v=n.outline,m=n.inside,n.left||d||v)for(l=0;l<c;l++)i.getCell(u+l,s,r).borderLeft(t);if(n.top||d||v)for(h=0;h<f;h++)i.getCell(u,s+h,r).borderTop(t);if(n.right||d||v)for(l=0;l<c;l++)i.getCell(u+l,s+f-1,r).borderRight(t);if(n.bottom||d||v)for(h=0;h<f;h++)i.getCell(u+c-1,s+h,r).borderBottom(t);if(n.diagonalUp)for(l=0;l<c;l++)for(h=0;h<f;h++)i.getCell(u+l,s+h,r).diagonalUp(t);if(n.diagonalDown)for(l=0;l<c;l++)for(h=0;h<f;h++)i.getCell(u+l,s+h,r).diagonalDown(t);if(n.innerHorizontal||d||m)for(l=0;l<c-1;l++)for(h=0;h<f;h++)i.getCell(u+l,s+h,r).borderBottom(t),i.getCell(u+l+1,s+h,r).borderTop(t);if(n.innerVertical||d||m)for(h=0;h<f-1;h++)for(l=0;l<c;l++)i.getCell(u+l,s+h,r).borderRight(t),i.getCell(u+l,s+h+1,r).borderLeft(t)}finally{i.resumePaint()}},A.prototype.toHtml=function(t,n){void 0===t&&(t=o.HeaderOptions.noHeaders),void 0===n&&(n=!0);var e=this;return e.sheetArea===o.SheetArea.corner?"":u.yM.KS(e.sheet,t,e.row,e.rowCount,e.col,e.colCount,e.sheetArea,n,[],[],!0,!0,n,!0)},A.p0=M,v=A,(n.CellRange=v).prototype.value=M(a.getValue,a.setValue),v.prototype.text=M(a.getText,a.setText),v.prototype.D5=M(function(t,n){return f&&this.getFormula(t,n)},function(t,n,e,i){f&&this.setFormula(t,n,e,i)}),v.prototype.formula=function(t,n){if(!n)return 0===arguments.length?this.D5():this.D5(t);f&&this.sheet.eL(this.row,this.col,this.rowCount,this.colCount,t)},v.prototype.defaultValue=M(a.getDefaultValue,a.setDefaultValue),v.prototype.styleName=M(a.getStyleName,a.setStyleName),i.GC$.each(["backColor","foreColor","hAlign","vAlign","themeFont","font","formatter","borderLeft","borderTop","borderRight","borderBottom","diagonalDown","diagonalUp","locked","textIndent","wordWrap","showEllipsis","shrinkToFit","backgroundImage","backgroundImageLayout","cellType","tabStop","textDecoration","imeMode","watermark","cellPadding","labelOptions","quotePrefix","isVerticalText","cellButtons","dropDowns","textOrientation","mask"],function(t,n){v.prototype[n]=function(t){return 0===arguments.length?this.l0(n):this.R5(n,t)}}),n.tL=x,n.$B=k,i.GC$.extend(a,{getRange:function(){var t,n,e,i,r,o,a,u,s,r,a,t=arguments[0];if(b(t)){if(a=t.toUpperCase(),u=this.parent&&1===this.parent.options.referenceStyle)return m;if(o=arguments[1],1<(a=I(a)).split(",").length)return m;if(f){if(!(r=(s=c("SheetsCalc")).formulaToRange(this,a,h,h,o)))return m;n=r.row,e=r.col,i=r.rowCount,r=r.colCount}else{if(!(a=x(a)))return m;n=a[0],e=a[1],i=a[2],r=a[3]}}else p(t)&&(n=t,e=arguments[1],i=arguments[2],r=arguments[3],o=arguments[4]);return new v(this,n,e,i,r,o)},getCell:function(t,n,e){return d(n)&&(n=-1),new v(this,t,n,1,1,e)}})},"./dist/core/worksheet/worksheet.js":function(i,t,o){"use strict";var n,I,r,a,x,j,l,u,f,_,N,g,k,p,e,b,w,W,D,M,g,T,Q,h,J,K,X,s,q,$,d,tt,C,nt,v,E,O,R,L,y,et,it,S,rt,B,ot,at,ut,c,st,F,ct,ft,lt,ht,dt,vt,mt,gt,pt,n,m,bt,wt,yt,Mt,Ct,St,n,n;function Tt(t,n){var e,i,r,o,a,u,s,e=[],i=t.Ut.Fj();if(i)for(r in i)if(K(i,r)&&(o=i[r])&&(n||"n"!==o.rs||(a={row:+r,item:t.getDataItem&&t.getDataItem(+r)},e.push(a)),n)&&"e"===o.rs)for(u in o)if(!v(u)&&(s=o[u])){(a={row:+r,item:t.getDataItem&&t.getDataItem(+r)}).originalItem=o.originalItem,e.push(a);break}return e}function A(t,n,e,i){for(var r,o,r=0,o=n;o<=e;o++)r+=t.Kt(o,i);return r}function P(t,n,e,i){for(var r,o,r=0,o=n;o<=e;o++)r+=t.Gt(o,i);return r}function G(t,n){return t.getColumnCount(n)}function U(t,n){return t.getRowCount(n)}function H(t){return t.frozenTrailingColumnCount()}function V(t){return t.frozenTrailingRowCount()}function At(t){return t.Ny}function It(t){return t.Vy}function z(t){return t.frozenColumnCount()}function Y(t){return t.frozenRowCount()}function xt(t){return t.yve}function Nt(t){return t.bve}function kt(t){return D(t)||t===_.SheetArea.viewport||t===_.SheetArea.rowHeader?_.SheetArea.viewport:t===_.SheetArea.colHeader?t:_.SheetArea.corner}function _t(t){return D(t)||t===_.SheetArea.viewport||t===_.SheetArea.colHeader?_.SheetArea.viewport:t===_.SheetArea.rowHeader?t:_.SheetArea.corner}function Dt(t,n){var t,n,t=I.util._0(t.font),n=I.util._0(n.font);return t.fontStyle+" "+t.fontWeight+" "+n.fontSize+" "+n.fontFamily}function jt(t,e,i){Object.defineProperty(t,e,{get:function(){return this["_"+e]},set:function(t){var n=this["_"+e];n!==t&&(this["_"+e]=t,i)&&i(e,t,n)}})}function Et(t,n,e,i){return{row:n,col:e,newValue:t.getValue(n,e),oldValue:i}}function Ot(t){var n,e,i,r;if(t)for(e=(n=t.sheets).length,r=0;r<e;r++)!0===(i=n[r]).iL&&delete i.iL}function Rt(t){if(!J(t))for(var n in t)if(!D(t[n])&&!J(t[n]))return;return 1}function Z(t){var i=this;i._id=Z.rL,i.canClone=!0,Z.rL++,i.options=T(Mt,function(t,n,e){i.Ob(t,n,e)}),i.Hc(t),i.Vp=new a.Tasks(function(){return this.tasks.pop()},function(){var t=i.parent;return t&&t.ib.eb||i.rt.rb||i.rt.ob||i.rt.ab})}function Lt(t,n,e,i,r){var r;-1===n&&-1===e||3===(r=D(r)?3:r)&&(r=t.tables&&t.tables.find(n,e))&&r.oL&&n===r.footerIndex()&&Ct.et(t,"composeTableFooterList",{table:r,row:n,col:e,style:i})}Object.defineProperty(t,"__esModule",{value:!0}),t.Worksheet=t.InvalidType=t.ClearPendingChangeType=t.MAX_COLUMN_COUNT=t.MAX_ROW_COUNT=void 0,n=o("./dist/core/core.ns.js"),I=o("./dist/core/util/common.js"),r=o("./dist/core/util/imageLoader.js"),a=o("./dist/core/util/tasks.js"),x=o("./dist/core/worksheet/style.js"),j=o("./dist/core/worksheet/worksheet-model.js"),l=o("./dist/core/util/domUtil.js"),u=o("./dist/core/celltype/textcelltype.js"),f=o("./dist/core/celltype/headercelltype.js"),_=o("./dist/core/core.enum.js"),N=o("Common"),g=o("CalcEngine"),k=!!g,e=o("./dist/core/util/theme.js"),b=o("./dist/core/worksheet/stylehelper.js"),w=I.util.g0,W=I.util.St,D=N.Common.lt.ht,M=I.util.En,g=I.util.p0,T=I.util.b0,Q=I.util.x0,h=l.GC$.each,J=l.GC$.isEmptyObject,K=N.Common.kh,X=I.util.Z0,s=I.util.V0,q=new RegExp("^\\d*(\\.\\d+)?\\*$"),$=new Date(1899,11,30).getTime(),d=N.Common.zf,tt=document,C=parseInt,nt=parseFloat,v=isNaN,E=null,O=void 0,R=Math.min,L=Math.max,y=Math.floor,et=Math.ceil,it=Math.abs,S=Math.round,rt="undefined",B="string",ot="width",at="height",ut="black",c="tag",st="altText",F="onLayoutChanged",ct="beforeLayoutChanged",ft="onPaintSuspend",lt="isVisible",ht="starSize",dt="resizable",vt=".gcSheet",mt=".gcSheetInternal",gt="columnHeaderFitMode",t.MAX_ROW_COUNT=1048576,t.MAX_COLUMN_COUNT=16384,pt={backColor:!0,foreColor:!0,font:!0,borderLeft:!0,borderTop:!0,borderRight:!0,borderBottom:!0,textDecoration:!0,cellType:!0,formatter:!0},n=new N.Common.ResourceManager(n.SR,"Sheets"),m=n.getResource.bind(n),bt=I.UsedRangeUtil.vh,(n=wt=t.ClearPendingChangeType||(t.ClearPendingChangeType={}))[n.dirty=1]="dirty",n[n.insert=2]="insert",n[n.delete=4]="delete",(n=yt=t.InvalidType||(t.InvalidType={}))[n.setFormula=0]="setFormula",n[n.copyPaste=1]="copyPaste",n[n.dragFill=2]="dragFill",n[n.dragDrop=3]="dragDrop",n[n.changePartOfArrayFormula=4]="changePartOfArrayFormula",n[n.changeSheetName=5]="changeSheetName",n[n.table=6]="table",n[n.hideSheet=7]="hideSheet",n[n.pivotTable=8]="pivotTable",n[n.PTOverlapPT=9]="PTOverlapPT",Mt={rowHeaderVisible:!0,colHeaderVisible:!0,clipBoardOptions:0,frozenlineColor:ut,rowHeaderAutoText:1,colHeaderAutoText:2,rowHeaderAutoTextIndex:-1,colHeaderAutoTextIndex:-1,sheetTabColor:E,selectionBackColor:E,selectionBorderColor:E,allowCellOverflow:!0,showFormulas:!1,showZeros:!0,isProtected:!1,protectionOptions:{},gridline:{},reversalTrailingResizeOrder:!1,keepUnknownFormulas:!1,sheetAreaOffset:{left:0,top:0}},Z.prototype.sortRange=function(t,n,e,i,r,o,a,u,s){return!1},Z.prototype.Ob=function(t,e,n){var i,r,o,a,u,s,i=this,r=i.parent;switch(t){case"allowCellOverflow":case"showFormulas":case"showZeros":case"colHeaderAutoText":case"colHeaderAutoTextIndex":case"colHeaderVisible":case"frozenlineColor":case"rowHeaderAutoText":case"rowHeaderAutoTextIndex":case"rowHeaderVisible":case"selectionBackColor":case"selectionBorderColor":case"reversalTrailingResizeOrder":i.zw();break;case"sheetAreaOffset":o=function(t,n){n<0&&(i.options.sheetAreaOffset[t]=0),i.zw()},a=i.options.sheetAreaOffset,["left","top"].forEach(function(t){var n=e[t];jt(a,t,o),a[t]=n});break;case"gridline":u=function(){i.zw()},s=i.options.gridline,["color","showHorizontalGridline","showVerticalGridline"].forEach(function(t){var n=e[t];jt(s,t,u),s[t]=n});break;case"isProtected":e&&r&&r.undoManager().aL(function(t){return t.sheetId!==i._id}),i.uL(),Z.et(i,"onProtectChanged"),i.zw();break;case"protectionOptions":i.uL(),Z.et(i,"onProtectChanged");break;case"sheetTabColor":r&&r.Xg();break;case"keepUnknownFormulas":i.options.keepUnknownFormulas=e}i.ki(I.Events.SheetOptionsChangedInternal,{propertyName:t,value:e})},Z.prototype.getUsedRange=function(t){var n,e,i,r,o,a,u,u;return!D(t)&&(i=(e=(n=this).Ut).getUsedRange(t)||{},r=n.getRowCount(),o=n.getColumnCount(),t&_.UsedRangeType.formula&&k&&(u=(a=n.b3()).usedRange,D(u)||bt(i,u.getUsedRange()),u=n.Uw&&n.Uw(3))&&u.t8&&bt(i,u.t8.Fme()),bt(i,n.rowOutlines.getUsedRange(t)),bt(i,n.columnOutlines.getUsedRange(t)),Z.et(n,"getUsedRange",{type:t,range:i}),i)&&0<Object.keys(i).length?(i.minRow<0&&(i.minRow=0,i.maxRow=r-1),i.minCol<0&&(i.minCol=0,i.maxCol=o-1),i.maxRow>=r&&(i.maxRow=r-1),i.maxCol>=o&&(i.maxCol=o-1),new I.Range(i.minRow,i.minCol,i.maxRow-i.minRow+1,i.maxCol-i.minCol+1)):E},Z.prototype.name=function(t){var n=this,e=n.parent;if(0===arguments.length)return n.Ut?n.Ut.getName():"";if(Q(t,e?e.sheets:null,n))return n.ub(t),e&&e.Xg(),n;throw m().Exp_NotSupported},Z.prototype.isSelected=function(t){return this.b2(t)},Z.prototype.b2=function(t,n){var e,i,r,o,a,u,e=this,i=e.parent,r=!!e.Ut&&e.Ut.Xj();return D(t)?r:(t!==r&&(o=e.name(),a=i&&i.Ese(o),u=void 0,n&&(u={oldValue:r,newValue:t,sheetName:o,propertyName:"isSelected",cancel:!1,sheetIndex:a,sheetPosition:i&&i.getSheetPosition(o)},i)&&i.ki(I.Events.SheetChanging,u),!n||u&&!1===u.cancel)&&(e.Ut.qj(t),i&&i.w2&&i.w2.repaint(),n)&&i&&i.ki(I.Events.SheetChanged,{oldValue:r,newValue:t,sheetName:o,propertyName:"isSelected",sheetIndex:a,sheetPosition:i&&i.getSheetPosition(o)}),e)},Z.prototype.ub=function(t,n){var e,i,e=this,i=e.name();n||Z.et(e,"beforeSetName",{oldName:i,newName:t}),this.Ut.do("setName",t),n||Z.et(e,"setName",{oldName:i,newName:t})},Z.prototype.addRows=function(t,n,e){this.ffe(t,n,e)},Z.prototype.ffe=function(t,n,e,i){var r,o,a,u,s;if((e=kt(r=e=void 0===e?_.SheetArea.viewport:e))!==_.SheetArea.corner&&!(n<=0)){a=U(o=this,e),(t<0||a<t)&&(t=a),o.suspendPaint();try{u="addRows",o.kj(t,r,u,n,a)&&(0===o.Ut.P8&&o.parent&&o.parent.Wp.clear(),o.sL(!1,e),s={changeType:"addingRows",row:t,rowCount:n,canAdd:!0,sheetArea:e},Z.et(o,F,s),s.canAdd)&&(D(s.newRow)||(t=s.newRow),this.Ut.do("addRows",t,n,O,O,e),o.Ww=!0,Z.et(o,F,{changeType:u,row:t,oldValue:a,rowCount:n,rowExpand:i,sheetArea:e}),Z.et(o,F,{changeType:"addRows2",row:t,oldValue:a,rowCount:n,sheetArea:e}),e===_.SheetArea.viewport&&o.tables&&o.tables.cL(!0,t),o.dj(t,r,u,n,a))}finally{o.sL(!0,e),o.resumePaint()}}},Z.prototype.sL=function(t,n){var e,i,r;(n=void 0===n?_.SheetArea.viewport:n)===_.SheetArea.viewport&&(i=(e=this).ui,r=e.ci,e.Ut.setCellState(i,r,_.CellStatesType.active,t,n))},Z.prototype.deleteRows=function(t,n,e){var i,r,o,a,u,s,c,f,l,h,d,v,m;if((e=kt(i=e=void 0===e?_.SheetArea.viewport:e))!==_.SheetArea.corner&&(o=U(r=this,e),!(t<0||o<=t||n<=0))){r.suspendPaint();try{if(a="deleteRows",r.kj(t,i,a,n,o)&&(0===r.Ut.P8&&r.parent&&r.parent.Wp.clear(),r.sL(!1,e),u={changeType:"deletingRows",row:t,rowCount:n,canDelete:!0,sheetArea:e},Z.et(r,F,u),u.canDelete)){if(e===_.SheetArea.viewport&&r._j(t,n,0,this.getColumnCount()),r.Ut.do("deleteRows",t,n,O,e),0<=(s=r.Tb)){for(c=-1,f=Y(r),l=s;f<=l;l--)if(r.getRowVisible(l)&&0<r.Gt(l)){c=l;break}s!==(c=-1===c?0:c)&&r.$A(c)}h=U(r),r.getActiveRowIndex()>=h&&(d=h-1,v=r.getActiveColumnIndex(),(m=r.getSpan(d,v))&&(d=m.row,v=m.col),r.setActiveCell(d,v)),r.Ww=!0,Z.et(r,F,{changeType:a,row:t,oldValue:o,rowCount:n,sheetArea:e}),e===_.SheetArea.viewport&&r.tables&&r.tables.cL(!0,t),r.dj(t,i,a,n,o)}}finally{r.sL(!0,e),r.resumePaint()}}},Z.prototype.addColumns=function(t,n,e){var i,r,o,a,u;(e=_t(i=e=void 0===e?_.SheetArea.viewport:e))===_.SheetArea.corner||n<=0||(o=G(r=this,e),r.Dj(t=t<0||o<t?o:t,i,a="addColumns",n,o)&&(0===r.Ut.P8&&r.parent&&r.parent.Wp.clear(),Z.et(r,F,u={changeType:"addingColumns",col:t,colCount:n,canAdd:!0,sheetArea:e}),u.canAdd)&&(r.sL(!1,e),r.Ut.do("addColumns",t,n,O,e),r.Zw=!0,Z.et(r,F,{changeType:a,col:t,oldValue:o,colCount:n,sheetArea:e}),Z.et(r,F,{changeType:"addColumns2",col:t,oldValue:o,colCount:n,sheetArea:e}),e===_.SheetArea.viewport&&r.tables&&r.tables.cL(!1,t),r.vj(t,i,a,n,o),r.sL(!0,e),r.zw()))},Z.prototype.deleteColumns=function(t,n,e){var i,r,o,a,u,u,s,c,f,u,l,u,h;if((e=_t(i=e=void 0===e?_.SheetArea.viewport:e))!==_.SheetArea.corner&&(o=G(r=this,e),!(t<0||o<=t||n<=0))&&r.Dj(t,i,a="deleteColumns",n,o)&&(0===r.Ut.P8&&r.parent&&r.parent.Wp.clear(),Z.et(r,F,u={changeType:"deletingColumns",col:t,colCount:n,canDelete:!0,sheetArea:e}),u.canDelete)){if(r.sL(!1,e),e===_.SheetArea.viewport&&r._j(0,this.getRowCount(),t,n),r.Ut.do("deleteColumns",t,n,O,e),0<=(u=r.Ab)){for(s=-1,c=z(r),f=u;c<=f;f--)if(r.getColumnVisible(f)&&0<r.nn(f)){s=f;break}u!==(s=-1===s?0:s)&&r.o9(s)}u=G(r),r.getActiveColumnIndex()>=u&&(l=r.getActiveRowIndex(),(h=r.getSpan(l,u=u-1))&&(l=h.row,u=h.col),r.setActiveCell(l,u)),r.Zw=!0,Z.et(r,F,{changeType:a,col:t,oldValue:o,colCount:n,sheetArea:e}),Z.et(r,F,{changeType:"deleteColumns2",col:t,oldValue:o,colCount:n,sheetArea:e}),e===_.SheetArea.viewport&&r.tables&&r.tables.cL(!1,t),r.vj(t,i,a,n,o),r.sL(!0,e),r.zw()}},Z.prototype.frozenColumnCount=function(t,n){var e=this;if(0===arguments.length)return e.fp;e.ame(t,n)},Z.prototype.ame=function(t,n,e){var i,r,o,i=this;0<=t&&(!D(n)&&"number"==typeof n||(n=0),r=i.yve,i.fp=t,0<n?(o=i.getColumnCount(),e||R(n,t)<o?i.yve=n<t-1?n:t-1:i.yve=o-1):i.yve=0,i.Ab<t?i.Ab=t:""!==t&&0!==t&&null!==t||(i.Ab=r||0),i.Zw=!0,i.zw())},Z.prototype.frozenRowCount=function(t,n){var e=this;if(0===arguments.length)return e.ap;e.ome(t,n)},Z.prototype.ome=function(t,n,e){var i,r,o,i=this;0<=t&&(!D(n)&&"number"==typeof n||(n=0),r=i.bve,i.ap=t,0<n?(o=i.getRowCount(),e||R(n,t)<o?i.bve=n<t-1?n:t-1:i.bve=o-1):i.bve=0,i.Tb<t?i.Tb=t:""!==t&&0!==t&&null!==t||(i.Tb=r||0),i.Ww=!0,i.zw())},Z.prototype.wve=function(t){void 0===t&&(t=0);var n,e=xt(this),i;return 0<e?e:t},Z.prototype.Mve=function(t){void 0===t&&(t=0);var n,e=Nt(this),i;return 0<e?e:t},Z.prototype.frozenTrailingRowCount=function(t,n){var e=this;return 0===arguments.length?e.fL:(0<=t&&(D(n)&&(n=!0),e.fL=t,e.Ny=n,e.Ww=!0,e.zw()),e)},Z.prototype.frozenTrailingColumnCount=function(t,n){var e=this;return 0===arguments.length?e.lL:(0<=t&&(D(n)&&(n=!0),e.lL=t,e.Vy=n,e.Zw=!0,e.zw()),e)},Z.prototype.getFrozenTrailingState=function(t){var n=this;return t?n.Ny:n.Vy},Z.prototype.getFrozenTopLeftIndex=function(t){var n=this;return t?n.bve:n.yve},Z.prototype.Gy=function(t){var n,e,n=It(this),e=t.hL;return n?e+t.Uy:e},Z.prototype.Sy=function(t){var n,e,n=At(this),e=t.A6;return n?e+t.Ty:e},Z.prototype.getRowCount=function(t){return 0===t?0:this.Ut.getRowCount(t)},Z.prototype.getColumnCount=function(t){return 0===t?0:this.Ut.getColumnCount(t)},Z.prototype.setRowCount=function(t,n,e){var i,e,e;D(n)&&(n=3),i=this,D(e)||(e=i.getUsedRange(e),D(e))||(t=Math.max(t,e.row+e.rowCount)),Z.et(i,F,e={changeType:"settingRowCount",rowCount:t,sheetArea:n,canSet:!0}),e.canSet&&i.setRowCountCore(t,n)},Z.prototype.setRowCountCore=function(t,n){var e,i;t=C(t,10),v(t)||(D(n)&&(n=3),i=(e=this).getRowCount(n),t<0)||t===i||(3===n||2===n?(e.Ut.do("setRowCount",t,n),Y(e)>t&&e.frozenRowCount(t)):1===n&&e.Ut.do("setRowCount",t,n),Z.et(e,F,{changeType:"setRowCount",row:i,rowCount:t,sheetArea:n}),e.Ww=!0,e.ui>=t&&(3===n||2===n)&&e.setActiveCell(t-1,e.getActiveColumnIndex()),e.zw(),e.clearPendingChanges())},Z.prototype.setColumnCount=function(t,n,e){var i,r,e;t=C(t,10),v(t)||(r=(i=this).getColumnCount(n),t<0)||t===r||(D(n)&&(n=3),D(e)||(e=i.getUsedRange(e),D(e))||(t=Math.max(t,e.col+e.colCount)),3===n||1===n?(i.Ut.do("setColumnCount",t,n),z(i)>t&&i.frozenColumnCount(t)):2===n&&i.Ut.do("setColumnCount",t,n),Z.et(i,F,{changeType:"setColumnCount",col:r,colCount:t,sheetArea:n}),i.Zw=!0,i.ci>=t&&(3===n||1===n)&&i.setActiveCell(i.getActiveRowIndex(),t-1),i.zw(),i.clearPendingChanges())},Z.prototype.getFreeAreaRowCount=function(t){var n;return this.Ut.getFreeAreaRowCount(t)},Z.prototype.getFreeAreaColumnCount=function(t){var n;return this.Ut.getFreeAreaColumnCount(t)},Z.prototype.setFreeAreaRowCount=function(t,n){var e;this.Ut.setFreeAreaRowCount(t,n)},Z.prototype.setFreeAreaColumnCount=function(t,n){var e;this.Ut.setFreeAreaColumnCount(t,n)},Z.prototype.w8=function(t){var n,e,i,r,o;if(!D(t)&&(n=t.rows,i=!1,this.filterRowsVisibleInfo)){if(r=this.filterRowsVisibleInfo.rowsVisibleInfo||{},n&&0<n.length)for(o=0;o<n.length;o++)(e=n[o])&&e.isFilter&&(e.visible=!0,delete e.isFilter,i=!(r[o]=!1));i&&(this.filterRowsVisibleInfo.rowsVisibleInfo=r,this.filterRowsVisibleInfo.empty=!1)}},Z.prototype.Oe=function(t,n,e,i){var r=this;return(p=p||o("SheetsCalc"))?r.dL(t,n,e,i):O},Z.prototype.t0=function(t,n,e){var i,r,r,o,e,r,e,i=this;if(3===e)return i.options.showFormulas?(r=i.getFormula(t,n,3,!0))?"="!==r[0]?"="+r:r:(r=i.Uw&&i.Uw(e))&&r.t8.getAnchorInfo(t,n)?"":void 0:i.options.showZeros||!(0===(e=i.getValue(t,n,3))||e instanceof Date&&e.getTime()===$)||(r=(r=i.getFormatter(t,n))||(e=i.getStyle(t,n))&&e._autoFormatter&&e._autoFormatter.formatCached)&&("="===r[0]||3<=r.split(";").length)?void 0:""},Z.prototype.getText=function(t,n,e){var i,r,o;return D(e)&&(e=3),r=(i=this).t0(t,n,e),D(r)?(o=i.getValue(t,n,e),i.vL(t,n,o,e,!0)):r},Z.prototype.setText=function(t,n,e,i){var r,o,a,a,u,s,c,r=this;D(i)&&(i=3),o=e,Z.et(r,"settingText",a={value:e}),a=e=a.value,u=r.getCellType(t,n,i),s=r.getFormatter&&r.getFormatter(t,n,i),u&&s&&!W(s)&&(a=u.parse(o,s,c={sheet:r,row:t,col:n,sheetArea:i}),a=D(a)?e:a),r.YI(t,n,a,i),r.zw()},Z.prototype.getValue=function(t,n,e,i){var r,o,a,u,s,a,c,i,i,r,r,i;return 0===e?E:(D(e)&&(e=3),o=(r=this).options,u=(a=r.Ut).getRowCount(e),s=a.getColumnCount(e),a=r.mL(a,t,n,e,i),1===e?D(a)&&((i=r.H3)&&i._dataSource&&(i=r.Ut.q_(!1,3,n),r=o.colHeaderAutoTextIndex,i)&&(0<=r&&t===r||-1===r&&t===u-1)&&(a=i.displayName||i.name),D(a))&&t===(c=(c=o.colHeaderAutoTextIndex)<0||u<=c?u-1:c)&&(2===(r=o.colHeaderAutoText)?a=I.util.Vf(n+1):1===r&&(a=n+1)):2===e&&D(a)&&n===(c=(c=o.rowHeaderAutoTextIndex)<0||s<=c?s-1:c)&&(2===(i=o.rowHeaderAutoText)?a=I.util.Vf(t+1):1===i&&(a=t+1)),a)},Z.prototype.setValue=function(t,n,e,i,r){this.YI(t,n,e,i,r),this.Cle()},Z.prototype.Ij=function(t,n,e,i){var r=this;!i&&k&&r.gL(t,n,e),r.Q1i&&r.Q1i(t,n,1,1,e)},Z.prototype.Tj=function(){var t=this.conditionalFormats;t&&t.dl()},Z.prototype.Lj=function(t,a,u){var n,s;t&&t.parent&&t.parent.sheets&&(n=t.parent.sheets,s=t._id,n.forEach(function(o){var t=o.cameraShapes;t&&0<t.length&&t.forEach(function(t){var n,e,i,r;if(t.cameraImageCache&&(e=(n=t.JVV).ytV.AnV)&&(o._id===s||e.sheet&&e.sheet._id===s))for(i=0;i<a.length;i++){if(r=e.cellRange,void 0!==a[i].row&&void 0===a[i].col&&2===u&&a[i].row>=r.row&&a[i].row<r.row+r.rowCount){t.cameraImageCache=null,n.ytV.rtV&&n.mtV();break}if(void 0===a[i].row&&void 0!==a[i].col&&1===u&&a[i].col>=r.col&&a[i].col<r.col+r.colCount){t