import { Component } from '@angular/core';
import * as GC from "@grapecity/spread-sheets";
import "@grapecity/spread-sheets-io";

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  hostStyle = {
    width: '800px',
    height: '600px'
  };
  sjsFile: any;
  spread: any;
 
  workbookInit(args: { spread: GC.Spread.Sheets.Workbook; }) {
    let spread: GC.Spread.Sheets.Workbook = args.spread;
    this.spread = spread;
    let sheet = spread.getActiveSheet();
    sheet.getCell(0, 0).text("My SpreadJS Angular Project").foreColor("blue");
  }

  saveToSJS() {
    this.spread.save((blob: Blob) => {
      this.sjsFile = blob;
    }, console.log);
  }

  loadSJS() {
    if (this.sjsFile) {
      this.spread.open(this.sjsFile, () => {
        console.log('loaded');
      }, console.log);
    }
  }
}