import '@mescius/spread-sheets-formula-panel';
import '@mescius/spread-sheets-pivot-addon';
import '@mescius/spread-sheets-designer-resources-en';
import * as GC from '@mescius/spread-sheets-designer';
import '@mescius/spread-sheets-collaboration-addon';
import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013white.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.light.min.css";

import { Client } from "@mescius/js-collaboration-client";
import * as OT from "@mescius/js-collaboration-ot-client";
import {IChangeSet, type} from '@mescius/spread-sheets-collaboration-client';
import ReactDOM from "react-dom/client";
import {Header} from './bind-syn-status';

OT.TypesManager.register(type);

const designer = new GC.Spread.Sheets.Designer.Designer("root");
const workbook = designer.getWorkbook() as any;
const conn = new Client().connect('room1');
const doc = new OT.SharedDoc<any, IChangeSet>(conn);
const config = GC.Spread.Sheets.Designer.DefaultConfig;
delete config.fileMenu;
designer.setConfig(config);
ReactDOM.createRoot(document.getElementById('header')!).render(
    <Header workbook={workbook} doc={doc} />
)