import express from 'express';
import http from 'http';
import { Server } from '@mescius/js-collaboration';
import * as OT from '@mescius/js-collaboration-ot';
import { type } from '@mescius/spread-sheets-collaboration';

import sqlite3 from 'sqlite3';
import { SqliteDb } from '@mescius/js-collaboration-ot-sqlite';

OT.TypesManager.register(type);

const app = express();
const httpServer = http.createServer(app);
const server = new Server({ httpServer });
const port = 8082;

app.use(express.static('public'));

const db = new sqlite3.Database("./docs.db");
const documentServices = new OT.DocumentServices({ db: new SqliteDb(db) });

server.useFeature(OT.documentFeature(documentServices));

httpServer.listen(port, () => {
    console.log(`Server listening on port ${port}`);
    console.log(`http://127.0.0.1:${port}/index.html`);
});
