const path = require('path');

module.exports = {
    mode: 'development', // 或 'production' | development
    entry: './src/client/index',
    module: {
        rules: [
            {
                test: /\.(ts|tsx|mts)$/,
                use: 'ts-loader',
                exclude: [
                    /node_modules/,
                ],
            },
            {
                test: /\.css$/,
                use: ['style-loader', 'css-loader'],
            },
            {
                test: /.(svg|png|jpg)$/,
                use: 'file-loader',
            }
        ],
    },
    resolve: {
        extensions: ['.tsx', '.ts', '.js'],
    },
    output: {
        filename: 'main.js',
        path: path.resolve(__dirname, 'public'),
    }
};