import React, {useEffect, useState} from "react";
import {HistoryOutlined, HomeOutlined, TeamOutlined} from "@ant-design/icons";
import {User} from "./user/user";
import {ICurrentUser, IUser, userReq} from "../request/user";
import {Avatar, Button, Divider, Input, Layout, Modal, Space} from "antd";
import {useNavigate} from "react-router-dom";
import {ReactElement} from "react";
import {Header} from "antd/es/layout/layout";
import {docReq, IDoc} from "../request/doc";
import {Role} from "../enum";
import {RoleSelect} from "./role-selector";
import {Share} from "./share";

export enum PageType {
    Home,
    Open,
    History,
}

export interface IUserEx extends IUser {
    color?: string
}

interface IHeaderProps {
    type: PageType,
    children?: ReactElement;
    doc?: IDoc;
    users?: IUserEx[];
}

function getFileName(type: PageType) {
    if (type === PageType.Home) {
        return 'Home';
    } else if (type === PageType.History) {
        return 'History';
    }
}

export const CustomHeader = (props: IHeaderProps) => {
    const {type, doc, users } = props;
    const navigate = useNavigate();
    const user = userReq.currentUser() as ICurrentUser;
    return (
        <Layout style={{ height: "100%", width: "100%" }}>
            <Header style={{background: '#f5f5f5', display: "flex", alignItems: "center", padding: "20px", marginRight: "20px"}}>
                <div style={{display: 'flex', alignItems: 'center', flexGrow: 1, marginRight: "26px"}}>
                    {type !== PageType.Home && (
                        <>
                            <HomeOutlined style={{fontSize: '24px'}} onClick={() => window.location.href = '/all-files'}/>
                            <div style={{width: '0', height: '48px', borderRight: 'rgba(5, 5, 5, 0.06) 2px solid', margin: '0 18px'}}/>
                        </>
                    )}
                    <img
                        src={"data:image/svg+xml,%3Csvg width='25' height='18' viewBox='0 0 25 18' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M19.4127 6.4904C18.6984 6.26581 18.3295 6.34153 17.5802 6.25965C16.4219 6.13331 15.9604 5.68062 15.7646 4.51554C15.6551 3.86516 15.7844 2.9129 15.5048 2.32334C14.9699 1.19921 13.7183 0.695046 12.461 0.982805C11.3994 1.22611 10.516 2.28708 10.4671 3.37612C10.4112 4.61957 11.1197 5.68054 12.3363 6.04667C12.9143 6.22097 13.5284 6.3087 14.132 6.35315C15.2391 6.43386 15.3241 7.04923 15.6236 7.55574C15.8124 7.87508 15.9954 8.18975 15.9954 9.14193C15.9954 10.0941 15.8112 10.4088 15.6236 10.7281C15.3241 11.2334 14.9547 11.5645 13.8477 11.6464C13.244 11.6908 12.6288 11.7786 12.0519 11.9528C10.8353 12.3201 10.1268 13.3799 10.1828 14.6234C10.2317 15.7124 11.115 16.7734 12.1766 17.0167C13.434 17.3056 14.6855 16.8003 15.2204 15.6762C15.5013 15.0866 15.6551 14.4187 15.7646 13.7683C15.9616 12.6032 16.423 12.1505 17.5802 12.0242C18.3295 11.9423 19.1049 12.0242 19.8071 11.6253C20.5491 11.0832 21.212 10.2696 21.212 9.14192C21.212 8.01428 20.4976 6.83197 19.4127 6.4904Z' fill='%23F44250'/%3E%3Cpath d='M7.59953 11.7459C6.12615 11.7459 4.92432 10.5547 4.92432 9.09441C4.92432 7.63407 6.12615 6.44287 7.59953 6.44287C9.0729 6.44287 10.2747 7.63407 10.2747 9.09441C10.2747 10.5536 9.07172 11.7459 7.59953 11.7459Z' fill='black'/%3E%3Cpath d='M2.64217 17.0965C1.18419 17.093 -0.0034949 15.8971 7.72743e-06 14.4356C0.00352588 12.9765 1.1994 11.7888 2.66089 11.7935C4.12004 11.797 5.30772 12.9929 5.30306 14.4544C5.29953 15.9123 4.10366 17.1 2.64217 17.0965Z' fill='black'/%3E%3Cpath d='M22.3677 17.0965C20.9051 17.1046 19.7046 15.9217 19.6963 14.4649C19.6882 13.0023 20.8712 11.8017 22.3279 11.7935C23.7906 11.7854 24.9911 12.9683 24.9993 14.4251C25.0075 15.8866 23.8245 17.0883 22.3677 17.0965Z' fill='black'/%3E%3C/svg%3E%0A"}/>
                    &nbsp;&nbsp;
                    { type === PageType.Open && doc ? <HeaderRename doc={doc} users={users!} /> : <h1>{getFileName(type)}</h1> }
                </div>
                <User username={user.username} onLogout={() => {
                    userReq.logOut();
                    navigate('/login');
                }}></User>
            </Header>
            <Divider style={{margin: 0}}/>
            <Layout style={{ width: "100%", padding: "10px 20px 0 20px" }}>
                {props.children}
            </Layout>
        </Layout>
    )
}


const HeaderRename = (props: { doc: IDoc, users: IUserEx[] }) => {
    const { doc, users = [] } = props;
    const [shareDocId, setShareDocId] = useState('');
    const [docName, setDocName] = useState(doc.name);
    const [role, setRole] = useState(Role.none);
    const navigate = useNavigate();
    // const refresh = (docId: string) => {
    //     docReq.get(docId).then(setDoc);
    // }

    const updateDocName = () => {
        const newName = docName;
        if (!newName || newName === doc.name) return;

        docReq.rename(doc.id, newName);

        // refresh(doc.id);
    };

    useEffect(() => {
        docReq.get(doc.id).then((v) => setRole(v.role as Role));
    }, [doc.id])

    return (
        <div style={{ display: 'flex', flexGrow: 1 }}>
            <div><Input type="text" disabled={role !== Role.owner} value={docName} onChange={(e) => setDocName(e.target.value)} onBlur={updateDocName} /></div>
            <div style={{ flexGrow: 1 }}></div>
            <div>
                <Space>
                    {users.map((u) => <Avatar key={u.id} alt={u.username} style={{ background: u.color ?? '#666666' }}>{u.username}</Avatar>)}

                    <RoleSelect disabled={true} value={role} />
                    <Button shape="round" title="History" icon={<HistoryOutlined />} onClick={() => navigate(`/history/${doc.id}`)}>History</Button>
                    <Button shape="round" title="Share" icon={<TeamOutlined />} onClick={() => setShareDocId(doc.id)}>Share</Button>
                </Space>
            </div>

            <Modal open={shareDocId !== ''} onCancel={() => { setShareDocId('') }} footer={null}>
                <Share docId={shareDocId}></Share>
            </Modal>
        </div>
    )

}