import { Select } from "antd";
import { Role } from "../enum";

interface IRoleSelectProps {
    value: Role;
    disabled?: boolean;
    onUpdate?: (role: Role) => void;
}

export const RoleSelect: React.FC<IRoleSelectProps> = (props) => {
    const disabled = props.disabled ?? props.value === Role.owner;

    return <Select disabled={disabled} value={props.value} options={[{ value: Role.editor }, { value: Role.viewer }]} onChange={props.onUpdate}></Select>
}