import { Avatar, Button, Popover } from "antd";
import React from "react";

interface IUserComponentProps {
    onLogout: () => void;
    username: string;
    style?: React.CSSProperties
}

export const User: React.FC<IUserComponentProps> = (props) => (
    <Popover style={{ position: 'relative', marginLeft: 'auto', right: '0px' }}
             content={
                 <Button onClick={props.onLogout}>Log out</Button>
             }
    >
        <Avatar style={{ background: '#065a85', cursor: 'pointer' }} size={"large"}><b color="white">{props.username}</b></Avatar>
    </Popover>
)