/* eslint-disable @typescript-eslint/no-explicit-any */
import Quill from 'quill';
import 'quill/dist/quill.snow.css';

import { useEffect, useRef } from 'react';

export default function QuillViewer(props: { data: any }) {
    const ref = useRef<HTMLDivElement>(null);
    const { data } = props;

    useEffect(() => {
        const div = ref.current as HTMLDivElement;
        const quill = new Quill(div, { theme: 'snow', readOnly: true });

        quill.setContents(data);

        return () => {
            div.previousSibling?.remove();
            div.innerHTML = '';
        }
    }, [data])

    return (
        <div ref={ref}></div>
    )
}
