/* eslint-disable @typescript-eslint/no-explicit-any */
import '@mescius/spread-sheets-formula-panel';
import "@mescius/spread-sheets-pivot-addon";
import "@mescius/spread-sheets-designer-resources-en";
import * as GC from "@mescius/spread-sheets-designer";
import "@mescius/spread-sheets-collaboration-addon";
import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013white.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.light.min.css";

import { useEffect, useRef } from "react";


export default function SpreadSheetsViewer(props: { data: any[] }) {
    const ref = useRef<HTMLDivElement>(null);
    const { data } = props;

    useEffect(() => {
        const div = ref.current as HTMLDivElement;
        const designer = new GC.Spread.Sheets.Designer.Designer(div);
        const config = GC.Spread.Sheets.Designer.DefaultConfig;
        delete config.fileMenu;
        designer.setConfig(config);
        const workbook = designer.getWorkbook() as any;

        workbook.collaboration.fromSnapshot(data);

        return () => {
            designer.destroy();
            workbook.destroy();
        };
    }, [data]);

    return (
        <div ref={ref} style={{height: "100%"}}></div>
    )
}