import React from 'react'
import ReactDOM from 'react-dom/client'

import {
    createBrowserRouter,
    RouterProvider,
} from "react-router-dom";

import './index.css'
import { loader } from './routes/root';
import ErrorPage from './error-page';
import Files from './routes/files';
import Open, { openLoader, openShareLinkLoader } from './routes/open';
import DocHistory, { loader as historyLoader } from './routes/history';
import Login from './routes/login';

const router = createBrowserRouter([
    {
        path: "/",
        loader,
        errorElement: <ErrorPage />,
        children: [
            { index: true, element: <Files /> },
            {
                path: "/all-files",
                element: <Files />,
            },
            {
                path: "/open/:docId",
                loader: openLoader,
                element: <Open />
            },
            {
                path: "/open-share-link/:link",
                loader: openShareLinkLoader,
                element: <Open />
            },
            {
                path: "/history/:docId",
                loader: historyLoader,
                element: <DocHistory />
            }
        ],
    },
    {
        path: "/login",
        element: <Login />
    }
]);

ReactDOM.createRoot(document.getElementById('root')!).render(
    <React.StrictMode>
        <RouterProvider router={router} />
    </React.StrictMode>,
)
